% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{class}
\name{mprior-class}
\alias{mprior-class}
\title{Class "mprior"}
\description{
An object pertaining to a BMA model prior
}
\section{Objects from the Class}{
 An \code{mprior} object holds descriptions
and subfunctions pertaining to model priors. The BMA functions
\code{\link{bms}} and post-processing functions rely on this class. \cr
There are currently five model prior structures built into the BMS package,
generated by the following functions (cf. the appendix of
\code{vignette(BMS)}): \cr \code{mprior.uniform.init}: creates a uniform
model prior object.\cr \code{mprior.fixedt.init}: creates the popular
binomial model prior object with common inclusion probabilities.\cr
\code{mprior.randomt.init}: creates a beta-binomial model prior object.\cr
\code{mprior.pip.init}: creates a binomial model prior object that allows
for defining individual prior inclusion probabilities.\cr
\code{mprior.customk.init}: creates a model prior object that allows for
defining a custom prior for each model parameter size.\cr The following
describes the necessary slots:
}

\seealso{
\code{\link{bms}} for creating \code{bma} objects. \cr Check the
appendix of \code{vignette(BMS)} for a more detailed description of built-in
priors.\cr Check \url{http://bms.zeugner.eu/custompriors.php} for examples.
}
\author{
Martin Feldkircher and Stefan Zeugner
}
\keyword{classes}
