% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bounds.sse.R
\name{bounds.sse}
\alias{bounds.sse}
\title{Obtain A SSE Object From An SSE Sequence Vector}
\usage{
bounds.sse(x, pdb = NULL)
}
\arguments{
\item{x}{a character vector indicating SSE for each amino acid residue.}

\item{pdb}{an object of class \code{pdb} as obtained from
function \code{\link{read.pdb}}. Can be ignored if \code{x} has 'names'
attribute for residue labels.}
}
\value{
a 'sse' object.
}
\description{
Inverse process of the funciton \code{\link{pdb2sse}}.
}
\details{
call for its effects.
}
\note{
In both \code{$helix} and \code{$sheet}, an additional 
   \code{$id} component is added to indicate the original numbering of the sse.
   This is particularly useful in e.g. \code{trim.pdb()} function.
}
\examples{
\donttest{
   # PDB server connection required - testing excluded
   try({

   pdb <- read.pdb("1a7l")
   sse <- pdb2sse(pdb)
   sse.ind <- bounds.sse(sse)
   sse.ind 

   }, silent=TRUE)
   if(inherits(.Last.value, "try-error")) {
      message("Need internet to run the example")
   }
} 
}
\author{
Xin-Qiu Yao & Barry Grant
}
\seealso{
\code{\link{pdb2sse}}
}

