## Mai 28, 2025

[Version 3.10](https://kitware.github.io/trame/guide/versions/features.html#version-3-10) of trame has been released. This version add a new tool for providing information on the rendering backend used by VTK. The tool documentation is available [here](https://trame.readthedocs.io/en/latest/tools.vtk.html), but in a nutshell, this is going to be very useful when debugging cloud deployment for remote rendering setup for either VTK or ParaView.

## Mai 9, 2025

Trame client is now 3.9 and brings all the [built-in components](https://vuejs.org/api/built-in-components.html#built-in-components) of vue.js.

## April 25, 2025

[Version 3.9](https://kitware.github.io/trame/guide/versions/features.html#version-3-9) of trame has been released. This version brings a new core module named trame-common into the mix. That module aims to provide generic classes that can be relevant across trame packages. This includes assets handling, execution helper (throttle, async task), decorators and abstract classes for building components or apps.

## April 24, 2025

Trame client is now 3.8 and brings support for event modifier from vue.js when using the v_on_xxx_yyy notation. 

## April 14, 2025

Trame vuetify has been updated to include [Andromeda 3.8](https://vuetifyjs.com/en/blog/announcing-vuetify-3.8/).

## February 4, 2025

[Version 3.8](https://kitware.github.io/trame/guide/versions/features.html#version-3-8) of trame has been released. This mainly fixes the `@TrameApp()` decorator so it can be used throw inheritance.

## October 29, 2024

With the release of __vtk__ 9.4, we have some really cool news for the __python__ community. 

![](https://www.kitware.com/main/wp-content/uploads/2024/10/Screenshot-2024-10-18-at-16.35.59.png)

Want to learn more on how to best leverage vtk with Python? 
Read our [blog on the new property and pipeline syntax](https://www.kitware.com/vtk-9-4-a-step-closer-to-the-ways-of-python/).

As always, [kitware can help](https://www.kitware.com/industry/support/) 

## October 20, 2024

We have a new widget that enable deep reactiveness on a state variable. This feature is only available with the vue3 client. An example of such usage is available [here](https://github.com/Kitware/trame-client/blob/master/examples/vue3/nested_reactive.py).

## October 16, 2024

Building Interactive Web Applications with trame
A simple paradigm for modern application development

Creating highly interactive or data intensive applications can be challenging in itself but if you want to venture to the web, things can become even more complicated. What if that was not true and you could leverage your existing team to create such applications? With trame, a single application can be deployed in the cloud, on HPC, run within Jupyter or bundled locally like any desktop application.

[Trame webinar with video recording available](https://www.kitware.com/webinars/from-desktop-to-ubiquitous-application-with-trame/)

## October 1, 2024

Modeling and simulation tools typically offer a comprehensive set of features to meet the needs of all potential users in a variety of domains. These tools are powerful, but come with a steep learning curve. Micro-workflows can be used to simplify the complex - creating a custom workflow packaged as a web application targeted at a specific need that is easy to learn, easy to use, and runs anywhere. Kitware Inc. can help you create micro-workflows that enable your domain experts to harness the power of your modeling and simulation tools without having to face a daunting learning curve. Find out more in our latest blog post on __trame__, then contact us to set up a meeting to talk about micro-workflows for your environment based on our open source platforms. 

[Full blog available here](https://www.kitware.com/trame-micro-workflow-use-case/)

## September 28, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:7243006448488587264" height="592" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## September 26, 2024

Want to learn how to create Web apps with __VTK__ and __ParaView__ in plain __Python__? I'll be teaching a course on September 26th. 

Come and join me to [learn more about trame](https://www.kitware.com/courses/trame/).

## September 21, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:7243017214008647680" height="760" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## September 20, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:7242292335647023105" height="655" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## September 18, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:7234614892945666050" height="676" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>


## September 5, 2024

__trame__ can do more than just interactive 3D visualization on the Web with __vtk__ and __paraview__. In fact it can also be used to create dashboards like __dash__ and __streamlit__ but with more capabilities.

![dasboard](https://www.kitware.com/main/wp-content/uploads/2024/08/image1.png)

Want to learn more? [Checkout our blog on dashboards with trame](https://www.kitware.com/trame-dashboard-use-case/). 

## September 3, 2024

Wondering how to leverage __trame__ with __paraview__? The 5.13 release make it strait forward. [This blog provides a quick introduction on how to get going](https://www.kitware.com/exposing-web-application-with-paraview-5-13-is-getting-simpler/).

![ParaView Trame Components](https://www.kitware.com/main/wp-content/uploads/2024/08/Screenshot-2024-08-14-at-15.39.48.png)

## August 29, 2024

We have our first blog out about __paraview__ and its new `--venv` option to extend the __python__ packages available.

Using Python Virtual environments in ParaView 5.13.0

[Full blog available here](https://www.kitware.com/using-python-virtual-environments-in-paraview-5-13-0/)

## August 21, 2024

Make Your Automotive Simulation Tools Available on the Web

We use websites to do everything, from communicating with friends and family and paying bills, to shopping for cars, and visiting the doctor. Even at work we rely heavily on the web because it provides a platform for wide-spread and easy access to applications. Web browsers are highly effective at delivering applications with excellent user experiences.

![](https://www.kitware.com/main/wp-content/uploads/2024/08/OnlineWindTunnel.jpg)

[Full blog available here](https://www.kitware.com/make-your-automotive-simulation-tools-available-on-the-web/)

## August 9, 2024

New blog on trame available [covering its Architecture and Capabilities](https://www.kitware.com/trame-architecture-and-capabilities/)

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7227731960389844992" height="505" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## August 5, 2024

__Trame usage keeps growing__

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7226592532988604417" height="470" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## July, 2024

__Enterprise deployment of CFD models with M-STAR__

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7225162200967979009" height="803" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## July 8-14, 2024

__Trame was present at SciPy__

Jaswant presented the new VTK/Python advancement (wrapping and WASM) and participated at the PyVista tutorial by teaching more usage of trame with VTK and PyVista. 

## June, 2025

Nice to see __trame__ being used by the community within __jupyter__ context to create 3D interactive solutions.

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7207780229610672129" height="677" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## May, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7189758268393545728" height="640" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## April 10, 2024

[Version 3.6](https://kitware.github.io/trame/guide/versions/features.html#version-3-6) of trame has been released. This version brings some big internal refactoring that replace the network layer to support message chunking via msgpack. This is key for enabling better support for trame within Jupyter thanks to the trame-jupyter-extension. 

## April, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7182113276732874752" height="461" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## March, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7168743724531769344" height="551" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## February, 2024

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:7159257484077977600" height="875" width="504" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## February, 2024

__Top Python Frontend Libraries for Data Science__ - HiRETOP

In the ever-evolving world of data science and machine learning, Python remains a dominant language, thanks in large part to its vast ecosystem of libraries. Among these, frontend libraries have become essential for professionals looking to translate complex data into accessible and interactive web applications. Here's an insightful exploration of the top Python frontend libraries, each offering unique capabilities to enhance your data science projects.

__Trame: Interactive and Visual Richness__

Trame is another notable mention for data scientists and engineers looking to build interactive web applications with rich visualizations, including 3D models and sophisticated simulations. Leveraging libraries like VTK and ParaView, Trame excels in scientific and engineering applications. Its approach to creating reactive, stateful applications is promising, although the relatively new framework means a smaller community and potential growing pains as it continues to develop.

[Full article](https://hiretop.com/blog2/top-python-frontend-libraries-for-data-science/)

## January 15th, 2024

__The Best Python Frontend Libraries For Data Science__ - Alessandro Fiori

Developing web and desktop applications requires knowledge of several programming languages. Defining user interfaces is a fundamental aspect of providing a good user experience (UX) and viewing information in an effective and appealing manner. For those involved in analysing data or collecting it, however, this aspect is critical. In fact, many developers specialise in one language and are reluctant to expand their knowledge to other languages or tasks that are not their core business. For this reason, in this article we present five libraries in python that can facilitate and speed up the development of user interfaces.

[Full article](https://flowygo.com/en/blog/the-best-python-frontend-libraries-for-data-science/)

## January 15th, 2024

__5 Exceptional Python Frameworks for Frontend Development__ - Ishaan Gupta

__#4 Trame__

If you find yourself tasked with creating a data-centric dashboard, Trame emerges as an excellent choice. This versatile tool empowers you to concentrate on your data analysis, effortlessly streamlining the intricacies of web development. Trame is ingeniously constructed upon Vuetify, a dynamic UI component framework rooted in Vue, ensuring a seamless and efficient dashboard creation experience.

[Full article](https://python.plainenglish.io/5-exceptional-python-frameworks-for-frontend-development-fcb7abb87462)


## January 5th, 2024

__2023 summary in kind words from the community:__
- I came across trame and is __simply MIND BLOWING__. What a fantastic job you did. [Link](https://github.com/Kitware/trame/discussions/395)
- I'm quite new on Trame but I have __been using Dash__ for a while to build some web applications. __I really like how easy you can create interactive 3D visualization with Trame__ and I wondered whether I should start using it, instead of Dash. [Link](https://github.com/Kitware/trame/discussions/130)
- I recently came across Trame and __the capabilities are really astounding__. It is a very nicely done framework for creating rich applications for 3D visualization, analysis, and interaction. [Link](https://github.com/Kitware/trame/discussions/399)
- Hi! First of all, thanks for this __amazing library, been having lots of fun rebuilding some old streamlit apps__ with it! [Link](https://github.com/Kitware/trame/discussions/249)

[LinkedIn post](https://www.linkedin.com/posts/sebastienjourdain_trame-trame-vtk-activity-7149110069140369408-KD8k?utm_source=share&utm_medium=member_desktop)
<!-- ![Image from a trame discussion forum](https://media.licdn.com/dms/image/D5622AQEZa_nuvTNASQ/feedshare-shrink_800/0/1704480663800?e=1707350400&v=beta&t=_H_fwEar7CUNEeS3_sEwrI8wl-f7tP1KrXlkj1Yy68E) -->

<!-- <iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7149110068158869504" height="917" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe> -->

## January 4th, 2024

Trame course on February 12th for __trame__

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:share:7148802264046911488" height="526" width="100%" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

Links to [Trame course](https://www.kitware.com/courses/trame/) | [Kitware trainings](https://www.kitware.com/training) | [LinkedIn](https://www.linkedin.com/posts/sebastienjourdain_trame-trame-vtk-activity-7148802264755806209-hCZX?utm_source=share&utm_medium=member_desktop)

## December 24th, 2023

__Top-5 Python Frontend Libraries for Data Science__ - Artem Shelamanov

__#3 Trame__ 

So, Trame is a go-to if you want to create some science-focused apps with interactive, complex visualizations and simulations (Even in 3D!). It’s multi-platform, it provides many useful features, and overall it looks aesthetically pleasing.


[Full Medium Post](https://python.plainenglish.io/top-5-python-frontend-libraries-for-data-science-91261a65e366)

## November 1st, 2023


__Trame: Frontend With Vue.js, but in Python__

You may have heard about Vue.js — a javascript library for quick one-page websites and UIs, a performant library with easy development. But what you may not have heard of is Trame — a library for Vue.js, but in Python!

[Full Medium blog post](https://medium.com/@ash_computational_qm/trame-frontend-with-vue-js-but-in-python-329111755b98)

## October 10, 2023

This is what happens when you let an engineer play for the first time with **VTK** and **trame**.

[![Finite Element Method](/assets/images/news/fem.gif)](https://www.linkedin.com/posts/sebastienjourdain_vtk-trame-kitware-activity-7117551438863466496-Zaxp?utm_source=share&utm_medium=member_desktop)


## October 4, 2023

Wow, I'm so impressed by __trame__'s impact.

We are at 30K downloads a month... If you are enjoying it, don't forget to add a star.


[![30K downloads per month](/assets/images/news/30k-download.png)](https://www.linkedin.com/posts/sebastienjourdain_trame-activity-7115357496873013248-cxBf?utm_source=share&utm_medium=member_desktop)


## October 2, 2023

I always love seeing how **trame** gets used in the wild. This led me to add a community page to showcase your application.
https://kitware.github.io/trame/examples/apps/community.html

So far, we have **SpinView**, a general interactive visual analysis tool developed for multiscale computational magnetism, which Qichen Xu developed at the KTH Royal Institute of Technology in Sweden.

[![SpinView](/assets/images/news/spinview.png)](https://www.linkedin.com/feed/update/urn:li:activity:7114654111735697408?utm_source=share&utm_medium=member_desktop)

## September 22, 2023

__13 Python Frameworks for Frontend Development: JavaScript Alternatives__ - Adejumo Ridwan Suleiman

If you are in a situation to create a dashboard, heavily based on data. I will suggest Trame as a goto option, it allows you to focus on your analysis while abstracting the complications of web development. Trame is built on Vuetify, which is a UI component framework built on Vue.

[Full article](https://python.plainenglish.io/8-python-frameworks-for-frontend-development-javascript-alternatives-2370e0cf6ae9)

## September 4, 2023

Kitware is delighted to announce that a trame tutorial will be given during the Siggraph Web3d conference in October of this year in San Sebastian, Spain.

We will present all our solutions for web scientific visualization and give a full hands-on tutorial about trame, i.e. how to bring your scientific data visualization onto the web, all through Python (no Javascript).

More about the Web3D conference that will happen in October 9-11 2023. (https://web3d.siggraph.org/)

[![Web3D trame tutorial](/assets/images/news/web3d.jpg)](https://www.linkedin.com/posts/kitware-sas_kitware-is-delighted-to-announce-that-activity-7105180875310395393-5G5y?utm_source=share&utm_medium=member_desktop)


## September 2, 2023

While documentation is an ongoing process. I'm excited of the new trame website which includes a lot of examples and references to get started with trame.

[![Trame website](/assets/images/news/trame-website.jpg)](https://www.linkedin.com/posts/sebastienjourdain_trame-activity-7110432344230002688-NooO?utm_source=share&utm_medium=member_desktop)

## August 2023

<iframe src="https://www.linkedin.com/embed/feed/update/urn:li:ugcPost:7093253518769201153" height="997" width="504" frameborder="0" allowfullscreen="" title="Embedded post"></iframe>

## April 2023

__Webifying UncertainSCI Using Trame__ - Jess Tate

Web deployment of research tools has become increasingly important as the commercially available computing platforms become more diverse. However, the web deployment of Python packages and applications, especially with a GUI, has traditionally required significant training in javascript or a similar web language. Trame is a Python JavaScript integration framework that simplifies the GUI development and web deployment for Python apps. We used trame to deploy UncertainSCI, our Python package for uncertainty quantification (UQ), on web browser and cloud services.

UncertainSCI non-invasively computes forward model uncertainty propagated from input variability. It uses weighted approximate Fekete points (WAFP) to parsimoniously sample input parameter space, and polynomial chaos emulators (PCE) to accurately estimate model variation of complex computer simulations. UncertainSCI has been developed for use in 3D bioelectric field simulation to work with 3D biophysical models, balancing accurate multivariate analysis with computation cost.

The process of deploying UncertainSCI on the web was greatly facilitated by trame. Because trame interfaces with JavaScript packages such as vue.js, and vtk.js, we were able to implement a tailored interactive web-based GUI with Python code. Building and running a web app has been made simple through trame’s docker support, making deploying on webservice providers like AWS steamlined for low traffic use cases.

In this presentation, we will describe UncertainSCI, how we used trame to build web apps and web services, and how users can use UncertainSCI to perform UQ on their modeling pipelines.

![Application UI](/assets/images/news/uncertainty.png)

[Poster list](https://us.pycon.org/2023/schedule/posters/list/)

## December 5, 2022

**Interactive Web-based 3D Visualization of large scientific datasets using Azure Batch**

![Microsoft Azure](/assets/logos/azure.svg)

Scientific computing has long relied on high-performance computing (HPC) systems to accelerate scientific discovery. What constitutes an HPC system has continued to evolve. Access to computing keeps getting democratized and HPC is no longer limited to multi-billion dollar government laboratories and industries who can afford the infrastructure. Anyone with access to the Internet can now easily leverage the ubiquitous cloud for their computing task du jour! Azure natively supports HPC by providing hardware suitable for high performance computing needs together with software infrastructure to make it easy to harness these resources. In this post, we focus on one such Azure infrastructure component, Azure Batch, and see how it can be used to support a common use-case: data browser with interactive 3D visualization support.

[Microsoft Azure High Performance Computing Blog](https://techcommunity.microsoft.com/t5/azure-high-performance-computing/interactive-web-based-3d-visualization-of-large-scientific/ba-p/3686390)