# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._serialization import Serializer
from .._vendor import StorageCacheManagementClientMixinABC, _convert_request, _format_url_section

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_check_aml_fs_subnets_request(subscription_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/checkAmlFSSubnets"
    )
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_get_required_aml_fs_subnets_size_request(subscription_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2023-05-01"))
    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = kwargs.pop(
        "template_url", "/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/getRequiredAmlFSSubnetsSize"
    )  # pylint: disable=line-too-long
    path_format_arguments = {
        "subscriptionId": _SERIALIZER.url("subscription_id", subscription_id, "str", min_length=1),
    }

    _url: str = _format_url_section(_url, **path_format_arguments)  # type: ignore

    # Construct parameters
    _params["api-version"] = _SERIALIZER.query("api_version", api_version, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


class StorageCacheManagementClientOperationsMixin(StorageCacheManagementClientMixinABC):
    @overload
    def check_aml_fs_subnets(  # pylint: disable=inconsistent-return-statements
        self,
        aml_filesystem_subnet_info: Optional[_models.AmlFilesystemSubnetInfo] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Check that subnets will be valid for AML file system create calls.

        :param aml_filesystem_subnet_info: Information about the subnets to validate. Default value is
         None.
        :type aml_filesystem_subnet_info: ~azure.mgmt.storagecache.models.AmlFilesystemSubnetInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def check_aml_fs_subnets(  # pylint: disable=inconsistent-return-statements
        self, aml_filesystem_subnet_info: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Check that subnets will be valid for AML file system create calls.

        :param aml_filesystem_subnet_info: Information about the subnets to validate. Default value is
         None.
        :type aml_filesystem_subnet_info: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def check_aml_fs_subnets(  # pylint: disable=inconsistent-return-statements
        self, aml_filesystem_subnet_info: Optional[Union[_models.AmlFilesystemSubnetInfo, IO]] = None, **kwargs: Any
    ) -> None:
        """Check that subnets will be valid for AML file system create calls.

        :param aml_filesystem_subnet_info: Information about the subnets to validate. Is either a
         AmlFilesystemSubnetInfo type or a IO type. Default value is None.
        :type aml_filesystem_subnet_info: ~azure.mgmt.storagecache.models.AmlFilesystemSubnetInfo or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            400: lambda response: HttpResponseError(
                response=response,
                model=self._deserialize(_models.AmlFilesystemCheckSubnetError, response),
                error_format=ARMErrorFormat,
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(aml_filesystem_subnet_info, (IOBase, bytes)):
            _content = aml_filesystem_subnet_info
        else:
            if aml_filesystem_subnet_info is not None:
                _json = self._serialize.body(aml_filesystem_subnet_info, "AmlFilesystemSubnetInfo")
            else:
                _json = None

        request = build_check_aml_fs_subnets_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.check_aml_fs_subnets.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    check_aml_fs_subnets.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/checkAmlFSSubnets"
    }

    @overload
    def get_required_aml_fs_subnets_size(
        self,
        required_aml_filesystem_subnets_size_info: Optional[_models.RequiredAmlFilesystemSubnetsSizeInfo] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RequiredAmlFilesystemSubnetsSize:
        """Get the number of available IP addresses needed for the AML file system information provided.

        :param required_aml_filesystem_subnets_size_info: Information to determine the number of
         available IPs a subnet will need to host the AML file system. Default value is None.
        :type required_aml_filesystem_subnets_size_info:
         ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSizeInfo
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequiredAmlFilesystemSubnetsSize or the result of cls(response)
        :rtype: ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSize
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    def get_required_aml_fs_subnets_size(
        self,
        required_aml_filesystem_subnets_size_info: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.RequiredAmlFilesystemSubnetsSize:
        """Get the number of available IP addresses needed for the AML file system information provided.

        :param required_aml_filesystem_subnets_size_info: Information to determine the number of
         available IPs a subnet will need to host the AML file system. Default value is None.
        :type required_aml_filesystem_subnets_size_info: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequiredAmlFilesystemSubnetsSize or the result of cls(response)
        :rtype: ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSize
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace
    def get_required_aml_fs_subnets_size(
        self,
        required_aml_filesystem_subnets_size_info: Optional[
            Union[_models.RequiredAmlFilesystemSubnetsSizeInfo, IO]
        ] = None,
        **kwargs: Any
    ) -> _models.RequiredAmlFilesystemSubnetsSize:
        """Get the number of available IP addresses needed for the AML file system information provided.

        :param required_aml_filesystem_subnets_size_info: Information to determine the number of
         available IPs a subnet will need to host the AML file system. Is either a
         RequiredAmlFilesystemSubnetsSizeInfo type or a IO type. Default value is None.
        :type required_aml_filesystem_subnets_size_info:
         ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSizeInfo or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: RequiredAmlFilesystemSubnetsSize or the result of cls(response)
        :rtype: ~azure.mgmt.storagecache.models.RequiredAmlFilesystemSubnetsSize
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RequiredAmlFilesystemSubnetsSize] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(required_aml_filesystem_subnets_size_info, (IOBase, bytes)):
            _content = required_aml_filesystem_subnets_size_info
        else:
            if required_aml_filesystem_subnets_size_info is not None:
                _json = self._serialize.body(
                    required_aml_filesystem_subnets_size_info, "RequiredAmlFilesystemSubnetsSizeInfo"
                )
            else:
                _json = None

        request = build_get_required_aml_fs_subnets_size_request(
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.get_required_aml_fs_subnets_size.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("RequiredAmlFilesystemSubnetsSize", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_required_aml_fs_subnets_size.metadata = {
        "url": "/subscriptions/{subscriptionId}/providers/Microsoft.StorageCache/getRequiredAmlFSSubnetsSize"
    }
