# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AddressFamily(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """IP address family. Example: ipv4 | ipv6."""

    IPV4 = "ipv4"
    IPV6 = "ipv6"


class AdministrativeState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Administrative state."""

    ENABLE = "Enable"
    DISABLE = "Disable"


class AllowASOverride(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enable Or Disable state."""

    ENABLE = "Enable"
    DISABLE = "Disable"


class BooleanEnumProperty(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Boolean Enum. Example- True/False."""

    TRUE = "True"
    FALSE = "False"


class CommunityActionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """community action types. Example: Permit | Deny."""

    PERMIT = "Permit"
    DENY = "Deny"


class Condition(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specify prefix-list bounds."""

    EQUAL_TO = "EqualTo"
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"
    LESSER_THAN_OR_EQUAL_TO = "LesserThanOrEqualTo"


class ConditionActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """action. Example: allow | deny."""

    ALLOW = "allow"
    DENY = "deny"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class EnabledDisabledState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """EnabledDisabledState state for the resource."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class ExpressRouteConnectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Express route connection state for the resource."""

    CONNECTING = "Connecting"
    CONNECTED = "Connected"
    DISCONNECTED = "Disconnected"


class FailedSucceededState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """FailedSucceeded state for the resource."""

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class InterfaceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Interface Type. Example: Management/Data."""

    MANAGEMENT = "Management"
    DATA = "Data"


class IsCurrentVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If the current version is in use."""

    TRUE = "true"
    FALSE = "false"


class IsTestVersion(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """If the current version is a test version."""

    TRUE = "true"
    FALSE = "false"


class NetworkDeviceRackRoleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Role for the network device."""

    CE = "CE"
    TO_R = "ToR"
    NPB = "NPB"
    TS = "TS"
    MANAGEMENT = "Management"


class NetworkDeviceRoleName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available roles for the network device."""

    CE = "CE"
    TO_R = "ToR"
    NPB = "NPB"
    TS = "TS"
    MANAGEMENT = "Management"


class NetworkDeviceRoleTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available roles for the network device."""

    CE = "CE"
    TO_R = "ToR"
    NPB = "NPB"
    TS = "TS"
    MANAGEMENT = "Management"


class NetworkFabricControllerOperationalState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operational state for the resource."""

    CONFIGURING = "Configuring"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class NetworkFabricOperationalState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operational state for the resource."""

    PROVISIONING = "Provisioning"
    PROVISIONED = "Provisioned"
    ERROR_PROVISIONING = "ErrorProvisioning"
    DEPROVISIONING = "Deprovisioning"
    DEPROVISIONED = "Deprovisioned"
    ERROR_DEPROVISIONING = "ErrorDeprovisioning"
    DEFERRED_CONTROL = "DeferredControl"


class NetworkRackRoleName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The role of the Network Rack: Aggregate or Compute."""

    COMPUTE_RACK = "ComputeRack"
    AGGREGATE_RACK = "AggregateRack"


class NniType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of NNI used. Example: CE | NPB."""

    CE = "CE"
    NPB = "NPB"


class OperationalState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operational state for the resource."""

    CONFIGURING = "Configuring"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"


class OperationalStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary or Secondary power end."""

    BOOTED = "Booted"
    BOOT_PROMPT = "BootPrompt"
    ZTP = "Ztp"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class PeeringOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Peering option list."""

    OPTION_A = "OptionA"
    OPTION_B = "OptionB"


class PowerCycleState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """On or Off power cycle state."""

    ON = "On"
    OFF = "Off"


class PowerEnd(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Primary or Secondary power end."""

    PRIMARY = "Primary"
    SECONDARY = "Secondary"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    UPDATING = "Updating"
    CANCELED = "Canceled"
    DELETING = "Deleting"
    FAILED = "Failed"


class ReachabilityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Generic network reachability state."""

    REACHABLE = "Reachable"
    UNREACHABLE = "Unreachable"


class RedistributeConnectedSubnets(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Advertise Connected Subnets. Ex: "True" | "False"."""

    TRUE = "True"
    FALSE = "False"


class RedistributeStaticRoutes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Advertise Static Routes. Ex: "True" | "False"."""

    TRUE = "True"
    FALSE = "False"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """On or Off toggle state."""

    ON = "On"
    OFF = "Off"


class TerminalServerConnectivityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """TerminalServerConnectivity state for the resource."""

    IPV4_REACHABLE = "Ipv4Reachable"
    IPV4_UNREACHABLE = "Ipv4Unreachable"


class WellKnownCommunities(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """``Internet`` - Advertise routes to internet community.
     ``LocalAS`` - Advertise routes to only localAS peers.
     ``NoAdvertise`` - Don't advertise routes to any peer.
    ``NoExport`` - Don't export to next AS.
    ``GShut`` - Graceful Shutdown (GSHUT) withdraw routes before terminating BGP connection.
    """

    INTERNET = "Internet"
    LOCAL_AS = "LocalAS"
    NO_ADVERTISE = "NoAdvertise"
    NO_EXPORT = "NoExport"
    G_SHUT = "GShut"
