# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccessPolicyRole(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """A role defining the data plane operations that a principal can perform on a Time Series
    Insights client.
    """

    READER = "Reader"
    CONTRIBUTOR = "Contributor"

class DataStringComparisonBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The reference data set key comparison behavior can be set using this property. By default, the
    value is 'Ordinal' - which means case sensitive key comparison will be performed while joining
    reference data with events or while adding new reference data. When 'OrdinalIgnoreCase' is set,
    case insensitive comparison will be used.
    """

    ORDINAL = "Ordinal"
    ORDINAL_IGNORE_CASE = "OrdinalIgnoreCase"

class EnvironmentKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the environment.
    """

    GEN1 = "Gen1"
    GEN2 = "Gen2"

class EnvironmentResourceKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the environment.
    """

    GEN1 = "Gen1"
    GEN2 = "Gen2"

class EventSourceKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the event source.
    """

    MICROSOFT_EVENT_HUB = "Microsoft.EventHub"
    MICROSOFT_IO_T_HUB = "Microsoft.IoTHub"

class EventSourceResourceKind(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The kind of the event source.
    """

    MICROSOFT_EVENT_HUB = "Microsoft.EventHub"
    MICROSOFT_IO_T_HUB = "Microsoft.IoTHub"

class IngressState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """This string represents the state of ingress operations on an environment. It can be "Disabled",
    "Ready", "Running", "Paused" or "Unknown"
    """

    DISABLED = "Disabled"
    READY = "Ready"
    RUNNING = "Running"
    PAUSED = "Paused"
    UNKNOWN = "Unknown"

class LocalTimestampFormat(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """An enum that represents the format of the local timestamp property that needs to be set.
    """

    EMBEDDED = "Embedded"

class PropertyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the property.
    """

    STRING = "String"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the resource.
    """

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    DELETING = "Deleting"

class ReferenceDataKeyPropertyType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the key property.
    """

    STRING = "String"
    DOUBLE = "Double"
    BOOL = "Bool"
    DATE_TIME = "DateTime"

class SkuName(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of this SKU.
    """

    S1 = "S1"
    S2 = "S2"
    P1 = "P1"
    L1 = "L1"

class StorageLimitExceededBehavior(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The behavior the Time Series Insights service should take when the environment's capacity has
    been exceeded. If "PauseIngress" is specified, new events will not be read from the event
    source. If "PurgeOldData" is specified, new events will continue to be read and old events will
    be deleted from the environment. The default behavior is PurgeOldData.
    """

    PURGE_OLD_DATA = "PurgeOldData"
    PAUSE_INGRESS = "PauseIngress"

class WarmStoragePropertiesState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """This string represents the state of warm storage properties usage. It can be "Ok", "Error",
    "Unknown".
    """

    OK = "Ok"
    ERROR = "Error"
    UNKNOWN = "Unknown"
