# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .multiple_pipeline_trigger import MultiplePipelineTrigger


class BlobTrigger(MultiplePipelineTrigger):
    """Trigger that runs every time the selected Blob container changes.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param description: Trigger description.
    :type description: str
    :ivar runtime_state: Indicates if trigger is running or not. Updated when
     Start/Stop APIs are called on the Trigger. Possible values include:
     'Started', 'Stopped', 'Disabled'
    :vartype runtime_state: str or
     ~azure.mgmt.datafactory.models.TriggerRuntimeState
    :param annotations: List of tags that can be used for describing the
     trigger.
    :type annotations: list[object]
    :param type: Required. Constant filled by server.
    :type type: str
    :param pipelines: Pipelines that need to be started.
    :type pipelines:
     list[~azure.mgmt.datafactory.models.TriggerPipelineReference]
    :param folder_path: Required. The path of the container/folder that will
     trigger the pipeline.
    :type folder_path: str
    :param max_concurrency: Required. The max number of parallel files to
     handle when it is triggered.
    :type max_concurrency: int
    :param linked_service: Required. The Azure Storage linked service
     reference.
    :type linked_service:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    """

    _validation = {
        'runtime_state': {'readonly': True},
        'type': {'required': True},
        'folder_path': {'required': True},
        'max_concurrency': {'required': True},
        'linked_service': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'description': {'key': 'description', 'type': 'str'},
        'runtime_state': {'key': 'runtimeState', 'type': 'str'},
        'annotations': {'key': 'annotations', 'type': '[object]'},
        'type': {'key': 'type', 'type': 'str'},
        'pipelines': {'key': 'pipelines', 'type': '[TriggerPipelineReference]'},
        'folder_path': {'key': 'typeProperties.folderPath', 'type': 'str'},
        'max_concurrency': {'key': 'typeProperties.maxConcurrency', 'type': 'int'},
        'linked_service': {'key': 'typeProperties.linkedService', 'type': 'LinkedServiceReference'},
    }

    def __init__(self, **kwargs):
        super(BlobTrigger, self).__init__(**kwargs)
        self.folder_path = kwargs.get('folder_path', None)
        self.max_concurrency = kwargs.get('max_concurrency', None)
        self.linked_service = kwargs.get('linked_service', None)
        self.type = 'BlobTrigger'
