#!/usr/bin/env python

# -*- coding: utf8 -*- 

#***********************************************************************
# pysycache : a program for learn to use the mouse
# Copyright (C) 2005-2007 Vincent DEROO (vincent.pysycache@free.fr) 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software 
# Foundation, Inc. : 
# 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
#***********************************************************************



#*******************************************************************************
# Importation des modules
#*******************************************************************************
import sys
import getopt, string
import random
import time
import locale


import random
import os.path
import pygame
from pygame.locals import *
#from pysyclasses import *


import datas
from pysyclasses import *
import const
import pysyihm

#from pysyclasses import MouseOfActivity
#from pysyclasses import BestScores
#from pysyclasses import BtnOfMenu




#*******************************************************************************
# Event detection                                                              #
#*******************************************************************************
def DetectEvent():
	""" Traitement des evenements """
	for event in pygame.event.get():
		if event.type == QUIT:
			return 0
		elif event.type == KEYUP:
			if event.key == K_ESCAPE:
				return 0
		elif event.type == pygame.MOUSEMOTION:
			#*************** evenement deplacement de la souris ***************
			event0 = event.pos[0] 
			event1 = event.pos[1] 
			screen = pygame.display.get_surface()

			#redessin de la souris a sa position actuelle
			const.GMaSourisCurrentPositionX = event0 
			const.GMaSourisCurrentPositionY = event1 
			for o in const.GLstSouris.sprites():
				o.move(const.Gbackground_image)

			const.GLstSouris.draw(screen)

			pygame.display.update()
			
			return 1
		elif event.type == MOUSEBUTTONUP:
			#---------------------- on relache la souris -----------------------
			ok = 0
			event0 = event.pos[0] 
			event1 = event.pos[1] 

			screen = pygame.display.get_surface()  

			#------------------------ boutons de menus -------------------------
			for btn in TabBtnScores :
				if ( event0 >= btn.left ) & ( event0 <= btn.left + btn.largeur ) & ( event1 >= btn.top  ) & ( event1 <= btn.top + btn.hauteur ) :
					if ( btn.id == 4) :
						#Quitter
						return 0
					elif ( btn.id == 11) :
						#scores de l'activite move
						myscore= BestScores("themes-move")
						myscore.ShowScores("ACT1", "Move activity")
					elif ( btn.id == 12) :
						#scores de l'activite click
						myscore= BestScores("themes-click")
						myscore.ShowScores("ACT2", "Click activity")
					elif ( btn.id == 13) :
						#scores de l'activite button
						myscore= BestScores("themes-buttons")
						myscore.ShowScores("ACT3", "Buttons activity")
					elif ( btn.id == 14) :
						#scores de l'activite button
						myscore= BestScores("themes-dblclick")
						myscore.ShowScores("ACT4", "Double click activity")
					elif ( btn.id == 16) :
						#scores de l'activite puzzle
						myscore= BestScores("themes-puzzle")
						myscore.ShowScores("ACT6", "Drag and drop activity")

#					datas.ShowBtnMenus(TabBtnScores, Background_Restore)
					for btn in TabBtnScores:
						if (btn.visible == 1) : 
							btn.LoadNormalPicture(Background_Restore)
				#			imgtmp, rectmp = Load_image("images", btn.imagenametp, None, not btn.isrelatif)
				#			(btn.largeur, btn.hauteur) = imgtmp.get_size()
				#			btn.survol = 0
				#			btn.debutsurvol = 0
				#			btn.actif = 0
				#			bkgimage.blit(imgtmp, (btn.left, btn.top))
				#			screen.blit(imgtmp, (btn.left, btn.top))
						else:
							btn.ClearBackground(Background_Restore)
					
					
					break

			#rafraichissement
			const.GLstSouris.draw(screen)
			pygame.display.update()


	return 1





#*******************************************************************************
# Main of the program                                                          #
# parameters    typfull = 0 : in window                                        #
#                       = 1 : fullscreen                                       #
#*******************************************************************************
def ShowWindow(withname, numgame, durationgame, tabscore):
	global TabBtnScores 			#tableau des boutons de l'application
	TabBtnScores = []
	TabBtnScores[:]= []
	global Background_Restore


	screen = pygame.display.get_surface()

	datas.ShowTransitionOfTheme(const.GDureeTransition, "fond-scores.png", 1)

	#----------------------- transition vers le menu ---------------------------
	const.Gbackground_image, background_rect = datas.Load_image("images", "fond-scores.png")
	Background_Restore, background_rect = datas.Load_image("images", "fond-scores.png")

	#titre
	datas.WriteTextInLang("SCOBEST3", "Higher scores", const.Gbackground_image, -1, 10, 40)

	if withname == 1:
		#on demande le nom du gagnant
		datas.WriteTextInLang("SCOBEST0", "Congratulation !", const.Gbackground_image, 300, 101, 30)
		datas.WriteTextInLang("SCOBEST1", "You have made a", const.Gbackground_image, 300, 141, 30)
		datas.WriteTextInLang("SCOBEST2", "very good score", const.Gbackground_image, 300, 181, 30)
	screen.blit(const.Gbackground_image, (0, 0))

	if withname == 1:
		#on demande le nom du gagnant
		title =  datas.GetTextInLang("WIN0", "Winner name")
		valutf, tmp, returnvalue = pysyihm.ShowInputBox(title, "", 40, 0, 280, 300)
		if returnvalue == 1:
			#on enregistre le nom
			winername = valutf
			if const.GModeJeu == const.MODENORMAL:
				tabscore.InsertNewScoreNormal(winername, durationgame)
			if const.GModeJeu == const.MODEFANTOM :
				tabscore.InsertNewScoreFantom(winername, durationgame)
			tabscore.Save()

	if numgame == "move":
		tabscore.ShowScores("ACT1", "Move activity")
	elif numgame == "click":
		tabscore.ShowScores("ACT2", "Click activity")
	elif numgame == "buttons":
		tabscore.ShowScores("ACT3", "Buttons activity")
	elif numgame == "dblclick":
		tabscore.ShowScores("ACT4", "Double click activity")
	elif numgame == "puzzle":
		tabscore.ShowScores("ACT6", "Drag and drop activity")
	


	#----------------------- transition vers le menu -----------------------
	screen.blit(const.Gbackground_image, (0, 0))
#	const.Gbackground_image, background_rect = datas.Load_image("images", "fond-scores.png")

	#----------------------------- liste des boutons ---------------------------
	const.GBtnMenu = 999
	TabBtnScores[:]=[]
	TabBtnScores.append(BtnOfMenu("fond-scores.png", 4, 'btn-quitter-gd.png', 'btn-quitter.png', 710 - 20, 545) )	#quitter
	TabBtnScores.append(BtnOfMenu( "fond-scores.png", 11, 'score-move.png', 'score-move.png', 735, 10) )
	TabBtnScores.append(BtnOfMenu("fond-scores.png", 12, 'score-click.png', 'score-click.png', 735, 97) )
	TabBtnScores.append(BtnOfMenu("fond-scores.png", 13, 'score-button.png', 'score-button.png', 735, 184) )
	TabBtnScores.append(BtnOfMenu("fond-scores.png", 14, 'score-dblclick.png', 'score-dblclick.png', 735, 271) )
	TabBtnScores.append(BtnOfMenu("fond-scores.png", 16, 'score-puzzle.png', 'score-puzzle.png', 735, 358) )
#	datas.AddBtnOfApplication(TabBtnAdminPysy, "fond-scores.png", 13, 'open.png', 'open.png', 601, 436) 						

#	datas.ShowBtnMenus(TabBtnScores, Background_Restore)
	for btn in TabBtnScores:
		if (btn.visible == 1) : 
			btn.LoadNormalPicture(Background_Restore)
#			imgtmp, rectmp = Load_image("images", btn.imagenametp, None, not btn.isrelatif)
#			(btn.largeur, btn.hauteur) = imgtmp.get_size()
#			btn.survol = 0
#			btn.debutsurvol = 0
#			btn.actif = 0
#			bkgimage.blit(imgtmp, (btn.left, btn.top))
#			screen.blit(imgtmp, (btn.left, btn.top))
		else:
			btn.ClearBackground(Background_Restore)

	screen.blit(const.Gbackground_image, (0, 0))



	#------------------- changer la souris en main -------------------------
#	pygame.event.clear()
	const.GLstSouris.empty()
	const.GLstSouris.add(MouseOfActivity(400, 300, "souris.png") )
	for o in const.GLstSouris.sprites():
		o.move(const.Gbackground_image)
	const.GLstSouris.draw(screen)
	pygame.display.update()
	pygame.event.clear()

	const.GTypeSouris = const.EVENT_JEU0



	#---------------------- entree dans la boucle principale -------------------
	running = 1
	while running:
		datas.Temporisation()

		#----------------- recherche des evt -----------------------------------
		running = DetectEvent()

		datas.ShowFPS()
