/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableRemapper;
import proguard.classfile.util.SimplifiedVisitor;

public class VariableEditor
extends SimplifiedVisitor
implements AttributeVisitor {
    private boolean modified;
    private boolean[] deleted = new boolean[64];
    private int[] variableMap = new int[64];
    private final VariableRemapper variableRemapper = new VariableRemapper();

    public void reset(int n) {
        if (this.deleted.length < n) {
            this.deleted = new boolean[n];
        } else {
            Arrays.fill(this.deleted, 0, n, false);
        }
        this.modified = false;
    }

    public void deleteVariable(int n) {
        this.deleted[n] = true;
        this.modified = true;
    }

    public boolean isDeleted(int n) {
        return this.deleted[n];
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (!this.modified) {
            return;
        }
        int n = codeAttribute.u2maxLocals;
        if (this.variableMap.length < n) {
            this.variableMap = new int[n];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.variableMap[i] = this.deleted[i] ? -1 : n2++;
        }
        this.variableRemapper.setVariableMap(this.variableMap);
        this.variableRemapper.visitCodeAttribute(clazz, method, codeAttribute);
        codeAttribute.u2maxLocals = n2;
    }
}

