#!/bin/sh
#
#
. /usr/lib/java-wrappers/java-wrappers.sh

# Jython compiles java bytecode into python bytecode in advance; it needs a user-writable directory to cache it
export JYTHON_OPTS="${JYTHON_OPTS} -Dpython.cachedir=${HOME}/.jython_cachedir"

# Detect and warn about a possible misconfiguration
if [ -n "$JAVA_HOME" ] && [ "x$JAVA_HOME" != x. ] ; then
	echo "Your JAVA_HOME is set to $JAVA_HOME. Please make sure that this points to a Java7 runtime"
fi	
if [ -n "$JAVA_CMD" ] && [ "x$JAVA_CMD" != x. ] ; then
	echo "Your JAVA_CMD is set to $JAVA_CMD. Please make sure that this points to a Java7 runtime"
fi	

# We depend on the openjdk runtime 
find_java_runtime openjdk7

# Use jython if found (this does not work yet, as we build-dep on jython: jh_build adds it to the depends)
#if locate_jar jython; then
#  find_jars jython
#fi

# For some reason, some people need that jar to be manually loaded
find_jars commons-logging

# http stuff
find_jars httpmime httpcore httpclient

# We obviously need our own library
find_jars plm

run_java plm.core.ui.ProgrammersLearningMachine "$@"
