/*	test_ByteBuffer_Streams

PIRL CVS ID: test_ByteBuffer_Streams.java,v 1.4 2012/04/16 06:18:24 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Utilities.ByteBuffer_InputStream;
import	PIRL.Utilities.ByteBuffer_OutputStream;

import	PIRL.PVL.*;
import	PIRL.Utilities.Checker;

import	java.nio.ByteBuffer;


public class test_ByteBuffer_Streams
{

public static void main
	(
	String[] arguments
	)
{
System.out.println
	("*** test_ByteBuffer_Streams:\n"
	+"    " + ByteBuffer_InputStream.ID + '\n'
	+"    " + ByteBuffer_OutputStream.ID);

String
	parameters_string =
		"Parameter = One\n" +
		"Parameter = Two\n" +
		"GROUP = Test\n" +
		"	Parameter = 1\n" +
		"	OBJECT = SUB_A\n" +
		"		SUB_A1 = 1.0\n" +
		"		SUB_A2 = 2.0\n" +
		"		SUB_A3 = 3.0\n" +
		"	END_OBJECT\n" +
		"	GROUP = SUB_B\n" +
		"		SUB_B1 = one\n" +
		"		SUB_B2 = \n" +
		"			(two, 2, to, too)\n" +
		"	END_GROUP\n" +
		"END_GROUP\n" +
		"END\n";
Parameter
	string_parameters,
	buffer_parameters;
ByteBuffer
	buffer = ByteBuffer.allocate (8192);
byte[]
	bytes;
Checker
	checker = new Checker ();

if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

try
	{
	if (checker.Verbose)
		System.out.println
			("--- parameters_string:\n"
			+ parameters_string);
	string_parameters = new Parameter
		(new Parser (parameters_string));

	buffer.put (parameters_string.getBytes ());
	buffer.flip ();
	buffer_parameters = new Parameter
		(new Parser (new ByteBuffer_InputStream (buffer)));
	checker.Check ("Parameter Parsed from ByteBuffer_InputStream",
		string_parameters.Description (), buffer_parameters.Description ());


	buffer.rewind ();
	bytes = new byte[buffer.limit ()];
	buffer.put (bytes);
	buffer.clear ();
	string_parameters.Write (new ByteBuffer_OutputStream (buffer));
	buffer.flip ();
	bytes = new byte[buffer.limit ()];
	buffer.get (bytes, 0, buffer.limit ());
	checker.Check ("Parameter Written to ByteBuffer_OutputStream",
		parameters_string, new String (bytes, 0, buffer.limit ()));
	}
catch (Exception exception)
	{
	System.out.println
		("\n"
		+"Exception: " + exception + '\n'
		+"    " + exception.getMessage ());
	}
}

}
