/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.rigidphysics;

import java.util.HashMap;
import org.odejava.Body;
import org.odejava.JointGroup;
import org.odejava.JointUniversal;
import org.odejava.World;
import org.odejava.ode.OdeConstants;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.rigidphysics.BaseJointNode;

public abstract class BaseUniversalJoint
extends BaseJointNode {
    protected static final int FIELD_ANCHOR_POINT = 4;
    protected static final int FIELD_AXIS1 = 5;
    protected static final int FIELD_AXIS2 = 6;
    protected static final int FIELD_BODY1_ANCHOR_POINT = 7;
    protected static final int FIELD_BODY2_ANCHOR_POINT = 8;
    protected static final int FIELD_BODY1_AXIS = 9;
    protected static final int FIELD_BODY2_AXIS = 10;
    protected static final int FIELD_STOP1_BOUNCE = 11;
    protected static final int FIELD_STOP2_BOUNCE = 12;
    protected static final int FIELD_STOP1_ERROR_CORRECTION = 13;
    protected static final int FIELD_STOP2_ERROR_CORRECTION = 14;
    protected static final int LAST_INDEX = 14;
    private static final int NUM_FIELDS = 15;
    protected static final String BOUNCE1_RANGE_MSG = "The stop1Bounce value is out of the required range [0,1]: ";
    protected static final String BOUNCE2_RANGE_MSG = "The stop2Bounce value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR1_RANGE_MSG = "The stop1ErrorCorrection value is out of the required range [0,1]: ";
    protected static final String STOP_ERROR2_RANGE_MSG = "The stop2ErrorCorrection value is out of the required range [0,1]: ";
    private static final String AP1_WRITE_MSG = "body1AnchorPoint is outputOnly and cannot be set";
    private static final String AP2_WRITE_MSG = "body2AnchorPoint is outputOnly and cannot be set";
    private static final String AX1_WRITE_MSG = "body1Axis is outputOnly and cannot be set";
    private static final String AX2_WRITE_MSG = "body2Axis is outputOnly and cannot be set";
    private static final int[] outputFields;
    private static final int[] nodeFields;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    protected float[] vfAnchorPoint = new float[3];
    protected float[] vfAxis1 = new float[3];
    protected float[] vfAxis2 = new float[3];
    protected float[] vfBody1AnchorPoint = new float[3];
    protected float[] vfBody2AnchorPoint = new float[3];
    protected float[] vfBody1Axis = new float[3];
    protected float[] vfBody2Axis = new float[3];
    protected float vfStop1Bounce = 0.0f;
    protected float vfStop2Bounce = 0.0f;
    protected float vfStop1ErrorCorrection = 0.8f;
    protected float vfStop2ErrorCorrection = 0.8f;
    protected JointUniversal odeJoint;

    public BaseUniversalJoint() {
        super("UniversalJoint");
        this.hasChanged = new boolean[15];
    }

    public BaseUniversalJoint(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        try {
            int n = vRMLNodeType.getFieldIndex("anchorPoint");
            VRMLFieldData vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAnchorPoint[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAnchorPoint[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAnchorPoint[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("axis1");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis1[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAxis1[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAxis1[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("axis2");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfAxis2[0] = vRMLFieldData.floatArrayValue[0];
            this.vfAxis2[1] = vRMLFieldData.floatArrayValue[1];
            this.vfAxis2[2] = vRMLFieldData.floatArrayValue[2];
            n = vRMLNodeType.getFieldIndex("stop1Bounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop1Bounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop2Bounce");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop2Bounce = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop1ErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop1ErrorCorrection = vRMLFieldData.floatValue;
            n = vRMLNodeType.getFieldIndex("stop2ErrorCorrection");
            vRMLFieldData = vRMLNodeType.getFieldValue(n);
            this.vfStop2ErrorCorrection = vRMLFieldData.floatValue;
        }
        catch (VRMLException vRMLException) {
            throw new IllegalArgumentException(vRMLException.getMessage());
        }
    }

    public void delete() {
        this.odeJoint.delete();
    }

    public void updateRequestedOutputs() {
        for (int i = 0; i < this.numOutputIndices; ++i) {
            int cfr_ignored_0 = this.outputIndices[i];
        }
    }

    public void setODEWorld(World world, JointGroup jointGroup) {
        if (world != null) {
            this.odeJoint = new JointUniversal(world, jointGroup);
            Body body = null;
            Body body2 = null;
            if (this.vfBody1 != null) {
                body = this.vfBody1.getODEBody();
            }
            if (this.vfBody2 != null) {
                body2 = this.vfBody2.getODEBody();
            }
            this.odeJoint.attach(body, body2);
            this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
            this.odeJoint.setAxis1(this.vfAxis1[0], this.vfAxis1[1], this.vfAxis1[2]);
            this.odeJoint.setAxis2(this.vfAxis2[0], this.vfAxis2[1], this.vfAxis2[2]);
            this.odeJoint.setParam(OdeConstants.dParamBounce, this.vfStop1Bounce);
            this.odeJoint.setParam(OdeConstants.dParamBounce2, this.vfStop2Bounce);
            this.odeJoint.setParam(OdeConstants.dParamStopERP, this.vfStop1ErrorCorrection);
            this.odeJoint.setParam(OdeConstants.dParamStopERP2, this.vfStop2ErrorCorrection);
        } else {
            this.odeJoint.delete();
        }
    }

    public void setBody1(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody1(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
    }

    public void setBody2(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setBody2(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 14) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 81;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        Body body = null;
        Body body2 = null;
        if (this.vfBody1 != null) {
            body = this.vfBody1.getODEBody();
        }
        if (this.vfBody2 != null) {
            body2 = this.vfBody2.getODEBody();
        }
        this.odeJoint.attach(body, body2);
        this.odeJoint.setAnchor(this.vfAnchorPoint[0], this.vfAnchorPoint[1], this.vfAnchorPoint[2]);
        this.odeJoint.setAxis1(this.vfAxis1[0], this.vfAxis1[1], this.vfAxis1[2]);
        this.odeJoint.setAxis2(this.vfAxis2[0], this.vfAxis2[1], this.vfAxis2[2]);
        this.odeJoint.setParam(OdeConstants.dParamBounce, this.vfStop1Bounce);
        this.odeJoint.setParam(OdeConstants.dParamBounce2, this.vfStop2Bounce);
        this.odeJoint.setParam(OdeConstants.dParamStopERP, this.vfStop1ErrorCorrection);
        this.odeJoint.setParam(OdeConstants.dParamStopERP2, this.vfStop2ErrorCorrection);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfAnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfAxis1;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfAxis2;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody1AnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody2AnchorPoint;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 9: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody1Axis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 10: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfBody2Axis;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 11: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop1Bounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 12: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop2Bounce;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 13: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop1ErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 14: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStop2ErrorCorrection;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfAnchorPoint, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfAxis1, 3);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfAxis2, 3);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfBody1AnchorPoint, 3);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfBody2AnchorPoint, 3);
                    break;
                }
                case 9: {
                    vRMLNodeType.setValue(n2, this.vfBody1Axis, 3);
                    break;
                }
                case 10: {
                    vRMLNodeType.setValue(n2, this.vfBody2Axis, 3);
                    break;
                }
                case 11: {
                    vRMLNodeType.setValue(n2, this.vfStop1Bounce);
                    break;
                }
                case 12: {
                    vRMLNodeType.setValue(n2, this.vfStop2Bounce);
                    break;
                }
                case 13: {
                    vRMLNodeType.setValue(n2, this.vfStop1ErrorCorrection);
                    break;
                }
                case 14: {
                    vRMLNodeType.setValue(n2, this.vfStop2ErrorCorrection);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("SingleAxis1Joint.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("SingleAxis1Joint.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, float f) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 11: {
                this.setStop1Bounce(f);
                break;
            }
            case 12: {
                this.setStop2Bounce(f);
                break;
            }
            case 13: {
                this.setStop1ErrorCorrection(f);
                break;
            }
            case 14: {
                this.setStop2ErrorCorrection(f);
                break;
            }
            default: {
                super.setValue(n, f);
            }
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldValueException, InvalidFieldException {
        switch (n) {
            case 4: {
                this.setAnchorPoint(fArray);
                break;
            }
            case 5: {
                this.setAxis1(fArray);
                break;
            }
            case 6: {
                this.setAxis2(fArray);
                break;
            }
            case 7: {
                throw new InvalidFieldAccessException(AP1_WRITE_MSG);
            }
            case 8: {
                throw new InvalidFieldAccessException(AP2_WRITE_MSG);
            }
            case 9: {
                throw new InvalidFieldAccessException(AX1_WRITE_MSG);
            }
            case 10: {
                throw new InvalidFieldAccessException(AX2_WRITE_MSG);
            }
            default: {
                super.setValue(n, fArray, n2);
            }
        }
    }

    private void setAnchorPoint(float[] fArray) {
        this.vfAnchorPoint[0] = fArray[0];
        this.vfAnchorPoint[1] = fArray[1];
        this.vfAnchorPoint[2] = fArray[2];
        if (!this.inSetup) {
            this.odeJoint.setAnchor(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    private void setAxis1(float[] fArray) {
        this.vfAxis1[0] = fArray[0];
        this.vfAxis1[1] = fArray[1];
        this.vfAxis1[2] = fArray[2];
        if (!this.inSetup) {
            this.odeJoint.setAxis1(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
        }
    }

    private void setAxis2(float[] fArray) {
        this.vfAxis2[0] = fArray[0];
        this.vfAxis2[1] = fArray[1];
        this.vfAxis2[2] = fArray[2];
        if (!this.inSetup) {
            this.odeJoint.setAxis2(fArray[0], fArray[1], fArray[2]);
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
        }
    }

    private void setStop1Bounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE1_RANGE_MSG + f);
        }
        this.vfStop1Bounce = f;
        if (!this.inSetup) {
            this.odeJoint.setParam(OdeConstants.dParamBounce, f);
            this.hasChanged[11] = true;
            this.fireFieldChanged(11);
        }
    }

    private void setStop2Bounce(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(BOUNCE2_RANGE_MSG + f);
        }
        this.vfStop2Bounce = f;
        if (!this.inSetup) {
            this.odeJoint.setParam(OdeConstants.dParamBounce2, f);
            this.hasChanged[12] = true;
            this.fireFieldChanged(12);
        }
    }

    private void setStop1ErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR1_RANGE_MSG + f);
        }
        this.vfStop1ErrorCorrection = f;
        if (!this.inSetup) {
            this.odeJoint.setParam(OdeConstants.dParamStopERP, f);
            this.hasChanged[13] = true;
            this.fireFieldChanged(13);
        }
    }

    private void setStop2ErrorCorrection(float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException(STOP_ERROR2_RANGE_MSG + f);
        }
        this.vfStop2ErrorCorrection = f;
        if (!this.inSetup) {
            this.odeJoint.setParam(OdeConstants.dParamStopERP2, f);
            this.hasChanged[14] = true;
            this.fireFieldChanged(14);
        }
    }

    int[] getAllOutputFieldIndices() {
        return outputFields;
    }

    static {
        nodeFields = new int[]{0, 1, 2};
        outputFields = new int[]{7, 8, 9, 10};
        fieldDecl = new VRMLFieldDeclaration[15];
        fieldMap = new HashMap(45);
        BaseUniversalJoint.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseUniversalJoint.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFVec3f", "anchorPoint");
        BaseUniversalJoint.fieldDecl[5] = new VRMLFieldDeclaration(3, "SFVec3f", "axis1");
        BaseUniversalJoint.fieldDecl[6] = new VRMLFieldDeclaration(3, "SFVec3f", "axis2");
        BaseUniversalJoint.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "body1");
        BaseUniversalJoint.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "body2");
        BaseUniversalJoint.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFVec3f", "body1AnchorPoint");
        BaseUniversalJoint.fieldDecl[8] = new VRMLFieldDeclaration(4, "SFVec3f", "body2AnchorPoint");
        BaseUniversalJoint.fieldDecl[9] = new VRMLFieldDeclaration(4, "SFVec3f", "body1Axis");
        BaseUniversalJoint.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFVec3f", "body2Axis");
        BaseUniversalJoint.fieldDecl[11] = new VRMLFieldDeclaration(3, "SFFloat", "stop1Bounce");
        BaseUniversalJoint.fieldDecl[12] = new VRMLFieldDeclaration(3, "SFFloat", "stop2Bounce");
        BaseUniversalJoint.fieldDecl[13] = new VRMLFieldDeclaration(3, "SFFloat", "stop1ErrorCorrection");
        BaseUniversalJoint.fieldDecl[14] = new VRMLFieldDeclaration(3, "SFFloat", "stop2ErrorCorrection");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(4);
        fieldMap.put("anchorPoint", n);
        fieldMap.put("set_anchorPoint", n);
        fieldMap.put("anchorPoint_changed", n);
        n = new Integer(1);
        fieldMap.put("body1", n);
        fieldMap.put("set_body1", n);
        fieldMap.put("body1_changed", n);
        n = new Integer(2);
        fieldMap.put("body2", n);
        fieldMap.put("set_body2", n);
        fieldMap.put("body2_changed", n);
        n = new Integer(5);
        fieldMap.put("axis1", n);
        fieldMap.put("set_axis1", n);
        fieldMap.put("axis1_changed", n);
        n = new Integer(6);
        fieldMap.put("axis2", n);
        fieldMap.put("set_axis2", n);
        fieldMap.put("axis2_changed", n);
        n = new Integer(11);
        fieldMap.put("stop1Bounce", n);
        fieldMap.put("set_stop1Bounce", n);
        fieldMap.put("stop1Bounce_changed", n);
        n = new Integer(12);
        fieldMap.put("stop2Bounce", n);
        fieldMap.put("set_stop2Bounce", n);
        fieldMap.put("stop2Bounce_changed", n);
        n = new Integer(13);
        fieldMap.put("stop1ErrorCorrection", n);
        fieldMap.put("set_stop1ErrorCorrection", n);
        fieldMap.put("stop1ErrorCorrection_changed", n);
        n = new Integer(14);
        fieldMap.put("stop2ErrorCorrection", n);
        fieldMap.put("set_stop2ErrorCorrection", n);
        fieldMap.put("stop2ErrorCorrection_changed", n);
        fieldMap.put("body1AnchorPoint", new Integer(7));
        fieldMap.put("body2AnchorPoint", new Integer(8));
        fieldMap.put("body1Axis", new Integer(9));
        fieldMap.put("body2Axis", new Integer(10));
    }
}

