//=======================================================================
// common.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef LIBPACO_COMMON_H
#define LIBPACO_COMMON_H

#include <stdexcept>
#include <iosfwd>
#include <sstream>


namespace Paco
{
	// Types and constants
	//--------------------

	int const HUMAN_READABLE	= -1;
	int const BYTE				= 1;
	int const KILOBYTE			= 1024;
	int const MEGABYTE			= 1048576;

	typedef enum {
		NO_SORT			= 0,
		SORT_NAME		= 1,
		SORT_SIZE		= 2,	// alias for SORT_SIZE_INST
		SORT_SIZE_INST	= 2,
		SORT_SIZE_MISS	= 3,
		SORT_FILES_INST	= 4,
		SORT_FILES_MISS	= 5,
		SORT_DATE		= 6
	} SortType;

	// Exceptions
	//-----------
	
	class X : public std::runtime_error
	{
		public: X(std::string const& msg);
	};

	class XErrno : public std::runtime_error
	{
		public: XErrno(std::string const& msg);
	};

	// Global free functions and classes
	//----------------------------------

	// A safer std::{i,o}fstream
	template<typename T>	// T = std::{i,o}fstream
	class FileStream : public T
	{
		public:
		FileStream(std::string const& path) : T(path.c_str())
		{
			if (!this)
				throw XErrno(path);
			this->exceptions(std::ios::badbit);
		}
	};

	extern std::string toString(float size, int unit = HUMAN_READABLE);
	extern std::string toString(long size, int unit = HUMAN_READABLE);

	extern bool inPaths(std::string const&, std::string const&);

	template <typename T>	// T = {int,long,unsigned,...}
	T str2num(std::string const& s)
	{
		std::istringstream is(s);
		T t;
		is >> t;
		return t;
	}

}		// namespace Paco

#endif  // LIBPACO_COMMON_H
