#ifndef __NAPT_APTPACKAGEBUILDER_H_2024_12_08
#define __NAPT_APTPACKAGEBUILDER_H_2024_12_08

#include <optional>
#include <map>

#include "dpkgparser.h"
#include "package.h"
#include "packagedetails.h"

using namespace std;

namespace NApt {

class AptPackageBuilder {
    /** Used only internally. */
    struct InstallInformation {
        IPackage::InstalledState installedState;
        QString installedVersion;
        QString availableVersion;
    };

    InstallInformation calculateInstallInformation() const;

    // todo: delete on destructor
    optional<QString> _name;
    optional<QString> _essential;
    optional<QString> _priority;
    optional<QString> _section;
    optional<uint>_installedSize;
    optional<QString> _maintainer;
    optional<QString> _architecture;
    optional<QString> _source;
    optional<QString> _replaces;
    optional<QString> _provides;
    optional<QString> _preDepends;
    optional<QString> _depends;
    optional<QString> _recommends;
    optional<QString> _suggests;
    optional<QString> _conflicts;
    optional<QString> _breaks;
    optional<QString> _filename;
    optional<uint>_size;
    optional<QString> _md5sum;
    optional<QString> _sha256;
    optional<QString> _conffiles;
    optional<IPackage::InstalledState> _installedState;
    optional<QString> _version;
    optional<QString> _description;
    optional<QString> _homepage;

    optional<reference_wrapper<const map<string, const DpkgParser::PackageInformation>>> _dpkgPackageInformation;
public:
    AptPackageBuilder(
        optional<reference_wrapper<const map<string, const DpkgParser::PackageInformation>>>
            dpkgPackageInformation = nullopt
    ) : _dpkgPackageInformation(dpkgPackageInformation) {}


    unique_ptr<Package> createPackage() const;
    PackageDetails createPackageDetails() const;

    QString name() const { return _name.value_or(""); }
    QString architecture() const { return _architecture.value_or(""); }

    bool isInstalled() const { return _installedState.has_value() && _installedState.value() == IPackage::INSTALLED; }

    void setName(const QString& value) { _name = value; }
    void setEssential(const QString& value) { _essential = value; }
    void setPriority(const QString& value) { _priority = value; }
    void setSection(const QString& value) { _section = value; }
    void setMaintainer(const QString& value) { _maintainer = value; }
    void setArchitecture(const QString& value) { _architecture = value; }
    void setSource(const QString& value) { _source = value; }
    void setReplaces(const QString& value) { _replaces = value; }
    void setProvides(const QString& value) { _provides = value; }
    void setPreDepends(const QString& value) { _preDepends = value; }
    void setDepends(const QString& value) { _depends = value; }
    void setRecommends(const QString& value) { _recommends = value; }
    void setSuggests(const QString& value) { _suggests = value; }
    void setConflicts(const QString& value) { _conflicts = value; }
    void setBreaks(const QString& value) { _breaks = value; }
    void setFilename(const QString& value) { _filename = value; }
    void setSize(uint32_t value) { _size = value; }
    void setMd5sum(const QString& value) { _md5sum = value; }
    void setSha256(const QString& value) { _sha256 = value; }
    void setConffiles(const QString& value) { _conffiles = value; }
    void setInstalledSize(uint32_t value) { _installedSize = value; }
    void setInstalledState(Package::InstalledState value) { _installedState = value; }
    void setVersion(const QString& value) { _version = value; }
    void setDescription(const QString& value) { _description = value; }
    void setHomepage(const QString& value) { _homepage = value; }

    void clear();

    static AptPackageBuilder fromPackageDetails(const PackageDetails& details);
};

}

#endif // __NAPT_APTPACKAGEBUILDER_H_2024_12_08
