///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __RENDER_SETTINGS_EDITOR_H
#define __RENDER_SETTINGS_EDITOR_H

#include <core/Core.h>
#include <core/gui/properties/PropertiesEditor.h>
#include <core/reference/RefTarget.h>
#include <core/scene/animation/TimeInterval.h>

namespace Core {

/******************************************************************************
* The editor component for the RenderSettings object class.
******************************************************************************/
class RenderSettingsEditor : public PropertiesEditor
{
protected:
	
	/// Creates the user interface controls for the editor.
	virtual void createUI(const RolloutInsertionParameters& rolloutParams);

private Q_SLOTS:

	/// Lets the user choose a filename for the output image.
	void onChooseImageFilename();

	/// Is called when the user selects an output size preset from the drop-down list.
	void onSizePresetActivated(int index);
	
private:

	QComboBox* sizePresetsBox;

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(RenderSettingsEditor)
};

};

#endif // __RENDER_SETTINGS_EDITOR_H
