###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_sjs_access_manager_detect.nasl 3866 2009-08-25 12:14:24Z aug $
#
# Sun Java System Access Manager Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900194);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Sun Java System Access Manager Version Detection");

  desc = "
  Overview: This script detects the installed version of Access Manager and
  sets the version in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of Access Manager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");

am_port = get_http_port(default:8080);
if(!am_port){
  am_port = 8080;
}

if(!get_port_state(am_port)){
  exit(0);
}

foreach dir (make_list("/", "/amserver"))
{
  sndReq = http_get(item:string(dir, "/UI/Login.jsp"), port:am_port);
  rcvRes = http_send_recv(port:am_port, data:sndReq);

  if(egrep(pattern:"Sun Java System Access Manager .*", string:rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    # Grep the Java System Access Manager Version from Response
    amVer = eregmatch(pattern:"X-DSAMEVersion: ([0-9]\.[0-9.]+(.?[a-zQ0-9]+)?)",
                      string:rcvRes);

    if(amVer[1] != NULL)
    {
       amVer = ereg_replace(pattern:" ", string:amVer[1], replace:".");
       set_kb_item(name:"www/"+ am_port + "/Sun/JavaSysAccessMang",
                  value:amVer + " under " + dir);
       security_note(data:"Sun Java System Access Manager version " + amVer +
                          " running at location " + dir +
                          " was detected on the host");
    }
  }
}
