#
#VID bce1f76d-82d0-11de-88ea-001a4d49522b
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID bce1f76d-82d0-11de-88ea-001a4d49522b
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64659);
 script_cve_id("CVE-2009-2411");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"8.5");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("FreeBSD Ports: subversion, subversion-freebsd, p5-subversion, py-subversion");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   subversion
   subversion-freebsd
   p5-subversion
   py-subversion

CVE-2009-2411
Multiple integer overflows in the libsvn_delta library in Subversion
before 1.5.7, and 1.6.x before 1.6.4, allow remote authenticated users
and remote Subversion servers to execute arbitrary code via an svndiff
stream with large windows that trigger a heap-based buffer overflow, a
related issue to CVE-2009-2412.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://subversion.tigris.org/security/CVE-2009-2411-advisory.txt
http://www.vuxml.org/freebsd/bce1f76d-82d0-11de-88ea-001a4d49522b.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: subversion, subversion-freebsd, p5-subversion, py-subversion");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"subversion");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.4")<0) {
    security_note(0, data:"Package subversion version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"subversion-freebsd");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.4")<0) {
    security_note(0, data:"Package subversion-freebsd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"p5-subversion");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.4")<0) {
    security_note(0, data:"Package p5-subversion version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"py-subversion");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.4")<0) {
    security_note(0, data:"Package py-subversion version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
