# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1086-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56856);
 script_cve_id("CVE-2006-2542");
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1086-1 (xmcd)";
 script_name(name);

 desc = "The remote host is missing an update to xmcd
announced via advisory DSA 1086-1.

The xmcdconfig creates directories world-writeable allowing local
users to fill the /usr and /var partition and hence cause a denial of
service.  This problem has been half-fixed since version 2.3-1.

For the old stable distribution (woody) this problem has been fixed in
version 2.6-14woody1.

For the stable distribution (sarge) this problem has been fixed in
version 2.6-17sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 2.6-18.

We recommend that you upgrade your xmcd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201086-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1086-1 (xmcd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cddb", ver:"2.6-14woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xmcd", ver:"2.6-14woody1", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"cddb", ver:"2.6-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xmcd", ver:"2.6-17sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
