"computeResidualLm" <-
function(x, beta, y){
  
  # Checking for NAs in y, beta is assumed not to contain any
  indexNA <- which(is.na(y))

  if(length(indexNA) > 0) {
    x[indexNA, ] <- NA 
  }

  # Checking for NAs in x, beta is assumed not to contain any
  indexNA <- which(is.na(x), arr.ind=TRUE)

  if(length(indexNA) > 0) {

    x[indexNA[, 1], ] <- NA 
    y[indexNA[, 1]] <- NA
    # Eliminating the NAs
    x <- matrix(x[ ! is.na(x)], ncol = ncol(x))
    y <- y[ ! is.na(y)]
  }

  # Computing the residual. 
  completeX <- cbind(rep(1, nrow(x)), x)
  predictedSample <- completeX %*% beta
  residual <- y - predictedSample  

  return(residual)

}

