/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.service.component;

import java.util.List;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.core.Assignment;
import org.chefproject.core.AssignmentContent;
import org.chefproject.core.AssignmentContentEdit;
import org.chefproject.core.AssignmentEdit;
import org.chefproject.core.AssignmentSubmission;
import org.chefproject.core.AssignmentSubmissionEdit;
import org.chefproject.service.component.BaseAssignmentService;
import org.chefproject.service.component.BaseXmlFileStorage;

public class XmlFileAssignmentService
extends BaseAssignmentService {
    protected String m_assignmentStoragePath = null;
    protected String m_contentStoragePath = null;
    protected String m_submissionStoragePath = null;

    public void init(RunData data) throws InitializationException {
        super.init(data);
        this.m_assignmentStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("assignmentpath", "db/assignment_assignment.xml"));
        Log.info("chef", this + ".init(RunData): assignment storage path: " + this.m_assignmentStoragePath);
        this.m_contentStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("contentpath", "db/assignment_content.xml"));
        Log.info("chef", this + ".init(RunData): assignment content storage path: " + this.m_contentStoragePath);
        this.m_submissionStoragePath = data.getServletContext().getRealPath(this.getProperties().getProperty("submissionpath", "db/assignment_submission.xml"));
        Log.info("chef", this + ".init(RunData): assignment submission storage path: " + this.m_submissionStoragePath);
    }

    public void init() throws InitializationException {
        super.init();
        this.m_assignmentCache.disable();
        this.m_contentCache.disable();
        this.m_submissionCache.disable();
    }

    protected BaseAssignmentService.AssignmentStorage newAssignmentStorage() {
        return new XmlFileAssignmentStorage(new BaseAssignmentService.AssignmentStorageUser());
    }

    protected BaseAssignmentService.AssignmentContentStorage newContentStorage() {
        return new XmlFileAssignmentContentStorage(new BaseAssignmentService.AssignmentContentStorageUser());
    }

    protected BaseAssignmentService.AssignmentSubmissionStorage newSubmissionStorage() {
        return new XmlFileAssignmentSubmissionStorage(new BaseAssignmentService.AssignmentSubmissionStorageUser());
    }

    protected class XmlFileAssignmentSubmissionStorage
    extends BaseXmlFileStorage
    implements BaseAssignmentService.AssignmentSubmissionStorage {
        public XmlFileAssignmentSubmissionStorage(BaseAssignmentService.AssignmentSubmissionStorageUser submission) {
            super(XmlFileAssignmentService.this.m_submissionStoragePath, "submissions", null, "submission", submission);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public AssignmentSubmission get(String id) {
            return (AssignmentSubmission)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public AssignmentSubmissionEdit put(String id, String context, String assignmentId) {
            Object[] others = new Object[]{context, assignmentId};
            return (AssignmentSubmissionEdit)super.putResource(null, id, others);
        }

        public AssignmentSubmissionEdit edit(String id) {
            return (AssignmentSubmissionEdit)super.editResource(null, id);
        }

        public void commit(AssignmentSubmissionEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(AssignmentSubmissionEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(AssignmentSubmissionEdit edit) {
            super.removeResource(null, edit);
        }
    }

    protected class XmlFileAssignmentContentStorage
    extends BaseXmlFileStorage
    implements BaseAssignmentService.AssignmentContentStorage {
        public XmlFileAssignmentContentStorage(BaseAssignmentService.AssignmentContentStorageUser content) {
            super(XmlFileAssignmentService.this.m_contentStoragePath, "contents", null, "content", content);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public AssignmentContent get(String id) {
            return (AssignmentContent)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public AssignmentContentEdit put(String id, String context) {
            Object[] others = new Object[]{context};
            return (AssignmentContentEdit)super.putResource(null, id, others);
        }

        public AssignmentContentEdit edit(String id) {
            return (AssignmentContentEdit)super.editResource(null, id);
        }

        public void commit(AssignmentContentEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(AssignmentContentEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(AssignmentContentEdit edit) {
            super.removeResource(null, edit);
        }
    }

    protected class XmlFileAssignmentStorage
    extends BaseXmlFileStorage
    implements BaseAssignmentService.AssignmentStorage {
        public XmlFileAssignmentStorage(BaseAssignmentService.AssignmentStorageUser assignment) {
            super(XmlFileAssignmentService.this.m_assignmentStoragePath, "assignments", null, "assignment", assignment);
        }

        public boolean check(String id) {
            return super.checkResource(null, id);
        }

        public Assignment get(String id) {
            return (Assignment)super.getResource(null, id);
        }

        public List getAll() {
            return super.getAllResources(null);
        }

        public AssignmentEdit put(String id, String context) {
            Object[] others = new Object[]{context};
            return (AssignmentEdit)super.putResource(null, id, others);
        }

        public AssignmentEdit edit(String id) {
            return (AssignmentEdit)super.editResource(null, id);
        }

        public void commit(AssignmentEdit edit) {
            super.commitResource(null, edit);
        }

        public void cancel(AssignmentEdit edit) {
            super.cancelResource(null, edit);
        }

        public void remove(AssignmentEdit edit) {
            super.removeResource(null, edit);
        }
    }
}

