/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.service.ArchiveService;

public class ArchiveAction
extends VelocityPortletPaneledAction {
    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String message = (String)state.getAttribute("message");
        if (message != null) {
            context.put("message", message);
        }
        state.removeAttribute("message");
        context.put("action", "ArchiveAction");
        return (String)this.getContext(rundata).get("template");
    }

    public void doArchive(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ArchiveService service = (ArchiveService)((Object)TurbineServices.getInstance().getService(ArchiveService.SERVICE_NAME));
        String id = data.getParameters().getString("archive-id");
        if (id != null && id.trim().length() > 0) {
            service.archive(id.trim());
            state.setAttribute("message", (Object)("archive of group " + id + " complete."));
        } else {
            state.setAttribute("message", (Object)"Please specify a group to archive.");
        }
    }

    public void doImport(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ArchiveService service = (ArchiveService)((Object)TurbineServices.getInstance().getService(ArchiveService.SERVICE_NAME));
        String id = data.getParameters().getString("import-id");
        String file = data.getParameters().getString("import-file");
        String mergeId = data.getParameters().getString("import-merge-id");
        if (id != null && id.trim().length() > 0 && file != null && file.trim().length() > 0) {
            service.merge(file.trim(), id.trim(), mergeId.trim());
            state.setAttribute("message", (Object)("import from file " + file + " to group " + id + " complete."));
        } else {
            state.setAttribute("message", (Object)"Please specify a file name and a group id for import.");
        }
    }
}

