/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.authorization;

import com.sourceforge.knecs.dsm.authorization.DSIPrivilege;
import com.sourceforge.knecs.util.LoggerUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class NormalizedAce
extends Hashtable {
    protected String mUser;
    protected static Logger mLogger = null;

    public NormalizedAce() {
        mLogger = LoggerUtils.getLogger(this);
        this.mUser = "";
    }

    public NormalizedAce(NormalizedAce ace) {
        this.mUser = ace.mUser;
        mLogger = LoggerUtils.getLogger(this);
        mLogger.fine("copying ace for " + this.mUser);
        Enumeration keys = ace.keys();
        while (keys.hasMoreElements()) {
            String privName = (String)keys.nextElement();
            Vector curPrivList = ace.getVector(privName);
            Vector<DSIPrivilege> newPrivList = new Vector<DSIPrivilege>();
            int size = curPrivList.size();
            for (int i = 0; i < size; ++i) {
                DSIPrivilege curPriv = (DSIPrivilege)curPrivList.elementAt(i);
                newPrivList.add(new DSIPrivilege(curPriv));
            }
            super.put(privName, newPrivList);
        }
    }

    public NormalizedAce(String user) {
        this();
        this.mUser = user;
    }

    public void setUser(String user) {
        this.mUser = new String(user);
    }

    public String getUser() {
        return this.mUser;
    }

    public Object put(Object key, Object value) {
        Vector<DSIPrivilege> newval = value;
        if (key instanceof String && value instanceof DSIPrivilege) {
            Vector<DSIPrivilege> list = (Vector<DSIPrivilege>)super.get(key);
            DSIPrivilege priv = (DSIPrivilege)((Object)value);
            if (list == null) {
                list = new Vector<DSIPrivilege>();
            }
            int size = list.size();
            int insert = 0;
            for (int i = 0; i < size; ++i) {
                DSIPrivilege curPriv = (DSIPrivilege)list.elementAt(i);
                if (priv.getInheritanceLevel() <= curPriv.getInheritanceLevel()) break;
                ++insert;
            }
            mLogger.fine("inserting " + priv.getName() + " deny=" + priv.getDeny() + " inheritanceLvl=" + priv.getInheritanceLevel() + " for user " + this.mUser + " at index " + insert);
            list.add(insert, priv);
            newval = list;
        } else {
            mLogger.fine("Putting object: " + value.getClass().getName() + " into NormalizedAce");
        }
        return super.put(key, newval);
    }

    public Object get(Object key) {
        Object ret = super.get(key);
        if (ret != null && ret instanceof Vector) {
            Vector list = (Vector)ret;
            ret = list.size() > 0 ? list.elementAt(0) : null;
        }
        return ret;
    }

    protected Vector getVector(String key) {
        return (Vector)super.get(key);
    }

    public Object remove(Object key) {
        Object ret = super.get(key);
        if (ret != null && ret instanceof Vector) {
            DSIPrivilege priv;
            Vector list = (Vector)ret;
            ret = null;
            if (list.size() > 0 && (priv = (DSIPrivilege)list.elementAt(0)).getInheritanceLevel() == 0) {
                mLogger.fine("removing " + priv.getName() + " deny=" + priv.getDeny() + " inheritanceLvl=" + priv.getInheritanceLevel() + " for user " + this.mUser + " at index 0");
                ret = priv;
                list.removeElementAt(0);
            }
        }
        return ret;
    }

    public Enumeration elements() {
        Vector tempVec = new Vector();
        Enumeration elements = super.elements();
        while (elements.hasMoreElements()) {
            Vector vec = (Vector)elements.nextElement();
            if (vec.size() <= 0) continue;
            tempVec.add(vec.elementAt(0));
        }
        return tempVec.elements();
    }

    public DSIPrivilege getPrivilege(String privName) {
        DSIPrivilege priv = (DSIPrivilege)this.get(privName);
        DSIPrivilege all = (DSIPrivilege)this.get(DSIPrivilege.ALL);
        DSIPrivilege ret = priv == null ? all : (all == null ? priv : (priv.getInheritanceLevel() == all.getInheritanceLevel() && priv.getDeny() ? priv : (priv.getInheritanceLevel() < all.getInheritanceLevel() ? priv : all)));
        return ret;
    }
}

