/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/*
* When adding modules to the namespace, ensure that they are added in alphabetical order according to module name.
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-read-only-property' );


// MAIN //

/**
* Top-level namespace.
*
* @namespace ns
*/
var ns = {};

/**
* @name HOURS_IN_DAY
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/hours-in-day}
*/
setReadOnly( ns, 'HOURS_IN_DAY', require( './../../time/hours-in-day' ) );

/**
* @name HOURS_IN_WEEK
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/hours-in-week}
*/
setReadOnly( ns, 'HOURS_IN_WEEK', require( './../../time/hours-in-week' ) );

/**
* @name MILLISECONDS_IN_DAY
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/milliseconds-in-day}
*/
setReadOnly( ns, 'MILLISECONDS_IN_DAY', require( './../../time/milliseconds-in-day' ) );

/**
* @name MILLISECONDS_IN_HOUR
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/milliseconds-in-hour}
*/
setReadOnly( ns, 'MILLISECONDS_IN_HOUR', require( './../../time/milliseconds-in-hour' ) );

/**
* @name MILLISECONDS_IN_MINUTE
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/milliseconds-in-minute}
*/
setReadOnly( ns, 'MILLISECONDS_IN_MINUTE', require( './../../time/milliseconds-in-minute' ) );

/**
* @name MILLISECONDS_IN_SECOND
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/milliseconds-in-second}
*/
setReadOnly( ns, 'MILLISECONDS_IN_SECOND', require( './../../time/milliseconds-in-second' ) );

/**
* @name MILLISECONDS_IN_WEEK
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/milliseconds-in-week}
*/
setReadOnly( ns, 'MILLISECONDS_IN_WEEK', require( './../../time/milliseconds-in-week' ) );

/**
* @name MINUTES_IN_DAY
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/minutes-in-day}
*/
setReadOnly( ns, 'MINUTES_IN_DAY', require( './../../time/minutes-in-day' ) );

/**
* @name MINUTES_IN_HOUR
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/minutes-in-hour}
*/
setReadOnly( ns, 'MINUTES_IN_HOUR', require( './../../time/minutes-in-hour' ) );

/**
* @name MINUTES_IN_WEEK
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/minutes-in-week}
*/
setReadOnly( ns, 'MINUTES_IN_WEEK', require( './../../time/minutes-in-week' ) );

/**
* @name MONTHS_IN_YEAR
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/months-in-year}
*/
setReadOnly( ns, 'MONTHS_IN_YEAR', require( './../../time/months-in-year' ) );

/**
* @name SECONDS_IN_DAY
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/seconds-in-day}
*/
setReadOnly( ns, 'SECONDS_IN_DAY', require( './../../time/seconds-in-day' ) );

/**
* @name SECONDS_IN_HOUR
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/seconds-in-hour}
*/
setReadOnly( ns, 'SECONDS_IN_HOUR', require( './../../time/seconds-in-hour' ) );

/**
* @name SECONDS_IN_MINUTE
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/seconds-in-minute}
*/
setReadOnly( ns, 'SECONDS_IN_MINUTE', require( './../../time/seconds-in-minute' ) );

/**
* @name SECONDS_IN_WEEK
* @memberof ns
* @readonly
* @constant
* @type {number}
* @see {@link module:@stdlib/constants/time/seconds-in-week}
*/
setReadOnly( ns, 'SECONDS_IN_WEEK', require( './../../time/seconds-in-week' ) );


// EXPORTS //

module.exports = ns;
