#ifndef _PDU_IPX_H
#define _PDU_IPX_H

/* pdu-ipx.h
   
   Data structures used by the builder of IPX PDUs.

   Copyright (C) 2007, 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 *	The following information is in its entirety obtained from:
 *
 *	Novell 'IPX Router Specification' Version 1.10 
 *		Part No. 107-000029-001
 *
 *	Which is available from ftp.novell.com
 */

#define IPX_TYPE        1
#define IPX_NET_LEN     4
#define IPX_NODE_LEN    6
#define IPX_MTU         576

struct ipx_address {
	uint32_t net;
	uint8_t node[IPX_NODE_LEN]; 
	uint16_t sock;
} __attribute__ ((packed));

#define IPX_MAX_PPROP_HOPS 8

struct ipxhdr {
	uint16_t ipx_checksum;
#define IPX_NO_CHECKSUM	0xFFFF
	uint16_t ipx_pktsize;
	uint8_t	ipx_tctrl;
	uint8_t ipx_type;
#define IPX_TYPE_UNKNOWN	0x00
#define IPX_TYPE_RIP		0x01	/* may also be 0 */
#define IPX_TYPE_SAP		0x04	/* may also be 0 */
#define IPX_TYPE_SPX		0x05	/* SPX protocol */
#define IPX_TYPE_NCP		0x11	/* $lots for docs on this (SPIT) */
#define IPX_TYPE_PPROP		0x14	/* complicated flood fill brdcast */
	struct ipx_address ipx_dest;
	struct ipx_address ipx_source;
};

struct ipxhdr_options {
    numspec_t *ipx_type;
    struct ipx_address ipx_dest;
    struct ipx_address ipx_source;
    numspec_t *source_sock;
    numspec_t *dest_sock;
    numspec_t *cksum;
};

#endif
