// Copyright (C) 2004-2025 Artifex Software, Inc.
//
// This file is part of MuPDF.
//
// MuPDF is free software: you can redistribute it and/or modify it under the
// terms of the GNU Affero General Public License as published by the Free
// Software Foundation, either version 3 of the License, or (at your option)
// any later version.
//
// MuPDF is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
// details.
//
// You should have received a copy of the GNU Affero General Public License
// along with MuPDF. If not, see <https://www.gnu.org/licenses/agpl-3.0.en.html>
//
// Alternative licensing terms are available from the licensor.
// For commercial licensing, see <https://www.artifex.com/> or contact
// Artifex Software, Inc., 39 Mesa Street, Suite 108A, San Francisco,
// CA 94129, USA, for further information.

#ifndef ZXINGBARCODE_H
#define ZXINGBARCODE_H

#include "mupdf/fitz.h"

unsigned char *barcode_create(fz_barcode_type type, const char *value, int size, int ec_level, int quiet, int hrt, int *w, int *h, char *exception, int exception_len);
char *barcode_decode_from_samples(fz_barcode_type *type, int n, int w, int h, unsigned char *samples, int rotate, char *exception, int exception_len);

#endif
