#######################################################
# 
# SegmentFactory.py
# Python implementation of the Class SegmentFactory
# Generated by Enterprise Architect
# Created on:      14-Aug-2019 10:11:59 AM
# Original author: talve
# 
#######################################################


class SegmentFactory:
    """This class is responsible for creating and registering the segments.
    """
    segments = {}

    @classmethod
    def register(cls, segment_type, obj):
        """This method should  be use from the specific segment in order to perform the
        segment registration.
        """
        cls.segments.update({segment_type: obj})

    @classmethod
    def create(cls, segment_type, *args):
        """create the segment and return the segment obj.
        """
        if segment_type not in cls.segments:
            raise Exception("segment type:{0} is not supported".format(segment_type))
        return cls.segments[segment_type](*args)
