/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ViewEditor.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef ViewEditor_H
#define ViewEditor_H

#ifndef InternalEditor_H
#include "InternalEditor.h"
#endif

#ifndef Request_H
#include "Request.h"
#endif

#include "UIViewEditor.h"

#ifndef PageView_H
#include "PageView.h"
#endif


struct PaperRectangle;

class ViewEditor : public XEditor<UIViewEditor_c> {
public:

// -- Exceptions
	// None

// -- Contructors

	ViewEditor(const IconClass&,const string&);

// -- Destructor

	virtual ~ViewEditor(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	void splitSelection(int,int,double,double);
	void joinSelection();
	void groupSelection();
	void ungroupSelection();

	bool canSplitSelection();
	bool canJoinSelection(); 
	bool canGroupSelection();
	bool canUngroupSelection();

	void insetSelection(double,double,double,double);

	void deleteSelection();
	void addPage();

	void setPaperSize(double,double);
	void getPaperSize(double&,double&);

	void setGrid(double,double);
	void getGrid(double&,double&);
	void showGrid(bool);
	void snapGrid(bool);

	void update();

	void alignTop();
	void alignHorizontally(); 
	void alignLeft();
	void alignRight();
	void alignVertically(); 
	void alignBottom();

	void distributeHorizontally();
	void distributeVertically();

	void selectFirst();
	void unselect();

	void undo();
	void redo();

	IconObject* defaultView();

	IconObject *makeIcon(Folder*,int, Request&);
// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	ViewEditor(const ViewEditor&);
	ViewEditor& operator=(const ViewEditor&);

// -- Members

	Request request_;
	vector<IconObjectH> save_;

	map<IconObjectH,PageViewH> cache_;

// -- Methods

	PageView* pageView(IconObject*);


	PaperRectangle* loadRectangle(const Request&);
	PaperRectangle* loadPages(IconObject*,const Request&);
	PaperRectangle* loadSubPages(IconObject*,const Request&);

	void loadPaperSize(const Request&);
	void savePaperSize(Request&);

	void saveRectangle(Request&,PaperRectangle*);
	void savePages(IconObject*,Request&);


// -- Overridden methods

	// From InternalEditor 

	virtual void apply();
	virtual void reset();
	virtual void close();
	virtual void merge(IconObject*);
	virtual void replace(IconObject*);
	virtual string alternateEditor();

	// From DropSite. NOTE: we override the ones from Editor

	virtual Widget dropSite();
	virtual void drop(Dropping&);

	virtual void drawCB(Widget,XtPointer);
	virtual void dblClickCB(Widget,XtPointer);
	virtual void changeCB(Widget,XtPointer);
	virtual void splitCB(Widget, XtPointer );
	virtual void joinCB(Widget, XtPointer );
	virtual void groupCB(Widget, XtPointer );
	virtual void ungroupCB(Widget, XtPointer );
	virtual void deleteCB(Widget, XtPointer );
// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const ViewEditor& p)
	//	{ p.print(s); return s; }

};

inline void destroy(ViewEditor**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(ViewEditor);
//#endif

#endif
