/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQFolderWatcher_H
#define MvQFolderWatcher_H
 
#include <QList>
#include <QMap>
#include <QObject>
#include <QTime>

#include <time.h>

class Folder;
class FolderPresenter;
class QTimer;

struct MvQTimeoutInfo
{
	MvQTimeoutInfo() : lenght(0) {};
  	QTime last;
  	int lenght;
};


class MvQFolderWatcher : public QObject
{
Q_OBJECT  
  
public:
	static MvQFolderWatcher* add(FolderPresenter*);
	static void remove(FolderPresenter*);
	static void print();
	static void reload(FolderPresenter*);
	
	FolderPresenter* folderPresenter() {return presenter_;}
	Folder* folder();
	int timeout() const {return timeout_;}
	
public slots:
	void slotTimeout();
	
protected: 
	MvQFolderWatcher(FolderPresenter*);
	~MvQFolderWatcher() {};
	bool doTimeout(bool);
	void reload();
	
	bool isTimeoutDue();
	static void cleanLog();
	static MvQFolderWatcher* find(FolderPresenter* fp);
	
	FolderPresenter* presenter_;
	QTimer* timer_;
	static const int defaultTimeout_;
	int timeout_;
	static QList<MvQFolderWatcher*> items_;	
	static QMap<Folder*,MvQTimeoutInfo> timeoutLog_;
};

#endif
