#include "pdf/pilot.h"
c ---------------------------------------------------------------------
      double precision function faux5MI(ifl,x,q)
c auxiliary function for parametrization of CTEQ5MI (J. Pumplin 9/99).
c ---------------------------------------------------------------------
#include "pdf/impdp.inc"
      integer ifl

      parameter (nex=8, nlf=2)
      dimension am(0:nex,0:nlf,-5:2)
      dimension alfvec(-5:2), qmavec(-5:2)
      dimension mexvec(-5:2), mlfvec(-5:2)
      dimension ut1vec(-5:2), ut2vec(-5:2)
      dimension af(0:nex)

      data mexvec( 2) / 8 /
      data mlfvec( 2) / 2 /
      data ut1vec( 2) /  0.5141718E+01 /
      data ut2vec( 2) / -0.1346944E+01 /
      data alfvec( 2) /  0.5260555E+00 /
      data qmavec( 2) /  0.0000000E+00 /
      data (am( 0,k, 2),k=0, 2)
     & /  0.4289071E+01, -0.2536870E+01, -0.1259948E+01 /
      data (am( 1,k, 2),k=0, 2)
     & /  0.9839410E+00,  0.4168426E-01, -0.5018952E-01 /
      data (am( 2,k, 2),k=0, 2)
     & / -0.1651961E+02,  0.9246261E+01,  0.5996400E+01 /
      data (am( 3,k, 2),k=0, 2)
     & / -0.2077936E+02,  0.9786469E+01,  0.7656465E+01 /
      data (am( 4,k, 2),k=0, 2)
     & /  0.3054926E+02,  0.1889536E+01,  0.1380541E+01 /
      data (am( 5,k, 2),k=0, 2)
     & /  0.3084695E+02, -0.1212303E+02, -0.1053551E+02 /
      data (am( 6,k, 2),k=0, 2)
     & / -0.1426778E+02,  0.6239537E+01,  0.5254819E+01 /
      data (am( 7,k, 2),k=0, 2)
     & / -0.1909811E+02,  0.3695678E+01,  0.5495729E+01 /
      data (am( 8,k, 2),k=0, 2)
     & /  0.1889751E-01,  0.5027193E-02,  0.6624896E-03 /

      data mexvec( 1) / 8 /
      data mlfvec( 1) / 2 /
      data ut1vec( 1) /  0.4138426E+01 /
      data ut2vec( 1) / -0.3221374E+01 /
      data alfvec( 1) /  0.4960962E+00 /
      data qmavec( 1) /  0.0000000E+00 /
      data (am( 0,k, 1),k=0, 2)
     & /  0.1332497E+01, -0.3703718E+00,  0.1288638E+00 /
      data (am( 1,k, 1),k=0, 2)
     & /  0.7544687E+00,  0.3255075E-01, -0.4706680E-01 /
      data (am( 2,k, 1),k=0, 2)
     & / -0.7638814E+00,  0.5008313E+00, -0.9237374E-01 /
      data (am( 3,k, 1),k=0, 2)
     & / -0.3689889E+00, -0.1055098E+01, -0.4645065E+00 /
      data (am( 4,k, 1),k=0, 2)
     & /  0.3991610E+02,  0.1979881E+01,  0.1775814E+01 /
      data (am( 5,k, 1),k=0, 2)
     & /  0.6201080E+01,  0.2046288E+01,  0.3804571E+00 /
      data (am( 6,k, 1),k=0, 2)
     & / -0.8027900E+00, -0.7011688E+00, -0.8049612E+00 /
      data (am( 7,k, 1),k=0, 2)
     & / -0.8631305E+01, -0.3981200E+01,  0.6970153E+00 /
      data (am( 8,k, 1),k=0, 2)
     & /  0.2371230E-01,  0.5372683E-02,  0.1118701E-02 /

      data mexvec( 0) / 8 /
      data mlfvec( 0) / 2 /
      data ut1vec( 0) / -0.1026789E+01 /
      data ut2vec( 0) / -0.9051707E+01 /
      data alfvec( 0) /  0.9462977E+00 /
      data qmavec( 0) /  0.0000000E+00 /
      data (am( 0,k, 0),k=0, 2)
     & /  0.1191990E+03, -0.8548739E+00, -0.1963040E+01 /
      data (am( 1,k, 0),k=0, 2)
     & / -0.9449972E+02,  0.1074771E+01,  0.2056055E+01 /
      data (am( 2,k, 0),k=0, 2)
     & /  0.3701064E+01, -0.1167947E-02,  0.1933573E+00 /
      data (am( 3,k, 0),k=0, 2)
     & /  0.1171345E+03, -0.1064540E+01, -0.1875312E+01 /
      data (am( 4,k, 0),k=0, 2)
     & / -0.1014453E+03, -0.5707427E+00,  0.4511242E-01 /
      data (am( 5,k, 0),k=0, 2)
     & /  0.6365168E+01,  0.1275354E+01, -0.4964081E+00 /
      data (am( 6,k, 0),k=0, 2)
     & / -0.3370693E+01, -0.1122020E+01,  0.5947751E-01 /
      data (am( 7,k, 0),k=0, 2)
     & / -0.5327270E+01, -0.9293556E+00,  0.6629940E+00 /
      data (am( 8,k, 0),k=0, 2)
     & /  0.2437513E-01,  0.1600939E-02,  0.6855336E-03 /

      data mexvec(-1) / 8 /
      data mlfvec(-1) / 2 /
      data ut1vec(-1) /  0.5243571E+01 /
      data ut2vec(-1) / -0.2870513E+01 /
      data alfvec(-1) /  0.6701448E+00 /
      data qmavec(-1) /  0.0000000E+00 /
      data (am( 0,k,-1),k=0, 2)
     & /  0.2428863E+02,  0.1907035E+01, -0.4606457E+00 /
      data (am( 1,k,-1),k=0, 2)
     & /  0.2006810E+01, -0.1265915E+00,  0.7153556E-02 /
      data (am( 2,k,-1),k=0, 2)
     & / -0.1884546E+02, -0.2339471E+01,  0.5740679E+01 /
      data (am( 3,k,-1),k=0, 2)
     & / -0.2527892E+02, -0.2044124E+01,  0.1280470E+02 /
      data (am( 4,k,-1),k=0, 2)
     & / -0.1013824E+03, -0.1594199E+01,  0.2216401E+00 /
      data (am( 5,k,-1),k=0, 2)
     & /  0.8070930E+02,  0.1792072E+01, -0.2164364E+02 /
      data (am( 6,k,-1),k=0, 2)
     & / -0.4641050E+02,  0.1977338E+00,  0.1273014E+02 /
      data (am( 7,k,-1),k=0, 2)
     & / -0.3910568E+02,  0.1719632E+01,  0.1086525E+02 /
      data (am( 8,k,-1),k=0, 2)
     & / -0.1185496E+01, -0.1905847E+00, -0.8744118E-03 /

      data mexvec(-2) / 7 /
      data mlfvec(-2) / 2 /
      data ut1vec(-2) /  0.4782210E+01 /
      data ut2vec(-2) / -0.1976856E+02 /
      data alfvec(-2) /  0.7558374E+00 /
      data qmavec(-2) /  0.0000000E+00 /
      data (am( 0,k,-2),k=0, 2)
     & / -0.6216935E+00,  0.2369963E+00, -0.7909949E-02 /
      data (am( 1,k,-2),k=0, 2)
     & /  0.1245440E+01, -0.1031510E+00,  0.4916523E-02 /
      data (am( 2,k,-2),k=0, 2)
     & / -0.7060824E+01, -0.3875283E-01,  0.1784981E+00 /
      data (am( 3,k,-2),k=0, 2)
     & / -0.7430595E+01,  0.1964572E+00, -0.1284999E+00 /
      data (am( 4,k,-2),k=0, 2)
     & / -0.6897810E+01,  0.2620543E+01,  0.8012553E-02 /
      data (am( 5,k,-2),k=0, 2)
     & /  0.1507713E+02,  0.2340307E-01,  0.2482535E+01 /
      data (am( 6,k,-2),k=0, 2)
     & / -0.1815341E+01, -0.1538698E+01, -0.2014208E+01 /
      data (am( 7,k,-2),k=0, 2)
     & / -0.2571932E+02,  0.2903941E+00, -0.2848206E+01 /

      data mexvec(-3) / 7 /
      data mlfvec(-3) / 2 /
      data ut1vec(-3) /  0.4518239E+01 /
      data ut2vec(-3) / -0.2690590E+01 /
      data alfvec(-3) /  0.6124079E+00 /
      data qmavec(-3) /  0.0000000E+00 /
      data (am( 0,k,-3),k=0, 2)
     & / -0.2734458E+01, -0.7245673E+00, -0.6351374E+00 /
      data (am( 1,k,-3),k=0, 2)
     & /  0.2927174E+01,  0.4822709E+00, -0.1088787E-01 /
      data (am( 2,k,-3),k=0, 2)
     & / -0.1771017E+02, -0.1416635E+01,  0.8467622E+01 /
      data (am( 3,k,-3),k=0, 2)
     & / -0.4972782E+02, -0.3348547E+01,  0.1767061E+02 /
      data (am( 4,k,-3),k=0, 2)
     & / -0.7102770E+01, -0.3205337E+01,  0.4101704E+00 /
      data (am( 5,k,-3),k=0, 2)
     & /  0.7169698E+02, -0.2205985E+01, -0.2463931E+02 /
      data (am( 6,k,-3),k=0, 2)
     & / -0.4090347E+02,  0.2103486E+01,  0.1416507E+02 /
      data (am( 7,k,-3),k=0, 2)
     & / -0.2952639E+02,  0.5376136E+01,  0.7825585E+01 /

      data mexvec(-4) / 7 /
      data mlfvec(-4) / 2 /
      data ut1vec(-4) /  0.2783230E+01 /
      data ut2vec(-4) / -0.1746328E+01 /
      data alfvec(-4) /  0.1115653E+01 /
      data qmavec(-4) /  0.1300000E+01 /
      data (am( 0,k,-4),k=0, 2)
     & / -0.1743872E+01, -0.1128921E+01, -0.2841969E+00 /
      data (am( 1,k,-4),k=0, 2)
     & /  0.3345755E+01,  0.3187765E+00,  0.1378124E+00 /
      data (am( 2,k,-4),k=0, 2)
     & / -0.2037615E+02,  0.4121687E+01,  0.2236520E+00 /
      data (am( 3,k,-4),k=0, 2)
     & / -0.4703104E+02,  0.5353087E+01, -0.1455347E+01 /
      data (am( 4,k,-4),k=0, 2)
     & / -0.1060230E+02, -0.1551122E+01, -0.1078863E+01 /
      data (am( 5,k,-4),k=0, 2)
     & /  0.5088892E+02, -0.8197304E+01,  0.8083451E+01 /
      data (am( 6,k,-4),k=0, 2)
     & / -0.2819070E+02,  0.4554086E+01, -0.5890995E+01 /
      data (am( 7,k,-4),k=0, 2)
     & / -0.1098238E+02,  0.2590096E+01, -0.8062879E+01 /

      data mexvec(-5) / 6 /
      data mlfvec(-5) / 2 /
      data ut1vec(-5) /  0.1619654E+02 /
      data ut2vec(-5) / -0.3367346E+01 /
      data alfvec(-5) /  0.5109891E-02 /
      data qmavec(-5) /  0.4500000E+01 /
      data (am( 0,k,-5),k=0, 2)
     & / -0.6800138E+01,  0.2493627E+01, -0.1075724E+01 /
      data (am( 1,k,-5),k=0, 2)
     & /  0.3036555E+01,  0.3324733E+00,  0.2008298E+00 /
      data (am( 2,k,-5),k=0, 2)
     & / -0.5203879E+01, -0.8493476E+01, -0.4523208E+01 /
      data (am( 3,k,-5),k=0, 2)
     & / -0.1524239E+01, -0.3411912E+01, -0.1771867E+02 /
      data (am( 4,k,-5),k=0, 2)
     & / -0.1099444E+02,  0.1320930E+01, -0.2353831E+01 /
      data (am( 5,k,-5),k=0, 2)
     & /  0.1699299E+02, -0.3565802E+02,  0.3566872E+02 /
      data (am( 6,k,-5),k=0, 2)
     & / -0.1465793E+02,  0.2703365E+02, -0.2176372E+02 /

      if(q .le. qmavec(ifl)) then
         faux5MI = 0.d0
         return
      endif

      if(x .ge. 1.d0) then
         faux5MI = 0.d0
         return
      endif

      tmp = log(q/alfvec(ifl))
      if(tmp .le. 0.d0) then
         faux5MI = 0.d0
         return
      endif

      sb = log(tmp)
      sb1 = sb - 1.2d0
      sb2 = sb1*sb1

      do i = 0, nex
         af(i) = 0.d0
         sbx = 1.d0
         do k = 0, mlfvec(ifl)
            af(i) = af(i) + sbx*am(i,k,ifl)
            sbx = sb1*sbx
         enddo
      enddo

      y = -log(x)
      u = log(x/0.00001d0)

      part1 = af(1)*y**(1.d0+0.01d0*af(4))*(1.d0+ af(8)*u)
      part2 = af(0)*(1.d0 - x) + af(3)*x 
      part3 = x*(1.d0-x)*(af(5)+af(6)*(1.d0-x)+af(7)*x*(1.d0-x))
      part4 = ut1vec(ifl)*log(1.d0-x) + 
     &	      AF(2)*log(1.d0+exp(ut2vec(ifl))-x)

      faux5MI = exp(log(x) + part1 + part2 + part3 + part4)

c include threshold factor...
      faux5MI = faux5MI * (1.d0 - qmavec(ifl)/q)

      return
      end
