/* Copyright (C) 1995 Bjoern Beutel. */

/* Description. =============================================================*/

/* Tools for a command line interpreter. */

/* Types. ===================================================================*/

/* Use a vector of "command_t" command descriptions
 * (terminated by a {NULL, NULL} entry) as argument for "command_loop". */ 
typedef struct
{ 
  string_t names; /* The command name followed by its
                   * shortcuts, separated by spaces. */
  void (*command)( string_t arguments ); /* The command function. */
  string_t help; /* Help string or NULL. */
} command_t; 

/* Variables. ===============================================================*/

extern command_t **options;
/* The options that can be set by the set command.
 * This has to be set before executing "set_command". */

extern bool_t leave_program; /* Set to TRUE if program is to quit. */
extern bool_t leave_command_loop; /* Set to TRUE if command loop is to quit. */
extern bool_t in_command_loop; /* Set to TRUE if program is in command loop. */

/* Functions for user interrupts. ===========================================*/

extern void check_user_break( void );
/* Abort command execution if user has sent an interrupt signal. */

/* Functions for reading and executing commands. ============================*/

extern void execute_command( string_t command_line, string_t command_type,
                             command_t *commands[], bool_t use_aliases );
/* Execute COMMAND_LINE using COMMANDS.
 * If there is no such command, print an error.
 * COMMAND_TYPE may be "command" or "option" and is used for error messages.
 * If USE_ALIASES == TRUE, look for the command in the list of aliases. */

extern void execute_command_file( string_t command_file, string_t line_header, 
                                  command_t *commands[] );
/* Execute commands in COMMAND_FILE using COMMANDS.
 * If LINE_HEADER != NULL, command lines must start with LINE_HEADER. */

extern void execute_set_commands( string_t file_name, string_t prefix );
/* Execute set commands in file FILE_NAME that are prefixed with PREFIX. */

extern void free_aliases( void );
/* Free all currently defined aliases. */

/* General commands. ========================================================*/

extern command_t help_command; /* Print a command summary. */

extern command_t quit_command; /* Quit the program. */

extern command_t get_command; /* Query options. */

extern command_t set_command; /* Set options. */

extern command_t alias_option; /* Define command line abbreviations. */

/* End of file. =============================================================*/
