# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::CN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20151208171614;

my $formatters = [
                {
                  'pattern' => '(80\\d{2})(\\d{4})',
                  'leading_digits' => '80[2678]'
                },
                {
                  'pattern' => '([48]00)(\\d{3})(\\d{4})',
                  'leading_digits' => '[48]00'
                },
                {
                  'leading_digits' => '
            100|
            95
          ',
                  'pattern' => '(\\d{5,6})'
                },
                {
                  'pattern' => '(\\d{2})(\\d{5,6})',
                  'leading_digits' => '
            (?:
              10|
              2\\d
            )(?:
              100|
              9[56]
            )
          '
                },
                {
                  'leading_digits' => '
            [3-9]\\d{2}(?:
              10|
              9[56]
            )
          ',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'pattern' => '(\\d{3,4})(\\d{4})',
                  'leading_digits' => '[2-9]'
                },
                {
                  'pattern' => '(21)(\\d{4})(\\d{4,6})',
                  'leading_digits' => '21'
                },
                {
                  'leading_digits' => '
            10(?:
              [1-79]|
              8(?:
                [1-9]|
                0[1-9]
              )
            )|
            2[02-9]
          ',
                  'pattern' => '([12]\\d)(\\d{4})(\\d{4})'
                },
                {
                  'leading_digits' => '
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              31|
              5[457]|
              6[09]|
              91
            )|
            8(?:
              [57]1|
              98
            )
          ',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})',
                  'leading_digits' => '
            3(?:
              1[02-9]|
              35|
              49|
              5|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              [35][2-9]|
              6[4789]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]|
              2[248]|
              3[04-9]|
              4[3-6]|
              6[2368]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3|
              5[4-9]|
              7[02-9]|
              8[3678]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]|
              4[13]|
              5[1-5]
            )
          '
                },
                {
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})',
                  'leading_digits' => '1[3-578]'
                },
                {
                  'pattern' => '(10800)(\\d{3})(\\d{4})',
                  'leading_digits' => '10800'
                },
                {
                  'leading_digits' => '950',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                }
              ];

my $validators = {
                'toll_free' => '
          (?:
            10
          )?800\\d{7}
        ',
                'specialrate' => '(
          400\\d{7}|
          950\\d{7,8}|
          (?:
            10|
            2[0-57-9]|
            3(?:
              [157]\\d|
              35|
              49|
              9[1-68]
            )|
            4(?:
              [17]\\d|
              2[179]|
              [35][1-9]|
              6[4789]|
              8[23]
            )|
            5(?:
              [1357]\\d|
              2[37]|
              4[36]|
              6[1-46]|
              80|
              9[1-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [1579]\\d|
              2[248]|
              3[014-9]|
              4[3-6]|
              6[023689]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              [37]\\d|
              5[14-9]|
              8[3678]|
              9[1-8]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )96\\d{3,4}
        )|(16[08]\\d{5})',
                'voip' => '',
                'mobile' => '
          1(?:
            [38]\\d|
            4[57]|
            5[0-35-9]|
            7[06-8]
          )\\d{8}
        ',
                'pager' => '',
                'personal_number' => '',
                'geographic' => '
          21(?:
            100\\d{2}|
            95\\d{3,4}|
            \\d{8,10}
          )|
          (?:
            10|
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              31|
              5[457]|
              6[09]|
              91
            )|
            8(?:
              [57]1|
              98
            )
          )(?:
            100\\d{2}|
            95\\d{3,4}|
            \\d{8}
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[3-9]|
              5[2-9]|
              6[4789]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[4-9]|
              7[02-9]|
              8[3678]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            100\\d{2}|
            95\\d{3,4}|
            \\d{7}
          )|
          80(?:
            29|
            6[03578]|
            7[018]|
            81
          )\\d{4}
        ',
                'fixed_line' => '
          21(?:
            100\\d{2}|
            95\\d{3,4}|
            \\d{8,10}
          )|
          (?:
            10|
            2[02-57-9]|
            3(?:
              11|
              7[179]
            )|
            4(?:
              [15]1|
              3[12]
            )|
            5(?:
              1\\d|
              2[37]|
              3[12]|
              51|
              7[13-79]|
              9[15]
            )|
            7(?:
              31|
              5[457]|
              6[09]|
              91
            )|
            8(?:
              [57]1|
              98
            )
          )(?:
            100\\d{2}|
            95\\d{3,4}|
            \\d{8}
          )|
          (?:
            3(?:
              1[02-9]|
              35|
              49|
              5\\d|
              7[02-68]|
              9[1-68]
            )|
            4(?:
              1[02-9]|
              2[179]|
              3[3-9]|
              5[2-9]|
              6[4789]|
              7\\d|
              8[23]
            )|
            5(?:
              3[03-9]|
              4[36]|
              5[02-9]|
              6[1-46]|
              7[028]|
              80|
              9[2-46-9]
            )|
            6(?:
              3[1-5]|
              6[0238]|
              9[12]
            )|
            7(?:
              01|
              [17]\\d|
              2[248]|
              3[04-9]|
              4[3-6]|
              5[0-3689]|
              6[2368]|
              9[02-9]
            )|
            8(?:
              1[236-8]|
              2[5-7]|
              3\\d|
              5[4-9]|
              7[02-9]|
              8[3678]|
              9[1-7]
            )|
            9(?:
              0[1-3689]|
              1[1-79]|
              [379]\\d|
              4[13]|
              5[1-5]
            )
          )(?:
            100\\d{2}|
            95\\d{3,4}|
            \\d{7}
          )|
          80(?:
            29|
            6[03578]|
            7[018]|
            81
          )\\d{4}
        '
              };
sub areaname { my $self = shift; my $number = $self->{number}; my %map = (
  8610 => "Beijing",
  861300000 => "Jinan\,\ Shandong",
  861300001 => "Changzhou\,\ Jiangsu",
  861300002 => "Chaohu\,\ Anhui",
  861300006 => "Nanjing\,\ Jiangsu",
  861300008 => "Wuhan\,\ Hubei",
  861300010 => "Beijing",
  861300011 => "Beijing",
  861300012 => "Tianjin",
  861300013 => "Tianjin",
  861300014 => "Tianjin",
  861300015 => "Zibo\,\ Shandong",
  861300016 => "Yantai\,\ Shandong",
  861300017 => "Jinan\,\ Shandong",
  861300018 => "Tianjin",
  861300019 => "Tianjin",
  861300020 => "Shanghai",
  861300021 => "Shanghai",
  861300022 => "Shanghai",
  861300023 => "Shanghai",
  861300024 => "Shanghai",
  861300025 => "Nanjing\,\ Jiangsu",
  861300026 => "Nanjing\,\ Jiangsu",
  861300027 => "Yantai\,\ Shandong",
  861300028 => "Nanjing\,\ Jiangsu",
  861300029 => "Nanjing\,\ Jiangsu",
  861300030 => "Nanjing\,\ Jiangsu",
  861300031 => "Nanjing\,\ Jiangsu",
  861300032 => "Nanjing\,\ Jiangsu",
  861300033 => "Wuxi\,\ Jiangsu",
  861300034 => "Wuxi\,\ Jiangsu",
  861300035 => "Wuxi\,\ Jiangsu",
  861300036 => "Wuxi\,\ Jiangsu",
  861300037 => "Wuxi\,\ Jiangsu",
  861300038 => "Wuxi\,\ Jiangsu",
  861300039 => "Wuxi\,\ Jiangsu",
  861300040 => "Guangzhou\,\ Guangdong",
  861300041 => "Guangzhou\,\ Guangdong",
  861300042 => "Guangzhou\,\ Guangdong",
  861300043 => "Guangzhou\,\ Guangdong",
  861300044 => "Guangzhou\,\ Guangdong",
  861300045 => "Beijing",
  861300046 => "Beijing",
  861300047 => "Beijing",
  861300048 => "Beijing",
  861300049 => "Beijing",
  86130005 => "Guangzhou\,\ Guangdong",
  861300060 => "Guangzhou\,\ Guangdong",
  861300061 => "Jingmen\,\ Hubei",
  861300062 => "Guangzhou\,\ Guangdong",
  861300063 => "Guangzhou\,\ Guangdong",
  861300064 => "Guangzhou\,\ Guangdong",
  861300065 => "Weifang\,\ Shandong",
  861300066 => "Guangzhou\,\ Guangdong",
  861300067 => "Wenzhou\,\ Zhejiang",
  861300068 => "Guangzhou\,\ Guangdong",
  861300069 => "Nanning\,\ Guangxi",
  861300070 => "Guangzhou\,\ Guangdong",
  861300071 => "Wuhan\,\ Hubei",
  861300072 => "Guangzhou\,\ Guangdong",
  861300073 => "Guangzhou\,\ Guangdong",
  861300074 => "Guangzhou\,\ Guangdong",
  861300075 => "Guangzhou\,\ Guangdong",
  861300076 => "Guangzhou\,\ Guangdong",
  861300077 => "Guangzhou\,\ Guangdong",
  861300078 => "Guangzhou\,\ Guangdong",
  861300079 => "Guangzhou\,\ Guangdong",
  861300080 => "Guangzhou\,\ Guangdong",
  861300081 => "Guangzhou\,\ Guangdong",
  861300082 => "Guangzhou\,\ Guangdong",
  861300083 => "Guangzhou\,\ Guangdong",
  861300084 => "Guangzhou\,\ Guangdong",
  861300085 => "Guangzhou\,\ Guangdong",
  861300086 => "Guangzhou\,\ Guangdong",
  861300087 => "Lanzhou\,\ Gansu",
  861300088 => "Guangzhou\,\ Guangdong",
  861300089 => "Guangzhou\,\ Guangdong",
  861300091 => "Changchun\,\ Jilin",
  861300092 => "Benxi\,\ Liaoning",
  861300093 => "Yingkou\,\ Liaoning",
  861300094 => "Dalian\,\ Liaoning",
  861300095 => "Baotou\,\ Inner\ Mongolia",
  861300096 => "Urumchi\,\ Xinjiang",
  861300097 => "Jiamusi\,\ Heilongjiang",
  861300098 => "Harbin\,\ Heilongjiang",
  86130010 => "Beijing",
  86130011 => "Beijing",
  86130012 => "Beijing",
  86130013 => "Tianjin",
  861300140 => "Baoding\,\ Hebei",
  861300141 => "Tangshan\,\ Hebei",
  861300142 => "Qinhuangdao\,\ Hebei",
  861300143 => "Langfang\,\ Hebei",
  861300144 => "Cangzhou\,\ Hebei",
  861300145 => "Xingtai\,\ Hebei",
  861300146 => "Handan\,\ Hebei",
  861300147 => "Hengshui\,\ Hebei",
  861300148 => "Cangzhou\,\ Hebei",
  861300149 => "Shijiazhuang\,\ Hebei",
  861300150 => "Zibo\,\ Shandong",
  861300151 => "Zibo\,\ Shandong",
  861300152 => "Binzhou\,\ Shandong",
  861300153 => "Weifang\,\ Shandong",
  861300154 => "Weifang\,\ Shandong",
  861300155 => "Weifang\,\ Shandong",
  861300156 => "Dongying\,\ Shandong",
  861300157 => "Linyi\,\ Shandong",
  861300158 => "Rizhao\,\ Shandong",
  861300159 => "Zaozhuang\,\ Shandong",
  861300160 => "Yantai\,\ Shandong",
  861300161 => "Yantai\,\ Shandong",
  861300162 => "Yantai\,\ Shandong",
  861300163 => "Weihai\,\ Shandong",
  861300164 => "Weihai\,\ Shandong",
  861300165 => "Weihai\,\ Shandong",
  861300166 => "Qingdao\,\ Shandong",
  861300167 => "Qingdao\,\ Shandong",
  861300168 => "Qingdao\,\ Shandong",
  861300169 => "Qingdao\,\ Shandong",
  861300170 => "Jinan\,\ Shandong",
  861300171 => "Jinan\,\ Shandong",
  861300172 => "Jinan\,\ Shandong",
  861300173 => "Jinan\,\ Shandong",
  861300174 => "Jinan\,\ Shandong",
  861300175 => "Liaocheng\,\ Shandong",
  861300176 => "Dezhou\,\ Shandong",
  861300177 => "TaiAn\,\ Shandong",
  861300178 => "Jining\,\ Shandong",
  861300179 => "Heze\,\ Shandong",
  861300180 => "Shijiazhuang\,\ Hebei",
  861300181 => "Tangshan\,\ Hebei",
  861300182 => "Qinhuangdao\,\ Hebei",
  861300183 => "Langfang\,\ Hebei",
  861300184 => "Tangshan\,\ Hebei",
  861300185 => "Xingtai\,\ Hebei",
  861300186 => "Handan\,\ Hebei",
  861300187 => "Baoding\,\ Hebei",
  861300188 => "Shijiazhuang\,\ Hebei",
  861300189 => "Shijiazhuang\,\ Hebei",
  86130019 => "Beijing",
  86130020 => "Guangzhou\,\ Guangdong",
  86130021 => "Shanghai",
  86130022 => "Tianjin",
  86130023 => "Chongqing",
  86130024 => "Shenyang\,\ Liaoning",
  86130025 => "Nanjing\,\ Jiangsu",
  861300260 => "Jiaxing\,\ Zhejiang",
  861300261 => "Huzhou\,\ Zhejiang",
  861300262 => "Zhoushan\,\ Zhejiang",
  861300263 => "Shaoxing\,\ Zhejiang",
  861300264 => "Quzhou\,\ Zhejiang",
  861300265 => "Jinhua\,\ Zhejiang",
  861300266 => "Taizhou\,\ Zhejiang",
  861300267 => "Lishui\,\ Zhejiang",
  861300268 => "Wenzhou\,\ Zhejiang",
  861300269 => "Wenzhou\,\ Zhejiang",
  861300270 => "Zibo\,\ Shandong",
  861300271 => "Zibo\,\ Shandong",
  861300272 => "Yantai\,\ Shandong",
  861300273 => "Yantai\,\ Shandong",
  861300274 => "Yantai\,\ Shandong",
  861300275 => "Yantai\,\ Shandong",
  861300276 => "Laiwu\,\ Shandong",
  861300277 => "TaiAn\,\ Shandong",
  861300278 => "Weifang\,\ Shandong",
  861300279 => "Linyi\,\ Shandong",
  861300280 => "Liangshan\,\ Sichuan",
  861300281 => "Panzhihua\,\ Sichuan",
  861300282 => "Nanchong\,\ Sichuan",
  861300283 => "Suining\,\ Sichuan",
  861300284 => "Suining\,\ Sichuan",
  861300285 => "Dazhou\,\ Sichuan",
  861300286 => "Luzhou\,\ Sichuan",
  861300287 => "Neijiang\,\ Sichuan",
  861300288 => "Yibin\,\ Sichuan",
  861300289 => "Zigong\,\ Sichuan",
  86130029 => "XiAn\,\ Shaanxi",
  861300300 => "Hefei\,\ Anhui",
  861300301 => "Bengbu\,\ Anhui",
  861300302 => "Bengbu\,\ Anhui",
  861300303 => "Wuhu\,\ Anhui",
  861300304 => "Wuhu\,\ Anhui",
  861300305 => "Hefei\,\ Anhui",
  861300306 => "Hefei\,\ Anhui",
  861300307 => "Huainan\,\ Anhui",
  861300308 => "Hefei\,\ Anhui",
  861300309 => "Hefei\,\ Anhui",
  86130031 => "Shanghai",
  86130032 => "Shanghai",
  86130033 => "Wuxi\,\ Jiangsu",
  861300340 => "Nanjing\,\ Jiangsu",
  861300341 => "Nanjing\,\ Jiangsu",
  861300342 => "Nanjing\,\ Jiangsu",
  861300343 => "Zhenjiang\,\ Jiangsu",
  861300344 => "Zhenjiang\,\ Jiangsu",
  861300345 => "Zhenjiang\,\ Jiangsu",
  861300346 => "Lianyungang\,\ Jiangsu",
  861300347 => "Lianyungang\,\ Jiangsu",
  861300348 => "Yancheng\,\ Jiangsu",
  861300349 => "Suqian\,\ Jiangsu",
  861300350 => "Xuzhou\,\ Jiangsu",
  861300351 => "Xuzhou\,\ Jiangsu",
  861300352 => "Xuzhou\,\ Jiangsu",
  861300353 => "Nantong\,\ Jiangsu",
  861300354 => "HuaiAn\,\ Jiangsu",
  861300355 => "Nantong\,\ Jiangsu",
  861300356 => "Nantong\,\ Jiangsu",
  861300357 => "Nantong\,\ Jiangsu",
  861300358 => "Nantong\,\ Jiangsu",
  861300359 => "Nantong\,\ Jiangsu",
  86130036 => "Hangzhou\,\ Zhejiang",
  86130037 => "Ningbo\,\ Zhejiang",
  861300380 => "Fuzhou\,\ Fujian",
  861300381 => "Fuzhou\,\ Fujian",
  861300382 => "Fuzhou\,\ Fujian",
  861300383 => "Fuzhou\,\ Fujian",
  861300384 => "Fuzhou\,\ Fujian",
  861300385 => "Putian\,\ Fujian",
  861300386 => "Putian\,\ Fujian",
  861300387 => "Fuzhou\,\ Fujian",
  861300388 => "Fuzhou\,\ Fujian",
  861300389 => "Fuzhou\,\ Fujian",
  861300390 => "Xiamen\,\ Fujian",
  861300391 => "Xiamen\,\ Fujian",
  861300392 => "Xiamen\,\ Fujian",
  861300393 => "Xiamen\,\ Fujian",
  861300394 => "Xiamen\,\ Fujian",
  861300395 => "Zhangzhou\,\ Fujian",
  861300396 => "Zhangzhou\,\ Fujian",
  861300397 => "Xiamen\,\ Fujian",
  861300398 => "Xiamen\,\ Fujian",
  861300399 => "Xiamen\,\ Fujian",
  861300400 => "Huainan\,\ Anhui",
  861300401 => "Fuyang\,\ Anhui",
  861300402 => "Fuyang\,\ Anhui",
  861300403 => "Fuyang\,\ Anhui",
  861300404 => "Wuhu\,\ Anhui",
  861300405 => "Wuhu\,\ Anhui",
  861300406 => "Wuhu\,\ Anhui",
  861300407 => "Bengbu\,\ Anhui",
  861300408 => "Bengbu\,\ Anhui",
  861300409 => "Bengbu\,\ Anhui",
  86130041 => "Shanghai",
  861300420 => "Jiaxing\,\ Zhejiang",
  861300421 => "Jiaxing\,\ Zhejiang",
  861300422 => "Jiaxing\,\ Zhejiang",
  861300423 => "Jiaxing\,\ Zhejiang",
  861300424 => "Jiaxing\,\ Zhejiang",
  861300425 => "Huzhou\,\ Zhejiang",
  861300426 => "Huzhou\,\ Zhejiang",
  861300427 => "Huzhou\,\ Zhejiang",
  861300428 => "Hangzhou\,\ Zhejiang",
  861300429 => "Zhoushan\,\ Zhejiang",
  861300430 => "Yangzhou\,\ Jiangsu",
  861300431 => "Yangzhou\,\ Jiangsu",
  861300432 => "Yangzhou\,\ Jiangsu",
  861300433 => "Yangzhou\,\ Jiangsu",
  861300434 => "Yangzhou\,\ Jiangsu",
  861300435 => "Zhenjiang\,\ Jiangsu",
  861300436 => "Zhenjiang\,\ Jiangsu",
  861300437 => "Changzhou\,\ Jiangsu",
  861300438 => "Changzhou\,\ Jiangsu",
  861300439 => "Yangzhou\,\ Jiangsu",
  861300440 => "Changzhou\,\ Jiangsu",
  861300441 => "Changzhou\,\ Jiangsu",
  861300442 => "Changzhou\,\ Jiangsu",
  861300443 => "Changzhou\,\ Jiangsu",
  861300444 => "Taizhou\,\ Jiangsu",
  861300445 => "Taizhou\,\ Jiangsu",
  861300446 => "Taizhou\,\ Jiangsu",
  861300447 => "Yancheng\,\ Jiangsu",
  861300448 => "Yancheng\,\ Jiangsu",
  861300449 => "Yancheng\,\ Jiangsu",
  86130045 => "Suzhou\,\ Jiangsu",
  861300460 => "Shaoxing\,\ Zhejiang",
  861300461 => "Shaoxing\,\ Zhejiang",
  861300462 => "Shaoxing\,\ Zhejiang",
  861300463 => "Shaoxing\,\ Zhejiang",
  861300464 => "Jinhua\,\ Zhejiang",
  861300465 => "Jinhua\,\ Zhejiang",
  861300466 => "Jinhua\,\ Zhejiang",
  861300467 => "Jinhua\,\ Zhejiang",
  861300468 => "Quzhou\,\ Zhejiang",
  861300469 => "Lishui\,\ Zhejiang",
  861300470 => "Wenzhou\,\ Zhejiang",
  861300471 => "Wenzhou\,\ Zhejiang",
  861300472 => "Wenzhou\,\ Zhejiang",
  861300473 => "Wenzhou\,\ Zhejiang",
  861300474 => "Wenzhou\,\ Zhejiang",
  861300475 => "Wenzhou\,\ Zhejiang",
  861300476 => "Taizhou\,\ Zhejiang",
  861300477 => "Taizhou\,\ Zhejiang",
  861300478 => "Taizhou\,\ Zhejiang",
  861300479 => "Taizhou\,\ Zhejiang",
  86130048 => "Quanzhou\,\ Fujian",
  861300490 => "Sanming\,\ Fujian",
  861300491 => "Ningde\,\ Fujian",
  861300492 => "Ningde\,\ Fujian",
  861300493 => "Ningde\,\ Fujian",
  861300494 => "Nanping\,\ Fujian",
  861300495 => "Nanping\,\ Fujian",
  861300496 => "Nanping\,\ Fujian",
  861300497 => "Longyan\,\ Fujian",
  861300498 => "Longyan\,\ Fujian",
  861300499 => "Sanming\,\ Fujian",
  86130050 => "Haikou\,\ Hainan",
  86130051 => "Guangzhou\,\ Guangdong",
  861300520 => "Shantou\,\ Guangdong",
  861300521 => "Shantou\,\ Guangdong",
  861300522 => "Shantou\,\ Guangdong",
  861300523 => "Shantou\,\ Guangdong",
  861300524 => "Shantou\,\ Guangdong",
  861300525 => "Shanwei\,\ Guangdong",
  861300526 => "Jieyang\,\ Guangdong",
  861300527 => "Jieyang\,\ Guangdong",
  861300528 => "Meizhou\,\ Guangdong",
  861300529 => "Meizhou\,\ Guangdong",
  861300530 => "Heyuan\,\ Guangdong",
  861300531 => "Chaozhou\,\ Guangdong",
  861300532 => "Shantou\,\ Guangdong",
  861300533 => "Shantou\,\ Guangdong",
  861300534 => "Shantou\,\ Guangdong",
  861300535 => "Qingyuan\,\ Guangdong",
  861300536 => "Shaoguan\,\ Guangdong",
  861300537 => "Shaoguan\,\ Guangdong",
  861300538 => "Yunfu\,\ Guangdong",
  861300539 => "Yunfu\,\ Guangdong",
  86130054 => "Shenzhen\,\ Guangdong",
  861300550 => "Zhongshan\,\ Guangdong",
  861300551 => "Zhongshan\,\ Guangdong",
  861300552 => "Zhongshan\,\ Guangdong",
  861300553 => "Zhongshan\,\ Guangdong",
  861300554 => "Zhongshan\,\ Guangdong",
  861300555 => "Zhongshan\,\ Guangdong",
  861300556 => "Zhaoqing\,\ Guangdong",
  861300557 => "Zhaoqing\,\ Guangdong",
  861300558 => "Zhaoqing\,\ Guangdong",
  861300559 => "Zhaoqing\,\ Guangdong",
  861300560 => "Zhanjiang\,\ Guangdong",
  861300561 => "Zhanjiang\,\ Guangdong",
  861300562 => "Zhanjiang\,\ Guangdong",
  861300563 => "Zhanjiang\,\ Guangdong",
  861300564 => "Yangjiang\,\ Guangdong",
  861300565 => "Yangjiang\,\ Guangdong",
  861300566 => "Maoming\,\ Guangdong",
  861300567 => "Maoming\,\ Guangdong",
  861300568 => "Maoming\,\ Guangdong",
  861300569 => "Zhuhai\,\ Guangdong",
  861300570 => "Huizhou\,\ Guangdong",
  861300571 => "Huizhou\,\ Guangdong",
  861300572 => "Huizhou\,\ Guangdong",
  861300573 => "Huizhou\,\ Guangdong",
  861300574 => "Huizhou\,\ Guangdong",
  861300575 => "Huizhou\,\ Guangdong",
  861300576 => "Zhuhai\,\ Guangdong",
  861300577 => "Zhuhai\,\ Guangdong",
  861300578 => "Zhuhai\,\ Guangdong",
  861300579 => "Zhuhai\,\ Guangdong",
  86130058 => "Jiangmen\,\ Guangdong",
  861300590 => "Nanning\,\ Guangxi",
  861300591 => "Nanning\,\ Guangxi",
  861300592 => "Nanning\,\ Guangxi",
  861300593 => "Liuzhou\,\ Guangxi",
  861300594 => "Guilin\,\ Guangxi",
  861300595 => "Guilin\,\ Guangxi",
  861300596 => "Yulin\,\ Guangxi",
  861300597 => "Wuzhou\,\ Guangxi",
  861300598 => "Wuzhou\,\ Guangxi",
  861300599 => "Beihai\,\ Guangxi",
  86130060 => "Haikou\,\ Hainan",
  86130061 => "Wuhan\,\ Hubei",
  861300620 => "Nanchang\,\ Jiangxi",
  861300621 => "Nanchang\,\ Jiangxi",
  861300622 => "Yingtan\,\ Jiangxi",
  861300623 => "Yingtan\,\ Jiangxi",
  861300624 => "Yingtan\,\ Jiangxi",
  861300625 => "Shangrao\,\ Jiangxi",
  861300626 => "Yichun\,\ Jiangxi",
  861300627 => "Yichun\,\ Jiangxi",
  861300628 => "Xinyu\,\ Jiangxi",
  861300629 => "Pingxiang\,\ Jiangxi",
  86130063 => "Wuhan\,\ Hubei",
  861300640 => "Leshan\,\ Sichuan",
  861300641 => "Meishan\,\ Sichuan",
  861300642 => "Leshan\,\ Sichuan",
  861300643 => "Deyang\,\ Sichuan",
  861300644 => "Deyang\,\ Sichuan",
  861300645 => "Deyang\,\ Sichuan",
  861300646 => "Guangyuan\,\ Sichuan",
  861300647 => "Guangyuan\,\ Sichuan",
  861300648 => "Mianyang\,\ Sichuan",
  861300649 => "Mianyang\,\ Sichuan",
  861300650 => "Qingdao\,\ Shandong",
  861300651 => "Qingdao\,\ Shandong",
  861300652 => "Qingdao\,\ Shandong",
  861300653 => "Qingdao\,\ Shandong",
  861300654 => "Dongying\,\ Shandong",
  861300655 => "Weifang\,\ Shandong",
  861300656 => "Weifang\,\ Shandong",
  861300657 => "Jinan\,\ Shandong",
  861300658 => "Jinan\,\ Shandong",
  861300659 => "Jinan\,\ Shandong",
  86130066 => "Shenzhen\,\ Guangdong",
  86130067 => "Foshan\,\ Guangdong",
  861300680 => "Dongguan\,\ Guangdong",
  861300681 => "Dongguan\,\ Guangdong",
  861300682 => "Dongguan\,\ Guangdong",
  861300683 => "Dongguan\,\ Guangdong",
  861300684 => "Dongguan\,\ Guangdong",
  861300685 => "Dongguan\,\ Guangdong",
  861300686 => "Guangzhou\,\ Guangdong",
  861300687 => "Guangzhou\,\ Guangdong",
  861300688 => "Guangzhou\,\ Guangdong",
  861300689 => "Guangzhou\,\ Guangdong",
  861300690 => "Fangchenggang\,\ Guangxi",
  861300691 => "Nanning\,\ Guangxi",
  861300692 => "Liuzhou\,\ Guangxi",
  861300693 => "Guilin\,\ Guangxi",
  861300694 => "Wuzhou\,\ Guangxi",
  861300695 => "Yulin\,\ Guangxi",
  861300696 => "Baise\,\ Guangxi",
  861300697 => "Qinzhou\,\ Guangxi",
  861300698 => "Hechi\,\ Guangxi",
  861300699 => "Beihai\,\ Guangxi",
  861300700 => "Taiyuan\,\ Shanxi",
  861300701 => "Taiyuan\,\ Shanxi",
  861300702 => "Taiyuan\,\ Shanxi",
  861300703 => "Taiyuan\,\ Shanxi",
  861300704 => "Taiyuan\,\ Shanxi",
  861300705 => "Jinzhong\,\ Shanxi",
  861300706 => "Jinzhong\,\ Shanxi",
  861300707 => "Taiyuan\,\ Shanxi",
  861300708 => "Taiyuan\,\ Shanxi",
  861300709 => "Taiyuan\,\ Shanxi",
  86130071 => "Wuhan\,\ Hubei",
  861300720 => "Nanchang\,\ Jiangxi",
  861300721 => "Nanchang\,\ Jiangxi",
  861300722 => "Nanchang\,\ Jiangxi",
  861300723 => "Nanchang\,\ Jiangxi",
  861300724 => "Nanchang\,\ Jiangxi",
  861300725 => "Jiujiang\,\ Jiangxi",
  861300726 => "Jiujiang\,\ Jiangxi",
  861300727 => "Jiujiang\,\ Jiangxi",
  861300728 => "Nanchang\,\ Jiangxi",
  861300729 => "Jiujiang\,\ Jiangxi",
  861300730 => "Yueyang\,\ Hunan",
  861300731 => "Changsha\,\ Hunan",
  861300732 => "Xiangtan\,\ Hunan",
  861300733 => "Zhuzhou\,\ Hunan",
  861300734 => "Hengyang\,\ Hunan",
  861300735 => "Chenzhou\,\ Hunan",
  861300736 => "Changde\,\ Hunan",
  861300737 => "Yiyang\,\ Hunan",
  861300738 => "Loudi\,\ Hunan",
  861300739 => "Shaoyang\,\ Hunan",
  861300740 => "Changde\,\ Hunan",
  861300741 => "Changsha\,\ Hunan",
  861300742 => "Changsha\,\ Hunan",
  861300743 => "Changsha\,\ Hunan",
  861300744 => "Xiangtan\,\ Hunan",
  861300745 => "Zhuzhou\,\ Hunan",
  861300746 => "Hengyang\,\ Hunan",
  861300747 => "Yueyang\,\ Hunan",
  861300748 => "Changsha\,\ Hunan",
  861300749 => "Changsha\,\ Hunan",
  861300750 => "Zhengzhou\,\ Henan",
  861300751 => "Zhengzhou\,\ Henan",
  861300752 => "Zhengzhou\,\ Henan",
  861300753 => "Zhengzhou\,\ Henan",
  861300754 => "Zhengzhou\,\ Henan",
  861300755 => "Luoyang\,\ Henan",
  861300756 => "Luoyang\,\ Henan",
  861300757 => "Luoyang\,\ Henan",
  861300758 => "Luoyang\,\ Henan",
  861300759 => "Anyang\,\ Henan",
  861300760 => "Zhengzhou\,\ Henan",
  861300761 => "Zhengzhou\,\ Henan",
  861300762 => "Zhengzhou\,\ Henan",
  861300763 => "Luoyang\,\ Henan",
  861300764 => "Kaifeng\,\ Henan",
  861300765 => "Jiaozuo\,\ Henan",
  861300766 => "Xinxiang\,\ Henan",
  861300767 => "Xuchang\,\ Henan",
  861300768 => "Luohe\,\ Henan",
  861300769 => "Anyang\,\ Henan",
  861300770 => "Haixi\,\ Qinghai",
  861300771 => "Xining\,\ Qinghai",
  861300772 => "Haidong\,\ Qinghai",
  861300773 => "Haidong\,\ Qinghai",
  861300774 => "Hainan\,\ Qinghai",
  861300775 => "Haibei\,\ Qinghai",
  861300776 => "Xining\,\ Qinghai",
  861300777 => "Xining\,\ Qinghai",
  861300778 => "Xining\,\ Qinghai",
  861300779 => "Xining\,\ Qinghai",
  861300780 => "Guiyang\,\ Guizhou",
  861300781 => "Guiyang\,\ Guizhou",
  861300782 => "Guiyang\,\ Guizhou",
  861300783 => "Guiyang\,\ Guizhou",
  861300784 => "Guiyang\,\ Guizhou",
  861300785 => "Guiyang\,\ Guizhou",
  861300786 => "Guiyang\,\ Guizhou",
  861300787 => "Zunyi\,\ Guizhou",
  861300788 => "Guiyang\,\ Guizhou",
  861300789 => "Anshun\,\ Guizhou",
  861300790 => "Shizuishan\,\ Ningxia",
  861300791 => "Shizuishan\,\ Ningxia",
  861300792 => "Wuzhong\,\ Ningxia",
  861300793 => "Wuzhong\,\ Ningxia",
  861300794 => "Guyuan\,\ Ningxia",
  861300795 => "Guyuan\,\ Ningxia",
  861300796 => "Yinchuan\,\ Ningxia",
  861300797 => "Yinchuan\,\ Ningxia",
  861300798 => "Yinchuan\,\ Ningxia",
  861300799 => "Yinchuan\,\ Ningxia",
  861300800 => "Yuncheng\,\ Shanxi",
  861300801 => "Yuncheng\,\ Shanxi",
  861300802 => "Linfen\,\ Shanxi",
  861300803 => "Linfen\,\ Shanxi",
  861300804 => "Datong\,\ Shanxi",
  861300805 => "Jincheng\,\ Shanxi",
  861300806 => "Changzhi\,\ Shanxi",
  861300807 => "Changzhi\,\ Shanxi",
  861300808 => "Datong\,\ Shanxi",
  861300809 => "Datong\,\ Shanxi",
  86130081 => "Chengdu\,\ Sichuan",
  861300820 => "Liaoyang\,\ Liaoning",
  861300821 => "Fuxin\,\ Liaoning",
  861300822 => "Panjin\,\ Liaoning",
  861300823 => "Panjin\,\ Liaoning",
  861300824 => "Chaoyang\,\ Liaoning",
  861300825 => "Panjin\,\ Liaoning",
  861300826 => "Jinzhou\,\ Liaoning",
  861300827 => "Tieling\,\ Liaoning",
  861300828 => "Liaoyang\,\ Liaoning",
  861300829 => "Fuxin\,\ Liaoning",
  86130083 => "Chongqing",
  861300840 => "XiAn\,\ Shaanxi",
  861300841 => "XiAn\,\ Shaanxi",
  861300842 => "XiAn\,\ Shaanxi",
  861300843 => "Weinan\,\ Shaanxi",
  861300844 => "Xianyang\,\ Shaanxi",
  861300845 => "Hanzhong\,\ Shaanxi",
  861300846 => "Hanzhong\,\ Shaanxi",
  861300847 => "Baoji\,\ Shaanxi",
  861300848 => "Baoji\,\ Shaanxi",
  861300849 => "Baoji\,\ Shaanxi",
  861300850 => "Tongchuan\,\ Shaanxi",
  861300851 => "Tongchuan\,\ Shaanxi",
  861300852 => "Weinan\,\ Shaanxi",
  861300853 => "Weinan\,\ Shaanxi",
  861300854 => "Xianyang\,\ Shaanxi",
  861300855 => "Xianyang\,\ Shaanxi",
  861300856 => "Xianyang\,\ Shaanxi",
  861300857 => "YanAn\,\ Shaanxi",
  861300858 => "YanAn\,\ Shaanxi",
  861300859 => "YanAn\,\ Shaanxi",
  861300860 => "Honghe\,\ Yunnan",
  861300861 => "Honghe\,\ Yunnan",
  861300862 => "Chuxiong\,\ Yunnan",
  861300863 => "Qujing\,\ Yunnan",
  861300864 => "Yuxi\,\ Yunnan",
  861300865 => "Kunming\,\ Yunnan",
  861300866 => "Kunming\,\ Yunnan",
  861300867 => "Kunming\,\ Yunnan",
  861300868 => "Kunming\,\ Yunnan",
  861300869 => "Kunming\,\ Yunnan",
  86130087 => "Lanzhou\,\ Gansu",
  86130088 => "Shenzhen\,\ Guangdong",
  86130089 => "Ningbo\,\ Zhejiang",
  861300900 => "Changchun\,\ Jilin",
  861300901 => "Changchun\,\ Jilin",
  861300902 => "Siping\,\ Jilin",
  861300903 => "Siping\,\ Jilin",
  861300904 => "Liaoyuan\,\ Jilin",
  861300905 => "Songyuan\,\ Jilin",
  861300906 => "Baicheng\,\ Jilin",
  861300907 => "Baishan\,\ Jilin",
  861300908 => "Yanbian\,\ Jilin",
  861300909 => "Yanbian\,\ Jilin",
  861300910 => "Changchun\,\ Jilin",
  861300911 => "Changchun\,\ Jilin",
  861300912 => "Changchun\,\ Jilin",
  861300913 => "Changchun\,\ Jilin",
  861300914 => "Changchun\,\ Jilin",
  861300915 => "Jilin\,\ Jilin",
  861300916 => "Jilin\,\ Jilin",
  861300917 => "Jilin\,\ Jilin",
  861300918 => "Jilin\,\ Jilin",
  861300919 => "Tonghua\,\ Jilin",
  861300920 => "Dandong\,\ Liaoning",
  861300921 => "Dandong\,\ Liaoning",
  861300922 => "Benxi\,\ Liaoning",
  861300923 => "Benxi\,\ Liaoning",
  861300924 => "Fushun\,\ Liaoning",
  861300925 => "Fushun\,\ Liaoning",
  861300926 => "Fushun\,\ Liaoning",
  861300927 => "Tieling\,\ Liaoning",
  861300928 => "Huludao\,\ Liaoning",
  861300929 => "Huludao\,\ Liaoning",
  861300930 => "Yingkou\,\ Liaoning",
  861300931 => "Yingkou\,\ Liaoning",
  861300932 => "Yingkou\,\ Liaoning",
  861300933 => "Jinzhou\,\ Liaoning",
  861300934 => "Jinzhou\,\ Liaoning",
  861300935 => "Jinzhou\,\ Liaoning",
  861300936 => "Anshan\,\ Liaoning",
  861300937 => "Anshan\,\ Liaoning",
  861300938 => "Anshan\,\ Liaoning",
  861300939 => "Anshan\,\ Liaoning",
  86130094 => "Dalian\,\ Liaoning",
  861300950 => "Hohhot\,\ Inner\ Mongolia",
  861300951 => "Hohhot\,\ Inner\ Mongolia",
  861300952 => "Hohhot\,\ Inner\ Mongolia",
  861300953 => "Ulanqab\,\ Inner\ Mongolia",
  861300954 => "Baotou\,\ Inner\ Mongolia",
  861300955 => "Baotou\,\ Inner\ Mongolia",
  861300956 => "Baotou\,\ Inner\ Mongolia",
  861300957 => "Ordos\,\ Inner\ Mongolia",
  861300958 => "Bayannur\,\ Inner\ Mongolia",
  861300959 => "Wuhai\,\ Inner\ Mongolia",
  861300960 => "Changji\,\ Xinjiang",
  861300961 => "Urumchi\,\ Xinjiang",
  861300962 => "Urumchi\,\ Xinjiang",
  861300963 => "Urumchi\,\ Xinjiang",
  861300964 => "Urumchi\,\ Xinjiang",
  861300965 => "Urumchi\,\ Xinjiang",
  861300966 => "Urumchi\,\ Xinjiang",
  861300967 => "Urumchi\,\ Xinjiang",
  861300968 => "Urumchi\,\ Xinjiang",
  861300969 => "Urumchi\,\ Xinjiang",
  861300970 => "Harbin\,\ Heilongjiang",
  861300971 => "Harbin\,\ Heilongjiang",
  861300972 => "Harbin\,\ Heilongjiang",
  861300973 => "Qiqihar\,\ Heilongjiang",
  861300974 => "Qiqihar\,\ Heilongjiang",
  861300975 => "Qiqihar\,\ Heilongjiang",
  861300976 => "Jiamusi\,\ Heilongjiang",
  861300977 => "Jiamusi\,\ Heilongjiang",
  861300978 => "Jiamusi\,\ Heilongjiang",
  861300979 => "Mudanjiang\,\ Heilongjiang",
  861300980 => "Harbin\,\ Heilongjiang",
  861300981 => "Daqing\,\ Heilongjiang",
  861300982 => "Daqing\,\ Heilongjiang",
  861300983 => "Daqing\,\ Heilongjiang",
  861300984 => "Harbin\,\ Heilongjiang",
  861300985 => "Harbin\,\ Heilongjiang",
  861300986 => "Harbin\,\ Heilongjiang",
  861300987 => "Harbin\,\ Heilongjiang",
  861300988 => "Mudanjiang\,\ Heilongjiang",
  861300989 => "Mudanjiang\,\ Heilongjiang",
  861300990 => "Daqing\,\ Heilongjiang",
  861300991 => "Suihua\,\ Heilongjiang",
  861300992 => "Suihua\,\ Heilongjiang",
  861300993 => "Heihe\,\ Heilongjiang",
  861300994 => "Heihe\,\ Heilongjiang",
  861300995 => "Jixi\,\ Heilongjiang",
  861300996 => "Qitaihe\,\ Heilongjiang",
  861300997 => "Hegang\,\ Heilongjiang",
  861300998 => "Shuangyashan\,\ Heilongjiang",
  861300999 => "Harbin\,\ Heilongjiang",
  861301000 => "Shanghai",
  861301006 => "Beijing",
  861301007 => "Beijing",
  861301008 => "Beijing",
  861301009 => "Beijing",
  861301010 => "Beijing",
  861301011 => "Beijing",
  861301012 => "Beijing",
  861301013 => "Tianjin",
  861301014 => "Hengshui\,\ Hebei",
  861301015 => "Zibo\,\ Shandong",
  861301016 => "Yantai\,\ Shandong",
  861301017 => "Jinan\,\ Shandong",
  861301018 => "Shijiazhuang\,\ Hebei",
  861301019 => "Beijing",
  861301020 => "Guangzhou\,\ Guangdong",
  861301024 => "Shenyang\,\ Liaoning",
  861301027 => "Laiwu\,\ Shandong",
  861301030 => "Hefei\,\ Anhui",
  861301031 => "Shanghai",
  861301033 => "Wuxi\,\ Jiangsu",
  861301034 => "Nanjing\,\ Jiangsu",
  861301035 => "Xuzhou\,\ Jiangsu",
  861301036 => "Hangzhou\,\ Zhejiang",
  861301037 => "Ningbo\,\ Zhejiang",
  861301038 => "Fuzhou\,\ Fujian",
  861301039 => "Xiamen\,\ Fujian",
  861301042 => "Jiaxing\,\ Zhejiang",
  861301043 => "Yangzhou\,\ Jiangsu",
  861301044 => "Changzhou\,\ Jiangsu",
  861301045 => "Suzhou\,\ Jiangsu",
  861301046 => "Shaoxing\,\ Zhejiang",
  861301047 => "Wenzhou\,\ Zhejiang",
  861301048 => "Quanzhou\,\ Fujian",
  861301049 => "Ningde\,\ Fujian",
  861301050 => "Haikou\,\ Hainan",
  861301051 => "Guangzhou\,\ Guangdong",
  861301052 => "Shantou\,\ Guangdong",
  861301053 => "Shaoguan\,\ Guangdong",
  861301054 => "Shenzhen\,\ Guangdong",
  861301055 => "Zhongshan\,\ Guangdong",
  861301056 => "Zhanjiang\,\ Guangdong",
  861301057 => "Huizhou\,\ Guangdong",
  861301058 => "Jiangmen\,\ Guangdong",
  861301059 => "Nanning\,\ Guangxi",
  861301062 => "Yingtan\,\ Jiangxi",
  861301064 => "Leshan\,\ Sichuan",
  861301066 => "Guangzhou\,\ Guangdong",
  861301067 => "Foshan\,\ Guangdong",
  861301068 => "Dongguan\,\ Guangdong",
  861301070 => "Taiyuan\,\ Shanxi",
  861301071 => "Wuhan\,\ Hubei",
  861301072 => "Nanchang\,\ Jiangxi",
  861301073 => "Yueyang\,\ Hunan",
  861301074 => "Changsha\,\ Hunan",
  861301075 => "Shenzhen\,\ Guangdong",
  861301076 => "Zhengzhou\,\ Henan",
  861301077 => "Wuhan\,\ Hubei",
  861301078 => "Guiyang\,\ Guizhou",
  861301079 => "Yinchuan\,\ Ningxia",
  861301081 => "Chengdu\,\ Sichuan",
  861301082 => "Liaoyang\,\ Liaoning",
  861301083 => "Chongqing",
  861301084 => "XiAn\,\ Shaanxi",
  861301085 => "XiAn\,\ Shaanxi",
  861301086 => "Kunming\,\ Yunnan",
  861301087 => "Lanzhou\,\ Gansu",
  861301088 => "Shenzhen\,\ Guangdong",
  861301089 => "Shenzhen\,\ Guangdong",
  861301091 => "Changchun\,\ Jilin",
  861301092 => "Dandong\,\ Liaoning",
  861301093 => "Yingkou\,\ Liaoning",
  861301094 => "Dalian\,\ Liaoning",
  861301095 => "Hohhot\,\ Inner\ Mongolia",
  861301096 => "Urumchi\,\ Xinjiang",
  861301097 => "Qiqihar\,\ Heilongjiang",
  861301098 => "Harbin\,\ Heilongjiang",
  86130110 => "Beijing",
  86130111 => "Beijing",
  86130112 => "Beijing",
  86130113 => "Tianjin",
  861301140 => "Baoding\,\ Hebei",
  861301141 => "Baoding\,\ Hebei",
  861301142 => "Cangzhou\,\ Hebei",
  861301143 => "Tangshan\,\ Hebei",
  861301144 => "Tangshan\,\ Hebei",
  861301145 => "Xingtai\,\ Hebei",
  861301146 => "Qinhuangdao\,\ Hebei",
  861301147 => "Qinhuangdao\,\ Hebei",
  861301148 => "Langfang\,\ Hebei",
  861301149 => "Handan\,\ Hebei",
  861301150 => "Tangshan\,\ Hebei",
  861301151 => "Tangshan\,\ Hebei",
  861301152 => "Tangshan\,\ Hebei",
  861301153 => "Handan\,\ Hebei",
  861301154 => "Handan\,\ Hebei",
  861301155 => "Shijiazhuang\,\ Hebei",
  861301156 => "Shijiazhuang\,\ Hebei",
  861301157 => "Shijiazhuang\,\ Hebei",
  861301158 => "Shijiazhuang\,\ Hebei",
  861301159 => "Shijiazhuang\,\ Hebei",
  861301160 => "Zibo\,\ Shandong",
  861301161 => "Zibo\,\ Shandong",
  861301162 => "Zibo\,\ Shandong",
  861301163 => "Zibo\,\ Shandong",
  861301164 => "Zibo\,\ Shandong",
  861301165 => "Weifang\,\ Shandong",
  861301166 => "Weifang\,\ Shandong",
  861301167 => "Weifang\,\ Shandong",
  861301168 => "Weifang\,\ Shandong",
  861301169 => "Weifang\,\ Shandong",
  861301170 => "Jinan\,\ Shandong",
  861301171 => "Jinan\,\ Shandong",
  861301172 => "Jinan\,\ Shandong",
  861301173 => "Jinan\,\ Shandong",
  861301174 => "Jinan\,\ Shandong",
  861301175 => "Dezhou\,\ Shandong",
  861301176 => "Dezhou\,\ Shandong",
  861301177 => "TaiAn\,\ Shandong",
  861301178 => "TaiAn\,\ Shandong",
  861301179 => "Binzhou\,\ Shandong",
  86130118 => "Beijing",
  861301190 => "Baoding\,\ Hebei",
  861301191 => "Baoding\,\ Hebei",
  861301192 => "Baoding\,\ Hebei",
  861301193 => "Langfang\,\ Hebei",
  861301194 => "Langfang\,\ Hebei",
  861301195 => "Xingtai\,\ Hebei",
  861301196 => "Qinhuangdao\,\ Hebei",
  861301197 => "Qinhuangdao\,\ Hebei",
  861301198 => "Cangzhou\,\ Hebei",
  861301199 => "Cangzhou\,\ Hebei",
  861301200 => "Langfang\,\ Hebei",
  861301201 => "Tangshan\,\ Hebei",
  861301202 => "Cangzhou\,\ Hebei",
  861301203 => "Cangzhou\,\ Hebei",
  861301204 => "Cangzhou\,\ Hebei",
  861301205 => "Baoding\,\ Hebei",
  861301206 => "Baoding\,\ Hebei",
  861301207 => "Baoding\,\ Hebei",
  861301208 => "Langfang\,\ Hebei",
  861301209 => "Hengshui\,\ Hebei",
  861301210 => "Handan\,\ Hebei",
  861301211 => "Handan\,\ Hebei",
  861301212 => "Xingtai\,\ Hebei",
  861301213 => "Xingtai\,\ Hebei",
  861301214 => "Shijiazhuang\,\ Hebei",
  861301215 => "Shijiazhuang\,\ Hebei",
  861301216 => "Shijiazhuang\,\ Hebei",
  861301217 => "Tangshan\,\ Hebei",
  861301218 => "Qinhuangdao\,\ Hebei",
  861301219 => "Tangshan\,\ Hebei",
  86130122 => "Tianjin",
  86130123 => "Chongqing",
  86130124 => "Qingdao\,\ Shandong",
  861301250 => "Qingdao\,\ Shandong",
  861301251 => "Qingdao\,\ Shandong",
  861301252 => "Qingdao\,\ Shandong",
  861301253 => "Qingdao\,\ Shandong",
  861301254 => "Qingdao\,\ Shandong",
  861301255 => "Qingdao\,\ Shandong",
  861301256 => "Yantai\,\ Shandong",
  861301257 => "Yantai\,\ Shandong",
  861301258 => "Yantai\,\ Shandong",
  861301259 => "Yantai\,\ Shandong",
  861301260 => "Jining\,\ Shandong",
  861301261 => "Jining\,\ Shandong",
  861301262 => "Jining\,\ Shandong",
  861301263 => "Jining\,\ Shandong",
  861301264 => "Jining\,\ Shandong",
  861301265 => "Jining\,\ Shandong",
  861301266 => "Zaozhuang\,\ Shandong",
  861301267 => "Zaozhuang\,\ Shandong",
  861301268 => "Liaocheng\,\ Shandong",
  861301269 => "Heze\,\ Shandong",
  861301270 => "Zibo\,\ Shandong",
  861301271 => "Zibo\,\ Shandong",
  861301272 => "Binzhou\,\ Shandong",
  861301273 => "Weihai\,\ Shandong",
  861301274 => "TaiAn\,\ Shandong",
  861301275 => "Laiwu\,\ Shandong",
  861301276 => "Dezhou\,\ Shandong",
  861301277 => "Rizhao\,\ Shandong",
  861301278 => "Liaocheng\,\ Shandong",
  861301279 => "Linyi\,\ Shandong",
  86130128 => "Shanghai",
  861301290 => "Dongying\,\ Shandong",
  861301291 => "Dongying\,\ Shandong",
  861301292 => "Jining\,\ Shandong",
  861301293 => "Jining\,\ Shandong",
  861301294 => "Qingdao\,\ Shandong",
  861301295 => "Qingdao\,\ Shandong",
  861301296 => "Heze\,\ Shandong",
  861301297 => "Zaozhuang\,\ Shandong",
  861301298 => "Jinan\,\ Shandong",
  861301299 => "Jinan\,\ Shandong",
  861301300 => "Chuzhou\,\ Anhui",
  861301301 => "Chuzhou\,\ Anhui",
  861301302 => "Chuzhou\,\ Anhui",
  861301303 => "Hefei\,\ Anhui",
  861301304 => "Chizhou\,\ Anhui",
  861301305 => "Huainan\,\ Anhui",
  861301306 => "Hefei\,\ Anhui",
  861301307 => "Hefei\,\ Anhui",
  861301308 => "Hefei\,\ Anhui",
  861301309 => "Hefei\,\ Anhui",
  861301310 => "MaAnshan\,\ Anhui",
  861301311 => "MaAnshan\,\ Anhui",
  861301312 => "Huangshan\,\ Anhui",
  861301313 => "Xuancheng\,\ Anhui",
  861301314 => "Xuancheng\,\ Anhui",
  861301315 => "Tongling\,\ Anhui",
  861301316 => "Anqing\,\ Anhui",
  861301317 => "Anqing\,\ Anhui",
  861301318 => "Anqing\,\ Anhui",
  861301319 => "Anqing\,\ Anhui",
  861301320 => "Handan\,\ Hebei",
  861301321 => "Langfang\,\ Hebei",
  861301322 => "Cangzhou\,\ Hebei",
  861301323 => "Shijiazhuang\,\ Hebei",
  861301324 => "Baoding\,\ Hebei",
  861301325 => "Baoding\,\ Hebei",
  861301326 => "Qinhuangdao\,\ Hebei",
  861301327 => "Hengshui\,\ Hebei",
  861301328 => "Tangshan\,\ Hebei",
  861301329 => "Xingtai\,\ Hebei",
  861301330 => "Kunming\,\ Yunnan",
  861301331 => "Kunming\,\ Yunnan",
  861301332 => "Kunming\,\ Yunnan",
  861301333 => "Kunming\,\ Yunnan",
  861301334 => "Qujing\,\ Yunnan",
  861301335 => "Kunming\,\ Yunnan",
  861301336 => "Dali\,\ Yunnan",
  861301337 => "Yuxi\,\ Yunnan",
  861301338 => "Lijiang\,\ Yunnan",
  861301339 => "Dali\,\ Yunnan",
  861301340 => "Honghe\,\ Yunnan",
  861301341 => "Honghe\,\ Yunnan",
  861301342 => "Chuxiong\,\ Yunnan",
  861301343 => "Chuxiong\,\ Yunnan",
  861301344 => "Dali\,\ Yunnan",
  861301345 => "Qujing\,\ Yunnan",
  861301346 => "Qujing\,\ Yunnan",
  861301347 => "Lijiang\,\ Yunnan",
  861301348 => "Yuxi\,\ Yunnan",
  861301349 => "Yuxi\,\ Yunnan",
  861301350 => "Linyi\,\ Shandong",
  861301351 => "Linyi\,\ Shandong",
  861301352 => "Linyi\,\ Shandong",
  861301353 => "Linyi\,\ Shandong",
  861301354 => "Linyi\,\ Shandong",
  861301355 => "Linyi\,\ Shandong",
  861301356 => "Dongying\,\ Shandong",
  861301357 => "Weihai\,\ Shandong",
  861301358 => "Weihai\,\ Shandong",
  861301359 => "Rizhao\,\ Shandong",
  86130136 => "Wuxi\,\ Jiangsu",
  861301370 => "Yangzhou\,\ Jiangsu",
  861301371 => "Yangzhou\,\ Jiangsu",
  861301372 => "Yangzhou\,\ Jiangsu",
  861301373 => "Yangzhou\,\ Jiangsu",
  861301374 => "Yangzhou\,\ Jiangsu",
  861301375 => "Suzhou\,\ Jiangsu",
  861301376 => "Suzhou\,\ Jiangsu",
  861301377 => "Suzhou\,\ Jiangsu",
  861301378 => "Suzhou\,\ Jiangsu",
  861301379 => "Suzhou\,\ Jiangsu",
  86130138 => "Suzhou\,\ Jiangsu",
  861301390 => "Suqian\,\ Jiangsu",
  861301391 => "Suqian\,\ Jiangsu",
  861301392 => "Suqian\,\ Jiangsu",
  861301393 => "Xuzhou\,\ Jiangsu",
  861301394 => "Xuzhou\,\ Jiangsu",
  861301395 => "Xuzhou\,\ Jiangsu",
  861301396 => "Xuzhou\,\ Jiangsu",
  861301397 => "Xuzhou\,\ Jiangsu",
  861301398 => "Xuzhou\,\ Jiangsu",
  861301399 => "Xuzhou\,\ Jiangsu",
  861301400 => "Suzhou\,\ Anhui",
  861301401 => "Suzhou\,\ Anhui",
  861301402 => "LuAn\,\ Anhui",
  861301403 => "LuAn\,\ Anhui",
  861301404 => "Huaibei\,\ Anhui",
  861301405 => "Huaibei\,\ Anhui",
  861301406 => "Fuyang\,\ Anhui",
  861301407 => "Fuyang\,\ Anhui",
  861301408 => "Fuyang\,\ Anhui",
  861301409 => "Fuyang\,\ Anhui",
  861301410 => "Jiayuguan\,\ Gansu",
  861301411 => "Zhangye\,\ Gansu",
  861301412 => "Zhangye\,\ Gansu",
  861301413 => "Wuwei\,\ Gansu",
  861301414 => "Lanzhou\,\ Gansu",
  861301415 => "Wuwei\,\ Gansu",
  861301416 => "Wuwei\,\ Gansu",
  861301417 => "Wuwei\,\ Gansu",
  861301418 => "Jiayuguan\,\ Gansu",
  861301419 => "Jiayuguan\,\ Gansu",
  861301420 => "Shizuishan\,\ Ningxia",
  861301421 => "Shizuishan\,\ Ningxia",
  861301422 => "Wuzhong\,\ Ningxia",
  861301423 => "Wuzhong\,\ Ningxia",
  861301424 => "Wuzhong\,\ Ningxia",
  861301425 => "Yinchuan\,\ Ningxia",
  861301426 => "Yinchuan\,\ Ningxia",
  861301427 => "Yinchuan\,\ Ningxia",
  861301428 => "Yinchuan\,\ Ningxia",
  861301429 => "Yinchuan\,\ Ningxia",
  861301430 => "Baoding\,\ Hebei",
  861301431 => "Tangshan\,\ Hebei",
  861301432 => "Tangshan\,\ Hebei",
  861301433 => "Shijiazhuang\,\ Hebei",
  861301434 => "Shijiazhuang\,\ Hebei",
  861301435 => "Shijiazhuang\,\ Hebei",
  861301436 => "Shijiazhuang\,\ Hebei",
  861301437 => "Shijiazhuang\,\ Hebei",
  861301438 => "Shijiazhuang\,\ Hebei",
  861301439 => "Shijiazhuang\,\ Hebei",
  861301440 => "Yingtan\,\ Jiangxi",
  861301441 => "Yingtan\,\ Jiangxi",
  861301442 => "Shangrao\,\ Jiangxi",
  861301443 => "Shangrao\,\ Jiangxi",
  861301444 => "Shangrao\,\ Jiangxi",
  861301445 => "Yichun\,\ Jiangxi",
  861301446 => "Yichun\,\ Jiangxi",
  861301447 => "Yichun\,\ Jiangxi",
  861301448 => "Yichun\,\ Jiangxi",
  861301449 => "Yichun\,\ Jiangxi",
  86130145 => "Zhengzhou\,\ Henan",
  86130146 => "Zhengzhou\,\ Henan",
  86130147 => "Luoyang\,\ Henan",
  861301480 => "Fangchenggang\,\ Guangxi",
  861301481 => "Guigang\,\ Guangxi",
  861301482 => "Guigang\,\ Guangxi",
  861301483 => "Beihai\,\ Guangxi",
  861301484 => "Beihai\,\ Guangxi",
  861301485 => "Guilin\,\ Guangxi",
  861301486 => "Guilin\,\ Guangxi",
  861301487 => "Liuzhou\,\ Guangxi",
  861301488 => "Liuzhou\,\ Guangxi",
  861301489 => "Liuzhou\,\ Guangxi",
  861301490 => "Nanning\,\ Guangxi",
  861301491 => "Nanning\,\ Guangxi",
  861301492 => "Yulin\,\ Guangxi",
  861301493 => "Liuzhou\,\ Guangxi",
  861301494 => "Hezhou\,\ Guangxi",
  861301495 => "Yulin\,\ Guangxi",
  861301496 => "Yulin\,\ Guangxi",
  861301497 => "Qinzhou\,\ Guangxi",
  861301498 => "Nanning\,\ Guangxi",
  861301499 => "Nanning\,\ Guangxi",
  861301500 => "Hohhot\,\ Inner\ Mongolia",
  861301501 => "Hohhot\,\ Inner\ Mongolia",
  861301502 => "Hohhot\,\ Inner\ Mongolia",
  861301503 => "Ulanqab\,\ Inner\ Mongolia",
  861301504 => "Baotou\,\ Inner\ Mongolia",
  861301505 => "Baotou\,\ Inner\ Mongolia",
  861301506 => "Baotou\,\ Inner\ Mongolia",
  861301507 => "Ordos\,\ Inner\ Mongolia",
  861301508 => "Bayannur\,\ Inner\ Mongolia",
  861301509 => "Wuhai\,\ Inner\ Mongolia",
  861301510 => "Hohhot\,\ Inner\ Mongolia",
  861301511 => "Hulun\,\ Inner\ Mongolia",
  861301512 => "Hulun\,\ Inner\ Mongolia",
  861301513 => "Tongliao\,\ Inner\ Mongolia",
  861301514 => "Tongliao\,\ Inner\ Mongolia",
  861301515 => "Baotou\,\ Inner\ Mongolia",
  861301516 => "Baotou\,\ Inner\ Mongolia",
  861301517 => "Ordos\,\ Inner\ Mongolia",
  861301518 => "Chifeng\,\ Inner\ Mongolia",
  861301519 => "Chifeng\,\ Inner\ Mongolia",
  861301520 => "Hohhot\,\ Inner\ Mongolia",
  861301521 => "Hohhot\,\ Inner\ Mongolia",
  861301522 => "Hohhot\,\ Inner\ Mongolia",
  861301523 => "Ulanqab\,\ Inner\ Mongolia",
  861301524 => "Baotou\,\ Inner\ Mongolia",
  861301525 => "Baotou\,\ Inner\ Mongolia",
  861301526 => "Baotou\,\ Inner\ Mongolia",
  861301527 => "Ordos\,\ Inner\ Mongolia",
  861301528 => "Bayannur\,\ Inner\ Mongolia",
  861301529 => "Chifeng\,\ Inner\ Mongolia",
  861301530 => "Taiyuan\,\ Shanxi",
  861301531 => "Yuncheng\,\ Shanxi",
  861301532 => "Linfen\,\ Shanxi",
  861301533 => "Jinzhong\,\ Shanxi",
  861301534 => "Taiyuan\,\ Shanxi",
  861301535 => "Jincheng\,\ Shanxi",
  861301536 => "Changzhi\,\ Shanxi",
  861301537 => "Taiyuan\,\ Shanxi",
  861301538 => "Taiyuan\,\ Shanxi",
  861301539 => "Datong\,\ Shanxi",
  861301540 => "Taiyuan\,\ Shanxi",
  861301541 => "Yuncheng\,\ Shanxi",
  861301542 => "Linfen\,\ Shanxi",
  861301543 => "Jinzhong\,\ Shanxi",
  861301544 => "Taiyuan\,\ Shanxi",
  861301545 => "Jincheng\,\ Shanxi",
  861301546 => "Changzhi\,\ Shanxi",
  861301547 => "Taiyuan\,\ Shanxi",
  861301548 => "Taiyuan\,\ Shanxi",
  861301549 => "Datong\,\ Shanxi",
  861301550 => "Zhengzhou\,\ Henan",
  861301551 => "Zhengzhou\,\ Henan",
  861301552 => "Zhengzhou\,\ Henan",
  861301553 => "Zhengzhou\,\ Henan",
  861301554 => "Zhengzhou\,\ Henan",
  861301555 => "Luoyang\,\ Henan",
  861301556 => "Luoyang\,\ Henan",
  861301557 => "Luoyang\,\ Henan",
  861301558 => "Luoyang\,\ Henan",
  861301559 => "Luoyang\,\ Henan",
  861301560 => "Longyan\,\ Fujian",
  861301561 => "Zhangzhou\,\ Fujian",
  861301562 => "Zhangzhou\,\ Fujian",
  861301563 => "Zhangzhou\,\ Fujian",
  861301564 => "Zhangzhou\,\ Fujian",
  861301565 => "Zhangzhou\,\ Fujian",
  861301566 => "Zhangzhou\,\ Fujian",
  861301567 => "Zhangzhou\,\ Fujian",
  861301568 => "Sanming\,\ Fujian",
  861301569 => "Nanping\,\ Fujian",
  861301570 => "Ningde\,\ Fujian",
  861301571 => "Fuzhou\,\ Fujian",
  861301572 => "Fuzhou\,\ Fujian",
  861301573 => "Fuzhou\,\ Fujian",
  861301574 => "Fuzhou\,\ Fujian",
  861301575 => "Fuzhou\,\ Fujian",
  861301576 => "Fuzhou\,\ Fujian",
  861301577 => "Fuzhou\,\ Fujian",
  861301578 => "Fuzhou\,\ Fujian",
  861301579 => "Ningde\,\ Fujian",
  861301580 => "Ningde\,\ Fujian",
  861301581 => "Quanzhou\,\ Fujian",
  861301582 => "Quanzhou\,\ Fujian",
  861301583 => "Quanzhou\,\ Fujian",
  861301584 => "Quanzhou\,\ Fujian",
  861301585 => "Quanzhou\,\ Fujian",
  861301586 => "Quanzhou\,\ Fujian",
  861301587 => "Quanzhou\,\ Fujian",
  861301588 => "Quanzhou\,\ Fujian",
  861301589 => "Ningde\,\ Fujian",
  861301590 => "Putian\,\ Fujian",
  861301591 => "Xiamen\,\ Fujian",
  861301592 => "Xiamen\,\ Fujian",
  861301593 => "Xiamen\,\ Fujian",
  861301594 => "Xiamen\,\ Fujian",
  861301595 => "Xiamen\,\ Fujian",
  861301596 => "Putian\,\ Fujian",
  861301597 => "Putian\,\ Fujian",
  861301598 => "Putian\,\ Fujian",
  861301599 => "Putian\,\ Fujian",
  86130160 => "Guangzhou\,\ Guangdong",
  861301610 => "Chenzhou\,\ Hunan",
  861301611 => "Chenzhou\,\ Hunan",
  861301612 => "Chenzhou\,\ Hunan",
  861301613 => "Yiyang\,\ Hunan",
  861301614 => "Yiyang\,\ Hunan",
  861301615 => "Yiyang\,\ Hunan",
  861301616 => "Changsha\,\ Hunan",
  861301617 => "Xiangtan\,\ Hunan",
  861301618 => "Hengyang\,\ Hunan",
  861301619 => "Hengyang\,\ Hunan",
  86130162 => "Haikou\,\ Hainan",
  86130163 => "Zhuhai\,\ Guangdong",
  86130164 => "Wuhan\,\ Hubei",
  861301650 => "Yancheng\,\ Jiangsu",
  861301651 => "Yancheng\,\ Jiangsu",
  861301652 => "Yancheng\,\ Jiangsu",
  861301653 => "Yancheng\,\ Jiangsu",
  861301654 => "Yancheng\,\ Jiangsu",
  861301655 => "Yancheng\,\ Jiangsu",
  861301656 => "HuaiAn\,\ Jiangsu",
  861301657 => "HuaiAn\,\ Jiangsu",
  861301658 => "HuaiAn\,\ Jiangsu",
  861301659 => "HuaiAn\,\ Jiangsu",
  861301660 => "Foshan\,\ Guangdong",
  861301661 => "Foshan\,\ Guangdong",
  861301662 => "Foshan\,\ Guangdong",
  861301663 => "Dongguan\,\ Guangdong",
  861301664 => "Dongguan\,\ Guangdong",
  861301665 => "Shantou\,\ Guangdong",
  861301666 => "Shantou\,\ Guangdong",
  861301667 => "Chaozhou\,\ Guangdong",
  861301668 => "Shantou\,\ Guangdong",
  861301669 => "Jieyang\,\ Guangdong",
  861301670 => "Taizhou\,\ Jiangsu",
  861301671 => "Taizhou\,\ Jiangsu",
  861301672 => "Taizhou\,\ Jiangsu",
  861301673 => "Taizhou\,\ Jiangsu",
  861301674 => "Taizhou\,\ Jiangsu",
  861301675 => "Taizhou\,\ Jiangsu",
  861301676 => "Nantong\,\ Jiangsu",
  861301677 => "Nantong\,\ Jiangsu",
  861301678 => "Nantong\,\ Jiangsu",
  861301679 => "Nantong\,\ Jiangsu",
  861301680 => "Zhenjiang\,\ Jiangsu",
  861301681 => "Zhenjiang\,\ Jiangsu",
  861301682 => "Zhenjiang\,\ Jiangsu",
  861301683 => "Zhenjiang\,\ Jiangsu",
  861301684 => "Changzhou\,\ Jiangsu",
  861301685 => "Changzhou\,\ Jiangsu",
  861301686 => "Changzhou\,\ Jiangsu",
  861301687 => "Changzhou\,\ Jiangsu",
  861301688 => "Changzhou\,\ Jiangsu",
  861301689 => "Changzhou\,\ Jiangsu",
  861301690 => "Lianyungang\,\ Jiangsu",
  861301691 => "Lianyungang\,\ Jiangsu",
  861301692 => "Lianyungang\,\ Jiangsu",
  861301693 => "Nanjing\,\ Jiangsu",
  861301694 => "Nanjing\,\ Jiangsu",
  861301695 => "Nanjing\,\ Jiangsu",
  861301696 => "Nanjing\,\ Jiangsu",
  861301697 => "Nanjing\,\ Jiangsu",
  861301698 => "Nanjing\,\ Jiangsu",
  861301699 => "Nanjing\,\ Jiangsu",
  861301700 => "Tongren\,\ Guizhou",
  861301701 => "Qiandongnan\,\ Guizhou",
  861301702 => "Qiannan\,\ Guizhou",
  861301703 => "Qiannan\,\ Guizhou",
  861301704 => "Liupanshui\,\ Guizhou",
  861301705 => "Qianxinan\,\ Guizhou",
  861301706 => "Bijie\,\ Guizhou",
  861301707 => "Liupanshui\,\ Guizhou",
  861301708 => "Anshun\,\ Guizhou",
  861301709 => "Anshun\,\ Guizhou",
  861301710 => "Zhuzhou\,\ Hunan",
  861301711 => "Zhuzhou\,\ Hunan",
  861301712 => "Zhuzhou\,\ Hunan",
  861301713 => "Zhuzhou\,\ Hunan",
  861301714 => "Xiangtan\,\ Hunan",
  861301715 => "Xiangtan\,\ Hunan",
  861301716 => "Hengyang\,\ Hunan",
  861301717 => "Hengyang\,\ Hunan",
  861301718 => "Changsha\,\ Hunan",
  861301719 => "Changsha\,\ Hunan",
  861301720 => "Yueyang\,\ Hunan",
  861301721 => "Yueyang\,\ Hunan",
  861301722 => "Yueyang\,\ Hunan",
  861301723 => "Yueyang\,\ Hunan",
  861301724 => "Changde\,\ Hunan",
  861301725 => "Changde\,\ Hunan",
  861301726 => "Changde\,\ Hunan",
  861301727 => "Changde\,\ Hunan",
  861301728 => "Changsha\,\ Hunan",
  861301729 => "Changsha\,\ Hunan",
  861301730 => "Yueyang\,\ Hunan",
  861301731 => "Changsha\,\ Hunan",
  861301732 => "Xiangtan\,\ Hunan",
  861301733 => "Zhuzhou\,\ Hunan",
  861301734 => "Hengyang\,\ Hunan",
  861301735 => "Chenzhou\,\ Hunan",
  861301736 => "Changde\,\ Hunan",
  861301737 => "Yiyang\,\ Hunan",
  861301738 => "Changsha\,\ Hunan",
  861301739 => "Changsha\,\ Hunan",
  861301740 => "Zunyi\,\ Guizhou",
  861301741 => "Zunyi\,\ Guizhou",
  861301742 => "Qiandongnan\,\ Guizhou",
  861301743 => "Guiyang\,\ Guizhou",
  861301744 => "Anshun\,\ Guizhou",
  861301745 => "Guiyang\,\ Guizhou",
  861301746 => "Guiyang\,\ Guizhou",
  861301747 => "Guiyang\,\ Guizhou",
  861301748 => "Guiyang\,\ Guizhou",
  861301749 => "Zunyi\,\ Guizhou",
  861301750 => "Jiaozuo\,\ Henan",
  861301751 => "Jiaozuo\,\ Henan",
  861301752 => "Anyang\,\ Henan",
  861301753 => "Xinxiang\,\ Henan",
  861301754 => "Xinxiang\,\ Henan",
  861301755 => "Pingdingshan\,\ Henan",
  861301756 => "Pingdingshan\,\ Henan",
  861301757 => "Pingdingshan\,\ Henan",
  861301758 => "Kaifeng\,\ Henan",
  861301759 => "Xuchang\,\ Henan",
  861301760 => "Xinxiang\,\ Henan",
  861301761 => "Luohe\,\ Henan",
  861301762 => "Kaifeng\,\ Henan",
  861301763 => "Luoyang\,\ Henan",
  861301764 => "Luoyang\,\ Henan",
  861301765 => "Zhengzhou\,\ Henan",
  861301766 => "Zhengzhou\,\ Henan",
  861301767 => "Zhengzhou\,\ Henan",
  861301768 => "Zhengzhou\,\ Henan",
  861301769 => "Zhengzhou\,\ Henan",
  861301770 => "Shaoxing\,\ Zhejiang",
  861301771 => "Shaoxing\,\ Zhejiang",
  861301772 => "Shaoxing\,\ Zhejiang",
  861301773 => "Shaoxing\,\ Zhejiang",
  861301774 => "Quzhou\,\ Zhejiang",
  861301775 => "Jiaxing\,\ Zhejiang",
  861301776 => "Jiaxing\,\ Zhejiang",
  861301777 => "Jiaxing\,\ Zhejiang",
  861301778 => "Jiaxing\,\ Zhejiang",
  861301779 => "Jiaxing\,\ Zhejiang",
  86130178 => "Wenzhou\,\ Zhejiang",
  861301790 => "Huzhou\,\ Zhejiang",
  861301791 => "Huzhou\,\ Zhejiang",
  861301792 => "Lishui\,\ Zhejiang",
  861301793 => "Lishui\,\ Zhejiang",
  861301794 => "Jinhua\,\ Zhejiang",
  861301795 => "Jinhua\,\ Zhejiang",
  861301796 => "Jinhua\,\ Zhejiang",
  861301797 => "Jinhua\,\ Zhejiang",
  861301798 => "Jinhua\,\ Zhejiang",
  861301799 => "Jinhua\,\ Zhejiang",
  86130180 => "Wuhan\,\ Hubei",
  861301810 => "Liangshan\,\ Sichuan",
  861301811 => "Panzhihua\,\ Sichuan",
  861301812 => "Nanchong\,\ Sichuan",
  861301813 => "Mianyang\,\ Sichuan",
  861301814 => "Mianyang\,\ Sichuan",
  861301815 => "Luzhou\,\ Sichuan",
  861301816 => "Neijiang\,\ Sichuan",
  861301817 => "Yibin\,\ Sichuan",
  861301818 => "Zigong\,\ Sichuan",
  861301819 => "Deyang\,\ Sichuan",
  86130182 => "Chengdu\,\ Sichuan",
  86130183 => "Chongqing",
  861301840 => "Huizhou\,\ Guangdong",
  861301841 => "Huizhou\,\ Guangdong",
  861301842 => "Huizhou\,\ Guangdong",
  861301843 => "Huizhou\,\ Guangdong",
  861301844 => "Huizhou\,\ Guangdong",
  861301845 => "Huizhou\,\ Guangdong",
  861301846 => "Huizhou\,\ Guangdong",
  861301847 => "Zhuhai\,\ Guangdong",
  861301848 => "Zhuhai\,\ Guangdong",
  861301849 => "Zhuhai\,\ Guangdong",
  861301850 => "Maoming\,\ Guangdong",
  861301851 => "Yangjiang\,\ Guangdong",
  861301852 => "Foshan\,\ Guangdong",
  861301853 => "Foshan\,\ Guangdong",
  861301854 => "Foshan\,\ Guangdong",
  861301855 => "Foshan\,\ Guangdong",
  861301856 => "Foshan\,\ Guangdong",
  861301857 => "Foshan\,\ Guangdong",
  861301858 => "Zhanjiang\,\ Guangdong",
  861301859 => "Zhanjiang\,\ Guangdong",
  86130186 => "Dongguan\,\ Guangdong",
  861301870 => "Qingyuan\,\ Guangdong",
  861301871 => "Shaoguan\,\ Guangdong",
  861301872 => "Zhongshan\,\ Guangdong",
  861301873 => "Zhongshan\,\ Guangdong",
  861301874 => "Zhongshan\,\ Guangdong",
  861301875 => "Zhongshan\,\ Guangdong",
  861301876 => "Zhongshan\,\ Guangdong",
  861301877 => "Meizhou\,\ Guangdong",
  861301878 => "Meizhou\,\ Guangdong",
  861301879 => "Heyuan\,\ Guangdong",
  861301880 => "Shaoxing\,\ Zhejiang",
  861301881 => "Zhoushan\,\ Zhejiang",
  861301882 => "Taizhou\,\ Zhejiang",
  861301883 => "Taizhou\,\ Zhejiang",
  861301884 => "Taizhou\,\ Zhejiang",
  861301885 => "Taizhou\,\ Zhejiang",
  861301886 => "Taizhou\,\ Zhejiang",
  861301887 => "Taizhou\,\ Zhejiang",
  861301888 => "Taizhou\,\ Zhejiang",
  861301889 => "Taizhou\,\ Zhejiang",
  86130189 => "Hangzhou\,\ Zhejiang",
  861301900 => "Harbin\,\ Heilongjiang",
  861301901 => "Harbin\,\ Heilongjiang",
  861301902 => "Hegang\,\ Heilongjiang",
  861301903 => "Qiqihar\,\ Heilongjiang",
  861301904 => "Shuangyashan\,\ Heilongjiang",
  861301905 => "Mudanjiang\,\ Heilongjiang",
  861301906 => "Mudanjiang\,\ Heilongjiang",
  861301907 => "Daqing\,\ Heilongjiang",
  861301908 => "Daqing\,\ Heilongjiang",
  861301909 => "Qiqihar\,\ Heilongjiang",
  861301910 => "Changchun\,\ Jilin",
  861301911 => "Changchun\,\ Jilin",
  861301912 => "Changchun\,\ Jilin",
  861301913 => "Changchun\,\ Jilin",
  861301914 => "Songyuan\,\ Jilin",
  861301915 => "Jilin\,\ Jilin",
  861301916 => "Jilin\,\ Jilin",
  861301917 => "Jilin\,\ Jilin",
  861301918 => "Yanbian\,\ Jilin",
  861301919 => "Tonghua\,\ Jilin",
  861301920 => "Changchun\,\ Jilin",
  861301921 => "Changchun\,\ Jilin",
  861301922 => "Changchun\,\ Jilin",
  861301923 => "Yanbian\,\ Jilin",
  861301924 => "Jilin\,\ Jilin",
  861301925 => "Jilin\,\ Jilin",
  861301926 => "Jilin\,\ Jilin",
  861301927 => "Jilin\,\ Jilin",
  861301928 => "Liaoyuan\,\ Jilin",
  861301929 => "Liaoyuan\,\ Jilin",
  86130193 => "Shenyang\,\ Liaoning",
  86130194 => "Dalian\,\ Liaoning",
  861301950 => "Hohhot\,\ Inner\ Mongolia",
  861301951 => "Hulun\,\ Inner\ Mongolia",
  861301952 => "Hulun\,\ Inner\ Mongolia",
  861301953 => "Tongliao\,\ Inner\ Mongolia",
  861301954 => "Tongliao\,\ Inner\ Mongolia",
  861301955 => "Baotou\,\ Inner\ Mongolia",
  861301956 => "Baotou\,\ Inner\ Mongolia",
  861301957 => "Ordos\,\ Inner\ Mongolia",
  861301958 => "Bayannur\,\ Inner\ Mongolia",
  861301959 => "Chifeng\,\ Inner\ Mongolia",
  861301960 => "Anshan\,\ Liaoning",
  861301961 => "Anshan\,\ Liaoning",
  861301962 => "Anshan\,\ Liaoning",
  861301963 => "Anshan\,\ Liaoning",
  861301964 => "Anshan\,\ Liaoning",
  861301965 => "Fushun\,\ Liaoning",
  861301966 => "Fushun\,\ Liaoning",
  861301967 => "Benxi\,\ Liaoning",
  861301968 => "Benxi\,\ Liaoning",
  861301969 => "Dandong\,\ Liaoning",
  861301970 => "Harbin\,\ Heilongjiang",
  861301971 => "Harbin\,\ Heilongjiang",
  861301972 => "Harbin\,\ Heilongjiang",
  861301973 => "Qiqihar\,\ Heilongjiang",
  861301974 => "Jixi\,\ Heilongjiang",
  861301975 => "Jiamusi\,\ Heilongjiang",
  861301976 => "Jiamusi\,\ Heilongjiang",
  861301977 => "Daqing\,\ Heilongjiang",
  861301978 => "Qiqihar\,\ Heilongjiang",
  861301979 => "Qitaihe\,\ Heilongjiang",
  861301980 => "Dandong\,\ Liaoning",
  861301981 => "Jinzhou\,\ Liaoning",
  861301982 => "Jinzhou\,\ Liaoning",
  861301983 => "Jinzhou\,\ Liaoning",
  861301984 => "Yingkou\,\ Liaoning",
  861301985 => "Yingkou\,\ Liaoning",
  861301986 => "Fuxin\,\ Liaoning",
  861301987 => "Fuxin\,\ Liaoning",
  861301988 => "Liaoyang\,\ Liaoning",
  861301989 => "Liaoyang\,\ Liaoning",
  861301990 => "Liaoyang\,\ Liaoning",
  861301991 => "Tieling\,\ Liaoning",
  861301992 => "Tieling\,\ Liaoning",
  861301993 => "Chaoyang\,\ Liaoning",
  861301994 => "Panjin\,\ Liaoning",
  861301995 => "Panjin\,\ Liaoning",
  861301996 => "Panjin\,\ Liaoning",
  861301997 => "Huludao\,\ Liaoning",
  861301998 => "Huludao\,\ Liaoning",
  861301999 => "Huludao\,\ Liaoning",
  86130200 => "Beijing",
  86130201 => "Shanghai",
  86130202 => "Shanghai",
  861302030 => "Shenyang\,\ Liaoning",
  861302031 => "Shenyang\,\ Liaoning",
  861302032 => "Shenyang\,\ Liaoning",
  861302033 => "Anshan\,\ Liaoning",
  861302034 => "Fushun\,\ Liaoning",
  861302035 => "Dandong\,\ Liaoning",
  861302036 => "Jinzhou\,\ Liaoning",
  861302037 => "Yingkou\,\ Liaoning",
  861302038 => "Fuxin\,\ Liaoning",
  861302039 => "Tieling\,\ Liaoning",
  861302040 => "Hulun\,\ Inner\ Mongolia",
  861302041 => "Tongliao\,\ Inner\ Mongolia",
  861302042 => "Chifeng\,\ Inner\ Mongolia",
  861302043 => "Baotou\,\ Inner\ Mongolia",
  861302044 => "Ordos\,\ Inner\ Mongolia",
  861302045 => "Bayannur\,\ Inner\ Mongolia",
  861302046 => "Bayannur\,\ Inner\ Mongolia",
  861302047 => "Bayannur\,\ Inner\ Mongolia",
  861302048 => "Bayannur\,\ Inner\ Mongolia",
  861302049 => "Tongliao\,\ Inner\ Mongolia",
  861302050 => "Jining\,\ Shandong",
  861302051 => "Heze\,\ Shandong",
  861302052 => "Zaozhuang\,\ Shandong",
  861302053 => "Rizhao\,\ Shandong",
  861302054 => "Binzhou\,\ Shandong",
  861302055 => "Liaocheng\,\ Shandong",
  861302056 => "Dezhou\,\ Shandong",
  861302057 => "Liaocheng\,\ Shandong",
  861302058 => "Liaocheng\,\ Shandong",
  861302059 => "Liaocheng\,\ Shandong",
  861302060 => "Dongying\,\ Shandong",
  861302061 => "Dezhou\,\ Shandong",
  861302062 => "Binzhou\,\ Shandong",
  861302063 => "Zaozhuang\,\ Shandong",
  861302064 => "Heze\,\ Shandong",
  861302065 => "Linyi\,\ Shandong",
  861302066 => "Linyi\,\ Shandong",
  861302067 => "Jining\,\ Shandong",
  861302068 => "Jining\,\ Shandong",
  861302069 => "Jining\,\ Shandong",
  86130207 => "Xianyang\,\ Shaanxi",
  861302080 => "Baoding\,\ Hebei",
  861302081 => "Baoding\,\ Hebei",
  861302082 => "Baoding\,\ Hebei",
  861302083 => "Handan\,\ Hebei",
  861302084 => "Shijiazhuang\,\ Hebei",
  861302085 => "Shijiazhuang\,\ Hebei",
  861302086 => "Shijiazhuang\,\ Hebei",
  861302087 => "Zhangjiakou\,\ Hebei",
  861302088 => "Tangshan\,\ Hebei",
  861302089 => "Chengde\,\ Hebei",
  861302090 => "Wenzhou\,\ Zhejiang",
  861302091 => "Wenzhou\,\ Zhejiang",
  861302092 => "Wenzhou\,\ Zhejiang",
  861302093 => "Wenzhou\,\ Zhejiang",
  861302094 => "Wenzhou\,\ Zhejiang",
  861302095 => "Taizhou\,\ Zhejiang",
  861302096 => "Taizhou\,\ Zhejiang",
  861302097 => "Taizhou\,\ Zhejiang",
  861302098 => "Jinhua\,\ Zhejiang",
  861302099 => "Jiaxing\,\ Zhejiang",
  86130210 => "Beijing",
  86130211 => "Beijing",
  86130212 => "Beijing",
  86130213 => "Tianjin",
  861302140 => "Baoding\,\ Hebei",
  861302141 => "Tangshan\,\ Hebei",
  861302142 => "Qinhuangdao\,\ Hebei",
  861302143 => "Langfang\,\ Hebei",
  861302144 => "Cangzhou\,\ Hebei",
  861302145 => "Xingtai\,\ Hebei",
  861302146 => "Handan\,\ Hebei",
  861302147 => "Hengshui\,\ Hebei",
  861302148 => "Cangzhou\,\ Hebei",
  861302149 => "Shijiazhuang\,\ Hebei",
  861302150 => "Zibo\,\ Shandong",
  861302151 => "Zibo\,\ Shandong",
  861302152 => "Binzhou\,\ Shandong",
  861302153 => "Weifang\,\ Shandong",
  861302154 => "Weifang\,\ Shandong",
  861302155 => "Weifang\,\ Shandong",
  861302156 => "Dongying\,\ Shandong",
  861302157 => "Linyi\,\ Shandong",
  861302158 => "Rizhao\,\ Shandong",
  861302159 => "Zaozhuang\,\ Shandong",
  861302160 => "Yantai\,\ Shandong",
  861302161 => "Yantai\,\ Shandong",
  861302162 => "Yantai\,\ Shandong",
  861302163 => "Weihai\,\ Shandong",
  861302164 => "Weihai\,\ Shandong",
  861302165 => "Weihai\,\ Shandong",
  861302166 => "Qingdao\,\ Shandong",
  861302167 => "Qingdao\,\ Shandong",
  861302168 => "Qingdao\,\ Shandong",
  861302169 => "Qingdao\,\ Shandong",
  861302170 => "Jinan\,\ Shandong",
  861302171 => "Jinan\,\ Shandong",
  861302172 => "Jinan\,\ Shandong",
  861302173 => "Jinan\,\ Shandong",
  861302174 => "Jinan\,\ Shandong",
  861302175 => "Liaocheng\,\ Shandong",
  861302176 => "Dezhou\,\ Shandong",
  861302177 => "TaiAn\,\ Shandong",
  861302178 => "Jining\,\ Shandong",
  861302179 => "Heze\,\ Shandong",
  861302180 => "Shijiazhuang\,\ Hebei",
  861302181 => "Tangshan\,\ Hebei",
  861302182 => "Qinhuangdao\,\ Hebei",
  861302183 => "Langfang\,\ Hebei",
  861302184 => "Tangshan\,\ Hebei",
  861302185 => "Xingtai\,\ Hebei",
  861302186 => "Handan\,\ Hebei",
  861302187 => "Baoding\,\ Hebei",
  861302188 => "Shijiazhuang\,\ Hebei",
  861302189 => "Shijiazhuang\,\ Hebei",
  86130219 => "Beijing",
  86130220 => "Guangzhou\,\ Guangdong",
  86130221 => "Shanghai",
  86130222 => "Tianjin",
  86130223 => "Chongqing",
  86130224 => "Shenyang\,\ Liaoning",
  86130225 => "Nanjing\,\ Jiangsu",
  861302260 => "Jiaxing\,\ Zhejiang",
  861302261 => "Huzhou\,\ Zhejiang",
  861302262 => "Zhoushan\,\ Zhejiang",
  861302263 => "Shaoxing\,\ Zhejiang",
  861302264 => "Quzhou\,\ Zhejiang",
  861302265 => "Jinhua\,\ Zhejiang",
  861302266 => "Taizhou\,\ Zhejiang",
  861302267 => "Lishui\,\ Zhejiang",
  861302268 => "Wenzhou\,\ Zhejiang",
  861302269 => "Wenzhou\,\ Zhejiang",
  861302270 => "Zibo\,\ Shandong",
  861302271 => "Zibo\,\ Shandong",
  861302272 => "Yantai\,\ Shandong",
  861302273 => "Yantai\,\ Shandong",
  861302274 => "Yantai\,\ Shandong",
  861302275 => "Yantai\,\ Shandong",
  861302276 => "Laiwu\,\ Shandong",
  861302277 => "TaiAn\,\ Shandong",
  861302278 => "Weifang\,\ Shandong",
  861302279 => "Linyi\,\ Shandong",
  86130228 => "XiAn\,\ Shaanxi",
  86130229 => "XiAn\,\ Shaanxi",
  861302300 => "Hefei\,\ Anhui",
  861302301 => "Bengbu\,\ Anhui",
  861302302 => "Bengbu\,\ Anhui",
  861302303 => "Wuhu\,\ Anhui",
  861302304 => "Wuhu\,\ Anhui",
  861302305 => "Hefei\,\ Anhui",
  861302306 => "Hefei\,\ Anhui",
  861302307 => "Huainan\,\ Anhui",
  861302308 => "Hefei\,\ Anhui",
  861302309 => "Hefei\,\ Anhui",
  86130231 => "Shanghai",
  86130232 => "Shanghai",
  861302330 => "Wuxi\,\ Jiangsu",
  861302331 => "Wuxi\,\ Jiangsu",
  861302332 => "Wuxi\,\ Jiangsu",
  861302333 => "Wuxi\,\ Jiangsu",
  861302334 => "Xiangtan\,\ Hunan",
  861302335 => "Wuxi\,\ Jiangsu",
  861302336 => "Wuxi\,\ Jiangsu",
  861302337 => "Wuxi\,\ Jiangsu",
  861302338 => "Wuxi\,\ Jiangsu",
  861302339 => "Wuxi\,\ Jiangsu",
  861302340 => "Nanjing\,\ Jiangsu",
  861302341 => "Nanjing\,\ Jiangsu",
  861302342 => "Nanjing\,\ Jiangsu",
  861302343 => "Zhenjiang\,\ Jiangsu",
  861302344 => "Zhenjiang\,\ Jiangsu",
  861302345 => "Zhenjiang\,\ Jiangsu",
  861302346 => "Lianyungang\,\ Jiangsu",
  861302347 => "Lianyungang\,\ Jiangsu",
  861302348 => "Yancheng\,\ Jiangsu",
  861302349 => "Suqian\,\ Jiangsu",
  861302350 => "Xuzhou\,\ Jiangsu",
  861302351 => "Xuzhou\,\ Jiangsu",
  861302352 => "Xuzhou\,\ Jiangsu",
  861302353 => "Nantong\,\ Jiangsu",
  861302354 => "HuaiAn\,\ Jiangsu",
  861302355 => "Nantong\,\ Jiangsu",
  861302356 => "Nantong\,\ Jiangsu",
  861302357 => "Nantong\,\ Jiangsu",
  861302358 => "Nantong\,\ Jiangsu",
  861302359 => "Nantong\,\ Jiangsu",
  86130236 => "Hangzhou\,\ Zhejiang",
  86130237 => "Ningbo\,\ Zhejiang",
  861302380 => "Fuzhou\,\ Fujian",
  861302381 => "Fuzhou\,\ Fujian",
  861302382 => "Fuzhou\,\ Fujian",
  861302383 => "Fuzhou\,\ Fujian",
  861302384 => "Fuzhou\,\ Fujian",
  861302385 => "Putian\,\ Fujian",
  861302386 => "Putian\,\ Fujian",
  861302387 => "Fuzhou\,\ Fujian",
  861302388 => "Fuzhou\,\ Fujian",
  861302389 => "Fuzhou\,\ Fujian",
  861302390 => "Xiamen\,\ Fujian",
  861302391 => "Xiamen\,\ Fujian",
  861302392 => "Xiamen\,\ Fujian",
  861302393 => "Xiamen\,\ Fujian",
  861302394 => "Xiamen\,\ Fujian",
  861302395 => "Zhangzhou\,\ Fujian",
  861302396 => "Zhangzhou\,\ Fujian",
  861302397 => "Xiamen\,\ Fujian",
  861302398 => "Xiamen\,\ Fujian",
  861302399 => "Xiamen\,\ Fujian",
  861302400 => "Huainan\,\ Anhui",
  861302401 => "Fuyang\,\ Anhui",
  861302402 => "Bozhou\,\ Anhui",
  861302403 => "Fuyang\,\ Anhui",
  861302404 => "Wuhu\,\ Anhui",
  861302405 => "Wuhu\,\ Anhui",
  861302406 => "Wuhu\,\ Anhui",
  861302407 => "Bengbu\,\ Anhui",
  861302408 => "Bengbu\,\ Anhui",
  861302409 => "Bengbu\,\ Anhui",
  86130241 => "Shanghai",
  861302420 => "Jiaxing\,\ Zhejiang",
  861302421 => "Jiaxing\,\ Zhejiang",
  861302422 => "Jiaxing\,\ Zhejiang",
  861302423 => "Jiaxing\,\ Zhejiang",
  861302424 => "Jiaxing\,\ Zhejiang",
  861302425 => "Huzhou\,\ Zhejiang",
  861302426 => "Huzhou\,\ Zhejiang",
  861302427 => "Hangzhou\,\ Zhejiang",
  861302428 => "Hangzhou\,\ Zhejiang",
  861302429 => "Hangzhou\,\ Zhejiang",
  861302430 => "Yangzhou\,\ Jiangsu",
  861302431 => "Yangzhou\,\ Jiangsu",
  861302432 => "Yangzhou\,\ Jiangsu",
  861302433 => "Yangzhou\,\ Jiangsu",
  861302434 => "Yangzhou\,\ Jiangsu",
  861302435 => "Zhenjiang\,\ Jiangsu",
  861302436 => "Zhenjiang\,\ Jiangsu",
  861302437 => "Shaoyang\,\ Hunan",
  861302438 => "Shaoyang\,\ Hunan",
  861302439 => "Yangzhou\,\ Jiangsu",
  861302440 => "Changzhou\,\ Jiangsu",
  861302441 => "Changzhou\,\ Jiangsu",
  861302442 => "Changzhou\,\ Jiangsu",
  861302443 => "Changzhou\,\ Jiangsu",
  861302444 => "Taizhou\,\ Jiangsu",
  861302445 => "Taizhou\,\ Jiangsu",
  861302446 => "Taizhou\,\ Jiangsu",
  861302447 => "Yancheng\,\ Jiangsu",
  861302448 => "Yancheng\,\ Jiangsu",
  861302449 => "Yancheng\,\ Jiangsu",
  86130245 => "Suzhou\,\ Jiangsu",
  861302460 => "Shaoxing\,\ Zhejiang",
  861302461 => "Shaoxing\,\ Zhejiang",
  861302462 => "Shaoxing\,\ Zhejiang",
  861302463 => "Shaoxing\,\ Zhejiang",
  861302464 => "Jinhua\,\ Zhejiang",
  861302465 => "Jinhua\,\ Zhejiang",
  861302466 => "Jinhua\,\ Zhejiang",
  861302467 => "Jinhua\,\ Zhejiang",
  861302468 => "Quzhou\,\ Zhejiang",
  861302469 => "Lishui\,\ Zhejiang",
  861302470 => "Wenzhou\,\ Zhejiang",
  861302471 => "Wenzhou\,\ Zhejiang",
  861302472 => "Wenzhou\,\ Zhejiang",
  861302473 => "Wenzhou\,\ Zhejiang",
  861302474 => "Wenzhou\,\ Zhejiang",
  861302475 => "Wenzhou\,\ Zhejiang",
  861302476 => "Taizhou\,\ Zhejiang",
  861302477 => "Taizhou\,\ Zhejiang",
  861302478 => "Taizhou\,\ Zhejiang",
  861302479 => "Taizhou\,\ Zhejiang",
  86130248 => "Quanzhou\,\ Fujian",
  861302490 => "Sanming\,\ Fujian",
  861302491 => "Ningde\,\ Fujian",
  861302492 => "Ningde\,\ Fujian",
  861302493 => "Ningde\,\ Fujian",
  861302494 => "Nanping\,\ Fujian",
  861302495 => "Nanping\,\ Fujian",
  861302496 => "Nanping\,\ Fujian",
  861302497 => "Longyan\,\ Fujian",
  861302498 => "Longyan\,\ Fujian",
  861302499 => "Sanming\,\ Fujian",
  86130250 => "Wenzhou\,\ Zhejiang",
  86130251 => "Guangzhou\,\ Guangdong",
  861302520 => "Shantou\,\ Guangdong",
  861302521 => "Shantou\,\ Guangdong",
  861302522 => "Shantou\,\ Guangdong",
  861302523 => "Shantou\,\ Guangdong",
  861302524 => "Shantou\,\ Guangdong",
  861302525 => "Shanwei\,\ Guangdong",
  861302526 => "Jieyang\,\ Guangdong",
  861302527 => "Jieyang\,\ Guangdong",
  861302528 => "Meizhou\,\ Guangdong",
  861302529 => "Meizhou\,\ Guangdong",
  861302530 => "Heyuan\,\ Guangdong",
  861302531 => "Chaozhou\,\ Guangdong",
  861302532 => "Shantou\,\ Guangdong",
  861302533 => "Shantou\,\ Guangdong",
  861302534 => "Shantou\,\ Guangdong",
  861302535 => "Qingyuan\,\ Guangdong",
  861302536 => "Shaoguan\,\ Guangdong",
  861302537 => "Shaoguan\,\ Guangdong",
  861302538 => "Yunfu\,\ Guangdong",
  861302539 => "Yunfu\,\ Guangdong",
  86130254 => "Shenzhen\,\ Guangdong",
  861302550 => "Zhongshan\,\ Guangdong",
  861302551 => "Zhongshan\,\ Guangdong",
  861302552 => "Zhongshan\,\ Guangdong",
  861302553 => "Zhongshan\,\ Guangdong",
  861302554 => "Zhongshan\,\ Guangdong",
  861302555 => "Zhongshan\,\ Guangdong",
  861302556 => "Zhaoqing\,\ Guangdong",
  861302557 => "Zhaoqing\,\ Guangdong",
  861302558 => "Zhaoqing\,\ Guangdong",
  861302559 => "Zhaoqing\,\ Guangdong",
  861302560 => "Zhanjiang\,\ Guangdong",
  861302561 => "Zhanjiang\,\ Guangdong",
  861302562 => "Zhanjiang\,\ Guangdong",
  861302563 => "Zhanjiang\,\ Guangdong",
  861302564 => "Yangjiang\,\ Guangdong",
  861302565 => "Yangjiang\,\ Guangdong",
  861302566 => "Maoming\,\ Guangdong",
  861302567 => "Maoming\,\ Guangdong",
  861302568 => "Maoming\,\ Guangdong",
  861302569 => "Zhuhai\,\ Guangdong",
  861302570 => "Huizhou\,\ Guangdong",
  861302571 => "Huizhou\,\ Guangdong",
  861302572 => "Huizhou\,\ Guangdong",
  861302573 => "Huizhou\,\ Guangdong",
  861302574 => "Huizhou\,\ Guangdong",
  861302575 => "Huizhou\,\ Guangdong",
  861302576 => "Zhuhai\,\ Guangdong",
  861302577 => "Zhuhai\,\ Guangdong",
  861302578 => "Zhuhai\,\ Guangdong",
  861302579 => "Zhuhai\,\ Guangdong",
  86130258 => "Jiangmen\,\ Guangdong",
  861302590 => "Nanning\,\ Guangxi",
  861302591 => "Nanning\,\ Guangxi",
  861302592 => "Nanning\,\ Guangxi",
  861302593 => "Liuzhou\,\ Guangxi",
  861302594 => "Guilin\,\ Guangxi",
  861302595 => "Guilin\,\ Guangxi",
  861302596 => "Yulin\,\ Guangxi",
  861302597 => "Wuzhou\,\ Guangxi",
  861302598 => "Wuzhou\,\ Guangxi",
  861302599 => "Beihai\,\ Guangxi",
  861302600 => "Anqing\,\ Anhui",
  861302601 => "Anqing\,\ Anhui",
  861302602 => "Chuzhou\,\ Anhui",
  861302603 => "Chuzhou\,\ Anhui",
  861302604 => "Huaibei\,\ Anhui",
  861302605 => "Huaibei\,\ Anhui",
  861302606 => "LuAn\,\ Anhui",
  861302607 => "Xuancheng\,\ Anhui",
  861302608 => "MaAnshan\,\ Anhui",
  861302609 => "Suzhou\,\ Anhui",
  86130261 => "Wuhan\,\ Hubei",
  861302620 => "Nanchang\,\ Jiangxi",
  861302621 => "Nanchang\,\ Jiangxi",
  861302622 => "Yingtan\,\ Jiangxi",
  861302623 => "Yingtan\,\ Jiangxi",
  861302624 => "Ganzhou\,\ Jiangxi",
  861302625 => "Yingtan\,\ Jiangxi",
  861302626 => "Yichun\,\ Jiangxi",
  861302627 => "Yichun\,\ Jiangxi",
  861302628 => "Yichun\,\ Jiangxi",
  861302629 => "Yichun\,\ Jiangxi",
  86130263 => "Wuhan\,\ Hubei",
  861302640 => "Yulin\,\ Shaanxi",
  861302641 => "Weinan\,\ Shaanxi",
  861302642 => "Hanzhong\,\ Shaanxi",
  861302643 => "YanAn\,\ Shaanxi",
  861302644 => "Baoji\,\ Shaanxi",
  861302645 => "Deyang\,\ Sichuan",
  861302646 => "Weinan\,\ Shaanxi",
  861302647 => "YanAn\,\ Shaanxi",
  861302648 => "Mianyang\,\ Sichuan",
  861302649 => "Mianyang\,\ Sichuan",
  861302650 => "Qingdao\,\ Shandong",
  861302651 => "Qingdao\,\ Shandong",
  861302652 => "Qingdao\,\ Shandong",
  861302653 => "Qingdao\,\ Shandong",
  861302654 => "Dongying\,\ Shandong",
  861302655 => "Weifang\,\ Shandong",
  861302656 => "Weifang\,\ Shandong",
  861302657 => "Jinan\,\ Shandong",
  861302658 => "Jinan\,\ Shandong",
  861302659 => "Jinan\,\ Shandong",
  86130266 => "Shenzhen\,\ Guangdong",
  86130267 => "Foshan\,\ Guangdong",
  861302680 => "Dongguan\,\ Guangdong",
  861302681 => "Dongguan\,\ Guangdong",
  861302682 => "Dongguan\,\ Guangdong",
  861302683 => "Dongguan\,\ Guangdong",
  861302684 => "Dongguan\,\ Guangdong",
  861302685 => "Dongguan\,\ Guangdong",
  861302686 => "Guangzhou\,\ Guangdong",
  861302687 => "Guangzhou\,\ Guangdong",
  861302688 => "Guangzhou\,\ Guangdong",
  861302689 => "Guangzhou\,\ Guangdong",
  861302690 => "Fangchenggang\,\ Guangxi",
  861302691 => "Nanning\,\ Guangxi",
  861302692 => "Liuzhou\,\ Guangxi",
  861302693 => "Guilin\,\ Guangxi",
  861302694 => "Wuzhou\,\ Guangxi",
  861302695 => "Yulin\,\ Guangxi",
  861302696 => "Baise\,\ Guangxi",
  861302697 => "Qinzhou\,\ Guangxi",
  861302698 => "Hechi\,\ Guangxi",
  861302699 => "Beihai\,\ Guangxi",
  861302700 => "Taiyuan\,\ Shanxi",
  861302701 => "Taiyuan\,\ Shanxi",
  861302702 => "Taiyuan\,\ Shanxi",
  861302703 => "Taiyuan\,\ Shanxi",
  861302704 => "Taiyuan\,\ Shanxi",
  861302705 => "Jinzhong\,\ Shanxi",
  861302706 => "Jinzhong\,\ Shanxi",
  861302707 => "Taiyuan\,\ Shanxi",
  861302708 => "Taiyuan\,\ Shanxi",
  861302709 => "Taiyuan\,\ Shanxi",
  86130271 => "Wuhan\,\ Hubei",
  861302720 => "Nanchang\,\ Jiangxi",
  861302721 => "Nanchang\,\ Jiangxi",
  861302722 => "Nanchang\,\ Jiangxi",
  861302723 => "Nanchang\,\ Jiangxi",
  861302724 => "Nanchang\,\ Jiangxi",
  861302725 => "Jiujiang\,\ Jiangxi",
  861302726 => "Jiujiang\,\ Jiangxi",
  861302727 => "Jiujiang\,\ Jiangxi",
  861302728 => "Nanchang\,\ Jiangxi",
  861302729 => "Jiujiang\,\ Jiangxi",
  861302730 => "Yueyang\,\ Hunan",
  861302731 => "Changsha\,\ Hunan",
  861302732 => "Xiangtan\,\ Hunan",
  861302733 => "Zhuzhou\,\ Hunan",
  861302734 => "Hengyang\,\ Hunan",
  861302735 => "Chenzhou\,\ Hunan",
  861302736 => "Changde\,\ Hunan",
  861302737 => "Yiyang\,\ Hunan",
  861302738 => "Loudi\,\ Hunan",
  861302739 => "Shaoyang\,\ Hunan",
  861302740 => "Changde\,\ Hunan",
  861302741 => "Changsha\,\ Hunan",
  861302742 => "Changsha\,\ Hunan",
  861302743 => "Changsha\,\ Hunan",
  861302744 => "Xiangtan\,\ Hunan",
  861302745 => "Zhuzhou\,\ Hunan",
  861302746 => "Hengyang\,\ Hunan",
  861302747 => "Yueyang\,\ Hunan",
  861302748 => "Changsha\,\ Hunan",
  861302749 => "Changsha\,\ Hunan",
  861302750 => "Zhengzhou\,\ Henan",
  861302751 => "Zhengzhou\,\ Henan",
  861302752 => "Zhengzhou\,\ Henan",
  861302753 => "Luoyang\,\ Henan",
  861302754 => "Luoyang\,\ Henan",
  861302755 => "Xinxiang\,\ Henan",
  861302756 => "Pingdingshan\,\ Henan",
  861302757 => "Pingdingshan\,\ Henan",
  861302758 => "Jiaozuo\,\ Henan",
  861302759 => "Anyang\,\ Henan",
  861302760 => "Zhengzhou\,\ Henan",
  861302761 => "Zhengzhou\,\ Henan",
  861302762 => "Zhengzhou\,\ Henan",
  861302763 => "Luoyang\,\ Henan",
  861302764 => "Kaifeng\,\ Henan",
  861302765 => "Jiaozuo\,\ Henan",
  861302766 => "Xinxiang\,\ Henan",
  861302767 => "Xuchang\,\ Henan",
  861302768 => "Luohe\,\ Henan",
  861302769 => "Anyang\,\ Henan",
  86130277 => "Zhengzhou\,\ Henan",
  861302780 => "Guiyang\,\ Guizhou",
  861302781 => "Guiyang\,\ Guizhou",
  861302782 => "Guiyang\,\ Guizhou",
  861302783 => "Guiyang\,\ Guizhou",
  861302784 => "Guiyang\,\ Guizhou",
  861302785 => "Guiyang\,\ Guizhou",
  861302786 => "Guiyang\,\ Guizhou",
  861302787 => "Zunyi\,\ Guizhou",
  861302788 => "Guiyang\,\ Guizhou",
  861302789 => "Anshun\,\ Guizhou",
  86130279 => "Shenzhen\,\ Guangdong",
  861302800 => "Yuncheng\,\ Shanxi",
  861302801 => "Yuncheng\,\ Shanxi",
  861302802 => "Linfen\,\ Shanxi",
  861302803 => "Linfen\,\ Shanxi",
  861302804 => "Datong\,\ Shanxi",
  861302805 => "Jincheng\,\ Shanxi",
  861302806 => "Changzhi\,\ Shanxi",
  861302807 => "Changzhi\,\ Shanxi",
  861302808 => "Datong\,\ Shanxi",
  861302809 => "Datong\,\ Shanxi",
  86130281 => "Chengdu\,\ Sichuan",
  861302820 => "Liaoyang\,\ Liaoning",
  861302821 => "Fuxin\,\ Liaoning",
  861302822 => "Panjin\,\ Liaoning",
  861302823 => "Panjin\,\ Liaoning",
  861302824 => "Chaoyang\,\ Liaoning",
  861302825 => "Panjin\,\ Liaoning",
  861302826 => "Jinzhou\,\ Liaoning",
  861302827 => "Tieling\,\ Liaoning",
  861302828 => "Liaoyang\,\ Liaoning",
  861302829 => "Fuxin\,\ Liaoning",
  86130283 => "Chongqing",
  861302840 => "XiAn\,\ Shaanxi",
  861302841 => "XiAn\,\ Shaanxi",
  861302842 => "XiAn\,\ Shaanxi",
  861302843 => "Weinan\,\ Shaanxi",
  861302844 => "Xianyang\,\ Shaanxi",
  861302845 => "Hanzhong\,\ Shaanxi",
  861302846 => "Hanzhong\,\ Shaanxi",
  861302847 => "Baoji\,\ Shaanxi",
  861302848 => "Baoji\,\ Shaanxi",
  861302849 => "Baoji\,\ Shaanxi",
  861302850 => "Tongchuan\,\ Shaanxi",
  861302851 => "XiAn\,\ Shaanxi",
  861302852 => "Weinan\,\ Shaanxi",
  861302853 => "Weinan\,\ Shaanxi",
  861302854 => "Xianyang\,\ Shaanxi",
  861302855 => "Xianyang\,\ Shaanxi",
  861302856 => "XiAn\,\ Shaanxi",
  861302857 => "YanAn\,\ Shaanxi",
  861302858 => "YanAn\,\ Shaanxi",
  861302859 => "XiAn\,\ Shaanxi",
  86130286 => "Shijiazhuang\,\ Hebei",
  861302870 => "Lanzhou\,\ Gansu",
  861302871 => "Lanzhou\,\ Gansu",
  861302872 => "Baiyin\,\ Gansu",
  861302873 => "Baiyin\,\ Gansu",
  861302874 => "Baiyin\,\ Gansu",
  861302875 => "Jiuquan\,\ Gansu",
  861302876 => "Dingxi\,\ Gansu",
  861302877 => "Linxia\,\ Gansu",
  861302878 => "Linxia\,\ Gansu",
  861302879 => "Lanzhou\,\ Gansu",
  86130288 => "Shenzhen\,\ Guangdong",
  86130289 => "Ningbo\,\ Zhejiang",
  861302900 => "Changchun\,\ Jilin",
  861302901 => "Changchun\,\ Jilin",
  861302902 => "Siping\,\ Jilin",
  861302903 => "Siping\,\ Jilin",
  861302904 => "Liaoyuan\,\ Jilin",
  861302905 => "Songyuan\,\ Jilin",
  861302906 => "Baicheng\,\ Jilin",
  861302907 => "Baishan\,\ Jilin",
  861302908 => "Yanbian\,\ Jilin",
  861302909 => "Yanbian\,\ Jilin",
  861302910 => "Changchun\,\ Jilin",
  861302911 => "Changchun\,\ Jilin",
  861302912 => "Changchun\,\ Jilin",
  861302913 => "Changchun\,\ Jilin",
  861302914 => "Changchun\,\ Jilin",
  861302915 => "Jilin\,\ Jilin",
  861302916 => "Jilin\,\ Jilin",
  861302917 => "Jilin\,\ Jilin",
  861302918 => "Jilin\,\ Jilin",
  861302919 => "Tonghua\,\ Jilin",
  861302920 => "Dandong\,\ Liaoning",
  861302921 => "Dandong\,\ Liaoning",
  861302922 => "Benxi\,\ Liaoning",
  861302923 => "Benxi\,\ Liaoning",
  861302924 => "Fushun\,\ Liaoning",
  861302925 => "Fushun\,\ Liaoning",
  861302926 => "Fushun\,\ Liaoning",
  861302927 => "Tieling\,\ Liaoning",
  861302928 => "Huludao\,\ Liaoning",
  861302929 => "Huludao\,\ Liaoning",
  861302930 => "Yingkou\,\ Liaoning",
  861302931 => "Yingkou\,\ Liaoning",
  861302932 => "Yingkou\,\ Liaoning",
  861302933 => "Jinzhou\,\ Liaoning",
  861302934 => "Jinzhou\,\ Liaoning",
  861302935 => "Jinzhou\,\ Liaoning",
  861302936 => "Anshan\,\ Liaoning",
  861302937 => "Anshan\,\ Liaoning",
  861302938 => "Anshan\,\ Liaoning",
  861302939 => "Anshan\,\ Liaoning",
  86130294 => "Dalian\,\ Liaoning",
  861302950 => "Hohhot\,\ Inner\ Mongolia",
  861302951 => "Hohhot\,\ Inner\ Mongolia",
  861302952 => "Hohhot\,\ Inner\ Mongolia",
  861302953 => "Ulanqab\,\ Inner\ Mongolia",
  861302954 => "Baotou\,\ Inner\ Mongolia",
  861302955 => "Baotou\,\ Inner\ Mongolia",
  861302956 => "Baotou\,\ Inner\ Mongolia",
  861302957 => "Ordos\,\ Inner\ Mongolia",
  861302958 => "Bayannur\,\ Inner\ Mongolia",
  861302959 => "Wuhai\,\ Inner\ Mongolia",
  861302960 => "Changji\,\ Xinjiang",
  861302961 => "Shihezi\,\ Xinjiang",
  861302962 => "Bayingolin\,\ Xinjiang",
  861302963 => "Kashi\,\ Xinjiang",
  861302964 => "Urumchi\,\ Xinjiang",
  861302965 => "Urumchi\,\ Xinjiang",
  861302966 => "Urumchi\,\ Xinjiang",
  861302967 => "Urumchi\,\ Xinjiang",
  861302968 => "Wenzhou\,\ Zhejiang",
  861302969 => "Wenzhou\,\ Zhejiang",
  861302970 => "Harbin\,\ Heilongjiang",
  861302971 => "Harbin\,\ Heilongjiang",
  861302972 => "Harbin\,\ Heilongjiang",
  861302973 => "Qiqihar\,\ Heilongjiang",
  861302974 => "Qiqihar\,\ Heilongjiang",
  861302975 => "Qiqihar\,\ Heilongjiang",
  861302976 => "Hegang\,\ Heilongjiang",
  861302977 => "Shuangyashan\,\ Heilongjiang",
  861302978 => "Jiamusi\,\ Heilongjiang",
  861302979 => "Qitaihe\,\ Heilongjiang",
  861302980 => "Harbin\,\ Heilongjiang",
  861302981 => "Daqing\,\ Heilongjiang",
  861302982 => "Daqing\,\ Heilongjiang",
  861302983 => "Daqing\,\ Heilongjiang",
  861302984 => "Harbin\,\ Heilongjiang",
  861302985 => "Harbin\,\ Heilongjiang",
  861302986 => "Harbin\,\ Heilongjiang",
  861302987 => "Harbin\,\ Heilongjiang",
  861302988 => "Mudanjiang\,\ Heilongjiang",
  861302989 => "Jixi\,\ Heilongjiang",
  861302990 => "Daqing\,\ Heilongjiang",
  861302991 => "Suihua\,\ Heilongjiang",
  861302992 => "Suihua\,\ Heilongjiang",
  861302993 => "Heihe\,\ Heilongjiang",
  861302994 => "Heihe\,\ Heilongjiang",
  861302995 => "Mudanjiang\,\ Heilongjiang",
  861302996 => "Mudanjiang\,\ Heilongjiang",
  861302997 => "Jiamusi\,\ Heilongjiang",
  861302998 => "Jiamusi\,\ Heilongjiang",
  861302999 => "Harbin\,\ Heilongjiang",
  86130300 => "Harbin\,\ Heilongjiang",
  861303010 => "Shaoguan\,\ Guangdong",
  861303011 => "Shaoguan\,\ Guangdong",
  861303012 => "Shaoguan\,\ Guangdong",
  861303013 => "Shaoguan\,\ Guangdong",
  861303014 => "Shaoguan\,\ Guangdong",
  861303015 => "Zhanjiang\,\ Guangdong",
  861303016 => "Zhanjiang\,\ Guangdong",
  861303017 => "Zhanjiang\,\ Guangdong",
  861303018 => "Zhanjiang\,\ Guangdong",
  861303019 => "Zhanjiang\,\ Guangdong",
  861303020 => "Zhaoqing\,\ Guangdong",
  861303021 => "Zhaoqing\,\ Guangdong",
  861303022 => "Zhaoqing\,\ Guangdong",
  861303023 => "Zhaoqing\,\ Guangdong",
  861303024 => "Zhaoqing\,\ Guangdong",
  861303025 => "Zhaoqing\,\ Guangdong",
  861303026 => "Zhaoqing\,\ Guangdong",
  861303027 => "Yunfu\,\ Guangdong",
  861303028 => "Yunfu\,\ Guangdong",
  861303029 => "Yunfu\,\ Guangdong",
  861303030 => "Puyang\,\ Henan",
  861303031 => "Puyang\,\ Henan",
  861303032 => "Puyang\,\ Henan",
  861303033 => "Puyang\,\ Henan",
  861303034 => "Sanmenxia\,\ Henan",
  861303035 => "Sanmenxia\,\ Henan",
  861303036 => "Sanmenxia\,\ Henan",
  861303037 => "Sanmenxia\,\ Henan",
  861303038 => "Sanmenxia\,\ Henan",
  861303039 => "Hebi\,\ Henan",
  861303040 => "Hulun\,\ Inner\ Mongolia",
  861303041 => "Hulun\,\ Inner\ Mongolia",
  861303042 => "Hulun\,\ Inner\ Mongolia",
  861303043 => "Hinggan\,\ Inner\ Mongolia",
  861303044 => "Hinggan\,\ Inner\ Mongolia",
  861303045 => "Xilin\,\ Inner\ Mongolia",
  861303046 => "Baotou\,\ Inner\ Mongolia",
  861303047 => "Baotou\,\ Inner\ Mongolia",
  861303048 => "Baotou\,\ Inner\ Mongolia",
  861303049 => "Baotou\,\ Inner\ Mongolia",
  861303050 => "Jingdezhen\,\ Jiangxi",
  861303051 => "Jingdezhen\,\ Jiangxi",
  861303052 => "JiAn\,\ Jiangxi",
  861303053 => "JiAn\,\ Jiangxi",
  861303054 => "JiAn\,\ Jiangxi",
  861303055 => "Xinyu\,\ Jiangxi",
  861303056 => "Pingxiang\,\ Jiangxi",
  861303057 => "Fuzhou\,\ Jiangxi",
  861303058 => "Fuzhou\,\ Jiangxi",
  861303059 => "Fuzhou\,\ Jiangxi",
  861303060 => "Huaibei\,\ Anhui",
  861303061 => "Huaibei\,\ Anhui",
  861303062 => "Chizhou\,\ Anhui",
  861303063 => "Chuzhou\,\ Anhui",
  861303064 => "Bozhou\,\ Anhui",
  861303065 => "Bozhou\,\ Anhui",
  861303066 => "Fuyang\,\ Anhui",
  861303067 => "Fuyang\,\ Anhui",
  861303068 => "Fuyang\,\ Anhui",
  861303069 => "Bozhou\,\ Anhui",
  861303070 => "Fushun\,\ Liaoning",
  861303071 => "Fushun\,\ Liaoning",
  861303072 => "Benxi\,\ Liaoning",
  861303073 => "Benxi\,\ Liaoning",
  861303074 => "Dandong\,\ Liaoning",
  861303075 => "Dandong\,\ Liaoning",
  861303076 => "Panjin\,\ Liaoning",
  861303077 => "Panjin\,\ Liaoning",
  861303078 => "Tieling\,\ Liaoning",
  861303079 => "Tieling\,\ Liaoning",
  861303080 => "Sanming\,\ Fujian",
  861303081 => "Putian\,\ Fujian",
  861303082 => "Putian\,\ Fujian",
  861303083 => "Putian\,\ Fujian",
  861303084 => "Xiamen\,\ Fujian",
  861303085 => "Putian\,\ Fujian",
  861303086 => "Putian\,\ Fujian",
  861303087 => "Xiamen\,\ Fujian",
  861303088 => "Xiamen\,\ Fujian",
  861303089 => "Xiamen\,\ Fujian",
  861303090 => "Ningde\,\ Fujian",
  861303091 => "Ningde\,\ Fujian",
  861303092 => "Ningde\,\ Fujian",
  861303093 => "Ningde\,\ Fujian",
  861303094 => "Quanzhou\,\ Fujian",
  861303095 => "Ningde\,\ Fujian",
  861303096 => "Ningde\,\ Fujian",
  861303097 => "Quanzhou\,\ Fujian",
  861303098 => "Quanzhou\,\ Fujian",
  861303099 => "Quanzhou\,\ Fujian",
  86130310 => "Beijing",
  86130311 => "Beijing",
  861303120 => "Turpan\,\ Xinjiang",
  861303121 => "Hami\,\ Xinjiang",
  861303122 => "Hami\,\ Xinjiang",
  861303123 => "Bayingolin\,\ Xinjiang",
  861303124 => "Bayingolin\,\ Xinjiang",
  861303125 => "Bayingolin\,\ Xinjiang",
  861303126 => "Aksu\,\ Xinjiang",
  861303127 => "Aksu\,\ Xinjiang",
  861303128 => "Kashi\,\ Xinjiang",
  861303129 => "Kashi\,\ Xinjiang",
  861303130 => "Ili\,\ Xinjiang",
  861303131 => "Ili\,\ Xinjiang",
  861303132 => "Shihezi\,\ Xinjiang",
  861303133 => "Shihezi\,\ Xinjiang",
  861303134 => "Bortala\,\ Xinjiang",
  861303135 => "Bortala\,\ Xinjiang",
  861303136 => "Ili\,\ Xinjiang",
  861303137 => "Ili\,\ Xinjiang",
  861303138 => "Karamay\,\ Xinjiang",
  861303139 => "Karamay\,\ Xinjiang",
  861303140 => "Chengde\,\ Hebei",
  861303141 => "Chengde\,\ Hebei",
  861303142 => "Chengde\,\ Hebei",
  861303143 => "Qinhuangdao\,\ Hebei",
  861303144 => "Shijiazhuang\,\ Hebei",
  861303145 => "Handan\,\ Hebei",
  861303146 => "Handan\,\ Hebei",
  861303147 => "Handan\,\ Hebei",
  861303148 => "Langfang\,\ Hebei",
  861303149 => "Langfang\,\ Hebei",
  861303150 => "Tangshan\,\ Hebei",
  861303151 => "Tangshan\,\ Hebei",
  861303152 => "Tangshan\,\ Hebei",
  861303153 => "Tangshan\,\ Hebei",
  861303154 => "Tangshan\,\ Hebei",
  861303155 => "Tangshan\,\ Hebei",
  861303156 => "Tangshan\,\ Hebei",
  861303157 => "Tangshan\,\ Hebei",
  861303158 => "Tangshan\,\ Hebei",
  861303159 => "Cangzhou\,\ Hebei",
  861303160 => "Yantai\,\ Shandong",
  861303161 => "Yantai\,\ Shandong",
  861303162 => "Yantai\,\ Shandong",
  861303163 => "Yantai\,\ Shandong",
  861303164 => "Yantai\,\ Shandong",
  861303165 => "Yantai\,\ Shandong",
  861303166 => "Weifang\,\ Shandong",
  861303167 => "Weifang\,\ Shandong",
  861303168 => "Weifang\,\ Shandong",
  861303169 => "Weifang\,\ Shandong",
  861303170 => "Jinan\,\ Shandong",
  861303171 => "Jinan\,\ Shandong",
  861303172 => "Jinan\,\ Shandong",
  861303173 => "Jinan\,\ Shandong",
  861303174 => "Jinan\,\ Shandong",
  861303175 => "Laiwu\,\ Shandong",
  861303176 => "Laiwu\,\ Shandong",
  861303177 => "Zibo\,\ Shandong",
  861303178 => "Zibo\,\ Shandong",
  861303179 => "Zibo\,\ Shandong",
  861303180 => "Langfang\,\ Hebei",
  861303181 => "Langfang\,\ Hebei",
  861303182 => "Hengshui\,\ Hebei",
  861303183 => "Hengshui\,\ Hebei",
  861303184 => "Hengshui\,\ Hebei",
  861303185 => "Hengshui\,\ Hebei",
  861303186 => "Qinhuangdao\,\ Hebei",
  861303187 => "Qinhuangdao\,\ Hebei",
  861303188 => "Qinhuangdao\,\ Hebei",
  861303189 => "Cangzhou\,\ Hebei",
  861303190 => "Xingtai\,\ Hebei",
  861303191 => "Xingtai\,\ Hebei",
  861303192 => "Xingtai\,\ Hebei",
  861303193 => "Zhangjiakou\,\ Hebei",
  861303194 => "Zhangjiakou\,\ Hebei",
  861303195 => "Zhangjiakou\,\ Hebei",
  861303196 => "Zhangjiakou\,\ Hebei",
  861303197 => "Zhangjiakou\,\ Hebei",
  861303198 => "Handan\,\ Hebei",
  861303199 => "Handan\,\ Hebei",
  861303200 => "Baoding\,\ Hebei",
  861303201 => "Baoding\,\ Hebei",
  861303202 => "Baoding\,\ Hebei",
  861303203 => "Baoding\,\ Hebei",
  861303204 => "Baoding\,\ Hebei",
  861303205 => "Baoding\,\ Hebei",
  861303206 => "Baoding\,\ Hebei",
  861303207 => "Baoding\,\ Hebei",
  861303208 => "Baoding\,\ Hebei",
  861303209 => "Chengde\,\ Hebei",
  86130321 => "Shanghai",
  86130322 => "Tianjin",
  86130323 => "Chongqing",
  86130324 => "Shenyang\,\ Liaoning",
  861303250 => "Changzhou\,\ Jiangsu",
  861303251 => "Changzhou\,\ Jiangsu",
  861303252 => "Suzhou\,\ Jiangsu",
  861303253 => "Suzhou\,\ Jiangsu",
  861303254 => "Nanjing\,\ Jiangsu",
  861303255 => "Nanjing\,\ Jiangsu",
  861303256 => "Yangzhou\,\ Jiangsu",
  861303257 => "Yangzhou\,\ Jiangsu",
  861303258 => "Suqian\,\ Jiangsu",
  861303259 => "Yancheng\,\ Jiangsu",
  86130326 => "Shijiazhuang\,\ Hebei",
  861303270 => "Yichang\,\ Hubei",
  861303271 => "Yichang\,\ Hubei",
  861303272 => "Yichang\,\ Hubei",
  861303273 => "Yichang\,\ Hubei",
  861303274 => "Yichang\,\ Hubei",
  861303275 => "Jingmen\,\ Hubei",
  861303276 => "Jingmen\,\ Hubei",
  861303277 => "Jingmen\,\ Hubei",
  861303278 => "Enshi\,\ Hubei",
  861303279 => "Enshi\,\ Hubei",
  86130328 => "Chengdu\,\ Sichuan",
  86130329 => "XiAn\,\ Shaanxi",
  861303300 => "Hefei\,\ Anhui",
  861303301 => "Bengbu\,\ Anhui",
  861303302 => "Bengbu\,\ Anhui",
  861303303 => "Wuhu\,\ Anhui",
  861303304 => "Wuhu\,\ Anhui",
  861303305 => "Hefei\,\ Anhui",
  861303306 => "Hefei\,\ Anhui",
  861303307 => "Huainan\,\ Anhui",
  861303308 => "Hefei\,\ Anhui",
  861303309 => "Hefei\,\ Anhui",
  861303310 => "MaAnshan\,\ Anhui",
  861303311 => "MaAnshan\,\ Anhui",
  861303312 => "Huangshan\,\ Anhui",
  861303313 => "Xuancheng\,\ Anhui",
  861303314 => "Xuancheng\,\ Anhui",
  861303315 => "Tongling\,\ Anhui",
  861303316 => "Anqing\,\ Anhui",
  861303317 => "Anqing\,\ Anhui",
  861303318 => "Anqing\,\ Anhui",
  861303319 => "Anqing\,\ Anhui",
  861303320 => "Ganzhou\,\ Jiangxi",
  861303321 => "Ganzhou\,\ Jiangxi",
  861303322 => "Ganzhou\,\ Jiangxi",
  861303323 => "Ganzhou\,\ Jiangxi",
  861303324 => "Ganzhou\,\ Jiangxi",
  861303325 => "Ganzhou\,\ Jiangxi",
  861303326 => "Ganzhou\,\ Jiangxi",
  861303327 => "Ganzhou\,\ Jiangxi",
  861303328 => "Ganzhou\,\ Jiangxi",
  861303329 => "JiAn\,\ Jiangxi",
  861303330 => "Wenshan\,\ Yunnan",
  861303331 => "Puer\,\ Yunnan",
  861303332 => "Baoshan\,\ Yunnan",
  861303333 => "Kunming\,\ Yunnan",
  861303334 => "Kunming\,\ Yunnan",
  861303335 => "Kunming\,\ Yunnan",
  861303336 => "Kunming\,\ Yunnan",
  861303337 => "Kunming\,\ Yunnan",
  861303338 => "Kunming\,\ Yunnan",
  861303339 => "Kunming\,\ Yunnan",
  861303340 => "Xinzhou\,\ Shanxi",
  861303341 => "Yuncheng\,\ Shanxi",
  861303342 => "Linfen\,\ Shanxi",
  861303343 => "Jinzhong\,\ Shanxi",
  861303344 => "Yuncheng\,\ Shanxi",
  861303345 => "Shuozhou\,\ Shanxi",
  861303346 => "Changzhi\,\ Shanxi",
  861303347 => "Lüliang\,\ Shanxi",
  861303348 => "Taiyuan\,\ Shanxi",
  861303349 => "Datong\,\ Shanxi",
  861303350 => "Wuxi\,\ Jiangsu",
  861303351 => "Wuxi\,\ Jiangsu",
  861303352 => "Lianyungang\,\ Jiangsu",
  861303353 => "Xuzhou\,\ Jiangsu",
  861303354 => "Xuzhou\,\ Jiangsu",
  861303355 => "HuaiAn\,\ Jiangsu",
  861303356 => "Nantong\,\ Jiangsu",
  861303357 => "Nantong\,\ Jiangsu",
  861303358 => "Taizhou\,\ Jiangsu",
  861303359 => "Zhenjiang\,\ Jiangsu",
  861303360 => "Hangzhou\,\ Zhejiang",
  861303361 => "Hangzhou\,\ Zhejiang",
  861303362 => "Wenzhou\,\ Zhejiang",
  861303363 => "Wenzhou\,\ Zhejiang",
  861303364 => "Taizhou\,\ Zhejiang",
  861303365 => "Taizhou\,\ Zhejiang",
  861303366 => "Jinhua\,\ Zhejiang",
  861303367 => "Jiaxing\,\ Zhejiang",
  861303368 => "Lishui\,\ Zhejiang",
  861303369 => "Shaoxing\,\ Zhejiang",
  86130337 => "Xinyang\,\ Henan",
  861303380 => "Zhumadian\,\ Henan",
  861303381 => "Zhumadian\,\ Henan",
  861303382 => "Zhumadian\,\ Henan",
  861303383 => "Zhumadian\,\ Henan",
  861303384 => "Zhumadian\,\ Henan",
  861303385 => "Zhumadian\,\ Henan",
  861303386 => "Zhumadian\,\ Henan",
  861303387 => "Hebi\,\ Henan",
  861303388 => "Hebi\,\ Henan",
  861303389 => "Hebi\,\ Henan",
  861303390 => "Zhoukou\,\ Henan",
  861303391 => "Zhoukou\,\ Henan",
  861303392 => "Zhoukou\,\ Henan",
  861303393 => "Zhoukou\,\ Henan",
  861303394 => "Zhoukou\,\ Henan",
  861303395 => "Zhoukou\,\ Henan",
  861303396 => "Zhoukou\,\ Henan",
  861303397 => "Zhoukou\,\ Henan",
  861303398 => "Puyang\,\ Henan",
  861303399 => "Puyang\,\ Henan",
  861303400 => "Suzhou\,\ Anhui",
  861303401 => "Suzhou\,\ Anhui",
  861303402 => "LuAn\,\ Anhui",
  861303403 => "LuAn\,\ Anhui",
  861303404 => "Hefei\,\ Anhui",
  861303405 => "Hefei\,\ Anhui",
  861303406 => "Fuyang\,\ Anhui",
  861303407 => "Fuyang\,\ Anhui",
  861303408 => "Fuyang\,\ Anhui",
  861303409 => "Fuyang\,\ Anhui",
  861303410 => "Qingyang\,\ Gansu",
  861303411 => "Tianshui\,\ Gansu",
  861303412 => "Tianshui\,\ Gansu",
  861303413 => "Linxia\,\ Gansu",
  861303414 => "Dingxi\,\ Gansu",
  861303415 => "Baiyin\,\ Gansu",
  861303416 => "Baiyin\,\ Gansu",
  861303417 => "Pingliang\,\ Gansu",
  861303418 => "Pingliang\,\ Gansu",
  861303419 => "Qingyang\,\ Gansu",
  861303420 => "Hangzhou\,\ Zhejiang",
  861303421 => "Hangzhou\,\ Zhejiang",
  861303422 => "Wenzhou\,\ Zhejiang",
  861303423 => "Wenzhou\,\ Zhejiang",
  861303424 => "Lishui\,\ Zhejiang",
  861303425 => "Jinhua\,\ Zhejiang",
  861303426 => "Shaoxing\,\ Zhejiang",
  861303427 => "Jiaxing\,\ Zhejiang",
  861303428 => "Taizhou\,\ Zhejiang",
  861303429 => "Taizhou\,\ Zhejiang",
  86130343 => "Tianjin",
  861303440 => "Huangshi\,\ Hubei",
  861303441 => "Huangshi\,\ Hubei",
  861303442 => "Huangshi\,\ Hubei",
  861303443 => "Huangshi\,\ Hubei",
  861303444 => "Ezhou\,\ Hubei",
  861303445 => "Ezhou\,\ Hubei",
  861303446 => "Huanggang\,\ Hubei",
  861303447 => "Huanggang\,\ Hubei",
  861303448 => "Huanggang\,\ Hubei",
  861303449 => "Huanggang\,\ Hubei",
  861303450 => "Zibo\,\ Shandong",
  861303451 => "Zibo\,\ Shandong",
  861303452 => "Binzhou\,\ Shandong",
  861303453 => "Liaocheng\,\ Shandong",
  861303454 => "Liaocheng\,\ Shandong",
  861303455 => "Heze\,\ Shandong",
  861303456 => "Weihai\,\ Shandong",
  861303457 => "Weihai\,\ Shandong",
  861303458 => "Weihai\,\ Shandong",
  861303459 => "Weihai\,\ Shandong",
  86130346 => "Ningbo\,\ Zhejiang",
  861303470 => "Xilin\,\ Inner\ Mongolia",
  861303471 => "Hohhot\,\ Inner\ Mongolia",
  861303472 => "Tongliao\,\ Inner\ Mongolia",
  861303473 => "Wuhai\,\ Inner\ Mongolia",
  861303474 => "Ulanqab\,\ Inner\ Mongolia",
  861303475 => "Tongliao\,\ Inner\ Mongolia",
  861303476 => "Chifeng\,\ Inner\ Mongolia",
  861303477 => "Ordos\,\ Inner\ Mongolia",
  861303478 => "Bayannur\,\ Inner\ Mongolia",
  861303479 => "Chifeng\,\ Inner\ Mongolia",
  861303480 => "Loudi\,\ Hunan",
  861303481 => "Loudi\,\ Hunan",
  861303482 => "Loudi\,\ Hunan",
  861303483 => "Loudi\,\ Hunan",
  861303484 => "Loudi\,\ Hunan",
  861303485 => "Huaihua\,\ Hunan",
  861303486 => "Huaihua\,\ Hunan",
  861303487 => "Huaihua\,\ Hunan",
  861303488 => "Huaihua\,\ Hunan",
  861303489 => "Huaihua\,\ Hunan",
  86130349 => "Haikou\,\ Hainan",
  861303500 => "Suzhou\,\ Anhui",
  861303501 => "Bengbu\,\ Anhui",
  861303502 => "Bengbu\,\ Anhui",
  861303503 => "Chuzhou\,\ Anhui",
  861303504 => "Wuhu\,\ Anhui",
  861303505 => "Hefei\,\ Anhui",
  861303506 => "Hefei\,\ Anhui",
  861303507 => "Fuyang\,\ Anhui",
  861303508 => "Fuyang\,\ Anhui",
  861303509 => "Hefei\,\ Anhui",
  861303510 => "Wuhan\,\ Hubei",
  861303511 => "Wuhan\,\ Hubei",
  861303512 => "Wuhan\,\ Hubei",
  861303513 => "Wuhan\,\ Hubei",
  861303514 => "Wuhan\,\ Hubei",
  861303515 => "Xiaogan\,\ Hubei",
  861303516 => "Xiaogan\,\ Hubei",
  861303517 => "Xiaogan\,\ Hubei",
  861303518 => "Xiaogan\,\ Hubei",
  861303519 => "Suizhou\,\ Hubei",
  861303520 => "Xiangfan\,\ Hubei",
  861303521 => "Xiangfan\,\ Hubei",
  861303522 => "Xiangfan\,\ Hubei",
  861303523 => "Xiangfan\,\ Hubei",
  861303524 => "Xiangfan\,\ Hubei",
  861303525 => "Shiyan\,\ Hubei",
  861303526 => "Shiyan\,\ Hubei",
  861303527 => "Shiyan\,\ Hubei",
  861303528 => "Shiyan\,\ Hubei",
  861303529 => "Shiyan\,\ Hubei",
  861303530 => "Jingzhou\,\ Hubei",
  861303531 => "Jingzhou\,\ Hubei",
  861303532 => "Jingzhou\,\ Hubei",
  861303533 => "Jingzhou\,\ Hubei",
  861303534 => "Wuhan\,\ Hubei",
  861303535 => "Wuhan\,\ Hubei",
  861303536 => "Wuhan\,\ Hubei",
  861303537 => "Wuhan\,\ Hubei",
  861303538 => "Wuhan\,\ Hubei",
  861303539 => "Wuhan\,\ Hubei",
  861303540 => "Hefei\,\ Anhui",
  861303541 => "Fuyang\,\ Anhui",
  861303542 => "LuAn\,\ Anhui",
  861303543 => "Huangshan\,\ Anhui",
  861303544 => "MaAnshan\,\ Anhui",
  861303545 => "Chuzhou\,\ Anhui",
  861303546 => "Huaibei\,\ Anhui",
  861303547 => "Huainan\,\ Anhui",
  861303548 => "Tongling\,\ Anhui",
  861303549 => "Chizhou\,\ Anhui",
  861303550 => "Zunyi\,\ Guizhou",
  861303551 => "Zunyi\,\ Guizhou",
  861303552 => "Zunyi\,\ Guizhou",
  861303553 => "Zunyi\,\ Guizhou",
  861303554 => "Bijie\,\ Guizhou",
  861303555 => "Qiannan\,\ Guizhou",
  861303556 => "Qiandongnan\,\ Guizhou",
  861303557 => "Tongren\,\ Guizhou",
  861303558 => "Anshun\,\ Guizhou",
  861303559 => "Qianxinan\,\ Guizhou",
  861303560 => "Zigong\,\ Sichuan",
  861303561 => "Guangyuan\,\ Sichuan",
  861303562 => "Guangyuan\,\ Sichuan",
  861303563 => "Mianyang\,\ Sichuan",
  861303564 => "Mianyang\,\ Sichuan",
  861303565 => "Mianyang\,\ Sichuan",
  861303566 => "Mianyang\,\ Sichuan",
  861303567 => "Mianyang\,\ Sichuan",
  861303568 => "Mianyang\,\ Sichuan",
  861303569 => "Mianyang\,\ Sichuan",
  861303570 => "Heyuan\,\ Guangdong",
  861303571 => "Heyuan\,\ Guangdong",
  861303572 => "Heyuan\,\ Guangdong",
  861303573 => "Heyuan\,\ Guangdong",
  861303574 => "Meizhou\,\ Guangdong",
  861303575 => "Meizhou\,\ Guangdong",
  861303576 => "Meizhou\,\ Guangdong",
  861303577 => "Meizhou\,\ Guangdong",
  861303578 => "Meizhou\,\ Guangdong",
  861303579 => "Meizhou\,\ Guangdong",
  861303580 => "Maoming\,\ Guangdong",
  861303581 => "Maoming\,\ Guangdong",
  861303582 => "Maoming\,\ Guangdong",
  861303583 => "Maoming\,\ Guangdong",
  861303584 => "Maoming\,\ Guangdong",
  861303585 => "Maoming\,\ Guangdong",
  861303586 => "Yangjiang\,\ Guangdong",
  861303587 => "Yangjiang\,\ Guangdong",
  861303588 => "Shijiazhuang\,\ Hebei",
  861303589 => "Yangjiang\,\ Guangdong",
  861303590 => "Honghe\,\ Yunnan",
  861303591 => "Honghe\,\ Yunnan",
  861303592 => "Lincang\,\ Yunnan",
  861303593 => "Nujiang\,\ Yunnan",
  861303594 => "Dehong\,\ Yunnan",
  861303595 => "Dehong\,\ Yunnan",
  861303596 => "Dehong\,\ Yunnan",
  861303597 => "Xishuangbanna\,\ Yunnan",
  861303598 => "Xishuangbanna\,\ Yunnan",
  861303599 => "Xishuangbanna\,\ Yunnan",
  86130360 => "Haikou\,\ Hainan",
  861303610 => "Wuhan\,\ Hubei",
  861303611 => "Wuhan\,\ Hubei",
  861303612 => "Wuhan\,\ Hubei",
  861303613 => "Wuhan\,\ Hubei",
  861303614 => "Wuhan\,\ Hubei",
  861303615 => "Wuhan\,\ Hubei",
  861303616 => "Wuhan\,\ Hubei",
  861303617 => "Xianning\,\ Hubei",
  861303618 => "Xianning\,\ Hubei",
  861303619 => "Xianning\,\ Hubei",
  861303620 => "Nanchang\,\ Jiangxi",
  861303621 => "Nanchang\,\ Jiangxi",
  861303622 => "Yingtan\,\ Jiangxi",
  861303623 => "Yingtan\,\ Jiangxi",
  861303624 => "Shangrao\,\ Jiangxi",
  861303625 => "Shangrao\,\ Jiangxi",
  861303626 => "Yichun\,\ Jiangxi",
  861303627 => "Yichun\,\ Jiangxi",
  861303628 => "Xinyu\,\ Jiangxi",
  861303629 => "Pingxiang\,\ Jiangxi",
  86130363 => "Chongqing",
  861303640 => "Zigong\,\ Sichuan",
  861303641 => "Zigong\,\ Sichuan",
  861303642 => "Luzhou\,\ Sichuan",
  861303643 => "Luzhou\,\ Sichuan",
  861303644 => "Meishan\,\ Sichuan",
  861303645 => "Leshan\,\ Sichuan",
  861303646 => "Suining\,\ Sichuan",
  861303647 => "Dazhou\,\ Sichuan",
  861303648 => "Yibin\,\ Sichuan",
  861303649 => "Yibin\,\ Sichuan",
  861303650 => "Yibin\,\ Sichuan",
  861303651 => "Yibin\,\ Sichuan",
  861303652 => "Yibin\,\ Sichuan",
  861303653 => "Yibin\,\ Sichuan",
  861303654 => "Luzhou\,\ Sichuan",
  861303655 => "Luzhou\,\ Sichuan",
  861303656 => "Nanchong\,\ Sichuan",
  861303657 => "Leshan\,\ Sichuan",
  861303658 => "Leshan\,\ Sichuan",
  861303659 => "Leshan\,\ Sichuan",
  861303660 => "Meishan\,\ Sichuan",
  861303661 => "Meishan\,\ Sichuan",
  861303662 => "Dazhou\,\ Sichuan",
  861303663 => "Dazhou\,\ Sichuan",
  861303664 => "Dazhou\,\ Sichuan",
  861303665 => "Dazhou\,\ Sichuan",
  861303666 => "Chengdu\,\ Sichuan",
  861303667 => "Chengdu\,\ Sichuan",
  861303668 => "Chengdu\,\ Sichuan",
  861303669 => "Chengdu\,\ Sichuan",
  861303670 => "Shaoyang\,\ Hunan",
  861303671 => "Shaoyang\,\ Hunan",
  861303672 => "Shaoyang\,\ Hunan",
  861303673 => "Shaoyang\,\ Hunan",
  861303674 => "Shaoyang\,\ Hunan",
  861303675 => "Zhangjiajie\,\ Hunan",
  861303676 => "Zhangjiajie\,\ Hunan",
  861303677 => "Yongzhou\,\ Hunan",
  861303678 => "Changsha\,\ Hunan",
  861303679 => "Changsha\,\ Hunan",
  861303680 => "Guigang\,\ Guangxi",
  861303681 => "Nanning\,\ Guangxi",
  861303682 => "Liuzhou\,\ Guangxi",
  861303683 => "Guilin\,\ Guangxi",
  861303684 => "Wuzhou\,\ Guangxi",
  861303685 => "Guigang\,\ Guangxi",
  861303686 => "Nanning\,\ Guangxi",
  861303687 => "Hezhou\,\ Guangxi",
  861303688 => "Nanning\,\ Guangxi",
  861303689 => "Beihai\,\ Guangxi",
  861303690 => "Fangchenggang\,\ Guangxi",
  861303691 => "Nanning\,\ Guangxi",
  861303692 => "Liuzhou\,\ Guangxi",
  861303693 => "Guilin\,\ Guangxi",
  861303694 => "Wuzhou\,\ Guangxi",
  861303695 => "Yulin\,\ Guangxi",
  861303696 => "Baise\,\ Guangxi",
  861303697 => "Qinzhou\,\ Guangxi",
  861303698 => "Hechi\,\ Guangxi",
  861303699 => "Beihai\,\ Guangxi",
  861303700 => "Xinzhou\,\ Shanxi",
  861303701 => "Xinzhou\,\ Shanxi",
  861303702 => "Xinzhou\,\ Shanxi",
  861303703 => "Shuozhou\,\ Shanxi",
  861303704 => "Shuozhou\,\ Shanxi",
  861303705 => "Yangquan\,\ Shanxi",
  861303706 => "Yangquan\,\ Shanxi",
  861303707 => "Lüliang\,\ Shanxi",
  861303708 => "Lüliang\,\ Shanxi",
  861303709 => "Lüliang\,\ Shanxi",
  86130371 => "Wuhan\,\ Hubei",
  861303720 => "Nanchang\,\ Jiangxi",
  861303721 => "Nanchang\,\ Jiangxi",
  861303722 => "Nanchang\,\ Jiangxi",
  861303723 => "Nanchang\,\ Jiangxi",
  861303724 => "Nanchang\,\ Jiangxi",
  861303725 => "Jiujiang\,\ Jiangxi",
  861303726 => "Jiujiang\,\ Jiangxi",
  861303727 => "Jiujiang\,\ Jiangxi",
  861303728 => "Nanchang\,\ Jiangxi",
  861303729 => "Jiujiang\,\ Jiangxi",
  861303730 => "Yueyang\,\ Hunan",
  861303731 => "Changsha\,\ Hunan",
  861303732 => "Xiangtan\,\ Hunan",
  861303733 => "Zhuzhou\,\ Hunan",
  861303734 => "Hengyang\,\ Hunan",
  861303735 => "Chenzhou\,\ Hunan",
  861303736 => "Changde\,\ Hunan",
  861303737 => "Yiyang\,\ Hunan",
  861303738 => "Loudi\,\ Hunan",
  861303739 => "Shaoyang\,\ Hunan",
  861303740 => "Xiangxi\,\ Hunan",
  861303741 => "Xiangxi\,\ Hunan",
  861303742 => "Xiangxi\,\ Hunan",
  861303743 => "Xiangxi\,\ Hunan",
  861303744 => "Zhangjiajie\,\ Hunan",
  861303745 => "Huaihua\,\ Hunan",
  861303746 => "Yongzhou\,\ Hunan",
  861303747 => "Yongzhou\,\ Hunan",
  861303748 => "Yongzhou\,\ Hunan",
  861303749 => "Yongzhou\,\ Hunan",
  86130375 => "Shangqiu\,\ Henan",
  86130376 => "Nanyang\,\ Henan",
  861303770 => "Panzhihua\,\ Sichuan",
  861303771 => "Panzhihua\,\ Sichuan",
  861303772 => "Panzhihua\,\ Sichuan",
  861303773 => "Panzhihua\,\ Sichuan",
  861303774 => "Liangshan\,\ Sichuan",
  861303775 => "Liangshan\,\ Sichuan",
  861303776 => "Liangshan\,\ Sichuan",
  861303777 => "Liangshan\,\ Sichuan",
  861303778 => "Liangshan\,\ Sichuan",
  861303779 => "Liangshan\,\ Sichuan",
  86130378 => "Guiyang\,\ Guizhou",
  861303790 => "Shizuishan\,\ Ningxia",
  861303791 => "Shizuishan\,\ Ningxia",
  861303792 => "Wuzhong\,\ Ningxia",
  861303793 => "Wuzhong\,\ Ningxia",
  861303794 => "Wuzhong\,\ Ningxia",
  861303795 => "Guyuan\,\ Ningxia",
  861303796 => "Yinchuan\,\ Ningxia",
  861303797 => "Yinchuan\,\ Ningxia",
  861303798 => "Yinchuan\,\ Ningxia",
  861303799 => "Yinchuan\,\ Ningxia",
  861303800 => "Taiyuan\,\ Shanxi",
  861303801 => "Yuncheng\,\ Shanxi",
  861303802 => "Linfen\,\ Shanxi",
  861303803 => "Jinzhong\,\ Shanxi",
  861303804 => "Yuncheng\,\ Shanxi",
  861303805 => "Jincheng\,\ Shanxi",
  861303806 => "Changzhi\,\ Shanxi",
  861303807 => "Yangquan\,\ Shanxi",
  861303808 => "Taiyuan\,\ Shanxi",
  861303809 => "Datong\,\ Shanxi",
  861303810 => "Zigong\,\ Sichuan",
  861303811 => "Luzhou\,\ Sichuan",
  861303812 => "Leshan\,\ Sichuan",
  861303813 => "Leshan\,\ Sichuan",
  861303814 => "Ziyang\,\ Sichuan",
  861303815 => "Ziyang\,\ Sichuan",
  861303816 => "Ziyang\,\ Sichuan",
  861303817 => "Neijiang\,\ Sichuan",
  861303818 => "Neijiang\,\ Sichuan",
  861303819 => "Neijiang\,\ Sichuan",
  861303820 => "Nanchong\,\ Sichuan",
  861303821 => "Nanchong\,\ Sichuan",
  861303822 => "Suining\,\ Sichuan",
  861303823 => "Yibin\,\ Sichuan",
  861303824 => "Deyang\,\ Sichuan",
  861303825 => "Deyang\,\ Sichuan",
  861303826 => "Deyang\,\ Sichuan",
  861303827 => "Deyang\,\ Sichuan",
  861303828 => "Deyang\,\ Sichuan",
  861303829 => "Deyang\,\ Sichuan",
  86130383 => "Chongqing",
  861303840 => "Weinan\,\ Shaanxi",
  861303841 => "Weinan\,\ Shaanxi",
  861303842 => "Weinan\,\ Shaanxi",
  861303843 => "Weinan\,\ Shaanxi",
  861303844 => "YanAn\,\ Shaanxi",
  861303845 => "Hanzhong\,\ Shaanxi",
  861303846 => "Hanzhong\,\ Shaanxi",
  861303847 => "Hanzhong\,\ Shaanxi",
  861303848 => "Baoji\,\ Shaanxi",
  861303849 => "Baoji\,\ Shaanxi",
  861303850 => "Tongchuan\,\ Shaanxi",
  861303851 => "Shangluo\,\ Shaanxi",
  861303852 => "Shangluo\,\ Shaanxi",
  861303853 => "Shangluo\,\ Shaanxi",
  861303854 => "Xianyang\,\ Shaanxi",
  861303855 => "Xianyang\,\ Shaanxi",
  861303856 => "YanAn\,\ Shaanxi",
  861303857 => "YanAn\,\ Shaanxi",
  861303858 => "XiAn\,\ Shaanxi",
  861303859 => "XiAn\,\ Shaanxi",
  861303860 => "Deqen\,\ Yunnan",
  861303861 => "Lijiang\,\ Yunnan",
  861303862 => "Dali\,\ Yunnan",
  861303863 => "Zhaotong\,\ Yunnan",
  861303864 => "Zhaotong\,\ Yunnan",
  861303865 => "Yuxi\,\ Yunnan",
  861303866 => "Yuxi\,\ Yunnan",
  861303867 => "Qujing\,\ Yunnan",
  861303868 => "Qujing\,\ Yunnan",
  861303869 => "Chuxiong\,\ Yunnan",
  86130387 => "Lanzhou\,\ Gansu",
  86130388 => "Dongguan\,\ Guangdong",
  861303890 => "Ankang\,\ Shaanxi",
  861303891 => "Ankang\,\ Shaanxi",
  861303892 => "Ankang\,\ Shaanxi",
  861303893 => "XiAn\,\ Shaanxi",
  861303894 => "Yulin\,\ Shaanxi",
  861303895 => "Yulin\,\ Shaanxi",
  861303896 => "Yulin\,\ Shaanxi",
  861303897 => "Yulin\,\ Shaanxi",
  861303898 => "Yulin\,\ Shaanxi",
  861303899 => "Yulin\,\ Shaanxi",
  861303900 => "Changchun\,\ Jilin",
  861303901 => "Changchun\,\ Jilin",
  861303902 => "Siping\,\ Jilin",
  861303903 => "Siping\,\ Jilin",
  861303904 => "Changchun\,\ Jilin",
  861303905 => "Songyuan\,\ Jilin",
  861303906 => "Baicheng\,\ Jilin",
  861303907 => "Baishan\,\ Jilin",
  861303908 => "Yanbian\,\ Jilin",
  861303909 => "Yanbian\,\ Jilin",
  861303910 => "Changchun\,\ Jilin",
  861303911 => "Changchun\,\ Jilin",
  861303912 => "Changchun\,\ Jilin",
  861303913 => "Changchun\,\ Jilin",
  861303914 => "Changchun\,\ Jilin",
  861303915 => "Jilin\,\ Jilin",
  861303916 => "Jilin\,\ Jilin",
  861303917 => "Jilin\,\ Jilin",
  861303918 => "Yanbian\,\ Jilin",
  861303919 => "Tonghua\,\ Jilin",
  861303920 => "Changchun\,\ Jilin",
  861303921 => "Changchun\,\ Jilin",
  861303922 => "Changchun\,\ Jilin",
  861303923 => "Yanbian\,\ Jilin",
  861303924 => "Jilin\,\ Jilin",
  861303925 => "Jilin\,\ Jilin",
  861303926 => "Jilin\,\ Jilin",
  861303927 => "Jilin\,\ Jilin",
  861303928 => "Liaoyuan\,\ Jilin",
  861303929 => "Tonghua\,\ Jilin",
  861303930 => "Changchun\,\ Jilin",
  861303931 => "Changchun\,\ Jilin",
  861303932 => "Changchun\,\ Jilin",
  861303933 => "Yanbian\,\ Jilin",
  861303934 => "Changchun\,\ Jilin",
  861303935 => "Songyuan\,\ Jilin",
  861303936 => "Baicheng\,\ Jilin",
  861303937 => "Baicheng\,\ Jilin",
  861303938 => "Baishan\,\ Jilin",
  861303939 => "Baishan\,\ Jilin",
  861303940 => "Changji\,\ Xinjiang",
  861303941 => "Changji\,\ Xinjiang",
  861303942 => "Changji\,\ Xinjiang",
  861303943 => "Urumchi\,\ Xinjiang",
  861303944 => "Urumchi\,\ Xinjiang",
  861303945 => "Urumchi\,\ Xinjiang",
  861303946 => "Urumchi\,\ Xinjiang",
  861303947 => "Urumchi\,\ Xinjiang",
  861303948 => "Urumchi\,\ Xinjiang",
  861303949 => "Urumchi\,\ Xinjiang",
  861303950 => "Hohhot\,\ Inner\ Mongolia",
  861303951 => "Hohhot\,\ Inner\ Mongolia",
  861303952 => "Hohhot\,\ Inner\ Mongolia",
  861303953 => "Tongliao\,\ Inner\ Mongolia",
  861303954 => "Tongliao\,\ Inner\ Mongolia",
  861303955 => "Baotou\,\ Inner\ Mongolia",
  861303956 => "Baotou\,\ Inner\ Mongolia",
  861303957 => "Baotou\,\ Inner\ Mongolia",
  861303958 => "Baotou\,\ Inner\ Mongolia",
  861303959 => "Chifeng\,\ Inner\ Mongolia",
  861303960 => "Jiamusi\,\ Heilongjiang",
  861303961 => "Jiamusi\,\ Heilongjiang",
  861303962 => "Jiamusi\,\ Heilongjiang",
  861303963 => "Jiamusi\,\ Heilongjiang",
  861303964 => "Jiamusi\,\ Heilongjiang",
  861303965 => "Jiamusi\,\ Heilongjiang",
  861303966 => "Yichun\,\ Heilongjiang",
  861303967 => "Yichun\,\ Heilongjiang",
  861303968 => "Yichun\,\ Heilongjiang",
  861303969 => "Yichun\,\ Heilongjiang",
  861303970 => "Mudanjiang\,\ Heilongjiang",
  861303971 => "Mudanjiang\,\ Heilongjiang",
  861303972 => "Mudanjiang\,\ Heilongjiang",
  861303973 => "Hegang\,\ Heilongjiang",
  861303974 => "Qiqihar\,\ Heilongjiang",
  861303975 => "Shuangyashan\,\ Heilongjiang",
  861303976 => "Heihe\,\ Heilongjiang",
  861303977 => "Heihe\,\ Heilongjiang",
  861303978 => "Heihe\,\ Heilongjiang",
  861303979 => "Qitaihe\,\ Heilongjiang",
  861303980 => "Daqing\,\ Heilongjiang",
  861303981 => "Daqing\,\ Heilongjiang",
  861303982 => "Daqing\,\ Heilongjiang",
  861303983 => "Daqing\,\ Heilongjiang",
  861303984 => "Daqing\,\ Heilongjiang",
  861303985 => "Daqing\,\ Heilongjiang",
  861303986 => "Daqing\,\ Heilongjiang",
  861303987 => "Daqing\,\ Heilongjiang",
  861303988 => "Daqing\,\ Heilongjiang",
  861303989 => "Jixi\,\ Heilongjiang",
  861303990 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861303991 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861303992 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861303993 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861303994 => "Suihua\,\ Heilongjiang",
  861303995 => "Suihua\,\ Heilongjiang",
  861303996 => "Harbin\,\ Heilongjiang",
  861303997 => "Harbin\,\ Heilongjiang",
  861303998 => "Harbin\,\ Heilongjiang",
  861303999 => "Harbin\,\ Heilongjiang",
  86130400 => "Tangshan\,\ Hebei",
  861304010 => "Taizhou\,\ Jiangsu",
  861304011 => "Taizhou\,\ Jiangsu",
  861304012 => "Taizhou\,\ Jiangsu",
  861304013 => "Taizhou\,\ Jiangsu",
  861304014 => "Taizhou\,\ Jiangsu",
  861304015 => "Taizhou\,\ Jiangsu",
  861304016 => "Taizhou\,\ Jiangsu",
  861304017 => "Taizhou\,\ Jiangsu",
  861304018 => "Taizhou\,\ Jiangsu",
  861304019 => "HuaiAn\,\ Jiangsu",
  861304020 => "Yangzhou\,\ Jiangsu",
  861304021 => "Yangzhou\,\ Jiangsu",
  861304022 => "Yangzhou\,\ Jiangsu",
  861304023 => "Yangzhou\,\ Jiangsu",
  861304024 => "Yangzhou\,\ Jiangsu",
  861304025 => "Yangzhou\,\ Jiangsu",
  861304026 => "Yangzhou\,\ Jiangsu",
  861304027 => "Yangzhou\,\ Jiangsu",
  861304028 => "Yangzhou\,\ Jiangsu",
  861304029 => "Suzhou\,\ Jiangsu",
  861304030 => "Siping\,\ Jilin",
  861304031 => "Baicheng\,\ Jilin",
  861304032 => "Baishan\,\ Jilin",
  861304033 => "Songyuan\,\ Jilin",
  861304034 => "Songyuan\,\ Jilin",
  861304035 => "Tonghua\,\ Jilin",
  861304036 => "Baicheng\,\ Jilin",
  861304037 => "Tonghua\,\ Jilin",
  861304038 => "Siping\,\ Jilin",
  861304039 => "Baishan\,\ Jilin",
  861304040 => "Ningbo\,\ Zhejiang",
  861304041 => "Ningbo\,\ Zhejiang",
  861304042 => "Ningbo\,\ Zhejiang",
  861304043 => "Ningbo\,\ Zhejiang",
  861304044 => "Ningbo\,\ Zhejiang",
  861304045 => "Bayingolin\,\ Xinjiang",
  861304046 => "Aksu\,\ Xinjiang",
  861304047 => "Kizilsu\,\ Xinjiang",
  861304048 => "Kashi\,\ Xinjiang",
  861304049 => "Hotan\,\ Xinjiang",
  861304050 => "Changji\,\ Xinjiang",
  861304051 => "Turpan\,\ Xinjiang",
  861304052 => "Hami\,\ Xinjiang",
  861304053 => "Ili\,\ Xinjiang",
  861304054 => "Shihezi\,\ Xinjiang",
  861304055 => "Karamay\,\ Xinjiang",
  861304056 => "Ili\,\ Xinjiang",
  861304057 => "Bortala\,\ Xinjiang",
  861304058 => "Tacheng\,\ Xinjiang",
  861304059 => "Altay\,\ Xinjiang",
  86130406 => "Shanghai",
  861304070 => "Jinhua\,\ Zhejiang",
  861304071 => "Jinhua\,\ Zhejiang",
  861304072 => "Jinhua\,\ Zhejiang",
  861304073 => "Jinhua\,\ Zhejiang",
  861304074 => "Taizhou\,\ Zhejiang",
  861304075 => "Taizhou\,\ Zhejiang",
  861304076 => "Jinhua\,\ Zhejiang",
  861304077 => "Jinhua\,\ Zhejiang",
  861304078 => "Shaoxing\,\ Zhejiang",
  861304079 => "Shaoxing\,\ Zhejiang",
  86130408 => "Shenzhen\,\ Guangdong",
  861304090 => "Jingzhou\,\ Hubei",
  861304091 => "Jingzhou\,\ Hubei",
  861304092 => "Jingzhou\,\ Hubei",
  861304093 => "Jingzhou\,\ Hubei",
  861304094 => "Jingzhou\,\ Hubei",
  861304095 => "Yichang\,\ Hubei",
  861304096 => "Yichang\,\ Hubei",
  861304097 => "Yichang\,\ Hubei",
  861304098 => "Yichang\,\ Hubei",
  861304099 => "Yichang\,\ Hubei",
  86130410 => "Beijing",
  86130411 => "Beijing",
  86130412 => "Beijing",
  861304130 => "Jilin\,\ Jilin",
  861304131 => "Jilin\,\ Jilin",
  861304132 => "Jilin\,\ Jilin",
  861304133 => "Jilin\,\ Jilin",
  861304134 => "Jilin\,\ Jilin",
  861304135 => "Jilin\,\ Jilin",
  861304136 => "Changchun\,\ Jilin",
  861304137 => "Changchun\,\ Jilin",
  861304138 => "Changchun\,\ Jilin",
  861304139 => "Changchun\,\ Jilin",
  86130414 => "Suzhou\,\ Jiangsu",
  86130415 => "Changzhou\,\ Jiangsu",
  86130416 => "Shanghai",
  861304170 => "Changzhou\,\ Jiangsu",
  861304171 => "Changzhou\,\ Jiangsu",
  861304172 => "Changzhou\,\ Jiangsu",
  861304173 => "Zhenjiang\,\ Jiangsu",
  861304174 => "Zhenjiang\,\ Jiangsu",
  861304175 => "Zhenjiang\,\ Jiangsu",
  861304176 => "Ordos\,\ Inner\ Mongolia",
  861304177 => "Zhenjiang\,\ Jiangsu",
  861304178 => "Zhenjiang\,\ Jiangsu",
  861304179 => "Zhenjiang\,\ Jiangsu",
  86130418 => "Suzhou\,\ Jiangsu",
  861304190 => "Xuzhou\,\ Jiangsu",
  861304191 => "Xuzhou\,\ Jiangsu",
  861304192 => "Xuzhou\,\ Jiangsu",
  861304193 => "Xuzhou\,\ Jiangsu",
  861304194 => "Xuzhou\,\ Jiangsu",
  861304195 => "Xuzhou\,\ Jiangsu",
  861304196 => "Xuzhou\,\ Jiangsu",
  861304197 => "Xuzhou\,\ Jiangsu",
  861304198 => "Xuzhou\,\ Jiangsu",
  861304199 => "Lianyungang\,\ Jiangsu",
  86130420 => "Guangzhou\,\ Guangdong",
  86130421 => "Shanghai",
  86130422 => "Tianjin",
  86130423 => "Chongqing",
  861304240 => "Shenyang\,\ Liaoning",
  861304241 => "Shenyang\,\ Liaoning",
  861304242 => "Shenyang\,\ Liaoning",
  861304243 => "Shenyang\,\ Liaoning",
  861304244 => "Shenyang\,\ Liaoning",
  861304245 => "Dalian\,\ Liaoning",
  861304246 => "Dalian\,\ Liaoning",
  861304247 => "Dalian\,\ Liaoning",
  861304248 => "Dalian\,\ Liaoning",
  861304249 => "Dalian\,\ Liaoning",
  86130425 => "Nanjing\,\ Jiangsu",
  861304260 => "Anshan\,\ Liaoning",
  861304261 => "Anshan\,\ Liaoning",
  861304262 => "Anshan\,\ Liaoning",
  861304263 => "Fushun\,\ Liaoning",
  861304264 => "Fushun\,\ Liaoning",
  861304265 => "Benxi\,\ Liaoning",
  861304266 => "Dandong\,\ Liaoning",
  861304267 => "Jinzhou\,\ Liaoning",
  861304268 => "Jinzhou\,\ Liaoning",
  861304269 => "Yingkou\,\ Liaoning",
  861304270 => "Huangshi\,\ Hubei",
  861304271 => "Huanggang\,\ Hubei",
  861304272 => "Huanggang\,\ Hubei",
  861304273 => "Ezhou\,\ Hubei",
  861304274 => "Xiaogan\,\ Hubei",
  861304275 => "Suizhou\,\ Hubei",
  861304276 => "Shiyan\,\ Hubei",
  861304277 => "Xianning\,\ Hubei",
  861304278 => "Xiangfan\,\ Hubei",
  861304279 => "Xiangfan\,\ Hubei",
  861304280 => "Xiangfan\,\ Hubei",
  861304281 => "Xiangfan\,\ Hubei",
  861304282 => "Xiangfan\,\ Hubei",
  861304283 => "Xiangfan\,\ Hubei",
  861304284 => "Wuhan\,\ Hubei",
  861304285 => "Wuhan\,\ Hubei",
  861304286 => "Wuhan\,\ Hubei",
  861304287 => "Wuhan\,\ Hubei",
  861304288 => "Wuhan\,\ Hubei",
  861304289 => "Wuhan\,\ Hubei",
  861304290 => "Baiyin\,\ Gansu",
  861304291 => "Linxia\,\ Gansu",
  861304292 => "Zhangye\,\ Gansu",
  861304293 => "Qingyang\,\ Gansu",
  861304294 => "Dingxi\,\ Gansu",
  861304295 => "Tianshui\,\ Gansu",
  861304296 => "Jiayuguan\,\ Gansu",
  861304297 => "Tianshui\,\ Gansu",
  861304298 => "Tianshui\,\ Gansu",
  861304299 => "Pingliang\,\ Gansu",
  861304300 => "Xiamen\,\ Fujian",
  861304301 => "Zhengzhou\,\ Henan",
  861304302 => "Luoyang\,\ Henan",
  861304303 => "Pingdingshan\,\ Henan",
  861304304 => "Xiamen\,\ Fujian",
  861304305 => "Sanming\,\ Fujian",
  861304306 => "Zhangzhou\,\ Fujian",
  861304307 => "Zhangzhou\,\ Fujian",
  861304308 => "Zhangzhou\,\ Fujian",
  861304309 => "Zhangzhou\,\ Fujian",
  861304310 => "Handan\,\ Hebei",
  861304311 => "Shijiazhuang\,\ Hebei",
  861304312 => "Baoding\,\ Hebei",
  861304313 => "Qinhuangdao\,\ Hebei",
  861304314 => "Tangshan\,\ Hebei",
  861304315 => "Tangshan\,\ Hebei",
  861304316 => "Langfang\,\ Hebei",
  861304317 => "Cangzhou\,\ Hebei",
  861304318 => "Hengshui\,\ Hebei",
  861304319 => "Xingtai\,\ Hebei",
  86130432 => "Tianjin",
  861304330 => "Changchun\,\ Jilin",
  861304331 => "Changchun\,\ Jilin",
  861304332 => "Changchun\,\ Jilin",
  861304333 => "Changchun\,\ Jilin",
  861304334 => "Changchun\,\ Jilin",
  861304335 => "Yanbian\,\ Jilin",
  861304336 => "Yanbian\,\ Jilin",
  861304337 => "Yanbian\,\ Jilin",
  861304338 => "Yanbian\,\ Jilin",
  861304339 => "Yanbian\,\ Jilin",
  86130434 => "Shenzhen\,\ Guangdong",
  861304350 => "Fuzhou\,\ Fujian",
  861304351 => "Fuzhou\,\ Fujian",
  861304352 => "Fuzhou\,\ Fujian",
  861304353 => "Fuzhou\,\ Fujian",
  861304354 => "Fuzhou\,\ Fujian",
  861304355 => "Fuzhou\,\ Fujian",
  861304356 => "Longyan\,\ Fujian",
  861304357 => "Sanming\,\ Fujian",
  861304358 => "Nanping\,\ Fujian",
  861304359 => "Longyan\,\ Fujian",
  861304360 => "Wuxi\,\ Jiangsu",
  861304361 => "Wuxi\,\ Jiangsu",
  861304362 => "Wuxi\,\ Jiangsu",
  861304363 => "Loudi\,\ Hunan",
  861304364 => "Loudi\,\ Hunan",
  861304365 => "Wuxi\,\ Jiangsu",
  861304366 => "Wuxi\,\ Jiangsu",
  861304367 => "Loudi\,\ Hunan",
  861304368 => "Loudi\,\ Hunan",
  861304369 => "Loudi\,\ Hunan",
  861304370 => "Shangqiu\,\ Henan",
  861304371 => "Zhengzhou\,\ Henan",
  861304372 => "Anyang\,\ Henan",
  861304373 => "Xinxiang\,\ Henan",
  861304374 => "Xuchang\,\ Henan",
  861304375 => "Pingdingshan\,\ Henan",
  861304376 => "Xinyang\,\ Henan",
  861304377 => "Nanyang\,\ Henan",
  861304378 => "Kaifeng\,\ Henan",
  861304379 => "Luoyang\,\ Henan",
  861304380 => "Fuxin\,\ Liaoning",
  861304381 => "Liaoyang\,\ Liaoning",
  861304382 => "Liaoyang\,\ Liaoning",
  861304383 => "Tieling\,\ Liaoning",
  861304384 => "Tieling\,\ Liaoning",
  861304385 => "Chaoyang\,\ Liaoning",
  861304386 => "Panjin\,\ Liaoning",
  861304387 => "Panjin\,\ Liaoning",
  861304388 => "Huludao\,\ Liaoning",
  861304389 => "Huludao\,\ Liaoning",
  861304390 => "Nanyang\,\ Henan",
  861304391 => "Jiaozuo\,\ Henan",
  861304392 => "Hebi\,\ Henan",
  861304393 => "Puyang\,\ Henan",
  861304394 => "Zhoukou\,\ Henan",
  861304395 => "Luohe\,\ Henan",
  861304396 => "Zhumadian\,\ Henan",
  861304397 => "Zhengzhou\,\ Henan",
  861304398 => "Sanmenxia\,\ Henan",
  861304399 => "Zhengzhou\,\ Henan",
  861304400 => "TaiAn\,\ Shandong",
  861304401 => "TaiAn\,\ Shandong",
  861304402 => "TaiAn\,\ Shandong",
  861304403 => "Laiwu\,\ Shandong",
  861304404 => "Linyi\,\ Shandong",
  861304405 => "Linyi\,\ Shandong",
  861304406 => "Linyi\,\ Shandong",
  861304407 => "Jining\,\ Shandong",
  861304408 => "Jining\,\ Shandong",
  861304409 => "Jining\,\ Shandong",
  86130441 => "Shanghai",
  86130442 => "Guangzhou\,\ Guangdong",
  861304430 => "Changchun\,\ Jilin",
  861304431 => "Changchun\,\ Jilin",
  861304432 => "Jilin\,\ Jilin",
  861304433 => "Yanbian\,\ Jilin",
  861304434 => "Siping\,\ Jilin",
  861304435 => "Tonghua\,\ Jilin",
  861304436 => "Baicheng\,\ Jilin",
  861304437 => "Liaoyuan\,\ Jilin",
  861304438 => "Songyuan\,\ Jilin",
  861304439 => "Baishan\,\ Jilin",
  861304440 => "Yuncheng\,\ Shanxi",
  861304441 => "Xinzhou\,\ Shanxi",
  861304442 => "Xinzhou\,\ Shanxi",
  861304443 => "Shuozhou\,\ Shanxi",
  861304444 => "Shuozhou\,\ Shanxi",
  861304445 => "Jincheng\,\ Shanxi",
  861304446 => "Yangquan\,\ Shanxi",
  861304447 => "Yangquan\,\ Shanxi",
  861304448 => "Lüliang\,\ Shanxi",
  861304449 => "Lüliang\,\ Shanxi",
  861304450 => "Zhangzhou\,\ Fujian",
  861304451 => "Zhengzhou\,\ Henan",
  861304452 => "Zhangzhou\,\ Fujian",
  861304453 => "Zhangzhou\,\ Fujian",
  861304454 => "Quanzhou\,\ Fujian",
  861304455 => "Quanzhou\,\ Fujian",
  861304456 => "Quanzhou\,\ Fujian",
  861304457 => "Fuzhou\,\ Fujian",
  861304458 => "Fuzhou\,\ Fujian",
  861304459 => "Fuzhou\,\ Fujian",
  86130446 => "Shanghai",
  861304470 => "Zhengzhou\,\ Henan",
  861304471 => "Zhengzhou\,\ Henan",
  861304472 => "Luoyang\,\ Henan",
  861304473 => "Luoyang\,\ Henan",
  861304474 => "Luoyang\,\ Henan",
  861304475 => "Xinxiang\,\ Henan",
  861304476 => "Anyang\,\ Henan",
  861304477 => "Luohe\,\ Henan",
  861304478 => "Kaifeng\,\ Henan",
  861304479 => "Pingdingshan\,\ Henan",
  861304480 => "Xiaogan\,\ Hubei",
  861304481 => "Xiaogan\,\ Hubei",
  861304482 => "Xiaogan\,\ Hubei",
  861304483 => "Enshi\,\ Hubei",
  861304484 => "Enshi\,\ Hubei",
  861304485 => "Enshi\,\ Hubei",
  861304486 => "Enshi\,\ Hubei",
  861304487 => "Jingmen\,\ Hubei",
  861304488 => "Jingmen\,\ Hubei",
  861304489 => "Jingmen\,\ Hubei",
  861304490 => "Nanchang\,\ Jiangxi",
  861304491 => "Nanchang\,\ Jiangxi",
  861304492 => "Jiujiang\,\ Jiangxi",
  861304493 => "Shangrao\,\ Jiangxi",
  861304494 => "Fuzhou\,\ Jiangxi",
  861304495 => "Yichun\,\ Jiangxi",
  861304496 => "JiAn\,\ Jiangxi",
  861304497 => "Ganzhou\,\ Jiangxi",
  861304498 => "Jingdezhen\,\ Jiangxi",
  861304499 => "Pingxiang\,\ Jiangxi",
  86130450 => "Qingdao\,\ Shandong",
  86130451 => "Harbin\,\ Heilongjiang",
  861304520 => "Qiqihar\,\ Heilongjiang",
  861304521 => "Qiqihar\,\ Heilongjiang",
  861304522 => "Qiqihar\,\ Heilongjiang",
  861304523 => "Qiqihar\,\ Heilongjiang",
  861304524 => "Qiqihar\,\ Heilongjiang",
  861304525 => "Yichun\,\ Heilongjiang",
  861304526 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861304527 => "Qiqihar\,\ Heilongjiang",
  861304528 => "Suihua\,\ Heilongjiang",
  861304529 => "Suihua\,\ Heilongjiang",
  861304530 => "Mudanjiang\,\ Heilongjiang",
  861304531 => "Mudanjiang\,\ Heilongjiang",
  861304532 => "Mudanjiang\,\ Heilongjiang",
  861304533 => "Mudanjiang\,\ Heilongjiang",
  861304534 => "Mudanjiang\,\ Heilongjiang",
  861304535 => "Jixi\,\ Heilongjiang",
  861304536 => "Jixi\,\ Heilongjiang",
  861304537 => "Qitaihe\,\ Heilongjiang",
  861304538 => "Qitaihe\,\ Heilongjiang",
  861304539 => "Daqing\,\ Heilongjiang",
  861304540 => "Jiamusi\,\ Heilongjiang",
  861304541 => "Jiamusi\,\ Heilongjiang",
  861304542 => "Jiamusi\,\ Heilongjiang",
  861304543 => "Jiamusi\,\ Heilongjiang",
  861304544 => "Jiamusi\,\ Heilongjiang",
  861304545 => "Hegang\,\ Heilongjiang",
  861304546 => "Hegang\,\ Heilongjiang",
  861304547 => "Shuangyashan\,\ Heilongjiang",
  861304548 => "Shuangyashan\,\ Heilongjiang",
  861304549 => "Daqing\,\ Heilongjiang",
  861304550 => "Chuzhou\,\ Anhui",
  861304551 => "Hefei\,\ Anhui",
  861304552 => "LuAn\,\ Anhui",
  861304553 => "Chizhou\,\ Anhui",
  861304554 => "Xuancheng\,\ Anhui",
  861304555 => "MaAnshan\,\ Anhui",
  861304556 => "Anqing\,\ Anhui",
  861304557 => "Tongling\,\ Anhui",
  861304558 => "Xuancheng\,\ Anhui",
  861304559 => "Huangshan\,\ Anhui",
  86130456 => "Shanghai",
  861304570 => "Quzhou\,\ Zhejiang",
  861304571 => "Hangzhou\,\ Zhejiang",
  861304572 => "Huzhou\,\ Zhejiang",
  861304573 => "Jiaxing\,\ Zhejiang",
  861304574 => "Jiaxing\,\ Zhejiang",
  861304575 => "Shaoxing\,\ Zhejiang",
  861304576 => "Taizhou\,\ Zhejiang",
  861304577 => "Wenzhou\,\ Zhejiang",
  861304578 => "Jinhua\,\ Zhejiang",
  861304579 => "Jinhua\,\ Zhejiang",
  86130458 => "Shenzhen\,\ Guangdong",
  861304590 => "Longyan\,\ Fujian",
  861304591 => "Fuzhou\,\ Fujian",
  861304592 => "Xiamen\,\ Fujian",
  861304593 => "Ningde\,\ Fujian",
  861304594 => "Putian\,\ Fujian",
  861304595 => "Quanzhou\,\ Fujian",
  861304596 => "Zhangzhou\,\ Fujian",
  861304597 => "Xiamen\,\ Fujian",
  861304598 => "Sanming\,\ Fujian",
  861304599 => "Nanping\,\ Fujian",
  861304600 => "Jinan\,\ Shandong",
  861304601 => "Jinan\,\ Shandong",
  861304602 => "Jinan\,\ Shandong",
  861304603 => "Jinan\,\ Shandong",
  861304604 => "Jinan\,\ Shandong",
  861304605 => "Zibo\,\ Shandong",
  861304606 => "Zibo\,\ Shandong",
  861304607 => "Zibo\,\ Shandong",
  861304608 => "Zibo\,\ Shandong",
  861304609 => "Zibo\,\ Shandong",
  861304610 => "Shanwei\,\ Guangdong",
  861304611 => "Shanwei\,\ Guangdong",
  861304612 => "Shanwei\,\ Guangdong",
  861304613 => "Shanwei\,\ Guangdong",
  861304614 => "Qingyuan\,\ Guangdong",
  861304615 => "Qingyuan\,\ Guangdong",
  861304616 => "Qingyuan\,\ Guangdong",
  861304617 => "Shaoguan\,\ Guangdong",
  861304618 => "Shaoguan\,\ Guangdong",
  861304619 => "Shaoguan\,\ Guangdong",
  861304620 => "Zhanjiang\,\ Guangdong",
  861304621 => "Zhanjiang\,\ Guangdong",
  861304622 => "Zhanjiang\,\ Guangdong",
  861304623 => "Zhanjiang\,\ Guangdong",
  861304624 => "Zhanjiang\,\ Guangdong",
  861304625 => "Maoming\,\ Guangdong",
  861304626 => "Maoming\,\ Guangdong",
  861304627 => "Maoming\,\ Guangdong",
  861304628 => "Maoming\,\ Guangdong",
  861304629 => "Maoming\,\ Guangdong",
  861304630 => "Zhongshan\,\ Guangdong",
  861304631 => "Zhongshan\,\ Guangdong",
  861304632 => "Zhongshan\,\ Guangdong",
  861304633 => "Zhongshan\,\ Guangdong",
  861304634 => "Zhongshan\,\ Guangdong",
  861304635 => "Zhuhai\,\ Guangdong",
  861304636 => "Zhuhai\,\ Guangdong",
  861304637 => "Zhuhai\,\ Guangdong",
  861304638 => "Zhuhai\,\ Guangdong",
  861304639 => "Zhuhai\,\ Guangdong",
  861304640 => "Yantai\,\ Shandong",
  861304641 => "Yantai\,\ Shandong",
  861304642 => "Yantai\,\ Shandong",
  861304643 => "Weihai\,\ Shandong",
  861304644 => "Weihai\,\ Shandong",
  861304645 => "Weihai\,\ Shandong",
  861304646 => "Weifang\,\ Shandong",
  861304647 => "Weifang\,\ Shandong",
  861304648 => "Weifang\,\ Shandong",
  861304649 => "Weifang\,\ Shandong",
  86130465 => "Yancheng\,\ Jiangsu",
  86130466 => "Shanghai",
  861304670 => "Nantong\,\ Jiangsu",
  861304671 => "Nantong\,\ Jiangsu",
  861304672 => "Nantong\,\ Jiangsu",
  861304673 => "Nantong\,\ Jiangsu",
  861304674 => "Nantong\,\ Jiangsu",
  861304675 => "Nantong\,\ Jiangsu",
  861304676 => "Nantong\,\ Jiangsu",
  861304677 => "Nantong\,\ Jiangsu",
  861304678 => "Nantong\,\ Jiangsu",
  861304679 => "Suqian\,\ Jiangsu",
  861304680 => "Shantou\,\ Guangdong",
  861304681 => "Shantou\,\ Guangdong",
  861304682 => "Dongguan\,\ Guangdong",
  861304683 => "Dongguan\,\ Guangdong",
  861304684 => "Dongguan\,\ Guangdong",
  861304685 => "Dongguan\,\ Guangdong",
  861304686 => "Dongguan\,\ Guangdong",
  861304687 => "Dongguan\,\ Guangdong",
  861304688 => "Dongguan\,\ Guangdong",
  861304689 => "Dongguan\,\ Guangdong",
  861304690 => "Putian\,\ Fujian",
  861304691 => "Pingdingshan\,\ Henan",
  861304692 => "Ningde\,\ Fujian",
  861304693 => "Ningde\,\ Fujian",
  861304694 => "Ningde\,\ Fujian",
  861304695 => "Ningde\,\ Fujian",
  861304696 => "Quanzhou\,\ Fujian",
  861304697 => "Quanzhou\,\ Fujian",
  861304698 => "Quanzhou\,\ Fujian",
  861304699 => "Quanzhou\,\ Fujian",
  861304700 => "Chaozhou\,\ Guangdong",
  861304701 => "Chaozhou\,\ Guangdong",
  861304702 => "Yangjiang\,\ Guangdong",
  861304703 => "Yangjiang\,\ Guangdong",
  861304704 => "Foshan\,\ Guangdong",
  861304705 => "Foshan\,\ Guangdong",
  861304706 => "Foshan\,\ Guangdong",
  861304707 => "Foshan\,\ Guangdong",
  861304708 => "Foshan\,\ Guangdong",
  861304709 => "Foshan\,\ Guangdong",
  861304710 => "Jingzhou\,\ Hubei",
  861304711 => "Jingzhou\,\ Hubei",
  861304712 => "Wuhan\,\ Hubei",
  861304713 => "Wuhan\,\ Hubei",
  861304714 => "Wuhan\,\ Hubei",
  861304715 => "Yichang\,\ Hubei",
  861304716 => "Yichang\,\ Hubei",
  861304717 => "Yichang\,\ Hubei",
  861304718 => "Jingmen\,\ Hubei",
  861304719 => "Enshi\,\ Hubei",
  861304720 => "Yueyang\,\ Hunan",
  861304721 => "Changsha\,\ Hunan",
  861304722 => "Xiangtan\,\ Hunan",
  861304723 => "Zhuzhou\,\ Hunan",
  861304724 => "Hengyang\,\ Hunan",
  861304725 => "Chenzhou\,\ Hunan",
  861304726 => "Changde\,\ Hunan",
  861304727 => "Yiyang\,\ Hunan",
  861304728 => "Shaoyang\,\ Hunan",
  861304729 => "Huaihua\,\ Hunan",
  86130473 => "Chongqing",
  861304740 => "Qingdao\,\ Shandong",
  861304741 => "Qingdao\,\ Shandong",
  861304742 => "Zaozhuang\,\ Shandong",
  861304743 => "Rizhao\,\ Shandong",
  861304744 => "Dongying\,\ Shandong",
  861304745 => "Liaocheng\,\ Shandong",
  861304746 => "Dezhou\,\ Shandong",
  861304747 => "Linyi\,\ Shandong",
  861304748 => "Jinan\,\ Shandong",
  861304749 => "Yantai\,\ Shandong",
  861304750 => "Nanjing\,\ Jiangsu",
  861304751 => "Nanjing\,\ Jiangsu",
  861304752 => "Nanjing\,\ Jiangsu",
  861304753 => "Nanjing\,\ Jiangsu",
  861304754 => "Nanjing\,\ Jiangsu",
  861304755 => "Nanjing\,\ Jiangsu",
  861304756 => "Nanjing\,\ Jiangsu",
  861304757 => "Nanjing\,\ Jiangsu",
  861304758 => "Suqian\,\ Jiangsu",
  861304759 => "Suqian\,\ Jiangsu",
  861304760 => "Hangzhou\,\ Zhejiang",
  861304761 => "Hangzhou\,\ Zhejiang",
  861304762 => "Hangzhou\,\ Zhejiang",
  861304763 => "Hangzhou\,\ Zhejiang",
  861304764 => "Hangzhou\,\ Zhejiang",
  861304765 => "Hangzhou\,\ Zhejiang",
  861304766 => "Hangzhou\,\ Zhejiang",
  861304767 => "Hangzhou\,\ Zhejiang",
  861304768 => "Suqian\,\ Jiangsu",
  861304769 => "Suqian\,\ Jiangsu",
  86130477 => "Handan\,\ Hebei",
  861304780 => "Liuzhou\,\ Guangxi",
  861304781 => "Nanning\,\ Guangxi",
  861304782 => "Liuzhou\,\ Guangxi",
  861304783 => "Hezhou\,\ Guangxi",
  861304784 => "Guigang\,\ Guangxi",
  861304785 => "Yulin\,\ Guangxi",
  861304786 => "Baise\,\ Guangxi",
  861304787 => "Qinzhou\,\ Guangxi",
  861304788 => "Hechi\,\ Guangxi",
  861304789 => "Guigang\,\ Guangxi",
  861304790 => "Nanchang\,\ Jiangxi",
  861304791 => "Nanchang\,\ Jiangxi",
  861304792 => "Jiujiang\,\ Jiangxi",
  861304793 => "Shangrao\,\ Jiangxi",
  861304794 => "Fuzhou\,\ Jiangxi",
  861304795 => "Yichun\,\ Jiangxi",
  861304796 => "JiAn\,\ Jiangxi",
  861304797 => "Ganzhou\,\ Jiangxi",
  861304798 => "Jingdezhen\,\ Jiangxi",
  861304799 => "Pingxiang\,\ Jiangxi",
  86130480 => "Guangzhou\,\ Guangdong",
  86130481 => "Jiangmen\,\ Guangdong",
  861304820 => "Zhaoqing\,\ Guangdong",
  861304821 => "Zhaoqing\,\ Guangdong",
  861304822 => "Zhaoqing\,\ Guangdong",
  861304823 => "Zhaoqing\,\ Guangdong",
  861304824 => "Zhaoqing\,\ Guangdong",
  861304825 => "Meizhou\,\ Guangdong",
  861304826 => "Meizhou\,\ Guangdong",
  861304827 => "Meizhou\,\ Guangdong",
  861304828 => "Meizhou\,\ Guangdong",
  861304829 => "Meizhou\,\ Guangdong",
  86130483 => "Chongqing",
  86130484 => "Chongqing",
  861304850 => "Zunyi\,\ Guizhou",
  861304851 => "Zunyi\,\ Guizhou",
  861304852 => "Qiannan\,\ Guizhou",
  861304853 => "Qiannan\,\ Guizhou",
  861304854 => "Bijie\,\ Guizhou",
  861304855 => "Bijie\,\ Guizhou",
  861304856 => "Liupanshui\,\ Guizhou",
  861304857 => "Zunyi\,\ Guizhou",
  861304858 => "Zunyi\,\ Guizhou",
  861304859 => "Zunyi\,\ Guizhou",
  861304860 => "HuaiAn\,\ Jiangsu",
  861304861 => "HuaiAn\,\ Jiangsu",
  861304862 => "HuaiAn\,\ Jiangsu",
  861304863 => "HuaiAn\,\ Jiangsu",
  861304864 => "HuaiAn\,\ Jiangsu",
  861304865 => "Lianyungang\,\ Jiangsu",
  861304866 => "Lianyungang\,\ Jiangsu",
  861304867 => "Lianyungang\,\ Jiangsu",
  861304868 => "Lianyungang\,\ Jiangsu",
  861304869 => "Lianyungang\,\ Jiangsu",
  861304870 => "Huizhou\,\ Guangdong",
  861304871 => "Huizhou\,\ Guangdong",
  861304872 => "Huizhou\,\ Guangdong",
  861304873 => "Huizhou\,\ Guangdong",
  861304874 => "Huizhou\,\ Guangdong",
  861304875 => "Huizhou\,\ Guangdong",
  861304876 => "Huizhou\,\ Guangdong",
  861304877 => "Huizhou\,\ Guangdong",
  861304878 => "Shijiazhuang\,\ Hebei",
  861304879 => "Shijiazhuang\,\ Hebei",
  86130488 => "Shenzhen\,\ Guangdong",
  86130489 => "Shenzhen\,\ Guangdong",
  86130490 => "Shantou\,\ Guangdong",
  86130491 => "Foshan\,\ Guangdong",
  861304920 => "Yunfu\,\ Guangdong",
  861304921 => "Yunfu\,\ Guangdong",
  861304922 => "Yunfu\,\ Guangdong",
  861304923 => "Jieyang\,\ Guangdong",
  861304924 => "Jieyang\,\ Guangdong",
  861304925 => "Jieyang\,\ Guangdong",
  861304926 => "Jieyang\,\ Guangdong",
  861304927 => "Jieyang\,\ Guangdong",
  861304928 => "Jieyang\,\ Guangdong",
  861304929 => "Jieyang\,\ Guangdong",
  86130493 => "Shenzhen\,\ Guangdong",
  86130494 => "Shenzhen\,\ Guangdong",
  861304950 => "Anshun\,\ Guizhou",
  861304951 => "Anshun\,\ Guizhou",
  861304952 => "Qiannan\,\ Guizhou",
  861304953 => "Qiannan\,\ Guizhou",
  861304954 => "Qiandongnan\,\ Guizhou",
  861304955 => "Qiandongnan\,\ Guizhou",
  861304956 => "Tongren\,\ Guizhou",
  861304957 => "Bijie\,\ Guizhou",
  861304958 => "Liupanshui\,\ Guizhou",
  861304959 => "Qianxinan\,\ Guizhou",
  861304960 => "Heyuan\,\ Guangdong",
  861304961 => "Heyuan\,\ Guangdong",
  861304962 => "Guangzhou\,\ Guangdong",
  861304963 => "Guangzhou\,\ Guangdong",
  861304964 => "Guangzhou\,\ Guangdong",
  861304965 => "Guangzhou\,\ Guangdong",
  861304966 => "Guangzhou\,\ Guangdong",
  861304967 => "Guangzhou\,\ Guangdong",
  861304968 => "Guangzhou\,\ Guangdong",
  861304969 => "Guangzhou\,\ Guangdong",
  86130497 => "Dongguan\,\ Guangdong",
  86130498 => "Shenzhen\,\ Guangdong",
  86130499 => "Jinhua\,\ Zhejiang",
  86130500 => "Anshan\,\ Liaoning",
  86130501 => "Fushun\,\ Liaoning",
  86130502 => "Benxi\,\ Liaoning",
  86130503 => "Dandong\,\ Liaoning",
  86130504 => "Jinzhou\,\ Liaoning",
  86130505 => "Dalian\,\ Liaoning",
  86130506 => "Yingkou\,\ Liaoning",
  861305070 => "Fuxin\,\ Liaoning",
  861305071 => "Fuxin\,\ Liaoning",
  861305072 => "Fuxin\,\ Liaoning",
  861305073 => "Fuxin\,\ Liaoning",
  861305074 => "Fuxin\,\ Liaoning",
  861305075 => "Liaoyang\,\ Liaoning",
  861305076 => "Liaoyang\,\ Liaoning",
  861305077 => "Liaoyang\,\ Liaoning",
  861305078 => "Liaoyang\,\ Liaoning",
  861305079 => "Liaoyang\,\ Liaoning",
  861305080 => "Tieling\,\ Liaoning",
  861305081 => "Tieling\,\ Liaoning",
  861305082 => "Tieling\,\ Liaoning",
  861305083 => "Tieling\,\ Liaoning",
  861305084 => "Tieling\,\ Liaoning",
  861305085 => "Panjin\,\ Liaoning",
  861305086 => "Panjin\,\ Liaoning",
  861305087 => "Panjin\,\ Liaoning",
  861305088 => "Panjin\,\ Liaoning",
  861305089 => "Panjin\,\ Liaoning",
  861305090 => "Chaoyang\,\ Liaoning",
  861305091 => "Chaoyang\,\ Liaoning",
  861305092 => "Chaoyang\,\ Liaoning",
  861305093 => "Chaoyang\,\ Liaoning",
  861305094 => "Chaoyang\,\ Liaoning",
  861305095 => "Huludao\,\ Liaoning",
  861305096 => "Huludao\,\ Liaoning",
  861305097 => "Huludao\,\ Liaoning",
  861305098 => "Huludao\,\ Liaoning",
  861305099 => "Huludao\,\ Liaoning",
  8613051 => "Beijing",
  86130520 => "Shanghai",
  86130521 => "Shanghai",
  86130522 => "Shanghai",
  86130523 => "Shanghai",
  86130524 => "Shanghai",
  86130525 => "Shanghai",
  861305260 => "Chaoyang\,\ Liaoning",
  861305261 => "Chaoyang\,\ Liaoning",
  861305262 => "Chaoyang\,\ Liaoning",
  861305263 => "Chaoyang\,\ Liaoning",
  861305264 => "Chaoyang\,\ Liaoning",
  861305265 => "Huludao\,\ Liaoning",
  861305266 => "Huludao\,\ Liaoning",
  861305267 => "Huludao\,\ Liaoning",
  861305268 => "Huludao\,\ Liaoning",
  861305269 => "Huludao\,\ Liaoning",
  86130527 => "Dalian\,\ Liaoning",
  86130528 => "Suzhou\,\ Jiangsu",
  861305290 => "Zhenjiang\,\ Jiangsu",
  861305291 => "Zhenjiang\,\ Jiangsu",
  861305292 => "Zhenjiang\,\ Jiangsu",
  861305293 => "Zhenjiang\,\ Jiangsu",
  861305294 => "Zhenjiang\,\ Jiangsu",
  861305295 => "Taizhou\,\ Jiangsu",
  861305296 => "Taizhou\,\ Jiangsu",
  861305297 => "Taizhou\,\ Jiangsu",
  861305298 => "Taizhou\,\ Jiangsu",
  861305299 => "Taizhou\,\ Jiangsu",
  861305300 => "Suzhou\,\ Anhui",
  861305301 => "Suzhou\,\ Anhui",
  861305302 => "LuAn\,\ Anhui",
  861305303 => "LuAn\,\ Anhui",
  861305304 => "Hefei\,\ Anhui",
  861305305 => "Hefei\,\ Anhui",
  861305306 => "Hefei\,\ Anhui",
  861305307 => "Huainan\,\ Anhui",
  861305308 => "Hefei\,\ Anhui",
  861305309 => "Hefei\,\ Anhui",
  861305310 => "Chuzhou\,\ Anhui",
  861305311 => "Bengbu\,\ Anhui",
  861305312 => "Bengbu\,\ Anhui",
  861305313 => "Hefei\,\ Anhui",
  861305314 => "Chuzhou\,\ Anhui",
  861305315 => "Huaibei\,\ Anhui",
  861305316 => "Wuhu\,\ Anhui",
  861305317 => "Huainan\,\ Anhui",
  861305318 => "Bozhou\,\ Anhui",
  861305319 => "Fuyang\,\ Anhui",
  861305320 => "MaAnshan\,\ Anhui",
  861305321 => "MaAnshan\,\ Anhui",
  861305322 => "Huangshan\,\ Anhui",
  861305323 => "Xuancheng\,\ Anhui",
  861305324 => "Xuancheng\,\ Anhui",
  861305325 => "Tongling\,\ Anhui",
  861305326 => "Wuhu\,\ Anhui",
  861305327 => "Anqing\,\ Anhui",
  861305328 => "Anqing\,\ Anhui",
  861305329 => "Chizhou\,\ Anhui",
  86130533 => "Zibo\,\ Shandong",
  86130534 => "Dezhou\,\ Shandong",
  86130535 => "Yantai\,\ Shandong",
  86130536 => "Weifang\,\ Shandong",
  86130537 => "Jining\,\ Shandong",
  86130538 => "TaiAn\,\ Shandong",
  86130539 => "Linyi\,\ Shandong",
  861305400 => "Chenzhou\,\ Hunan",
  861305401 => "Chenzhou\,\ Hunan",
  861305402 => "Changde\,\ Hunan",
  861305403 => "Changde\,\ Hunan",
  861305404 => "Changde\,\ Hunan",
  861305405 => "Hengyang\,\ Hunan",
  861305406 => "Hengyang\,\ Hunan",
  861305407 => "Yueyang\,\ Hunan",
  861305408 => "Yueyang\,\ Hunan",
  861305409 => "Yiyang\,\ Hunan",
  861305410 => "Yiyang\,\ Hunan",
  861305411 => "Zhuzhou\,\ Hunan",
  861305412 => "Zhuzhou\,\ Hunan",
  861305413 => "Zhuzhou\,\ Hunan",
  861305414 => "Xiangtan\,\ Hunan",
  861305415 => "Xiangtan\,\ Hunan",
  861305416 => "Changsha\,\ Hunan",
  861305417 => "Changsha\,\ Hunan",
  861305418 => "Changsha\,\ Hunan",
  861305419 => "Changsha\,\ Hunan",
  861305420 => "Daqing\,\ Heilongjiang",
  861305421 => "Daqing\,\ Heilongjiang",
  861305422 => "Daqing\,\ Heilongjiang",
  861305423 => "Daqing\,\ Heilongjiang",
  861305424 => "Qiqihar\,\ Heilongjiang",
  861305425 => "Suihua\,\ Heilongjiang",
  861305426 => "Harbin\,\ Heilongjiang",
  861305427 => "Harbin\,\ Heilongjiang",
  861305428 => "Harbin\,\ Heilongjiang",
  861305429 => "Harbin\,\ Heilongjiang",
  861305430 => "Qiqihar\,\ Heilongjiang",
  861305431 => "Qiqihar\,\ Heilongjiang",
  861305432 => "Jixi\,\ Heilongjiang",
  861305433 => "Mudanjiang\,\ Heilongjiang",
  861305434 => "Mudanjiang\,\ Heilongjiang",
  861305435 => "Qitaihe\,\ Heilongjiang",
  861305436 => "Jiamusi\,\ Heilongjiang",
  861305437 => "Shuangyashan\,\ Heilongjiang",
  861305438 => "Hegang\,\ Heilongjiang",
  861305439 => "Suihua\,\ Heilongjiang",
  86130544 => "Guangzhou\,\ Guangdong",
  86130545 => "Yantai\,\ Shandong",
  86130546 => "Dongying\,\ Shandong",
  86130547 => "Weifang\,\ Shandong",
  861305480 => "Laiwu\,\ Shandong",
  861305481 => "Laiwu\,\ Shandong",
  861305482 => "Laiwu\,\ Shandong",
  861305483 => "Laiwu\,\ Shandong",
  861305484 => "Laiwu\,\ Shandong",
  861305485 => "Zibo\,\ Shandong",
  861305486 => "Zibo\,\ Shandong",
  861305487 => "Zibo\,\ Shandong",
  861305488 => "Zibo\,\ Shandong",
  861305489 => "Zibo\,\ Shandong",
  861305490 => "Linyi\,\ Shandong",
  861305491 => "Linyi\,\ Shandong",
  861305492 => "Linyi\,\ Shandong",
  861305493 => "Linyi\,\ Shandong",
  861305494 => "Linyi\,\ Shandong",
  861305495 => "Jining\,\ Shandong",
  861305496 => "Jining\,\ Shandong",
  861305497 => "Jining\,\ Shandong",
  861305498 => "Jining\,\ Shandong",
  861305499 => "Jining\,\ Shandong",
  861305500 => "Chenzhou\,\ Hunan",
  861305501 => "Chenzhou\,\ Hunan",
  861305502 => "Changde\,\ Hunan",
  861305503 => "Changde\,\ Hunan",
  861305504 => "Changde\,\ Hunan",
  861305505 => "Hengyang\,\ Hunan",
  861305506 => "Hengyang\,\ Hunan",
  861305507 => "Yueyang\,\ Hunan",
  861305508 => "Yueyang\,\ Hunan",
  861305509 => "Yiyang\,\ Hunan",
  861305510 => "Yiyang\,\ Hunan",
  861305511 => "Zhuzhou\,\ Hunan",
  861305512 => "Zhuzhou\,\ Hunan",
  861305513 => "Zhuzhou\,\ Hunan",
  861305514 => "Xiangtan\,\ Hunan",
  861305515 => "Xiangtan\,\ Hunan",
  861305516 => "Changsha\,\ Hunan",
  861305517 => "Changsha\,\ Hunan",
  861305518 => "Changsha\,\ Hunan",
  861305519 => "Changsha\,\ Hunan",
  861305520 => "Xiamen\,\ Fujian",
  861305521 => "Xiamen\,\ Fujian",
  861305522 => "Xiamen\,\ Fujian",
  861305523 => "Xiamen\,\ Fujian",
  861305524 => "Xiamen\,\ Fujian",
  861305525 => "Fuzhou\,\ Fujian",
  861305526 => "Fuzhou\,\ Fujian",
  861305527 => "Fuzhou\,\ Fujian",
  861305528 => "Fuzhou\,\ Fujian",
  861305529 => "Fuzhou\,\ Fujian",
  861305530 => "Putian\,\ Fujian",
  861305531 => "Putian\,\ Fujian",
  861305532 => "Quanzhou\,\ Fujian",
  861305533 => "Quanzhou\,\ Fujian",
  861305534 => "Zhangzhou\,\ Fujian",
  861305535 => "Zhangzhou\,\ Fujian",
  861305536 => "Zhangzhou\,\ Fujian",
  861305537 => "Zhangzhou\,\ Fujian",
  861305538 => "Zhangzhou\,\ Fujian",
  861305539 => "Zhangzhou\,\ Fujian",
  861305540 => "Fuzhou\,\ Fujian",
  861305541 => "Fuzhou\,\ Fujian",
  861305542 => "Fuzhou\,\ Fujian",
  861305543 => "Xiamen\,\ Fujian",
  861305544 => "Zhangzhou\,\ Fujian",
  861305545 => "Zhangzhou\,\ Fujian",
  861305546 => "Quanzhou\,\ Fujian",
  861305547 => "Quanzhou\,\ Fujian",
  861305548 => "Ningde\,\ Fujian",
  861305549 => "Nanping\,\ Fujian",
  861305550 => "Xiamen\,\ Fujian",
  861305551 => "Xiamen\,\ Fujian",
  861305552 => "Fuzhou\,\ Fujian",
  861305553 => "Fuzhou\,\ Fujian",
  861305554 => "Sanming\,\ Fujian",
  861305555 => "Sanming\,\ Fujian",
  861305556 => "Sanming\,\ Fujian",
  861305557 => "Ningde\,\ Fujian",
  861305558 => "Ningde\,\ Fujian",
  861305559 => "Ningde\,\ Fujian",
  861305560 => "Quanzhou\,\ Fujian",
  861305561 => "Quanzhou\,\ Fujian",
  861305562 => "Quanzhou\,\ Fujian",
  861305563 => "Quanzhou\,\ Fujian",
  861305564 => "Quanzhou\,\ Fujian",
  861305565 => "Quanzhou\,\ Fujian",
  861305566 => "Quanzhou\,\ Fujian",
  861305567 => "Quanzhou\,\ Fujian",
  861305568 => "Putian\,\ Fujian",
  861305569 => "Putian\,\ Fujian",
  861305570 => "Nanping\,\ Fujian",
  861305571 => "Nanping\,\ Fujian",
  861305572 => "Fuzhou\,\ Fujian",
  861305573 => "Fuzhou\,\ Fujian",
  861305574 => "Fuzhou\,\ Fujian",
  861305575 => "Fuzhou\,\ Fujian",
  861305576 => "Fuzhou\,\ Fujian",
  861305577 => "Fuzhou\,\ Fujian",
  861305578 => "Fuzhou\,\ Fujian",
  861305579 => "Fuzhou\,\ Fujian",
  861305580 => "Quanzhou\,\ Fujian",
  861305581 => "Quanzhou\,\ Fujian",
  861305582 => "Nanping\,\ Fujian",
  861305583 => "Nanping\,\ Fujian",
  861305584 => "Longyan\,\ Fujian",
  861305585 => "Longyan\,\ Fujian",
  861305586 => "Longyan\,\ Fujian",
  861305587 => "Xiamen\,\ Fujian",
  861305588 => "Zhangzhou\,\ Fujian",
  861305589 => "Zhangzhou\,\ Fujian",
  861305590 => "Fuzhou\,\ Fujian",
  861305591 => "Fuzhou\,\ Fujian",
  861305592 => "Xiamen\,\ Fujian",
  861305593 => "Ningde\,\ Fujian",
  861305594 => "Putian\,\ Fujian",
  861305595 => "Quanzhou\,\ Fujian",
  861305596 => "Zhangzhou\,\ Fujian",
  861305597 => "Longyan\,\ Fujian",
  861305598 => "Nanping\,\ Fujian",
  861305599 => "Nanping\,\ Fujian",
  861305600 => "HuaiAn\,\ Jiangsu",
  861305601 => "HuaiAn\,\ Jiangsu",
  861305602 => "HuaiAn\,\ Jiangsu",
  861305603 => "HuaiAn\,\ Jiangsu",
  861305604 => "Lianyungang\,\ Jiangsu",
  861305605 => "Lianyungang\,\ Jiangsu",
  861305606 => "Lianyungang\,\ Jiangsu",
  861305607 => "Lianyungang\,\ Jiangsu",
  861305608 => "Lianyungang\,\ Jiangsu",
  861305609 => "Lianyungang\,\ Jiangsu",
  861305610 => "Suqian\,\ Jiangsu",
  861305611 => "Suqian\,\ Jiangsu",
  861305612 => "Suqian\,\ Jiangsu",
  861305613 => "Yancheng\,\ Jiangsu",
  861305614 => "Yancheng\,\ Jiangsu",
  861305615 => "Yancheng\,\ Jiangsu",
  861305616 => "Yancheng\,\ Jiangsu",
  861305617 => "Yancheng\,\ Jiangsu",
  861305618 => "Yancheng\,\ Jiangsu",
  861305619 => "Yancheng\,\ Jiangsu",
  86130562 => "Xuzhou\,\ Jiangsu",
  86130563 => "Yangzhou\,\ Jiangsu",
  861305640 => "Leshan\,\ Sichuan",
  861305641 => "Meishan\,\ Sichuan",
  861305642 => "Nanchong\,\ Sichuan",
  861305643 => "Nanchong\,\ Sichuan",
  861305644 => "Dazhou\,\ Sichuan",
  861305645 => "Garze\,\ Sichuan",
  861305646 => "Aba\,\ Sichuan",
  861305647 => "Aba\,\ Sichuan",
  861305648 => "Bazhong\,\ Sichuan",
  861305649 => "Bazhong\,\ Sichuan",
  861305650 => "Bazhong\,\ Sichuan",
  861305651 => "Bazhong\,\ Sichuan",
  861305652 => "GuangAn\,\ Sichuan",
  861305653 => "GuangAn\,\ Sichuan",
  861305654 => "GuangAn\,\ Sichuan",
  861305655 => "GuangAn\,\ Sichuan",
  861305656 => "YaAn\,\ Sichuan",
  861305657 => "YaAn\,\ Sichuan",
  861305658 => "YaAn\,\ Sichuan",
  861305659 => "YaAn\,\ Sichuan",
  861305660 => "Meishan\,\ Sichuan",
  861305661 => "Meishan\,\ Sichuan",
  861305662 => "Leshan\,\ Sichuan",
  861305663 => "Leshan\,\ Sichuan",
  861305664 => "Yibin\,\ Sichuan",
  861305665 => "Yibin\,\ Sichuan",
  861305666 => "Chengdu\,\ Sichuan",
  861305667 => "Chengdu\,\ Sichuan",
  861305668 => "Chengdu\,\ Sichuan",
  861305669 => "Chengdu\,\ Sichuan",
  86130567 => "Ningbo\,\ Zhejiang",
  86130568 => "Ningbo\,\ Zhejiang",
  86130569 => "Ningbo\,\ Zhejiang",
  86130570 => "Nantong\,\ Jiangsu",
  86130571 => "Changzhou\,\ Jiangsu",
  86130572 => "Wuxi\,\ Jiangsu",
  86130573 => "Wuxi\,\ Jiangsu",
  86130574 => "Suzhou\,\ Jiangsu",
  86130575 => "Nanjing\,\ Jiangsu",
  86130576 => "Nanjing\,\ Jiangsu",
  86130577 => "Wenzhou\,\ Zhejiang",
  86130578 => "Wenzhou\,\ Zhejiang",
  86130579 => "Wenzhou\,\ Zhejiang",
  86130580 => "Shenzhen\,\ Guangdong",
  86130581 => "Shenzhen\,\ Guangdong",
  861305820 => "Shaoguan\,\ Guangdong",
  861305821 => "Shaoguan\,\ Guangdong",
  861305822 => "Shaoguan\,\ Guangdong",
  861305823 => "Shaoguan\,\ Guangdong",
  861305824 => "Shanwei\,\ Guangdong",
  861305825 => "Shanwei\,\ Guangdong",
  861305826 => "Shantou\,\ Guangdong",
  861305827 => "Shantou\,\ Guangdong",
  861305828 => "Shantou\,\ Guangdong",
  861305829 => "Shantou\,\ Guangdong",
  861305830 => "Foshan\,\ Guangdong",
  861305831 => "Foshan\,\ Guangdong",
  861305832 => "Foshan\,\ Guangdong",
  861305833 => "Foshan\,\ Guangdong",
  861305834 => "Zhanjiang\,\ Guangdong",
  861305835 => "Zhanjiang\,\ Guangdong",
  861305836 => "Zhanjiang\,\ Guangdong",
  861305837 => "Zhanjiang\,\ Guangdong",
  861305838 => "Zhanjiang\,\ Guangdong",
  861305839 => "Zhanjiang\,\ Guangdong",
  861305840 => "Guangzhou\,\ Guangdong",
  861305841 => "Guangzhou\,\ Guangdong",
  861305842 => "Guangzhou\,\ Guangdong",
  861305843 => "Guangzhou\,\ Guangdong",
  861305844 => "Jieyang\,\ Guangdong",
  861305845 => "Jieyang\,\ Guangdong",
  861305846 => "Chaozhou\,\ Guangdong",
  861305847 => "Chaozhou\,\ Guangdong",
  861305848 => "Shantou\,\ Guangdong",
  861305849 => "Shantou\,\ Guangdong",
  86130585 => "Dongguan\,\ Guangdong",
  86130586 => "Taizhou\,\ Zhejiang",
  86130587 => "Taizhou\,\ Zhejiang",
  86130588 => "Taizhou\,\ Zhejiang",
  861305890 => "Huzhou\,\ Zhejiang",
  861305891 => "Huzhou\,\ Zhejiang",
  861305892 => "Huzhou\,\ Zhejiang",
  861305893 => "Huzhou\,\ Zhejiang",
  861305894 => "Huzhou\,\ Zhejiang",
  861305895 => "Jinhua\,\ Zhejiang",
  861305896 => "Jinhua\,\ Zhejiang",
  861305897 => "Jinhua\,\ Zhejiang",
  861305898 => "Jinhua\,\ Zhejiang",
  861305899 => "Jinhua\,\ Zhejiang",
  861305900 => "Harbin\,\ Heilongjiang",
  861305901 => "Harbin\,\ Heilongjiang",
  861305902 => "Harbin\,\ Heilongjiang",
  861305903 => "Harbin\,\ Heilongjiang",
  861305904 => "Daqing\,\ Heilongjiang",
  861305905 => "Daqing\,\ Heilongjiang",
  861305906 => "Daqing\,\ Heilongjiang",
  861305907 => "Daqing\,\ Heilongjiang",
  861305908 => "Daqing\,\ Heilongjiang",
  861305909 => "Daqing\,\ Heilongjiang",
  86130591 => "Guangzhou\,\ Guangdong",
  86130592 => "Jiangmen\,\ Guangdong",
  861305930 => "Yunfu\,\ Guangdong",
  861305931 => "Yunfu\,\ Guangdong",
  861305932 => "Yunfu\,\ Guangdong",
  861305933 => "Yunfu\,\ Guangdong",
  861305934 => "Yunfu\,\ Guangdong",
  861305935 => "Zhaoqing\,\ Guangdong",
  861305936 => "Zhaoqing\,\ Guangdong",
  861305937 => "Zhaoqing\,\ Guangdong",
  861305938 => "Zhaoqing\,\ Guangdong",
  861305939 => "Zhaoqing\,\ Guangdong",
  861305940 => "Dongguan\,\ Guangdong",
  861305941 => "Dongguan\,\ Guangdong",
  861305942 => "Dongguan\,\ Guangdong",
  861305943 => "Dongguan\,\ Guangdong",
  861305944 => "Dongguan\,\ Guangdong",
  861305945 => "Dongguan\,\ Guangdong",
  861305946 => "Dongguan\,\ Guangdong",
  861305947 => "Zhaoqing\,\ Guangdong",
  861305948 => "Zhaoqing\,\ Guangdong",
  861305949 => "Zhaoqing\,\ Guangdong",
  861305950 => "Huizhou\,\ Guangdong",
  861305951 => "Huizhou\,\ Guangdong",
  861305952 => "Huizhou\,\ Guangdong",
  861305953 => "Huizhou\,\ Guangdong",
  861305954 => "Huizhou\,\ Guangdong",
  861305955 => "Huizhou\,\ Guangdong",
  861305956 => "Huizhou\,\ Guangdong",
  861305957 => "Qingyuan\,\ Guangdong",
  861305958 => "Qingyuan\,\ Guangdong",
  861305959 => "Qingyuan\,\ Guangdong",
  86130596 => "Lishui\,\ Zhejiang",
  86130597 => "Quzhou\,\ Zhejiang",
  86130598 => "Zhoushan\,\ Zhejiang",
  86130599 => "Huzhou\,\ Zhejiang",
  86130600 => "Chengdu\,\ Sichuan",
  861306010 => "Deyang\,\ Sichuan",
  861306011 => "Deyang\,\ Sichuan",
  861306012 => "Deyang\,\ Sichuan",
  861306013 => "Panzhihua\,\ Sichuan",
  861306014 => "Luzhou\,\ Sichuan",
  861306015 => "Luzhou\,\ Sichuan",
  861306016 => "Guangyuan\,\ Sichuan",
  861306017 => "Mianyang\,\ Sichuan",
  861306018 => "Mianyang\,\ Sichuan",
  861306019 => "Mianyang\,\ Sichuan",
  86130602 => "Chongqing",
  861306030 => "Weinan\,\ Shaanxi",
  861306031 => "Weinan\,\ Shaanxi",
  861306032 => "Weinan\,\ Shaanxi",
  861306033 => "Weinan\,\ Shaanxi",
  861306034 => "Xianyang\,\ Shaanxi",
  861306035 => "Xianyang\,\ Shaanxi",
  861306036 => "Xianyang\,\ Shaanxi",
  861306037 => "XiAn\,\ Shaanxi",
  861306038 => "XiAn\,\ Shaanxi",
  861306039 => "XiAn\,\ Shaanxi",
  861306040 => "XiAn\,\ Shaanxi",
  861306041 => "XiAn\,\ Shaanxi",
  861306042 => "XiAn\,\ Shaanxi",
  861306043 => "Weinan\,\ Shaanxi",
  861306044 => "Xianyang\,\ Shaanxi",
  861306045 => "Hanzhong\,\ Shaanxi",
  861306046 => "Hanzhong\,\ Shaanxi",
  861306047 => "Baoji\,\ Shaanxi",
  861306048 => "Baoji\,\ Shaanxi",
  861306049 => "Baoji\,\ Shaanxi",
  861306050 => "Shanwei\,\ Guangdong",
  861306051 => "Shanwei\,\ Guangdong",
  861306052 => "Chaozhou\,\ Guangdong",
  861306053 => "Chaozhou\,\ Guangdong",
  861306054 => "Chaozhou\,\ Guangdong",
  861306055 => "Jieyang\,\ Guangdong",
  861306056 => "Jieyang\,\ Guangdong",
  861306057 => "Jieyang\,\ Guangdong",
  861306058 => "Jieyang\,\ Guangdong",
  861306059 => "Jieyang\,\ Guangdong",
  86130606 => "Guangzhou\,\ Guangdong",
  861306070 => "Meizhou\,\ Guangdong",
  861306071 => "Meizhou\,\ Guangdong",
  861306072 => "Meizhou\,\ Guangdong",
  861306073 => "Meizhou\,\ Guangdong",
  861306074 => "Meizhou\,\ Guangdong",
  861306075 => "Foshan\,\ Guangdong",
  861306076 => "Foshan\,\ Guangdong",
  861306077 => "Foshan\,\ Guangdong",
  861306078 => "Foshan\,\ Guangdong",
  861306079 => "Foshan\,\ Guangdong",
  86130608 => "Guangzhou\,\ Guangdong",
  86130609 => "Guangzhou\,\ Guangdong",
  861306100 => "Binzhou\,\ Shandong",
  861306101 => "Binzhou\,\ Shandong",
  861306102 => "Binzhou\,\ Shandong",
  861306103 => "Binzhou\,\ Shandong",
  861306104 => "Binzhou\,\ Shandong",
  861306105 => "Binzhou\,\ Shandong",
  861306106 => "Binzhou\,\ Shandong",
  861306107 => "Liaocheng\,\ Shandong",
  861306108 => "Liaocheng\,\ Shandong",
  861306109 => "Liaocheng\,\ Shandong",
  86130611 => "Weihai\,\ Shandong",
  86130612 => "Qingdao\,\ Shandong",
  86130613 => "Qingdao\,\ Shandong",
  86130614 => "Qingdao\,\ Shandong",
  861306150 => "Liaocheng\,\ Shandong",
  861306151 => "Liaocheng\,\ Shandong",
  861306152 => "Liaocheng\,\ Shandong",
  861306153 => "Heze\,\ Shandong",
  861306154 => "Heze\,\ Shandong",
  861306155 => "Heze\,\ Shandong",
  861306156 => "Heze\,\ Shandong",
  861306157 => "Heze\,\ Shandong",
  861306158 => "Heze\,\ Shandong",
  861306159 => "Heze\,\ Shandong",
  86130616 => "Shanghai",
  86130617 => "Shanghai",
  86130618 => "Shanghai",
  86130619 => "Shanghai",
  86130620 => "Zaozhuang\,\ Shandong",
  861306210 => "Sanming\,\ Fujian",
  861306211 => "Sanming\,\ Fujian",
  861306212 => "Sanming\,\ Fujian",
  861306213 => "Putian\,\ Fujian",
  861306214 => "Putian\,\ Fujian",
  861306215 => "Putian\,\ Fujian",
  861306216 => "Ningde\,\ Fujian",
  861306217 => "Ningde\,\ Fujian",
  861306218 => "Ningde\,\ Fujian",
  861306219 => "Ningde\,\ Fujian",
  861306220 => "Longyan\,\ Fujian",
  861306221 => "Longyan\,\ Fujian",
  861306222 => "Longyan\,\ Fujian",
  861306223 => "Longyan\,\ Fujian",
  861306224 => "Longyan\,\ Fujian",
  861306225 => "Longyan\,\ Fujian",
  861306226 => "Nanping\,\ Fujian",
  861306227 => "Nanping\,\ Fujian",
  861306228 => "Nanping\,\ Fujian",
  861306229 => "Putian\,\ Fujian",
  86130623 => "Chongqing",
  861306240 => "Zhangzhou\,\ Fujian",
  861306241 => "Zhangzhou\,\ Fujian",
  861306242 => "Zhangzhou\,\ Fujian",
  861306243 => "Xiamen\,\ Fujian",
  861306244 => "Xiamen\,\ Fujian",
  861306245 => "Longyan\,\ Fujian",
  861306246 => "Ningde\,\ Fujian",
  861306247 => "Nanping\,\ Fujian",
  861306248 => "Sanming\,\ Fujian",
  861306249 => "Sanming\,\ Fujian",
  86130625 => "Nanjing\,\ Jiangsu",
  86130626 => "Shanghai",
  86130627 => "Shanghai",
  86130628 => "Shanghai",
  861306290 => "Zhenjiang\,\ Jiangsu",
  861306291 => "Zhenjiang\,\ Jiangsu",
  861306292 => "Zhenjiang\,\ Jiangsu",
  861306293 => "Zhenjiang\,\ Jiangsu",
  861306294 => "Zhenjiang\,\ Jiangsu",
  861306295 => "Taizhou\,\ Jiangsu",
  861306296 => "Taizhou\,\ Jiangsu",
  861306297 => "Taizhou\,\ Jiangsu",
  861306298 => "Taizhou\,\ Jiangsu",
  861306299 => "Taizhou\,\ Jiangsu",
  861306300 => "Zhangzhou\,\ Fujian",
  861306301 => "Zhangzhou\,\ Fujian",
  861306302 => "Zhangzhou\,\ Fujian",
  861306303 => "Xiamen\,\ Fujian",
  861306304 => "Xiamen\,\ Fujian",
  861306305 => "Xiamen\,\ Fujian",
  861306306 => "Xiamen\,\ Fujian",
  861306307 => "Xiamen\,\ Fujian",
  861306308 => "Xiamen\,\ Fujian",
  861306309 => "Xiamen\,\ Fujian",
  86130631 => "Zhangzhou\,\ Fujian",
  861306320 => "MaAnshan\,\ Anhui",
  861306321 => "Hefei\,\ Anhui",
  861306322 => "Huangshan\,\ Anhui",
  861306323 => "Xuancheng\,\ Anhui",
  861306324 => "Xuancheng\,\ Anhui",
  861306325 => "Tongling\,\ Anhui",
  861306326 => "Wuhu\,\ Anhui",
  861306327 => "Anqing\,\ Anhui",
  861306328 => "Anqing\,\ Anhui",
  861306329 => "Chizhou\,\ Anhui",
  861306330 => "Chuzhou\,\ Anhui",
  861306331 => "Bengbu\,\ Anhui",
  861306332 => "Bengbu\,\ Anhui",
  861306333 => "Hefei\,\ Anhui",
  861306334 => "Chuzhou\,\ Anhui",
  861306335 => "Huaibei\,\ Anhui",
  861306336 => "Wuhu\,\ Anhui",
  861306337 => "Fuyang\,\ Anhui",
  861306338 => "Fuyang\,\ Anhui",
  861306339 => "Bozhou\,\ Anhui",
  861306340 => "Suzhou\,\ Anhui",
  861306341 => "Anqing\,\ Anhui",
  861306342 => "LuAn\,\ Anhui",
  861306343 => "LuAn\,\ Anhui",
  861306344 => "Hefei\,\ Anhui",
  861306345 => "Hefei\,\ Anhui",
  861306346 => "Huainan\,\ Anhui",
  861306347 => "Huainan\,\ Anhui",
  861306348 => "Hefei\,\ Anhui",
  861306349 => "Hefei\,\ Anhui",
  861306350 => "Xuzhou\,\ Jiangsu",
  861306351 => "Xuzhou\,\ Jiangsu",
  861306352 => "Xuzhou\,\ Jiangsu",
  861306353 => "Xuzhou\,\ Jiangsu",
  861306354 => "Xuzhou\,\ Jiangsu",
  861306355 => "Nantong\,\ Jiangsu",
  861306356 => "Nantong\,\ Jiangsu",
  861306357 => "Nantong\,\ Jiangsu",
  861306358 => "Nantong\,\ Jiangsu",
  861306359 => "Nantong\,\ Jiangsu",
  86130636 => "Wuxi\,\ Jiangsu",
  86130637 => "Suzhou\,\ Jiangsu",
  86130638 => "Suzhou\,\ Jiangsu",
  86130639 => "Changzhou\,\ Jiangsu",
  86130640 => "Jinan\,\ Shandong",
  861306410 => "Nanchang\,\ Jiangxi",
  861306411 => "Nanchang\,\ Jiangxi",
  861306412 => "Nanchang\,\ Jiangxi",
  861306413 => "Nanchang\,\ Jiangxi",
  861306414 => "Nanchang\,\ Jiangxi",
  861306415 => "Jiujiang\,\ Jiangxi",
  861306416 => "Jiujiang\,\ Jiangxi",
  861306417 => "Jiujiang\,\ Jiangxi",
  861306418 => "Jiujiang\,\ Jiangxi",
  861306419 => "Jiujiang\,\ Jiangxi",
  86130642 => "Kunming\,\ Yunnan",
  861306430 => "Nanchong\,\ Sichuan",
  861306431 => "Nanchong\,\ Sichuan",
  861306432 => "Dazhou\,\ Sichuan",
  861306433 => "Dazhou\,\ Sichuan",
  861306434 => "Neijiang\,\ Sichuan",
  861306435 => "Neijiang\,\ Sichuan",
  861306436 => "Ziyang\,\ Sichuan",
  861306437 => "Ziyang\,\ Sichuan",
  861306438 => "Zigong\,\ Sichuan",
  861306439 => "Zigong\,\ Sichuan",
  861306440 => "Anyang\,\ Henan",
  861306441 => "Anyang\,\ Henan",
  861306442 => "Anyang\,\ Henan",
  861306443 => "Anyang\,\ Henan",
  861306444 => "Anyang\,\ Henan",
  861306445 => "Pingdingshan\,\ Henan",
  861306446 => "Pingdingshan\,\ Henan",
  861306447 => "Pingdingshan\,\ Henan",
  861306448 => "Pingdingshan\,\ Henan",
  861306449 => "Pingdingshan\,\ Henan",
  86130645 => "Wenzhou\,\ Zhejiang",
  86130646 => "Jinhua\,\ Zhejiang",
  86130647 => "Hangzhou\,\ Zhejiang",
  861306480 => "Suqian\,\ Jiangsu",
  861306481 => "Suqian\,\ Jiangsu",
  861306482 => "Suqian\,\ Jiangsu",
  861306483 => "Yancheng\,\ Jiangsu",
  861306484 => "Yancheng\,\ Jiangsu",
  861306485 => "Yancheng\,\ Jiangsu",
  861306486 => "Yancheng\,\ Jiangsu",
  861306487 => "Yancheng\,\ Jiangsu",
  861306488 => "Yangzhou\,\ Jiangsu",
  861306489 => "Yangzhou\,\ Jiangsu",
  861306490 => "HuaiAn\,\ Jiangsu",
  861306491 => "HuaiAn\,\ Jiangsu",
  861306492 => "HuaiAn\,\ Jiangsu",
  861306493 => "HuaiAn\,\ Jiangsu",
  861306494 => "Lianyungang\,\ Jiangsu",
  861306495 => "Lianyungang\,\ Jiangsu",
  861306496 => "Lianyungang\,\ Jiangsu",
  861306497 => "Lianyungang\,\ Jiangsu",
  861306498 => "Yangzhou\,\ Jiangsu",
  861306499 => "Yangzhou\,\ Jiangsu",
  86130650 => "Jinan\,\ Shandong",
  86130651 => "Nanchang\,\ Jiangxi",
  861306520 => "Tieling\,\ Liaoning",
  861306521 => "Tieling\,\ Liaoning",
  861306522 => "Tieling\,\ Liaoning",
  861306523 => "Tieling\,\ Liaoning",
  861306524 => "Tieling\,\ Liaoning",
  861306525 => "Panjin\,\ Liaoning",
  861306526 => "Panjin\,\ Liaoning",
  861306527 => "Panjin\,\ Liaoning",
  861306528 => "Panjin\,\ Liaoning",
  861306529 => "Panjin\,\ Liaoning",
  861306530 => "Fuxin\,\ Liaoning",
  861306531 => "Fuxin\,\ Liaoning",
  861306532 => "Fuxin\,\ Liaoning",
  861306533 => "Fuxin\,\ Liaoning",
  861306534 => "Fuxin\,\ Liaoning",
  861306535 => "Liaoyang\,\ Liaoning",
  861306536 => "Liaoyang\,\ Liaoning",
  861306537 => "Liaoyang\,\ Liaoning",
  861306538 => "Liaoyang\,\ Liaoning",
  861306539 => "Liaoyang\,\ Liaoning",
  86130654 => "Anshan\,\ Liaoning",
  86130655 => "Shaoxing\,\ Zhejiang",
  86130656 => "Ningbo\,\ Zhejiang",
  861306570 => "Hangzhou\,\ Zhejiang",
  861306571 => "Hangzhou\,\ Zhejiang",
  861306572 => "Hangzhou\,\ Zhejiang",
  861306573 => "Hangzhou\,\ Zhejiang",
  861306574 => "Hangzhou\,\ Zhejiang",
  861306575 => "Shaoxing\,\ Zhejiang",
  861306576 => "Shaoxing\,\ Zhejiang",
  861306577 => "Shaoxing\,\ Zhejiang",
  861306578 => "Shaoxing\,\ Zhejiang",
  861306579 => "Shaoxing\,\ Zhejiang",
  86130658 => "Ningbo\,\ Zhejiang",
  86130659 => "Jinhua\,\ Zhejiang",
  861306600 => "Jinan\,\ Shandong",
  861306601 => "Jinan\,\ Shandong",
  861306602 => "Jinan\,\ Shandong",
  861306603 => "Jinan\,\ Shandong",
  861306604 => "Rizhao\,\ Shandong",
  861306605 => "Rizhao\,\ Shandong",
  861306606 => "Rizhao\,\ Shandong",
  861306607 => "Rizhao\,\ Shandong",
  861306608 => "Rizhao\,\ Shandong",
  861306609 => "Rizhao\,\ Shandong",
  86130661 => "Dongguan\,\ Guangdong",
  86130662 => "Jiangmen\,\ Guangdong",
  86130663 => "Guangzhou\,\ Guangdong",
  861306640 => "Jiangmen\,\ Guangdong",
  861306641 => "Jiangmen\,\ Guangdong",
  861306642 => "Jiangmen\,\ Guangdong",
  861306643 => "Jiangmen\,\ Guangdong",
  861306644 => "Foshan\,\ Guangdong",
  861306645 => "Foshan\,\ Guangdong",
  861306646 => "Foshan\,\ Guangdong",
  861306647 => "Foshan\,\ Guangdong",
  861306648 => "Foshan\,\ Guangdong",
  861306649 => "Foshan\,\ Guangdong",
  86130665 => "Shenyang\,\ Liaoning",
  86130666 => "Shenyang\,\ Liaoning",
  86130667 => "Shenyang\,\ Liaoning",
  86130668 => "Shenzhen\,\ Guangdong",
  86130669 => "Shenzhen\,\ Guangdong",
  861306700 => "Sanming\,\ Fujian",
  861306701 => "Sanming\,\ Fujian",
  861306702 => "Quanzhou\,\ Fujian",
  861306703 => "Quanzhou\,\ Fujian",
  861306704 => "Quanzhou\,\ Fujian",
  861306705 => "Quanzhou\,\ Fujian",
  861306706 => "Quanzhou\,\ Fujian",
  861306707 => "Quanzhou\,\ Fujian",
  861306708 => "Quanzhou\,\ Fujian",
  861306709 => "Quanzhou\,\ Fujian",
  861306710 => "Fuzhou\,\ Fujian",
  861306711 => "Fuzhou\,\ Fujian",
  861306712 => "Quanzhou\,\ Fujian",
  861306713 => "Quanzhou\,\ Fujian",
  861306714 => "Quanzhou\,\ Fujian",
  861306715 => "Quanzhou\,\ Fujian",
  861306716 => "Quanzhou\,\ Fujian",
  861306717 => "Quanzhou\,\ Fujian",
  861306718 => "Quanzhou\,\ Fujian",
  861306719 => "Quanzhou\,\ Fujian",
  86130672 => "Fuzhou\,\ Fujian",
  86130673 => "Fuzhou\,\ Fujian",
  861306740 => "Fuzhou\,\ Fujian",
  861306741 => "Fuzhou\,\ Fujian",
  861306742 => "Fuzhou\,\ Fujian",
  861306743 => "Fuzhou\,\ Fujian",
  861306744 => "Fuzhou\,\ Fujian",
  861306745 => "Fuzhou\,\ Fujian",
  861306746 => "Fuzhou\,\ Fujian",
  861306747 => "Quanzhou\,\ Fujian",
  861306748 => "Quanzhou\,\ Fujian",
  861306749 => "Quanzhou\,\ Fujian",
  86130675 => "Jiaxing\,\ Zhejiang",
  86130676 => "Jiaxing\,\ Zhejiang",
  86130677 => "Hangzhou\,\ Zhejiang",
  86130678 => "Hangzhou\,\ Zhejiang",
  86130679 => "Hangzhou\,\ Zhejiang",
  861306800 => "Taiyuan\,\ Shanxi",
  861306801 => "Yuncheng\,\ Shanxi",
  861306802 => "Linfen\,\ Shanxi",
  861306803 => "Jinzhong\,\ Shanxi",
  861306804 => "Taiyuan\,\ Shanxi",
  861306805 => "Jincheng\,\ Shanxi",
  861306806 => "Changzhi\,\ Shanxi",
  861306807 => "Taiyuan\,\ Shanxi",
  861306808 => "Taiyuan\,\ Shanxi",
  861306809 => "Datong\,\ Shanxi",
  86130681 => "Zhongshan\,\ Guangdong",
  86130682 => "Huizhou\,\ Guangdong",
  86130683 => "Chongqing",
  86130684 => "Shenzhen\,\ Guangdong",
  861306850 => "Maoming\,\ Guangdong",
  861306851 => "Maoming\,\ Guangdong",
  861306852 => "Maoming\,\ Guangdong",
  861306853 => "Maoming\,\ Guangdong",
  861306854 => "Yangjiang\,\ Guangdong",
  861306855 => "Yangjiang\,\ Guangdong",
  861306856 => "Yangjiang\,\ Guangdong",
  861306857 => "Heyuan\,\ Guangdong",
  861306858 => "Heyuan\,\ Guangdong",
  861306859 => "Heyuan\,\ Guangdong",
  86130686 => "Foshan\,\ Guangdong",
  861306870 => "Shenzhen\,\ Guangdong",
  861306871 => "Shenzhen\,\ Guangdong",
  861306872 => "Shenzhen\,\ Guangdong",
  861306873 => "Shenzhen\,\ Guangdong",
  861306874 => "Shenzhen\,\ Guangdong",
  861306875 => "Shijiazhuang\,\ Hebei",
  861306876 => "Shijiazhuang\,\ Hebei",
  861306877 => "Shijiazhuang\,\ Hebei",
  861306878 => "Shenzhen\,\ Guangdong",
  861306879 => "Shijiazhuang\,\ Hebei",
  86130688 => "Guangzhou\,\ Guangdong",
  86130689 => "Shantou\,\ Guangdong",
  861306900 => "Changchun\,\ Jilin",
  861306901 => "Changchun\,\ Jilin",
  861306902 => "Siping\,\ Jilin",
  861306903 => "Siping\,\ Jilin",
  861306904 => "Changchun\,\ Jilin",
  861306905 => "Songyuan\,\ Jilin",
  861306906 => "Songyuan\,\ Jilin",
  861306907 => "Tonghua\,\ Jilin",
  861306908 => "Yanbian\,\ Jilin",
  861306909 => "Yanbian\,\ Jilin",
  861306910 => "Changchun\,\ Jilin",
  861306911 => "Changchun\,\ Jilin",
  861306912 => "Changchun\,\ Jilin",
  861306913 => "Changchun\,\ Jilin",
  861306914 => "Changchun\,\ Jilin",
  861306915 => "Jilin\,\ Jilin",
  861306916 => "Jilin\,\ Jilin",
  861306917 => "Jilin\,\ Jilin",
  861306918 => "Jilin\,\ Jilin",
  861306919 => "Tonghua\,\ Jilin",
  861306920 => "Changchun\,\ Jilin",
  861306921 => "Changchun\,\ Jilin",
  861306922 => "Siping\,\ Jilin",
  861306923 => "Yanbian\,\ Jilin",
  861306924 => "Changchun\,\ Jilin",
  861306925 => "Songyuan\,\ Jilin",
  861306926 => "Songyuan\,\ Jilin",
  861306927 => "Tonghua\,\ Jilin",
  861306928 => "Siping\,\ Jilin",
  861306929 => "Tonghua\,\ Jilin",
  861306930 => "Kaifeng\,\ Henan",
  861306931 => "Kaifeng\,\ Henan",
  861306932 => "Kaifeng\,\ Henan",
  861306933 => "Kaifeng\,\ Henan",
  861306934 => "Kaifeng\,\ Henan",
  861306935 => "Xinxiang\,\ Henan",
  861306936 => "Xinxiang\,\ Henan",
  861306937 => "Xinxiang\,\ Henan",
  861306938 => "Xinxiang\,\ Henan",
  861306939 => "Xinxiang\,\ Henan",
  86130694 => "Jiaozuo\,\ Henan",
  861306950 => "Xuchang\,\ Henan",
  861306951 => "Xuchang\,\ Henan",
  861306952 => "Xuchang\,\ Henan",
  861306953 => "Xuchang\,\ Henan",
  861306954 => "Xuchang\,\ Henan",
  861306955 => "Luohe\,\ Henan",
  861306956 => "Luohe\,\ Henan",
  861306957 => "Luohe\,\ Henan",
  861306958 => "Luohe\,\ Henan",
  861306959 => "Luohe\,\ Henan",
  861306960 => "Daqing\,\ Heilongjiang",
  861306961 => "Daqing\,\ Heilongjiang",
  861306962 => "Daqing\,\ Heilongjiang",
  861306963 => "Qiqihar\,\ Heilongjiang",
  861306964 => "Daqing\,\ Heilongjiang",
  861306965 => "Daqing\,\ Heilongjiang",
  861306966 => "Daqing\,\ Heilongjiang",
  861306967 => "Daqing\,\ Heilongjiang",
  861306968 => "Qiqihar\,\ Heilongjiang",
  861306969 => "Daqing\,\ Heilongjiang",
  861306970 => "Harbin\,\ Heilongjiang",
  861306971 => "Harbin\,\ Heilongjiang",
  861306972 => "Harbin\,\ Heilongjiang",
  861306973 => "Qiqihar\,\ Heilongjiang",
  861306974 => "Daqing\,\ Heilongjiang",
  861306975 => "Jiamusi\,\ Heilongjiang",
  861306976 => "Jiamusi\,\ Heilongjiang",
  861306977 => "Suihua\,\ Heilongjiang",
  861306978 => "Mudanjiang\,\ Heilongjiang",
  861306979 => "Mudanjiang\,\ Heilongjiang",
  861306980 => "Jixi\,\ Heilongjiang",
  861306981 => "Jixi\,\ Heilongjiang",
  861306982 => "Mudanjiang\,\ Heilongjiang",
  861306983 => "Mudanjiang\,\ Heilongjiang",
  861306984 => "Qitaihe\,\ Heilongjiang",
  861306985 => "Qitaihe\,\ Heilongjiang",
  861306986 => "Harbin\,\ Heilongjiang",
  861306987 => "Harbin\,\ Heilongjiang",
  861306988 => "Harbin\,\ Heilongjiang",
  861306989 => "Harbin\,\ Heilongjiang",
  861306990 => "Shuangyashan\,\ Heilongjiang",
  861306991 => "Shuangyashan\,\ Heilongjiang",
  861306992 => "Jiamusi\,\ Heilongjiang",
  861306993 => "Jiamusi\,\ Heilongjiang",
  861306994 => "Hegang\,\ Heilongjiang",
  861306995 => "Hegang\,\ Heilongjiang",
  861306996 => "Suihua\,\ Heilongjiang",
  861306997 => "Qiqihar\,\ Heilongjiang",
  861306998 => "Qiqihar\,\ Heilongjiang",
  861306999 => "Qiqihar\,\ Heilongjiang",
  861307000 => "Bayingolin\,\ Xinjiang",
  861307001 => "Bayingolin\,\ Xinjiang",
  861307002 => "Aksu\,\ Xinjiang",
  861307003 => "Aksu\,\ Xinjiang",
  861307004 => "Kashi\,\ Xinjiang",
  861307005 => "Kashi\,\ Xinjiang",
  861307006 => "Kizilsu\,\ Xinjiang",
  861307007 => "Hotan\,\ Xinjiang",
  861307008 => "Hotan\,\ Xinjiang",
  861307009 => "Shihezi\,\ Xinjiang",
  86130701 => "Beijing",
  86130702 => "Guangzhou\,\ Guangdong",
  861307030 => "Tacheng\,\ Xinjiang",
  861307031 => "Tacheng\,\ Xinjiang",
  861307032 => "Altay\,\ Xinjiang",
  861307033 => "Altay\,\ Xinjiang",
  861307034 => "Turpan\,\ Xinjiang",
  861307035 => "Ili\,\ Xinjiang",
  861307036 => "Ili\,\ Xinjiang",
  861307037 => "Karamay\,\ Xinjiang",
  861307038 => "Changji\,\ Xinjiang",
  861307039 => "Karamay\,\ Xinjiang",
  861307040 => "Urumchi\,\ Xinjiang",
  861307041 => "Urumchi\,\ Xinjiang",
  861307042 => "Urumchi\,\ Xinjiang",
  861307043 => "Urumchi\,\ Xinjiang",
  861307044 => "Urumchi\,\ Xinjiang",
  861307045 => "Urumchi\,\ Xinjiang",
  861307046 => "Karamay\,\ Xinjiang",
  861307047 => "Ili\,\ Xinjiang",
  861307048 => "Hami\,\ Xinjiang",
  861307049 => "Ili\,\ Xinjiang",
  86130705 => "Baoding\,\ Hebei",
  86130706 => "Zibo\,\ Shandong",
  86130707 => "Weifang\,\ Shandong",
  86130708 => "Qingdao\,\ Shandong",
  86130709 => "Dongguan\,\ Guangdong",
  86130710 => "Zhengzhou\,\ Henan",
  86130711 => "Beijing",
  86130712 => "Wuhan\,\ Hubei",
  86130713 => "Dongguan\,\ Guangdong",
  86130714 => "Jiangmen\,\ Guangdong",
  86130715 => "Shanwei\,\ Guangdong",
  86130716 => "Maoming\,\ Guangdong",
  86130717 => "Pingdingshan\,\ Henan",
  86130718 => "Hangzhou\,\ Zhejiang",
  86130719 => "Ningbo\,\ Zhejiang",
  86130720 => "Tianjin",
  86130721 => "Shanghai",
  86130722 => "Tianjin",
  86130723 => "Chongqing",
  86130724 => "Shenyang\,\ Liaoning",
  86130725 => "Nanjing\,\ Jiangsu",
  86130726 => "Xinxiang\,\ Henan",
  86130727 => "Wuhan\,\ Hubei",
  86130728 => "Chengdu\,\ Sichuan",
  86130729 => "XiAn\,\ Shaanxi",
  86130730 => "Guangzhou\,\ Guangdong",
  86130731 => "Shijiazhuang\,\ Hebei",
  86130732 => "Nantong\,\ Jiangsu",
  86130733 => "Suzhou\,\ Jiangsu",
  86130734 => "Nanjing\,\ Jiangsu",
  86130735 => "Taiyuan\,\ Shanxi",
  86130736 => "Hangzhou\,\ Zhejiang",
  86130737 => "Zhengzhou\,\ Henan",
  86130738 => "Taizhou\,\ Zhejiang",
  86130739 => "Ningde\,\ Fujian",
  86130740 => "Anqing\,\ Anhui",
  86130741 => "Dalian\,\ Liaoning",
  86130742 => "Foshan\,\ Guangdong",
  86130743 => "Changchun\,\ Jilin",
  86130744 => "Zhaoqing\,\ Guangdong",
  86130745 => "Harbin\,\ Heilongjiang",
  86130746 => "Wenzhou\,\ Zhejiang",
  86130747 => "Hohhot\,\ Inner\ Mongolia",
  86130748 => "Xiamen\,\ Fujian",
  861307490 => "Quanzhou\,\ Fujian",
  861307491 => "Quanzhou\,\ Fujian",
  861307492 => "Quanzhou\,\ Fujian",
  861307493 => "Quanzhou\,\ Fujian",
  861307494 => "Xinyang\,\ Henan",
  861307495 => "Quanzhou\,\ Fujian",
  861307496 => "Quanzhou\,\ Fujian",
  861307497 => "Quanzhou\,\ Fujian",
  861307498 => "Quanzhou\,\ Fujian",
  861307499 => "Quanzhou\,\ Fujian",
  861307500 => "Fuyang\,\ Anhui",
  861307501 => "Bozhou\,\ Anhui",
  861307502 => "Fuyang\,\ Anhui",
  861307503 => "Bozhou\,\ Anhui",
  861307504 => "Bozhou\,\ Anhui",
  861307505 => "Fuyang\,\ Anhui",
  861307506 => "Fuyang\,\ Anhui",
  861307507 => "Bozhou\,\ Anhui",
  861307508 => "Fuyang\,\ Anhui",
  861307509 => "Fuyang\,\ Anhui",
  86130751 => "Meizhou\,\ Guangdong",
  86130752 => "Huizhou\,\ Guangdong",
  86130753 => "Jinan\,\ Shandong",
  86130754 => "Chongqing",
  86130755 => "Hefei\,\ Anhui",
  86130756 => "Zhuhai\,\ Guangdong",
  86130757 => "Wenzhou\,\ Zhejiang",
  86130758 => "Fuzhou\,\ Fujian",
  86130759 => "Fuzhou\,\ Fujian",
  86130760 => "Chengdu\,\ Sichuan",
  86130761 => "Heyuan\,\ Guangdong",
  86130762 => "Shaoguan\,\ Guangdong",
  86130763 => "Shantou\,\ Guangdong",
  86130764 => "Chaozhou\,\ Guangdong",
  86130765 => "Jieyang\,\ Guangdong",
  86130766 => "Qingyuan\,\ Guangdong",
  86130767 => "Guangzhou\,\ Guangdong",
  86130768 => "Guangzhou\,\ Guangdong",
  86130769 => "Shenzhen\,\ Guangdong",
  86130770 => "Zhuzhou\,\ Hunan",
  86130771 => "Yueyang\,\ Hunan",
  86130772 => "Changde\,\ Hunan",
  86130773 => "Changsha\,\ Hunan",
  86130774 => "Foshan\,\ Guangdong",
  86130775 => "Yunfu\,\ Guangdong",
  86130776 => "Guilin\,\ Guangxi",
  86130777 => "Nanning\,\ Guangxi",
  86130778 => "Shenzhen\,\ Guangdong",
  86130779 => "Nanchang\,\ Jiangxi",
  86130780 => "Liuzhou\,\ Guangxi",
  86130781 => "Foshan\,\ Guangdong",
  86130782 => "Zhanjiang\,\ Guangdong",
  86130783 => "Yangjiang\,\ Guangdong",
  86130784 => "Foshan\,\ Guangdong",
  86130785 => "Guiyang\,\ Guizhou",
  86130786 => "Zhongshan\,\ Guangdong",
  86130787 => "Kunming\,\ Yunnan",
  86130788 => "Guangzhou\,\ Guangdong",
  86130789 => "Haikou\,\ Hainan",
  86130790 => "Dazhou\,\ Sichuan",
  86130791 => "Luzhou\,\ Sichuan",
  86130792 => "Shenyang\,\ Liaoning",
  861307930 => "Jiayuguan\,\ Gansu",
  861307931 => "Jiayuguan\,\ Gansu",
  861307932 => "Jiayuguan\,\ Gansu",
  861307933 => "Wuwei\,\ Gansu",
  861307934 => "Dingxi\,\ Gansu",
  861307935 => "Wuwei\,\ Gansu",
  861307936 => "Dingxi\,\ Gansu",
  861307937 => "Wuwei\,\ Gansu",
  861307938 => "Jiayuguan\,\ Gansu",
  861307939 => "Wuwei\,\ Gansu",
  86130794 => "Yingkou\,\ Liaoning",
  861307950 => "Yinchuan\,\ Ningxia",
  861307951 => "Yinchuan\,\ Ningxia",
  861307952 => "Shizuishan\,\ Ningxia",
  861307953 => "Wuzhong\,\ Ningxia",
  861307954 => "Guyuan\,\ Ningxia",
  861307955 => "Wuzhong\,\ Ningxia",
  861307956 => "Shizuishan\,\ Ningxia",
  861307957 => "Wuzhong\,\ Ningxia",
  861307958 => "Yinchuan\,\ Ningxia",
  861307959 => "Yinchuan\,\ Ningxia",
  86130796 => "Qiqihar\,\ Heilongjiang",
  86130797 => "Jilin\,\ Jilin",
  86130798 => "Dalian\,\ Liaoning",
  86130799 => "Urumchi\,\ Xinjiang",
  861308000 => "Tonghua\,\ Jilin",
  861308001 => "Changchun\,\ Jilin",
  861308002 => "Changchun\,\ Jilin",
  861308003 => "Changchun\,\ Jilin",
  861308004 => "Changchun\,\ Jilin",
  861308005 => "Tonghua\,\ Jilin",
  861308006 => "Baicheng\,\ Jilin",
  861308007 => "Songyuan\,\ Jilin",
  861308008 => "Songyuan\,\ Jilin",
  861308009 => "Songyuan\,\ Jilin",
  861308010 => "Puyang\,\ Henan",
  861308011 => "Puyang\,\ Henan",
  861308012 => "Puyang\,\ Henan",
  861308013 => "Luohe\,\ Henan",
  861308014 => "Luohe\,\ Henan",
  861308015 => "Xuchang\,\ Henan",
  861308016 => "Xuchang\,\ Henan",
  861308017 => "Xuchang\,\ Henan",
  861308018 => "Xuchang\,\ Henan",
  861308019 => "Xuchang\,\ Henan",
  861308020 => "Hohhot\,\ Inner\ Mongolia",
  861308021 => "Baotou\,\ Inner\ Mongolia",
  861308022 => "Baotou\,\ Inner\ Mongolia",
  861308023 => "Hinggan\,\ Inner\ Mongolia",
  861308024 => "Tongliao\,\ Inner\ Mongolia",
  861308025 => "Tongliao\,\ Inner\ Mongolia",
  861308026 => "Chifeng\,\ Inner\ Mongolia",
  861308027 => "Chifeng\,\ Inner\ Mongolia",
  861308028 => "Bayannur\,\ Inner\ Mongolia",
  861308029 => "Ordos\,\ Inner\ Mongolia",
  861308030 => "Xinzhou\,\ Shanxi",
  861308031 => "Taiyuan\,\ Shanxi",
  861308032 => "Datong\,\ Shanxi",
  861308033 => "Yangquan\,\ Shanxi",
  861308034 => "Yuncheng\,\ Shanxi",
  861308035 => "Changzhi\,\ Shanxi",
  861308036 => "Jincheng\,\ Shanxi",
  861308037 => "Linfen\,\ Shanxi",
  861308038 => "Lüliang\,\ Shanxi",
  861308039 => "Shuozhou\,\ Shanxi",
  861308040 => "Handan\,\ Hebei",
  861308041 => "Shijiazhuang\,\ Hebei",
  861308042 => "Baoding\,\ Hebei",
  861308043 => "Zhangjiakou\,\ Hebei",
  861308044 => "Handan\,\ Hebei",
  861308045 => "Tangshan\,\ Hebei",
  861308046 => "Shijiazhuang\,\ Hebei",
  861308047 => "Cangzhou\,\ Hebei",
  861308048 => "Tangshan\,\ Hebei",
  861308049 => "Baoding\,\ Hebei",
  861308050 => "Changsha\,\ Hunan",
  861308051 => "Changsha\,\ Hunan",
  861308052 => "Changsha\,\ Hunan",
  861308053 => "Changsha\,\ Hunan",
  861308054 => "Changsha\,\ Hunan",
  861308055 => "Changsha\,\ Hunan",
  861308056 => "Changsha\,\ Hunan",
  861308057 => "Yiyang\,\ Hunan",
  861308058 => "Yiyang\,\ Hunan",
  861308059 => "Yiyang\,\ Hunan",
  86130806 => "Wuhan\,\ Hubei",
  86130807 => "Shenyang\,\ Liaoning",
  86130808 => "Shenyang\,\ Liaoning",
  861308090 => "XiAn\,\ Shaanxi",
  861308091 => "XiAn\,\ Shaanxi",
  861308092 => "XiAn\,\ Shaanxi",
  861308093 => "XiAn\,\ Shaanxi",
  861308094 => "YanAn\,\ Shaanxi",
  861308095 => "YanAn\,\ Shaanxi",
  861308096 => "Yulin\,\ Shaanxi",
  861308097 => "Yulin\,\ Shaanxi",
  861308098 => "Yulin\,\ Shaanxi",
  861308099 => "Shangluo\,\ Shaanxi",
  86130810 => "Shijiazhuang\,\ Hebei",
  861308110 => "Shijiazhuang\,\ Hebei",
  861308111 => "Shijiazhuang\,\ Hebei",
  861308112 => "Shijiazhuang\,\ Hebei",
  861308113 => "Tangshan\,\ Hebei",
  861308114 => "Tangshan\,\ Hebei",
  861308115 => "Tangshan\,\ Hebei",
  861308116 => "Tangshan\,\ Hebei",
  861308117 => "Tangshan\,\ Hebei",
  861308118 => "Tangshan\,\ Hebei",
  861308119 => "Tangshan\,\ Hebei",
  861308120 => "Anshan\,\ Liaoning",
  861308121 => "Anshan\,\ Liaoning",
  861308122 => "Anshan\,\ Liaoning",
  861308123 => "Anshan\,\ Liaoning",
  861308124 => "Anshan\,\ Liaoning",
  861308125 => "Dandong\,\ Liaoning",
  861308126 => "Dandong\,\ Liaoning",
  861308127 => "Jinzhou\,\ Liaoning",
  861308128 => "Jinzhou\,\ Liaoning",
  861308129 => "Jinzhou\,\ Liaoning",
  861308130 => "Fushun\,\ Liaoning",
  861308131 => "Fushun\,\ Liaoning",
  861308132 => "Fushun\,\ Liaoning",
  861308133 => "Fushun\,\ Liaoning",
  861308134 => "Fushun\,\ Liaoning",
  861308135 => "Benxi\,\ Liaoning",
  861308136 => "Benxi\,\ Liaoning",
  861308137 => "Benxi\,\ Liaoning",
  861308138 => "Benxi\,\ Liaoning",
  861308139 => "Benxi\,\ Liaoning",
  861308140 => "Dongying\,\ Shandong",
  861308141 => "Dongying\,\ Shandong",
  861308142 => "Jinan\,\ Shandong",
  861308143 => "Weifang\,\ Shandong",
  861308144 => "Weifang\,\ Shandong",
  861308145 => "Weifang\,\ Shandong",
  861308146 => "Liaocheng\,\ Shandong",
  861308147 => "TaiAn\,\ Shandong",
  861308148 => "Heze\,\ Shandong",
  861308149 => "Weihai\,\ Shandong",
  861308150 => "Hohhot\,\ Inner\ Mongolia",
  861308151 => "Hohhot\,\ Inner\ Mongolia",
  861308152 => "Hohhot\,\ Inner\ Mongolia",
  861308153 => "Baotou\,\ Inner\ Mongolia",
  861308154 => "Baotou\,\ Inner\ Mongolia",
  861308155 => "Ordos\,\ Inner\ Mongolia",
  861308156 => "Bayannur\,\ Inner\ Mongolia",
  861308157 => "Chifeng\,\ Inner\ Mongolia",
  861308158 => "Hinggan\,\ Inner\ Mongolia",
  861308159 => "Xilin\,\ Inner\ Mongolia",
  861308160 => "Yantai\,\ Shandong",
  861308161 => "Yantai\,\ Shandong",
  861308162 => "Yantai\,\ Shandong",
  861308163 => "Yantai\,\ Shandong",
  861308164 => "Yantai\,\ Shandong",
  861308165 => "Weifang\,\ Shandong",
  861308166 => "Weifang\,\ Shandong",
  861308167 => "Weifang\,\ Shandong",
  861308168 => "Weifang\,\ Shandong",
  861308169 => "Weifang\,\ Shandong",
  861308170 => "Yingkou\,\ Liaoning",
  861308171 => "Yingkou\,\ Liaoning",
  861308172 => "Yingkou\,\ Liaoning",
  861308173 => "Yingkou\,\ Liaoning",
  861308174 => "Fuxin\,\ Liaoning",
  861308175 => "Liaoyang\,\ Liaoning",
  861308176 => "Liaoyang\,\ Liaoning",
  861308177 => "Liaoyang\,\ Liaoning",
  861308178 => "Liaoyang\,\ Liaoning",
  861308179 => "Tieling\,\ Liaoning",
  861308180 => "Hengshui\,\ Hebei",
  861308181 => "Hengshui\,\ Hebei",
  861308182 => "Zhangjiakou\,\ Hebei",
  861308183 => "Zhangjiakou\,\ Hebei",
  861308184 => "Qinhuangdao\,\ Hebei",
  861308185 => "Qinhuangdao\,\ Hebei",
  861308186 => "Qinhuangdao\,\ Hebei",
  861308187 => "Qinhuangdao\,\ Hebei",
  861308188 => "Qinhuangdao\,\ Hebei",
  861308189 => "Chengde\,\ Hebei",
  86130819 => "Ningbo\,\ Zhejiang",
  861308200 => "Xingtai\,\ Hebei",
  861308201 => "Xingtai\,\ Hebei",
  861308202 => "Xingtai\,\ Hebei",
  861308203 => "Xingtai\,\ Hebei",
  861308204 => "Langfang\,\ Hebei",
  861308205 => "Langfang\,\ Hebei",
  861308206 => "Langfang\,\ Hebei",
  861308207 => "Langfang\,\ Hebei",
  861308208 => "Langfang\,\ Hebei",
  861308209 => "Langfang\,\ Hebei",
  861308210 => "Handan\,\ Hebei",
  861308211 => "Handan\,\ Hebei",
  861308212 => "Handan\,\ Hebei",
  861308213 => "Handan\,\ Hebei",
  861308214 => "Handan\,\ Hebei",
  861308215 => "Handan\,\ Hebei",
  861308216 => "Cangzhou\,\ Hebei",
  861308217 => "Cangzhou\,\ Hebei",
  861308218 => "Cangzhou\,\ Hebei",
  861308219 => "Cangzhou\,\ Hebei",
  861308220 => "Chaoyang\,\ Liaoning",
  861308221 => "Chaoyang\,\ Liaoning",
  861308222 => "Panjin\,\ Liaoning",
  861308223 => "Panjin\,\ Liaoning",
  861308224 => "Huludao\,\ Liaoning",
  861308225 => "Anshan\,\ Liaoning",
  861308226 => "Anshan\,\ Liaoning",
  861308227 => "Fushun\,\ Liaoning",
  861308228 => "Fushun\,\ Liaoning",
  861308229 => "Yingkou\,\ Liaoning",
  86130823 => "Baoding\,\ Hebei",
  86130824 => "Shenyang\,\ Liaoning",
  861308250 => "Changzhou\,\ Jiangsu",
  861308251 => "Changzhou\,\ Jiangsu",
  861308252 => "Suzhou\,\ Jiangsu",
  861308253 => "Lianyungang\,\ Jiangsu",
  861308254 => "Nanjing\,\ Jiangsu",
  861308255 => "Nanjing\,\ Jiangsu",
  861308256 => "Yangzhou\,\ Jiangsu",
  861308257 => "Yangzhou\,\ Jiangsu",
  861308258 => "Suqian\,\ Jiangsu",
  861308259 => "Yancheng\,\ Jiangsu",
  861308260 => "Dongying\,\ Shandong",
  861308261 => "Dongying\,\ Shandong",
  861308262 => "Jining\,\ Shandong",
  861308263 => "Jining\,\ Shandong",
  861308264 => "Linyi\,\ Shandong",
  861308265 => "Linyi\,\ Shandong",
  861308266 => "Linyi\,\ Shandong",
  861308267 => "Weihai\,\ Shandong",
  861308268 => "Weihai\,\ Shandong",
  861308269 => "Heze\,\ Shandong",
  861308270 => "Zibo\,\ Shandong",
  861308271 => "Zibo\,\ Shandong",
  861308272 => "Binzhou\,\ Shandong",
  861308273 => "Jinan\,\ Shandong",
  861308274 => "Jinan\,\ Shandong",
  861308275 => "Jinan\,\ Shandong",
  861308276 => "Dezhou\,\ Shandong",
  861308277 => "TaiAn\,\ Shandong",
  861308278 => "Liaocheng\,\ Shandong",
  861308279 => "Rizhao\,\ Shandong",
  861308280 => "Hangzhou\,\ Zhejiang",
  861308281 => "Hangzhou\,\ Zhejiang",
  861308282 => "Hangzhou\,\ Zhejiang",
  861308283 => "Hangzhou\,\ Zhejiang",
  861308284 => "Hangzhou\,\ Zhejiang",
  861308285 => "Hangzhou\,\ Zhejiang",
  861308286 => "Zhoushan\,\ Zhejiang",
  861308287 => "Zhoushan\,\ Zhejiang",
  861308288 => "Quzhou\,\ Zhejiang",
  861308289 => "Lishui\,\ Zhejiang",
  86130829 => "Ningbo\,\ Zhejiang",
  861308300 => "Hefei\,\ Anhui",
  861308301 => "Bengbu\,\ Anhui",
  861308302 => "Suzhou\,\ Anhui",
  861308303 => "Wuhu\,\ Anhui",
  861308304 => "Chizhou\,\ Anhui",
  861308305 => "Hefei\,\ Anhui",
  861308306 => "Hefei\,\ Anhui",
  861308307 => "Huainan\,\ Anhui",
  861308308 => "Hefei\,\ Anhui",
  861308309 => "Hefei\,\ Anhui",
  861308310 => "MaAnshan\,\ Anhui",
  861308311 => "MaAnshan\,\ Anhui",
  861308312 => "Xuancheng\,\ Anhui",
  861308313 => "Xuancheng\,\ Anhui",
  861308314 => "Chuzhou\,\ Anhui",
  861308315 => "Tongling\,\ Anhui",
  861308316 => "Anqing\,\ Anhui",
  861308317 => "Anqing\,\ Anhui",
  861308318 => "Anqing\,\ Anhui",
  861308319 => "Hefei\,\ Anhui",
  861308320 => "MaAnshan\,\ Anhui",
  861308321 => "Wuhu\,\ Anhui",
  861308322 => "Huangshan\,\ Anhui",
  861308323 => "Huangshan\,\ Anhui",
  861308324 => "Xuancheng\,\ Anhui",
  861308325 => "Tongling\,\ Anhui",
  861308326 => "Wuhu\,\ Anhui",
  861308327 => "Bengbu\,\ Anhui",
  861308328 => "Chizhou\,\ Anhui",
  861308329 => "Chizhou\,\ Anhui",
  861308330 => "Chuzhou\,\ Anhui",
  861308331 => "Chuzhou\,\ Anhui",
  861308332 => "Chuzhou\,\ Anhui",
  861308333 => "Chuzhou\,\ Anhui",
  861308334 => "Fuyang\,\ Anhui",
  861308335 => "Huaibei\,\ Anhui",
  861308336 => "Bozhou\,\ Anhui",
  861308337 => "Fuyang\,\ Anhui",
  861308338 => "Bozhou\,\ Anhui",
  861308339 => "Fuyang\,\ Anhui",
  861308340 => "Hefei\,\ Anhui",
  861308341 => "Hefei\,\ Anhui",
  861308342 => "Hefei\,\ Anhui",
  861308343 => "Tongling\,\ Anhui",
  861308344 => "Hefei\,\ Anhui",
  861308345 => "Hefei\,\ Anhui",
  861308346 => "Huainan\,\ Anhui",
  861308347 => "Fuyang\,\ Anhui",
  861308348 => "Hefei\,\ Anhui",
  861308349 => "Hefei\,\ Anhui",
  861308350 => "Wuxi\,\ Jiangsu",
  861308351 => "Wuxi\,\ Jiangsu",
  861308352 => "Suzhou\,\ Jiangsu",
  861308353 => "Xuzhou\,\ Jiangsu",
  861308354 => "Xuzhou\,\ Jiangsu",
  861308355 => "HuaiAn\,\ Jiangsu",
  861308356 => "Nantong\,\ Jiangsu",
  861308357 => "Nantong\,\ Jiangsu",
  861308358 => "Taizhou\,\ Jiangsu",
  861308359 => "Zhenjiang\,\ Jiangsu",
  861308360 => "Zhengzhou\,\ Henan",
  861308361 => "Xuchang\,\ Henan",
  861308362 => "Luoyang\,\ Henan",
  861308363 => "Luoyang\,\ Henan",
  861308364 => "Luoyang\,\ Henan",
  861308365 => "Luoyang\,\ Henan",
  861308366 => "Zhengzhou\,\ Henan",
  861308367 => "Jiaozuo\,\ Henan",
  861308368 => "Jiaozuo\,\ Henan",
  861308369 => "Zhengzhou\,\ Henan",
  861308370 => "Shangqiu\,\ Henan",
  861308371 => "Zhengzhou\,\ Henan",
  861308372 => "Anyang\,\ Henan",
  861308373 => "Xinxiang\,\ Henan",
  861308374 => "Xuchang\,\ Henan",
  861308375 => "Pingdingshan\,\ Henan",
  861308376 => "Xinyang\,\ Henan",
  861308377 => "Nanyang\,\ Henan",
  861308378 => "Kaifeng\,\ Henan",
  861308379 => "Luoyang\,\ Henan",
  861308380 => "Xinxiang\,\ Henan",
  861308381 => "Xinxiang\,\ Henan",
  861308382 => "Xinxiang\,\ Henan",
  861308383 => "Jiaozuo\,\ Henan",
  861308384 => "Jiaozuo\,\ Henan",
  861308385 => "Anyang\,\ Henan",
  861308386 => "Anyang\,\ Henan",
  861308387 => "Anyang\,\ Henan",
  861308388 => "Kaifeng\,\ Henan",
  861308389 => "Puyang\,\ Henan",
  861308390 => "Huzhou\,\ Zhejiang",
  861308391 => "Huzhou\,\ Zhejiang",
  861308392 => "Huzhou\,\ Zhejiang",
  861308393 => "Wenzhou\,\ Zhejiang",
  861308394 => "Quzhou\,\ Zhejiang",
  861308395 => "Hangzhou\,\ Zhejiang",
  861308396 => "Hangzhou\,\ Zhejiang",
  861308397 => "Hangzhou\,\ Zhejiang",
  861308398 => "Hangzhou\,\ Zhejiang",
  861308399 => "Hangzhou\,\ Zhejiang",
  861308400 => "Suzhou\,\ Anhui",
  861308401 => "Suzhou\,\ Anhui",
  861308402 => "Fuyang\,\ Anhui",
  861308403 => "LuAn\,\ Anhui",
  861308404 => "LuAn\,\ Anhui",
  861308405 => "Huaibei\,\ Anhui",
  861308406 => "Bozhou\,\ Anhui",
  861308407 => "Bengbu\,\ Anhui",
  861308408 => "Bengbu\,\ Anhui",
  861308409 => "Xuancheng\,\ Anhui",
  86130841 => "Dalian\,\ Liaoning",
  861308420 => "Xinxiang\,\ Henan",
  861308421 => "Xinxiang\,\ Henan",
  861308422 => "Hebi\,\ Henan",
  861308423 => "Hebi\,\ Henan",
  861308424 => "Kaifeng\,\ Henan",
  861308425 => "Luohe\,\ Henan",
  861308426 => "Luohe\,\ Henan",
  861308427 => "Luohe\,\ Henan",
  861308428 => "Zhoukou\,\ Henan",
  861308429 => "Zhoukou\,\ Henan",
  861308430 => "YaAn\,\ Sichuan",
  861308431 => "Dazhou\,\ Sichuan",
  861308432 => "Bazhong\,\ Sichuan",
  861308433 => "Nanchong\,\ Sichuan",
  861308434 => "Suining\,\ Sichuan",
  861308435 => "GuangAn\,\ Sichuan",
  861308436 => "Liangshan\,\ Sichuan",
  861308437 => "Guangyuan\,\ Sichuan",
  861308438 => "Deyang\,\ Sichuan",
  861308439 => "Panzhihua\,\ Sichuan",
  861308440 => "Chengdu\,\ Sichuan",
  861308441 => "Chengdu\,\ Sichuan",
  861308442 => "Chengdu\,\ Sichuan",
  861308443 => "Chengdu\,\ Sichuan",
  861308444 => "Chengdu\,\ Sichuan",
  861308445 => "Chengdu\,\ Sichuan",
  861308446 => "Chengdu\,\ Sichuan",
  861308447 => "Chengdu\,\ Sichuan",
  861308448 => "Mianyang\,\ Sichuan",
  861308449 => "Mianyang\,\ Sichuan",
  861308450 => "Cangzhou\,\ Hebei",
  861308451 => "Cangzhou\,\ Hebei",
  861308452 => "Cangzhou\,\ Hebei",
  861308453 => "Qinhuangdao\,\ Hebei",
  861308454 => "Hengshui\,\ Hebei",
  861308455 => "Langfang\,\ Hebei",
  861308456 => "Xingtai\,\ Hebei",
  861308457 => "Zhangjiakou\,\ Hebei",
  861308458 => "Zhangjiakou\,\ Hebei",
  861308459 => "Chengde\,\ Hebei",
  861308460 => "Shaoxing\,\ Zhejiang",
  861308461 => "Wenzhou\,\ Zhejiang",
  861308462 => "Wenzhou\,\ Zhejiang",
  861308463 => "Wenzhou\,\ Zhejiang",
  861308464 => "Jinhua\,\ Zhejiang",
  861308465 => "Jinhua\,\ Zhejiang",
  861308466 => "Jinhua\,\ Zhejiang",
  861308467 => "Taizhou\,\ Zhejiang",
  861308468 => "Taizhou\,\ Zhejiang",
  861308469 => "Lishui\,\ Zhejiang",
  861308470 => "Hulun\,\ Inner\ Mongolia",
  861308471 => "Hohhot\,\ Inner\ Mongolia",
  861308472 => "Baotou\,\ Inner\ Mongolia",
  861308473 => "Wuhai\,\ Inner\ Mongolia",
  861308474 => "Ulanqab\,\ Inner\ Mongolia",
  861308475 => "Tongliao\,\ Inner\ Mongolia",
  861308476 => "Chifeng\,\ Inner\ Mongolia",
  861308477 => "Ordos\,\ Inner\ Mongolia",
  861308478 => "Bayannur\,\ Inner\ Mongolia",
  861308479 => "Xilin\,\ Inner\ Mongolia",
  861308480 => "Ankang\,\ Shaanxi",
  861308481 => "Ankang\,\ Shaanxi",
  861308482 => "Yulin\,\ Shaanxi",
  861308483 => "Yulin\,\ Shaanxi",
  861308484 => "Yulin\,\ Shaanxi",
  861308485 => "YanAn\,\ Shaanxi",
  861308486 => "YanAn\,\ Shaanxi",
  861308487 => "Hanzhong\,\ Shaanxi",
  861308488 => "Hanzhong\,\ Shaanxi",
  861308489 => "Hanzhong\,\ Shaanxi",
  861308490 => "Baise\,\ Guangxi",
  861308491 => "Nanning\,\ Guangxi",
  861308492 => "Liuzhou\,\ Guangxi",
  861308493 => "Liuzhou\,\ Guangxi",
  861308494 => "Hechi\,\ Guangxi",
  861308495 => "Guigang\,\ Guangxi",
  861308496 => "Yulin\,\ Guangxi",
  861308497 => "Qinzhou\,\ Guangxi",
  861308498 => "Nanning\,\ Guangxi",
  861308499 => "Nanning\,\ Guangxi",
  861308500 => "Hefei\,\ Anhui",
  861308501 => "Suzhou\,\ Anhui",
  861308502 => "LuAn\,\ Anhui",
  861308503 => "LuAn\,\ Anhui",
  861308504 => "LuAn\,\ Anhui",
  861308505 => "Hefei\,\ Anhui",
  861308506 => "Hefei\,\ Anhui",
  861308507 => "Huaibei\,\ Anhui",
  861308508 => "Huainan\,\ Anhui",
  861308509 => "LuAn\,\ Anhui",
  861308510 => "Jingzhou\,\ Hubei",
  861308511 => "Jingzhou\,\ Hubei",
  861308512 => "Wuhan\,\ Hubei",
  861308513 => "Wuhan\,\ Hubei",
  861308514 => "Wuhan\,\ Hubei",
  861308515 => "Yichang\,\ Hubei",
  861308516 => "Yichang\,\ Hubei",
  861308517 => "Jingmen\,\ Hubei",
  861308518 => "Jingmen\,\ Hubei",
  861308519 => "Enshi\,\ Hubei",
  861308520 => "Huangshi\,\ Hubei",
  861308521 => "Huanggang\,\ Hubei",
  861308522 => "Huanggang\,\ Hubei",
  861308523 => "Ezhou\,\ Hubei",
  861308524 => "Suizhou\,\ Hubei",
  861308525 => "Suizhou\,\ Hubei",
  861308526 => "Shiyan\,\ Hubei",
  861308527 => "Xianning\,\ Hubei",
  861308528 => "Xiangfan\,\ Hubei",
  861308529 => "Xiangfan\,\ Hubei",
  861308530 => "Xishuangbanna\,\ Yunnan",
  861308531 => "Puer\,\ Yunnan",
  861308532 => "Puer\,\ Yunnan",
  861308533 => "Kunming\,\ Yunnan",
  861308534 => "Kunming\,\ Yunnan",
  861308535 => "Kunming\,\ Yunnan",
  861308536 => "Kunming\,\ Yunnan",
  861308537 => "Kunming\,\ Yunnan",
  861308538 => "Kunming\,\ Yunnan",
  861308539 => "Kunming\,\ Yunnan",
  861308540 => "Zhangjiajie\,\ Hunan",
  861308541 => "Zhangjiajie\,\ Hunan",
  861308542 => "Yongzhou\,\ Hunan",
  861308543 => "Yongzhou\,\ Hunan",
  861308544 => "Yongzhou\,\ Hunan",
  861308545 => "Xiangxi\,\ Hunan",
  861308546 => "Xiangxi\,\ Hunan",
  861308547 => "Huaihua\,\ Hunan",
  861308548 => "Loudi\,\ Hunan",
  861308549 => "Loudi\,\ Hunan",
  861308550 => "Chuzhou\,\ Anhui",
  861308551 => "Hefei\,\ Anhui",
  861308552 => "Bengbu\,\ Anhui",
  861308553 => "Wuhu\,\ Anhui",
  861308554 => "Huainan\,\ Anhui",
  861308555 => "MaAnshan\,\ Anhui",
  861308556 => "Anqing\,\ Anhui",
  861308557 => "Suzhou\,\ Anhui",
  861308558 => "Fuyang\,\ Anhui",
  861308559 => "Huangshan\,\ Anhui",
  861308560 => "Jiaxing\,\ Zhejiang",
  861308561 => "Jiaxing\,\ Zhejiang",
  861308562 => "Jiaxing\,\ Zhejiang",
  861308563 => "Jiaxing\,\ Zhejiang",
  861308564 => "Jiaxing\,\ Zhejiang",
  861308565 => "Jinhua\,\ Zhejiang",
  861308566 => "Jinhua\,\ Zhejiang",
  861308567 => "Jinhua\,\ Zhejiang",
  861308568 => "Shaoxing\,\ Zhejiang",
  861308569 => "Shaoxing\,\ Zhejiang",
  861308570 => "Qingyuan\,\ Guangdong",
  861308571 => "Qingyuan\,\ Guangdong",
  861308572 => "Qingyuan\,\ Guangdong",
  861308573 => "Chaozhou\,\ Guangdong",
  861308574 => "Chaozhou\,\ Guangdong",
  861308575 => "Shantou\,\ Guangdong",
  861308576 => "Shantou\,\ Guangdong",
  861308577 => "Shantou\,\ Guangdong",
  861308578 => "Shantou\,\ Guangdong",
  861308579 => "Shantou\,\ Guangdong",
  861308580 => "Zhuhai\,\ Guangdong",
  861308581 => "Zhuhai\,\ Guangdong",
  861308582 => "Zhuhai\,\ Guangdong",
  861308583 => "Zhuhai\,\ Guangdong",
  861308584 => "Xingtai\,\ Hebei",
  861308585 => "Zhongshan\,\ Guangdong",
  861308586 => "Zhongshan\,\ Guangdong",
  861308587 => "Zhongshan\,\ Guangdong",
  861308588 => "Zhongshan\,\ Guangdong",
  861308589 => "Zhongshan\,\ Guangdong",
  861308590 => "Baiyin\,\ Gansu",
  861308591 => "Linxia\,\ Gansu",
  861308592 => "Zhangye\,\ Gansu",
  861308593 => "Qingyang\,\ Gansu",
  861308594 => "Tianshui\,\ Gansu",
  861308595 => "Wuwei\,\ Gansu",
  861308596 => "Jiayuguan\,\ Gansu",
  861308597 => "Tianshui\,\ Gansu",
  861308598 => "Tianshui\,\ Gansu",
  861308599 => "Pingliang\,\ Gansu",
  86130860 => "Haikou\,\ Hainan",
  861308610 => "Xinyu\,\ Jiangxi",
  861308611 => "Shangrao\,\ Jiangxi",
  861308612 => "Shangrao\,\ Jiangxi",
  861308613 => "Shangrao\,\ Jiangxi",
  861308614 => "Jingdezhen\,\ Jiangxi",
  861308615 => "Yichun\,\ Jiangxi",
  861308616 => "JiAn\,\ Jiangxi",
  861308617 => "Yichun\,\ Jiangxi",
  861308618 => "Fuzhou\,\ Jiangxi",
  861308619 => "Pingxiang\,\ Jiangxi",
  861308620 => "Haixi\,\ Qinghai",
  861308621 => "Haixi\,\ Qinghai",
  861308622 => "Haixi\,\ Qinghai",
  861308623 => "Hainan\,\ Qinghai",
  861308624 => "Haibei\,\ Qinghai",
  861308625 => "Xining\,\ Qinghai",
  861308626 => "Xining\,\ Qinghai",
  861308627 => "Xining\,\ Qinghai",
  861308628 => "Xining\,\ Qinghai",
  861308629 => "Xining\,\ Qinghai",
  861308630 => "YaAn\,\ Sichuan",
  861308631 => "YaAn\,\ Sichuan",
  861308632 => "Dazhou\,\ Sichuan",
  861308633 => "Dazhou\,\ Sichuan",
  861308634 => "Bazhong\,\ Sichuan",
  861308635 => "Garze\,\ Sichuan",
  861308636 => "Nanchong\,\ Sichuan",
  861308637 => "Nanchong\,\ Sichuan",
  861308638 => "Suining\,\ Sichuan",
  861308639 => "GuangAn\,\ Sichuan",
  861308640 => "Mianyang\,\ Sichuan",
  861308641 => "Mianyang\,\ Sichuan",
  861308642 => "Zigong\,\ Sichuan",
  861308643 => "Neijiang\,\ Sichuan",
  861308644 => "Luzhou\,\ Sichuan",
  861308645 => "Leshan\,\ Sichuan",
  861308646 => "Leshan\,\ Sichuan",
  861308647 => "Meishan\,\ Sichuan",
  861308648 => "Meishan\,\ Sichuan",
  861308649 => "Liangshan\,\ Sichuan",
  861308650 => "Guangyuan\,\ Sichuan",
  861308651 => "Guangyuan\,\ Sichuan",
  861308652 => "Neijiang\,\ Sichuan",
  861308653 => "Aba\,\ Sichuan",
  861308654 => "Yibin\,\ Sichuan",
  861308655 => "Yibin\,\ Sichuan",
  861308656 => "Yibin\,\ Sichuan",
  861308657 => "Ziyang\,\ Sichuan",
  861308658 => "Ziyang\,\ Sichuan",
  861308659 => "Luzhou\,\ Sichuan",
  86130866 => "Chengdu\,\ Sichuan",
  861308670 => "Fangchenggang\,\ Guangxi",
  861308671 => "Nanning\,\ Guangxi",
  861308672 => "Liuzhou\,\ Guangxi",
  861308673 => "Guilin\,\ Guangxi",
  861308674 => "Baise\,\ Guangxi",
  861308675 => "Yulin\,\ Guangxi",
  861308676 => "Hezhou\,\ Guangxi",
  861308677 => "Guigang\,\ Guangxi",
  861308678 => "Hechi\,\ Guangxi",
  861308679 => "Beihai\,\ Guangxi",
  86130868 => "Changchun\,\ Jilin",
  861308690 => "Anshun\,\ Guizhou",
  861308691 => "Qiannan\,\ Guizhou",
  861308692 => "Qiannan\,\ Guizhou",
  861308693 => "Qiannan\,\ Guizhou",
  861308694 => "Qiandongnan\,\ Guizhou",
  861308695 => "Qiandongnan\,\ Guizhou",
  861308696 => "Liupanshui\,\ Guizhou",
  861308697 => "Liupanshui\,\ Guizhou",
  861308698 => "Qianxinan\,\ Guizhou",
  861308699 => "Tongren\,\ Guizhou",
  861308700 => "Kaifeng\,\ Henan",
  861308701 => "Xinyang\,\ Henan",
  861308702 => "Shangqiu\,\ Henan",
  861308703 => "Nanyang\,\ Henan",
  861308704 => "Pingdingshan\,\ Henan",
  861308705 => "Pingdingshan\,\ Henan",
  861308706 => "Pingdingshan\,\ Henan",
  861308707 => "Sanmenxia\,\ Henan",
  861308708 => "Zhumadian\,\ Henan",
  861308709 => "Zhumadian\,\ Henan",
  861308710 => "Hohhot\,\ Inner\ Mongolia",
  861308711 => "Hohhot\,\ Inner\ Mongolia",
  861308712 => "Hohhot\,\ Inner\ Mongolia",
  861308713 => "Hinggan\,\ Inner\ Mongolia",
  861308714 => "Alxa\,\ Inner\ Mongolia",
  861308715 => "Tongliao\,\ Inner\ Mongolia",
  861308716 => "Tongliao\,\ Inner\ Mongolia",
  861308717 => "Tongliao\,\ Inner\ Mongolia",
  861308718 => "Ordos\,\ Inner\ Mongolia",
  861308719 => "Ordos\,\ Inner\ Mongolia",
  861308720 => "Huaihua\,\ Hunan",
  861308721 => "Xiangtan\,\ Hunan",
  861308722 => "Xiangtan\,\ Hunan",
  861308723 => "Xiangtan\,\ Hunan",
  861308724 => "Hengyang\,\ Hunan",
  861308725 => "Chenzhou\,\ Hunan",
  861308726 => "Shaoyang\,\ Hunan",
  861308727 => "Yiyang\,\ Hunan",
  861308728 => "Shaoyang\,\ Hunan",
  861308729 => "Huaihua\,\ Hunan",
  861308730 => "Yueyang\,\ Hunan",
  861308731 => "Changsha\,\ Hunan",
  861308732 => "Xiangtan\,\ Hunan",
  861308733 => "Zhuzhou\,\ Hunan",
  861308734 => "Hengyang\,\ Hunan",
  861308735 => "Chenzhou\,\ Hunan",
  861308736 => "Changde\,\ Hunan",
  861308737 => "Yiyang\,\ Hunan",
  861308738 => "Loudi\,\ Hunan",
  861308739 => "Shaoyang\,\ Hunan",
  861308740 => "Dali\,\ Yunnan",
  861308741 => "Dali\,\ Yunnan",
  861308742 => "Deqen\,\ Yunnan",
  861308743 => "Yuxi\,\ Yunnan",
  861308744 => "Nujiang\,\ Yunnan",
  861308745 => "Honghe\,\ Yunnan",
  861308746 => "Wenshan\,\ Yunnan",
  861308747 => "Qujing\,\ Yunnan",
  861308748 => "Zhaotong\,\ Yunnan",
  861308749 => "Baoshan\,\ Yunnan",
  86130875 => "XiAn\,\ Shaanxi",
  861308760 => "Weinan\,\ Shaanxi",
  861308761 => "Weinan\,\ Shaanxi",
  861308762 => "Weinan\,\ Shaanxi",
  861308763 => "Weinan\,\ Shaanxi",
  861308764 => "Shangluo\,\ Shaanxi",
  861308765 => "Tongchuan\,\ Shaanxi",
  861308766 => "Xianyang\,\ Shaanxi",
  861308767 => "Xianyang\,\ Shaanxi",
  861308768 => "Xianyang\,\ Shaanxi",
  861308769 => "Xianyang\,\ Shaanxi",
  861308770 => "Fangchenggang\,\ Guangxi",
  861308771 => "Nanning\,\ Guangxi",
  861308772 => "Liuzhou\,\ Guangxi",
  861308773 => "Guilin\,\ Guangxi",
  861308774 => "Wuzhou\,\ Guangxi",
  861308775 => "Yulin\,\ Guangxi",
  861308776 => "Baise\,\ Guangxi",
  861308777 => "Qinzhou\,\ Guangxi",
  861308778 => "Hechi\,\ Guangxi",
  861308779 => "Beihai\,\ Guangxi",
  861308780 => "Guiyang\,\ Guizhou",
  861308781 => "Guiyang\,\ Guizhou",
  861308782 => "Guiyang\,\ Guizhou",
  861308783 => "Guiyang\,\ Guizhou",
  861308784 => "Guiyang\,\ Guizhou",
  861308785 => "Guiyang\,\ Guizhou",
  861308786 => "Bijie\,\ Guizhou",
  861308787 => "Zunyi\,\ Guizhou",
  861308788 => "Zunyi\,\ Guizhou",
  861308789 => "Zunyi\,\ Guizhou",
  861308790 => "Nanning\,\ Guangxi",
  861308791 => "Nanning\,\ Guangxi",
  861308792 => "Liuzhou\,\ Guangxi",
  861308793 => "Guilin\,\ Guangxi",
  861308794 => "Wuzhou\,\ Guangxi",
  861308795 => "Yulin\,\ Guangxi",
  861308796 => "Nanning\,\ Guangxi",
  861308797 => "Nanning\,\ Guangxi",
  861308798 => "Wuzhou\,\ Guangxi",
  861308799 => "Nanning\,\ Guangxi",
  86130880 => "Chengdu\,\ Sichuan",
  861308810 => "Mianyang\,\ Sichuan",
  861308811 => "Mianyang\,\ Sichuan",
  861308812 => "GuangAn\,\ Sichuan",
  861308813 => "Nanchong\,\ Sichuan",
  861308814 => "Dazhou\,\ Sichuan",
  861308815 => "Dazhou\,\ Sichuan",
  861308816 => "Suining\,\ Sichuan",
  861308817 => "Luzhou\,\ Sichuan",
  861308818 => "Deyang\,\ Sichuan",
  861308819 => "Nanchong\,\ Sichuan",
  861308820 => "Deyang\,\ Sichuan",
  861308821 => "Bazhong\,\ Sichuan",
  861308822 => "Neijiang\,\ Sichuan",
  861308823 => "Neijiang\,\ Sichuan",
  861308824 => "Ziyang\,\ Sichuan",
  861308825 => "Mianyang\,\ Sichuan",
  861308826 => "Mianyang\,\ Sichuan",
  861308827 => "Mianyang\,\ Sichuan",
  861308828 => "Zigong\,\ Sichuan",
  861308829 => "Zigong\,\ Sichuan",
  861308830 => "Ziyang\,\ Sichuan",
  861308831 => "Luzhou\,\ Sichuan",
  861308832 => "Zigong\,\ Sichuan",
  861308833 => "Yibin\,\ Sichuan",
  861308834 => "Deyang\,\ Sichuan",
  861308835 => "Leshan\,\ Sichuan",
  861308836 => "Panzhihua\,\ Sichuan",
  861308837 => "Liangshan\,\ Sichuan",
  861308838 => "Meishan\,\ Sichuan",
  861308839 => "Leshan\,\ Sichuan",
  861308840 => "Chifeng\,\ Inner\ Mongolia",
  861308841 => "Chifeng\,\ Inner\ Mongolia",
  861308842 => "Chifeng\,\ Inner\ Mongolia",
  861308843 => "Chifeng\,\ Inner\ Mongolia",
  861308844 => "Baotou\,\ Inner\ Mongolia",
  861308845 => "Baotou\,\ Inner\ Mongolia",
  861308846 => "Bayannur\,\ Inner\ Mongolia",
  861308847 => "Bayannur\,\ Inner\ Mongolia",
  861308848 => "Bayannur\,\ Inner\ Mongolia",
  861308849 => "Bayannur\,\ Inner\ Mongolia",
  861308850 => "Hulun\,\ Inner\ Mongolia",
  861308851 => "Hulun\,\ Inner\ Mongolia",
  861308852 => "Hulun\,\ Inner\ Mongolia",
  861308853 => "Hulun\,\ Inner\ Mongolia",
  861308854 => "Hulun\,\ Inner\ Mongolia",
  861308855 => "Hulun\,\ Inner\ Mongolia",
  861308856 => "Baotou\,\ Inner\ Mongolia",
  861308857 => "Ulanqab\,\ Inner\ Mongolia",
  861308858 => "Ulanqab\,\ Inner\ Mongolia",
  861308859 => "Ulanqab\,\ Inner\ Mongolia",
  861308860 => "Taizhou\,\ Zhejiang",
  861308861 => "Taizhou\,\ Zhejiang",
  861308862 => "Taizhou\,\ Zhejiang",
  861308863 => "Taizhou\,\ Zhejiang",
  861308864 => "Taizhou\,\ Zhejiang",
  861308865 => "Wenzhou\,\ Zhejiang",
  861308866 => "Wenzhou\,\ Zhejiang",
  861308867 => "Wenzhou\,\ Zhejiang",
  861308868 => "Wenzhou\,\ Zhejiang",
  861308869 => "Wenzhou\,\ Zhejiang",
  86130887 => "Lanzhou\,\ Gansu",
  86130888 => "Shenzhen\,\ Guangdong",
  861308890 => "Baoji\,\ Shaanxi",
  861308891 => "Baoji\,\ Shaanxi",
  861308892 => "Baoji\,\ Shaanxi",
  861308893 => "Baoji\,\ Shaanxi",
  861308894 => "Baoji\,\ Shaanxi",
  861308895 => "XiAn\,\ Shaanxi",
  861308896 => "XiAn\,\ Shaanxi",
  861308897 => "XiAn\,\ Shaanxi",
  861308898 => "XiAn\,\ Shaanxi",
  861308899 => "XiAn\,\ Shaanxi",
  861308900 => "Daqing\,\ Heilongjiang",
  861308901 => "Daqing\,\ Heilongjiang",
  861308902 => "Daqing\,\ Heilongjiang",
  861308903 => "Daqing\,\ Heilongjiang",
  861308904 => "Daqing\,\ Heilongjiang",
  861308905 => "Daqing\,\ Heilongjiang",
  861308906 => "Daqing\,\ Heilongjiang",
  861308907 => "Daqing\,\ Heilongjiang",
  861308908 => "Daqing\,\ Heilongjiang",
  861308909 => "Heihe\,\ Heilongjiang",
  861308910 => "Changchun\,\ Jilin",
  861308911 => "Changchun\,\ Jilin",
  861308912 => "Changchun\,\ Jilin",
  861308913 => "Changchun\,\ Jilin",
  861308914 => "Changchun\,\ Jilin",
  861308915 => "Jilin\,\ Jilin",
  861308916 => "Jilin\,\ Jilin",
  861308917 => "Jilin\,\ Jilin",
  861308918 => "Jilin\,\ Jilin",
  861308919 => "Tonghua\,\ Jilin",
  861308920 => "Liaoyuan\,\ Jilin",
  861308921 => "Liaoyuan\,\ Jilin",
  861308922 => "Siping\,\ Jilin",
  861308923 => "Siping\,\ Jilin",
  861308924 => "Jilin\,\ Jilin",
  861308925 => "Songyuan\,\ Jilin",
  861308926 => "Songyuan\,\ Jilin",
  861308927 => "Tonghua\,\ Jilin",
  861308928 => "Siping\,\ Jilin",
  861308929 => "Tonghua\,\ Jilin",
  861308930 => "Yanbian\,\ Jilin",
  861308931 => "Yanbian\,\ Jilin",
  861308932 => "Yanbian\,\ Jilin",
  861308933 => "Yanbian\,\ Jilin",
  861308934 => "Yanbian\,\ Jilin",
  861308935 => "Songyuan\,\ Jilin",
  861308936 => "Baicheng\,\ Jilin",
  861308937 => "Baicheng\,\ Jilin",
  861308938 => "Baishan\,\ Jilin",
  861308939 => "Baishan\,\ Jilin",
  861308940 => "Changchun\,\ Jilin",
  861308941 => "Changchun\,\ Jilin",
  861308942 => "Changchun\,\ Jilin",
  861308943 => "Yanbian\,\ Jilin",
  861308944 => "Yanbian\,\ Jilin",
  861308945 => "Jilin\,\ Jilin",
  861308946 => "Jilin\,\ Jilin",
  861308947 => "Jilin\,\ Jilin",
  861308948 => "Jilin\,\ Jilin",
  861308949 => "Jilin\,\ Jilin",
  861308950 => "Hegang\,\ Heilongjiang",
  861308951 => "Hegang\,\ Heilongjiang",
  861308952 => "Heihe\,\ Heilongjiang",
  861308953 => "Qitaihe\,\ Heilongjiang",
  861308954 => "Qitaihe\,\ Heilongjiang",
  861308955 => "Qitaihe\,\ Heilongjiang",
  861308956 => "Jixi\,\ Heilongjiang",
  861308957 => "Jixi\,\ Heilongjiang",
  861308958 => "Jixi\,\ Heilongjiang",
  861308959 => "Yichun\,\ Heilongjiang",
  861308960 => "Yichun\,\ Heilongjiang",
  861308961 => "Yichun\,\ Heilongjiang",
  861308962 => "Yichun\,\ Heilongjiang",
  861308963 => "Jiamusi\,\ Heilongjiang",
  861308964 => "Jiamusi\,\ Heilongjiang",
  861308965 => "Jiamusi\,\ Heilongjiang",
  861308966 => "Jiamusi\,\ Heilongjiang",
  861308967 => "Jiamusi\,\ Heilongjiang",
  861308968 => "Jiamusi\,\ Heilongjiang",
  861308969 => "Jiamusi\,\ Heilongjiang",
  861308970 => "Harbin\,\ Heilongjiang",
  861308971 => "Harbin\,\ Heilongjiang",
  861308972 => "Harbin\,\ Heilongjiang",
  861308973 => "Qiqihar\,\ Heilongjiang",
  861308974 => "Qiqihar\,\ Heilongjiang",
  861308975 => "Qiqihar\,\ Heilongjiang",
  861308976 => "Heihe\,\ Heilongjiang",
  861308977 => "Hegang\,\ Heilongjiang",
  861308978 => "Shuangyashan\,\ Heilongjiang",
  861308979 => "Jixi\,\ Heilongjiang",
  861308980 => "Jixi\,\ Heilongjiang",
  861308981 => "Shuangyashan\,\ Heilongjiang",
  861308982 => "Shuangyashan\,\ Heilongjiang",
  861308983 => "Mudanjiang\,\ Heilongjiang",
  861308984 => "Mudanjiang\,\ Heilongjiang",
  861308985 => "Mudanjiang\,\ Heilongjiang",
  861308986 => "Mudanjiang\,\ Heilongjiang",
  861308987 => "Mudanjiang\,\ Heilongjiang",
  861308988 => "Mudanjiang\,\ Heilongjiang",
  861308989 => "Mudanjiang\,\ Heilongjiang",
  861308990 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861308991 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861308992 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861308993 => "Suihua\,\ Heilongjiang",
  861308994 => "Suihua\,\ Heilongjiang",
  861308995 => "Suihua\,\ Heilongjiang",
  861308996 => "Suihua\,\ Heilongjiang",
  861308997 => "Suihua\,\ Heilongjiang",
  861308998 => "Harbin\,\ Heilongjiang",
  861308999 => "Harbin\,\ Heilongjiang",
  86130900 => "Changji\,\ Xinjiang",
  861309024 => "Shenyang\,\ Liaoning",
  861309029 => "XiAn\,\ Shaanxi",
  861309042 => "Beijing",
  861309044 => "Jinzhou\,\ Liaoning",
  86130905 => "Zunyi\,\ Guizhou",
  861309066 => "Xilin\,\ Inner\ Mongolia",
  861309067 => "Xilin\,\ Inner\ Mongolia",
  861309069 => "Hohhot\,\ Inner\ Mongolia",
  861309100 => "Shijiazhuang\,\ Hebei",
  861309101 => "Shijiazhuang\,\ Hebei",
  861309102 => "Shijiazhuang\,\ Hebei",
  861309103 => "Shijiazhuang\,\ Hebei",
  861309104 => "Tangshan\,\ Hebei",
  861309105 => "Tangshan\,\ Hebei",
  861309106 => "Tangshan\,\ Hebei",
  861309107 => "Tangshan\,\ Hebei",
  861309108 => "Tangshan\,\ Hebei",
  861309109 => "Shijiazhuang\,\ Hebei",
  861309110 => "Handan\,\ Hebei",
  861309111 => "Handan\,\ Hebei",
  861309112 => "Handan\,\ Hebei",
  861309113 => "Handan\,\ Hebei",
  861309114 => "Cangzhou\,\ Hebei",
  861309115 => "Cangzhou\,\ Hebei",
  861309116 => "Cangzhou\,\ Hebei",
  861309117 => "Hengshui\,\ Hebei",
  861309118 => "Hengshui\,\ Hebei",
  861309119 => "Hengshui\,\ Hebei",
  861309120 => "Baoding\,\ Hebei",
  861309121 => "Baoding\,\ Hebei",
  861309122 => "Baoding\,\ Hebei",
  861309123 => "Baoding\,\ Hebei",
  861309124 => "Baoding\,\ Hebei",
  861309125 => "Baoding\,\ Hebei",
  861309126 => "Baoding\,\ Hebei",
  861309127 => "Xingtai\,\ Hebei",
  861309128 => "Xingtai\,\ Hebei",
  861309129 => "Xingtai\,\ Hebei",
  861309130 => "Langfang\,\ Hebei",
  861309131 => "Zhangjiakou\,\ Hebei",
  861309132 => "Zhangjiakou\,\ Hebei",
  861309133 => "Chengde\,\ Hebei",
  861309134 => "Qinhuangdao\,\ Hebei",
  861309135 => "Chengde\,\ Hebei",
  861309136 => "Qinhuangdao\,\ Hebei",
  861309137 => "Qinhuangdao\,\ Hebei",
  861309138 => "Qinhuangdao\,\ Hebei",
  861309139 => "Langfang\,\ Hebei",
  861309140 => "Daqing\,\ Heilongjiang",
  861309141 => "Daqing\,\ Heilongjiang",
  861309142 => "Daqing\,\ Heilongjiang",
  861309143 => "Harbin\,\ Heilongjiang",
  861309144 => "Harbin\,\ Heilongjiang",
  861309145 => "Harbin\,\ Heilongjiang",
  861309146 => "Jixi\,\ Heilongjiang",
  861309147 => "Shuangyashan\,\ Heilongjiang",
  861309148 => "Yichun\,\ Heilongjiang",
  861309149 => "Hegang\,\ Heilongjiang",
  861309150 => "Hegang\,\ Heilongjiang",
  861309151 => "Hegang\,\ Heilongjiang",
  861309152 => "Heihe\,\ Heilongjiang",
  861309153 => "Suihua\,\ Heilongjiang",
  861309154 => "Suihua\,\ Heilongjiang",
  861309155 => "Suihua\,\ Heilongjiang",
  861309156 => "Suihua\,\ Heilongjiang",
  861309157 => "Jixi\,\ Heilongjiang",
  861309158 => "Jixi\,\ Heilongjiang",
  861309159 => "Jixi\,\ Heilongjiang",
  861309160 => "Yichun\,\ Heilongjiang",
  861309161 => "Yichun\,\ Heilongjiang",
  861309162 => "Jiamusi\,\ Heilongjiang",
  861309163 => "Jiamusi\,\ Heilongjiang",
  861309164 => "Jiamusi\,\ Heilongjiang",
  861309165 => "Jiamusi\,\ Heilongjiang",
  861309166 => "Daqing\,\ Heilongjiang",
  861309167 => "Daqing\,\ Heilongjiang",
  861309168 => "Daqing\,\ Heilongjiang",
  861309169 => "Daqing\,\ Heilongjiang",
  861309170 => "Harbin\,\ Heilongjiang",
  861309171 => "Harbin\,\ Heilongjiang",
  861309172 => "Harbin\,\ Heilongjiang",
  861309173 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861309174 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861309175 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861309176 => "Heihe\,\ Heilongjiang",
  861309177 => "Heihe\,\ Heilongjiang",
  861309178 => "Shuangyashan\,\ Heilongjiang",
  861309179 => "Shuangyashan\,\ Heilongjiang",
  861309180 => "Shuangyashan\,\ Heilongjiang",
  861309181 => "Mudanjiang\,\ Heilongjiang",
  861309182 => "Mudanjiang\,\ Heilongjiang",
  861309183 => "Mudanjiang\,\ Heilongjiang",
  861309184 => "Mudanjiang\,\ Heilongjiang",
  861309185 => "Mudanjiang\,\ Heilongjiang",
  861309186 => "Harbin\,\ Heilongjiang",
  861309187 => "Harbin\,\ Heilongjiang",
  861309188 => "Harbin\,\ Heilongjiang",
  861309189 => "Harbin\,\ Heilongjiang",
  86130919 => "Wenzhou\,\ Zhejiang",
  86130920 => "Yangzhou\,\ Jiangsu",
  86130921 => "Yancheng\,\ Jiangsu",
  86130922 => "Taizhou\,\ Jiangsu",
  861309230 => "Xuzhou\,\ Jiangsu",
  861309231 => "Xuzhou\,\ Jiangsu",
  861309232 => "Xuzhou\,\ Jiangsu",
  861309233 => "Xuzhou\,\ Jiangsu",
  861309234 => "Xuzhou\,\ Jiangsu",
  861309235 => "Xuzhou\,\ Jiangsu",
  861309236 => "Xuzhou\,\ Jiangsu",
  861309237 => "Lianyungang\,\ Jiangsu",
  861309238 => "Lianyungang\,\ Jiangsu",
  861309239 => "Lianyungang\,\ Jiangsu",
  861309240 => "Wuxi\,\ Jiangsu",
  861309241 => "Wuxi\,\ Jiangsu",
  861309242 => "Changzhou\,\ Jiangsu",
  861309243 => "Changzhou\,\ Jiangsu",
  861309244 => "Taizhou\,\ Jiangsu",
  861309245 => "Lianyungang\,\ Jiangsu",
  861309246 => "Suqian\,\ Jiangsu",
  861309247 => "Suqian\,\ Jiangsu",
  861309248 => "Suqian\,\ Jiangsu",
  861309249 => "Suqian\,\ Jiangsu",
  86130925 => "Changzhou\,\ Jiangsu",
  861309260 => "Suzhou\,\ Jiangsu",
  861309261 => "Suzhou\,\ Jiangsu",
  861309262 => "Suzhou\,\ Jiangsu",
  861309263 => "Suzhou\,\ Jiangsu",
  861309264 => "Suzhou\,\ Jiangsu",
  861309265 => "Suzhou\,\ Jiangsu",
  861309266 => "Suzhou\,\ Jiangsu",
  861309267 => "Suzhou\,\ Jiangsu",
  861309268 => "Zhenjiang\,\ Jiangsu",
  861309269 => "Zhenjiang\,\ Jiangsu",
  861309270 => "Ezhou\,\ Hubei",
  861309271 => "Ezhou\,\ Hubei",
  861309272 => "Huanggang\,\ Hubei",
  861309273 => "Huanggang\,\ Hubei",
  861309274 => "Huanggang\,\ Hubei",
  861309275 => "Huangshi\,\ Hubei",
  861309276 => "Huangshi\,\ Hubei",
  861309277 => "Huangshi\,\ Hubei",
  861309278 => "Huangshi\,\ Hubei",
  861309279 => "Huangshi\,\ Hubei",
  861309280 => "Liangshan\,\ Sichuan",
  861309281 => "Panzhihua\,\ Sichuan",
  861309282 => "Nanchong\,\ Sichuan",
  861309283 => "Suining\,\ Sichuan",
  861309284 => "GuangAn\,\ Sichuan",
  861309285 => "Dazhou\,\ Sichuan",
  861309286 => "Deyang\,\ Sichuan",
  861309287 => "Neijiang\,\ Sichuan",
  861309288 => "Yibin\,\ Sichuan",
  861309289 => "Zigong\,\ Sichuan",
  861309290 => "Baoji\,\ Shaanxi",
  861309291 => "Baoji\,\ Shaanxi",
  861309292 => "Baoji\,\ Shaanxi",
  861309293 => "Baoji\,\ Shaanxi",
  861309294 => "Xianyang\,\ Shaanxi",
  861309295 => "Xianyang\,\ Shaanxi",
  861309296 => "Xianyang\,\ Shaanxi",
  861309297 => "Xianyang\,\ Shaanxi",
  861309298 => "Xianyang\,\ Shaanxi",
  861309299 => "Xianyang\,\ Shaanxi",
  86130930 => "Wuxi\,\ Jiangsu",
  861309310 => "Wuxi\,\ Jiangsu",
  861309311 => "Wuxi\,\ Jiangsu",
  861309312 => "Wuxi\,\ Jiangsu",
  861309313 => "Wuxi\,\ Jiangsu",
  861309314 => "Wuxi\,\ Jiangsu",
  861309315 => "Changzhou\,\ Jiangsu",
  861309316 => "Changzhou\,\ Jiangsu",
  861309317 => "Changzhou\,\ Jiangsu",
  861309318 => "Changzhou\,\ Jiangsu",
  861309319 => "Changzhou\,\ Jiangsu",
  861309320 => "Jingmen\,\ Hubei",
  861309321 => "Jingmen\,\ Hubei",
  861309322 => "Jingmen\,\ Hubei",
  861309323 => "Jingmen\,\ Hubei",
  861309324 => "Enshi\,\ Hubei",
  861309325 => "Enshi\,\ Hubei",
  861309326 => "Enshi\,\ Hubei",
  861309327 => "Suizhou\,\ Hubei",
  861309328 => "Suizhou\,\ Hubei",
  861309329 => "Wuhan\,\ Hubei",
  861309330 => "Chuzhou\,\ Anhui",
  861309331 => "Chuzhou\,\ Anhui",
  861309332 => "Chuzhou\,\ Anhui",
  861309333 => "Tongling\,\ Anhui",
  861309334 => "Fuyang\,\ Anhui",
  861309335 => "Bozhou\,\ Anhui",
  861309336 => "Fuyang\,\ Anhui",
  861309337 => "Bozhou\,\ Anhui",
  861309338 => "Fuyang\,\ Anhui",
  861309339 => "Fuyang\,\ Anhui",
  861309340 => "Hefei\,\ Anhui",
  861309341 => "LuAn\,\ Anhui",
  861309342 => "LuAn\,\ Anhui",
  861309343 => "LuAn\,\ Anhui",
  861309344 => "Wuhu\,\ Anhui",
  861309345 => "Hefei\,\ Anhui",
  861309346 => "Xuancheng\,\ Anhui",
  861309347 => "Xuancheng\,\ Anhui",
  861309348 => "Xuancheng\,\ Anhui",
  861309349 => "Chizhou\,\ Anhui",
  861309350 => "MaAnshan\,\ Anhui",
  861309351 => "Huaibei\,\ Anhui",
  861309352 => "Huaibei\,\ Anhui",
  861309353 => "Huaibei\,\ Anhui",
  861309354 => "Hefei\,\ Anhui",
  861309355 => "Hefei\,\ Anhui",
  861309356 => "Suzhou\,\ Anhui",
  861309357 => "Suzhou\,\ Anhui",
  861309358 => "Suzhou\,\ Anhui",
  861309359 => "Suzhou\,\ Anhui",
  861309360 => "Xuancheng\,\ Anhui",
  861309361 => "Xuancheng\,\ Anhui",
  861309362 => "Wuhu\,\ Anhui",
  861309363 => "Wuhu\,\ Anhui",
  861309364 => "Wuhu\,\ Anhui",
  861309365 => "Bengbu\,\ Anhui",
  861309366 => "Bengbu\,\ Anhui",
  861309367 => "Bengbu\,\ Anhui",
  861309368 => "Chizhou\,\ Anhui",
  861309369 => "Chizhou\,\ Anhui",
  86130937 => "Hangzhou\,\ Zhejiang",
  86130938 => "Taizhou\,\ Zhejiang",
  861309390 => "Hanzhong\,\ Shaanxi",
  861309391 => "Hanzhong\,\ Shaanxi",
  861309392 => "Hanzhong\,\ Shaanxi",
  861309393 => "Hanzhong\,\ Shaanxi",
  861309394 => "Weinan\,\ Shaanxi",
  861309395 => "Weinan\,\ Shaanxi",
  861309396 => "Weinan\,\ Shaanxi",
  861309397 => "Weinan\,\ Shaanxi",
  861309398 => "Weinan\,\ Shaanxi",
  861309399 => "Weinan\,\ Shaanxi",
  861309400 => "Altay\,\ Xinjiang",
  861309401 => "Changji\,\ Xinjiang",
  861309402 => "Hami\,\ Xinjiang",
  861309403 => "Ili\,\ Xinjiang",
  861309404 => "Shihezi\,\ Xinjiang",
  861309405 => "Karamay\,\ Xinjiang",
  861309406 => "Ili\,\ Xinjiang",
  861309407 => "Bayingolin\,\ Xinjiang",
  861309408 => "Aksu\,\ Xinjiang",
  861309409 => "Hotan\,\ Xinjiang",
  861309410 => "Xiangfan\,\ Hubei",
  861309411 => "Xiangfan\,\ Hubei",
  861309412 => "Xiangfan\,\ Hubei",
  861309413 => "Xiangfan\,\ Hubei",
  861309414 => "Xiaogan\,\ Hubei",
  861309415 => "Xiaogan\,\ Hubei",
  861309416 => "Yichang\,\ Hubei",
  861309417 => "Yichang\,\ Hubei",
  861309418 => "Yichang\,\ Hubei",
  861309419 => "Xianning\,\ Hubei",
  861309420 => "Jingzhou\,\ Hubei",
  861309421 => "Jingzhou\,\ Hubei",
  861309422 => "Jingzhou\,\ Hubei",
  861309423 => "Jingzhou\,\ Hubei",
  861309424 => "Jingzhou\,\ Hubei",
  861309425 => "Wuhan\,\ Hubei",
  861309426 => "Wuhan\,\ Hubei",
  861309427 => "Shiyan\,\ Hubei",
  861309428 => "Shiyan\,\ Hubei",
  861309429 => "Wuhan\,\ Hubei",
  861309430 => "Yuxi\,\ Yunnan",
  861309431 => "Qujing\,\ Yunnan",
  861309432 => "Chuxiong\,\ Yunnan",
  861309433 => "Zhaotong\,\ Yunnan",
  861309434 => "Honghe\,\ Yunnan",
  861309435 => "Baoshan\,\ Yunnan",
  861309436 => "Baoshan\,\ Yunnan",
  861309437 => "Wenshan\,\ Yunnan",
  861309438 => "Wenshan\,\ Yunnan",
  861309439 => "Lincang\,\ Yunnan",
  86130944 => "Chengdu\,\ Sichuan",
  861309450 => "Dazhou\,\ Sichuan",
  861309451 => "Bazhong\,\ Sichuan",
  861309452 => "Bazhong\,\ Sichuan",
  861309453 => "Yibin\,\ Sichuan",
  861309454 => "Liangshan\,\ Sichuan",
  861309455 => "Panzhihua\,\ Sichuan",
  861309456 => "Panzhihua\,\ Sichuan",
  861309457 => "YaAn\,\ Sichuan",
  861309458 => "Yibin\,\ Sichuan",
  861309459 => "Yibin\,\ Sichuan",
  861309460 => "Shaoxing\,\ Zhejiang",
  861309461 => "Shaoxing\,\ Zhejiang",
  861309462 => "Shaoxing\,\ Zhejiang",
  861309463 => "Shaoxing\,\ Zhejiang",
  861309464 => "Jinhua\,\ Zhejiang",
  861309465 => "Jinhua\,\ Zhejiang",
  861309466 => "Jinhua\,\ Zhejiang",
  861309467 => "Jiaxing\,\ Zhejiang",
  861309468 => "Lishui\,\ Zhejiang",
  861309469 => "Lishui\,\ Zhejiang",
  861309470 => "Wenzhou\,\ Zhejiang",
  861309471 => "Wenzhou\,\ Zhejiang",
  861309472 => "Wenzhou\,\ Zhejiang",
  861309473 => "Wenzhou\,\ Zhejiang",
  861309474 => "Quzhou\,\ Zhejiang",
  861309475 => "Zhoushan\,\ Zhejiang",
  861309476 => "Taizhou\,\ Zhejiang",
  861309477 => "Taizhou\,\ Zhejiang",
  861309478 => "Taizhou\,\ Zhejiang",
  861309479 => "Taizhou\,\ Zhejiang",
  861309480 => "Hangzhou\,\ Zhejiang",
  861309481 => "Hangzhou\,\ Zhejiang",
  861309482 => "Ningbo\,\ Zhejiang",
  861309483 => "Ningbo\,\ Zhejiang",
  861309484 => "Huzhou\,\ Zhejiang",
  861309485 => "Huzhou\,\ Zhejiang",
  861309486 => "Huzhou\,\ Zhejiang",
  861309487 => "Jiaxing\,\ Zhejiang",
  861309488 => "Jiaxing\,\ Zhejiang",
  861309489 => "Jiaxing\,\ Zhejiang",
  861309490 => "HuaiAn\,\ Jiangsu",
  861309491 => "HuaiAn\,\ Jiangsu",
  861309492 => "HuaiAn\,\ Jiangsu",
  861309493 => "HuaiAn\,\ Jiangsu",
  861309494 => "HuaiAn\,\ Jiangsu",
  861309495 => "Zhenjiang\,\ Jiangsu",
  861309496 => "Zhenjiang\,\ Jiangsu",
  861309497 => "Zhenjiang\,\ Jiangsu",
  861309498 => "Zhenjiang\,\ Jiangsu",
  861309499 => "Zhenjiang\,\ Jiangsu",
  861309500 => "Urumchi\,\ Xinjiang",
  861309501 => "Urumchi\,\ Xinjiang",
  861309502 => "Urumchi\,\ Xinjiang",
  861309503 => "Urumchi\,\ Xinjiang",
  861309504 => "Turpan\,\ Xinjiang",
  861309505 => "Changji\,\ Xinjiang",
  861309506 => "Changji\,\ Xinjiang",
  861309507 => "Hami\,\ Xinjiang",
  861309508 => "Ili\,\ Xinjiang",
  861309509 => "Shihezi\,\ Xinjiang",
  861309510 => "Karamay\,\ Xinjiang",
  861309511 => "Ili\,\ Xinjiang",
  861309512 => "Ili\,\ Xinjiang",
  861309513 => "Bortala\,\ Xinjiang",
  861309514 => "Tacheng\,\ Xinjiang",
  861309515 => "Kashi\,\ Xinjiang",
  861309516 => "Bayingolin\,\ Xinjiang",
  861309517 => "Aksu\,\ Xinjiang",
  861309518 => "Urumchi\,\ Xinjiang",
  861309519 => "Kashi\,\ Xinjiang",
  861309520 => "Zhaotong\,\ Yunnan",
  861309521 => "Dehong\,\ Yunnan",
  861309522 => "Lincang\,\ Yunnan",
  861309523 => "Lijiang\,\ Yunnan",
  861309524 => "Xishuangbanna\,\ Yunnan",
  861309525 => "Dali\,\ Yunnan",
  861309526 => "Honghe\,\ Yunnan",
  861309527 => "Qujing\,\ Yunnan",
  861309528 => "Chuxiong\,\ Yunnan",
  861309529 => "Yuxi\,\ Yunnan",
  861309530 => "Kunming\,\ Yunnan",
  861309531 => "Kunming\,\ Yunnan",
  861309532 => "Kunming\,\ Yunnan",
  861309533 => "Kunming\,\ Yunnan",
  861309534 => "Kunming\,\ Yunnan",
  861309535 => "Kunming\,\ Yunnan",
  861309536 => "Kunming\,\ Yunnan",
  861309537 => "Puer\,\ Yunnan",
  861309538 => "Wenshan\,\ Yunnan",
  861309539 => "Baoshan\,\ Yunnan",
  861309540 => "Fuyang\,\ Anhui",
  861309541 => "Fuyang\,\ Anhui",
  861309542 => "Fuyang\,\ Anhui",
  861309543 => "Huangshan\,\ Anhui",
  861309544 => "Huangshan\,\ Anhui",
  861309545 => "Hefei\,\ Anhui",
  861309546 => "MaAnshan\,\ Anhui",
  861309547 => "Huainan\,\ Anhui",
  861309548 => "Tongling\,\ Anhui",
  861309549 => "Wuhu\,\ Anhui",
  861309550 => "Chuzhou\,\ Anhui",
  861309551 => "Hefei\,\ Anhui",
  861309552 => "Bengbu\,\ Anhui",
  861309553 => "Wuhu\,\ Anhui",
  861309554 => "Huainan\,\ Anhui",
  861309555 => "MaAnshan\,\ Anhui",
  861309556 => "Anqing\,\ Anhui",
  861309557 => "Suzhou\,\ Anhui",
  861309558 => "Fuyang\,\ Anhui",
  861309559 => "Huangshan\,\ Anhui",
  861309560 => "Jiaxing\,\ Zhejiang",
  861309561 => "Jiaxing\,\ Zhejiang",
  861309562 => "Jiaxing\,\ Zhejiang",
  861309563 => "Jiaxing\,\ Zhejiang",
  861309564 => "Jiaxing\,\ Zhejiang",
  861309565 => "Shaoxing\,\ Zhejiang",
  861309566 => "Shaoxing\,\ Zhejiang",
  861309567 => "Shaoxing\,\ Zhejiang",
  861309568 => "Shaoxing\,\ Zhejiang",
  861309569 => "Shaoxing\,\ Zhejiang",
  861309570 => "Quzhou\,\ Zhejiang",
  861309571 => "Hangzhou\,\ Zhejiang",
  861309572 => "Huzhou\,\ Zhejiang",
  861309573 => "Jiaxing\,\ Zhejiang",
  861309574 => "Ningbo\,\ Zhejiang",
  861309575 => "Shaoxing\,\ Zhejiang",
  861309576 => "Taizhou\,\ Zhejiang",
  861309577 => "Wenzhou\,\ Zhejiang",
  861309578 => "Lishui\,\ Zhejiang",
  861309579 => "Jinhua\,\ Zhejiang",
  861309580 => "Zhoushan\,\ Zhejiang",
  861309581 => "Zhoushan\,\ Zhejiang",
  861309582 => "Quzhou\,\ Zhejiang",
  861309583 => "Lishui\,\ Zhejiang",
  861309584 => "Huzhou\,\ Zhejiang",
  861309585 => "Huzhou\,\ Zhejiang",
  861309586 => "Huzhou\,\ Zhejiang",
  861309587 => "Jinhua\,\ Zhejiang",
  861309588 => "Jinhua\,\ Zhejiang",
  861309589 => "Jinhua\,\ Zhejiang",
  86130959 => "Ningbo\,\ Zhejiang",
  861309600 => "Zigong\,\ Sichuan",
  861309601 => "Zigong\,\ Sichuan",
  861309602 => "Meishan\,\ Sichuan",
  861309603 => "Panzhihua\,\ Sichuan",
  861309604 => "Mianyang\,\ Sichuan",
  861309605 => "Leshan\,\ Sichuan",
  861309606 => "Ziyang\,\ Sichuan",
  861309607 => "Meishan\,\ Sichuan",
  861309608 => "Neijiang\,\ Sichuan",
  861309609 => "Panzhihua\,\ Sichuan",
  861309610 => "Deyang\,\ Sichuan",
  861309611 => "Guangyuan\,\ Sichuan",
  861309612 => "Mianyang\,\ Sichuan",
  861309613 => "Nanchong\,\ Sichuan",
  861309614 => "Nanchong\,\ Sichuan",
  861309615 => "Ziyang\,\ Sichuan",
  861309616 => "Ziyang\,\ Sichuan",
  861309617 => "Mianyang\,\ Sichuan",
  861309618 => "Yibin\,\ Sichuan",
  861309619 => "Dazhou\,\ Sichuan",
  861309620 => "Yibin\,\ Sichuan",
  861309621 => "Yibin\,\ Sichuan",
  861309622 => "Yibin\,\ Sichuan",
  861309623 => "Mianyang\,\ Sichuan",
  861309624 => "Panzhihua\,\ Sichuan",
  861309625 => "Meishan\,\ Sichuan",
  861309626 => "Garze\,\ Sichuan",
  861309627 => "YaAn\,\ Sichuan",
  861309628 => "Deyang\,\ Sichuan",
  861309629 => "Deyang\,\ Sichuan",
  86130963 => "Chengdu\,\ Sichuan",
  861309640 => "Leshan\,\ Sichuan",
  861309641 => "Meishan\,\ Sichuan",
  861309642 => "Leshan\,\ Sichuan",
  861309643 => "Deyang\,\ Sichuan",
  861309644 => "Deyang\,\ Sichuan",
  861309645 => "Deyang\,\ Sichuan",
  861309646 => "Guangyuan\,\ Sichuan",
  861309647 => "Guangyuan\,\ Sichuan",
  861309648 => "Mianyang\,\ Sichuan",
  861309649 => "Mianyang\,\ Sichuan",
  861309650 => "Yangquan\,\ Shanxi",
  861309651 => "Yuncheng\,\ Shanxi",
  861309652 => "Linfen\,\ Shanxi",
  861309653 => "Jinzhong\,\ Shanxi",
  861309654 => "Datong\,\ Shanxi",
  861309655 => "Jincheng\,\ Shanxi",
  861309656 => "Changzhi\,\ Shanxi",
  861309657 => "Xinzhou\,\ Shanxi",
  861309658 => "Datong\,\ Shanxi",
  861309659 => "Datong\,\ Shanxi",
  861309660 => "Shuozhou\,\ Shanxi",
  861309661 => "Yuncheng\,\ Shanxi",
  861309662 => "Linfen\,\ Shanxi",
  861309663 => "Jinzhong\,\ Shanxi",
  861309664 => "Linfen\,\ Shanxi",
  861309665 => "Jincheng\,\ Shanxi",
  861309666 => "Changzhi\,\ Shanxi",
  861309667 => "Lüliang\,\ Shanxi",
  861309668 => "Datong\,\ Shanxi",
  861309669 => "Datong\,\ Shanxi",
  86130967 => "Zunyi\,\ Guizhou",
  861309680 => "Qianxinan\,\ Guizhou",
  861309681 => "Liupanshui\,\ Guizhou",
  861309682 => "Bijie\,\ Guizhou",
  861309683 => "Qiandongnan\,\ Guizhou",
  861309684 => "Qiannan\,\ Guizhou",
  861309685 => "Qiandongnan\,\ Guizhou",
  861309686 => "Tongren\,\ Guizhou",
  861309687 => "Bijie\,\ Guizhou",
  861309688 => "Liupanshui\,\ Guizhou",
  861309689 => "Qianxinan\,\ Guizhou",
  86130969 => "XiAn\,\ Shaanxi",
  861309700 => "Xinyu\,\ Jiangxi",
  861309701 => "Fuzhou\,\ Jiangxi",
  861309702 => "Jiujiang\,\ Jiangxi",
  861309703 => "Shangrao\,\ Jiangxi",
  861309704 => "Fuzhou\,\ Jiangxi",
  861309705 => "Yichun\,\ Jiangxi",
  861309706 => "JiAn\,\ Jiangxi",
  861309707 => "Ganzhou\,\ Jiangxi",
  861309708 => "Shangrao\,\ Jiangxi",
  861309709 => "Pingxiang\,\ Jiangxi",
  861309710 => "Jingdezhen\,\ Jiangxi",
  861309711 => "Fuzhou\,\ Jiangxi",
  861309712 => "Jingdezhen\,\ Jiangxi",
  861309713 => "Shangrao\,\ Jiangxi",
  861309714 => "JiAn\,\ Jiangxi",
  861309715 => "Yichun\,\ Jiangxi",
  861309716 => "Ganzhou\,\ Jiangxi",
  861309717 => "Ganzhou\,\ Jiangxi",
  861309718 => "Jingdezhen\,\ Jiangxi",
  861309719 => "Pingxiang\,\ Jiangxi",
  861309720 => "Nanchang\,\ Jiangxi",
  861309721 => "Nanchang\,\ Jiangxi",
  861309722 => "JiAn\,\ Jiangxi",
  861309723 => "Jingdezhen\,\ Jiangxi",
  861309724 => "Ganzhou\,\ Jiangxi",
  861309725 => "Jiujiang\,\ Jiangxi",
  861309726 => "Jiujiang\,\ Jiangxi",
  861309727 => "Jiujiang\,\ Jiangxi",
  861309728 => "Nanchang\,\ Jiangxi",
  861309729 => "Jiujiang\,\ Jiangxi",
  861309730 => "Ganzhou\,\ Jiangxi",
  861309731 => "Ganzhou\,\ Jiangxi",
  861309732 => "Ganzhou\,\ Jiangxi",
  861309733 => "Ganzhou\,\ Jiangxi",
  861309734 => "Ganzhou\,\ Jiangxi",
  861309735 => "Pingxiang\,\ Jiangxi",
  861309736 => "Shangrao\,\ Jiangxi",
  861309737 => "Shangrao\,\ Jiangxi",
  861309738 => "Shangrao\,\ Jiangxi",
  861309739 => "Shangrao\,\ Jiangxi",
  861309740 => "Yuxi\,\ Yunnan",
  861309741 => "Yuxi\,\ Yunnan",
  861309742 => "Honghe\,\ Yunnan",
  861309743 => "Honghe\,\ Yunnan",
  861309744 => "Lijiang\,\ Yunnan",
  861309745 => "Zhaotong\,\ Yunnan",
  861309746 => "Qujing\,\ Yunnan",
  861309747 => "Qujing\,\ Yunnan",
  861309748 => "Wenshan\,\ Yunnan",
  861309749 => "Dali\,\ Yunnan",
  861309750 => "Yangquan\,\ Shanxi",
  861309751 => "Yuncheng\,\ Shanxi",
  861309752 => "Linfen\,\ Shanxi",
  861309753 => "Jinzhong\,\ Shanxi",
  861309754 => "Datong\,\ Shanxi",
  861309755 => "Jincheng\,\ Shanxi",
  861309756 => "Changzhi\,\ Shanxi",
  861309757 => "Lüliang\,\ Shanxi",
  861309758 => "Lüliang\,\ Shanxi",
  861309759 => "Datong\,\ Shanxi",
  861309760 => "Yangquan\,\ Shanxi",
  861309761 => "Yuncheng\,\ Shanxi",
  861309762 => "Linfen\,\ Shanxi",
  861309763 => "Jinzhong\,\ Shanxi",
  861309764 => "Shuozhou\,\ Shanxi",
  861309765 => "Jincheng\,\ Shanxi",
  861309766 => "Changzhi\,\ Shanxi",
  861309767 => "Xinzhou\,\ Shanxi",
  861309768 => "Shuozhou\,\ Shanxi",
  861309769 => "Datong\,\ Shanxi",
  861309770 => "Fangchenggang\,\ Guangxi",
  861309771 => "Nanning\,\ Guangxi",
  861309772 => "Liuzhou\,\ Guangxi",
  861309773 => "Guilin\,\ Guangxi",
  861309774 => "Wuzhou\,\ Guangxi",
  861309775 => "Yulin\,\ Guangxi",
  861309776 => "Baise\,\ Guangxi",
  861309777 => "Qinzhou\,\ Guangxi",
  861309778 => "Hechi\,\ Guangxi",
  861309779 => "Beihai\,\ Guangxi",
  861309780 => "Fangchenggang\,\ Guangxi",
  861309781 => "Beihai\,\ Guangxi",
  861309782 => "Guigang\,\ Guangxi",
  861309783 => "Hezhou\,\ Guangxi",
  861309784 => "Wuzhou\,\ Guangxi",
  861309785 => "Yulin\,\ Guangxi",
  861309786 => "Baise\,\ Guangxi",
  861309787 => "Qinzhou\,\ Guangxi",
  861309788 => "Wuzhou\,\ Guangxi",
  861309789 => "Beihai\,\ Guangxi",
  861309790 => "Fangchenggang\,\ Guangxi",
  861309791 => "Beihai\,\ Guangxi",
  861309792 => "Guigang\,\ Guangxi",
  861309793 => "Guilin\,\ Guangxi",
  861309794 => "Wuzhou\,\ Guangxi",
  861309795 => "Yulin\,\ Guangxi",
  861309796 => "Baise\,\ Guangxi",
  861309797 => "Qinzhou\,\ Guangxi",
  861309798 => "Hechi\,\ Guangxi",
  861309799 => "Beihai\,\ Guangxi",
  861309800 => "Ankang\,\ Shaanxi",
  861309801 => "Ankang\,\ Shaanxi",
  861309802 => "Ankang\,\ Shaanxi",
  861309803 => "Ankang\,\ Shaanxi",
  861309804 => "YanAn\,\ Shaanxi",
  861309805 => "YanAn\,\ Shaanxi",
  861309806 => "YanAn\,\ Shaanxi",
  861309807 => "YanAn\,\ Shaanxi",
  861309808 => "YanAn\,\ Shaanxi",
  861309809 => "YanAn\,\ Shaanxi",
  861309810 => "Xianyang\,\ Shaanxi",
  861309811 => "Xianyang\,\ Shaanxi",
  861309812 => "Weinan\,\ Shaanxi",
  861309813 => "Weinan\,\ Shaanxi",
  861309814 => "Weinan\,\ Shaanxi",
  861309815 => "Baoji\,\ Shaanxi",
  861309816 => "Baoji\,\ Shaanxi",
  861309817 => "Tongchuan\,\ Shaanxi",
  861309818 => "Tongchuan\,\ Shaanxi",
  861309819 => "Tongchuan\,\ Shaanxi",
  861309820 => "Hanzhong\,\ Shaanxi",
  861309821 => "Hanzhong\,\ Shaanxi",
  861309822 => "Shangluo\,\ Shaanxi",
  861309823 => "Shangluo\,\ Shaanxi",
  861309824 => "Yulin\,\ Shaanxi",
  861309825 => "Yulin\,\ Shaanxi",
  861309826 => "Yulin\,\ Shaanxi",
  861309827 => "Yulin\,\ Shaanxi",
  861309828 => "Yulin\,\ Shaanxi",
  861309829 => "Yulin\,\ Shaanxi",
  861309830 => "Jingzhou\,\ Hubei",
  861309831 => "Jingzhou\,\ Hubei",
  861309832 => "Wuhan\,\ Hubei",
  861309833 => "Wuhan\,\ Hubei",
  861309834 => "Wuhan\,\ Hubei",
  861309835 => "Xianning\,\ Hubei",
  861309836 => "Huanggang\,\ Hubei",
  861309837 => "Huanggang\,\ Hubei",
  861309838 => "Ezhou\,\ Hubei",
  861309839 => "Huangshi\,\ Hubei",
  861309840 => "Yichang\,\ Hubei",
  861309841 => "Yichang\,\ Hubei",
  861309842 => "Jingmen\,\ Hubei",
  861309843 => "Jingmen\,\ Hubei",
  861309844 => "Suizhou\,\ Hubei",
  861309845 => "Xiangfan\,\ Hubei",
  861309846 => "Xiangfan\,\ Hubei",
  861309847 => "Enshi\,\ Hubei",
  861309848 => "Xiaogan\,\ Hubei",
  861309849 => "Shiyan\,\ Hubei",
  861309850 => "Guiyang\,\ Guizhou",
  861309851 => "Guiyang\,\ Guizhou",
  861309852 => "Zunyi\,\ Guizhou",
  861309853 => "Anshun\,\ Guizhou",
  861309854 => "Qiannan\,\ Guizhou",
  861309855 => "Qiandongnan\,\ Guizhou",
  861309856 => "Tongren\,\ Guizhou",
  861309857 => "Bijie\,\ Guizhou",
  861309858 => "Liupanshui\,\ Guizhou",
  861309859 => "Qianxinan\,\ Guizhou",
  86130986 => "Chongqing",
  86130987 => "Chongqing",
  86130988 => "Wuhan\,\ Hubei",
  86130989 => "Haikou\,\ Hainan",
  861309900 => "Taiyuan\,\ Shanxi",
  861309901 => "Yuncheng\,\ Shanxi",
  861309902 => "Linfen\,\ Shanxi",
  861309903 => "Xinzhou\,\ Shanxi",
  861309904 => "Taiyuan\,\ Shanxi",
  861309905 => "Taiyuan\,\ Shanxi",
  861309906 => "Taiyuan\,\ Shanxi",
  861309907 => "Taiyuan\,\ Shanxi",
  861309908 => "Taiyuan\,\ Shanxi",
  861309909 => "Taiyuan\,\ Shanxi",
  86130991 => "Lanzhou\,\ Gansu",
  861309920 => "Lanzhou\,\ Gansu",
  861309921 => "Lanzhou\,\ Gansu",
  861309922 => "Lanzhou\,\ Gansu",
  861309923 => "Lanzhou\,\ Gansu",
  861309924 => "Lanzhou\,\ Gansu",
  861309925 => "Lanzhou\,\ Gansu",
  861309926 => "Lanzhou\,\ Gansu",
  861309927 => "Baiyin\,\ Gansu",
  861309928 => "Baiyin\,\ Gansu",
  861309929 => "Linxia\,\ Gansu",
  861309930 => "Gannan\,\ Gansu",
  861309931 => "Gannan\,\ Gansu",
  861309932 => "Longnan\,\ Gansu",
  861309933 => "Pingliang\,\ Gansu",
  861309934 => "Longnan\,\ Gansu",
  861309935 => "Qingyang\,\ Gansu",
  861309936 => "Qingyang\,\ Gansu",
  861309937 => "Jiayuguan\,\ Gansu",
  861309938 => "Zhangye\,\ Gansu",
  861309939 => "Jiayuguan\,\ Gansu",
  861309940 => "Kunming\,\ Yunnan",
  861309941 => "Kunming\,\ Yunnan",
  861309942 => "Kunming\,\ Yunnan",
  861309943 => "Kunming\,\ Yunnan",
  861309944 => "Kunming\,\ Yunnan",
  861309945 => "Kunming\,\ Yunnan",
  861309946 => "Kunming\,\ Yunnan",
  861309947 => "Dehong\,\ Yunnan",
  861309948 => "Dehong\,\ Yunnan",
  861309949 => "Dehong\,\ Yunnan",
  861309950 => "Yinchuan\,\ Ningxia",
  861309951 => "Yinchuan\,\ Ningxia",
  861309952 => "Shizuishan\,\ Ningxia",
  861309953 => "Wuzhong\,\ Ningxia",
  861309954 => "Guyuan\,\ Ningxia",
  861309955 => "Wuzhong\,\ Ningxia",
  861309956 => "Shizuishan\,\ Ningxia",
  861309957 => "Yinchuan\,\ Ningxia",
  861309958 => "Yinchuan\,\ Ningxia",
  861309959 => "Yinchuan\,\ Ningxia",
  861309960 => "Lincang\,\ Yunnan",
  861309961 => "Lincang\,\ Yunnan",
  861309962 => "Xishuangbanna\,\ Yunnan",
  861309963 => "Xishuangbanna\,\ Yunnan",
  861309964 => "Zhaotong\,\ Yunnan",
  861309965 => "Puer\,\ Yunnan",
  861309966 => "Puer\,\ Yunnan",
  861309967 => "Baoshan\,\ Yunnan",
  861309968 => "Baoshan\,\ Yunnan",
  861309969 => "Wenshan\,\ Yunnan",
  861309970 => "Yushu\,\ Qinghai",
  861309971 => "Golog\,\ Qinghai",
  861309972 => "Haidong\,\ Qinghai",
  861309973 => "Huangnan\,\ Qinghai",
  861309974 => "Xining\,\ Qinghai",
  861309975 => "Xining\,\ Qinghai",
  861309976 => "Xining\,\ Qinghai",
  861309977 => "Xining\,\ Qinghai",
  861309978 => "Xining\,\ Qinghai",
  861309979 => "Xining\,\ Qinghai",
  861309980 => "Honghe\,\ Yunnan",
  861309981 => "Honghe\,\ Yunnan",
  861309982 => "Chuxiong\,\ Yunnan",
  861309983 => "Chuxiong\,\ Yunnan",
  861309984 => "Dali\,\ Yunnan",
  861309985 => "Dali\,\ Yunnan",
  861309986 => "Qujing\,\ Yunnan",
  861309987 => "Qujing\,\ Yunnan",
  861309988 => "Yuxi\,\ Yunnan",
  861309989 => "Yuxi\,\ Yunnan",
  86130999 => "Kunming\,\ Yunnan",
  861310000 => "Taiyuan\,\ Shanxi",
  861310001 => "Taiyuan\,\ Shanxi",
  861310002 => "Datong\,\ Shanxi",
  861310003 => "Yangquan\,\ Shanxi",
  861310004 => "Shuozhou\,\ Shanxi",
  861310005 => "Changzhi\,\ Shanxi",
  861310006 => "Jincheng\,\ Shanxi",
  861310007 => "Linfen\,\ Shanxi",
  861310008 => "Lüliang\,\ Shanxi",
  861310009 => "Yuncheng\,\ Shanxi",
  861310010 => "Xinzhou\,\ Shanxi",
  861310011 => "Taiyuan\,\ Shanxi",
  861310012 => "Datong\,\ Shanxi",
  861310013 => "Jinzhong\,\ Shanxi",
  861310014 => "Taiyuan\,\ Shanxi",
  861310015 => "Changzhi\,\ Shanxi",
  861310016 => "Jincheng\,\ Shanxi",
  861310017 => "Linfen\,\ Shanxi",
  861310018 => "Jinzhong\,\ Shanxi",
  861310019 => "Yuncheng\,\ Shanxi",
  861310020 => "Yueyang\,\ Hunan",
  861310021 => "Huaihua\,\ Hunan",
  861310022 => "Yongzhou\,\ Hunan",
  861310023 => "Zhuzhou\,\ Hunan",
  861310024 => "Zhangjiajie\,\ Hunan",
  861310025 => "Changsha\,\ Hunan",
  861310026 => "Hengyang\,\ Hunan",
  861310027 => "Xiangxi\,\ Hunan",
  861310028 => "Changde\,\ Hunan",
  861310029 => "Changde\,\ Hunan",
  861310030 => "Yueyang\,\ Hunan",
  861310031 => "Changsha\,\ Hunan",
  861310032 => "Xiangtan\,\ Hunan",
  861310033 => "Zhuzhou\,\ Hunan",
  861310034 => "Hengyang\,\ Hunan",
  861310035 => "Chenzhou\,\ Hunan",
  861310036 => "Loudi\,\ Hunan",
  861310037 => "Yiyang\,\ Hunan",
  861310038 => "Chenzhou\,\ Hunan",
  861310039 => "Shaoyang\,\ Hunan",
  861310040 => "Nanning\,\ Guangxi",
  861310041 => "Nanning\,\ Guangxi",
  861310042 => "Liuzhou\,\ Guangxi",
  861310043 => "Guilin\,\ Guangxi",
  861310044 => "Hezhou\,\ Guangxi",
  861310045 => "Yulin\,\ Guangxi",
  861310046 => "Baise\,\ Guangxi",
  861310047 => "Guigang\,\ Guangxi",
  861310048 => "Hechi\,\ Guangxi",
  861310049 => "Liuzhou\,\ Guangxi",
  861310050 => "Nanning\,\ Guangxi",
  861310051 => "Nanning\,\ Guangxi",
  861310052 => "Liuzhou\,\ Guangxi",
  861310053 => "Guilin\,\ Guangxi",
  861310054 => "Hezhou\,\ Guangxi",
  861310055 => "Yulin\,\ Guangxi",
  861310056 => "Baise\,\ Guangxi",
  861310057 => "Guigang\,\ Guangxi",
  861310058 => "Hechi\,\ Guangxi",
  861310059 => "Guilin\,\ Guangxi",
  86131006 => "Wuhan\,\ Hubei",
  861310070 => "Wuhan\,\ Hubei",
  861310071 => "Wuhan\,\ Hubei",
  861310072 => "Wuhan\,\ Hubei",
  861310073 => "Wuhan\,\ Hubei",
  861310074 => "Huanggang\,\ Hubei",
  861310075 => "Suizhou\,\ Hubei",
  861310076 => "Enshi\,\ Hubei",
  861310077 => "Xiangfan\,\ Hubei",
  861310078 => "Yichang\,\ Hubei",
  861310079 => "Jingzhou\,\ Hubei",
  861310080 => "Harbin\,\ Heilongjiang",
  861310081 => "Harbin\,\ Heilongjiang",
  861310082 => "Qiqihar\,\ Heilongjiang",
  861310083 => "Harbin\,\ Heilongjiang",
  861310084 => "Harbin\,\ Heilongjiang",
  861310085 => "Harbin\,\ Heilongjiang",
  861310086 => "Heihe\,\ Heilongjiang",
  861310087 => "Harbin\,\ Heilongjiang",
  861310088 => "Harbin\,\ Heilongjiang",
  861310089 => "Daqing\,\ Heilongjiang",
  861310090 => "Harbin\,\ Heilongjiang",
  861310091 => "Harbin\,\ Heilongjiang",
  861310092 => "Qiqihar\,\ Heilongjiang",
  861310093 => "Harbin\,\ Heilongjiang",
  861310094 => "Heihe\,\ Heilongjiang",
  861310095 => "Harbin\,\ Heilongjiang",
  861310096 => "Harbin\,\ Heilongjiang",
  861310097 => "Harbin\,\ Heilongjiang",
  861310098 => "Qiqihar\,\ Heilongjiang",
  861310099 => "Qiqihar\,\ Heilongjiang",
  86131010 => "Chongqing",
  86131011 => "Chongqing",
  86131012 => "Chongqing",
  86131013 => "Chongqing",
  861310140 => "Fuzhou\,\ Fujian",
  861310141 => "Fuzhou\,\ Fujian",
  861310142 => "Fuzhou\,\ Fujian",
  861310143 => "Xiamen\,\ Fujian",
  861310144 => "Quanzhou\,\ Fujian",
  861310145 => "Quanzhou\,\ Fujian",
  861310146 => "Quanzhou\,\ Fujian",
  861310147 => "Ningde\,\ Fujian",
  861310148 => "Ningde\,\ Fujian",
  861310149 => "Sanming\,\ Fujian",
  861310150 => "Harbin\,\ Heilongjiang",
  861310151 => "Harbin\,\ Heilongjiang",
  861310152 => "Qiqihar\,\ Heilongjiang",
  861310153 => "Mudanjiang\,\ Heilongjiang",
  861310154 => "Heihe\,\ Heilongjiang",
  861310155 => "Suihua\,\ Heilongjiang",
  861310156 => "Harbin\,\ Heilongjiang",
  861310157 => "Jixi\,\ Heilongjiang",
  861310158 => "Harbin\,\ Heilongjiang",
  861310159 => "Daqing\,\ Heilongjiang",
  861310160 => "Harbin\,\ Heilongjiang",
  861310161 => "Harbin\,\ Heilongjiang",
  861310162 => "Qiqihar\,\ Heilongjiang",
  861310163 => "Mudanjiang\,\ Heilongjiang",
  861310164 => "Daqing\,\ Heilongjiang",
  861310165 => "Jiamusi\,\ Heilongjiang",
  861310166 => "Harbin\,\ Heilongjiang",
  861310167 => "Jixi\,\ Heilongjiang",
  861310168 => "Hegang\,\ Heilongjiang",
  861310169 => "Shuangyashan\,\ Heilongjiang",
  861310170 => "Shangqiu\,\ Henan",
  861310171 => "Zhengzhou\,\ Henan",
  861310172 => "Anyang\,\ Henan",
  861310173 => "Xinxiang\,\ Henan",
  861310174 => "Nanyang\,\ Henan",
  861310175 => "Pingdingshan\,\ Henan",
  861310176 => "Xinyang\,\ Henan",
  861310177 => "Nanyang\,\ Henan",
  861310178 => "Kaifeng\,\ Henan",
  861310179 => "Luoyang\,\ Henan",
  861310180 => "Taizhou\,\ Jiangsu",
  861310181 => "Taizhou\,\ Jiangsu",
  861310182 => "Xuzhou\,\ Jiangsu",
  861310183 => "Xuzhou\,\ Jiangsu",
  861310184 => "Nanjing\,\ Jiangsu",
  861310185 => "Yangzhou\,\ Jiangsu",
  861310186 => "Suqian\,\ Jiangsu",
  861310187 => "Suqian\,\ Jiangsu",
  861310188 => "Nanjing\,\ Jiangsu",
  861310189 => "Nanjing\,\ Jiangsu",
  861310190 => "HuaiAn\,\ Jiangsu",
  861310191 => "HuaiAn\,\ Jiangsu",
  861310192 => "Zhenjiang\,\ Jiangsu",
  861310193 => "Zhenjiang\,\ Jiangsu",
  861310194 => "Nantong\,\ Jiangsu",
  861310195 => "Yangzhou\,\ Jiangsu",
  861310196 => "Wuxi\,\ Jiangsu",
  861310197 => "Wuxi\,\ Jiangsu",
  861310198 => "Nantong\,\ Jiangsu",
  861310199 => "Nantong\,\ Jiangsu",
  86131020 => "Tianjin",
  86131021 => "Tianjin",
  86131022 => "Tianjin",
  86131023 => "Chongqing",
  861310240 => "Cangzhou\,\ Hebei",
  861310241 => "Cangzhou\,\ Hebei",
  861310242 => "Cangzhou\,\ Hebei",
  861310243 => "Cangzhou\,\ Hebei",
  861310244 => "Cangzhou\,\ Hebei",
  861310245 => "Langfang\,\ Hebei",
  861310246 => "Langfang\,\ Hebei",
  861310247 => "Langfang\,\ Hebei",
  861310248 => "Langfang\,\ Hebei",
  861310249 => "Langfang\,\ Hebei",
  861310250 => "Qinhuangdao\,\ Hebei",
  861310251 => "Qinhuangdao\,\ Hebei",
  861310252 => "Qinhuangdao\,\ Hebei",
  861310253 => "Qinhuangdao\,\ Hebei",
  861310254 => "Qinhuangdao\,\ Hebei",
  861310255 => "Xingtai\,\ Hebei",
  861310256 => "Xingtai\,\ Hebei",
  861310257 => "Xingtai\,\ Hebei",
  861310258 => "Xingtai\,\ Hebei",
  861310259 => "Xingtai\,\ Hebei",
  86131026 => "Tangshan\,\ Hebei",
  861310270 => "Cangzhou\,\ Hebei",
  861310271 => "Cangzhou\,\ Hebei",
  861310272 => "Cangzhou\,\ Hebei",
  861310273 => "Cangzhou\,\ Hebei",
  861310274 => "Cangzhou\,\ Hebei",
  861310275 => "Hengshui\,\ Hebei",
  861310276 => "Hengshui\,\ Hebei",
  861310277 => "Hengshui\,\ Hebei",
  861310278 => "Hengshui\,\ Hebei",
  861310279 => "Hengshui\,\ Hebei",
  86131028 => "Shijiazhuang\,\ Hebei",
  86131029 => "Baoding\,\ Hebei",
  861310300 => "Handan\,\ Hebei",
  861310301 => "Shijiazhuang\,\ Hebei",
  861310302 => "Baoding\,\ Hebei",
  861310303 => "Zhangjiakou\,\ Hebei",
  861310304 => "Chengde\,\ Hebei",
  861310305 => "Tangshan\,\ Hebei",
  861310306 => "Langfang\,\ Hebei",
  861310307 => "Cangzhou\,\ Hebei",
  861310308 => "Hengshui\,\ Hebei",
  861310309 => "Xingtai\,\ Hebei",
  861310310 => "Handan\,\ Hebei",
  861310311 => "Shijiazhuang\,\ Hebei",
  861310312 => "Baoding\,\ Hebei",
  861310313 => "Zhangjiakou\,\ Hebei",
  861310314 => "Chengde\,\ Hebei",
  861310315 => "Tangshan\,\ Hebei",
  861310316 => "Langfang\,\ Hebei",
  861310317 => "Cangzhou\,\ Hebei",
  861310318 => "Hengshui\,\ Hebei",
  861310319 => "Xingtai\,\ Hebei",
  861310320 => "Handan\,\ Hebei",
  861310321 => "Shijiazhuang\,\ Hebei",
  861310322 => "Baoding\,\ Hebei",
  861310323 => "Zhangjiakou\,\ Hebei",
  861310324 => "Chengde\,\ Hebei",
  861310325 => "Tangshan\,\ Hebei",
  861310326 => "Langfang\,\ Hebei",
  861310327 => "Cangzhou\,\ Hebei",
  861310328 => "Hengshui\,\ Hebei",
  861310329 => "Xingtai\,\ Hebei",
  861310330 => "Handan\,\ Hebei",
  861310331 => "Shijiazhuang\,\ Hebei",
  861310332 => "Baoding\,\ Hebei",
  861310333 => "Zhangjiakou\,\ Hebei",
  861310334 => "Chengde\,\ Hebei",
  861310335 => "Qinhuangdao\,\ Hebei",
  861310336 => "Langfang\,\ Hebei",
  861310337 => "Cangzhou\,\ Hebei",
  861310338 => "Hengshui\,\ Hebei",
  861310339 => "Xingtai\,\ Hebei",
  861310340 => "Datong\,\ Shanxi",
  861310341 => "Taiyuan\,\ Shanxi",
  861310342 => "Datong\,\ Shanxi",
  861310343 => "Taiyuan\,\ Shanxi",
  861310344 => "Taiyuan\,\ Shanxi",
  861310345 => "Changzhi\,\ Shanxi",
  861310346 => "Jincheng\,\ Shanxi",
  861310347 => "Linfen\,\ Shanxi",
  861310348 => "Yuncheng\,\ Shanxi",
  861310349 => "Shuozhou\,\ Shanxi",
  861310350 => "Xinzhou\,\ Shanxi",
  861310351 => "Taiyuan\,\ Shanxi",
  861310352 => "Datong\,\ Shanxi",
  861310353 => "Yangquan\,\ Shanxi",
  861310354 => "Jinzhong\,\ Shanxi",
  861310355 => "Changzhi\,\ Shanxi",
  861310356 => "Jincheng\,\ Shanxi",
  861310357 => "Linfen\,\ Shanxi",
  861310358 => "Lüliang\,\ Shanxi",
  861310359 => "Yuncheng\,\ Shanxi",
  861310360 => "Shangqiu\,\ Henan",
  861310361 => "Jiaozuo\,\ Henan",
  861310362 => "Anyang\,\ Henan",
  861310363 => "Puyang\,\ Henan",
  861310364 => "Puyang\,\ Henan",
  861310365 => "Pingdingshan\,\ Henan",
  861310366 => "Zhumadian\,\ Henan",
  861310367 => "Nanyang\,\ Henan",
  861310368 => "Nanyang\,\ Henan",
  861310369 => "Luohe\,\ Henan",
  861310370 => "Shangqiu\,\ Henan",
  861310371 => "Zhengzhou\,\ Henan",
  861310372 => "Anyang\,\ Henan",
  861310373 => "Xinxiang\,\ Henan",
  861310374 => "Xuchang\,\ Henan",
  861310375 => "Pingdingshan\,\ Henan",
  861310376 => "Xinyang\,\ Henan",
  861310377 => "Nanyang\,\ Henan",
  861310378 => "Kaifeng\,\ Henan",
  861310379 => "Luoyang\,\ Henan",
  861310380 => "Xinxiang\,\ Henan",
  861310381 => "Zhengzhou\,\ Henan",
  861310382 => "Zhengzhou\,\ Henan",
  861310383 => "Zhengzhou\,\ Henan",
  861310384 => "Zhengzhou\,\ Henan",
  861310385 => "Zhengzhou\,\ Henan",
  861310386 => "Zhengzhou\,\ Henan",
  861310387 => "Zhoukou\,\ Henan",
  861310388 => "Xuchang\,\ Henan",
  861310389 => "Jiaozuo\,\ Henan",
  861310390 => "Shangqiu\,\ Henan",
  861310391 => "Jiaozuo\,\ Henan",
  861310392 => "Hebi\,\ Henan",
  861310393 => "Puyang\,\ Henan",
  861310394 => "Zhoukou\,\ Henan",
  861310395 => "Luohe\,\ Henan",
  861310396 => "Zhumadian\,\ Henan",
  861310397 => "Xinyang\,\ Henan",
  861310398 => "Sanmenxia\,\ Henan",
  861310399 => "Jiaozuo\,\ Henan",
  861310400 => "Harbin\,\ Heilongjiang",
  861310401 => "Harbin\,\ Heilongjiang",
  861310402 => "Qiqihar\,\ Heilongjiang",
  861310403 => "Qiqihar\,\ Heilongjiang",
  861310404 => "Qiqihar\,\ Heilongjiang",
  861310405 => "Harbin\,\ Heilongjiang",
  861310406 => "Shuangyashan\,\ Heilongjiang",
  861310407 => "Harbin\,\ Heilongjiang",
  861310408 => "Harbin\,\ Heilongjiang",
  861310409 => "Daqing\,\ Heilongjiang",
  861310410 => "Tieling\,\ Liaoning",
  861310411 => "Dalian\,\ Liaoning",
  861310412 => "Anshan\,\ Liaoning",
  861310413 => "Fushun\,\ Liaoning",
  861310414 => "Benxi\,\ Liaoning",
  861310415 => "Dandong\,\ Liaoning",
  861310416 => "Jinzhou\,\ Liaoning",
  861310417 => "Yingkou\,\ Liaoning",
  861310418 => "Fuxin\,\ Liaoning",
  861310419 => "Liaoyang\,\ Liaoning",
  861310420 => "Yingkou\,\ Liaoning",
  861310421 => "Chaoyang\,\ Liaoning",
  861310422 => "Anshan\,\ Liaoning",
  861310423 => "Fushun\,\ Liaoning",
  861310424 => "Benxi\,\ Liaoning",
  861310425 => "Dandong\,\ Liaoning",
  861310426 => "Jinzhou\,\ Liaoning",
  861310427 => "Panjin\,\ Liaoning",
  861310428 => "Fuxin\,\ Liaoning",
  861310429 => "Huludao\,\ Liaoning",
  861310430 => "Changchun\,\ Jilin",
  861310431 => "Changchun\,\ Jilin",
  861310432 => "Jilin\,\ Jilin",
  861310433 => "Yanbian\,\ Jilin",
  861310434 => "Siping\,\ Jilin",
  861310435 => "Tonghua\,\ Jilin",
  861310436 => "Baicheng\,\ Jilin",
  861310437 => "Liaoyuan\,\ Jilin",
  861310438 => "Songyuan\,\ Jilin",
  861310439 => "Baishan\,\ Jilin",
  86131044 => "Changchun\,\ Jilin",
  861310450 => "Harbin\,\ Heilongjiang",
  861310451 => "Harbin\,\ Heilongjiang",
  861310452 => "Qiqihar\,\ Heilongjiang",
  861310453 => "Mudanjiang\,\ Heilongjiang",
  861310454 => "Jiamusi\,\ Heilongjiang",
  861310455 => "Suihua\,\ Heilongjiang",
  861310456 => "Heihe\,\ Heilongjiang",
  861310457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861310458 => "Yichun\,\ Heilongjiang",
  861310459 => "Daqing\,\ Heilongjiang",
  861310460 => "Harbin\,\ Heilongjiang",
  861310461 => "Harbin\,\ Heilongjiang",
  861310462 => "Harbin\,\ Heilongjiang",
  861310463 => "Harbin\,\ Heilongjiang",
  861310464 => "Qitaihe\,\ Heilongjiang",
  861310465 => "Harbin\,\ Heilongjiang",
  861310466 => "Harbin\,\ Heilongjiang",
  861310467 => "Jixi\,\ Heilongjiang",
  861310468 => "Hegang\,\ Heilongjiang",
  861310469 => "Shuangyashan\,\ Heilongjiang",
  861310470 => "Zhuhai\,\ Guangdong",
  861310471 => "Zhuhai\,\ Guangdong",
  861310472 => "Zhuhai\,\ Guangdong",
  861310473 => "Zhuhai\,\ Guangdong",
  861310474 => "Zhuhai\,\ Guangdong",
  861310475 => "Dongguan\,\ Guangdong",
  861310476 => "Dongguan\,\ Guangdong",
  861310477 => "Dongguan\,\ Guangdong",
  861310478 => "Dongguan\,\ Guangdong",
  861310479 => "Dongguan\,\ Guangdong",
  861310480 => "Yunfu\,\ Guangdong",
  861310481 => "Yunfu\,\ Guangdong",
  861310482 => "Shantou\,\ Guangdong",
  861310483 => "Shantou\,\ Guangdong",
  861310484 => "Xingtai\,\ Hebei",
  861310485 => "Guangzhou\,\ Guangdong",
  861310486 => "Guangzhou\,\ Guangdong",
  861310487 => "Guangzhou\,\ Guangdong",
  861310488 => "Guangzhou\,\ Guangdong",
  861310489 => "Guangzhou\,\ Guangdong",
  861310490 => "Zhanjiang\,\ Guangdong",
  861310491 => "Zhanjiang\,\ Guangdong",
  861310492 => "Zhanjiang\,\ Guangdong",
  861310493 => "Zhanjiang\,\ Guangdong",
  861310494 => "Jiangmen\,\ Guangdong",
  861310495 => "Jiangmen\,\ Guangdong",
  861310496 => "Zhaoqing\,\ Guangdong",
  861310497 => "Zhaoqing\,\ Guangdong",
  861310498 => "Maoming\,\ Guangdong",
  861310499 => "Maoming\,\ Guangdong",
  861310500 => "Zhangzhou\,\ Fujian",
  861310501 => "Zhangzhou\,\ Fujian",
  861310502 => "Zhangzhou\,\ Fujian",
  861310503 => "Zhangzhou\,\ Fujian",
  861310504 => "Zhangzhou\,\ Fujian",
  861310505 => "Zhangzhou\,\ Fujian",
  861310506 => "Quanzhou\,\ Fujian",
  861310507 => "Quanzhou\,\ Fujian",
  861310508 => "Quanzhou\,\ Fujian",
  861310509 => "Quanzhou\,\ Fujian",
  861310510 => "Rizhao\,\ Shandong",
  861310511 => "Zaozhuang\,\ Shandong",
  861310512 => "Qingdao\,\ Shandong",
  861310513 => "Qingdao\,\ Shandong",
  861310514 => "Qingdao\,\ Shandong",
  861310515 => "Qingdao\,\ Shandong",
  861310516 => "Qingdao\,\ Shandong",
  861310517 => "Qingdao\,\ Shandong",
  861310518 => "Qingdao\,\ Shandong",
  861310519 => "Qingdao\,\ Shandong",
  86131052 => "Yantai\,\ Shandong",
  861310530 => "Heze\,\ Shandong",
  861310531 => "Jinan\,\ Shandong",
  861310532 => "Qingdao\,\ Shandong",
  861310533 => "Zibo\,\ Shandong",
  861310534 => "Dezhou\,\ Shandong",
  861310535 => "Yantai\,\ Shandong",
  861310536 => "Weifang\,\ Shandong",
  861310537 => "Jining\,\ Shandong",
  861310538 => "TaiAn\,\ Shandong",
  861310539 => "Linyi\,\ Shandong",
  861310540 => "Heze\,\ Shandong",
  861310541 => "Jinan\,\ Shandong",
  861310542 => "Qingdao\,\ Shandong",
  861310543 => "Binzhou\,\ Shandong",
  861310544 => "Dezhou\,\ Shandong",
  861310545 => "Yantai\,\ Shandong",
  861310546 => "Dongying\,\ Shandong",
  861310547 => "Jining\,\ Shandong",
  861310548 => "TaiAn\,\ Shandong",
  861310549 => "Linyi\,\ Shandong",
  861310550 => "Jiaxing\,\ Zhejiang",
  861310551 => "Jiaxing\,\ Zhejiang",
  861310552 => "Ningbo\,\ Zhejiang",
  861310553 => "Ningbo\,\ Zhejiang",
  861310554 => "Ningbo\,\ Zhejiang",
  861310555 => "Ningbo\,\ Zhejiang",
  861310556 => "Ningbo\,\ Zhejiang",
  861310557 => "Ningbo\,\ Zhejiang",
  861310558 => "Ningbo\,\ Zhejiang",
  861310559 => "Jinhua\,\ Zhejiang",
  86131056 => "Taizhou\,\ Zhejiang",
  861310570 => "Quzhou\,\ Zhejiang",
  861310571 => "Hangzhou\,\ Zhejiang",
  861310572 => "Huzhou\,\ Zhejiang",
  861310573 => "Jiaxing\,\ Zhejiang",
  861310574 => "Ningbo\,\ Zhejiang",
  861310575 => "Shaoxing\,\ Zhejiang",
  861310576 => "Taizhou\,\ Zhejiang",
  861310577 => "Wenzhou\,\ Zhejiang",
  861310578 => "Lishui\,\ Zhejiang",
  861310579 => "Jinhua\,\ Zhejiang",
  861310580 => "Zhoushan\,\ Zhejiang",
  861310581 => "Hangzhou\,\ Zhejiang",
  861310582 => "Huzhou\,\ Zhejiang",
  861310583 => "Jiaxing\,\ Zhejiang",
  861310584 => "Quzhou\,\ Zhejiang",
  861310585 => "Shaoxing\,\ Zhejiang",
  861310586 => "Taizhou\,\ Zhejiang",
  861310587 => "Zhoushan\,\ Zhejiang",
  861310588 => "Lishui\,\ Zhejiang",
  861310589 => "Jinhua\,\ Zhejiang",
  861310590 => "Longyan\,\ Fujian",
  861310591 => "Longyan\,\ Fujian",
  861310592 => "Longyan\,\ Fujian",
  861310593 => "Ningde\,\ Fujian",
  861310594 => "Longyan\,\ Fujian",
  861310595 => "Ningde\,\ Fujian",
  861310596 => "Ningde\,\ Fujian",
  861310597 => "Ningde\,\ Fujian",
  861310598 => "Nanping\,\ Fujian",
  861310599 => "Nanping\,\ Fujian",
  861310600 => "Taizhou\,\ Zhejiang",
  861310601 => "Taizhou\,\ Zhejiang",
  861310602 => "Taizhou\,\ Zhejiang",
  861310603 => "Taizhou\,\ Zhejiang",
  861310604 => "Taizhou\,\ Zhejiang",
  861310605 => "Taizhou\,\ Zhejiang",
  861310606 => "Quzhou\,\ Zhejiang",
  861310607 => "Quzhou\,\ Zhejiang",
  861310608 => "Quzhou\,\ Zhejiang",
  861310609 => "Quzhou\,\ Zhejiang",
  86131061 => "Wenzhou\,\ Zhejiang",
  861310620 => "Jinhua\,\ Zhejiang",
  861310621 => "Jinhua\,\ Zhejiang",
  861310622 => "Jinhua\,\ Zhejiang",
  861310623 => "Jinhua\,\ Zhejiang",
  861310624 => "Jinhua\,\ Zhejiang",
  861310625 => "Jinhua\,\ Zhejiang",
  861310626 => "Jinhua\,\ Zhejiang",
  861310627 => "Lishui\,\ Zhejiang",
  861310628 => "Lishui\,\ Zhejiang",
  861310629 => "Lishui\,\ Zhejiang",
  861310630 => "Shaoxing\,\ Zhejiang",
  861310631 => "Shaoxing\,\ Zhejiang",
  861310632 => "Shaoxing\,\ Zhejiang",
  861310633 => "Shaoxing\,\ Zhejiang",
  861310634 => "Shaoxing\,\ Zhejiang",
  861310635 => "Shaoxing\,\ Zhejiang",
  861310636 => "Shaoxing\,\ Zhejiang",
  861310637 => "Shaoxing\,\ Zhejiang",
  861310638 => "Lishui\,\ Zhejiang",
  861310639 => "Lishui\,\ Zhejiang",
  861310640 => "Jinhua\,\ Zhejiang",
  861310641 => "Jinhua\,\ Zhejiang",
  861310642 => "Jinhua\,\ Zhejiang",
  861310643 => "Shaoxing\,\ Zhejiang",
  861310644 => "Shaoxing\,\ Zhejiang",
  861310645 => "Taizhou\,\ Zhejiang",
  861310646 => "Taizhou\,\ Zhejiang",
  861310647 => "Taizhou\,\ Zhejiang",
  861310648 => "Taizhou\,\ Zhejiang",
  861310649 => "Taizhou\,\ Zhejiang",
  861310650 => "Shijiazhuang\,\ Hebei",
  861310651 => "Shijiazhuang\,\ Hebei",
  861310652 => "Shijiazhuang\,\ Hebei",
  861310653 => "Shijiazhuang\,\ Hebei",
  861310654 => "Shenzhen\,\ Guangdong",
  861310655 => "Shijiazhuang\,\ Hebei",
  861310656 => "Shijiazhuang\,\ Hebei",
  861310657 => "Foshan\,\ Guangdong",
  861310658 => "Foshan\,\ Guangdong",
  861310659 => "Foshan\,\ Guangdong",
  861310660 => "Zhanjiang\,\ Guangdong",
  861310661 => "Zhanjiang\,\ Guangdong",
  861310662 => "Zhanjiang\,\ Guangdong",
  861310663 => "Zhanjiang\,\ Guangdong",
  861310664 => "Zhanjiang\,\ Guangdong",
  861310665 => "Foshan\,\ Guangdong",
  861310666 => "Foshan\,\ Guangdong",
  861310667 => "Foshan\,\ Guangdong",
  861310668 => "Foshan\,\ Guangdong",
  861310669 => "Langfang\,\ Hebei",
  861310670 => "Foshan\,\ Guangdong",
  861310671 => "Foshan\,\ Guangdong",
  861310672 => "Foshan\,\ Guangdong",
  861310673 => "Foshan\,\ Guangdong",
  861310674 => "Foshan\,\ Guangdong",
  861310675 => "Foshan\,\ Guangdong",
  861310676 => "Foshan\,\ Guangdong",
  861310677 => "Yangjiang\,\ Guangdong",
  861310678 => "Yangjiang\,\ Guangdong",
  861310679 => "Yangjiang\,\ Guangdong",
  861310680 => "Zhuhai\,\ Guangdong",
  861310681 => "Zhuhai\,\ Guangdong",
  861310682 => "Zhuhai\,\ Guangdong",
  861310683 => "Zhuhai\,\ Guangdong",
  861310684 => "Zhuhai\,\ Guangdong",
  861310685 => "Dongguan\,\ Guangdong",
  861310686 => "Dongguan\,\ Guangdong",
  861310687 => "Dongguan\,\ Guangdong",
  861310688 => "Dongguan\,\ Guangdong",
  861310689 => "Dongguan\,\ Guangdong",
  861310690 => "Zhaoqing\,\ Guangdong",
  861310691 => "Zhaoqing\,\ Guangdong",
  861310692 => "Zhaoqing\,\ Guangdong",
  861310693 => "Jieyang\,\ Guangdong",
  861310694 => "Jieyang\,\ Guangdong",
  861310695 => "Jiangmen\,\ Guangdong",
  861310696 => "Jiangmen\,\ Guangdong",
  861310697 => "Jiangmen\,\ Guangdong",
  861310698 => "Jiangmen\,\ Guangdong",
  861310699 => "Jiangmen\,\ Guangdong",
  861310700 => "Zhuzhou\,\ Hunan",
  861310701 => "Zhuzhou\,\ Hunan",
  861310702 => "Zhuzhou\,\ Hunan",
  861310703 => "Zhuzhou\,\ Hunan",
  861310704 => "Hengyang\,\ Hunan",
  861310705 => "Chenzhou\,\ Hunan",
  861310706 => "Chenzhou\,\ Hunan",
  861310707 => "Yiyang\,\ Hunan",
  861310708 => "Chenzhou\,\ Hunan",
  861310709 => "Shaoyang\,\ Hunan",
  861310710 => "Yueyang\,\ Hunan",
  861310711 => "Changsha\,\ Hunan",
  861310712 => "Xiangtan\,\ Hunan",
  861310713 => "Xiangxi\,\ Hunan",
  861310714 => "Zhangjiajie\,\ Hunan",
  861310715 => "Huaihua\,\ Hunan",
  861310716 => "Yongzhou\,\ Hunan",
  861310717 => "Yiyang\,\ Hunan",
  861310718 => "Loudi\,\ Hunan",
  861310719 => "Shaoyang\,\ Hunan",
  861310720 => "Yueyang\,\ Hunan",
  861310721 => "Changsha\,\ Hunan",
  861310722 => "Xiangtan\,\ Hunan",
  861310723 => "Xiangxi\,\ Hunan",
  861310724 => "Hengyang\,\ Hunan",
  861310725 => "Huaihua\,\ Hunan",
  861310726 => "Yongzhou\,\ Hunan",
  861310727 => "Yiyang\,\ Hunan",
  861310728 => "Loudi\,\ Hunan",
  861310729 => "Shaoyang\,\ Hunan",
  861310730 => "Yueyang\,\ Hunan",
  861310731 => "Changsha\,\ Hunan",
  861310732 => "Xiangtan\,\ Hunan",
  861310733 => "Zhuzhou\,\ Hunan",
  861310734 => "Hengyang\,\ Hunan",
  861310735 => "Chenzhou\,\ Hunan",
  861310736 => "Changde\,\ Hunan",
  861310737 => "Yiyang\,\ Hunan",
  861310738 => "Loudi\,\ Hunan",
  861310739 => "Shaoyang\,\ Hunan",
  861310740 => "Changde\,\ Hunan",
  861310741 => "Changsha\,\ Hunan",
  861310742 => "Changsha\,\ Hunan",
  861310743 => "Xiangxi\,\ Hunan",
  861310744 => "Zhangjiajie\,\ Hunan",
  861310745 => "Huaihua\,\ Hunan",
  861310746 => "Yongzhou\,\ Hunan",
  861310747 => "Yueyang\,\ Hunan",
  861310748 => "Changsha\,\ Hunan",
  861310749 => "Changsha\,\ Hunan",
  861310750 => "Haidong\,\ Qinghai",
  861310751 => "Haidong\,\ Qinghai",
  861310752 => "Haidong\,\ Qinghai",
  861310753 => "Haidong\,\ Qinghai",
  861310754 => "Haixi\,\ Qinghai",
  861310755 => "Xining\,\ Qinghai",
  861310756 => "Haixi\,\ Qinghai",
  861310757 => "Haixi\,\ Qinghai",
  861310758 => "Xining\,\ Qinghai",
  861310759 => "Xining\,\ Qinghai",
  86131076 => "Fuzhou\,\ Fujian",
  861310770 => "Hangzhou\,\ Zhejiang",
  861310771 => "Hangzhou\,\ Zhejiang",
  861310772 => "Hangzhou\,\ Zhejiang",
  861310773 => "Hangzhou\,\ Zhejiang",
  861310774 => "Hangzhou\,\ Zhejiang",
  861310775 => "Wenzhou\,\ Zhejiang",
  861310776 => "Wenzhou\,\ Zhejiang",
  861310777 => "Wenzhou\,\ Zhejiang",
  861310778 => "Wenzhou\,\ Zhejiang",
  861310779 => "Wenzhou\,\ Zhejiang",
  86131078 => "Quanzhou\,\ Fujian",
  861310790 => "Sanming\,\ Fujian",
  861310791 => "Sanming\,\ Fujian",
  861310792 => "Fuzhou\,\ Fujian",
  861310793 => "Fuzhou\,\ Fujian",
  861310794 => "Fuzhou\,\ Fujian",
  861310795 => "Putian\,\ Fujian",
  861310796 => "Putian\,\ Fujian",
  861310797 => "Putian\,\ Fujian",
  861310798 => "Putian\,\ Fujian",
  861310799 => "Putian\,\ Fujian",
  861310800 => "Yibin\,\ Sichuan",
  861310801 => "Shangluo\,\ Shaanxi",
  861310802 => "YanAn\,\ Shaanxi",
  861310803 => "Neijiang\,\ Sichuan",
  861310804 => "Baoji\,\ Shaanxi",
  861310805 => "Luzhou\,\ Sichuan",
  861310806 => "Luzhou\,\ Sichuan",
  861310807 => "Ziyang\,\ Sichuan",
  861310808 => "Zigong\,\ Sichuan",
  861310809 => "YanAn\,\ Shaanxi",
  861310810 => "Mianyang\,\ Sichuan",
  861310811 => "Mianyang\,\ Sichuan",
  861310812 => "Panzhihua\,\ Sichuan",
  861310813 => "YanAn\,\ Shaanxi",
  861310814 => "Mianyang\,\ Sichuan",
  861310815 => "Mianyang\,\ Sichuan",
  861310816 => "Mianyang\,\ Sichuan",
  861310817 => "Nanchong\,\ Sichuan",
  861310818 => "Dazhou\,\ Sichuan",
  861310819 => "Mianyang\,\ Sichuan",
  861310820 => "Meishan\,\ Sichuan",
  861310821 => "Deyang\,\ Sichuan",
  861310822 => "Deyang\,\ Sichuan",
  861310823 => "Leshan\,\ Sichuan",
  861310824 => "Leshan\,\ Sichuan",
  861310825 => "Suining\,\ Sichuan",
  861310826 => "GuangAn\,\ Sichuan",
  861310827 => "Bazhong\,\ Sichuan",
  861310828 => "Baoji\,\ Shaanxi",
  861310829 => "Baoji\,\ Shaanxi",
  861310830 => "Luzhou\,\ Sichuan",
  861310831 => "Yibin\,\ Sichuan",
  861310832 => "Neijiang\,\ Sichuan",
  861310833 => "Leshan\,\ Sichuan",
  861310834 => "Liangshan\,\ Sichuan",
  861310835 => "YaAn\,\ Sichuan",
  861310836 => "Garze\,\ Sichuan",
  861310837 => "Aba\,\ Sichuan",
  861310838 => "Deyang\,\ Sichuan",
  861310839 => "Guangyuan\,\ Sichuan",
  861310840 => "Guangyuan\,\ Sichuan",
  861310841 => "Deyang\,\ Sichuan",
  861310842 => "GuangAn\,\ Sichuan",
  861310843 => "Meishan\,\ Sichuan",
  861310844 => "Dazhou\,\ Sichuan",
  861310845 => "Suining\,\ Sichuan",
  861310846 => "Hanzhong\,\ Shaanxi",
  861310847 => "Weinan\,\ Shaanxi",
  861310848 => "Liangshan\,\ Sichuan",
  861310849 => "Yulin\,\ Shaanxi",
  861310850 => "Kunming\,\ Yunnan",
  861310851 => "Kunming\,\ Yunnan",
  861310852 => "Kunming\,\ Yunnan",
  861310853 => "Kunming\,\ Yunnan",
  861310854 => "Kunming\,\ Yunnan",
  861310855 => "Dehong\,\ Yunnan",
  861310856 => "Dali\,\ Yunnan",
  861310857 => "Dali\,\ Yunnan",
  861310858 => "Zhaotong\,\ Yunnan",
  861310859 => "Puer\,\ Yunnan",
  861310860 => "Honghe\,\ Yunnan",
  861310861 => "Honghe\,\ Yunnan",
  861310862 => "Chuxiong\,\ Yunnan",
  861310863 => "Qujing\,\ Yunnan",
  861310864 => "Yuxi\,\ Yunnan",
  861310865 => "Kunming\,\ Yunnan",
  861310866 => "Kunming\,\ Yunnan",
  861310867 => "Kunming\,\ Yunnan",
  861310868 => "Kunming\,\ Yunnan",
  861310869 => "Kunming\,\ Yunnan",
  861310870 => "Kunming\,\ Yunnan",
  861310871 => "Kunming\,\ Yunnan",
  861310872 => "Dali\,\ Yunnan",
  861310873 => "Honghe\,\ Yunnan",
  861310874 => "Qujing\,\ Yunnan",
  861310875 => "Baoshan\,\ Yunnan",
  861310876 => "Kunming\,\ Yunnan",
  861310877 => "Yuxi\,\ Yunnan",
  861310878 => "Chuxiong\,\ Yunnan",
  861310879 => "Puer\,\ Yunnan",
  861310880 => "Kunming\,\ Yunnan",
  861310881 => "Xishuangbanna\,\ Yunnan",
  861310882 => "Dehong\,\ Yunnan",
  861310883 => "Kunming\,\ Yunnan",
  861310884 => "Kunming\,\ Yunnan",
  861310885 => "Kunming\,\ Yunnan",
  861310886 => "Kunming\,\ Yunnan",
  861310887 => "Kunming\,\ Yunnan",
  861310888 => "Lijiang\,\ Yunnan",
  861310889 => "Kunming\,\ Yunnan",
  86131089 => "Chongqing",
  861310900 => "Changji\,\ Xinjiang",
  861310901 => "Changji\,\ Xinjiang",
  861310902 => "Changji\,\ Xinjiang",
  861310903 => "Turpan\,\ Xinjiang",
  861310904 => "Ili\,\ Xinjiang",
  861310905 => "Ili\,\ Xinjiang",
  861310906 => "Ili\,\ Xinjiang",
  861310907 => "Ili\,\ Xinjiang",
  861310908 => "Ili\,\ Xinjiang",
  861310909 => "Aksu\,\ Xinjiang",
  861310910 => "Weinan\,\ Shaanxi",
  861310911 => "Weinan\,\ Shaanxi",
  861310912 => "Weinan\,\ Shaanxi",
  861310913 => "Weinan\,\ Shaanxi",
  861310914 => "Baoji\,\ Shaanxi",
  861310915 => "Baoji\,\ Shaanxi",
  861310916 => "Baoji\,\ Shaanxi",
  861310917 => "Baoji\,\ Shaanxi",
  861310918 => "Hanzhong\,\ Shaanxi",
  861310919 => "Hanzhong\,\ Shaanxi",
  861310920 => "Yulin\,\ Shaanxi",
  861310921 => "Yulin\,\ Shaanxi",
  861310922 => "Yulin\,\ Shaanxi",
  861310923 => "Yulin\,\ Shaanxi",
  861310924 => "Yulin\,\ Shaanxi",
  861310925 => "Yulin\,\ Shaanxi",
  861310926 => "Ankang\,\ Shaanxi",
  861310927 => "Ankang\,\ Shaanxi",
  861310928 => "Ankang\,\ Shaanxi",
  861310929 => "Ankang\,\ Shaanxi",
  861310930 => "Lanzhou\,\ Gansu",
  861310931 => "Lanzhou\,\ Gansu",
  861310932 => "Lanzhou\,\ Gansu",
  861310933 => "Lanzhou\,\ Gansu",
  861310934 => "Qingyang\,\ Gansu",
  861310935 => "Lanzhou\,\ Gansu",
  861310936 => "Lanzhou\,\ Gansu",
  861310937 => "Lanzhou\,\ Gansu",
  861310938 => "Lanzhou\,\ Gansu",
  861310939 => "Lanzhou\,\ Gansu",
  861310940 => "Lanzhou\,\ Gansu",
  861310941 => "Lanzhou\,\ Gansu",
  861310942 => "Lanzhou\,\ Gansu",
  861310943 => "Lanzhou\,\ Gansu",
  861310944 => "Dingxi\,\ Gansu",
  861310945 => "Jinchang\,\ Gansu",
  861310946 => "Tianshui\,\ Gansu",
  861310947 => "Jiuquan\,\ Gansu",
  861310948 => "Lanzhou\,\ Gansu",
  861310949 => "Lanzhou\,\ Gansu",
  86131095 => "XiAn\,\ Shaanxi",
  861310960 => "Xianyang\,\ Shaanxi",
  861310961 => "Xianyang\,\ Shaanxi",
  861310962 => "Xianyang\,\ Shaanxi",
  861310963 => "Xianyang\,\ Shaanxi",
  861310964 => "Weinan\,\ Shaanxi",
  861310965 => "Weinan\,\ Shaanxi",
  861310966 => "Baoji\,\ Shaanxi",
  861310967 => "YanAn\,\ Shaanxi",
  861310968 => "Yulin\,\ Shaanxi",
  861310969 => "Yulin\,\ Shaanxi",
  86131097 => "Xining\,\ Qinghai",
  861310980 => "Dalian\,\ Liaoning",
  861310981 => "Dalian\,\ Liaoning",
  861310982 => "Dalian\,\ Liaoning",
  861310983 => "Dalian\,\ Liaoning",
  861310984 => "Dalian\,\ Liaoning",
  861310985 => "Shenyang\,\ Liaoning",
  861310986 => "Shenyang\,\ Liaoning",
  861310987 => "Shenyang\,\ Liaoning",
  861310988 => "Shenyang\,\ Liaoning",
  861310989 => "Shenyang\,\ Liaoning",
  86131099 => "Urumchi\,\ Xinjiang",
  86131100 => "Tianjin",
  86131101 => "Chongqing",
  86131102 => "Chongqing",
  861311030 => "Weinan\,\ Shaanxi",
  861311031 => "Weinan\,\ Shaanxi",
  861311032 => "Weinan\,\ Shaanxi",
  861311033 => "Weinan\,\ Shaanxi",
  861311034 => "Weinan\,\ Shaanxi",
  861311035 => "Weinan\,\ Shaanxi",
  861311036 => "Hanzhong\,\ Shaanxi",
  861311037 => "Hanzhong\,\ Shaanxi",
  861311038 => "Hanzhong\,\ Shaanxi",
  861311039 => "Hanzhong\,\ Shaanxi",
  86131104 => "XiAn\,\ Shaanxi",
  861311050 => "Fuzhou\,\ Fujian",
  861311051 => "Fuzhou\,\ Fujian",
  861311052 => "Fuzhou\,\ Fujian",
  861311053 => "Fuzhou\,\ Fujian",
  861311054 => "Fuzhou\,\ Fujian",
  861311055 => "Putian\,\ Fujian",
  861311056 => "Putian\,\ Fujian",
  861311057 => "Nanping\,\ Fujian",
  861311058 => "Sanming\,\ Fujian",
  861311059 => "Xiamen\,\ Fujian",
  861311060 => "Longyan\,\ Fujian",
  861311061 => "Longyan\,\ Fujian",
  861311062 => "Longyan\,\ Fujian",
  861311063 => "Fuzhou\,\ Fujian",
  861311064 => "Fuzhou\,\ Fujian",
  861311065 => "Zhangzhou\,\ Fujian",
  861311066 => "Zhangzhou\,\ Fujian",
  861311067 => "Zhangzhou\,\ Fujian",
  861311068 => "Longyan\,\ Fujian",
  861311069 => "Putian\,\ Fujian",
  861311070 => "Quanzhou\,\ Fujian",
  861311071 => "Quanzhou\,\ Fujian",
  861311072 => "Quanzhou\,\ Fujian",
  861311073 => "Quanzhou\,\ Fujian",
  861311074 => "Quanzhou\,\ Fujian",
  861311075 => "Fuzhou\,\ Fujian",
  861311076 => "Fuzhou\,\ Fujian",
  861311077 => "Fuzhou\,\ Fujian",
  861311078 => "Fuzhou\,\ Fujian",
  861311079 => "Fuzhou\,\ Fujian",
  861311080 => "Quanzhou\,\ Fujian",
  861311081 => "Quanzhou\,\ Fujian",
  861311082 => "Quanzhou\,\ Fujian",
  861311083 => "Quanzhou\,\ Fujian",
  861311084 => "Sanming\,\ Fujian",
  861311085 => "Quanzhou\,\ Fujian",
  861311086 => "Quanzhou\,\ Fujian",
  861311087 => "Fuzhou\,\ Fujian",
  861311088 => "Fuzhou\,\ Fujian",
  861311089 => "Fuzhou\,\ Fujian",
  861311090 => "Nanping\,\ Fujian",
  861311091 => "Nanping\,\ Fujian",
  861311092 => "Xiamen\,\ Fujian",
  861311093 => "Xiamen\,\ Fujian",
  861311094 => "Quanzhou\,\ Fujian",
  861311095 => "Quanzhou\,\ Fujian",
  861311096 => "Quanzhou\,\ Fujian",
  861311097 => "Quanzhou\,\ Fujian",
  861311098 => "Quanzhou\,\ Fujian",
  861311099 => "Quanzhou\,\ Fujian",
  861311100 => "Taiyuan\,\ Shanxi",
  861311101 => "Jinzhong\,\ Shanxi",
  861311102 => "Shuozhou\,\ Shanxi",
  861311103 => "Jinzhong\,\ Shanxi",
  861311104 => "Taiyuan\,\ Shanxi",
  861311105 => "Taiyuan\,\ Shanxi",
  861311106 => "Taiyuan\,\ Shanxi",
  861311107 => "Taiyuan\,\ Shanxi",
  861311108 => "Taiyuan\,\ Shanxi",
  861311109 => "Taiyuan\,\ Shanxi",
  861311110 => "Xinzhou\,\ Shanxi",
  861311111 => "Linfen\,\ Shanxi",
  861311112 => "Datong\,\ Shanxi",
  861311113 => "Yangquan\,\ Shanxi",
  861311114 => "Jincheng\,\ Shanxi",
  861311115 => "Changzhi\,\ Shanxi",
  861311116 => "Jincheng\,\ Shanxi",
  861311117 => "Linfen\,\ Shanxi",
  861311118 => "Lüliang\,\ Shanxi",
  861311119 => "Yuncheng\,\ Shanxi",
  861311120 => "Xinzhou\,\ Shanxi",
  861311121 => "Lüliang\,\ Shanxi",
  861311122 => "Datong\,\ Shanxi",
  861311123 => "Yangquan\,\ Shanxi",
  861311124 => "Yuncheng\,\ Shanxi",
  861311125 => "Changzhi\,\ Shanxi",
  861311126 => "Jincheng\,\ Shanxi",
  861311127 => "Linfen\,\ Shanxi",
  861311128 => "Datong\,\ Shanxi",
  861311129 => "Yuncheng\,\ Shanxi",
  86131113 => "Handan\,\ Hebei",
  861311140 => "Qinhuangdao\,\ Hebei",
  861311141 => "Qinhuangdao\,\ Hebei",
  861311142 => "Qinhuangdao\,\ Hebei",
  861311143 => "Qinhuangdao\,\ Hebei",
  861311144 => "Tangshan\,\ Hebei",
  861311145 => "Tangshan\,\ Hebei",
  861311146 => "Tangshan\,\ Hebei",
  861311147 => "Tangshan\,\ Hebei",
  861311148 => "Tangshan\,\ Hebei",
  861311149 => "Tangshan\,\ Hebei",
  86131115 => "Shijiazhuang\,\ Hebei",
  86131116 => "Baoding\,\ Hebei",
  86131117 => "Cangzhou\,\ Hebei",
  861311180 => "Aba\,\ Sichuan",
  861311181 => "Garze\,\ Sichuan",
  861311182 => "YaAn\,\ Sichuan",
  861311183 => "YaAn\,\ Sichuan",
  861311184 => "YaAn\,\ Sichuan",
  861311185 => "Chengdu\,\ Sichuan",
  861311186 => "Chengdu\,\ Sichuan",
  861311187 => "Chengdu\,\ Sichuan",
  861311188 => "Chengdu\,\ Sichuan",
  861311189 => "Chengdu\,\ Sichuan",
  86131119 => "Haikou\,\ Hainan",
  86131120 => "Shaoguan\,\ Guangdong",
  86131121 => "Jieyang\,\ Guangdong",
  86131122 => "Guangzhou\,\ Guangdong",
  86131123 => "Zhuhai\,\ Guangdong",
  86131124 => "Meizhou\,\ Guangdong",
  861311250 => "Chaozhou\,\ Guangdong",
  861311251 => "Chaozhou\,\ Guangdong",
  861311252 => "Chaozhou\,\ Guangdong",
  861311253 => "Chaozhou\,\ Guangdong",
  861311254 => "Shantou\,\ Guangdong",
  861311255 => "Shantou\,\ Guangdong",
  861311256 => "Shantou\,\ Guangdong",
  861311257 => "Shantou\,\ Guangdong",
  861311258 => "Shantou\,\ Guangdong",
  861311259 => "Shantou\,\ Guangdong",
  86131126 => "Huizhou\,\ Guangdong",
  86131127 => "Foshan\,\ Guangdong",
  86131128 => "Dongguan\,\ Guangdong",
  86131129 => "Zhongshan\,\ Guangdong",
  861311300 => "Shenzhen\,\ Guangdong",
  861311301 => "Shenzhen\,\ Guangdong",
  861311302 => "Shenzhen\,\ Guangdong",
  861311303 => "Shijiazhuang\,\ Hebei",
  861311304 => "Shenzhen\,\ Guangdong",
  861311305 => "Dongguan\,\ Guangdong",
  861311306 => "Dongguan\,\ Guangdong",
  861311307 => "Dongguan\,\ Guangdong",
  861311308 => "Dongguan\,\ Guangdong",
  861311309 => "Dongguan\,\ Guangdong",
  86131131 => "Dongguan\,\ Guangdong",
  86131132 => "Dongguan\,\ Guangdong",
  86131133 => "Guangzhou\,\ Guangdong",
  861311340 => "Huizhou\,\ Guangdong",
  861311341 => "Huizhou\,\ Guangdong",
  861311342 => "Zhuhai\,\ Guangdong",
  861311343 => "Zhuhai\,\ Guangdong",
  861311344 => "Zhuhai\,\ Guangdong",
  861311345 => "Xingtai\,\ Hebei",
  861311346 => "Jiangmen\,\ Guangdong",
  861311347 => "Shantou\,\ Guangdong",
  861311348 => "Shantou\,\ Guangdong",
  861311349 => "Shantou\,\ Guangdong",
  861311350 => "Ordos\,\ Inner\ Mongolia",
  861311351 => "Ordos\,\ Inner\ Mongolia",
  861311352 => "Ordos\,\ Inner\ Mongolia",
  861311353 => "Ordos\,\ Inner\ Mongolia",
  861311354 => "Chifeng\,\ Inner\ Mongolia",
  861311355 => "Chifeng\,\ Inner\ Mongolia",
  861311356 => "Chifeng\,\ Inner\ Mongolia",
  861311357 => "Chifeng\,\ Inner\ Mongolia",
  861311358 => "Chifeng\,\ Inner\ Mongolia",
  861311359 => "Hinggan\,\ Inner\ Mongolia",
  86131136 => "Shenzhen\,\ Guangdong",
  861311370 => "Langfang\,\ Hebei",
  861311371 => "Foshan\,\ Guangdong",
  861311372 => "Foshan\,\ Guangdong",
  861311373 => "Foshan\,\ Guangdong",
  861311374 => "Foshan\,\ Guangdong",
  861311375 => "Foshan\,\ Guangdong",
  861311376 => "Foshan\,\ Guangdong",
  861311377 => "Foshan\,\ Guangdong",
  861311378 => "Foshan\,\ Guangdong",
  861311379 => "Foshan\,\ Guangdong",
  861311380 => "Shenzhen\,\ Guangdong",
  861311381 => "Shenzhen\,\ Guangdong",
  861311382 => "Shenzhen\,\ Guangdong",
  861311383 => "Shenzhen\,\ Guangdong",
  861311384 => "Shenzhen\,\ Guangdong",
  861311385 => "Shenzhen\,\ Guangdong",
  861311386 => "Shenzhen\,\ Guangdong",
  861311387 => "Shenzhen\,\ Guangdong",
  861311388 => "Shijiazhuang\,\ Hebei",
  861311389 => "Shijiazhuang\,\ Hebei",
  861311390 => "Zhongshan\,\ Guangdong",
  861311391 => "Zhongshan\,\ Guangdong",
  861311392 => "Zhongshan\,\ Guangdong",
  861311393 => "Zhongshan\,\ Guangdong",
  861311394 => "Zhongshan\,\ Guangdong",
  861311395 => "Guangzhou\,\ Guangdong",
  861311396 => "Guangzhou\,\ Guangdong",
  861311397 => "Guangzhou\,\ Guangdong",
  861311398 => "Guangzhou\,\ Guangdong",
  861311399 => "Guangzhou\,\ Guangdong",
  86131140 => "Chongqing",
  861311410 => "Yuxi\,\ Yunnan",
  861311411 => "Qujing\,\ Yunnan",
  861311412 => "Dali\,\ Yunnan",
  861311413 => "Chuxiong\,\ Yunnan",
  861311414 => "Kunming\,\ Yunnan",
  861311415 => "Puer\,\ Yunnan",
  861311416 => "Lincang\,\ Yunnan",
  861311417 => "Wenshan\,\ Yunnan",
  861311418 => "Xishuangbanna\,\ Yunnan",
  861311419 => "Baoshan\,\ Yunnan",
  86131142 => "Kunming\,\ Yunnan",
  861311430 => "Jingzhou\,\ Hubei",
  861311431 => "Jingzhou\,\ Hubei",
  861311432 => "Wuhan\,\ Hubei",
  861311433 => "Wuhan\,\ Hubei",
  861311434 => "Wuhan\,\ Hubei",
  861311435 => "Wuhan\,\ Hubei",
  861311436 => "Wuhan\,\ Hubei",
  861311437 => "Wuhan\,\ Hubei",
  861311438 => "Wuhan\,\ Hubei",
  861311439 => "Wuhan\,\ Hubei",
  861311440 => "Suizhou\,\ Hubei",
  861311441 => "Xiaogan\,\ Hubei",
  861311442 => "Huangshi\,\ Hubei",
  861311443 => "Huanggang\,\ Hubei",
  861311444 => "Shiyan\,\ Hubei",
  861311445 => "Yichang\,\ Hubei",
  861311446 => "Yichang\,\ Hubei",
  861311447 => "Xiangfan\,\ Hubei",
  861311448 => "Xiangfan\,\ Hubei",
  861311449 => "Jingmen\,\ Hubei",
  861311450 => "Harbin\,\ Heilongjiang",
  861311451 => "Harbin\,\ Heilongjiang",
  861311452 => "Qiqihar\,\ Heilongjiang",
  861311453 => "Mudanjiang\,\ Heilongjiang",
  861311454 => "Jiamusi\,\ Heilongjiang",
  861311455 => "Suihua\,\ Heilongjiang",
  861311456 => "Heihe\,\ Heilongjiang",
  861311457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861311458 => "Yichun\,\ Heilongjiang",
  861311459 => "Daqing\,\ Heilongjiang",
  861311460 => "Harbin\,\ Heilongjiang",
  861311461 => "Harbin\,\ Heilongjiang",
  861311462 => "Qiqihar\,\ Heilongjiang",
  861311463 => "Mudanjiang\,\ Heilongjiang",
  861311464 => "Qitaihe\,\ Heilongjiang",
  861311465 => "Suihua\,\ Heilongjiang",
  861311466 => "Qiqihar\,\ Heilongjiang",
  861311467 => "Jixi\,\ Heilongjiang",
  861311468 => "Hegang\,\ Heilongjiang",
  861311469 => "Shuangyashan\,\ Heilongjiang",
  861311470 => "Fangchenggang\,\ Guangxi",
  861311471 => "Nanning\,\ Guangxi",
  861311472 => "Liuzhou\,\ Guangxi",
  861311473 => "Guilin\,\ Guangxi",
  861311474 => "Wuzhou\,\ Guangxi",
  861311475 => "Yulin\,\ Guangxi",
  861311476 => "Baise\,\ Guangxi",
  861311477 => "Qinzhou\,\ Guangxi",
  861311478 => "Hechi\,\ Guangxi",
  861311479 => "Beihai\,\ Guangxi",
  86131148 => "Tianjin",
  86131149 => "Tianjin",
  861311500 => "Nanjing\,\ Jiangsu",
  861311501 => "Nanjing\,\ Jiangsu",
  861311502 => "Nanjing\,\ Jiangsu",
  861311503 => "Nanjing\,\ Jiangsu",
  861311504 => "Nanjing\,\ Jiangsu",
  861311505 => "Wuxi\,\ Jiangsu",
  861311506 => "Wuxi\,\ Jiangsu",
  861311507 => "Wuxi\,\ Jiangsu",
  861311508 => "Wuxi\,\ Jiangsu",
  861311509 => "Wuxi\,\ Jiangsu",
  861311510 => "Suzhou\,\ Jiangsu",
  861311511 => "Suzhou\,\ Jiangsu",
  861311512 => "Suzhou\,\ Jiangsu",
  861311513 => "Lianyungang\,\ Jiangsu",
  861311514 => "Lianyungang\,\ Jiangsu",
  861311515 => "Lianyungang\,\ Jiangsu",
  861311516 => "Yancheng\,\ Jiangsu",
  861311517 => "Yangzhou\,\ Jiangsu",
  861311518 => "Yangzhou\,\ Jiangsu",
  861311519 => "Yangzhou\,\ Jiangsu",
  861311520 => "Xuzhou\,\ Jiangsu",
  861311521 => "Xuzhou\,\ Jiangsu",
  861311522 => "Xuzhou\,\ Jiangsu",
  861311523 => "HuaiAn\,\ Jiangsu",
  861311524 => "HuaiAn\,\ Jiangsu",
  861311525 => "HuaiAn\,\ Jiangsu",
  861311526 => "Yancheng\,\ Jiangsu",
  861311527 => "Changzhou\,\ Jiangsu",
  861311528 => "Changzhou\,\ Jiangsu",
  861311529 => "Changzhou\,\ Jiangsu",
  861311530 => "Harbin\,\ Heilongjiang",
  861311531 => "Harbin\,\ Heilongjiang",
  861311532 => "Qiqihar\,\ Heilongjiang",
  861311533 => "Mudanjiang\,\ Heilongjiang",
  861311534 => "Jiamusi\,\ Heilongjiang",
  861311535 => "Jiamusi\,\ Heilongjiang",
  861311536 => "Jiamusi\,\ Heilongjiang",
  861311537 => "Jixi\,\ Heilongjiang",
  861311538 => "Hegang\,\ Heilongjiang",
  861311539 => "Daqing\,\ Heilongjiang",
  861311540 => "Harbin\,\ Heilongjiang",
  861311541 => "Harbin\,\ Heilongjiang",
  861311542 => "Daqing\,\ Heilongjiang",
  861311543 => "Daqing\,\ Heilongjiang",
  861311544 => "Daqing\,\ Heilongjiang",
  861311545 => "Harbin\,\ Heilongjiang",
  861311546 => "Jixi\,\ Heilongjiang",
  861311547 => "Jixi\,\ Heilongjiang",
  861311548 => "Hegang\,\ Heilongjiang",
  861311549 => "Daqing\,\ Heilongjiang",
  861311550 => "Harbin\,\ Heilongjiang",
  861311551 => "Harbin\,\ Heilongjiang",
  861311552 => "Heihe\,\ Heilongjiang",
  861311553 => "Mudanjiang\,\ Heilongjiang",
  861311554 => "Jiamusi\,\ Heilongjiang",
  861311555 => "Harbin\,\ Heilongjiang",
  861311556 => "Heihe\,\ Heilongjiang",
  861311557 => "Shuangyashan\,\ Heilongjiang",
  861311558 => "Yichun\,\ Heilongjiang",
  861311559 => "Daqing\,\ Heilongjiang",
  861311560 => "Harbin\,\ Heilongjiang",
  861311561 => "Harbin\,\ Heilongjiang",
  861311562 => "Heihe\,\ Heilongjiang",
  861311563 => "Mudanjiang\,\ Heilongjiang",
  861311564 => "Hegang\,\ Heilongjiang",
  861311565 => "Suihua\,\ Heilongjiang",
  861311566 => "Qiqihar\,\ Heilongjiang",
  861311567 => "Daqing\,\ Heilongjiang",
  861311568 => "Hegang\,\ Heilongjiang",
  861311569 => "Shuangyashan\,\ Heilongjiang",
  861311570 => "Quzhou\,\ Zhejiang",
  861311571 => "Hangzhou\,\ Zhejiang",
  861311572 => "Huzhou\,\ Zhejiang",
  861311573 => "Jiaxing\,\ Zhejiang",
  861311574 => "Ningbo\,\ Zhejiang",
  861311575 => "Shaoxing\,\ Zhejiang",
  861311576 => "Taizhou\,\ Zhejiang",
  861311577 => "Wenzhou\,\ Zhejiang",
  861311578 => "Lishui\,\ Zhejiang",
  861311579 => "Jinhua\,\ Zhejiang",
  861311580 => "Zhoushan\,\ Zhejiang",
  861311581 => "Wenzhou\,\ Zhejiang",
  861311582 => "Wenzhou\,\ Zhejiang",
  861311583 => "Wenzhou\,\ Zhejiang",
  861311584 => "Wenzhou\,\ Zhejiang",
  861311585 => "Wenzhou\,\ Zhejiang",
  861311586 => "Wenzhou\,\ Zhejiang",
  861311587 => "Wenzhou\,\ Zhejiang",
  861311588 => "Wenzhou\,\ Zhejiang",
  861311589 => "Wenzhou\,\ Zhejiang",
  861311590 => "Fuzhou\,\ Fujian",
  861311591 => "Fuzhou\,\ Fujian",
  861311592 => "Fuzhou\,\ Fujian",
  861311593 => "Ningde\,\ Fujian",
  861311594 => "Putian\,\ Fujian",
  861311595 => "Quanzhou\,\ Fujian",
  861311596 => "Zhangzhou\,\ Fujian",
  861311597 => "Ningde\,\ Fujian",
  861311598 => "Sanming\,\ Fujian",
  861311599 => "Quanzhou\,\ Fujian",
  86131160 => "Tianjin",
  86131161 => "Tianjin",
  86131162 => "Kunming\,\ Yunnan",
  861311630 => "Guiyang\,\ Guizhou",
  861311631 => "Guiyang\,\ Guizhou",
  861311632 => "Guiyang\,\ Guizhou",
  861311633 => "Zunyi\,\ Guizhou",
  861311634 => "Zunyi\,\ Guizhou",
  861311635 => "Zunyi\,\ Guizhou",
  861311636 => "Liupanshui\,\ Guizhou",
  861311637 => "Liupanshui\,\ Guizhou",
  861311638 => "Liupanshui\,\ Guizhou",
  861311639 => "Qianxinan\,\ Guizhou",
  861311640 => "Anshun\,\ Guizhou",
  861311641 => "Anshun\,\ Guizhou",
  861311642 => "Qiannan\,\ Guizhou",
  861311643 => "Qiannan\,\ Guizhou",
  861311644 => "Qiandongnan\,\ Guizhou",
  861311645 => "Qiandongnan\,\ Guizhou",
  861311646 => "Bijie\,\ Guizhou",
  861311647 => "Bijie\,\ Guizhou",
  861311648 => "Tongren\,\ Guizhou",
  861311649 => "Guiyang\,\ Guizhou",
  86131165 => "Taizhou\,\ Zhejiang",
  86131166 => "Ningbo\,\ Zhejiang",
  86131167 => "Hangzhou\,\ Zhejiang",
  861311680 => "Zhoushan\,\ Zhejiang",
  861311681 => "Jiaxing\,\ Zhejiang",
  861311682 => "Huzhou\,\ Zhejiang",
  861311683 => "Jiaxing\,\ Zhejiang",
  861311684 => "Quzhou\,\ Zhejiang",
  861311685 => "Shaoxing\,\ Zhejiang",
  861311686 => "Lishui\,\ Zhejiang",
  861311687 => "Jinhua\,\ Zhejiang",
  861311688 => "Jinhua\,\ Zhejiang",
  861311689 => "Jinhua\,\ Zhejiang",
  861311690 => "Deqen\,\ Yunnan",
  861311691 => "Xishuangbanna\,\ Yunnan",
  861311692 => "Dehong\,\ Yunnan",
  861311693 => "Nujiang\,\ Yunnan",
  861311694 => "Lijiang\,\ Yunnan",
  861311695 => "Kunming\,\ Yunnan",
  861311696 => "Lijiang\,\ Yunnan",
  861311697 => "Honghe\,\ Yunnan",
  861311698 => "Dehong\,\ Yunnan",
  861311699 => "Zhaotong\,\ Yunnan",
  861311700 => "Xiaogan\,\ Hubei",
  861311701 => "Huangshi\,\ Hubei",
  861311702 => "Huangshi\,\ Hubei",
  861311703 => "Huangshi\,\ Hubei",
  861311704 => "Xianning\,\ Hubei",
  861311705 => "Jingmen\,\ Hubei",
  861311706 => "Jingmen\,\ Hubei",
  861311707 => "Huanggang\,\ Hubei",
  861311708 => "Huanggang\,\ Hubei",
  861311709 => "Huanggang\,\ Hubei",
  861311710 => "Shiyan\,\ Hubei",
  861311711 => "Wuhan\,\ Hubei",
  861311712 => "Wuhan\,\ Hubei",
  861311713 => "Enshi\,\ Hubei",
  861311714 => "Enshi\,\ Hubei",
  861311715 => "Xianning\,\ Hubei",
  861311716 => "Xianning\,\ Hubei",
  861311717 => "Jingzhou\,\ Hubei",
  861311718 => "Jingzhou\,\ Hubei",
  861311719 => "Jingzhou\,\ Hubei",
  861311720 => "Ezhou\,\ Hubei",
  861311721 => "Xiangfan\,\ Hubei",
  861311722 => "Xiangfan\,\ Hubei",
  861311723 => "Xiangfan\,\ Hubei",
  861311724 => "Wuhan\,\ Hubei",
  861311725 => "Wuhan\,\ Hubei",
  861311726 => "Suizhou\,\ Hubei",
  861311727 => "Yichang\,\ Hubei",
  861311728 => "Yichang\,\ Hubei",
  861311729 => "Yichang\,\ Hubei",
  861311730 => "Yueyang\,\ Hunan",
  861311731 => "Changsha\,\ Hunan",
  861311732 => "Xiangtan\,\ Hunan",
  861311733 => "Zhuzhou\,\ Hunan",
  861311734 => "Hengyang\,\ Hunan",
  861311735 => "Chenzhou\,\ Hunan",
  861311736 => "Changde\,\ Hunan",
  861311737 => "Yiyang\,\ Hunan",
  861311738 => "Loudi\,\ Hunan",
  861311739 => "Shaoyang\,\ Hunan",
  861311740 => "Yueyang\,\ Hunan",
  861311741 => "Changsha\,\ Hunan",
  861311742 => "Xiangtan\,\ Hunan",
  861311743 => "Xiangxi\,\ Hunan",
  861311744 => "Zhangjiajie\,\ Hunan",
  861311745 => "Huaihua\,\ Hunan",
  861311746 => "Yongzhou\,\ Hunan",
  861311747 => "Yiyang\,\ Hunan",
  861311748 => "Loudi\,\ Hunan",
  861311749 => "Shaoyang\,\ Hunan",
  861311750 => "Yueyang\,\ Hunan",
  861311751 => "Changsha\,\ Hunan",
  861311752 => "Xiangtan\,\ Hunan",
  861311753 => "Zhuzhou\,\ Hunan",
  861311754 => "Hengyang\,\ Hunan",
  861311755 => "Chenzhou\,\ Hunan",
  861311756 => "Changde\,\ Hunan",
  861311757 => "Yiyang\,\ Hunan",
  861311758 => "Loudi\,\ Hunan",
  861311759 => "Shaoyang\,\ Hunan",
  861311760 => "Nanning\,\ Guangxi",
  861311761 => "Nanning\,\ Guangxi",
  861311762 => "Liuzhou\,\ Guangxi",
  861311763 => "Guilin\,\ Guangxi",
  861311764 => "Hezhou\,\ Guangxi",
  861311765 => "Yulin\,\ Guangxi",
  861311766 => "Guigang\,\ Guangxi",
  861311767 => "Hezhou\,\ Guangxi",
  861311768 => "Hechi\,\ Guangxi",
  861311769 => "Guigang\,\ Guangxi",
  861311770 => "Fangchenggang\,\ Guangxi",
  861311771 => "Nanning\,\ Guangxi",
  861311772 => "Liuzhou\,\ Guangxi",
  861311773 => "Guilin\,\ Guangxi",
  861311774 => "Wuzhou\,\ Guangxi",
  861311775 => "Yulin\,\ Guangxi",
  861311776 => "Baise\,\ Guangxi",
  861311777 => "Qinzhou\,\ Guangxi",
  861311778 => "Hechi\,\ Guangxi",
  861311779 => "Beihai\,\ Guangxi",
  861311780 => "Nanchang\,\ Jiangxi",
  861311781 => "Nanchang\,\ Jiangxi",
  861311782 => "Jiujiang\,\ Jiangxi",
  861311783 => "Shangrao\,\ Jiangxi",
  861311784 => "Shangrao\,\ Jiangxi",
  861311785 => "Fuzhou\,\ Jiangxi",
  861311786 => "JiAn\,\ Jiangxi",
  861311787 => "Ganzhou\,\ Jiangxi",
  861311788 => "Ganzhou\,\ Jiangxi",
  861311789 => "Ganzhou\,\ Jiangxi",
  861311790 => "Xinyu\,\ Jiangxi",
  861311791 => "Nanchang\,\ Jiangxi",
  861311792 => "Jiujiang\,\ Jiangxi",
  861311793 => "Shangrao\,\ Jiangxi",
  861311794 => "Fuzhou\,\ Jiangxi",
  861311795 => "Yichun\,\ Jiangxi",
  861311796 => "JiAn\,\ Jiangxi",
  861311797 => "Ganzhou\,\ Jiangxi",
  861311798 => "Jingdezhen\,\ Jiangxi",
  861311799 => "Pingxiang\,\ Jiangxi",
  861311800 => "Yibin\,\ Sichuan",
  861311801 => "Yibin\,\ Sichuan",
  861311802 => "Luzhou\,\ Sichuan",
  861311803 => "Luzhou\,\ Sichuan",
  861311804 => "Ziyang\,\ Sichuan",
  861311805 => "Ziyang\,\ Sichuan",
  861311806 => "Neijiang\,\ Sichuan",
  861311807 => "Neijiang\,\ Sichuan",
  861311808 => "Zigong\,\ Sichuan",
  861311809 => "Zigong\,\ Sichuan",
  861311810 => "Deyang\,\ Sichuan",
  861311811 => "Deyang\,\ Sichuan",
  861311812 => "Deyang\,\ Sichuan",
  861311813 => "Deyang\,\ Sichuan",
  861311814 => "Guangyuan\,\ Sichuan",
  861311815 => "Guangyuan\,\ Sichuan",
  861311816 => "Mianyang\,\ Sichuan",
  861311817 => "Mianyang\,\ Sichuan",
  861311818 => "Mianyang\,\ Sichuan",
  861311819 => "Mianyang\,\ Sichuan",
  861311820 => "Suining\,\ Sichuan",
  861311821 => "Suining\,\ Sichuan",
  861311822 => "Suining\,\ Sichuan",
  861311823 => "GuangAn\,\ Sichuan",
  861311824 => "GuangAn\,\ Sichuan",
  861311825 => "GuangAn\,\ Sichuan",
  861311826 => "Nanchong\,\ Sichuan",
  861311827 => "Nanchong\,\ Sichuan",
  861311828 => "Nanchong\,\ Sichuan",
  861311829 => "Nanchong\,\ Sichuan",
  861311830 => "Panzhihua\,\ Sichuan",
  861311831 => "Panzhihua\,\ Sichuan",
  861311832 => "Liangshan\,\ Sichuan",
  861311833 => "Liangshan\,\ Sichuan",
  861311834 => "Meishan\,\ Sichuan",
  861311835 => "Meishan\,\ Sichuan",
  861311836 => "Meishan\,\ Sichuan",
  861311837 => "Leshan\,\ Sichuan",
  861311838 => "Leshan\,\ Sichuan",
  861311839 => "Leshan\,\ Sichuan",
  861311840 => "Ziyang\,\ Sichuan",
  861311841 => "Ziyang\,\ Sichuan",
  861311842 => "Ziyang\,\ Sichuan",
  861311843 => "Luzhou\,\ Sichuan",
  861311844 => "Luzhou\,\ Sichuan",
  861311845 => "Neijiang\,\ Sichuan",
  861311846 => "Neijiang\,\ Sichuan",
  861311847 => "Yibin\,\ Sichuan",
  861311848 => "Yibin\,\ Sichuan",
  861311849 => "Yibin\,\ Sichuan",
  861311850 => "Guiyang\,\ Guizhou",
  861311851 => "Guiyang\,\ Guizhou",
  861311852 => "Zunyi\,\ Guizhou",
  861311853 => "Anshun\,\ Guizhou",
  861311854 => "Qiannan\,\ Guizhou",
  861311855 => "Qiandongnan\,\ Guizhou",
  861311856 => "Tongren\,\ Guizhou",
  861311857 => "Bijie\,\ Guizhou",
  861311858 => "Liupanshui\,\ Guizhou",
  861311859 => "Qianxinan\,\ Guizhou",
  861311860 => "Chaozhou\,\ Guangdong",
  861311861 => "Chaozhou\,\ Guangdong",
  861311862 => "Chaozhou\,\ Guangdong",
  861311863 => "Chaozhou\,\ Guangdong",
  861311864 => "Shantou\,\ Guangdong",
  861311865 => "Shantou\,\ Guangdong",
  861311866 => "Shantou\,\ Guangdong",
  861311867 => "Shantou\,\ Guangdong",
  861311868 => "Shantou\,\ Guangdong",
  861311869 => "Shantou\,\ Guangdong",
  861311870 => "Zhaotong\,\ Yunnan",
  861311871 => "Kunming\,\ Yunnan",
  861311872 => "Dali\,\ Yunnan",
  861311873 => "Honghe\,\ Yunnan",
  861311874 => "Qujing\,\ Yunnan",
  861311875 => "Baoshan\,\ Yunnan",
  861311876 => "Wenshan\,\ Yunnan",
  861311877 => "Yuxi\,\ Yunnan",
  861311878 => "Chuxiong\,\ Yunnan",
  861311879 => "Puer\,\ Yunnan",
  86131188 => "Foshan\,\ Guangdong",
  86131189 => "Haikou\,\ Hainan",
  861311900 => "Changji\,\ Xinjiang",
  861311901 => "Tacheng\,\ Xinjiang",
  861311902 => "Hami\,\ Xinjiang",
  861311903 => "Hotan\,\ Xinjiang",
  861311904 => "Urumchi\,\ Xinjiang",
  861311905 => "Altay\,\ Xinjiang",
  861311906 => "Altay\,\ Xinjiang",
  861311907 => "Bayingolin\,\ Xinjiang",
  861311908 => "Kizilsu\,\ Xinjiang",
  861311909 => "Bortala\,\ Xinjiang",
  86131191 => "XiAn\,\ Shaanxi",
  861311920 => "YanAn\,\ Shaanxi",
  861311921 => "YanAn\,\ Shaanxi",
  861311922 => "YanAn\,\ Shaanxi",
  861311923 => "YanAn\,\ Shaanxi",
  861311924 => "YanAn\,\ Shaanxi",
  861311925 => "YanAn\,\ Shaanxi",
  861311926 => "YanAn\,\ Shaanxi",
  861311927 => "YanAn\,\ Shaanxi",
  861311928 => "Yulin\,\ Shaanxi",
  861311929 => "Yulin\,\ Shaanxi",
  861311930 => "Lanzhou\,\ Gansu",
  861311931 => "Lanzhou\,\ Gansu",
  861311932 => "Dingxi\,\ Gansu",
  861311933 => "Pingliang\,\ Gansu",
  861311934 => "Qingyang\,\ Gansu",
  861311935 => "Wuwei\,\ Gansu",
  861311936 => "Zhangye\,\ Gansu",
  861311937 => "Jiuquan\,\ Gansu",
  861311938 => "Tianshui\,\ Gansu",
  861311939 => "Qingyang\,\ Gansu",
  861311940 => "Lanzhou\,\ Gansu",
  861311941 => "Lanzhou\,\ Gansu",
  861311942 => "Lanzhou\,\ Gansu",
  861311943 => "Lanzhou\,\ Gansu",
  861311944 => "Lanzhou\,\ Gansu",
  861311945 => "Jiuquan\,\ Gansu",
  861311946 => "Jiuquan\,\ Gansu",
  861311947 => "Pingliang\,\ Gansu",
  861311948 => "Wuwei\,\ Gansu",
  861311949 => "Qingyang\,\ Gansu",
  86131195 => "Guangzhou\,\ Guangdong",
  86131196 => "Jiangmen\,\ Guangdong",
  861311970 => "Haibei\,\ Qinghai",
  861311971 => "Xining\,\ Qinghai",
  861311972 => "Haidong\,\ Qinghai",
  861311973 => "Huangnan\,\ Qinghai",
  861311974 => "Hainan\,\ Qinghai",
  861311975 => "Haixi\,\ Qinghai",
  861311976 => "Xining\,\ Qinghai",
  861311977 => "Haixi\,\ Qinghai",
  861311978 => "Xining\,\ Qinghai",
  861311979 => "Haixi\,\ Qinghai",
  861311980 => "Shanwei\,\ Guangdong",
  861311981 => "Shanwei\,\ Guangdong",
  861311982 => "Shanwei\,\ Guangdong",
  861311983 => "Shanwei\,\ Guangdong",
  861311984 => "Shanwei\,\ Guangdong",
  861311985 => "Foshan\,\ Guangdong",
  861311986 => "Foshan\,\ Guangdong",
  861311987 => "Foshan\,\ Guangdong",
  861311988 => "Foshan\,\ Guangdong",
  861311989 => "Foshan\,\ Guangdong",
  861311990 => "Karamay\,\ Xinjiang",
  861311991 => "Urumchi\,\ Xinjiang",
  861311992 => "Ili\,\ Xinjiang",
  861311993 => "Shihezi\,\ Xinjiang",
  861311994 => "Changji\,\ Xinjiang",
  861311995 => "Turpan\,\ Xinjiang",
  861311996 => "Bayingolin\,\ Xinjiang",
  861311997 => "Aksu\,\ Xinjiang",
  861311998 => "Kashi\,\ Xinjiang",
  861311999 => "Ili\,\ Xinjiang",
  86131200 => "Beijing",
  86131201 => "Beijing",
  86131202 => "Beijing",
  86131203 => "Beijing",
  86131204 => "Beijing",
  86131205 => "Shanghai",
  86131206 => "Shanghai",
  86131207 => "Shanghai",
  86131208 => "Shanghai",
  86131209 => "Shanghai",
  86131210 => "Beijing",
  86131211 => "Beijing",
  86131212 => "Beijing",
  86131213 => "Beijing",
  861312140 => "Beijing",
  861312141 => "Beijing",
  861312142 => "Beijing",
  861312143 => "Beijing",
  861312144 => "Ordos\,\ Inner\ Mongolia",
  861312145 => "Beijing",
  861312146 => "Beijing",
  861312147 => "Beijing",
  861312148 => "Beijing",
  861312149 => "Beijing",
  86131215 => "Beijing",
  86131216 => "Beijing",
  861312170 => "Beijing",
  861312171 => "Beijing",
  861312172 => "Beijing",
  861312173 => "Beijing",
  861312174 => "Hinggan\,\ Inner\ Mongolia",
  861312175 => "Beijing",
  861312176 => "Beijing",
  861312177 => "Beijing",
  861312178 => "Beijing",
  861312179 => "Beijing",
  86131218 => "Beijing",
  86131219 => "Beijing",
  8613122 => "Shanghai",
  861312300 => "Quanzhou\,\ Fujian",
  861312301 => "Quanzhou\,\ Fujian",
  861312302 => "Quanzhou\,\ Fujian",
  861312303 => "Quanzhou\,\ Fujian",
  861312304 => "Sanming\,\ Fujian",
  861312305 => "Sanming\,\ Fujian",
  861312306 => "Sanming\,\ Fujian",
  861312307 => "Longyan\,\ Fujian",
  861312308 => "Longyan\,\ Fujian",
  861312309 => "Longyan\,\ Fujian",
  861312310 => "Quanzhou\,\ Fujian",
  861312311 => "Quanzhou\,\ Fujian",
  861312312 => "Quanzhou\,\ Fujian",
  861312313 => "Quanzhou\,\ Fujian",
  861312314 => "Ningde\,\ Fujian",
  861312315 => "Fuzhou\,\ Fujian",
  861312316 => "Fuzhou\,\ Fujian",
  861312317 => "Fuzhou\,\ Fujian",
  861312318 => "Fuzhou\,\ Fujian",
  861312319 => "Fuzhou\,\ Fujian",
  861312320 => "Nanping\,\ Fujian",
  861312321 => "Nanping\,\ Fujian",
  861312322 => "Nanping\,\ Fujian",
  861312323 => "Ningde\,\ Fujian",
  861312324 => "Zhengzhou\,\ Henan",
  861312325 => "Ningde\,\ Fujian",
  861312326 => "Ningde\,\ Fujian",
  861312327 => "Putian\,\ Fujian",
  861312328 => "Putian\,\ Fujian",
  861312329 => "Putian\,\ Fujian",
  861312330 => "Zhangzhou\,\ Fujian",
  861312331 => "Zhangzhou\,\ Fujian",
  861312332 => "Zhangzhou\,\ Fujian",
  861312333 => "Zhangzhou\,\ Fujian",
  861312334 => "Zhangzhou\,\ Fujian",
  861312335 => "Zhangzhou\,\ Fujian",
  861312336 => "Xiamen\,\ Fujian",
  861312337 => "Xiamen\,\ Fujian",
  861312338 => "Xiamen\,\ Fujian",
  861312339 => "Xiamen\,\ Fujian",
  861312340 => "Fangchenggang\,\ Guangxi",
  861312341 => "Nanning\,\ Guangxi",
  861312342 => "Liuzhou\,\ Guangxi",
  861312343 => "Guilin\,\ Guangxi",
  861312344 => "Guigang\,\ Guangxi",
  861312345 => "Yulin\,\ Guangxi",
  861312346 => "Baise\,\ Guangxi",
  861312347 => "Qinzhou\,\ Guangxi",
  861312348 => "Hechi\,\ Guangxi",
  861312349 => "Beihai\,\ Guangxi",
  861312350 => "Fangchenggang\,\ Guangxi",
  861312351 => "Nanning\,\ Guangxi",
  861312352 => "Liuzhou\,\ Guangxi",
  861312353 => "Guilin\,\ Guangxi",
  861312354 => "Wuzhou\,\ Guangxi",
  861312355 => "Yulin\,\ Guangxi",
  861312356 => "Baise\,\ Guangxi",
  861312357 => "Hezhou\,\ Guangxi",
  861312358 => "Hechi\,\ Guangxi",
  861312359 => "Beihai\,\ Guangxi",
  861312360 => "Guiyang\,\ Guizhou",
  861312361 => "Guiyang\,\ Guizhou",
  861312362 => "Zunyi\,\ Guizhou",
  861312363 => "Anshun\,\ Guizhou",
  861312364 => "Qiannan\,\ Guizhou",
  861312365 => "Qiandongnan\,\ Guizhou",
  861312366 => "Tongren\,\ Guizhou",
  861312367 => "Bijie\,\ Guizhou",
  861312368 => "Liupanshui\,\ Guizhou",
  861312369 => "Qianxinan\,\ Guizhou",
  86131237 => "Zhumadian\,\ Henan",
  86131238 => "Ningbo\,\ Zhejiang",
  861312390 => "Hangzhou\,\ Zhejiang",
  861312391 => "Hangzhou\,\ Zhejiang",
  861312392 => "Hangzhou\,\ Zhejiang",
  861312393 => "Hangzhou\,\ Zhejiang",
  861312394 => "Hangzhou\,\ Zhejiang",
  861312395 => "Hangzhou\,\ Zhejiang",
  861312396 => "Kashi\,\ Xinjiang",
  861312397 => "Wenzhou\,\ Zhejiang",
  861312398 => "Wenzhou\,\ Zhejiang",
  861312399 => "Wenzhou\,\ Zhejiang",
  861312400 => "Fuzhou\,\ Fujian",
  861312401 => "Fuzhou\,\ Fujian",
  861312402 => "Fuzhou\,\ Fujian",
  861312403 => "Xinyang\,\ Henan",
  861312404 => "Longyan\,\ Fujian",
  861312405 => "Jiaozuo\,\ Henan",
  861312406 => "Putian\,\ Fujian",
  861312407 => "Xiamen\,\ Fujian",
  861312408 => "Xiamen\,\ Fujian",
  861312409 => "Xiamen\,\ Fujian",
  861312410 => "Dalian\,\ Liaoning",
  861312411 => "Dalian\,\ Liaoning",
  861312412 => "Anshan\,\ Liaoning",
  861312413 => "Fushun\,\ Liaoning",
  861312414 => "Benxi\,\ Liaoning",
  861312415 => "Dandong\,\ Liaoning",
  861312416 => "Jinzhou\,\ Liaoning",
  861312417 => "Yingkou\,\ Liaoning",
  861312418 => "Fuxin\,\ Liaoning",
  861312419 => "Liaoyang\,\ Liaoning",
  861312420 => "Shenyang\,\ Liaoning",
  861312421 => "Shenyang\,\ Liaoning",
  861312422 => "Shenyang\,\ Liaoning",
  861312423 => "Shenyang\,\ Liaoning",
  861312424 => "Shenyang\,\ Liaoning",
  861312425 => "Shenyang\,\ Liaoning",
  861312426 => "Shenyang\,\ Liaoning",
  861312427 => "Dalian\,\ Liaoning",
  861312428 => "Dalian\,\ Liaoning",
  861312429 => "Yingkou\,\ Liaoning",
  861312430 => "Jilin\,\ Jilin",
  861312431 => "Jilin\,\ Jilin",
  861312432 => "Jilin\,\ Jilin",
  861312433 => "Yanbian\,\ Jilin",
  861312434 => "Jilin\,\ Jilin",
  861312435 => "Tonghua\,\ Jilin",
  861312436 => "Baicheng\,\ Jilin",
  861312437 => "Liaoyuan\,\ Jilin",
  861312438 => "Songyuan\,\ Jilin",
  861312439 => "Baishan\,\ Jilin",
  861312440 => "Kaifeng\,\ Henan",
  861312441 => "Anyang\,\ Henan",
  861312442 => "Anyang\,\ Henan",
  861312443 => "Anyang\,\ Henan",
  861312444 => "Puyang\,\ Henan",
  861312445 => "Xiamen\,\ Fujian",
  861312446 => "Quanzhou\,\ Fujian",
  861312447 => "Quanzhou\,\ Fujian",
  861312448 => "Ningde\,\ Fujian",
  861312449 => "Ningde\,\ Fujian",
  861312450 => "Harbin\,\ Heilongjiang",
  861312451 => "Harbin\,\ Heilongjiang",
  861312452 => "Qiqihar\,\ Heilongjiang",
  861312453 => "Mudanjiang\,\ Heilongjiang",
  861312454 => "Jiamusi\,\ Heilongjiang",
  861312455 => "Suihua\,\ Heilongjiang",
  861312456 => "Heihe\,\ Heilongjiang",
  861312457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861312458 => "Yichun\,\ Heilongjiang",
  861312459 => "Daqing\,\ Heilongjiang",
  861312460 => "Guiyang\,\ Guizhou",
  861312461 => "Guiyang\,\ Guizhou",
  861312462 => "Zunyi\,\ Guizhou",
  861312463 => "Anshun\,\ Guizhou",
  861312464 => "Zunyi\,\ Guizhou",
  861312465 => "Qiandongnan\,\ Guizhou",
  861312466 => "Qiannan\,\ Guizhou",
  861312467 => "Guiyang\,\ Guizhou",
  861312468 => "Liupanshui\,\ Guizhou",
  861312469 => "Qiandongnan\,\ Guizhou",
  86131247 => "Beijing",
  86131248 => "Shanghai",
  86131249 => "Zhanjiang\,\ Guangdong",
  86131250 => "Wuhan\,\ Hubei",
  86131251 => "Wuhan\,\ Hubei",
  861312520 => "Jiujiang\,\ Jiangxi",
  861312521 => "Nanchang\,\ Jiangxi",
  861312522 => "Jiujiang\,\ Jiangxi",
  861312523 => "Shangrao\,\ Jiangxi",
  861312524 => "Fuzhou\,\ Jiangxi",
  861312525 => "Yichun\,\ Jiangxi",
  861312526 => "JiAn\,\ Jiangxi",
  861312527 => "Ganzhou\,\ Jiangxi",
  861312528 => "Jingdezhen\,\ Jiangxi",
  861312529 => "Pingxiang\,\ Jiangxi",
  861312530 => "Shangrao\,\ Jiangxi",
  861312531 => "Shangrao\,\ Jiangxi",
  861312532 => "Fuzhou\,\ Jiangxi",
  861312533 => "Fuzhou\,\ Jiangxi",
  861312534 => "JiAn\,\ Jiangxi",
  861312535 => "JiAn\,\ Jiangxi",
  861312536 => "Ganzhou\,\ Jiangxi",
  861312537 => "Ganzhou\,\ Jiangxi",
  861312538 => "Ganzhou\,\ Jiangxi",
  861312539 => "Ganzhou\,\ Jiangxi",
  861312540 => "Shenyang\,\ Liaoning",
  861312541 => "Shenyang\,\ Liaoning",
  861312542 => "Shenyang\,\ Liaoning",
  861312543 => "Shenyang\,\ Liaoning",
  861312544 => "Shenyang\,\ Liaoning",
  861312545 => "Dalian\,\ Liaoning",
  861312546 => "Dalian\,\ Liaoning",
  861312547 => "Dalian\,\ Liaoning",
  861312548 => "Dalian\,\ Liaoning",
  861312549 => "Dalian\,\ Liaoning",
  861312550 => "Anshan\,\ Liaoning",
  861312551 => "Fushun\,\ Liaoning",
  861312552 => "Fushun\,\ Liaoning",
  861312553 => "Benxi\,\ Liaoning",
  861312554 => "Benxi\,\ Liaoning",
  861312555 => "Benxi\,\ Liaoning",
  861312556 => "Dandong\,\ Liaoning",
  861312557 => "Dandong\,\ Liaoning",
  861312558 => "Dandong\,\ Liaoning",
  861312559 => "Dandong\,\ Liaoning",
  861312560 => "Jinzhou\,\ Liaoning",
  861312561 => "Yingkou\,\ Liaoning",
  861312562 => "Yingkou\,\ Liaoning",
  861312563 => "Yingkou\,\ Liaoning",
  861312564 => "Yingkou\,\ Liaoning",
  861312565 => "Fuxin\,\ Liaoning",
  861312566 => "Fuxin\,\ Liaoning",
  861312567 => "Liaoyang\,\ Liaoning",
  861312568 => "Liaoyang\,\ Liaoning",
  861312569 => "Liaoyang\,\ Liaoning",
  861312570 => "Changchun\,\ Jilin",
  861312571 => "Jilin\,\ Jilin",
  861312572 => "Jilin\,\ Jilin",
  861312573 => "Yanbian\,\ Jilin",
  861312574 => "Changchun\,\ Jilin",
  861312575 => "Tonghua\,\ Jilin",
  861312576 => "Baicheng\,\ Jilin",
  861312577 => "Liaoyuan\,\ Jilin",
  861312578 => "Songyuan\,\ Jilin",
  861312579 => "Baishan\,\ Jilin",
  861312580 => "Changchun\,\ Jilin",
  861312581 => "Changchun\,\ Jilin",
  861312582 => "Changchun\,\ Jilin",
  861312583 => "Siping\,\ Jilin",
  861312584 => "Jilin\,\ Jilin",
  861312585 => "Tonghua\,\ Jilin",
  861312586 => "Baicheng\,\ Jilin",
  861312587 => "Liaoyuan\,\ Jilin",
  861312588 => "Jilin\,\ Jilin",
  861312589 => "Tonghua\,\ Jilin",
  861312590 => "Harbin\,\ Heilongjiang",
  861312591 => "Harbin\,\ Heilongjiang",
  861312592 => "Harbin\,\ Heilongjiang",
  861312593 => "Mudanjiang\,\ Heilongjiang",
  861312594 => "Daqing\,\ Heilongjiang",
  861312595 => "Suihua\,\ Heilongjiang",
  861312596 => "Suihua\,\ Heilongjiang",
  861312597 => "Jixi\,\ Heilongjiang",
  861312598 => "Harbin\,\ Heilongjiang",
  861312599 => "Daqing\,\ Heilongjiang",
  86131260 => "Maoming\,\ Guangdong",
  861312610 => "Shijiazhuang\,\ Hebei",
  861312611 => "Shijiazhuang\,\ Hebei",
  861312612 => "Shijiazhuang\,\ Hebei",
  861312613 => "Shijiazhuang\,\ Hebei",
  861312614 => "Shijiazhuang\,\ Hebei",
  861312615 => "Shijiazhuang\,\ Hebei",
  861312616 => "Shijiazhuang\,\ Hebei",
  861312617 => "Meizhou\,\ Guangdong",
  861312618 => "Shijiazhuang\,\ Hebei",
  861312619 => "Shijiazhuang\,\ Hebei",
  86131262 => "Jiangmen\,\ Guangdong",
  86131263 => "Huizhou\,\ Guangdong",
  86131264 => "Guangzhou\,\ Guangdong",
  861312650 => "Beijing",
  861312651 => "Beijing",
  861312652 => "Beijing",
  861312653 => "Beijing",
  861312654 => "Tongliao\,\ Inner\ Mongolia",
  861312655 => "Beijing",
  861312656 => "Beijing",
  861312657 => "Beijing",
  861312658 => "Beijing",
  861312659 => "Beijing",
  86131266 => "Beijing",
  861312670 => "Beijing",
  861312671 => "Beijing",
  861312672 => "Beijing",
  861312673 => "Beijing",
  861312674 => "Hinggan\,\ Inner\ Mongolia",
  861312675 => "Beijing",
  861312676 => "Beijing",
  861312677 => "Beijing",
  861312678 => "Beijing",
  861312679 => "Beijing",
  861312680 => "Beijing",
  861312681 => "Beijing",
  861312682 => "Beijing",
  861312683 => "Beijing",
  861312684 => "Bayannur\,\ Inner\ Mongolia",
  861312685 => "Beijing",
  861312686 => "Beijing",
  861312687 => "Beijing",
  861312688 => "Beijing",
  861312689 => "Beijing",
  861312690 => "Beijing",
  861312691 => "Beijing",
  861312692 => "Beijing",
  861312693 => "Beijing",
  861312694 => "Ordos\,\ Inner\ Mongolia",
  861312695 => "Beijing",
  861312696 => "Beijing",
  861312697 => "Beijing",
  861312698 => "Beijing",
  861312699 => "Beijing",
  861312700 => "Qingdao\,\ Shandong",
  861312701 => "Qingdao\,\ Shandong",
  861312702 => "Qingdao\,\ Shandong",
  861312703 => "Qingdao\,\ Shandong",
  861312704 => "Qingdao\,\ Shandong",
  861312705 => "Qingdao\,\ Shandong",
  861312706 => "Qingdao\,\ Shandong",
  861312707 => "Yantai\,\ Shandong",
  861312708 => "Yantai\,\ Shandong",
  861312709 => "Rizhao\,\ Shandong",
  861312710 => "Jinan\,\ Shandong",
  861312711 => "Jinan\,\ Shandong",
  861312712 => "Jinan\,\ Shandong",
  861312713 => "Jinan\,\ Shandong",
  861312714 => "Jinan\,\ Shandong",
  861312715 => "Jinan\,\ Shandong",
  861312716 => "Weifang\,\ Shandong",
  861312717 => "Weifang\,\ Shandong",
  861312718 => "Weifang\,\ Shandong",
  861312719 => "Dongying\,\ Shandong",
  861312720 => "Zibo\,\ Shandong",
  861312721 => "Zaozhuang\,\ Shandong",
  861312722 => "Zaozhuang\,\ Shandong",
  861312723 => "Zaozhuang\,\ Shandong",
  861312724 => "Dongying\,\ Shandong",
  861312725 => "Dongying\,\ Shandong",
  861312726 => "Laiwu\,\ Shandong",
  861312727 => "TaiAn\,\ Shandong",
  861312728 => "TaiAn\,\ Shandong",
  861312729 => "Linyi\,\ Shandong",
  86131273 => "Cangzhou\,\ Hebei",
  86131274 => "Baoding\,\ Hebei",
  86131275 => "Shanghai",
  86131276 => "Shanghai",
  86131277 => "Shanghai",
  86131278 => "Shanghai",
  86131279 => "Shanghai",
  86131280 => "Dongguan\,\ Guangdong",
  86131281 => "Dongguan\,\ Guangdong",
  86131282 => "Guangzhou\,\ Guangdong",
  86131283 => "Jieyang\,\ Guangdong",
  861312840 => "Chaozhou\,\ Guangdong",
  861312841 => "Chaozhou\,\ Guangdong",
  861312842 => "Chaozhou\,\ Guangdong",
  861312843 => "Shantou\,\ Guangdong",
  861312844 => "Shantou\,\ Guangdong",
  861312845 => "Shantou\,\ Guangdong",
  861312846 => "Shantou\,\ Guangdong",
  861312847 => "Shantou\,\ Guangdong",
  861312848 => "Shantou\,\ Guangdong",
  861312849 => "Shantou\,\ Guangdong",
  86131285 => "Zhuhai\,\ Guangdong",
  86131286 => "Guangzhou\,\ Guangdong",
  86131287 => "Shenzhen\,\ Guangdong",
  86131288 => "Shenzhen\,\ Guangdong",
  86131289 => "Shenzhen\,\ Guangdong",
  86131290 => "Foshan\,\ Guangdong",
  86131291 => "Foshan\,\ Guangdong",
  86131292 => "Zhongshan\,\ Guangdong",
  86131293 => "Guangzhou\,\ Guangdong",
  86131294 => "Dongguan\,\ Guangdong",
  86131295 => "Shenzhen\,\ Guangdong",
  86131296 => "Shantou\,\ Guangdong",
  86131297 => "Zhaoqing\,\ Guangdong",
  86131298 => "Dongguan\,\ Guangdong",
  86131299 => "Wuhan\,\ Hubei",
  861313000 => "Dalian\,\ Liaoning",
  861313001 => "Dalian\,\ Liaoning",
  861313002 => "Dalian\,\ Liaoning",
  861313003 => "Dalian\,\ Liaoning",
  861313004 => "Dalian\,\ Liaoning",
  861313005 => "Anshan\,\ Liaoning",
  861313006 => "Anshan\,\ Liaoning",
  861313007 => "Anshan\,\ Liaoning",
  861313008 => "Anshan\,\ Liaoning",
  861313009 => "Anshan\,\ Liaoning",
  861313010 => "Benxi\,\ Liaoning",
  861313011 => "Benxi\,\ Liaoning",
  861313012 => "Benxi\,\ Liaoning",
  861313013 => "Benxi\,\ Liaoning",
  861313014 => "Benxi\,\ Liaoning",
  861313015 => "Anshan\,\ Liaoning",
  861313016 => "Anshan\,\ Liaoning",
  861313017 => "Anshan\,\ Liaoning",
  861313018 => "Anshan\,\ Liaoning",
  861313019 => "Anshan\,\ Liaoning",
  86131302 => "Shenyang\,\ Liaoning",
  861313030 => "Fushun\,\ Liaoning",
  861313031 => "Fushun\,\ Liaoning",
  861313032 => "Fushun\,\ Liaoning",
  861313033 => "Fushun\,\ Liaoning",
  861313034 => "Fushun\,\ Liaoning",
  861313035 => "Fushun\,\ Liaoning",
  861313036 => "Fushun\,\ Liaoning",
  861313037 => "Fushun\,\ Liaoning",
  861313038 => "Benxi\,\ Liaoning",
  861313039 => "Benxi\,\ Liaoning",
  86131304 => "Dalian\,\ Liaoning",
  861313050 => "Dandong\,\ Liaoning",
  861313051 => "Dandong\,\ Liaoning",
  861313052 => "Dandong\,\ Liaoning",
  861313053 => "Dandong\,\ Liaoning",
  861313054 => "Dandong\,\ Liaoning",
  861313055 => "Yingkou\,\ Liaoning",
  861313056 => "Yingkou\,\ Liaoning",
  861313057 => "Yingkou\,\ Liaoning",
  861313058 => "Yingkou\,\ Liaoning",
  861313059 => "Yingkou\,\ Liaoning",
  861313060 => "Jinzhou\,\ Liaoning",
  861313061 => "Jinzhou\,\ Liaoning",
  861313062 => "Jinzhou\,\ Liaoning",
  861313063 => "Jinzhou\,\ Liaoning",
  861313064 => "Jinzhou\,\ Liaoning",
  861313065 => "Jinzhou\,\ Liaoning",
  861313066 => "Jinzhou\,\ Liaoning",
  861313067 => "Fuxin\,\ Liaoning",
  861313068 => "Fuxin\,\ Liaoning",
  861313069 => "Fuxin\,\ Liaoning",
  861313070 => "Liaoyang\,\ Liaoning",
  861313071 => "Liaoyang\,\ Liaoning",
  861313072 => "Liaoyang\,\ Liaoning",
  861313073 => "Liaoyang\,\ Liaoning",
  861313074 => "Liaoyang\,\ Liaoning",
  861313075 => "Liaoyang\,\ Liaoning",
  861313076 => "Liaoyang\,\ Liaoning",
  861313077 => "Tieling\,\ Liaoning",
  861313078 => "Tieling\,\ Liaoning",
  861313079 => "Tieling\,\ Liaoning",
  861313080 => "Chaoyang\,\ Liaoning",
  861313081 => "Chaoyang\,\ Liaoning",
  861313082 => "Chaoyang\,\ Liaoning",
  861313083 => "Chaoyang\,\ Liaoning",
  861313084 => "Chaoyang\,\ Liaoning",
  861313085 => "Chaoyang\,\ Liaoning",
  861313086 => "Chaoyang\,\ Liaoning",
  861313087 => "Fuxin\,\ Liaoning",
  861313088 => "Panjin\,\ Liaoning",
  861313089 => "Tieling\,\ Liaoning",
  861313090 => "Panjin\,\ Liaoning",
  861313091 => "Panjin\,\ Liaoning",
  861313092 => "Panjin\,\ Liaoning",
  861313093 => "Panjin\,\ Liaoning",
  861313094 => "Panjin\,\ Liaoning",
  861313095 => "Huludao\,\ Liaoning",
  861313096 => "Huludao\,\ Liaoning",
  861313097 => "Huludao\,\ Liaoning",
  861313098 => "Huludao\,\ Liaoning",
  861313099 => "Huludao\,\ Liaoning",
  86131310 => "Handan\,\ Hebei",
  86131311 => "Shijiazhuang\,\ Hebei",
  86131312 => "Baoding\,\ Hebei",
  86131313 => "Zhangjiakou\,\ Hebei",
  86131314 => "Chengde\,\ Hebei",
  86131315 => "Tangshan\,\ Hebei",
  86131316 => "Langfang\,\ Hebei",
  86131317 => "Cangzhou\,\ Hebei",
  86131318 => "Hengshui\,\ Hebei",
  86131319 => "Xingtai\,\ Hebei",
  86131320 => "Tianjin",
  86131321 => "Tianjin",
  86131322 => "Tianjin",
  86131323 => "Chongqing",
  861313240 => "Hengshui\,\ Hebei",
  861313241 => "Hengshui\,\ Hebei",
  861313242 => "Hengshui\,\ Hebei",
  861313243 => "Hengshui\,\ Hebei",
  861313244 => "Hengshui\,\ Hebei",
  861313245 => "Xingtai\,\ Hebei",
  861313246 => "Xingtai\,\ Hebei",
  861313247 => "Xingtai\,\ Hebei",
  861313248 => "Xingtai\,\ Hebei",
  861313249 => "Xingtai\,\ Hebei",
  86131325 => "Tianjin",
  861313260 => "Nanning\,\ Guangxi",
  861313261 => "Nanning\,\ Guangxi",
  861313262 => "Liuzhou\,\ Guangxi",
  861313263 => "Guilin\,\ Guangxi",
  861313264 => "Guilin\,\ Guangxi",
  861313265 => "Yulin\,\ Guangxi",
  861313266 => "Guigang\,\ Guangxi",
  861313267 => "Qinzhou\,\ Guangxi",
  861313268 => "Hechi\,\ Guangxi",
  861313269 => "Beihai\,\ Guangxi",
  861313270 => "Hechi\,\ Guangxi",
  861313271 => "Nanning\,\ Guangxi",
  861313272 => "Liuzhou\,\ Guangxi",
  861313273 => "Guilin\,\ Guangxi",
  861313274 => "Wuzhou\,\ Guangxi",
  861313275 => "Yulin\,\ Guangxi",
  861313276 => "Baise\,\ Guangxi",
  861313277 => "Qinzhou\,\ Guangxi",
  861313278 => "Hechi\,\ Guangxi",
  861313279 => "Beihai\,\ Guangxi",
  861313280 => "Hechi\,\ Guangxi",
  861313281 => "Nanning\,\ Guangxi",
  861313282 => "Liuzhou\,\ Guangxi",
  861313283 => "Guilin\,\ Guangxi",
  861313284 => "Guigang\,\ Guangxi",
  861313285 => "Yulin\,\ Guangxi",
  861313286 => "Baise\,\ Guangxi",
  861313287 => "Hezhou\,\ Guangxi",
  861313288 => "Guigang\,\ Guangxi",
  861313289 => "Guigang\,\ Guangxi",
  861313290 => "Nanning\,\ Guangxi",
  861313291 => "Nanning\,\ Guangxi",
  861313292 => "Liuzhou\,\ Guangxi",
  861313293 => "Guilin\,\ Guangxi",
  861313294 => "Hezhou\,\ Guangxi",
  861313295 => "Yulin\,\ Guangxi",
  861313296 => "Baise\,\ Guangxi",
  861313297 => "Guilin\,\ Guangxi",
  861313298 => "Hechi\,\ Guangxi",
  861313299 => "Guigang\,\ Guangxi",
  861313300 => "Taiyuan\,\ Shanxi",
  861313301 => "Taiyuan\,\ Shanxi",
  861313302 => "Taiyuan\,\ Shanxi",
  861313303 => "Shuozhou\,\ Shanxi",
  861313304 => "Jinzhong\,\ Shanxi",
  861313305 => "Changzhi\,\ Shanxi",
  861313306 => "Jincheng\,\ Shanxi",
  861313307 => "Linfen\,\ Shanxi",
  861313308 => "Lüliang\,\ Shanxi",
  861313309 => "Yuncheng\,\ Shanxi",
  861313310 => "Xinzhou\,\ Shanxi",
  861313311 => "Shuozhou\,\ Shanxi",
  861313312 => "Datong\,\ Shanxi",
  861313313 => "Yangquan\,\ Shanxi",
  861313314 => "Yuncheng\,\ Shanxi",
  861313315 => "Changzhi\,\ Shanxi",
  861313316 => "Jincheng\,\ Shanxi",
  861313317 => "Linfen\,\ Shanxi",
  861313318 => "Linfen\,\ Shanxi",
  861313319 => "Yuncheng\,\ Shanxi",
  861313320 => "Xinzhou\,\ Shanxi",
  861313321 => "Jinzhong\,\ Shanxi",
  861313322 => "Datong\,\ Shanxi",
  861313323 => "Yangquan\,\ Shanxi",
  861313324 => "Lüliang\,\ Shanxi",
  861313325 => "Changzhi\,\ Shanxi",
  861313326 => "Linfen\,\ Shanxi",
  861313327 => "Linfen\,\ Shanxi",
  861313328 => "Datong\,\ Shanxi",
  861313329 => "Yuncheng\,\ Shanxi",
  861313330 => "Jinzhong\,\ Shanxi",
  861313331 => "Jinzhong\,\ Shanxi",
  861313332 => "Datong\,\ Shanxi",
  861313333 => "Datong\,\ Shanxi",
  861313334 => "Xinzhou\,\ Shanxi",
  861313335 => "Changzhi\,\ Shanxi",
  861313336 => "Jincheng\,\ Shanxi",
  861313337 => "Jincheng\,\ Shanxi",
  861313338 => "Lüliang\,\ Shanxi",
  861313339 => "Yuncheng\,\ Shanxi",
  861313340 => "Xinzhou\,\ Shanxi",
  861313341 => "Yuncheng\,\ Shanxi",
  861313342 => "Datong\,\ Shanxi",
  861313343 => "Yangquan\,\ Shanxi",
  861313344 => "Jinzhong\,\ Shanxi",
  861313345 => "Changzhi\,\ Shanxi",
  861313346 => "Jincheng\,\ Shanxi",
  861313347 => "Linfen\,\ Shanxi",
  861313348 => "Lüliang\,\ Shanxi",
  861313349 => "Shuozhou\,\ Shanxi",
  86131335 => "Qinhuangdao\,\ Hebei",
  861313360 => "Shangrao\,\ Jiangxi",
  861313361 => "Shangrao\,\ Jiangxi",
  861313362 => "Yingtan\,\ Jiangxi",
  861313363 => "Jiujiang\,\ Jiangxi",
  861313364 => "Jiujiang\,\ Jiangxi",
  861313365 => "Jiujiang\,\ Jiangxi",
  861313366 => "Jiujiang\,\ Jiangxi",
  861313367 => "JiAn\,\ Jiangxi",
  861313368 => "JiAn\,\ Jiangxi",
  861313369 => "JiAn\,\ Jiangxi",
  861313370 => "Fuzhou\,\ Jiangxi",
  861313371 => "Fuzhou\,\ Jiangxi",
  861313372 => "Fuzhou\,\ Jiangxi",
  861313373 => "Fuzhou\,\ Jiangxi",
  861313374 => "Ganzhou\,\ Jiangxi",
  861313375 => "Ganzhou\,\ Jiangxi",
  861313376 => "Ganzhou\,\ Jiangxi",
  861313377 => "Ganzhou\,\ Jiangxi",
  861313378 => "Yichun\,\ Jiangxi",
  861313379 => "Yichun\,\ Jiangxi",
  861313380 => "Nanchang\,\ Jiangxi",
  861313381 => "Nanchang\,\ Jiangxi",
  861313382 => "Nanchang\,\ Jiangxi",
  861313383 => "Nanchang\,\ Jiangxi",
  861313384 => "Nanchang\,\ Jiangxi",
  861313385 => "Yichun\,\ Jiangxi",
  861313386 => "Pingxiang\,\ Jiangxi",
  861313387 => "Pingxiang\,\ Jiangxi",
  861313388 => "Jingdezhen\,\ Jiangxi",
  861313389 => "Jingdezhen\,\ Jiangxi",
  861313390 => "Xinyu\,\ Jiangxi",
  861313391 => "Nanchang\,\ Jiangxi",
  861313392 => "Jiujiang\,\ Jiangxi",
  861313393 => "Shangrao\,\ Jiangxi",
  861313394 => "Fuzhou\,\ Jiangxi",
  861313395 => "Yichun\,\ Jiangxi",
  861313396 => "JiAn\,\ Jiangxi",
  861313397 => "Ganzhou\,\ Jiangxi",
  861313398 => "Jingdezhen\,\ Jiangxi",
  861313399 => "Pingxiang\,\ Jiangxi",
  861313400 => "Yichun\,\ Jiangxi",
  861313401 => "Jiujiang\,\ Jiangxi",
  861313402 => "Ganzhou\,\ Jiangxi",
  861313403 => "Fuzhou\,\ Jiangxi",
  861313404 => "Jingdezhen\,\ Jiangxi",
  861313405 => "Jingdezhen\,\ Jiangxi",
  861313406 => "JiAn\,\ Jiangxi",
  861313407 => "JiAn\,\ Jiangxi",
  861313408 => "Pingxiang\,\ Jiangxi",
  861313409 => "Pingxiang\,\ Jiangxi",
  861313410 => "Tieling\,\ Liaoning",
  861313411 => "Dalian\,\ Liaoning",
  861313412 => "Anshan\,\ Liaoning",
  861313413 => "Fushun\,\ Liaoning",
  861313414 => "Benxi\,\ Liaoning",
  861313415 => "Dandong\,\ Liaoning",
  861313416 => "Jinzhou\,\ Liaoning",
  861313417 => "Yingkou\,\ Liaoning",
  861313418 => "Fuxin\,\ Liaoning",
  861313419 => "Liaoyang\,\ Liaoning",
  861313420 => "Shenyang\,\ Liaoning",
  861313421 => "Chaoyang\,\ Liaoning",
  861313422 => "Shenyang\,\ Liaoning",
  861313423 => "Shenyang\,\ Liaoning",
  861313424 => "Shenyang\,\ Liaoning",
  861313425 => "Anshan\,\ Liaoning",
  861313426 => "Dalian\,\ Liaoning",
  861313427 => "Panjin\,\ Liaoning",
  861313428 => "Dalian\,\ Liaoning",
  861313429 => "Huludao\,\ Liaoning",
  861313430 => "Changchun\,\ Jilin",
  861313431 => "Changchun\,\ Jilin",
  861313432 => "Jilin\,\ Jilin",
  861313433 => "Yanbian\,\ Jilin",
  861313434 => "Siping\,\ Jilin",
  861313435 => "Tonghua\,\ Jilin",
  861313436 => "Baicheng\,\ Jilin",
  861313437 => "Liaoyuan\,\ Jilin",
  861313438 => "Songyuan\,\ Jilin",
  861313439 => "Baishan\,\ Jilin",
  861313440 => "Jilin\,\ Jilin",
  861313441 => "Jilin\,\ Jilin",
  861313442 => "Jilin\,\ Jilin",
  861313443 => "Changchun\,\ Jilin",
  861313444 => "Jilin\,\ Jilin",
  861313445 => "Changchun\,\ Jilin",
  861313446 => "Changchun\,\ Jilin",
  861313447 => "Changchun\,\ Jilin",
  861313448 => "Changchun\,\ Jilin",
  861313449 => "Changchun\,\ Jilin",
  861313450 => "Harbin\,\ Heilongjiang",
  861313451 => "Harbin\,\ Heilongjiang",
  861313452 => "Qiqihar\,\ Heilongjiang",
  861313453 => "Mudanjiang\,\ Heilongjiang",
  861313454 => "Jiamusi\,\ Heilongjiang",
  861313455 => "Suihua\,\ Heilongjiang",
  861313456 => "Heihe\,\ Heilongjiang",
  861313457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861313458 => "Yichun\,\ Heilongjiang",
  861313459 => "Daqing\,\ Heilongjiang",
  861313460 => "Xinzhou\,\ Shanxi",
  861313461 => "Shuozhou\,\ Shanxi",
  861313462 => "Datong\,\ Shanxi",
  861313463 => "Yangquan\,\ Shanxi",
  861313464 => "Lüliang\,\ Shanxi",
  861313465 => "Changzhi\,\ Shanxi",
  861313466 => "Jincheng\,\ Shanxi",
  861313467 => "Linfen\,\ Shanxi",
  861313468 => "Jinzhong\,\ Shanxi",
  861313469 => "Yuncheng\,\ Shanxi",
  861313470 => "Hulun\,\ Inner\ Mongolia",
  861313471 => "Hohhot\,\ Inner\ Mongolia",
  861313472 => "Baotou\,\ Inner\ Mongolia",
  861313473 => "Wuhai\,\ Inner\ Mongolia",
  861313474 => "Hinggan\,\ Inner\ Mongolia",
  861313475 => "Tongliao\,\ Inner\ Mongolia",
  861313476 => "Chifeng\,\ Inner\ Mongolia",
  861313477 => "Ordos\,\ Inner\ Mongolia",
  861313478 => "Bayannur\,\ Inner\ Mongolia",
  861313479 => "Xilin\,\ Inner\ Mongolia",
  861313480 => "Bayannur\,\ Inner\ Mongolia",
  861313481 => "Bayannur\,\ Inner\ Mongolia",
  861313482 => "Hinggan\,\ Inner\ Mongolia",
  861313483 => "Alxa\,\ Inner\ Mongolia",
  861313484 => "Ordos\,\ Inner\ Mongolia",
  861313485 => "Ordos\,\ Inner\ Mongolia",
  861313486 => "Ordos\,\ Inner\ Mongolia",
  861313487 => "Ordos\,\ Inner\ Mongolia",
  861313488 => "Ordos\,\ Inner\ Mongolia",
  861313489 => "Baotou\,\ Inner\ Mongolia",
  861313490 => "Hulun\,\ Inner\ Mongolia",
  861313491 => "Hulun\,\ Inner\ Mongolia",
  861313492 => "Hulun\,\ Inner\ Mongolia",
  861313493 => "Hulun\,\ Inner\ Mongolia",
  861313494 => "Hulun\,\ Inner\ Mongolia",
  861313495 => "Hulun\,\ Inner\ Mongolia",
  861313496 => "Hulun\,\ Inner\ Mongolia",
  861313497 => "Hulun\,\ Inner\ Mongolia",
  861313498 => "Wuhai\,\ Inner\ Mongolia",
  861313499 => "Xilin\,\ Inner\ Mongolia",
  861313500 => "Yueyang\,\ Hunan",
  861313501 => "Changsha\,\ Hunan",
  861313502 => "Xiangtan\,\ Hunan",
  861313503 => "Zhuzhou\,\ Hunan",
  861313504 => "Hengyang\,\ Hunan",
  861313505 => "Chenzhou\,\ Hunan",
  861313506 => "Changde\,\ Hunan",
  861313507 => "Yiyang\,\ Hunan",
  861313508 => "Shaoyang\,\ Hunan",
  861313509 => "Xiangxi\,\ Hunan",
  861313510 => "Yueyang\,\ Hunan",
  861313511 => "Changsha\,\ Hunan",
  861313512 => "Xiangtan\,\ Hunan",
  861313513 => "Zhuzhou\,\ Hunan",
  861313514 => "Xiangxi\,\ Hunan",
  861313515 => "Chenzhou\,\ Hunan",
  861313516 => "Yiyang\,\ Hunan",
  861313517 => "Yiyang\,\ Hunan",
  861313518 => "Hengyang\,\ Hunan",
  861313519 => "Shaoyang\,\ Hunan",
  861313520 => "Xiangxi\,\ Hunan",
  861313521 => "Changsha\,\ Hunan",
  861313522 => "Yongzhou\,\ Hunan",
  861313523 => "Zhangjiajie\,\ Hunan",
  861313524 => "Loudi\,\ Hunan",
  861313525 => "Huaihua\,\ Hunan",
  861313526 => "Huaihua\,\ Hunan",
  861313527 => "Yongzhou\,\ Hunan",
  861313528 => "Changsha\,\ Hunan",
  861313529 => "Shaoyang\,\ Hunan",
  861313530 => "Yueyang\,\ Hunan",
  861313531 => "Changsha\,\ Hunan",
  861313532 => "Xiangtan\,\ Hunan",
  861313533 => "Zhuzhou\,\ Hunan",
  861313534 => "Hengyang\,\ Hunan",
  861313535 => "Chenzhou\,\ Hunan",
  861313536 => "Changde\,\ Hunan",
  861313537 => "Yiyang\,\ Hunan",
  861313538 => "Loudi\,\ Hunan",
  861313539 => "Shaoyang\,\ Hunan",
  861313540 => "Hefei\,\ Anhui",
  861313541 => "Fuyang\,\ Anhui",
  861313542 => "LuAn\,\ Anhui",
  861313543 => "Xuancheng\,\ Anhui",
  861313544 => "MaAnshan\,\ Anhui",
  861313545 => "Chuzhou\,\ Anhui",
  861313546 => "Huaibei\,\ Anhui",
  861313547 => "Bozhou\,\ Anhui",
  861313548 => "Tongling\,\ Anhui",
  861313549 => "Chizhou\,\ Anhui",
  861313550 => "Chuzhou\,\ Anhui",
  861313551 => "Hefei\,\ Anhui",
  861313552 => "Bengbu\,\ Anhui",
  861313553 => "Wuhu\,\ Anhui",
  861313554 => "Huainan\,\ Anhui",
  861313555 => "Hefei\,\ Anhui",
  861313556 => "Anqing\,\ Anhui",
  861313557 => "Suzhou\,\ Anhui",
  861313558 => "Fuyang\,\ Anhui",
  861313559 => "Huangshan\,\ Anhui",
  861313560 => "Xiaogan\,\ Hubei",
  861313561 => "Xiaogan\,\ Hubei",
  861313562 => "Xiaogan\,\ Hubei",
  861313563 => "Xiaogan\,\ Hubei",
  861313564 => "Xiaogan\,\ Hubei",
  861313565 => "Wuhan\,\ Hubei",
  861313566 => "Wuhan\,\ Hubei",
  861313567 => "Wuhan\,\ Hubei",
  861313568 => "Wuhan\,\ Hubei",
  861313569 => "Wuhan\,\ Hubei",
  861313570 => "Shiyan\,\ Hubei",
  861313571 => "Shiyan\,\ Hubei",
  861313572 => "Shiyan\,\ Hubei",
  861313573 => "Suizhou\,\ Hubei",
  861313574 => "Suizhou\,\ Hubei",
  861313575 => "Jingzhou\,\ Hubei",
  861313576 => "Jingzhou\,\ Hubei",
  861313577 => "Jingzhou\,\ Hubei",
  861313578 => "Jingzhou\,\ Hubei",
  861313579 => "Jingzhou\,\ Hubei",
  861313580 => "Yichang\,\ Hubei",
  861313581 => "Yichang\,\ Hubei",
  861313582 => "Yichang\,\ Hubei",
  861313583 => "Enshi\,\ Hubei",
  861313584 => "Enshi\,\ Hubei",
  861313585 => "Enshi\,\ Hubei",
  861313586 => "Xiangfan\,\ Hubei",
  861313587 => "Xiangfan\,\ Hubei",
  861313588 => "Xiangfan\,\ Hubei",
  861313589 => "Ezhou\,\ Hubei",
  861313590 => "Huanggang\,\ Hubei",
  861313591 => "Huanggang\,\ Hubei",
  861313592 => "Huangshi\,\ Hubei",
  861313593 => "Huangshi\,\ Hubei",
  861313594 => "Xianning\,\ Hubei",
  861313595 => "Xianning\,\ Hubei",
  861313596 => "Xianning\,\ Hubei",
  861313597 => "Jingmen\,\ Hubei",
  861313598 => "Jingmen\,\ Hubei",
  861313599 => "Wuhan\,\ Hubei",
  86131360 => "Haikou\,\ Hainan",
  86131361 => "Hangzhou\,\ Zhejiang",
  861313620 => "Jiaxing\,\ Zhejiang",
  861313621 => "Jiaxing\,\ Zhejiang",
  861313622 => "Jiaxing\,\ Zhejiang",
  861313623 => "Jiaxing\,\ Zhejiang",
  861313624 => "Jiaxing\,\ Zhejiang",
  861313625 => "Zhoushan\,\ Zhejiang",
  861313626 => "Zhoushan\,\ Zhejiang",
  861313627 => "Zhoushan\,\ Zhejiang",
  861313628 => "Zhoushan\,\ Zhejiang",
  861313629 => "Zhoushan\,\ Zhejiang",
  86131363 => "Ningbo\,\ Zhejiang",
  861313640 => "Zhoushan\,\ Zhejiang",
  861313641 => "Zhoushan\,\ Zhejiang",
  861313642 => "Zhoushan\,\ Zhejiang",
  861313643 => "Zhoushan\,\ Zhejiang",
  861313644 => "Zhoushan\,\ Zhejiang",
  861313645 => "Taizhou\,\ Zhejiang",
  861313646 => "Taizhou\,\ Zhejiang",
  861313647 => "Taizhou\,\ Zhejiang",
  861313648 => "Taizhou\,\ Zhejiang",
  861313649 => "Taizhou\,\ Zhejiang",
  861313650 => "Huzhou\,\ Zhejiang",
  861313651 => "Huzhou\,\ Zhejiang",
  861313652 => "Huzhou\,\ Zhejiang",
  861313653 => "Huzhou\,\ Zhejiang",
  861313654 => "Huzhou\,\ Zhejiang",
  861313655 => "Taizhou\,\ Zhejiang",
  861313656 => "Taizhou\,\ Zhejiang",
  861313657 => "Taizhou\,\ Zhejiang",
  861313658 => "Taizhou\,\ Zhejiang",
  861313659 => "Taizhou\,\ Zhejiang",
  861313660 => "Qiqihar\,\ Heilongjiang",
  861313661 => "Qiqihar\,\ Heilongjiang",
  861313662 => "Qiqihar\,\ Heilongjiang",
  861313663 => "Qiqihar\,\ Heilongjiang",
  861313664 => "Harbin\,\ Heilongjiang",
  861313665 => "Harbin\,\ Heilongjiang",
  861313666 => "Harbin\,\ Heilongjiang",
  861313667 => "Harbin\,\ Heilongjiang",
  861313668 => "Harbin\,\ Heilongjiang",
  861313669 => "Harbin\,\ Heilongjiang",
  861313670 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861313671 => "Yichun\,\ Heilongjiang",
  861313672 => "Qiqihar\,\ Heilongjiang",
  861313673 => "Qiqihar\,\ Heilongjiang",
  861313674 => "Harbin\,\ Heilongjiang",
  861313675 => "Harbin\,\ Heilongjiang",
  861313676 => "Harbin\,\ Heilongjiang",
  861313677 => "Shuangyashan\,\ Heilongjiang",
  861313678 => "Shuangyashan\,\ Heilongjiang",
  861313679 => "Qitaihe\,\ Heilongjiang",
  861313680 => "Daqing\,\ Heilongjiang",
  861313681 => "Daqing\,\ Heilongjiang",
  861313682 => "Daqing\,\ Heilongjiang",
  861313683 => "Daqing\,\ Heilongjiang",
  861313684 => "Daqing\,\ Heilongjiang",
  861313685 => "Daqing\,\ Heilongjiang",
  861313686 => "Mudanjiang\,\ Heilongjiang",
  861313687 => "Mudanjiang\,\ Heilongjiang",
  861313688 => "Mudanjiang\,\ Heilongjiang",
  861313689 => "Mudanjiang\,\ Heilongjiang",
  861313690 => "Hegang\,\ Heilongjiang",
  861313691 => "Suihua\,\ Heilongjiang",
  861313692 => "Suihua\,\ Heilongjiang",
  861313693 => "Heihe\,\ Heilongjiang",
  861313694 => "Jixi\,\ Heilongjiang",
  861313695 => "Jixi\,\ Heilongjiang",
  861313696 => "Jixi\,\ Heilongjiang",
  861313697 => "Jiamusi\,\ Heilongjiang",
  861313698 => "Jiamusi\,\ Heilongjiang",
  861313699 => "Jiamusi\,\ Heilongjiang",
  861313700 => "Shangqiu\,\ Henan",
  861313701 => "Shangqiu\,\ Henan",
  861313702 => "Shangqiu\,\ Henan",
  861313703 => "Shangqiu\,\ Henan",
  861313704 => "Luoyang\,\ Henan",
  861313705 => "Luoyang\,\ Henan",
  861313706 => "Luoyang\,\ Henan",
  861313707 => "Nanyang\,\ Henan",
  861313708 => "Nanyang\,\ Henan",
  861313709 => "Nanyang\,\ Henan",
  861313710 => "Zhengzhou\,\ Henan",
  861313711 => "Zhengzhou\,\ Henan",
  861313712 => "Zhengzhou\,\ Henan",
  861313713 => "Zhengzhou\,\ Henan",
  861313714 => "Zhengzhou\,\ Henan",
  861313715 => "Zhengzhou\,\ Henan",
  861313716 => "Jiaozuo\,\ Henan",
  861313717 => "Jiaozuo\,\ Henan",
  861313718 => "Jiaozuo\,\ Henan",
  861313719 => "Anyang\,\ Henan",
  861313720 => "Anyang\,\ Henan",
  861313721 => "Anyang\,\ Henan",
  861313722 => "Hebi\,\ Henan",
  861313723 => "Hebi\,\ Henan",
  861313724 => "Zhumadian\,\ Henan",
  861313725 => "Zhumadian\,\ Henan",
  861313726 => "Zhumadian\,\ Henan",
  861313727 => "Zhumadian\,\ Henan",
  861313728 => "Zhumadian\,\ Henan",
  861313729 => "Zhumadian\,\ Henan",
  861313730 => "Xinxiang\,\ Henan",
  861313731 => "Xinxiang\,\ Henan",
  861313732 => "Xinxiang\,\ Henan",
  861313733 => "Puyang\,\ Henan",
  861313734 => "Puyang\,\ Henan",
  861313735 => "Puyang\,\ Henan",
  861313736 => "Xinyang\,\ Henan",
  861313737 => "Xinyang\,\ Henan",
  861313738 => "Xinyang\,\ Henan",
  861313739 => "Xinyang\,\ Henan",
  861313740 => "Xuchang\,\ Henan",
  861313741 => "Xuchang\,\ Henan",
  861313742 => "Xuchang\,\ Henan",
  861313743 => "Xuchang\,\ Henan",
  861313744 => "Zhoukou\,\ Henan",
  861313745 => "Zhoukou\,\ Henan",
  861313746 => "Zhoukou\,\ Henan",
  861313747 => "Zhoukou\,\ Henan",
  861313748 => "Sanmenxia\,\ Henan",
  861313749 => "Sanmenxia\,\ Henan",
  861313750 => "Pingdingshan\,\ Henan",
  861313751 => "Pingdingshan\,\ Henan",
  861313752 => "Pingdingshan\,\ Henan",
  861313753 => "Pingdingshan\,\ Henan",
  861313754 => "Luohe\,\ Henan",
  861313755 => "Luohe\,\ Henan",
  861313756 => "Kaifeng\,\ Henan",
  861313757 => "Kaifeng\,\ Henan",
  861313758 => "Kaifeng\,\ Henan",
  861313759 => "Kaifeng\,\ Henan",
  861313760 => "Xinyang\,\ Henan",
  861313761 => "Xinyang\,\ Henan",
  861313762 => "Xinyang\,\ Henan",
  861313763 => "Xinyang\,\ Henan",
  861313764 => "Xinyang\,\ Henan",
  861313765 => "Zhoukou\,\ Henan",
  861313766 => "Zhoukou\,\ Henan",
  861313767 => "Zhoukou\,\ Henan",
  861313768 => "Zhoukou\,\ Henan",
  861313769 => "Zhoukou\,\ Henan",
  861313770 => "Zhengzhou\,\ Henan",
  861313771 => "Zhengzhou\,\ Henan",
  861313772 => "Zhengzhou\,\ Henan",
  861313773 => "Zhengzhou\,\ Henan",
  861313774 => "Pingdingshan\,\ Henan",
  861313775 => "Pingdingshan\,\ Henan",
  861313776 => "Pingdingshan\,\ Henan",
  861313777 => "Nanyang\,\ Henan",
  861313778 => "Nanyang\,\ Henan",
  861313779 => "Nanyang\,\ Henan",
  861313780 => "Kaifeng\,\ Henan",
  861313781 => "Kaifeng\,\ Henan",
  861313782 => "Kaifeng\,\ Henan",
  861313783 => "Kaifeng\,\ Henan",
  861313784 => "Kaifeng\,\ Henan",
  861313785 => "Zhumadian\,\ Henan",
  861313786 => "Zhumadian\,\ Henan",
  861313787 => "Zhumadian\,\ Henan",
  861313788 => "Xuchang\,\ Henan",
  861313789 => "Xuchang\,\ Henan",
  861313790 => "Luoyang\,\ Henan",
  861313791 => "Jiaozuo\,\ Henan",
  861313792 => "Jiaozuo\,\ Henan",
  861313793 => "Jiaozuo\,\ Henan",
  861313794 => "Zhengzhou\,\ Henan",
  861313795 => "Luohe\,\ Henan",
  861313796 => "Luohe\,\ Henan",
  861313797 => "Sanmenxia\,\ Henan",
  861313798 => "Sanmenxia\,\ Henan",
  861313799 => "Luoyang\,\ Henan",
  861313800 => "Meizhou\,\ Guangdong",
  861313801 => "Meizhou\,\ Guangdong",
  861313802 => "Meizhou\,\ Guangdong",
  861313803 => "Meizhou\,\ Guangdong",
  861313804 => "Meizhou\,\ Guangdong",
  861313805 => "Meizhou\,\ Guangdong",
  861313806 => "Meizhou\,\ Guangdong",
  861313807 => "Meizhou\,\ Guangdong",
  861313808 => "Shijiazhuang\,\ Hebei",
  861313809 => "Meizhou\,\ Guangdong",
  861313810 => "Zhuhai\,\ Guangdong",
  861313811 => "Zhuhai\,\ Guangdong",
  861313812 => "Zhuhai\,\ Guangdong",
  861313813 => "Zhuhai\,\ Guangdong",
  861313814 => "Zhuhai\,\ Guangdong",
  861313815 => "Shenzhen\,\ Guangdong",
  861313816 => "Shenzhen\,\ Guangdong",
  861313817 => "Shenzhen\,\ Guangdong",
  861313818 => "Shenzhen\,\ Guangdong",
  861313819 => "Shijiazhuang\,\ Hebei",
  86131382 => "Foshan\,\ Guangdong",
  86131383 => "Huizhou\,\ Guangdong",
  861313840 => "Shantou\,\ Guangdong",
  861313841 => "Shantou\,\ Guangdong",
  861313842 => "Shantou\,\ Guangdong",
  861313843 => "Shantou\,\ Guangdong",
  861313844 => "Shantou\,\ Guangdong",
  861313845 => "Guangzhou\,\ Guangdong",
  861313846 => "Guangzhou\,\ Guangdong",
  861313847 => "Guangzhou\,\ Guangdong",
  861313848 => "Guangzhou\,\ Guangdong",
  861313849 => "Guangzhou\,\ Guangdong",
  861313850 => "Zhaoqing\,\ Guangdong",
  861313851 => "Zhaoqing\,\ Guangdong",
  861313852 => "Zhaoqing\,\ Guangdong",
  861313853 => "Zhaoqing\,\ Guangdong",
  861313854 => "Zhaoqing\,\ Guangdong",
  861313855 => "Shantou\,\ Guangdong",
  861313856 => "Shantou\,\ Guangdong",
  861313857 => "Shantou\,\ Guangdong",
  861313858 => "Shantou\,\ Guangdong",
  861313859 => "Shantou\,\ Guangdong",
  86131386 => "Guangzhou\,\ Guangdong",
  86131387 => "Maoming\,\ Guangdong",
  861313880 => "Dongguan\,\ Guangdong",
  861313881 => "Dongguan\,\ Guangdong",
  861313882 => "Dongguan\,\ Guangdong",
  861313883 => "Dongguan\,\ Guangdong",
  861313884 => "Dongguan\,\ Guangdong",
  861313885 => "Shenzhen\,\ Guangdong",
  861313886 => "Shenzhen\,\ Guangdong",
  861313887 => "Shenzhen\,\ Guangdong",
  861313888 => "Shenzhen\,\ Guangdong",
  861313889 => "Shenzhen\,\ Guangdong",
  86131389 => "Haikou\,\ Hainan",
  861313900 => "Haixi\,\ Qinghai",
  861313901 => "Haixi\,\ Qinghai",
  861313902 => "Haixi\,\ Qinghai",
  861313903 => "Haixi\,\ Qinghai",
  861313904 => "Xining\,\ Qinghai",
  861313905 => "Xining\,\ Qinghai",
  861313906 => "Xining\,\ Qinghai",
  861313907 => "Xining\,\ Qinghai",
  861313908 => "Xining\,\ Qinghai",
  861313909 => "Xining\,\ Qinghai",
  861313910 => "Haibei\,\ Qinghai",
  861313911 => "Haidong\,\ Qinghai",
  861313912 => "Haidong\,\ Qinghai",
  861313913 => "Huangnan\,\ Qinghai",
  861313914 => "Hainan\,\ Qinghai",
  861313915 => "Golog\,\ Qinghai",
  861313916 => "Yushu\,\ Qinghai",
  861313917 => "Haixi\,\ Qinghai",
  861313918 => "Haixi\,\ Qinghai",
  861313919 => "Haidong\,\ Qinghai",
  86131392 => "Lanzhou\,\ Gansu",
  861313930 => "Linxia\,\ Gansu",
  861313931 => "Lanzhou\,\ Gansu",
  861313932 => "Dingxi\,\ Gansu",
  861313933 => "Pingliang\,\ Gansu",
  861313934 => "Qingyang\,\ Gansu",
  861313935 => "Wuwei\,\ Gansu",
  861313936 => "Zhangye\,\ Gansu",
  861313937 => "Jiuquan\,\ Gansu",
  861313938 => "Tianshui\,\ Gansu",
  861313939 => "Longnan\,\ Gansu",
  861313940 => "Lanzhou\,\ Gansu",
  861313941 => "Longnan\,\ Gansu",
  861313942 => "Dingxi\,\ Gansu",
  861313943 => "Baiyin\,\ Gansu",
  861313944 => "Tianshui\,\ Gansu",
  861313945 => "Wuwei\,\ Gansu",
  861313946 => "Qingyang\,\ Gansu",
  861313947 => "Jiayuguan\,\ Gansu",
  861313948 => "Jiuquan\,\ Gansu",
  861313949 => "Jiuquan\,\ Gansu",
  861313950 => "Yinchuan\,\ Ningxia",
  861313951 => "Yinchuan\,\ Ningxia",
  861313952 => "Shizuishan\,\ Ningxia",
  861313953 => "Wuzhong\,\ Ningxia",
  861313954 => "Guyuan\,\ Ningxia",
  861313955 => "Wuzhong\,\ Ningxia",
  861313956 => "Shizuishan\,\ Ningxia",
  861313957 => "Wuzhong\,\ Ningxia",
  861313958 => "Yinchuan\,\ Ningxia",
  861313959 => "Yinchuan\,\ Ningxia",
  86131396 => "Urumchi\,\ Xinjiang",
  861313970 => "Changji\,\ Xinjiang",
  861313971 => "Hami\,\ Xinjiang",
  861313972 => "Bayingolin\,\ Xinjiang",
  861313973 => "Bayingolin\,\ Xinjiang",
  861313974 => "Aksu\,\ Xinjiang",
  861313975 => "Kashi\,\ Xinjiang",
  861313976 => "Hotan\,\ Xinjiang",
  861313977 => "Bortala\,\ Xinjiang",
  861313978 => "Tacheng\,\ Xinjiang",
  861313979 => "Altay\,\ Xinjiang",
  861313980 => "Ili\,\ Xinjiang",
  861313981 => "Bortala\,\ Xinjiang",
  861313982 => "Tacheng\,\ Xinjiang",
  861313983 => "Altay\,\ Xinjiang",
  861313984 => "Bayingolin\,\ Xinjiang",
  861313985 => "Bayingolin\,\ Xinjiang",
  861313986 => "Aksu\,\ Xinjiang",
  861313987 => "Urumchi\,\ Xinjiang",
  861313988 => "Urumchi\,\ Xinjiang",
  861313989 => "Urumchi\,\ Xinjiang",
  861313990 => "Karamay\,\ Xinjiang",
  861313991 => "Urumchi\,\ Xinjiang",
  861313992 => "Ili\,\ Xinjiang",
  861313993 => "Shihezi\,\ Xinjiang",
  861313994 => "Changji\,\ Xinjiang",
  861313995 => "Turpan\,\ Xinjiang",
  861313996 => "Bayingolin\,\ Xinjiang",
  861313997 => "Aksu\,\ Xinjiang",
  861313998 => "Kashi\,\ Xinjiang",
  861313999 => "Ili\,\ Xinjiang",
  86131400 => "Zhengzhou\,\ Henan",
  86131401 => "Zhengzhou\,\ Henan",
  86131402 => "Chongqing",
  86131403 => "Chongqing",
  861314040 => "Anyang\,\ Henan",
  861314041 => "Anyang\,\ Henan",
  861314042 => "Hebi\,\ Henan",
  861314043 => "Jiaozuo\,\ Henan",
  861314044 => "Jiaozuo\,\ Henan",
  861314045 => "Kaifeng\,\ Henan",
  861314046 => "Kaifeng\,\ Henan",
  861314047 => "Luoyang\,\ Henan",
  861314048 => "Luoyang\,\ Henan",
  861314049 => "Luoyang\,\ Henan",
  861314050 => "Luohe\,\ Henan",
  861314051 => "Nanyang\,\ Henan",
  861314052 => "Nanyang\,\ Henan",
  861314053 => "Pingdingshan\,\ Henan",
  861314054 => "Shangqiu\,\ Henan",
  861314055 => "Puyang\,\ Henan",
  861314056 => "Sanmenxia\,\ Henan",
  861314057 => "Shangqiu\,\ Henan",
  861314058 => "Xinxiang\,\ Henan",
  861314059 => "Xinxiang\,\ Henan",
  861314060 => "Xinyang\,\ Henan",
  861314061 => "Xinyang\,\ Henan",
  861314062 => "Xuchang\,\ Henan",
  861314063 => "Xuchang\,\ Henan",
  861314064 => "Zhoukou\,\ Henan",
  861314065 => "Zhoukou\,\ Henan",
  861314066 => "Zhoukou\,\ Henan",
  861314067 => "Zhumadian\,\ Henan",
  861314068 => "Zhumadian\,\ Henan",
  861314069 => "Zhumadian\,\ Henan",
  86131407 => "Nanjing\,\ Jiangsu",
  86131408 => "Suzhou\,\ Jiangsu",
  86131409 => "Suzhou\,\ Jiangsu",
  86131410 => "Beijing",
  86131411 => "Beijing",
  86131412 => "Beijing",
  86131413 => "Beijing",
  86131414 => "Beijing",
  861314150 => "Lianyungang\,\ Jiangsu",
  861314151 => "Lianyungang\,\ Jiangsu",
  861314152 => "Lianyungang\,\ Jiangsu",
  861314153 => "Lianyungang\,\ Jiangsu",
  861314154 => "Yiyang\,\ Hunan",
  861314155 => "Yiyang\,\ Hunan",
  861314156 => "Suqian\,\ Jiangsu",
  861314157 => "Suqian\,\ Jiangsu",
  861314158 => "Suqian\,\ Jiangsu",
  861314159 => "Chenzhou\,\ Hunan",
  861314160 => "Xiangxi\,\ Hunan",
  861314161 => "Xiangxi\,\ Hunan",
  861314162 => "Xiangxi\,\ Hunan",
  861314163 => "Xiangxi\,\ Hunan",
  861314164 => "Xiangxi\,\ Hunan",
  861314165 => "Nanjing\,\ Jiangsu",
  861314166 => "Nanjing\,\ Jiangsu",
  861314167 => "Nanjing\,\ Jiangsu",
  861314168 => "Nanjing\,\ Jiangsu",
  861314169 => "Nanjing\,\ Jiangsu",
  861314170 => "Chenzhou\,\ Hunan",
  861314171 => "Chenzhou\,\ Hunan",
  861314172 => "Nantong\,\ Jiangsu",
  861314173 => "Nantong\,\ Jiangsu",
  861314174 => "Nantong\,\ Jiangsu",
  861314175 => "Dingxi\,\ Gansu",
  861314176 => "Dingxi\,\ Gansu",
  861314177 => "Ordos\,\ Inner\ Mongolia",
  861314178 => "Bayannur\,\ Inner\ Mongolia",
  861314179 => "Xilin\,\ Inner\ Mongolia",
  86131418 => "Suzhou\,\ Jiangsu",
  861314190 => "Yancheng\,\ Jiangsu",
  861314191 => "Yancheng\,\ Jiangsu",
  861314192 => "Tianshui\,\ Gansu",
  861314193 => "Tianshui\,\ Gansu",
  861314194 => "Dingxi\,\ Gansu",
  861314195 => "Shaoyang\,\ Hunan",
  861314196 => "Shaoyang\,\ Hunan",
  861314197 => "Shaoyang\,\ Hunan",
  861314198 => "Taizhou\,\ Jiangsu",
  861314199 => "Taizhou\,\ Jiangsu",
  86131420 => "Changsha\,\ Hunan",
  86131421 => "Changsha\,\ Hunan",
  86131422 => "Changsha\,\ Hunan",
  86131423 => "Hengyang\,\ Hunan",
  861314240 => "Baotou\,\ Inner\ Mongolia",
  861314241 => "Baotou\,\ Inner\ Mongolia",
  861314242 => "Baotou\,\ Inner\ Mongolia",
  861314243 => "Baotou\,\ Inner\ Mongolia",
  861314244 => "Baotou\,\ Inner\ Mongolia",
  861314245 => "Bayannur\,\ Inner\ Mongolia",
  861314246 => "Bayannur\,\ Inner\ Mongolia",
  861314247 => "Bayannur\,\ Inner\ Mongolia",
  861314248 => "Bayannur\,\ Inner\ Mongolia",
  861314249 => "Alxa\,\ Inner\ Mongolia",
  861314250 => "Changzhou\,\ Jiangsu",
  861314251 => "Changzhou\,\ Jiangsu",
  861314252 => "Changzhou\,\ Jiangsu",
  861314253 => "Changzhou\,\ Jiangsu",
  861314254 => "Changzhou\,\ Jiangsu",
  861314255 => "Changzhou\,\ Jiangsu",
  861314256 => "Changzhou\,\ Jiangsu",
  861314257 => "Shaoyang\,\ Hunan",
  861314258 => "Yangzhou\,\ Jiangsu",
  861314259 => "Yangzhou\,\ Jiangsu",
  861314260 => "Zhenjiang\,\ Jiangsu",
  861314261 => "Baotou\,\ Inner\ Mongolia",
  861314262 => "Zhenjiang\,\ Jiangsu",
  861314263 => "Baotou\,\ Inner\ Mongolia",
  861314264 => "Baotou\,\ Inner\ Mongolia",
  861314265 => "Nantong\,\ Jiangsu",
  861314266 => "Nantong\,\ Jiangsu",
  861314267 => "Nantong\,\ Jiangsu",
  861314268 => "Nantong\,\ Jiangsu",
  861314269 => "Nantong\,\ Jiangsu",
  86131427 => "Wenzhou\,\ Zhejiang",
  861314280 => "Nanjing\,\ Jiangsu",
  861314281 => "Nanjing\,\ Jiangsu",
  861314282 => "Nanjing\,\ Jiangsu",
  861314283 => "Nanjing\,\ Jiangsu",
  861314284 => "Nanjing\,\ Jiangsu",
  861314285 => "Taizhou\,\ Jiangsu",
  861314286 => "Taizhou\,\ Jiangsu",
  861314287 => "Xiangtan\,\ Hunan",
  861314288 => "Taizhou\,\ Jiangsu",
  861314289 => "Taizhou\,\ Jiangsu",
  86131429 => "Nantong\,\ Jiangsu",
  861314300 => "Huizhou\,\ Guangdong",
  861314301 => "Shijiazhuang\,\ Hebei",
  861314302 => "Shijiazhuang\,\ Hebei",
  861314303 => "Huizhou\,\ Guangdong",
  861314304 => "Shijiazhuang\,\ Hebei",
  861314305 => "Huizhou\,\ Guangdong",
  861314306 => "Huizhou\,\ Guangdong",
  861314307 => "Huizhou\,\ Guangdong",
  861314308 => "Huizhou\,\ Guangdong",
  861314309 => "Huizhou\,\ Guangdong",
  861314310 => "Zhuhai\,\ Guangdong",
  861314311 => "Zhuhai\,\ Guangdong",
  861314312 => "Zhuhai\,\ Guangdong",
  861314313 => "Zhuhai\,\ Guangdong",
  861314314 => "Zhuhai\,\ Guangdong",
  861314315 => "Langfang\,\ Hebei",
  861314316 => "Foshan\,\ Guangdong",
  861314317 => "Foshan\,\ Guangdong",
  861314318 => "Foshan\,\ Guangdong",
  861314319 => "Foshan\,\ Guangdong",
  86131432 => "Dongguan\,\ Guangdong",
  86131433 => "Guangzhou\,\ Guangdong",
  861314340 => "Shenzhen\,\ Guangdong",
  861314341 => "Shenzhen\,\ Guangdong",
  861314342 => "Shenzhen\,\ Guangdong",
  861314343 => "Shenzhen\,\ Guangdong",
  861314344 => "Shenzhen\,\ Guangdong",
  861314345 => "Shenzhen\,\ Guangdong",
  861314346 => "Shenzhen\,\ Guangdong",
  861314347 => "Huizhou\,\ Guangdong",
  861314348 => "Shijiazhuang\,\ Hebei",
  861314349 => "Shijiazhuang\,\ Hebei",
  861314350 => "Guangzhou\,\ Guangdong",
  861314351 => "Guangzhou\,\ Guangdong",
  861314352 => "Guangzhou\,\ Guangdong",
  861314353 => "Guangzhou\,\ Guangdong",
  861314354 => "Guangzhou\,\ Guangdong",
  861314355 => "Foshan\,\ Guangdong",
  861314356 => "Foshan\,\ Guangdong",
  861314357 => "Foshan\,\ Guangdong",
  861314358 => "Foshan\,\ Guangdong",
  861314359 => "Foshan\,\ Guangdong",
  861314360 => "Huizhou\,\ Guangdong",
  861314361 => "Huizhou\,\ Guangdong",
  861314362 => "Huizhou\,\ Guangdong",
  861314363 => "Shijiazhuang\,\ Hebei",
  861314364 => "Shijiazhuang\,\ Hebei",
  861314365 => "Guangzhou\,\ Guangdong",
  861314366 => "Guangzhou\,\ Guangdong",
  861314367 => "Guangzhou\,\ Guangdong",
  861314368 => "Guangzhou\,\ Guangdong",
  861314369 => "Guangzhou\,\ Guangdong",
  86131437 => "Guangzhou\,\ Guangdong",
  86131438 => "Shenzhen\,\ Guangdong",
  86131439 => "Shenzhen\,\ Guangdong",
  861314400 => "Zhongshan\,\ Guangdong",
  861314401 => "Zhongshan\,\ Guangdong",
  861314402 => "Zhongshan\,\ Guangdong",
  861314403 => "Zhongshan\,\ Guangdong",
  861314404 => "Zhongshan\,\ Guangdong",
  861314405 => "Chaozhou\,\ Guangdong",
  861314406 => "Chaozhou\,\ Guangdong",
  861314407 => "Jieyang\,\ Guangdong",
  861314408 => "Jieyang\,\ Guangdong",
  861314409 => "Jieyang\,\ Guangdong",
  861314410 => "Heyuan\,\ Guangdong",
  861314411 => "Foshan\,\ Guangdong",
  861314412 => "Foshan\,\ Guangdong",
  861314413 => "Foshan\,\ Guangdong",
  861314414 => "Foshan\,\ Guangdong",
  861314415 => "Zhaoqing\,\ Guangdong",
  861314416 => "Zhaoqing\,\ Guangdong",
  861314417 => "Zhaoqing\,\ Guangdong",
  861314418 => "Zhaoqing\,\ Guangdong",
  861314419 => "Zhaoqing\,\ Guangdong",
  861314420 => "Jiangmen\,\ Guangdong",
  861314421 => "Jiangmen\,\ Guangdong",
  861314422 => "Jiangmen\,\ Guangdong",
  861314423 => "Jiangmen\,\ Guangdong",
  861314424 => "Jiangmen\,\ Guangdong",
  861314425 => "Shantou\,\ Guangdong",
  861314426 => "Shantou\,\ Guangdong",
  861314427 => "Shantou\,\ Guangdong",
  861314428 => "Shantou\,\ Guangdong",
  861314429 => "Shantou\,\ Guangdong",
  861314430 => "Changchun\,\ Jilin",
  861314431 => "Changchun\,\ Jilin",
  861314432 => "Jilin\,\ Jilin",
  861314433 => "Yanbian\,\ Jilin",
  861314434 => "Siping\,\ Jilin",
  861314435 => "Tonghua\,\ Jilin",
  861314436 => "Baicheng\,\ Jilin",
  861314437 => "Liaoyuan\,\ Jilin",
  861314438 => "Songyuan\,\ Jilin",
  861314439 => "Baishan\,\ Jilin",
  861314440 => "Guangzhou\,\ Guangdong",
  861314441 => "Guangzhou\,\ Guangdong",
  861314442 => "Guangzhou\,\ Guangdong",
  861314443 => "Guangzhou\,\ Guangdong",
  861314444 => "Guangzhou\,\ Guangdong",
  861314445 => "Guangzhou\,\ Guangdong",
  861314446 => "Chaozhou\,\ Guangdong",
  861314447 => "Shanwei\,\ Guangdong",
  861314448 => "Shanwei\,\ Guangdong",
  861314449 => "Shanwei\,\ Guangdong",
  861314450 => "Harbin\,\ Heilongjiang",
  861314451 => "Harbin\,\ Heilongjiang",
  861314452 => "Qiqihar\,\ Heilongjiang",
  861314453 => "Mudanjiang\,\ Heilongjiang",
  861314454 => "Jiamusi\,\ Heilongjiang",
  861314455 => "Suihua\,\ Heilongjiang",
  861314456 => "Heihe\,\ Heilongjiang",
  861314457 => "Qiqihar\,\ Heilongjiang",
  861314458 => "Yichun\,\ Heilongjiang",
  861314459 => "Daqing\,\ Heilongjiang",
  861314460 => "Harbin\,\ Heilongjiang",
  861314461 => "Harbin\,\ Heilongjiang",
  861314462 => "Harbin\,\ Heilongjiang",
  861314463 => "Mudanjiang\,\ Heilongjiang",
  861314464 => "Qitaihe\,\ Heilongjiang",
  861314465 => "Daqing\,\ Heilongjiang",
  861314466 => "Jixi\,\ Heilongjiang",
  861314467 => "Jixi\,\ Heilongjiang",
  861314468 => "Hegang\,\ Heilongjiang",
  861314469 => "Shuangyashan\,\ Heilongjiang",
  86131447 => "Foshan\,\ Guangdong",
  861314480 => "Shenzhen\,\ Guangdong",
  861314481 => "Shenzhen\,\ Guangdong",
  861314482 => "Shenzhen\,\ Guangdong",
  861314483 => "Shenzhen\,\ Guangdong",
  861314484 => "Shenzhen\,\ Guangdong",
  861314485 => "Dongguan\,\ Guangdong",
  861314486 => "Dongguan\,\ Guangdong",
  861314487 => "Dongguan\,\ Guangdong",
  861314488 => "Dongguan\,\ Guangdong",
  861314489 => "Dongguan\,\ Guangdong",
  86131449 => "Dongguan\,\ Guangdong",
  86131450 => "Suzhou\,\ Jiangsu",
  861314510 => "Suzhou\,\ Jiangsu",
  861314511 => "Suzhou\,\ Jiangsu",
  861314512 => "Nanjing\,\ Jiangsu",
  861314513 => "Nanjing\,\ Jiangsu",
  861314514 => "Nanjing\,\ Jiangsu",
  861314515 => "Nanjing\,\ Jiangsu",
  861314516 => "Nanjing\,\ Jiangsu",
  861314517 => "Nanjing\,\ Jiangsu",
  861314518 => "Nanjing\,\ Jiangsu",
  861314519 => "Nanjing\,\ Jiangsu",
  861314520 => "Xuzhou\,\ Jiangsu",
  861314521 => "Xuzhou\,\ Jiangsu",
  861314522 => "Xuzhou\,\ Jiangsu",
  861314523 => "Xiangtan\,\ Hunan",
  861314524 => "Tianshui\,\ Gansu",
  861314525 => "Tongliao\,\ Inner\ Mongolia",
  861314526 => "Baotou\,\ Inner\ Mongolia",
  861314527 => "Baotou\,\ Inner\ Mongolia",
  861314528 => "Hulun\,\ Inner\ Mongolia",
  861314529 => "Xilin\,\ Inner\ Mongolia",
  861314530 => "Heze\,\ Shandong",
  861314531 => "Jinan\,\ Shandong",
  861314532 => "Qingdao\,\ Shandong",
  861314533 => "Zibo\,\ Shandong",
  861314534 => "Dezhou\,\ Shandong",
  861314535 => "Yantai\,\ Shandong",
  861314536 => "Weifang\,\ Shandong",
  861314537 => "Jining\,\ Shandong",
  861314538 => "TaiAn\,\ Shandong",
  861314539 => "Linyi\,\ Shandong",
  861314540 => "Jinan\,\ Shandong",
  861314541 => "Jinan\,\ Shandong",
  861314542 => "Qingdao\,\ Shandong",
  861314543 => "Binzhou\,\ Shandong",
  861314544 => "Rizhao\,\ Shandong",
  861314545 => "Dongying\,\ Shandong",
  861314546 => "Dongying\,\ Shandong",
  861314547 => "Jinan\,\ Shandong",
  861314548 => "Laiwu\,\ Shandong",
  861314549 => "Linyi\,\ Shandong",
  861314550 => "Chuzhou\,\ Anhui",
  861314551 => "Hefei\,\ Anhui",
  861314552 => "Bengbu\,\ Anhui",
  861314553 => "Wuhu\,\ Anhui",
  861314554 => "Huainan\,\ Anhui",
  861314555 => "MaAnshan\,\ Anhui",
  861314556 => "Anqing\,\ Anhui",
  861314557 => "Suzhou\,\ Anhui",
  861314558 => "Fuyang\,\ Anhui",
  861314559 => "Huangshan\,\ Anhui",
  861314560 => "Suzhou\,\ Anhui",
  861314561 => "Huaibei\,\ Anhui",
  861314562 => "Tongling\,\ Anhui",
  861314563 => "Xuancheng\,\ Anhui",
  861314564 => "LuAn\,\ Anhui",
  861314565 => "Hefei\,\ Anhui",
  861314566 => "Chizhou\,\ Anhui",
  861314567 => "Bozhou\,\ Anhui",
  861314568 => "Bozhou\,\ Anhui",
  861314569 => "Xuancheng\,\ Anhui",
  86131457 => "Guangzhou\,\ Guangdong",
  86131458 => "Shenzhen\,\ Guangdong",
  86131459 => "Shenzhen\,\ Guangdong",
  8613146 => "Beijing",
  86131470 => "Shenzhen\,\ Guangdong",
  86131471 => "Wuhan\,\ Hubei",
  861314720 => "Ezhou\,\ Hubei",
  861314721 => "Jingzhou\,\ Hubei",
  861314722 => "Suizhou\,\ Hubei",
  861314723 => "Huangshi\,\ Hubei",
  861314724 => "Xianning\,\ Hubei",
  861314725 => "Jingmen\,\ Hubei",
  861314726 => "Enshi\,\ Hubei",
  861314727 => "Xiangfan\,\ Hubei",
  861314728 => "Shiyan\,\ Hubei",
  861314729 => "Xiaogan\,\ Hubei",
  86131473 => "Dongguan\,\ Guangdong",
  86131474 => "Shijiazhuang\,\ Hebei",
  86131475 => "Shenzhen\,\ Guangdong",
  861314760 => "Baicheng\,\ Jilin",
  861314761 => "Baicheng\,\ Jilin",
  861314762 => "Baicheng\,\ Jilin",
  861314763 => "Jilin\,\ Jilin",
  861314764 => "Changchun\,\ Jilin",
  861314765 => "Changchun\,\ Jilin",
  861314766 => "Changchun\,\ Jilin",
  861314767 => "Songyuan\,\ Jilin",
  861314768 => "Songyuan\,\ Jilin",
  861314769 => "Songyuan\,\ Jilin",
  861314770 => "Changchun\,\ Jilin",
  861314771 => "Changchun\,\ Jilin",
  861314772 => "Songyuan\,\ Jilin",
  861314773 => "Jilin\,\ Jilin",
  861314774 => "Jilin\,\ Jilin",
  861314775 => "Jilin\,\ Jilin",
  861314776 => "Jilin\,\ Jilin",
  861314777 => "Jilin\,\ Jilin",
  861314778 => "Liaoyuan\,\ Jilin",
  861314779 => "Liaoyuan\,\ Jilin",
  861314780 => "Shenyang\,\ Liaoning",
  861314781 => "Shenyang\,\ Liaoning",
  861314782 => "Shenyang\,\ Liaoning",
  861314783 => "Shenyang\,\ Liaoning",
  861314784 => "Dalian\,\ Liaoning",
  861314785 => "Dalian\,\ Liaoning",
  861314786 => "Dalian\,\ Liaoning",
  861314787 => "Dalian\,\ Liaoning",
  861314788 => "Anshan\,\ Liaoning",
  861314789 => "Jinzhou\,\ Liaoning",
  861314790 => "Jinzhou\,\ Liaoning",
  861314791 => "Jinzhou\,\ Liaoning",
  861314792 => "Jinzhou\,\ Liaoning",
  861314793 => "Yingkou\,\ Liaoning",
  861314794 => "Fuxin\,\ Liaoning",
  861314795 => "Liaoyang\,\ Liaoning",
  861314796 => "Tieling\,\ Liaoning",
  861314797 => "Chaoyang\,\ Liaoning",
  861314798 => "Panjin\,\ Liaoning",
  861314799 => "Huludao\,\ Liaoning",
  86131480 => "Shangqiu\,\ Henan",
  86131481 => "Shanghai",
  86131482 => "Zhoukou\,\ Henan",
  86131483 => "Hangzhou\,\ Zhejiang",
  86131484 => "Hangzhou\,\ Zhejiang",
  861314850 => "Zhongshan\,\ Guangdong",
  861314851 => "Zhongshan\,\ Guangdong",
  861314852 => "Zhongshan\,\ Guangdong",
  861314853 => "Zhongshan\,\ Guangdong",
  861314854 => "Zhongshan\,\ Guangdong",
  861314855 => "Dongguan\,\ Guangdong",
  861314856 => "Dongguan\,\ Guangdong",
  861314857 => "Dongguan\,\ Guangdong",
  861314858 => "Dongguan\,\ Guangdong",
  861314859 => "Dongguan\,\ Guangdong",
  861314860 => "Heyuan\,\ Guangdong",
  861314861 => "Heyuan\,\ Guangdong",
  861314862 => "Meizhou\,\ Guangdong",
  861314863 => "Shijiazhuang\,\ Hebei",
  861314864 => "Yunfu\,\ Guangdong",
  861314865 => "Yunfu\,\ Guangdong",
  861314866 => "Yangjiang\,\ Guangdong",
  861314867 => "Yangjiang\,\ Guangdong",
  861314868 => "Shaoguan\,\ Guangdong",
  861314869 => "Shaoguan\,\ Guangdong",
  86131487 => "Shenzhen\,\ Guangdong",
  86131488 => "Shenzhen\,\ Guangdong",
  86131489 => "Guangzhou\,\ Guangdong",
  861314900 => "Yangjiang\,\ Guangdong",
  861314901 => "Qingyuan\,\ Guangdong",
  861314902 => "Qingyuan\,\ Guangdong",
  861314903 => "Qingyuan\,\ Guangdong",
  861314904 => "Yangjiang\,\ Guangdong",
  861314905 => "Shaoguan\,\ Guangdong",
  861314906 => "Shaoguan\,\ Guangdong",
  861314907 => "Shaoguan\,\ Guangdong",
  861314908 => "Shaoguan\,\ Guangdong",
  861314909 => "Qingyuan\,\ Guangdong",
  861314910 => "Xianyang\,\ Shaanxi",
  861314911 => "YanAn\,\ Shaanxi",
  861314912 => "Yulin\,\ Shaanxi",
  861314913 => "Weinan\,\ Shaanxi",
  861314914 => "Shangluo\,\ Shaanxi",
  861314915 => "Ankang\,\ Shaanxi",
  861314916 => "Hanzhong\,\ Shaanxi",
  861314917 => "Baoji\,\ Shaanxi",
  861314918 => "XiAn\,\ Shaanxi",
  861314919 => "Tongchuan\,\ Shaanxi",
  86131492 => "XiAn\,\ Shaanxi",
  861314930 => "Zhuhai\,\ Guangdong",
  861314931 => "Zhuhai\,\ Guangdong",
  861314932 => "Zhanjiang\,\ Guangdong",
  861314933 => "Zhanjiang\,\ Guangdong",
  861314934 => "Guangzhou\,\ Guangdong",
  861314935 => "Guangzhou\,\ Guangdong",
  861314936 => "Guangzhou\,\ Guangdong",
  861314937 => "Guangzhou\,\ Guangdong",
  861314938 => "Guangzhou\,\ Guangdong",
  861314939 => "Guangzhou\,\ Guangdong",
  86131494 => "Shijiazhuang\,\ Hebei",
  861314950 => "Harbin\,\ Heilongjiang",
  861314951 => "Harbin\,\ Heilongjiang",
  861314952 => "Qiqihar\,\ Heilongjiang",
  861314953 => "Mudanjiang\,\ Heilongjiang",
  861314954 => "Jiamusi\,\ Heilongjiang",
  861314955 => "Suihua\,\ Heilongjiang",
  861314956 => "Heihe\,\ Heilongjiang",
  861314957 => "Qiqihar\,\ Heilongjiang",
  861314958 => "Yichun\,\ Heilongjiang",
  861314959 => "Daqing\,\ Heilongjiang",
  861314960 => "Harbin\,\ Heilongjiang",
  861314961 => "Harbin\,\ Heilongjiang",
  861314962 => "Qiqihar\,\ Heilongjiang",
  861314963 => "Mudanjiang\,\ Heilongjiang",
  861314964 => "Qitaihe\,\ Heilongjiang",
  861314965 => "Daqing\,\ Heilongjiang",
  861314966 => "Jiamusi\,\ Heilongjiang",
  861314967 => "Jixi\,\ Heilongjiang",
  861314968 => "Hegang\,\ Heilongjiang",
  861314969 => "Shuangyashan\,\ Heilongjiang",
  861314970 => "Jinzhou\,\ Liaoning",
  861314971 => "Yingkou\,\ Liaoning",
  861314972 => "Anshan\,\ Liaoning",
  861314973 => "Jinzhou\,\ Liaoning",
  861314974 => "Jinzhou\,\ Liaoning",
  861314975 => "Fuxin\,\ Liaoning",
  861314976 => "Jinzhou\,\ Liaoning",
  861314977 => "Yingkou\,\ Liaoning",
  861314978 => "Jinzhou\,\ Liaoning",
  861314979 => "Liaoyang\,\ Liaoning",
  861314980 => "Shenyang\,\ Liaoning",
  861314981 => "Shenyang\,\ Liaoning",
  861314982 => "Shenyang\,\ Liaoning",
  861314983 => "Shenyang\,\ Liaoning",
  861314984 => "Shenyang\,\ Liaoning",
  861314985 => "Shenyang\,\ Liaoning",
  861314986 => "Dalian\,\ Liaoning",
  861314987 => "Dalian\,\ Liaoning",
  861314988 => "Dalian\,\ Liaoning",
  861314989 => "Dalian\,\ Liaoning",
  86131499 => "Shenzhen\,\ Guangdong",
  861315000 => "Zhangye\,\ Gansu",
  861315001 => "Lanzhou\,\ Gansu",
  861315002 => "Lanzhou\,\ Gansu",
  861315003 => "Longnan\,\ Gansu",
  861315004 => "Linxia\,\ Gansu",
  861315005 => "Gannan\,\ Gansu",
  861315006 => "Tianshui\,\ Gansu",
  861315007 => "Tianshui\,\ Gansu",
  861315008 => "Longnan\,\ Gansu",
  861315009 => "Linxia\,\ Gansu",
  861315010 => "Dingxi\,\ Gansu",
  861315011 => "Dingxi\,\ Gansu",
  861315012 => "Qingyang\,\ Gansu",
  861315013 => "Qingyang\,\ Gansu",
  861315014 => "Zhangye\,\ Gansu",
  861315015 => "Wuwei\,\ Gansu",
  861315016 => "Wuwei\,\ Gansu",
  861315017 => "Jinchang\,\ Gansu",
  861315018 => "Pingliang\,\ Gansu",
  861315019 => "Jiuquan\,\ Gansu",
  861315020 => "Ili\,\ Xinjiang",
  861315021 => "Ili\,\ Xinjiang",
  861315022 => "Tacheng\,\ Xinjiang",
  861315023 => "Bayingolin\,\ Xinjiang",
  861315024 => "Bayingolin\,\ Xinjiang",
  861315025 => "Bayingolin\,\ Xinjiang",
  861315026 => "Bayingolin\,\ Xinjiang",
  861315027 => "Aksu\,\ Xinjiang",
  861315028 => "Aksu\,\ Xinjiang",
  861315029 => "Kashi\,\ Xinjiang",
  861315030 => "Urumchi\,\ Xinjiang",
  861315031 => "Urumchi\,\ Xinjiang",
  861315032 => "Urumchi\,\ Xinjiang",
  861315033 => "Urumchi\,\ Xinjiang",
  861315034 => "Urumchi\,\ Xinjiang",
  861315035 => "Changji\,\ Xinjiang",
  861315036 => "Hami\,\ Xinjiang",
  861315037 => "Ili\,\ Xinjiang",
  861315038 => "Bortala\,\ Xinjiang",
  861315039 => "Bortala\,\ Xinjiang",
  861315040 => "Shihezi\,\ Xinjiang",
  861315041 => "Kashi\,\ Xinjiang",
  861315042 => "Aksu\,\ Xinjiang",
  861315043 => "Hotan\,\ Xinjiang",
  861315044 => "Kashi\,\ Xinjiang",
  861315045 => "Urumchi\,\ Xinjiang",
  861315046 => "Urumchi\,\ Xinjiang",
  861315047 => "Urumchi\,\ Xinjiang",
  861315048 => "Aksu\,\ Xinjiang",
  861315049 => "Urumchi\,\ Xinjiang",
  861315050 => "Yuxi\,\ Yunnan",
  861315051 => "Yuxi\,\ Yunnan",
  861315052 => "Yuxi\,\ Yunnan",
  861315053 => "Qujing\,\ Yunnan",
  861315054 => "Qujing\,\ Yunnan",
  861315055 => "Qujing\,\ Yunnan",
  861315056 => "Chuxiong\,\ Yunnan",
  861315057 => "Chuxiong\,\ Yunnan",
  861315058 => "Chuxiong\,\ Yunnan",
  861315059 => "Honghe\,\ Yunnan",
  861315060 => "Honghe\,\ Yunnan",
  861315061 => "Honghe\,\ Yunnan",
  861315062 => "Honghe\,\ Yunnan",
  861315063 => "Dali\,\ Yunnan",
  861315064 => "Dali\,\ Yunnan",
  861315065 => "Dali\,\ Yunnan",
  861315066 => "Lijiang\,\ Yunnan",
  861315067 => "Lijiang\,\ Yunnan",
  861315068 => "Zhaotong\,\ Yunnan",
  861315069 => "Zhaotong\,\ Yunnan",
  861315070 => "Kunming\,\ Yunnan",
  861315071 => "Kunming\,\ Yunnan",
  861315072 => "Nujiang\,\ Yunnan",
  861315073 => "Deqen\,\ Yunnan",
  861315074 => "Kunming\,\ Yunnan",
  861315075 => "Kunming\,\ Yunnan",
  861315076 => "Xishuangbanna\,\ Yunnan",
  861315077 => "Baoshan\,\ Yunnan",
  861315078 => "Wenshan\,\ Yunnan",
  861315079 => "Puer\,\ Yunnan",
  861315080 => "Ulanqab\,\ Inner\ Mongolia",
  861315081 => "Ulanqab\,\ Inner\ Mongolia",
  861315082 => "Ulanqab\,\ Inner\ Mongolia",
  861315083 => "Ulanqab\,\ Inner\ Mongolia",
  861315084 => "Ulanqab\,\ Inner\ Mongolia",
  861315085 => "Ordos\,\ Inner\ Mongolia",
  861315086 => "Ordos\,\ Inner\ Mongolia",
  861315087 => "Ordos\,\ Inner\ Mongolia",
  861315088 => "Ordos\,\ Inner\ Mongolia",
  861315089 => "Ordos\,\ Inner\ Mongolia",
  861315090 => "Hulun\,\ Inner\ Mongolia",
  861315091 => "Chifeng\,\ Inner\ Mongolia",
  861315092 => "Chifeng\,\ Inner\ Mongolia",
  861315093 => "Chifeng\,\ Inner\ Mongolia",
  861315094 => "Chifeng\,\ Inner\ Mongolia",
  861315095 => "Chifeng\,\ Inner\ Mongolia",
  861315096 => "Chifeng\,\ Inner\ Mongolia",
  861315097 => "Chifeng\,\ Inner\ Mongolia",
  861315098 => "Chifeng\,\ Inner\ Mongolia",
  861315099 => "Bayannur\,\ Inner\ Mongolia",
  861315100 => "Wuxi\,\ Jiangsu",
  861315101 => "Wuxi\,\ Jiangsu",
  861315102 => "Wuxi\,\ Jiangsu",
  861315103 => "Wuxi\,\ Jiangsu",
  861315104 => "Wuxi\,\ Jiangsu",
  861315105 => "Nanjing\,\ Jiangsu",
  861315106 => "Nanjing\,\ Jiangsu",
  861315107 => "Nanjing\,\ Jiangsu",
  861315108 => "Nanjing\,\ Jiangsu",
  861315109 => "Nanjing\,\ Jiangsu",
  861315110 => "Yangzhou\,\ Jiangsu",
  861315111 => "Yangzhou\,\ Jiangsu",
  861315112 => "Yangzhou\,\ Jiangsu",
  861315113 => "Yangzhou\,\ Jiangsu",
  861315114 => "Yangzhou\,\ Jiangsu",
  861315115 => "Suzhou\,\ Jiangsu",
  861315116 => "Suzhou\,\ Jiangsu",
  861315117 => "Suzhou\,\ Jiangsu",
  861315118 => "Suzhou\,\ Jiangsu",
  861315119 => "Suzhou\,\ Jiangsu",
  861315120 => "Xuzhou\,\ Jiangsu",
  861315121 => "Xuzhou\,\ Jiangsu",
  861315122 => "Xuzhou\,\ Jiangsu",
  861315123 => "Xuzhou\,\ Jiangsu",
  861315124 => "Xuzhou\,\ Jiangsu",
  861315125 => "Changzhou\,\ Jiangsu",
  861315126 => "Changzhou\,\ Jiangsu",
  861315127 => "Changzhou\,\ Jiangsu",
  861315128 => "Changzhou\,\ Jiangsu",
  861315129 => "Changzhou\,\ Jiangsu",
  861315130 => "HuaiAn\,\ Jiangsu",
  861315131 => "HuaiAn\,\ Jiangsu",
  861315132 => "HuaiAn\,\ Jiangsu",
  861315133 => "HuaiAn\,\ Jiangsu",
  861315134 => "HuaiAn\,\ Jiangsu",
  861315135 => "Yancheng\,\ Jiangsu",
  861315136 => "Yancheng\,\ Jiangsu",
  861315137 => "Lianyungang\,\ Jiangsu",
  861315138 => "Lianyungang\,\ Jiangsu",
  861315139 => "Lianyungang\,\ Jiangsu",
  861315140 => "Nanjing\,\ Jiangsu",
  861315141 => "Nanjing\,\ Jiangsu",
  861315142 => "Nanjing\,\ Jiangsu",
  861315143 => "Yangzhou\,\ Jiangsu",
  861315144 => "Lianyungang\,\ Jiangsu",
  861315145 => "Wuxi\,\ Jiangsu",
  861315146 => "Suzhou\,\ Jiangsu",
  861315147 => "Suzhou\,\ Jiangsu",
  861315148 => "Suzhou\,\ Jiangsu",
  861315149 => "Suzhou\,\ Jiangsu",
  861315150 => "Yangzhou\,\ Jiangsu",
  861315151 => "Yangzhou\,\ Jiangsu",
  861315152 => "Nanjing\,\ Jiangsu",
  861315153 => "Nanjing\,\ Jiangsu",
  861315154 => "Nanjing\,\ Jiangsu",
  861315155 => "Nanjing\,\ Jiangsu",
  861315156 => "Nanjing\,\ Jiangsu",
  861315157 => "Nanjing\,\ Jiangsu",
  861315158 => "Nanjing\,\ Jiangsu",
  861315159 => "Nanjing\,\ Jiangsu",
  861315160 => "Yangzhou\,\ Jiangsu",
  861315161 => "Yangzhou\,\ Jiangsu",
  861315162 => "Suzhou\,\ Jiangsu",
  861315163 => "Suzhou\,\ Jiangsu",
  861315164 => "Suzhou\,\ Jiangsu",
  861315165 => "Suzhou\,\ Jiangsu",
  861315166 => "Suzhou\,\ Jiangsu",
  861315167 => "Zhenjiang\,\ Jiangsu",
  861315168 => "Zhenjiang\,\ Jiangsu",
  861315169 => "Zhenjiang\,\ Jiangsu",
  861315170 => "Lianyungang\,\ Jiangsu",
  861315171 => "Lianyungang\,\ Jiangsu",
  861315172 => "Lianyungang\,\ Jiangsu",
  861315173 => "Lianyungang\,\ Jiangsu",
  861315174 => "Lianyungang\,\ Jiangsu",
  861315175 => "Lianyungang\,\ Jiangsu",
  861315176 => "Lianyungang\,\ Jiangsu",
  861315177 => "Lianyungang\,\ Jiangsu",
  861315178 => "Xuzhou\,\ Jiangsu",
  861315179 => "Xuzhou\,\ Jiangsu",
  861315180 => "Suqian\,\ Jiangsu",
  861315181 => "Suqian\,\ Jiangsu",
  861315182 => "Suqian\,\ Jiangsu",
  861315183 => "Suqian\,\ Jiangsu",
  861315184 => "HuaiAn\,\ Jiangsu",
  861315185 => "HuaiAn\,\ Jiangsu",
  861315186 => "HuaiAn\,\ Jiangsu",
  861315187 => "HuaiAn\,\ Jiangsu",
  861315188 => "HuaiAn\,\ Jiangsu",
  861315189 => "HuaiAn\,\ Jiangsu",
  861315190 => "Wuxi\,\ Jiangsu",
  861315191 => "Wuxi\,\ Jiangsu",
  861315192 => "Wuxi\,\ Jiangsu",
  861315193 => "Wuxi\,\ Jiangsu",
  861315194 => "Wuxi\,\ Jiangsu",
  861315195 => "Wuxi\,\ Jiangsu",
  861315196 => "Wuxi\,\ Jiangsu",
  861315197 => "Wuxi\,\ Jiangsu",
  861315198 => "Xuzhou\,\ Jiangsu",
  861315199 => "Xuzhou\,\ Jiangsu",
  86131520 => "XiAn\,\ Shaanxi",
  86131521 => "XiAn\,\ Shaanxi",
  861315220 => "Baoji\,\ Shaanxi",
  861315221 => "Baoji\,\ Shaanxi",
  861315222 => "Baoji\,\ Shaanxi",
  861315223 => "Baoji\,\ Shaanxi",
  861315224 => "Baoji\,\ Shaanxi",
  861315225 => "Shangluo\,\ Shaanxi",
  861315226 => "Shangluo\,\ Shaanxi",
  861315227 => "Tongchuan\,\ Shaanxi",
  861315228 => "Tongchuan\,\ Shaanxi",
  861315229 => "Tongchuan\,\ Shaanxi",
  861315230 => "Xianyang\,\ Shaanxi",
  861315231 => "Xianyang\,\ Shaanxi",
  861315232 => "Xianyang\,\ Shaanxi",
  861315233 => "Xianyang\,\ Shaanxi",
  861315234 => "Xianyang\,\ Shaanxi",
  861315235 => "Weinan\,\ Shaanxi",
  861315236 => "Weinan\,\ Shaanxi",
  861315237 => "Weinan\,\ Shaanxi",
  861315238 => "Weinan\,\ Shaanxi",
  861315239 => "Weinan\,\ Shaanxi",
  86131524 => "XiAn\,\ Shaanxi",
  861315250 => "Nanning\,\ Guangxi",
  861315251 => "Nanning\,\ Guangxi",
  861315252 => "Liuzhou\,\ Guangxi",
  861315253 => "Guilin\,\ Guangxi",
  861315254 => "Liuzhou\,\ Guangxi",
  861315255 => "Liuzhou\,\ Guangxi",
  861315256 => "Liuzhou\,\ Guangxi",
  861315257 => "Guilin\,\ Guangxi",
  861315258 => "Guilin\,\ Guangxi",
  861315259 => "Guilin\,\ Guangxi",
  861315260 => "Nanning\,\ Guangxi",
  861315261 => "Nanning\,\ Guangxi",
  861315262 => "Liuzhou\,\ Guangxi",
  861315263 => "Guilin\,\ Guangxi",
  861315264 => "Nanning\,\ Guangxi",
  861315265 => "Nanning\,\ Guangxi",
  861315266 => "Nanning\,\ Guangxi",
  861315267 => "Nanning\,\ Guangxi",
  861315268 => "Nanning\,\ Guangxi",
  861315269 => "Nanning\,\ Guangxi",
  861315270 => "Xinzhou\,\ Shanxi",
  861315271 => "Shuozhou\,\ Shanxi",
  861315272 => "Datong\,\ Shanxi",
  861315273 => "Yangquan\,\ Shanxi",
  861315274 => "Yuncheng\,\ Shanxi",
  861315275 => "Changzhi\,\ Shanxi",
  861315276 => "Jincheng\,\ Shanxi",
  861315277 => "Linfen\,\ Shanxi",
  861315278 => "Lüliang\,\ Shanxi",
  861315279 => "Yuncheng\,\ Shanxi",
  861315280 => "Linfen\,\ Shanxi",
  861315281 => "Jinzhong\,\ Shanxi",
  861315282 => "Datong\,\ Shanxi",
  861315283 => "Yangquan\,\ Shanxi",
  861315284 => "Xinzhou\,\ Shanxi",
  861315285 => "Changzhi\,\ Shanxi",
  861315286 => "Jincheng\,\ Shanxi",
  861315287 => "Linfen\,\ Shanxi",
  861315288 => "Jinzhong\,\ Shanxi",
  861315289 => "Yuncheng\,\ Shanxi",
  861315290 => "Xinzhou\,\ Shanxi",
  861315291 => "Jinzhong\,\ Shanxi",
  861315292 => "Datong\,\ Shanxi",
  861315293 => "Shuozhou\,\ Shanxi",
  861315294 => "Datong\,\ Shanxi",
  861315295 => "Changzhi\,\ Shanxi",
  861315296 => "Jincheng\,\ Shanxi",
  861315297 => "Linfen\,\ Shanxi",
  861315298 => "Lüliang\,\ Shanxi",
  861315299 => "Yuncheng\,\ Shanxi",
  861315300 => "Jinan\,\ Shandong",
  861315301 => "Jinan\,\ Shandong",
  861315302 => "Jinan\,\ Shandong",
  861315303 => "Jinan\,\ Shandong",
  861315304 => "Jinan\,\ Shandong",
  861315305 => "Zaozhuang\,\ Shandong",
  861315306 => "Zaozhuang\,\ Shandong",
  861315307 => "Heze\,\ Shandong",
  861315308 => "Heze\,\ Shandong",
  861315309 => "Heze\,\ Shandong",
  86131531 => "Jinan\,\ Shandong",
  86131532 => "Qingdao\,\ Shandong",
  861315330 => "Weihai\,\ Shandong",
  861315331 => "Weihai\,\ Shandong",
  861315332 => "Zaozhuang\,\ Shandong",
  861315333 => "Rizhao\,\ Shandong",
  861315334 => "Rizhao\,\ Shandong",
  861315335 => "Zibo\,\ Shandong",
  861315336 => "Zibo\,\ Shandong",
  861315337 => "Zibo\,\ Shandong",
  861315338 => "Zibo\,\ Shandong",
  861315339 => "Zibo\,\ Shandong",
  861315340 => "Weihai\,\ Shandong",
  861315341 => "Dongying\,\ Shandong",
  861315342 => "Binzhou\,\ Shandong",
  861315343 => "Zaozhuang\,\ Shandong",
  861315344 => "Zaozhuang\,\ Shandong",
  861315345 => "Dezhou\,\ Shandong",
  861315346 => "Dezhou\,\ Shandong",
  861315347 => "Dezhou\,\ Shandong",
  861315348 => "Dezhou\,\ Shandong",
  861315349 => "Dezhou\,\ Shandong",
  861315350 => "Yantai\,\ Shandong",
  861315351 => "Yantai\,\ Shandong",
  861315352 => "Yantai\,\ Shandong",
  861315353 => "Yantai\,\ Shandong",
  861315354 => "Yantai\,\ Shandong",
  861315355 => "Dongying\,\ Shandong",
  861315356 => "Dongying\,\ Shandong",
  861315357 => "Weihai\,\ Shandong",
  861315358 => "Binzhou\,\ Shandong",
  861315359 => "Binzhou\,\ Shandong",
  86131536 => "Weifang\,\ Shandong",
  86131537 => "Jining\,\ Shandong",
  861315380 => "Liaocheng\,\ Shandong",
  861315381 => "Liaocheng\,\ Shandong",
  861315382 => "Liaocheng\,\ Shandong",
  861315383 => "Laiwu\,\ Shandong",
  861315384 => "TaiAn\,\ Shandong",
  861315385 => "TaiAn\,\ Shandong",
  861315386 => "TaiAn\,\ Shandong",
  861315387 => "TaiAn\,\ Shandong",
  861315388 => "TaiAn\,\ Shandong",
  861315389 => "TaiAn\,\ Shandong",
  86131539 => "Linyi\,\ Shandong",
  861315400 => "Yulin\,\ Shaanxi",
  861315401 => "Yulin\,\ Shaanxi",
  861315402 => "Yulin\,\ Shaanxi",
  861315403 => "Ankang\,\ Shaanxi",
  861315404 => "Ankang\,\ Shaanxi",
  861315405 => "Ankang\,\ Shaanxi",
  861315406 => "Shangluo\,\ Shaanxi",
  861315407 => "Shangluo\,\ Shaanxi",
  861315408 => "Tongchuan\,\ Shaanxi",
  861315409 => "Tongchuan\,\ Shaanxi",
  861315410 => "Tieling\,\ Liaoning",
  861315411 => "Dalian\,\ Liaoning",
  861315412 => "Anshan\,\ Liaoning",
  861315413 => "Fushun\,\ Liaoning",
  861315414 => "Benxi\,\ Liaoning",
  861315415 => "Dandong\,\ Liaoning",
  861315416 => "Jinzhou\,\ Liaoning",
  861315417 => "Yingkou\,\ Liaoning",
  861315418 => "Fuxin\,\ Liaoning",
  861315419 => "Liaoyang\,\ Liaoning",
  861315420 => "Tieling\,\ Liaoning",
  861315421 => "Chaoyang\,\ Liaoning",
  861315422 => "Chaoyang\,\ Liaoning",
  861315423 => "Fushun\,\ Liaoning",
  861315424 => "Jinzhou\,\ Liaoning",
  861315425 => "Anshan\,\ Liaoning",
  861315426 => "Dalian\,\ Liaoning",
  861315427 => "Panjin\,\ Liaoning",
  861315428 => "Panjin\,\ Liaoning",
  861315429 => "Huludao\,\ Liaoning",
  861315430 => "Changchun\,\ Jilin",
  861315431 => "Changchun\,\ Jilin",
  861315432 => "Jilin\,\ Jilin",
  861315433 => "Yanbian\,\ Jilin",
  861315434 => "Siping\,\ Jilin",
  861315435 => "Changchun\,\ Jilin",
  861315436 => "Changchun\,\ Jilin",
  861315437 => "Changchun\,\ Jilin",
  861315438 => "Songyuan\,\ Jilin",
  861315439 => "Changchun\,\ Jilin",
  861315440 => "Aba\,\ Sichuan",
  861315441 => "Garze\,\ Sichuan",
  861315442 => "Guangyuan\,\ Sichuan",
  861315443 => "Guangyuan\,\ Sichuan",
  861315444 => "Mianyang\,\ Sichuan",
  861315445 => "Mianyang\,\ Sichuan",
  861315446 => "Mianyang\,\ Sichuan",
  861315447 => "Deyang\,\ Sichuan",
  861315448 => "Deyang\,\ Sichuan",
  861315449 => "Deyang\,\ Sichuan",
  861315450 => "Harbin\,\ Heilongjiang",
  861315451 => "Harbin\,\ Heilongjiang",
  861315452 => "Qiqihar\,\ Heilongjiang",
  861315453 => "Mudanjiang\,\ Heilongjiang",
  861315454 => "Jiamusi\,\ Heilongjiang",
  861315455 => "Suihua\,\ Heilongjiang",
  861315456 => "Heihe\,\ Heilongjiang",
  861315457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861315458 => "Yichun\,\ Heilongjiang",
  861315459 => "Daqing\,\ Heilongjiang",
  861315460 => "Luzhou\,\ Sichuan",
  861315461 => "Ziyang\,\ Sichuan",
  861315462 => "Ziyang\,\ Sichuan",
  861315463 => "Zigong\,\ Sichuan",
  861315464 => "Zigong\,\ Sichuan",
  861315465 => "Zigong\,\ Sichuan",
  861315466 => "Zigong\,\ Sichuan",
  861315467 => "Zigong\,\ Sichuan",
  861315468 => "Neijiang\,\ Sichuan",
  861315469 => "Yibin\,\ Sichuan",
  861315470 => "Hulun\,\ Inner\ Mongolia",
  861315471 => "Hohhot\,\ Inner\ Mongolia",
  861315472 => "Baotou\,\ Inner\ Mongolia",
  861315473 => "Wuhai\,\ Inner\ Mongolia",
  861315474 => "Ulanqab\,\ Inner\ Mongolia",
  861315475 => "Tongliao\,\ Inner\ Mongolia",
  861315476 => "Chifeng\,\ Inner\ Mongolia",
  861315477 => "Ordos\,\ Inner\ Mongolia",
  861315478 => "Bayannur\,\ Inner\ Mongolia",
  861315479 => "Xilin\,\ Inner\ Mongolia",
  861315480 => "Hohhot\,\ Inner\ Mongolia",
  861315481 => "Hohhot\,\ Inner\ Mongolia",
  861315482 => "Hinggan\,\ Inner\ Mongolia",
  861315483 => "Alxa\,\ Inner\ Mongolia",
  861315484 => "Chifeng\,\ Inner\ Mongolia",
  861315485 => "Chifeng\,\ Inner\ Mongolia",
  861315486 => "Chifeng\,\ Inner\ Mongolia",
  861315487 => "Hohhot\,\ Inner\ Mongolia",
  861315488 => "Hohhot\,\ Inner\ Mongolia",
  861315489 => "Tongliao\,\ Inner\ Mongolia",
  861315490 => "Panzhihua\,\ Sichuan",
  861315491 => "Panzhihua\,\ Sichuan",
  861315492 => "Liangshan\,\ Sichuan",
  861315493 => "Ankang\,\ Shaanxi",
  861315494 => "Meishan\,\ Sichuan",
  861315495 => "Meishan\,\ Sichuan",
  861315496 => "Meishan\,\ Sichuan",
  861315497 => "Leshan\,\ Sichuan",
  861315498 => "Leshan\,\ Sichuan",
  861315499 => "Leshan\,\ Sichuan",
  86131550 => "Chuzhou\,\ Anhui",
  86131551 => "Hefei\,\ Anhui",
  86131552 => "Bengbu\,\ Anhui",
  861315530 => "Wuhu\,\ Anhui",
  861315531 => "Wuhu\,\ Anhui",
  861315532 => "Wuhu\,\ Anhui",
  861315533 => "Wuhu\,\ Anhui",
  861315534 => "Wuhu\,\ Anhui",
  861315535 => "MaAnshan\,\ Anhui",
  861315536 => "MaAnshan\,\ Anhui",
  861315537 => "Xuancheng\,\ Anhui",
  861315538 => "LuAn\,\ Anhui",
  861315539 => "LuAn\,\ Anhui",
  86131554 => "Huainan\,\ Anhui",
  861315550 => "MaAnshan\,\ Anhui",
  861315551 => "MaAnshan\,\ Anhui",
  861315552 => "MaAnshan\,\ Anhui",
  861315553 => "MaAnshan\,\ Anhui",
  861315554 => "MaAnshan\,\ Anhui",
  861315555 => "MaAnshan\,\ Anhui",
  861315556 => "Anqing\,\ Anhui",
  861315557 => "Suzhou\,\ Anhui",
  861315558 => "Fuyang\,\ Anhui",
  861315559 => "Huangshan\,\ Anhui",
  861315560 => "Anqing\,\ Anhui",
  861315561 => "Huaibei\,\ Anhui",
  861315562 => "Tongling\,\ Anhui",
  861315563 => "Xuancheng\,\ Anhui",
  861315564 => "LuAn\,\ Anhui",
  861315565 => "Hefei\,\ Anhui",
  861315566 => "Chizhou\,\ Anhui",
  861315567 => "Bozhou\,\ Anhui",
  861315568 => "Bozhou\,\ Anhui",
  861315569 => "Anqing\,\ Anhui",
  861315570 => "Jiujiang\,\ Jiangxi",
  861315571 => "Jiujiang\,\ Jiangxi",
  861315572 => "Jiujiang\,\ Jiangxi",
  861315573 => "Jiujiang\,\ Jiangxi",
  861315574 => "Jingdezhen\,\ Jiangxi",
  861315575 => "Jingdezhen\,\ Jiangxi",
  861315576 => "Jingdezhen\,\ Jiangxi",
  861315577 => "Jingdezhen\,\ Jiangxi",
  861315578 => "Jingdezhen\,\ Jiangxi",
  861315579 => "Ganzhou\,\ Jiangxi",
  861315580 => "Nanchang\,\ Jiangxi",
  861315581 => "Nanchang\,\ Jiangxi",
  861315582 => "Nanchang\,\ Jiangxi",
  861315583 => "Nanchang\,\ Jiangxi",
  861315584 => "JiAn\,\ Jiangxi",
  861315585 => "JiAn\,\ Jiangxi",
  861315586 => "JiAn\,\ Jiangxi",
  861315587 => "Fuzhou\,\ Jiangxi",
  861315588 => "Fuzhou\,\ Jiangxi",
  861315589 => "Fuzhou\,\ Jiangxi",
  861315590 => "Shangrao\,\ Jiangxi",
  861315591 => "Shangrao\,\ Jiangxi",
  861315592 => "Shangrao\,\ Jiangxi",
  861315593 => "Shangrao\,\ Jiangxi",
  861315594 => "Pingxiang\,\ Jiangxi",
  861315595 => "Pingxiang\,\ Jiangxi",
  861315596 => "Pingxiang\,\ Jiangxi",
  861315597 => "Pingxiang\,\ Jiangxi",
  861315598 => "Jiujiang\,\ Jiangxi",
  861315599 => "Ganzhou\,\ Jiangxi",
  861315600 => "Jinan\,\ Shandong",
  861315601 => "Jinan\,\ Shandong",
  861315602 => "Zaozhuang\,\ Shandong",
  861315603 => "Qingdao\,\ Shandong",
  861315604 => "Qingdao\,\ Shandong",
  861315605 => "Qingdao\,\ Shandong",
  861315606 => "Dongying\,\ Shandong",
  861315607 => "Dongying\,\ Shandong",
  861315608 => "Weihai\,\ Shandong",
  861315609 => "Weihai\,\ Shandong",
  86131561 => "Jinan\,\ Shandong",
  86131562 => "Qingdao\,\ Shandong",
  861315630 => "Weihai\,\ Shandong",
  861315631 => "Weihai\,\ Shandong",
  861315632 => "Zaozhuang\,\ Shandong",
  861315633 => "Rizhao\,\ Shandong",
  861315634 => "Laiwu\,\ Shandong",
  861315635 => "Liaocheng\,\ Shandong",
  861315636 => "Qingdao\,\ Shandong",
  861315637 => "Qingdao\,\ Shandong",
  861315638 => "Qingdao\,\ Shandong",
  861315639 => "Qingdao\,\ Shandong",
  861315640 => "Jinan\,\ Shandong",
  861315641 => "Jinan\,\ Shandong",
  861315642 => "Qingdao\,\ Shandong",
  861315643 => "Zibo\,\ Shandong",
  861315644 => "Jinan\,\ Shandong",
  861315645 => "Yantai\,\ Shandong",
  861315646 => "Weifang\,\ Shandong",
  861315647 => "Dongying\,\ Shandong",
  861315648 => "Qingdao\,\ Shandong",
  861315649 => "Binzhou\,\ Shandong",
  86131565 => "Hefei\,\ Anhui",
  86131566 => "Chizhou\,\ Anhui",
  86131567 => "Bozhou\,\ Anhui",
  861315680 => "Dongying\,\ Shandong",
  861315681 => "Dongying\,\ Shandong",
  861315682 => "Zaozhuang\,\ Shandong",
  861315683 => "Binzhou\,\ Shandong",
  861315684 => "Heze\,\ Shandong",
  861315685 => "Qingdao\,\ Shandong",
  861315686 => "Qingdao\,\ Shandong",
  861315687 => "Qingdao\,\ Shandong",
  861315688 => "Qingdao\,\ Shandong",
  861315689 => "Qingdao\,\ Shandong",
  861315690 => "Yantai\,\ Shandong",
  861315691 => "Yantai\,\ Shandong",
  861315692 => "Yantai\,\ Shandong",
  861315693 => "Yantai\,\ Shandong",
  861315694 => "Yantai\,\ Shandong",
  861315695 => "Yantai\,\ Shandong",
  861315696 => "Weifang\,\ Shandong",
  861315697 => "TaiAn\,\ Shandong",
  861315698 => "Zibo\,\ Shandong",
  861315699 => "Rizhao\,\ Shandong",
  86131570 => "Quzhou\,\ Zhejiang",
  86131571 => "Hangzhou\,\ Zhejiang",
  86131572 => "Huzhou\,\ Zhejiang",
  86131573 => "Jiaxing\,\ Zhejiang",
  86131574 => "Ningbo\,\ Zhejiang",
  86131575 => "Shaoxing\,\ Zhejiang",
  86131576 => "Taizhou\,\ Zhejiang",
  86131577 => "Wenzhou\,\ Zhejiang",
  86131578 => "Lishui\,\ Zhejiang",
  86131579 => "Jinhua\,\ Zhejiang",
  86131580 => "Guiyang\,\ Guizhou",
  861315810 => "Qiandongnan\,\ Guizhou",
  861315811 => "Zunyi\,\ Guizhou",
  861315812 => "Zunyi\,\ Guizhou",
  861315813 => "Anshun\,\ Guizhou",
  861315814 => "Qiannan\,\ Guizhou",
  861315815 => "Qiandongnan\,\ Guizhou",
  861315816 => "Qiannan\,\ Guizhou",
  861315817 => "Liupanshui\,\ Guizhou",
  861315818 => "Liupanshui\,\ Guizhou",
  861315819 => "Qianxinan\,\ Guizhou",
  861315820 => "Zunyi\,\ Guizhou",
  861315821 => "Zunyi\,\ Guizhou",
  861315822 => "Zunyi\,\ Guizhou",
  861315823 => "Anshun\,\ Guizhou",
  861315824 => "Qiannan\,\ Guizhou",
  861315825 => "Qiandongnan\,\ Guizhou",
  861315826 => "Tongren\,\ Guizhou",
  861315827 => "Bijie\,\ Guizhou",
  861315828 => "Liupanshui\,\ Guizhou",
  861315829 => "Qianxinan\,\ Guizhou",
  861315830 => "Qianxinan\,\ Guizhou",
  861315831 => "Anshun\,\ Guizhou",
  861315832 => "Zunyi\,\ Guizhou",
  861315833 => "Anshun\,\ Guizhou",
  861315834 => "Qiannan\,\ Guizhou",
  861315835 => "Qiandongnan\,\ Guizhou",
  861315836 => "Tongren\,\ Guizhou",
  861315837 => "Qiandongnan\,\ Guizhou",
  861315838 => "Liupanshui\,\ Guizhou",
  861315839 => "Qianxinan\,\ Guizhou",
  861315840 => "Garze\,\ Sichuan",
  861315841 => "Aba\,\ Sichuan",
  861315842 => "Dazhou\,\ Sichuan",
  861315843 => "Bazhong\,\ Sichuan",
  861315844 => "Deyang\,\ Sichuan",
  861315845 => "Mianyang\,\ Sichuan",
  861315846 => "GuangAn\,\ Sichuan",
  861315847 => "Liangshan\,\ Sichuan",
  861315848 => "Suining\,\ Sichuan",
  861315849 => "Ziyang\,\ Sichuan",
  861315850 => "Nanchong\,\ Sichuan",
  861315851 => "Nanchong\,\ Sichuan",
  861315852 => "Nanchong\,\ Sichuan",
  861315853 => "YaAn\,\ Sichuan",
  861315854 => "YaAn\,\ Sichuan",
  861315855 => "Liangshan\,\ Sichuan",
  861315856 => "Panzhihua\,\ Sichuan",
  861315857 => "Neijiang\,\ Sichuan",
  861315858 => "Neijiang\,\ Sichuan",
  861315859 => "Neijiang\,\ Sichuan",
  861315860 => "Luzhou\,\ Sichuan",
  861315861 => "Luzhou\,\ Sichuan",
  861315862 => "Luzhou\,\ Sichuan",
  861315863 => "Yibin\,\ Sichuan",
  861315864 => "Yibin\,\ Sichuan",
  861315865 => "Yibin\,\ Sichuan",
  861315866 => "Deyang\,\ Sichuan",
  861315867 => "Deyang\,\ Sichuan",
  861315868 => "Deyang\,\ Sichuan",
  861315869 => "Deyang\,\ Sichuan",
  861315870 => "Dazhou\,\ Sichuan",
  861315871 => "Bazhong\,\ Sichuan",
  861315872 => "GuangAn\,\ Sichuan",
  861315873 => "Suining\,\ Sichuan",
  861315874 => "Guangyuan\,\ Sichuan",
  861315875 => "Guangyuan\,\ Sichuan",
  861315876 => "Meishan\,\ Sichuan",
  861315877 => "Meishan\,\ Sichuan",
  861315878 => "Ziyang\,\ Sichuan",
  861315879 => "Panzhihua\,\ Sichuan",
  861315880 => "Zigong\,\ Sichuan",
  861315881 => "Zigong\,\ Sichuan",
  861315882 => "Zigong\,\ Sichuan",
  861315883 => "Leshan\,\ Sichuan",
  861315884 => "Leshan\,\ Sichuan",
  861315885 => "Leshan\,\ Sichuan",
  861315886 => "Mianyang\,\ Sichuan",
  861315887 => "Mianyang\,\ Sichuan",
  861315888 => "Mianyang\,\ Sichuan",
  861315889 => "Mianyang\,\ Sichuan",
  86131589 => "Haikou\,\ Hainan",
  86131590 => "Quanzhou\,\ Fujian",
  86131591 => "Zhangzhou\,\ Fujian",
  861315920 => "Xiamen\,\ Fujian",
  861315921 => "Xiamen\,\ Fujian",
  861315922 => "Xiamen\,\ Fujian",
  861315923 => "Xiamen\,\ Fujian",
  861315924 => "Sanming\,\ Fujian",
  861315925 => "Xiamen\,\ Fujian",
  861315926 => "Xiamen\,\ Fujian",
  861315927 => "Xiamen\,\ Fujian",
  861315928 => "Nanping\,\ Fujian",
  861315929 => "Nanping\,\ Fujian",
  861315930 => "Longyan\,\ Fujian",
  861315931 => "Longyan\,\ Fujian",
  861315932 => "Longyan\,\ Fujian",
  861315933 => "Putian\,\ Fujian",
  861315934 => "Ningde\,\ Fujian",
  861315935 => "Ningde\,\ Fujian",
  861315936 => "Sanming\,\ Fujian",
  861315937 => "Sanming\,\ Fujian",
  861315938 => "Sanming\,\ Fujian",
  861315939 => "Sanming\,\ Fujian",
  861315940 => "Fuzhou\,\ Fujian",
  861315941 => "Fuzhou\,\ Fujian",
  861315942 => "Fuzhou\,\ Fujian",
  861315943 => "Fuzhou\,\ Fujian",
  861315944 => "Putian\,\ Fujian",
  861315945 => "Putian\,\ Fujian",
  861315946 => "Zhangzhou\,\ Fujian",
  861315947 => "Zhangzhou\,\ Fujian",
  861315948 => "Zhangzhou\,\ Fujian",
  861315949 => "Zhangzhou\,\ Fujian",
  861315950 => "Changchun\,\ Jilin",
  861315951 => "Changchun\,\ Jilin",
  861315952 => "Changchun\,\ Jilin",
  861315953 => "Changchun\,\ Jilin",
  861315954 => "Jilin\,\ Jilin",
  861315955 => "Jilin\,\ Jilin",
  861315956 => "Changchun\,\ Jilin",
  861315957 => "Jilin\,\ Jilin",
  861315958 => "Songyuan\,\ Jilin",
  861315959 => "Baicheng\,\ Jilin",
  861315960 => "Changchun\,\ Jilin",
  861315961 => "Changchun\,\ Jilin",
  861315962 => "Siping\,\ Jilin",
  861315963 => "Yanbian\,\ Jilin",
  861315964 => "Changchun\,\ Jilin",
  861315965 => "Tonghua\,\ Jilin",
  861315966 => "Jilin\,\ Jilin",
  861315967 => "Songyuan\,\ Jilin",
  861315968 => "Changchun\,\ Jilin",
  861315969 => "Baishan\,\ Jilin",
  861315970 => "Jilin\,\ Jilin",
  861315971 => "Songyuan\,\ Jilin",
  861315972 => "Tonghua\,\ Jilin",
  861315973 => "Tonghua\,\ Jilin",
  861315974 => "Changchun\,\ Jilin",
  861315975 => "Changchun\,\ Jilin",
  861315976 => "Baicheng\,\ Jilin",
  861315977 => "Changchun\,\ Jilin",
  861315978 => "Siping\,\ Jilin",
  861315979 => "Baishan\,\ Jilin",
  861315980 => "Harbin\,\ Heilongjiang",
  861315981 => "Daqing\,\ Heilongjiang",
  861315982 => "Daqing\,\ Heilongjiang",
  861315983 => "Daqing\,\ Heilongjiang",
  861315984 => "Harbin\,\ Heilongjiang",
  861315985 => "Harbin\,\ Heilongjiang",
  861315986 => "Harbin\,\ Heilongjiang",
  861315987 => "Harbin\,\ Heilongjiang",
  861315988 => "Hegang\,\ Heilongjiang",
  861315989 => "Jixi\,\ Heilongjiang",
  861315990 => "Shuangyashan\,\ Heilongjiang",
  861315991 => "Shuangyashan\,\ Heilongjiang",
  861315992 => "Hegang\,\ Heilongjiang",
  861315993 => "Hegang\,\ Heilongjiang",
  861315994 => "Daqing\,\ Heilongjiang",
  861315995 => "Jixi\,\ Heilongjiang",
  861315996 => "Qitaihe\,\ Heilongjiang",
  861315997 => "Jiamusi\,\ Heilongjiang",
  861315998 => "Jiamusi\,\ Heilongjiang",
  861315999 => "Daqing\,\ Heilongjiang",
  861316000 => "HuaiAn\,\ Jiangsu",
  861316001 => "HuaiAn\,\ Jiangsu",
  861316002 => "Nanjing\,\ Jiangsu",
  861316003 => "Nanjing\,\ Jiangsu",
  861316004 => "Nanjing\,\ Jiangsu",
  861316005 => "Nanjing\,\ Jiangsu",
  861316006 => "Nanjing\,\ Jiangsu",
  861316007 => "Nanjing\,\ Jiangsu",
  861316008 => "Nanjing\,\ Jiangsu",
  861316009 => "Nanjing\,\ Jiangsu",
  861316010 => "Suzhou\,\ Jiangsu",
  861316011 => "Suzhou\,\ Jiangsu",
  861316012 => "Suzhou\,\ Jiangsu",
  861316013 => "Suzhou\,\ Jiangsu",
  861316014 => "Suzhou\,\ Jiangsu",
  861316015 => "Suzhou\,\ Jiangsu",
  861316016 => "Suzhou\,\ Jiangsu",
  861316017 => "Yancheng\,\ Jiangsu",
  861316018 => "Yancheng\,\ Jiangsu",
  861316019 => "Yancheng\,\ Jiangsu",
  861316020 => "Zhenjiang\,\ Jiangsu",
  861316021 => "Zhenjiang\,\ Jiangsu",
  861316022 => "Zhenjiang\,\ Jiangsu",
  861316023 => "Xuzhou\,\ Jiangsu",
  861316024 => "Xuzhou\,\ Jiangsu",
  861316025 => "Xuzhou\,\ Jiangsu",
  861316026 => "Xuzhou\,\ Jiangsu",
  861316027 => "Xuzhou\,\ Jiangsu",
  861316028 => "Xuzhou\,\ Jiangsu",
  861316029 => "Xuzhou\,\ Jiangsu",
  861316030 => "Yangzhou\,\ Jiangsu",
  861316031 => "Yangzhou\,\ Jiangsu",
  861316032 => "Yangzhou\,\ Jiangsu",
  861316033 => "Suqian\,\ Jiangsu",
  861316034 => "Suqian\,\ Jiangsu",
  861316035 => "Suqian\,\ Jiangsu",
  861316036 => "Nantong\,\ Jiangsu",
  861316037 => "Nantong\,\ Jiangsu",
  861316038 => "Nantong\,\ Jiangsu",
  861316039 => "Nantong\,\ Jiangsu",
  861316040 => "Yangzhou\,\ Jiangsu",
  861316041 => "Yangzhou\,\ Jiangsu",
  861316042 => "Suzhou\,\ Jiangsu",
  861316043 => "Suzhou\,\ Jiangsu",
  861316044 => "Yancheng\,\ Jiangsu",
  861316045 => "Yancheng\,\ Jiangsu",
  861316046 => "Nanjing\,\ Jiangsu",
  861316047 => "Nanjing\,\ Jiangsu",
  861316048 => "Xuzhou\,\ Jiangsu",
  861316049 => "Nantong\,\ Jiangsu",
  861316050 => "Yangjiang\,\ Guangdong",
  861316051 => "Yangjiang\,\ Guangdong",
  861316052 => "Yangjiang\,\ Guangdong",
  861316053 => "Yangjiang\,\ Guangdong",
  861316054 => "Yangjiang\,\ Guangdong",
  861316055 => "Qingyuan\,\ Guangdong",
  861316056 => "Qingyuan\,\ Guangdong",
  861316057 => "Qingyuan\,\ Guangdong",
  861316058 => "Qingyuan\,\ Guangdong",
  861316059 => "Qingyuan\,\ Guangdong",
  861316060 => "Chaozhou\,\ Guangdong",
  861316061 => "Chaozhou\,\ Guangdong",
  861316062 => "Chaozhou\,\ Guangdong",
  861316063 => "Chaozhou\,\ Guangdong",
  861316064 => "Zhuhai\,\ Guangdong",
  861316065 => "Zhuhai\,\ Guangdong",
  861316066 => "Zhuhai\,\ Guangdong",
  861316067 => "Zhuhai\,\ Guangdong",
  861316068 => "Zhuhai\,\ Guangdong",
  861316069 => "Zhuhai\,\ Guangdong",
  86131607 => "Huizhou\,\ Guangdong",
  86131608 => "Guangzhou\,\ Guangdong",
  86131609 => "Foshan\,\ Guangdong",
  8613161 => "Beijing",
  8613162 => "Shanghai",
  86131630 => "Tianjin",
  86131631 => "Tianjin",
  86131632 => "Wuhan\,\ Hubei",
  86131633 => "Wuhan\,\ Hubei",
  861316340 => "Qiqihar\,\ Heilongjiang",
  861316341 => "Harbin\,\ Heilongjiang",
  861316342 => "Harbin\,\ Heilongjiang",
  861316343 => "Harbin\,\ Heilongjiang",
  861316344 => "Harbin\,\ Heilongjiang",
  861316345 => "Shuangyashan\,\ Heilongjiang",
  861316346 => "Hegang\,\ Heilongjiang",
  861316347 => "Suihua\,\ Heilongjiang",
  861316348 => "Suihua\,\ Heilongjiang",
  861316349 => "Jiamusi\,\ Heilongjiang",
  861316350 => "Jiamusi\,\ Heilongjiang",
  861316351 => "Jiamusi\,\ Heilongjiang",
  861316352 => "Daqing\,\ Heilongjiang",
  861316353 => "Daqing\,\ Heilongjiang",
  861316354 => "Daqing\,\ Heilongjiang",
  861316355 => "Daqing\,\ Heilongjiang",
  861316356 => "Jixi\,\ Heilongjiang",
  861316357 => "Suihua\,\ Heilongjiang",
  861316358 => "Suihua\,\ Heilongjiang",
  861316359 => "Suihua\,\ Heilongjiang",
  861316360 => "Mudanjiang\,\ Heilongjiang",
  861316361 => "Mudanjiang\,\ Heilongjiang",
  861316362 => "Mudanjiang\,\ Heilongjiang",
  861316363 => "Suihua\,\ Heilongjiang",
  861316364 => "Suihua\,\ Heilongjiang",
  861316365 => "Suihua\,\ Heilongjiang",
  861316366 => "Harbin\,\ Heilongjiang",
  861316367 => "Harbin\,\ Heilongjiang",
  861316368 => "Harbin\,\ Heilongjiang",
  861316369 => "Harbin\,\ Heilongjiang",
  86131637 => "Shenzhen\,\ Guangdong",
  861316380 => "Nanping\,\ Fujian",
  861316381 => "Longyan\,\ Fujian",
  861316382 => "Sanming\,\ Fujian",
  861316383 => "Ningde\,\ Fujian",
  861316384 => "Sanmenxia\,\ Henan",
  861316385 => "Ningde\,\ Fujian",
  861316386 => "Putian\,\ Fujian",
  861316387 => "Fuzhou\,\ Fujian",
  861316388 => "Fuzhou\,\ Fujian",
  861316389 => "Fuzhou\,\ Fujian",
  861316390 => "Xiamen\,\ Fujian",
  861316391 => "Quanzhou\,\ Fujian",
  861316392 => "Quanzhou\,\ Fujian",
  861316393 => "Quanzhou\,\ Fujian",
  861316394 => "Quanzhou\,\ Fujian",
  861316395 => "Quanzhou\,\ Fujian",
  861316396 => "Quanzhou\,\ Fujian",
  861316397 => "Zhangzhou\,\ Fujian",
  861316398 => "Zhangzhou\,\ Fujian",
  861316399 => "Xiamen\,\ Fujian",
  86131640 => "Tianjin",
  86131641 => "Wuhan\,\ Hubei",
  86131642 => "Beijing",
  86131643 => "Zhengzhou\,\ Henan",
  86131644 => "Chongqing",
  86131645 => "Dalian\,\ Liaoning",
  86131646 => "Wuhan\,\ Hubei",
  86131647 => "Shenzhen\,\ Guangdong",
  861316480 => "Fuzhou\,\ Fujian",
  861316481 => "Fuzhou\,\ Fujian",
  861316482 => "Fuzhou\,\ Fujian",
  861316483 => "Zhangzhou\,\ Fujian",
  861316484 => "Zhangzhou\,\ Fujian",
  861316485 => "Putian\,\ Fujian",
  861316486 => "Putian\,\ Fujian",
  861316487 => "Xiamen\,\ Fujian",
  861316488 => "Xiamen\,\ Fujian",
  861316489 => "Xiamen\,\ Fujian",
  861316490 => "Wenzhou\,\ Zhejiang",
  861316491 => "Wenzhou\,\ Zhejiang",
  861316492 => "Wenzhou\,\ Zhejiang",
  861316493 => "Jiaxing\,\ Zhejiang",
  861316494 => "Hangzhou\,\ Zhejiang",
  861316495 => "Hangzhou\,\ Zhejiang",
  861316496 => "Ningbo\,\ Zhejiang",
  861316497 => "Ningbo\,\ Zhejiang",
  861316498 => "Ningbo\,\ Zhejiang",
  861316499 => "Ningbo\,\ Zhejiang",
  86131650 => "Qingdao\,\ Shandong",
  861316510 => "Jinan\,\ Shandong",
  861316511 => "Jinan\,\ Shandong",
  861316512 => "Jinan\,\ Shandong",
  861316513 => "Jinan\,\ Shandong",
  861316514 => "Jinan\,\ Shandong",
  861316515 => "Qingdao\,\ Shandong",
  861316516 => "Qingdao\,\ Shandong",
  861316517 => "Jining\,\ Shandong",
  861316518 => "Jining\,\ Shandong",
  861316519 => "Jining\,\ Shandong",
  861316520 => "Rizhao\,\ Shandong",
  861316521 => "Zaozhuang\,\ Shandong",
  861316522 => "Zaozhuang\,\ Shandong",
  861316523 => "Dezhou\,\ Shandong",
  861316524 => "Dezhou\,\ Shandong",
  861316525 => "Dongying\,\ Shandong",
  861316526 => "Weifang\,\ Shandong",
  861316527 => "Linyi\,\ Shandong",
  861316528 => "Linyi\,\ Shandong",
  861316529 => "Linyi\,\ Shandong",
  861316530 => "Heze\,\ Shandong",
  861316531 => "Jinan\,\ Shandong",
  861316532 => "Qingdao\,\ Shandong",
  861316533 => "Zibo\,\ Shandong",
  861316534 => "Dezhou\,\ Shandong",
  861316535 => "Yantai\,\ Shandong",
  861316536 => "Weifang\,\ Shandong",
  861316537 => "Jining\,\ Shandong",
  861316538 => "TaiAn\,\ Shandong",
  861316539 => "Linyi\,\ Shandong",
  861316540 => "Liaocheng\,\ Shandong",
  861316541 => "Jinan\,\ Shandong",
  861316542 => "Qingdao\,\ Shandong",
  861316543 => "Binzhou\,\ Shandong",
  861316544 => "Zibo\,\ Shandong",
  861316545 => "Yantai\,\ Shandong",
  861316546 => "Dongying\,\ Shandong",
  861316547 => "Jining\,\ Shandong",
  861316548 => "Zibo\,\ Shandong",
  861316549 => "Linyi\,\ Shandong",
  861316550 => "Handan\,\ Hebei",
  861316551 => "Handan\,\ Hebei",
  861316552 => "Chengde\,\ Hebei",
  861316553 => "Zhangjiakou\,\ Hebei",
  861316554 => "Shijiazhuang\,\ Hebei",
  861316555 => "Hengshui\,\ Hebei",
  861316556 => "Qinhuangdao\,\ Hebei",
  861316557 => "Baoding\,\ Hebei",
  861316558 => "Shijiazhuang\,\ Hebei",
  861316559 => "Baoding\,\ Hebei",
  861316560 => "Jingzhou\,\ Hubei",
  861316561 => "Yichang\,\ Hubei",
  861316562 => "Jingmen\,\ Hubei",
  861316563 => "Shiyan\,\ Hubei",
  861316564 => "Xiangfan\,\ Hubei",
  861316565 => "Huanggang\,\ Hubei",
  861316566 => "Xiaogan\,\ Hubei",
  861316567 => "Huangshi\,\ Hubei",
  861316568 => "Huangshi\,\ Hubei",
  861316569 => "Xianning\,\ Hubei",
  861316570 => "Yulin\,\ Shaanxi",
  861316571 => "XiAn\,\ Shaanxi",
  861316572 => "XiAn\,\ Shaanxi",
  861316573 => "XiAn\,\ Shaanxi",
  861316574 => "XiAn\,\ Shaanxi",
  861316575 => "XiAn\,\ Shaanxi",
  861316576 => "Ankang\,\ Shaanxi",
  861316577 => "Shangluo\,\ Shaanxi",
  861316578 => "XiAn\,\ Shaanxi",
  861316579 => "XiAn\,\ Shaanxi",
  861316580 => "Jinhua\,\ Zhejiang",
  861316581 => "Jiaxing\,\ Zhejiang",
  861316582 => "Jiaxing\,\ Zhejiang",
  861316583 => "Wenzhou\,\ Zhejiang",
  861316584 => "Wenzhou\,\ Zhejiang",
  861316585 => "Wenzhou\,\ Zhejiang",
  861316586 => "Wenzhou\,\ Zhejiang",
  861316587 => "Wenzhou\,\ Zhejiang",
  861316588 => "Wenzhou\,\ Zhejiang",
  861316589 => "Wenzhou\,\ Zhejiang",
  861316590 => "Ningbo\,\ Zhejiang",
  861316591 => "Ningbo\,\ Zhejiang",
  861316592 => "Ningbo\,\ Zhejiang",
  861316593 => "Ningbo\,\ Zhejiang",
  861316594 => "Ningbo\,\ Zhejiang",
  861316595 => "Hangzhou\,\ Zhejiang",
  861316596 => "Hangzhou\,\ Zhejiang",
  861316597 => "Hangzhou\,\ Zhejiang",
  861316598 => "Hangzhou\,\ Zhejiang",
  861316599 => "Hangzhou\,\ Zhejiang",
  86131660 => "Shanghai",
  86131661 => "Shanghai",
  86131662 => "Shanghai",
  86131663 => "Shanghai",
  86131664 => "Shanghai",
  861316650 => "Chengde\,\ Hebei",
  861316651 => "Qinhuangdao\,\ Hebei",
  861316652 => "Langfang\,\ Hebei",
  861316653 => "Langfang\,\ Hebei",
  861316654 => "Tangshan\,\ Hebei",
  861316655 => "Zhangjiakou\,\ Hebei",
  861316656 => "Cangzhou\,\ Hebei",
  861316657 => "Hengshui\,\ Hebei",
  861316658 => "Tangshan\,\ Hebei",
  861316659 => "Xingtai\,\ Hebei",
  86131666 => "Shenyang\,\ Liaoning",
  86131667 => "Shenyang\,\ Liaoning",
  86131668 => "Changchun\,\ Jilin",
  86131669 => "Jilin\,\ Jilin",
  86131670 => "Shanghai",
  86131671 => "Shanghai",
  86131672 => "Shanghai",
  86131673 => "Beijing",
  861316740 => "Zhuzhou\,\ Hunan",
  861316741 => "Zhuzhou\,\ Hunan",
  861316742 => "Zhuzhou\,\ Hunan",
  861316743 => "Zhuzhou\,\ Hunan",
  861316744 => "Zhuzhou\,\ Hunan",
  861316745 => "Nantong\,\ Jiangsu",
  861316746 => "Nantong\,\ Jiangsu",
  861316747 => "Nantong\,\ Jiangsu",
  861316748 => "Nantong\,\ Jiangsu",
  861316749 => "Nantong\,\ Jiangsu",
  86131675 => "Beijing",
  861316760 => "Chizhou\,\ Anhui",
  861316761 => "Tongling\,\ Anhui",
  861316762 => "Chuzhou\,\ Anhui",
  861316763 => "Wuhu\,\ Anhui",
  861316764 => "Huangshan\,\ Anhui",
  861316765 => "Fuyang\,\ Anhui",
  861316766 => "Fuyang\,\ Anhui",
  861316767 => "Bozhou\,\ Anhui",
  861316768 => "Bozhou\,\ Anhui",
  861316769 => "LuAn\,\ Anhui",
  861316770 => "Anqing\,\ Anhui",
  861316771 => "Anqing\,\ Anhui",
  861316772 => "Hefei\,\ Anhui",
  861316773 => "Hefei\,\ Anhui",
  861316774 => "Hefei\,\ Anhui",
  861316775 => "Xuancheng\,\ Anhui",
  861316776 => "Xuancheng\,\ Anhui",
  861316777 => "Suzhou\,\ Anhui",
  861316778 => "LuAn\,\ Anhui",
  861316779 => "LuAn\,\ Anhui",
  86131678 => "Chongqing",
  86131679 => "Chongqing",
  86131680 => "Shenzhen\,\ Guangdong",
  861316810 => "Meizhou\,\ Guangdong",
  861316811 => "Meizhou\,\ Guangdong",
  861316812 => "Zhanjiang\,\ Guangdong",
  861316813 => "Zhanjiang\,\ Guangdong",
  861316814 => "Shaoguan\,\ Guangdong",
  861316815 => "Shaoguan\,\ Guangdong",
  861316816 => "Yunfu\,\ Guangdong",
  861316817 => "Yunfu\,\ Guangdong",
  861316818 => "Yangjiang\,\ Guangdong",
  861316819 => "Yangjiang\,\ Guangdong",
  861316820 => "Shanwei\,\ Guangdong",
  861316821 => "Shanwei\,\ Guangdong",
  861316822 => "Shanwei\,\ Guangdong",
  861316823 => "Shanwei\,\ Guangdong",
  861316824 => "Shantou\,\ Guangdong",
  861316825 => "Shantou\,\ Guangdong",
  861316826 => "Chaozhou\,\ Guangdong",
  861316827 => "Chaozhou\,\ Guangdong",
  861316828 => "Heyuan\,\ Guangdong",
  861316829 => "Heyuan\,\ Guangdong",
  86131683 => "Guangzhou\,\ Guangdong",
  86131684 => "Dongguan\,\ Guangdong",
  861316850 => "Jiangmen\,\ Guangdong",
  861316851 => "Jiangmen\,\ Guangdong",
  861316852 => "Jiangmen\,\ Guangdong",
  861316853 => "Foshan\,\ Guangdong",
  861316854 => "Foshan\,\ Guangdong",
  861316855 => "Foshan\,\ Guangdong",
  861316856 => "Foshan\,\ Guangdong",
  861316857 => "Foshan\,\ Guangdong",
  861316858 => "Foshan\,\ Guangdong",
  861316859 => "Foshan\,\ Guangdong",
  861316860 => "Huizhou\,\ Guangdong",
  861316861 => "Huizhou\,\ Guangdong",
  861316862 => "Huizhou\,\ Guangdong",
  861316863 => "Huizhou\,\ Guangdong",
  861316864 => "Huizhou\,\ Guangdong",
  861316865 => "Zhuhai\,\ Guangdong",
  861316866 => "Zhuhai\,\ Guangdong",
  861316867 => "Zhuhai\,\ Guangdong",
  861316868 => "Zhuhai\,\ Guangdong",
  861316869 => "Zhuhai\,\ Guangdong",
  86131687 => "Shenzhen\,\ Guangdong",
  86131688 => "Guangzhou\,\ Guangdong",
  86131689 => "Dongguan\,\ Guangdong",
  861316900 => "Shantou\,\ Guangdong",
  861316901 => "Shantou\,\ Guangdong",
  861316902 => "Shantou\,\ Guangdong",
  861316903 => "Shantou\,\ Guangdong",
  861316904 => "Chaozhou\,\ Guangdong",
  861316905 => "Chaozhou\,\ Guangdong",
  861316906 => "Chaozhou\,\ Guangdong",
  861316907 => "Shantou\,\ Guangdong",
  861316908 => "Shantou\,\ Guangdong",
  861316909 => "Shantou\,\ Guangdong",
  861316910 => "Zhanjiang\,\ Guangdong",
  861316911 => "Zhanjiang\,\ Guangdong",
  861316912 => "Zhanjiang\,\ Guangdong",
  861316913 => "Zhanjiang\,\ Guangdong",
  861316914 => "Yangjiang\,\ Guangdong",
  861316915 => "Yangjiang\,\ Guangdong",
  861316916 => "Maoming\,\ Guangdong",
  861316917 => "Maoming\,\ Guangdong",
  861316918 => "Maoming\,\ Guangdong",
  861316919 => "Maoming\,\ Guangdong",
  861316920 => "Meizhou\,\ Guangdong",
  861316921 => "Meizhou\,\ Guangdong",
  861316922 => "Meizhou\,\ Guangdong",
  861316923 => "Meizhou\,\ Guangdong",
  861316924 => "Meizhou\,\ Guangdong",
  861316925 => "Jieyang\,\ Guangdong",
  861316926 => "Jieyang\,\ Guangdong",
  861316927 => "Jieyang\,\ Guangdong",
  861316928 => "Jieyang\,\ Guangdong",
  861316929 => "Jieyang\,\ Guangdong",
  861316930 => "Zhongshan\,\ Guangdong",
  861316931 => "Zhongshan\,\ Guangdong",
  861316932 => "Zhongshan\,\ Guangdong",
  861316933 => "Zhongshan\,\ Guangdong",
  861316934 => "Zhaoqing\,\ Guangdong",
  861316935 => "Zhaoqing\,\ Guangdong",
  861316936 => "Zhaoqing\,\ Guangdong",
  861316937 => "Yunfu\,\ Guangdong",
  861316938 => "Yunfu\,\ Guangdong",
  861316939 => "Yunfu\,\ Guangdong",
  861316940 => "Shaoguan\,\ Guangdong",
  861316941 => "Shaoguan\,\ Guangdong",
  861316942 => "Shaoguan\,\ Guangdong",
  861316943 => "Baoding\,\ Hebei",
  861316944 => "Qingyuan\,\ Guangdong",
  861316945 => "Heyuan\,\ Guangdong",
  861316946 => "Heyuan\,\ Guangdong",
  861316947 => "Shanwei\,\ Guangdong",
  861316948 => "Shanwei\,\ Guangdong",
  861316949 => "Shanwei\,\ Guangdong",
  861316950 => "Dongguan\,\ Guangdong",
  861316951 => "Dongguan\,\ Guangdong",
  861316952 => "Dongguan\,\ Guangdong",
  861316953 => "Dongguan\,\ Guangdong",
  861316954 => "Dongguan\,\ Guangdong",
  861316955 => "Huizhou\,\ Guangdong",
  861316956 => "Huizhou\,\ Guangdong",
  861316957 => "Huizhou\,\ Guangdong",
  861316958 => "Huizhou\,\ Guangdong",
  861316959 => "Huizhou\,\ Guangdong",
  86131696 => "Zhuhai\,\ Guangdong",
  861316970 => "Foshan\,\ Guangdong",
  861316971 => "Foshan\,\ Guangdong",
  861316972 => "Foshan\,\ Guangdong",
  861316973 => "Qingyuan\,\ Guangdong",
  861316974 => "Qingyuan\,\ Guangdong",
  861316975 => "Qingyuan\,\ Guangdong",
  861316976 => "Maoming\,\ Guangdong",
  861316977 => "Maoming\,\ Guangdong",
  861316978 => "Maoming\,\ Guangdong",
  861316979 => "Maoming\,\ Guangdong",
  861316980 => "Jiangmen\,\ Guangdong",
  861316981 => "Jiangmen\,\ Guangdong",
  861316982 => "Jiangmen\,\ Guangdong",
  861316983 => "Jiangmen\,\ Guangdong",
  861316984 => "Jiangmen\,\ Guangdong",
  861316985 => "Zhongshan\,\ Guangdong",
  861316986 => "Zhongshan\,\ Guangdong",
  861316987 => "Zhongshan\,\ Guangdong",
  861316988 => "Zhongshan\,\ Guangdong",
  861316989 => "Zhongshan\,\ Guangdong",
  861316990 => "Shenzhen\,\ Guangdong",
  861316991 => "Shenzhen\,\ Guangdong",
  861316992 => "Shenzhen\,\ Guangdong",
  861316993 => "Shenzhen\,\ Guangdong",
  861316994 => "Shenzhen\,\ Guangdong",
  861316995 => "Foshan\,\ Guangdong",
  861316996 => "Foshan\,\ Guangdong",
  861316997 => "Foshan\,\ Guangdong",
  861316998 => "Foshan\,\ Guangdong",
  861316999 => "Foshan\,\ Guangdong",
  861317000 => "Chuzhou\,\ Anhui",
  861317001 => "Hefei\,\ Anhui",
  861317002 => "Bengbu\,\ Anhui",
  861317003 => "Wuhu\,\ Anhui",
  861317004 => "Fuyang\,\ Anhui",
  861317005 => "MaAnshan\,\ Anhui",
  861317006 => "Anqing\,\ Anhui",
  861317007 => "Suzhou\,\ Anhui",
  861317008 => "Fuyang\,\ Anhui",
  861317009 => "Huangshan\,\ Anhui",
  861317010 => "Bozhou\,\ Anhui",
  861317011 => "Huaibei\,\ Anhui",
  861317012 => "Tongling\,\ Anhui",
  861317013 => "Xuancheng\,\ Anhui",
  861317014 => "LuAn\,\ Anhui",
  861317015 => "Hefei\,\ Anhui",
  861317016 => "Chizhou\,\ Anhui",
  861317017 => "Bozhou\,\ Anhui",
  861317018 => "LuAn\,\ Anhui",
  861317019 => "LuAn\,\ Anhui",
  861317020 => "Huainan\,\ Anhui",
  861317021 => "Suzhou\,\ Anhui",
  861317022 => "Bengbu\,\ Anhui",
  861317023 => "Wuhu\,\ Anhui",
  861317024 => "Anqing\,\ Anhui",
  861317025 => "Hefei\,\ Anhui",
  861317026 => "Xuancheng\,\ Anhui",
  861317027 => "Hefei\,\ Anhui",
  861317028 => "Anqing\,\ Anhui",
  861317029 => "Huangshan\,\ Anhui",
  861317030 => "Changsha\,\ Hunan",
  861317031 => "Changsha\,\ Hunan",
  861317032 => "Xiangtan\,\ Hunan",
  861317033 => "Hengyang\,\ Hunan",
  861317034 => "Hengyang\,\ Hunan",
  861317035 => "Chenzhou\,\ Hunan",
  861317036 => "Chenzhou\,\ Hunan",
  861317037 => "Yiyang\,\ Hunan",
  861317038 => "Loudi\,\ Hunan",
  861317039 => "Shaoyang\,\ Hunan",
  861317040 => "Changsha\,\ Hunan",
  861317041 => "Changsha\,\ Hunan",
  861317042 => "Xiangtan\,\ Hunan",
  861317043 => "Xiangxi\,\ Hunan",
  861317044 => "Zhangjiajie\,\ Hunan",
  861317045 => "Huaihua\,\ Hunan",
  861317046 => "Yongzhou\,\ Hunan",
  861317047 => "Changsha\,\ Hunan",
  861317048 => "Changsha\,\ Hunan",
  861317049 => "Shaoyang\,\ Hunan",
  861317050 => "Chuxiong\,\ Yunnan",
  861317051 => "Chuxiong\,\ Yunnan",
  861317052 => "Chuxiong\,\ Yunnan",
  861317053 => "Xishuangbanna\,\ Yunnan",
  861317054 => "Xishuangbanna\,\ Yunnan",
  861317055 => "Lincang\,\ Yunnan",
  861317056 => "Nujiang\,\ Yunnan",
  861317057 => "Zhaotong\,\ Yunnan",
  861317058 => "Zhaotong\,\ Yunnan",
  861317059 => "Wenshan\,\ Yunnan",
  861317060 => "Kunming\,\ Yunnan",
  861317061 => "Kunming\,\ Yunnan",
  861317062 => "Kunming\,\ Yunnan",
  861317063 => "Kunming\,\ Yunnan",
  861317064 => "Yuxi\,\ Yunnan",
  861317065 => "Yuxi\,\ Yunnan",
  861317066 => "Yuxi\,\ Yunnan",
  861317067 => "Honghe\,\ Yunnan",
  861317068 => "Honghe\,\ Yunnan",
  861317069 => "Dehong\,\ Yunnan",
  861317070 => "Qujing\,\ Yunnan",
  861317071 => "Qujing\,\ Yunnan",
  861317072 => "Qujing\,\ Yunnan",
  861317073 => "Baoshan\,\ Yunnan",
  861317074 => "Puer\,\ Yunnan",
  861317075 => "Dali\,\ Yunnan",
  861317076 => "Dali\,\ Yunnan",
  861317077 => "Lijiang\,\ Yunnan",
  861317078 => "Lijiang\,\ Yunnan",
  861317079 => "Deqen\,\ Yunnan",
  861317080 => "Yingtan\,\ Jiangxi",
  861317081 => "Ganzhou\,\ Jiangxi",
  861317082 => "Jiujiang\,\ Jiangxi",
  861317083 => "Yichun\,\ Jiangxi",
  861317084 => "Ganzhou\,\ Jiangxi",
  861317085 => "Yichun\,\ Jiangxi",
  861317086 => "Nanchang\,\ Jiangxi",
  861317087 => "Nanchang\,\ Jiangxi",
  861317088 => "Nanchang\,\ Jiangxi",
  861317089 => "Fuzhou\,\ Jiangxi",
  861317090 => "Xinyu\,\ Jiangxi",
  861317091 => "Nanchang\,\ Jiangxi",
  861317092 => "Jiujiang\,\ Jiangxi",
  861317093 => "Shangrao\,\ Jiangxi",
  861317094 => "Fuzhou\,\ Jiangxi",
  861317095 => "Yichun\,\ Jiangxi",
  861317096 => "JiAn\,\ Jiangxi",
  861317097 => "Ganzhou\,\ Jiangxi",
  861317098 => "Jingdezhen\,\ Jiangxi",
  861317099 => "Shangrao\,\ Jiangxi",
  86131710 => "Hohhot\,\ Inner\ Mongolia",
  861317110 => "Tongliao\,\ Inner\ Mongolia",
  861317111 => "Tongliao\,\ Inner\ Mongolia",
  861317112 => "Tongliao\,\ Inner\ Mongolia",
  861317113 => "Tongliao\,\ Inner\ Mongolia",
  861317114 => "Hulun\,\ Inner\ Mongolia",
  861317115 => "Hulun\,\ Inner\ Mongolia",
  861317116 => "Hulun\,\ Inner\ Mongolia",
  861317117 => "Hulun\,\ Inner\ Mongolia",
  861317118 => "Hulun\,\ Inner\ Mongolia",
  861317119 => "Hulun\,\ Inner\ Mongolia",
  86131712 => "Baotou\,\ Inner\ Mongolia",
  861317130 => "Hinggan\,\ Inner\ Mongolia",
  861317131 => "Wuhai\,\ Inner\ Mongolia",
  861317132 => "Bayannur\,\ Inner\ Mongolia",
  861317133 => "Bayannur\,\ Inner\ Mongolia",
  861317134 => "Bayannur\,\ Inner\ Mongolia",
  861317135 => "Chifeng\,\ Inner\ Mongolia",
  861317136 => "Chifeng\,\ Inner\ Mongolia",
  861317137 => "Chifeng\,\ Inner\ Mongolia",
  861317138 => "Xilin\,\ Inner\ Mongolia",
  861317139 => "Hinggan\,\ Inner\ Mongolia",
  861317140 => "Hohhot\,\ Inner\ Mongolia",
  861317141 => "Hohhot\,\ Inner\ Mongolia",
  861317142 => "Hohhot\,\ Inner\ Mongolia",
  861317143 => "Baotou\,\ Inner\ Mongolia",
  861317144 => "Baotou\,\ Inner\ Mongolia",
  861317145 => "Baotou\,\ Inner\ Mongolia",
  861317146 => "Baotou\,\ Inner\ Mongolia",
  861317147 => "Baotou\,\ Inner\ Mongolia",
  861317148 => "Baotou\,\ Inner\ Mongolia",
  861317149 => "Ordos\,\ Inner\ Mongolia",
  861317150 => "Tangshan\,\ Hebei",
  861317151 => "Tangshan\,\ Hebei",
  861317152 => "Tangshan\,\ Hebei",
  861317153 => "Handan\,\ Hebei",
  861317154 => "Handan\,\ Hebei",
  861317155 => "Shijiazhuang\,\ Hebei",
  861317156 => "Shijiazhuang\,\ Hebei",
  861317157 => "Shijiazhuang\,\ Hebei",
  861317158 => "Shijiazhuang\,\ Hebei",
  861317159 => "Shijiazhuang\,\ Hebei",
  861317160 => "Chengde\,\ Hebei",
  861317161 => "Chengde\,\ Hebei",
  861317162 => "Chengde\,\ Hebei",
  861317163 => "Zhangjiakou\,\ Hebei",
  861317164 => "Zhangjiakou\,\ Hebei",
  861317165 => "Zhangjiakou\,\ Hebei",
  861317166 => "Zhangjiakou\,\ Hebei",
  861317167 => "Baoding\,\ Hebei",
  861317168 => "Baoding\,\ Hebei",
  861317169 => "Baoding\,\ Hebei",
  861317170 => "Cangzhou\,\ Hebei",
  861317171 => "Hengshui\,\ Hebei",
  861317172 => "Qinhuangdao\,\ Hebei",
  861317173 => "Langfang\,\ Hebei",
  861317174 => "Hengshui\,\ Hebei",
  861317175 => "Xingtai\,\ Hebei",
  861317176 => "Hengshui\,\ Hebei",
  861317177 => "Handan\,\ Hebei",
  861317178 => "Handan\,\ Hebei",
  861317179 => "Handan\,\ Hebei",
  861317180 => "Shijiazhuang\,\ Hebei",
  861317181 => "Tangshan\,\ Hebei",
  861317182 => "Qinhuangdao\,\ Hebei",
  861317183 => "Langfang\,\ Hebei",
  861317184 => "Tangshan\,\ Hebei",
  861317185 => "Xingtai\,\ Hebei",
  861317186 => "Handan\,\ Hebei",
  861317187 => "Baoding\,\ Hebei",
  861317188 => "Shijiazhuang\,\ Hebei",
  861317189 => "Shijiazhuang\,\ Hebei",
  861317190 => "Baoding\,\ Hebei",
  861317191 => "Baoding\,\ Hebei",
  861317192 => "Baoding\,\ Hebei",
  861317193 => "Langfang\,\ Hebei",
  861317194 => "Langfang\,\ Hebei",
  861317195 => "Xingtai\,\ Hebei",
  861317196 => "Qinhuangdao\,\ Hebei",
  861317197 => "Qinhuangdao\,\ Hebei",
  861317198 => "Cangzhou\,\ Hebei",
  861317199 => "Cangzhou\,\ Hebei",
  86131720 => "Guangzhou\,\ Guangdong",
  861317210 => "Guangzhou\,\ Guangdong",
  861317211 => "Dongguan\,\ Guangdong",
  861317212 => "Langfang\,\ Hebei",
  861317213 => "Langfang\,\ Hebei",
  861317214 => "Langfang\,\ Hebei",
  861317215 => "Langfang\,\ Hebei",
  861317216 => "Dongguan\,\ Guangdong",
  861317217 => "Langfang\,\ Hebei",
  861317218 => "Langfang\,\ Hebei",
  861317219 => "Langfang\,\ Hebei",
  86131722 => "Jiangmen\,\ Guangdong",
  86131723 => "Foshan\,\ Guangdong",
  86131724 => "Shenzhen\,\ Guangdong",
  861317250 => "Shantou\,\ Guangdong",
  861317251 => "Shantou\,\ Guangdong",
  861317252 => "Shantou\,\ Guangdong",
  861317253 => "Shantou\,\ Guangdong",
  861317254 => "Shantou\,\ Guangdong",
  861317255 => "Chaozhou\,\ Guangdong",
  861317256 => "Chaozhou\,\ Guangdong",
  861317257 => "Chaozhou\,\ Guangdong",
  861317258 => "Chaozhou\,\ Guangdong",
  861317259 => "Chaozhou\,\ Guangdong",
  861317260 => "Zhaoqing\,\ Guangdong",
  861317261 => "Zhaoqing\,\ Guangdong",
  861317262 => "Zhaoqing\,\ Guangdong",
  861317263 => "Zhaoqing\,\ Guangdong",
  861317264 => "Zhaoqing\,\ Guangdong",
  861317265 => "Zhuhai\,\ Guangdong",
  861317266 => "Zhuhai\,\ Guangdong",
  861317267 => "Xingtai\,\ Hebei",
  861317268 => "Xingtai\,\ Hebei",
  861317269 => "Xingtai\,\ Hebei",
  861317270 => "Huizhou\,\ Guangdong",
  861317271 => "Huizhou\,\ Guangdong",
  861317272 => "Huizhou\,\ Guangdong",
  861317273 => "Huizhou\,\ Guangdong",
  861317274 => "Huizhou\,\ Guangdong",
  861317275 => "Heyuan\,\ Guangdong",
  861317276 => "Heyuan\,\ Guangdong",
  861317277 => "Heyuan\,\ Guangdong",
  861317278 => "Heyuan\,\ Guangdong",
  861317279 => "Heyuan\,\ Guangdong",
  861317280 => "Jieyang\,\ Guangdong",
  861317281 => "Jieyang\,\ Guangdong",
  861317282 => "Jieyang\,\ Guangdong",
  861317283 => "Jieyang\,\ Guangdong",
  861317284 => "Jieyang\,\ Guangdong",
  861317285 => "Shanwei\,\ Guangdong",
  861317286 => "Shanwei\,\ Guangdong",
  861317287 => "Shanwei\,\ Guangdong",
  861317288 => "Shanwei\,\ Guangdong",
  861317289 => "Shanwei\,\ Guangdong",
  861317290 => "Qingyuan\,\ Guangdong",
  861317291 => "Qingyuan\,\ Guangdong",
  861317292 => "Qingyuan\,\ Guangdong",
  861317293 => "Qingyuan\,\ Guangdong",
  861317294 => "Qingyuan\,\ Guangdong",
  861317295 => "Shaoguan\,\ Guangdong",
  861317296 => "Shaoguan\,\ Guangdong",
  861317297 => "Shaoguan\,\ Guangdong",
  861317298 => "Shaoguan\,\ Guangdong",
  861317299 => "Shaoguan\,\ Guangdong",
  861317300 => "Jinan\,\ Shandong",
  861317301 => "Jinan\,\ Shandong",
  861317302 => "Jinan\,\ Shandong",
  861317303 => "Jinan\,\ Shandong",
  861317304 => "Jinan\,\ Shandong",
  861317305 => "Jinan\,\ Shandong",
  861317306 => "Zaozhuang\,\ Shandong",
  861317307 => "Linyi\,\ Shandong",
  861317308 => "Linyi\,\ Shandong",
  861317309 => "Linyi\,\ Shandong",
  861317310 => "Weifang\,\ Shandong",
  861317311 => "Weifang\,\ Shandong",
  861317312 => "Weifang\,\ Shandong",
  861317313 => "Weifang\,\ Shandong",
  861317314 => "Weifang\,\ Shandong",
  861317315 => "Weifang\,\ Shandong",
  861317316 => "Weifang\,\ Shandong",
  861317317 => "Jining\,\ Shandong",
  861317318 => "Jining\,\ Shandong",
  861317319 => "Jining\,\ Shandong",
  861317320 => "Qingdao\,\ Shandong",
  861317321 => "Qingdao\,\ Shandong",
  861317322 => "Qingdao\,\ Shandong",
  861317323 => "Qingdao\,\ Shandong",
  861317324 => "Qingdao\,\ Shandong",
  861317325 => "Liaocheng\,\ Shandong",
  861317326 => "Zibo\,\ Shandong",
  861317327 => "Zibo\,\ Shandong",
  861317328 => "Binzhou\,\ Shandong",
  861317329 => "Binzhou\,\ Shandong",
  861317330 => "Weihai\,\ Shandong",
  861317331 => "Weihai\,\ Shandong",
  861317332 => "Zaozhuang\,\ Shandong",
  861317333 => "Dezhou\,\ Shandong",
  861317334 => "Dezhou\,\ Shandong",
  861317335 => "Liaocheng\,\ Shandong",
  861317336 => "Dongying\,\ Shandong",
  861317337 => "Zaozhuang\,\ Shandong",
  861317338 => "TaiAn\,\ Shandong",
  861317339 => "Heze\,\ Shandong",
  861317340 => "Weihai\,\ Shandong",
  861317341 => "Zibo\,\ Shandong",
  861317342 => "Binzhou\,\ Shandong",
  861317343 => "Dezhou\,\ Shandong",
  861317344 => "Linyi\,\ Shandong",
  861317345 => "Jining\,\ Shandong",
  861317346 => "Dongying\,\ Shandong",
  861317347 => "Zaozhuang\,\ Shandong",
  861317348 => "TaiAn\,\ Shandong",
  861317349 => "Heze\,\ Shandong",
  86131735 => "Wenzhou\,\ Zhejiang",
  86131736 => "Hangzhou\,\ Zhejiang",
  86131737 => "Taizhou\,\ Zhejiang",
  86131738 => "Jinhua\,\ Zhejiang",
  86131739 => "Shaoxing\,\ Zhejiang",
  861317400 => "HuaiAn\,\ Jiangsu",
  861317401 => "HuaiAn\,\ Jiangsu",
  861317402 => "Yancheng\,\ Jiangsu",
  861317403 => "Yancheng\,\ Jiangsu",
  861317404 => "Wuxi\,\ Jiangsu",
  861317405 => "Wuxi\,\ Jiangsu",
  861317406 => "Wuxi\,\ Jiangsu",
  861317407 => "Nanjing\,\ Jiangsu",
  861317408 => "Nanjing\,\ Jiangsu",
  861317409 => "Nanjing\,\ Jiangsu",
  861317410 => "Suzhou\,\ Jiangsu",
  861317411 => "Suzhou\,\ Jiangsu",
  861317412 => "Yangzhou\,\ Jiangsu",
  861317413 => "Yangzhou\,\ Jiangsu",
  861317414 => "Xuzhou\,\ Jiangsu",
  861317415 => "Xuzhou\,\ Jiangsu",
  861317416 => "Changzhou\,\ Jiangsu",
  861317417 => "Changzhou\,\ Jiangsu",
  861317418 => "Lianyungang\,\ Jiangsu",
  861317419 => "Lianyungang\,\ Jiangsu",
  861317420 => "Huaihua\,\ Hunan",
  861317421 => "Zhangjiajie\,\ Hunan",
  861317422 => "Xiangxi\,\ Hunan",
  861317423 => "Xiangxi\,\ Hunan",
  861317424 => "Zhangjiajie\,\ Hunan",
  861317425 => "Huaihua\,\ Hunan",
  861317426 => "Yongzhou\,\ Hunan",
  861317427 => "Yongzhou\,\ Hunan",
  861317428 => "Loudi\,\ Hunan",
  861317429 => "Shaoyang\,\ Hunan",
  861317430 => "Changchun\,\ Jilin",
  861317431 => "Changchun\,\ Jilin",
  861317432 => "Jilin\,\ Jilin",
  861317433 => "Changchun\,\ Jilin",
  861317434 => "Changchun\,\ Jilin",
  861317435 => "Changchun\,\ Jilin",
  861317436 => "Changchun\,\ Jilin",
  861317437 => "Changchun\,\ Jilin",
  861317438 => "Changchun\,\ Jilin",
  861317439 => "Changchun\,\ Jilin",
  86131744 => "Changchun\,\ Jilin",
  861317450 => "Fuzhou\,\ Fujian",
  861317451 => "Fuzhou\,\ Fujian",
  861317452 => "Fuzhou\,\ Fujian",
  861317453 => "Fuzhou\,\ Fujian",
  861317454 => "Putian\,\ Fujian",
  861317455 => "Putian\,\ Fujian",
  861317456 => "Putian\,\ Fujian",
  861317457 => "Ningde\,\ Fujian",
  861317458 => "Longyan\,\ Fujian",
  861317459 => "Longyan\,\ Fujian",
  861317460 => "Zhangzhou\,\ Fujian",
  861317461 => "Zhangzhou\,\ Fujian",
  861317462 => "Zhangzhou\,\ Fujian",
  861317463 => "Ningde\,\ Fujian",
  861317464 => "Xinyang\,\ Henan",
  861317465 => "Putian\,\ Fujian",
  861317466 => "Zhangzhou\,\ Fujian",
  861317467 => "Zhangzhou\,\ Fujian",
  861317468 => "Zhangzhou\,\ Fujian",
  861317469 => "Nanping\,\ Fujian",
  861317470 => "Jiaxing\,\ Zhejiang",
  861317471 => "Jiaxing\,\ Zhejiang",
  861317472 => "Jiaxing\,\ Zhejiang",
  861317473 => "Jiaxing\,\ Zhejiang",
  861317474 => "Jiaxing\,\ Zhejiang",
  861317475 => "Taizhou\,\ Zhejiang",
  861317476 => "Taizhou\,\ Zhejiang",
  861317477 => "Taizhou\,\ Zhejiang",
  861317478 => "Taizhou\,\ Zhejiang",
  861317479 => "Taizhou\,\ Zhejiang",
  86131748 => "Tianjin",
  86131749 => "Jinhua\,\ Zhejiang",
  86131750 => "Hangzhou\,\ Zhejiang",
  861317510 => "Hangzhou\,\ Zhejiang",
  861317511 => "Hangzhou\,\ Zhejiang",
  861317512 => "Hangzhou\,\ Zhejiang",
  861317513 => "Hangzhou\,\ Zhejiang",
  861317514 => "Hangzhou\,\ Zhejiang",
  861317515 => "Ningbo\,\ Zhejiang",
  861317516 => "Ningbo\,\ Zhejiang",
  861317517 => "Ningbo\,\ Zhejiang",
  861317518 => "Ningbo\,\ Zhejiang",
  861317519 => "Ningbo\,\ Zhejiang",
  861317520 => "Huzhou\,\ Zhejiang",
  861317521 => "Huzhou\,\ Zhejiang",
  861317522 => "Huzhou\,\ Zhejiang",
  861317523 => "Huzhou\,\ Zhejiang",
  861317524 => "Huzhou\,\ Zhejiang",
  861317525 => "Shaoxing\,\ Zhejiang",
  861317526 => "Shaoxing\,\ Zhejiang",
  861317527 => "Shaoxing\,\ Zhejiang",
  861317528 => "Shaoxing\,\ Zhejiang",
  861317529 => "Shaoxing\,\ Zhejiang",
  86131753 => "Taizhou\,\ Zhejiang",
  861317540 => "Jinhua\,\ Zhejiang",
  861317541 => "Jinhua\,\ Zhejiang",
  861317542 => "Jinhua\,\ Zhejiang",
  861317543 => "Jinhua\,\ Zhejiang",
  861317544 => "Jinhua\,\ Zhejiang",
  861317545 => "Taizhou\,\ Zhejiang",
  861317546 => "Taizhou\,\ Zhejiang",
  861317547 => "Taizhou\,\ Zhejiang",
  861317548 => "Taizhou\,\ Zhejiang",
  861317549 => "Taizhou\,\ Zhejiang",
  861317550 => "Jinhua\,\ Zhejiang",
  861317551 => "Jinhua\,\ Zhejiang",
  861317552 => "Jinhua\,\ Zhejiang",
  861317553 => "Jinhua\,\ Zhejiang",
  861317554 => "Jinhua\,\ Zhejiang",
  861317555 => "Jiaxing\,\ Zhejiang",
  861317556 => "Jiaxing\,\ Zhejiang",
  861317557 => "Jiaxing\,\ Zhejiang",
  861317558 => "Jiaxing\,\ Zhejiang",
  861317559 => "Jiaxing\,\ Zhejiang",
  86131756 => "Wenzhou\,\ Zhejiang",
  861317570 => "Quzhou\,\ Zhejiang",
  861317571 => "Quzhou\,\ Zhejiang",
  861317572 => "Quzhou\,\ Zhejiang",
  861317573 => "Quzhou\,\ Zhejiang",
  861317574 => "Quzhou\,\ Zhejiang",
  861317575 => "Lishui\,\ Zhejiang",
  861317576 => "Lishui\,\ Zhejiang",
  861317577 => "Lishui\,\ Zhejiang",
  861317578 => "Lishui\,\ Zhejiang",
  861317579 => "Lishui\,\ Zhejiang",
  861317580 => "Zhoushan\,\ Zhejiang",
  861317581 => "Zhoushan\,\ Zhejiang",
  861317582 => "Zhoushan\,\ Zhejiang",
  861317583 => "Zhoushan\,\ Zhejiang",
  861317584 => "Zhoushan\,\ Zhejiang",
  861317585 => "Taizhou\,\ Zhejiang",
  861317586 => "Taizhou\,\ Zhejiang",
  861317587 => "Taizhou\,\ Zhejiang",
  861317588 => "Taizhou\,\ Zhejiang",
  861317589 => "Taizhou\,\ Zhejiang",
  86131759 => "Ningbo\,\ Zhejiang",
  861317600 => "Jinan\,\ Shandong",
  861317601 => "Jinan\,\ Shandong",
  861317602 => "Jinan\,\ Shandong",
  861317603 => "Zaozhuang\,\ Shandong",
  861317604 => "Zaozhuang\,\ Shandong",
  861317605 => "Heze\,\ Shandong",
  861317606 => "Weifang\,\ Shandong",
  861317607 => "Linyi\,\ Shandong",
  861317608 => "Linyi\,\ Shandong",
  861317609 => "Linyi\,\ Shandong",
  861317610 => "Heze\,\ Shandong",
  861317611 => "Heze\,\ Shandong",
  861317612 => "TaiAn\,\ Shandong",
  861317613 => "TaiAn\,\ Shandong",
  861317614 => "Dezhou\,\ Shandong",
  861317615 => "Liaocheng\,\ Shandong",
  861317616 => "Liaocheng\,\ Shandong",
  861317617 => "Jining\,\ Shandong",
  861317618 => "Jining\,\ Shandong",
  861317619 => "Jining\,\ Shandong",
  861317620 => "Heze\,\ Shandong",
  861317621 => "Heze\,\ Shandong",
  861317622 => "Zibo\,\ Shandong",
  861317623 => "Rizhao\,\ Shandong",
  861317624 => "Weihai\,\ Shandong",
  861317625 => "Liaocheng\,\ Shandong",
  861317626 => "Dezhou\,\ Shandong",
  861317627 => "Dezhou\,\ Shandong",
  861317628 => "Binzhou\,\ Shandong",
  861317629 => "Binzhou\,\ Shandong",
  861317630 => "Weihai\,\ Shandong",
  861317631 => "Weihai\,\ Shandong",
  861317632 => "Zaozhuang\,\ Shandong",
  861317633 => "Rizhao\,\ Shandong",
  861317634 => "Laiwu\,\ Shandong",
  861317635 => "Liaocheng\,\ Shandong",
  861317636 => "Weifang\,\ Shandong",
  861317637 => "Zaozhuang\,\ Shandong",
  861317638 => "Yantai\,\ Shandong",
  861317639 => "Qingdao\,\ Shandong",
  861317640 => "Jinan\,\ Shandong",
  861317641 => "Jinan\,\ Shandong",
  861317642 => "Binzhou\,\ Shandong",
  861317643 => "Zibo\,\ Shandong",
  861317644 => "Jinan\,\ Shandong",
  861317645 => "Yantai\,\ Shandong",
  861317646 => "Weifang\,\ Shandong",
  861317647 => "Dongying\,\ Shandong",
  861317648 => "Qingdao\,\ Shandong",
  861317649 => "Binzhou\,\ Shandong",
  861317650 => "Qingdao\,\ Shandong",
  861317651 => "Qingdao\,\ Shandong",
  861317652 => "Qingdao\,\ Shandong",
  861317653 => "Qingdao\,\ Shandong",
  861317654 => "TaiAn\,\ Shandong",
  861317655 => "Zibo\,\ Shandong",
  861317656 => "Zibo\,\ Shandong",
  861317657 => "Zibo\,\ Shandong",
  861317658 => "Zibo\,\ Shandong",
  861317659 => "Zibo\,\ Shandong",
  861317660 => "Dongying\,\ Shandong",
  861317661 => "Dongying\,\ Shandong",
  861317662 => "Dongying\,\ Shandong",
  861317663 => "Dongying\,\ Shandong",
  861317664 => "Dongying\,\ Shandong",
  861317665 => "Jinan\,\ Shandong",
  861317666 => "Jinan\,\ Shandong",
  861317667 => "Jinan\,\ Shandong",
  861317668 => "Jinan\,\ Shandong",
  861317669 => "Jinan\,\ Shandong",
  861317670 => "Weifang\,\ Shandong",
  861317671 => "Weifang\,\ Shandong",
  861317672 => "Weifang\,\ Shandong",
  861317673 => "Weifang\,\ Shandong",
  861317674 => "Weifang\,\ Shandong",
  861317675 => "Jining\,\ Shandong",
  861317676 => "Jining\,\ Shandong",
  861317677 => "Jining\,\ Shandong",
  861317678 => "Jining\,\ Shandong",
  861317679 => "Jining\,\ Shandong",
  861317680 => "Weihai\,\ Shandong",
  861317681 => "Weihai\,\ Shandong",
  861317682 => "TaiAn\,\ Shandong",
  861317683 => "TaiAn\,\ Shandong",
  861317684 => "Dezhou\,\ Shandong",
  861317685 => "Qingdao\,\ Shandong",
  861317686 => "Qingdao\,\ Shandong",
  861317687 => "Qingdao\,\ Shandong",
  861317688 => "Qingdao\,\ Shandong",
  861317689 => "Qingdao\,\ Shandong",
  861317690 => "Yantai\,\ Shandong",
  861317691 => "Yantai\,\ Shandong",
  861317692 => "Yantai\,\ Shandong",
  861317693 => "Yantai\,\ Shandong",
  861317694 => "Yantai\,\ Shandong",
  861317695 => "Liaocheng\,\ Shandong",
  861317696 => "Linyi\,\ Shandong",
  861317697 => "Linyi\,\ Shandong",
  861317698 => "Linyi\,\ Shandong",
  861317699 => "Linyi\,\ Shandong",
  861317700 => "Jingzhou\,\ Hubei",
  861317701 => "Jingzhou\,\ Hubei",
  861317702 => "Jingzhou\,\ Hubei",
  861317703 => "Jingzhou\,\ Hubei",
  861317704 => "Jingzhou\,\ Hubei",
  861317705 => "Yichang\,\ Hubei",
  861317706 => "Yichang\,\ Hubei",
  861317707 => "Yichang\,\ Hubei",
  861317708 => "Yichang\,\ Hubei",
  861317709 => "Yichang\,\ Hubei",
  861317710 => "Enshi\,\ Hubei",
  861317711 => "Enshi\,\ Hubei",
  861317712 => "Enshi\,\ Hubei",
  861317713 => "Enshi\,\ Hubei",
  861317714 => "Jingmen\,\ Hubei",
  861317715 => "Jingmen\,\ Hubei",
  861317716 => "Jingmen\,\ Hubei",
  861317717 => "Jingmen\,\ Hubei",
  861317718 => "Suizhou\,\ Hubei",
  861317719 => "Suizhou\,\ Hubei",
  861317720 => "Xiangfan\,\ Hubei",
  861317721 => "Xiangfan\,\ Hubei",
  861317722 => "Xiangfan\,\ Hubei",
  861317723 => "Xiangfan\,\ Hubei",
  861317724 => "Xiangfan\,\ Hubei",
  861317725 => "Xiaogan\,\ Hubei",
  861317726 => "Xiaogan\,\ Hubei",
  861317727 => "Xiaogan\,\ Hubei",
  861317728 => "Xiaogan\,\ Hubei",
  861317729 => "Xiaogan\,\ Hubei",
  861317730 => "Huangshi\,\ Hubei",
  861317731 => "Huangshi\,\ Hubei",
  861317732 => "Huangshi\,\ Hubei",
  861317733 => "Huangshi\,\ Hubei",
  861317734 => "Huanggang\,\ Hubei",
  861317735 => "Huanggang\,\ Hubei",
  861317736 => "Huanggang\,\ Hubei",
  861317737 => "Ezhou\,\ Hubei",
  861317738 => "Ezhou\,\ Hubei",
  861317739 => "Ezhou\,\ Hubei",
  861317740 => "Xianning\,\ Hubei",
  861317741 => "Xianning\,\ Hubei",
  861317742 => "Xianning\,\ Hubei",
  861317743 => "Xianning\,\ Hubei",
  861317744 => "Xianning\,\ Hubei",
  861317745 => "Shiyan\,\ Hubei",
  861317746 => "Shiyan\,\ Hubei",
  861317747 => "Shiyan\,\ Hubei",
  861317748 => "Shiyan\,\ Hubei",
  861317749 => "Wuhan\,\ Hubei",
  861317750 => "Shangrao\,\ Jiangxi",
  861317751 => "Shangrao\,\ Jiangxi",
  861317752 => "Shangrao\,\ Jiangxi",
  861317753 => "Xinyu\,\ Jiangxi",
  861317754 => "Xinyu\,\ Jiangxi",
  861317755 => "Pingxiang\,\ Jiangxi",
  861317756 => "Yichun\,\ Jiangxi",
  861317757 => "Yichun\,\ Jiangxi",
  861317758 => "Yichun\,\ Jiangxi",
  861317759 => "Yingtan\,\ Jiangxi",
  861317760 => "JiAn\,\ Jiangxi",
  861317761 => "JiAn\,\ Jiangxi",
  861317762 => "JiAn\,\ Jiangxi",
  861317763 => "Jingdezhen\,\ Jiangxi",
  861317764 => "Pingxiang\,\ Jiangxi",
  861317765 => "Fuzhou\,\ Jiangxi",
  861317766 => "Fuzhou\,\ Jiangxi",
  861317767 => "Fuzhou\,\ Jiangxi",
  861317768 => "Fuzhou\,\ Jiangxi",
  861317769 => "Yingtan\,\ Jiangxi",
  861317770 => "Jiujiang\,\ Jiangxi",
  861317771 => "Jiujiang\,\ Jiangxi",
  861317772 => "Jiujiang\,\ Jiangxi",
  861317773 => "Jiujiang\,\ Jiangxi",
  861317774 => "Ganzhou\,\ Jiangxi",
  861317775 => "Ganzhou\,\ Jiangxi",
  861317776 => "Ganzhou\,\ Jiangxi",
  861317777 => "Nanchang\,\ Jiangxi",
  861317778 => "Nanchang\,\ Jiangxi",
  861317779 => "Ganzhou\,\ Jiangxi",
  86131778 => "Nanchang\,\ Jiangxi",
  861317790 => "Xinyu\,\ Jiangxi",
  861317791 => "Nanchang\,\ Jiangxi",
  861317792 => "Jiujiang\,\ Jiangxi",
  861317793 => "Shangrao\,\ Jiangxi",
  861317794 => "Fuzhou\,\ Jiangxi",
  861317795 => "Yichun\,\ Jiangxi",
  861317796 => "JiAn\,\ Jiangxi",
  861317797 => "Ganzhou\,\ Jiangxi",
  861317798 => "Jingdezhen\,\ Jiangxi",
  861317799 => "Pingxiang\,\ Jiangxi",
  861317800 => "Zhangzhou\,\ Fujian",
  861317801 => "Quanzhou\,\ Fujian",
  861317802 => "Zhangzhou\,\ Fujian",
  861317803 => "Fuzhou\,\ Fujian",
  861317804 => "Quanzhou\,\ Fujian",
  861317805 => "Putian\,\ Fujian",
  861317806 => "Putian\,\ Fujian",
  861317807 => "Sanming\,\ Fujian",
  861317808 => "Quanzhou\,\ Fujian",
  861317809 => "Quanzhou\,\ Fujian",
  861317810 => "Ningde\,\ Fujian",
  861317811 => "Fuzhou\,\ Fujian",
  861317812 => "Ningde\,\ Fujian",
  861317813 => "Putian\,\ Fujian",
  861317814 => "Ningde\,\ Fujian",
  861317815 => "Longyan\,\ Fujian",
  861317816 => "Zhangzhou\,\ Fujian",
  861317817 => "Nanping\,\ Fujian",
  861317818 => "Longyan\,\ Fujian",
  861317819 => "Putian\,\ Fujian",
  861317820 => "Quanzhou\,\ Fujian",
  861317821 => "Quanzhou\,\ Fujian",
  861317822 => "Longyan\,\ Fujian",
  861317823 => "Putian\,\ Fujian",
  861317824 => "Putian\,\ Fujian",
  861317825 => "Xiamen\,\ Fujian",
  861317826 => "Longyan\,\ Fujian",
  861317827 => "Xiamen\,\ Fujian",
  861317828 => "Ningde\,\ Fujian",
  861317829 => "Sanming\,\ Fujian",
  861317830 => "Ningde\,\ Fujian",
  861317831 => "Zhangzhou\,\ Fujian",
  861317832 => "Quanzhou\,\ Fujian",
  861317833 => "Nanping\,\ Fujian",
  861317834 => "Zhangzhou\,\ Fujian",
  861317835 => "Xiamen\,\ Fujian",
  861317836 => "Quanzhou\,\ Fujian",
  861317837 => "Zhangzhou\,\ Fujian",
  861317838 => "Fuzhou\,\ Fujian",
  861317839 => "Longyan\,\ Fujian",
  861317840 => "Shaoguan\,\ Guangdong",
  861317841 => "Shaoguan\,\ Guangdong",
  861317842 => "Shaoguan\,\ Guangdong",
  861317843 => "Shaoguan\,\ Guangdong",
  861317844 => "Shaoguan\,\ Guangdong",
  861317845 => "Qingyuan\,\ Guangdong",
  861317846 => "Qingyuan\,\ Guangdong",
  861317847 => "Qingyuan\,\ Guangdong",
  861317848 => "Qingyuan\,\ Guangdong",
  861317849 => "Qingyuan\,\ Guangdong",
  861317850 => "Foshan\,\ Guangdong",
  861317851 => "Foshan\,\ Guangdong",
  861317852 => "Foshan\,\ Guangdong",
  861317853 => "Foshan\,\ Guangdong",
  861317854 => "Foshan\,\ Guangdong",
  861317855 => "Zhanjiang\,\ Guangdong",
  861317856 => "Zhanjiang\,\ Guangdong",
  861317857 => "Zhanjiang\,\ Guangdong",
  861317858 => "Zhanjiang\,\ Guangdong",
  861317859 => "Zhanjiang\,\ Guangdong",
  86131786 => "Zhongshan\,\ Guangdong",
  861317870 => "Meizhou\,\ Guangdong",
  861317871 => "Meizhou\,\ Guangdong",
  861317872 => "Meizhou\,\ Guangdong",
  861317873 => "Meizhou\,\ Guangdong",
  861317874 => "Meizhou\,\ Guangdong",
  861317875 => "Shantou\,\ Guangdong",
  861317876 => "Shantou\,\ Guangdong",
  861317877 => "Shantou\,\ Guangdong",
  861317878 => "Shantou\,\ Guangdong",
  861317879 => "Shantou\,\ Guangdong",
  86131788 => "Guangzhou\,\ Guangdong",
  86131789 => "Haikou\,\ Hainan",
  861317900 => "Changchun\,\ Jilin",
  861317901 => "Changchun\,\ Jilin",
  861317902 => "Siping\,\ Jilin",
  861317903 => "Siping\,\ Jilin",
  861317904 => "Changchun\,\ Jilin",
  861317905 => "Songyuan\,\ Jilin",
  861317906 => "Baicheng\,\ Jilin",
  861317907 => "Baishan\,\ Jilin",
  861317908 => "Yanbian\,\ Jilin",
  861317909 => "Yanbian\,\ Jilin",
  861317910 => "Changchun\,\ Jilin",
  861317911 => "Changchun\,\ Jilin",
  861317912 => "Changchun\,\ Jilin",
  861317913 => "Changchun\,\ Jilin",
  861317914 => "Yanbian\,\ Jilin",
  861317915 => "Yanbian\,\ Jilin",
  861317916 => "Baicheng\,\ Jilin",
  861317917 => "Baishan\,\ Jilin",
  861317918 => "Siping\,\ Jilin",
  861317919 => "Tonghua\,\ Jilin",
  861317920 => "Songyuan\,\ Jilin",
  861317921 => "Tonghua\,\ Jilin",
  861317922 => "Tonghua\,\ Jilin",
  861317923 => "Jilin\,\ Jilin",
  861317924 => "Jilin\,\ Jilin",
  861317925 => "Jilin\,\ Jilin",
  861317926 => "Jilin\,\ Jilin",
  861317927 => "Jilin\,\ Jilin",
  861317928 => "Liaoyuan\,\ Jilin",
  861317929 => "Liaoyuan\,\ Jilin",
  861317930 => "Changzhou\,\ Jiangsu",
  861317931 => "Changzhou\,\ Jiangsu",
  861317932 => "Yancheng\,\ Jiangsu",
  861317933 => "Yancheng\,\ Jiangsu",
  861317934 => "Yancheng\,\ Jiangsu",
  861317935 => "Yancheng\,\ Jiangsu",
  861317936 => "Taizhou\,\ Jiangsu",
  861317937 => "Taizhou\,\ Jiangsu",
  861317938 => "Zhenjiang\,\ Jiangsu",
  861317939 => "Zhenjiang\,\ Jiangsu",
  861317940 => "Suzhou\,\ Jiangsu",
  861317941 => "Suzhou\,\ Jiangsu",
  861317942 => "Taizhou\,\ Jiangsu",
  861317943 => "Taizhou\,\ Jiangsu",
  861317944 => "Wuxi\,\ Jiangsu",
  861317945 => "Zhenjiang\,\ Jiangsu",
  861317946 => "Zhenjiang\,\ Jiangsu",
  861317947 => "Zhenjiang\,\ Jiangsu",
  861317948 => "Zhenjiang\,\ Jiangsu",
  861317949 => "Zhenjiang\,\ Jiangsu",
  861317950 => "HuaiAn\,\ Jiangsu",
  861317951 => "HuaiAn\,\ Jiangsu",
  861317952 => "HuaiAn\,\ Jiangsu",
  861317953 => "Changzhou\,\ Jiangsu",
  861317954 => "Changzhou\,\ Jiangsu",
  861317955 => "Suqian\,\ Jiangsu",
  861317956 => "Suqian\,\ Jiangsu",
  861317957 => "Lianyungang\,\ Jiangsu",
  861317958 => "Lianyungang\,\ Jiangsu",
  861317959 => "Lianyungang\,\ Jiangsu",
  861317960 => "Suzhou\,\ Jiangsu",
  861317961 => "Suzhou\,\ Jiangsu",
  861317962 => "Suzhou\,\ Jiangsu",
  861317963 => "Suzhou\,\ Jiangsu",
  861317964 => "Suzhou\,\ Jiangsu",
  861317965 => "Wuxi\,\ Jiangsu",
  861317966 => "Wuxi\,\ Jiangsu",
  861317967 => "Wuxi\,\ Jiangsu",
  861317968 => "Wuxi\,\ Jiangsu",
  861317969 => "Wuxi\,\ Jiangsu",
  861317970 => "Xuzhou\,\ Jiangsu",
  861317971 => "Xuzhou\,\ Jiangsu",
  861317972 => "Xuzhou\,\ Jiangsu",
  861317973 => "Xuzhou\,\ Jiangsu",
  861317974 => "Xuzhou\,\ Jiangsu",
  861317975 => "Yangzhou\,\ Jiangsu",
  861317976 => "Yangzhou\,\ Jiangsu",
  861317977 => "Yangzhou\,\ Jiangsu",
  861317978 => "Yangzhou\,\ Jiangsu",
  861317979 => "Yangzhou\,\ Jiangsu",
  861317980 => "Urumchi\,\ Xinjiang",
  861317981 => "Urumchi\,\ Xinjiang",
  861317982 => "Urumchi\,\ Xinjiang",
  861317983 => "Urumchi\,\ Xinjiang",
  861317984 => "Urumchi\,\ Xinjiang",
  861317985 => "Ili\,\ Xinjiang",
  861317986 => "Kizilsu\,\ Xinjiang",
  861317987 => "Bayingolin\,\ Xinjiang",
  861317988 => "Aksu\,\ Xinjiang",
  861317989 => "Hotan\,\ Xinjiang",
  861317990 => "Karamay\,\ Xinjiang",
  861317991 => "Urumchi\,\ Xinjiang",
  861317992 => "Ili\,\ Xinjiang",
  861317993 => "Shihezi\,\ Xinjiang",
  861317994 => "Changji\,\ Xinjiang",
  861317995 => "Turpan\,\ Xinjiang",
  861317996 => "Bayingolin\,\ Xinjiang",
  861317997 => "Aksu\,\ Xinjiang",
  861317998 => "Kashi\,\ Xinjiang",
  861317999 => "Ili\,\ Xinjiang",
  861318000 => "Hengshui\,\ Hebei",
  861318001 => "Hengshui\,\ Hebei",
  861318002 => "Zhangjiakou\,\ Hebei",
  861318003 => "Handan\,\ Hebei",
  861318004 => "Shijiazhuang\,\ Hebei",
  861318005 => "Shijiazhuang\,\ Hebei",
  861318006 => "Shijiazhuang\,\ Hebei",
  861318007 => "Shijiazhuang\,\ Hebei",
  861318008 => "Shijiazhuang\,\ Hebei",
  861318009 => "Shijiazhuang\,\ Hebei",
  861318010 => "Chengde\,\ Hebei",
  861318011 => "Chengde\,\ Hebei",
  861318012 => "Qinhuangdao\,\ Hebei",
  861318013 => "Qinhuangdao\,\ Hebei",
  861318014 => "Qinhuangdao\,\ Hebei",
  861318015 => "Cangzhou\,\ Hebei",
  861318016 => "Tangshan\,\ Hebei",
  861318017 => "Tangshan\,\ Hebei",
  861318018 => "Tangshan\,\ Hebei",
  861318019 => "Tangshan\,\ Hebei",
  861318020 => "Baoding\,\ Hebei",
  861318021 => "Baoding\,\ Hebei",
  861318022 => "Baoding\,\ Hebei",
  861318023 => "Baoding\,\ Hebei",
  861318024 => "Baoding\,\ Hebei",
  861318025 => "Baoding\,\ Hebei",
  861318026 => "Baoding\,\ Hebei",
  861318027 => "Qinhuangdao\,\ Hebei",
  861318028 => "Xingtai\,\ Hebei",
  861318029 => "Hengshui\,\ Hebei",
  861318030 => "Cangzhou\,\ Hebei",
  861318031 => "Cangzhou\,\ Hebei",
  861318032 => "Cangzhou\,\ Hebei",
  861318033 => "Cangzhou\,\ Hebei",
  861318034 => "Langfang\,\ Hebei",
  861318035 => "Langfang\,\ Hebei",
  861318036 => "Langfang\,\ Hebei",
  861318037 => "Langfang\,\ Hebei",
  861318038 => "Langfang\,\ Hebei",
  861318039 => "Zhangjiakou\,\ Hebei",
  861318040 => "Tangshan\,\ Hebei",
  861318041 => "Tangshan\,\ Hebei",
  861318042 => "Tangshan\,\ Hebei",
  861318043 => "Baoding\,\ Hebei",
  861318044 => "Shijiazhuang\,\ Hebei",
  861318045 => "Shijiazhuang\,\ Hebei",
  861318046 => "Shijiazhuang\,\ Hebei",
  861318047 => "Shijiazhuang\,\ Hebei",
  861318048 => "Shijiazhuang\,\ Hebei",
  861318049 => "Shijiazhuang\,\ Hebei",
  861318050 => "Handan\,\ Hebei",
  861318051 => "Handan\,\ Hebei",
  861318052 => "Handan\,\ Hebei",
  861318053 => "Handan\,\ Hebei",
  861318054 => "Xingtai\,\ Hebei",
  861318055 => "Xingtai\,\ Hebei",
  861318056 => "Xingtai\,\ Hebei",
  861318057 => "Zhangjiakou\,\ Hebei",
  861318058 => "Shijiazhuang\,\ Hebei",
  861318059 => "Qinhuangdao\,\ Hebei",
  861318060 => "Baicheng\,\ Jilin",
  861318061 => "Baicheng\,\ Jilin",
  861318062 => "Baicheng\,\ Jilin",
  861318063 => "Siping\,\ Jilin",
  861318064 => "Tonghua\,\ Jilin",
  861318065 => "Tonghua\,\ Jilin",
  861318066 => "Tonghua\,\ Jilin",
  861318067 => "Tonghua\,\ Jilin",
  861318068 => "Tonghua\,\ Jilin",
  861318069 => "Tonghua\,\ Jilin",
  861318070 => "Baishan\,\ Jilin",
  861318071 => "Baishan\,\ Jilin",
  861318072 => "Baishan\,\ Jilin",
  861318073 => "Yanbian\,\ Jilin",
  861318074 => "Changchun\,\ Jilin",
  861318075 => "Jilin\,\ Jilin",
  861318076 => "Jilin\,\ Jilin",
  861318077 => "Songyuan\,\ Jilin",
  861318078 => "Songyuan\,\ Jilin",
  861318079 => "Changchun\,\ Jilin",
  86131808 => "Changchun\,\ Jilin",
  861318090 => "Yanbian\,\ Jilin",
  861318091 => "Yanbian\,\ Jilin",
  861318092 => "Yanbian\,\ Jilin",
  861318093 => "Yanbian\,\ Jilin",
  861318094 => "Changchun\,\ Jilin",
  861318095 => "Liaoyuan\,\ Jilin",
  861318096 => "Liaoyuan\,\ Jilin",
  861318097 => "Siping\,\ Jilin",
  861318098 => "Siping\,\ Jilin",
  861318099 => "Changchun\,\ Jilin",
  861318100 => "Binzhou\,\ Shandong",
  861318101 => "Binzhou\,\ Shandong",
  861318102 => "Binzhou\,\ Shandong",
  861318103 => "Binzhou\,\ Shandong",
  861318104 => "Binzhou\,\ Shandong",
  861318105 => "Liaocheng\,\ Shandong",
  861318106 => "Liaocheng\,\ Shandong",
  861318107 => "Liaocheng\,\ Shandong",
  861318108 => "Liaocheng\,\ Shandong",
  861318109 => "Liaocheng\,\ Shandong",
  861318110 => "Weihai\,\ Shandong",
  861318111 => "Weihai\,\ Shandong",
  861318112 => "Weihai\,\ Shandong",
  861318113 => "Weihai\,\ Shandong",
  861318114 => "Weihai\,\ Shandong",
  861318115 => "Rizhao\,\ Shandong",
  861318116 => "Rizhao\,\ Shandong",
  861318117 => "Rizhao\,\ Shandong",
  861318118 => "Rizhao\,\ Shandong",
  861318119 => "Rizhao\,\ Shandong",
  861318120 => "Linyi\,\ Shandong",
  861318121 => "Linyi\,\ Shandong",
  861318122 => "Linyi\,\ Shandong",
  861318123 => "Linyi\,\ Shandong",
  861318124 => "Linyi\,\ Shandong",
  861318125 => "Zaozhuang\,\ Shandong",
  861318126 => "Zaozhuang\,\ Shandong",
  861318127 => "Zaozhuang\,\ Shandong",
  861318128 => "Zaozhuang\,\ Shandong",
  861318129 => "Zaozhuang\,\ Shandong",
  861318130 => "Jining\,\ Shandong",
  861318131 => "Jining\,\ Shandong",
  861318132 => "Jining\,\ Shandong",
  861318133 => "Jining\,\ Shandong",
  861318134 => "Jining\,\ Shandong",
  861318135 => "Dezhou\,\ Shandong",
  861318136 => "Dezhou\,\ Shandong",
  861318137 => "Dezhou\,\ Shandong",
  861318138 => "Dezhou\,\ Shandong",
  861318139 => "Dezhou\,\ Shandong",
  861318140 => "Dongying\,\ Shandong",
  861318141 => "Dongying\,\ Shandong",
  861318142 => "Zaozhuang\,\ Shandong",
  861318143 => "Zaozhuang\,\ Shandong",
  861318144 => "Zaozhuang\,\ Shandong",
  861318145 => "Rizhao\,\ Shandong",
  861318146 => "Jining\,\ Shandong",
  861318147 => "Jining\,\ Shandong",
  861318148 => "Linyi\,\ Shandong",
  861318149 => "Linyi\,\ Shandong",
  861318150 => "Yantai\,\ Shandong",
  861318151 => "Yantai\,\ Shandong",
  861318152 => "Yantai\,\ Shandong",
  861318153 => "Yantai\,\ Shandong",
  861318154 => "Yantai\,\ Shandong",
  861318155 => "Heze\,\ Shandong",
  861318156 => "Heze\,\ Shandong",
  861318157 => "Heze\,\ Shandong",
  861318158 => "Heze\,\ Shandong",
  861318159 => "Heze\,\ Shandong",
  861318160 => "Yantai\,\ Shandong",
  861318161 => "Yantai\,\ Shandong",
  861318162 => "Yantai\,\ Shandong",
  861318163 => "Yantai\,\ Shandong",
  861318164 => "Yantai\,\ Shandong",
  861318165 => "Weifang\,\ Shandong",
  861318166 => "Weifang\,\ Shandong",
  861318167 => "Weifang\,\ Shandong",
  861318168 => "Weifang\,\ Shandong",
  861318169 => "Weifang\,\ Shandong",
  861318170 => "Jinan\,\ Shandong",
  861318171 => "Jinan\,\ Shandong",
  861318172 => "Jinan\,\ Shandong",
  861318173 => "Jinan\,\ Shandong",
  861318174 => "Jinan\,\ Shandong",
  861318175 => "Laiwu\,\ Shandong",
  861318176 => "Laiwu\,\ Shandong",
  861318177 => "TaiAn\,\ Shandong",
  861318178 => "TaiAn\,\ Shandong",
  861318179 => "TaiAn\,\ Shandong",
  861318180 => "TaiAn\,\ Shandong",
  861318181 => "TaiAn\,\ Shandong",
  861318182 => "TaiAn\,\ Shandong",
  861318183 => "TaiAn\,\ Shandong",
  861318184 => "TaiAn\,\ Shandong",
  861318185 => "Dongying\,\ Shandong",
  861318186 => "Dongying\,\ Shandong",
  861318187 => "Weihai\,\ Shandong",
  861318188 => "Weihai\,\ Shandong",
  861318189 => "Weihai\,\ Shandong",
  861318190 => "Zibo\,\ Shandong",
  861318191 => "Zibo\,\ Shandong",
  861318192 => "Zibo\,\ Shandong",
  861318193 => "Zibo\,\ Shandong",
  861318194 => "Zibo\,\ Shandong",
  861318195 => "Dongying\,\ Shandong",
  861318196 => "Dongying\,\ Shandong",
  861318197 => "Dongying\,\ Shandong",
  861318198 => "Dongying\,\ Shandong",
  861318199 => "Dongying\,\ Shandong",
  861318200 => "Yangzhou\,\ Jiangsu",
  861318201 => "Yangzhou\,\ Jiangsu",
  861318202 => "Yangzhou\,\ Jiangsu",
  861318203 => "Yangzhou\,\ Jiangsu",
  861318204 => "Yangzhou\,\ Jiangsu",
  861318205 => "Yangzhou\,\ Jiangsu",
  861318206 => "Wuxi\,\ Jiangsu",
  861318207 => "Wuxi\,\ Jiangsu",
  861318208 => "Wuxi\,\ Jiangsu",
  861318209 => "Wuxi\,\ Jiangsu",
  86131821 => "Yancheng\,\ Jiangsu",
  86131822 => "Taizhou\,\ Jiangsu",
  86131823 => "Xuzhou\,\ Jiangsu",
  861318240 => "Wuxi\,\ Jiangsu",
  861318241 => "Wuxi\,\ Jiangsu",
  861318242 => "Changzhou\,\ Jiangsu",
  861318243 => "Changzhou\,\ Jiangsu",
  861318244 => "Taizhou\,\ Jiangsu",
  861318245 => "Taizhou\,\ Jiangsu",
  861318246 => "Suzhou\,\ Jiangsu",
  861318247 => "Nantong\,\ Jiangsu",
  861318248 => "Nantong\,\ Jiangsu",
  861318249 => "Nantong\,\ Jiangsu",
  86131825 => "Changzhou\,\ Jiangsu",
  86131826 => "Suzhou\,\ Jiangsu",
  86131827 => "Wuxi\,\ Jiangsu",
  86131828 => "Nanjing\,\ Jiangsu",
  86131829 => "Nanjing\,\ Jiangsu",
  861318300 => "Zhengzhou\,\ Henan",
  861318301 => "Zhengzhou\,\ Henan",
  861318302 => "Xuchang\,\ Henan",
  861318303 => "Xuchang\,\ Henan",
  861318304 => "Shangqiu\,\ Henan",
  861318305 => "Luoyang\,\ Henan",
  861318306 => "Luoyang\,\ Henan",
  861318307 => "Luoyang\,\ Henan",
  861318308 => "Luoyang\,\ Henan",
  861318309 => "Xinxiang\,\ Henan",
  861318310 => "Xinxiang\,\ Henan",
  861318311 => "Xinxiang\,\ Henan",
  861318312 => "Jiaozuo\,\ Henan",
  861318313 => "Jiaozuo\,\ Henan",
  861318314 => "Zhumadian\,\ Henan",
  861318315 => "Anyang\,\ Henan",
  861318316 => "Anyang\,\ Henan",
  861318317 => "Puyang\,\ Henan",
  861318318 => "Puyang\,\ Henan",
  861318319 => "Luohe\,\ Henan",
  861318320 => "Luohe\,\ Henan",
  861318321 => "Luohe\,\ Henan",
  861318322 => "Zhoukou\,\ Henan",
  861318323 => "Zhoukou\,\ Henan",
  861318324 => "Sanmenxia\,\ Henan",
  861318325 => "Kaifeng\,\ Henan",
  861318326 => "Kaifeng\,\ Henan",
  861318327 => "Kaifeng\,\ Henan",
  861318328 => "Kaifeng\,\ Henan",
  861318329 => "Shangqiu\,\ Henan",
  861318330 => "Nanyang\,\ Henan",
  861318331 => "Nanyang\,\ Henan",
  861318332 => "Pingdingshan\,\ Henan",
  861318333 => "Pingdingshan\,\ Henan",
  861318334 => "Pingdingshan\,\ Henan",
  861318335 => "Pingdingshan\,\ Henan",
  861318336 => "Xinyang\,\ Henan",
  861318337 => "Xinyang\,\ Henan",
  861318338 => "Zhumadian\,\ Henan",
  861318339 => "Sanmenxia\,\ Henan",
  861318340 => "Nanchong\,\ Sichuan",
  861318341 => "Dazhou\,\ Sichuan",
  861318342 => "Deyang\,\ Sichuan",
  861318343 => "Mianyang\,\ Sichuan",
  861318344 => "Leshan\,\ Sichuan",
  861318345 => "Luzhou\,\ Sichuan",
  861318346 => "Zigong\,\ Sichuan",
  861318347 => "Yibin\,\ Sichuan",
  861318348 => "Neijiang\,\ Sichuan",
  861318349 => "Panzhihua\,\ Sichuan",
  861318350 => "Dazhou\,\ Sichuan",
  861318351 => "Dazhou\,\ Sichuan",
  861318352 => "Bazhong\,\ Sichuan",
  861318353 => "Bazhong\,\ Sichuan",
  861318354 => "Guangyuan\,\ Sichuan",
  861318355 => "Guangyuan\,\ Sichuan",
  861318356 => "Guangyuan\,\ Sichuan",
  861318357 => "Suining\,\ Sichuan",
  861318358 => "Suining\,\ Sichuan",
  861318359 => "Dazhou\,\ Sichuan",
  861318360 => "Luzhou\,\ Sichuan",
  861318361 => "Luzhou\,\ Sichuan",
  861318362 => "Leshan\,\ Sichuan",
  861318363 => "Leshan\,\ Sichuan",
  861318364 => "Meishan\,\ Sichuan",
  861318365 => "Meishan\,\ Sichuan",
  861318366 => "Meishan\,\ Sichuan",
  861318367 => "Neijiang\,\ Sichuan",
  861318368 => "Neijiang\,\ Sichuan",
  861318369 => "Neijiang\,\ Sichuan",
  861318370 => "Panzhihua\,\ Sichuan",
  861318371 => "Panzhihua\,\ Sichuan",
  861318372 => "Liangshan\,\ Sichuan",
  861318373 => "Liangshan\,\ Sichuan",
  861318374 => "YaAn\,\ Sichuan",
  861318375 => "Nanchong\,\ Sichuan",
  861318376 => "Nanchong\,\ Sichuan",
  861318377 => "Mianyang\,\ Sichuan",
  861318378 => "Mianyang\,\ Sichuan",
  861318379 => "Mianyang\,\ Sichuan",
  86131838 => "Chengdu\,\ Sichuan",
  861318390 => "GuangAn\,\ Sichuan",
  861318391 => "GuangAn\,\ Sichuan",
  861318392 => "Zigong\,\ Sichuan",
  861318393 => "Zigong\,\ Sichuan",
  861318394 => "Ziyang\,\ Sichuan",
  861318395 => "Ziyang\,\ Sichuan",
  861318396 => "Yibin\,\ Sichuan",
  861318397 => "Yibin\,\ Sichuan",
  861318398 => "Deyang\,\ Sichuan",
  861318399 => "Deyang\,\ Sichuan",
  861318400 => "Yantai\,\ Shandong",
  861318401 => "Yantai\,\ Shandong",
  861318402 => "Yantai\,\ Shandong",
  861318403 => "Yantai\,\ Shandong",
  861318404 => "Yantai\,\ Shandong",
  861318405 => "Yantai\,\ Shandong",
  861318406 => "Heze\,\ Shandong",
  861318407 => "Heze\,\ Shandong",
  861318408 => "Heze\,\ Shandong",
  861318409 => "Heze\,\ Shandong",
  861318410 => "Dezhou\,\ Shandong",
  861318411 => "Dezhou\,\ Shandong",
  861318412 => "Dezhou\,\ Shandong",
  861318413 => "Qingdao\,\ Shandong",
  861318414 => "Qingdao\,\ Shandong",
  861318415 => "Liaocheng\,\ Shandong",
  861318416 => "Liaocheng\,\ Shandong",
  861318417 => "Liaocheng\,\ Shandong",
  861318418 => "Weihai\,\ Shandong",
  861318419 => "Weihai\,\ Shandong",
  861318420 => "Hangzhou\,\ Zhejiang",
  861318421 => "Hangzhou\,\ Zhejiang",
  861318422 => "Hangzhou\,\ Zhejiang",
  861318423 => "Hangzhou\,\ Zhejiang",
  861318424 => "Hangzhou\,\ Zhejiang",
  861318425 => "Wenzhou\,\ Zhejiang",
  861318426 => "Wenzhou\,\ Zhejiang",
  861318427 => "Wenzhou\,\ Zhejiang",
  861318428 => "Wenzhou\,\ Zhejiang",
  861318429 => "Wenzhou\,\ Zhejiang",
  861318430 => "Ningbo\,\ Zhejiang",
  861318431 => "Ningbo\,\ Zhejiang",
  861318432 => "Ningbo\,\ Zhejiang",
  861318433 => "Ningbo\,\ Zhejiang",
  861318434 => "Ningbo\,\ Zhejiang",
  861318435 => "Taizhou\,\ Zhejiang",
  861318436 => "Taizhou\,\ Zhejiang",
  861318437 => "Taizhou\,\ Zhejiang",
  861318438 => "Taizhou\,\ Zhejiang",
  861318439 => "Taizhou\,\ Zhejiang",
  861318440 => "Quzhou\,\ Zhejiang",
  861318441 => "Hangzhou\,\ Zhejiang",
  861318442 => "Huzhou\,\ Zhejiang",
  861318443 => "Jiaxing\,\ Zhejiang",
  861318444 => "Ningbo\,\ Zhejiang",
  861318445 => "Shaoxing\,\ Zhejiang",
  861318446 => "Taizhou\,\ Zhejiang",
  861318447 => "Wenzhou\,\ Zhejiang",
  861318448 => "Lishui\,\ Zhejiang",
  861318449 => "Jinhua\,\ Zhejiang",
  861318450 => "Jingdezhen\,\ Jiangxi",
  861318451 => "Jingdezhen\,\ Jiangxi",
  861318452 => "Ganzhou\,\ Jiangxi",
  861318453 => "Ganzhou\,\ Jiangxi",
  861318454 => "Ganzhou\,\ Jiangxi",
  861318455 => "Pingxiang\,\ Jiangxi",
  861318456 => "Nanchang\,\ Jiangxi",
  861318457 => "Nanchang\,\ Jiangxi",
  861318458 => "Nanchang\,\ Jiangxi",
  861318459 => "Nanchang\,\ Jiangxi",
  861318460 => "Jiujiang\,\ Jiangxi",
  861318461 => "Jiujiang\,\ Jiangxi",
  861318462 => "Jiujiang\,\ Jiangxi",
  861318463 => "Shangrao\,\ Jiangxi",
  861318464 => "Shangrao\,\ Jiangxi",
  861318465 => "Shangrao\,\ Jiangxi",
  861318466 => "Yichun\,\ Jiangxi",
  861318467 => "Yichun\,\ Jiangxi",
  861318468 => "Yichun\,\ Jiangxi",
  861318469 => "JiAn\,\ Jiangxi",
  861318470 => "Handan\,\ Hebei",
  861318471 => "Handan\,\ Hebei",
  861318472 => "Qinhuangdao\,\ Hebei",
  861318473 => "Langfang\,\ Hebei",
  861318474 => "Shijiazhuang\,\ Hebei",
  861318475 => "Xingtai\,\ Hebei",
  861318476 => "Hengshui\,\ Hebei",
  861318477 => "Shijiazhuang\,\ Hebei",
  861318478 => "Cangzhou\,\ Hebei",
  861318479 => "Tangshan\,\ Hebei",
  861318480 => "Jieyang\,\ Guangdong",
  861318481 => "Jieyang\,\ Guangdong",
  861318482 => "Jieyang\,\ Guangdong",
  861318483 => "Jieyang\,\ Guangdong",
  861318484 => "Jieyang\,\ Guangdong",
  861318485 => "Shanwei\,\ Guangdong",
  861318486 => "Shanwei\,\ Guangdong",
  861318487 => "Shanwei\,\ Guangdong",
  861318488 => "Shanwei\,\ Guangdong",
  861318489 => "Shanwei\,\ Guangdong",
  861318490 => "Baoding\,\ Hebei",
  861318491 => "Tangshan\,\ Hebei",
  861318492 => "Qinhuangdao\,\ Hebei",
  861318493 => "Cangzhou\,\ Hebei",
  861318494 => "Baoding\,\ Hebei",
  861318495 => "Xingtai\,\ Hebei",
  861318496 => "Hengshui\,\ Hebei",
  861318497 => "Hengshui\,\ Hebei",
  861318498 => "Cangzhou\,\ Hebei",
  861318499 => "Tangshan\,\ Hebei",
  86131850 => "Hangzhou\,\ Zhejiang",
  86131851 => "Jinhua\,\ Zhejiang",
  86131852 => "Huzhou\,\ Zhejiang",
  86131853 => "Jiaxing\,\ Zhejiang",
  861318540 => "Jiaxing\,\ Zhejiang",
  861318541 => "Jiaxing\,\ Zhejiang",
  861318542 => "Jiaxing\,\ Zhejiang",
  861318543 => "Jiaxing\,\ Zhejiang",
  861318544 => "Jiaxing\,\ Zhejiang",
  861318545 => "Huzhou\,\ Zhejiang",
  861318546 => "Huzhou\,\ Zhejiang",
  861318547 => "Huzhou\,\ Zhejiang",
  861318548 => "Huzhou\,\ Zhejiang",
  861318549 => "Huzhou\,\ Zhejiang",
  86131855 => "Shaoxing\,\ Zhejiang",
  86131856 => "Taizhou\,\ Zhejiang",
  861318570 => "Quzhou\,\ Zhejiang",
  861318571 => "Hangzhou\,\ Zhejiang",
  861318572 => "Huzhou\,\ Zhejiang",
  861318573 => "Jiaxing\,\ Zhejiang",
  861318574 => "Ningbo\,\ Zhejiang",
  861318575 => "Shaoxing\,\ Zhejiang",
  861318576 => "Taizhou\,\ Zhejiang",
  861318577 => "Wenzhou\,\ Zhejiang",
  861318578 => "Lishui\,\ Zhejiang",
  861318579 => "Jinhua\,\ Zhejiang",
  861318580 => "Zhoushan\,\ Zhejiang",
  861318581 => "Wenzhou\,\ Zhejiang",
  861318582 => "Wenzhou\,\ Zhejiang",
  861318583 => "Wenzhou\,\ Zhejiang",
  861318584 => "Wenzhou\,\ Zhejiang",
  861318585 => "Wenzhou\,\ Zhejiang",
  861318586 => "Wenzhou\,\ Zhejiang",
  861318587 => "Wenzhou\,\ Zhejiang",
  861318588 => "Wenzhou\,\ Zhejiang",
  861318589 => "Wenzhou\,\ Zhejiang",
  86131859 => "Ningbo\,\ Zhejiang",
  86131860 => "XiAn\,\ Shaanxi",
  86131861 => "XiAn\,\ Shaanxi",
  861318620 => "Weinan\,\ Shaanxi",
  861318621 => "Weinan\,\ Shaanxi",
  861318622 => "Weinan\,\ Shaanxi",
  861318623 => "Xianyang\,\ Shaanxi",
  861318624 => "Xianyang\,\ Shaanxi",
  861318625 => "Xianyang\,\ Shaanxi",
  861318626 => "Xianyang\,\ Shaanxi",
  861318627 => "Ankang\,\ Shaanxi",
  861318628 => "Ankang\,\ Shaanxi",
  861318629 => "Ankang\,\ Shaanxi",
  861318630 => "Hanzhong\,\ Shaanxi",
  861318631 => "Hanzhong\,\ Shaanxi",
  861318632 => "Hanzhong\,\ Shaanxi",
  861318633 => "Hanzhong\,\ Shaanxi",
  861318634 => "Hanzhong\,\ Shaanxi",
  861318635 => "Hanzhong\,\ Shaanxi",
  861318636 => "Baoji\,\ Shaanxi",
  861318637 => "Baoji\,\ Shaanxi",
  861318638 => "Baoji\,\ Shaanxi",
  861318639 => "Baoji\,\ Shaanxi",
  861318640 => "Nanjing\,\ Jiangsu",
  861318641 => "Nanjing\,\ Jiangsu",
  861318642 => "Nanjing\,\ Jiangsu",
  861318643 => "Nanjing\,\ Jiangsu",
  861318644 => "Yancheng\,\ Jiangsu",
  861318645 => "Yancheng\,\ Jiangsu",
  861318646 => "Lianyungang\,\ Jiangsu",
  861318647 => "Lianyungang\,\ Jiangsu",
  861318648 => "Zhenjiang\,\ Jiangsu",
  861318649 => "Zhenjiang\,\ Jiangsu",
  86131865 => "Nantong\,\ Jiangsu",
  861318660 => "Lianyungang\,\ Jiangsu",
  861318661 => "Lianyungang\,\ Jiangsu",
  861318662 => "Lianyungang\,\ Jiangsu",
  861318663 => "Zhenjiang\,\ Jiangsu",
  861318664 => "HuaiAn\,\ Jiangsu",
  861318665 => "HuaiAn\,\ Jiangsu",
  861318666 => "Changzhou\,\ Jiangsu",
  861318667 => "Changzhou\,\ Jiangsu",
  861318668 => "Changzhou\,\ Jiangsu",
  861318669 => "Changzhou\,\ Jiangsu",
  861318670 => "Quzhou\,\ Zhejiang",
  861318671 => "Quzhou\,\ Zhejiang",
  861318672 => "Quzhou\,\ Zhejiang",
  861318673 => "Quzhou\,\ Zhejiang",
  861318674 => "Lishui\,\ Zhejiang",
  861318675 => "Lishui\,\ Zhejiang",
  861318676 => "Lishui\,\ Zhejiang",
  861318677 => "Zhoushan\,\ Zhejiang",
  861318678 => "Zhoushan\,\ Zhejiang",
  861318679 => "Zhoushan\,\ Zhejiang",
  861318680 => "Wenzhou\,\ Zhejiang",
  861318681 => "Wenzhou\,\ Zhejiang",
  861318682 => "Wenzhou\,\ Zhejiang",
  861318683 => "Wenzhou\,\ Zhejiang",
  861318684 => "Wenzhou\,\ Zhejiang",
  861318685 => "Ningbo\,\ Zhejiang",
  861318686 => "Ningbo\,\ Zhejiang",
  861318687 => "Ningbo\,\ Zhejiang",
  861318688 => "Ningbo\,\ Zhejiang",
  861318689 => "Ningbo\,\ Zhejiang",
  861318690 => "Taizhou\,\ Zhejiang",
  861318691 => "Taizhou\,\ Zhejiang",
  861318692 => "Taizhou\,\ Zhejiang",
  861318693 => "Taizhou\,\ Zhejiang",
  861318694 => "Taizhou\,\ Zhejiang",
  861318695 => "Hangzhou\,\ Zhejiang",
  861318696 => "Hangzhou\,\ Zhejiang",
  861318697 => "Hangzhou\,\ Zhejiang",
  861318698 => "Hangzhou\,\ Zhejiang",
  861318699 => "Hangzhou\,\ Zhejiang",
  86131870 => "Changsha\,\ Hunan",
  861318710 => "Yongzhou\,\ Hunan",
  861318711 => "Yongzhou\,\ Hunan",
  861318712 => "Yongzhou\,\ Hunan",
  861318713 => "Yongzhou\,\ Hunan",
  861318714 => "Huaihua\,\ Hunan",
  861318715 => "Huaihua\,\ Hunan",
  861318716 => "Hengyang\,\ Hunan",
  861318717 => "Shaoyang\,\ Hunan",
  861318718 => "Shaoyang\,\ Hunan",
  861318719 => "Shaoyang\,\ Hunan",
  861318720 => "Hengyang\,\ Hunan",
  861318721 => "Changsha\,\ Hunan",
  861318722 => "Xiangtan\,\ Hunan",
  861318723 => "Hengyang\,\ Hunan",
  861318724 => "Hengyang\,\ Hunan",
  861318725 => "Chenzhou\,\ Hunan",
  861318726 => "Chenzhou\,\ Hunan",
  861318727 => "Chenzhou\,\ Hunan",
  861318728 => "Shaoyang\,\ Hunan",
  861318729 => "Shaoyang\,\ Hunan",
  861318730 => "Hengyang\,\ Hunan",
  861318731 => "Changsha\,\ Hunan",
  861318732 => "Xiangtan\,\ Hunan",
  861318733 => "Hengyang\,\ Hunan",
  861318734 => "Hengyang\,\ Hunan",
  861318735 => "Chenzhou\,\ Hunan",
  861318736 => "Chenzhou\,\ Hunan",
  861318737 => "Yiyang\,\ Hunan",
  861318738 => "Shaoyang\,\ Hunan",
  861318739 => "Shaoyang\,\ Hunan",
  861318740 => "Kunming\,\ Yunnan",
  861318741 => "Kunming\,\ Yunnan",
  861318742 => "Kunming\,\ Yunnan",
  861318743 => "Kunming\,\ Yunnan",
  861318744 => "Kunming\,\ Yunnan",
  861318745 => "Qujing\,\ Yunnan",
  861318746 => "Dali\,\ Yunnan",
  861318747 => "Lincang\,\ Yunnan",
  861318748 => "Deqen\,\ Yunnan",
  861318749 => "Nujiang\,\ Yunnan",
  861318750 => "Baoshan\,\ Yunnan",
  861318751 => "Baoshan\,\ Yunnan",
  861318752 => "Baoshan\,\ Yunnan",
  861318753 => "Baoshan\,\ Yunnan",
  861318754 => "Zhaotong\,\ Yunnan",
  861318755 => "Zhaotong\,\ Yunnan",
  861318756 => "Dehong\,\ Yunnan",
  861318757 => "Dehong\,\ Yunnan",
  861318758 => "Lincang\,\ Yunnan",
  861318759 => "Lincang\,\ Yunnan",
  861318760 => "Wenshan\,\ Yunnan",
  861318761 => "Wenshan\,\ Yunnan",
  861318762 => "Wenshan\,\ Yunnan",
  861318763 => "Wenshan\,\ Yunnan",
  861318764 => "Chuxiong\,\ Yunnan",
  861318765 => "Chuxiong\,\ Yunnan",
  861318766 => "Chuxiong\,\ Yunnan",
  861318767 => "Chuxiong\,\ Yunnan",
  861318768 => "Dali\,\ Yunnan",
  861318769 => "Dali\,\ Yunnan",
  861318770 => "Kunming\,\ Yunnan",
  861318771 => "Yuxi\,\ Yunnan",
  861318772 => "Yuxi\,\ Yunnan",
  861318773 => "Yuxi\,\ Yunnan",
  861318774 => "Yuxi\,\ Yunnan",
  861318775 => "Lijiang\,\ Yunnan",
  861318776 => "Qujing\,\ Yunnan",
  861318777 => "Qujing\,\ Yunnan",
  861318778 => "Qujing\,\ Yunnan",
  861318779 => "Lijiang\,\ Yunnan",
  861318780 => "Chuxiong\,\ Yunnan",
  861318781 => "Kunming\,\ Yunnan",
  861318782 => "Kunming\,\ Yunnan",
  861318783 => "Kunming\,\ Yunnan",
  861318784 => "Kunming\,\ Yunnan",
  861318785 => "Kunming\,\ Yunnan",
  861318786 => "Kunming\,\ Yunnan",
  861318787 => "Kunming\,\ Yunnan",
  861318788 => "Kunming\,\ Yunnan",
  861318789 => "Kunming\,\ Yunnan",
  861318790 => "Puer\,\ Yunnan",
  861318791 => "Puer\,\ Yunnan",
  861318792 => "Puer\,\ Yunnan",
  861318793 => "Puer\,\ Yunnan",
  861318794 => "Honghe\,\ Yunnan",
  861318795 => "Honghe\,\ Yunnan",
  861318796 => "Honghe\,\ Yunnan",
  861318797 => "Xishuangbanna\,\ Yunnan",
  861318798 => "Deqen\,\ Yunnan",
  861318799 => "Nujiang\,\ Yunnan",
  86131880 => "Anshan\,\ Liaoning",
  861318810 => "Jinzhou\,\ Liaoning",
  861318811 => "Jinzhou\,\ Liaoning",
  861318812 => "Jinzhou\,\ Liaoning",
  861318813 => "Jinzhou\,\ Liaoning",
  861318814 => "Jinzhou\,\ Liaoning",
  861318815 => "Chaoyang\,\ Liaoning",
  861318816 => "Chaoyang\,\ Liaoning",
  861318817 => "Chaoyang\,\ Liaoning",
  861318818 => "Chaoyang\,\ Liaoning",
  861318819 => "Chaoyang\,\ Liaoning",
  861318820 => "Benxi\,\ Liaoning",
  861318821 => "Benxi\,\ Liaoning",
  861318822 => "Benxi\,\ Liaoning",
  861318823 => "Benxi\,\ Liaoning",
  861318824 => "Benxi\,\ Liaoning",
  861318825 => "Fushun\,\ Liaoning",
  861318826 => "Fushun\,\ Liaoning",
  861318827 => "Fushun\,\ Liaoning",
  861318828 => "Fushun\,\ Liaoning",
  861318829 => "Fushun\,\ Liaoning",
  861318830 => "Fuxin\,\ Liaoning",
  861318831 => "Fuxin\,\ Liaoning",
  861318832 => "Fuxin\,\ Liaoning",
  861318833 => "Fuxin\,\ Liaoning",
  861318834 => "Fuxin\,\ Liaoning",
  861318835 => "Dandong\,\ Liaoning",
  861318836 => "Dandong\,\ Liaoning",
  861318837 => "Dandong\,\ Liaoning",
  861318838 => "Dandong\,\ Liaoning",
  861318839 => "Dandong\,\ Liaoning",
  861318840 => "Tieling\,\ Liaoning",
  861318841 => "Tieling\,\ Liaoning",
  861318842 => "Tieling\,\ Liaoning",
  861318843 => "Tieling\,\ Liaoning",
  861318844 => "Tieling\,\ Liaoning",
  861318845 => "Liaoyang\,\ Liaoning",
  861318846 => "Liaoyang\,\ Liaoning",
  861318847 => "Liaoyang\,\ Liaoning",
  861318848 => "Liaoyang\,\ Liaoning",
  861318849 => "Liaoyang\,\ Liaoning",
  861318850 => "Huludao\,\ Liaoning",
  861318851 => "Huludao\,\ Liaoning",
  861318852 => "Huludao\,\ Liaoning",
  861318853 => "Huludao\,\ Liaoning",
  861318854 => "Huludao\,\ Liaoning",
  861318855 => "Panjin\,\ Liaoning",
  861318856 => "Panjin\,\ Liaoning",
  861318857 => "Panjin\,\ Liaoning",
  861318858 => "Panjin\,\ Liaoning",
  861318859 => "Panjin\,\ Liaoning",
  861318860 => "Liaoyang\,\ Liaoning",
  861318861 => "Liaoyang\,\ Liaoning",
  861318862 => "Liaoyang\,\ Liaoning",
  861318863 => "Liaoyang\,\ Liaoning",
  861318864 => "Liaoyang\,\ Liaoning",
  861318865 => "Tieling\,\ Liaoning",
  861318866 => "Tieling\,\ Liaoning",
  861318867 => "Tieling\,\ Liaoning",
  861318868 => "Tieling\,\ Liaoning",
  861318869 => "Tieling\,\ Liaoning",
  861318870 => "Linyi\,\ Shandong",
  861318871 => "Linyi\,\ Shandong",
  861318872 => "Linyi\,\ Shandong",
  861318873 => "Linyi\,\ Shandong",
  861318874 => "Liaocheng\,\ Shandong",
  861318875 => "Liaocheng\,\ Shandong",
  861318876 => "Yantai\,\ Shandong",
  861318877 => "Yantai\,\ Shandong",
  861318878 => "Yantai\,\ Shandong",
  861318879 => "Yantai\,\ Shandong",
  861318880 => "Jining\,\ Shandong",
  861318881 => "Jining\,\ Shandong",
  861318882 => "Jining\,\ Shandong",
  861318883 => "Weifang\,\ Shandong",
  861318884 => "Weifang\,\ Shandong",
  861318885 => "Weifang\,\ Shandong",
  861318886 => "Weifang\,\ Shandong",
  861318887 => "Jinan\,\ Shandong",
  861318888 => "Jinan\,\ Shandong",
  861318889 => "Jinan\,\ Shandong",
  861318890 => "Binzhou\,\ Shandong",
  861318891 => "Binzhou\,\ Shandong",
  861318892 => "Zaozhuang\,\ Shandong",
  861318893 => "Jinan\,\ Shandong",
  861318894 => "Jinan\,\ Shandong",
  861318895 => "Qingdao\,\ Shandong",
  861318896 => "Qingdao\,\ Shandong",
  861318897 => "Qingdao\,\ Shandong",
  861318898 => "Qingdao\,\ Shandong",
  861318899 => "Qingdao\,\ Shandong",
  86131890 => "Guangzhou\,\ Guangdong",
  86131891 => "Guangzhou\,\ Guangdong",
  86131892 => "Zhongshan\,\ Guangdong",
  86131893 => "Zhaoqing\,\ Guangdong",
  861318940 => "Jiangmen\,\ Guangdong",
  861318941 => "Jiangmen\,\ Guangdong",
  861318942 => "Jiangmen\,\ Guangdong",
  861318943 => "Jiangmen\,\ Guangdong",
  861318944 => "Jiangmen\,\ Guangdong",
  861318945 => "Zhanjiang\,\ Guangdong",
  861318946 => "Zhanjiang\,\ Guangdong",
  861318947 => "Zhanjiang\,\ Guangdong",
  861318948 => "Zhanjiang\,\ Guangdong",
  861318949 => "Zhanjiang\,\ Guangdong",
  86131895 => "Maoming\,\ Guangdong",
  86131896 => "Foshan\,\ Guangdong",
  861318970 => "Shenzhen\,\ Guangdong",
  861318971 => "Shenzhen\,\ Guangdong",
  861318972 => "Shenzhen\,\ Guangdong",
  861318973 => "Shenzhen\,\ Guangdong",
  861318974 => "Shenzhen\,\ Guangdong",
  861318975 => "Shenzhen\,\ Guangdong",
  861318976 => "Shenzhen\,\ Guangdong",
  861318977 => "Shenzhen\,\ Guangdong",
  861318978 => "Shenzhen\,\ Guangdong",
  861318979 => "Shijiazhuang\,\ Hebei",
  861318980 => "Zhanjiang\,\ Guangdong",
  861318981 => "Zhanjiang\,\ Guangdong",
  861318982 => "Zhanjiang\,\ Guangdong",
  861318983 => "Zhanjiang\,\ Guangdong",
  861318984 => "Zhanjiang\,\ Guangdong",
  861318985 => "Jiangmen\,\ Guangdong",
  861318986 => "Jiangmen\,\ Guangdong",
  861318987 => "Jiangmen\,\ Guangdong",
  861318988 => "Jiangmen\,\ Guangdong",
  861318989 => "Jiangmen\,\ Guangdong",
  86131899 => "Meizhou\,\ Guangdong",
  86131900 => "Shenyang\,\ Liaoning",
  86131901 => "Dalian\,\ Liaoning",
  861319020 => "Dandong\,\ Liaoning",
  861319021 => "Dandong\,\ Liaoning",
  861319022 => "Dandong\,\ Liaoning",
  861319023 => "Dandong\,\ Liaoning",
  861319024 => "Dandong\,\ Liaoning",
  861319025 => "Chaoyang\,\ Liaoning",
  861319026 => "Chaoyang\,\ Liaoning",
  861319027 => "Fuxin\,\ Liaoning",
  861319028 => "Fuxin\,\ Liaoning",
  861319029 => "Fuxin\,\ Liaoning",
  861319030 => "Panjin\,\ Liaoning",
  861319031 => "Panjin\,\ Liaoning",
  861319032 => "Panjin\,\ Liaoning",
  861319033 => "Panjin\,\ Liaoning",
  861319034 => "Panjin\,\ Liaoning",
  861319035 => "Huludao\,\ Liaoning",
  861319036 => "Huludao\,\ Liaoning",
  861319037 => "Huludao\,\ Liaoning",
  861319038 => "Huludao\,\ Liaoning",
  861319039 => "Huludao\,\ Liaoning",
  861319040 => "Jinzhou\,\ Liaoning",
  861319041 => "Jinzhou\,\ Liaoning",
  861319042 => "Jinzhou\,\ Liaoning",
  861319043 => "Jinzhou\,\ Liaoning",
  861319044 => "Jinzhou\,\ Liaoning",
  861319045 => "Benxi\,\ Liaoning",
  861319046 => "Benxi\,\ Liaoning",
  861319047 => "Benxi\,\ Liaoning",
  861319048 => "Benxi\,\ Liaoning",
  861319049 => "Benxi\,\ Liaoning",
  861319050 => "Hohhot\,\ Inner\ Mongolia",
  861319051 => "Hohhot\,\ Inner\ Mongolia",
  861319052 => "Hohhot\,\ Inner\ Mongolia",
  861319053 => "Hohhot\,\ Inner\ Mongolia",
  861319054 => "Hohhot\,\ Inner\ Mongolia",
  861319055 => "Hohhot\,\ Inner\ Mongolia",
  861319056 => "Tongliao\,\ Inner\ Mongolia",
  861319057 => "Xilin\,\ Inner\ Mongolia",
  861319058 => "Wuhai\,\ Inner\ Mongolia",
  861319059 => "Ulanqab\,\ Inner\ Mongolia",
  861319060 => "Hohhot\,\ Inner\ Mongolia",
  861319061 => "Alxa\,\ Inner\ Mongolia",
  861319062 => "Ulanqab\,\ Inner\ Mongolia",
  861319063 => "Ulanqab\,\ Inner\ Mongolia",
  861319064 => "Ulanqab\,\ Inner\ Mongolia",
  861319065 => "Ulanqab\,\ Inner\ Mongolia",
  861319066 => "Xilin\,\ Inner\ Mongolia",
  861319067 => "Xilin\,\ Inner\ Mongolia",
  861319068 => "Wuhai\,\ Inner\ Mongolia",
  861319069 => "Baotou\,\ Inner\ Mongolia",
  861319070 => "Baotou\,\ Inner\ Mongolia",
  861319071 => "Baotou\,\ Inner\ Mongolia",
  861319072 => "Baotou\,\ Inner\ Mongolia",
  861319073 => "Baotou\,\ Inner\ Mongolia",
  861319074 => "Baotou\,\ Inner\ Mongolia",
  861319075 => "Baotou\,\ Inner\ Mongolia",
  861319076 => "Hulun\,\ Inner\ Mongolia",
  861319077 => "Hulun\,\ Inner\ Mongolia",
  861319078 => "Bayannur\,\ Inner\ Mongolia",
  861319079 => "Bayannur\,\ Inner\ Mongolia",
  861319080 => "Ordos\,\ Inner\ Mongolia",
  861319081 => "Ordos\,\ Inner\ Mongolia",
  861319082 => "Ordos\,\ Inner\ Mongolia",
  861319083 => "Ordos\,\ Inner\ Mongolia",
  861319084 => "Ordos\,\ Inner\ Mongolia",
  861319085 => "Bayannur\,\ Inner\ Mongolia",
  861319086 => "Bayannur\,\ Inner\ Mongolia",
  861319087 => "Bayannur\,\ Inner\ Mongolia",
  861319088 => "Tongliao\,\ Inner\ Mongolia",
  861319089 => "Tongliao\,\ Inner\ Mongolia",
  861319090 => "Chifeng\,\ Inner\ Mongolia",
  861319091 => "Chifeng\,\ Inner\ Mongolia",
  861319092 => "Chifeng\,\ Inner\ Mongolia",
  861319093 => "Chifeng\,\ Inner\ Mongolia",
  861319094 => "Chifeng\,\ Inner\ Mongolia",
  861319095 => "Hinggan\,\ Inner\ Mongolia",
  861319096 => "Hinggan\,\ Inner\ Mongolia",
  861319097 => "Hulun\,\ Inner\ Mongolia",
  861319098 => "Hulun\,\ Inner\ Mongolia",
  861319099 => "Hulun\,\ Inner\ Mongolia",
  861319100 => "Taiyuan\,\ Shanxi",
  861319101 => "Jinzhong\,\ Shanxi",
  861319102 => "Shuozhou\,\ Shanxi",
  861319103 => "Changzhi\,\ Shanxi",
  861319104 => "Taiyuan\,\ Shanxi",
  861319105 => "Taiyuan\,\ Shanxi",
  861319106 => "Taiyuan\,\ Shanxi",
  861319107 => "Taiyuan\,\ Shanxi",
  861319108 => "Taiyuan\,\ Shanxi",
  861319109 => "Taiyuan\,\ Shanxi",
  861319110 => "Xinzhou\,\ Shanxi",
  861319111 => "Linfen\,\ Shanxi",
  861319112 => "Datong\,\ Shanxi",
  861319113 => "Yangquan\,\ Shanxi",
  861319114 => "Jinzhong\,\ Shanxi",
  861319115 => "Changzhi\,\ Shanxi",
  861319116 => "Jincheng\,\ Shanxi",
  861319117 => "Linfen\,\ Shanxi",
  861319118 => "Lüliang\,\ Shanxi",
  861319119 => "Yuncheng\,\ Shanxi",
  861319120 => "Xinzhou\,\ Shanxi",
  861319121 => "Lüliang\,\ Shanxi",
  861319122 => "Datong\,\ Shanxi",
  861319123 => "Yangquan\,\ Shanxi",
  861319124 => "Yuncheng\,\ Shanxi",
  861319125 => "Changzhi\,\ Shanxi",
  861319126 => "Jincheng\,\ Shanxi",
  861319127 => "Linfen\,\ Shanxi",
  861319128 => "Datong\,\ Shanxi",
  861319129 => "Yuncheng\,\ Shanxi",
  861319130 => "Hulun\,\ Inner\ Mongolia",
  861319131 => "Hulun\,\ Inner\ Mongolia",
  861319132 => "Hulun\,\ Inner\ Mongolia",
  861319133 => "Hulun\,\ Inner\ Mongolia",
  861319134 => "Hulun\,\ Inner\ Mongolia",
  861319135 => "Wuhai\,\ Inner\ Mongolia",
  861319136 => "Ordos\,\ Inner\ Mongolia",
  861319137 => "Ordos\,\ Inner\ Mongolia",
  861319138 => "Bayannur\,\ Inner\ Mongolia",
  861319139 => "Bayannur\,\ Inner\ Mongolia",
  861319140 => "Hohhot\,\ Inner\ Mongolia",
  861319141 => "Hohhot\,\ Inner\ Mongolia",
  861319142 => "Hohhot\,\ Inner\ Mongolia",
  861319143 => "Hohhot\,\ Inner\ Mongolia",
  861319144 => "Baotou\,\ Inner\ Mongolia",
  861319145 => "Baotou\,\ Inner\ Mongolia",
  861319146 => "Baotou\,\ Inner\ Mongolia",
  861319147 => "Baotou\,\ Inner\ Mongolia",
  861319148 => "Baotou\,\ Inner\ Mongolia",
  861319149 => "Baotou\,\ Inner\ Mongolia",
  861319150 => "Chifeng\,\ Inner\ Mongolia",
  861319151 => "Chifeng\,\ Inner\ Mongolia",
  861319152 => "Chifeng\,\ Inner\ Mongolia",
  861319153 => "Tongliao\,\ Inner\ Mongolia",
  861319154 => "Tongliao\,\ Inner\ Mongolia",
  861319155 => "Xilin\,\ Inner\ Mongolia",
  861319156 => "Xilin\,\ Inner\ Mongolia",
  861319157 => "Ulanqab\,\ Inner\ Mongolia",
  861319158 => "Ulanqab\,\ Inner\ Mongolia",
  861319159 => "Hinggan\,\ Inner\ Mongolia",
  861319160 => "Xingtai\,\ Hebei",
  861319161 => "Xingtai\,\ Hebei",
  861319162 => "Xingtai\,\ Hebei",
  861319163 => "Chengde\,\ Hebei",
  861319164 => "Baoding\,\ Hebei",
  861319165 => "Baoding\,\ Hebei",
  861319166 => "Baoding\,\ Hebei",
  861319167 => "Baoding\,\ Hebei",
  861319168 => "Baoding\,\ Hebei",
  861319169 => "Hengshui\,\ Hebei",
  861319170 => "Handan\,\ Hebei",
  861319171 => "Handan\,\ Hebei",
  861319172 => "Handan\,\ Hebei",
  861319173 => "Handan\,\ Hebei",
  861319174 => "Tangshan\,\ Hebei",
  861319175 => "Tangshan\,\ Hebei",
  861319176 => "Tangshan\,\ Hebei",
  861319177 => "Tangshan\,\ Hebei",
  861319178 => "Tangshan\,\ Hebei",
  861319179 => "Zhangjiakou\,\ Hebei",
  861319180 => "Qinhuangdao\,\ Hebei",
  861319181 => "Qinhuangdao\,\ Hebei",
  861319182 => "Qinhuangdao\,\ Hebei",
  861319183 => "Qinhuangdao\,\ Hebei",
  861319184 => "Shijiazhuang\,\ Hebei",
  861319185 => "Shijiazhuang\,\ Hebei",
  861319186 => "Shijiazhuang\,\ Hebei",
  861319187 => "Shijiazhuang\,\ Hebei",
  861319188 => "Shijiazhuang\,\ Hebei",
  861319189 => "Chengde\,\ Hebei",
  861319190 => "Hengshui\,\ Hebei",
  861319191 => "Zhangjiakou\,\ Hebei",
  861319192 => "Cangzhou\,\ Hebei",
  861319193 => "Cangzhou\,\ Hebei",
  861319194 => "Cangzhou\,\ Hebei",
  861319195 => "Langfang\,\ Hebei",
  861319196 => "Langfang\,\ Hebei",
  861319197 => "Langfang\,\ Hebei",
  861319198 => "Langfang\,\ Hebei",
  861319199 => "Cangzhou\,\ Hebei",
  86131920 => "Dongguan\,\ Guangdong",
  861319210 => "Chaozhou\,\ Guangdong",
  861319211 => "Chaozhou\,\ Guangdong",
  861319212 => "Chaozhou\,\ Guangdong",
  861319213 => "Chaozhou\,\ Guangdong",
  861319214 => "Chaozhou\,\ Guangdong",
  861319215 => "Shantou\,\ Guangdong",
  861319216 => "Shantou\,\ Guangdong",
  861319217 => "Shantou\,\ Guangdong",
  861319218 => "Shantou\,\ Guangdong",
  861319219 => "Shantou\,\ Guangdong",
  86131922 => "Zhuhai\,\ Guangdong",
  86131923 => "Shantou\,\ Guangdong",
  861319240 => "Shaoguan\,\ Guangdong",
  861319241 => "Shaoguan\,\ Guangdong",
  861319242 => "Shaoguan\,\ Guangdong",
  861319243 => "Shaoguan\,\ Guangdong",
  861319244 => "Shaoguan\,\ Guangdong",
  861319245 => "Huizhou\,\ Guangdong",
  861319246 => "Huizhou\,\ Guangdong",
  861319247 => "Huizhou\,\ Guangdong",
  861319248 => "Huizhou\,\ Guangdong",
  861319249 => "Huizhou\,\ Guangdong",
  861319250 => "Shanwei\,\ Guangdong",
  861319251 => "Shanwei\,\ Guangdong",
  861319252 => "Shanwei\,\ Guangdong",
  861319253 => "Shanwei\,\ Guangdong",
  861319254 => "Shanwei\,\ Guangdong",
  861319255 => "Yangjiang\,\ Guangdong",
  861319256 => "Yangjiang\,\ Guangdong",
  861319257 => "Yangjiang\,\ Guangdong",
  861319258 => "Yangjiang\,\ Guangdong",
  861319259 => "Yangjiang\,\ Guangdong",
  861319260 => "Yunfu\,\ Guangdong",
  861319261 => "Yunfu\,\ Guangdong",
  861319262 => "Yunfu\,\ Guangdong",
  861319263 => "Yunfu\,\ Guangdong",
  861319264 => "Yunfu\,\ Guangdong",
  861319265 => "Foshan\,\ Guangdong",
  861319266 => "Foshan\,\ Guangdong",
  861319267 => "Foshan\,\ Guangdong",
  861319268 => "Foshan\,\ Guangdong",
  861319269 => "Foshan\,\ Guangdong",
  861319270 => "Heyuan\,\ Guangdong",
  861319271 => "Heyuan\,\ Guangdong",
  861319272 => "Heyuan\,\ Guangdong",
  861319273 => "Heyuan\,\ Guangdong",
  861319274 => "Heyuan\,\ Guangdong",
  861319275 => "Qingyuan\,\ Guangdong",
  861319276 => "Qingyuan\,\ Guangdong",
  861319277 => "Qingyuan\,\ Guangdong",
  861319278 => "Qingyuan\,\ Guangdong",
  861319279 => "Qingyuan\,\ Guangdong",
  861319280 => "Huizhou\,\ Guangdong",
  861319281 => "Huizhou\,\ Guangdong",
  861319282 => "Huizhou\,\ Guangdong",
  861319283 => "Huizhou\,\ Guangdong",
  861319284 => "Huizhou\,\ Guangdong",
  861319285 => "Shaoguan\,\ Guangdong",
  861319286 => "Shaoguan\,\ Guangdong",
  861319287 => "Shaoguan\,\ Guangdong",
  861319288 => "Shaoguan\,\ Guangdong",
  861319289 => "Shaoguan\,\ Guangdong",
  86131929 => "Jieyang\,\ Guangdong",
  86131930 => "Chongqing",
  86131931 => "Chongqing",
  86131932 => "Chongqing",
  86131933 => "XiAn\,\ Shaanxi",
  861319340 => "Shangqiu\,\ Henan",
  861319341 => "Shangqiu\,\ Henan",
  861319342 => "Shangqiu\,\ Henan",
  861319343 => "Xuchang\,\ Henan",
  861319344 => "Xuchang\,\ Henan",
  861319345 => "Xuchang\,\ Henan",
  861319346 => "Xuchang\,\ Henan",
  861319347 => "Hebi\,\ Henan",
  861319348 => "Hebi\,\ Henan",
  861319349 => "Hebi\,\ Henan",
  861319350 => "Anyang\,\ Henan",
  861319351 => "Anyang\,\ Henan",
  861319352 => "Anyang\,\ Henan",
  861319353 => "Anyang\,\ Henan",
  861319354 => "Anyang\,\ Henan",
  861319355 => "Puyang\,\ Henan",
  861319356 => "Puyang\,\ Henan",
  861319357 => "Puyang\,\ Henan",
  861319358 => "Puyang\,\ Henan",
  861319359 => "Puyang\,\ Henan",
  861319360 => "Zhoukou\,\ Henan",
  861319361 => "Zhoukou\,\ Henan",
  861319362 => "Zhoukou\,\ Henan",
  861319363 => "Zhoukou\,\ Henan",
  861319364 => "Zhoukou\,\ Henan",
  861319365 => "Nanyang\,\ Henan",
  861319366 => "Nanyang\,\ Henan",
  861319367 => "Nanyang\,\ Henan",
  861319368 => "Nanyang\,\ Henan",
  861319369 => "Nanyang\,\ Henan",
  861319370 => "Zhumadian\,\ Henan",
  861319371 => "Zhumadian\,\ Henan",
  861319372 => "Zhumadian\,\ Henan",
  861319373 => "Zhumadian\,\ Henan",
  861319374 => "Zhumadian\,\ Henan",
  861319375 => "Kaifeng\,\ Henan",
  861319376 => "Kaifeng\,\ Henan",
  861319377 => "Kaifeng\,\ Henan",
  861319378 => "Kaifeng\,\ Henan",
  861319379 => "Kaifeng\,\ Henan",
  861319380 => "Nanyang\,\ Henan",
  861319381 => "Nanyang\,\ Henan",
  861319382 => "Nanyang\,\ Henan",
  861319383 => "Nanyang\,\ Henan",
  861319384 => "Nanyang\,\ Henan",
  861319385 => "Xinyang\,\ Henan",
  861319386 => "Xinyang\,\ Henan",
  861319387 => "Xinyang\,\ Henan",
  861319388 => "Xinyang\,\ Henan",
  861319389 => "Xinyang\,\ Henan",
  861319390 => "Luohe\,\ Henan",
  861319391 => "Luohe\,\ Henan",
  861319392 => "Luohe\,\ Henan",
  861319393 => "Luohe\,\ Henan",
  861319394 => "Sanmenxia\,\ Henan",
  861319395 => "Sanmenxia\,\ Henan",
  861319396 => "Sanmenxia\,\ Henan",
  861319397 => "Sanmenxia\,\ Henan",
  861319398 => "Sanmenxia\,\ Henan",
  861319399 => "Sanmenxia\,\ Henan",
  861319400 => "Sanming\,\ Fujian",
  861319401 => "Nanping\,\ Fujian",
  861319402 => "Nanping\,\ Fujian",
  861319403 => "Ningde\,\ Fujian",
  861319404 => "Pingdingshan\,\ Henan",
  861319405 => "Nanping\,\ Fujian",
  861319406 => "Quanzhou\,\ Fujian",
  861319407 => "Xiamen\,\ Fujian",
  861319408 => "Xiamen\,\ Fujian",
  861319409 => "Xiamen\,\ Fujian",
  861319410 => "Tieling\,\ Liaoning",
  861319411 => "Dalian\,\ Liaoning",
  861319412 => "Anshan\,\ Liaoning",
  861319413 => "Fushun\,\ Liaoning",
  861319414 => "Benxi\,\ Liaoning",
  861319415 => "Dandong\,\ Liaoning",
  861319416 => "Jinzhou\,\ Liaoning",
  861319417 => "Yingkou\,\ Liaoning",
  861319418 => "Fuxin\,\ Liaoning",
  861319419 => "Liaoyang\,\ Liaoning",
  861319420 => "Shenyang\,\ Liaoning",
  861319421 => "Chaoyang\,\ Liaoning",
  861319422 => "Shenyang\,\ Liaoning",
  861319423 => "Shenyang\,\ Liaoning",
  861319424 => "Shenyang\,\ Liaoning",
  861319425 => "Anshan\,\ Liaoning",
  861319426 => "Dalian\,\ Liaoning",
  861319427 => "Panjin\,\ Liaoning",
  861319428 => "Dalian\,\ Liaoning",
  861319429 => "Huludao\,\ Liaoning",
  861319430 => "Changchun\,\ Jilin",
  861319431 => "Changchun\,\ Jilin",
  861319432 => "Jilin\,\ Jilin",
  861319433 => "Yanbian\,\ Jilin",
  861319434 => "Siping\,\ Jilin",
  861319435 => "Changchun\,\ Jilin",
  861319436 => "Changchun\,\ Jilin",
  861319437 => "Changchun\,\ Jilin",
  861319438 => "Changchun\,\ Jilin",
  861319439 => "Changchun\,\ Jilin",
  861319440 => "Putian\,\ Fujian",
  861319441 => "Putian\,\ Fujian",
  861319442 => "Putian\,\ Fujian",
  861319443 => "Putian\,\ Fujian",
  861319444 => "Putian\,\ Fujian",
  861319445 => "Fuzhou\,\ Fujian",
  861319446 => "Fuzhou\,\ Fujian",
  861319447 => "Fuzhou\,\ Fujian",
  861319448 => "Longyan\,\ Fujian",
  861319449 => "Longyan\,\ Fujian",
  861319450 => "Harbin\,\ Heilongjiang",
  861319451 => "Harbin\,\ Heilongjiang",
  861319452 => "Qiqihar\,\ Heilongjiang",
  861319453 => "Mudanjiang\,\ Heilongjiang",
  861319454 => "Jiamusi\,\ Heilongjiang",
  861319455 => "Suihua\,\ Heilongjiang",
  861319456 => "Heihe\,\ Heilongjiang",
  861319457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861319458 => "Yichun\,\ Heilongjiang",
  861319459 => "Daqing\,\ Heilongjiang",
  86131946 => "Tianjin",
  861319470 => "YaAn\,\ Sichuan",
  861319471 => "YaAn\,\ Sichuan",
  861319472 => "Guangyuan\,\ Sichuan",
  861319473 => "Guangyuan\,\ Sichuan",
  861319474 => "Bazhong\,\ Sichuan",
  861319475 => "Zigong\,\ Sichuan",
  861319476 => "Meishan\,\ Sichuan",
  861319477 => "Leshan\,\ Sichuan",
  861319478 => "Ziyang\,\ Sichuan",
  861319479 => "Ziyang\,\ Sichuan",
  861319480 => "Suining\,\ Sichuan",
  861319481 => "GuangAn\,\ Sichuan",
  861319482 => "Mianyang\,\ Sichuan",
  861319483 => "Mianyang\,\ Sichuan",
  861319484 => "Deyang\,\ Sichuan",
  861319485 => "Deyang\,\ Sichuan",
  861319486 => "Chengdu\,\ Sichuan",
  861319487 => "Chengdu\,\ Sichuan",
  861319488 => "Chengdu\,\ Sichuan",
  861319489 => "Chengdu\,\ Sichuan",
  861319490 => "Neijiang\,\ Sichuan",
  861319491 => "Zigong\,\ Sichuan",
  861319492 => "Luzhou\,\ Sichuan",
  861319493 => "Yibin\,\ Sichuan",
  861319494 => "Panzhihua\,\ Sichuan",
  861319495 => "Liangshan\,\ Sichuan",
  861319496 => "Chengdu\,\ Sichuan",
  861319497 => "Chengdu\,\ Sichuan",
  861319498 => "Chengdu\,\ Sichuan",
  861319499 => "Chengdu\,\ Sichuan",
  861319500 => "Yinchuan\,\ Ningxia",
  861319501 => "Yinchuan\,\ Ningxia",
  861319502 => "Shizuishan\,\ Ningxia",
  861319503 => "Wuzhong\,\ Ningxia",
  861319504 => "Guyuan\,\ Ningxia",
  861319505 => "Wuzhong\,\ Ningxia",
  861319506 => "Shizuishan\,\ Ningxia",
  861319507 => "Wuzhong\,\ Ningxia",
  861319508 => "Yinchuan\,\ Ningxia",
  861319509 => "Yinchuan\,\ Ningxia",
  861319510 => "Guiyang\,\ Guizhou",
  861319511 => "Guiyang\,\ Guizhou",
  861319512 => "Zunyi\,\ Guizhou",
  861319513 => "Anshun\,\ Guizhou",
  861319514 => "Qiannan\,\ Guizhou",
  861319515 => "Qiandongnan\,\ Guizhou",
  861319516 => "Tongren\,\ Guizhou",
  861319517 => "Bijie\,\ Guizhou",
  861319518 => "Liupanshui\,\ Guizhou",
  861319519 => "Qianxinan\,\ Guizhou",
  861319520 => "Guiyang\,\ Guizhou",
  861319521 => "Guiyang\,\ Guizhou",
  861319522 => "Zunyi\,\ Guizhou",
  861319523 => "Anshun\,\ Guizhou",
  861319524 => "Qiannan\,\ Guizhou",
  861319525 => "Qiandongnan\,\ Guizhou",
  861319526 => "Tongren\,\ Guizhou",
  861319527 => "Bijie\,\ Guizhou",
  861319528 => "Liupanshui\,\ Guizhou",
  861319529 => "Qianxinan\,\ Guizhou",
  861319530 => "Chizhou\,\ Anhui",
  861319531 => "Wuhu\,\ Anhui",
  861319532 => "Wuhu\,\ Anhui",
  861319533 => "Wuhu\,\ Anhui",
  861319534 => "Xuancheng\,\ Anhui",
  861319535 => "Xuancheng\,\ Anhui",
  861319536 => "Xuancheng\,\ Anhui",
  861319537 => "LuAn\,\ Anhui",
  861319538 => "LuAn\,\ Anhui",
  861319539 => "LuAn\,\ Anhui",
  861319540 => "Bozhou\,\ Anhui",
  861319541 => "Bozhou\,\ Anhui",
  861319542 => "Bengbu\,\ Anhui",
  861319543 => "Bengbu\,\ Anhui",
  861319544 => "Wuhu\,\ Anhui",
  861319545 => "Hefei\,\ Anhui",
  861319546 => "MaAnshan\,\ Anhui",
  861319547 => "Huainan\,\ Anhui",
  861319548 => "Fuyang\,\ Anhui",
  861319549 => "Chizhou\,\ Anhui",
  861319550 => "Chuzhou\,\ Anhui",
  861319551 => "Hefei\,\ Anhui",
  861319552 => "Bengbu\,\ Anhui",
  861319553 => "Wuhu\,\ Anhui",
  861319554 => "Huainan\,\ Anhui",
  861319555 => "MaAnshan\,\ Anhui",
  861319556 => "Anqing\,\ Anhui",
  861319557 => "Suzhou\,\ Anhui",
  861319558 => "Fuyang\,\ Anhui",
  861319559 => "Huangshan\,\ Anhui",
  861319560 => "Huaibei\,\ Anhui",
  861319561 => "Huaibei\,\ Anhui",
  861319562 => "Tongling\,\ Anhui",
  861319563 => "Xuancheng\,\ Anhui",
  861319564 => "LuAn\,\ Anhui",
  861319565 => "Hefei\,\ Anhui",
  861319566 => "Chizhou\,\ Anhui",
  861319567 => "Bozhou\,\ Anhui",
  861319568 => "Bozhou\,\ Anhui",
  861319569 => "Huaibei\,\ Anhui",
  861319570 => "Haixi\,\ Qinghai",
  861319571 => "Haixi\,\ Qinghai",
  861319572 => "Haixi\,\ Qinghai",
  861319573 => "Haidong\,\ Qinghai",
  861319574 => "Haidong\,\ Qinghai",
  861319575 => "Xining\,\ Qinghai",
  861319576 => "Xining\,\ Qinghai",
  861319577 => "Xining\,\ Qinghai",
  861319578 => "Xining\,\ Qinghai",
  861319579 => "Xining\,\ Qinghai",
  861319580 => "Longnan\,\ Gansu",
  861319581 => "Tianshui\,\ Gansu",
  861319582 => "Dingxi\,\ Gansu",
  861319583 => "Lanzhou\,\ Gansu",
  861319584 => "Qingyang\,\ Gansu",
  861319585 => "Linxia\,\ Gansu",
  861319586 => "Baiyin\,\ Gansu",
  861319587 => "Pingliang\,\ Gansu",
  861319588 => "Qingyang\,\ Gansu",
  861319589 => "Pingliang\,\ Gansu",
  861319590 => "Jiayuguan\,\ Gansu",
  861319591 => "Jiayuguan\,\ Gansu",
  861319592 => "Wuwei\,\ Gansu",
  861319593 => "Wuwei\,\ Gansu",
  861319594 => "Jiuquan\,\ Gansu",
  861319595 => "Jinchang\,\ Gansu",
  861319596 => "Zhangye\,\ Gansu",
  861319597 => "Jiuquan\,\ Gansu",
  861319598 => "Jiuquan\,\ Gansu",
  861319599 => "Jinchang\,\ Gansu",
  861319600 => "Changchun\,\ Jilin",
  861319601 => "Changchun\,\ Jilin",
  861319602 => "Changchun\,\ Jilin",
  861319603 => "Changchun\,\ Jilin",
  861319604 => "Changchun\,\ Jilin",
  861319605 => "Liaoyuan\,\ Jilin",
  861319606 => "Jilin\,\ Jilin",
  861319607 => "Jilin\,\ Jilin",
  861319608 => "Jilin\,\ Jilin",
  861319609 => "Jilin\,\ Jilin",
  861319610 => "Baicheng\,\ Jilin",
  861319611 => "Songyuan\,\ Jilin",
  861319612 => "Songyuan\,\ Jilin",
  861319613 => "Songyuan\,\ Jilin",
  861319614 => "Tonghua\,\ Jilin",
  861319615 => "Tonghua\,\ Jilin",
  861319616 => "Tonghua\,\ Jilin",
  861319617 => "Tonghua\,\ Jilin",
  861319618 => "Tonghua\,\ Jilin",
  861319619 => "Baishan\,\ Jilin",
  861319620 => "Yanbian\,\ Jilin",
  861319621 => "Jilin\,\ Jilin",
  861319622 => "Jilin\,\ Jilin",
  861319623 => "Jilin\,\ Jilin",
  861319624 => "Jilin\,\ Jilin",
  861319625 => "Liaoyuan\,\ Jilin",
  861319626 => "Liaoyuan\,\ Jilin",
  861319627 => "Siping\,\ Jilin",
  861319628 => "Siping\,\ Jilin",
  861319629 => "Siping\,\ Jilin",
  861319630 => "Xianyang\,\ Shaanxi",
  861319631 => "Xianyang\,\ Shaanxi",
  861319632 => "Weinan\,\ Shaanxi",
  861319633 => "Weinan\,\ Shaanxi",
  861319634 => "Baoji\,\ Shaanxi",
  861319635 => "Baoji\,\ Shaanxi",
  861319636 => "Baoji\,\ Shaanxi",
  861319637 => "Hanzhong\,\ Shaanxi",
  861319638 => "Hanzhong\,\ Shaanxi",
  861319639 => "Hanzhong\,\ Shaanxi",
  861319640 => "Wuxi\,\ Jiangsu",
  861319641 => "Wuxi\,\ Jiangsu",
  861319642 => "Wuxi\,\ Jiangsu",
  861319643 => "Changzhou\,\ Jiangsu",
  861319644 => "Changzhou\,\ Jiangsu",
  861319645 => "Yangzhou\,\ Jiangsu",
  861319646 => "Yangzhou\,\ Jiangsu",
  861319647 => "Yangzhou\,\ Jiangsu",
  861319648 => "Yangzhou\,\ Jiangsu",
  861319649 => "Yangzhou\,\ Jiangsu",
  86131965 => "Wuxi\,\ Jiangsu",
  861319660 => "Suzhou\,\ Jiangsu",
  861319661 => "Suzhou\,\ Jiangsu",
  861319662 => "Suzhou\,\ Jiangsu",
  861319663 => "Yancheng\,\ Jiangsu",
  861319664 => "Yancheng\,\ Jiangsu",
  861319665 => "Yancheng\,\ Jiangsu",
  861319666 => "Yancheng\,\ Jiangsu",
  861319667 => "Yancheng\,\ Jiangsu",
  861319668 => "Yangzhou\,\ Jiangsu",
  861319669 => "Yangzhou\,\ Jiangsu",
  86131967 => "Changzhou\,\ Jiangsu",
  861319680 => "Xuzhou\,\ Jiangsu",
  861319681 => "Xuzhou\,\ Jiangsu",
  861319682 => "Xuzhou\,\ Jiangsu",
  861319683 => "Lianyungang\,\ Jiangsu",
  861319684 => "Lianyungang\,\ Jiangsu",
  861319685 => "Zhenjiang\,\ Jiangsu",
  861319686 => "Zhenjiang\,\ Jiangsu",
  861319687 => "Suqian\,\ Jiangsu",
  861319688 => "Suqian\,\ Jiangsu",
  861319689 => "Suqian\,\ Jiangsu",
  861319690 => "Taizhou\,\ Jiangsu",
  861319691 => "Taizhou\,\ Jiangsu",
  861319692 => "Taizhou\,\ Jiangsu",
  861319693 => "Taizhou\,\ Jiangsu",
  861319694 => "Taizhou\,\ Jiangsu",
  861319695 => "Taizhou\,\ Jiangsu",
  861319696 => "HuaiAn\,\ Jiangsu",
  861319697 => "HuaiAn\,\ Jiangsu",
  861319698 => "HuaiAn\,\ Jiangsu",
  861319699 => "HuaiAn\,\ Jiangsu",
  861319700 => "Huangshi\,\ Hubei",
  861319701 => "Huangshi\,\ Hubei",
  861319702 => "Huangshi\,\ Hubei",
  861319703 => "Huangshi\,\ Hubei",
  861319704 => "Huangshi\,\ Hubei",
  861319705 => "Huanggang\,\ Hubei",
  861319706 => "Huanggang\,\ Hubei",
  861319707 => "Huanggang\,\ Hubei",
  861319708 => "Huanggang\,\ Hubei",
  861319709 => "Huanggang\,\ Hubei",
  861319710 => "Jingmen\,\ Hubei",
  861319711 => "Jingmen\,\ Hubei",
  861319712 => "Jingmen\,\ Hubei",
  861319713 => "Jingmen\,\ Hubei",
  861319714 => "Xiangfan\,\ Hubei",
  861319715 => "Xiangfan\,\ Hubei",
  861319716 => "Xiangfan\,\ Hubei",
  861319717 => "Xiangfan\,\ Hubei",
  861319718 => "Xiangfan\,\ Hubei",
  861319719 => "Xiangfan\,\ Hubei",
  861319720 => "Enshi\,\ Hubei",
  861319721 => "Enshi\,\ Hubei",
  861319722 => "Enshi\,\ Hubei",
  861319723 => "Enshi\,\ Hubei",
  861319724 => "Shiyan\,\ Hubei",
  861319725 => "Shiyan\,\ Hubei",
  861319726 => "Shiyan\,\ Hubei",
  861319727 => "Shiyan\,\ Hubei",
  861319728 => "Shiyan\,\ Hubei",
  861319729 => "Shiyan\,\ Hubei",
  861319730 => "Yichang\,\ Hubei",
  861319731 => "Yichang\,\ Hubei",
  861319732 => "Yichang\,\ Hubei",
  861319733 => "Yichang\,\ Hubei",
  861319734 => "Yichang\,\ Hubei",
  861319735 => "Xiaogan\,\ Hubei",
  861319736 => "Xiaogan\,\ Hubei",
  861319737 => "Xiaogan\,\ Hubei",
  861319738 => "Xiaogan\,\ Hubei",
  861319739 => "Xiaogan\,\ Hubei",
  861319740 => "Xianning\,\ Hubei",
  861319741 => "Xianning\,\ Hubei",
  861319742 => "Xianning\,\ Hubei",
  861319743 => "Ezhou\,\ Hubei",
  861319744 => "Ezhou\,\ Hubei",
  861319745 => "Wuhan\,\ Hubei",
  861319746 => "Suizhou\,\ Hubei",
  861319747 => "Jingzhou\,\ Hubei",
  861319748 => "Jingzhou\,\ Hubei",
  861319749 => "Jingzhou\,\ Hubei",
  861319750 => "Nanning\,\ Guangxi",
  861319751 => "Nanning\,\ Guangxi",
  861319752 => "Liuzhou\,\ Guangxi",
  861319753 => "Hezhou\,\ Guangxi",
  861319754 => "Hezhou\,\ Guangxi",
  861319755 => "Guigang\,\ Guangxi",
  861319756 => "Baise\,\ Guangxi",
  861319757 => "Nanning\,\ Guangxi",
  861319758 => "Wuzhou\,\ Guangxi",
  861319759 => "Beihai\,\ Guangxi",
  861319760 => "Fangchenggang\,\ Guangxi",
  861319761 => "Nanning\,\ Guangxi",
  861319762 => "Liuzhou\,\ Guangxi",
  861319763 => "Guilin\,\ Guangxi",
  861319764 => "Guilin\,\ Guangxi",
  861319765 => "Yulin\,\ Guangxi",
  861319766 => "Guigang\,\ Guangxi",
  861319767 => "Qinzhou\,\ Guangxi",
  861319768 => "Hechi\,\ Guangxi",
  861319769 => "Beihai\,\ Guangxi",
  861319770 => "Fangchenggang\,\ Guangxi",
  861319771 => "Nanning\,\ Guangxi",
  861319772 => "Liuzhou\,\ Guangxi",
  861319773 => "Guilin\,\ Guangxi",
  861319774 => "Wuzhou\,\ Guangxi",
  861319775 => "Yulin\,\ Guangxi",
  861319776 => "Baise\,\ Guangxi",
  861319777 => "Qinzhou\,\ Guangxi",
  861319778 => "Hechi\,\ Guangxi",
  861319779 => "Beihai\,\ Guangxi",
  861319780 => "Yingtan\,\ Jiangxi",
  861319781 => "Yingtan\,\ Jiangxi",
  861319782 => "Fuzhou\,\ Jiangxi",
  861319783 => "Jiujiang\,\ Jiangxi",
  861319784 => "Xinyu\,\ Jiangxi",
  861319785 => "Yichun\,\ Jiangxi",
  861319786 => "Yichun\,\ Jiangxi",
  861319787 => "Yichun\,\ Jiangxi",
  861319788 => "Fuzhou\,\ Jiangxi",
  861319789 => "JiAn\,\ Jiangxi",
  861319790 => "Xinyu\,\ Jiangxi",
  861319791 => "Nanchang\,\ Jiangxi",
  861319792 => "Jiujiang\,\ Jiangxi",
  861319793 => "Shangrao\,\ Jiangxi",
  861319794 => "Fuzhou\,\ Jiangxi",
  861319795 => "Yichun\,\ Jiangxi",
  861319796 => "JiAn\,\ Jiangxi",
  861319797 => "Ganzhou\,\ Jiangxi",
  861319798 => "Jingdezhen\,\ Jiangxi",
  861319799 => "Pingxiang\,\ Jiangxi",
  861319800 => "Neijiang\,\ Sichuan",
  861319801 => "Neijiang\,\ Sichuan",
  861319802 => "Neijiang\,\ Sichuan",
  861319803 => "Ziyang\,\ Sichuan",
  861319804 => "Ziyang\,\ Sichuan",
  861319805 => "Leshan\,\ Sichuan",
  861319806 => "Leshan\,\ Sichuan",
  861319807 => "Mianyang\,\ Sichuan",
  861319808 => "Mianyang\,\ Sichuan",
  861319809 => "Mianyang\,\ Sichuan",
  861319810 => "GuangAn\,\ Sichuan",
  861319811 => "GuangAn\,\ Sichuan",
  861319812 => "Bazhong\,\ Sichuan",
  861319813 => "Bazhong\,\ Sichuan",
  861319814 => "Bazhong\,\ Sichuan",
  861319815 => "Deyang\,\ Sichuan",
  861319816 => "Suining\,\ Sichuan",
  861319817 => "Nanchong\,\ Sichuan",
  861319818 => "Nanchong\,\ Sichuan",
  861319819 => "Nanchong\,\ Sichuan",
  861319820 => "Zigong\,\ Sichuan",
  861319821 => "Zigong\,\ Sichuan",
  861319822 => "Guangyuan\,\ Sichuan",
  861319823 => "Guangyuan\,\ Sichuan",
  861319824 => "Guangyuan\,\ Sichuan",
  861319825 => "Luzhou\,\ Sichuan",
  861319826 => "Luzhou\,\ Sichuan",
  861319827 => "Deyang\,\ Sichuan",
  861319828 => "Deyang\,\ Sichuan",
  861319829 => "Deyang\,\ Sichuan",
  861319830 => "Dazhou\,\ Sichuan",
  861319831 => "Dazhou\,\ Sichuan",
  861319832 => "Yibin\,\ Sichuan",
  861319833 => "Yibin\,\ Sichuan",
  861319834 => "Meishan\,\ Sichuan",
  861319835 => "Meishan\,\ Sichuan",
  861319836 => "Meishan\,\ Sichuan",
  861319837 => "Liangshan\,\ Sichuan",
  861319838 => "Panzhihua\,\ Sichuan",
  861319839 => "Panzhihua\,\ Sichuan",
  861319840 => "Zigong\,\ Sichuan",
  861319841 => "Suining\,\ Sichuan",
  861319842 => "Luzhou\,\ Sichuan",
  861319843 => "Nanchong\,\ Sichuan",
  861319844 => "Dazhou\,\ Sichuan",
  861319845 => "Neijiang\,\ Sichuan",
  861319846 => "Yibin\,\ Sichuan",
  861319847 => "Leshan\,\ Sichuan",
  861319848 => "Panzhihua\,\ Sichuan",
  861319849 => "Liangshan\,\ Sichuan",
  86131985 => "Chengdu\,\ Sichuan",
  861319860 => "Panzhihua\,\ Sichuan",
  861319861 => "Panzhihua\,\ Sichuan",
  861319862 => "Meishan\,\ Sichuan",
  861319863 => "Liangshan\,\ Sichuan",
  861319864 => "Nanchong\,\ Sichuan",
  861319865 => "Suining\,\ Sichuan",
  861319866 => "Mianyang\,\ Sichuan",
  861319867 => "Mianyang\,\ Sichuan",
  861319868 => "Mianyang\,\ Sichuan",
  861319869 => "Bazhong\,\ Sichuan",
  861319870 => "Meishan\,\ Sichuan",
  861319871 => "Leshan\,\ Sichuan",
  861319872 => "Leshan\,\ Sichuan",
  861319873 => "Dazhou\,\ Sichuan",
  861319874 => "Dazhou\,\ Sichuan",
  861319875 => "Dazhou\,\ Sichuan",
  861319876 => "Zigong\,\ Sichuan",
  861319877 => "GuangAn\,\ Sichuan",
  861319878 => "Neijiang\,\ Sichuan",
  861319879 => "Neijiang\,\ Sichuan",
  861319880 => "Zigong\,\ Sichuan",
  861319881 => "Nanchong\,\ Sichuan",
  861319882 => "Nanchong\,\ Sichuan",
  861319883 => "Yibin\,\ Sichuan",
  861319884 => "Yibin\,\ Sichuan",
  861319885 => "Ziyang\,\ Sichuan",
  861319886 => "Luzhou\,\ Sichuan",
  861319887 => "Guangyuan\,\ Sichuan",
  861319888 => "Deyang\,\ Sichuan",
  861319889 => "Deyang\,\ Sichuan",
  86131989 => "Haikou\,\ Hainan",
  861319900 => "Suihua\,\ Heilongjiang",
  861319901 => "Suihua\,\ Heilongjiang",
  861319902 => "Suihua\,\ Heilongjiang",
  861319903 => "Suihua\,\ Heilongjiang",
  861319904 => "Daqing\,\ Heilongjiang",
  861319905 => "Daqing\,\ Heilongjiang",
  861319906 => "Daqing\,\ Heilongjiang",
  861319907 => "Daqing\,\ Heilongjiang",
  861319908 => "Daqing\,\ Heilongjiang",
  861319909 => "Daqing\,\ Heilongjiang",
  861319910 => "Jiamusi\,\ Heilongjiang",
  861319911 => "Jiamusi\,\ Heilongjiang",
  861319912 => "Jiamusi\,\ Heilongjiang",
  861319913 => "Jiamusi\,\ Heilongjiang",
  861319914 => "Jiamusi\,\ Heilongjiang",
  861319915 => "Jiamusi\,\ Heilongjiang",
  861319916 => "Jixi\,\ Heilongjiang",
  861319917 => "Jixi\,\ Heilongjiang",
  861319918 => "Jixi\,\ Heilongjiang",
  861319919 => "Shuangyashan\,\ Heilongjiang",
  861319920 => "Shuangyashan\,\ Heilongjiang",
  861319921 => "Shuangyashan\,\ Heilongjiang",
  861319922 => "Shuangyashan\,\ Heilongjiang",
  861319923 => "Qitaihe\,\ Heilongjiang",
  861319924 => "Qitaihe\,\ Heilongjiang",
  861319925 => "Yichun\,\ Heilongjiang",
  861319926 => "Yichun\,\ Heilongjiang",
  861319927 => "Yichun\,\ Heilongjiang",
  861319928 => "Heihe\,\ Heilongjiang",
  861319929 => "Heihe\,\ Heilongjiang",
  861319930 => "Heihe\,\ Heilongjiang",
  861319931 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861319932 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861319933 => "Mudanjiang\,\ Heilongjiang",
  861319934 => "Mudanjiang\,\ Heilongjiang",
  861319935 => "Mudanjiang\,\ Heilongjiang",
  861319936 => "Mudanjiang\,\ Heilongjiang",
  861319937 => "Mudanjiang\,\ Heilongjiang",
  861319938 => "Mudanjiang\,\ Heilongjiang",
  861319939 => "Mudanjiang\,\ Heilongjiang",
  861319940 => "Daqing\,\ Heilongjiang",
  861319941 => "Daqing\,\ Heilongjiang",
  861319942 => "Jixi\,\ Heilongjiang",
  861319943 => "Jixi\,\ Heilongjiang",
  861319944 => "Harbin\,\ Heilongjiang",
  861319945 => "Harbin\,\ Heilongjiang",
  861319946 => "Harbin\,\ Heilongjiang",
  861319947 => "Harbin\,\ Heilongjiang",
  861319948 => "Harbin\,\ Heilongjiang",
  861319949 => "Harbin\,\ Heilongjiang",
  861319950 => "Harbin\,\ Heilongjiang",
  861319951 => "Harbin\,\ Heilongjiang",
  861319952 => "Harbin\,\ Heilongjiang",
  861319953 => "Harbin\,\ Heilongjiang",
  861319954 => "Harbin\,\ Heilongjiang",
  861319955 => "Harbin\,\ Heilongjiang",
  861319956 => "Harbin\,\ Heilongjiang",
  861319957 => "Harbin\,\ Heilongjiang",
  861319958 => "Harbin\,\ Heilongjiang",
  861319959 => "Hegang\,\ Heilongjiang",
  861319960 => "Hegang\,\ Heilongjiang",
  861319961 => "Hegang\,\ Heilongjiang",
  861319962 => "Qiqihar\,\ Heilongjiang",
  861319963 => "Qiqihar\,\ Heilongjiang",
  861319964 => "Qiqihar\,\ Heilongjiang",
  861319965 => "Qiqihar\,\ Heilongjiang",
  861319966 => "Qiqihar\,\ Heilongjiang",
  861319967 => "Qiqihar\,\ Heilongjiang",
  861319968 => "Qiqihar\,\ Heilongjiang",
  861319969 => "Qiqihar\,\ Heilongjiang",
  861319970 => "Changji\,\ Xinjiang",
  861319971 => "Hami\,\ Xinjiang",
  861319972 => "Bayingolin\,\ Xinjiang",
  861319973 => "Kashi\,\ Xinjiang",
  861319974 => "Aksu\,\ Xinjiang",
  861319975 => "Kizilsu\,\ Xinjiang",
  861319976 => "Hotan\,\ Xinjiang",
  861319977 => "Bortala\,\ Xinjiang",
  861319978 => "Tacheng\,\ Xinjiang",
  861319979 => "Altay\,\ Xinjiang",
  86131998 => "Urumchi\,\ Xinjiang",
  861319990 => "Karamay\,\ Xinjiang",
  861319991 => "Urumchi\,\ Xinjiang",
  861319992 => "Ili\,\ Xinjiang",
  861319993 => "Shihezi\,\ Xinjiang",
  861319994 => "Changji\,\ Xinjiang",
  861319995 => "Turpan\,\ Xinjiang",
  861319996 => "Bayingolin\,\ Xinjiang",
  861319997 => "Aksu\,\ Xinjiang",
  861319998 => "Kashi\,\ Xinjiang",
  861319999 => "Ili\,\ Xinjiang",
  8613200 => "Shanghai",
  861320100 => "Changji\,\ Xinjiang",
  861320101 => "Changji\,\ Xinjiang",
  861320102 => "Changji\,\ Xinjiang",
  861320103 => "Changji\,\ Xinjiang",
  861320104 => "Turpan\,\ Xinjiang",
  861320105 => "Kashi\,\ Xinjiang",
  861320106 => "Hami\,\ Xinjiang",
  861320107 => "Hami\,\ Xinjiang",
  861320108 => "Karamay\,\ Xinjiang",
  861320109 => "Shihezi\,\ Xinjiang",
  861320110 => "Ili\,\ Xinjiang",
  861320111 => "Ili\,\ Xinjiang",
  861320112 => "Ili\,\ Xinjiang",
  861320113 => "Bayingolin\,\ Xinjiang",
  861320114 => "Bayingolin\,\ Xinjiang",
  861320115 => "Bayingolin\,\ Xinjiang",
  861320116 => "Aksu\,\ Xinjiang",
  861320117 => "Aksu\,\ Xinjiang",
  861320118 => "Kashi\,\ Xinjiang",
  861320119 => "Kashi\,\ Xinjiang",
  86132012 => "Urumchi\,\ Xinjiang",
  86132013 => "Urumchi\,\ Xinjiang",
  86132014 => "XiAn\,\ Shaanxi",
  86132015 => "XiAn\,\ Shaanxi",
  86132016 => "XiAn\,\ Shaanxi",
  86132017 => "XiAn\,\ Shaanxi",
  86132018 => "XiAn\,\ Shaanxi",
  861320190 => "Xianyang\,\ Shaanxi",
  861320191 => "Xianyang\,\ Shaanxi",
  861320192 => "Xianyang\,\ Shaanxi",
  861320193 => "Xianyang\,\ Shaanxi",
  861320194 => "Weinan\,\ Shaanxi",
  861320195 => "Weinan\,\ Shaanxi",
  861320196 => "Weinan\,\ Shaanxi",
  861320197 => "Weinan\,\ Shaanxi",
  861320198 => "Weinan\,\ Shaanxi",
  861320199 => "Weinan\,\ Shaanxi",
  86132020 => "Guangzhou\,\ Guangdong",
  86132021 => "Shantou\,\ Guangdong",
  861320220 => "Jieyang\,\ Guangdong",
  861320221 => "Jieyang\,\ Guangdong",
  861320222 => "Jieyang\,\ Guangdong",
  861320223 => "Jieyang\,\ Guangdong",
  861320224 => "Jieyang\,\ Guangdong",
  861320225 => "Shenzhen\,\ Guangdong",
  861320226 => "Shenzhen\,\ Guangdong",
  861320227 => "Shenzhen\,\ Guangdong",
  861320228 => "Shenzhen\,\ Guangdong",
  861320229 => "Shenzhen\,\ Guangdong",
  861320230 => "Huizhou\,\ Guangdong",
  861320231 => "Huizhou\,\ Guangdong",
  861320232 => "Huizhou\,\ Guangdong",
  861320233 => "Huizhou\,\ Guangdong",
  861320234 => "Huizhou\,\ Guangdong",
  861320235 => "Foshan\,\ Guangdong",
  861320236 => "Foshan\,\ Guangdong",
  861320237 => "Foshan\,\ Guangdong",
  861320238 => "Foshan\,\ Guangdong",
  861320239 => "Foshan\,\ Guangdong",
  86132024 => "Foshan\,\ Guangdong",
  861320250 => "Guangzhou\,\ Guangdong",
  861320251 => "Guangzhou\,\ Guangdong",
  861320252 => "Guangzhou\,\ Guangdong",
  861320253 => "Guangzhou\,\ Guangdong",
  861320254 => "Guangzhou\,\ Guangdong",
  861320255 => "Jieyang\,\ Guangdong",
  861320256 => "Jieyang\,\ Guangdong",
  861320257 => "Jieyang\,\ Guangdong",
  861320258 => "Jieyang\,\ Guangdong",
  861320259 => "Jieyang\,\ Guangdong",
  861320260 => "Zhaoqing\,\ Guangdong",
  861320261 => "Zhaoqing\,\ Guangdong",
  861320262 => "Zhaoqing\,\ Guangdong",
  861320263 => "Zhaoqing\,\ Guangdong",
  861320264 => "Zhaoqing\,\ Guangdong",
  861320265 => "Dongguan\,\ Guangdong",
  861320266 => "Dongguan\,\ Guangdong",
  861320267 => "Dongguan\,\ Guangdong",
  861320268 => "Dongguan\,\ Guangdong",
  861320269 => "Dongguan\,\ Guangdong",
  861320270 => "Dongguan\,\ Guangdong",
  861320271 => "Dongguan\,\ Guangdong",
  861320272 => "Dongguan\,\ Guangdong",
  861320273 => "Dongguan\,\ Guangdong",
  861320274 => "Dongguan\,\ Guangdong",
  861320275 => "Zhaoqing\,\ Guangdong",
  861320276 => "Zhaoqing\,\ Guangdong",
  861320277 => "Zhaoqing\,\ Guangdong",
  861320278 => "Zhaoqing\,\ Guangdong",
  861320279 => "Zhaoqing\,\ Guangdong",
  86132028 => "Foshan\,\ Guangdong",
  86132029 => "Foshan\,\ Guangdong",
  861320300 => "Yueyang\,\ Hunan",
  861320301 => "Yueyang\,\ Hunan",
  861320302 => "Yueyang\,\ Hunan",
  861320303 => "Yueyang\,\ Hunan",
  861320304 => "Hengyang\,\ Hunan",
  861320305 => "Hengyang\,\ Hunan",
  861320306 => "Hengyang\,\ Hunan",
  861320307 => "Hengyang\,\ Hunan",
  861320308 => "Hengyang\,\ Hunan",
  861320309 => "Hengyang\,\ Hunan",
  861320310 => "Changsha\,\ Hunan",
  861320311 => "Changsha\,\ Hunan",
  861320312 => "Changsha\,\ Hunan",
  861320313 => "Changsha\,\ Hunan",
  861320314 => "Changsha\,\ Hunan",
  861320315 => "Changsha\,\ Hunan",
  861320316 => "Changsha\,\ Hunan",
  861320317 => "Changsha\,\ Hunan",
  861320318 => "Loudi\,\ Hunan",
  861320319 => "Loudi\,\ Hunan",
  861320320 => "Xiangtan\,\ Hunan",
  861320321 => "Xiangtan\,\ Hunan",
  861320322 => "Xiangtan\,\ Hunan",
  861320323 => "Xiangtan\,\ Hunan",
  861320324 => "Shaoyang\,\ Hunan",
  861320325 => "Shaoyang\,\ Hunan",
  861320326 => "Shaoyang\,\ Hunan",
  861320327 => "Shaoyang\,\ Hunan",
  861320328 => "Shaoyang\,\ Hunan",
  861320329 => "Shaoyang\,\ Hunan",
  861320330 => "Zhuzhou\,\ Hunan",
  861320331 => "Zhuzhou\,\ Hunan",
  861320332 => "Zhuzhou\,\ Hunan",
  861320333 => "Zhuzhou\,\ Hunan",
  861320334 => "Zhuzhou\,\ Hunan",
  861320335 => "Zhuzhou\,\ Hunan",
  861320336 => "Zhuzhou\,\ Hunan",
  861320337 => "Chenzhou\,\ Hunan",
  861320338 => "Chenzhou\,\ Hunan",
  861320339 => "Chenzhou\,\ Hunan",
  861320340 => "Xinzhou\,\ Shanxi",
  861320341 => "Taiyuan\,\ Shanxi",
  861320342 => "Datong\,\ Shanxi",
  861320343 => "Yangquan\,\ Shanxi",
  861320344 => "Jinzhong\,\ Shanxi",
  861320345 => "Changzhi\,\ Shanxi",
  861320346 => "Jincheng\,\ Shanxi",
  861320347 => "Linfen\,\ Shanxi",
  861320348 => "Yuncheng\,\ Shanxi",
  861320349 => "Shuozhou\,\ Shanxi",
  861320350 => "Xinzhou\,\ Shanxi",
  861320351 => "Taiyuan\,\ Shanxi",
  861320352 => "Datong\,\ Shanxi",
  861320353 => "Yangquan\,\ Shanxi",
  861320354 => "Jinzhong\,\ Shanxi",
  861320355 => "Changzhi\,\ Shanxi",
  861320356 => "Jincheng\,\ Shanxi",
  861320357 => "Linfen\,\ Shanxi",
  861320358 => "Lüliang\,\ Shanxi",
  861320359 => "Yuncheng\,\ Shanxi",
  861320360 => "Changde\,\ Hunan",
  861320361 => "Changde\,\ Hunan",
  861320362 => "Changde\,\ Hunan",
  861320363 => "Changde\,\ Hunan",
  861320364 => "Changde\,\ Hunan",
  861320365 => "Yiyang\,\ Hunan",
  861320366 => "Yiyang\,\ Hunan",
  861320367 => "Yiyang\,\ Hunan",
  861320368 => "Yiyang\,\ Hunan",
  861320369 => "Yiyang\,\ Hunan",
  861320370 => "Zhengzhou\,\ Henan",
  861320371 => "Zhengzhou\,\ Henan",
  861320372 => "Zhengzhou\,\ Henan",
  861320373 => "Zhengzhou\,\ Henan",
  861320374 => "Zhengzhou\,\ Henan",
  861320375 => "Nanyang\,\ Henan",
  861320376 => "Nanyang\,\ Henan",
  861320377 => "Nanyang\,\ Henan",
  861320378 => "Nanyang\,\ Henan",
  861320379 => "Nanyang\,\ Henan",
  86132038 => "Zhengzhou\,\ Henan",
  86132039 => "Jiaozuo\,\ Henan",
  861320400 => "Shenyang\,\ Liaoning",
  861320401 => "Shenyang\,\ Liaoning",
  861320402 => "Shenyang\,\ Liaoning",
  861320403 => "Shenyang\,\ Liaoning",
  861320404 => "Shenyang\,\ Liaoning",
  861320405 => "Dalian\,\ Liaoning",
  861320406 => "Dalian\,\ Liaoning",
  861320407 => "Dalian\,\ Liaoning",
  861320408 => "Dalian\,\ Liaoning",
  861320409 => "Dalian\,\ Liaoning",
  861320410 => "Tieling\,\ Liaoning",
  861320411 => "Dalian\,\ Liaoning",
  861320412 => "Anshan\,\ Liaoning",
  861320413 => "Fushun\,\ Liaoning",
  861320414 => "Benxi\,\ Liaoning",
  861320415 => "Dandong\,\ Liaoning",
  861320416 => "Jinzhou\,\ Liaoning",
  861320417 => "Yingkou\,\ Liaoning",
  861320418 => "Fuxin\,\ Liaoning",
  861320419 => "Liaoyang\,\ Liaoning",
  861320420 => "Tieling\,\ Liaoning",
  861320421 => "Chaoyang\,\ Liaoning",
  861320422 => "Anshan\,\ Liaoning",
  861320423 => "Anshan\,\ Liaoning",
  861320424 => "Fushun\,\ Liaoning",
  861320425 => "Fushun\,\ Liaoning",
  861320426 => "Benxi\,\ Liaoning",
  861320427 => "Panjin\,\ Liaoning",
  861320428 => "Fuxin\,\ Liaoning",
  861320429 => "Huludao\,\ Liaoning",
  861320430 => "Changchun\,\ Jilin",
  861320431 => "Changchun\,\ Jilin",
  861320432 => "Jilin\,\ Jilin",
  861320433 => "Yanbian\,\ Jilin",
  861320434 => "Siping\,\ Jilin",
  861320435 => "Tonghua\,\ Jilin",
  861320436 => "Baicheng\,\ Jilin",
  861320437 => "Liaoyuan\,\ Jilin",
  861320438 => "Songyuan\,\ Jilin",
  861320439 => "Baishan\,\ Jilin",
  861320440 => "Baicheng\,\ Jilin",
  861320441 => "Baicheng\,\ Jilin",
  861320442 => "Baicheng\,\ Jilin",
  861320443 => "Baicheng\,\ Jilin",
  861320444 => "Baicheng\,\ Jilin",
  861320445 => "Baicheng\,\ Jilin",
  861320446 => "Baicheng\,\ Jilin",
  861320447 => "Baicheng\,\ Jilin",
  861320448 => "Baicheng\,\ Jilin",
  861320449 => "Baishan\,\ Jilin",
  861320450 => "Harbin\,\ Heilongjiang",
  861320451 => "Harbin\,\ Heilongjiang",
  861320452 => "Qiqihar\,\ Heilongjiang",
  861320453 => "Mudanjiang\,\ Heilongjiang",
  861320454 => "Jiamusi\,\ Heilongjiang",
  861320455 => "Suihua\,\ Heilongjiang",
  861320456 => "Heihe\,\ Heilongjiang",
  861320457 => "Harbin\,\ Heilongjiang",
  861320458 => "Yichun\,\ Heilongjiang",
  861320459 => "Daqing\,\ Heilongjiang",
  861320460 => "Harbin\,\ Heilongjiang",
  861320461 => "Harbin\,\ Heilongjiang",
  861320462 => "Harbin\,\ Heilongjiang",
  861320463 => "Harbin\,\ Heilongjiang",
  861320464 => "Qitaihe\,\ Heilongjiang",
  861320465 => "Harbin\,\ Heilongjiang",
  861320466 => "Harbin\,\ Heilongjiang",
  861320467 => "Jixi\,\ Heilongjiang",
  861320468 => "Hegang\,\ Heilongjiang",
  861320469 => "Shuangyashan\,\ Heilongjiang",
  861320470 => "Hulun\,\ Inner\ Mongolia",
  861320471 => "Hohhot\,\ Inner\ Mongolia",
  861320472 => "Baotou\,\ Inner\ Mongolia",
  861320473 => "Wuhai\,\ Inner\ Mongolia",
  861320474 => "Ulanqab\,\ Inner\ Mongolia",
  861320475 => "Tongliao\,\ Inner\ Mongolia",
  861320476 => "Chifeng\,\ Inner\ Mongolia",
  861320477 => "Ordos\,\ Inner\ Mongolia",
  861320478 => "Bayannur\,\ Inner\ Mongolia",
  861320479 => "Xilin\,\ Inner\ Mongolia",
  861320480 => "Hohhot\,\ Inner\ Mongolia",
  861320481 => "Tongliao\,\ Inner\ Mongolia",
  861320482 => "Hinggan\,\ Inner\ Mongolia",
  861320483 => "Alxa\,\ Inner\ Mongolia",
  861320484 => "Ordos\,\ Inner\ Mongolia",
  861320485 => "Ordos\,\ Inner\ Mongolia",
  861320486 => "Hulun\,\ Inner\ Mongolia",
  861320487 => "Ordos\,\ Inner\ Mongolia",
  861320488 => "Hinggan\,\ Inner\ Mongolia",
  861320489 => "Hinggan\,\ Inner\ Mongolia",
  861320490 => "Chenzhou\,\ Hunan",
  861320491 => "Chenzhou\,\ Hunan",
  861320492 => "Huaihua\,\ Hunan",
  861320493 => "Huaihua\,\ Hunan",
  861320494 => "Loudi\,\ Hunan",
  861320495 => "Yongzhou\,\ Hunan",
  861320496 => "Yongzhou\,\ Hunan",
  861320497 => "Yongzhou\,\ Hunan",
  861320498 => "Xiangxi\,\ Hunan",
  861320499 => "Huaihua\,\ Hunan",
  861320500 => "Fuzhou\,\ Fujian",
  861320501 => "Fuzhou\,\ Fujian",
  861320502 => "Fuzhou\,\ Fujian",
  861320503 => "Fuzhou\,\ Fujian",
  861320504 => "Nanping\,\ Fujian",
  861320505 => "Quanzhou\,\ Fujian",
  861320506 => "Quanzhou\,\ Fujian",
  861320507 => "Quanzhou\,\ Fujian",
  861320508 => "Quanzhou\,\ Fujian",
  861320509 => "Quanzhou\,\ Fujian",
  861320510 => "Changzhou\,\ Jiangsu",
  861320511 => "Suzhou\,\ Jiangsu",
  861320512 => "Suzhou\,\ Jiangsu",
  861320513 => "Suzhou\,\ Jiangsu",
  861320514 => "Suzhou\,\ Jiangsu",
  861320515 => "Suzhou\,\ Jiangsu",
  861320516 => "Suzhou\,\ Jiangsu",
  861320517 => "Suzhou\,\ Jiangsu",
  861320518 => "Suzhou\,\ Jiangsu",
  861320519 => "Suzhou\,\ Jiangsu",
  861320520 => "Changzhou\,\ Jiangsu",
  861320521 => "Wuxi\,\ Jiangsu",
  861320522 => "Wuxi\,\ Jiangsu",
  861320523 => "Wuxi\,\ Jiangsu",
  861320524 => "Wuxi\,\ Jiangsu",
  861320525 => "Wuxi\,\ Jiangsu",
  861320526 => "Wuxi\,\ Jiangsu",
  861320527 => "Wuxi\,\ Jiangsu",
  861320528 => "Wuxi\,\ Jiangsu",
  861320529 => "Wuxi\,\ Jiangsu",
  861320530 => "Heze\,\ Shandong",
  861320531 => "Jinan\,\ Shandong",
  861320532 => "Qingdao\,\ Shandong",
  861320533 => "Zibo\,\ Shandong",
  861320534 => "Dezhou\,\ Shandong",
  861320535 => "Yantai\,\ Shandong",
  861320536 => "Weifang\,\ Shandong",
  861320537 => "Jining\,\ Shandong",
  861320538 => "TaiAn\,\ Shandong",
  861320539 => "Linyi\,\ Shandong",
  861320540 => "Jinan\,\ Shandong",
  861320541 => "Jinan\,\ Shandong",
  861320542 => "Jinan\,\ Shandong",
  861320543 => "Binzhou\,\ Shandong",
  861320544 => "Yantai\,\ Shandong",
  861320545 => "Yantai\,\ Shandong",
  861320546 => "Dongying\,\ Shandong",
  861320547 => "Dongying\,\ Shandong",
  861320548 => "Dongying\,\ Shandong",
  861320549 => "Dongying\,\ Shandong",
  861320550 => "Chuzhou\,\ Anhui",
  861320551 => "Hefei\,\ Anhui",
  861320552 => "Bengbu\,\ Anhui",
  861320553 => "Wuhu\,\ Anhui",
  861320554 => "Huainan\,\ Anhui",
  861320555 => "MaAnshan\,\ Anhui",
  861320556 => "Anqing\,\ Anhui",
  861320557 => "Suzhou\,\ Anhui",
  861320558 => "Fuyang\,\ Anhui",
  861320559 => "Huangshan\,\ Anhui",
  861320560 => "Hefei\,\ Anhui",
  861320561 => "Huaibei\,\ Anhui",
  861320562 => "Tongling\,\ Anhui",
  861320563 => "Xuancheng\,\ Anhui",
  861320564 => "LuAn\,\ Anhui",
  861320565 => "MaAnshan\,\ Anhui",
  861320566 => "Chizhou\,\ Anhui",
  861320567 => "Bozhou\,\ Anhui",
  861320568 => "Fuyang\,\ Anhui",
  861320569 => "Hefei\,\ Anhui",
  861320570 => "Quzhou\,\ Zhejiang",
  861320571 => "Hangzhou\,\ Zhejiang",
  861320572 => "Huzhou\,\ Zhejiang",
  861320573 => "Jiaxing\,\ Zhejiang",
  861320574 => "Ningbo\,\ Zhejiang",
  861320575 => "Shaoxing\,\ Zhejiang",
  861320576 => "Taizhou\,\ Zhejiang",
  861320577 => "Wenzhou\,\ Zhejiang",
  861320578 => "Lishui\,\ Zhejiang",
  861320579 => "Jinhua\,\ Zhejiang",
  861320580 => "Zhoushan\,\ Zhejiang",
  861320581 => "Hangzhou\,\ Zhejiang",
  861320582 => "Huzhou\,\ Zhejiang",
  861320583 => "Jiaxing\,\ Zhejiang",
  861320584 => "Ningbo\,\ Zhejiang",
  861320585 => "Shaoxing\,\ Zhejiang",
  861320586 => "Taizhou\,\ Zhejiang",
  861320587 => "Wenzhou\,\ Zhejiang",
  861320588 => "Lishui\,\ Zhejiang",
  861320589 => "Jinhua\,\ Zhejiang",
  861320590 => "Fuzhou\,\ Fujian",
  861320591 => "Fuzhou\,\ Fujian",
  861320592 => "Xiamen\,\ Fujian",
  861320593 => "Ningde\,\ Fujian",
  861320594 => "Putian\,\ Fujian",
  861320595 => "Quanzhou\,\ Fujian",
  861320596 => "Zhangzhou\,\ Fujian",
  861320597 => "Longyan\,\ Fujian",
  861320598 => "Sanming\,\ Fujian",
  861320599 => "Nanping\,\ Fujian",
  86132060 => "Chongqing",
  86132061 => "Chongqing",
  86132062 => "Chongqing",
  861320630 => "Weihai\,\ Shandong",
  861320631 => "Weihai\,\ Shandong",
  861320632 => "Zaozhuang\,\ Shandong",
  861320633 => "Rizhao\,\ Shandong",
  861320634 => "Laiwu\,\ Shandong",
  861320635 => "Liaocheng\,\ Shandong",
  861320636 => "Qingdao\,\ Shandong",
  861320637 => "Qingdao\,\ Shandong",
  861320638 => "Qingdao\,\ Shandong",
  861320639 => "Qingdao\,\ Shandong",
  861320640 => "Jinan\,\ Shandong",
  861320641 => "Qingdao\,\ Shandong",
  861320642 => "Qingdao\,\ Shandong",
  861320643 => "Qingdao\,\ Shandong",
  861320644 => "Qingdao\,\ Shandong",
  861320645 => "Qingdao\,\ Shandong",
  861320646 => "Qingdao\,\ Shandong",
  861320647 => "Qingdao\,\ Shandong",
  861320648 => "Qingdao\,\ Shandong",
  861320649 => "Qingdao\,\ Shandong",
  861320650 => "Qiqihar\,\ Heilongjiang",
  861320651 => "Qiqihar\,\ Heilongjiang",
  861320652 => "Harbin\,\ Heilongjiang",
  861320653 => "Harbin\,\ Heilongjiang",
  861320654 => "Harbin\,\ Heilongjiang",
  861320655 => "Harbin\,\ Heilongjiang",
  861320656 => "Harbin\,\ Heilongjiang",
  861320657 => "Harbin\,\ Heilongjiang",
  861320658 => "Harbin\,\ Heilongjiang",
  861320659 => "Harbin\,\ Heilongjiang",
  861320660 => "Qiqihar\,\ Heilongjiang",
  861320661 => "Qiqihar\,\ Heilongjiang",
  861320662 => "Qiqihar\,\ Heilongjiang",
  861320663 => "Qiqihar\,\ Heilongjiang",
  861320664 => "Harbin\,\ Heilongjiang",
  861320665 => "Harbin\,\ Heilongjiang",
  861320666 => "Harbin\,\ Heilongjiang",
  861320667 => "Harbin\,\ Heilongjiang",
  861320668 => "Harbin\,\ Heilongjiang",
  861320669 => "Harbin\,\ Heilongjiang",
  861320670 => "Heihe\,\ Heilongjiang",
  861320671 => "Yichun\,\ Heilongjiang",
  861320672 => "Qiqihar\,\ Heilongjiang",
  861320673 => "Qiqihar\,\ Heilongjiang",
  861320674 => "Harbin\,\ Heilongjiang",
  861320675 => "Harbin\,\ Heilongjiang",
  861320676 => "Harbin\,\ Heilongjiang",
  861320677 => "Shuangyashan\,\ Heilongjiang",
  861320678 => "Shuangyashan\,\ Heilongjiang",
  861320679 => "Heihe\,\ Heilongjiang",
  861320680 => "Daqing\,\ Heilongjiang",
  861320681 => "Daqing\,\ Heilongjiang",
  861320682 => "Daqing\,\ Heilongjiang",
  861320683 => "Daqing\,\ Heilongjiang",
  861320684 => "Daqing\,\ Heilongjiang",
  861320685 => "Daqing\,\ Heilongjiang",
  861320686 => "Mudanjiang\,\ Heilongjiang",
  861320687 => "Mudanjiang\,\ Heilongjiang",
  861320688 => "Mudanjiang\,\ Heilongjiang",
  861320689 => "Mudanjiang\,\ Heilongjiang",
  861320690 => "Suihua\,\ Heilongjiang",
  861320691 => "Suihua\,\ Heilongjiang",
  861320692 => "Suihua\,\ Heilongjiang",
  861320693 => "Heihe\,\ Heilongjiang",
  861320694 => "Heihe\,\ Heilongjiang",
  861320695 => "Jixi\,\ Heilongjiang",
  861320696 => "Jixi\,\ Heilongjiang",
  861320697 => "Jiamusi\,\ Heilongjiang",
  861320698 => "Jiamusi\,\ Heilongjiang",
  861320699 => "Jiamusi\,\ Heilongjiang",
  861320700 => "Nanchang\,\ Jiangxi",
  861320701 => "Yingtan\,\ Jiangxi",
  861320702 => "Jiujiang\,\ Jiangxi",
  861320703 => "Shangrao\,\ Jiangxi",
  861320704 => "Fuzhou\,\ Jiangxi",
  861320705 => "Yichun\,\ Jiangxi",
  861320706 => "JiAn\,\ Jiangxi",
  861320707 => "Ganzhou\,\ Jiangxi",
  861320708 => "Nanchang\,\ Jiangxi",
  861320709 => "Nanchang\,\ Jiangxi",
  86132071 => "Wuhan\,\ Hubei",
  861320720 => "Yichang\,\ Hubei",
  861320721 => "Yichang\,\ Hubei",
  861320722 => "Yichang\,\ Hubei",
  861320723 => "Xiangfan\,\ Hubei",
  861320724 => "Xiangfan\,\ Hubei",
  861320725 => "Xiangfan\,\ Hubei",
  861320726 => "Shiyan\,\ Hubei",
  861320727 => "Jingzhou\,\ Hubei",
  861320728 => "Jingzhou\,\ Hubei",
  861320729 => "Jingzhou\,\ Hubei",
  861320730 => "Yueyang\,\ Hunan",
  861320731 => "Changsha\,\ Hunan",
  861320732 => "Xiangtan\,\ Hunan",
  861320733 => "Zhuzhou\,\ Hunan",
  861320734 => "Hengyang\,\ Hunan",
  861320735 => "Chenzhou\,\ Hunan",
  861320736 => "Changde\,\ Hunan",
  861320737 => "Yiyang\,\ Hunan",
  861320738 => "Loudi\,\ Hunan",
  861320739 => "Shaoyang\,\ Hunan",
  861320740 => "Yueyang\,\ Hunan",
  861320741 => "Changsha\,\ Hunan",
  861320742 => "Changsha\,\ Hunan",
  861320743 => "Xiangxi\,\ Hunan",
  861320744 => "Zhangjiajie\,\ Hunan",
  861320745 => "Huaihua\,\ Hunan",
  861320746 => "Yongzhou\,\ Hunan",
  861320747 => "Changsha\,\ Hunan",
  861320748 => "Changsha\,\ Hunan",
  861320749 => "Changsha\,\ Hunan",
  86132075 => "Tianjin",
  86132076 => "Tianjin",
  861320770 => "Fangchenggang\,\ Guangxi",
  861320771 => "Nanning\,\ Guangxi",
  861320772 => "Liuzhou\,\ Guangxi",
  861320773 => "Guilin\,\ Guangxi",
  861320774 => "Wuzhou\,\ Guangxi",
  861320775 => "Yulin\,\ Guangxi",
  861320776 => "Baise\,\ Guangxi",
  861320777 => "Qinzhou\,\ Guangxi",
  861320778 => "Hechi\,\ Guangxi",
  861320779 => "Beihai\,\ Guangxi",
  861320780 => "Nanning\,\ Guangxi",
  861320781 => "Nanning\,\ Guangxi",
  861320782 => "Liuzhou\,\ Guangxi",
  861320783 => "Guilin\,\ Guangxi",
  861320784 => "Wuzhou\,\ Guangxi",
  861320785 => "Yulin\,\ Guangxi",
  861320786 => "Baise\,\ Guangxi",
  861320787 => "Qinzhou\,\ Guangxi",
  861320788 => "Hechi\,\ Guangxi",
  861320789 => "Guigang\,\ Guangxi",
  861320790 => "Xinyu\,\ Jiangxi",
  861320791 => "Nanchang\,\ Jiangxi",
  861320792 => "Jiujiang\,\ Jiangxi",
  861320793 => "Shangrao\,\ Jiangxi",
  861320794 => "Fuzhou\,\ Jiangxi",
  861320795 => "Yichun\,\ Jiangxi",
  861320796 => "JiAn\,\ Jiangxi",
  861320797 => "Ganzhou\,\ Jiangxi",
  861320798 => "Jingdezhen\,\ Jiangxi",
  861320799 => "Pingxiang\,\ Jiangxi",
  861320800 => "Hangzhou\,\ Zhejiang",
  861320801 => "Hangzhou\,\ Zhejiang",
  861320802 => "Hangzhou\,\ Zhejiang",
  861320803 => "Hangzhou\,\ Zhejiang",
  861320804 => "Hangzhou\,\ Zhejiang",
  861320805 => "Ningbo\,\ Zhejiang",
  861320806 => "Ningbo\,\ Zhejiang",
  861320807 => "Ningbo\,\ Zhejiang",
  861320808 => "Ningbo\,\ Zhejiang",
  861320809 => "Ningbo\,\ Zhejiang",
  861320810 => "Chengdu\,\ Sichuan",
  861320811 => "Chengdu\,\ Sichuan",
  861320812 => "Nanchong\,\ Sichuan",
  861320813 => "Zigong\,\ Sichuan",
  861320814 => "Aba\,\ Sichuan",
  861320815 => "Ziyang\,\ Sichuan",
  861320816 => "Chengdu\,\ Sichuan",
  861320817 => "Chengdu\,\ Sichuan",
  861320818 => "Chengdu\,\ Sichuan",
  861320819 => "Chengdu\,\ Sichuan",
  861320820 => "Panzhihua\,\ Sichuan",
  861320821 => "Dazhou\,\ Sichuan",
  861320822 => "GuangAn\,\ Sichuan",
  861320823 => "Nanchong\,\ Sichuan",
  861320824 => "Garze\,\ Sichuan",
  861320825 => "Suining\,\ Sichuan",
  861320826 => "Mianyang\,\ Sichuan",
  861320827 => "Mianyang\,\ Sichuan",
  861320828 => "Mianyang\,\ Sichuan",
  861320829 => "Mianyang\,\ Sichuan",
  861320830 => "Luzhou\,\ Sichuan",
  861320831 => "Yibin\,\ Sichuan",
  861320832 => "Neijiang\,\ Sichuan",
  861320833 => "Leshan\,\ Sichuan",
  861320834 => "Liangshan\,\ Sichuan",
  861320835 => "YaAn\,\ Sichuan",
  861320836 => "Bazhong\,\ Sichuan",
  861320837 => "Meishan\,\ Sichuan",
  861320838 => "Deyang\,\ Sichuan",
  861320839 => "Guangyuan\,\ Sichuan",
  861320840 => "Jiamusi\,\ Heilongjiang",
  861320841 => "Jiamusi\,\ Heilongjiang",
  861320842 => "Jiamusi\,\ Heilongjiang",
  861320843 => "Mudanjiang\,\ Heilongjiang",
  861320844 => "Daqing\,\ Heilongjiang",
  861320845 => "Daqing\,\ Heilongjiang",
  861320846 => "Daqing\,\ Heilongjiang",
  861320847 => "Daqing\,\ Heilongjiang",
  861320848 => "Daqing\,\ Heilongjiang",
  861320849 => "Shuangyashan\,\ Heilongjiang",
  861320850 => "Anshun\,\ Guizhou",
  861320851 => "Guiyang\,\ Guizhou",
  861320852 => "Zunyi\,\ Guizhou",
  861320853 => "Anshun\,\ Guizhou",
  861320854 => "Liupanshui\,\ Guizhou",
  861320855 => "Qiandongnan\,\ Guizhou",
  861320856 => "Qiannan\,\ Guizhou",
  861320857 => "Bijie\,\ Guizhou",
  861320858 => "Bijie\,\ Guizhou",
  861320859 => "Bijie\,\ Guizhou",
  861320860 => "Songyuan\,\ Jilin",
  861320861 => "Songyuan\,\ Jilin",
  861320862 => "Songyuan\,\ Jilin",
  861320863 => "Songyuan\,\ Jilin",
  861320864 => "Songyuan\,\ Jilin",
  861320865 => "Liaoyuan\,\ Jilin",
  861320866 => "Liaoyuan\,\ Jilin",
  861320867 => "Liaoyuan\,\ Jilin",
  861320868 => "Liaoyuan\,\ Jilin",
  861320869 => "Liaoyuan\,\ Jilin",
  861320870 => "Zhaotong\,\ Yunnan",
  861320871 => "Kunming\,\ Yunnan",
  861320872 => "Dali\,\ Yunnan",
  861320873 => "Honghe\,\ Yunnan",
  861320874 => "Qujing\,\ Yunnan",
  861320875 => "Baoshan\,\ Yunnan",
  861320876 => "Wenshan\,\ Yunnan",
  861320877 => "Yuxi\,\ Yunnan",
  861320878 => "Chuxiong\,\ Yunnan",
  861320879 => "Puer\,\ Yunnan",
  861320880 => "Kunming\,\ Yunnan",
  861320881 => "Xishuangbanna\,\ Yunnan",
  861320882 => "Dehong\,\ Yunnan",
  861320883 => "Lincang\,\ Yunnan",
  861320884 => "Kunming\,\ Yunnan",
  861320885 => "Kunming\,\ Yunnan",
  861320886 => "Nujiang\,\ Yunnan",
  861320887 => "Deqen\,\ Yunnan",
  861320888 => "Lijiang\,\ Yunnan",
  861320889 => "Kunming\,\ Yunnan",
  86132089 => "Haikou\,\ Hainan",
  861320900 => "Ili\,\ Xinjiang",
  861320901 => "Tacheng\,\ Xinjiang",
  861320902 => "Hami\,\ Xinjiang",
  861320903 => "Hotan\,\ Xinjiang",
  861320904 => "Bayingolin\,\ Xinjiang",
  861320905 => "Aksu\,\ Xinjiang",
  861320906 => "Altay\,\ Xinjiang",
  861320907 => "Kashi\,\ Xinjiang",
  861320908 => "Kizilsu\,\ Xinjiang",
  861320909 => "Bortala\,\ Xinjiang",
  861320910 => "Xianyang\,\ Shaanxi",
  861320911 => "YanAn\,\ Shaanxi",
  861320912 => "Yulin\,\ Shaanxi",
  861320913 => "Weinan\,\ Shaanxi",
  861320914 => "Shangluo\,\ Shaanxi",
  861320915 => "Ankang\,\ Shaanxi",
  861320916 => "Hanzhong\,\ Shaanxi",
  861320917 => "Baoji\,\ Shaanxi",
  861320918 => "Weinan\,\ Shaanxi",
  861320919 => "Tongchuan\,\ Shaanxi",
  861320920 => "Baoji\,\ Shaanxi",
  861320921 => "Baoji\,\ Shaanxi",
  861320922 => "Baoji\,\ Shaanxi",
  861320923 => "Baoji\,\ Shaanxi",
  861320924 => "Hanzhong\,\ Shaanxi",
  861320925 => "Hanzhong\,\ Shaanxi",
  861320926 => "Hanzhong\,\ Shaanxi",
  861320927 => "Hanzhong\,\ Shaanxi",
  861320928 => "YanAn\,\ Shaanxi",
  861320929 => "YanAn\,\ Shaanxi",
  861320930 => "Linxia\,\ Gansu",
  861320931 => "Lanzhou\,\ Gansu",
  861320932 => "Dingxi\,\ Gansu",
  861320933 => "Pingliang\,\ Gansu",
  861320934 => "Qingyang\,\ Gansu",
  861320935 => "Wuwei\,\ Gansu",
  861320936 => "Zhangye\,\ Gansu",
  861320937 => "Jiuquan\,\ Gansu",
  861320938 => "Tianshui\,\ Gansu",
  861320939 => "Longnan\,\ Gansu",
  861320940 => "Jiuquan\,\ Gansu",
  861320941 => "Gannan\,\ Gansu",
  861320942 => "Jiuquan\,\ Gansu",
  861320943 => "Baiyin\,\ Gansu",
  861320944 => "Longnan\,\ Gansu",
  861320945 => "Jinchang\,\ Gansu",
  861320946 => "Lanzhou\,\ Gansu",
  861320947 => "Jiayuguan\,\ Gansu",
  861320948 => "Jiayuguan\,\ Gansu",
  861320949 => "Baiyin\,\ Gansu",
  861320950 => "Yinchuan\,\ Ningxia",
  861320951 => "Yinchuan\,\ Ningxia",
  861320952 => "Shizuishan\,\ Ningxia",
  861320953 => "Wuzhong\,\ Ningxia",
  861320954 => "Guyuan\,\ Ningxia",
  861320955 => "Zhongwei\,\ Ningxia",
  861320956 => "Shizuishan\,\ Ningxia",
  861320957 => "Zhongwei\,\ Ningxia",
  861320958 => "Yinchuan\,\ Ningxia",
  861320959 => "Yinchuan\,\ Ningxia",
  861320960 => "Yinchuan\,\ Ningxia",
  861320961 => "Yinchuan\,\ Ningxia",
  861320962 => "Shizuishan\,\ Ningxia",
  861320963 => "Wuzhong\,\ Ningxia",
  861320964 => "Zhongwei\,\ Ningxia",
  861320965 => "Zhongwei\,\ Ningxia",
  861320966 => "Shizuishan\,\ Ningxia",
  861320967 => "Zhongwei\,\ Ningxia",
  861320968 => "Yinchuan\,\ Ningxia",
  861320969 => "Yinchuan\,\ Ningxia",
  861320970 => "Haibei\,\ Qinghai",
  861320971 => "Xining\,\ Qinghai",
  861320972 => "Haidong\,\ Qinghai",
  861320973 => "Huangnan\,\ Qinghai",
  861320974 => "Hainan\,\ Qinghai",
  861320975 => "Haixi\,\ Qinghai",
  861320976 => "Haixi\,\ Qinghai",
  861320977 => "Haixi\,\ Qinghai",
  861320978 => "Xining\,\ Qinghai",
  861320979 => "Haixi\,\ Qinghai",
  861320980 => "Taiyuan\,\ Shanxi",
  861320981 => "Taiyuan\,\ Shanxi",
  861320982 => "Taiyuan\,\ Shanxi",
  861320983 => "Datong\,\ Shanxi",
  861320984 => "Datong\,\ Shanxi",
  861320985 => "Changzhi\,\ Shanxi",
  861320986 => "Linfen\,\ Shanxi",
  861320987 => "Jincheng\,\ Shanxi",
  861320988 => "Jinzhong\,\ Shanxi",
  861320989 => "Yuncheng\,\ Shanxi",
  861320990 => "Urumchi\,\ Xinjiang",
  861320991 => "Urumchi\,\ Xinjiang",
  861320992 => "Urumchi\,\ Xinjiang",
  861320993 => "Urumchi\,\ Xinjiang",
  861320994 => "Changji\,\ Xinjiang",
  861320995 => "Urumchi\,\ Xinjiang",
  861320996 => "Urumchi\,\ Xinjiang",
  861320997 => "Urumchi\,\ Xinjiang",
  861320998 => "Urumchi\,\ Xinjiang",
  861320999 => "Urumchi\,\ Xinjiang",
  86132100 => "Qingdao\,\ Shandong",
  86132101 => "Qingdao\,\ Shandong",
  86132102 => "Qingdao\,\ Shandong",
  86132103 => "Dongying\,\ Shandong",
  861321040 => "Binzhou\,\ Shandong",
  861321041 => "Binzhou\,\ Shandong",
  861321042 => "Linyi\,\ Shandong",
  861321043 => "Linyi\,\ Shandong",
  861321044 => "Dezhou\,\ Shandong",
  861321045 => "Liaocheng\,\ Shandong",
  861321046 => "Liaocheng\,\ Shandong",
  861321047 => "Zaozhuang\,\ Shandong",
  861321048 => "Zaozhuang\,\ Shandong",
  861321049 => "Jining\,\ Shandong",
  86132105 => "Jinan\,\ Shandong",
  861321060 => "Laiwu\,\ Shandong",
  861321061 => "TaiAn\,\ Shandong",
  861321062 => "TaiAn\,\ Shandong",
  861321063 => "Rizhao\,\ Shandong",
  861321064 => "Rizhao\,\ Shandong",
  861321065 => "Linyi\,\ Shandong",
  861321066 => "Linyi\,\ Shandong",
  861321067 => "Zibo\,\ Shandong",
  861321068 => "Weifang\,\ Shandong",
  861321069 => "TaiAn\,\ Shandong",
  861321070 => "Binzhou\,\ Shandong",
  861321071 => "Binzhou\,\ Shandong",
  861321072 => "Binzhou\,\ Shandong",
  861321073 => "Weifang\,\ Shandong",
  861321074 => "Weifang\,\ Shandong",
  861321075 => "Weifang\,\ Shandong",
  861321076 => "Weifang\,\ Shandong",
  861321077 => "Zaozhuang\,\ Shandong",
  861321078 => "Zaozhuang\,\ Shandong",
  861321079 => "Jining\,\ Shandong",
  86132108 => "Qingdao\,\ Shandong",
  861321090 => "Weihai\,\ Shandong",
  861321091 => "Yantai\,\ Shandong",
  861321092 => "Yantai\,\ Shandong",
  861321093 => "Yantai\,\ Shandong",
  861321094 => "Yantai\,\ Shandong",
  861321095 => "Liaocheng\,\ Shandong",
  861321096 => "Liaocheng\,\ Shandong",
  861321097 => "Dezhou\,\ Shandong",
  861321098 => "Dezhou\,\ Shandong",
  861321099 => "Dezhou\,\ Shandong",
  861321100 => "Dongguan\,\ Guangdong",
  861321101 => "Dongguan\,\ Guangdong",
  861321102 => "Shanwei\,\ Guangdong",
  861321103 => "Shanwei\,\ Guangdong",
  861321104 => "Zhaoqing\,\ Guangdong",
  861321105 => "Zhaoqing\,\ Guangdong",
  861321106 => "Zhaoqing\,\ Guangdong",
  861321107 => "Xingtai\,\ Hebei",
  861321108 => "Xingtai\,\ Hebei",
  861321109 => "Xingtai\,\ Hebei",
  861321110 => "Qingyuan\,\ Guangdong",
  861321111 => "Qingyuan\,\ Guangdong",
  861321112 => "Zhongshan\,\ Guangdong",
  861321113 => "Foshan\,\ Guangdong",
  861321114 => "Foshan\,\ Guangdong",
  861321115 => "Foshan\,\ Guangdong",
  861321116 => "Foshan\,\ Guangdong",
  861321117 => "Foshan\,\ Guangdong",
  861321118 => "Foshan\,\ Guangdong",
  861321119 => "Foshan\,\ Guangdong",
  861321120 => "Shantou\,\ Guangdong",
  861321121 => "Shantou\,\ Guangdong",
  861321122 => "Shantou\,\ Guangdong",
  861321123 => "Shantou\,\ Guangdong",
  861321124 => "Shantou\,\ Guangdong",
  861321125 => "Shantou\,\ Guangdong",
  861321126 => "Jiangmen\,\ Guangdong",
  861321127 => "Jiangmen\,\ Guangdong",
  861321128 => "Jiangmen\,\ Guangdong",
  861321129 => "Jiangmen\,\ Guangdong",
  86132113 => "Nanning\,\ Guangxi",
  861321140 => "Liuzhou\,\ Guangxi",
  861321141 => "Liuzhou\,\ Guangxi",
  861321142 => "Laibin\,\ Guangxi",
  861321143 => "Guilin\,\ Guangxi",
  861321144 => "Hezhou\,\ Guangxi",
  861321145 => "Yulin\,\ Guangxi",
  861321146 => "Baise\,\ Guangxi",
  861321147 => "Guigang\,\ Guangxi",
  861321148 => "Hechi\,\ Guangxi",
  861321149 => "Guigang\,\ Guangxi",
  861321150 => "Guilin\,\ Guangxi",
  861321151 => "Liuzhou\,\ Guangxi",
  861321152 => "Liuzhou\,\ Guangxi",
  861321153 => "Guilin\,\ Guangxi",
  861321154 => "Guilin\,\ Guangxi",
  861321155 => "Yulin\,\ Guangxi",
  861321156 => "Yulin\,\ Guangxi",
  861321157 => "Guigang\,\ Guangxi",
  861321158 => "Laibin\,\ Guangxi",
  861321159 => "Guilin\,\ Guangxi",
  86132116 => "Kunming\,\ Yunnan",
  86132117 => "Kunming\,\ Yunnan",
  861321180 => "Baoshan\,\ Yunnan",
  861321181 => "Wenshan\,\ Yunnan",
  861321182 => "Chuxiong\,\ Yunnan",
  861321183 => "Xishuangbanna\,\ Yunnan",
  861321184 => "Zhaotong\,\ Yunnan",
  861321185 => "Zhaotong\,\ Yunnan",
  861321186 => "Zhaotong\,\ Yunnan",
  861321187 => "Qujing\,\ Yunnan",
  861321188 => "Qujing\,\ Yunnan",
  861321189 => "Qujing\,\ Yunnan",
  861321190 => "Dali\,\ Yunnan",
  861321191 => "Honghe\,\ Yunnan",
  861321192 => "Kunming\,\ Yunnan",
  861321193 => "Lincang\,\ Yunnan",
  861321194 => "Nujiang\,\ Yunnan",
  861321195 => "Yuxi\,\ Yunnan",
  861321196 => "Yuxi\,\ Yunnan",
  861321197 => "Deqen\,\ Yunnan",
  861321198 => "Puer\,\ Yunnan",
  861321199 => "Puer\,\ Yunnan",
  86132120 => "Tianjin",
  86132121 => "Tianjin",
  86132122 => "Tianjin",
  86132123 => "Chongqing",
  86132124 => "Chongqing",
  86132125 => "Chongqing",
  861321260 => "Xiangxi\,\ Hunan",
  861321261 => "Changsha\,\ Hunan",
  861321262 => "Changsha\,\ Hunan",
  861321263 => "Changsha\,\ Hunan",
  861321264 => "Zhangjiajie\,\ Hunan",
  861321265 => "Huaihua\,\ Hunan",
  861321266 => "Yongzhou\,\ Hunan",
  861321267 => "Loudi\,\ Hunan",
  861321268 => "Hengyang\,\ Hunan",
  861321269 => "Hengyang\,\ Hunan",
  86132127 => "Wuhan\,\ Hubei",
  861321280 => "Harbin\,\ Heilongjiang",
  861321281 => "Harbin\,\ Heilongjiang",
  861321282 => "Qiqihar\,\ Heilongjiang",
  861321283 => "Mudanjiang\,\ Heilongjiang",
  861321284 => "Jiamusi\,\ Heilongjiang",
  861321285 => "Suihua\,\ Heilongjiang",
  861321286 => "Heihe\,\ Heilongjiang",
  861321287 => "Jixi\,\ Heilongjiang",
  861321288 => "Yichun\,\ Heilongjiang",
  861321289 => "Daqing\,\ Heilongjiang",
  861321290 => "Harbin\,\ Heilongjiang",
  861321291 => "Harbin\,\ Heilongjiang",
  861321292 => "Harbin\,\ Heilongjiang",
  861321293 => "Harbin\,\ Heilongjiang",
  861321294 => "Shuangyashan\,\ Heilongjiang",
  861321295 => "Qiqihar\,\ Heilongjiang",
  861321296 => "Qiqihar\,\ Heilongjiang",
  861321297 => "Hegang\,\ Heilongjiang",
  861321298 => "Jiamusi\,\ Heilongjiang",
  861321299 => "Jiamusi\,\ Heilongjiang",
  86132130 => "Zhengzhou\,\ Henan",
  86132131 => "Zhengzhou\,\ Henan",
  861321320 => "Zhengzhou\,\ Henan",
  861321321 => "Zhengzhou\,\ Henan",
  861321322 => "Zhengzhou\,\ Henan",
  861321323 => "Zhengzhou\,\ Henan",
  861321324 => "Zhengzhou\,\ Henan",
  861321325 => "Anyang\,\ Henan",
  861321326 => "Anyang\,\ Henan",
  861321327 => "Anyang\,\ Henan",
  861321328 => "Anyang\,\ Henan",
  861321329 => "Anyang\,\ Henan",
  861321330 => "Zhoukou\,\ Henan",
  861321331 => "Zhoukou\,\ Henan",
  861321332 => "Zhoukou\,\ Henan",
  861321333 => "Zhoukou\,\ Henan",
  861321334 => "Zhoukou\,\ Henan",
  861321335 => "Xuchang\,\ Henan",
  861321336 => "Xuchang\,\ Henan",
  861321337 => "Xuchang\,\ Henan",
  861321338 => "Xuchang\,\ Henan",
  861321339 => "Xuchang\,\ Henan",
  861321340 => "Hebi\,\ Henan",
  861321341 => "Hebi\,\ Henan",
  861321342 => "Hebi\,\ Henan",
  861321343 => "Zhumadian\,\ Henan",
  861321344 => "Zhumadian\,\ Henan",
  861321345 => "Zhumadian\,\ Henan",
  861321346 => "Zhumadian\,\ Henan",
  861321347 => "Puyang\,\ Henan",
  861321348 => "Puyang\,\ Henan",
  861321349 => "Puyang\,\ Henan",
  86132135 => "Luoyang\,\ Henan",
  86132136 => "Luoyang\,\ Henan",
  86132137 => "Nanyang\,\ Henan",
  861321380 => "Pingdingshan\,\ Henan",
  861321381 => "Pingdingshan\,\ Henan",
  861321382 => "Pingdingshan\,\ Henan",
  861321383 => "Pingdingshan\,\ Henan",
  861321384 => "Pingdingshan\,\ Henan",
  861321385 => "Pingdingshan\,\ Henan",
  861321386 => "Xinyang\,\ Henan",
  861321387 => "Xinyang\,\ Henan",
  861321388 => "Xinyang\,\ Henan",
  861321389 => "Xinyang\,\ Henan",
  861321390 => "Puyang\,\ Henan",
  861321391 => "Puyang\,\ Henan",
  861321392 => "Puyang\,\ Henan",
  861321393 => "Puyang\,\ Henan",
  861321394 => "Puyang\,\ Henan",
  861321395 => "Puyang\,\ Henan",
  861321396 => "Puyang\,\ Henan",
  861321397 => "Kaifeng\,\ Henan",
  861321398 => "Kaifeng\,\ Henan",
  861321399 => "Kaifeng\,\ Henan",
  861321400 => "Hohhot\,\ Inner\ Mongolia",
  861321401 => "Hohhot\,\ Inner\ Mongolia",
  861321402 => "Hohhot\,\ Inner\ Mongolia",
  861321403 => "Hohhot\,\ Inner\ Mongolia",
  861321404 => "Hinggan\,\ Inner\ Mongolia",
  861321405 => "Hohhot\,\ Inner\ Mongolia",
  861321406 => "Hohhot\,\ Inner\ Mongolia",
  861321407 => "Tongliao\,\ Inner\ Mongolia",
  861321408 => "Hohhot\,\ Inner\ Mongolia",
  861321409 => "Hohhot\,\ Inner\ Mongolia",
  861321410 => "Tieling\,\ Liaoning",
  861321411 => "Dalian\,\ Liaoning",
  861321412 => "Anshan\,\ Liaoning",
  861321413 => "Fushun\,\ Liaoning",
  861321414 => "Benxi\,\ Liaoning",
  861321415 => "Dandong\,\ Liaoning",
  861321416 => "Jinzhou\,\ Liaoning",
  861321417 => "Yingkou\,\ Liaoning",
  861321418 => "Fuxin\,\ Liaoning",
  861321419 => "Liaoyang\,\ Liaoning",
  861321420 => "Dalian\,\ Liaoning",
  861321421 => "Chaoyang\,\ Liaoning",
  861321422 => "Dalian\,\ Liaoning",
  861321423 => "Shenyang\,\ Liaoning",
  861321424 => "Shenyang\,\ Liaoning",
  861321425 => "Shenyang\,\ Liaoning",
  861321426 => "Shenyang\,\ Liaoning",
  861321427 => "Panjin\,\ Liaoning",
  861321428 => "Dalian\,\ Liaoning",
  861321429 => "Huludao\,\ Liaoning",
  861321430 => "Changchun\,\ Jilin",
  861321431 => "Changchun\,\ Jilin",
  861321432 => "Jilin\,\ Jilin",
  861321433 => "Yanbian\,\ Jilin",
  861321434 => "Siping\,\ Jilin",
  861321435 => "Tonghua\,\ Jilin",
  861321436 => "Baicheng\,\ Jilin",
  861321437 => "Liaoyuan\,\ Jilin",
  861321438 => "Songyuan\,\ Jilin",
  861321439 => "Baishan\,\ Jilin",
  861321440 => "Changchun\,\ Jilin",
  861321441 => "Changchun\,\ Jilin",
  861321442 => "Changchun\,\ Jilin",
  861321443 => "Changchun\,\ Jilin",
  861321444 => "Siping\,\ Jilin",
  861321445 => "Tonghua\,\ Jilin",
  861321446 => "Changchun\,\ Jilin",
  861321447 => "Changchun\,\ Jilin",
  861321448 => "Changchun\,\ Jilin",
  861321449 => "Changchun\,\ Jilin",
  861321450 => "Harbin\,\ Heilongjiang",
  861321451 => "Harbin\,\ Heilongjiang",
  861321452 => "Qiqihar\,\ Heilongjiang",
  861321453 => "Mudanjiang\,\ Heilongjiang",
  861321454 => "Jiamusi\,\ Heilongjiang",
  861321455 => "Suihua\,\ Heilongjiang",
  861321456 => "Heihe\,\ Heilongjiang",
  861321457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861321458 => "Yichun\,\ Heilongjiang",
  861321459 => "Daqing\,\ Heilongjiang",
  861321460 => "Harbin\,\ Heilongjiang",
  861321461 => "Harbin\,\ Heilongjiang",
  861321462 => "Qiqihar\,\ Heilongjiang",
  861321463 => "Mudanjiang\,\ Heilongjiang",
  861321464 => "Qitaihe\,\ Heilongjiang",
  861321465 => "Suihua\,\ Heilongjiang",
  861321466 => "Heihe\,\ Heilongjiang",
  861321467 => "Jixi\,\ Heilongjiang",
  861321468 => "Hegang\,\ Heilongjiang",
  861321469 => "Shuangyashan\,\ Heilongjiang",
  861321470 => "Hulun\,\ Inner\ Mongolia",
  861321471 => "Hohhot\,\ Inner\ Mongolia",
  861321472 => "Baotou\,\ Inner\ Mongolia",
  861321473 => "Wuhai\,\ Inner\ Mongolia",
  861321474 => "Hinggan\,\ Inner\ Mongolia",
  861321475 => "Tongliao\,\ Inner\ Mongolia",
  861321476 => "Chifeng\,\ Inner\ Mongolia",
  861321477 => "Ordos\,\ Inner\ Mongolia",
  861321478 => "Bayannur\,\ Inner\ Mongolia",
  861321479 => "Xilin\,\ Inner\ Mongolia",
  861321480 => "Hinggan\,\ Inner\ Mongolia",
  861321481 => "Tongliao\,\ Inner\ Mongolia",
  861321482 => "Hinggan\,\ Inner\ Mongolia",
  861321483 => "Ordos\,\ Inner\ Mongolia",
  861321484 => "Ordos\,\ Inner\ Mongolia",
  861321485 => "Ordos\,\ Inner\ Mongolia",
  861321486 => "Chifeng\,\ Inner\ Mongolia",
  861321487 => "Chifeng\,\ Inner\ Mongolia",
  861321488 => "Bayannur\,\ Inner\ Mongolia",
  861321489 => "Bayannur\,\ Inner\ Mongolia",
  861321490 => "Baotou\,\ Inner\ Mongolia",
  861321491 => "Baotou\,\ Inner\ Mongolia",
  861321492 => "Baotou\,\ Inner\ Mongolia",
  861321493 => "Baotou\,\ Inner\ Mongolia",
  861321494 => "Baotou\,\ Inner\ Mongolia",
  861321495 => "Baotou\,\ Inner\ Mongolia",
  861321496 => "Baotou\,\ Inner\ Mongolia",
  861321497 => "Bayannur\,\ Inner\ Mongolia",
  861321498 => "Hulun\,\ Inner\ Mongolia",
  861321499 => "Hulun\,\ Inner\ Mongolia",
  861321500 => "Fuzhou\,\ Fujian",
  861321501 => "Xiamen\,\ Fujian",
  861321502 => "Xiamen\,\ Fujian",
  861321503 => "Sanming\,\ Fujian",
  861321504 => "Fuzhou\,\ Fujian",
  861321505 => "Putian\,\ Fujian",
  861321506 => "Quanzhou\,\ Fujian",
  861321507 => "Quanzhou\,\ Fujian",
  861321508 => "Putian\,\ Fujian",
  861321509 => "Longyan\,\ Fujian",
  86132151 => "Dongguan\,\ Guangdong",
  86132152 => "Dongguan\,\ Guangdong",
  86132153 => "Dongguan\,\ Guangdong",
  861321540 => "Langfang\,\ Hebei",
  861321541 => "Langfang\,\ Hebei",
  861321542 => "Dongguan\,\ Guangdong",
  861321543 => "Langfang\,\ Hebei",
  861321544 => "Langfang\,\ Hebei",
  861321545 => "Langfang\,\ Hebei",
  861321546 => "Dongguan\,\ Guangdong",
  861321547 => "Langfang\,\ Hebei",
  861321548 => "Langfang\,\ Hebei",
  861321549 => "Langfang\,\ Hebei",
  861321550 => "Chuzhou\,\ Anhui",
  861321551 => "Hefei\,\ Anhui",
  861321552 => "Bengbu\,\ Anhui",
  861321553 => "Wuhu\,\ Anhui",
  861321554 => "Huainan\,\ Anhui",
  861321555 => "MaAnshan\,\ Anhui",
  861321556 => "Anqing\,\ Anhui",
  861321557 => "Suzhou\,\ Anhui",
  861321558 => "Fuyang\,\ Anhui",
  861321559 => "Huangshan\,\ Anhui",
  861321560 => "Hefei\,\ Anhui",
  861321561 => "Huaibei\,\ Anhui",
  861321562 => "Tongling\,\ Anhui",
  861321563 => "Xuancheng\,\ Anhui",
  861321564 => "LuAn\,\ Anhui",
  861321565 => "Hefei\,\ Anhui",
  861321566 => "Chizhou\,\ Anhui",
  861321567 => "Bozhou\,\ Anhui",
  861321568 => "Fuyang\,\ Anhui",
  861321569 => "Hefei\,\ Anhui",
  86132157 => "Haikou\,\ Hainan",
  86132158 => "Haikou\,\ Hainan",
  861321590 => "Sanming\,\ Fujian",
  861321591 => "Xiamen\,\ Fujian",
  861321592 => "Xiamen\,\ Fujian",
  861321593 => "Nanping\,\ Fujian",
  861321594 => "Xiamen\,\ Fujian",
  861321595 => "Quanzhou\,\ Fujian",
  861321596 => "Zhangzhou\,\ Fujian",
  861321597 => "Fuzhou\,\ Fujian",
  861321598 => "Fuzhou\,\ Fujian",
  861321599 => "Zhengzhou\,\ Henan",
  86132160 => "Wenzhou\,\ Zhejiang",
  86132161 => "Hangzhou\,\ Zhejiang",
  861321620 => "Jinhua\,\ Zhejiang",
  861321621 => "Jinhua\,\ Zhejiang",
  861321622 => "Jinhua\,\ Zhejiang",
  861321623 => "Jinhua\,\ Zhejiang",
  861321624 => "Jinhua\,\ Zhejiang",
  861321625 => "Jinhua\,\ Zhejiang",
  861321626 => "Jinhua\,\ Zhejiang",
  861321627 => "Quzhou\,\ Zhejiang",
  861321628 => "Quzhou\,\ Zhejiang",
  861321629 => "Quzhou\,\ Zhejiang",
  86132163 => "Jiaxing\,\ Zhejiang",
  861321640 => "Quzhou\,\ Zhejiang",
  861321641 => "Quzhou\,\ Zhejiang",
  861321642 => "Huzhou\,\ Zhejiang",
  861321643 => "Lishui\,\ Zhejiang",
  861321644 => "Lishui\,\ Zhejiang",
  861321645 => "Shaoxing\,\ Zhejiang",
  861321646 => "Shaoxing\,\ Zhejiang",
  861321647 => "Wenzhou\,\ Zhejiang",
  861321648 => "Taizhou\,\ Zhejiang",
  861321649 => "Taizhou\,\ Zhejiang",
  861321650 => "Huzhou\,\ Zhejiang",
  861321651 => "Huzhou\,\ Zhejiang",
  861321652 => "Huzhou\,\ Zhejiang",
  861321653 => "Huzhou\,\ Zhejiang",
  861321654 => "Huzhou\,\ Zhejiang",
  861321655 => "Huzhou\,\ Zhejiang",
  861321656 => "Huzhou\,\ Zhejiang",
  861321657 => "Zhoushan\,\ Zhejiang",
  861321658 => "Zhoushan\,\ Zhejiang",
  861321659 => "Zhoushan\,\ Zhejiang",
  86132166 => "Ningbo\,\ Zhejiang",
  861321670 => "Hangzhou\,\ Zhejiang",
  861321671 => "Hangzhou\,\ Zhejiang",
  861321672 => "Huzhou\,\ Zhejiang",
  861321673 => "Jiaxing\,\ Zhejiang",
  861321674 => "Ningbo\,\ Zhejiang",
  861321675 => "Shaoxing\,\ Zhejiang",
  861321676 => "Shaoxing\,\ Zhejiang",
  861321677 => "Shaoxing\,\ Zhejiang",
  861321678 => "Shaoxing\,\ Zhejiang",
  861321679 => "Jinhua\,\ Zhejiang",
  861321680 => "Zhoushan\,\ Zhejiang",
  861321681 => "Hangzhou\,\ Zhejiang",
  861321682 => "Ningbo\,\ Zhejiang",
  861321683 => "Ningbo\,\ Zhejiang",
  861321684 => "Ningbo\,\ Zhejiang",
  861321685 => "Shaoxing\,\ Zhejiang",
  861321686 => "Lishui\,\ Zhejiang",
  861321687 => "Lishui\,\ Zhejiang",
  861321688 => "Lishui\,\ Zhejiang",
  861321689 => "Lishui\,\ Zhejiang",
  86132169 => "Taizhou\,\ Zhejiang",
  861321700 => "Nanchang\,\ Jiangxi",
  861321701 => "Yingtan\,\ Jiangxi",
  861321702 => "Jiujiang\,\ Jiangxi",
  861321703 => "Jingdezhen\,\ Jiangxi",
  861321704 => "Fuzhou\,\ Jiangxi",
  861321705 => "Yichun\,\ Jiangxi",
  861321706 => "JiAn\,\ Jiangxi",
  861321707 => "Ganzhou\,\ Jiangxi",
  861321708 => "Xinyu\,\ Jiangxi",
  861321709 => "Pingxiang\,\ Jiangxi",
  861321710 => "Xiangfan\,\ Hubei",
  861321711 => "Ezhou\,\ Hubei",
  861321712 => "Xiaogan\,\ Hubei",
  861321713 => "Huanggang\,\ Hubei",
  861321714 => "Huangshi\,\ Hubei",
  861321715 => "Xianning\,\ Hubei",
  861321716 => "Jingzhou\,\ Hubei",
  861321717 => "Yichang\,\ Hubei",
  861321718 => "Enshi\,\ Hubei",
  861321719 => "Shiyan\,\ Hubei",
  861321720 => "Xiangfan\,\ Hubei",
  861321721 => "Xiaogan\,\ Hubei",
  861321722 => "Suizhou\,\ Hubei",
  861321723 => "Huanggang\,\ Hubei",
  861321724 => "Jingmen\,\ Hubei",
  861321725 => "Huanggang\,\ Hubei",
  861321726 => "Jingzhou\,\ Hubei",
  861321727 => "Yichang\,\ Hubei",
  861321728 => "Enshi\,\ Hubei",
  861321729 => "Jingzhou\,\ Hubei",
  861321730 => "Yueyang\,\ Hunan",
  861321731 => "Changsha\,\ Hunan",
  861321732 => "Xiangtan\,\ Hunan",
  861321733 => "Zhuzhou\,\ Hunan",
  861321734 => "Hengyang\,\ Hunan",
  861321735 => "Chenzhou\,\ Hunan",
  861321736 => "Changde\,\ Hunan",
  861321737 => "Yiyang\,\ Hunan",
  861321738 => "Loudi\,\ Hunan",
  861321739 => "Shaoyang\,\ Hunan",
  861321740 => "Yueyang\,\ Hunan",
  861321741 => "Changsha\,\ Hunan",
  861321742 => "Xiangtan\,\ Hunan",
  861321743 => "Xiangxi\,\ Hunan",
  861321744 => "Zhangjiajie\,\ Hunan",
  861321745 => "Huaihua\,\ Hunan",
  861321746 => "Yongzhou\,\ Hunan",
  861321747 => "Huaihua\,\ Hunan",
  861321748 => "Changsha\,\ Hunan",
  861321749 => "Shaoyang\,\ Hunan",
  861321750 => "Jiangmen\,\ Guangdong",
  861321751 => "Shaoguan\,\ Guangdong",
  861321752 => "Huizhou\,\ Guangdong",
  861321753 => "Meizhou\,\ Guangdong",
  861321754 => "Shantou\,\ Guangdong",
  861321755 => "Shantou\,\ Guangdong",
  861321756 => "Zhuhai\,\ Guangdong",
  861321757 => "Foshan\,\ Guangdong",
  861321758 => "Zhaoqing\,\ Guangdong",
  861321759 => "Zhanjiang\,\ Guangdong",
  861321760 => "Zhongshan\,\ Guangdong",
  861321761 => "Heyuan\,\ Guangdong",
  861321762 => "Heyuan\,\ Guangdong",
  861321763 => "Qingyuan\,\ Guangdong",
  861321764 => "Foshan\,\ Guangdong",
  861321765 => "Foshan\,\ Guangdong",
  861321766 => "Yunfu\,\ Guangdong",
  861321767 => "Chaozhou\,\ Guangdong",
  861321768 => "Chaozhou\,\ Guangdong",
  861321769 => "Dongguan\,\ Guangdong",
  861321770 => "Fangchenggang\,\ Guangxi",
  861321771 => "Nanning\,\ Guangxi",
  861321772 => "Liuzhou\,\ Guangxi",
  861321773 => "Guilin\,\ Guangxi",
  861321774 => "Wuzhou\,\ Guangxi",
  861321775 => "Yulin\,\ Guangxi",
  861321776 => "Baise\,\ Guangxi",
  861321777 => "Qinzhou\,\ Guangxi",
  861321778 => "Hechi\,\ Guangxi",
  861321779 => "Beihai\,\ Guangxi",
  861321780 => "Nanning\,\ Guangxi",
  861321781 => "Nanning\,\ Guangxi",
  861321782 => "Laibin\,\ Guangxi",
  861321783 => "Guilin\,\ Guangxi",
  861321784 => "Hezhou\,\ Guangxi",
  861321785 => "Yulin\,\ Guangxi",
  861321786 => "Baise\,\ Guangxi",
  861321787 => "Liuzhou\,\ Guangxi",
  861321788 => "Hechi\,\ Guangxi",
  861321789 => "Hezhou\,\ Guangxi",
  861321790 => "Xinyu\,\ Jiangxi",
  861321791 => "Nanchang\,\ Jiangxi",
  861321792 => "Jiujiang\,\ Jiangxi",
  861321793 => "Shangrao\,\ Jiangxi",
  861321794 => "Fuzhou\,\ Jiangxi",
  861321795 => "Yichun\,\ Jiangxi",
  861321796 => "JiAn\,\ Jiangxi",
  861321797 => "Ganzhou\,\ Jiangxi",
  861321798 => "Jingdezhen\,\ Jiangxi",
  861321799 => "Pingxiang\,\ Jiangxi",
  86132180 => "Nanjing\,\ Jiangsu",
  86132181 => "Suzhou\,\ Jiangsu",
  86132182 => "Nantong\,\ Jiangsu",
  861321830 => "HuaiAn\,\ Jiangsu",
  861321831 => "HuaiAn\,\ Jiangsu",
  861321832 => "HuaiAn\,\ Jiangsu",
  861321833 => "HuaiAn\,\ Jiangsu",
  861321834 => "Zhenjiang\,\ Jiangsu",
  861321835 => "Zhenjiang\,\ Jiangsu",
  861321836 => "Zhenjiang\,\ Jiangsu",
  861321837 => "Zhenjiang\,\ Jiangsu",
  861321838 => "Zhenjiang\,\ Jiangsu",
  861321839 => "Zhenjiang\,\ Jiangsu",
  861321840 => "Xuzhou\,\ Jiangsu",
  861321841 => "Zhenjiang\,\ Jiangsu",
  861321842 => "Yangzhou\,\ Jiangsu",
  861321843 => "Nantong\,\ Jiangsu",
  861321844 => "Nantong\,\ Jiangsu",
  861321845 => "Suzhou\,\ Jiangsu",
  861321846 => "Suzhou\,\ Jiangsu",
  861321847 => "Changzhou\,\ Jiangsu",
  861321848 => "Nanjing\,\ Jiangsu",
  861321849 => "Nanjing\,\ Jiangsu",
  861321850 => "Yancheng\,\ Jiangsu",
  861321851 => "Yancheng\,\ Jiangsu",
  861321852 => "Yancheng\,\ Jiangsu",
  861321853 => "Xuzhou\,\ Jiangsu",
  861321854 => "Xuzhou\,\ Jiangsu",
  861321855 => "Xuzhou\,\ Jiangsu",
  861321856 => "Xuzhou\,\ Jiangsu",
  861321857 => "Xuzhou\,\ Jiangsu",
  861321858 => "Xuzhou\,\ Jiangsu",
  861321859 => "Xuzhou\,\ Jiangsu",
  861321860 => "Yancheng\,\ Jiangsu",
  861321861 => "Yancheng\,\ Jiangsu",
  861321862 => "Yancheng\,\ Jiangsu",
  861321863 => "Yancheng\,\ Jiangsu",
  861321864 => "Changzhou\,\ Jiangsu",
  861321865 => "Changzhou\,\ Jiangsu",
  861321866 => "Changzhou\,\ Jiangsu",
  861321867 => "Changzhou\,\ Jiangsu",
  861321868 => "Changzhou\,\ Jiangsu",
  861321869 => "Changzhou\,\ Jiangsu",
  861321870 => "Taizhou\,\ Jiangsu",
  861321871 => "Taizhou\,\ Jiangsu",
  861321872 => "Taizhou\,\ Jiangsu",
  861321873 => "Wuxi\,\ Jiangsu",
  861321874 => "Wuxi\,\ Jiangsu",
  861321875 => "Wuxi\,\ Jiangsu",
  861321876 => "Wuxi\,\ Jiangsu",
  861321877 => "Wuxi\,\ Jiangsu",
  861321878 => "Wuxi\,\ Jiangsu",
  861321879 => "Wuxi\,\ Jiangsu",
  861321880 => "Xuzhou\,\ Jiangsu",
  861321881 => "Zhenjiang\,\ Jiangsu",
  861321882 => "Yangzhou\,\ Jiangsu",
  861321883 => "Nantong\,\ Jiangsu",
  861321884 => "HuaiAn\,\ Jiangsu",
  861321885 => "Wuxi\,\ Jiangsu",
  861321886 => "Suzhou\,\ Jiangsu",
  861321887 => "Changzhou\,\ Jiangsu",
  861321888 => "Nanjing\,\ Jiangsu",
  861321889 => "Nanjing\,\ Jiangsu",
  861321890 => "Suqian\,\ Jiangsu",
  861321891 => "Suqian\,\ Jiangsu",
  861321892 => "Suqian\,\ Jiangsu",
  861321893 => "Suqian\,\ Jiangsu",
  861321894 => "Yangzhou\,\ Jiangsu",
  861321895 => "Yangzhou\,\ Jiangsu",
  861321896 => "Yangzhou\,\ Jiangsu",
  861321897 => "Yangzhou\,\ Jiangsu",
  861321898 => "Yangzhou\,\ Jiangsu",
  861321899 => "Yangzhou\,\ Jiangsu",
  86132190 => "Chengdu\,\ Sichuan",
  861321910 => "Nanchong\,\ Sichuan",
  861321911 => "Nanchong\,\ Sichuan",
  861321912 => "Nanchong\,\ Sichuan",
  861321913 => "Nanchong\,\ Sichuan",
  861321914 => "Nanchong\,\ Sichuan",
  861321915 => "Nanchong\,\ Sichuan",
  861321916 => "Dazhou\,\ Sichuan",
  861321917 => "Dazhou\,\ Sichuan",
  861321918 => "Dazhou\,\ Sichuan",
  861321919 => "Dazhou\,\ Sichuan",
  861321920 => "Suining\,\ Sichuan",
  861321921 => "Suining\,\ Sichuan",
  861321922 => "Suining\,\ Sichuan",
  861321923 => "Suining\,\ Sichuan",
  861321924 => "GuangAn\,\ Sichuan",
  861321925 => "GuangAn\,\ Sichuan",
  861321926 => "GuangAn\,\ Sichuan",
  861321927 => "GuangAn\,\ Sichuan",
  861321928 => "Bazhong\,\ Sichuan",
  861321929 => "Bazhong\,\ Sichuan",
  861321930 => "Bazhong\,\ Sichuan",
  861321931 => "Bazhong\,\ Sichuan",
  861321932 => "Bazhong\,\ Sichuan",
  861321933 => "Luzhou\,\ Sichuan",
  861321934 => "Luzhou\,\ Sichuan",
  861321935 => "Luzhou\,\ Sichuan",
  861321936 => "Luzhou\,\ Sichuan",
  861321937 => "Luzhou\,\ Sichuan",
  861321938 => "Luzhou\,\ Sichuan",
  861321939 => "Yibin\,\ Sichuan",
  861321940 => "Nanchong\,\ Sichuan",
  861321941 => "Dazhou\,\ Sichuan",
  861321942 => "Neijiang\,\ Sichuan",
  861321943 => "Ziyang\,\ Sichuan",
  861321944 => "Leshan\,\ Sichuan",
  861321945 => "Meishan\,\ Sichuan",
  861321946 => "Garze\,\ Sichuan",
  861321947 => "Deyang\,\ Sichuan",
  861321948 => "Mianyang\,\ Sichuan",
  861321949 => "Guangyuan\,\ Sichuan",
  861321950 => "Yibin\,\ Sichuan",
  861321951 => "Yibin\,\ Sichuan",
  861321952 => "Yibin\,\ Sichuan",
  861321953 => "Yibin\,\ Sichuan",
  861321954 => "Yibin\,\ Sichuan",
  861321955 => "Neijiang\,\ Sichuan",
  861321956 => "Neijiang\,\ Sichuan",
  861321957 => "Neijiang\,\ Sichuan",
  861321958 => "Neijiang\,\ Sichuan",
  861321959 => "Ziyang\,\ Sichuan",
  861321960 => "Yulin\,\ Shaanxi",
  861321961 => "Yulin\,\ Shaanxi",
  861321962 => "Yulin\,\ Shaanxi",
  861321963 => "Zigong\,\ Sichuan",
  861321964 => "Zigong\,\ Sichuan",
  861321965 => "Zigong\,\ Sichuan",
  861321966 => "Zigong\,\ Sichuan",
  861321967 => "Leshan\,\ Sichuan",
  861321968 => "Leshan\,\ Sichuan",
  861321969 => "Leshan\,\ Sichuan",
  861321970 => "Leshan\,\ Sichuan",
  861321971 => "Leshan\,\ Sichuan",
  861321972 => "Leshan\,\ Sichuan",
  861321973 => "Meishan\,\ Sichuan",
  861321974 => "Meishan\,\ Sichuan",
  861321975 => "Meishan\,\ Sichuan",
  861321976 => "Meishan\,\ Sichuan",
  861321977 => "Hanzhong\,\ Shaanxi",
  861321978 => "YaAn\,\ Sichuan",
  861321979 => "Panzhihua\,\ Sichuan",
  861321980 => "Panzhihua\,\ Sichuan",
  861321981 => "Panzhihua\,\ Sichuan",
  861321982 => "Weinan\,\ Shaanxi",
  861321983 => "Yibin\,\ Sichuan",
  861321984 => "Aba\,\ Sichuan",
  861321985 => "Deyang\,\ Sichuan",
  861321986 => "Deyang\,\ Sichuan",
  861321987 => "Deyang\,\ Sichuan",
  861321988 => "Deyang\,\ Sichuan",
  861321989 => "Deyang\,\ Sichuan",
  861321990 => "Guangyuan\,\ Sichuan",
  861321991 => "Guangyuan\,\ Sichuan",
  861321992 => "Guangyuan\,\ Sichuan",
  861321993 => "Mianyang\,\ Sichuan",
  861321994 => "Mianyang\,\ Sichuan",
  861321995 => "Mianyang\,\ Sichuan",
  861321996 => "Mianyang\,\ Sichuan",
  861321997 => "Mianyang\,\ Sichuan",
  861321998 => "Mianyang\,\ Sichuan",
  861321999 => "Mianyang\,\ Sichuan",
  861322000 => "Xianyang\,\ Shaanxi",
  861322001 => "YanAn\,\ Shaanxi",
  861322002 => "Yulin\,\ Shaanxi",
  861322003 => "Weinan\,\ Shaanxi",
  861322004 => "Weinan\,\ Shaanxi",
  861322005 => "Weinan\,\ Shaanxi",
  861322006 => "YanAn\,\ Shaanxi",
  861322007 => "Baoji\,\ Shaanxi",
  861322008 => "YanAn\,\ Shaanxi",
  861322009 => "Baoji\,\ Shaanxi",
  86132201 => "Beijing",
  86132202 => "Chongqing",
  86132203 => "Chongqing",
  861322040 => "Lanzhou\,\ Gansu",
  861322041 => "Baiyin\,\ Gansu",
  861322042 => "Pingliang\,\ Gansu",
  861322043 => "Tianshui\,\ Gansu",
  861322044 => "Zhangye\,\ Gansu",
  861322045 => "Lanzhou\,\ Gansu",
  861322046 => "Lanzhou\,\ Gansu",
  861322047 => "Linxia\,\ Gansu",
  861322048 => "Lanzhou\,\ Gansu",
  861322049 => "Linxia\,\ Gansu",
  861322050 => "Dongying\,\ Shandong",
  861322051 => "Dongying\,\ Shandong",
  861322052 => "Dongying\,\ Shandong",
  861322053 => "Linyi\,\ Shandong",
  861322054 => "Linyi\,\ Shandong",
  861322055 => "Jinan\,\ Shandong",
  861322056 => "Jinan\,\ Shandong",
  861322057 => "Jinan\,\ Shandong",
  861322058 => "Jinan\,\ Shandong",
  861322059 => "Jinan\,\ Shandong",
  861322060 => "Laiwu\,\ Shandong",
  861322061 => "TaiAn\,\ Shandong",
  861322062 => "TaiAn\,\ Shandong",
  861322063 => "Rizhao\,\ Shandong",
  861322064 => "Rizhao\,\ Shandong",
  861322065 => "Linyi\,\ Shandong",
  861322066 => "Linyi\,\ Shandong",
  861322067 => "Zibo\,\ Shandong",
  861322068 => "Zibo\,\ Shandong",
  861322069 => "Zibo\,\ Shandong",
  861322070 => "Binzhou\,\ Shandong",
  861322071 => "Binzhou\,\ Shandong",
  861322072 => "Binzhou\,\ Shandong",
  861322073 => "Weifang\,\ Shandong",
  861322074 => "Weifang\,\ Shandong",
  861322075 => "Weifang\,\ Shandong",
  861322076 => "Weifang\,\ Shandong",
  861322077 => "Zaozhuang\,\ Shandong",
  861322078 => "Zaozhuang\,\ Shandong",
  861322079 => "Jining\,\ Shandong",
  861322080 => "Jining\,\ Shandong",
  861322081 => "Jining\,\ Shandong",
  861322082 => "Weihai\,\ Shandong",
  861322083 => "Weihai\,\ Shandong",
  861322084 => "Weihai\,\ Shandong",
  861322085 => "Qingdao\,\ Shandong",
  861322086 => "Qingdao\,\ Shandong",
  861322087 => "Qingdao\,\ Shandong",
  861322088 => "Qingdao\,\ Shandong",
  861322089 => "Qingdao\,\ Shandong",
  861322090 => "Weihai\,\ Shandong",
  861322091 => "Yantai\,\ Shandong",
  861322092 => "Yantai\,\ Shandong",
  861322093 => "Yantai\,\ Shandong",
  861322094 => "Yantai\,\ Shandong",
  861322095 => "Liaocheng\,\ Shandong",
  861322096 => "Liaocheng\,\ Shandong",
  861322097 => "Dezhou\,\ Shandong",
  861322098 => "Dezhou\,\ Shandong",
  861322099 => "Dezhou\,\ Shandong",
  86132210 => "Hangzhou\,\ Zhejiang",
  86132211 => "Wenzhou\,\ Zhejiang",
  861322120 => "Huzhou\,\ Zhejiang",
  861322121 => "Huzhou\,\ Zhejiang",
  861322122 => "Huzhou\,\ Zhejiang",
  861322123 => "Huzhou\,\ Zhejiang",
  861322124 => "Huzhou\,\ Zhejiang",
  861322125 => "Jinhua\,\ Zhejiang",
  861322126 => "Jinhua\,\ Zhejiang",
  861322127 => "Jinhua\,\ Zhejiang",
  861322128 => "Jinhua\,\ Zhejiang",
  861322129 => "Jinhua\,\ Zhejiang",
  86132213 => "Jiaxing\,\ Zhejiang",
  861322140 => "Hangzhou\,\ Zhejiang",
  861322141 => "Hangzhou\,\ Zhejiang",
  861322142 => "Ningbo\,\ Zhejiang",
  861322143 => "Jiaxing\,\ Zhejiang",
  861322144 => "Ningbo\,\ Zhejiang",
  861322145 => "Taizhou\,\ Zhejiang",
  861322146 => "Taizhou\,\ Zhejiang",
  861322147 => "Wenzhou\,\ Zhejiang",
  861322148 => "Lishui\,\ Zhejiang",
  861322149 => "Jinhua\,\ Zhejiang",
  86132215 => "Shaoxing\,\ Zhejiang",
  86132216 => "Taizhou\,\ Zhejiang",
  861322170 => "Quzhou\,\ Zhejiang",
  861322171 => "Quzhou\,\ Zhejiang",
  861322172 => "Quzhou\,\ Zhejiang",
  861322173 => "Zhoushan\,\ Zhejiang",
  861322174 => "Zhoushan\,\ Zhejiang",
  861322175 => "Zhoushan\,\ Zhejiang",
  861322176 => "Lishui\,\ Zhejiang",
  861322177 => "Lishui\,\ Zhejiang",
  861322178 => "Lishui\,\ Zhejiang",
  861322179 => "Lishui\,\ Zhejiang",
  861322180 => "Hangzhou\,\ Zhejiang",
  861322181 => "Hangzhou\,\ Zhejiang",
  861322182 => "Hangzhou\,\ Zhejiang",
  861322183 => "Hangzhou\,\ Zhejiang",
  861322184 => "Jiaxing\,\ Zhejiang",
  861322185 => "Wenzhou\,\ Zhejiang",
  861322186 => "Wenzhou\,\ Zhejiang",
  861322187 => "Ningbo\,\ Zhejiang",
  861322188 => "Ningbo\,\ Zhejiang",
  861322189 => "Ningbo\,\ Zhejiang",
  86132219 => "Ningbo\,\ Zhejiang",
  86132220 => "Nanjing\,\ Jiangsu",
  86132221 => "Nantong\,\ Jiangsu",
  86132222 => "Suzhou\,\ Jiangsu",
  861322230 => "Yangzhou\,\ Jiangsu",
  861322231 => "Yangzhou\,\ Jiangsu",
  861322232 => "Yancheng\,\ Jiangsu",
  861322233 => "Yancheng\,\ Jiangsu",
  861322234 => "Yancheng\,\ Jiangsu",
  861322235 => "Yancheng\,\ Jiangsu",
  861322236 => "Yancheng\,\ Jiangsu",
  861322237 => "Yancheng\,\ Jiangsu",
  861322238 => "Yancheng\,\ Jiangsu",
  861322239 => "Yancheng\,\ Jiangsu",
  861322240 => "Wuxi\,\ Jiangsu",
  861322241 => "Zhenjiang\,\ Jiangsu",
  861322242 => "Suzhou\,\ Jiangsu",
  861322243 => "Nanjing\,\ Jiangsu",
  861322244 => "Nanjing\,\ Jiangsu",
  861322245 => "Yancheng\,\ Jiangsu",
  861322246 => "Xuzhou\,\ Jiangsu",
  861322247 => "Changzhou\,\ Jiangsu",
  861322248 => "Taizhou\,\ Jiangsu",
  861322249 => "Nantong\,\ Jiangsu",
  861322250 => "Changzhou\,\ Jiangsu",
  861322251 => "Changzhou\,\ Jiangsu",
  861322252 => "Changzhou\,\ Jiangsu",
  861322253 => "Changzhou\,\ Jiangsu",
  861322254 => "Shaoyang\,\ Hunan",
  861322255 => "Changzhou\,\ Jiangsu",
  861322256 => "Changzhou\,\ Jiangsu",
  861322257 => "Changzhou\,\ Jiangsu",
  861322258 => "Changzhou\,\ Jiangsu",
  861322259 => "Changzhou\,\ Jiangsu",
  861322260 => "Zhenjiang\,\ Jiangsu",
  861322261 => "Zhenjiang\,\ Jiangsu",
  861322262 => "Zhenjiang\,\ Jiangsu",
  861322263 => "Zhenjiang\,\ Jiangsu",
  861322264 => "Zhenjiang\,\ Jiangsu",
  861322265 => "Zhenjiang\,\ Jiangsu",
  861322266 => "Yangzhou\,\ Jiangsu",
  861322267 => "Yangzhou\,\ Jiangsu",
  861322268 => "Yangzhou\,\ Jiangsu",
  861322269 => "Yangzhou\,\ Jiangsu",
  861322270 => "HuaiAn\,\ Jiangsu",
  861322271 => "HuaiAn\,\ Jiangsu",
  861322272 => "Nanjing\,\ Jiangsu",
  861322273 => "Nanjing\,\ Jiangsu",
  861322274 => "Nanjing\,\ Jiangsu",
  861322275 => "Nanjing\,\ Jiangsu",
  861322276 => "Nanjing\,\ Jiangsu",
  861322277 => "Nanjing\,\ Jiangsu",
  861322278 => "Nanjing\,\ Jiangsu",
  861322279 => "Nanjing\,\ Jiangsu",
  86132228 => "Wuxi\,\ Jiangsu",
  861322290 => "Wuxi\,\ Jiangsu",
  861322291 => "Wuxi\,\ Jiangsu",
  861322292 => "Wuxi\,\ Jiangsu",
  861322293 => "Wuxi\,\ Jiangsu",
  861322294 => "Wuxi\,\ Jiangsu",
  861322295 => "Suzhou\,\ Jiangsu",
  861322296 => "Suzhou\,\ Jiangsu",
  861322297 => "Suzhou\,\ Jiangsu",
  861322298 => "Suzhou\,\ Jiangsu",
  861322299 => "Suzhou\,\ Jiangsu",
  861322300 => "Shangqiu\,\ Henan",
  861322301 => "Zhengzhou\,\ Henan",
  861322302 => "Zhengzhou\,\ Henan",
  861322303 => "Zhengzhou\,\ Henan",
  861322304 => "Zhengzhou\,\ Henan",
  861322305 => "Zhengzhou\,\ Henan",
  861322306 => "Zhengzhou\,\ Henan",
  861322307 => "Zhengzhou\,\ Henan",
  861322308 => "Zhengzhou\,\ Henan",
  861322309 => "Zhengzhou\,\ Henan",
  861322310 => "Handan\,\ Hebei",
  861322311 => "Handan\,\ Hebei",
  861322312 => "Handan\,\ Hebei",
  861322313 => "Handan\,\ Hebei",
  861322314 => "Handan\,\ Hebei",
  861322315 => "Tangshan\,\ Hebei",
  861322316 => "Tangshan\,\ Hebei",
  861322317 => "Tangshan\,\ Hebei",
  861322318 => "Tangshan\,\ Hebei",
  861322319 => "Tangshan\,\ Hebei",
  861322320 => "Baoding\,\ Hebei",
  861322321 => "Baoding\,\ Hebei",
  861322322 => "Baoding\,\ Hebei",
  861322323 => "Baoding\,\ Hebei",
  861322324 => "Baoding\,\ Hebei",
  861322325 => "Xingtai\,\ Hebei",
  861322326 => "Xingtai\,\ Hebei",
  861322327 => "Xingtai\,\ Hebei",
  861322328 => "Xingtai\,\ Hebei",
  861322329 => "Xingtai\,\ Hebei",
  86132233 => "Qinhuangdao\,\ Hebei",
  86132234 => "Shijiazhuang\,\ Hebei",
  861322350 => "Xinzhou\,\ Shanxi",
  861322351 => "Taiyuan\,\ Shanxi",
  861322352 => "Datong\,\ Shanxi",
  861322353 => "Yangquan\,\ Shanxi",
  861322354 => "Jinzhong\,\ Shanxi",
  861322355 => "Changzhi\,\ Shanxi",
  861322356 => "Jincheng\,\ Shanxi",
  861322357 => "Linfen\,\ Shanxi",
  861322358 => "Lüliang\,\ Shanxi",
  861322359 => "Yuncheng\,\ Shanxi",
  861322360 => "Xinzhou\,\ Shanxi",
  861322361 => "Shuozhou\,\ Shanxi",
  861322362 => "Datong\,\ Shanxi",
  861322363 => "Yangquan\,\ Shanxi",
  861322364 => "Taiyuan\,\ Shanxi",
  861322365 => "Changzhi\,\ Shanxi",
  861322366 => "Jinzhong\,\ Shanxi",
  861322367 => "Jincheng\,\ Shanxi",
  861322368 => "Linfen\,\ Shanxi",
  861322369 => "Yuncheng\,\ Shanxi",
  861322370 => "Shangqiu\,\ Henan",
  861322371 => "Zhengzhou\,\ Henan",
  861322372 => "Anyang\,\ Henan",
  861322373 => "Xinxiang\,\ Henan",
  861322374 => "Xinxiang\,\ Henan",
  861322375 => "Xinxiang\,\ Henan",
  861322376 => "Xinxiang\,\ Henan",
  861322377 => "Xinxiang\,\ Henan",
  861322378 => "Kaifeng\,\ Henan",
  861322379 => "Kaifeng\,\ Henan",
  861322380 => "Kaifeng\,\ Henan",
  861322381 => "Zhumadian\,\ Henan",
  861322382 => "Zhumadian\,\ Henan",
  861322383 => "Zhumadian\,\ Henan",
  861322384 => "Zhumadian\,\ Henan",
  861322385 => "Zhumadian\,\ Henan",
  861322386 => "Zhumadian\,\ Henan",
  861322387 => "Zhumadian\,\ Henan",
  861322388 => "Zhumadian\,\ Henan",
  861322389 => "Zhumadian\,\ Henan",
  861322390 => "Shangqiu\,\ Henan",
  861322391 => "Jiaozuo\,\ Henan",
  861322392 => "Jiaozuo\,\ Henan",
  861322393 => "Puyang\,\ Henan",
  861322394 => "Zhoukou\,\ Henan",
  861322395 => "Zhoukou\,\ Henan",
  861322396 => "Zhumadian\,\ Henan",
  861322397 => "Puyang\,\ Henan",
  861322398 => "Puyang\,\ Henan",
  861322399 => "Anyang\,\ Henan",
  86132240 => "Chongqing",
  861322410 => "Tieling\,\ Liaoning",
  861322411 => "Dalian\,\ Liaoning",
  861322412 => "Anshan\,\ Liaoning",
  861322413 => "Fushun\,\ Liaoning",
  861322414 => "Benxi\,\ Liaoning",
  861322415 => "Dandong\,\ Liaoning",
  861322416 => "Jinzhou\,\ Liaoning",
  861322417 => "Yingkou\,\ Liaoning",
  861322418 => "Fuxin\,\ Liaoning",
  861322419 => "Liaoyang\,\ Liaoning",
  861322420 => "Dalian\,\ Liaoning",
  861322421 => "Chaoyang\,\ Liaoning",
  861322422 => "Dalian\,\ Liaoning",
  861322423 => "Shenyang\,\ Liaoning",
  861322424 => "Shenyang\,\ Liaoning",
  861322425 => "Shenyang\,\ Liaoning",
  861322426 => "Shenyang\,\ Liaoning",
  861322427 => "Panjin\,\ Liaoning",
  861322428 => "Dalian\,\ Liaoning",
  861322429 => "Huludao\,\ Liaoning",
  861322430 => "Changchun\,\ Jilin",
  861322431 => "Changchun\,\ Jilin",
  861322432 => "Jilin\,\ Jilin",
  861322433 => "Yanbian\,\ Jilin",
  861322434 => "Siping\,\ Jilin",
  861322435 => "Tonghua\,\ Jilin",
  861322436 => "Baicheng\,\ Jilin",
  861322437 => "Liaoyuan\,\ Jilin",
  861322438 => "Songyuan\,\ Jilin",
  861322439 => "Baishan\,\ Jilin",
  861322440 => "Siping\,\ Jilin",
  861322441 => "Siping\,\ Jilin",
  861322442 => "Jilin\,\ Jilin",
  861322443 => "Yanbian\,\ Jilin",
  861322444 => "Siping\,\ Jilin",
  861322445 => "Tonghua\,\ Jilin",
  861322446 => "Baicheng\,\ Jilin",
  861322447 => "Liaoyuan\,\ Jilin",
  861322448 => "Songyuan\,\ Jilin",
  861322449 => "Baishan\,\ Jilin",
  861322450 => "Harbin\,\ Heilongjiang",
  861322451 => "Harbin\,\ Heilongjiang",
  861322452 => "Qiqihar\,\ Heilongjiang",
  861322453 => "Mudanjiang\,\ Heilongjiang",
  861322454 => "Jiamusi\,\ Heilongjiang",
  861322455 => "Suihua\,\ Heilongjiang",
  861322456 => "Heihe\,\ Heilongjiang",
  861322457 => "Daqing\,\ Heilongjiang",
  861322458 => "Daqing\,\ Heilongjiang",
  861322459 => "Daqing\,\ Heilongjiang",
  861322460 => "Harbin\,\ Heilongjiang",
  861322461 => "Harbin\,\ Heilongjiang",
  861322462 => "Qiqihar\,\ Heilongjiang",
  861322463 => "Mudanjiang\,\ Heilongjiang",
  861322464 => "Jiamusi\,\ Heilongjiang",
  861322465 => "Suihua\,\ Heilongjiang",
  861322466 => "Jiamusi\,\ Heilongjiang",
  861322467 => "Jixi\,\ Heilongjiang",
  861322468 => "Hegang\,\ Heilongjiang",
  861322469 => "Shuangyashan\,\ Heilongjiang",
  861322470 => "Baotou\,\ Inner\ Mongolia",
  861322471 => "Baotou\,\ Inner\ Mongolia",
  861322472 => "Baotou\,\ Inner\ Mongolia",
  861322473 => "Wuhai\,\ Inner\ Mongolia",
  861322474 => "Hinggan\,\ Inner\ Mongolia",
  861322475 => "Tongliao\,\ Inner\ Mongolia",
  861322476 => "Tongliao\,\ Inner\ Mongolia",
  861322477 => "Ordos\,\ Inner\ Mongolia",
  861322478 => "Bayannur\,\ Inner\ Mongolia",
  861322479 => "Hinggan\,\ Inner\ Mongolia",
  861322480 => "Wuhai\,\ Inner\ Mongolia",
  861322481 => "Hinggan\,\ Inner\ Mongolia",
  861322482 => "Hinggan\,\ Inner\ Mongolia",
  861322483 => "Hinggan\,\ Inner\ Mongolia",
  861322484 => "Tongliao\,\ Inner\ Mongolia",
  861322485 => "Baotou\,\ Inner\ Mongolia",
  861322486 => "Baotou\,\ Inner\ Mongolia",
  861322487 => "Baotou\,\ Inner\ Mongolia",
  861322488 => "Bayannur\,\ Inner\ Mongolia",
  861322489 => "Bayannur\,\ Inner\ Mongolia",
  86132249 => "Chongqing",
  861322500 => "Quanzhou\,\ Fujian",
  861322501 => "Zhangzhou\,\ Fujian",
  861322502 => "Sanming\,\ Fujian",
  861322503 => "Xiamen\,\ Fujian",
  861322504 => "Ningde\,\ Fujian",
  861322505 => "Sanming\,\ Fujian",
  861322506 => "Putian\,\ Fujian",
  861322507 => "Xiamen\,\ Fujian",
  861322508 => "Xiamen\,\ Fujian",
  861322509 => "Putian\,\ Fujian",
  861322510 => "Wuxi\,\ Jiangsu",
  861322511 => "Zhenjiang\,\ Jiangsu",
  861322512 => "Suzhou\,\ Jiangsu",
  861322513 => "Nantong\,\ Jiangsu",
  861322514 => "Yangzhou\,\ Jiangsu",
  861322515 => "Yancheng\,\ Jiangsu",
  861322516 => "Xuzhou\,\ Jiangsu",
  861322517 => "HuaiAn\,\ Jiangsu",
  861322518 => "Lianyungang\,\ Jiangsu",
  861322519 => "Changzhou\,\ Jiangsu",
  861322520 => "Lianyungang\,\ Jiangsu",
  861322521 => "Lianyungang\,\ Jiangsu",
  861322522 => "Xuzhou\,\ Jiangsu",
  861322523 => "Xuzhou\,\ Jiangsu",
  861322524 => "Xuzhou\,\ Jiangsu",
  861322525 => "Xuzhou\,\ Jiangsu",
  861322526 => "Xuzhou\,\ Jiangsu",
  861322527 => "Xuzhou\,\ Jiangsu",
  861322528 => "Xuzhou\,\ Jiangsu",
  861322529 => "Xuzhou\,\ Jiangsu",
  861322530 => "Heze\,\ Shandong",
  861322531 => "Jinan\,\ Shandong",
  861322532 => "Qingdao\,\ Shandong",
  861322533 => "Zibo\,\ Shandong",
  861322534 => "Dezhou\,\ Shandong",
  861322535 => "Yantai\,\ Shandong",
  861322536 => "Weifang\,\ Shandong",
  861322537 => "Jining\,\ Shandong",
  861322538 => "TaiAn\,\ Shandong",
  861322539 => "Linyi\,\ Shandong",
  861322540 => "Heze\,\ Shandong",
  861322541 => "Jinan\,\ Shandong",
  861322542 => "Qingdao\,\ Shandong",
  861322543 => "Binzhou\,\ Shandong",
  861322544 => "Dezhou\,\ Shandong",
  861322545 => "Yantai\,\ Shandong",
  861322546 => "Dongying\,\ Shandong",
  861322547 => "Jining\,\ Shandong",
  861322548 => "TaiAn\,\ Shandong",
  861322549 => "Linyi\,\ Shandong",
  861322550 => "Chuzhou\,\ Anhui",
  861322551 => "Hefei\,\ Anhui",
  861322552 => "Bengbu\,\ Anhui",
  861322553 => "Wuhu\,\ Anhui",
  861322554 => "Huainan\,\ Anhui",
  861322555 => "MaAnshan\,\ Anhui",
  861322556 => "Anqing\,\ Anhui",
  861322557 => "Suzhou\,\ Anhui",
  861322558 => "Fuyang\,\ Anhui",
  861322559 => "Huangshan\,\ Anhui",
  861322560 => "Hefei\,\ Anhui",
  861322561 => "Huaibei\,\ Anhui",
  861322562 => "Tongling\,\ Anhui",
  861322563 => "Xuancheng\,\ Anhui",
  861322564 => "LuAn\,\ Anhui",
  861322565 => "Hefei\,\ Anhui",
  861322566 => "Chizhou\,\ Anhui",
  861322567 => "Bozhou\,\ Anhui",
  861322568 => "Fuyang\,\ Anhui",
  861322569 => "Hefei\,\ Anhui",
  861322570 => "Anqing\,\ Anhui",
  861322571 => "Anqing\,\ Anhui",
  861322572 => "Anqing\,\ Anhui",
  861322573 => "Anqing\,\ Anhui",
  861322574 => "Anqing\,\ Anhui",
  861322575 => "Hefei\,\ Anhui",
  861322576 => "Anqing\,\ Anhui",
  861322577 => "Suzhou\,\ Anhui",
  861322578 => "Anqing\,\ Anhui",
  861322579 => "Huangshan\,\ Anhui",
  861322580 => "LuAn\,\ Anhui",
  861322581 => "LuAn\,\ Anhui",
  861322582 => "LuAn\,\ Anhui",
  861322583 => "LuAn\,\ Anhui",
  861322584 => "LuAn\,\ Anhui",
  861322585 => "Hefei\,\ Anhui",
  861322586 => "LuAn\,\ Anhui",
  861322587 => "Bozhou\,\ Anhui",
  861322588 => "LuAn\,\ Anhui",
  861322589 => "Hefei\,\ Anhui",
  861322590 => "Nanping\,\ Fujian",
  861322591 => "Fuzhou\,\ Fujian",
  861322592 => "Xiamen\,\ Fujian",
  861322593 => "Longyan\,\ Fujian",
  861322594 => "Fuzhou\,\ Fujian",
  861322595 => "Quanzhou\,\ Fujian",
  861322596 => "Xiamen\,\ Fujian",
  861322597 => "Nanping\,\ Fujian",
  861322598 => "Quanzhou\,\ Fujian",
  861322599 => "Fuzhou\,\ Fujian",
  861322600 => "Zhuhai\,\ Guangdong",
  861322601 => "Zhuhai\,\ Guangdong",
  861322602 => "Zhuhai\,\ Guangdong",
  861322603 => "Zhuhai\,\ Guangdong",
  861322604 => "Zhuhai\,\ Guangdong",
  861322605 => "Zhuhai\,\ Guangdong",
  861322606 => "Zhongshan\,\ Guangdong",
  861322607 => "Zhongshan\,\ Guangdong",
  861322608 => "Zhongshan\,\ Guangdong",
  861322609 => "Zhongshan\,\ Guangdong",
  861322610 => "Chaozhou\,\ Guangdong",
  861322611 => "Chaozhou\,\ Guangdong",
  861322612 => "Chaozhou\,\ Guangdong",
  861322613 => "Chaozhou\,\ Guangdong",
  861322614 => "Chaozhou\,\ Guangdong",
  861322615 => "Jieyang\,\ Guangdong",
  861322616 => "Jieyang\,\ Guangdong",
  861322617 => "Jieyang\,\ Guangdong",
  861322618 => "Jieyang\,\ Guangdong",
  861322619 => "Jieyang\,\ Guangdong",
  861322620 => "Meizhou\,\ Guangdong",
  861322621 => "Meizhou\,\ Guangdong",
  861322622 => "Zhanjiang\,\ Guangdong",
  861322623 => "Zhanjiang\,\ Guangdong",
  861322624 => "Zhanjiang\,\ Guangdong",
  861322625 => "Zhanjiang\,\ Guangdong",
  861322626 => "Zhanjiang\,\ Guangdong",
  861322627 => "Maoming\,\ Guangdong",
  861322628 => "Maoming\,\ Guangdong",
  861322629 => "Maoming\,\ Guangdong",
  861322630 => "Huizhou\,\ Guangdong",
  861322631 => "Huizhou\,\ Guangdong",
  861322632 => "Huizhou\,\ Guangdong",
  861322633 => "Huizhou\,\ Guangdong",
  861322634 => "Huizhou\,\ Guangdong",
  861322635 => "Shijiazhuang\,\ Hebei",
  861322636 => "Yunfu\,\ Guangdong",
  861322637 => "Yangjiang\,\ Guangdong",
  861322638 => "Yangjiang\,\ Guangdong",
  861322639 => "Yangjiang\,\ Guangdong",
  861322640 => "Guangzhou\,\ Guangdong",
  861322641 => "Guangzhou\,\ Guangdong",
  861322642 => "Guangzhou\,\ Guangdong",
  861322643 => "Guangzhou\,\ Guangdong",
  861322644 => "Guangzhou\,\ Guangdong",
  861322645 => "Guangzhou\,\ Guangdong",
  861322646 => "Jiangmen\,\ Guangdong",
  861322647 => "Jiangmen\,\ Guangdong",
  861322648 => "Zhuhai\,\ Guangdong",
  861322649 => "Zhuhai\,\ Guangdong",
  861322650 => "Shaoguan\,\ Guangdong",
  861322651 => "Shaoguan\,\ Guangdong",
  861322652 => "Shaoguan\,\ Guangdong",
  861322653 => "Shaoguan\,\ Guangdong",
  861322654 => "Shaoguan\,\ Guangdong",
  861322655 => "Qingyuan\,\ Guangdong",
  861322656 => "Qingyuan\,\ Guangdong",
  861322657 => "Qingyuan\,\ Guangdong",
  861322658 => "Qingyuan\,\ Guangdong",
  861322659 => "Qingyuan\,\ Guangdong",
  86132266 => "Guangzhou\,\ Guangdong",
  861322670 => "Foshan\,\ Guangdong",
  861322671 => "Foshan\,\ Guangdong",
  861322672 => "Foshan\,\ Guangdong",
  861322673 => "Foshan\,\ Guangdong",
  861322674 => "Shanwei\,\ Guangdong",
  861322675 => "Shanwei\,\ Guangdong",
  861322676 => "Heyuan\,\ Guangdong",
  861322677 => "Zhaoqing\,\ Guangdong",
  861322678 => "Zhaoqing\,\ Guangdong",
  861322679 => "Zhaoqing\,\ Guangdong",
  861322680 => "Shantou\,\ Guangdong",
  861322681 => "Shantou\,\ Guangdong",
  861322682 => "Shantou\,\ Guangdong",
  861322683 => "Shantou\,\ Guangdong",
  861322684 => "Shantou\,\ Guangdong",
  861322685 => "Shenzhen\,\ Guangdong",
  861322686 => "Shenzhen\,\ Guangdong",
  861322687 => "Shenzhen\,\ Guangdong",
  861322688 => "Shanwei\,\ Guangdong",
  861322689 => "Heyuan\,\ Guangdong",
  861322690 => "Jiangmen\,\ Guangdong",
  861322691 => "Jiangmen\,\ Guangdong",
  861322692 => "Jiangmen\,\ Guangdong",
  861322693 => "Jiangmen\,\ Guangdong",
  861322694 => "Jiangmen\,\ Guangdong",
  861322695 => "Jiangmen\,\ Guangdong",
  861322696 => "Foshan\,\ Guangdong",
  861322697 => "Foshan\,\ Guangdong",
  861322698 => "Foshan\,\ Guangdong",
  861322699 => "Foshan\,\ Guangdong",
  86132270 => "XiAn\,\ Shaanxi",
  861322710 => "Ezhou\,\ Hubei",
  861322711 => "Ezhou\,\ Hubei",
  861322712 => "Xiaogan\,\ Hubei",
  861322713 => "Xiaogan\,\ Hubei",
  861322714 => "Xiaogan\,\ Hubei",
  861322715 => "Xiaogan\,\ Hubei",
  861322716 => "Xiaogan\,\ Hubei",
  861322717 => "Xiaogan\,\ Hubei",
  861322718 => "Xiaogan\,\ Hubei",
  861322719 => "Xiaogan\,\ Hubei",
  861322720 => "Xianning\,\ Hubei",
  861322721 => "Xianning\,\ Hubei",
  861322722 => "Suizhou\,\ Hubei",
  861322723 => "Xianning\,\ Hubei",
  861322724 => "Shiyan\,\ Hubei",
  861322725 => "Yichang\,\ Hubei",
  861322726 => "Yichang\,\ Hubei",
  861322727 => "Yichang\,\ Hubei",
  861322728 => "Yichang\,\ Hubei",
  861322729 => "Yichang\,\ Hubei",
  861322730 => "Xiaogan\,\ Hubei",
  861322731 => "Huanggang\,\ Hubei",
  861322732 => "Huanggang\,\ Hubei",
  861322733 => "Huanggang\,\ Hubei",
  861322734 => "Huanggang\,\ Hubei",
  861322735 => "Huanggang\,\ Hubei",
  861322736 => "Huanggang\,\ Hubei",
  861322737 => "Huanggang\,\ Hubei",
  861322738 => "Huanggang\,\ Hubei",
  861322739 => "Huanggang\,\ Hubei",
  86132274 => "Enshi\,\ Hubei",
  86132275 => "Xiangfan\,\ Hubei",
  861322760 => "Shiyan\,\ Hubei",
  861322761 => "Shiyan\,\ Hubei",
  861322762 => "Jingzhou\,\ Hubei",
  861322763 => "Jingzhou\,\ Hubei",
  861322764 => "Jingzhou\,\ Hubei",
  861322765 => "Jingzhou\,\ Hubei",
  861322766 => "Jingzhou\,\ Hubei",
  861322767 => "Jingzhou\,\ Hubei",
  861322768 => "Jingzhou\,\ Hubei",
  861322769 => "Jingzhou\,\ Hubei",
  86132277 => "XiAn\,\ Shaanxi",
  86132278 => "XiAn\,\ Shaanxi",
  861322790 => "Xianyang\,\ Shaanxi",
  861322791 => "YanAn\,\ Shaanxi",
  861322792 => "Yulin\,\ Shaanxi",
  861322793 => "Weinan\,\ Shaanxi",
  861322794 => "Xianyang\,\ Shaanxi",
  861322795 => "Xianyang\,\ Shaanxi",
  861322796 => "YanAn\,\ Shaanxi",
  861322797 => "Baoji\,\ Shaanxi",
  861322798 => "YanAn\,\ Shaanxi",
  861322799 => "Yulin\,\ Shaanxi",
  86132280 => "XiAn\,\ Shaanxi",
  86132281 => "Chengdu\,\ Sichuan",
  861322820 => "Chengdu\,\ Sichuan",
  861322821 => "Chengdu\,\ Sichuan",
  861322822 => "Chengdu\,\ Sichuan",
  861322823 => "Mianyang\,\ Sichuan",
  861322824 => "Mianyang\,\ Sichuan",
  861322825 => "Nanchong\,\ Sichuan",
  861322826 => "Nanchong\,\ Sichuan",
  861322827 => "Dazhou\,\ Sichuan",
  861322828 => "Dazhou\,\ Sichuan",
  861322829 => "Weinan\,\ Shaanxi",
  861322830 => "GuangAn\,\ Sichuan",
  861322831 => "Yibin\,\ Sichuan",
  861322832 => "Yibin\,\ Sichuan",
  861322833 => "Deyang\,\ Sichuan",
  861322834 => "Bazhong\,\ Sichuan",
  861322835 => "Neijiang\,\ Sichuan",
  861322836 => "Yulin\,\ Shaanxi",
  861322837 => "Luzhou\,\ Sichuan",
  861322838 => "Leshan\,\ Sichuan",
  861322839 => "Mianyang\,\ Sichuan",
  861322840 => "Meishan\,\ Sichuan",
  861322841 => "Deyang\,\ Sichuan",
  861322842 => "Tongchuan\,\ Shaanxi",
  861322843 => "Baoji\,\ Shaanxi",
  861322844 => "Yulin\,\ Shaanxi",
  861322845 => "Nanchong\,\ Sichuan",
  861322846 => "Dazhou\,\ Sichuan",
  861322847 => "Baoji\,\ Shaanxi",
  861322848 => "Leshan\,\ Sichuan",
  861322849 => "Suining\,\ Sichuan",
  86132285 => "Chongqing",
  86132286 => "Chongqing",
  861322870 => "Suqian\,\ Jiangsu",
  861322871 => "Suqian\,\ Jiangsu",
  861322872 => "Suqian\,\ Jiangsu",
  861322873 => "Taizhou\,\ Jiangsu",
  861322874 => "Taizhou\,\ Jiangsu",
  861322875 => "Taizhou\,\ Jiangsu",
  861322876 => "Taizhou\,\ Jiangsu",
  861322877 => "Taizhou\,\ Jiangsu",
  861322878 => "Taizhou\,\ Jiangsu",
  861322879 => "Taizhou\,\ Jiangsu",
  86132288 => "Nantong\,\ Jiangsu",
  861322890 => "Lhasa\,\ Tibet",
  861322891 => "Lhasa\,\ Tibet",
  861322892 => "Xigaze\,\ Tibet",
  861322893 => "Shannan\,\ Tibet",
  861322894 => "Nyingchi\,\ Tibet",
  861322895 => "Qamdo\,\ Tibet",
  861322896 => "Nagqu\,\ Tibet",
  861322897 => "Ngari\,\ Tibet",
  861322898 => "Lhasa\,\ Tibet",
  861322899 => "Lhasa\,\ Tibet",
  861322900 => "Zhaoqing\,\ Guangdong",
  861322901 => "Zhaoqing\,\ Guangdong",
  861322902 => "Zhaoqing\,\ Guangdong",
  861322903 => "Zhaoqing\,\ Guangdong",
  861322904 => "Zhaoqing\,\ Guangdong",
  861322905 => "Zhaoqing\,\ Guangdong",
  861322906 => "Xingtai\,\ Hebei",
  861322907 => "Xingtai\,\ Hebei",
  861322908 => "Jiangmen\,\ Guangdong",
  861322909 => "Jiangmen\,\ Guangdong",
  861322910 => "Zhongshan\,\ Guangdong",
  861322911 => "Shijiazhuang\,\ Hebei",
  861322912 => "Zhongshan\,\ Guangdong",
  861322913 => "Jiangmen\,\ Guangdong",
  861322914 => "Jiangmen\,\ Guangdong",
  861322915 => "Huizhou\,\ Guangdong",
  861322916 => "Huizhou\,\ Guangdong",
  861322917 => "Jieyang\,\ Guangdong",
  861322918 => "Jieyang\,\ Guangdong",
  861322919 => "Jieyang\,\ Guangdong",
  86132292 => "Foshan\,\ Guangdong",
  861322930 => "Guangzhou\,\ Guangdong",
  861322931 => "Guangzhou\,\ Guangdong",
  861322932 => "Tangshan\,\ Hebei",
  861322933 => "Guangzhou\,\ Guangdong",
  861322934 => "Guangzhou\,\ Guangdong",
  861322935 => "Tangshan\,\ Hebei",
  861322936 => "Shaoguan\,\ Guangdong",
  861322937 => "Shaoguan\,\ Guangdong",
  861322938 => "Shaoguan\,\ Guangdong",
  861322939 => "Shaoguan\,\ Guangdong",
  86132294 => "Guangzhou\,\ Guangdong",
  861322950 => "Zhanjiang\,\ Guangdong",
  861322951 => "Zhanjiang\,\ Guangdong",
  861322952 => "Zhanjiang\,\ Guangdong",
  861322953 => "Zhanjiang\,\ Guangdong",
  861322954 => "Zhanjiang\,\ Guangdong",
  861322955 => "Zhanjiang\,\ Guangdong",
  861322956 => "Zhanjiang\,\ Guangdong",
  861322957 => "Zhanjiang\,\ Guangdong",
  861322958 => "Huizhou\,\ Guangdong",
  861322959 => "Huizhou\,\ Guangdong",
  861322960 => "Meizhou\,\ Guangdong",
  861322961 => "Shantou\,\ Guangdong",
  861322962 => "Shantou\,\ Guangdong",
  861322963 => "Shantou\,\ Guangdong",
  861322964 => "Shantou\,\ Guangdong",
  861322965 => "Shantou\,\ Guangdong",
  861322966 => "Shantou\,\ Guangdong",
  861322967 => "Shantou\,\ Guangdong",
  861322968 => "Shantou\,\ Guangdong",
  861322969 => "Shanwei\,\ Guangdong",
  861322970 => "Meizhou\,\ Guangdong",
  861322971 => "Yunfu\,\ Guangdong",
  861322972 => "Yunfu\,\ Guangdong",
  861322973 => "Shanwei\,\ Guangdong",
  861322974 => "Shanwei\,\ Guangdong",
  861322975 => "Zhuhai\,\ Guangdong",
  861322976 => "Zhuhai\,\ Guangdong",
  861322977 => "Zhuhai\,\ Guangdong",
  861322978 => "Zhaoqing\,\ Guangdong",
  861322979 => "Zhaoqing\,\ Guangdong",
  861322980 => "Qingyuan\,\ Guangdong",
  861322981 => "Qingyuan\,\ Guangdong",
  861322982 => "Qingyuan\,\ Guangdong",
  861322983 => "Qingyuan\,\ Guangdong",
  861322984 => "Qingyuan\,\ Guangdong",
  861322985 => "Zhuhai\,\ Guangdong",
  861322986 => "Xingtai\,\ Hebei",
  861322987 => "Zhuhai\,\ Guangdong",
  861322988 => "Zhuhai\,\ Guangdong",
  861322989 => "Xingtai\,\ Hebei",
  861322990 => "Tangshan\,\ Hebei",
  861322991 => "Guangzhou\,\ Guangdong",
  861322992 => "Guangzhou\,\ Guangdong",
  861322993 => "Guangzhou\,\ Guangdong",
  861322994 => "Guangzhou\,\ Guangdong",
  861322995 => "Guangzhou\,\ Guangdong",
  861322996 => "Guangzhou\,\ Guangdong",
  861322997 => "Guangzhou\,\ Guangdong",
  861322998 => "Guangzhou\,\ Guangdong",
  861322999 => "Guangzhou\,\ Guangdong",
  86132300 => "Handan\,\ Hebei",
  86132301 => "Shijiazhuang\,\ Hebei",
  86132302 => "Baoding\,\ Hebei",
  86132303 => "Qinhuangdao\,\ Hebei",
  86132304 => "Shijiazhuang\,\ Hebei",
  86132305 => "Tangshan\,\ Hebei",
  861323060 => "Baoding\,\ Hebei",
  861323061 => "Baoding\,\ Hebei",
  861323062 => "Baoding\,\ Hebei",
  861323063 => "Baoding\,\ Hebei",
  861323064 => "Baoding\,\ Hebei",
  861323065 => "Langfang\,\ Hebei",
  861323066 => "Langfang\,\ Hebei",
  861323067 => "Langfang\,\ Hebei",
  861323068 => "Langfang\,\ Hebei",
  861323069 => "Langfang\,\ Hebei",
  86132307 => "Cangzhou\,\ Hebei",
  86132308 => "Tangshan\,\ Hebei",
  861323090 => "Qinhuangdao\,\ Hebei",
  861323091 => "Qinhuangdao\,\ Hebei",
  861323092 => "Qinhuangdao\,\ Hebei",
  861323093 => "Qinhuangdao\,\ Hebei",
  861323094 => "Qinhuangdao\,\ Hebei",
  861323095 => "Xingtai\,\ Hebei",
  861323096 => "Xingtai\,\ Hebei",
  861323097 => "Xingtai\,\ Hebei",
  861323098 => "Xingtai\,\ Hebei",
  861323099 => "Xingtai\,\ Hebei",
  86132310 => "Handan\,\ Hebei",
  86132311 => "Shijiazhuang\,\ Hebei",
  86132312 => "Baoding\,\ Hebei",
  861323130 => "Zhangjiakou\,\ Hebei",
  861323131 => "Zhangjiakou\,\ Hebei",
  861323132 => "Zhangjiakou\,\ Hebei",
  861323133 => "Zhangjiakou\,\ Hebei",
  861323134 => "Zhangjiakou\,\ Hebei",
  861323135 => "Zhangjiakou\,\ Hebei",
  861323136 => "Zhangjiakou\,\ Hebei",
  861323137 => "Qinhuangdao\,\ Hebei",
  861323138 => "Qinhuangdao\,\ Hebei",
  861323139 => "Qinhuangdao\,\ Hebei",
  86132314 => "Chengde\,\ Hebei",
  86132315 => "Tangshan\,\ Hebei",
  86132316 => "Langfang\,\ Hebei",
  86132317 => "Cangzhou\,\ Hebei",
  86132318 => "Hengshui\,\ Hebei",
  86132319 => "Xingtai\,\ Hebei",
  861323200 => "Yangjiang\,\ Guangdong",
  861323201 => "Yangjiang\,\ Guangdong",
  861323202 => "Yangjiang\,\ Guangdong",
  861323203 => "Yangjiang\,\ Guangdong",
  861323204 => "Yangjiang\,\ Guangdong",
  861323205 => "Shaoguan\,\ Guangdong",
  861323206 => "Shaoguan\,\ Guangdong",
  861323207 => "Shaoguan\,\ Guangdong",
  861323208 => "Shaoguan\,\ Guangdong",
  861323209 => "Shaoguan\,\ Guangdong",
  861323210 => "Yunfu\,\ Guangdong",
  861323211 => "Yunfu\,\ Guangdong",
  861323212 => "Yunfu\,\ Guangdong",
  861323213 => "Yunfu\,\ Guangdong",
  861323214 => "Yunfu\,\ Guangdong",
  861323215 => "Maoming\,\ Guangdong",
  861323216 => "Maoming\,\ Guangdong",
  861323217 => "Maoming\,\ Guangdong",
  861323218 => "Maoming\,\ Guangdong",
  861323219 => "Maoming\,\ Guangdong",
  86132322 => "Zhuhai\,\ Guangdong",
  861323230 => "Meizhou\,\ Guangdong",
  861323231 => "Meizhou\,\ Guangdong",
  861323232 => "Meizhou\,\ Guangdong",
  861323233 => "Meizhou\,\ Guangdong",
  861323234 => "Zhongshan\,\ Guangdong",
  861323235 => "Zhongshan\,\ Guangdong",
  861323236 => "Zhongshan\,\ Guangdong",
  861323237 => "Zhongshan\,\ Guangdong",
  861323238 => "Zhongshan\,\ Guangdong",
  861323239 => "Zhongshan\,\ Guangdong",
  861323240 => "Jiangmen\,\ Guangdong",
  861323241 => "Jiangmen\,\ Guangdong",
  861323242 => "Jiangmen\,\ Guangdong",
  861323243 => "Jiangmen\,\ Guangdong",
  861323244 => "Jiangmen\,\ Guangdong",
  861323245 => "Qingyuan\,\ Guangdong",
  861323246 => "Qingyuan\,\ Guangdong",
  861323247 => "Qingyuan\,\ Guangdong",
  861323248 => "Qingyuan\,\ Guangdong",
  861323249 => "Qingyuan\,\ Guangdong",
  861323250 => "Zhuhai\,\ Guangdong",
  861323251 => "Zhuhai\,\ Guangdong",
  861323252 => "Zhuhai\,\ Guangdong",
  861323253 => "Zhongshan\,\ Guangdong",
  861323254 => "Zhongshan\,\ Guangdong",
  861323255 => "Zhongshan\,\ Guangdong",
  861323256 => "Zhongshan\,\ Guangdong",
  861323257 => "Zhongshan\,\ Guangdong",
  861323258 => "Zhongshan\,\ Guangdong",
  861323259 => "Zhongshan\,\ Guangdong",
  861323260 => "Heyuan\,\ Guangdong",
  861323261 => "Heyuan\,\ Guangdong",
  861323262 => "Heyuan\,\ Guangdong",
  861323263 => "Heyuan\,\ Guangdong",
  861323264 => "Heyuan\,\ Guangdong",
  861323265 => "Zhanjiang\,\ Guangdong",
  861323266 => "Zhanjiang\,\ Guangdong",
  861323267 => "Zhanjiang\,\ Guangdong",
  861323268 => "Zhanjiang\,\ Guangdong",
  861323269 => "Zhanjiang\,\ Guangdong",
  861323270 => "Zhanjiang\,\ Guangdong",
  861323271 => "Zhanjiang\,\ Guangdong",
  861323272 => "Zhanjiang\,\ Guangdong",
  861323273 => "Zhanjiang\,\ Guangdong",
  861323274 => "Zhanjiang\,\ Guangdong",
  861323275 => "Heyuan\,\ Guangdong",
  861323276 => "Heyuan\,\ Guangdong",
  861323277 => "Heyuan\,\ Guangdong",
  861323278 => "Heyuan\,\ Guangdong",
  861323279 => "Heyuan\,\ Guangdong",
  861323280 => "Qingyuan\,\ Guangdong",
  861323281 => "Qingyuan\,\ Guangdong",
  861323282 => "Qingyuan\,\ Guangdong",
  861323283 => "Qingyuan\,\ Guangdong",
  861323284 => "Qingyuan\,\ Guangdong",
  861323285 => "Jiangmen\,\ Guangdong",
  861323286 => "Jiangmen\,\ Guangdong",
  861323287 => "Jiangmen\,\ Guangdong",
  861323288 => "Jiangmen\,\ Guangdong",
  861323289 => "Jiangmen\,\ Guangdong",
  861323290 => "Jiangmen\,\ Guangdong",
  861323291 => "Jiangmen\,\ Guangdong",
  861323292 => "Jiangmen\,\ Guangdong",
  861323293 => "Jiangmen\,\ Guangdong",
  861323294 => "Jiangmen\,\ Guangdong",
  861323295 => "Qingyuan\,\ Guangdong",
  861323296 => "Qingyuan\,\ Guangdong",
  861323297 => "Qingyuan\,\ Guangdong",
  861323298 => "Qingyuan\,\ Guangdong",
  861323299 => "Qingyuan\,\ Guangdong",
  861323300 => "Jinzhong\,\ Shanxi",
  861323301 => "Jinzhong\,\ Shanxi",
  861323302 => "Jinzhong\,\ Shanxi",
  861323303 => "Jinzhong\,\ Shanxi",
  861323304 => "Jinzhong\,\ Shanxi",
  861323305 => "Jinzhong\,\ Shanxi",
  861323306 => "Linfen\,\ Shanxi",
  861323307 => "Linfen\,\ Shanxi",
  861323308 => "Linfen\,\ Shanxi",
  861323309 => "Linfen\,\ Shanxi",
  861323310 => "Linfen\,\ Shanxi",
  861323311 => "Linfen\,\ Shanxi",
  861323312 => "Linfen\,\ Shanxi",
  861323313 => "Datong\,\ Shanxi",
  861323314 => "Datong\,\ Shanxi",
  861323315 => "Datong\,\ Shanxi",
  861323316 => "Datong\,\ Shanxi",
  861323317 => "Datong\,\ Shanxi",
  861323318 => "Datong\,\ Shanxi",
  861323319 => "Datong\,\ Shanxi",
  861323320 => "Yuncheng\,\ Shanxi",
  861323321 => "Yuncheng\,\ Shanxi",
  861323322 => "Yuncheng\,\ Shanxi",
  861323323 => "Yuncheng\,\ Shanxi",
  861323324 => "Yuncheng\,\ Shanxi",
  861323325 => "Yuncheng\,\ Shanxi",
  861323326 => "Yuncheng\,\ Shanxi",
  861323327 => "Jincheng\,\ Shanxi",
  861323328 => "Jincheng\,\ Shanxi",
  861323329 => "Jincheng\,\ Shanxi",
  861323330 => "Jincheng\,\ Shanxi",
  861323331 => "Jincheng\,\ Shanxi",
  861323332 => "Jincheng\,\ Shanxi",
  861323333 => "Jincheng\,\ Shanxi",
  861323334 => "Changzhi\,\ Shanxi",
  861323335 => "Changzhi\,\ Shanxi",
  861323336 => "Changzhi\,\ Shanxi",
  861323337 => "Changzhi\,\ Shanxi",
  861323338 => "Changzhi\,\ Shanxi",
  861323339 => "Changzhi\,\ Shanxi",
  861323340 => "Xinzhou\,\ Shanxi",
  861323341 => "Taiyuan\,\ Shanxi",
  861323342 => "Datong\,\ Shanxi",
  861323343 => "Yangquan\,\ Shanxi",
  861323344 => "Jinzhong\,\ Shanxi",
  861323345 => "Changzhi\,\ Shanxi",
  861323346 => "Jincheng\,\ Shanxi",
  861323347 => "Linfen\,\ Shanxi",
  861323348 => "Yuncheng\,\ Shanxi",
  861323349 => "Shuozhou\,\ Shanxi",
  861323350 => "Xinzhou\,\ Shanxi",
  861323351 => "Taiyuan\,\ Shanxi",
  861323352 => "Datong\,\ Shanxi",
  861323353 => "Yangquan\,\ Shanxi",
  861323354 => "Jinzhong\,\ Shanxi",
  861323355 => "Changzhi\,\ Shanxi",
  861323356 => "Jincheng\,\ Shanxi",
  861323357 => "Linfen\,\ Shanxi",
  861323358 => "Lüliang\,\ Shanxi",
  861323359 => "Yuncheng\,\ Shanxi",
  86132336 => "Taiyuan\,\ Shanxi",
  861323370 => "Pingdingshan\,\ Henan",
  861323371 => "Pingdingshan\,\ Henan",
  861323372 => "Pingdingshan\,\ Henan",
  861323373 => "Pingdingshan\,\ Henan",
  861323374 => "Pingdingshan\,\ Henan",
  861323375 => "Pingdingshan\,\ Henan",
  861323376 => "Xinyang\,\ Henan",
  861323377 => "Xinyang\,\ Henan",
  861323378 => "Xinyang\,\ Henan",
  861323379 => "Luoyang\,\ Henan",
  861323380 => "Xinxiang\,\ Henan",
  861323381 => "Xinxiang\,\ Henan",
  861323382 => "Xinxiang\,\ Henan",
  861323383 => "Xinxiang\,\ Henan",
  861323384 => "Xinxiang\,\ Henan",
  861323385 => "Shangqiu\,\ Henan",
  861323386 => "Shangqiu\,\ Henan",
  861323387 => "Shangqiu\,\ Henan",
  861323388 => "Shangqiu\,\ Henan",
  861323389 => "Shangqiu\,\ Henan",
  861323390 => "Luoyang\,\ Henan",
  861323391 => "Luoyang\,\ Henan",
  861323392 => "Luoyang\,\ Henan",
  861323393 => "Luoyang\,\ Henan",
  861323394 => "Luoyang\,\ Henan",
  861323395 => "Luoyang\,\ Henan",
  861323396 => "Luoyang\,\ Henan",
  861323397 => "Xinyang\,\ Henan",
  861323398 => "Luoyang\,\ Henan",
  861323399 => "Luoyang\,\ Henan",
  861323400 => "Shenyang\,\ Liaoning",
  861323401 => "Shenyang\,\ Liaoning",
  861323402 => "Shenyang\,\ Liaoning",
  861323403 => "Shenyang\,\ Liaoning",
  861323404 => "Shenyang\,\ Liaoning",
  861323405 => "Dalian\,\ Liaoning",
  861323406 => "Dalian\,\ Liaoning",
  861323407 => "Dalian\,\ Liaoning",
  861323408 => "Dalian\,\ Liaoning",
  861323409 => "Dalian\,\ Liaoning",
  861323410 => "Tieling\,\ Liaoning",
  861323411 => "Dalian\,\ Liaoning",
  861323412 => "Anshan\,\ Liaoning",
  861323413 => "Fushun\,\ Liaoning",
  861323414 => "Benxi\,\ Liaoning",
  861323415 => "Dandong\,\ Liaoning",
  861323416 => "Jinzhou\,\ Liaoning",
  861323417 => "Yingkou\,\ Liaoning",
  861323418 => "Fuxin\,\ Liaoning",
  861323419 => "Liaoyang\,\ Liaoning",
  861323420 => "Tieling\,\ Liaoning",
  861323421 => "Chaoyang\,\ Liaoning",
  861323422 => "Chaoyang\,\ Liaoning",
  861323423 => "Huludao\,\ Liaoning",
  861323424 => "Liaoyang\,\ Liaoning",
  861323425 => "Dandong\,\ Liaoning",
  861323426 => "Dandong\,\ Liaoning",
  861323427 => "Panjin\,\ Liaoning",
  861323428 => "Panjin\,\ Liaoning",
  861323429 => "Huludao\,\ Liaoning",
  861323430 => "Changchun\,\ Jilin",
  861323431 => "Changchun\,\ Jilin",
  861323432 => "Jilin\,\ Jilin",
  861323433 => "Yanbian\,\ Jilin",
  861323434 => "Siping\,\ Jilin",
  861323435 => "Tonghua\,\ Jilin",
  861323436 => "Baicheng\,\ Jilin",
  861323437 => "Liaoyuan\,\ Jilin",
  861323438 => "Songyuan\,\ Jilin",
  861323439 => "Baishan\,\ Jilin",
  86132344 => "Changchun\,\ Jilin",
  861323450 => "Harbin\,\ Heilongjiang",
  861323451 => "Harbin\,\ Heilongjiang",
  861323452 => "Qiqihar\,\ Heilongjiang",
  861323453 => "Mudanjiang\,\ Heilongjiang",
  861323454 => "Jiamusi\,\ Heilongjiang",
  861323455 => "Suihua\,\ Heilongjiang",
  861323456 => "Heihe\,\ Heilongjiang",
  861323457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861323458 => "Yichun\,\ Heilongjiang",
  861323459 => "Daqing\,\ Heilongjiang",
  861323460 => "Qiqihar\,\ Heilongjiang",
  861323461 => "Qiqihar\,\ Heilongjiang",
  861323462 => "Qiqihar\,\ Heilongjiang",
  861323463 => "Qiqihar\,\ Heilongjiang",
  861323464 => "Qiqihar\,\ Heilongjiang",
  861323465 => "Harbin\,\ Heilongjiang",
  861323466 => "Harbin\,\ Heilongjiang",
  861323467 => "Jixi\,\ Heilongjiang",
  861323468 => "Hegang\,\ Heilongjiang",
  861323469 => "Shuangyashan\,\ Heilongjiang",
  861323470 => "Hulun\,\ Inner\ Mongolia",
  861323471 => "Hohhot\,\ Inner\ Mongolia",
  861323472 => "Baotou\,\ Inner\ Mongolia",
  861323473 => "Wuhai\,\ Inner\ Mongolia",
  861323474 => "Hinggan\,\ Inner\ Mongolia",
  861323475 => "Tongliao\,\ Inner\ Mongolia",
  861323476 => "Chifeng\,\ Inner\ Mongolia",
  861323477 => "Ordos\,\ Inner\ Mongolia",
  861323478 => "Bayannur\,\ Inner\ Mongolia",
  861323479 => "Xilin\,\ Inner\ Mongolia",
  861323480 => "Baotou\,\ Inner\ Mongolia",
  861323481 => "Baotou\,\ Inner\ Mongolia",
  861323482 => "Hinggan\,\ Inner\ Mongolia",
  861323483 => "Ordos\,\ Inner\ Mongolia",
  861323484 => "Ordos\,\ Inner\ Mongolia",
  861323485 => "Tongliao\,\ Inner\ Mongolia",
  861323486 => "Tongliao\,\ Inner\ Mongolia",
  861323487 => "Bayannur\,\ Inner\ Mongolia",
  861323488 => "Bayannur\,\ Inner\ Mongolia",
  861323489 => "Bayannur\,\ Inner\ Mongolia",
  861323490 => "Daqing\,\ Heilongjiang",
  861323491 => "Daqing\,\ Heilongjiang",
  861323492 => "Daqing\,\ Heilongjiang",
  861323493 => "Qiqihar\,\ Heilongjiang",
  861323494 => "Qiqihar\,\ Heilongjiang",
  861323495 => "Harbin\,\ Heilongjiang",
  861323496 => "Harbin\,\ Heilongjiang",
  861323497 => "Harbin\,\ Heilongjiang",
  861323498 => "Harbin\,\ Heilongjiang",
  861323499 => "Harbin\,\ Heilongjiang",
  861323500 => "Xiamen\,\ Fujian",
  861323501 => "Zhangzhou\,\ Fujian",
  861323502 => "Zhangzhou\,\ Fujian",
  861323503 => "Zhangzhou\,\ Fujian",
  861323504 => "Zhangzhou\,\ Fujian",
  861323505 => "Zhangzhou\,\ Fujian",
  861323506 => "Ningde\,\ Fujian",
  861323507 => "Putian\,\ Fujian",
  861323508 => "Putian\,\ Fujian",
  861323509 => "Longyan\,\ Fujian",
  861323510 => "Suqian\,\ Jiangsu",
  861323511 => "Suqian\,\ Jiangsu",
  861323512 => "Suqian\,\ Jiangsu",
  861323513 => "Suqian\,\ Jiangsu",
  861323514 => "Suqian\,\ Jiangsu",
  861323515 => "Suqian\,\ Jiangsu",
  861323516 => "Changzhou\,\ Jiangsu",
  861323517 => "Changzhou\,\ Jiangsu",
  861323518 => "Changzhou\,\ Jiangsu",
  861323519 => "Changzhou\,\ Jiangsu",
  861323520 => "Nantong\,\ Jiangsu",
  861323521 => "Nantong\,\ Jiangsu",
  861323522 => "Nantong\,\ Jiangsu",
  861323523 => "Yangzhou\,\ Jiangsu",
  861323524 => "Yangzhou\,\ Jiangsu",
  861323525 => "Yangzhou\,\ Jiangsu",
  861323526 => "Yangzhou\,\ Jiangsu",
  861323527 => "Yangzhou\,\ Jiangsu",
  861323528 => "Yangzhou\,\ Jiangsu",
  861323529 => "Yangzhou\,\ Jiangsu",
  861323530 => "Heze\,\ Shandong",
  861323531 => "Jinan\,\ Shandong",
  861323532 => "Qingdao\,\ Shandong",
  861323533 => "Zibo\,\ Shandong",
  861323534 => "Dezhou\,\ Shandong",
  861323535 => "Yantai\,\ Shandong",
  861323536 => "Weifang\,\ Shandong",
  861323537 => "Jining\,\ Shandong",
  861323538 => "TaiAn\,\ Shandong",
  861323539 => "Linyi\,\ Shandong",
  861323540 => "Ezhou\,\ Hubei",
  861323541 => "Huanggang\,\ Hubei",
  861323542 => "Huanggang\,\ Hubei",
  861323543 => "Huanggang\,\ Hubei",
  861323544 => "Enshi\,\ Hubei",
  861323545 => "Enshi\,\ Hubei",
  861323546 => "Enshi\,\ Hubei",
  861323547 => "Xiaogan\,\ Hubei",
  861323548 => "Xiaogan\,\ Hubei",
  861323549 => "Xiaogan\,\ Hubei",
  861323550 => "Suizhou\,\ Hubei",
  861323551 => "Suizhou\,\ Hubei",
  861323552 => "Wuhan\,\ Hubei",
  861323553 => "Wuhan\,\ Hubei",
  861323554 => "Wuhan\,\ Hubei",
  861323555 => "Wuhan\,\ Hubei",
  861323556 => "Xianning\,\ Hubei",
  861323557 => "Xianning\,\ Hubei",
  861323558 => "Xianning\,\ Hubei",
  861323559 => "Enshi\,\ Hubei",
  861323560 => "Jingzhou\,\ Hubei",
  861323561 => "Jingzhou\,\ Hubei",
  861323562 => "Yichang\,\ Hubei",
  861323563 => "Yichang\,\ Hubei",
  861323564 => "Jingmen\,\ Hubei",
  861323565 => "Shiyan\,\ Hubei",
  861323566 => "Shiyan\,\ Hubei",
  861323567 => "Shiyan\,\ Hubei",
  861323568 => "Xiangfan\,\ Hubei",
  861323569 => "Xiangfan\,\ Hubei",
  861323570 => "Quzhou\,\ Zhejiang",
  861323571 => "Hangzhou\,\ Zhejiang",
  861323572 => "Huzhou\,\ Zhejiang",
  861323573 => "Jiaxing\,\ Zhejiang",
  861323574 => "Ningbo\,\ Zhejiang",
  861323575 => "Shaoxing\,\ Zhejiang",
  861323576 => "Taizhou\,\ Zhejiang",
  861323577 => "Wenzhou\,\ Zhejiang",
  861323578 => "Lishui\,\ Zhejiang",
  861323579 => "Jinhua\,\ Zhejiang",
  861323580 => "Zhoushan\,\ Zhejiang",
  861323581 => "Hangzhou\,\ Zhejiang",
  861323582 => "Huzhou\,\ Zhejiang",
  861323583 => "Jiaxing\,\ Zhejiang",
  861323584 => "Ningbo\,\ Zhejiang",
  861323585 => "Shaoxing\,\ Zhejiang",
  861323586 => "Taizhou\,\ Zhejiang",
  861323587 => "Wenzhou\,\ Zhejiang",
  861323588 => "Lishui\,\ Zhejiang",
  861323589 => "Jinhua\,\ Zhejiang",
  861323590 => "Fuzhou\,\ Fujian",
  861323591 => "Fuzhou\,\ Fujian",
  861323592 => "Xiamen\,\ Fujian",
  861323593 => "Ningde\,\ Fujian",
  861323594 => "Putian\,\ Fujian",
  861323595 => "Quanzhou\,\ Fujian",
  861323596 => "Zhangzhou\,\ Fujian",
  861323597 => "Longyan\,\ Fujian",
  861323598 => "Sanming\,\ Fujian",
  861323599 => "Nanping\,\ Fujian",
  861323600 => "Xuzhou\,\ Jiangsu",
  861323601 => "Xuzhou\,\ Jiangsu",
  861323602 => "Xuzhou\,\ Jiangsu",
  861323603 => "Xuzhou\,\ Jiangsu",
  861323604 => "Xuzhou\,\ Jiangsu",
  861323605 => "Xuzhou\,\ Jiangsu",
  861323606 => "Xuzhou\,\ Jiangsu",
  861323607 => "Nantong\,\ Jiangsu",
  861323608 => "Nantong\,\ Jiangsu",
  861323609 => "Nantong\,\ Jiangsu",
  861323610 => "Yancheng\,\ Jiangsu",
  861323611 => "Yancheng\,\ Jiangsu",
  861323612 => "Yancheng\,\ Jiangsu",
  861323613 => "Yancheng\,\ Jiangsu",
  861323614 => "Taizhou\,\ Jiangsu",
  861323615 => "Taizhou\,\ Jiangsu",
  861323616 => "Taizhou\,\ Jiangsu",
  861323617 => "Taizhou\,\ Jiangsu",
  861323618 => "Taizhou\,\ Jiangsu",
  861323619 => "Taizhou\,\ Jiangsu",
  861323620 => "HuaiAn\,\ Jiangsu",
  861323621 => "HuaiAn\,\ Jiangsu",
  861323622 => "HuaiAn\,\ Jiangsu",
  861323623 => "HuaiAn\,\ Jiangsu",
  861323624 => "HuaiAn\,\ Jiangsu",
  861323625 => "HuaiAn\,\ Jiangsu",
  861323626 => "HuaiAn\,\ Jiangsu",
  861323627 => "Yancheng\,\ Jiangsu",
  861323628 => "Yancheng\,\ Jiangsu",
  861323629 => "Yancheng\,\ Jiangsu",
  861323630 => "Lianyungang\,\ Jiangsu",
  861323631 => "Lianyungang\,\ Jiangsu",
  861323632 => "Lianyungang\,\ Jiangsu",
  861323633 => "Lianyungang\,\ Jiangsu",
  861323634 => "Lianyungang\,\ Jiangsu",
  861323635 => "Zhenjiang\,\ Jiangsu",
  861323636 => "Zhenjiang\,\ Jiangsu",
  861323637 => "Zhenjiang\,\ Jiangsu",
  861323638 => "Zhenjiang\,\ Jiangsu",
  861323639 => "Zhenjiang\,\ Jiangsu",
  861323640 => "Nanjing\,\ Jiangsu",
  861323641 => "Nanjing\,\ Jiangsu",
  861323642 => "Xuzhou\,\ Jiangsu",
  861323643 => "Wuxi\,\ Jiangsu",
  861323644 => "Yangzhou\,\ Jiangsu",
  861323645 => "Yancheng\,\ Jiangsu",
  861323646 => "HuaiAn\,\ Jiangsu",
  861323647 => "Zhenjiang\,\ Jiangsu",
  861323648 => "Nantong\,\ Jiangsu",
  861323649 => "Suzhou\,\ Jiangsu",
  86132365 => "Nanjing\,\ Jiangsu",
  861323660 => "Shenyang\,\ Liaoning",
  861323661 => "Shenyang\,\ Liaoning",
  861323662 => "Shenyang\,\ Liaoning",
  861323663 => "Shenyang\,\ Liaoning",
  861323664 => "Shenyang\,\ Liaoning",
  861323665 => "Shenyang\,\ Liaoning",
  861323666 => "Shenyang\,\ Liaoning",
  861323667 => "Shenyang\,\ Liaoning",
  861323668 => "Benxi\,\ Liaoning",
  861323669 => "Benxi\,\ Liaoning",
  861323670 => "Fuxin\,\ Liaoning",
  861323671 => "Fuxin\,\ Liaoning",
  861323672 => "Yingkou\,\ Liaoning",
  861323673 => "Yingkou\,\ Liaoning",
  861323674 => "Tieling\,\ Liaoning",
  861323675 => "Tieling\,\ Liaoning",
  861323676 => "Chaoyang\,\ Liaoning",
  861323677 => "Panjin\,\ Liaoning",
  861323678 => "Panjin\,\ Liaoning",
  861323679 => "Huludao\,\ Liaoning",
  861323680 => "Anshan\,\ Liaoning",
  861323681 => "Anshan\,\ Liaoning",
  861323682 => "Anshan\,\ Liaoning",
  861323683 => "Anshan\,\ Liaoning",
  861323684 => "Anshan\,\ Liaoning",
  861323685 => "Jinzhou\,\ Liaoning",
  861323686 => "Jinzhou\,\ Liaoning",
  861323687 => "Jinzhou\,\ Liaoning",
  861323688 => "Jinzhou\,\ Liaoning",
  861323689 => "Jinzhou\,\ Liaoning",
  861323690 => "Dalian\,\ Liaoning",
  861323691 => "Dalian\,\ Liaoning",
  861323692 => "Dalian\,\ Liaoning",
  861323693 => "Dalian\,\ Liaoning",
  861323694 => "Dalian\,\ Liaoning",
  861323695 => "Fushun\,\ Liaoning",
  861323696 => "Liaoyang\,\ Liaoning",
  861323697 => "Dandong\,\ Liaoning",
  861323698 => "Dandong\,\ Liaoning",
  861323699 => "Yingkou\,\ Liaoning",
  861323700 => "Nanchang\,\ Jiangxi",
  861323701 => "Yingtan\,\ Jiangxi",
  861323702 => "Jiujiang\,\ Jiangxi",
  861323703 => "Shangrao\,\ Jiangxi",
  861323704 => "Nanchang\,\ Jiangxi",
  861323705 => "Yichun\,\ Jiangxi",
  861323706 => "JiAn\,\ Jiangxi",
  861323707 => "Ganzhou\,\ Jiangxi",
  861323708 => "Nanchang\,\ Jiangxi",
  861323709 => "Yichun\,\ Jiangxi",
  86132371 => "Wuhan\,\ Hubei",
  861323720 => "Huanggang\,\ Hubei",
  861323721 => "Huanggang\,\ Hubei",
  861323722 => "Huanggang\,\ Hubei",
  861323723 => "Huangshi\,\ Hubei",
  861323724 => "Huangshi\,\ Hubei",
  861323725 => "Huangshi\,\ Hubei",
  861323726 => "Suizhou\,\ Hubei",
  861323727 => "Jingmen\,\ Hubei",
  861323728 => "Jingmen\,\ Hubei",
  861323729 => "Jingmen\,\ Hubei",
  861323730 => "Yueyang\,\ Hunan",
  861323731 => "Changsha\,\ Hunan",
  861323732 => "Xiangtan\,\ Hunan",
  861323733 => "Zhuzhou\,\ Hunan",
  861323734 => "Hengyang\,\ Hunan",
  861323735 => "Chenzhou\,\ Hunan",
  861323736 => "Changde\,\ Hunan",
  861323737 => "Yiyang\,\ Hunan",
  861323738 => "Loudi\,\ Hunan",
  861323739 => "Shaoyang\,\ Hunan",
  861323740 => "Yueyang\,\ Hunan",
  861323741 => "Changsha\,\ Hunan",
  861323742 => "Changsha\,\ Hunan",
  861323743 => "Xiangxi\,\ Hunan",
  861323744 => "Zhangjiajie\,\ Hunan",
  861323745 => "Huaihua\,\ Hunan",
  861323746 => "Yongzhou\,\ Hunan",
  861323747 => "Changsha\,\ Hunan",
  861323748 => "Changsha\,\ Hunan",
  861323749 => "Changsha\,\ Hunan",
  861323750 => "Fuzhou\,\ Jiangxi",
  861323751 => "Nanchang\,\ Jiangxi",
  861323752 => "Nanchang\,\ Jiangxi",
  861323753 => "Shangrao\,\ Jiangxi",
  861323754 => "Xinyu\,\ Jiangxi",
  861323755 => "Xinyu\,\ Jiangxi",
  861323756 => "Xinyu\,\ Jiangxi",
  861323757 => "Xinyu\,\ Jiangxi",
  861323758 => "Jingdezhen\,\ Jiangxi",
  861323759 => "Pingxiang\,\ Jiangxi",
  861323760 => "Jingdezhen\,\ Jiangxi",
  861323761 => "Jiujiang\,\ Jiangxi",
  861323762 => "Jiujiang\,\ Jiangxi",
  861323763 => "Shangrao\,\ Jiangxi",
  861323764 => "Nanchang\,\ Jiangxi",
  861323765 => "Yichun\,\ Jiangxi",
  861323766 => "Ganzhou\,\ Jiangxi",
  861323767 => "Ganzhou\,\ Jiangxi",
  861323768 => "Ganzhou\,\ Jiangxi",
  861323769 => "Ganzhou\,\ Jiangxi",
  861323770 => "Nanning\,\ Guangxi",
  861323771 => "Nanning\,\ Guangxi",
  861323772 => "Liuzhou\,\ Guangxi",
  861323773 => "Guilin\,\ Guangxi",
  861323774 => "Hezhou\,\ Guangxi",
  861323775 => "Guigang\,\ Guangxi",
  861323776 => "Baise\,\ Guangxi",
  861323777 => "Hezhou\,\ Guangxi",
  861323778 => "Hechi\,\ Guangxi",
  861323779 => "Laibin\,\ Guangxi",
  861323780 => "Nanning\,\ Guangxi",
  861323781 => "Nanning\,\ Guangxi",
  861323782 => "Liuzhou\,\ Guangxi",
  861323783 => "Guilin\,\ Guangxi",
  861323784 => "Hezhou\,\ Guangxi",
  861323785 => "Guigang\,\ Guangxi",
  861323786 => "Yulin\,\ Guangxi",
  861323787 => "Laibin\,\ Guangxi",
  861323788 => "Hechi\,\ Guangxi",
  861323789 => "Laibin\,\ Guangxi",
  861323790 => "Xinyu\,\ Jiangxi",
  861323791 => "Nanchang\,\ Jiangxi",
  861323792 => "Jiujiang\,\ Jiangxi",
  861323793 => "Shangrao\,\ Jiangxi",
  861323794 => "Fuzhou\,\ Jiangxi",
  861323795 => "Yichun\,\ Jiangxi",
  861323796 => "JiAn\,\ Jiangxi",
  861323797 => "Ganzhou\,\ Jiangxi",
  861323798 => "Jingdezhen\,\ Jiangxi",
  861323799 => "Pingxiang\,\ Jiangxi",
  86132380 => "Dalian\,\ Liaoning",
  861323810 => "Fushun\,\ Liaoning",
  861323811 => "Fuxin\,\ Liaoning",
  861323812 => "Liaoyang\,\ Liaoning",
  861323813 => "Fushun\,\ Liaoning",
  861323814 => "Tieling\,\ Liaoning",
  861323815 => "Dandong\,\ Liaoning",
  861323816 => "Jinzhou\,\ Liaoning",
  861323817 => "Anshan\,\ Liaoning",
  861323818 => "Anshan\,\ Liaoning",
  861323819 => "Anshan\,\ Liaoning",
  861323820 => "Yingkou\,\ Liaoning",
  861323821 => "Fuxin\,\ Liaoning",
  861323822 => "Liaoyang\,\ Liaoning",
  861323823 => "Panjin\,\ Liaoning",
  861323824 => "Yingkou\,\ Liaoning",
  861323825 => "Dandong\,\ Liaoning",
  861323826 => "Yingkou\,\ Liaoning",
  861323827 => "Yingkou\,\ Liaoning",
  861323828 => "Tieling\,\ Liaoning",
  861323829 => "Tieling\,\ Liaoning",
  86132383 => "Dongguan\,\ Guangdong",
  861323840 => "Hohhot\,\ Inner\ Mongolia",
  861323841 => "Hohhot\,\ Inner\ Mongolia",
  861323842 => "Hohhot\,\ Inner\ Mongolia",
  861323843 => "Hohhot\,\ Inner\ Mongolia",
  861323844 => "Hohhot\,\ Inner\ Mongolia",
  861323845 => "Wuhai\,\ Inner\ Mongolia",
  861323846 => "Hinggan\,\ Inner\ Mongolia",
  861323847 => "Hinggan\,\ Inner\ Mongolia",
  861323848 => "Hinggan\,\ Inner\ Mongolia",
  861323849 => "Xilin\,\ Inner\ Mongolia",
  861323850 => "Anshun\,\ Guizhou",
  861323851 => "Anshun\,\ Guizhou",
  861323852 => "Bijie\,\ Guizhou",
  861323853 => "Liupanshui\,\ Guizhou",
  861323854 => "Liupanshui\,\ Guizhou",
  861323855 => "Qiandongnan\,\ Guizhou",
  861323856 => "Tongren\,\ Guizhou",
  861323857 => "Bijie\,\ Guizhou",
  861323858 => "Bijie\,\ Guizhou",
  861323859 => "Qianxinan\,\ Guizhou",
  861323860 => "Zhaotong\,\ Yunnan",
  861323861 => "Xishuangbanna\,\ Yunnan",
  861323862 => "Qujing\,\ Yunnan",
  861323863 => "Lincang\,\ Yunnan",
  861323864 => "Qujing\,\ Yunnan",
  861323865 => "Baoshan\,\ Yunnan",
  861323866 => "Kunming\,\ Yunnan",
  861323867 => "Kunming\,\ Yunnan",
  861323868 => "Kunming\,\ Yunnan",
  861323869 => "Kunming\,\ Yunnan",
  861323870 => "Zhaotong\,\ Yunnan",
  861323871 => "Kunming\,\ Yunnan",
  861323872 => "Dali\,\ Yunnan",
  861323873 => "Honghe\,\ Yunnan",
  861323874 => "Qujing\,\ Yunnan",
  861323875 => "Baoshan\,\ Yunnan",
  861323876 => "Wenshan\,\ Yunnan",
  861323877 => "Yuxi\,\ Yunnan",
  861323878 => "Chuxiong\,\ Yunnan",
  861323879 => "Puer\,\ Yunnan",
  86132388 => "Shenyang\,\ Liaoning",
  861323890 => "Chaoyang\,\ Liaoning",
  861323891 => "Chaoyang\,\ Liaoning",
  861323892 => "Huludao\,\ Liaoning",
  861323893 => "Liaoyang\,\ Liaoning",
  861323894 => "Jinzhou\,\ Liaoning",
  861323895 => "Huludao\,\ Liaoning",
  861323896 => "Panjin\,\ Liaoning",
  861323897 => "Anshan\,\ Liaoning",
  861323898 => "Anshan\,\ Liaoning",
  861323899 => "Anshan\,\ Liaoning",
  861323900 => "Changji\,\ Xinjiang",
  861323901 => "Kashi\,\ Xinjiang",
  861323902 => "Ili\,\ Xinjiang",
  861323903 => "Shihezi\,\ Xinjiang",
  861323904 => "Ili\,\ Xinjiang",
  861323905 => "Ili\,\ Xinjiang",
  861323906 => "Bayingolin\,\ Xinjiang",
  861323907 => "Bayingolin\,\ Xinjiang",
  861323908 => "Aksu\,\ Xinjiang",
  861323909 => "Bortala\,\ Xinjiang",
  861323910 => "Xianyang\,\ Shaanxi",
  861323911 => "YanAn\,\ Shaanxi",
  861323912 => "Yulin\,\ Shaanxi",
  861323913 => "Weinan\,\ Shaanxi",
  861323914 => "Shangluo\,\ Shaanxi",
  861323915 => "Ankang\,\ Shaanxi",
  861323916 => "Hanzhong\,\ Shaanxi",
  861323917 => "Baoji\,\ Shaanxi",
  861323918 => "YanAn\,\ Shaanxi",
  861323919 => "Tongchuan\,\ Shaanxi",
  861323920 => "YanAn\,\ Shaanxi",
  861323921 => "YanAn\,\ Shaanxi",
  861323922 => "YanAn\,\ Shaanxi",
  861323923 => "YanAn\,\ Shaanxi",
  861323924 => "Yulin\,\ Shaanxi",
  861323925 => "Yulin\,\ Shaanxi",
  861323926 => "Yulin\,\ Shaanxi",
  861323927 => "Yulin\,\ Shaanxi",
  861323928 => "Yulin\,\ Shaanxi",
  861323929 => "Yulin\,\ Shaanxi",
  861323930 => "Linxia\,\ Gansu",
  861323931 => "Lanzhou\,\ Gansu",
  861323932 => "Dingxi\,\ Gansu",
  861323933 => "Pingliang\,\ Gansu",
  861323934 => "Qingyang\,\ Gansu",
  861323935 => "Jinchang\,\ Gansu",
  861323936 => "Zhangye\,\ Gansu",
  861323937 => "Jiuquan\,\ Gansu",
  861323938 => "Tianshui\,\ Gansu",
  861323939 => "Longnan\,\ Gansu",
  861323940 => "Jiayuguan\,\ Gansu",
  861323941 => "Gannan\,\ Gansu",
  861323942 => "Dingxi\,\ Gansu",
  861323943 => "Baiyin\,\ Gansu",
  861323944 => "Longnan\,\ Gansu",
  861323945 => "Wuwei\,\ Gansu",
  861323946 => "Jiayuguan\,\ Gansu",
  861323947 => "Gannan\,\ Gansu",
  861323948 => "Zhangye\,\ Gansu",
  861323949 => "Jiuquan\,\ Gansu",
  861323950 => "Yinchuan\,\ Ningxia",
  861323951 => "Yinchuan\,\ Ningxia",
  861323952 => "Shizuishan\,\ Ningxia",
  861323953 => "Wuzhong\,\ Ningxia",
  861323954 => "Guyuan\,\ Ningxia",
  861323955 => "Zhongwei\,\ Ningxia",
  861323956 => "Shizuishan\,\ Ningxia",
  861323957 => "Zhongwei\,\ Ningxia",
  861323958 => "Yinchuan\,\ Ningxia",
  861323959 => "Yinchuan\,\ Ningxia",
  861323960 => "Qingyang\,\ Gansu",
  861323961 => "Qingyang\,\ Gansu",
  861323962 => "Lanzhou\,\ Gansu",
  861323963 => "Lanzhou\,\ Gansu",
  861323964 => "Lanzhou\,\ Gansu",
  861323965 => "Lanzhou\,\ Gansu",
  861323966 => "Lanzhou\,\ Gansu",
  861323967 => "Lanzhou\,\ Gansu",
  861323968 => "Lanzhou\,\ Gansu",
  861323969 => "Lanzhou\,\ Gansu",
  861323970 => "Kashi\,\ Xinjiang",
  861323971 => "Turpan\,\ Xinjiang",
  861323972 => "Kashi\,\ Xinjiang",
  861323973 => "Hami\,\ Xinjiang",
  861323974 => "Hotan\,\ Xinjiang",
  861323975 => "Ili\,\ Xinjiang",
  861323976 => "Hotan\,\ Xinjiang",
  861323977 => "Karamay\,\ Xinjiang",
  861323978 => "Ili\,\ Xinjiang",
  861323979 => "Ili\,\ Xinjiang",
  861323980 => "Hotan\,\ Xinjiang",
  861323981 => "Hotan\,\ Xinjiang",
  861323982 => "Aksu\,\ Xinjiang",
  861323983 => "Aksu\,\ Xinjiang",
  861323984 => "Aksu\,\ Xinjiang",
  861323985 => "Bayingolin\,\ Xinjiang",
  861323986 => "Aksu\,\ Xinjiang",
  861323987 => "Kashi\,\ Xinjiang",
  861323988 => "Changji\,\ Xinjiang",
  861323989 => "Changji\,\ Xinjiang",
  861323990 => "Karamay\,\ Xinjiang",
  861323991 => "Urumchi\,\ Xinjiang",
  861323992 => "Ili\,\ Xinjiang",
  861323993 => "Shihezi\,\ Xinjiang",
  861323994 => "Changji\,\ Xinjiang",
  861323995 => "Turpan\,\ Xinjiang",
  861323996 => "Bayingolin\,\ Xinjiang",
  861323997 => "Aksu\,\ Xinjiang",
  861323998 => "Kashi\,\ Xinjiang",
  861323999 => "Ili\,\ Xinjiang",
  86132400 => "Beijing",
  86132401 => "Beijing",
  86132402 => "Beijing",
  86132403 => "Beijing",
  86132404 => "Beijing",
  86132405 => "Dongguan\,\ Guangdong",
  86132406 => "Dongguan\,\ Guangdong",
  86132407 => "Beijing",
  861324080 => "Beijing",
  861324081 => "Beijing",
  861324082 => "Beijing",
  861324083 => "Hinggan\,\ Inner\ Mongolia",
  861324084 => "Hulun\,\ Inner\ Mongolia",
  861324085 => "Hulun\,\ Inner\ Mongolia",
  861324086 => "Chifeng\,\ Inner\ Mongolia",
  861324087 => "Hohhot\,\ Inner\ Mongolia",
  861324088 => "Hohhot\,\ Inner\ Mongolia",
  861324089 => "Beijing",
  86132409 => "Beijing",
  8613241 => "Beijing",
  86132420 => "Shenzhen\,\ Guangdong",
  861324210 => "Foshan\,\ Guangdong",
  861324211 => "Foshan\,\ Guangdong",
  861324212 => "Foshan\,\ Guangdong",
  861324213 => "Foshan\,\ Guangdong",
  861324214 => "Foshan\,\ Guangdong",
  861324215 => "Jiangmen\,\ Guangdong",
  861324216 => "Jiangmen\,\ Guangdong",
  861324217 => "Jiangmen\,\ Guangdong",
  861324218 => "Jiangmen\,\ Guangdong",
  861324219 => "Jiangmen\,\ Guangdong",
  861324220 => "Zhongshan\,\ Guangdong",
  861324221 => "Zhongshan\,\ Guangdong",
  861324222 => "Zhongshan\,\ Guangdong",
  861324223 => "Zhongshan\,\ Guangdong",
  861324224 => "Zhongshan\,\ Guangdong",
  861324225 => "Jieyang\,\ Guangdong",
  861324226 => "Jieyang\,\ Guangdong",
  861324227 => "Jieyang\,\ Guangdong",
  861324228 => "Jieyang\,\ Guangdong",
  861324229 => "Jieyang\,\ Guangdong",
  861324230 => "Guangzhou\,\ Guangdong",
  861324231 => "Guangzhou\,\ Guangdong",
  861324232 => "Guangzhou\,\ Guangdong",
  861324233 => "Guangzhou\,\ Guangdong",
  861324234 => "Guangzhou\,\ Guangdong",
  861324235 => "Huizhou\,\ Guangdong",
  861324236 => "Huizhou\,\ Guangdong",
  861324237 => "Qingyuan\,\ Guangdong",
  861324238 => "Qingyuan\,\ Guangdong",
  861324239 => "Qingyuan\,\ Guangdong",
  861324240 => "Shenzhen\,\ Guangdong",
  861324241 => "Shenzhen\,\ Guangdong",
  861324242 => "Shenzhen\,\ Guangdong",
  861324243 => "Shenzhen\,\ Guangdong",
  861324244 => "Shenzhen\,\ Guangdong",
  861324245 => "Foshan\,\ Guangdong",
  861324246 => "Foshan\,\ Guangdong",
  861324247 => "Xingtai\,\ Hebei",
  861324248 => "Jiangmen\,\ Guangdong",
  861324249 => "Jiangmen\,\ Guangdong",
  861324250 => "Shaoguan\,\ Guangdong",
  861324251 => "Shaoguan\,\ Guangdong",
  861324252 => "Shaoguan\,\ Guangdong",
  861324253 => "Shaoguan\,\ Guangdong",
  861324254 => "Shaoguan\,\ Guangdong",
  861324255 => "Shaoguan\,\ Guangdong",
  861324256 => "Shaoguan\,\ Guangdong",
  861324257 => "Chaozhou\,\ Guangdong",
  861324258 => "Chaozhou\,\ Guangdong",
  861324259 => "Chaozhou\,\ Guangdong",
  861324260 => "Zhaoqing\,\ Guangdong",
  861324261 => "Zhaoqing\,\ Guangdong",
  861324262 => "Zhaoqing\,\ Guangdong",
  861324263 => "Tangshan\,\ Hebei",
  861324264 => "Tangshan\,\ Hebei",
  861324265 => "Shanwei\,\ Guangdong",
  861324266 => "Shanwei\,\ Guangdong",
  861324267 => "Zhuhai\,\ Guangdong",
  861324268 => "Zhuhai\,\ Guangdong",
  861324269 => "Zhuhai\,\ Guangdong",
  86132427 => "Guangzhou\,\ Guangdong",
  86132428 => "Guangzhou\,\ Guangdong",
  86132429 => "Shenzhen\,\ Guangdong",
  861324300 => "Anyang\,\ Henan",
  861324301 => "Anyang\,\ Henan",
  861324302 => "Anyang\,\ Henan",
  861324303 => "Jiaozuo\,\ Henan",
  861324304 => "Jiaozuo\,\ Henan",
  861324305 => "Kaifeng\,\ Henan",
  861324306 => "Kaifeng\,\ Henan",
  861324307 => "Luoyang\,\ Henan",
  861324308 => "Luoyang\,\ Henan",
  861324309 => "Luoyang\,\ Henan",
  861324310 => "Luohe\,\ Henan",
  861324311 => "Luohe\,\ Henan",
  861324312 => "Nanyang\,\ Henan",
  861324313 => "Nanyang\,\ Henan",
  861324314 => "Nanyang\,\ Henan",
  861324315 => "Nanyang\,\ Henan",
  861324316 => "Pingdingshan\,\ Henan",
  861324317 => "Pingdingshan\,\ Henan",
  861324318 => "Pingdingshan\,\ Henan",
  861324319 => "Pingdingshan\,\ Henan",
  861324320 => "Puyang\,\ Henan",
  861324321 => "Puyang\,\ Henan",
  861324322 => "Puyang\,\ Henan",
  861324323 => "Sanmenxia\,\ Henan",
  861324324 => "Sanmenxia\,\ Henan",
  861324325 => "Shangqiu\,\ Henan",
  861324326 => "Shangqiu\,\ Henan",
  861324327 => "Shangqiu\,\ Henan",
  861324328 => "Xinxiang\,\ Henan",
  861324329 => "Xinxiang\,\ Henan",
  861324330 => "Xinyang\,\ Henan",
  861324331 => "Xinyang\,\ Henan",
  861324332 => "Xinyang\,\ Henan",
  861324333 => "Xuchang\,\ Henan",
  861324334 => "Xuchang\,\ Henan",
  861324335 => "Xuchang\,\ Henan",
  861324336 => "Xuchang\,\ Henan",
  861324337 => "Zhoukou\,\ Henan",
  861324338 => "Zhoukou\,\ Henan",
  861324339 => "Zhumadian\,\ Henan",
  861324340 => "Hebi\,\ Henan",
  861324341 => "Hebi\,\ Henan",
  861324342 => "Zhengzhou\,\ Henan",
  861324343 => "Zhengzhou\,\ Henan",
  861324344 => "Zhengzhou\,\ Henan",
  861324345 => "Jiaozuo\,\ Henan",
  861324346 => "Zhoukou\,\ Henan",
  861324347 => "Zhumadian\,\ Henan",
  861324348 => "Zhumadian\,\ Henan",
  861324349 => "Xinxiang\,\ Henan",
  86132435 => "Chongqing",
  86132436 => "Yongzhou\,\ Hunan",
  86132437 => "Shenzhen\,\ Guangdong",
  86132438 => "Shenzhen\,\ Guangdong",
  861324390 => "Huludao\,\ Liaoning",
  861324391 => "Jinzhou\,\ Liaoning",
  861324392 => "Jinzhou\,\ Liaoning",
  861324393 => "Yingkou\,\ Liaoning",
  861324394 => "Yingkou\,\ Liaoning",
  861324395 => "Liaoyang\,\ Liaoning",
  861324396 => "Liaoyang\,\ Liaoning",
  861324397 => "Huludao\,\ Liaoning",
  861324398 => "Huludao\,\ Liaoning",
  861324399 => "Huludao\,\ Liaoning",
  861324400 => "Jilin\,\ Jilin",
  861324401 => "Jilin\,\ Jilin",
  861324402 => "Jilin\,\ Jilin",
  861324403 => "Jilin\,\ Jilin",
  861324404 => "Jilin\,\ Jilin",
  861324405 => "Siping\,\ Jilin",
  861324406 => "Siping\,\ Jilin",
  861324407 => "Siping\,\ Jilin",
  861324408 => "Siping\,\ Jilin",
  861324409 => "Siping\,\ Jilin",
  861324410 => "XiAn\,\ Shaanxi",
  861324411 => "YanAn\,\ Shaanxi",
  861324412 => "YanAn\,\ Shaanxi",
  861324413 => "YanAn\,\ Shaanxi",
  861324414 => "YanAn\,\ Shaanxi",
  861324415 => "YanAn\,\ Shaanxi",
  861324416 => "YanAn\,\ Shaanxi",
  861324417 => "YanAn\,\ Shaanxi",
  861324418 => "YanAn\,\ Shaanxi",
  861324419 => "YanAn\,\ Shaanxi",
  861324420 => "Jilin\,\ Jilin",
  861324421 => "Jilin\,\ Jilin",
  861324422 => "Jilin\,\ Jilin",
  861324423 => "Jilin\,\ Jilin",
  861324424 => "Siping\,\ Jilin",
  861324425 => "Tonghua\,\ Jilin",
  861324426 => "Changchun\,\ Jilin",
  861324427 => "Changchun\,\ Jilin",
  861324428 => "Songyuan\,\ Jilin",
  861324429 => "Songyuan\,\ Jilin",
  861324430 => "Changchun\,\ Jilin",
  861324431 => "Changchun\,\ Jilin",
  861324432 => "Jilin\,\ Jilin",
  861324433 => "Yanbian\,\ Jilin",
  861324434 => "Siping\,\ Jilin",
  861324435 => "Tonghua\,\ Jilin",
  861324436 => "Baicheng\,\ Jilin",
  861324437 => "Liaoyuan\,\ Jilin",
  861324438 => "Songyuan\,\ Jilin",
  861324439 => "Baishan\,\ Jilin",
  861324440 => "Changchun\,\ Jilin",
  861324441 => "Changchun\,\ Jilin",
  861324442 => "Changchun\,\ Jilin",
  861324443 => "Changchun\,\ Jilin",
  861324444 => "Siping\,\ Jilin",
  861324445 => "Tonghua\,\ Jilin",
  861324446 => "Baicheng\,\ Jilin",
  861324447 => "Liaoyuan\,\ Jilin",
  861324448 => "Songyuan\,\ Jilin",
  861324449 => "Songyuan\,\ Jilin",
  861324450 => "Harbin\,\ Heilongjiang",
  861324451 => "Harbin\,\ Heilongjiang",
  861324452 => "Harbin\,\ Heilongjiang",
  861324453 => "Harbin\,\ Heilongjiang",
  861324454 => "Harbin\,\ Heilongjiang",
  861324455 => "Harbin\,\ Heilongjiang",
  861324456 => "Harbin\,\ Heilongjiang",
  861324457 => "Harbin\,\ Heilongjiang",
  861324458 => "Harbin\,\ Heilongjiang",
  861324459 => "Daqing\,\ Heilongjiang",
  861324460 => "Harbin\,\ Heilongjiang",
  861324461 => "Harbin\,\ Heilongjiang",
  861324462 => "Harbin\,\ Heilongjiang",
  861324463 => "Harbin\,\ Heilongjiang",
  861324464 => "Harbin\,\ Heilongjiang",
  861324465 => "Harbin\,\ Heilongjiang",
  861324466 => "Harbin\,\ Heilongjiang",
  861324467 => "Harbin\,\ Heilongjiang",
  861324468 => "Harbin\,\ Heilongjiang",
  861324469 => "Daqing\,\ Heilongjiang",
  86132447 => "Shenzhen\,\ Guangdong",
  861324480 => "Guangzhou\,\ Guangdong",
  861324481 => "Guangzhou\,\ Guangdong",
  861324482 => "Guangzhou\,\ Guangdong",
  861324483 => "Guangzhou\,\ Guangdong",
  861324484 => "Guangzhou\,\ Guangdong",
  861324485 => "Shenzhen\,\ Guangdong",
  861324486 => "Shenzhen\,\ Guangdong",
  861324487 => "Shenzhen\,\ Guangdong",
  861324488 => "Shenzhen\,\ Guangdong",
  861324489 => "Shenzhen\,\ Guangdong",
  861324490 => "Jiangmen\,\ Guangdong",
  861324491 => "Jiangmen\,\ Guangdong",
  861324492 => "Jiangmen\,\ Guangdong",
  861324493 => "Jiangmen\,\ Guangdong",
  861324494 => "Xingtai\,\ Hebei",
  861324495 => "Dongguan\,\ Guangdong",
  861324496 => "Dongguan\,\ Guangdong",
  861324497 => "Dongguan\,\ Guangdong",
  861324498 => "Dongguan\,\ Guangdong",
  861324499 => "Dongguan\,\ Guangdong",
  861324500 => "Changde\,\ Hunan",
  861324501 => "Changde\,\ Hunan",
  861324502 => "Changde\,\ Hunan",
  861324503 => "Changde\,\ Hunan",
  861324504 => "Changde\,\ Hunan",
  861324505 => "Suzhou\,\ Jiangsu",
  861324506 => "Suzhou\,\ Jiangsu",
  861324507 => "Suzhou\,\ Jiangsu",
  861324508 => "Suzhou\,\ Jiangsu",
  861324509 => "Suzhou\,\ Jiangsu",
  861324510 => "Hohhot\,\ Inner\ Mongolia",
  861324511 => "Hohhot\,\ Inner\ Mongolia",
  861324512 => "Baotou\,\ Inner\ Mongolia",
  861324513 => "Baotou\,\ Inner\ Mongolia",
  861324514 => "Hinggan\,\ Inner\ Mongolia",
  861324515 => "Hinggan\,\ Inner\ Mongolia",
  861324516 => "Wuhai\,\ Inner\ Mongolia",
  861324517 => "Ulanqab\,\ Inner\ Mongolia",
  861324518 => "Ulanqab\,\ Inner\ Mongolia",
  861324519 => "Xilin\,\ Inner\ Mongolia",
  86132452 => "Nanjing\,\ Jiangsu",
  861324530 => "Jinan\,\ Shandong",
  861324531 => "Jinan\,\ Shandong",
  861324532 => "Qingdao\,\ Shandong",
  861324533 => "Zibo\,\ Shandong",
  861324534 => "Liaocheng\,\ Shandong",
  861324535 => "Yantai\,\ Shandong",
  861324536 => "Rizhao\,\ Shandong",
  861324537 => "Liaocheng\,\ Shandong",
  861324538 => "TaiAn\,\ Shandong",
  861324539 => "Linyi\,\ Shandong",
  861324540 => "Jinan\,\ Shandong",
  861324541 => "Jinan\,\ Shandong",
  861324542 => "Qingdao\,\ Shandong",
  861324543 => "Binzhou\,\ Shandong",
  861324544 => "Rizhao\,\ Shandong",
  861324545 => "Dongying\,\ Shandong",
  861324546 => "Dongying\,\ Shandong",
  861324547 => "Jinan\,\ Shandong",
  861324548 => "Laiwu\,\ Shandong",
  861324549 => "Linyi\,\ Shandong",
  86132455 => "Ningbo\,\ Zhejiang",
  86132456 => "Ningbo\,\ Zhejiang",
  861324570 => "HuaiAn\,\ Jiangsu",
  861324571 => "Shaoyang\,\ Hunan",
  861324572 => "Nantong\,\ Jiangsu",
  861324573 => "Nantong\,\ Jiangsu",
  861324574 => "Nantong\,\ Jiangsu",
  861324575 => "Nantong\,\ Jiangsu",
  861324576 => "Nantong\,\ Jiangsu",
  861324577 => "Nantong\,\ Jiangsu",
  861324578 => "Nantong\,\ Jiangsu",
  861324579 => "Nantong\,\ Jiangsu",
  86132458 => "Nanjing\,\ Jiangsu",
  861324590 => "Ordos\,\ Inner\ Mongolia",
  861324591 => "Ordos\,\ Inner\ Mongolia",
  861324592 => "Bayannur\,\ Inner\ Mongolia",
  861324593 => "Bayannur\,\ Inner\ Mongolia",
  861324594 => "Chifeng\,\ Inner\ Mongolia",
  861324595 => "Chifeng\,\ Inner\ Mongolia",
  861324596 => "Tongliao\,\ Inner\ Mongolia",
  861324597 => "Tongliao\,\ Inner\ Mongolia",
  861324598 => "Hulun\,\ Inner\ Mongolia",
  861324599 => "Hulun\,\ Inner\ Mongolia",
  861324600 => "Zhongshan\,\ Guangdong",
  861324601 => "Zhongshan\,\ Guangdong",
  861324602 => "Zhongshan\,\ Guangdong",
  861324603 => "Zhongshan\,\ Guangdong",
  861324604 => "Zhongshan\,\ Guangdong",
  861324605 => "Zhongshan\,\ Guangdong",
  861324606 => "Zhongshan\,\ Guangdong",
  861324607 => "Shantou\,\ Guangdong",
  861324608 => "Shantou\,\ Guangdong",
  861324609 => "Shantou\,\ Guangdong",
  86132461 => "Huizhou\,\ Guangdong",
  86132462 => "Foshan\,\ Guangdong",
  861324630 => "Foshan\,\ Guangdong",
  861324631 => "Foshan\,\ Guangdong",
  861324632 => "Foshan\,\ Guangdong",
  861324633 => "Foshan\,\ Guangdong",
  861324634 => "Foshan\,\ Guangdong",
  861324635 => "Zhuhai\,\ Guangdong",
  861324636 => "Zhuhai\,\ Guangdong",
  861324637 => "Zhuhai\,\ Guangdong",
  861324638 => "Zhuhai\,\ Guangdong",
  861324639 => "Zhuhai\,\ Guangdong",
  86132464 => "Guangzhou\,\ Guangdong",
  861324650 => "Zhanjiang\,\ Guangdong",
  861324651 => "Zhanjiang\,\ Guangdong",
  861324652 => "Zhanjiang\,\ Guangdong",
  861324653 => "Zhanjiang\,\ Guangdong",
  861324654 => "Foshan\,\ Guangdong",
  861324655 => "Foshan\,\ Guangdong",
  861324656 => "Huizhou\,\ Guangdong",
  861324657 => "Shijiazhuang\,\ Hebei",
  861324658 => "Jiangmen\,\ Guangdong",
  861324659 => "Jiangmen\,\ Guangdong",
  86132466 => "Shenzhen\,\ Guangdong",
  86132467 => "Shenzhen\,\ Guangdong",
  86132468 => "Guangzhou\,\ Guangdong",
  861324690 => "Jieyang\,\ Guangdong",
  861324691 => "Jieyang\,\ Guangdong",
  861324692 => "Dongguan\,\ Guangdong",
  861324693 => "Dongguan\,\ Guangdong",
  861324694 => "Dongguan\,\ Guangdong",
  861324695 => "Dongguan\,\ Guangdong",
  861324696 => "Dongguan\,\ Guangdong",
  861324697 => "Dongguan\,\ Guangdong",
  861324698 => "Dongguan\,\ Guangdong",
  861324699 => "Dongguan\,\ Guangdong",
  861324700 => "Nanchang\,\ Jiangxi",
  861324701 => "Yingtan\,\ Jiangxi",
  861324702 => "Jiujiang\,\ Jiangxi",
  861324703 => "Shangrao\,\ Jiangxi",
  861324704 => "Fuzhou\,\ Jiangxi",
  861324705 => "Ganzhou\,\ Jiangxi",
  861324706 => "JiAn\,\ Jiangxi",
  861324707 => "Ganzhou\,\ Jiangxi",
  861324708 => "Nanchang\,\ Jiangxi",
  861324709 => "Nanchang\,\ Jiangxi",
  86132471 => "Wuhan\,\ Hubei",
  861324720 => "Huanggang\,\ Hubei",
  861324721 => "Xiaogan\,\ Hubei",
  861324722 => "Enshi\,\ Hubei",
  861324723 => "Huangshi\,\ Hubei",
  861324724 => "Xianning\,\ Hubei",
  861324725 => "Jingmen\,\ Hubei",
  861324726 => "Shiyan\,\ Hubei",
  861324727 => "Xiangfan\,\ Hubei",
  861324728 => "Yichang\,\ Hubei",
  861324729 => "Jingzhou\,\ Hubei",
  86132473 => "Guangzhou\,\ Guangdong",
  86132474 => "Xingtai\,\ Hebei",
  86132475 => "Guangzhou\,\ Guangdong",
  861324760 => "Shenzhen\,\ Guangdong",
  861324761 => "Shenzhen\,\ Guangdong",
  861324762 => "Shenzhen\,\ Guangdong",
  861324763 => "Shenzhen\,\ Guangdong",
  861324764 => "Shenzhen\,\ Guangdong",
  861324765 => "Guangzhou\,\ Guangdong",
  861324766 => "Guangzhou\,\ Guangdong",
  861324767 => "Guangzhou\,\ Guangdong",
  861324768 => "Guangzhou\,\ Guangdong",
  861324769 => "Guangzhou\,\ Guangdong",
  861324770 => "Nanchang\,\ Jiangxi",
  861324771 => "Nanchang\,\ Jiangxi",
  861324772 => "Jiujiang\,\ Jiangxi",
  861324773 => "Shangrao\,\ Jiangxi",
  861324774 => "Fuzhou\,\ Jiangxi",
  861324775 => "Yichun\,\ Jiangxi",
  861324776 => "Nanchang\,\ Jiangxi",
  861324777 => "Ganzhou\,\ Jiangxi",
  861324778 => "Nanchang\,\ Jiangxi",
  861324779 => "Ganzhou\,\ Jiangxi",
  861324780 => "Nanchang\,\ Jiangxi",
  861324781 => "Nanchang\,\ Jiangxi",
  861324782 => "Jiujiang\,\ Jiangxi",
  861324783 => "Shangrao\,\ Jiangxi",
  861324784 => "Nanchang\,\ Jiangxi",
  861324785 => "Jiujiang\,\ Jiangxi",
  861324786 => "Nanchang\,\ Jiangxi",
  861324787 => "Ganzhou\,\ Jiangxi",
  861324788 => "Jingdezhen\,\ Jiangxi",
  861324789 => "Ganzhou\,\ Jiangxi",
  861324790 => "Ganzhou\,\ Jiangxi",
  861324791 => "Nanchang\,\ Jiangxi",
  861324792 => "Jiujiang\,\ Jiangxi",
  861324793 => "Shangrao\,\ Jiangxi",
  861324794 => "Fuzhou\,\ Jiangxi",
  861324795 => "Yichun\,\ Jiangxi",
  861324796 => "JiAn\,\ Jiangxi",
  861324797 => "Ganzhou\,\ Jiangxi",
  861324798 => "Jingdezhen\,\ Jiangxi",
  861324799 => "Pingxiang\,\ Jiangxi",
  86132480 => "Shanghai",
  86132481 => "Shanghai",
  86132482 => "Shanghai",
  86132483 => "Shanghai",
  861324840 => "Hangzhou\,\ Zhejiang",
  861324841 => "Hangzhou\,\ Zhejiang",
  861324842 => "Hangzhou\,\ Zhejiang",
  861324843 => "Hangzhou\,\ Zhejiang",
  861324844 => "Hangzhou\,\ Zhejiang",
  861324845 => "Hangzhou\,\ Zhejiang",
  861324846 => "Jinhua\,\ Zhejiang",
  861324847 => "Jinhua\,\ Zhejiang",
  861324848 => "Jinhua\,\ Zhejiang",
  861324849 => "Jinhua\,\ Zhejiang",
  86132485 => "Ningbo\,\ Zhejiang",
  86132486 => "Ningbo\,\ Zhejiang",
  861324870 => "Ningbo\,\ Zhejiang",
  861324871 => "Ningbo\,\ Zhejiang",
  861324872 => "Ningbo\,\ Zhejiang",
  861324873 => "Ningbo\,\ Zhejiang",
  861324874 => "Ningbo\,\ Zhejiang",
  861324875 => "Wenzhou\,\ Zhejiang",
  861324876 => "Wenzhou\,\ Zhejiang",
  861324877 => "Wenzhou\,\ Zhejiang",
  861324878 => "Wenzhou\,\ Zhejiang",
  861324879 => "Wenzhou\,\ Zhejiang",
  86132488 => "Jinhua\,\ Zhejiang",
  86132489 => "Wenzhou\,\ Zhejiang",
  861324900 => "Zhongshan\,\ Guangdong",
  861324901 => "Zhongshan\,\ Guangdong",
  861324902 => "Zhongshan\,\ Guangdong",
  861324903 => "Zhongshan\,\ Guangdong",
  861324904 => "Zhongshan\,\ Guangdong",
  861324905 => "Shenzhen\,\ Guangdong",
  861324906 => "Shenzhen\,\ Guangdong",
  861324907 => "Shenzhen\,\ Guangdong",
  861324908 => "Shenzhen\,\ Guangdong",
  861324909 => "Shenzhen\,\ Guangdong",
  861324910 => "Jiangmen\,\ Guangdong",
  861324911 => "Jiangmen\,\ Guangdong",
  861324912 => "Jiangmen\,\ Guangdong",
  861324913 => "Guangzhou\,\ Guangdong",
  861324914 => "Guangzhou\,\ Guangdong",
  861324915 => "Guangzhou\,\ Guangdong",
  861324916 => "Guangzhou\,\ Guangdong",
  861324917 => "Guangzhou\,\ Guangdong",
  861324918 => "Guangzhou\,\ Guangdong",
  861324919 => "Guangzhou\,\ Guangdong",
  86132492 => "Foshan\,\ Guangdong",
  861324930 => "Huizhou\,\ Guangdong",
  861324931 => "Huizhou\,\ Guangdong",
  861324932 => "Huizhou\,\ Guangdong",
  861324933 => "Shijiazhuang\,\ Hebei",
  861324934 => "Shijiazhuang\,\ Hebei",
  861324935 => "Shijiazhuang\,\ Hebei",
  861324936 => "Huizhou\,\ Guangdong",
  861324937 => "Zhongshan\,\ Guangdong",
  861324938 => "Zhongshan\,\ Guangdong",
  861324939 => "Shenzhen\,\ Guangdong",
  861324940 => "Foshan\,\ Guangdong",
  861324941 => "Foshan\,\ Guangdong",
  861324942 => "Foshan\,\ Guangdong",
  861324943 => "Shenzhen\,\ Guangdong",
  861324944 => "Shenzhen\,\ Guangdong",
  861324945 => "Shenzhen\,\ Guangdong",
  861324946 => "Shenzhen\,\ Guangdong",
  861324947 => "Dongguan\,\ Guangdong",
  861324948 => "Shantou\,\ Guangdong",
  861324949 => "Shantou\,\ Guangdong",
  861324950 => "Xingtai\,\ Hebei",
  861324951 => "Shantou\,\ Guangdong",
  861324952 => "Shantou\,\ Guangdong",
  861324953 => "Shantou\,\ Guangdong",
  861324954 => "Shantou\,\ Guangdong",
  861324955 => "Shantou\,\ Guangdong",
  861324956 => "Shantou\,\ Guangdong",
  861324957 => "Shantou\,\ Guangdong",
  861324958 => "Shantou\,\ Guangdong",
  861324959 => "Shantou\,\ Guangdong",
  86132496 => "Guangzhou\,\ Guangdong",
  86132497 => "Guangzhou\,\ Guangdong",
  86132498 => "Shenzhen\,\ Guangdong",
  861324990 => "Dongguan\,\ Guangdong",
  861324991 => "Dongguan\,\ Guangdong",
  861324992 => "Dongguan\,\ Guangdong",
  861324993 => "Dongguan\,\ Guangdong",
  861324994 => "Dongguan\,\ Guangdong",
  861324995 => "Dongguan\,\ Guangdong",
  861324996 => "Dongguan\,\ Guangdong",
  861324997 => "Dongguan\,\ Guangdong",
  861324998 => "Dongguan\,\ Guangdong",
  861324999 => "Foshan\,\ Guangdong",
  861325000 => "Xingtai\,\ Hebei",
  861325001 => "Jiangmen\,\ Guangdong",
  861325002 => "Jiangmen\,\ Guangdong",
  861325003 => "Zhuhai\,\ Guangdong",
  861325004 => "Zhuhai\,\ Guangdong",
  861325005 => "Zhuhai\,\ Guangdong",
  861325006 => "Zhuhai\,\ Guangdong",
  861325007 => "Zhuhai\,\ Guangdong",
  861325008 => "Zhongshan\,\ Guangdong",
  861325009 => "Zhongshan\,\ Guangdong",
  861325010 => "Foshan\,\ Guangdong",
  861325011 => "Foshan\,\ Guangdong",
  861325012 => "Foshan\,\ Guangdong",
  861325013 => "Foshan\,\ Guangdong",
  861325014 => "Foshan\,\ Guangdong",
  861325015 => "Guangzhou\,\ Guangdong",
  861325016 => "Guangzhou\,\ Guangdong",
  861325017 => "Guangzhou\,\ Guangdong",
  861325018 => "Shantou\,\ Guangdong",
  861325019 => "Shantou\,\ Guangdong",
  86132502 => "Guangzhou\,\ Guangdong",
  861325030 => "Guangzhou\,\ Guangdong",
  861325031 => "Guangzhou\,\ Guangdong",
  861325032 => "Guangzhou\,\ Guangdong",
  861325033 => "Guangzhou\,\ Guangdong",
  861325034 => "Guangzhou\,\ Guangdong",
  861325035 => "Foshan\,\ Guangdong",
  861325036 => "Foshan\,\ Guangdong",
  861325037 => "Foshan\,\ Guangdong",
  861325038 => "Foshan\,\ Guangdong",
  861325039 => "Maoming\,\ Guangdong",
  861325040 => "Zhanjiang\,\ Guangdong",
  861325041 => "Zhanjiang\,\ Guangdong",
  861325042 => "Shijiazhuang\,\ Hebei",
  861325043 => "Yunfu\,\ Guangdong",
  861325044 => "Jieyang\,\ Guangdong",
  861325045 => "Jieyang\,\ Guangdong",
  861325046 => "Jiangmen\,\ Guangdong",
  861325047 => "Jiangmen\,\ Guangdong",
  861325048 => "Zhongshan\,\ Guangdong",
  861325049 => "Zhongshan\,\ Guangdong",
  86132505 => "Guangzhou\,\ Guangdong",
  861325060 => "Huizhou\,\ Guangdong",
  861325061 => "Huizhou\,\ Guangdong",
  861325062 => "Huizhou\,\ Guangdong",
  861325063 => "Huizhou\,\ Guangdong",
  861325064 => "Shantou\,\ Guangdong",
  861325065 => "Shantou\,\ Guangdong",
  861325066 => "Jieyang\,\ Guangdong",
  861325067 => "Qingyuan\,\ Guangdong",
  861325068 => "Qingyuan\,\ Guangdong",
  861325069 => "Yangjiang\,\ Guangdong",
  86132507 => "Guangzhou\,\ Guangdong",
  861325080 => "Hangzhou\,\ Zhejiang",
  861325081 => "Hangzhou\,\ Zhejiang",
  861325082 => "Hangzhou\,\ Zhejiang",
  861325083 => "Hangzhou\,\ Zhejiang",
  861325084 => "Hangzhou\,\ Zhejiang",
  861325085 => "Shaoxing\,\ Zhejiang",
  861325086 => "Taizhou\,\ Zhejiang",
  861325087 => "Wenzhou\,\ Zhejiang",
  861325088 => "Wenzhou\,\ Zhejiang",
  861325089 => "Wenzhou\,\ Zhejiang",
  861325090 => "Jiaxing\,\ Zhejiang",
  861325091 => "Jiaxing\,\ Zhejiang",
  861325092 => "Huzhou\,\ Zhejiang",
  861325093 => "Ningbo\,\ Zhejiang",
  861325094 => "Ningbo\,\ Zhejiang",
  861325095 => "Ningbo\,\ Zhejiang",
  861325096 => "Ningbo\,\ Zhejiang",
  861325097 => "Ningbo\,\ Zhejiang",
  861325098 => "Ningbo\,\ Zhejiang",
  861325099 => "Jinhua\,\ Zhejiang",
  861325100 => "Hangzhou\,\ Zhejiang",
  861325101 => "Hangzhou\,\ Zhejiang",
  861325102 => "Hangzhou\,\ Zhejiang",
  861325103 => "Wenzhou\,\ Zhejiang",
  861325104 => "Wenzhou\,\ Zhejiang",
  861325105 => "Wenzhou\,\ Zhejiang",
  861325106 => "Taizhou\,\ Zhejiang",
  861325107 => "Taizhou\,\ Zhejiang",
  861325108 => "Quzhou\,\ Zhejiang",
  861325109 => "Jinhua\,\ Zhejiang",
  86132511 => "Chongqing",
  86132512 => "Chongqing",
  86132513 => "Chongqing",
  86132514 => "Chongqing",
  861325150 => "Harbin\,\ Heilongjiang",
  861325151 => "Harbin\,\ Heilongjiang",
  861325152 => "Qiqihar\,\ Heilongjiang",
  861325153 => "Mudanjiang\,\ Heilongjiang",
  861325154 => "Jiamusi\,\ Heilongjiang",
  861325155 => "Suihua\,\ Heilongjiang",
  861325156 => "Heihe\,\ Heilongjiang",
  861325157 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861325158 => "Yichun\,\ Heilongjiang",
  861325159 => "Daqing\,\ Heilongjiang",
  861325160 => "Harbin\,\ Heilongjiang",
  861325161 => "Harbin\,\ Heilongjiang",
  861325162 => "Qiqihar\,\ Heilongjiang",
  861325163 => "Mudanjiang\,\ Heilongjiang",
  861325164 => "Qitaihe\,\ Heilongjiang",
  861325165 => "Suihua\,\ Heilongjiang",
  861325166 => "Daqing\,\ Heilongjiang",
  861325167 => "Jixi\,\ Heilongjiang",
  861325168 => "Hegang\,\ Heilongjiang",
  861325169 => "Shuangyashan\,\ Heilongjiang",
  861325170 => "Changchun\,\ Jilin",
  861325171 => "Changchun\,\ Jilin",
  861325172 => "Changchun\,\ Jilin",
  861325173 => "Changchun\,\ Jilin",
  861325174 => "Changchun\,\ Jilin",
  861325175 => "Changchun\,\ Jilin",
  861325176 => "Baicheng\,\ Jilin",
  861325177 => "Baicheng\,\ Jilin",
  861325178 => "Songyuan\,\ Jilin",
  861325179 => "Songyuan\,\ Jilin",
  861325180 => "Changchun\,\ Jilin",
  861325181 => "Changchun\,\ Jilin",
  861325182 => "Jilin\,\ Jilin",
  861325183 => "Yanbian\,\ Jilin",
  861325184 => "Siping\,\ Jilin",
  861325185 => "Tonghua\,\ Jilin",
  861325186 => "Baicheng\,\ Jilin",
  861325187 => "Liaoyuan\,\ Jilin",
  861325188 => "Songyuan\,\ Jilin",
  861325189 => "Baishan\,\ Jilin",
  861325190 => "Ningbo\,\ Zhejiang",
  861325191 => "Huzhou\,\ Zhejiang",
  861325192 => "Huzhou\,\ Zhejiang",
  861325193 => "Jiaxing\,\ Zhejiang",
  861325194 => "Jiaxing\,\ Zhejiang",
  861325195 => "Shaoxing\,\ Zhejiang",
  861325196 => "Ningbo\,\ Zhejiang",
  861325197 => "Ningbo\,\ Zhejiang",
  861325198 => "Lishui\,\ Zhejiang",
  861325199 => "Lishui\,\ Zhejiang",
  86132520 => "Huzhou\,\ Zhejiang",
  86132521 => "Shaoxing\,\ Zhejiang",
  861325220 => "Huzhou\,\ Zhejiang",
  861325221 => "Huzhou\,\ Zhejiang",
  861325222 => "Ningbo\,\ Zhejiang",
  861325223 => "Ningbo\,\ Zhejiang",
  861325224 => "Ningbo\,\ Zhejiang",
  861325225 => "Ningbo\,\ Zhejiang",
  861325226 => "Ningbo\,\ Zhejiang",
  861325227 => "Ningbo\,\ Zhejiang",
  861325228 => "Ningbo\,\ Zhejiang",
  861325229 => "Ningbo\,\ Zhejiang",
  86132523 => "Jiaxing\,\ Zhejiang",
  861325240 => "Ningbo\,\ Zhejiang",
  861325241 => "Ningbo\,\ Zhejiang",
  861325242 => "Ningbo\,\ Zhejiang",
  861325243 => "Ningbo\,\ Zhejiang",
  861325244 => "Ningbo\,\ Zhejiang",
  861325245 => "Taizhou\,\ Zhejiang",
  861325246 => "Taizhou\,\ Zhejiang",
  861325247 => "Taizhou\,\ Zhejiang",
  861325248 => "Taizhou\,\ Zhejiang",
  861325249 => "Taizhou\,\ Zhejiang",
  861325250 => "Songyuan\,\ Jilin",
  861325251 => "Songyuan\,\ Jilin",
  861325252 => "Jilin\,\ Jilin",
  861325253 => "Jilin\,\ Jilin",
  861325254 => "Jilin\,\ Jilin",
  861325255 => "Jilin\,\ Jilin",
  861325256 => "Jilin\,\ Jilin",
  861325257 => "Jilin\,\ Jilin",
  861325258 => "Jilin\,\ Jilin",
  861325259 => "Jilin\,\ Jilin",
  861325260 => "Changchun\,\ Jilin",
  861325261 => "Changchun\,\ Jilin",
  861325262 => "Changchun\,\ Jilin",
  861325263 => "Changchun\,\ Jilin",
  861325264 => "Changchun\,\ Jilin",
  861325265 => "Tonghua\,\ Jilin",
  861325266 => "Tonghua\,\ Jilin",
  861325267 => "Tonghua\,\ Jilin",
  861325268 => "Liaoyuan\,\ Jilin",
  861325269 => "Baishan\,\ Jilin",
  861325270 => "Shenyang\,\ Liaoning",
  861325271 => "Shenyang\,\ Liaoning",
  861325272 => "Shenyang\,\ Liaoning",
  861325273 => "Shenyang\,\ Liaoning",
  861325274 => "Fushun\,\ Liaoning",
  861325275 => "Fushun\,\ Liaoning",
  861325276 => "Fushun\,\ Liaoning",
  861325277 => "Chaoyang\,\ Liaoning",
  861325278 => "Chaoyang\,\ Liaoning",
  861325279 => "Tieling\,\ Liaoning",
  86132528 => "Shenyang\,\ Liaoning",
  86132529 => "Dalian\,\ Liaoning",
  861325300 => "Anyang\,\ Henan",
  861325301 => "Anyang\,\ Henan",
  861325302 => "Anyang\,\ Henan",
  861325303 => "Anyang\,\ Henan",
  861325304 => "Anyang\,\ Henan",
  861325305 => "Anyang\,\ Henan",
  861325306 => "Anyang\,\ Henan",
  861325307 => "Anyang\,\ Henan",
  861325308 => "Puyang\,\ Henan",
  861325309 => "Puyang\,\ Henan",
  861325310 => "Zhangjiakou\,\ Hebei",
  861325311 => "Zhangjiakou\,\ Hebei",
  861325312 => "Zhangjiakou\,\ Hebei",
  861325313 => "Zhangjiakou\,\ Hebei",
  861325314 => "Zhangjiakou\,\ Hebei",
  861325315 => "Zhangjiakou\,\ Hebei",
  861325316 => "Zhangjiakou\,\ Hebei",
  861325317 => "Chengde\,\ Hebei",
  861325318 => "Chengde\,\ Hebei",
  861325319 => "Chengde\,\ Hebei",
  86132532 => "Hengshui\,\ Hebei",
  86132533 => "Zhengzhou\,\ Henan",
  86132534 => "Zhengzhou\,\ Henan",
  86132535 => "Zhengzhou\,\ Henan",
  86132536 => "Zhengzhou\,\ Henan",
  861325370 => "Xuchang\,\ Henan",
  861325371 => "Xuchang\,\ Henan",
  861325372 => "Xuchang\,\ Henan",
  861325373 => "Xuchang\,\ Henan",
  861325374 => "Xuchang\,\ Henan",
  861325375 => "Zhoukou\,\ Henan",
  861325376 => "Zhoukou\,\ Henan",
  861325377 => "Zhoukou\,\ Henan",
  861325378 => "Zhoukou\,\ Henan",
  861325379 => "Zhoukou\,\ Henan",
  861325380 => "Xinyang\,\ Henan",
  861325381 => "Xinyang\,\ Henan",
  861325382 => "Xinyang\,\ Henan",
  861325383 => "Xinyang\,\ Henan",
  861325384 => "Xinyang\,\ Henan",
  861325385 => "Xinyang\,\ Henan",
  861325386 => "Jiaozuo\,\ Henan",
  861325387 => "Jiaozuo\,\ Henan",
  861325388 => "Jiaozuo\,\ Henan",
  861325389 => "Jiaozuo\,\ Henan",
  861325390 => "Luohe\,\ Henan",
  861325391 => "Luohe\,\ Henan",
  861325392 => "Sanmenxia\,\ Henan",
  861325393 => "Sanmenxia\,\ Henan",
  861325394 => "Sanmenxia\,\ Henan",
  861325395 => "Sanmenxia\,\ Henan",
  861325396 => "Sanmenxia\,\ Henan",
  861325397 => "Sanmenxia\,\ Henan",
  861325398 => "Sanmenxia\,\ Henan",
  861325399 => "Sanmenxia\,\ Henan",
  8613254 => "Shanghai",
  861325500 => "Quanzhou\,\ Fujian",
  861325501 => "Putian\,\ Fujian",
  861325502 => "Longyan\,\ Fujian",
  861325503 => "Quanzhou\,\ Fujian",
  861325504 => "Fuzhou\,\ Fujian",
  861325505 => "Fuzhou\,\ Fujian",
  861325506 => "Xiamen\,\ Fujian",
  861325507 => "Nanping\,\ Fujian",
  861325508 => "Nanping\,\ Fujian",
  861325509 => "Sanming\,\ Fujian",
  861325510 => "Wuxi\,\ Jiangsu",
  861325511 => "Wuxi\,\ Jiangsu",
  861325512 => "Suzhou\,\ Jiangsu",
  861325513 => "Suzhou\,\ Jiangsu",
  861325514 => "Suzhou\,\ Jiangsu",
  861325515 => "Suzhou\,\ Jiangsu",
  861325516 => "Suzhou\,\ Jiangsu",
  861325517 => "Suzhou\,\ Jiangsu",
  861325518 => "Suzhou\,\ Jiangsu",
  861325519 => "Suzhou\,\ Jiangsu",
  861325520 => "Wuxi\,\ Jiangsu",
  861325521 => "Wuxi\,\ Jiangsu",
  861325522 => "Wuxi\,\ Jiangsu",
  861325523 => "Nantong\,\ Jiangsu",
  861325524 => "Nantong\,\ Jiangsu",
  861325525 => "Nantong\,\ Jiangsu",
  861325526 => "Nanjing\,\ Jiangsu",
  861325527 => "Nanjing\,\ Jiangsu",
  861325528 => "Nanjing\,\ Jiangsu",
  861325529 => "Nanjing\,\ Jiangsu",
  861325530 => "Heze\,\ Shandong",
  861325531 => "Jinan\,\ Shandong",
  861325532 => "Qingdao\,\ Shandong",
  861325533 => "Zibo\,\ Shandong",
  861325534 => "Dezhou\,\ Shandong",
  861325535 => "Yantai\,\ Shandong",
  861325536 => "Weifang\,\ Shandong",
  861325537 => "Jining\,\ Shandong",
  861325538 => "TaiAn\,\ Shandong",
  861325539 => "Linyi\,\ Shandong",
  861325540 => "Heze\,\ Shandong",
  861325541 => "Jinan\,\ Shandong",
  861325542 => "Qingdao\,\ Shandong",
  861325543 => "Binzhou\,\ Shandong",
  861325544 => "Dezhou\,\ Shandong",
  861325545 => "Yantai\,\ Shandong",
  861325546 => "Dongying\,\ Shandong",
  861325547 => "Jining\,\ Shandong",
  861325548 => "TaiAn\,\ Shandong",
  861325549 => "Linyi\,\ Shandong",
  861325550 => "Yantai\,\ Shandong",
  861325551 => "Yantai\,\ Shandong",
  861325552 => "Yantai\,\ Shandong",
  861325553 => "Yantai\,\ Shandong",
  861325554 => "Yantai\,\ Shandong",
  861325555 => "Qingdao\,\ Shandong",
  861325556 => "Qingdao\,\ Shandong",
  861325557 => "Qingdao\,\ Shandong",
  861325558 => "Qingdao\,\ Shandong",
  861325559 => "Qingdao\,\ Shandong",
  861325560 => "Dongying\,\ Shandong",
  861325561 => "Dongying\,\ Shandong",
  861325562 => "Dongying\,\ Shandong",
  861325563 => "Dongying\,\ Shandong",
  861325564 => "Weihai\,\ Shandong",
  861325565 => "Weihai\,\ Shandong",
  861325566 => "Weihai\,\ Shandong",
  861325567 => "Weihai\,\ Shandong",
  861325568 => "Jinan\,\ Shandong",
  861325569 => "Jinan\,\ Shandong",
  861325570 => "Quzhou\,\ Zhejiang",
  861325571 => "Hangzhou\,\ Zhejiang",
  861325572 => "Huzhou\,\ Zhejiang",
  861325573 => "Jiaxing\,\ Zhejiang",
  861325574 => "Ningbo\,\ Zhejiang",
  861325575 => "Shaoxing\,\ Zhejiang",
  861325576 => "Taizhou\,\ Zhejiang",
  861325577 => "Wenzhou\,\ Zhejiang",
  861325578 => "Lishui\,\ Zhejiang",
  861325579 => "Jinhua\,\ Zhejiang",
  861325580 => "Zhoushan\,\ Zhejiang",
  861325581 => "Hangzhou\,\ Zhejiang",
  861325582 => "Huzhou\,\ Zhejiang",
  861325583 => "Jiaxing\,\ Zhejiang",
  861325584 => "Ningbo\,\ Zhejiang",
  861325585 => "Shaoxing\,\ Zhejiang",
  861325586 => "Taizhou\,\ Zhejiang",
  861325587 => "Wenzhou\,\ Zhejiang",
  861325588 => "Taizhou\,\ Zhejiang",
  861325589 => "Jinhua\,\ Zhejiang",
  861325590 => "Xiamen\,\ Fujian",
  861325591 => "Fuzhou\,\ Fujian",
  861325592 => "Zhengzhou\,\ Henan",
  861325593 => "Ningde\,\ Fujian",
  861325594 => "Xiamen\,\ Fujian",
  861325595 => "Quanzhou\,\ Fujian",
  861325596 => "Zhengzhou\,\ Henan",
  861325597 => "Longyan\,\ Fujian",
  861325598 => "Xiamen\,\ Fujian",
  861325599 => "Fuzhou\,\ Fujian",
  86132560 => "Rizhao\,\ Shandong",
  86132561 => "Jinan\,\ Shandong",
  861325620 => "Heze\,\ Shandong",
  861325621 => "Heze\,\ Shandong",
  861325622 => "Dezhou\,\ Shandong",
  861325623 => "Dezhou\,\ Shandong",
  861325624 => "Dezhou\,\ Shandong",
  861325625 => "Dezhou\,\ Shandong",
  861325626 => "Dezhou\,\ Shandong",
  861325627 => "Dezhou\,\ Shandong",
  861325628 => "Binzhou\,\ Shandong",
  861325629 => "Binzhou\,\ Shandong",
  861325630 => "Weihai\,\ Shandong",
  861325631 => "Weihai\,\ Shandong",
  861325632 => "Zaozhuang\,\ Shandong",
  861325633 => "Rizhao\,\ Shandong",
  861325634 => "Laiwu\,\ Shandong",
  861325635 => "Liaocheng\,\ Shandong",
  861325636 => "Weifang\,\ Shandong",
  861325637 => "Zaozhuang\,\ Shandong",
  861325638 => "Yantai\,\ Shandong",
  861325639 => "Qingdao\,\ Shandong",
  861325640 => "Jinan\,\ Shandong",
  861325641 => "Jinan\,\ Shandong",
  861325642 => "Liaocheng\,\ Shandong",
  861325643 => "Heze\,\ Shandong",
  861325644 => "Jinan\,\ Shandong",
  861325645 => "Yantai\,\ Shandong",
  861325646 => "Weifang\,\ Shandong",
  861325647 => "Dongying\,\ Shandong",
  861325648 => "Yantai\,\ Shandong",
  861325649 => "Binzhou\,\ Shandong",
  86132565 => "Linyi\,\ Shandong",
  861325660 => "Liaocheng\,\ Shandong",
  861325661 => "Liaocheng\,\ Shandong",
  861325662 => "Yantai\,\ Shandong",
  861325663 => "Heze\,\ Shandong",
  861325664 => "Heze\,\ Shandong",
  861325665 => "Jinan\,\ Shandong",
  861325666 => "Jinan\,\ Shandong",
  861325667 => "Jinan\,\ Shandong",
  861325668 => "Jinan\,\ Shandong",
  861325669 => "Jinan\,\ Shandong",
  86132567 => "Jinan\,\ Shandong",
  861325680 => "Weihai\,\ Shandong",
  861325681 => "Weihai\,\ Shandong",
  861325682 => "Qingdao\,\ Shandong",
  861325683 => "Qingdao\,\ Shandong",
  861325684 => "Qingdao\,\ Shandong",
  861325685 => "Qingdao\,\ Shandong",
  861325686 => "Qingdao\,\ Shandong",
  861325687 => "Qingdao\,\ Shandong",
  861325688 => "Qingdao\,\ Shandong",
  861325689 => "Qingdao\,\ Shandong",
  86132569 => "Yantai\,\ Shandong",
  861325700 => "Nanchang\,\ Jiangxi",
  861325701 => "Yingtan\,\ Jiangxi",
  861325702 => "Jiujiang\,\ Jiangxi",
  861325703 => "Shangrao\,\ Jiangxi",
  861325704 => "Ganzhou\,\ Jiangxi",
  861325705 => "Yichun\,\ Jiangxi",
  861325706 => "Xinyu\,\ Jiangxi",
  861325707 => "Ganzhou\,\ Jiangxi",
  861325708 => "Nanchang\,\ Jiangxi",
  861325709 => "Nanchang\,\ Jiangxi",
  861325710 => "Xiangfan\,\ Hubei",
  861325711 => "Xiaogan\,\ Hubei",
  861325712 => "Xiaogan\,\ Hubei",
  861325713 => "Huanggang\,\ Hubei",
  861325714 => "Huanggang\,\ Hubei",
  861325715 => "Xianning\,\ Hubei",
  861325716 => "Jingzhou\,\ Hubei",
  861325717 => "Huanggang\,\ Hubei",
  861325718 => "Enshi\,\ Hubei",
  861325719 => "Huanggang\,\ Hubei",
  861325720 => "Xianning\,\ Hubei",
  861325721 => "Jingzhou\,\ Hubei",
  861325722 => "Suizhou\,\ Hubei",
  861325723 => "Jingmen\,\ Hubei",
  861325724 => "Jingmen\,\ Hubei",
  861325725 => "Enshi\,\ Hubei",
  861325726 => "Enshi\,\ Hubei",
  861325727 => "Xiangfan\,\ Hubei",
  861325728 => "Wuhan\,\ Hubei",
  861325729 => "Xiangfan\,\ Hubei",
  861325730 => "Yueyang\,\ Hunan",
  861325731 => "Changsha\,\ Hunan",
  861325732 => "Xiangtan\,\ Hunan",
  861325733 => "Zhuzhou\,\ Hunan",
  861325734 => "Hengyang\,\ Hunan",
  861325735 => "Chenzhou\,\ Hunan",
  861325736 => "Changde\,\ Hunan",
  861325737 => "Yiyang\,\ Hunan",
  861325738 => "Loudi\,\ Hunan",
  861325739 => "Shaoyang\,\ Hunan",
  861325740 => "Yueyang\,\ Hunan",
  861325741 => "Zhuzhou\,\ Hunan",
  861325742 => "Changde\,\ Hunan",
  861325743 => "Xiangxi\,\ Hunan",
  861325744 => "Zhangjiajie\,\ Hunan",
  861325745 => "Huaihua\,\ Hunan",
  861325746 => "Yongzhou\,\ Hunan",
  861325747 => "Yiyang\,\ Hunan",
  861325748 => "Changsha\,\ Hunan",
  861325749 => "Xiangtan\,\ Hunan",
  861325750 => "Jiangmen\,\ Guangdong",
  861325751 => "Shaoguan\,\ Guangdong",
  861325752 => "Huizhou\,\ Guangdong",
  861325753 => "Meizhou\,\ Guangdong",
  861325754 => "Shantou\,\ Guangdong",
  861325755 => "Shijiazhuang\,\ Hebei",
  861325756 => "Zhuhai\,\ Guangdong",
  861325757 => "Foshan\,\ Guangdong",
  861325758 => "Zhaoqing\,\ Guangdong",
  861325759 => "Zhanjiang\,\ Guangdong",
  861325760 => "Zhongshan\,\ Guangdong",
  861325761 => "Shanwei\,\ Guangdong",
  861325762 => "Heyuan\,\ Guangdong",
  861325763 => "Baoding\,\ Hebei",
  861325764 => "Yangjiang\,\ Guangdong",
  861325765 => "Yangjiang\,\ Guangdong",
  861325766 => "Yunfu\,\ Guangdong",
  861325767 => "Maoming\,\ Guangdong",
  861325768 => "Chaozhou\,\ Guangdong",
  861325769 => "Dongguan\,\ Guangdong",
  86132577 => "Nanning\,\ Guangxi",
  861325780 => "Liuzhou\,\ Guangxi",
  861325781 => "Liuzhou\,\ Guangxi",
  861325782 => "Laibin\,\ Guangxi",
  861325783 => "Laibin\,\ Guangxi",
  861325784 => "Laibin\,\ Guangxi",
  861325785 => "Yulin\,\ Guangxi",
  861325786 => "Yulin\,\ Guangxi",
  861325787 => "Yulin\,\ Guangxi",
  861325788 => "Yulin\,\ Guangxi",
  861325789 => "Yulin\,\ Guangxi",
  861325790 => "Xinyu\,\ Jiangxi",
  861325791 => "Nanchang\,\ Jiangxi",
  861325792 => "Jiujiang\,\ Jiangxi",
  861325793 => "Shangrao\,\ Jiangxi",
  861325794 => "Fuzhou\,\ Jiangxi",
  861325795 => "Yichun\,\ Jiangxi",
  861325796 => "JiAn\,\ Jiangxi",
  861325797 => "Ganzhou\,\ Jiangxi",
  861325798 => "Jingdezhen\,\ Jiangxi",
  861325799 => "Pingxiang\,\ Jiangxi",
  861325800 => "Jining\,\ Shandong",
  861325801 => "Jining\,\ Shandong",
  861325802 => "Jining\,\ Shandong",
  861325803 => "Jining\,\ Shandong",
  861325804 => "Jining\,\ Shandong",
  861325805 => "Jining\,\ Shandong",
  861325806 => "Weifang\,\ Shandong",
  861325807 => "Weifang\,\ Shandong",
  861325808 => "Weifang\,\ Shandong",
  861325809 => "Weifang\,\ Shandong",
  86132581 => "Chengdu\,\ Sichuan",
  86132582 => "Chengdu\,\ Sichuan",
  86132583 => "Chengdu\,\ Sichuan",
  861325840 => "Nanchong\,\ Sichuan",
  861325841 => "Nanchong\,\ Sichuan",
  861325842 => "Mianyang\,\ Sichuan",
  861325843 => "Mianyang\,\ Sichuan",
  861325844 => "Mianyang\,\ Sichuan",
  861325845 => "Mianyang\,\ Sichuan",
  861325846 => "Deyang\,\ Sichuan",
  861325847 => "Deyang\,\ Sichuan",
  861325848 => "Suining\,\ Sichuan",
  861325849 => "GuangAn\,\ Sichuan",
  861325850 => "Mudanjiang\,\ Heilongjiang",
  861325851 => "Mudanjiang\,\ Heilongjiang",
  861325852 => "Jixi\,\ Heilongjiang",
  861325853 => "Jixi\,\ Heilongjiang",
  861325854 => "Shuangyashan\,\ Heilongjiang",
  861325855 => "Shuangyashan\,\ Heilongjiang",
  861325856 => "Hegang\,\ Heilongjiang",
  861325857 => "Suihua\,\ Heilongjiang",
  861325858 => "Suihua\,\ Heilongjiang",
  861325859 => "Qitaihe\,\ Heilongjiang",
  861325860 => "Jiamusi\,\ Heilongjiang",
  861325861 => "Jiamusi\,\ Heilongjiang",
  861325862 => "Jiamusi\,\ Heilongjiang",
  861325863 => "Daqing\,\ Heilongjiang",
  861325864 => "Daqing\,\ Heilongjiang",
  861325865 => "Daqing\,\ Heilongjiang",
  861325866 => "Harbin\,\ Heilongjiang",
  861325867 => "Harbin\,\ Heilongjiang",
  861325868 => "Qiqihar\,\ Heilongjiang",
  861325869 => "Qiqihar\,\ Heilongjiang",
  861325870 => "Siping\,\ Jilin",
  861325871 => "Siping\,\ Jilin",
  861325872 => "Siping\,\ Jilin",
  861325873 => "Siping\,\ Jilin",
  861325874 => "Tonghua\,\ Jilin",
  861325875 => "Tonghua\,\ Jilin",
  861325876 => "Tonghua\,\ Jilin",
  861325877 => "Tonghua\,\ Jilin",
  861325878 => "Siping\,\ Jilin",
  861325879 => "Siping\,\ Jilin",
  861325880 => "Siping\,\ Jilin",
  861325881 => "Yanbian\,\ Jilin",
  861325882 => "Yanbian\,\ Jilin",
  861325883 => "Yanbian\,\ Jilin",
  861325884 => "Changchun\,\ Jilin",
  861325885 => "Tonghua\,\ Jilin",
  861325886 => "Baicheng\,\ Jilin",
  861325887 => "Baicheng\,\ Jilin",
  861325888 => "Changchun\,\ Jilin",
  861325889 => "Baishan\,\ Jilin",
  861325890 => "Binzhou\,\ Shandong",
  861325891 => "Binzhou\,\ Shandong",
  861325892 => "Heze\,\ Shandong",
  861325893 => "Heze\,\ Shandong",
  861325894 => "Rizhao\,\ Shandong",
  861325895 => "Rizhao\,\ Shandong",
  861325896 => "Zaozhuang\,\ Shandong",
  861325897 => "Zaozhuang\,\ Shandong",
  861325898 => "Liaocheng\,\ Shandong",
  861325899 => "Liaocheng\,\ Shandong",
  861325900 => "Xianyang\,\ Shaanxi",
  861325901 => "Xianyang\,\ Shaanxi",
  861325902 => "Xianyang\,\ Shaanxi",
  861325903 => "Xianyang\,\ Shaanxi",
  861325904 => "Xianyang\,\ Shaanxi",
  861325905 => "Xianyang\,\ Shaanxi",
  861325906 => "Weinan\,\ Shaanxi",
  861325907 => "Weinan\,\ Shaanxi",
  861325908 => "Weinan\,\ Shaanxi",
  861325909 => "Weinan\,\ Shaanxi",
  861325910 => "Xianyang\,\ Shaanxi",
  861325911 => "YanAn\,\ Shaanxi",
  861325912 => "Yulin\,\ Shaanxi",
  861325913 => "Weinan\,\ Shaanxi",
  861325914 => "Shangluo\,\ Shaanxi",
  861325915 => "Ankang\,\ Shaanxi",
  861325916 => "Hanzhong\,\ Shaanxi",
  861325917 => "Baoji\,\ Shaanxi",
  861325918 => "Shangluo\,\ Shaanxi",
  861325919 => "Tongchuan\,\ Shaanxi",
  861325920 => "Weinan\,\ Shaanxi",
  861325921 => "Baoji\,\ Shaanxi",
  861325922 => "Baoji\,\ Shaanxi",
  861325923 => "Baoji\,\ Shaanxi",
  861325924 => "Baoji\,\ Shaanxi",
  861325925 => "Hanzhong\,\ Shaanxi",
  861325926 => "Hanzhong\,\ Shaanxi",
  861325927 => "Hanzhong\,\ Shaanxi",
  861325928 => "Hanzhong\,\ Shaanxi",
  861325929 => "Hanzhong\,\ Shaanxi",
  861325930 => "YanAn\,\ Shaanxi",
  861325931 => "YanAn\,\ Shaanxi",
  861325932 => "YanAn\,\ Shaanxi",
  861325933 => "Yulin\,\ Shaanxi",
  861325934 => "Yulin\,\ Shaanxi",
  861325935 => "Yulin\,\ Shaanxi",
  861325936 => "Yulin\,\ Shaanxi",
  861325937 => "Yulin\,\ Shaanxi",
  861325938 => "Yulin\,\ Shaanxi",
  861325939 => "Ankang\,\ Shaanxi",
  86132594 => "XiAn\,\ Shaanxi",
  861325950 => "Yinchuan\,\ Ningxia",
  861325951 => "Yinchuan\,\ Ningxia",
  861325952 => "Shizuishan\,\ Ningxia",
  861325953 => "Wuzhong\,\ Ningxia",
  861325954 => "Guyuan\,\ Ningxia",
  861325955 => "Zhongwei\,\ Ningxia",
  861325956 => "Wuzhong\,\ Ningxia",
  861325957 => "Zhongwei\,\ Ningxia",
  861325958 => "Yinchuan\,\ Ningxia",
  861325959 => "Zhongwei\,\ Ningxia",
  861325960 => "Yinchuan\,\ Ningxia",
  861325961 => "Yinchuan\,\ Ningxia",
  861325962 => "Shizuishan\,\ Ningxia",
  861325963 => "Wuzhong\,\ Ningxia",
  861325964 => "Guyuan\,\ Ningxia",
  861325965 => "Zhongwei\,\ Ningxia",
  861325966 => "Wuzhong\,\ Ningxia",
  861325967 => "Zhongwei\,\ Ningxia",
  861325968 => "Yinchuan\,\ Ningxia",
  861325969 => "Zhongwei\,\ Ningxia",
  86132597 => "XiAn\,\ Shaanxi",
  86132598 => "XiAn\,\ Shaanxi",
  86132599 => "XiAn\,\ Shaanxi",
  861326000 => "Beijing",
  861326001 => "Beijing",
  861326002 => "Beijing",
  861326003 => "Beijing",
  861326004 => "Hohhot\,\ Inner\ Mongolia",
  861326005 => "Beijing",
  861326006 => "Beijing",
  861326007 => "Beijing",
  861326008 => "Beijing",
  861326009 => "Beijing",
  861326010 => "Beijing",
  861326011 => "Beijing",
  861326012 => "Beijing",
  861326013 => "Beijing",
  861326014 => "Chifeng\,\ Inner\ Mongolia",
  861326015 => "Beijing",
  861326016 => "Beijing",
  861326017 => "Beijing",
  861326018 => "Beijing",
  861326019 => "Beijing",
  861326020 => "Beijing",
  861326021 => "Beijing",
  861326022 => "Beijing",
  861326023 => "Beijing",
  861326024 => "Alxa\,\ Inner\ Mongolia",
  861326025 => "Beijing",
  861326026 => "Beijing",
  861326027 => "Beijing",
  861326028 => "Beijing",
  861326029 => "Beijing",
  861326030 => "Beijing",
  861326031 => "Beijing",
  861326032 => "Beijing",
  861326033 => "Beijing",
  861326034 => "Qingyang\,\ Gansu",
  861326035 => "Beijing",
  861326036 => "Beijing",
  861326037 => "Beijing",
  861326038 => "Beijing",
  861326039 => "Beijing",
  86132604 => "Beijing",
  86132605 => "Wuhan\,\ Hubei",
  86132606 => "Wuhan\,\ Hubei",
  86132607 => "Nanjing\,\ Jiangsu",
  861326080 => "Nanjing\,\ Jiangsu",
  861326081 => "Nanjing\,\ Jiangsu",
  861326082 => "Nanjing\,\ Jiangsu",
  861326083 => "Nanjing\,\ Jiangsu",
  861326084 => "Nanjing\,\ Jiangsu",
  861326085 => "Nanjing\,\ Jiangsu",
  861326086 => "Nanjing\,\ Jiangsu",
  861326087 => "Nanjing\,\ Jiangsu",
  861326088 => "Nanjing\,\ Jiangsu",
  861326089 => "Shaoyang\,\ Hunan",
  86132609 => "Nanjing\,\ Jiangsu",
  8613261 => "Beijing",
  86132620 => "Nanyang\,\ Henan",
  86132621 => "Xinxiang\,\ Henan",
  86132622 => "Shanghai",
  86132623 => "Wenzhou\,\ Zhejiang",
  86132624 => "Wenzhou\,\ Zhejiang",
  86132625 => "Shanghai",
  86132626 => "Shanghai",
  86132627 => "Shanghai",
  86132628 => "Shanghai",
  86132629 => "Shanghai",
  861326300 => "Nanchang\,\ Jiangxi",
  861326301 => "Ganzhou\,\ Jiangxi",
  861326302 => "Jiujiang\,\ Jiangxi",
  861326303 => "Shangrao\,\ Jiangxi",
  861326304 => "Shangrao\,\ Jiangxi",
  861326305 => "Yichun\,\ Jiangxi",
  861326306 => "Ganzhou\,\ Jiangxi",
  861326307 => "Ganzhou\,\ Jiangxi",
  861326308 => "Fuzhou\,\ Jiangxi",
  861326309 => "Nanchang\,\ Jiangxi",
  86132631 => "Beijing",
  861326320 => "Beijing",
  861326321 => "Beijing",
  861326322 => "Beijing",
  861326323 => "Beijing",
  861326324 => "Qingyang\,\ Gansu",
  861326325 => "Beijing",
  861326326 => "Beijing",
  861326327 => "Beijing",
  861326328 => "Beijing",
  861326329 => "Beijing",
  861326330 => "Beijing",
  861326331 => "Beijing",
  861326332 => "Beijing",
  861326333 => "Beijing",
  861326334 => "Qingyang\,\ Gansu",
  861326335 => "Beijing",
  861326336 => "Beijing",
  861326337 => "Beijing",
  861326338 => "Beijing",
  861326339 => "Beijing",
  86132634 => "Beijing",
  861326350 => "Harbin\,\ Heilongjiang",
  861326351 => "Harbin\,\ Heilongjiang",
  861326352 => "Qiqihar\,\ Heilongjiang",
  861326353 => "Mudanjiang\,\ Heilongjiang",
  861326354 => "Harbin\,\ Heilongjiang",
  861326355 => "Harbin\,\ Heilongjiang",
  861326356 => "Qitaihe\,\ Heilongjiang",
  861326357 => "Shuangyashan\,\ Heilongjiang",
  861326358 => "Daqing\,\ Heilongjiang",
  861326359 => "Daqing\,\ Heilongjiang",
  861326360 => "Harbin\,\ Heilongjiang",
  861326361 => "Harbin\,\ Heilongjiang",
  861326362 => "Harbin\,\ Heilongjiang",
  861326363 => "Harbin\,\ Heilongjiang",
  861326364 => "Daqing\,\ Heilongjiang",
  861326365 => "Daqing\,\ Heilongjiang",
  861326366 => "Harbin\,\ Heilongjiang",
  861326367 => "Harbin\,\ Heilongjiang",
  861326368 => "Harbin\,\ Heilongjiang",
  861326369 => "Harbin\,\ Heilongjiang",
  861326370 => "Nanning\,\ Guangxi",
  861326371 => "Nanning\,\ Guangxi",
  861326372 => "Liuzhou\,\ Guangxi",
  861326373 => "Guilin\,\ Guangxi",
  861326374 => "Wuzhou\,\ Guangxi",
  861326375 => "Yulin\,\ Guangxi",
  861326376 => "Wuzhou\,\ Guangxi",
  861326377 => "Qinzhou\,\ Guangxi",
  861326378 => "Nanning\,\ Guangxi",
  861326379 => "Hezhou\,\ Guangxi",
  861326380 => "Nanning\,\ Guangxi",
  861326381 => "Nanning\,\ Guangxi",
  861326382 => "Liuzhou\,\ Guangxi",
  861326383 => "Guilin\,\ Guangxi",
  861326384 => "Hezhou\,\ Guangxi",
  861326385 => "Laibin\,\ Guangxi",
  861326386 => "Wuzhou\,\ Guangxi",
  861326387 => "Laibin\,\ Guangxi",
  861326388 => "Nanning\,\ Guangxi",
  861326389 => "Guigang\,\ Guangxi",
  861326390 => "Yichun\,\ Jiangxi",
  861326391 => "Nanchang\,\ Jiangxi",
  861326392 => "Jiujiang\,\ Jiangxi",
  861326393 => "Shangrao\,\ Jiangxi",
  861326394 => "Fuzhou\,\ Jiangxi",
  861326395 => "Yichun\,\ Jiangxi",
  861326396 => "JiAn\,\ Jiangxi",
  861326397 => "Ganzhou\,\ Jiangxi",
  861326398 => "Jingdezhen\,\ Jiangxi",
  861326399 => "Pingxiang\,\ Jiangxi",
  86132640 => "Beijing",
  86132641 => "Beijing",
  86132642 => "Beijing",
  86132643 => "Beijing",
  86132644 => "Beijing",
  861326450 => "Beijing",
  861326451 => "Beijing",
  861326452 => "Beijing",
  861326453 => "Beijing",
  861326454 => "Linxia\,\ Gansu",
  861326455 => "Beijing",
  861326456 => "Beijing",
  861326457 => "Beijing",
  861326458 => "Beijing",
  861326459 => "Beijing",
  86132646 => "Jingzhou\,\ Hubei",
  861326470 => "Wuhan\,\ Hubei",
  861326471 => "Wuhan\,\ Hubei",
  861326472 => "Wuhan\,\ Hubei",
  861326473 => "Wuhan\,\ Hubei",
  861326474 => "Wuhan\,\ Hubei",
  861326475 => "Suizhou\,\ Hubei",
  861326476 => "Suizhou\,\ Hubei",
  861326477 => "Xiangfan\,\ Hubei",
  861326478 => "Xiangfan\,\ Hubei",
  861326479 => "Xiangfan\,\ Hubei",
  861326480 => "Huanggang\,\ Hubei",
  861326481 => "Huanggang\,\ Hubei",
  861326482 => "Huanggang\,\ Hubei",
  861326483 => "Huanggang\,\ Hubei",
  861326484 => "Xiaogan\,\ Hubei",
  861326485 => "Xiaogan\,\ Hubei",
  861326486 => "Xiaogan\,\ Hubei",
  861326487 => "Xiaogan\,\ Hubei",
  861326488 => "Shiyan\,\ Hubei",
  861326489 => "Shiyan\,\ Hubei",
  861326490 => "Yichang\,\ Hubei",
  861326491 => "Yichang\,\ Hubei",
  861326492 => "Enshi\,\ Hubei",
  861326493 => "Enshi\,\ Hubei",
  861326494 => "Ezhou\,\ Hubei",
  861326495 => "Jingmen\,\ Hubei",
  861326496 => "Jingmen\,\ Hubei",
  861326497 => "Wuhan\,\ Hubei",
  861326498 => "Wuhan\,\ Hubei",
  861326499 => "Ezhou\,\ Hubei",
  86132650 => "Guangzhou\,\ Guangdong",
  86132651 => "Guangzhou\,\ Guangdong",
  86132652 => "Dongguan\,\ Guangdong",
  86132653 => "Guangzhou\,\ Guangdong",
  86132654 => "Shenzhen\,\ Guangdong",
  861326550 => "Guangzhou\,\ Guangdong",
  861326551 => "Guangzhou\,\ Guangdong",
  861326552 => "Shenzhen\,\ Guangdong",
  861326553 => "Shenzhen\,\ Guangdong",
  861326554 => "Shenzhen\,\ Guangdong",
  861326555 => "Shenzhen\,\ Guangdong",
  861326556 => "Shenzhen\,\ Guangdong",
  861326557 => "Shenzhen\,\ Guangdong",
  861326558 => "Shenzhen\,\ Guangdong",
  861326559 => "Shenzhen\,\ Guangdong",
  86132656 => "Shenzhen\,\ Guangdong",
  86132657 => "Shenzhen\,\ Guangdong",
  86132658 => "Shenzhen\,\ Guangdong",
  86132659 => "Guangzhou\,\ Guangdong",
  86132660 => "Dongguan\,\ Guangdong",
  86132661 => "Dongguan\,\ Guangdong",
  86132662 => "Dongguan\,\ Guangdong",
  86132663 => "Foshan\,\ Guangdong",
  861326640 => "Zhanjiang\,\ Guangdong",
  861326641 => "Zhanjiang\,\ Guangdong",
  861326642 => "Zhanjiang\,\ Guangdong",
  861326643 => "Zhanjiang\,\ Guangdong",
  861326644 => "Zhanjiang\,\ Guangdong",
  861326645 => "Jiangmen\,\ Guangdong",
  861326646 => "Jiangmen\,\ Guangdong",
  861326647 => "Xingtai\,\ Hebei",
  861326648 => "Jiangmen\,\ Guangdong",
  861326649 => "Jiangmen\,\ Guangdong",
  86132665 => "Shenzhen\,\ Guangdong",
  86132666 => "Shenzhen\,\ Guangdong",
  86132667 => "Shenzhen\,\ Guangdong",
  86132668 => "Shenzhen\,\ Guangdong",
  861326690 => "Shijiazhuang\,\ Hebei",
  861326691 => "Shijiazhuang\,\ Hebei",
  861326692 => "Dongguan\,\ Guangdong",
  861326693 => "Dongguan\,\ Guangdong",
  861326694 => "Dongguan\,\ Guangdong",
  861326695 => "Dongguan\,\ Guangdong",
  861326696 => "Shenzhen\,\ Guangdong",
  861326697 => "Dongguan\,\ Guangdong",
  861326698 => "Shenzhen\,\ Guangdong",
  861326699 => "Shenzhen\,\ Guangdong",
  86132670 => "Shenzhen\,\ Guangdong",
  86132671 => "Shenzhen\,\ Guangdong",
  861326720 => "Shenzhen\,\ Guangdong",
  861326721 => "Shenzhen\,\ Guangdong",
  861326722 => "Shenzhen\,\ Guangdong",
  861326723 => "Shenzhen\,\ Guangdong",
  861326724 => "Shenzhen\,\ Guangdong",
  861326725 => "Dongguan\,\ Guangdong",
  861326726 => "Dongguan\,\ Guangdong",
  861326727 => "Dongguan\,\ Guangdong",
  861326728 => "Dongguan\,\ Guangdong",
  861326729 => "Dongguan\,\ Guangdong",
  86132673 => "Dongguan\,\ Guangdong",
  86132674 => "Dongguan\,\ Guangdong",
  86132675 => "Dongguan\,\ Guangdong",
  861326760 => "Zhongshan\,\ Guangdong",
  861326761 => "Zhongshan\,\ Guangdong",
  861326762 => "Zhongshan\,\ Guangdong",
  861326763 => "Zhongshan\,\ Guangdong",
  861326764 => "Zhongshan\,\ Guangdong",
  861326765 => "Jiangmen\,\ Guangdong",
  861326766 => "Jiangmen\,\ Guangdong",
  861326767 => "Jiangmen\,\ Guangdong",
  861326768 => "Jiangmen\,\ Guangdong",
  861326769 => "Jiangmen\,\ Guangdong",
  861326770 => "Shanwei\,\ Guangdong",
  861326771 => "Shanwei\,\ Guangdong",
  861326772 => "Shanwei\,\ Guangdong",
  861326773 => "Shanwei\,\ Guangdong",
  861326774 => "Shanwei\,\ Guangdong",
  861326775 => "Shantou\,\ Guangdong",
  861326776 => "Shantou\,\ Guangdong",
  861326777 => "Shantou\,\ Guangdong",
  861326778 => "Shantou\,\ Guangdong",
  861326779 => "Shantou\,\ Guangdong",
  861326780 => "Meizhou\,\ Guangdong",
  861326781 => "Meizhou\,\ Guangdong",
  861326782 => "Meizhou\,\ Guangdong",
  861326783 => "Shijiazhuang\,\ Hebei",
  861326784 => "Shijiazhuang\,\ Hebei",
  861326785 => "Zhanjiang\,\ Guangdong",
  861326786 => "Zhanjiang\,\ Guangdong",
  861326787 => "Zhanjiang\,\ Guangdong",
  861326788 => "Zhanjiang\,\ Guangdong",
  861326789 => "Zhanjiang\,\ Guangdong",
  861326790 => "Huizhou\,\ Guangdong",
  861326791 => "Huizhou\,\ Guangdong",
  861326792 => "Huizhou\,\ Guangdong",
  861326793 => "Huizhou\,\ Guangdong",
  861326794 => "Huizhou\,\ Guangdong",
  861326795 => "Zhuhai\,\ Guangdong",
  861326796 => "Zhuhai\,\ Guangdong",
  861326797 => "Zhuhai\,\ Guangdong",
  861326798 => "Zhuhai\,\ Guangdong",
  861326799 => "Zhuhai\,\ Guangdong",
  86132680 => "Guangzhou\,\ Guangdong",
  86132681 => "Guangzhou\,\ Guangdong",
  86132682 => "Guangzhou\,\ Guangdong",
  86132683 => "Guangzhou\,\ Guangdong",
  86132684 => "Dongguan\,\ Guangdong",
  86132685 => "Dongguan\,\ Guangdong",
  86132686 => "Dongguan\,\ Guangdong",
  86132687 => "Dongguan\,\ Guangdong",
  86132688 => "Dongguan\,\ Guangdong",
  86132689 => "Dongguan\,\ Guangdong",
  86132690 => "Beijing",
  861326910 => "Beijing",
  861326911 => "Beijing",
  861326912 => "Beijing",
  861326913 => "Beijing",
  861326914 => "Linxia\,\ Gansu",
  861326915 => "Beijing",
  861326916 => "Beijing",
  861326917 => "Beijing",
  861326918 => "Beijing",
  861326919 => "Beijing",
  861326920 => "Beijing",
  861326921 => "Beijing",
  861326922 => "Beijing",
  861326923 => "Beijing",
  861326924 => "Linxia\,\ Gansu",
  861326925 => "Beijing",
  861326926 => "Beijing",
  861326927 => "Beijing",
  861326928 => "Beijing",
  861326929 => "Beijing",
  861326930 => "Beijing",
  861326931 => "Beijing",
  861326932 => "Beijing",
  861326933 => "Beijing",
  861326934 => "Zhangye\,\ Gansu",
  861326935 => "Beijing",
  861326936 => "Beijing",
  861326937 => "Beijing",
  861326938 => "Beijing",
  861326939 => "Beijing",
  86132694 => "Beijing",
  861326950 => "Beijing",
  861326951 => "Beijing",
  861326952 => "Beijing",
  861326953 => "Beijing",
  861326954 => "Qingyang\,\ Gansu",
  861326955 => "Beijing",
  861326956 => "Beijing",
  861326957 => "Beijing",
  861326958 => "Beijing",
  861326959 => "Beijing",
  86132696 => "Beijing",
  86132697 => "Beijing",
  861326980 => "Beijing",
  861326981 => "Beijing",
  861326982 => "Beijing",
  861326983 => "Beijing",
  861326984 => "Pingliang\,\ Gansu",
  861326985 => "Beijing",
  861326986 => "Beijing",
  861326987 => "Beijing",
  861326988 => "Beijing",
  861326989 => "Beijing",
  861326990 => "Beijing",
  861326991 => "Beijing",
  861326992 => "Beijing",
  861326993 => "Beijing",
  861326994 => "Tianshui\,\ Gansu",
  861326995 => "Beijing",
  861326996 => "Beijing",
  861326997 => "Beijing",
  861326998 => "Beijing",
  861326999 => "Beijing",
  861327000 => "Yangzhou\,\ Jiangsu",
  861327001 => "Yangzhou\,\ Jiangsu",
  861327002 => "Yancheng\,\ Jiangsu",
  861327003 => "Yancheng\,\ Jiangsu",
  861327004 => "Yancheng\,\ Jiangsu",
  861327005 => "Yancheng\,\ Jiangsu",
  861327006 => "Yancheng\,\ Jiangsu",
  861327007 => "Yancheng\,\ Jiangsu",
  861327008 => "Yancheng\,\ Jiangsu",
  861327009 => "Yancheng\,\ Jiangsu",
  86132701 => "Wuxi\,\ Jiangsu",
  86132702 => "Xuzhou\,\ Jiangsu",
  861327030 => "Wuhai\,\ Inner\ Mongolia",
  861327031 => "Bayannur\,\ Inner\ Mongolia",
  861327032 => "Zhenjiang\,\ Jiangsu",
  861327033 => "Xuzhou\,\ Jiangsu",
  861327034 => "Baiyin\,\ Gansu",
  861327035 => "Xuzhou\,\ Jiangsu",
  861327036 => "Xuzhou\,\ Jiangsu",
  861327037 => "Changzhou\,\ Jiangsu",
  861327038 => "Changzhou\,\ Jiangsu",
  861327039 => "Changzhou\,\ Jiangsu",
  861327040 => "Lianyungang\,\ Jiangsu",
  861327041 => "Wuxi\,\ Jiangsu",
  861327042 => "Wuxi\,\ Jiangsu",
  861327043 => "Nantong\,\ Jiangsu",
  861327044 => "Nanjing\,\ Jiangsu",
  861327045 => "Nanjing\,\ Jiangsu",
  861327046 => "Suzhou\,\ Jiangsu",
  861327047 => "Suzhou\,\ Jiangsu",
  861327048 => "Xuzhou\,\ Jiangsu",
  861327049 => "Shaoyang\,\ Hunan",
  86132705 => "Yangzhou\,\ Jiangsu",
  861327060 => "Lianyungang\,\ Jiangsu",
  861327061 => "Nantong\,\ Jiangsu",
  861327062 => "Nantong\,\ Jiangsu",
  861327063 => "Tongliao\,\ Inner\ Mongolia",
  861327064 => "Chenzhou\,\ Hunan",
  861327065 => "Chenzhou\,\ Hunan",
  861327066 => "Nantong\,\ Jiangsu",
  861327067 => "Nantong\,\ Jiangsu",
  861327068 => "Nantong\,\ Jiangsu",
  861327069 => "Nantong\,\ Jiangsu",
  861327070 => "Nanjing\,\ Jiangsu",
  861327071 => "Nanjing\,\ Jiangsu",
  861327072 => "Nanjing\,\ Jiangsu",
  861327073 => "Nanjing\,\ Jiangsu",
  861327074 => "Nanjing\,\ Jiangsu",
  861327075 => "Nanjing\,\ Jiangsu",
  861327076 => "Taizhou\,\ Jiangsu",
  861327077 => "Taizhou\,\ Jiangsu",
  861327078 => "Taizhou\,\ Jiangsu",
  861327079 => "Taizhou\,\ Jiangsu",
  86132708 => "Nanjing\,\ Jiangsu",
  861327090 => "Changzhou\,\ Jiangsu",
  861327091 => "Changzhou\,\ Jiangsu",
  861327092 => "Changzhou\,\ Jiangsu",
  861327093 => "Changzhou\,\ Jiangsu",
  861327094 => "Changzhou\,\ Jiangsu",
  861327095 => "Changzhou\,\ Jiangsu",
  861327096 => "Suzhou\,\ Jiangsu",
  861327097 => "Suzhou\,\ Jiangsu",
  861327098 => "Suzhou\,\ Jiangsu",
  861327099 => "Suzhou\,\ Jiangsu",
  86132710 => "Shangqiu\,\ Henan",
  861327110 => "Shangqiu\,\ Henan",
  861327111 => "Shangqiu\,\ Henan",
  861327112 => "Xinyang\,\ Henan",
  861327113 => "Xinyang\,\ Henan",
  861327114 => "Kaifeng\,\ Henan",
  861327115 => "Kaifeng\,\ Henan",
  861327116 => "Zhoukou\,\ Henan",
  861327117 => "Zhoukou\,\ Henan",
  861327118 => "Xuchang\,\ Henan",
  861327119 => "Xuchang\,\ Henan",
  86132712 => "Xuchang\,\ Henan",
  86132713 => "Nanyang\,\ Henan",
  86132714 => "Pingdingshan\,\ Henan",
  861327150 => "Luoyang\,\ Henan",
  861327151 => "Luoyang\,\ Henan",
  861327152 => "Luoyang\,\ Henan",
  861327153 => "Luoyang\,\ Henan",
  861327154 => "Luoyang\,\ Henan",
  861327155 => "Zhengzhou\,\ Henan",
  861327156 => "Zhengzhou\,\ Henan",
  861327157 => "Zhengzhou\,\ Henan",
  861327158 => "Zhengzhou\,\ Henan",
  861327159 => "Zhengzhou\,\ Henan",
  86132716 => "Zhoukou\,\ Henan",
  861327170 => "Zhumadian\,\ Henan",
  861327171 => "Zhumadian\,\ Henan",
  861327172 => "Zhumadian\,\ Henan",
  861327173 => "Zhumadian\,\ Henan",
  861327174 => "Zhumadian\,\ Henan",
  861327175 => "Zhumadian\,\ Henan",
  861327176 => "Zhumadian\,\ Henan",
  861327177 => "Zhumadian\,\ Henan",
  861327178 => "Nanyang\,\ Henan",
  861327179 => "Nanyang\,\ Henan",
  86132718 => "Chongqing",
  86132719 => "Chongqing",
  86132720 => "Changsha\,\ Hunan",
  861327210 => "Zhuzhou\,\ Hunan",
  861327211 => "Zhuzhou\,\ Hunan",
  861327212 => "Zhuzhou\,\ Hunan",
  861327213 => "Zhuzhou\,\ Hunan",
  861327214 => "Zhuzhou\,\ Hunan",
  861327215 => "Yiyang\,\ Hunan",
  861327216 => "Yiyang\,\ Hunan",
  861327217 => "Yiyang\,\ Hunan",
  861327218 => "Yiyang\,\ Hunan",
  861327219 => "Yiyang\,\ Hunan",
  861327220 => "Shaoyang\,\ Hunan",
  861327221 => "Hengyang\,\ Hunan",
  861327222 => "Zhangjiajie\,\ Hunan",
  861327223 => "Changsha\,\ Hunan",
  861327224 => "Huaihua\,\ Hunan",
  861327225 => "Huaihua\,\ Hunan",
  861327226 => "Huaihua\,\ Hunan",
  861327227 => "Huaihua\,\ Hunan",
  861327228 => "Huaihua\,\ Hunan",
  861327229 => "Huaihua\,\ Hunan",
  861327230 => "Hengyang\,\ Hunan",
  861327231 => "Hengyang\,\ Hunan",
  861327232 => "Hengyang\,\ Hunan",
  861327233 => "Hengyang\,\ Hunan",
  861327234 => "Hengyang\,\ Hunan",
  861327235 => "Chenzhou\,\ Hunan",
  861327236 => "Chenzhou\,\ Hunan",
  861327237 => "Chenzhou\,\ Hunan",
  861327238 => "Chenzhou\,\ Hunan",
  861327239 => "Chenzhou\,\ Hunan",
  86132724 => "Changsha\,\ Hunan",
  86132725 => "Chongqing",
  86132726 => "Chongqing",
  86132727 => "Chongqing",
  86132728 => "Chongqing",
  86132729 => "Chongqing",
  861327300 => "Zhoukou\,\ Henan",
  861327301 => "Zhoukou\,\ Henan",
  861327302 => "Zhengzhou\,\ Henan",
  861327303 => "Puyang\,\ Henan",
  861327304 => "Kaifeng\,\ Henan",
  861327305 => "Luohe\,\ Henan",
  861327306 => "Luohe\,\ Henan",
  861327307 => "Luohe\,\ Henan",
  861327308 => "Sanmenxia\,\ Henan",
  861327309 => "Sanmenxia\,\ Henan",
  86132731 => "Shijiazhuang\,\ Hebei",
  86132732 => "Baoding\,\ Hebei",
  861327330 => "Hengshui\,\ Hebei",
  861327331 => "Hengshui\,\ Hebei",
  861327332 => "Hengshui\,\ Hebei",
  861327333 => "Hengshui\,\ Hebei",
  861327334 => "Hengshui\,\ Hebei",
  861327335 => "Qinhuangdao\,\ Hebei",
  861327336 => "Qinhuangdao\,\ Hebei",
  861327337 => "Qinhuangdao\,\ Hebei",
  861327338 => "Qinhuangdao\,\ Hebei",
  861327339 => "Qinhuangdao\,\ Hebei",
  861327340 => "Shijiazhuang\,\ Hebei",
  861327341 => "Shijiazhuang\,\ Hebei",
  861327342 => "Shijiazhuang\,\ Hebei",
  861327343 => "Shijiazhuang\,\ Hebei",
  861327344 => "Shijiazhuang\,\ Hebei",
  861327345 => "Xingtai\,\ Hebei",
  861327346 => "Xingtai\,\ Hebei",
  861327347 => "Xingtai\,\ Hebei",
  861327348 => "Xingtai\,\ Hebei",
  861327349 => "Xingtai\,\ Hebei",
  86132735 => "Tangshan\,\ Hebei",
  861327360 => "Langfang\,\ Hebei",
  861327361 => "Langfang\,\ Hebei",
  861327362 => "Langfang\,\ Hebei",
  861327363 => "Langfang\,\ Hebei",
  861327364 => "Langfang\,\ Hebei",
  861327365 => "Xingtai\,\ Hebei",
  861327366 => "Xingtai\,\ Hebei",
  861327367 => "Xingtai\,\ Hebei",
  861327368 => "Xingtai\,\ Hebei",
  861327369 => "Xingtai\,\ Hebei",
  861327370 => "Shangqiu\,\ Henan",
  861327371 => "Zhengzhou\,\ Henan",
  861327372 => "Xinxiang\,\ Henan",
  861327373 => "Xinxiang\,\ Henan",
  861327374 => "Xuchang\,\ Henan",
  861327375 => "Pingdingshan\,\ Henan",
  861327376 => "Xinyang\,\ Henan",
  861327377 => "Nanyang\,\ Henan",
  861327378 => "Kaifeng\,\ Henan",
  861327379 => "Nanyang\,\ Henan",
  861327380 => "Zhengzhou\,\ Henan",
  861327381 => "Zhengzhou\,\ Henan",
  861327382 => "Shangqiu\,\ Henan",
  861327383 => "Shangqiu\,\ Henan",
  861327384 => "Shangqiu\,\ Henan",
  861327385 => "Xuchang\,\ Henan",
  861327386 => "Xuchang\,\ Henan",
  861327387 => "Xuchang\,\ Henan",
  861327388 => "Pingdingshan\,\ Henan",
  861327389 => "Pingdingshan\,\ Henan",
  861327390 => "Jiaozuo\,\ Henan",
  861327391 => "Jiaozuo\,\ Henan",
  861327392 => "Hebi\,\ Henan",
  861327393 => "Puyang\,\ Henan",
  861327394 => "Zhoukou\,\ Henan",
  861327395 => "Luohe\,\ Henan",
  861327396 => "Zhumadian\,\ Henan",
  861327397 => "Xinyang\,\ Henan",
  861327398 => "Sanmenxia\,\ Henan",
  861327399 => "Zhumadian\,\ Henan",
  86132740 => "Chongqing",
  861327410 => "Tieling\,\ Liaoning",
  861327411 => "Dalian\,\ Liaoning",
  861327412 => "Anshan\,\ Liaoning",
  861327413 => "Fushun\,\ Liaoning",
  861327414 => "Benxi\,\ Liaoning",
  861327415 => "Dandong\,\ Liaoning",
  861327416 => "Jinzhou\,\ Liaoning",
  861327417 => "Yingkou\,\ Liaoning",
  861327418 => "Fuxin\,\ Liaoning",
  861327419 => "Liaoyang\,\ Liaoning",
  861327420 => "Tieling\,\ Liaoning",
  861327421 => "Chaoyang\,\ Liaoning",
  861327422 => "Chaoyang\,\ Liaoning",
  861327423 => "Fushun\,\ Liaoning",
  861327424 => "Shenyang\,\ Liaoning",
  861327425 => "Shenyang\,\ Liaoning",
  861327426 => "Jinzhou\,\ Liaoning",
  861327427 => "Panjin\,\ Liaoning",
  861327428 => "Huludao\,\ Liaoning",
  861327429 => "Huludao\,\ Liaoning",
  861327430 => "Changchun\,\ Jilin",
  861327431 => "Changchun\,\ Jilin",
  861327432 => "Jilin\,\ Jilin",
  861327433 => "Yanbian\,\ Jilin",
  861327434 => "Siping\,\ Jilin",
  861327435 => "Tonghua\,\ Jilin",
  861327436 => "Baicheng\,\ Jilin",
  861327437 => "Liaoyuan\,\ Jilin",
  861327438 => "Songyuan\,\ Jilin",
  861327439 => "Baishan\,\ Jilin",
  86132744 => "Jilin\,\ Jilin",
  861327450 => "Harbin\,\ Heilongjiang",
  861327451 => "Harbin\,\ Heilongjiang",
  861327452 => "Qiqihar\,\ Heilongjiang",
  861327453 => "Mudanjiang\,\ Heilongjiang",
  861327454 => "Jiamusi\,\ Heilongjiang",
  861327455 => "Suihua\,\ Heilongjiang",
  861327456 => "Suihua\,\ Heilongjiang",
  861327457 => "Mudanjiang\,\ Heilongjiang",
  861327458 => "Jixi\,\ Heilongjiang",
  861327459 => "Daqing\,\ Heilongjiang",
  861327460 => "Harbin\,\ Heilongjiang",
  861327461 => "Harbin\,\ Heilongjiang",
  861327462 => "Harbin\,\ Heilongjiang",
  861327463 => "Harbin\,\ Heilongjiang",
  861327464 => "Qitaihe\,\ Heilongjiang",
  861327465 => "Daqing\,\ Heilongjiang",
  861327466 => "Qiqihar\,\ Heilongjiang",
  861327467 => "Jixi\,\ Heilongjiang",
  861327468 => "Jiamusi\,\ Heilongjiang",
  861327469 => "Shuangyashan\,\ Heilongjiang",
  861327470 => "Hulun\,\ Inner\ Mongolia",
  861327471 => "Hohhot\,\ Inner\ Mongolia",
  861327472 => "Baotou\,\ Inner\ Mongolia",
  861327473 => "Wuhai\,\ Inner\ Mongolia",
  861327474 => "Hinggan\,\ Inner\ Mongolia",
  861327475 => "Tongliao\,\ Inner\ Mongolia",
  861327476 => "Chifeng\,\ Inner\ Mongolia",
  861327477 => "Ordos\,\ Inner\ Mongolia",
  861327478 => "Bayannur\,\ Inner\ Mongolia",
  861327479 => "Xilin\,\ Inner\ Mongolia",
  861327480 => "Hohhot\,\ Inner\ Mongolia",
  861327481 => "Hohhot\,\ Inner\ Mongolia",
  861327482 => "Hinggan\,\ Inner\ Mongolia",
  861327483 => "Alxa\,\ Inner\ Mongolia",
  861327484 => "Tongliao\,\ Inner\ Mongolia",
  861327485 => "Tongliao\,\ Inner\ Mongolia",
  861327486 => "Baotou\,\ Inner\ Mongolia",
  861327487 => "Ordos\,\ Inner\ Mongolia",
  861327488 => "Bayannur\,\ Inner\ Mongolia",
  861327489 => "Ordos\,\ Inner\ Mongolia",
  86132749 => "Chongqing",
  861327500 => "Xiamen\,\ Fujian",
  861327501 => "Fuzhou\,\ Fujian",
  861327502 => "Xiamen\,\ Fujian",
  861327503 => "Longyan\,\ Fujian",
  861327504 => "Xiamen\,\ Fujian",
  861327505 => "Quanzhou\,\ Fujian",
  861327506 => "Sanming\,\ Fujian",
  861327507 => "Quanzhou\,\ Fujian",
  861327508 => "Quanzhou\,\ Fujian",
  861327509 => "Nanping\,\ Fujian",
  861327510 => "Wuxi\,\ Jiangsu",
  861327511 => "Zhenjiang\,\ Jiangsu",
  861327512 => "Zhenjiang\,\ Jiangsu",
  861327513 => "Nantong\,\ Jiangsu",
  861327514 => "Yangzhou\,\ Jiangsu",
  861327515 => "Yancheng\,\ Jiangsu",
  861327516 => "Xuzhou\,\ Jiangsu",
  861327517 => "HuaiAn\,\ Jiangsu",
  861327518 => "Changzhou\,\ Jiangsu",
  861327519 => "Changzhou\,\ Jiangsu",
  861327520 => "Changzhou\,\ Jiangsu",
  861327521 => "Changzhou\,\ Jiangsu",
  861327522 => "Changzhou\,\ Jiangsu",
  861327523 => "Changzhou\,\ Jiangsu",
  861327524 => "Changzhou\,\ Jiangsu",
  861327525 => "Nantong\,\ Jiangsu",
  861327526 => "Nantong\,\ Jiangsu",
  861327527 => "Nantong\,\ Jiangsu",
  861327528 => "Nantong\,\ Jiangsu",
  861327529 => "Nantong\,\ Jiangsu",
  861327530 => "Heze\,\ Shandong",
  861327531 => "Jinan\,\ Shandong",
  861327532 => "Qingdao\,\ Shandong",
  861327533 => "Zibo\,\ Shandong",
  861327534 => "Dezhou\,\ Shandong",
  861327535 => "Yantai\,\ Shandong",
  861327536 => "Weifang\,\ Shandong",
  861327537 => "Jining\,\ Shandong",
  861327538 => "TaiAn\,\ Shandong",
  861327539 => "Linyi\,\ Shandong",
  861327540 => "Heze\,\ Shandong",
  861327541 => "Jinan\,\ Shandong",
  861327542 => "Qingdao\,\ Shandong",
  861327543 => "Binzhou\,\ Shandong",
  861327544 => "Dezhou\,\ Shandong",
  861327545 => "Yantai\,\ Shandong",
  861327546 => "Dongying\,\ Shandong",
  861327547 => "Jining\,\ Shandong",
  861327548 => "TaiAn\,\ Shandong",
  861327549 => "Linyi\,\ Shandong",
  861327550 => "Chuzhou\,\ Anhui",
  861327551 => "Hefei\,\ Anhui",
  861327552 => "Bengbu\,\ Anhui",
  861327553 => "Wuhu\,\ Anhui",
  861327554 => "Huainan\,\ Anhui",
  861327555 => "MaAnshan\,\ Anhui",
  861327556 => "Anqing\,\ Anhui",
  861327557 => "Suzhou\,\ Anhui",
  861327558 => "Fuyang\,\ Anhui",
  861327559 => "Huangshan\,\ Anhui",
  861327560 => "Hefei\,\ Anhui",
  861327561 => "Huaibei\,\ Anhui",
  861327562 => "Tongling\,\ Anhui",
  861327563 => "Xuancheng\,\ Anhui",
  861327564 => "LuAn\,\ Anhui",
  861327565 => "Hefei\,\ Anhui",
  861327566 => "Chizhou\,\ Anhui",
  861327567 => "Bozhou\,\ Anhui",
  861327568 => "Fuyang\,\ Anhui",
  861327569 => "Hefei\,\ Anhui",
  861327570 => "Anqing\,\ Anhui",
  861327571 => "Anqing\,\ Anhui",
  861327572 => "Anqing\,\ Anhui",
  861327573 => "Anqing\,\ Anhui",
  861327574 => "Anqing\,\ Anhui",
  861327575 => "Hefei\,\ Anhui",
  861327576 => "Hefei\,\ Anhui",
  861327577 => "Hefei\,\ Anhui",
  861327578 => "Anqing\,\ Anhui",
  861327579 => "Hefei\,\ Anhui",
  861327580 => "LuAn\,\ Anhui",
  861327581 => "LuAn\,\ Anhui",
  861327582 => "LuAn\,\ Anhui",
  861327583 => "LuAn\,\ Anhui",
  861327584 => "LuAn\,\ Anhui",
  861327585 => "Hefei\,\ Anhui",
  861327586 => "Hefei\,\ Anhui",
  861327587 => "Hefei\,\ Anhui",
  861327588 => "LuAn\,\ Anhui",
  861327589 => "Hefei\,\ Anhui",
  861327590 => "Fuzhou\,\ Fujian",
  861327591 => "Fuzhou\,\ Fujian",
  861327592 => "Xiamen\,\ Fujian",
  861327593 => "Ningde\,\ Fujian",
  861327594 => "Putian\,\ Fujian",
  861327595 => "Quanzhou\,\ Fujian",
  861327596 => "Zhangzhou\,\ Fujian",
  861327597 => "Zhengzhou\,\ Henan",
  861327598 => "Sanming\,\ Fujian",
  861327599 => "Nanping\,\ Fujian",
  861327600 => "Quanzhou\,\ Fujian",
  861327601 => "Fuzhou\,\ Fujian",
  861327602 => "Xiamen\,\ Fujian",
  861327603 => "Ningde\,\ Fujian",
  861327604 => "Fuzhou\,\ Fujian",
  861327605 => "Sanming\,\ Fujian",
  861327606 => "Zhangzhou\,\ Fujian",
  861327607 => "Nanping\,\ Fujian",
  861327608 => "Fuzhou\,\ Fujian",
  861327609 => "Quanzhou\,\ Fujian",
  861327610 => "Yancheng\,\ Jiangsu",
  861327611 => "Yancheng\,\ Jiangsu",
  861327612 => "Yancheng\,\ Jiangsu",
  861327613 => "Yancheng\,\ Jiangsu",
  861327614 => "Yancheng\,\ Jiangsu",
  861327615 => "Zhenjiang\,\ Jiangsu",
  861327616 => "Zhenjiang\,\ Jiangsu",
  861327617 => "Zhenjiang\,\ Jiangsu",
  861327618 => "Zhenjiang\,\ Jiangsu",
  861327619 => "Zhenjiang\,\ Jiangsu",
  861327620 => "Yancheng\,\ Jiangsu",
  861327621 => "Yancheng\,\ Jiangsu",
  861327622 => "Wuxi\,\ Jiangsu",
  861327623 => "Wuxi\,\ Jiangsu",
  861327624 => "Wuxi\,\ Jiangsu",
  861327625 => "Wuxi\,\ Jiangsu",
  861327626 => "Wuxi\,\ Jiangsu",
  861327627 => "Wuxi\,\ Jiangsu",
  861327628 => "Wuxi\,\ Jiangsu",
  861327629 => "Wuxi\,\ Jiangsu",
  861327630 => "Weihai\,\ Shandong",
  861327631 => "Weihai\,\ Shandong",
  861327632 => "Zaozhuang\,\ Shandong",
  861327633 => "Rizhao\,\ Shandong",
  861327634 => "Laiwu\,\ Shandong",
  861327635 => "Liaocheng\,\ Shandong",
  861327636 => "Weifang\,\ Shandong",
  861327637 => "Zaozhuang\,\ Shandong",
  861327638 => "Yantai\,\ Shandong",
  861327639 => "Qingdao\,\ Shandong",
  861327640 => "Jinan\,\ Shandong",
  861327641 => "Jinan\,\ Shandong",
  861327642 => "Qingdao\,\ Shandong",
  861327643 => "Zibo\,\ Shandong",
  861327644 => "Jinan\,\ Shandong",
  861327645 => "Yantai\,\ Shandong",
  861327646 => "Weifang\,\ Shandong",
  861327647 => "Dongying\,\ Shandong",
  861327648 => "Qingdao\,\ Shandong",
  861327649 => "Jinan\,\ Shandong",
  861327650 => "HuaiAn\,\ Jiangsu",
  861327651 => "HuaiAn\,\ Jiangsu",
  861327652 => "Yangzhou\,\ Jiangsu",
  861327653 => "Yangzhou\,\ Jiangsu",
  861327654 => "Yangzhou\,\ Jiangsu",
  861327655 => "Yangzhou\,\ Jiangsu",
  861327656 => "Yangzhou\,\ Jiangsu",
  861327657 => "Yangzhou\,\ Jiangsu",
  861327658 => "Yangzhou\,\ Jiangsu",
  861327659 => "Xuzhou\,\ Jiangsu",
  861327660 => "Nanjing\,\ Jiangsu",
  861327661 => "Nanjing\,\ Jiangsu",
  861327662 => "Nanjing\,\ Jiangsu",
  861327663 => "Nanjing\,\ Jiangsu",
  861327664 => "Nanjing\,\ Jiangsu",
  861327665 => "Nanjing\,\ Jiangsu",
  861327666 => "Nanjing\,\ Jiangsu",
  861327667 => "Nanjing\,\ Jiangsu",
  861327668 => "Nanjing\,\ Jiangsu",
  861327669 => "Xuzhou\,\ Jiangsu",
  861327670 => "Ningbo\,\ Zhejiang",
  861327671 => "Hangzhou\,\ Zhejiang",
  861327672 => "Ningbo\,\ Zhejiang",
  861327673 => "Jiaxing\,\ Zhejiang",
  861327674 => "Ningbo\,\ Zhejiang",
  861327675 => "Shaoxing\,\ Zhejiang",
  861327676 => "Taizhou\,\ Zhejiang",
  861327677 => "Wenzhou\,\ Zhejiang",
  861327678 => "Ningbo\,\ Zhejiang",
  861327679 => "Jinhua\,\ Zhejiang",
  861327680 => "Zhoushan\,\ Zhejiang",
  861327681 => "Hangzhou\,\ Zhejiang",
  861327682 => "Ningbo\,\ Zhejiang",
  861327683 => "Jiaxing\,\ Zhejiang",
  861327684 => "Ningbo\,\ Zhejiang",
  861327685 => "Shaoxing\,\ Zhejiang",
  861327686 => "Taizhou\,\ Zhejiang",
  861327687 => "Wenzhou\,\ Zhejiang",
  861327688 => "Lishui\,\ Zhejiang",
  861327689 => "Jinhua\,\ Zhejiang",
  861327690 => "Zhengzhou\,\ Henan",
  861327691 => "Fuzhou\,\ Fujian",
  861327692 => "Putian\,\ Fujian",
  861327693 => "Longyan\,\ Fujian",
  861327694 => "Quanzhou\,\ Fujian",
  861327695 => "Ningde\,\ Fujian",
  861327696 => "Xiamen\,\ Fujian",
  861327697 => "Zhangzhou\,\ Fujian",
  861327698 => "Quanzhou\,\ Fujian",
  861327699 => "Fuzhou\,\ Fujian",
  861327700 => "Xiaogan\,\ Hubei",
  861327701 => "Xiaogan\,\ Hubei",
  861327702 => "Xiaogan\,\ Hubei",
  861327703 => "Wuhan\,\ Hubei",
  861327704 => "Wuhan\,\ Hubei",
  861327705 => "Wuhan\,\ Hubei",
  861327706 => "Wuhan\,\ Hubei",
  861327707 => "Wuhan\,\ Hubei",
  861327708 => "Wuhan\,\ Hubei",
  861327709 => "Wuhan\,\ Hubei",
  861327710 => "Xiangfan\,\ Hubei",
  861327711 => "Xiangfan\,\ Hubei",
  861327712 => "Xiaogan\,\ Hubei",
  861327713 => "Huanggang\,\ Hubei",
  861327714 => "Huanggang\,\ Hubei",
  861327715 => "Xianning\,\ Hubei",
  861327716 => "Jingzhou\,\ Hubei",
  861327717 => "Yichang\,\ Hubei",
  861327718 => "Enshi\,\ Hubei",
  861327719 => "Shiyan\,\ Hubei",
  861327720 => "Huanggang\,\ Hubei",
  861327721 => "Huanggang\,\ Hubei",
  861327722 => "Suizhou\,\ Hubei",
  861327723 => "Yichang\,\ Hubei",
  861327724 => "Jingmen\,\ Hubei",
  861327725 => "Yichang\,\ Hubei",
  861327726 => "Shiyan\,\ Hubei",
  861327727 => "Xiangfan\,\ Hubei",
  861327728 => "Wuhan\,\ Hubei",
  861327729 => "Xiangfan\,\ Hubei",
  861327730 => "Jingzhou\,\ Hubei",
  861327731 => "Jingzhou\,\ Hubei",
  861327732 => "Jingzhou\,\ Hubei",
  861327733 => "Jingzhou\,\ Hubei",
  861327734 => "Jingzhou\,\ Hubei",
  861327735 => "Jingzhou\,\ Hubei",
  861327736 => "Jingzhou\,\ Hubei",
  861327737 => "Jingzhou\,\ Hubei",
  861327738 => "Jingzhou\,\ Hubei",
  861327739 => "Yichang\,\ Hubei",
  861327740 => "Huanggang\,\ Hubei",
  861327741 => "Huanggang\,\ Hubei",
  861327742 => "Huanggang\,\ Hubei",
  861327743 => "Huanggang\,\ Hubei",
  861327744 => "Wuhan\,\ Hubei",
  861327745 => "Wuhan\,\ Hubei",
  861327746 => "Wuhan\,\ Hubei",
  861327747 => "Wuhan\,\ Hubei",
  861327748 => "Wuhan\,\ Hubei",
  861327749 => "Wuhan\,\ Hubei",
  86132775 => "Enshi\,\ Hubei",
  861327760 => "Suizhou\,\ Hubei",
  861327761 => "Suizhou\,\ Hubei",
  861327762 => "Suizhou\,\ Hubei",
  861327763 => "Jingmen\,\ Hubei",
  861327764 => "Jingmen\,\ Hubei",
  861327765 => "Jingmen\,\ Hubei",
  861327766 => "Jingmen\,\ Hubei",
  861327767 => "Wuhan\,\ Hubei",
  861327768 => "Wuhan\,\ Hubei",
  861327769 => "Wuhan\,\ Hubei",
  86132777 => "Nanning\,\ Guangxi",
  86132778 => "Nanning\,\ Guangxi",
  86132779 => "Wuhan\,\ Hubei",
  86132780 => "Siping\,\ Jilin",
  861327810 => "Changchun\,\ Jilin",
  861327811 => "Baishan\,\ Jilin",
  861327812 => "Siping\,\ Jilin",
  861327813 => "Siping\,\ Jilin",
  861327814 => "Siping\,\ Jilin",
  861327815 => "Tonghua\,\ Jilin",
  861327816 => "Baicheng\,\ Jilin",
  861327817 => "Baicheng\,\ Jilin",
  861327818 => "Baicheng\,\ Jilin",
  861327819 => "Baicheng\,\ Jilin",
  861327820 => "Jilin\,\ Jilin",
  861327821 => "Jilin\,\ Jilin",
  861327822 => "Jilin\,\ Jilin",
  861327823 => "Yanbian\,\ Jilin",
  861327824 => "Yanbian\,\ Jilin",
  861327825 => "Tonghua\,\ Jilin",
  861327826 => "Baicheng\,\ Jilin",
  861327827 => "Baicheng\,\ Jilin",
  861327828 => "Baicheng\,\ Jilin",
  861327829 => "Baishan\,\ Jilin",
  861327830 => "Songyuan\,\ Jilin",
  861327831 => "Songyuan\,\ Jilin",
  861327832 => "Songyuan\,\ Jilin",
  861327833 => "Yanbian\,\ Jilin",
  861327834 => "Yanbian\,\ Jilin",
  861327835 => "Tonghua\,\ Jilin",
  861327836 => "Baicheng\,\ Jilin",
  861327837 => "Liaoyuan\,\ Jilin",
  861327838 => "Liaoyuan\,\ Jilin",
  861327839 => "Liaoyuan\,\ Jilin",
  861327840 => "Siping\,\ Jilin",
  861327841 => "Siping\,\ Jilin",
  861327842 => "Siping\,\ Jilin",
  861327843 => "Siping\,\ Jilin",
  861327844 => "Siping\,\ Jilin",
  861327845 => "Tonghua\,\ Jilin",
  861327846 => "Baicheng\,\ Jilin",
  861327847 => "Liaoyuan\,\ Jilin",
  861327848 => "Liaoyuan\,\ Jilin",
  861327849 => "Liaoyuan\,\ Jilin",
  861327850 => "Siping\,\ Jilin",
  861327851 => "Siping\,\ Jilin",
  861327852 => "Siping\,\ Jilin",
  861327853 => "Siping\,\ Jilin",
  861327854 => "Siping\,\ Jilin",
  861327855 => "Tonghua\,\ Jilin",
  861327856 => "Baicheng\,\ Jilin",
  861327857 => "Liaoyuan\,\ Jilin",
  861327858 => "Songyuan\,\ Jilin",
  861327859 => "Songyuan\,\ Jilin",
  861327860 => "Baoshan\,\ Yunnan",
  861327861 => "Baoshan\,\ Yunnan",
  861327862 => "Baoshan\,\ Yunnan",
  861327863 => "Zhaotong\,\ Yunnan",
  861327864 => "Zhaotong\,\ Yunnan",
  861327865 => "Zhaotong\,\ Yunnan",
  861327866 => "Zhaotong\,\ Yunnan",
  861327867 => "Zhaotong\,\ Yunnan",
  861327868 => "Zhaotong\,\ Yunnan",
  861327869 => "Zhaotong\,\ Yunnan",
  861327870 => "Zhaotong\,\ Yunnan",
  861327871 => "Kunming\,\ Yunnan",
  861327872 => "Kunming\,\ Yunnan",
  861327873 => "Qujing\,\ Yunnan",
  861327874 => "Qujing\,\ Yunnan",
  861327875 => "Qujing\,\ Yunnan",
  861327876 => "Qujing\,\ Yunnan",
  861327877 => "Qujing\,\ Yunnan",
  861327878 => "Qujing\,\ Yunnan",
  861327879 => "Qujing\,\ Yunnan",
  861327880 => "Yueyang\,\ Hunan",
  861327881 => "Yongzhou\,\ Hunan",
  861327882 => "Xiangtan\,\ Hunan",
  861327883 => "Changde\,\ Hunan",
  861327884 => "Changsha\,\ Hunan",
  861327885 => "Changsha\,\ Hunan",
  861327886 => "Changsha\,\ Hunan",
  861327887 => "Changsha\,\ Hunan",
  861327888 => "Changsha\,\ Hunan",
  861327889 => "Changsha\,\ Hunan",
  86132789 => "Haikou\,\ Hainan",
  861327900 => "Changji\,\ Xinjiang",
  861327901 => "Kashi\,\ Xinjiang",
  861327902 => "Hami\,\ Xinjiang",
  861327903 => "Hotan\,\ Xinjiang",
  861327904 => "Bayingolin\,\ Xinjiang",
  861327905 => "Changji\,\ Xinjiang",
  861327906 => "Aksu\,\ Xinjiang",
  861327907 => "Ili\,\ Xinjiang",
  861327908 => "Kizilsu\,\ Xinjiang",
  861327909 => "Aksu\,\ Xinjiang",
  861327910 => "Xianyang\,\ Shaanxi",
  861327911 => "YanAn\,\ Shaanxi",
  861327912 => "Yulin\,\ Shaanxi",
  861327913 => "Weinan\,\ Shaanxi",
  861327914 => "Weinan\,\ Shaanxi",
  861327915 => "Weinan\,\ Shaanxi",
  861327916 => "Hanzhong\,\ Shaanxi",
  861327917 => "Baoji\,\ Shaanxi",
  861327918 => "Baoji\,\ Shaanxi",
  861327919 => "Baoji\,\ Shaanxi",
  86132792 => "XiAn\,\ Shaanxi",
  86132793 => "XiAn\,\ Shaanxi",
  86132794 => "XiAn\,\ Shaanxi",
  86132795 => "Xianyang\,\ Shaanxi",
  86132796 => "Weinan\,\ Shaanxi",
  861327970 => "Kashi\,\ Xinjiang",
  861327971 => "Kashi\,\ Xinjiang",
  861327972 => "Kashi\,\ Xinjiang",
  861327973 => "Kashi\,\ Xinjiang",
  861327974 => "Ili\,\ Xinjiang",
  861327975 => "Ili\,\ Xinjiang",
  861327976 => "Aksu\,\ Xinjiang",
  861327977 => "Bayingolin\,\ Xinjiang",
  861327978 => "Bayingolin\,\ Xinjiang",
  861327979 => "Aksu\,\ Xinjiang",
  861327980 => "Aksu\,\ Xinjiang",
  861327981 => "Kashi\,\ Xinjiang",
  861327982 => "Kashi\,\ Xinjiang",
  861327983 => "Urumchi\,\ Xinjiang",
  861327984 => "Kashi\,\ Xinjiang",
  861327985 => "Kashi\,\ Xinjiang",
  861327986 => "Kashi\,\ Xinjiang",
  861327987 => "Kashi\,\ Xinjiang",
  861327988 => "Kashi\,\ Xinjiang",
  861327989 => "Kashi\,\ Xinjiang",
  861327990 => "Kashi\,\ Xinjiang",
  861327991 => "Urumchi\,\ Xinjiang",
  861327992 => "Ili\,\ Xinjiang",
  861327993 => "Shihezi\,\ Xinjiang",
  861327994 => "Changji\,\ Xinjiang",
  861327995 => "Turpan\,\ Xinjiang",
  861327996 => "Bayingolin\,\ Xinjiang",
  861327997 => "Aksu\,\ Xinjiang",
  861327998 => "Kashi\,\ Xinjiang",
  861327999 => "Ili\,\ Xinjiang",
  861328000 => "Jinan\,\ Shandong",
  861328001 => "Jinan\,\ Shandong",
  861328002 => "Jinan\,\ Shandong",
  861328003 => "Jining\,\ Shandong",
  861328004 => "Jining\,\ Shandong",
  861328005 => "Jining\,\ Shandong",
  861328006 => "Jining\,\ Shandong",
  861328007 => "Jining\,\ Shandong",
  861328008 => "Jining\,\ Shandong",
  861328009 => "Jining\,\ Shandong",
  86132801 => "Weifang\,\ Shandong",
  86132802 => "Zaozhuang\,\ Shandong",
  861328030 => "Dongying\,\ Shandong",
  861328031 => "Dongying\,\ Shandong",
  861328032 => "Dongying\,\ Shandong",
  861328033 => "Dongying\,\ Shandong",
  861328034 => "Weifang\,\ Shandong",
  861328035 => "Dongying\,\ Shandong",
  861328036 => "Dongying\,\ Shandong",
  861328037 => "Dongying\,\ Shandong",
  861328038 => "Dongying\,\ Shandong",
  861328039 => "Dongying\,\ Shandong",
  861328040 => "Binzhou\,\ Shandong",
  861328041 => "Binzhou\,\ Shandong",
  861328042 => "Linyi\,\ Shandong",
  861328043 => "Linyi\,\ Shandong",
  861328044 => "Rizhao\,\ Shandong",
  861328045 => "Liaocheng\,\ Shandong",
  861328046 => "Liaocheng\,\ Shandong",
  861328047 => "Zaozhuang\,\ Shandong",
  861328048 => "Zaozhuang\,\ Shandong",
  861328049 => "Jining\,\ Shandong",
  86132805 => "Linyi\,\ Shandong",
  86132806 => "Zibo\,\ Shandong",
  86132807 => "Weifang\,\ Shandong",
  86132808 => "Qingdao\,\ Shandong",
  86132809 => "Yantai\,\ Shandong",
  86132810 => "Chengdu\,\ Sichuan",
  86132811 => "Chengdu\,\ Sichuan",
  86132812 => "Chengdu\,\ Sichuan",
  861328130 => "Leshan\,\ Sichuan",
  861328131 => "Leshan\,\ Sichuan",
  861328132 => "Leshan\,\ Sichuan",
  861328133 => "Leshan\,\ Sichuan",
  861328134 => "Leshan\,\ Sichuan",
  861328135 => "Deyang\,\ Sichuan",
  861328136 => "Deyang\,\ Sichuan",
  861328137 => "Deyang\,\ Sichuan",
  861328138 => "Deyang\,\ Sichuan",
  861328139 => "Deyang\,\ Sichuan",
  861328140 => "Mianyang\,\ Sichuan",
  861328141 => "Weinan\,\ Shaanxi",
  861328142 => "Dazhou\,\ Sichuan",
  861328143 => "Nanchong\,\ Sichuan",
  861328144 => "Leshan\,\ Sichuan",
  861328145 => "Chengdu\,\ Sichuan",
  861328146 => "Chengdu\,\ Sichuan",
  861328147 => "Chengdu\,\ Sichuan",
  861328148 => "Chengdu\,\ Sichuan",
  861328149 => "Chengdu\,\ Sichuan",
  86132815 => "Mianyang\,\ Sichuan",
  861328160 => "Luzhou\,\ Sichuan",
  861328161 => "Luzhou\,\ Sichuan",
  861328162 => "Luzhou\,\ Sichuan",
  861328163 => "Luzhou\,\ Sichuan",
  861328164 => "Luzhou\,\ Sichuan",
  861328165 => "Luzhou\,\ Sichuan",
  861328166 => "Luzhou\,\ Sichuan",
  861328167 => "Luzhou\,\ Sichuan",
  861328168 => "GuangAn\,\ Sichuan",
  861328169 => "YaAn\,\ Sichuan",
  861328170 => "Dazhou\,\ Sichuan",
  861328171 => "Dazhou\,\ Sichuan",
  861328172 => "Dazhou\,\ Sichuan",
  861328173 => "Dazhou\,\ Sichuan",
  861328174 => "Dazhou\,\ Sichuan",
  861328175 => "Dazhou\,\ Sichuan",
  861328176 => "GuangAn\,\ Sichuan",
  861328177 => "GuangAn\,\ Sichuan",
  861328178 => "Suining\,\ Sichuan",
  861328179 => "Suining\,\ Sichuan",
  86132818 => "Chengdu\,\ Sichuan",
  861328190 => "Nanchong\,\ Sichuan",
  861328191 => "Nanchong\,\ Sichuan",
  861328192 => "Nanchong\,\ Sichuan",
  861328193 => "Nanchong\,\ Sichuan",
  861328194 => "Nanchong\,\ Sichuan",
  861328195 => "Nanchong\,\ Sichuan",
  861328196 => "Yibin\,\ Sichuan",
  861328197 => "Yibin\,\ Sichuan",
  861328198 => "Yibin\,\ Sichuan",
  861328199 => "YaAn\,\ Sichuan",
  861328200 => "Hangzhou\,\ Zhejiang",
  861328201 => "Hangzhou\,\ Zhejiang",
  861328202 => "Hangzhou\,\ Zhejiang",
  861328203 => "Hangzhou\,\ Zhejiang",
  861328204 => "Wenzhou\,\ Zhejiang",
  861328205 => "Quzhou\,\ Zhejiang",
  861328206 => "Quzhou\,\ Zhejiang",
  861328207 => "Quzhou\,\ Zhejiang",
  861328208 => "Quzhou\,\ Zhejiang",
  861328209 => "Quzhou\,\ Zhejiang",
  86132821 => "Hangzhou\,\ Zhejiang",
  86132822 => "Ningbo\,\ Zhejiang",
  861328230 => "Jiaxing\,\ Zhejiang",
  861328231 => "Jiaxing\,\ Zhejiang",
  861328232 => "Jiaxing\,\ Zhejiang",
  861328233 => "Jiaxing\,\ Zhejiang",
  861328234 => "Jiaxing\,\ Zhejiang",
  861328235 => "Zhoushan\,\ Zhejiang",
  861328236 => "Zhoushan\,\ Zhejiang",
  861328237 => "Zhoushan\,\ Zhejiang",
  861328238 => "Wenzhou\,\ Zhejiang",
  861328239 => "Zhoushan\,\ Zhejiang",
  861328240 => "Hangzhou\,\ Zhejiang",
  861328241 => "Hangzhou\,\ Zhejiang",
  861328242 => "Hangzhou\,\ Zhejiang",
  861328243 => "Hangzhou\,\ Zhejiang",
  861328244 => "Wenzhou\,\ Zhejiang",
  861328245 => "Wenzhou\,\ Zhejiang",
  861328246 => "Wenzhou\,\ Zhejiang",
  861328247 => "Wenzhou\,\ Zhejiang",
  861328248 => "Wenzhou\,\ Zhejiang",
  861328249 => "Wenzhou\,\ Zhejiang",
  861328250 => "Shaoxing\,\ Zhejiang",
  861328251 => "Jinhua\,\ Zhejiang",
  861328252 => "Lishui\,\ Zhejiang",
  861328253 => "Lishui\,\ Zhejiang",
  861328254 => "Wenzhou\,\ Zhejiang",
  861328255 => "Lishui\,\ Zhejiang",
  861328256 => "Lishui\,\ Zhejiang",
  861328257 => "Lishui\,\ Zhejiang",
  861328258 => "Lishui\,\ Zhejiang",
  861328259 => "Lishui\,\ Zhejiang",
  86132826 => "Taizhou\,\ Zhejiang",
  86132827 => "Wenzhou\,\ Zhejiang",
  861328280 => "Hangzhou\,\ Zhejiang",
  861328281 => "Hangzhou\,\ Zhejiang",
  861328282 => "Hangzhou\,\ Zhejiang",
  861328283 => "Hangzhou\,\ Zhejiang",
  861328284 => "Hangzhou\,\ Zhejiang",
  861328285 => "Shaoxing\,\ Zhejiang",
  861328286 => "Taizhou\,\ Zhejiang",
  861328287 => "Wenzhou\,\ Zhejiang",
  861328288 => "Wenzhou\,\ Zhejiang",
  861328289 => "Jinhua\,\ Zhejiang",
  86132829 => "Jinhua\,\ Zhejiang",
  861328300 => "Zhoukou\,\ Henan",
  861328301 => "Zhoukou\,\ Henan",
  861328302 => "Puyang\,\ Henan",
  861328303 => "Puyang\,\ Henan",
  861328304 => "Kaifeng\,\ Henan",
  861328305 => "Pingdingshan\,\ Henan",
  861328306 => "Pingdingshan\,\ Henan",
  861328307 => "Xinyang\,\ Henan",
  861328308 => "Zhumadian\,\ Henan",
  861328309 => "Zhumadian\,\ Henan",
  86132831 => "Handan\,\ Hebei",
  86132832 => "Cangzhou\,\ Hebei",
  861328330 => "Zhangjiakou\,\ Hebei",
  861328331 => "Zhangjiakou\,\ Hebei",
  861328332 => "Zhangjiakou\,\ Hebei",
  861328333 => "Zhangjiakou\,\ Hebei",
  861328334 => "Zhangjiakou\,\ Hebei",
  861328335 => "Chengde\,\ Hebei",
  861328336 => "Chengde\,\ Hebei",
  861328337 => "Chengde\,\ Hebei",
  861328338 => "Chengde\,\ Hebei",
  861328339 => "Chengde\,\ Hebei",
  861328340 => "Handan\,\ Hebei",
  861328341 => "Handan\,\ Hebei",
  861328342 => "Handan\,\ Hebei",
  861328343 => "Handan\,\ Hebei",
  861328344 => "Handan\,\ Hebei",
  861328345 => "Qinhuangdao\,\ Hebei",
  861328346 => "Qinhuangdao\,\ Hebei",
  861328347 => "Qinhuangdao\,\ Hebei",
  861328348 => "Qinhuangdao\,\ Hebei",
  861328349 => "Qinhuangdao\,\ Hebei",
  861328350 => "Xinzhou\,\ Shanxi",
  861328351 => "Taiyuan\,\ Shanxi",
  861328352 => "Datong\,\ Shanxi",
  861328353 => "Yangquan\,\ Shanxi",
  861328354 => "Jinzhong\,\ Shanxi",
  861328355 => "Changzhi\,\ Shanxi",
  861328356 => "Jincheng\,\ Shanxi",
  861328357 => "Linfen\,\ Shanxi",
  861328358 => "Lüliang\,\ Shanxi",
  861328359 => "Yuncheng\,\ Shanxi",
  861328360 => "Xinzhou\,\ Shanxi",
  861328361 => "Taiyuan\,\ Shanxi",
  861328362 => "Taiyuan\,\ Shanxi",
  861328363 => "Yangquan\,\ Shanxi",
  861328364 => "Yangquan\,\ Shanxi",
  861328365 => "Xinzhou\,\ Shanxi",
  861328366 => "Jinzhong\,\ Shanxi",
  861328367 => "Lüliang\,\ Shanxi",
  861328368 => "Datong\,\ Shanxi",
  861328369 => "Shuozhou\,\ Shanxi",
  861328370 => "Shangqiu\,\ Henan",
  861328371 => "Zhengzhou\,\ Henan",
  861328372 => "Xinxiang\,\ Henan",
  861328373 => "Xinxiang\,\ Henan",
  861328374 => "Xuchang\,\ Henan",
  861328375 => "Pingdingshan\,\ Henan",
  861328376 => "Xinyang\,\ Henan",
  861328377 => "Nanyang\,\ Henan",
  861328378 => "Kaifeng\,\ Henan",
  861328379 => "Nanyang\,\ Henan",
  86132838 => "Zhengzhou\,\ Henan",
  861328390 => "Jiaozuo\,\ Henan",
  861328391 => "Jiaozuo\,\ Henan",
  861328392 => "Hebi\,\ Henan",
  861328393 => "Puyang\,\ Henan",
  861328394 => "Zhoukou\,\ Henan",
  861328395 => "Luohe\,\ Henan",
  861328396 => "Zhumadian\,\ Henan",
  861328397 => "Xinyang\,\ Henan",
  861328398 => "Sanmenxia\,\ Henan",
  861328399 => "Zhumadian\,\ Henan",
  861328400 => "Harbin\,\ Heilongjiang",
  861328401 => "Harbin\,\ Heilongjiang",
  861328402 => "Qiqihar\,\ Heilongjiang",
  861328403 => "Mudanjiang\,\ Heilongjiang",
  861328404 => "Suihua\,\ Heilongjiang",
  861328405 => "Suihua\,\ Heilongjiang",
  861328406 => "Heihe\,\ Heilongjiang",
  861328407 => "Jiamusi\,\ Heilongjiang",
  861328408 => "Jixi\,\ Heilongjiang",
  861328409 => "Daqing\,\ Heilongjiang",
  861328410 => "Tieling\,\ Liaoning",
  861328411 => "Dalian\,\ Liaoning",
  861328412 => "Anshan\,\ Liaoning",
  861328413 => "Fushun\,\ Liaoning",
  861328414 => "Benxi\,\ Liaoning",
  861328415 => "Dandong\,\ Liaoning",
  861328416 => "Jinzhou\,\ Liaoning",
  861328417 => "Yingkou\,\ Liaoning",
  861328418 => "Fuxin\,\ Liaoning",
  861328419 => "Liaoyang\,\ Liaoning",
  861328420 => "Anshan\,\ Liaoning",
  861328421 => "Chaoyang\,\ Liaoning",
  861328422 => "Dalian\,\ Liaoning",
  861328423 => "Dalian\,\ Liaoning",
  861328424 => "Shenyang\,\ Liaoning",
  861328425 => "Shenyang\,\ Liaoning",
  861328426 => "Shenyang\,\ Liaoning",
  861328427 => "Panjin\,\ Liaoning",
  861328428 => "Shenyang\,\ Liaoning",
  861328429 => "Huludao\,\ Liaoning",
  86132843 => "Baoding\,\ Hebei",
  86132844 => "Shijiazhuang\,\ Hebei",
  861328450 => "Harbin\,\ Heilongjiang",
  861328451 => "Harbin\,\ Heilongjiang",
  861328452 => "Qiqihar\,\ Heilongjiang",
  861328453 => "Mudanjiang\,\ Heilongjiang",
  861328454 => "Jiamusi\,\ Heilongjiang",
  861328455 => "Suihua\,\ Heilongjiang",
  861328456 => "Heihe\,\ Heilongjiang",
  861328457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861328458 => "Yichun\,\ Heilongjiang",
  861328459 => "Daqing\,\ Heilongjiang",
  861328460 => "Harbin\,\ Heilongjiang",
  861328461 => "Harbin\,\ Heilongjiang",
  861328462 => "Harbin\,\ Heilongjiang",
  861328463 => "Harbin\,\ Heilongjiang",
  861328464 => "Qitaihe\,\ Heilongjiang",
  861328465 => "Jiamusi\,\ Heilongjiang",
  861328466 => "Daqing\,\ Heilongjiang",
  861328467 => "Jixi\,\ Heilongjiang",
  861328468 => "Hegang\,\ Heilongjiang",
  861328469 => "Shuangyashan\,\ Heilongjiang",
  861328470 => "Baotou\,\ Inner\ Mongolia",
  861328471 => "Baotou\,\ Inner\ Mongolia",
  861328472 => "Baotou\,\ Inner\ Mongolia",
  861328473 => "Wuhai\,\ Inner\ Mongolia",
  861328474 => "Hinggan\,\ Inner\ Mongolia",
  861328475 => "Tongliao\,\ Inner\ Mongolia",
  861328476 => "Chifeng\,\ Inner\ Mongolia",
  861328477 => "Ordos\,\ Inner\ Mongolia",
  861328478 => "Bayannur\,\ Inner\ Mongolia",
  861328479 => "Bayannur\,\ Inner\ Mongolia",
  861328480 => "Baotou\,\ Inner\ Mongolia",
  861328481 => "Hinggan\,\ Inner\ Mongolia",
  861328482 => "Hinggan\,\ Inner\ Mongolia",
  861328483 => "Ordos\,\ Inner\ Mongolia",
  861328484 => "Ordos\,\ Inner\ Mongolia",
  861328485 => "Ordos\,\ Inner\ Mongolia",
  861328486 => "Tongliao\,\ Inner\ Mongolia",
  861328487 => "Tongliao\,\ Inner\ Mongolia",
  861328488 => "Tongliao\,\ Inner\ Mongolia",
  861328489 => "Tongliao\,\ Inner\ Mongolia",
  861328490 => "Daqing\,\ Heilongjiang",
  861328491 => "Jiamusi\,\ Heilongjiang",
  861328492 => "Qitaihe\,\ Heilongjiang",
  861328493 => "Hegang\,\ Heilongjiang",
  861328494 => "Shuangyashan\,\ Heilongjiang",
  861328495 => "Suihua\,\ Heilongjiang",
  861328496 => "Mudanjiang\,\ Heilongjiang",
  861328497 => "Jixi\,\ Heilongjiang",
  861328498 => "Qiqihar\,\ Heilongjiang",
  861328499 => "Harbin\,\ Heilongjiang",
  861328500 => "Fuzhou\,\ Fujian",
  861328501 => "Quanzhou\,\ Fujian",
  861328502 => "Fuzhou\,\ Fujian",
  861328503 => "Quanzhou\,\ Fujian",
  861328504 => "Quanzhou\,\ Fujian",
  861328505 => "Longyan\,\ Fujian",
  861328506 => "Nanping\,\ Fujian",
  861328507 => "Zhengzhou\,\ Henan",
  861328508 => "Zhangzhou\,\ Fujian",
  861328509 => "Putian\,\ Fujian",
  86132851 => "Suzhou\,\ Jiangsu",
  861328520 => "Taizhou\,\ Jiangsu",
  861328521 => "Taizhou\,\ Jiangsu",
  861328522 => "Taizhou\,\ Jiangsu",
  861328523 => "Taizhou\,\ Jiangsu",
  861328524 => "Taizhou\,\ Jiangsu",
  861328525 => "Taizhou\,\ Jiangsu",
  861328526 => "Taizhou\,\ Jiangsu",
  861328527 => "Suqian\,\ Jiangsu",
  861328528 => "Suqian\,\ Jiangsu",
  861328529 => "Suqian\,\ Jiangsu",
  861328530 => "Heze\,\ Shandong",
  861328531 => "Jinan\,\ Shandong",
  861328532 => "Qingdao\,\ Shandong",
  861328533 => "Zibo\,\ Shandong",
  861328534 => "Dezhou\,\ Shandong",
  861328535 => "Yantai\,\ Shandong",
  861328536 => "Weifang\,\ Shandong",
  861328537 => "Jining\,\ Shandong",
  861328538 => "TaiAn\,\ Shandong",
  861328539 => "Linyi\,\ Shandong",
  861328540 => "Heze\,\ Shandong",
  861328541 => "Jinan\,\ Shandong",
  861328542 => "Qingdao\,\ Shandong",
  861328543 => "Binzhou\,\ Shandong",
  861328544 => "Dezhou\,\ Shandong",
  861328545 => "Yantai\,\ Shandong",
  861328546 => "Dongying\,\ Shandong",
  861328547 => "Jining\,\ Shandong",
  861328548 => "TaiAn\,\ Shandong",
  861328549 => "Linyi\,\ Shandong",
  861328550 => "Chuzhou\,\ Anhui",
  861328551 => "Hefei\,\ Anhui",
  861328552 => "Bengbu\,\ Anhui",
  861328553 => "Wuhu\,\ Anhui",
  861328554 => "Huainan\,\ Anhui",
  861328555 => "MaAnshan\,\ Anhui",
  861328556 => "Anqing\,\ Anhui",
  861328557 => "Suzhou\,\ Anhui",
  861328558 => "Fuyang\,\ Anhui",
  861328559 => "Huangshan\,\ Anhui",
  861328560 => "Hefei\,\ Anhui",
  861328561 => "Huaibei\,\ Anhui",
  861328562 => "Tongling\,\ Anhui",
  861328563 => "Xuancheng\,\ Anhui",
  861328564 => "LuAn\,\ Anhui",
  861328565 => "Hefei\,\ Anhui",
  861328566 => "Suzhou\,\ Anhui",
  861328567 => "Bozhou\,\ Anhui",
  861328568 => "Bozhou\,\ Anhui",
  861328569 => "Hefei\,\ Anhui",
  861328570 => "Quzhou\,\ Zhejiang",
  861328571 => "Hangzhou\,\ Zhejiang",
  861328572 => "Huzhou\,\ Zhejiang",
  861328573 => "Jiaxing\,\ Zhejiang",
  861328574 => "Ningbo\,\ Zhejiang",
  861328575 => "Shaoxing\,\ Zhejiang",
  861328576 => "Taizhou\,\ Zhejiang",
  861328577 => "Wenzhou\,\ Zhejiang",
  861328578 => "Lishui\,\ Zhejiang",
  861328579 => "Jinhua\,\ Zhejiang",
  861328580 => "Zhoushan\,\ Zhejiang",
  861328581 => "Hangzhou\,\ Zhejiang",
  861328582 => "Huzhou\,\ Zhejiang",
  861328583 => "Jiaxing\,\ Zhejiang",
  861328584 => "Ningbo\,\ Zhejiang",
  861328585 => "Shaoxing\,\ Zhejiang",
  861328586 => "Taizhou\,\ Zhejiang",
  861328587 => "Wenzhou\,\ Zhejiang",
  861328588 => "Lishui\,\ Zhejiang",
  861328589 => "Jinhua\,\ Zhejiang",
  861328590 => "Longyan\,\ Fujian",
  861328591 => "Fuzhou\,\ Fujian",
  861328592 => "Xiamen\,\ Fujian",
  861328593 => "Ningde\,\ Fujian",
  861328594 => "Fuzhou\,\ Fujian",
  861328595 => "Quanzhou\,\ Fujian",
  861328596 => "Sanming\,\ Fujian",
  861328597 => "Xiamen\,\ Fujian",
  861328598 => "Fuzhou\,\ Fujian",
  861328599 => "Quanzhou\,\ Fujian",
  861328600 => "Zhuhai\,\ Guangdong",
  861328601 => "Zhuhai\,\ Guangdong",
  861328602 => "Zhuhai\,\ Guangdong",
  861328603 => "Zhuhai\,\ Guangdong",
  861328604 => "Zhuhai\,\ Guangdong",
  861328605 => "Zhuhai\,\ Guangdong",
  861328606 => "Zhuhai\,\ Guangdong",
  861328607 => "Zhuhai\,\ Guangdong",
  861328608 => "Zhuhai\,\ Guangdong",
  861328609 => "Xingtai\,\ Hebei",
  86132861 => "Jiangmen\,\ Guangdong",
  86132862 => "Huizhou\,\ Guangdong",
  86132863 => "Zhongshan\,\ Guangdong",
  86132864 => "Shantou\,\ Guangdong",
  861328650 => "Zhaoqing\,\ Guangdong",
  861328651 => "Zhaoqing\,\ Guangdong",
  861328652 => "Zhaoqing\,\ Guangdong",
  861328653 => "Zhaoqing\,\ Guangdong",
  861328654 => "Handan\,\ Hebei",
  861328655 => "Zhaoqing\,\ Guangdong",
  861328656 => "Qingyuan\,\ Guangdong",
  861328657 => "Qingyuan\,\ Guangdong",
  861328658 => "Baoding\,\ Hebei",
  861328659 => "Qingyuan\,\ Guangdong",
  861328660 => "Jiangmen\,\ Guangdong",
  861328661 => "Jiangmen\,\ Guangdong",
  861328662 => "Jiangmen\,\ Guangdong",
  861328663 => "Jiangmen\,\ Guangdong",
  861328664 => "Xingtai\,\ Hebei",
  861328665 => "Shenzhen\,\ Guangdong",
  861328666 => "Shenzhen\,\ Guangdong",
  861328667 => "Shenzhen\,\ Guangdong",
  861328668 => "Shenzhen\,\ Guangdong",
  861328669 => "Shenzhen\,\ Guangdong",
  861328670 => "Heyuan\,\ Guangdong",
  861328671 => "Heyuan\,\ Guangdong",
  861328672 => "Heyuan\,\ Guangdong",
  861328673 => "Heyuan\,\ Guangdong",
  861328674 => "Heyuan\,\ Guangdong",
  861328675 => "Meizhou\,\ Guangdong",
  861328676 => "Meizhou\,\ Guangdong",
  861328677 => "Meizhou\,\ Guangdong",
  861328678 => "Meizhou\,\ Guangdong",
  861328679 => "Meizhou\,\ Guangdong",
  86132868 => "Guangzhou\,\ Guangdong",
  861328690 => "Zhongshan\,\ Guangdong",
  861328691 => "Zhongshan\,\ Guangdong",
  861328692 => "Zhongshan\,\ Guangdong",
  861328693 => "Zhongshan\,\ Guangdong",
  861328694 => "Zhongshan\,\ Guangdong",
  861328695 => "Zhanjiang\,\ Guangdong",
  861328696 => "Zhanjiang\,\ Guangdong",
  861328697 => "Zhanjiang\,\ Guangdong",
  861328698 => "Zhanjiang\,\ Guangdong",
  861328699 => "Zhanjiang\,\ Guangdong",
  861328700 => "Zibo\,\ Shandong",
  861328701 => "Zibo\,\ Shandong",
  861328702 => "Zibo\,\ Shandong",
  861328703 => "Zibo\,\ Shandong",
  861328704 => "Liaocheng\,\ Shandong",
  861328705 => "Heze\,\ Shandong",
  861328706 => "Zibo\,\ Shandong",
  861328707 => "Zibo\,\ Shandong",
  861328708 => "Zibo\,\ Shandong",
  861328709 => "Zibo\,\ Shandong",
  861328710 => "Laiwu\,\ Shandong",
  861328711 => "Laiwu\,\ Shandong",
  861328712 => "Linyi\,\ Shandong",
  861328713 => "Linyi\,\ Shandong",
  861328714 => "Linyi\,\ Shandong",
  861328715 => "Linyi\,\ Shandong",
  861328716 => "Linyi\,\ Shandong",
  861328717 => "Linyi\,\ Shandong",
  861328718 => "Linyi\,\ Shandong",
  861328719 => "Linyi\,\ Shandong",
  86132872 => "Jining\,\ Shandong",
  861328730 => "Dongying\,\ Shandong",
  861328731 => "Dongying\,\ Shandong",
  861328732 => "Dongying\,\ Shandong",
  861328733 => "Dongying\,\ Shandong",
  861328734 => "TaiAn\,\ Shandong",
  861328735 => "Dongying\,\ Shandong",
  861328736 => "Dongying\,\ Shandong",
  861328737 => "Dongying\,\ Shandong",
  861328738 => "Dongying\,\ Shandong",
  861328739 => "Binzhou\,\ Shandong",
  861328740 => "Rizhao\,\ Shandong",
  861328741 => "Rizhao\,\ Shandong",
  861328742 => "Yantai\,\ Shandong",
  861328743 => "Yantai\,\ Shandong",
  861328744 => "Yantai\,\ Shandong",
  861328745 => "Yantai\,\ Shandong",
  861328746 => "Yantai\,\ Shandong",
  861328747 => "Weifang\,\ Shandong",
  861328748 => "Weifang\,\ Shandong",
  861328749 => "Heze\,\ Shandong",
  86132875 => "Liaocheng\,\ Shandong",
  861328760 => "TaiAn\,\ Shandong",
  861328761 => "TaiAn\,\ Shandong",
  861328762 => "TaiAn\,\ Shandong",
  861328763 => "TaiAn\,\ Shandong",
  861328764 => "TaiAn\,\ Shandong",
  861328765 => "Weifang\,\ Shandong",
  861328766 => "Weifang\,\ Shandong",
  861328767 => "Weifang\,\ Shandong",
  861328768 => "Weifang\,\ Shandong",
  861328769 => "Weifang\,\ Shandong",
  86132877 => "Jinan\,\ Shandong",
  861328780 => "Weihai\,\ Shandong",
  861328781 => "Weihai\,\ Shandong",
  861328782 => "Weihai\,\ Shandong",
  861328783 => "Weihai\,\ Shandong",
  861328784 => "Weihai\,\ Shandong",
  861328785 => "Weihai\,\ Shandong",
  861328786 => "Weihai\,\ Shandong",
  861328787 => "Weihai\,\ Shandong",
  861328788 => "Zibo\,\ Shandong",
  861328789 => "Zibo\,\ Shandong",
  861328790 => "Heze\,\ Shandong",
  861328791 => "Heze\,\ Shandong",
  861328792 => "Heze\,\ Shandong",
  861328793 => "Heze\,\ Shandong",
  861328794 => "Heze\,\ Shandong",
  861328795 => "Yantai\,\ Shandong",
  861328796 => "Yantai\,\ Shandong",
  861328797 => "Yantai\,\ Shandong",
  861328798 => "Yantai\,\ Shandong",
  861328799 => "Yantai\,\ Shandong",
  86132880 => "Shantou\,\ Guangdong",
  861328810 => "Jieyang\,\ Guangdong",
  861328811 => "Jieyang\,\ Guangdong",
  861328812 => "Shaoguan\,\ Guangdong",
  861328813 => "Shaoguan\,\ Guangdong",
  861328814 => "Huizhou\,\ Guangdong",
  861328815 => "Huizhou\,\ Guangdong",
  861328816 => "Huizhou\,\ Guangdong",
  861328817 => "Huizhou\,\ Guangdong",
  861328818 => "Huizhou\,\ Guangdong",
  861328819 => "Yangjiang\,\ Guangdong",
  86132882 => "Foshan\,\ Guangdong",
  861328830 => "Foshan\,\ Guangdong",
  861328831 => "Foshan\,\ Guangdong",
  861328832 => "Langfang\,\ Hebei",
  861328833 => "Foshan\,\ Guangdong",
  861328834 => "Foshan\,\ Guangdong",
  861328835 => "Foshan\,\ Guangdong",
  861328836 => "Foshan\,\ Guangdong",
  861328837 => "Foshan\,\ Guangdong",
  861328838 => "Foshan\,\ Guangdong",
  861328839 => "Foshan\,\ Guangdong",
  861328840 => "Foshan\,\ Guangdong",
  861328841 => "Foshan\,\ Guangdong",
  861328842 => "Foshan\,\ Guangdong",
  861328843 => "Foshan\,\ Guangdong",
  861328844 => "Foshan\,\ Guangdong",
  861328845 => "Guangzhou\,\ Guangdong",
  861328846 => "Guangzhou\,\ Guangdong",
  861328847 => "Guangzhou\,\ Guangdong",
  861328848 => "Guangzhou\,\ Guangdong",
  861328849 => "Guangzhou\,\ Guangdong",
  86132885 => "Jieyang\,\ Guangdong",
  86132886 => "Guangzhou\,\ Guangdong",
  861328870 => "Yunfu\,\ Guangdong",
  861328871 => "Shijiazhuang\,\ Hebei",
  861328872 => "Yunfu\,\ Guangdong",
  861328873 => "Yunfu\,\ Guangdong",
  861328874 => "Shijiazhuang\,\ Hebei",
  861328875 => "Chaozhou\,\ Guangdong",
  861328876 => "Chaozhou\,\ Guangdong",
  861328877 => "Chaozhou\,\ Guangdong",
  861328878 => "Chaozhou\,\ Guangdong",
  861328879 => "Handan\,\ Hebei",
  861328880 => "Guangzhou\,\ Guangdong",
  861328881 => "Guangzhou\,\ Guangdong",
  861328882 => "Guangzhou\,\ Guangdong",
  861328883 => "Guangzhou\,\ Guangdong",
  861328884 => "Guangzhou\,\ Guangdong",
  861328885 => "Dongguan\,\ Guangdong",
  861328886 => "Dongguan\,\ Guangdong",
  861328887 => "Langfang\,\ Hebei",
  861328888 => "Dongguan\,\ Guangdong",
  861328889 => "Dongguan\,\ Guangdong",
  861328890 => "Qingyuan\,\ Guangdong",
  861328891 => "Qingyuan\,\ Guangdong",
  861328892 => "Qingyuan\,\ Guangdong",
  861328893 => "Baoding\,\ Hebei",
  861328894 => "Shaoguan\,\ Guangdong",
  861328895 => "Maoming\,\ Guangdong",
  861328896 => "Maoming\,\ Guangdong",
  861328897 => "Maoming\,\ Guangdong",
  861328898 => "Maoming\,\ Guangdong",
  861328899 => "Maoming\,\ Guangdong",
  861328900 => "Changji\,\ Xinjiang",
  861328901 => "Hotan\,\ Xinjiang",
  861328902 => "Hami\,\ Xinjiang",
  861328903 => "Hotan\,\ Xinjiang",
  861328904 => "Ili\,\ Xinjiang",
  861328905 => "Changji\,\ Xinjiang",
  861328906 => "Altay\,\ Xinjiang",
  861328907 => "Hotan\,\ Xinjiang",
  861328908 => "Kizilsu\,\ Xinjiang",
  861328909 => "Bortala\,\ Xinjiang",
  861328910 => "Xianyang\,\ Shaanxi",
  861328911 => "YanAn\,\ Shaanxi",
  861328912 => "Yulin\,\ Shaanxi",
  861328913 => "Weinan\,\ Shaanxi",
  861328914 => "Shangluo\,\ Shaanxi",
  861328915 => "Ankang\,\ Shaanxi",
  861328916 => "Hanzhong\,\ Shaanxi",
  861328917 => "Baoji\,\ Shaanxi",
  861328918 => "Baoji\,\ Shaanxi",
  861328919 => "Baoji\,\ Shaanxi",
  86132892 => "XiAn\,\ Shaanxi",
  86132893 => "XiAn\,\ Shaanxi",
  861328940 => "Xianyang\,\ Shaanxi",
  861328941 => "Xianyang\,\ Shaanxi",
  861328942 => "Weinan\,\ Shaanxi",
  861328943 => "Baoji\,\ Shaanxi",
  861328944 => "Hanzhong\,\ Shaanxi",
  861328945 => "Hanzhong\,\ Shaanxi",
  861328946 => "YanAn\,\ Shaanxi",
  861328947 => "Yulin\,\ Shaanxi",
  861328948 => "Yulin\,\ Shaanxi",
  861328949 => "Yulin\,\ Shaanxi",
  861328950 => "Yinchuan\,\ Ningxia",
  861328951 => "Yinchuan\,\ Ningxia",
  861328952 => "Shizuishan\,\ Ningxia",
  861328953 => "Wuzhong\,\ Ningxia",
  861328954 => "Guyuan\,\ Ningxia",
  861328955 => "Zhongwei\,\ Ningxia",
  861328956 => "Wuzhong\,\ Ningxia",
  861328957 => "Zhongwei\,\ Ningxia",
  861328958 => "Yinchuan\,\ Ningxia",
  861328959 => "Guyuan\,\ Ningxia",
  861328960 => "Hanzhong\,\ Shaanxi",
  861328961 => "Hanzhong\,\ Shaanxi",
  861328962 => "Hanzhong\,\ Shaanxi",
  861328963 => "YanAn\,\ Shaanxi",
  861328964 => "YanAn\,\ Shaanxi",
  861328965 => "YanAn\,\ Shaanxi",
  861328966 => "YanAn\,\ Shaanxi",
  861328967 => "YanAn\,\ Shaanxi",
  861328968 => "YanAn\,\ Shaanxi",
  861328969 => "YanAn\,\ Shaanxi",
  86132897 => "Yulin\,\ Shaanxi",
  86132898 => "XiAn\,\ Shaanxi",
  861328990 => "Karamay\,\ Xinjiang",
  861328991 => "Urumchi\,\ Xinjiang",
  861328992 => "Ili\,\ Xinjiang",
  861328993 => "Shihezi\,\ Xinjiang",
  861328994 => "Changji\,\ Xinjiang",
  861328995 => "Turpan\,\ Xinjiang",
  861328996 => "Bayingolin\,\ Xinjiang",
  861328997 => "Aksu\,\ Xinjiang",
  861328998 => "Kashi\,\ Xinjiang",
  861328999 => "Ili\,\ Xinjiang",
  86132900 => "Chongqing",
  861329010 => "Jinan\,\ Shandong",
  861329011 => "Zibo\,\ Shandong",
  861329012 => "TaiAn\,\ Shandong",
  861329013 => "TaiAn\,\ Shandong",
  861329014 => "Laiwu\,\ Shandong",
  861329015 => "Weifang\,\ Shandong",
  861329016 => "Rizhao\,\ Shandong",
  861329017 => "Weihai\,\ Shandong",
  861329018 => "Yantai\,\ Shandong",
  861329019 => "Heze\,\ Shandong",
  861329020 => "Linyi\,\ Shandong",
  861329021 => "Linyi\,\ Shandong",
  861329022 => "Zaozhuang\,\ Shandong",
  861329023 => "Dezhou\,\ Shandong",
  861329024 => "Jinan\,\ Shandong",
  861329025 => "Liaocheng\,\ Shandong",
  861329026 => "Liaocheng\,\ Shandong",
  861329027 => "Binzhou\,\ Shandong",
  861329028 => "Dezhou\,\ Shandong",
  861329029 => "Jinan\,\ Shandong",
  861329030 => "Jining\,\ Shandong",
  861329031 => "Dongying\,\ Shandong",
  861329032 => "Jinan\,\ Shandong",
  861329033 => "Jinan\,\ Shandong",
  861329034 => "Heze\,\ Shandong",
  861329035 => "Linyi\,\ Shandong",
  861329036 => "Yantai\,\ Shandong",
  861329037 => "Liaocheng\,\ Shandong",
  861329038 => "Laiwu\,\ Shandong",
  861329039 => "Rizhao\,\ Shandong",
  861329040 => "Handan\,\ Hebei",
  861329041 => "Shijiazhuang\,\ Hebei",
  861329042 => "Baoding\,\ Hebei",
  861329043 => "Zhangjiakou\,\ Hebei",
  861329044 => "Shijiazhuang\,\ Hebei",
  861329045 => "Tangshan\,\ Hebei",
  861329046 => "Langfang\,\ Hebei",
  861329047 => "Cangzhou\,\ Hebei",
  861329048 => "Handan\,\ Hebei",
  861329049 => "Xingtai\,\ Hebei",
  861329050 => "Handan\,\ Hebei",
  861329051 => "Shijiazhuang\,\ Hebei",
  861329052 => "Baoding\,\ Hebei",
  861329053 => "Tangshan\,\ Hebei",
  861329054 => "Baoding\,\ Hebei",
  861329055 => "Tangshan\,\ Hebei",
  861329056 => "Shijiazhuang\,\ Hebei",
  861329057 => "Handan\,\ Hebei",
  861329058 => "Hengshui\,\ Hebei",
  861329059 => "Xingtai\,\ Hebei",
  861329060 => "Handan\,\ Hebei",
  861329061 => "Shijiazhuang\,\ Hebei",
  861329062 => "Baoding\,\ Hebei",
  861329063 => "Zhangjiakou\,\ Hebei",
  861329064 => "Tangshan\,\ Hebei",
  861329065 => "Tangshan\,\ Hebei",
  861329066 => "Langfang\,\ Hebei",
  861329067 => "Cangzhou\,\ Hebei",
  861329068 => "Baoding\,\ Hebei",
  861329069 => "Xingtai\,\ Hebei",
  861329070 => "Jiaozuo\,\ Henan",
  861329071 => "Zhangzhou\,\ Fujian",
  861329072 => "Fuzhou\,\ Fujian",
  861329073 => "Fuzhou\,\ Fujian",
  861329074 => "Fuzhou\,\ Fujian",
  861329075 => "Xuchang\,\ Henan",
  861329076 => "Zhangzhou\,\ Fujian",
  861329077 => "Puyang\,\ Henan",
  861329078 => "Xiamen\,\ Fujian",
  861329079 => "Anyang\,\ Henan",
  861329080 => "Fuzhou\,\ Fujian",
  861329081 => "Fuzhou\,\ Fujian",
  861329082 => "Anyang\,\ Henan",
  861329083 => "Putian\,\ Fujian",
  861329084 => "Sanmenxia\,\ Henan",
  861329085 => "Quanzhou\,\ Fujian",
  861329086 => "Quanzhou\,\ Fujian",
  861329087 => "Zhangzhou\,\ Fujian",
  861329088 => "Quanzhou\,\ Fujian",
  861329089 => "Fuzhou\,\ Fujian",
  861329090 => "Zhengzhou\,\ Henan",
  861329091 => "Sanmenxia\,\ Henan",
  861329092 => "Pingdingshan\,\ Henan",
  861329093 => "Fuzhou\,\ Fujian",
  861329094 => "Zhengzhou\,\ Henan",
  861329095 => "Fuzhou\,\ Fujian",
  861329096 => "Zhengzhou\,\ Henan",
  861329097 => "Puyang\,\ Henan",
  861329098 => "Fuzhou\,\ Fujian",
  861329099 => "Xinyang\,\ Henan",
  861329100 => "Xuzhou\,\ Jiangsu",
  861329101 => "Xuzhou\,\ Jiangsu",
  861329102 => "Xuzhou\,\ Jiangsu",
  861329103 => "Xuzhou\,\ Jiangsu",
  861329104 => "Baiyin\,\ Gansu",
  861329105 => "Xuzhou\,\ Jiangsu",
  861329106 => "Baiyin\,\ Gansu",
  861329107 => "Dingxi\,\ Gansu",
  861329108 => "Suzhou\,\ Jiangsu",
  861329109 => "Suzhou\,\ Jiangsu",
  861329110 => "Nantong\,\ Jiangsu",
  861329111 => "Nantong\,\ Jiangsu",
  861329112 => "Nantong\,\ Jiangsu",
  861329113 => "Nantong\,\ Jiangsu",
  861329114 => "Suzhou\,\ Jiangsu",
  861329115 => "Suzhou\,\ Jiangsu",
  861329116 => "Suzhou\,\ Jiangsu",
  861329117 => "Suzhou\,\ Jiangsu",
  861329118 => "Suzhou\,\ Jiangsu",
  861329119 => "Suzhou\,\ Jiangsu",
  861329120 => "Wuxi\,\ Jiangsu",
  861329121 => "Wuxi\,\ Jiangsu",
  861329122 => "Wuxi\,\ Jiangsu",
  861329123 => "Wuxi\,\ Jiangsu",
  861329124 => "Wuxi\,\ Jiangsu",
  861329125 => "Yancheng\,\ Jiangsu",
  861329126 => "Nanjing\,\ Jiangsu",
  861329127 => "Nanjing\,\ Jiangsu",
  861329128 => "Nanjing\,\ Jiangsu",
  861329129 => "Nanjing\,\ Jiangsu",
  861329130 => "Changzhou\,\ Jiangsu",
  861329131 => "Changzhou\,\ Jiangsu",
  861329132 => "Changzhou\,\ Jiangsu",
  861329133 => "Changzhou\,\ Jiangsu",
  861329134 => "Changzhou\,\ Jiangsu",
  861329135 => "Yancheng\,\ Jiangsu",
  861329136 => "Yancheng\,\ Jiangsu",
  861329137 => "Yangzhou\,\ Jiangsu",
  861329138 => "Yangzhou\,\ Jiangsu",
  861329139 => "Yangzhou\,\ Jiangsu",
  861329140 => "Hangzhou\,\ Zhejiang",
  861329141 => "Hangzhou\,\ Zhejiang",
  861329142 => "Hangzhou\,\ Zhejiang",
  861329143 => "Jiaxing\,\ Zhejiang",
  861329144 => "Ningbo\,\ Zhejiang",
  861329145 => "Shaoxing\,\ Zhejiang",
  861329146 => "Taizhou\,\ Zhejiang",
  861329147 => "Wenzhou\,\ Zhejiang",
  861329148 => "Hangzhou\,\ Zhejiang",
  861329149 => "Jinhua\,\ Zhejiang",
  861329150 => "Jiaxing\,\ Zhejiang",
  861329151 => "Jiaxing\,\ Zhejiang",
  861329152 => "Jiaxing\,\ Zhejiang",
  861329153 => "Jiaxing\,\ Zhejiang",
  861329154 => "Jiaxing\,\ Zhejiang",
  861329155 => "Shaoxing\,\ Zhejiang",
  861329156 => "Wenzhou\,\ Zhejiang",
  861329157 => "Jinhua\,\ Zhejiang",
  861329158 => "Jinhua\,\ Zhejiang",
  861329159 => "Jinhua\,\ Zhejiang",
  86132916 => "Taizhou\,\ Zhejiang",
  86132917 => "Wenzhou\,\ Zhejiang",
  86132918 => "Hangzhou\,\ Zhejiang",
  86132919 => "Ningbo\,\ Zhejiang",
  86132920 => "Handan\,\ Hebei",
  86132921 => "Xingtai\,\ Hebei",
  86132922 => "Hengshui\,\ Hebei",
  86132923 => "Qinhuangdao\,\ Hebei",
  86132924 => "Tangshan\,\ Hebei",
  86132925 => "Tangshan\,\ Hebei",
  86132926 => "Langfang\,\ Hebei",
  86132927 => "Cangzhou\,\ Hebei",
  86132928 => "Shijiazhuang\,\ Hebei",
  86132929 => "Baoding\,\ Hebei",
  86132930 => "Handan\,\ Hebei",
  861329310 => "Xingtai\,\ Hebei",
  861329311 => "Xingtai\,\ Hebei",
  861329312 => "Xingtai\,\ Hebei",
  861329313 => "Xingtai\,\ Hebei",
  861329314 => "Xingtai\,\ Hebei",
  861329315 => "Qinhuangdao\,\ Hebei",
  861329316 => "Qinhuangdao\,\ Hebei",
  861329317 => "Qinhuangdao\,\ Hebei",
  861329318 => "Qinhuangdao\,\ Hebei",
  861329319 => "Qinhuangdao\,\ Hebei",
  86132932 => "Chengde\,\ Hebei",
  86132933 => "Zhangjiakou\,\ Hebei",
  86132934 => "Cangzhou\,\ Hebei",
  861329350 => "Xinzhou\,\ Shanxi",
  861329351 => "Taiyuan\,\ Shanxi",
  861329352 => "Datong\,\ Shanxi",
  861329353 => "Yangquan\,\ Shanxi",
  861329354 => "Jinzhong\,\ Shanxi",
  861329355 => "Changzhi\,\ Shanxi",
  861329356 => "Jincheng\,\ Shanxi",
  861329357 => "Linfen\,\ Shanxi",
  861329358 => "Lüliang\,\ Shanxi",
  861329359 => "Yuncheng\,\ Shanxi",
  861329360 => "Xinzhou\,\ Shanxi",
  861329361 => "Xinzhou\,\ Shanxi",
  861329362 => "Xinzhou\,\ Shanxi",
  861329363 => "Yangquan\,\ Shanxi",
  861329364 => "Yangquan\,\ Shanxi",
  861329365 => "Yangquan\,\ Shanxi",
  861329366 => "Lüliang\,\ Shanxi",
  861329367 => "Lüliang\,\ Shanxi",
  861329368 => "Shuozhou\,\ Shanxi",
  861329369 => "Shuozhou\,\ Shanxi",
  861329370 => "Changzhi\,\ Shanxi",
  861329371 => "Taiyuan\,\ Shanxi",
  861329372 => "Datong\,\ Shanxi",
  861329373 => "Yangquan\,\ Shanxi",
  861329374 => "Taiyuan\,\ Shanxi",
  861329375 => "Changzhi\,\ Shanxi",
  861329376 => "Jincheng\,\ Shanxi",
  861329377 => "Linfen\,\ Shanxi",
  861329378 => "Lüliang\,\ Shanxi",
  861329379 => "Yuncheng\,\ Shanxi",
  861329380 => "Jinzhong\,\ Shanxi",
  861329381 => "Taiyuan\,\ Shanxi",
  861329382 => "Datong\,\ Shanxi",
  861329383 => "Yangquan\,\ Shanxi",
  861329384 => "Lüliang\,\ Shanxi",
  861329385 => "Changzhi\,\ Shanxi",
  861329386 => "Yuncheng\,\ Shanxi",
  861329387 => "Linfen\,\ Shanxi",
  861329388 => "Taiyuan\,\ Shanxi",
  861329389 => "Jincheng\,\ Shanxi",
  861329390 => "Taiyuan\,\ Shanxi",
  861329391 => "Taiyuan\,\ Shanxi",
  861329392 => "Datong\,\ Shanxi",
  861329393 => "Xinzhou\,\ Shanxi",
  861329394 => "Lüliang\,\ Shanxi",
  861329395 => "Changzhi\,\ Shanxi",
  861329396 => "Linfen\,\ Shanxi",
  861329397 => "Yuncheng\,\ Shanxi",
  861329398 => "Shuozhou\,\ Shanxi",
  861329399 => "Yuncheng\,\ Shanxi",
  86132940 => "Zhangjiakou\,\ Hebei",
  86132941 => "Wuhan\,\ Hubei",
  861329420 => "Jingzhou\,\ Hubei",
  861329421 => "Shiyan\,\ Hubei",
  861329422 => "Shiyan\,\ Hubei",
  861329423 => "Huangshi\,\ Hubei",
  861329424 => "Yichang\,\ Hubei",
  861329425 => "Xiangfan\,\ Hubei",
  861329426 => "Huanggang\,\ Hubei",
  861329427 => "Huanggang\,\ Hubei",
  861329428 => "Jingmen\,\ Hubei",
  861329429 => "Ezhou\,\ Hubei",
  861329430 => "Changchun\,\ Jilin",
  861329431 => "Changchun\,\ Jilin",
  861329432 => "Jilin\,\ Jilin",
  861329433 => "Yanbian\,\ Jilin",
  861329434 => "Siping\,\ Jilin",
  861329435 => "Tonghua\,\ Jilin",
  861329436 => "Baicheng\,\ Jilin",
  861329437 => "Liaoyuan\,\ Jilin",
  861329438 => "Songyuan\,\ Jilin",
  861329439 => "Baishan\,\ Jilin",
  86132944 => "Jilin\,\ Jilin",
  861329450 => "Xinzhou\,\ Shanxi",
  861329451 => "Taiyuan\,\ Shanxi",
  861329452 => "Datong\,\ Shanxi",
  861329453 => "Yangquan\,\ Shanxi",
  861329454 => "Jinzhong\,\ Shanxi",
  861329455 => "Changzhi\,\ Shanxi",
  861329456 => "Jincheng\,\ Shanxi",
  861329457 => "Linfen\,\ Shanxi",
  861329458 => "Lüliang\,\ Shanxi",
  861329459 => "Yuncheng\,\ Shanxi",
  861329460 => "Xinzhou\,\ Shanxi",
  861329461 => "Xinzhou\,\ Shanxi",
  861329462 => "Datong\,\ Shanxi",
  861329463 => "Xinzhou\,\ Shanxi",
  861329464 => "Jincheng\,\ Shanxi",
  861329465 => "Lüliang\,\ Shanxi",
  861329466 => "Jinzhong\,\ Shanxi",
  861329467 => "Yuncheng\,\ Shanxi",
  861329468 => "Linfen\,\ Shanxi",
  861329469 => "Shuozhou\,\ Shanxi",
  861329470 => "Hulun\,\ Inner\ Mongolia",
  861329471 => "Hohhot\,\ Inner\ Mongolia",
  861329472 => "Baotou\,\ Inner\ Mongolia",
  861329473 => "Wuhai\,\ Inner\ Mongolia",
  861329474 => "Ulanqab\,\ Inner\ Mongolia",
  861329475 => "Tongliao\,\ Inner\ Mongolia",
  861329476 => "Chifeng\,\ Inner\ Mongolia",
  861329477 => "Ordos\,\ Inner\ Mongolia",
  861329478 => "Bayannur\,\ Inner\ Mongolia",
  861329479 => "Xilin\,\ Inner\ Mongolia",
  861329480 => "Hohhot\,\ Inner\ Mongolia",
  861329481 => "Hohhot\,\ Inner\ Mongolia",
  861329482 => "Hinggan\,\ Inner\ Mongolia",
  861329483 => "Alxa\,\ Inner\ Mongolia",
  861329484 => "Tongliao\,\ Inner\ Mongolia",
  861329485 => "Tongliao\,\ Inner\ Mongolia",
  861329486 => "Baotou\,\ Inner\ Mongolia",
  861329487 => "Ordos\,\ Inner\ Mongolia",
  861329488 => "Bayannur\,\ Inner\ Mongolia",
  861329489 => "Ordos\,\ Inner\ Mongolia",
  861329490 => "Zhaotong\,\ Yunnan",
  861329491 => "Zhaotong\,\ Yunnan",
  861329492 => "Zhaotong\,\ Yunnan",
  861329493 => "Kunming\,\ Yunnan",
  861329494 => "Kunming\,\ Yunnan",
  861329495 => "Kunming\,\ Yunnan",
  861329496 => "Kunming\,\ Yunnan",
  861329497 => "Kunming\,\ Yunnan",
  861329498 => "Honghe\,\ Yunnan",
  861329499 => "Honghe\,\ Yunnan",
  861329500 => "Quanzhou\,\ Fujian",
  861329501 => "Fuzhou\,\ Fujian",
  861329502 => "Quanzhou\,\ Fujian",
  861329503 => "Pingdingshan\,\ Henan",
  861329504 => "Xuchang\,\ Henan",
  861329505 => "Quanzhou\,\ Fujian",
  861329506 => "Sanming\,\ Fujian",
  861329507 => "Ningde\,\ Fujian",
  861329508 => "Kaifeng\,\ Henan",
  861329509 => "Nanping\,\ Fujian",
  86132951 => "Suzhou\,\ Jiangsu",
  861329520 => "HuaiAn\,\ Jiangsu",
  861329521 => "HuaiAn\,\ Jiangsu",
  861329522 => "HuaiAn\,\ Jiangsu",
  861329523 => "Taizhou\,\ Jiangsu",
  861329524 => "Taizhou\,\ Jiangsu",
  861329525 => "Taizhou\,\ Jiangsu",
  861329526 => "Taizhou\,\ Jiangsu",
  861329527 => "Suqian\,\ Jiangsu",
  861329528 => "Suqian\,\ Jiangsu",
  861329529 => "Suqian\,\ Jiangsu",
  861329530 => "Heze\,\ Shandong",
  861329531 => "Jinan\,\ Shandong",
  861329532 => "Qingdao\,\ Shandong",
  861329533 => "Zibo\,\ Shandong",
  861329534 => "Dezhou\,\ Shandong",
  861329535 => "Yantai\,\ Shandong",
  861329536 => "Weifang\,\ Shandong",
  861329537 => "Jining\,\ Shandong",
  861329538 => "TaiAn\,\ Shandong",
  861329539 => "Linyi\,\ Shandong",
  861329540 => "Heze\,\ Shandong",
  861329541 => "Jinan\,\ Shandong",
  861329542 => "Qingdao\,\ Shandong",
  861329543 => "Binzhou\,\ Shandong",
  861329544 => "Liaocheng\,\ Shandong",
  861329545 => "Yantai\,\ Shandong",
  861329546 => "Dongying\,\ Shandong",
  861329547 => "Jining\,\ Shandong",
  861329548 => "TaiAn\,\ Shandong",
  861329549 => "Linyi\,\ Shandong",
  861329550 => "Chuzhou\,\ Anhui",
  861329551 => "Hefei\,\ Anhui",
  861329552 => "Bengbu\,\ Anhui",
  861329553 => "Wuhu\,\ Anhui",
  861329554 => "Huainan\,\ Anhui",
  861329555 => "MaAnshan\,\ Anhui",
  861329556 => "Anqing\,\ Anhui",
  861329557 => "Suzhou\,\ Anhui",
  861329558 => "Fuyang\,\ Anhui",
  861329559 => "Huangshan\,\ Anhui",
  861329560 => "Hefei\,\ Anhui",
  861329561 => "Huaibei\,\ Anhui",
  861329562 => "Tongling\,\ Anhui",
  861329563 => "Xuancheng\,\ Anhui",
  861329564 => "LuAn\,\ Anhui",
  861329565 => "Wuhu\,\ Anhui",
  861329566 => "Chizhou\,\ Anhui",
  861329567 => "Bozhou\,\ Anhui",
  861329568 => "Fuyang\,\ Anhui",
  861329569 => "Hefei\,\ Anhui",
  861329570 => "Quzhou\,\ Zhejiang",
  861329571 => "Hangzhou\,\ Zhejiang",
  861329572 => "Huzhou\,\ Zhejiang",
  861329573 => "Jiaxing\,\ Zhejiang",
  861329574 => "Ningbo\,\ Zhejiang",
  861329575 => "Shaoxing\,\ Zhejiang",
  861329576 => "Taizhou\,\ Zhejiang",
  861329577 => "Wenzhou\,\ Zhejiang",
  861329578 => "Lishui\,\ Zhejiang",
  861329579 => "Jinhua\,\ Zhejiang",
  861329580 => "Zhoushan\,\ Zhejiang",
  861329581 => "Hangzhou\,\ Zhejiang",
  861329582 => "Huzhou\,\ Zhejiang",
  861329583 => "Jiaxing\,\ Zhejiang",
  861329584 => "Ningbo\,\ Zhejiang",
  861329585 => "Shaoxing\,\ Zhejiang",
  861329586 => "Taizhou\,\ Zhejiang",
  861329587 => "Wenzhou\,\ Zhejiang",
  861329588 => "Lishui\,\ Zhejiang",
  861329589 => "Jinhua\,\ Zhejiang",
  861329590 => "Quanzhou\,\ Fujian",
  861329591 => "Fuzhou\,\ Fujian",
  861329592 => "Xiamen\,\ Fujian",
  861329593 => "Putian\,\ Fujian",
  861329594 => "Fuzhou\,\ Fujian",
  861329595 => "Quanzhou\,\ Fujian",
  861329596 => "Zhangzhou\,\ Fujian",
  861329597 => "Fuzhou\,\ Fujian",
  861329598 => "Luoyang\,\ Henan",
  861329599 => "Xinyang\,\ Henan",
  86132960 => "Shanghai",
  86132961 => "Shanghai",
  86132962 => "Shanghai",
  861329630 => "Weihai\,\ Shandong",
  861329631 => "Weihai\,\ Shandong",
  861329632 => "Zaozhuang\,\ Shandong",
  861329633 => "Rizhao\,\ Shandong",
  861329634 => "Laiwu\,\ Shandong",
  861329635 => "Liaocheng\,\ Shandong",
  861329636 => "Weifang\,\ Shandong",
  861329637 => "Zaozhuang\,\ Shandong",
  861329638 => "Yantai\,\ Shandong",
  861329639 => "Qingdao\,\ Shandong",
  861329640 => "Jinan\,\ Shandong",
  861329641 => "Jinan\,\ Shandong",
  861329642 => "Qingdao\,\ Shandong",
  861329643 => "Zibo\,\ Shandong",
  861329644 => "Jinan\,\ Shandong",
  861329645 => "Yantai\,\ Shandong",
  861329646 => "Weifang\,\ Shandong",
  861329647 => "Dongying\,\ Shandong",
  861329648 => "Qingdao\,\ Shandong",
  861329649 => "Heze\,\ Shandong",
  86132965 => "Wuhan\,\ Hubei",
  86132966 => "Wuhan\,\ Hubei",
  861329670 => "Wenzhou\,\ Zhejiang",
  861329671 => "Hangzhou\,\ Zhejiang",
  861329672 => "Hangzhou\,\ Zhejiang",
  861329673 => "Hangzhou\,\ Zhejiang",
  861329674 => "Hangzhou\,\ Zhejiang",
  861329675 => "Hangzhou\,\ Zhejiang",
  861329676 => "Hangzhou\,\ Zhejiang",
  861329677 => "Jiaxing\,\ Zhejiang",
  861329678 => "Jiaxing\,\ Zhejiang",
  861329679 => "Jiaxing\,\ Zhejiang",
  861329680 => "Shaoxing\,\ Zhejiang",
  861329681 => "Ningbo\,\ Zhejiang",
  861329682 => "Ningbo\,\ Zhejiang",
  861329683 => "Ningbo\,\ Zhejiang",
  861329684 => "Ningbo\,\ Zhejiang",
  861329685 => "Ningbo\,\ Zhejiang",
  861329686 => "Ningbo\,\ Zhejiang",
  861329687 => "Taizhou\,\ Zhejiang",
  861329688 => "Taizhou\,\ Zhejiang",
  861329689 => "Wenzhou\,\ Zhejiang",
  861329690 => "Hohhot\,\ Inner\ Mongolia",
  861329691 => "Baotou\,\ Inner\ Mongolia",
  861329692 => "Baotou\,\ Inner\ Mongolia",
  861329693 => "Baotou\,\ Inner\ Mongolia",
  861329694 => "Ulanqab\,\ Inner\ Mongolia",
  861329695 => "Ulanqab\,\ Inner\ Mongolia",
  861329696 => "Ordos\,\ Inner\ Mongolia",
  861329697 => "Bayannur\,\ Inner\ Mongolia",
  861329698 => "Bayannur\,\ Inner\ Mongolia",
  861329699 => "Bayannur\,\ Inner\ Mongolia",
  86132970 => "Wuhan\,\ Hubei",
  861329710 => "Enshi\,\ Hubei",
  861329711 => "Jingzhou\,\ Hubei",
  861329712 => "Jingmen\,\ Hubei",
  861329713 => "Jingmen\,\ Hubei",
  861329714 => "Shiyan\,\ Hubei",
  861329715 => "Shiyan\,\ Hubei",
  861329716 => "Shiyan\,\ Hubei",
  861329717 => "Shiyan\,\ Hubei",
  861329718 => "Shiyan\,\ Hubei",
  861329719 => "Shiyan\,\ Hubei",
  861329720 => "Wuhan\,\ Hubei",
  861329721 => "Huangshi\,\ Hubei",
  861329722 => "Huangshi\,\ Hubei",
  861329723 => "Huangshi\,\ Hubei",
  861329724 => "Huangshi\,\ Hubei",
  861329725 => "Suizhou\,\ Hubei",
  861329726 => "Suizhou\,\ Hubei",
  861329727 => "Suizhou\,\ Hubei",
  861329728 => "Yichang\,\ Hubei",
  861329729 => "Xiangfan\,\ Hubei",
  861329730 => "Yueyang\,\ Hunan",
  861329731 => "Changsha\,\ Hunan",
  861329732 => "Xiangtan\,\ Hunan",
  861329733 => "Zhuzhou\,\ Hunan",
  861329734 => "Hengyang\,\ Hunan",
  861329735 => "Chenzhou\,\ Hunan",
  861329736 => "Changde\,\ Hunan",
  861329737 => "Yiyang\,\ Hunan",
  861329738 => "Loudi\,\ Hunan",
  861329739 => "Shaoyang\,\ Hunan",
  861329740 => "Changsha\,\ Hunan",
  861329741 => "Changsha\,\ Hunan",
  861329742 => "Changsha\,\ Hunan",
  861329743 => "Xiangxi\,\ Hunan",
  861329744 => "Zhangjiajie\,\ Hunan",
  861329745 => "Huaihua\,\ Hunan",
  861329746 => "Yongzhou\,\ Hunan",
  861329747 => "Changsha\,\ Hunan",
  861329748 => "Changsha\,\ Hunan",
  861329749 => "Changsha\,\ Hunan",
  861329750 => "Ezhou\,\ Hubei",
  861329751 => "Ezhou\,\ Hubei",
  861329752 => "Xiaogan\,\ Hubei",
  861329753 => "Xiaogan\,\ Hubei",
  861329754 => "Xiaogan\,\ Hubei",
  861329755 => "Xiaogan\,\ Hubei",
  861329756 => "Huanggang\,\ Hubei",
  861329757 => "Huanggang\,\ Hubei",
  861329758 => "Huanggang\,\ Hubei",
  861329759 => "Huanggang\,\ Hubei",
  861329760 => "Jingmen\,\ Hubei",
  861329761 => "Jingmen\,\ Hubei",
  861329762 => "Jingmen\,\ Hubei",
  861329763 => "Jingmen\,\ Hubei",
  861329764 => "Huangshi\,\ Hubei",
  861329765 => "Huangshi\,\ Hubei",
  861329766 => "Huangshi\,\ Hubei",
  861329767 => "Xianning\,\ Hubei",
  861329768 => "Xianning\,\ Hubei",
  861329769 => "Ezhou\,\ Hubei",
  861329770 => "Nanning\,\ Guangxi",
  861329771 => "Nanning\,\ Guangxi",
  861329772 => "Liuzhou\,\ Guangxi",
  861329773 => "Guilin\,\ Guangxi",
  861329774 => "Wuzhou\,\ Guangxi",
  861329775 => "Yulin\,\ Guangxi",
  861329776 => "Baise\,\ Guangxi",
  861329777 => "Qinzhou\,\ Guangxi",
  861329778 => "Hechi\,\ Guangxi",
  861329779 => "Liuzhou\,\ Guangxi",
  861329780 => "Nanning\,\ Guangxi",
  861329781 => "Nanning\,\ Guangxi",
  861329782 => "Liuzhou\,\ Guangxi",
  861329783 => "Guilin\,\ Guangxi",
  861329784 => "Wuzhou\,\ Guangxi",
  861329785 => "Yulin\,\ Guangxi",
  861329786 => "Yulin\,\ Guangxi",
  861329787 => "Qinzhou\,\ Guangxi",
  861329788 => "Hechi\,\ Guangxi",
  861329789 => "Liuzhou\,\ Guangxi",
  86132979 => "Wuhan\,\ Hubei",
  861329800 => "Chifeng\,\ Inner\ Mongolia",
  861329801 => "Chifeng\,\ Inner\ Mongolia",
  861329802 => "Chifeng\,\ Inner\ Mongolia",
  861329803 => "Chifeng\,\ Inner\ Mongolia",
  861329804 => "Tongliao\,\ Inner\ Mongolia",
  861329805 => "Tongliao\,\ Inner\ Mongolia",
  861329806 => "Tongliao\,\ Inner\ Mongolia",
  861329807 => "Tongliao\,\ Inner\ Mongolia",
  861329808 => "Tongliao\,\ Inner\ Mongolia",
  861329809 => "Tongliao\,\ Inner\ Mongolia",
  86132981 => "Zhengzhou\,\ Henan",
  861329820 => "Xuchang\,\ Henan",
  861329821 => "Xuchang\,\ Henan",
  861329822 => "Xuchang\,\ Henan",
  861329823 => "Xuchang\,\ Henan",
  861329824 => "Xuchang\,\ Henan",
  861329825 => "Xuchang\,\ Henan",
  861329826 => "Xuchang\,\ Henan",
  861329827 => "Sanmenxia\,\ Henan",
  861329828 => "Sanmenxia\,\ Henan",
  861329829 => "Sanmenxia\,\ Henan",
  861329830 => "Zhengzhou\,\ Henan",
  861329831 => "Zhengzhou\,\ Henan",
  861329832 => "Zhengzhou\,\ Henan",
  861329833 => "Zhengzhou\,\ Henan",
  861329834 => "Zhengzhou\,\ Henan",
  861329835 => "Zhengzhou\,\ Henan",
  861329836 => "Zhengzhou\,\ Henan",
  861329837 => "Jiaozuo\,\ Henan",
  861329838 => "Jiaozuo\,\ Henan",
  861329839 => "Jiaozuo\,\ Henan",
  861329840 => "Zhengzhou\,\ Henan",
  861329841 => "Zhengzhou\,\ Henan",
  861329842 => "Zhengzhou\,\ Henan",
  861329843 => "Xuchang\,\ Henan",
  861329844 => "Xuchang\,\ Henan",
  861329845 => "Xuchang\,\ Henan",
  861329846 => "Jiaozuo\,\ Henan",
  861329847 => "Jiaozuo\,\ Henan",
  861329848 => "Sanmenxia\,\ Henan",
  861329849 => "Sanmenxia\,\ Henan",
  861329850 => "Yueyang\,\ Hunan",
  861329851 => "Yueyang\,\ Hunan",
  861329852 => "Xiangtan\,\ Hunan",
  861329853 => "Xiangtan\,\ Hunan",
  861329854 => "Zhuzhou\,\ Hunan",
  861329855 => "Zhangjiajie\,\ Hunan",
  861329856 => "Zhuzhou\,\ Hunan",
  861329857 => "Hengyang\,\ Hunan",
  861329858 => "Hengyang\,\ Hunan",
  861329859 => "Chenzhou\,\ Hunan",
  861329860 => "Changde\,\ Hunan",
  861329861 => "Changde\,\ Hunan",
  861329862 => "Yiyang\,\ Hunan",
  861329863 => "Hengyang\,\ Hunan",
  861329864 => "Shaoyang\,\ Hunan",
  861329865 => "Changsha\,\ Hunan",
  861329866 => "Huaihua\,\ Hunan",
  861329867 => "Yongzhou\,\ Hunan",
  861329868 => "Changsha\,\ Hunan",
  861329869 => "Changsha\,\ Hunan",
  861329870 => "Harbin\,\ Heilongjiang",
  861329871 => "Qiqihar\,\ Heilongjiang",
  861329872 => "Qiqihar\,\ Heilongjiang",
  861329873 => "Jiamusi\,\ Heilongjiang",
  861329874 => "Mudanjiang\,\ Heilongjiang",
  861329875 => "Suihua\,\ Heilongjiang",
  861329876 => "Jiamusi\,\ Heilongjiang",
  861329877 => "Daqing\,\ Heilongjiang",
  861329878 => "Harbin\,\ Heilongjiang",
  861329879 => "Mudanjiang\,\ Heilongjiang",
  861329880 => "Yanbian\,\ Jilin",
  861329881 => "Baishan\,\ Jilin",
  861329882 => "Songyuan\,\ Jilin",
  861329883 => "Songyuan\,\ Jilin",
  861329884 => "Tonghua\,\ Jilin",
  861329885 => "Tonghua\,\ Jilin",
  861329886 => "Tonghua\,\ Jilin",
  861329887 => "Liaoyuan\,\ Jilin",
  861329888 => "Changchun\,\ Jilin",
  861329889 => "Siping\,\ Jilin",
  861329890 => "Lhasa\,\ Tibet",
  861329891 => "Lhasa\,\ Tibet",
  861329892 => "Xigaze\,\ Tibet",
  861329893 => "Shannan\,\ Tibet",
  861329894 => "Nyingchi\,\ Tibet",
  861329895 => "Lhasa\,\ Tibet",
  861329896 => "Nagqu\,\ Tibet",
  861329897 => "Lhasa\,\ Tibet",
  861329898 => "Lhasa\,\ Tibet",
  861329899 => "Lhasa\,\ Tibet",
  86132990 => "XiAn\,\ Shaanxi",
  861329910 => "XiAn\,\ Shaanxi",
  861329911 => "XiAn\,\ Shaanxi",
  861329912 => "XiAn\,\ Shaanxi",
  861329913 => "XiAn\,\ Shaanxi",
  861329914 => "Shangluo\,\ Shaanxi",
  861329915 => "Ankang\,\ Shaanxi",
  861329916 => "XiAn\,\ Shaanxi",
  861329917 => "XiAn\,\ Shaanxi",
  861329918 => "Shangluo\,\ Shaanxi",
  861329919 => "XiAn\,\ Shaanxi",
  861329920 => "Nanning\,\ Guangxi",
  861329921 => "Nanning\,\ Guangxi",
  861329922 => "Liuzhou\,\ Guangxi",
  861329923 => "Guilin\,\ Guangxi",
  861329924 => "Yulin\,\ Guangxi",
  861329925 => "Yulin\,\ Guangxi",
  861329926 => "Nanning\,\ Guangxi",
  861329927 => "Guilin\,\ Guangxi",
  861329928 => "Hechi\,\ Guangxi",
  861329929 => "Liuzhou\,\ Guangxi",
  861329930 => "Linxia\,\ Gansu",
  861329931 => "Lanzhou\,\ Gansu",
  861329932 => "Jiuquan\,\ Gansu",
  861329933 => "Baiyin\,\ Gansu",
  861329934 => "Jiayuguan\,\ Gansu",
  861329935 => "Wuwei\,\ Gansu",
  861329936 => "Wuwei\,\ Gansu",
  861329937 => "Jiuquan\,\ Gansu",
  861329938 => "Jiuquan\,\ Gansu",
  861329939 => "Longnan\,\ Gansu",
  861329940 => "Nanning\,\ Guangxi",
  861329941 => "Nanning\,\ Guangxi",
  861329942 => "Liuzhou\,\ Guangxi",
  861329943 => "Guilin\,\ Guangxi",
  861329944 => "Yulin\,\ Guangxi",
  861329945 => "Yulin\,\ Guangxi",
  861329946 => "Yulin\,\ Guangxi",
  861329947 => "Guilin\,\ Guangxi",
  861329948 => "Hechi\,\ Guangxi",
  861329949 => "Liuzhou\,\ Guangxi",
  861329950 => "Yinchuan\,\ Ningxia",
  861329951 => "Yinchuan\,\ Ningxia",
  861329952 => "Shizuishan\,\ Ningxia",
  861329953 => "Wuzhong\,\ Ningxia",
  861329954 => "Guyuan\,\ Ningxia",
  861329955 => "Zhongwei\,\ Ningxia",
  861329956 => "Wuzhong\,\ Ningxia",
  861329957 => "Zhongwei\,\ Ningxia",
  861329958 => "Yinchuan\,\ Ningxia",
  861329959 => "Guyuan\,\ Ningxia",
  861329960 => "Liuzhou\,\ Guangxi",
  861329961 => "Liuzhou\,\ Guangxi",
  861329962 => "Liuzhou\,\ Guangxi",
  861329963 => "Guilin\,\ Guangxi",
  861329964 => "Liuzhou\,\ Guangxi",
  861329965 => "Yulin\,\ Guangxi",
  861329966 => "Yulin\,\ Guangxi",
  861329967 => "Yulin\,\ Guangxi",
  861329968 => "Yulin\,\ Guangxi",
  861329969 => "Yulin\,\ Guangxi",
  861329970 => "Haibei\,\ Qinghai",
  861329971 => "Xining\,\ Qinghai",
  861329972 => "Haidong\,\ Qinghai",
  861329973 => "Huangnan\,\ Qinghai",
  861329974 => "Hainan\,\ Qinghai",
  861329975 => "Haidong\,\ Qinghai",
  861329976 => "Xining\,\ Qinghai",
  861329977 => "Haidong\,\ Qinghai",
  861329978 => "Xining\,\ Qinghai",
  861329979 => "Haidong\,\ Qinghai",
  861329980 => "Xining\,\ Qinghai",
  861329981 => "Xining\,\ Qinghai",
  861329982 => "Haidong\,\ Qinghai",
  861329983 => "Haidong\,\ Qinghai",
  861329984 => "Hainan\,\ Qinghai",
  861329985 => "Haidong\,\ Qinghai",
  861329986 => "Yushu\,\ Qinghai",
  861329987 => "Haixi\,\ Qinghai",
  861329988 => "Xining\,\ Qinghai",
  861329989 => "Haidong\,\ Qinghai",
  86132999 => "Tianjin",
  861330000 => "Nanning\,\ Guangxi",
  861330001 => "Anqing\,\ Anhui",
  861330002 => "Chongqing",
  861330003 => "Chongqing",
  861330010 => "Beijing",
  861330011 => "Beijing",
  861330018 => "Shanghai",
  861330019 => "Shanghai",
  86133003 => "Tianjin",
  86133005 => "Shanghai",
  86133006 => "Shanghai",
  86133007 => "Nanning\,\ Guangxi",
  86133008 => "Shanghai",
  86133009 => "Shanghai",
  86133010 => "Beijing",
  86133011 => "Beijing",
  86133012 => "Beijing",
  86133013 => "Beijing",
  861330140 => "HuaiAn\,\ Jiangsu",
  861330141 => "Yancheng\,\ Jiangsu",
  861330142 => "Taizhou\,\ Jiangsu",
  861330143 => "Taizhou\,\ Jiangsu",
  861330144 => "Yangzhou\,\ Jiangsu",
  861330145 => "Yangzhou\,\ Jiangsu",
  861330146 => "Nantong\,\ Jiangsu",
  861330147 => "Nantong\,\ Jiangsu",
  861330148 => "Nantong\,\ Jiangsu",
  861330149 => "Changzhou\,\ Jiangsu",
  861330150 => "Changzhou\,\ Jiangsu",
  861330151 => "Wuxi\,\ Jiangsu",
  861330152 => "Wuxi\,\ Jiangsu",
  861330153 => "Wuxi\,\ Jiangsu",
  861330154 => "Suzhou\,\ Jiangsu",
  861330155 => "Suzhou\,\ Jiangsu",
  861330156 => "Suzhou\,\ Jiangsu",
  861330157 => "Suzhou\,\ Jiangsu",
  861330158 => "Nanjing\,\ Jiangsu",
  861330159 => "Nanjing\,\ Jiangsu",
  86133016 => "Shanghai",
  86133017 => "Shanghai",
  86133018 => "Shanghai",
  86133019 => "Shanghai",
  86133020 => "Tianjin",
  86133021 => "Tianjin",
  86133022 => "Guangzhou\,\ Guangdong",
  861330230 => "Guangzhou\,\ Guangdong",
  861330231 => "Shenzhen\,\ Guangdong",
  861330232 => "Guangzhou\,\ Guangdong",
  861330233 => "Guangzhou\,\ Guangdong",
  861330234 => "Shaoguan\,\ Guangdong",
  861330235 => "Qingyuan\,\ Guangdong",
  861330236 => "Zhaoqing\,\ Guangdong",
  861330237 => "Yunfu\,\ Guangdong",
  861330238 => "Guangzhou\,\ Guangdong",
  861330239 => "Guangzhou\,\ Guangdong",
  861330240 => "Guangzhou\,\ Guangdong",
  861330241 => "Foshan\,\ Guangdong",
  861330242 => "Foshan\,\ Guangdong",
  861330243 => "Shenzhen\,\ Guangdong",
  861330244 => "Shenzhen\,\ Guangdong",
  861330245 => "Shenzhen\,\ Guangdong",
  861330246 => "Shenzhen\,\ Guangdong",
  861330247 => "Shenzhen\,\ Guangdong",
  861330248 => "Shenzhen\,\ Guangdong",
  861330249 => "Guangzhou\,\ Guangdong",
  861330250 => "Zhanjiang\,\ Guangdong",
  861330251 => "Maoming\,\ Guangdong",
  861330252 => "Yangjiang\,\ Guangdong",
  861330253 => "Zhuhai\,\ Guangdong",
  861330254 => "Maoming\,\ Guangdong",
  861330255 => "Jiangmen\,\ Guangdong",
  861330256 => "Foshan\,\ Guangdong",
  861330257 => "Zhanjiang\,\ Guangdong",
  861330258 => "Jiangmen\,\ Guangdong",
  861330259 => "Zhongshan\,\ Guangdong",
  861330260 => "Dongguan\,\ Guangdong",
  861330261 => "Dongguan\,\ Guangdong",
  861330262 => "Huizhou\,\ Guangdong",
  861330263 => "Heyuan\,\ Guangdong",
  861330264 => "Dongguan\,\ Guangdong",
  861330265 => "Huizhou\,\ Guangdong",
  861330266 => "Huizhou\,\ Guangdong",
  861330267 => "Shanwei\,\ Guangdong",
  861330268 => "Shanwei\,\ Guangdong",
  861330269 => "Dongguan\,\ Guangdong",
  861330270 => "Shantou\,\ Guangdong",
  861330271 => "Shantou\,\ Guangdong",
  861330272 => "Shantou\,\ Guangdong",
  861330273 => "Shantou\,\ Guangdong",
  861330274 => "Shantou\,\ Guangdong",
  861330275 => "Jieyang\,\ Guangdong",
  861330276 => "Jieyang\,\ Guangdong",
  861330277 => "Shantou\,\ Guangdong",
  861330278 => "Meizhou\,\ Guangdong",
  861330279 => "Chaozhou\,\ Guangdong",
  861330280 => "Foshan\,\ Guangdong",
  861330281 => "Foshan\,\ Guangdong",
  861330282 => "Zhongshan\,\ Guangdong",
  861330283 => "Foshan\,\ Guangdong",
  861330284 => "Foshan\,\ Guangdong",
  861330285 => "Foshan\,\ Guangdong",
  861330286 => "Zhuhai\,\ Guangdong",
  861330287 => "Zhuhai\,\ Guangdong",
  861330288 => "Jiangmen\,\ Guangdong",
  861330289 => "Foshan\,\ Guangdong",
  86133029 => "Shenzhen\,\ Guangdong",
  861330300 => "Handan\,\ Hebei",
  861330301 => "Shijiazhuang\,\ Hebei",
  861330302 => "Baoding\,\ Hebei",
  861330303 => "Shijiazhuang\,\ Hebei",
  861330304 => "Shijiazhuang\,\ Hebei",
  861330305 => "Tangshan\,\ Hebei",
  861330306 => "Cangzhou\,\ Hebei",
  861330307 => "Cangzhou\,\ Hebei",
  861330308 => "Handan\,\ Hebei",
  861330309 => "Xingtai\,\ Hebei",
  861330310 => "Handan\,\ Hebei",
  861330311 => "Shijiazhuang\,\ Hebei",
  861330312 => "Baoding\,\ Hebei",
  861330313 => "Zhangjiakou\,\ Hebei",
  861330314 => "Chengde\,\ Hebei",
  861330315 => "Tangshan\,\ Hebei",
  861330316 => "Langfang\,\ Hebei",
  861330317 => "Cangzhou\,\ Hebei",
  861330318 => "Hengshui\,\ Hebei",
  861330319 => "Xingtai\,\ Hebei",
  861330320 => "Handan\,\ Hebei",
  861330321 => "Shijiazhuang\,\ Hebei",
  861330322 => "Baoding\,\ Hebei",
  861330323 => "Shijiazhuang\,\ Hebei",
  861330324 => "Tangshan\,\ Hebei",
  861330325 => "Tangshan\,\ Hebei",
  861330326 => "Baoding\,\ Hebei",
  861330327 => "Qinhuangdao\,\ Hebei",
  861330328 => "Qinhuangdao\,\ Hebei",
  861330329 => "Shijiazhuang\,\ Hebei",
  861330330 => "Handan\,\ Hebei",
  861330331 => "Shijiazhuang\,\ Hebei",
  861330332 => "Baoding\,\ Hebei",
  861330333 => "Zhangjiakou\,\ Hebei",
  861330334 => "Tangshan\,\ Hebei",
  861330335 => "Qinhuangdao\,\ Hebei",
  861330336 => "Langfang\,\ Hebei",
  861330337 => "Cangzhou\,\ Hebei",
  861330338 => "Hengshui\,\ Hebei",
  861330339 => "Xingtai\,\ Hebei",
  861330340 => "Taiyuan\,\ Shanxi",
  861330341 => "Taiyuan\,\ Shanxi",
  861330342 => "Datong\,\ Shanxi",
  861330343 => "Taiyuan\,\ Shanxi",
  861330344 => "Jinzhong\,\ Shanxi",
  861330345 => "Changzhi\,\ Shanxi",
  861330346 => "Taiyuan\,\ Shanxi",
  861330347 => "Linfen\,\ Shanxi",
  861330348 => "Yuncheng\,\ Shanxi",
  861330349 => "Shuozhou\,\ Shanxi",
  861330350 => "Xinzhou\,\ Shanxi",
  861330351 => "Taiyuan\,\ Shanxi",
  861330352 => "Datong\,\ Shanxi",
  861330353 => "Yangquan\,\ Shanxi",
  861330354 => "Jinzhong\,\ Shanxi",
  861330355 => "Changzhi\,\ Shanxi",
  861330356 => "Jincheng\,\ Shanxi",
  861330357 => "Linfen\,\ Shanxi",
  861330358 => "Lüliang\,\ Shanxi",
  861330359 => "Yuncheng\,\ Shanxi",
  861330360 => "Harbin\,\ Heilongjiang",
  861330361 => "Harbin\,\ Heilongjiang",
  861330362 => "Qiqihar\,\ Heilongjiang",
  861330363 => "Mudanjiang\,\ Heilongjiang",
  861330364 => "Harbin\,\ Heilongjiang",
  861330365 => "Harbin\,\ Heilongjiang",
  861330366 => "Harbin\,\ Heilongjiang",
  861330367 => "Jixi\,\ Heilongjiang",
  861330368 => "Jiamusi\,\ Heilongjiang",
  861330369 => "Daqing\,\ Heilongjiang",
  861330370 => "Shangqiu\,\ Henan",
  861330371 => "Zhengzhou\,\ Henan",
  861330372 => "Anyang\,\ Henan",
  861330373 => "Xinxiang\,\ Henan",
  861330374 => "Xuchang\,\ Henan",
  861330375 => "Pingdingshan\,\ Henan",
  861330376 => "Xinyang\,\ Henan",
  861330377 => "Nanyang\,\ Henan",
  861330378 => "Kaifeng\,\ Henan",
  861330379 => "Luoyang\,\ Henan",
  861330380 => "Xinxiang\,\ Henan",
  861330381 => "Zhengzhou\,\ Henan",
  861330382 => "Zhengzhou\,\ Henan",
  861330383 => "Zhengzhou\,\ Henan",
  861330384 => "Zhengzhou\,\ Henan",
  861330385 => "Zhengzhou\,\ Henan",
  861330386 => "Zhengzhou\,\ Henan",
  861330387 => "Zhoukou\,\ Henan",
  861330388 => "Luoyang\,\ Henan",
  861330389 => "Jiaozuo\,\ Henan",
  861330390 => "Pingdingshan\,\ Henan",
  861330391 => "Jiaozuo\,\ Henan",
  861330392 => "Hebi\,\ Henan",
  861330393 => "Puyang\,\ Henan",
  861330394 => "Zhoukou\,\ Henan",
  861330395 => "Luohe\,\ Henan",
  861330396 => "Zhumadian\,\ Henan",
  861330397 => "Xinyang\,\ Henan",
  861330398 => "Sanmenxia\,\ Henan",
  861330399 => "Xuchang\,\ Henan",
  861330400 => "Shenyang\,\ Liaoning",
  861330401 => "Shenyang\,\ Liaoning",
  861330402 => "Shenyang\,\ Liaoning",
  861330403 => "Shenyang\,\ Liaoning",
  861330404 => "Shenyang\,\ Liaoning",
  861330405 => "Shenyang\,\ Liaoning",
  861330406 => "Jinzhou\,\ Liaoning",
  861330407 => "Yingkou\,\ Liaoning",
  861330408 => "Dalian\,\ Liaoning",
  861330409 => "Dalian\,\ Liaoning",
  861330410 => "Tieling\,\ Liaoning",
  861330411 => "Dalian\,\ Liaoning",
  861330412 => "Anshan\,\ Liaoning",
  861330413 => "Fushun\,\ Liaoning",
  861330414 => "Benxi\,\ Liaoning",
  861330415 => "Dandong\,\ Liaoning",
  861330416 => "Jinzhou\,\ Liaoning",
  861330417 => "Yingkou\,\ Liaoning",
  861330418 => "Fuxin\,\ Liaoning",
  861330419 => "Liaoyang\,\ Liaoning",
  861330420 => "Anshan\,\ Liaoning",
  861330421 => "Chaoyang\,\ Liaoning",
  861330422 => "Anshan\,\ Liaoning",
  861330423 => "Fushun\,\ Liaoning",
  861330424 => "Benxi\,\ Liaoning",
  861330425 => "Dandong\,\ Liaoning",
  861330426 => "Dalian\,\ Liaoning",
  861330427 => "Panjin\,\ Liaoning",
  861330428 => "Dalian\,\ Liaoning",
  861330429 => "Huludao\,\ Liaoning",
  861330430 => "Changchun\,\ Jilin",
  861330431 => "Changchun\,\ Jilin",
  861330432 => "Changchun\,\ Jilin",
  861330433 => "Changchun\,\ Jilin",
  861330434 => "Siping\,\ Jilin",
  861330435 => "Siping\,\ Jilin",
  861330436 => "Baicheng\,\ Jilin",
  861330437 => "Liaoyuan\,\ Jilin",
  861330438 => "Songyuan\,\ Jilin",
  861330439 => "Changchun\,\ Jilin",
  861330440 => "Jilin\,\ Jilin",
  861330441 => "Jilin\,\ Jilin",
  861330442 => "Jilin\,\ Jilin",
  861330443 => "Yanbian\,\ Jilin",
  861330444 => "Jilin\,\ Jilin",
  861330445 => "Tonghua\,\ Jilin",
  861330446 => "Yanbian\,\ Jilin",
  861330447 => "Yanbian\,\ Jilin",
  861330448 => "Yanbian\,\ Jilin",
  861330449 => "Baishan\,\ Jilin",
  861330450 => "Harbin\,\ Heilongjiang",
  861330451 => "Harbin\,\ Heilongjiang",
  861330452 => "Qiqihar\,\ Heilongjiang",
  861330453 => "Mudanjiang\,\ Heilongjiang",
  861330454 => "Jiamusi\,\ Heilongjiang",
  861330455 => "Suihua\,\ Heilongjiang",
  861330456 => "Heihe\,\ Heilongjiang",
  861330457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861330458 => "Yichun\,\ Heilongjiang",
  861330459 => "Daqing\,\ Heilongjiang",
  861330460 => "Harbin\,\ Heilongjiang",
  861330461 => "Harbin\,\ Heilongjiang",
  861330462 => "Qiqihar\,\ Heilongjiang",
  861330463 => "Harbin\,\ Heilongjiang",
  861330464 => "Harbin\,\ Heilongjiang",
  861330465 => "Harbin\,\ Heilongjiang",
  861330466 => "Harbin\,\ Heilongjiang",
  861330467 => "Qitaihe\,\ Heilongjiang",
  861330468 => "Hegang\,\ Heilongjiang",
  861330469 => "Daqing\,\ Heilongjiang",
  861330470 => "Hulun\,\ Inner\ Mongolia",
  861330471 => "Hohhot\,\ Inner\ Mongolia",
  861330472 => "Baotou\,\ Inner\ Mongolia",
  861330473 => "Wuhai\,\ Inner\ Mongolia",
  861330474 => "Hinggan\,\ Inner\ Mongolia",
  861330475 => "Tongliao\,\ Inner\ Mongolia",
  861330476 => "Chifeng\,\ Inner\ Mongolia",
  861330477 => "Ordos\,\ Inner\ Mongolia",
  861330478 => "Bayannur\,\ Inner\ Mongolia",
  861330479 => "Xilin\,\ Inner\ Mongolia",
  861330480 => "Harbin\,\ Heilongjiang",
  861330481 => "Harbin\,\ Heilongjiang",
  861330482 => "Qiqihar\,\ Heilongjiang",
  861330483 => "Mudanjiang\,\ Heilongjiang",
  861330484 => "Harbin\,\ Heilongjiang",
  861330485 => "Suihua\,\ Heilongjiang",
  861330486 => "Daqing\,\ Heilongjiang",
  861330487 => "Jixi\,\ Heilongjiang",
  861330488 => "Shuangyashan\,\ Heilongjiang",
  861330489 => "Daqing\,\ Heilongjiang",
  861330490 => "Tieling\,\ Liaoning",
  861330491 => "Chaoyang\,\ Liaoning",
  861330492 => "Anshan\,\ Liaoning",
  861330493 => "Fushun\,\ Liaoning",
  861330494 => "Benxi\,\ Liaoning",
  861330495 => "Dandong\,\ Liaoning",
  861330496 => "Jinzhou\,\ Liaoning",
  861330497 => "Yingkou\,\ Liaoning",
  861330498 => "Fuxin\,\ Liaoning",
  861330499 => "Liaoyang\,\ Liaoning",
  861330500 => "Fuzhou\,\ Fujian",
  861330501 => "Fuzhou\,\ Fujian",
  861330502 => "Fuzhou\,\ Fujian",
  861330503 => "Ningde\,\ Fujian",
  861330504 => "Putian\,\ Fujian",
  861330505 => "Quanzhou\,\ Fujian",
  861330506 => "Quanzhou\,\ Fujian",
  861330507 => "Quanzhou\,\ Fujian",
  861330508 => "Quanzhou\,\ Fujian",
  861330509 => "Nanping\,\ Fujian",
  861330510 => "Yancheng\,\ Jiangsu",
  861330511 => "Yancheng\,\ Jiangsu",
  861330512 => "Lianyungang\,\ Jiangsu",
  861330513 => "Lianyungang\,\ Jiangsu",
  861330514 => "Nanjing\,\ Jiangsu",
  861330515 => "Nanjing\,\ Jiangsu",
  861330516 => "Nanjing\,\ Jiangsu",
  861330517 => "Nanjing\,\ Jiangsu",
  861330518 => "Nanjing\,\ Jiangsu",
  861330519 => "Nanjing\,\ Jiangsu",
  861330520 => "Xuzhou\,\ Jiangsu",
  861330521 => "Xuzhou\,\ Jiangsu",
  861330522 => "Xuzhou\,\ Jiangsu",
  861330523 => "HuaiAn\,\ Jiangsu",
  861330524 => "Suqian\,\ Jiangsu",
  861330525 => "Yangzhou\,\ Jiangsu",
  861330526 => "Taizhou\,\ Jiangsu",
  861330527 => "Yangzhou\,\ Jiangsu",
  861330528 => "Zhenjiang\,\ Jiangsu",
  861330529 => "Zhenjiang\,\ Jiangsu",
  861330530 => "Heze\,\ Shandong",
  861330531 => "Jinan\,\ Shandong",
  861330532 => "Qingdao\,\ Shandong",
  861330533 => "Zibo\,\ Shandong",
  861330534 => "Dezhou\,\ Shandong",
  861330535 => "Yantai\,\ Shandong",
  861330536 => "Weifang\,\ Shandong",
  861330537 => "Jining\,\ Shandong",
  861330538 => "TaiAn\,\ Shandong",
  861330539 => "Linyi\,\ Shandong",
  861330540 => "Heze\,\ Shandong",
  861330541 => "Jinan\,\ Shandong",
  861330542 => "Qingdao\,\ Shandong",
  861330543 => "Binzhou\,\ Shandong",
  861330544 => "Dezhou\,\ Shandong",
  861330545 => "Yantai\,\ Shandong",
  861330546 => "Dongying\,\ Shandong",
  861330547 => "Jining\,\ Shandong",
  861330548 => "TaiAn\,\ Shandong",
  861330549 => "Linyi\,\ Shandong",
  861330550 => "Chuzhou\,\ Anhui",
  861330551 => "Hefei\,\ Anhui",
  861330552 => "Bengbu\,\ Anhui",
  861330553 => "Wuhu\,\ Anhui",
  861330554 => "Huainan\,\ Anhui",
  861330555 => "MaAnshan\,\ Anhui",
  861330556 => "Anqing\,\ Anhui",
  861330557 => "Suzhou\,\ Anhui",
  861330558 => "Fuyang\,\ Anhui",
  861330559 => "Huangshan\,\ Anhui",
  861330560 => "Hefei\,\ Anhui",
  861330561 => "Huaibei\,\ Anhui",
  861330562 => "Tongling\,\ Anhui",
  861330563 => "Xuancheng\,\ Anhui",
  861330564 => "LuAn\,\ Anhui",
  861330565 => "Chaohu\,\ Anhui",
  861330566 => "Chizhou\,\ Anhui",
  861330567 => "Suzhou\,\ Anhui",
  861330568 => "Fuyang\,\ Anhui",
  861330569 => "Hefei\,\ Anhui",
  861330570 => "Quzhou\,\ Zhejiang",
  861330571 => "Hangzhou\,\ Zhejiang",
  861330572 => "Huzhou\,\ Zhejiang",
  861330573 => "Jiaxing\,\ Zhejiang",
  861330574 => "Ningbo\,\ Zhejiang",
  861330575 => "Shaoxing\,\ Zhejiang",
  861330576 => "Taizhou\,\ Zhejiang",
  861330577 => "Wenzhou\,\ Zhejiang",
  861330578 => "Lishui\,\ Zhejiang",
  861330579 => "Jinhua\,\ Zhejiang",
  861330580 => "Zhoushan\,\ Zhejiang",
  861330581 => "Hangzhou\,\ Zhejiang",
  861330582 => "Huzhou\,\ Zhejiang",
  861330583 => "Jiaxing\,\ Zhejiang",
  861330584 => "Ningbo\,\ Zhejiang",
  861330585 => "Shaoxing\,\ Zhejiang",
  861330586 => "Taizhou\,\ Zhejiang",
  861330587 => "Wenzhou\,\ Zhejiang",
  861330588 => "Lishui\,\ Zhejiang",
  861330589 => "Jinhua\,\ Zhejiang",
  861330590 => "Fuzhou\,\ Fujian",
  861330591 => "Fuzhou\,\ Fujian",
  861330592 => "Fuzhou\,\ Fujian",
  861330593 => "Ningde\,\ Fujian",
  861330594 => "Putian\,\ Fujian",
  861330595 => "Quanzhou\,\ Fujian",
  861330596 => "Quanzhou\,\ Fujian",
  861330597 => "Quanzhou\,\ Fujian",
  861330598 => "Quanzhou\,\ Fujian",
  861330599 => "Nanping\,\ Fujian",
  861330600 => "Xiamen\,\ Fujian",
  861330601 => "Xiamen\,\ Fujian",
  861330602 => "Xiamen\,\ Fujian",
  861330603 => "Xiamen\,\ Fujian",
  861330604 => "Xiamen\,\ Fujian",
  861330605 => "Xiamen\,\ Fujian",
  861330606 => "Zhangzhou\,\ Fujian",
  861330607 => "Longyan\,\ Fujian",
  861330608 => "Sanming\,\ Fujian",
  861330609 => "Quanzhou\,\ Fujian",
  861330610 => "Zhenjiang\,\ Jiangsu",
  861330611 => "Changzhou\,\ Jiangsu",
  861330612 => "Changzhou\,\ Jiangsu",
  861330613 => "Suzhou\,\ Jiangsu",
  861330614 => "Changzhou\,\ Jiangsu",
  861330615 => "Wuxi\,\ Jiangsu",
  861330616 => "Wuxi\,\ Jiangsu",
  861330617 => "Wuxi\,\ Jiangsu",
  861330618 => "Wuxi\,\ Jiangsu",
  861330619 => "Wuxi\,\ Jiangsu",
  861330620 => "Suzhou\,\ Jiangsu",
  861330621 => "Suzhou\,\ Jiangsu",
  861330622 => "Suzhou\,\ Jiangsu",
  861330623 => "Suzhou\,\ Jiangsu",
  861330624 => "Suzhou\,\ Jiangsu",
  861330625 => "Suzhou\,\ Jiangsu",
  861330626 => "Suzhou\,\ Jiangsu",
  861330627 => "Nantong\,\ Jiangsu",
  861330628 => "Nantong\,\ Jiangsu",
  861330629 => "Nantong\,\ Jiangsu",
  861330630 => "Weihai\,\ Shandong",
  861330631 => "Weihai\,\ Shandong",
  861330632 => "Zaozhuang\,\ Shandong",
  861330633 => "Rizhao\,\ Shandong",
  861330634 => "Laiwu\,\ Shandong",
  861330635 => "Liaocheng\,\ Shandong",
  861330636 => "Weifang\,\ Shandong",
  861330637 => "Zaozhuang\,\ Shandong",
  861330638 => "Yantai\,\ Shandong",
  861330639 => "Qingdao\,\ Shandong",
  861330640 => "Jinan\,\ Shandong",
  861330641 => "Jinan\,\ Shandong",
  861330642 => "Qingdao\,\ Shandong",
  861330643 => "Zibo\,\ Shandong",
  861330644 => "Jinan\,\ Shandong",
  861330645 => "Yantai\,\ Shandong",
  861330646 => "Weifang\,\ Shandong",
  861330647 => "Dongying\,\ Shandong",
  861330648 => "Qingdao\,\ Shandong",
  861330649 => "Binzhou\,\ Shandong",
  861330650 => "Hangzhou\,\ Zhejiang",
  861330651 => "Hangzhou\,\ Zhejiang",
  861330652 => "Hangzhou\,\ Zhejiang",
  861330653 => "Hangzhou\,\ Zhejiang",
  861330654 => "Taizhou\,\ Zhejiang",
  861330655 => "Taizhou\,\ Zhejiang",
  861330656 => "Taizhou\,\ Zhejiang",
  861330657 => "Taizhou\,\ Zhejiang",
  861330658 => "Taizhou\,\ Zhejiang",
  861330659 => "Taizhou\,\ Zhejiang",
  86133066 => "Ningbo\,\ Zhejiang",
  861330670 => "Quzhou\,\ Zhejiang",
  861330671 => "Hangzhou\,\ Zhejiang",
  861330672 => "Huzhou\,\ Zhejiang",
  861330673 => "Jiaxing\,\ Zhejiang",
  861330674 => "Ningbo\,\ Zhejiang",
  861330675 => "Shaoxing\,\ Zhejiang",
  861330676 => "Taizhou\,\ Zhejiang",
  861330677 => "Wenzhou\,\ Zhejiang",
  861330678 => "Lishui\,\ Zhejiang",
  861330679 => "Jinhua\,\ Zhejiang",
  861330680 => "Zhoushan\,\ Zhejiang",
  861330681 => "Hangzhou\,\ Zhejiang",
  861330682 => "Huzhou\,\ Zhejiang",
  861330683 => "Jiaxing\,\ Zhejiang",
  861330684 => "Ningbo\,\ Zhejiang",
  861330685 => "Shaoxing\,\ Zhejiang",
  861330686 => "Taizhou\,\ Zhejiang",
  861330687 => "Wenzhou\,\ Zhejiang",
  861330688 => "Lishui\,\ Zhejiang",
  861330689 => "Jinhua\,\ Zhejiang",
  861330690 => "Fuzhou\,\ Fujian",
  861330691 => "Fuzhou\,\ Fujian",
  861330692 => "Fuzhou\,\ Fujian",
  861330693 => "Fuzhou\,\ Fujian",
  861330694 => "Zhangzhou\,\ Fujian",
  861330695 => "Zhangzhou\,\ Fujian",
  861330696 => "Zhangzhou\,\ Fujian",
  861330697 => "Longyan\,\ Fujian",
  861330698 => "Sanming\,\ Fujian",
  861330699 => "Quanzhou\,\ Fujian",
  861330700 => "Nanchang\,\ Jiangxi",
  861330701 => "Yingtan\,\ Jiangxi",
  861330702 => "Jiujiang\,\ Jiangxi",
  861330703 => "Shangrao\,\ Jiangxi",
  861330704 => "Fuzhou\,\ Jiangxi",
  861330705 => "Yichun\,\ Jiangxi",
  861330706 => "JiAn\,\ Jiangxi",
  861330707 => "Ganzhou\,\ Jiangxi",
  861330708 => "Nanchang\,\ Jiangxi",
  861330709 => "Nanchang\,\ Jiangxi",
  86133071 => "Wuhan\,\ Hubei",
  861330720 => "Yichang\,\ Hubei",
  861330721 => "Jingzhou\,\ Hubei",
  861330722 => "Xiantao\,\ Hubei",
  861330723 => "Huangshi\,\ Hubei",
  861330724 => "Xianning\,\ Hubei",
  861330725 => "Huanggang\,\ Hubei",
  861330726 => "Enshi\,\ Hubei",
  861330727 => "Xiangfan\,\ Hubei",
  861330728 => "Shiyan\,\ Hubei",
  861330729 => "Xiaogan\,\ Hubei",
  861330730 => "Yueyang\,\ Hunan",
  861330731 => "Changsha\,\ Hunan",
  861330732 => "Xiangtan\,\ Hunan",
  861330733 => "Zhuzhou\,\ Hunan",
  861330734 => "Hengyang\,\ Hunan",
  861330735 => "Chenzhou\,\ Hunan",
  861330736 => "Changde\,\ Hunan",
  861330737 => "Yiyang\,\ Hunan",
  861330738 => "Loudi\,\ Hunan",
  861330739 => "Shaoyang\,\ Hunan",
  861330740 => "Yueyang\,\ Hunan",
  861330741 => "Zhuzhou\,\ Hunan",
  861330742 => "Changde\,\ Hunan",
  861330743 => "Xiangxi\,\ Hunan",
  861330744 => "Zhangjiajie\,\ Hunan",
  861330745 => "Huaihua\,\ Hunan",
  861330746 => "Yongzhou\,\ Hunan",
  861330747 => "Hengyang\,\ Hunan",
  861330748 => "Changsha\,\ Hunan",
  861330749 => "Changsha\,\ Hunan",
  86133075 => "Haikou\,\ Hainan",
  86133076 => "Haikou\,\ Hainan",
  861330770 => "Fangchenggang\,\ Guangxi",
  861330771 => "Nanning\,\ Guangxi",
  861330772 => "Liuzhou\,\ Guangxi",
  861330773 => "Guilin\,\ Guangxi",
  861330774 => "Wuzhou\,\ Guangxi",
  861330775 => "Yulin\,\ Guangxi",
  861330776 => "Baise\,\ Guangxi",
  861330777 => "Qinzhou\,\ Guangxi",
  861330778 => "Hechi\,\ Guangxi",
  861330779 => "Beihai\,\ Guangxi",
  861330780 => "Fangchenggang\,\ Guangxi",
  861330781 => "Nanning\,\ Guangxi",
  861330782 => "Liuzhou\,\ Guangxi",
  861330783 => "Guilin\,\ Guangxi",
  861330784 => "Wuzhou\,\ Guangxi",
  861330785 => "Yulin\,\ Guangxi",
  861330786 => "Nanning\,\ Guangxi",
  861330787 => "Qinzhou\,\ Guangxi",
  861330788 => "Hechi\,\ Guangxi",
  861330789 => "Beihai\,\ Guangxi",
  861330790 => "Xinyu\,\ Jiangxi",
  861330791 => "Nanchang\,\ Jiangxi",
  861330792 => "Jiujiang\,\ Jiangxi",
  861330793 => "Shangrao\,\ Jiangxi",
  861330794 => "Fuzhou\,\ Jiangxi",
  861330795 => "Yichun\,\ Jiangxi",
  861330796 => "JiAn\,\ Jiangxi",
  861330797 => "Ganzhou\,\ Jiangxi",
  861330798 => "Jingdezhen\,\ Jiangxi",
  861330799 => "Pingxiang\,\ Jiangxi",
  86133080 => "Chengdu\,\ Sichuan",
  861330810 => "Deyang\,\ Sichuan",
  861330811 => "Mianyang\,\ Sichuan",
  861330812 => "Guangyuan\,\ Sichuan",
  861330813 => "Leshan\,\ Sichuan",
  861330814 => "Panzhihua\,\ Sichuan",
  861330815 => "Liangshan\,\ Sichuan",
  861330816 => "YaAn\,\ Sichuan",
  861330817 => "Chengdu\,\ Sichuan",
  861330818 => "Chengdu\,\ Sichuan",
  861330819 => "Chengdu\,\ Sichuan",
  861330820 => "Chengdu\,\ Sichuan",
  861330821 => "Chengdu\,\ Sichuan",
  861330822 => "Chengdu\,\ Sichuan",
  861330823 => "Chengdu\,\ Sichuan",
  861330824 => "Dazhou\,\ Sichuan",
  861330825 => "Chongqing",
  861330826 => "Chongqing",
  861330827 => "Chongqing",
  861330828 => "GuangAn\,\ Sichuan",
  861330829 => "Bazhong\,\ Sichuan",
  86133083 => "Chongqing",
  86133084 => "Changsha\,\ Hunan",
  861330850 => "Guiyang\,\ Guizhou",
  861330851 => "Guiyang\,\ Guizhou",
  861330852 => "Zunyi\,\ Guizhou",
  861330853 => "Anshun\,\ Guizhou",
  861330854 => "Qiannan\,\ Guizhou",
  861330855 => "Qiandongnan\,\ Guizhou",
  861330856 => "Tongren\,\ Guizhou",
  861330857 => "Bijie\,\ Guizhou",
  861330858 => "Liupanshui\,\ Guizhou",
  861330859 => "Qianxinan\,\ Guizhou",
  861330860 => "Yichang\,\ Hubei",
  861330861 => "Jingzhou\,\ Hubei",
  861330862 => "Wuhan\,\ Hubei",
  861330863 => "Wuhan\,\ Hubei",
  861330864 => "Wuhan\,\ Hubei",
  861330865 => "Wuhan\,\ Hubei",
  861330866 => "Suizhou\,\ Hubei",
  861330867 => "Xiangfan\,\ Hubei",
  861330868 => "Ezhou\,\ Hubei",
  861330869 => "Jingmen\,\ Hubei",
  861330870 => "Zhaotong\,\ Yunnan",
  861330871 => "Kunming\,\ Yunnan",
  861330872 => "Dali\,\ Yunnan",
  861330873 => "Honghe\,\ Yunnan",
  861330874 => "Qujing\,\ Yunnan",
  861330875 => "Baoshan\,\ Yunnan",
  861330876 => "Wenshan\,\ Yunnan",
  861330877 => "Yuxi\,\ Yunnan",
  861330878 => "Chuxiong\,\ Yunnan",
  861330879 => "Puer\,\ Yunnan",
  861330880 => "Kunming\,\ Yunnan",
  861330881 => "Xishuangbanna\,\ Yunnan",
  861330882 => "Dehong\,\ Yunnan",
  861330883 => "Lincang\,\ Yunnan",
  861330884 => "Kunming\,\ Yunnan",
  861330885 => "Kunming\,\ Yunnan",
  861330886 => "Nujiang\,\ Yunnan",
  861330887 => "Deqen\,\ Yunnan",
  861330888 => "Lijiang\,\ Yunnan",
  861330889 => "Yuxi\,\ Yunnan",
  861330890 => "Lhasa\,\ Tibet",
  861330891 => "Lhasa\,\ Tibet",
  861330892 => "Xigaze\,\ Tibet",
  861330893 => "Shannan\,\ Tibet",
  861330894 => "Nyingchi\,\ Tibet",
  861330895 => "Qamdo\,\ Tibet",
  861330896 => "Nagqu\,\ Tibet",
  861330897 => "Ngari\,\ Tibet",
  861330898 => "Lhasa\,\ Tibet",
  861330899 => "Lhasa\,\ Tibet",
  861330900 => "Zigong\,\ Sichuan",
  861330901 => "Mianyang\,\ Sichuan",
  861330902 => "Deyang\,\ Sichuan",
  861330903 => "Leshan\,\ Sichuan",
  861330904 => "Aba\,\ Sichuan",
  861330905 => "Neijiang\,\ Sichuan",
  861330906 => "Suining\,\ Sichuan",
  861330907 => "Nanchong\,\ Sichuan",
  861330908 => "Luzhou\,\ Sichuan",
  861330909 => "Yibin\,\ Sichuan",
  861330910 => "Xianyang\,\ Shaanxi",
  861330911 => "YanAn\,\ Shaanxi",
  861330912 => "Yulin\,\ Shaanxi",
  861330913 => "Weinan\,\ Shaanxi",
  861330914 => "Shangluo\,\ Shaanxi",
  861330915 => "Ankang\,\ Shaanxi",
  861330916 => "Hanzhong\,\ Shaanxi",
  861330917 => "Baoji\,\ Shaanxi",
  861330918 => "XiAn\,\ Shaanxi",
  861330919 => "Tongchuan\,\ Shaanxi",
  86133092 => "XiAn\,\ Shaanxi",
  861330930 => "Linxia\,\ Gansu",
  861330931 => "Lanzhou\,\ Gansu",
  861330932 => "Dingxi\,\ Gansu",
  861330933 => "Pingliang\,\ Gansu",
  861330934 => "Qingyang\,\ Gansu",
  861330935 => "Wuwei\,\ Gansu",
  861330936 => "Zhangye\,\ Gansu",
  861330937 => "Jiuquan\,\ Gansu",
  861330938 => "Tianshui\,\ Gansu",
  861330939 => "Longnan\,\ Gansu",
  861330940 => "Lanzhou\,\ Gansu",
  861330941 => "Lanzhou\,\ Gansu",
  861330942 => "Lanzhou\,\ Gansu",
  861330943 => "Baiyin\,\ Gansu",
  861330944 => "Lanzhou\,\ Gansu",
  861330945 => "Jinchang\,\ Gansu",
  861330946 => "Lanzhou\,\ Gansu",
  861330947 => "Jiayuguan\,\ Gansu",
  861330948 => "Lanzhou\,\ Gansu",
  861330949 => "Lanzhou\,\ Gansu",
  861330950 => "Yinchuan\,\ Ningxia",
  861330951 => "Yinchuan\,\ Ningxia",
  861330952 => "Shizuishan\,\ Ningxia",
  861330953 => "Wuzhong\,\ Ningxia",
  861330954 => "Guyuan\,\ Ningxia",
  861330955 => "Wuzhong\,\ Ningxia",
  861330956 => "Shizuishan\,\ Ningxia",
  861330957 => "Yinchuan\,\ Ningxia",
  861330958 => "Yinchuan\,\ Ningxia",
  861330959 => "Yinchuan\,\ Ningxia",
  861330960 => "Chuzhou\,\ Anhui",
  861330961 => "Huaibei\,\ Anhui",
  861330962 => "Bengbu\,\ Anhui",
  861330963 => "Wuhu\,\ Anhui",
  861330964 => "Huainan\,\ Anhui",
  861330965 => "Bengbu\,\ Anhui",
  861330966 => "Anqing\,\ Anhui",
  861330967 => "Bozhou\,\ Anhui",
  861330968 => "Fuyang\,\ Anhui",
  861330969 => "Hefei\,\ Anhui",
  861330970 => "Haibei\,\ Qinghai",
  861330971 => "Xining\,\ Qinghai",
  861330972 => "Haidong\,\ Qinghai",
  861330973 => "Huangnan\,\ Qinghai",
  861330974 => "Hainan\,\ Qinghai",
  861330975 => "Golog\,\ Qinghai",
  861330976 => "Yushu\,\ Qinghai",
  861330977 => "Haixi\,\ Qinghai",
  861330978 => "Xining\,\ Qinghai",
  861330979 => "Haixi\,\ Qinghai",
  861330980 => "Anshan\,\ Liaoning",
  861330981 => "Shenyang\,\ Liaoning",
  861330982 => "Shenyang\,\ Liaoning",
  861330983 => "Shenyang\,\ Liaoning",
  861330984 => "Dalian\,\ Liaoning",
  861330985 => "Dalian\,\ Liaoning",
  861330986 => "Dalian\,\ Liaoning",
  861330987 => "Panjin\,\ Liaoning",
  861330988 => "Shenyang\,\ Liaoning",
  861330989 => "Huludao\,\ Liaoning",
  861330990 => "Karamay\,\ Xinjiang",
  861330991 => "Urumchi\,\ Xinjiang",
  861330992 => "Ili\,\ Xinjiang",
  861330993 => "Shihezi\,\ Xinjiang",
  861330994 => "Changji\,\ Xinjiang",
  861330995 => "Turpan\,\ Xinjiang",
  861330996 => "Bayingolin\,\ Xinjiang",
  861330997 => "Aksu\,\ Xinjiang",
  861330998 => "Kashi\,\ Xinjiang",
  861330999 => "Ili\,\ Xinjiang",
  86133100 => "Shanghai",
  86133101 => "Shanghai",
  86133102 => "Chongqing",
  861331030 => "Ordos\,\ Inner\ Mongolia",
  861331031 => "Ordos\,\ Inner\ Mongolia",
  861331032 => "Ordos\,\ Inner\ Mongolia",
  861331033 => "Ordos\,\ Inner\ Mongolia",
  861331034 => "Ordos\,\ Inner\ Mongolia",
  861331035 => "Tongliao\,\ Inner\ Mongolia",
  861331036 => "Tongliao\,\ Inner\ Mongolia",
  861331037 => "Tongliao\,\ Inner\ Mongolia",
  861331038 => "Chifeng\,\ Inner\ Mongolia",
  861331039 => "Chifeng\,\ Inner\ Mongolia",
  861331040 => "Guiyang\,\ Guizhou",
  861331041 => "Zunyi\,\ Guizhou",
  861331042 => "Zunyi\,\ Guizhou",
  861331043 => "Anshun\,\ Guizhou",
  861331044 => "Qiannan\,\ Guizhou",
  861331045 => "Qiandongnan\,\ Guizhou",
  861331046 => "Tongren\,\ Guizhou",
  861331047 => "Bijie\,\ Guizhou",
  861331048 => "Zunyi\,\ Guizhou",
  861331049 => "Zunyi\,\ Guizhou",
  861331050 => "Jingmen\,\ Hubei",
  861331051 => "Jingmen\,\ Hubei",
  861331052 => "Jingmen\,\ Hubei",
  861331053 => "Enshi\,\ Hubei",
  861331054 => "Enshi\,\ Hubei",
  861331055 => "Enshi\,\ Hubei",
  861331056 => "Yichang\,\ Hubei",
  861331057 => "Yichang\,\ Hubei",
  861331058 => "Jingzhou\,\ Hubei",
  861331059 => "Jingzhou\,\ Hubei",
  861331060 => "Dezhou\,\ Shandong",
  861331061 => "Jinan\,\ Shandong",
  861331062 => "Liaocheng\,\ Shandong",
  861331063 => "Rizhao\,\ Shandong",
  861331064 => "Rizhao\,\ Shandong",
  861331065 => "Liaocheng\,\ Shandong",
  861331066 => "Qingdao\,\ Shandong",
  861331067 => "Qingdao\,\ Shandong",
  861331068 => "Zaozhuang\,\ Shandong",
  861331069 => "Zaozhuang\,\ Shandong",
  861331070 => "Bijie\,\ Guizhou",
  861331071 => "Tongren\,\ Guizhou",
  861331072 => "Zunyi\,\ Guizhou",
  861331073 => "Anshun\,\ Guizhou",
  861331074 => "Qiannan\,\ Guizhou",
  861331075 => "Qiandongnan\,\ Guizhou",
  861331076 => "Tongren\,\ Guizhou",
  861331077 => "Bijie\,\ Guizhou",
  861331078 => "Liupanshui\,\ Guizhou",
  861331079 => "Qianxinan\,\ Guizhou",
  861331080 => "Dongguan\,\ Guangdong",
  861331081 => "Dongguan\,\ Guangdong",
  861331082 => "Dongguan\,\ Guangdong",
  861331083 => "Shenzhen\,\ Guangdong",
  861331084 => "Shenzhen\,\ Guangdong",
  861331085 => "Shenzhen\,\ Guangdong",
  861331086 => "Shenzhen\,\ Guangdong",
  861331087 => "Shenzhen\,\ Guangdong",
  861331088 => "Guangzhou\,\ Guangdong",
  861331089 => "Guangzhou\,\ Guangdong",
  861331090 => "Xianyang\,\ Shaanxi",
  861331091 => "YanAn\,\ Shaanxi",
  861331092 => "Yulin\,\ Shaanxi",
  861331093 => "Weinan\,\ Shaanxi",
  861331094 => "XiAn\,\ Shaanxi",
  861331095 => "Ankang\,\ Shaanxi",
  861331096 => "Hanzhong\,\ Shaanxi",
  861331097 => "XiAn\,\ Shaanxi",
  861331098 => "XiAn\,\ Shaanxi",
  861331099 => "Yulin\,\ Shaanxi",
  86133110 => "Beijing",
  86133111 => "Beijing",
  86133112 => "Beijing",
  86133113 => "Beijing",
  86133114 => "Beijing",
  86133115 => "Beijing",
  86133116 => "Shanghai",
  86133117 => "Shanghai",
  86133118 => "Shanghai",
  86133119 => "Shanghai",
  86133120 => "Tianjin",
  86133121 => "Tianjin",
  861331220 => "Guiyang\,\ Guizhou",
  861331221 => "Guiyang\,\ Guizhou",
  861331222 => "Guiyang\,\ Guizhou",
  861331223 => "Guiyang\,\ Guizhou",
  861331224 => "Guiyang\,\ Guizhou",
  861331225 => "Guiyang\,\ Guizhou",
  861331226 => "Guiyang\,\ Guizhou",
  861331227 => "Guiyang\,\ Guizhou",
  861331228 => "Guiyang\,\ Guizhou",
  861331229 => "Qianxinan\,\ Guizhou",
  861331230 => "Zunyi\,\ Guizhou",
  861331231 => "Zunyi\,\ Guizhou",
  861331232 => "Zunyi\,\ Guizhou",
  861331233 => "Zunyi\,\ Guizhou",
  861331234 => "Zunyi\,\ Guizhou",
  861331235 => "Zunyi\,\ Guizhou",
  861331236 => "Qiannan\,\ Guizhou",
  861331237 => "Qiannan\,\ Guizhou",
  861331238 => "Qiannan\,\ Guizhou",
  861331239 => "Liupanshui\,\ Guizhou",
  861331240 => "Anshun\,\ Guizhou",
  861331241 => "Anshun\,\ Guizhou",
  861331242 => "Qiandongnan\,\ Guizhou",
  861331243 => "Qiandongnan\,\ Guizhou",
  861331244 => "Qiandongnan\,\ Guizhou",
  861331245 => "Tongren\,\ Guizhou",
  861331246 => "Liupanshui\,\ Guizhou",
  861331247 => "Bijie\,\ Guizhou",
  861331248 => "Bijie\,\ Guizhou",
  861331249 => "Qianxinan\,\ Guizhou",
  86133125 => "Kunming\,\ Yunnan",
  861331260 => "Chuxiong\,\ Yunnan",
  861331261 => "Chuxiong\,\ Yunnan",
  861331262 => "Qujing\,\ Yunnan",
  861331263 => "Qujing\,\ Yunnan",
  861331264 => "Yuxi\,\ Yunnan",
  861331265 => "Yuxi\,\ Yunnan",
  861331266 => "Honghe\,\ Yunnan",
  861331267 => "Honghe\,\ Yunnan",
  861331268 => "Zhaotong\,\ Yunnan",
  861331269 => "Lijiang\,\ Yunnan",
  861331270 => "Xishuangbanna\,\ Yunnan",
  861331271 => "Lincang\,\ Yunnan",
  861331272 => "Dehong\,\ Yunnan",
  861331273 => "Deqen\,\ Yunnan",
  861331274 => "Dali\,\ Yunnan",
  861331275 => "Nujiang\,\ Yunnan",
  861331276 => "Wenshan\,\ Yunnan",
  861331277 => "Puer\,\ Yunnan",
  861331278 => "Dali\,\ Yunnan",
  861331279 => "Baoshan\,\ Yunnan",
  86133128 => "Guangzhou\,\ Guangdong",
  86133129 => "Shenzhen\,\ Guangdong",
  861331300 => "Handan\,\ Hebei",
  861331301 => "Shijiazhuang\,\ Hebei",
  861331302 => "Baoding\,\ Hebei",
  861331303 => "Shijiazhuang\,\ Hebei",
  861331304 => "Shijiazhuang\,\ Hebei",
  861331305 => "Tangshan\,\ Hebei",
  861331306 => "Langfang\,\ Hebei",
  861331307 => "Cangzhou\,\ Hebei",
  861331308 => "Hengshui\,\ Hebei",
  861331309 => "Xingtai\,\ Hebei",
  861331310 => "Handan\,\ Hebei",
  861331311 => "Shijiazhuang\,\ Hebei",
  861331312 => "Baoding\,\ Hebei",
  861331313 => "Zhangjiakou\,\ Hebei",
  861331314 => "Chengde\,\ Hebei",
  861331315 => "Tangshan\,\ Hebei",
  861331316 => "Langfang\,\ Hebei",
  861331317 => "Cangzhou\,\ Hebei",
  861331318 => "Hengshui\,\ Hebei",
  861331319 => "Xingtai\,\ Hebei",
  861331320 => "Handan\,\ Hebei",
  861331321 => "Shijiazhuang\,\ Hebei",
  861331322 => "Baoding\,\ Hebei",
  861331323 => "Baoding\,\ Hebei",
  861331324 => "Baoding\,\ Hebei",
  861331325 => "Tangshan\,\ Hebei",
  861331326 => "Langfang\,\ Hebei",
  861331327 => "Cangzhou\,\ Hebei",
  861331328 => "Chengde\,\ Hebei",
  861331329 => "Tangshan\,\ Hebei",
  861331330 => "Handan\,\ Hebei",
  861331331 => "Shijiazhuang\,\ Hebei",
  861331332 => "Baoding\,\ Hebei",
  861331333 => "Qinhuangdao\,\ Hebei",
  861331334 => "Qinhuangdao\,\ Hebei",
  861331335 => "Qinhuangdao\,\ Hebei",
  861331336 => "Langfang\,\ Hebei",
  861331337 => "Cangzhou\,\ Hebei",
  861331338 => "Chengde\,\ Hebei",
  861331339 => "Xingtai\,\ Hebei",
  861331340 => "Xinzhou\,\ Shanxi",
  861331341 => "Taiyuan\,\ Shanxi",
  861331342 => "Datong\,\ Shanxi",
  861331343 => "Taiyuan\,\ Shanxi",
  861331344 => "Jinzhong\,\ Shanxi",
  861331345 => "Changzhi\,\ Shanxi",
  861331346 => "Jincheng\,\ Shanxi",
  861331347 => "Linfen\,\ Shanxi",
  861331348 => "Yuncheng\,\ Shanxi",
  861331349 => "Shuozhou\,\ Shanxi",
  861331350 => "Xinzhou\,\ Shanxi",
  861331351 => "Taiyuan\,\ Shanxi",
  861331352 => "Datong\,\ Shanxi",
  861331353 => "Yangquan\,\ Shanxi",
  861331354 => "Jinzhong\,\ Shanxi",
  861331355 => "Changzhi\,\ Shanxi",
  861331356 => "Jincheng\,\ Shanxi",
  861331357 => "Linfen\,\ Shanxi",
  861331358 => "Lüliang\,\ Shanxi",
  861331359 => "Yuncheng\,\ Shanxi",
  86133136 => "Harbin\,\ Heilongjiang",
  861331370 => "Xiamen\,\ Fujian",
  861331371 => "Ningde\,\ Fujian",
  861331372 => "Ningde\,\ Fujian",
  861331373 => "Sanming\,\ Fujian",
  861331374 => "Quanzhou\,\ Fujian",
  861331375 => "Fuzhou\,\ Fujian",
  861331376 => "Fuzhou\,\ Fujian",
  861331377 => "Fuzhou\,\ Fujian",
  861331378 => "Fuzhou\,\ Fujian",
  861331379 => "Nanping\,\ Fujian",
  861331380 => "Sanming\,\ Fujian",
  861331381 => "Sanming\,\ Fujian",
  861331382 => "Quanzhou\,\ Fujian",
  861331383 => "Quanzhou\,\ Fujian",
  861331384 => "Xiamen\,\ Fujian",
  861331385 => "Xiamen\,\ Fujian",
  861331386 => "Xiamen\,\ Fujian",
  861331387 => "Quanzhou\,\ Fujian",
  861331388 => "Quanzhou\,\ Fujian",
  861331389 => "Quanzhou\,\ Fujian",
  861331390 => "Nanping\,\ Fujian",
  861331391 => "Nanping\,\ Fujian",
  861331392 => "Longyan\,\ Fujian",
  861331393 => "Longyan\,\ Fujian",
  861331394 => "Fuzhou\,\ Fujian",
  861331395 => "Putian\,\ Fujian",
  861331396 => "Putian\,\ Fujian",
  861331397 => "Fuzhou\,\ Fujian",
  861331398 => "Fuzhou\,\ Fujian",
  861331399 => "Longyan\,\ Fujian",
  861331400 => "Shenyang\,\ Liaoning",
  861331401 => "Shenyang\,\ Liaoning",
  861331402 => "Shenyang\,\ Liaoning",
  861331403 => "Anshan\,\ Liaoning",
  861331404 => "Anshan\,\ Liaoning",
  861331405 => "Liaoyang\,\ Liaoning",
  861331406 => "Yingkou\,\ Liaoning",
  861331407 => "Yingkou\,\ Liaoning",
  861331408 => "Dandong\,\ Liaoning",
  861331409 => "Huludao\,\ Liaoning",
  861331410 => "Tieling\,\ Liaoning",
  861331411 => "Dalian\,\ Liaoning",
  861331412 => "Anshan\,\ Liaoning",
  861331413 => "Fushun\,\ Liaoning",
  861331414 => "Benxi\,\ Liaoning",
  861331415 => "Dandong\,\ Liaoning",
  861331416 => "Jinzhou\,\ Liaoning",
  861331417 => "Yingkou\,\ Liaoning",
  861331418 => "Fuxin\,\ Liaoning",
  861331419 => "Liaoyang\,\ Liaoning",
  861331420 => "Shenyang\,\ Liaoning",
  861331421 => "Chaoyang\,\ Liaoning",
  861331422 => "Shenyang\,\ Liaoning",
  861331423 => "Shenyang\,\ Liaoning",
  861331424 => "Shenyang\,\ Liaoning",
  861331425 => "Anshan\,\ Liaoning",
  861331426 => "Dalian\,\ Liaoning",
  861331427 => "Panjin\,\ Liaoning",
  861331428 => "Dalian\,\ Liaoning",
  861331429 => "Huludao\,\ Liaoning",
  861331430 => "Changchun\,\ Jilin",
  861331431 => "Changchun\,\ Jilin",
  861331432 => "Jilin\,\ Jilin",
  861331433 => "Yanbian\,\ Jilin",
  861331434 => "Siping\,\ Jilin",
  861331435 => "Tonghua\,\ Jilin",
  861331436 => "Jilin\,\ Jilin",
  861331437 => "Jilin\,\ Jilin",
  861331438 => "Yanbian\,\ Jilin",
  861331439 => "Changchun\,\ Jilin",
  861331440 => "Zunyi\,\ Guizhou",
  861331441 => "Zunyi\,\ Guizhou",
  861331442 => "Zunyi\,\ Guizhou",
  861331443 => "Zunyi\,\ Guizhou",
  861331444 => "Qiannan\,\ Guizhou",
  861331445 => "Qiandongnan\,\ Guizhou",
  861331446 => "Tongren\,\ Guizhou",
  861331447 => "Bijie\,\ Guizhou",
  861331448 => "Qiannan\,\ Guizhou",
  861331449 => "Qianxinan\,\ Guizhou",
  861331450 => "Harbin\,\ Heilongjiang",
  861331451 => "Harbin\,\ Heilongjiang",
  861331452 => "Qiqihar\,\ Heilongjiang",
  861331453 => "Mudanjiang\,\ Heilongjiang",
  861331454 => "Jiamusi\,\ Heilongjiang",
  861331455 => "Suihua\,\ Heilongjiang",
  861331456 => "Heihe\,\ Heilongjiang",
  861331457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861331458 => "Yichun\,\ Heilongjiang",
  861331459 => "Daqing\,\ Heilongjiang",
  861331460 => "Harbin\,\ Heilongjiang",
  861331461 => "Harbin\,\ Heilongjiang",
  861331462 => "Qiqihar\,\ Heilongjiang",
  861331463 => "Mudanjiang\,\ Heilongjiang",
  861331464 => "Qitaihe\,\ Heilongjiang",
  861331465 => "Qiqihar\,\ Heilongjiang",
  861331466 => "Qiqihar\,\ Heilongjiang",
  861331467 => "Jixi\,\ Heilongjiang",
  861331468 => "Hegang\,\ Heilongjiang",
  861331469 => "Shuangyashan\,\ Heilongjiang",
  861331470 => "Hulun\,\ Inner\ Mongolia",
  861331471 => "Hohhot\,\ Inner\ Mongolia",
  861331472 => "Baotou\,\ Inner\ Mongolia",
  861331473 => "Wuhai\,\ Inner\ Mongolia",
  861331474 => "Hinggan\,\ Inner\ Mongolia",
  861331475 => "Tongliao\,\ Inner\ Mongolia",
  861331476 => "Chifeng\,\ Inner\ Mongolia",
  861331477 => "Ordos\,\ Inner\ Mongolia",
  861331478 => "Bayannur\,\ Inner\ Mongolia",
  861331479 => "Xilin\,\ Inner\ Mongolia",
  861331480 => "Hulun\,\ Inner\ Mongolia",
  861331481 => "Hulun\,\ Inner\ Mongolia",
  861331482 => "Hinggan\,\ Inner\ Mongolia",
  861331483 => "Hulun\,\ Inner\ Mongolia",
  861331484 => "Baotou\,\ Inner\ Mongolia",
  861331485 => "Baotou\,\ Inner\ Mongolia",
  861331486 => "Baotou\,\ Inner\ Mongolia",
  861331487 => "Hohhot\,\ Inner\ Mongolia",
  861331488 => "Hohhot\,\ Inner\ Mongolia",
  861331489 => "Hohhot\,\ Inner\ Mongolia",
  861331490 => "Fuzhou\,\ Fujian",
  861331491 => "Fuzhou\,\ Fujian",
  861331492 => "Fuzhou\,\ Fujian",
  861331493 => "Fuzhou\,\ Fujian",
  861331494 => "Fuzhou\,\ Fujian",
  861331495 => "Fuzhou\,\ Fujian",
  861331496 => "Quanzhou\,\ Fujian",
  861331497 => "Quanzhou\,\ Fujian",
  861331498 => "Quanzhou\,\ Fujian",
  861331499 => "Quanzhou\,\ Fujian",
  86133150 => "Handan\,\ Hebei",
  86133151 => "Shijiazhuang\,\ Hebei",
  86133152 => "Baoding\,\ Hebei",
  861331530 => "Zhangjiakou\,\ Hebei",
  861331531 => "Zhangjiakou\,\ Hebei",
  861331532 => "Zhangjiakou\,\ Hebei",
  861331533 => "Zhangjiakou\,\ Hebei",
  861331534 => "Zhangjiakou\,\ Hebei",
  861331535 => "Qinhuangdao\,\ Hebei",
  861331536 => "Qinhuangdao\,\ Hebei",
  861331537 => "Qinhuangdao\,\ Hebei",
  861331538 => "Qinhuangdao\,\ Hebei",
  861331539 => "Qinhuangdao\,\ Hebei",
  861331540 => "Baoding\,\ Hebei",
  861331541 => "Baoding\,\ Hebei",
  861331542 => "Baoding\,\ Hebei",
  861331543 => "Baoding\,\ Hebei",
  861331544 => "Baoding\,\ Hebei",
  861331545 => "Shijiazhuang\,\ Hebei",
  861331546 => "Shijiazhuang\,\ Hebei",
  861331547 => "Shijiazhuang\,\ Hebei",
  861331548 => "Shijiazhuang\,\ Hebei",
  861331549 => "Shijiazhuang\,\ Hebei",
  86133155 => "Tangshan\,\ Hebei",
  861331560 => "Langfang\,\ Hebei",
  861331561 => "Langfang\,\ Hebei",
  861331562 => "Langfang\,\ Hebei",
  861331563 => "Langfang\,\ Hebei",
  861331564 => "Langfang\,\ Hebei",
  861331565 => "Qinhuangdao\,\ Hebei",
  861331566 => "Qinhuangdao\,\ Hebei",
  861331567 => "Qinhuangdao\,\ Hebei",
  861331568 => "Qinhuangdao\,\ Hebei",
  861331569 => "Qinhuangdao\,\ Hebei",
  86133157 => "Cangzhou\,\ Hebei",
  861331580 => "Hengshui\,\ Hebei",
  861331581 => "Hengshui\,\ Hebei",
  861331582 => "Hengshui\,\ Hebei",
  861331583 => "Hengshui\,\ Hebei",
  861331584 => "Hengshui\,\ Hebei",
  861331585 => "Hengshui\,\ Hebei",
  861331586 => "Hengshui\,\ Hebei",
  861331587 => "Chengde\,\ Hebei",
  861331588 => "Chengde\,\ Hebei",
  861331589 => "Chengde\,\ Hebei",
  861331590 => "Xingtai\,\ Hebei",
  861331591 => "Xingtai\,\ Hebei",
  861331592 => "Xingtai\,\ Hebei",
  861331593 => "Xingtai\,\ Hebei",
  861331594 => "Xingtai\,\ Hebei",
  861331595 => "Shijiazhuang\,\ Hebei",
  861331596 => "Shijiazhuang\,\ Hebei",
  861331597 => "Shijiazhuang\,\ Hebei",
  861331598 => "Shijiazhuang\,\ Hebei",
  861331599 => "Shijiazhuang\,\ Hebei",
  86133160 => "Guangzhou\,\ Guangdong",
  86133161 => "Guangzhou\,\ Guangdong",
  86133162 => "Guangzhou\,\ Guangdong",
  861331630 => "Foshan\,\ Guangdong",
  861331631 => "Foshan\,\ Guangdong",
  861331632 => "Foshan\,\ Guangdong",
  861331633 => "Huizhou\,\ Guangdong",
  861331634 => "Huizhou\,\ Guangdong",
  861331635 => "Huizhou\,\ Guangdong",
  861331636 => "Huizhou\,\ Guangdong",
  861331637 => "Huizhou\,\ Guangdong",
  861331638 => "Huizhou\,\ Guangdong",
  861331639 => "Huizhou\,\ Guangdong",
  86133164 => "Shenzhen\,\ Guangdong",
  86133165 => "Shenzhen\,\ Guangdong",
  86133166 => "Dongguan\,\ Guangdong",
  861331670 => "Jiangmen\,\ Guangdong",
  861331671 => "Jiangmen\,\ Guangdong",
  861331672 => "Jiangmen\,\ Guangdong",
  861331673 => "Jiangmen\,\ Guangdong",
  861331674 => "Jiangmen\,\ Guangdong",
  861331675 => "Jiangmen\,\ Guangdong",
  861331676 => "Jiangmen\,\ Guangdong",
  861331677 => "Huizhou\,\ Guangdong",
  861331678 => "Huizhou\,\ Guangdong",
  861331679 => "Huizhou\,\ Guangdong",
  86133168 => "Shenzhen\,\ Guangdong",
  86133169 => "Shenzhen\,\ Guangdong",
  861331700 => "Nanchang\,\ Jiangxi",
  861331701 => "Yingtan\,\ Jiangxi",
  861331702 => "Jiujiang\,\ Jiangxi",
  861331703 => "Shangrao\,\ Jiangxi",
  861331704 => "JiAn\,\ Jiangxi",
  861331705 => "Nanchang\,\ Jiangxi",
  861331706 => "JiAn\,\ Jiangxi",
  861331707 => "Ganzhou\,\ Jiangxi",
  861331708 => "Ganzhou\,\ Jiangxi",
  861331709 => "Pingxiang\,\ Jiangxi",
  86133171 => "Wuhan\,\ Hubei",
  861331720 => "Yichang\,\ Hubei",
  861331721 => "Jingzhou\,\ Hubei",
  861331722 => "Jingzhou\,\ Hubei",
  861331723 => "Huangshi\,\ Hubei",
  861331724 => "Xianning\,\ Hubei",
  861331725 => "Huanggang\,\ Hubei",
  861331726 => "Enshi\,\ Hubei",
  861331727 => "Xiangfan\,\ Hubei",
  861331728 => "Shiyan\,\ Hubei",
  861331729 => "Shiyan\,\ Hubei",
  861331730 => "Yueyang\,\ Hunan",
  861331731 => "Changsha\,\ Hunan",
  861331732 => "Xiangtan\,\ Hunan",
  861331733 => "Zhuzhou\,\ Hunan",
  861331734 => "Hengyang\,\ Hunan",
  861331735 => "Chenzhou\,\ Hunan",
  861331736 => "Changde\,\ Hunan",
  861331737 => "Yiyang\,\ Hunan",
  861331738 => "Loudi\,\ Hunan",
  861331739 => "Shaoyang\,\ Hunan",
  861331740 => "Yueyang\,\ Hunan",
  861331741 => "Zhuzhou\,\ Hunan",
  861331742 => "Xiangtan\,\ Hunan",
  861331743 => "Xiangxi\,\ Hunan",
  861331744 => "Zhangjiajie\,\ Hunan",
  861331745 => "Huaihua\,\ Hunan",
  861331746 => "Yongzhou\,\ Hunan",
  861331747 => "Hengyang\,\ Hunan",
  861331748 => "Changsha\,\ Hunan",
  861331749 => "Changsha\,\ Hunan",
  861331750 => "Huanggang\,\ Hubei",
  861331751 => "Jingmen\,\ Hubei",
  861331752 => "Jingmen\,\ Hubei",
  861331753 => "Xiangfan\,\ Hubei",
  861331754 => "Xiangfan\,\ Hubei",
  861331755 => "Xiangfan\,\ Hubei",
  861331756 => "Yichang\,\ Hubei",
  861331757 => "Yichang\,\ Hubei",
  861331758 => "Jingzhou\,\ Hubei",
  861331759 => "Suizhou\,\ Hubei",
  861331760 => "Fangchenggang\,\ Guangxi",
  861331761 => "Nanning\,\ Guangxi",
  861331762 => "Liuzhou\,\ Guangxi",
  861331763 => "Guilin\,\ Guangxi",
  861331764 => "Wuzhou\,\ Guangxi",
  861331765 => "Yulin\,\ Guangxi",
  861331766 => "Baise\,\ Guangxi",
  861331767 => "Qinzhou\,\ Guangxi",
  861331768 => "Hechi\,\ Guangxi",
  861331769 => "Beihai\,\ Guangxi",
  861331770 => "Fangchenggang\,\ Guangxi",
  861331771 => "Nanning\,\ Guangxi",
  861331772 => "Liuzhou\,\ Guangxi",
  861331773 => "Guilin\,\ Guangxi",
  861331774 => "Wuzhou\,\ Guangxi",
  861331775 => "Yulin\,\ Guangxi",
  861331776 => "Baise\,\ Guangxi",
  861331777 => "Qinzhou\,\ Guangxi",
  861331778 => "Hechi\,\ Guangxi",
  861331779 => "Beihai\,\ Guangxi",
  861331780 => "Nanning\,\ Guangxi",
  861331781 => "Nanning\,\ Guangxi",
  861331782 => "Liuzhou\,\ Guangxi",
  861331783 => "Guilin\,\ Guangxi",
  861331784 => "Wuzhou\,\ Guangxi",
  861331785 => "Yulin\,\ Guangxi",
  861331786 => "Nanning\,\ Guangxi",
  861331787 => "Qinzhou\,\ Guangxi",
  861331788 => "Liuzhou\,\ Guangxi",
  861331789 => "Beihai\,\ Guangxi",
  861331790 => "Xinyu\,\ Jiangxi",
  861331791 => "Nanchang\,\ Jiangxi",
  861331792 => "Jiujiang\,\ Jiangxi",
  861331793 => "Shangrao\,\ Jiangxi",
  861331794 => "Fuzhou\,\ Jiangxi",
  861331795 => "Yichun\,\ Jiangxi",
  861331796 => "JiAn\,\ Jiangxi",
  861331797 => "Ganzhou\,\ Jiangxi",
  861331798 => "Jingdezhen\,\ Jiangxi",
  861331799 => "Pingxiang\,\ Jiangxi",
  861331800 => "Shantou\,\ Guangdong",
  861331801 => "Zhanjiang\,\ Guangdong",
  861331802 => "Zhanjiang\,\ Guangdong",
  861331803 => "Zhanjiang\,\ Guangdong",
  861331804 => "Zhanjiang\,\ Guangdong",
  861331805 => "Shantou\,\ Guangdong",
  861331806 => "Shantou\,\ Guangdong",
  861331807 => "Shantou\,\ Guangdong",
  861331808 => "Shantou\,\ Guangdong",
  861331809 => "Shantou\,\ Guangdong",
  861331810 => "Zhaoqing\,\ Guangdong",
  861331811 => "Zhaoqing\,\ Guangdong",
  861331812 => "Meizhou\,\ Guangdong",
  861331813 => "Meizhou\,\ Guangdong",
  861331814 => "Meizhou\,\ Guangdong",
  861331815 => "Meizhou\,\ Guangdong",
  861331816 => "Meizhou\,\ Guangdong",
  861331817 => "Jieyang\,\ Guangdong",
  861331818 => "Jieyang\,\ Guangdong",
  861331819 => "Jieyang\,\ Guangdong",
  861331820 => "Foshan\,\ Guangdong",
  861331821 => "Foshan\,\ Guangdong",
  861331822 => "Foshan\,\ Guangdong",
  861331823 => "Heyuan\,\ Guangdong",
  861331824 => "Heyuan\,\ Guangdong",
  861331825 => "Zhongshan\,\ Guangdong",
  861331826 => "Zhongshan\,\ Guangdong",
  861331827 => "Zhongshan\,\ Guangdong",
  861331828 => "Zhongshan\,\ Guangdong",
  861331829 => "Zhongshan\,\ Guangdong",
  86133183 => "Foshan\,\ Guangdong",
  861331840 => "Zhongshan\,\ Guangdong",
  861331841 => "Zhongshan\,\ Guangdong",
  861331842 => "Zhongshan\,\ Guangdong",
  861331843 => "Dongguan\,\ Guangdong",
  861331844 => "Dongguan\,\ Guangdong",
  861331845 => "Dongguan\,\ Guangdong",
  861331846 => "Dongguan\,\ Guangdong",
  861331847 => "Zhuhai\,\ Guangdong",
  861331848 => "Zhuhai\,\ Guangdong",
  861331849 => "Zhuhai\,\ Guangdong",
  861331850 => "Maoming\,\ Guangdong",
  861331851 => "Maoming\,\ Guangdong",
  861331852 => "Maoming\,\ Guangdong",
  861331853 => "Maoming\,\ Guangdong",
  861331854 => "Yangjiang\,\ Guangdong",
  861331855 => "Yangjiang\,\ Guangdong",
  861331856 => "Yangjiang\,\ Guangdong",
  861331857 => "Shaoguan\,\ Guangdong",
  861331858 => "Shaoguan\,\ Guangdong",
  861331859 => "Shaoguan\,\ Guangdong",
  861331860 => "Qingyuan\,\ Guangdong",
  861331861 => "Qingyuan\,\ Guangdong",
  861331862 => "Qingyuan\,\ Guangdong",
  861331863 => "Jiangmen\,\ Guangdong",
  861331864 => "Jiangmen\,\ Guangdong",
  861331865 => "Jiangmen\,\ Guangdong",
  861331866 => "Jiangmen\,\ Guangdong",
  861331867 => "Shanwei\,\ Guangdong",
  861331868 => "Shanwei\,\ Guangdong",
  861331869 => "Shanwei\,\ Guangdong",
  86133187 => "Guangzhou\,\ Guangdong",
  86133188 => "Guangzhou\,\ Guangdong",
  861331890 => "Yunfu\,\ Guangdong",
  861331891 => "Yunfu\,\ Guangdong",
  861331892 => "Chaozhou\,\ Guangdong",
  861331893 => "Chaozhou\,\ Guangdong",
  861331894 => "Zhuhai\,\ Guangdong",
  861331895 => "Zhuhai\,\ Guangdong",
  861331896 => "Zhuhai\,\ Guangdong",
  861331897 => "Zhuhai\,\ Guangdong",
  861331898 => "Zhuhai\,\ Guangdong",
  861331899 => "Heyuan\,\ Guangdong",
  861331900 => "Changji\,\ Xinjiang",
  861331901 => "Tacheng\,\ Xinjiang",
  861331902 => "Hami\,\ Xinjiang",
  861331903 => "Hotan\,\ Xinjiang",
  861331904 => "Urumchi\,\ Xinjiang",
  861331905 => "Changji\,\ Xinjiang",
  861331906 => "Altay\,\ Xinjiang",
  861331907 => "Bayingolin\,\ Xinjiang",
  861331908 => "Kizilsu\,\ Xinjiang",
  861331909 => "Bortala\,\ Xinjiang",
  861331910 => "Xianyang\,\ Shaanxi",
  861331911 => "YanAn\,\ Shaanxi",
  861331912 => "Yulin\,\ Shaanxi",
  861331913 => "Weinan\,\ Shaanxi",
  861331914 => "Shangluo\,\ Shaanxi",
  861331915 => "Ankang\,\ Shaanxi",
  861331916 => "Hanzhong\,\ Shaanxi",
  861331917 => "Baoji\,\ Shaanxi",
  861331918 => "XiAn\,\ Shaanxi",
  861331919 => "Tongchuan\,\ Shaanxi",
  86133192 => "XiAn\,\ Shaanxi",
  861331930 => "Shangrao\,\ Jiangxi",
  861331931 => "Shangrao\,\ Jiangxi",
  861331932 => "Shangrao\,\ Jiangxi",
  861331933 => "JiAn\,\ Jiangxi",
  861331934 => "Yichun\,\ Jiangxi",
  861331935 => "Yichun\,\ Jiangxi",
  861331936 => "Yichun\,\ Jiangxi",
  861331937 => "Jingdezhen\,\ Jiangxi",
  861331938 => "Jingdezhen\,\ Jiangxi",
  861331939 => "Pingxiang\,\ Jiangxi",
  861331940 => "Nanchang\,\ Jiangxi",
  861331941 => "Nanchang\,\ Jiangxi",
  861331942 => "Nanchang\,\ Jiangxi",
  861331943 => "Nanchang\,\ Jiangxi",
  861331944 => "Jiujiang\,\ Jiangxi",
  861331945 => "Jiujiang\,\ Jiangxi",
  861331946 => "Ganzhou\,\ Jiangxi",
  861331947 => "Ganzhou\,\ Jiangxi",
  861331948 => "Ganzhou\,\ Jiangxi",
  861331949 => "Ganzhou\,\ Jiangxi",
  86133195 => "Changsha\,\ Hunan",
  861331960 => "Changsha\,\ Hunan",
  861331961 => "Huaihua\,\ Hunan",
  861331962 => "Changde\,\ Hunan",
  861331963 => "Xiangxi\,\ Hunan",
  861331964 => "Zhangjiajie\,\ Hunan",
  861331965 => "Huaihua\,\ Hunan",
  861331966 => "Yongzhou\,\ Hunan",
  861331967 => "Chenzhou\,\ Hunan",
  861331968 => "Loudi\,\ Hunan",
  861331969 => "Shaoyang\,\ Hunan",
  861331970 => "Hami\,\ Xinjiang",
  861331971 => "Bortala\,\ Xinjiang",
  861331972 => "Ili\,\ Xinjiang",
  861331973 => "Ili\,\ Xinjiang",
  861331974 => "Ili\,\ Xinjiang",
  861331975 => "Tacheng\,\ Xinjiang",
  861331976 => "Altay\,\ Xinjiang",
  861331977 => "Bayingolin\,\ Xinjiang",
  861331978 => "Aksu\,\ Xinjiang",
  861331979 => "Hotan\,\ Xinjiang",
  86133198 => "Urumchi\,\ Xinjiang",
  861331990 => "Karamay\,\ Xinjiang",
  861331991 => "Urumchi\,\ Xinjiang",
  861331992 => "Ili\,\ Xinjiang",
  861331993 => "Shihezi\,\ Xinjiang",
  861331994 => "Changji\,\ Xinjiang",
  861331995 => "Turpan\,\ Xinjiang",
  861331996 => "Bayingolin\,\ Xinjiang",
  861331997 => "Aksu\,\ Xinjiang",
  861331998 => "Kashi\,\ Xinjiang",
  861331999 => "Ili\,\ Xinjiang",
  861332000 => "Xinyu\,\ Jiangxi",
  861332001 => "Nanchang\,\ Jiangxi",
  861332002 => "Jiujiang\,\ Jiangxi",
  861332003 => "Shangrao\,\ Jiangxi",
  861332004 => "Fuzhou\,\ Jiangxi",
  861332005 => "Yichun\,\ Jiangxi",
  861332006 => "JiAn\,\ Jiangxi",
  861332007 => "Ganzhou\,\ Jiangxi",
  861332008 => "Jingdezhen\,\ Jiangxi",
  861332009 => "Pingxiang\,\ Jiangxi",
  861332010 => "Yingtan\,\ Jiangxi",
  861332011 => "Nanchang\,\ Jiangxi",
  861332012 => "Jiujiang\,\ Jiangxi",
  861332013 => "Shangrao\,\ Jiangxi",
  861332014 => "Jingdezhen\,\ Jiangxi",
  861332015 => "Yichun\,\ Jiangxi",
  861332016 => "JiAn\,\ Jiangxi",
  861332017 => "Ganzhou\,\ Jiangxi",
  861332018 => "Fuzhou\,\ Jiangxi",
  861332019 => "Fuzhou\,\ Jiangxi",
  86133202 => "Chongqing",
  86133203 => "Chongqing",
  861332040 => "Honghe\,\ Yunnan",
  861332041 => "Lijiang\,\ Yunnan",
  861332042 => "Zhaotong\,\ Yunnan",
  861332043 => "Deqen\,\ Yunnan",
  861332044 => "Nujiang\,\ Yunnan",
  861332045 => "Dehong\,\ Yunnan",
  861332046 => "Wenshan\,\ Yunnan",
  861332047 => "Puer\,\ Yunnan",
  861332048 => "Xishuangbanna\,\ Yunnan",
  861332049 => "Lincang\,\ Yunnan",
  861332050 => "Kunming\,\ Yunnan",
  861332051 => "Kunming\,\ Yunnan",
  861332052 => "Kunming\,\ Yunnan",
  861332053 => "Kunming\,\ Yunnan",
  861332054 => "Kunming\,\ Yunnan",
  861332055 => "Dali\,\ Yunnan",
  861332056 => "Chuxiong\,\ Yunnan",
  861332057 => "Qujing\,\ Yunnan",
  861332058 => "Yuxi\,\ Yunnan",
  861332059 => "Baoshan\,\ Yunnan",
  861332060 => "YaAn\,\ Sichuan",
  861332061 => "Bazhong\,\ Sichuan",
  861332062 => "GuangAn\,\ Sichuan",
  861332063 => "Suining\,\ Sichuan",
  861332064 => "Suining\,\ Sichuan",
  861332065 => "Yibin\,\ Sichuan",
  861332066 => "Yibin\,\ Sichuan",
  861332067 => "Aba\,\ Sichuan",
  861332068 => "Ziyang\,\ Sichuan",
  861332069 => "Neijiang\,\ Sichuan",
  861332070 => "Neijiang\,\ Sichuan",
  861332071 => "Panzhihua\,\ Sichuan",
  861332072 => "Panzhihua\,\ Sichuan",
  861332073 => "Guangyuan\,\ Sichuan",
  861332074 => "Luzhou\,\ Sichuan",
  861332075 => "Guangyuan\,\ Sichuan",
  861332076 => "Nanchong\,\ Sichuan",
  861332077 => "Nanchong\,\ Sichuan",
  861332078 => "Luzhou\,\ Sichuan",
  861332079 => "Garze\,\ Sichuan",
  861332080 => "Zigong\,\ Sichuan",
  861332081 => "Zigong\,\ Sichuan",
  861332082 => "Dazhou\,\ Sichuan",
  861332083 => "Dazhou\,\ Sichuan",
  861332084 => "Ziyang\,\ Sichuan",
  861332085 => "Deyang\,\ Sichuan",
  861332086 => "Deyang\,\ Sichuan",
  861332087 => "Deyang\,\ Sichuan",
  861332088 => "Mianyang\,\ Sichuan",
  861332089 => "Mianyang\,\ Sichuan",
  861332090 => "Mianyang\,\ Sichuan",
  861332091 => "Leshan\,\ Sichuan",
  861332092 => "Leshan\,\ Sichuan",
  861332093 => "Meishan\,\ Sichuan",
  861332094 => "Chengdu\,\ Sichuan",
  861332095 => "Meishan\,\ Sichuan",
  861332096 => "Chengdu\,\ Sichuan",
  861332097 => "Liangshan\,\ Sichuan",
  861332098 => "Chengdu\,\ Sichuan",
  861332099 => "Chengdu\,\ Sichuan",
  86133210 => "Beijing",
  86133211 => "Beijing",
  861332120 => "Lanzhou\,\ Gansu",
  861332121 => "Lanzhou\,\ Gansu",
  861332122 => "Lanzhou\,\ Gansu",
  861332123 => "Qingyang\,\ Gansu",
  861332124 => "Gannan\,\ Gansu",
  861332125 => "Jinchang\,\ Gansu",
  861332126 => "Jiayuguan\,\ Gansu",
  861332127 => "Baiyin\,\ Gansu",
  861332128 => "Lanzhou\,\ Gansu",
  861332129 => "Jiuquan\,\ Gansu",
  861332130 => "Pingliang\,\ Gansu",
  861332131 => "Lanzhou\,\ Gansu",
  861332132 => "Dingxi\,\ Gansu",
  861332133 => "Lanzhou\,\ Gansu",
  861332134 => "Linxia\,\ Gansu",
  861332135 => "Wuwei\,\ Gansu",
  861332136 => "Zhangye\,\ Gansu",
  861332137 => "Jiuquan\,\ Gansu",
  861332138 => "Tianshui\,\ Gansu",
  861332139 => "Longnan\,\ Gansu",
  861332140 => "Changchun\,\ Jilin",
  861332141 => "Changchun\,\ Jilin",
  861332142 => "Jilin\,\ Jilin",
  861332143 => "Siping\,\ Jilin",
  861332144 => "Yanbian\,\ Jilin",
  861332145 => "Tonghua\,\ Jilin",
  861332146 => "Baicheng\,\ Jilin",
  861332147 => "Liaoyuan\,\ Jilin",
  861332148 => "Songyuan\,\ Jilin",
  861332149 => "Baishan\,\ Jilin",
  861332150 => "Jilin\,\ Jilin",
  861332151 => "Yanbian\,\ Jilin",
  861332152 => "Songyuan\,\ Jilin",
  861332153 => "Tonghua\,\ Jilin",
  861332154 => "Changchun\,\ Jilin",
  861332155 => "Siping\,\ Jilin",
  861332156 => "Liaoyuan\,\ Jilin",
  861332157 => "Baicheng\,\ Jilin",
  861332158 => "Changchun\,\ Jilin",
  861332159 => "Baishan\,\ Jilin",
  861332160 => "Nanning\,\ Guangxi",
  861332161 => "Nanning\,\ Guangxi",
  861332162 => "Liuzhou\,\ Guangxi",
  861332163 => "Guilin\,\ Guangxi",
  861332164 => "Hezhou\,\ Guangxi",
  861332165 => "Yulin\,\ Guangxi",
  861332166 => "Nanning\,\ Guangxi",
  861332167 => "Guigang\,\ Guangxi",
  861332168 => "Guigang\,\ Guangxi",
  861332169 => "Beihai\,\ Guangxi",
  861332170 => "Nanning\,\ Guangxi",
  861332171 => "Nanning\,\ Guangxi",
  861332172 => "Liuzhou\,\ Guangxi",
  861332173 => "Guilin\,\ Guangxi",
  861332174 => "Hezhou\,\ Guangxi",
  861332175 => "Yulin\,\ Guangxi",
  861332176 => "Baise\,\ Guangxi",
  861332177 => "Guigang\,\ Guangxi",
  861332178 => "Guigang\,\ Guangxi",
  861332179 => "Beihai\,\ Guangxi",
  86133218 => "Shanghai",
  86133219 => "Shanghai",
  86133220 => "Haikou\,\ Hainan",
  861332210 => "Anshan\,\ Liaoning",
  861332211 => "Anshan\,\ Liaoning",
  861332212 => "Fushun\,\ Liaoning",
  861332213 => "Fushun\,\ Liaoning",
  861332214 => "Benxi\,\ Liaoning",
  861332215 => "Benxi\,\ Liaoning",
  861332216 => "Dandong\,\ Liaoning",
  861332217 => "Dandong\,\ Liaoning",
  861332218 => "Jinzhou\,\ Liaoning",
  861332219 => "Jinzhou\,\ Liaoning",
  86133222 => "Dalian\,\ Liaoning",
  861332230 => "Yingkou\,\ Liaoning",
  861332231 => "Yingkou\,\ Liaoning",
  861332232 => "Fuxin\,\ Liaoning",
  861332233 => "Liaoyang\,\ Liaoning",
  861332234 => "Liaoyang\,\ Liaoning",
  861332235 => "Tieling\,\ Liaoning",
  861332236 => "Chaoyang\,\ Liaoning",
  861332237 => "Panjin\,\ Liaoning",
  861332238 => "Panjin\,\ Liaoning",
  861332239 => "Huludao\,\ Liaoning",
  86133224 => "Shenyang\,\ Liaoning",
  861332250 => "Lhasa\,\ Tibet",
  861332251 => "Lhasa\,\ Tibet",
  861332252 => "Xigaze\,\ Tibet",
  861332253 => "Shannan\,\ Tibet",
  861332254 => "Nyingchi\,\ Tibet",
  861332255 => "Qamdo\,\ Tibet",
  861332256 => "Nagqu\,\ Tibet",
  861332257 => "Ngari\,\ Tibet",
  861332258 => "Lhasa\,\ Tibet",
  861332259 => "Lhasa\,\ Tibet",
  861332260 => "Dongguan\,\ Guangdong",
  861332261 => "Dongguan\,\ Guangdong",
  861332262 => "Huizhou\,\ Guangdong",
  861332263 => "Heyuan\,\ Guangdong",
  861332264 => "Huizhou\,\ Guangdong",
  861332265 => "Meizhou\,\ Guangdong",
  861332266 => "Meizhou\,\ Guangdong",
  861332267 => "Shanwei\,\ Guangdong",
  861332268 => "Shanwei\,\ Guangdong",
  861332269 => "Heyuan\,\ Guangdong",
  861332270 => "Shantou\,\ Guangdong",
  861332271 => "Shantou\,\ Guangdong",
  861332272 => "Shantou\,\ Guangdong",
  861332273 => "Shantou\,\ Guangdong",
  861332274 => "Shantou\,\ Guangdong",
  861332275 => "Jieyang\,\ Guangdong",
  861332276 => "Jieyang\,\ Guangdong",
  861332277 => "Shantou\,\ Guangdong",
  861332278 => "Chaozhou\,\ Guangdong",
  861332279 => "Chaozhou\,\ Guangdong",
  861332280 => "Guangzhou\,\ Guangdong",
  861332281 => "Guangzhou\,\ Guangdong",
  861332282 => "Foshan\,\ Guangdong",
  861332283 => "Foshan\,\ Guangdong",
  861332284 => "Foshan\,\ Guangdong",
  861332285 => "Foshan\,\ Guangdong",
  861332286 => "Zhuhai\,\ Guangdong",
  861332287 => "Zhuhai\,\ Guangdong",
  861332288 => "Jiangmen\,\ Guangdong",
  861332289 => "Jiangmen\,\ Guangdong",
  861332290 => "Zhongshan\,\ Guangdong",
  861332291 => "Zhongshan\,\ Guangdong",
  861332292 => "Shenzhen\,\ Guangdong",
  861332293 => "Shenzhen\,\ Guangdong",
  861332294 => "Yunfu\,\ Guangdong",
  861332295 => "Yunfu\,\ Guangdong",
  861332296 => "Zhaoqing\,\ Guangdong",
  861332297 => "Zhaoqing\,\ Guangdong",
  861332298 => "Shenzhen\,\ Guangdong",
  861332299 => "Shenzhen\,\ Guangdong",
  861332300 => "Handan\,\ Hebei",
  861332301 => "Shijiazhuang\,\ Hebei",
  861332302 => "Baoding\,\ Hebei",
  861332303 => "Zhangjiakou\,\ Hebei",
  861332304 => "Shijiazhuang\,\ Hebei",
  861332305 => "Tangshan\,\ Hebei",
  861332306 => "Langfang\,\ Hebei",
  861332307 => "Cangzhou\,\ Hebei",
  861332308 => "Hengshui\,\ Hebei",
  861332309 => "Xingtai\,\ Hebei",
  861332310 => "Handan\,\ Hebei",
  861332311 => "Shijiazhuang\,\ Hebei",
  861332312 => "Baoding\,\ Hebei",
  861332313 => "Zhangjiakou\,\ Hebei",
  861332314 => "Chengde\,\ Hebei",
  861332315 => "Tangshan\,\ Hebei",
  861332316 => "Langfang\,\ Hebei",
  861332317 => "Cangzhou\,\ Hebei",
  861332318 => "Hengshui\,\ Hebei",
  861332319 => "Xingtai\,\ Hebei",
  861332320 => "Handan\,\ Hebei",
  861332321 => "Shijiazhuang\,\ Hebei",
  861332322 => "Baoding\,\ Hebei",
  861332323 => "Zhangjiakou\,\ Hebei",
  861332324 => "Baoding\,\ Hebei",
  861332325 => "Tangshan\,\ Hebei",
  861332326 => "Langfang\,\ Hebei",
  861332327 => "Cangzhou\,\ Hebei",
  861332328 => "Qinhuangdao\,\ Hebei",
  861332329 => "Tangshan\,\ Hebei",
  86133233 => "Tianjin",
  86133234 => "Tianjin",
  861332350 => "Yinchuan\,\ Ningxia",
  861332351 => "Yinchuan\,\ Ningxia",
  861332352 => "Shizuishan\,\ Ningxia",
  861332353 => "Wuzhong\,\ Ningxia",
  861332354 => "Guyuan\,\ Ningxia",
  861332355 => "Wuzhong\,\ Ningxia",
  861332356 => "Shizuishan\,\ Ningxia",
  861332357 => "Yinchuan\,\ Ningxia",
  861332358 => "Yinchuan\,\ Ningxia",
  861332359 => "Yinchuan\,\ Ningxia",
  861332360 => "Shangqiu\,\ Henan",
  861332361 => "Hebi\,\ Henan",
  861332362 => "Anyang\,\ Henan",
  861332363 => "Puyang\,\ Henan",
  861332364 => "Zhumadian\,\ Henan",
  861332365 => "Kaifeng\,\ Henan",
  861332366 => "Sanmenxia\,\ Henan",
  861332367 => "Luohe\,\ Henan",
  861332368 => "Nanyang\,\ Henan",
  861332369 => "Nanyang\,\ Henan",
  861332370 => "Shangqiu\,\ Henan",
  861332371 => "Zhengzhou\,\ Henan",
  861332372 => "Anyang\,\ Henan",
  861332373 => "Xinxiang\,\ Henan",
  861332374 => "Xuchang\,\ Henan",
  861332375 => "Pingdingshan\,\ Henan",
  861332376 => "Xinyang\,\ Henan",
  861332377 => "Nanyang\,\ Henan",
  861332378 => "Kaifeng\,\ Henan",
  861332379 => "Luoyang\,\ Henan",
  861332380 => "Xinxiang\,\ Henan",
  861332381 => "Zhengzhou\,\ Henan",
  861332382 => "Zhengzhou\,\ Henan",
  861332383 => "Zhengzhou\,\ Henan",
  861332384 => "Zhengzhou\,\ Henan",
  861332385 => "Zhengzhou\,\ Henan",
  861332386 => "Zhengzhou\,\ Henan",
  861332387 => "Zhoukou\,\ Henan",
  861332388 => "Luoyang\,\ Henan",
  861332389 => "Jiaozuo\,\ Henan",
  861332390 => "Pingdingshan\,\ Henan",
  861332391 => "Jiaozuo\,\ Henan",
  861332392 => "Hebi\,\ Henan",
  861332393 => "Puyang\,\ Henan",
  861332394 => "Zhoukou\,\ Henan",
  861332395 => "Luohe\,\ Henan",
  861332396 => "Zhumadian\,\ Henan",
  861332397 => "Xinyang\,\ Henan",
  861332398 => "Sanmenxia\,\ Henan",
  861332399 => "Xuchang\,\ Henan",
  86133240 => "Shenyang\,\ Liaoning",
  861332410 => "Tieling\,\ Liaoning",
  861332411 => "Dalian\,\ Liaoning",
  861332412 => "Anshan\,\ Liaoning",
  861332413 => "Fushun\,\ Liaoning",
  861332414 => "Benxi\,\ Liaoning",
  861332415 => "Dandong\,\ Liaoning",
  861332416 => "Jinzhou\,\ Liaoning",
  861332417 => "Yingkou\,\ Liaoning",
  861332418 => "Fuxin\,\ Liaoning",
  861332419 => "Liaoyang\,\ Liaoning",
  861332420 => "Dalian\,\ Liaoning",
  861332421 => "Chaoyang\,\ Liaoning",
  861332422 => "Anshan\,\ Liaoning",
  861332423 => "Fushun\,\ Liaoning",
  861332424 => "Benxi\,\ Liaoning",
  861332425 => "Panjin\,\ Liaoning",
  861332426 => "Jinzhou\,\ Liaoning",
  861332427 => "Panjin\,\ Liaoning",
  861332428 => "Dandong\,\ Liaoning",
  861332429 => "Huludao\,\ Liaoning",
  861332430 => "Changchun\,\ Jilin",
  861332431 => "Changchun\,\ Jilin",
  861332432 => "Jilin\,\ Jilin",
  861332433 => "Yanbian\,\ Jilin",
  861332434 => "Siping\,\ Jilin",
  861332435 => "Tonghua\,\ Jilin",
  861332436 => "Baicheng\,\ Jilin",
  861332437 => "Liaoyuan\,\ Jilin",
  861332438 => "Songyuan\,\ Jilin",
  861332439 => "Baishan\,\ Jilin",
  861332440 => "Jilin\,\ Jilin",
  861332441 => "Jilin\,\ Jilin",
  861332442 => "Jilin\,\ Jilin",
  861332443 => "Yanbian\,\ Jilin",
  861332444 => "Jilin\,\ Jilin",
  861332445 => "Tonghua\,\ Jilin",
  861332446 => "Changchun\,\ Jilin",
  861332447 => "Changchun\,\ Jilin",
  861332448 => "Yanbian\,\ Jilin",
  861332449 => "Baishan\,\ Jilin",
  86133245 => "XiAn\,\ Shaanxi",
  861332460 => "Yulin\,\ Shaanxi",
  861332461 => "Yulin\,\ Shaanxi",
  861332462 => "Yulin\,\ Shaanxi",
  861332463 => "Ankang\,\ Shaanxi",
  861332464 => "Ankang\,\ Shaanxi",
  861332465 => "Ankang\,\ Shaanxi",
  861332466 => "Shangluo\,\ Shaanxi",
  861332467 => "Shangluo\,\ Shaanxi",
  861332468 => "Tongchuan\,\ Shaanxi",
  861332469 => "Tongchuan\,\ Shaanxi",
  861332470 => "Fangchenggang\,\ Guangxi",
  861332471 => "Nanning\,\ Guangxi",
  861332472 => "Liuzhou\,\ Guangxi",
  861332473 => "Guilin\,\ Guangxi",
  861332474 => "Hezhou\,\ Guangxi",
  861332475 => "Guigang\,\ Guangxi",
  861332476 => "Baise\,\ Guangxi",
  861332477 => "Qinzhou\,\ Guangxi",
  861332478 => "Hechi\,\ Guangxi",
  861332479 => "Beihai\,\ Guangxi",
  861332480 => "Hezhou\,\ Guangxi",
  861332481 => "Nanning\,\ Guangxi",
  861332482 => "Liuzhou\,\ Guangxi",
  861332483 => "Guilin\,\ Guangxi",
  861332484 => "Wuzhou\,\ Guangxi",
  861332485 => "Yulin\,\ Guangxi",
  861332486 => "Guigang\,\ Guangxi",
  861332487 => "Qinzhou\,\ Guangxi",
  861332488 => "Wuzhou\,\ Guangxi",
  861332489 => "Beihai\,\ Guangxi",
  861332490 => "Qujing\,\ Yunnan",
  861332491 => "Qujing\,\ Yunnan",
  861332492 => "Honghe\,\ Yunnan",
  861332493 => "Honghe\,\ Yunnan",
  861332494 => "Dali\,\ Yunnan",
  861332495 => "Dali\,\ Yunnan",
  861332496 => "Zhaotong\,\ Yunnan",
  861332497 => "Dehong\,\ Yunnan",
  861332498 => "Xishuangbanna\,\ Yunnan",
  861332499 => "Puer\,\ Yunnan",
  861332500 => "Qingdao\,\ Shandong",
  861332501 => "Qingdao\,\ Shandong",
  861332502 => "Qingdao\,\ Shandong",
  861332503 => "Dongying\,\ Shandong",
  861332504 => "Dongying\,\ Shandong",
  861332505 => "Dongying\,\ Shandong",
  861332506 => "Dongying\,\ Shandong",
  861332507 => "Linyi\,\ Shandong",
  861332508 => "Linyi\,\ Shandong",
  861332509 => "Linyi\,\ Shandong",
  861332510 => "Jinan\,\ Shandong",
  861332511 => "Jinan\,\ Shandong",
  861332512 => "Jinan\,\ Shandong",
  861332513 => "Jinan\,\ Shandong",
  861332514 => "Yantai\,\ Shandong",
  861332515 => "Yantai\,\ Shandong",
  861332516 => "Yantai\,\ Shandong",
  861332517 => "Jining\,\ Shandong",
  861332518 => "Jining\,\ Shandong",
  861332519 => "Jining\,\ Shandong",
  861332520 => "Zibo\,\ Shandong",
  861332521 => "Zibo\,\ Shandong",
  861332522 => "Zibo\,\ Shandong",
  861332523 => "Zibo\,\ Shandong",
  861332524 => "Weifang\,\ Shandong",
  861332525 => "Weifang\,\ Shandong",
  861332526 => "Weifang\,\ Shandong",
  861332527 => "TaiAn\,\ Shandong",
  861332528 => "TaiAn\,\ Shandong",
  861332529 => "TaiAn\,\ Shandong",
  861332530 => "Xianyang\,\ Shaanxi",
  861332531 => "YanAn\,\ Shaanxi",
  861332532 => "Yulin\,\ Shaanxi",
  861332533 => "Weinan\,\ Shaanxi",
  861332534 => "Shangluo\,\ Shaanxi",
  861332535 => "Ankang\,\ Shaanxi",
  861332536 => "Hanzhong\,\ Shaanxi",
  861332537 => "Baoji\,\ Shaanxi",
  861332538 => "XiAn\,\ Shaanxi",
  861332539 => "Tongchuan\,\ Shaanxi",
  861332540 => "Yulin\,\ Shaanxi",
  861332541 => "Yulin\,\ Shaanxi",
  861332542 => "Yulin\,\ Shaanxi",
  861332543 => "Weinan\,\ Shaanxi",
  861332544 => "Weinan\,\ Shaanxi",
  861332545 => "XiAn\,\ Shaanxi",
  861332546 => "XiAn\,\ Shaanxi",
  861332547 => "XiAn\,\ Shaanxi",
  861332548 => "XiAn\,\ Shaanxi",
  861332549 => "XiAn\,\ Shaanxi",
  861332550 => "Bayingolin\,\ Xinjiang",
  861332551 => "Aksu\,\ Xinjiang",
  861332552 => "Kashi\,\ Xinjiang",
  861332553 => "Urumchi\,\ Xinjiang",
  861332554 => "Urumchi\,\ Xinjiang",
  861332555 => "Urumchi\,\ Xinjiang",
  861332556 => "Urumchi\,\ Xinjiang",
  861332557 => "Urumchi\,\ Xinjiang",
  861332558 => "Urumchi\,\ Xinjiang",
  861332559 => "Urumchi\,\ Xinjiang",
  861332560 => "Urumchi\,\ Xinjiang",
  861332561 => "Urumchi\,\ Xinjiang",
  861332562 => "Urumchi\,\ Xinjiang",
  861332563 => "Urumchi\,\ Xinjiang",
  861332564 => "Urumchi\,\ Xinjiang",
  861332565 => "Ili\,\ Xinjiang",
  861332566 => "Shihezi\,\ Xinjiang",
  861332567 => "Karamay\,\ Xinjiang",
  861332568 => "Karamay\,\ Xinjiang",
  861332569 => "Ili\,\ Xinjiang",
  861332570 => "Quzhou\,\ Zhejiang",
  861332571 => "Hangzhou\,\ Zhejiang",
  861332572 => "Huzhou\,\ Zhejiang",
  861332573 => "Jiaxing\,\ Zhejiang",
  861332574 => "Ningbo\,\ Zhejiang",
  861332575 => "Shaoxing\,\ Zhejiang",
  861332576 => "Taizhou\,\ Zhejiang",
  861332577 => "Wenzhou\,\ Zhejiang",
  861332578 => "Lishui\,\ Zhejiang",
  861332579 => "Jinhua\,\ Zhejiang",
  861332580 => "Zhoushan\,\ Zhejiang",
  861332581 => "Hangzhou\,\ Zhejiang",
  861332582 => "Huzhou\,\ Zhejiang",
  861332583 => "Jiaxing\,\ Zhejiang",
  861332584 => "Ningbo\,\ Zhejiang",
  861332585 => "Shaoxing\,\ Zhejiang",
  861332586 => "Taizhou\,\ Zhejiang",
  861332587 => "Wenzhou\,\ Zhejiang",
  861332588 => "Ningbo\,\ Zhejiang",
  861332589 => "Jinhua\,\ Zhejiang",
  861332590 => "Zhoushan\,\ Zhejiang",
  861332591 => "Hangzhou\,\ Zhejiang",
  861332592 => "Huzhou\,\ Zhejiang",
  861332593 => "Jiaxing\,\ Zhejiang",
  861332594 => "Ningbo\,\ Zhejiang",
  861332595 => "Shaoxing\,\ Zhejiang",
  861332596 => "Taizhou\,\ Zhejiang",
  861332597 => "Wenzhou\,\ Zhejiang",
  861332598 => "Wenzhou\,\ Zhejiang",
  861332599 => "Jinhua\,\ Zhejiang",
  86133260 => "Taizhou\,\ Zhejiang",
  861332610 => "Quzhou\,\ Zhejiang",
  861332611 => "Lishui\,\ Zhejiang",
  861332612 => "Ningbo\,\ Zhejiang",
  861332613 => "Hangzhou\,\ Zhejiang",
  861332614 => "Hangzhou\,\ Zhejiang",
  861332615 => "Huzhou\,\ Zhejiang",
  861332616 => "Huzhou\,\ Zhejiang",
  861332617 => "Huzhou\,\ Zhejiang",
  861332618 => "Huzhou\,\ Zhejiang",
  861332619 => "Wenzhou\,\ Zhejiang",
  861332620 => "Heze\,\ Shandong",
  861332621 => "Heze\,\ Shandong",
  861332622 => "Laiwu\,\ Shandong",
  861332623 => "Rizhao\,\ Shandong",
  861332624 => "Weihai\,\ Shandong",
  861332625 => "Liaocheng\,\ Shandong",
  861332626 => "Dezhou\,\ Shandong",
  861332627 => "Dezhou\,\ Shandong",
  861332628 => "Binzhou\,\ Shandong",
  861332629 => "Binzhou\,\ Shandong",
  861332630 => "Weihai\,\ Shandong",
  861332631 => "Weihai\,\ Shandong",
  861332632 => "Zaozhuang\,\ Shandong",
  861332633 => "Rizhao\,\ Shandong",
  861332634 => "Laiwu\,\ Shandong",
  861332635 => "Liaocheng\,\ Shandong",
  861332636 => "Weifang\,\ Shandong",
  861332637 => "Zaozhuang\,\ Shandong",
  861332638 => "Yantai\,\ Shandong",
  861332639 => "Qingdao\,\ Shandong",
  86133264 => "Guangzhou\,\ Guangdong",
  861332650 => "Zhanjiang\,\ Guangdong",
  861332651 => "Zhanjiang\,\ Guangdong",
  861332652 => "Shaoguan\,\ Guangdong",
  861332653 => "Shaoguan\,\ Guangdong",
  861332654 => "Qingyuan\,\ Guangdong",
  861332655 => "Qingyuan\,\ Guangdong",
  861332656 => "Maoming\,\ Guangdong",
  861332657 => "Maoming\,\ Guangdong",
  861332658 => "Yangjiang\,\ Guangdong",
  861332659 => "Yangjiang\,\ Guangdong",
  86133266 => "Zhuhai\,\ Guangdong",
  86133267 => "Foshan\,\ Guangdong",
  861332680 => "Jiangmen\,\ Guangdong",
  861332681 => "Jiangmen\,\ Guangdong",
  861332682 => "Jiangmen\,\ Guangdong",
  861332683 => "Jiangmen\,\ Guangdong",
  861332684 => "Jiangmen\,\ Guangdong",
  861332685 => "Dongguan\,\ Guangdong",
  861332686 => "Dongguan\,\ Guangdong",
  861332687 => "Dongguan\,\ Guangdong",
  861332688 => "Dongguan\,\ Guangdong",
  861332689 => "Dongguan\,\ Guangdong",
  86133269 => "Zhongshan\,\ Guangdong",
  861332700 => "Hulun\,\ Inner\ Mongolia",
  861332701 => "Hulun\,\ Inner\ Mongolia",
  861332702 => "Hinggan\,\ Inner\ Mongolia",
  861332703 => "Wuhai\,\ Inner\ Mongolia",
  861332704 => "Tongliao\,\ Inner\ Mongolia",
  861332705 => "Tongliao\,\ Inner\ Mongolia",
  861332706 => "Ordos\,\ Inner\ Mongolia",
  861332707 => "Ordos\,\ Inner\ Mongolia",
  861332708 => "Bayannur\,\ Inner\ Mongolia",
  861332709 => "Xilin\,\ Inner\ Mongolia",
  861332710 => "Hohhot\,\ Inner\ Mongolia",
  861332711 => "Hohhot\,\ Inner\ Mongolia",
  861332712 => "Hohhot\,\ Inner\ Mongolia",
  861332713 => "Alxa\,\ Inner\ Mongolia",
  861332714 => "Hinggan\,\ Inner\ Mongolia",
  861332715 => "Chifeng\,\ Inner\ Mongolia",
  861332716 => "Chifeng\,\ Inner\ Mongolia",
  861332717 => "Baotou\,\ Inner\ Mongolia",
  861332718 => "Baotou\,\ Inner\ Mongolia",
  861332719 => "Baotou\,\ Inner\ Mongolia",
  861332720 => "Yueyang\,\ Hunan",
  861332721 => "Changsha\,\ Hunan",
  861332722 => "Xiangtan\,\ Hunan",
  861332723 => "Xiangxi\,\ Hunan",
  861332724 => "Zhangjiajie\,\ Hunan",
  861332725 => "Huaihua\,\ Hunan",
  861332726 => "Yongzhou\,\ Hunan",
  861332727 => "Yiyang\,\ Hunan",
  861332728 => "Loudi\,\ Hunan",
  861332729 => "Shaoyang\,\ Hunan",
  861332730 => "Yueyang\,\ Hunan",
  861332731 => "Changsha\,\ Hunan",
  861332732 => "Xiangtan\,\ Hunan",
  861332733 => "Zhuzhou\,\ Hunan",
  861332734 => "Hengyang\,\ Hunan",
  861332735 => "Chenzhou\,\ Hunan",
  861332736 => "Changde\,\ Hunan",
  861332737 => "Yiyang\,\ Hunan",
  861332738 => "Loudi\,\ Hunan",
  861332739 => "Shaoyang\,\ Hunan",
  861332740 => "Taiyuan\,\ Shanxi",
  861332741 => "Taiyuan\,\ Shanxi",
  861332742 => "Datong\,\ Shanxi",
  861332743 => "Taiyuan\,\ Shanxi",
  861332744 => "Jinzhong\,\ Shanxi",
  861332745 => "Changzhi\,\ Shanxi",
  861332746 => "Taiyuan\,\ Shanxi",
  861332747 => "Linfen\,\ Shanxi",
  861332748 => "Yuncheng\,\ Shanxi",
  861332749 => "Shuozhou\,\ Shanxi",
  861332750 => "Xinzhou\,\ Shanxi",
  861332751 => "Taiyuan\,\ Shanxi",
  861332752 => "Datong\,\ Shanxi",
  861332753 => "Yangquan\,\ Shanxi",
  861332754 => "Jinzhong\,\ Shanxi",
  861332755 => "Changzhi\,\ Shanxi",
  861332756 => "Jincheng\,\ Shanxi",
  861332757 => "Linfen\,\ Shanxi",
  861332758 => "Lüliang\,\ Shanxi",
  861332759 => "Yuncheng\,\ Shanxi",
  861332760 => "Haixi\,\ Qinghai",
  861332761 => "Haixi\,\ Qinghai",
  861332762 => "Haidong\,\ Qinghai",
  861332763 => "Xining\,\ Qinghai",
  861332764 => "Xining\,\ Qinghai",
  861332765 => "Xining\,\ Qinghai",
  861332766 => "Xining\,\ Qinghai",
  861332767 => "Xining\,\ Qinghai",
  861332768 => "Xining\,\ Qinghai",
  861332769 => "Xining\,\ Qinghai",
  861332770 => "Nanjing\,\ Jiangsu",
  861332771 => "Nanjing\,\ Jiangsu",
  861332772 => "Nanjing\,\ Jiangsu",
  861332773 => "Nanjing\,\ Jiangsu",
  861332774 => "Zhenjiang\,\ Jiangsu",
  861332775 => "Zhenjiang\,\ Jiangsu",
  861332776 => "Zhenjiang\,\ Jiangsu",
  861332777 => "Zhenjiang\,\ Jiangsu",
  861332778 => "Taizhou\,\ Jiangsu",
  861332779 => "Taizhou\,\ Jiangsu",
  861332780 => "Nanjing\,\ Jiangsu",
  861332781 => "Nanjing\,\ Jiangsu",
  861332782 => "Nanjing\,\ Jiangsu",
  861332783 => "Nanjing\,\ Jiangsu",
  861332784 => "Suqian\,\ Jiangsu",
  861332785 => "Suqian\,\ Jiangsu",
  861332786 => "Lianyungang\,\ Jiangsu",
  861332787 => "Lianyungang\,\ Jiangsu",
  861332788 => "Changzhou\,\ Jiangsu",
  861332789 => "Changzhou\,\ Jiangsu",
  861332790 => "Wuxi\,\ Jiangsu",
  861332791 => "Wuxi\,\ Jiangsu",
  861332792 => "Wuxi\,\ Jiangsu",
  861332793 => "Xuzhou\,\ Jiangsu",
  861332794 => "Xuzhou\,\ Jiangsu",
  861332795 => "Xuzhou\,\ Jiangsu",
  861332796 => "HuaiAn\,\ Jiangsu",
  861332797 => "HuaiAn\,\ Jiangsu",
  861332798 => "Yancheng\,\ Jiangsu",
  861332799 => "Yancheng\,\ Jiangsu",
  861332800 => "Suzhou\,\ Jiangsu",
  861332801 => "Suzhou\,\ Jiangsu",
  861332802 => "Suzhou\,\ Jiangsu",
  861332803 => "Suzhou\,\ Jiangsu",
  861332804 => "Suzhou\,\ Jiangsu",
  861332805 => "Suzhou\,\ Jiangsu",
  861332806 => "Nantong\,\ Jiangsu",
  861332807 => "Nantong\,\ Jiangsu",
  861332808 => "Nantong\,\ Jiangsu",
  861332809 => "Nantong\,\ Jiangsu",
  861332810 => "Wuxi\,\ Jiangsu",
  861332811 => "Wuxi\,\ Jiangsu",
  861332812 => "Yangzhou\,\ Jiangsu",
  861332813 => "Yangzhou\,\ Jiangsu",
  861332814 => "Yangzhou\,\ Jiangsu",
  861332815 => "Wuxi\,\ Jiangsu",
  861332816 => "Changzhou\,\ Jiangsu",
  861332817 => "Changzhou\,\ Jiangsu",
  861332818 => "Changzhou\,\ Jiangsu",
  861332819 => "Changzhou\,\ Jiangsu",
  861332820 => "Fuzhou\,\ Fujian",
  861332821 => "Fuzhou\,\ Fujian",
  861332822 => "Fuzhou\,\ Fujian",
  861332823 => "Fuzhou\,\ Fujian",
  861332824 => "Fuzhou\,\ Fujian",
  861332825 => "Fuzhou\,\ Fujian",
  861332826 => "Fuzhou\,\ Fujian",
  861332827 => "Fuzhou\,\ Fujian",
  861332828 => "Ningde\,\ Fujian",
  861332829 => "Ningde\,\ Fujian",
  861332830 => "Xiamen\,\ Fujian",
  861332831 => "Xiamen\,\ Fujian",
  861332832 => "Xiamen\,\ Fujian",
  861332833 => "Zhangzhou\,\ Fujian",
  861332834 => "Zhangzhou\,\ Fujian",
  861332835 => "Zhangzhou\,\ Fujian",
  861332836 => "Putian\,\ Fujian",
  861332837 => "Putian\,\ Fujian",
  861332838 => "Nanping\,\ Fujian",
  861332839 => "Nanping\,\ Fujian",
  861332840 => "Xiamen\,\ Fujian",
  861332841 => "Xiamen\,\ Fujian",
  861332842 => "Quanzhou\,\ Fujian",
  861332843 => "Quanzhou\,\ Fujian",
  861332844 => "Zhangzhou\,\ Fujian",
  861332845 => "Zhangzhou\,\ Fujian",
  861332846 => "Fuzhou\,\ Fujian",
  861332847 => "Fuzhou\,\ Fujian",
  861332848 => "Longyan\,\ Fujian",
  861332849 => "Longyan\,\ Fujian",
  861332850 => "Quanzhou\,\ Fujian",
  861332851 => "Quanzhou\,\ Fujian",
  861332852 => "Quanzhou\,\ Fujian",
  861332853 => "Quanzhou\,\ Fujian",
  861332854 => "Quanzhou\,\ Fujian",
  861332855 => "Quanzhou\,\ Fujian",
  861332856 => "Quanzhou\,\ Fujian",
  861332857 => "Quanzhou\,\ Fujian",
  861332858 => "Sanming\,\ Fujian",
  861332859 => "Sanming\,\ Fujian",
  861332860 => "Nanping\,\ Fujian",
  861332861 => "Nanping\,\ Fujian",
  861332862 => "Nanping\,\ Fujian",
  861332863 => "Longyan\,\ Fujian",
  861332864 => "Fuzhou\,\ Fujian",
  861332865 => "Fuzhou\,\ Fujian",
  861332866 => "Fuzhou\,\ Fujian",
  861332867 => "Fuzhou\,\ Fujian",
  861332868 => "Fuzhou\,\ Fujian",
  861332869 => "Fuzhou\,\ Fujian",
  861332870 => "Zhangzhou\,\ Fujian",
  861332871 => "Zhangzhou\,\ Fujian",
  861332872 => "Zhangzhou\,\ Fujian",
  861332873 => "Longyan\,\ Fujian",
  861332874 => "Longyan\,\ Fujian",
  861332875 => "Xiamen\,\ Fujian",
  861332876 => "Xiamen\,\ Fujian",
  861332877 => "Xiamen\,\ Fujian",
  861332878 => "Xiamen\,\ Fujian",
  861332879 => "Xiamen\,\ Fujian",
  861332880 => "Zhangzhou\,\ Fujian",
  861332881 => "Zhangzhou\,\ Fujian",
  861332882 => "Putian\,\ Fujian",
  861332883 => "Putian\,\ Fujian",
  861332884 => "Putian\,\ Fujian",
  861332885 => "Fuzhou\,\ Fujian",
  861332886 => "Fuzhou\,\ Fujian",
  861332887 => "Quanzhou\,\ Fujian",
  861332888 => "Quanzhou\,\ Fujian",
  861332889 => "Quanzhou\,\ Fujian",
  861332890 => "Sanming\,\ Fujian",
  861332891 => "Sanming\,\ Fujian",
  861332892 => "Sanming\,\ Fujian",
  861332893 => "Ningde\,\ Fujian",
  861332894 => "Ningde\,\ Fujian",
  861332895 => "Ningde\,\ Fujian",
  861332896 => "Quanzhou\,\ Fujian",
  861332897 => "Quanzhou\,\ Fujian",
  861332898 => "Quanzhou\,\ Fujian",
  861332899 => "Quanzhou\,\ Fujian",
  861332900 => "Chuzhou\,\ Anhui",
  861332901 => "Hefei\,\ Anhui",
  861332902 => "Bengbu\,\ Anhui",
  861332903 => "Wuhu\,\ Anhui",
  861332904 => "Hefei\,\ Anhui",
  861332905 => "MaAnshan\,\ Anhui",
  861332906 => "Anqing\,\ Anhui",
  861332907 => "Suzhou\,\ Anhui",
  861332908 => "Fuyang\,\ Anhui",
  861332909 => "Huangshan\,\ Anhui",
  861332910 => "Huainan\,\ Anhui",
  861332911 => "Huaibei\,\ Anhui",
  861332912 => "Tongling\,\ Anhui",
  861332913 => "Xuancheng\,\ Anhui",
  861332914 => "Wuhu\,\ Anhui",
  861332915 => "Chaohu\,\ Anhui",
  861332916 => "Chizhou\,\ Anhui",
  861332917 => "Suzhou\,\ Anhui",
  861332918 => "MaAnshan\,\ Anhui",
  861332919 => "LuAn\,\ Anhui",
  861332920 => "Chuzhou\,\ Anhui",
  861332921 => "Huaibei\,\ Anhui",
  861332922 => "Bengbu\,\ Anhui",
  861332923 => "LuAn\,\ Anhui",
  861332924 => "Fuyang\,\ Anhui",
  861332925 => "Chaohu\,\ Anhui",
  861332926 => "Anqing\,\ Anhui",
  861332927 => "Bozhou\,\ Anhui",
  861332928 => "Huainan\,\ Anhui",
  861332929 => "Xuancheng\,\ Anhui",
  861332930 => "Harbin\,\ Heilongjiang",
  861332931 => "Harbin\,\ Heilongjiang",
  861332932 => "Qitaihe\,\ Heilongjiang",
  861332933 => "Shuangyashan\,\ Heilongjiang",
  861332934 => "Shuangyashan\,\ Heilongjiang",
  861332935 => "Suihua\,\ Heilongjiang",
  861332936 => "Heihe\,\ Heilongjiang",
  861332937 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861332938 => "Yichun\,\ Heilongjiang",
  861332939 => "Daqing\,\ Heilongjiang",
  861332940 => "Harbin\,\ Heilongjiang",
  861332941 => "Harbin\,\ Heilongjiang",
  861332942 => "Qiqihar\,\ Heilongjiang",
  861332943 => "Mudanjiang\,\ Heilongjiang",
  861332944 => "Jiamusi\,\ Heilongjiang",
  861332945 => "Suihua\,\ Heilongjiang",
  861332946 => "Heihe\,\ Heilongjiang",
  861332947 => "Daqing\,\ Heilongjiang",
  861332948 => "Yichun\,\ Heilongjiang",
  861332949 => "Daqing\,\ Heilongjiang",
  861332950 => "Daqing\,\ Heilongjiang",
  861332951 => "Harbin\,\ Heilongjiang",
  861332952 => "Qiqihar\,\ Heilongjiang",
  861332953 => "Mudanjiang\,\ Heilongjiang",
  861332954 => "Jiamusi\,\ Heilongjiang",
  861332955 => "Jiamusi\,\ Heilongjiang",
  861332956 => "Jixi\,\ Heilongjiang",
  861332957 => "Jixi\,\ Heilongjiang",
  861332958 => "Hegang\,\ Heilongjiang",
  861332959 => "Daqing\,\ Heilongjiang",
  861332960 => "Guiyang\,\ Guizhou",
  861332961 => "Guiyang\,\ Guizhou",
  861332962 => "Zunyi\,\ Guizhou",
  861332963 => "Anshun\,\ Guizhou",
  861332964 => "Qiannan\,\ Guizhou",
  861332965 => "Qiandongnan\,\ Guizhou",
  861332966 => "Tongren\,\ Guizhou",
  861332967 => "Bijie\,\ Guizhou",
  861332968 => "Liupanshui\,\ Guizhou",
  861332969 => "Qianxinan\,\ Guizhou",
  861332970 => "Wuhan\,\ Hubei",
  861332971 => "Wuhan\,\ Hubei",
  861332972 => "Wuhan\,\ Hubei",
  861332973 => "Wuhan\,\ Hubei",
  861332974 => "Xiantao\,\ Hubei",
  861332975 => "Xiantao\,\ Hubei",
  861332976 => "Jingzhou\,\ Hubei",
  861332977 => "Jingzhou\,\ Hubei",
  861332978 => "Jingmen\,\ Hubei",
  861332979 => "Jingmen\,\ Hubei",
  861332980 => "Yichang\,\ Hubei",
  861332981 => "Yichang\,\ Hubei",
  861332982 => "Enshi\,\ Hubei",
  861332983 => "Enshi\,\ Hubei",
  861332984 => "Shiyan\,\ Hubei",
  861332985 => "Shiyan\,\ Hubei",
  861332986 => "Xiangfan\,\ Hubei",
  861332987 => "Xiangfan\,\ Hubei",
  861332988 => "Suizhou\,\ Hubei",
  861332989 => "Suizhou\,\ Hubei",
  861332990 => "Xiaogan\,\ Hubei",
  861332991 => "Xiaogan\,\ Hubei",
  861332992 => "Huangshi\,\ Hubei",
  861332993 => "Huangshi\,\ Hubei",
  861332994 => "Huanggang\,\ Hubei",
  861332995 => "Huanggang\,\ Hubei",
  861332996 => "Ezhou\,\ Hubei",
  861332997 => "Ezhou\,\ Hubei",
  861332998 => "Xianning\,\ Hubei",
  861332999 => "Xianning\,\ Hubei",
  861333000 => "Jiujiang\,\ Jiangxi",
  861333001 => "Jiujiang\,\ Jiangxi",
  861333002 => "Jiujiang\,\ Jiangxi",
  861333003 => "Jiujiang\,\ Jiangxi",
  861333004 => "Shangrao\,\ Jiangxi",
  861333005 => "Nanchang\,\ Jiangxi",
  861333006 => "Nanchang\,\ Jiangxi",
  861333007 => "Nanchang\,\ Jiangxi",
  861333008 => "Nanchang\,\ Jiangxi",
  861333009 => "Nanchang\,\ Jiangxi",
  861333010 => "Nanchang\,\ Jiangxi",
  861333011 => "Nanchang\,\ Jiangxi",
  861333012 => "Nanchang\,\ Jiangxi",
  861333013 => "Ganzhou\,\ Jiangxi",
  861333014 => "Ganzhou\,\ Jiangxi",
  861333015 => "Ganzhou\,\ Jiangxi",
  861333016 => "Ganzhou\,\ Jiangxi",
  861333017 => "Ganzhou\,\ Jiangxi",
  861333018 => "Ganzhou\,\ Jiangxi",
  861333019 => "Yichun\,\ Jiangxi",
  86133302 => "Chongqing",
  86133303 => "Chongqing",
  861333040 => "Honghe\,\ Yunnan",
  861333041 => "Kunming\,\ Yunnan",
  861333042 => "Zhaotong\,\ Yunnan",
  861333043 => "Kunming\,\ Yunnan",
  861333044 => "Kunming\,\ Yunnan",
  861333045 => "Dehong\,\ Yunnan",
  861333046 => "Kunming\,\ Yunnan",
  861333047 => "Puer\,\ Yunnan",
  861333048 => "Xishuangbanna\,\ Yunnan",
  861333049 => "Kunming\,\ Yunnan",
  861333050 => "Kunming\,\ Yunnan",
  861333051 => "Kunming\,\ Yunnan",
  861333052 => "Kunming\,\ Yunnan",
  861333053 => "Kunming\,\ Yunnan",
  861333054 => "Kunming\,\ Yunnan",
  861333055 => "Dali\,\ Yunnan",
  861333056 => "Chuxiong\,\ Yunnan",
  861333057 => "Qujing\,\ Yunnan",
  861333058 => "Yuxi\,\ Yunnan",
  861333059 => "Baoshan\,\ Yunnan",
  861333060 => "YaAn\,\ Sichuan",
  861333061 => "Bazhong\,\ Sichuan",
  861333062 => "GuangAn\,\ Sichuan",
  861333063 => "Suining\,\ Sichuan",
  861333064 => "Suining\,\ Sichuan",
  861333065 => "Yibin\,\ Sichuan",
  861333066 => "Yibin\,\ Sichuan",
  861333067 => "Bazhong\,\ Sichuan",
  861333068 => "Ziyang\,\ Sichuan",
  861333069 => "Neijiang\,\ Sichuan",
  861333070 => "Neijiang\,\ Sichuan",
  861333071 => "Panzhihua\,\ Sichuan",
  861333072 => "Panzhihua\,\ Sichuan",
  861333073 => "Guangyuan\,\ Sichuan",
  861333074 => "Luzhou\,\ Sichuan",
  861333075 => "Guangyuan\,\ Sichuan",
  861333076 => "Nanchong\,\ Sichuan",
  861333077 => "Nanchong\,\ Sichuan",
  861333078 => "Luzhou\,\ Sichuan",
  861333079 => "Garze\,\ Sichuan",
  861333080 => "Zigong\,\ Sichuan",
  861333081 => "Zigong\,\ Sichuan",
  861333082 => "Dazhou\,\ Sichuan",
  861333083 => "Dazhou\,\ Sichuan",
  861333084 => "Ziyang\,\ Sichuan",
  861333085 => "Deyang\,\ Sichuan",
  861333086 => "Deyang\,\ Sichuan",
  861333087 => "Deyang\,\ Sichuan",
  861333088 => "Mianyang\,\ Sichuan",
  861333089 => "Mianyang\,\ Sichuan",
  861333090 => "Mianyang\,\ Sichuan",
  861333091 => "Leshan\,\ Sichuan",
  861333092 => "Leshan\,\ Sichuan",
  861333093 => "Meishan\,\ Sichuan",
  861333094 => "Chengdu\,\ Sichuan",
  861333095 => "Meishan\,\ Sichuan",
  861333096 => "Chengdu\,\ Sichuan",
  861333097 => "Liangshan\,\ Sichuan",
  861333098 => "Chengdu\,\ Sichuan",
  861333099 => "Chengdu\,\ Sichuan",
  86133310 => "Beijing",
  86133311 => "Beijing",
  86133312 => "Baoding\,\ Hebei",
  861333130 => "Zhangjiakou\,\ Hebei",
  861333131 => "Zhangjiakou\,\ Hebei",
  861333132 => "Zhangjiakou\,\ Hebei",
  861333133 => "Zhangjiakou\,\ Hebei",
  861333134 => "Shijiazhuang\,\ Hebei",
  861333135 => "Shijiazhuang\,\ Hebei",
  861333136 => "Shijiazhuang\,\ Hebei",
  861333137 => "Shijiazhuang\,\ Hebei",
  861333138 => "Shijiazhuang\,\ Hebei",
  861333139 => "Shijiazhuang\,\ Hebei",
  861333140 => "Baicheng\,\ Jilin",
  861333141 => "Baicheng\,\ Jilin",
  861333142 => "Liaoyuan\,\ Jilin",
  861333143 => "Liaoyuan\,\ Jilin",
  861333144 => "Tonghua\,\ Jilin",
  861333145 => "Tonghua\,\ Jilin",
  861333146 => "Tonghua\,\ Jilin",
  861333147 => "Tonghua\,\ Jilin",
  861333148 => "Yanbian\,\ Jilin",
  861333149 => "Baishan\,\ Jilin",
  861333150 => "Jilin\,\ Jilin",
  861333151 => "Yanbian\,\ Jilin",
  861333152 => "Songyuan\,\ Jilin",
  861333153 => "Tonghua\,\ Jilin",
  861333154 => "Changchun\,\ Jilin",
  861333155 => "Siping\,\ Jilin",
  861333156 => "Liaoyuan\,\ Jilin",
  861333157 => "Baicheng\,\ Jilin",
  861333158 => "Changchun\,\ Jilin",
  861333159 => "Baishan\,\ Jilin",
  861333160 => "Jilin\,\ Jilin",
  861333161 => "Jilin\,\ Jilin",
  861333162 => "Jilin\,\ Jilin",
  861333163 => "Yanbian\,\ Jilin",
  861333164 => "Changchun\,\ Jilin",
  861333165 => "Changchun\,\ Jilin",
  861333166 => "Changchun\,\ Jilin",
  861333167 => "Changchun\,\ Jilin",
  861333168 => "Changchun\,\ Jilin",
  861333169 => "Changchun\,\ Jilin",
  861333170 => "Jilin\,\ Jilin",
  861333171 => "Jilin\,\ Jilin",
  861333172 => "Jilin\,\ Jilin",
  861333173 => "Siping\,\ Jilin",
  861333174 => "Changchun\,\ Jilin",
  861333175 => "Changchun\,\ Jilin",
  861333176 => "Changchun\,\ Jilin",
  861333177 => "Changchun\,\ Jilin",
  861333178 => "Songyuan\,\ Jilin",
  861333179 => "Tonghua\,\ Jilin",
  86133318 => "Shanghai",
  86133319 => "Shanghai",
  86133320 => "Tianjin",
  861333210 => "Anshan\,\ Liaoning",
  861333211 => "Anshan\,\ Liaoning",
  861333212 => "Fushun\,\ Liaoning",
  861333213 => "Fushun\,\ Liaoning",
  861333214 => "Benxi\,\ Liaoning",
  861333215 => "Benxi\,\ Liaoning",
  861333216 => "Dandong\,\ Liaoning",
  861333217 => "Dandong\,\ Liaoning",
  861333218 => "Jinzhou\,\ Liaoning",
  861333219 => "Jinzhou\,\ Liaoning",
  86133322 => "Dalian\,\ Liaoning",
  861333230 => "Yingkou\,\ Liaoning",
  861333231 => "Yingkou\,\ Liaoning",
  861333232 => "Fuxin\,\ Liaoning",
  861333233 => "Liaoyang\,\ Liaoning",
  861333234 => "Liaoyang\,\ Liaoning",
  861333235 => "Tieling\,\ Liaoning",
  861333236 => "Chaoyang\,\ Liaoning",
  861333237 => "Panjin\,\ Liaoning",
  861333238 => "Panjin\,\ Liaoning",
  861333239 => "Huludao\,\ Liaoning",
  86133324 => "Shenyang\,\ Liaoning",
  861333250 => "Yueyang\,\ Hunan",
  861333251 => "Changsha\,\ Hunan",
  861333252 => "Xiangtan\,\ Hunan",
  861333253 => "Zhuzhou\,\ Hunan",
  861333254 => "Hengyang\,\ Hunan",
  861333255 => "Chenzhou\,\ Hunan",
  861333256 => "Changde\,\ Hunan",
  861333257 => "Yiyang\,\ Hunan",
  861333258 => "Loudi\,\ Hunan",
  861333259 => "Shaoyang\,\ Hunan",
  86133326 => "Dongguan\,\ Guangdong",
  861333270 => "Meizhou\,\ Guangdong",
  861333271 => "Meizhou\,\ Guangdong",
  861333272 => "Meizhou\,\ Guangdong",
  861333273 => "Meizhou\,\ Guangdong",
  861333274 => "Meizhou\,\ Guangdong",
  861333275 => "Meizhou\,\ Guangdong",
  861333276 => "Heyuan\,\ Guangdong",
  861333277 => "Chaozhou\,\ Guangdong",
  861333278 => "Chaozhou\,\ Guangdong",
  861333279 => "Chaozhou\,\ Guangdong",
  86133328 => "Guangzhou\,\ Guangdong",
  86133329 => "Shenzhen\,\ Guangdong",
  861333300 => "Handan\,\ Hebei",
  861333301 => "Shijiazhuang\,\ Hebei",
  861333302 => "Baoding\,\ Hebei",
  861333303 => "Zhangjiakou\,\ Hebei",
  861333304 => "Shijiazhuang\,\ Hebei",
  861333305 => "Tangshan\,\ Hebei",
  861333306 => "Langfang\,\ Hebei",
  861333307 => "Cangzhou\,\ Hebei",
  861333308 => "Hengshui\,\ Hebei",
  861333309 => "Xingtai\,\ Hebei",
  861333310 => "Handan\,\ Hebei",
  861333311 => "Shijiazhuang\,\ Hebei",
  861333312 => "Baoding\,\ Hebei",
  861333313 => "Zhangjiakou\,\ Hebei",
  861333314 => "Chengde\,\ Hebei",
  861333315 => "Tangshan\,\ Hebei",
  861333316 => "Langfang\,\ Hebei",
  861333317 => "Cangzhou\,\ Hebei",
  861333318 => "Hengshui\,\ Hebei",
  861333319 => "Xingtai\,\ Hebei",
  861333320 => "Handan\,\ Hebei",
  861333321 => "Shijiazhuang\,\ Hebei",
  861333322 => "Baoding\,\ Hebei",
  861333323 => "Zhangjiakou\,\ Hebei",
  861333324 => "Baoding\,\ Hebei",
  861333325 => "Tangshan\,\ Hebei",
  861333326 => "Langfang\,\ Hebei",
  861333327 => "Cangzhou\,\ Hebei",
  861333328 => "Qinhuangdao\,\ Hebei",
  861333329 => "Tangshan\,\ Hebei",
  861333330 => "Qinhuangdao\,\ Hebei",
  861333331 => "Qinhuangdao\,\ Hebei",
  861333332 => "Qinhuangdao\,\ Hebei",
  861333333 => "Qinhuangdao\,\ Hebei",
  861333334 => "Qinhuangdao\,\ Hebei",
  861333335 => "Qinhuangdao\,\ Hebei",
  861333336 => "Cangzhou\,\ Hebei",
  861333337 => "Shijiazhuang\,\ Hebei",
  861333338 => "Shijiazhuang\,\ Hebei",
  861333339 => "Chengde\,\ Hebei",
  861333340 => "Taiyuan\,\ Shanxi",
  861333341 => "Taiyuan\,\ Shanxi",
  861333342 => "Datong\,\ Shanxi",
  861333343 => "Taiyuan\,\ Shanxi",
  861333344 => "Jinzhong\,\ Shanxi",
  861333345 => "Changzhi\,\ Shanxi",
  861333346 => "Taiyuan\,\ Shanxi",
  861333347 => "Linfen\,\ Shanxi",
  861333348 => "Yuncheng\,\ Shanxi",
  861333349 => "Shuozhou\,\ Shanxi",
  861333350 => "Xinzhou\,\ Shanxi",
  861333351 => "Taiyuan\,\ Shanxi",
  861333352 => "Datong\,\ Shanxi",
  861333353 => "Yangquan\,\ Shanxi",
  861333354 => "Jinzhong\,\ Shanxi",
  861333355 => "Changzhi\,\ Shanxi",
  861333356 => "Jincheng\,\ Shanxi",
  861333357 => "Linfen\,\ Shanxi",
  861333358 => "Lüliang\,\ Shanxi",
  861333359 => "Yuncheng\,\ Shanxi",
  86133336 => "Nanyang\,\ Henan",
  861333370 => "Shangqiu\,\ Henan",
  861333371 => "Zhengzhou\,\ Henan",
  861333372 => "Anyang\,\ Henan",
  861333373 => "Xinxiang\,\ Henan",
  861333374 => "Xuchang\,\ Henan",
  861333375 => "Pingdingshan\,\ Henan",
  861333376 => "Xinyang\,\ Henan",
  861333377 => "Nanyang\,\ Henan",
  861333378 => "Kaifeng\,\ Henan",
  861333379 => "Luoyang\,\ Henan",
  861333380 => "Xinxiang\,\ Henan",
  861333381 => "Zhengzhou\,\ Henan",
  861333382 => "Zhengzhou\,\ Henan",
  861333383 => "Zhengzhou\,\ Henan",
  861333384 => "Zhengzhou\,\ Henan",
  861333385 => "Zhengzhou\,\ Henan",
  861333386 => "Zhengzhou\,\ Henan",
  861333387 => "Luoyang\,\ Henan",
  861333388 => "Luoyang\,\ Henan",
  861333389 => "Luoyang\,\ Henan",
  861333390 => "Pingdingshan\,\ Henan",
  861333391 => "Jiaozuo\,\ Henan",
  861333392 => "Hebi\,\ Henan",
  861333393 => "Puyang\,\ Henan",
  861333394 => "Zhoukou\,\ Henan",
  861333395 => "Luohe\,\ Henan",
  861333396 => "Zhumadian\,\ Henan",
  861333397 => "Xinyang\,\ Henan",
  861333398 => "Sanmenxia\,\ Henan",
  861333399 => "Xuchang\,\ Henan",
  86133343 => "Foshan\,\ Guangdong",
  86133347 => "Puer\,\ Yunnan",
  86133350 => "Qingdao\,\ Shandong",
  86133351 => "Jinan\,\ Shandong",
  861333520 => "Zibo\,\ Shandong",
  861333521 => "Zibo\,\ Shandong",
  861333522 => "Zibo\,\ Shandong",
  861333523 => "Zibo\,\ Shandong",
  861333524 => "Weifang\,\ Shandong",
  861333525 => "Weifang\,\ Shandong",
  861333526 => "Weifang\,\ Shandong",
  861333527 => "TaiAn\,\ Shandong",
  861333528 => "TaiAn\,\ Shandong",
  861333529 => "TaiAn\,\ Shandong",
  861333530 => "Xianyang\,\ Shaanxi",
  861333531 => "YanAn\,\ Shaanxi",
  861333532 => "Yulin\,\ Shaanxi",
  861333533 => "Weinan\,\ Shaanxi",
  861333534 => "Weinan\,\ Shaanxi",
  861333535 => "Weinan\,\ Shaanxi",
  861333536 => "Hanzhong\,\ Shaanxi",
  861333537 => "Baoji\,\ Shaanxi",
  861333538 => "XiAn\,\ Shaanxi",
  861333539 => "XiAn\,\ Shaanxi",
  861333540 => "Xianyang\,\ Shaanxi",
  861333541 => "Xianyang\,\ Shaanxi",
  861333542 => "Xianyang\,\ Shaanxi",
  861333543 => "Xianyang\,\ Shaanxi",
  861333544 => "Hanzhong\,\ Shaanxi",
  861333545 => "Hanzhong\,\ Shaanxi",
  861333546 => "Baoji\,\ Shaanxi",
  861333547 => "Baoji\,\ Shaanxi",
  861333548 => "Baoji\,\ Shaanxi",
  861333549 => "Baoji\,\ Shaanxi",
  861333550 => "Chuzhou\,\ Anhui",
  861333551 => "Hefei\,\ Anhui",
  861333552 => "Bengbu\,\ Anhui",
  861333553 => "Wuhu\,\ Anhui",
  861333554 => "Huainan\,\ Anhui",
  861333555 => "MaAnshan\,\ Anhui",
  861333556 => "Anqing\,\ Anhui",
  861333557 => "Suzhou\,\ Anhui",
  861333558 => "Fuyang\,\ Anhui",
  861333559 => "Huangshan\,\ Anhui",
  861333560 => "Huaibei\,\ Anhui",
  861333561 => "Huaibei\,\ Anhui",
  861333562 => "Tongling\,\ Anhui",
  861333563 => "Xuancheng\,\ Anhui",
  861333564 => "LuAn\,\ Anhui",
  861333565 => "Chaohu\,\ Anhui",
  861333566 => "Chizhou\,\ Anhui",
  861333567 => "Bozhou\,\ Anhui",
  861333568 => "Bozhou\,\ Anhui",
  861333569 => "Huangshan\,\ Anhui",
  861333570 => "Quzhou\,\ Zhejiang",
  861333571 => "Hangzhou\,\ Zhejiang",
  861333572 => "Huzhou\,\ Zhejiang",
  861333573 => "Jiaxing\,\ Zhejiang",
  861333574 => "Ningbo\,\ Zhejiang",
  861333575 => "Shaoxing\,\ Zhejiang",
  861333576 => "Taizhou\,\ Zhejiang",
  861333577 => "Wenzhou\,\ Zhejiang",
  861333578 => "Shaoxing\,\ Zhejiang",
  861333579 => "Jinhua\,\ Zhejiang",
  861333580 => "Zhoushan\,\ Zhejiang",
  861333581 => "Hangzhou\,\ Zhejiang",
  861333582 => "Huzhou\,\ Zhejiang",
  861333583 => "Jiaxing\,\ Zhejiang",
  861333584 => "Ningbo\,\ Zhejiang",
  861333585 => "Shaoxing\,\ Zhejiang",
  861333586 => "Taizhou\,\ Zhejiang",
  861333587 => "Wenzhou\,\ Zhejiang",
  861333588 => "Hangzhou\,\ Zhejiang",
  861333589 => "Jinhua\,\ Zhejiang",
  86133359 => "Jinhua\,\ Zhejiang",
  86133360 => "Hangzhou\,\ Zhejiang",
  86133361 => "Hangzhou\,\ Zhejiang",
  861333620 => "Heze\,\ Shandong",
  861333621 => "Heze\,\ Shandong",
  861333622 => "Liaocheng\,\ Shandong",
  861333623 => "Rizhao\,\ Shandong",
  861333624 => "Weihai\,\ Shandong",
  861333625 => "Liaocheng\,\ Shandong",
  861333626 => "Dezhou\,\ Shandong",
  861333627 => "Dezhou\,\ Shandong",
  861333628 => "Binzhou\,\ Shandong",
  861333629 => "Binzhou\,\ Shandong",
  861333630 => "Weihai\,\ Shandong",
  861333631 => "Weihai\,\ Shandong",
  861333632 => "Zaozhuang\,\ Shandong",
  861333633 => "Rizhao\,\ Shandong",
  861333634 => "Laiwu\,\ Shandong",
  861333635 => "Liaocheng\,\ Shandong",
  861333636 => "Weifang\,\ Shandong",
  861333637 => "Zaozhuang\,\ Shandong",
  861333638 => "Yantai\,\ Shandong",
  861333639 => "Qingdao\,\ Shandong",
  86133364 => "Foshan\,\ Guangdong",
  861333650 => "Zhanjiang\,\ Guangdong",
  861333651 => "Zhanjiang\,\ Guangdong",
  861333652 => "Maoming\,\ Guangdong",
  861333653 => "Maoming\,\ Guangdong",
  861333654 => "Shenzhen\,\ Guangdong",
  861333655 => "Maoming\,\ Guangdong",
  861333656 => "Maoming\,\ Guangdong",
  861333657 => "Yangjiang\,\ Guangdong",
  861333658 => "Yangjiang\,\ Guangdong",
  861333659 => "Yangjiang\,\ Guangdong",
  86133366 => "Ningbo\,\ Zhejiang",
  861333670 => "Shaoxing\,\ Zhejiang",
  861333671 => "Shaoxing\,\ Zhejiang",
  861333672 => "Taizhou\,\ Zhejiang",
  861333673 => "Taizhou\,\ Zhejiang",
  861333674 => "Taizhou\,\ Zhejiang",
  861333675 => "Taizhou\,\ Zhejiang",
  861333676 => "Taizhou\,\ Zhejiang",
  861333677 => "Taizhou\,\ Zhejiang",
  861333678 => "Taizhou\,\ Zhejiang",
  861333679 => "Taizhou\,\ Zhejiang",
  861333680 => "Shaoxing\,\ Zhejiang",
  861333681 => "Shaoxing\,\ Zhejiang",
  861333682 => "Shaoxing\,\ Zhejiang",
  861333683 => "Huzhou\,\ Zhejiang",
  861333684 => "Huzhou\,\ Zhejiang",
  861333685 => "Huzhou\,\ Zhejiang",
  861333686 => "Ningbo\,\ Zhejiang",
  861333687 => "Ningbo\,\ Zhejiang",
  861333688 => "Ningbo\,\ Zhejiang",
  861333689 => "Ningbo\,\ Zhejiang",
  86133369 => "Wenzhou\,\ Zhejiang",
  861333700 => "Bayannur\,\ Inner\ Mongolia",
  861333701 => "Bayannur\,\ Inner\ Mongolia",
  861333702 => "Hinggan\,\ Inner\ Mongolia",
  861333703 => "Bayannur\,\ Inner\ Mongolia",
  861333704 => "Tongliao\,\ Inner\ Mongolia",
  861333705 => "Tongliao\,\ Inner\ Mongolia",
  861333706 => "Ordos\,\ Inner\ Mongolia",
  861333707 => "Ordos\,\ Inner\ Mongolia",
  861333708 => "Bayannur\,\ Inner\ Mongolia",
  861333709 => "Xilin\,\ Inner\ Mongolia",
  861333710 => "Hohhot\,\ Inner\ Mongolia",
  861333711 => "Hohhot\,\ Inner\ Mongolia",
  861333712 => "Hohhot\,\ Inner\ Mongolia",
  861333713 => "Hinggan\,\ Inner\ Mongolia",
  861333714 => "Hinggan\,\ Inner\ Mongolia",
  861333715 => "Chifeng\,\ Inner\ Mongolia",
  861333716 => "Chifeng\,\ Inner\ Mongolia",
  861333717 => "Baotou\,\ Inner\ Mongolia",
  861333718 => "Baotou\,\ Inner\ Mongolia",
  861333719 => "Baotou\,\ Inner\ Mongolia",
  861333720 => "Yueyang\,\ Hunan",
  861333721 => "Changsha\,\ Hunan",
  861333722 => "Xiangtan\,\ Hunan",
  861333723 => "Zhuzhou\,\ Hunan",
  861333724 => "Zhangjiajie\,\ Hunan",
  861333725 => "Huaihua\,\ Hunan",
  861333726 => "Yongzhou\,\ Hunan",
  861333727 => "Yiyang\,\ Hunan",
  861333728 => "Xiangxi\,\ Hunan",
  861333729 => "Shaoyang\,\ Hunan",
  861333730 => "Yueyang\,\ Hunan",
  861333731 => "Changsha\,\ Hunan",
  861333732 => "Xiangtan\,\ Hunan",
  861333733 => "Zhuzhou\,\ Hunan",
  861333734 => "Hengyang\,\ Hunan",
  861333735 => "Chenzhou\,\ Hunan",
  861333736 => "Changde\,\ Hunan",
  861333737 => "Yiyang\,\ Hunan",
  861333738 => "Loudi\,\ Hunan",
  861333739 => "Shaoyang\,\ Hunan",
  861333740 => "Huanggang\,\ Hubei",
  861333741 => "Huanggang\,\ Hubei",
  861333742 => "Huanggang\,\ Hubei",
  861333743 => "Huanggang\,\ Hubei",
  861333744 => "Huanggang\,\ Hubei",
  861333745 => "Huanggang\,\ Hubei",
  861333746 => "Huanggang\,\ Hubei",
  861333747 => "Jingmen\,\ Hubei",
  861333748 => "Jingmen\,\ Hubei",
  861333749 => "Enshi\,\ Hubei",
  86133375 => "Haikou\,\ Hainan",
  86133376 => "Haikou\,\ Hainan",
  861333770 => "Nanjing\,\ Jiangsu",
  861333771 => "Nanjing\,\ Jiangsu",
  861333772 => "Nanjing\,\ Jiangsu",
  861333773 => "Nanjing\,\ Jiangsu",
  861333774 => "Zhenjiang\,\ Jiangsu",
  861333775 => "Zhenjiang\,\ Jiangsu",
  861333776 => "Zhenjiang\,\ Jiangsu",
  861333777 => "Zhenjiang\,\ Jiangsu",
  861333778 => "Taizhou\,\ Jiangsu",
  861333779 => "Taizhou\,\ Jiangsu",
  861333780 => "Nanjing\,\ Jiangsu",
  861333781 => "Nanjing\,\ Jiangsu",
  861333782 => "Nanjing\,\ Jiangsu",
  861333783 => "Nanjing\,\ Jiangsu",
  861333784 => "Suqian\,\ Jiangsu",
  861333785 => "Suqian\,\ Jiangsu",
  861333786 => "Lianyungang\,\ Jiangsu",
  861333787 => "Lianyungang\,\ Jiangsu",
  861333788 => "Changzhou\,\ Jiangsu",
  861333789 => "Changzhou\,\ Jiangsu",
  861333790 => "Wuxi\,\ Jiangsu",
  861333791 => "Wuxi\,\ Jiangsu",
  861333792 => "Wuxi\,\ Jiangsu",
  861333793 => "Xuzhou\,\ Jiangsu",
  861333794 => "Xuzhou\,\ Jiangsu",
  861333795 => "Xuzhou\,\ Jiangsu",
  861333796 => "HuaiAn\,\ Jiangsu",
  861333797 => "HuaiAn\,\ Jiangsu",
  861333798 => "Yancheng\,\ Jiangsu",
  861333799 => "Yancheng\,\ Jiangsu",
  861333800 => "Suzhou\,\ Jiangsu",
  861333801 => "Suzhou\,\ Jiangsu",
  861333802 => "Suzhou\,\ Jiangsu",
  861333803 => "Suzhou\,\ Jiangsu",
  861333804 => "Suzhou\,\ Jiangsu",
  861333805 => "Suzhou\,\ Jiangsu",
  861333806 => "Nantong\,\ Jiangsu",
  861333807 => "Nantong\,\ Jiangsu",
  861333808 => "Nantong\,\ Jiangsu",
  861333809 => "Nantong\,\ Jiangsu",
  861333810 => "Wuxi\,\ Jiangsu",
  861333811 => "Wuxi\,\ Jiangsu",
  861333812 => "Yangzhou\,\ Jiangsu",
  861333813 => "Yangzhou\,\ Jiangsu",
  861333814 => "Yangzhou\,\ Jiangsu",
  861333815 => "Wuxi\,\ Jiangsu",
  861333816 => "Changzhou\,\ Jiangsu",
  861333817 => "Changzhou\,\ Jiangsu",
  861333818 => "Changzhou\,\ Jiangsu",
  861333819 => "Changzhou\,\ Jiangsu",
  861333820 => "Ningde\,\ Fujian",
  861333821 => "Ningde\,\ Fujian",
  861333822 => "Ningde\,\ Fujian",
  861333823 => "Sanming\,\ Fujian",
  861333824 => "Sanming\,\ Fujian",
  861333825 => "Fuzhou\,\ Fujian",
  861333826 => "Fuzhou\,\ Fujian",
  861333827 => "Fuzhou\,\ Fujian",
  861333828 => "Fuzhou\,\ Fujian",
  861333829 => "Fuzhou\,\ Fujian",
  861333830 => "Zhangzhou\,\ Fujian",
  861333831 => "Zhangzhou\,\ Fujian",
  861333832 => "Zhangzhou\,\ Fujian",
  861333833 => "Zhangzhou\,\ Fujian",
  861333834 => "Zhangzhou\,\ Fujian",
  861333835 => "Zhangzhou\,\ Fujian",
  861333836 => "Xiamen\,\ Fujian",
  861333837 => "Longyan\,\ Fujian",
  861333838 => "Longyan\,\ Fujian",
  861333839 => "Longyan\,\ Fujian",
  861333840 => "Fuzhou\,\ Fujian",
  861333841 => "Fuzhou\,\ Fujian",
  861333842 => "Fuzhou\,\ Fujian",
  861333843 => "Fuzhou\,\ Fujian",
  861333844 => "Fuzhou\,\ Fujian",
  861333845 => "Xiamen\,\ Fujian",
  861333846 => "Xiamen\,\ Fujian",
  861333847 => "Quanzhou\,\ Fujian",
  861333848 => "Quanzhou\,\ Fujian",
  861333849 => "Quanzhou\,\ Fujian",
  861333850 => "Putian\,\ Fujian",
  861333851 => "Putian\,\ Fujian",
  861333852 => "Putian\,\ Fujian",
  861333853 => "Nanping\,\ Fujian",
  861333854 => "Nanping\,\ Fujian",
  861333855 => "Nanping\,\ Fujian",
  861333856 => "Quanzhou\,\ Fujian",
  861333857 => "Quanzhou\,\ Fujian",
  861333858 => "Quanzhou\,\ Fujian",
  861333859 => "Quanzhou\,\ Fujian",
  861333860 => "Nanjing\,\ Jiangsu",
  861333861 => "Nanjing\,\ Jiangsu",
  861333862 => "Nanjing\,\ Jiangsu",
  861333863 => "Nanjing\,\ Jiangsu",
  861333864 => "Suzhou\,\ Jiangsu",
  861333865 => "Suzhou\,\ Jiangsu",
  861333866 => "Suzhou\,\ Jiangsu",
  861333867 => "Suzhou\,\ Jiangsu",
  861333868 => "Suzhou\,\ Jiangsu",
  861333869 => "Suzhou\,\ Jiangsu",
  861333870 => "Suzhou\,\ Jiangsu",
  861333871 => "Suzhou\,\ Jiangsu",
  861333872 => "Suzhou\,\ Jiangsu",
  861333873 => "Wuxi\,\ Jiangsu",
  861333874 => "Wuxi\,\ Jiangsu",
  861333875 => "Wuxi\,\ Jiangsu",
  861333876 => "Wuxi\,\ Jiangsu",
  861333877 => "Wuxi\,\ Jiangsu",
  861333878 => "Wuxi\,\ Jiangsu",
  861333879 => "Changzhou\,\ Jiangsu",
  861333880 => "Changzhou\,\ Jiangsu",
  861333881 => "Zhenjiang\,\ Jiangsu",
  861333882 => "Nantong\,\ Jiangsu",
  861333883 => "Nantong\,\ Jiangsu",
  861333884 => "Yangzhou\,\ Jiangsu",
  861333885 => "Yangzhou\,\ Jiangsu",
  861333886 => "Yangzhou\,\ Jiangsu",
  861333887 => "Taizhou\,\ Jiangsu",
  861333888 => "Taizhou\,\ Jiangsu",
  861333889 => "Taizhou\,\ Jiangsu",
  861333890 => "HuaiAn\,\ Jiangsu",
  861333891 => "HuaiAn\,\ Jiangsu",
  861333892 => "Yancheng\,\ Jiangsu",
  861333893 => "Yancheng\,\ Jiangsu",
  861333894 => "Yancheng\,\ Jiangsu",
  861333895 => "Yancheng\,\ Jiangsu",
  861333896 => "Xuzhou\,\ Jiangsu",
  861333897 => "Xuzhou\,\ Jiangsu",
  861333898 => "Lianyungang\,\ Jiangsu",
  861333899 => "Lianyungang\,\ Jiangsu",
  861333900 => "Chuzhou\,\ Anhui",
  861333901 => "Hefei\,\ Anhui",
  861333902 => "Bengbu\,\ Anhui",
  861333903 => "Wuhu\,\ Anhui",
  861333904 => "Fuyang\,\ Anhui",
  861333905 => "MaAnshan\,\ Anhui",
  861333906 => "Anqing\,\ Anhui",
  861333907 => "Suzhou\,\ Anhui",
  861333908 => "Bengbu\,\ Anhui",
  861333909 => "Huangshan\,\ Anhui",
  861333910 => "Hefei\,\ Anhui",
  861333911 => "LuAn\,\ Anhui",
  861333912 => "Tongling\,\ Anhui",
  861333913 => "Xuancheng\,\ Anhui",
  861333914 => "Hefei\,\ Anhui",
  861333915 => "Chaohu\,\ Anhui",
  861333916 => "Chizhou\,\ Anhui",
  861333917 => "Bozhou\,\ Anhui",
  861333918 => "Huainan\,\ Anhui",
  861333919 => "Hefei\,\ Anhui",
  861333920 => "Chuzhou\,\ Anhui",
  861333921 => "Huaibei\,\ Anhui",
  861333922 => "Fuyang\,\ Anhui",
  861333923 => "Wuhu\,\ Anhui",
  861333924 => "Xuancheng\,\ Anhui",
  861333925 => "Tongling\,\ Anhui",
  861333926 => "Anqing\,\ Anhui",
  861333927 => "Bozhou\,\ Anhui",
  861333928 => "Hefei\,\ Anhui",
  861333929 => "Hefei\,\ Anhui",
  861333930 => "Harbin\,\ Heilongjiang",
  861333931 => "Harbin\,\ Heilongjiang",
  861333932 => "Qitaihe\,\ Heilongjiang",
  861333933 => "Shuangyashan\,\ Heilongjiang",
  861333934 => "Shuangyashan\,\ Heilongjiang",
  861333935 => "Suihua\,\ Heilongjiang",
  861333936 => "Heihe\,\ Heilongjiang",
  861333937 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861333938 => "Yichun\,\ Heilongjiang",
  861333939 => "Daqing\,\ Heilongjiang",
  861333940 => "Harbin\,\ Heilongjiang",
  861333941 => "Harbin\,\ Heilongjiang",
  861333942 => "Qiqihar\,\ Heilongjiang",
  861333943 => "Mudanjiang\,\ Heilongjiang",
  861333944 => "Jiamusi\,\ Heilongjiang",
  861333945 => "Suihua\,\ Heilongjiang",
  861333946 => "Heihe\,\ Heilongjiang",
  861333947 => "Daqing\,\ Heilongjiang",
  861333948 => "Yichun\,\ Heilongjiang",
  861333949 => "Daqing\,\ Heilongjiang",
  861333950 => "Daqing\,\ Heilongjiang",
  861333951 => "Harbin\,\ Heilongjiang",
  861333952 => "Qiqihar\,\ Heilongjiang",
  861333953 => "Mudanjiang\,\ Heilongjiang",
  861333954 => "Jiamusi\,\ Heilongjiang",
  861333955 => "Jiamusi\,\ Heilongjiang",
  861333956 => "Jixi\,\ Heilongjiang",
  861333957 => "Jixi\,\ Heilongjiang",
  861333958 => "Hegang\,\ Heilongjiang",
  861333959 => "Daqing\,\ Heilongjiang",
  861333960 => "Guiyang\,\ Guizhou",
  861333961 => "Guiyang\,\ Guizhou",
  861333962 => "Zunyi\,\ Guizhou",
  861333963 => "Anshun\,\ Guizhou",
  861333964 => "Qiannan\,\ Guizhou",
  861333965 => "Qiandongnan\,\ Guizhou",
  861333966 => "Tongren\,\ Guizhou",
  861333967 => "Bijie\,\ Guizhou",
  861333968 => "Liupanshui\,\ Guizhou",
  861333969 => "Qianxinan\,\ Guizhou",
  861333970 => "Xiantao\,\ Hubei",
  861333971 => "Wuhan\,\ Hubei",
  861333972 => "Wuhan\,\ Hubei",
  861333973 => "Jingzhou\,\ Hubei",
  861333974 => "Jingzhou\,\ Hubei",
  861333975 => "Jingmen\,\ Hubei",
  861333976 => "Jingmen\,\ Hubei",
  861333977 => "Jingmen\,\ Hubei",
  861333978 => "Yichang\,\ Hubei",
  861333979 => "Yichang\,\ Hubei",
  861333980 => "Xiangfan\,\ Hubei",
  861333981 => "Xiangfan\,\ Hubei",
  861333982 => "Xiangfan\,\ Hubei",
  861333983 => "Xiaogan\,\ Hubei",
  861333984 => "Xiaogan\,\ Hubei",
  861333985 => "Shiyan\,\ Hubei",
  861333986 => "Shiyan\,\ Hubei",
  861333987 => "Xianning\,\ Hubei",
  861333988 => "Xianning\,\ Hubei",
  861333989 => "Suizhou\,\ Hubei",
  861333990 => "Huangshi\,\ Hubei",
  861333991 => "Huangshi\,\ Hubei",
  861333992 => "Huangshi\,\ Hubei",
  861333993 => "Ezhou\,\ Hubei",
  861333994 => "Enshi\,\ Hubei",
  861333995 => "Huanggang\,\ Hubei",
  861333996 => "Huanggang\,\ Hubei",
  861333997 => "Huanggang\,\ Hubei",
  861333998 => "Wuhan\,\ Hubei",
  861333999 => "Wuhan\,\ Hubei",
  861334000 => "Xinyu\,\ Jiangxi",
  861334001 => "Nanchang\,\ Jiangxi",
  861334002 => "Jiujiang\,\ Jiangxi",
  861334003 => "Shangrao\,\ Jiangxi",
  861334004 => "Ganzhou\,\ Jiangxi",
  861334005 => "Yichun\,\ Jiangxi",
  861334006 => "JiAn\,\ Jiangxi",
  861334007 => "Jingdezhen\,\ Jiangxi",
  861334008 => "Shangrao\,\ Jiangxi",
  861334009 => "Yichun\,\ Jiangxi",
  861334010 => "Yingtan\,\ Jiangxi",
  861334011 => "Nanchang\,\ Jiangxi",
  861334012 => "Jiujiang\,\ Jiangxi",
  861334013 => "Shangrao\,\ Jiangxi",
  861334014 => "JiAn\,\ Jiangxi",
  861334015 => "Yichun\,\ Jiangxi",
  861334016 => "Pingxiang\,\ Jiangxi",
  861334017 => "Ganzhou\,\ Jiangxi",
  861334018 => "Fuzhou\,\ Jiangxi",
  861334019 => "Fuzhou\,\ Jiangxi",
  86133402 => "Chongqing",
  86133403 => "Chongqing",
  861334040 => "Fuzhou\,\ Fujian",
  861334041 => "Fuzhou\,\ Fujian",
  861334042 => "Fuzhou\,\ Fujian",
  861334043 => "Xiamen\,\ Fujian",
  861334044 => "Quanzhou\,\ Fujian",
  861334045 => "Quanzhou\,\ Fujian",
  861334046 => "Quanzhou\,\ Fujian",
  861334047 => "Ningde\,\ Fujian",
  861334048 => "Putian\,\ Fujian",
  861334049 => "Putian\,\ Fujian",
  861334050 => "Nanping\,\ Fujian",
  861334051 => "Nanping\,\ Fujian",
  861334052 => "Nanping\,\ Fujian",
  861334053 => "Nanping\,\ Fujian",
  861334054 => "Sanming\,\ Fujian",
  861334055 => "Sanming\,\ Fujian",
  861334056 => "Longyan\,\ Fujian",
  861334057 => "Longyan\,\ Fujian",
  861334058 => "Longyan\,\ Fujian",
  861334059 => "Longyan\,\ Fujian",
  861334060 => "YaAn\,\ Sichuan",
  861334061 => "Bazhong\,\ Sichuan",
  861334062 => "GuangAn\,\ Sichuan",
  861334063 => "Suining\,\ Sichuan",
  861334064 => "Suining\,\ Sichuan",
  861334065 => "Yibin\,\ Sichuan",
  861334066 => "Yibin\,\ Sichuan",
  861334067 => "Dazhou\,\ Sichuan",
  861334068 => "Ziyang\,\ Sichuan",
  861334069 => "Neijiang\,\ Sichuan",
  861334070 => "Neijiang\,\ Sichuan",
  861334071 => "Panzhihua\,\ Sichuan",
  861334072 => "Panzhihua\,\ Sichuan",
  861334073 => "Guangyuan\,\ Sichuan",
  861334074 => "Luzhou\,\ Sichuan",
  861334075 => "Guangyuan\,\ Sichuan",
  861334076 => "Nanchong\,\ Sichuan",
  861334077 => "Nanchong\,\ Sichuan",
  861334078 => "Luzhou\,\ Sichuan",
  861334079 => "Ziyang\,\ Sichuan",
  861334080 => "Zigong\,\ Sichuan",
  861334081 => "Zigong\,\ Sichuan",
  861334082 => "Dazhou\,\ Sichuan",
  861334083 => "Dazhou\,\ Sichuan",
  861334084 => "Ziyang\,\ Sichuan",
  861334085 => "Deyang\,\ Sichuan",
  861334086 => "Deyang\,\ Sichuan",
  861334087 => "Deyang\,\ Sichuan",
  861334088 => "Mianyang\,\ Sichuan",
  861334089 => "Mianyang\,\ Sichuan",
  861334090 => "Mianyang\,\ Sichuan",
  861334091 => "Leshan\,\ Sichuan",
  861334092 => "Leshan\,\ Sichuan",
  861334093 => "Meishan\,\ Sichuan",
  861334094 => "Chengdu\,\ Sichuan",
  861334095 => "Meishan\,\ Sichuan",
  861334096 => "Chengdu\,\ Sichuan",
  861334097 => "Liangshan\,\ Sichuan",
  861334098 => "Chengdu\,\ Sichuan",
  861334099 => "Chengdu\,\ Sichuan",
  86133410 => "Beijing",
  86133411 => "Beijing",
  861334120 => "Jining\,\ Shandong",
  861334121 => "Jining\,\ Shandong",
  861334122 => "Qingdao\,\ Shandong",
  861334123 => "Qingdao\,\ Shandong",
  861334124 => "Qingdao\,\ Shandong",
  861334125 => "Zibo\,\ Shandong",
  861334126 => "Zibo\,\ Shandong",
  861334127 => "Linyi\,\ Shandong",
  861334128 => "Linyi\,\ Shandong",
  861334129 => "Weifang\,\ Shandong",
  861334130 => "Yueyang\,\ Hunan",
  861334131 => "Changsha\,\ Hunan",
  861334132 => "Xiangtan\,\ Hunan",
  861334133 => "Zhuzhou\,\ Hunan",
  861334134 => "Hengyang\,\ Hunan",
  861334135 => "Chenzhou\,\ Hunan",
  861334136 => "Changde\,\ Hunan",
  861334137 => "Yiyang\,\ Hunan",
  861334138 => "Loudi\,\ Hunan",
  861334139 => "Shaoyang\,\ Hunan",
  86133414 => "Changchun\,\ Jilin",
  861334150 => "Jilin\,\ Jilin",
  861334151 => "Jilin\,\ Jilin",
  861334152 => "Yanbian\,\ Jilin",
  861334153 => "Yanbian\,\ Jilin",
  861334154 => "Jilin\,\ Jilin",
  861334155 => "Songyuan\,\ Jilin",
  861334156 => "Tonghua\,\ Jilin",
  861334157 => "Changchun\,\ Jilin",
  861334158 => "Changchun\,\ Jilin",
  861334159 => "Changchun\,\ Jilin",
  86133416 => "Shanghai",
  86133417 => "Shanghai",
  86133418 => "Shanghai",
  86133419 => "Shanghai",
  86133420 => "Tianjin",
  861334210 => "Anshan\,\ Liaoning",
  861334211 => "Anshan\,\ Liaoning",
  861334212 => "Fushun\,\ Liaoning",
  861334213 => "Fushun\,\ Liaoning",
  861334214 => "Benxi\,\ Liaoning",
  861334215 => "Benxi\,\ Liaoning",
  861334216 => "Dandong\,\ Liaoning",
  861334217 => "Dandong\,\ Liaoning",
  861334218 => "Jinzhou\,\ Liaoning",
  861334219 => "Jinzhou\,\ Liaoning",
  86133422 => "Dalian\,\ Liaoning",
  861334230 => "Yingkou\,\ Liaoning",
  861334231 => "Yingkou\,\ Liaoning",
  861334232 => "Fuxin\,\ Liaoning",
  861334233 => "Liaoyang\,\ Liaoning",
  861334234 => "Liaoyang\,\ Liaoning",
  861334235 => "Tieling\,\ Liaoning",
  861334236 => "Chaoyang\,\ Liaoning",
  861334237 => "Panjin\,\ Liaoning",
  861334238 => "Panjin\,\ Liaoning",
  861334239 => "Huludao\,\ Liaoning",
  86133424 => "Shenyang\,\ Liaoning",
  861334250 => "Yueyang\,\ Hunan",
  861334251 => "Changsha\,\ Hunan",
  861334252 => "Xiangtan\,\ Hunan",
  861334253 => "Zhuzhou\,\ Hunan",
  861334254 => "Hengyang\,\ Hunan",
  861334255 => "Chenzhou\,\ Hunan",
  861334256 => "Changde\,\ Hunan",
  861334257 => "Yiyang\,\ Hunan",
  861334258 => "Loudi\,\ Hunan",
  861334259 => "Shaoyang\,\ Hunan",
  86133426 => "Dongguan\,\ Guangdong",
  861334270 => "Shantou\,\ Guangdong",
  861334271 => "Shantou\,\ Guangdong",
  861334272 => "Shantou\,\ Guangdong",
  861334273 => "Shantou\,\ Guangdong",
  861334274 => "Shantou\,\ Guangdong",
  861334275 => "Shantou\,\ Guangdong",
  861334276 => "Shantou\,\ Guangdong",
  861334277 => "Shantou\,\ Guangdong",
  861334278 => "Chaozhou\,\ Guangdong",
  861334279 => "Chaozhou\,\ Guangdong",
  86133428 => "Guangzhou\,\ Guangdong",
  86133429 => "Shenzhen\,\ Guangdong",
  861334300 => "Handan\,\ Hebei",
  861334301 => "Shijiazhuang\,\ Hebei",
  861334302 => "Baoding\,\ Hebei",
  861334303 => "Shijiazhuang\,\ Hebei",
  861334304 => "Shijiazhuang\,\ Hebei",
  861334305 => "Tangshan\,\ Hebei",
  861334306 => "Langfang\,\ Hebei",
  861334307 => "Cangzhou\,\ Hebei",
  861334308 => "Baoding\,\ Hebei",
  861334309 => "Baoding\,\ Hebei",
  861334310 => "Handan\,\ Hebei",
  861334311 => "Shijiazhuang\,\ Hebei",
  861334312 => "Baoding\,\ Hebei",
  861334313 => "Zhangjiakou\,\ Hebei",
  861334314 => "Chengde\,\ Hebei",
  861334315 => "Tangshan\,\ Hebei",
  861334316 => "Langfang\,\ Hebei",
  861334317 => "Cangzhou\,\ Hebei",
  861334318 => "Hengshui\,\ Hebei",
  861334319 => "Xingtai\,\ Hebei",
  861334320 => "Handan\,\ Hebei",
  861334321 => "Shijiazhuang\,\ Hebei",
  861334322 => "Baoding\,\ Hebei",
  861334323 => "Shijiazhuang\,\ Hebei",
  861334324 => "Shijiazhuang\,\ Hebei",
  861334325 => "Tangshan\,\ Hebei",
  861334326 => "Langfang\,\ Hebei",
  861334327 => "Cangzhou\,\ Hebei",
  861334328 => "Qinhuangdao\,\ Hebei",
  861334329 => "Tangshan\,\ Hebei",
  861334330 => "Handan\,\ Hebei",
  861334331 => "Shijiazhuang\,\ Hebei",
  861334332 => "Baoding\,\ Hebei",
  861334333 => "Qinhuangdao\,\ Hebei",
  861334334 => "Qinhuangdao\,\ Hebei",
  861334335 => "Qinhuangdao\,\ Hebei",
  861334336 => "Langfang\,\ Hebei",
  861334337 => "Cangzhou\,\ Hebei",
  861334338 => "Chengde\,\ Hebei",
  861334339 => "Chengde\,\ Hebei",
  86133434 => "Wuhan\,\ Hubei",
  861334350 => "Jingzhou\,\ Hubei",
  861334351 => "Jingzhou\,\ Hubei",
  861334352 => "Wuhan\,\ Hubei",
  861334353 => "Yichang\,\ Hubei",
  861334354 => "Yichang\,\ Hubei",
  861334355 => "Enshi\,\ Hubei",
  861334356 => "Xiangfan\,\ Hubei",
  861334357 => "Xiangfan\,\ Hubei",
  861334358 => "Wuhan\,\ Hubei",
  861334359 => "Shiyan\,\ Hubei",
  861334360 => "Shangqiu\,\ Henan",
  861334361 => "Jiaozuo\,\ Henan",
  861334362 => "Jiaozuo\,\ Henan",
  861334363 => "Puyang\,\ Henan",
  861334364 => "Zhumadian\,\ Henan",
  861334365 => "Kaifeng\,\ Henan",
  861334366 => "Sanmenxia\,\ Henan",
  861334367 => "Luohe\,\ Henan",
  861334368 => "Anyang\,\ Henan",
  861334369 => "Nanyang\,\ Henan",
  861334370 => "Shangqiu\,\ Henan",
  861334371 => "Zhengzhou\,\ Henan",
  861334372 => "Anyang\,\ Henan",
  861334373 => "Xinxiang\,\ Henan",
  861334374 => "Xuchang\,\ Henan",
  861334375 => "Pingdingshan\,\ Henan",
  861334376 => "Xinyang\,\ Henan",
  861334377 => "Nanyang\,\ Henan",
  861334378 => "Kaifeng\,\ Henan",
  861334379 => "Luoyang\,\ Henan",
  861334380 => "Xinxiang\,\ Henan",
  861334381 => "Zhengzhou\,\ Henan",
  861334382 => "Zhengzhou\,\ Henan",
  861334383 => "Zhengzhou\,\ Henan",
  861334384 => "Zhengzhou\,\ Henan",
  861334385 => "Zhengzhou\,\ Henan",
  861334386 => "Zhengzhou\,\ Henan",
  861334387 => "Luoyang\,\ Henan",
  861334388 => "Luoyang\,\ Henan",
  861334389 => "Luoyang\,\ Henan",
  861334390 => "Pingdingshan\,\ Henan",
  861334391 => "Jiaozuo\,\ Henan",
  861334392 => "Hebi\,\ Henan",
  861334393 => "Puyang\,\ Henan",
  861334394 => "Zhoukou\,\ Henan",
  861334395 => "Luohe\,\ Henan",
  861334396 => "Zhumadian\,\ Henan",
  861334397 => "Xinyang\,\ Henan",
  861334398 => "Sanmenxia\,\ Henan",
  861334399 => "Pingdingshan\,\ Henan",
  861334400 => "Pingdingshan\,\ Henan",
  861334401 => "Chongqing",
  861334402 => "Chongqing",
  861334403 => "Chongqing",
  861334410 => "Beijing",
  861334411 => "Beijing",
  861334416 => "Changchun\,\ Jilin",
  861334418 => "Shanghai",
  861334419 => "Shanghai",
  86133443 => "Tianjin",
  861334444 => "Beijing",
  861334445 => "Qingdao\,\ Shandong",
  86133446 => "Dezhou\,\ Shandong",
  861334500 => "Qingdao\,\ Shandong",
  861334501 => "Qingdao\,\ Shandong",
  861334502 => "Qingdao\,\ Shandong",
  861334503 => "Dongying\,\ Shandong",
  861334504 => "Dongying\,\ Shandong",
  861334505 => "Dongying\,\ Shandong",
  861334506 => "Dongying\,\ Shandong",
  861334507 => "Linyi\,\ Shandong",
  861334508 => "Linyi\,\ Shandong",
  861334509 => "Linyi\,\ Shandong",
  861334510 => "Jinan\,\ Shandong",
  861334511 => "Jinan\,\ Shandong",
  861334512 => "Jinan\,\ Shandong",
  861334513 => "Jinan\,\ Shandong",
  861334514 => "Yantai\,\ Shandong",
  861334515 => "Yantai\,\ Shandong",
  861334516 => "Yantai\,\ Shandong",
  861334517 => "Jining\,\ Shandong",
  861334518 => "Jining\,\ Shandong",
  861334519 => "Jining\,\ Shandong",
  861334520 => "Zibo\,\ Shandong",
  861334521 => "Zibo\,\ Shandong",
  861334522 => "Zibo\,\ Shandong",
  861334523 => "Zibo\,\ Shandong",
  861334524 => "Weifang\,\ Shandong",
  861334525 => "Weifang\,\ Shandong",
  861334526 => "Weifang\,\ Shandong",
  861334527 => "TaiAn\,\ Shandong",
  861334528 => "TaiAn\,\ Shandong",
  861334529 => "TaiAn\,\ Shandong",
  861334530 => "Tacheng\,\ Xinjiang",
  861334531 => "Altay\,\ Xinjiang",
  861334532 => "Bayingolin\,\ Xinjiang",
  861334533 => "Bayingolin\,\ Xinjiang",
  861334534 => "Kashi\,\ Xinjiang",
  861334535 => "Aksu\,\ Xinjiang",
  861334536 => "Aksu\,\ Xinjiang",
  861334537 => "Kizilsu\,\ Xinjiang",
  861334538 => "Hotan\,\ Xinjiang",
  861334539 => "Changji\,\ Xinjiang",
  861334540 => "Changji\,\ Xinjiang",
  861334541 => "Changji\,\ Xinjiang",
  861334542 => "Turpan\,\ Xinjiang",
  861334543 => "Hami\,\ Xinjiang",
  861334544 => "Urumchi\,\ Xinjiang",
  861334545 => "Bayingolin\,\ Xinjiang",
  861334546 => "Shihezi\,\ Xinjiang",
  861334547 => "Karamay\,\ Xinjiang",
  861334548 => "Ili\,\ Xinjiang",
  861334549 => "Bortala\,\ Xinjiang",
  861334550 => "Chuzhou\,\ Anhui",
  861334551 => "Hefei\,\ Anhui",
  861334552 => "Bengbu\,\ Anhui",
  861334553 => "Wuhu\,\ Anhui",
  861334554 => "Huainan\,\ Anhui",
  861334555 => "MaAnshan\,\ Anhui",
  861334556 => "Anqing\,\ Anhui",
  861334557 => "Suzhou\,\ Anhui",
  861334558 => "Fuyang\,\ Anhui",
  861334559 => "Huangshan\,\ Anhui",
  861334560 => "Huaibei\,\ Anhui",
  861334561 => "Huaibei\,\ Anhui",
  861334562 => "Tongling\,\ Anhui",
  861334563 => "Xuancheng\,\ Anhui",
  861334564 => "LuAn\,\ Anhui",
  861334565 => "Chaohu\,\ Anhui",
  861334566 => "Chizhou\,\ Anhui",
  861334567 => "Bozhou\,\ Anhui",
  861334568 => "Bozhou\,\ Anhui",
  861334569 => "Huangshan\,\ Anhui",
  861334570 => "Quzhou\,\ Zhejiang",
  861334571 => "Hangzhou\,\ Zhejiang",
  861334572 => "Huzhou\,\ Zhejiang",
  861334573 => "Jiaxing\,\ Zhejiang",
  861334574 => "Ningbo\,\ Zhejiang",
  861334575 => "Shaoxing\,\ Zhejiang",
  861334576 => "Taizhou\,\ Zhejiang",
  861334577 => "Wenzhou\,\ Zhejiang",
  861334578 => "Lishui\,\ Zhejiang",
  861334579 => "Jinhua\,\ Zhejiang",
  861334580 => "Zhoushan\,\ Zhejiang",
  861334581 => "Hangzhou\,\ Zhejiang",
  861334582 => "Huzhou\,\ Zhejiang",
  861334583 => "Jiaxing\,\ Zhejiang",
  861334584 => "Ningbo\,\ Zhejiang",
  861334585 => "Shaoxing\,\ Zhejiang",
  861334586 => "Taizhou\,\ Zhejiang",
  861334587 => "Wenzhou\,\ Zhejiang",
  861334588 => "Wenzhou\,\ Zhejiang",
  861334589 => "Jinhua\,\ Zhejiang",
  861334590 => "Jinhua\,\ Zhejiang",
  861334591 => "Jinhua\,\ Zhejiang",
  861334592 => "Jinhua\,\ Zhejiang",
  861334593 => "Jinhua\,\ Zhejiang",
  861334594 => "Jinhua\,\ Zhejiang",
  861334595 => "Ningbo\,\ Zhejiang",
  861334596 => "Ningbo\,\ Zhejiang",
  861334597 => "Ningbo\,\ Zhejiang",
  861334598 => "Ningbo\,\ Zhejiang",
  861334599 => "Ningbo\,\ Zhejiang",
  861334600 => "Jiaxing\,\ Zhejiang",
  861334601 => "Jiaxing\,\ Zhejiang",
  861334602 => "Shaoxing\,\ Zhejiang",
  861334603 => "Shaoxing\,\ Zhejiang",
  861334604 => "Shaoxing\,\ Zhejiang",
  861334605 => "Shaoxing\,\ Zhejiang",
  861334606 => "Lishui\,\ Zhejiang",
  861334607 => "Lishui\,\ Zhejiang",
  861334608 => "Wenzhou\,\ Zhejiang",
  861334609 => "Wenzhou\,\ Zhejiang",
  861334610 => "Taizhou\,\ Zhejiang",
  861334611 => "Taizhou\,\ Zhejiang",
  861334612 => "Taizhou\,\ Zhejiang",
  861334613 => "Taizhou\,\ Zhejiang",
  861334614 => "Taizhou\,\ Zhejiang",
  861334615 => "Hangzhou\,\ Zhejiang",
  861334616 => "Hangzhou\,\ Zhejiang",
  861334617 => "Hangzhou\,\ Zhejiang",
  861334618 => "Hangzhou\,\ Zhejiang",
  861334619 => "Hangzhou\,\ Zhejiang",
  861334620 => "Heze\,\ Shandong",
  861334621 => "Heze\,\ Shandong",
  861334622 => "Liaocheng\,\ Shandong",
  861334623 => "Rizhao\,\ Shandong",
  861334624 => "Weihai\,\ Shandong",
  861334625 => "Liaocheng\,\ Shandong",
  861334626 => "Dezhou\,\ Shandong",
  861334627 => "Dezhou\,\ Shandong",
  861334628 => "Binzhou\,\ Shandong",
  861334629 => "Binzhou\,\ Shandong",
  861334630 => "Weihai\,\ Shandong",
  861334631 => "Weihai\,\ Shandong",
  861334632 => "Zaozhuang\,\ Shandong",
  861334633 => "Rizhao\,\ Shandong",
  861334634 => "Laiwu\,\ Shandong",
  861334635 => "Liaocheng\,\ Shandong",
  861334636 => "Weifang\,\ Shandong",
  861334637 => "Zaozhuang\,\ Shandong",
  861334638 => "Yantai\,\ Shandong",
  861334639 => "Qingdao\,\ Shandong",
  861334640 => "Zhuhai\,\ Guangdong",
  861334641 => "Zhuhai\,\ Guangdong",
  861334642 => "Zhuhai\,\ Guangdong",
  861334643 => "Zhongshan\,\ Guangdong",
  861334644 => "Zhongshan\,\ Guangdong",
  861334645 => "Zhongshan\,\ Guangdong",
  861334646 => "Zhongshan\,\ Guangdong",
  861334647 => "Zhongshan\,\ Guangdong",
  861334648 => "Zhongshan\,\ Guangdong",
  861334649 => "Zhongshan\,\ Guangdong",
  861334650 => "Shaoguan\,\ Guangdong",
  861334651 => "Shaoguan\,\ Guangdong",
  861334652 => "Shaoguan\,\ Guangdong",
  861334653 => "Shaoguan\,\ Guangdong",
  861334654 => "Qingyuan\,\ Guangdong",
  861334655 => "Qingyuan\,\ Guangdong",
  861334656 => "Zhaoqing\,\ Guangdong",
  861334657 => "Zhaoqing\,\ Guangdong",
  861334658 => "Yunfu\,\ Guangdong",
  861334659 => "Yunfu\,\ Guangdong",
  861334660 => "Shangqiu\,\ Henan",
  861334661 => "Shangqiu\,\ Henan",
  861334662 => "Shangqiu\,\ Henan",
  861334663 => "Anyang\,\ Henan",
  861334664 => "Anyang\,\ Henan",
  861334665 => "Anyang\,\ Henan",
  861334666 => "Xinxiang\,\ Henan",
  861334667 => "Xinxiang\,\ Henan",
  861334668 => "Xinxiang\,\ Henan",
  861334669 => "Xuchang\,\ Henan",
  861334670 => "Xuchang\,\ Henan",
  861334671 => "Pingdingshan\,\ Henan",
  861334672 => "Pingdingshan\,\ Henan",
  861334673 => "Pingdingshan\,\ Henan",
  861334674 => "Xinyang\,\ Henan",
  861334675 => "Xinyang\,\ Henan",
  861334676 => "Xinyang\,\ Henan",
  861334677 => "Kaifeng\,\ Henan",
  861334678 => "Jiaozuo\,\ Henan",
  861334679 => "Jiaozuo\,\ Henan",
  861334680 => "Hebi\,\ Henan",
  861334681 => "Puyang\,\ Henan",
  861334682 => "Puyang\,\ Henan",
  861334683 => "Zhoukou\,\ Henan",
  861334684 => "Zhoukou\,\ Henan",
  861334685 => "Zhoukou\,\ Henan",
  861334686 => "Luohe\,\ Henan",
  861334687 => "Luohe\,\ Henan",
  861334688 => "Zhumadian\,\ Henan",
  861334689 => "Zhumadian\,\ Henan",
  861334690 => "Zhumadian\,\ Henan",
  861334691 => "Sanmenxia\,\ Henan",
  861334692 => "Sanmenxia\,\ Henan",
  861334693 => "Zhengzhou\,\ Henan",
  861334694 => "Zhengzhou\,\ Henan",
  861334695 => "Zhengzhou\,\ Henan",
  861334696 => "Nanyang\,\ Henan",
  861334697 => "Nanyang\,\ Henan",
  861334698 => "Luoyang\,\ Henan",
  861334699 => "Luoyang\,\ Henan",
  861334700 => "Hulun\,\ Inner\ Mongolia",
  861334701 => "Hulun\,\ Inner\ Mongolia",
  861334702 => "Hulun\,\ Inner\ Mongolia",
  861334703 => "Hulun\,\ Inner\ Mongolia",
  861334704 => "Hulun\,\ Inner\ Mongolia",
  861334705 => "Tongliao\,\ Inner\ Mongolia",
  861334706 => "Ordos\,\ Inner\ Mongolia",
  861334707 => "Baotou\,\ Inner\ Mongolia",
  861334708 => "Baotou\,\ Inner\ Mongolia",
  861334709 => "Baotou\,\ Inner\ Mongolia",
  861334710 => "Hohhot\,\ Inner\ Mongolia",
  861334711 => "Hohhot\,\ Inner\ Mongolia",
  861334712 => "Hohhot\,\ Inner\ Mongolia",
  861334713 => "Hohhot\,\ Inner\ Mongolia",
  861334714 => "Hohhot\,\ Inner\ Mongolia",
  861334715 => "Hohhot\,\ Inner\ Mongolia",
  861334716 => "Hohhot\,\ Inner\ Mongolia",
  861334717 => "Baotou\,\ Inner\ Mongolia",
  861334718 => "Baotou\,\ Inner\ Mongolia",
  861334719 => "Baotou\,\ Inner\ Mongolia",
  861334720 => "Yueyang\,\ Hunan",
  861334721 => "Changsha\,\ Hunan",
  861334722 => "Xiangtan\,\ Hunan",
  861334723 => "Zhuzhou\,\ Hunan",
  861334724 => "Hengyang\,\ Hunan",
  861334725 => "Chenzhou\,\ Hunan",
  861334726 => "Changde\,\ Hunan",
  861334727 => "Yiyang\,\ Hunan",
  861334728 => "Loudi\,\ Hunan",
  861334729 => "Shaoyang\,\ Hunan",
  861334730 => "Yueyang\,\ Hunan",
  861334731 => "Changsha\,\ Hunan",
  861334732 => "Xiangtan\,\ Hunan",
  861334733 => "Zhuzhou\,\ Hunan",
  861334734 => "Hengyang\,\ Hunan",
  861334735 => "Chenzhou\,\ Hunan",
  861334736 => "Changde\,\ Hunan",
  861334737 => "Yiyang\,\ Hunan",
  861334738 => "Loudi\,\ Hunan",
  861334739 => "Shaoyang\,\ Hunan",
  861334740 => "XiAn\,\ Shaanxi",
  861334741 => "XiAn\,\ Shaanxi",
  861334742 => "XiAn\,\ Shaanxi",
  861334743 => "XiAn\,\ Shaanxi",
  861334744 => "Xianyang\,\ Shaanxi",
  861334745 => "Weinan\,\ Shaanxi",
  861334746 => "Baoji\,\ Shaanxi",
  861334747 => "Hanzhong\,\ Shaanxi",
  861334748 => "Yulin\,\ Shaanxi",
  861334749 => "Ankang\,\ Shaanxi",
  861334750 => "Nanning\,\ Guangxi",
  861334751 => "Nanning\,\ Guangxi",
  861334752 => "Liuzhou\,\ Guangxi",
  861334753 => "Guilin\,\ Guangxi",
  861334754 => "Hezhou\,\ Guangxi",
  861334755 => "Yulin\,\ Guangxi",
  861334756 => "Guilin\,\ Guangxi",
  861334757 => "Guigang\,\ Guangxi",
  861334758 => "Hezhou\,\ Guangxi",
  861334759 => "Beihai\,\ Guangxi",
  861334760 => "Nanning\,\ Guangxi",
  861334761 => "Nanning\,\ Guangxi",
  861334762 => "Liuzhou\,\ Guangxi",
  861334763 => "Guilin\,\ Guangxi",
  861334764 => "Wuzhou\,\ Guangxi",
  861334765 => "Yulin\,\ Guangxi",
  861334766 => "Baise\,\ Guangxi",
  861334767 => "Guigang\,\ Guangxi",
  861334768 => "Hechi\,\ Guangxi",
  861334769 => "Beihai\,\ Guangxi",
  861334770 => "Nanjing\,\ Jiangsu",
  861334771 => "Nanjing\,\ Jiangsu",
  861334772 => "Nanjing\,\ Jiangsu",
  861334773 => "Nanjing\,\ Jiangsu",
  861334774 => "Zhenjiang\,\ Jiangsu",
  861334775 => "Zhenjiang\,\ Jiangsu",
  861334776 => "Zhenjiang\,\ Jiangsu",
  861334777 => "Zhenjiang\,\ Jiangsu",
  861334778 => "Taizhou\,\ Jiangsu",
  861334779 => "Taizhou\,\ Jiangsu",
  861334780 => "Nanjing\,\ Jiangsu",
  861334781 => "Nanjing\,\ Jiangsu",
  861334782 => "Nanjing\,\ Jiangsu",
  861334783 => "Nanjing\,\ Jiangsu",
  861334784 => "Suqian\,\ Jiangsu",
  861334785 => "Suqian\,\ Jiangsu",
  861334786 => "Lianyungang\,\ Jiangsu",
  861334787 => "Lianyungang\,\ Jiangsu",
  861334788 => "Changzhou\,\ Jiangsu",
  861334789 => "Changzhou\,\ Jiangsu",
  861334790 => "Wuxi\,\ Jiangsu",
  861334791 => "Wuxi\,\ Jiangsu",
  861334792 => "Wuxi\,\ Jiangsu",
  861334793 => "Xuzhou\,\ Jiangsu",
  861334794 => "Xuzhou\,\ Jiangsu",
  861334795 => "Xuzhou\,\ Jiangsu",
  861334796 => "HuaiAn\,\ Jiangsu",
  861334797 => "HuaiAn\,\ Jiangsu",
  861334798 => "Yancheng\,\ Jiangsu",
  861334799 => "Yancheng\,\ Jiangsu",
  861334800 => "Suzhou\,\ Jiangsu",
  861334801 => "Suzhou\,\ Jiangsu",
  861334802 => "Suzhou\,\ Jiangsu",
  861334803 => "Suzhou\,\ Jiangsu",
  861334804 => "Suzhou\,\ Jiangsu",
  861334805 => "Suzhou\,\ Jiangsu",
  861334806 => "Nantong\,\ Jiangsu",
  861334807 => "Nantong\,\ Jiangsu",
  861334808 => "Nantong\,\ Jiangsu",
  861334809 => "Nantong\,\ Jiangsu",
  861334810 => "Wuxi\,\ Jiangsu",
  861334811 => "Wuxi\,\ Jiangsu",
  861334812 => "Yangzhou\,\ Jiangsu",
  861334813 => "Yangzhou\,\ Jiangsu",
  861334814 => "Yangzhou\,\ Jiangsu",
  861334815 => "Wuxi\,\ Jiangsu",
  861334816 => "Changzhou\,\ Jiangsu",
  861334817 => "Changzhou\,\ Jiangsu",
  861334818 => "Changzhou\,\ Jiangsu",
  861334819 => "Changzhou\,\ Jiangsu",
  86133482 => "Fuzhou\,\ Fujian",
  861334830 => "Putian\,\ Fujian",
  861334831 => "Putian\,\ Fujian",
  861334832 => "Putian\,\ Fujian",
  861334833 => "Sanming\,\ Fujian",
  861334834 => "Longyan\,\ Fujian",
  861334835 => "Longyan\,\ Fujian",
  861334836 => "Longyan\,\ Fujian",
  861334837 => "Xiamen\,\ Fujian",
  861334838 => "Xiamen\,\ Fujian",
  861334839 => "Xiamen\,\ Fujian",
  861334840 => "Ningde\,\ Fujian",
  861334841 => "Ningde\,\ Fujian",
  861334842 => "Ningde\,\ Fujian",
  861334843 => "Sanming\,\ Fujian",
  861334844 => "Sanming\,\ Fujian",
  861334845 => "Zhangzhou\,\ Fujian",
  861334846 => "Zhangzhou\,\ Fujian",
  861334847 => "Zhangzhou\,\ Fujian",
  861334848 => "Zhangzhou\,\ Fujian",
  861334849 => "Zhangzhou\,\ Fujian",
  861334850 => "Quanzhou\,\ Fujian",
  861334851 => "Quanzhou\,\ Fujian",
  861334852 => "Quanzhou\,\ Fujian",
  861334853 => "Quanzhou\,\ Fujian",
  861334854 => "Quanzhou\,\ Fujian",
  861334855 => "Quanzhou\,\ Fujian",
  861334856 => "Quanzhou\,\ Fujian",
  861334857 => "Quanzhou\,\ Fujian",
  861334858 => "Nanping\,\ Fujian",
  861334859 => "Nanping\,\ Fujian",
  861334860 => "Yueyang\,\ Hunan",
  861334861 => "Changsha\,\ Hunan",
  861334862 => "Xiangtan\,\ Hunan",
  861334863 => "Zhuzhou\,\ Hunan",
  861334864 => "Hengyang\,\ Hunan",
  861334865 => "Chenzhou\,\ Hunan",
  861334866 => "Changde\,\ Hunan",
  861334867 => "Changsha\,\ Hunan",
  861334868 => "Changsha\,\ Hunan",
  861334869 => "Changsha\,\ Hunan",
  861334870 => "Yueyang\,\ Hunan",
  861334871 => "Changsha\,\ Hunan",
  861334872 => "Xiangtan\,\ Hunan",
  861334873 => "Xiangxi\,\ Hunan",
  861334874 => "Zhangjiajie\,\ Hunan",
  861334875 => "Huaihua\,\ Hunan",
  861334876 => "Yongzhou\,\ Hunan",
  861334877 => "Yiyang\,\ Hunan",
  861334878 => "Loudi\,\ Hunan",
  861334879 => "Shaoyang\,\ Hunan",
  86133488 => "Chengdu\,\ Sichuan",
  86133489 => "Chengdu\,\ Sichuan",
  861334900 => "LuAn\,\ Anhui",
  861334901 => "Hefei\,\ Anhui",
  861334902 => "Bengbu\,\ Anhui",
  861334903 => "Wuhu\,\ Anhui",
  861334904 => "Bozhou\,\ Anhui",
  861334905 => "MaAnshan\,\ Anhui",
  861334906 => "Anqing\,\ Anhui",
  861334907 => "Anqing\,\ Anhui",
  861334908 => "Fuyang\,\ Anhui",
  861334909 => "Hefei\,\ Anhui",
  861334910 => "Fuyang\,\ Anhui",
  861334911 => "Hefei\,\ Anhui",
  861334912 => "LuAn\,\ Anhui",
  861334913 => "Xuancheng\,\ Anhui",
  861334914 => "Chizhou\,\ Anhui",
  861334915 => "Chaohu\,\ Anhui",
  861334916 => "Chaohu\,\ Anhui",
  861334917 => "Bozhou\,\ Anhui",
  861334918 => "Hefei\,\ Anhui",
  861334919 => "Hefei\,\ Anhui",
  861334920 => "Hefei\,\ Anhui",
  861334921 => "Wuhu\,\ Anhui",
  861334922 => "Bengbu\,\ Anhui",
  861334923 => "Wuhu\,\ Anhui",
  861334924 => "Chaohu\,\ Anhui",
  861334925 => "Chuzhou\,\ Anhui",
  861334926 => "Anqing\,\ Anhui",
  861334927 => "Bozhou\,\ Anhui",
  861334928 => "Fuyang\,\ Anhui",
  861334929 => "Hefei\,\ Anhui",
  861334930 => "Harbin\,\ Heilongjiang",
  861334931 => "Harbin\,\ Heilongjiang",
  861334932 => "Qitaihe\,\ Heilongjiang",
  861334933 => "Shuangyashan\,\ Heilongjiang",
  861334934 => "Shuangyashan\,\ Heilongjiang",
  861334935 => "Suihua\,\ Heilongjiang",
  861334936 => "Heihe\,\ Heilongjiang",
  861334937 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861334938 => "Yichun\,\ Heilongjiang",
  861334939 => "Daqing\,\ Heilongjiang",
  861334940 => "Harbin\,\ Heilongjiang",
  861334941 => "Harbin\,\ Heilongjiang",
  861334942 => "Qiqihar\,\ Heilongjiang",
  861334943 => "Mudanjiang\,\ Heilongjiang",
  861334944 => "Jiamusi\,\ Heilongjiang",
  861334945 => "Suihua\,\ Heilongjiang",
  861334946 => "Heihe\,\ Heilongjiang",
  861334947 => "Daqing\,\ Heilongjiang",
  861334948 => "Hegang\,\ Heilongjiang",
  861334949 => "Daqing\,\ Heilongjiang",
  861334950 => "Daqing\,\ Heilongjiang",
  861334951 => "Harbin\,\ Heilongjiang",
  861334952 => "Qiqihar\,\ Heilongjiang",
  861334953 => "Mudanjiang\,\ Heilongjiang",
  861334954 => "Jiamusi\,\ Heilongjiang",
  861334955 => "Jiamusi\,\ Heilongjiang",
  861334956 => "Jixi\,\ Heilongjiang",
  861334957 => "Jixi\,\ Heilongjiang",
  861334958 => "Hegang\,\ Heilongjiang",
  861334959 => "Daqing\,\ Heilongjiang",
  861334960 => "Changsha\,\ Hunan",
  861334961 => "Huaihua\,\ Hunan",
  861334962 => "Changde\,\ Hunan",
  861334963 => "Xiangxi\,\ Hunan",
  861334964 => "Zhangjiajie\,\ Hunan",
  861334965 => "Huaihua\,\ Hunan",
  861334966 => "Yongzhou\,\ Hunan",
  861334967 => "Chenzhou\,\ Hunan",
  861334968 => "Loudi\,\ Hunan",
  861334969 => "Shaoyang\,\ Hunan",
  861334970 => "Wuhan\,\ Hubei",
  861334971 => "Wuhan\,\ Hubei",
  861334972 => "Wuhan\,\ Hubei",
  861334973 => "Jingzhou\,\ Hubei",
  861334974 => "Jingzhou\,\ Hubei",
  861334975 => "Jingzhou\,\ Hubei",
  861334976 => "Yichang\,\ Hubei",
  861334977 => "Yichang\,\ Hubei",
  861334978 => "Yichang\,\ Hubei",
  861334979 => "Shiyan\,\ Hubei",
  861334980 => "Xiangfan\,\ Hubei",
  861334981 => "Xiaogan\,\ Hubei",
  861334982 => "Huangshi\,\ Hubei",
  861334983 => "Wuhan\,\ Hubei",
  861334984 => "Wuhan\,\ Hubei",
  861334985 => "Wuhan\,\ Hubei",
  861334986 => "Wuhan\,\ Hubei",
  861334987 => "Wuhan\,\ Hubei",
  861334988 => "Wuhan\,\ Hubei",
  861334989 => "Wuhan\,\ Hubei",
  86133499 => "Wuhan\,\ Hubei",
  861335000 => "Mianyang\,\ Sichuan",
  861335001 => "Mianyang\,\ Sichuan",
  861335002 => "Mianyang\,\ Sichuan",
  861335003 => "Guangyuan\,\ Sichuan",
  861335004 => "Deyang\,\ Sichuan",
  861335005 => "Chengdu\,\ Sichuan",
  861335006 => "Chengdu\,\ Sichuan",
  861335007 => "Chengdu\,\ Sichuan",
  861335008 => "Chengdu\,\ Sichuan",
  861335009 => "Chengdu\,\ Sichuan",
  861335010 => "Zigong\,\ Sichuan",
  861335011 => "Zigong\,\ Sichuan",
  861335012 => "Ziyang\,\ Sichuan",
  861335013 => "Luzhou\,\ Sichuan",
  861335014 => "Luzhou\,\ Sichuan",
  861335015 => "Neijiang\,\ Sichuan",
  861335016 => "Neijiang\,\ Sichuan",
  861335017 => "Yibin\,\ Sichuan",
  861335018 => "Yibin\,\ Sichuan",
  861335019 => "Yibin\,\ Sichuan",
  861335020 => "Suining\,\ Sichuan",
  861335021 => "Suining\,\ Sichuan",
  861335022 => "GuangAn\,\ Sichuan",
  861335023 => "Bazhong\,\ Sichuan",
  861335024 => "Yibin\,\ Sichuan",
  861335025 => "Nanchong\,\ Sichuan",
  861335026 => "Nanchong\,\ Sichuan",
  861335027 => "Nanchong\,\ Sichuan",
  861335028 => "Dazhou\,\ Sichuan",
  861335029 => "Dazhou\,\ Sichuan",
  86133503 => "Chongqing",
  861335040 => "Nanchong\,\ Sichuan",
  861335041 => "Leshan\,\ Sichuan",
  861335042 => "YaAn\,\ Sichuan",
  861335043 => "Meishan\,\ Sichuan",
  861335044 => "Aba\,\ Sichuan",
  861335045 => "Garze\,\ Sichuan",
  861335046 => "GuangAn\,\ Sichuan",
  861335047 => "Bazhong\,\ Sichuan",
  861335048 => "Dazhou\,\ Sichuan",
  861335049 => "Guangyuan\,\ Sichuan",
  861335050 => "Leshan\,\ Sichuan",
  861335051 => "Leshan\,\ Sichuan",
  861335052 => "Meishan\,\ Sichuan",
  861335053 => "Meishan\,\ Sichuan",
  861335054 => "Panzhihua\,\ Sichuan",
  861335055 => "Panzhihua\,\ Sichuan",
  861335056 => "YaAn\,\ Sichuan",
  861335057 => "Liangshan\,\ Sichuan",
  861335058 => "Deyang\,\ Sichuan",
  861335059 => "Deyang\,\ Sichuan",
  861335060 => "Yibin\,\ Sichuan",
  861335061 => "Yibin\,\ Sichuan",
  861335062 => "Suining\,\ Sichuan",
  861335063 => "Nanchong\,\ Sichuan",
  861335064 => "Nanchong\,\ Sichuan",
  861335065 => "Nanchong\,\ Sichuan",
  861335066 => "Nanchong\,\ Sichuan",
  861335067 => "Zigong\,\ Sichuan",
  861335068 => "Zigong\,\ Sichuan",
  861335069 => "Ziyang\,\ Sichuan",
  861335070 => "Meishan\,\ Sichuan",
  861335071 => "Meishan\,\ Sichuan",
  861335072 => "Leshan\,\ Sichuan",
  861335073 => "Leshan\,\ Sichuan",
  861335074 => "Leshan\,\ Sichuan",
  861335075 => "Leshan\,\ Sichuan",
  861335076 => "Leshan\,\ Sichuan",
  861335077 => "Dazhou\,\ Sichuan",
  861335078 => "Dazhou\,\ Sichuan",
  861335079 => "Dazhou\,\ Sichuan",
  861335080 => "Deyang\,\ Sichuan",
  861335081 => "Luzhou\,\ Sichuan",
  861335082 => "Chengdu\,\ Sichuan",
  861335083 => "Chengdu\,\ Sichuan",
  861335084 => "Chengdu\,\ Sichuan",
  861335085 => "Chengdu\,\ Sichuan",
  861335086 => "Chengdu\,\ Sichuan",
  861335087 => "Chengdu\,\ Sichuan",
  861335088 => "Chengdu\,\ Sichuan",
  861335089 => "Chengdu\,\ Sichuan",
  861335090 => "GuangAn\,\ Sichuan",
  861335091 => "GuangAn\,\ Sichuan",
  861335092 => "Bazhong\,\ Sichuan",
  861335093 => "Bazhong\,\ Sichuan",
  861335094 => "Mianyang\,\ Sichuan",
  861335095 => "Mianyang\,\ Sichuan",
  861335096 => "Mianyang\,\ Sichuan",
  861335097 => "Mianyang\,\ Sichuan",
  861335098 => "Mianyang\,\ Sichuan",
  861335099 => "Mianyang\,\ Sichuan",
  861335100 => "Harbin\,\ Heilongjiang",
  861335101 => "Harbin\,\ Heilongjiang",
  861335102 => "Qiqihar\,\ Heilongjiang",
  861335103 => "Mudanjiang\,\ Heilongjiang",
  861335104 => "Shuangyashan\,\ Heilongjiang",
  861335105 => "Shuangyashan\,\ Heilongjiang",
  861335106 => "Shuangyashan\,\ Heilongjiang",
  861335107 => "Jixi\,\ Heilongjiang",
  861335108 => "Yichun\,\ Heilongjiang",
  861335109 => "Daqing\,\ Heilongjiang",
  861335110 => "Harbin\,\ Heilongjiang",
  861335111 => "Harbin\,\ Heilongjiang",
  861335112 => "Qiqihar\,\ Heilongjiang",
  861335113 => "Mudanjiang\,\ Heilongjiang",
  861335114 => "Qitaihe\,\ Heilongjiang",
  861335115 => "Suihua\,\ Heilongjiang",
  861335116 => "Shuangyashan\,\ Heilongjiang",
  861335117 => "Jixi\,\ Heilongjiang",
  861335118 => "Daqing\,\ Heilongjiang",
  861335119 => "Daqing\,\ Heilongjiang",
  861335120 => "Harbin\,\ Heilongjiang",
  861335121 => "Harbin\,\ Heilongjiang",
  861335122 => "Qiqihar\,\ Heilongjiang",
  861335123 => "Mudanjiang\,\ Heilongjiang",
  861335124 => "Qitaihe\,\ Heilongjiang",
  861335125 => "Suihua\,\ Heilongjiang",
  861335126 => "Qitaihe\,\ Heilongjiang",
  861335127 => "Harbin\,\ Heilongjiang",
  861335128 => "Harbin\,\ Heilongjiang",
  861335129 => "Daqing\,\ Heilongjiang",
  861335130 => "Harbin\,\ Heilongjiang",
  861335131 => "Harbin\,\ Heilongjiang",
  861335132 => "Qiqihar\,\ Heilongjiang",
  861335133 => "Mudanjiang\,\ Heilongjiang",
  861335134 => "Jiamusi\,\ Heilongjiang",
  861335135 => "Suihua\,\ Heilongjiang",
  861335136 => "Heihe\,\ Heilongjiang",
  861335137 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861335138 => "Yichun\,\ Heilongjiang",
  861335139 => "Daqing\,\ Heilongjiang",
  861335140 => "Harbin\,\ Heilongjiang",
  861335141 => "Harbin\,\ Heilongjiang",
  861335142 => "Qiqihar\,\ Heilongjiang",
  861335143 => "Mudanjiang\,\ Heilongjiang",
  861335144 => "Jiamusi\,\ Heilongjiang",
  861335145 => "Suihua\,\ Heilongjiang",
  861335146 => "Heihe\,\ Heilongjiang",
  861335147 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861335148 => "Yichun\,\ Heilongjiang",
  861335149 => "Daqing\,\ Heilongjiang",
  861335150 => "Changchun\,\ Jilin",
  861335151 => "Jilin\,\ Jilin",
  861335152 => "Baicheng\,\ Jilin",
  861335153 => "Tonghua\,\ Jilin",
  861335154 => "Changchun\,\ Jilin",
  861335155 => "Songyuan\,\ Jilin",
  861335156 => "Liaoyuan\,\ Jilin",
  861335157 => "Yanbian\,\ Jilin",
  861335158 => "Siping\,\ Jilin",
  861335159 => "Baishan\,\ Jilin",
  861335160 => "Harbin\,\ Heilongjiang",
  861335161 => "Harbin\,\ Heilongjiang",
  861335162 => "Qiqihar\,\ Heilongjiang",
  861335163 => "Mudanjiang\,\ Heilongjiang",
  861335164 => "Jiamusi\,\ Heilongjiang",
  861335165 => "Jiamusi\,\ Heilongjiang",
  861335166 => "Jiamusi\,\ Heilongjiang",
  861335167 => "Jixi\,\ Heilongjiang",
  861335168 => "Harbin\,\ Heilongjiang",
  861335169 => "Daqing\,\ Heilongjiang",
  861335170 => "Harbin\,\ Heilongjiang",
  861335171 => "Harbin\,\ Heilongjiang",
  861335172 => "Qiqihar\,\ Heilongjiang",
  861335173 => "Mudanjiang\,\ Heilongjiang",
  861335174 => "Daqing\,\ Heilongjiang",
  861335175 => "Daqing\,\ Heilongjiang",
  861335176 => "Jiamusi\,\ Heilongjiang",
  861335177 => "Jixi\,\ Heilongjiang",
  861335178 => "Harbin\,\ Heilongjiang",
  861335179 => "Daqing\,\ Heilongjiang",
  861335180 => "Harbin\,\ Heilongjiang",
  861335181 => "Harbin\,\ Heilongjiang",
  861335182 => "Qiqihar\,\ Heilongjiang",
  861335183 => "Mudanjiang\,\ Heilongjiang",
  861335184 => "Daqing\,\ Heilongjiang",
  861335185 => "Daqing\,\ Heilongjiang",
  861335186 => "Jiamusi\,\ Heilongjiang",
  861335187 => "Jixi\,\ Heilongjiang",
  861335188 => "Harbin\,\ Heilongjiang",
  861335189 => "Daqing\,\ Heilongjiang",
  861335190 => "Harbin\,\ Heilongjiang",
  861335191 => "Harbin\,\ Heilongjiang",
  861335192 => "Qiqihar\,\ Heilongjiang",
  861335193 => "Hegang\,\ Heilongjiang",
  861335194 => "Hegang\,\ Heilongjiang",
  861335195 => "Hegang\,\ Heilongjiang",
  861335196 => "Hegang\,\ Heilongjiang",
  861335197 => "Jixi\,\ Heilongjiang",
  861335198 => "Harbin\,\ Heilongjiang",
  861335199 => "Daqing\,\ Heilongjiang",
  86133520 => "Tianjin",
  861335210 => "Anshan\,\ Liaoning",
  861335211 => "Anshan\,\ Liaoning",
  861335212 => "Fushun\,\ Liaoning",
  861335213 => "Fushun\,\ Liaoning",
  861335214 => "Benxi\,\ Liaoning",
  861335215 => "Benxi\,\ Liaoning",
  861335216 => "Dandong\,\ Liaoning",
  861335217 => "Dandong\,\ Liaoning",
  861335218 => "Jinzhou\,\ Liaoning",
  861335219 => "Jinzhou\,\ Liaoning",
  86133522 => "Dalian\,\ Liaoning",
  861335230 => "Yingkou\,\ Liaoning",
  861335231 => "Yingkou\,\ Liaoning",
  861335232 => "Fuxin\,\ Liaoning",
  861335233 => "Liaoyang\,\ Liaoning",
  861335234 => "Liaoyang\,\ Liaoning",
  861335235 => "Tieling\,\ Liaoning",
  861335236 => "Chaoyang\,\ Liaoning",
  861335237 => "Panjin\,\ Liaoning",
  861335238 => "Panjin\,\ Liaoning",
  861335239 => "Huludao\,\ Liaoning",
  86133524 => "Shenyang\,\ Liaoning",
  861335250 => "Harbin\,\ Heilongjiang",
  861335251 => "Harbin\,\ Heilongjiang",
  861335252 => "Qiqihar\,\ Heilongjiang",
  861335253 => "Mudanjiang\,\ Heilongjiang",
  861335254 => "Jiamusi\,\ Heilongjiang",
  861335255 => "Suihua\,\ Heilongjiang",
  861335256 => "Heihe\,\ Heilongjiang",
  861335257 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861335258 => "Yichun\,\ Heilongjiang",
  861335259 => "Daqing\,\ Heilongjiang",
  86133526 => "Huizhou\,\ Guangdong",
  861335270 => "Jieyang\,\ Guangdong",
  861335271 => "Jieyang\,\ Guangdong",
  861335272 => "Jieyang\,\ Guangdong",
  861335273 => "Jieyang\,\ Guangdong",
  861335274 => "Jieyang\,\ Guangdong",
  861335275 => "Shanwei\,\ Guangdong",
  861335276 => "Shanwei\,\ Guangdong",
  861335277 => "Huizhou\,\ Guangdong",
  861335278 => "Huizhou\,\ Guangdong",
  861335279 => "Huizhou\,\ Guangdong",
  86133528 => "Guangzhou\,\ Guangdong",
  86133529 => "Shenzhen\,\ Guangdong",
  861335300 => "Zhaoqing\,\ Guangdong",
  861335301 => "Zhaoqing\,\ Guangdong",
  861335302 => "Zhaoqing\,\ Guangdong",
  861335303 => "Zhaoqing\,\ Guangdong",
  861335304 => "Zhaoqing\,\ Guangdong",
  861335305 => "Zhaoqing\,\ Guangdong",
  861335306 => "Shantou\,\ Guangdong",
  861335307 => "Shantou\,\ Guangdong",
  861335308 => "Shantou\,\ Guangdong",
  861335309 => "Shantou\,\ Guangdong",
  861335310 => "Changchun\,\ Jilin",
  861335311 => "Changchun\,\ Jilin",
  861335312 => "Jilin\,\ Jilin",
  861335313 => "Yanbian\,\ Jilin",
  861335314 => "Changchun\,\ Jilin",
  861335315 => "Tonghua\,\ Jilin",
  861335316 => "Siping\,\ Jilin",
  861335317 => "Songyuan\,\ Jilin",
  861335318 => "Liaoyuan\,\ Jilin",
  861335319 => "Changchun\,\ Jilin",
  861335320 => "Changchun\,\ Jilin",
  861335321 => "Songyuan\,\ Jilin",
  861335322 => "Jilin\,\ Jilin",
  861335323 => "Baicheng\,\ Jilin",
  861335324 => "Changchun\,\ Jilin",
  861335325 => "Yanbian\,\ Jilin",
  861335326 => "Changchun\,\ Jilin",
  861335327 => "Changchun\,\ Jilin",
  861335328 => "Jilin\,\ Jilin",
  861335329 => "Changchun\,\ Jilin",
  86133533 => "Wenzhou\,\ Zhejiang",
  861335340 => "Xinzhou\,\ Shanxi",
  861335341 => "Taiyuan\,\ Shanxi",
  861335342 => "Datong\,\ Shanxi",
  861335343 => "Taiyuan\,\ Shanxi",
  861335344 => "Jinzhong\,\ Shanxi",
  861335345 => "Changzhi\,\ Shanxi",
  861335346 => "Jincheng\,\ Shanxi",
  861335347 => "Linfen\,\ Shanxi",
  861335348 => "Yuncheng\,\ Shanxi",
  861335349 => "Shuozhou\,\ Shanxi",
  861335350 => "Xinzhou\,\ Shanxi",
  861335351 => "Taiyuan\,\ Shanxi",
  861335352 => "Datong\,\ Shanxi",
  861335353 => "Yangquan\,\ Shanxi",
  861335354 => "Jinzhong\,\ Shanxi",
  861335355 => "Changzhi\,\ Shanxi",
  861335356 => "Jincheng\,\ Shanxi",
  861335357 => "Linfen\,\ Shanxi",
  861335358 => "Lüliang\,\ Shanxi",
  861335359 => "Yuncheng\,\ Shanxi",
  861335360 => "Shangqiu\,\ Henan",
  861335361 => "Shangqiu\,\ Henan",
  861335362 => "Shangqiu\,\ Henan",
  861335363 => "Anyang\,\ Henan",
  861335364 => "Anyang\,\ Henan",
  861335365 => "Anyang\,\ Henan",
  861335366 => "Xinxiang\,\ Henan",
  861335367 => "Xinxiang\,\ Henan",
  861335368 => "Xinxiang\,\ Henan",
  861335369 => "Xinyang\,\ Henan",
  861335370 => "Shangqiu\,\ Henan",
  861335371 => "Zhengzhou\,\ Henan",
  861335372 => "Anyang\,\ Henan",
  861335373 => "Xinxiang\,\ Henan",
  861335374 => "Xuchang\,\ Henan",
  861335375 => "Pingdingshan\,\ Henan",
  861335376 => "Xinyang\,\ Henan",
  861335377 => "Nanyang\,\ Henan",
  861335378 => "Kaifeng\,\ Henan",
  861335379 => "Luoyang\,\ Henan",
  861335380 => "Zhengzhou\,\ Henan",
  861335381 => "Kaifeng\,\ Henan",
  861335382 => "Kaifeng\,\ Henan",
  861335383 => "Kaifeng\,\ Henan",
  861335384 => "Zhoukou\,\ Henan",
  861335385 => "Zhoukou\,\ Henan",
  861335386 => "Zhoukou\,\ Henan",
  861335387 => "Zhumadian\,\ Henan",
  861335388 => "Zhumadian\,\ Henan",
  861335389 => "Zhumadian\,\ Henan",
  861335390 => "Luoyang\,\ Henan",
  861335391 => "Jiaozuo\,\ Henan",
  861335392 => "Hebi\,\ Henan",
  861335393 => "Puyang\,\ Henan",
  861335394 => "Zhoukou\,\ Henan",
  861335395 => "Luohe\,\ Henan",
  861335396 => "Zhumadian\,\ Henan",
  861335397 => "Luoyang\,\ Henan",
  861335398 => "Sanmenxia\,\ Henan",
  861335399 => "Luoyang\,\ Henan",
  86133540 => "Dalian\,\ Liaoning",
  861335410 => "Tieling\,\ Liaoning",
  861335411 => "Dalian\,\ Liaoning",
  861335412 => "Anshan\,\ Liaoning",
  861335413 => "Fushun\,\ Liaoning",
  861335414 => "Benxi\,\ Liaoning",
  861335415 => "Dandong\,\ Liaoning",
  861335416 => "Jinzhou\,\ Liaoning",
  861335417 => "Yingkou\,\ Liaoning",
  861335418 => "Fuxin\,\ Liaoning",
  861335419 => "Liaoyang\,\ Liaoning",
  861335420 => "Shenyang\,\ Liaoning",
  861335421 => "Chaoyang\,\ Liaoning",
  861335422 => "Shenyang\,\ Liaoning",
  861335423 => "Shenyang\,\ Liaoning",
  861335424 => "Shenyang\,\ Liaoning",
  861335425 => "Anshan\,\ Liaoning",
  861335426 => "Dalian\,\ Liaoning",
  861335427 => "Panjin\,\ Liaoning",
  861335428 => "Dalian\,\ Liaoning",
  861335429 => "Huludao\,\ Liaoning",
  861335430 => "Changchun\,\ Jilin",
  861335431 => "Changchun\,\ Jilin",
  861335432 => "Jilin\,\ Jilin",
  861335433 => "Yanbian\,\ Jilin",
  861335434 => "Siping\,\ Jilin",
  861335435 => "Tonghua\,\ Jilin",
  861335436 => "Baicheng\,\ Jilin",
  861335437 => "Liaoyuan\,\ Jilin",
  861335438 => "Songyuan\,\ Jilin",
  861335439 => "Baishan\,\ Jilin",
  861335440 => "Zibo\,\ Shandong",
  861335441 => "Zibo\,\ Shandong",
  861335442 => "Dezhou\,\ Shandong",
  861335443 => "Dezhou\,\ Shandong",
  861335444 => "Qingdao\,\ Shandong",
  861335445 => "Qingdao\,\ Shandong",
  861335446 => "Liaocheng\,\ Shandong",
  861335447 => "Liaocheng\,\ Shandong",
  861335448 => "Zaozhuang\,\ Shandong",
  861335449 => "Zaozhuang\,\ Shandong",
  861335450 => "Harbin\,\ Heilongjiang",
  861335451 => "Harbin\,\ Heilongjiang",
  861335452 => "Qiqihar\,\ Heilongjiang",
  861335453 => "Mudanjiang\,\ Heilongjiang",
  861335454 => "Jiamusi\,\ Heilongjiang",
  861335455 => "Suihua\,\ Heilongjiang",
  861335456 => "Heihe\,\ Heilongjiang",
  861335457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861335458 => "Yichun\,\ Heilongjiang",
  861335459 => "Daqing\,\ Heilongjiang",
  861335460 => "Kunming\,\ Yunnan",
  861335461 => "Kunming\,\ Yunnan",
  861335462 => "Kunming\,\ Yunnan",
  861335463 => "Kunming\,\ Yunnan",
  861335464 => "Kunming\,\ Yunnan",
  861335465 => "Kunming\,\ Yunnan",
  861335466 => "Yuxi\,\ Yunnan",
  861335467 => "Yuxi\,\ Yunnan",
  861335468 => "Qujing\,\ Yunnan",
  861335469 => "Chuxiong\,\ Yunnan",
  861335470 => "Hulun\,\ Inner\ Mongolia",
  861335471 => "Hohhot\,\ Inner\ Mongolia",
  861335472 => "Baotou\,\ Inner\ Mongolia",
  861335473 => "Wuhai\,\ Inner\ Mongolia",
  861335474 => "Hinggan\,\ Inner\ Mongolia",
  861335475 => "Tongliao\,\ Inner\ Mongolia",
  861335476 => "Chifeng\,\ Inner\ Mongolia",
  861335477 => "Ordos\,\ Inner\ Mongolia",
  861335478 => "Bayannur\,\ Inner\ Mongolia",
  861335479 => "Xilin\,\ Inner\ Mongolia",
  861335480 => "Hulun\,\ Inner\ Mongolia",
  861335481 => "Hulun\,\ Inner\ Mongolia",
  861335482 => "Hinggan\,\ Inner\ Mongolia",
  861335483 => "Alxa\,\ Inner\ Mongolia",
  861335484 => "Chifeng\,\ Inner\ Mongolia",
  861335485 => "Chifeng\,\ Inner\ Mongolia",
  861335486 => "Baotou\,\ Inner\ Mongolia",
  861335487 => "Hohhot\,\ Inner\ Mongolia",
  861335488 => "Hohhot\,\ Inner\ Mongolia",
  861335489 => "Hohhot\,\ Inner\ Mongolia",
  86133549 => "Kunming\,\ Yunnan",
  86133550 => "Linyi\,\ Shandong",
  86133551 => "Jining\,\ Shandong",
  86133552 => "Zibo\,\ Shandong",
  861335530 => "Heze\,\ Shandong",
  861335531 => "Jinan\,\ Shandong",
  861335532 => "Qingdao\,\ Shandong",
  861335533 => "Zibo\,\ Shandong",
  861335534 => "Dezhou\,\ Shandong",
  861335535 => "Yantai\,\ Shandong",
  861335536 => "Weifang\,\ Shandong",
  861335537 => "Jining\,\ Shandong",
  861335538 => "TaiAn\,\ Shandong",
  861335539 => "Linyi\,\ Shandong",
  861335540 => "Heze\,\ Shandong",
  861335541 => "Jinan\,\ Shandong",
  861335542 => "Qingdao\,\ Shandong",
  861335543 => "Binzhou\,\ Shandong",
  861335544 => "Dezhou\,\ Shandong",
  861335545 => "Yantai\,\ Shandong",
  861335546 => "Dongying\,\ Shandong",
  861335547 => "Jining\,\ Shandong",
  861335548 => "TaiAn\,\ Shandong",
  861335549 => "Linyi\,\ Shandong",
  861335550 => "Chuzhou\,\ Anhui",
  861335551 => "Hefei\,\ Anhui",
  861335552 => "Bengbu\,\ Anhui",
  861335553 => "Wuhu\,\ Anhui",
  861335554 => "Huainan\,\ Anhui",
  861335555 => "MaAnshan\,\ Anhui",
  861335556 => "Anqing\,\ Anhui",
  861335557 => "Suzhou\,\ Anhui",
  861335558 => "Fuyang\,\ Anhui",
  861335559 => "Huangshan\,\ Anhui",
  861335560 => "Hefei\,\ Anhui",
  861335561 => "Huaibei\,\ Anhui",
  861335562 => "Tongling\,\ Anhui",
  861335563 => "Xuancheng\,\ Anhui",
  861335564 => "LuAn\,\ Anhui",
  861335565 => "Chaohu\,\ Anhui",
  861335566 => "Chizhou\,\ Anhui",
  861335567 => "Bozhou\,\ Anhui",
  861335568 => "Bozhou\,\ Anhui",
  861335569 => "Hefei\,\ Anhui",
  861335570 => "Quzhou\,\ Zhejiang",
  861335571 => "Hangzhou\,\ Zhejiang",
  861335572 => "Huzhou\,\ Zhejiang",
  861335573 => "Jiaxing\,\ Zhejiang",
  861335574 => "Ningbo\,\ Zhejiang",
  861335575 => "Shaoxing\,\ Zhejiang",
  861335576 => "Taizhou\,\ Zhejiang",
  861335577 => "Wenzhou\,\ Zhejiang",
  861335578 => "Hangzhou\,\ Zhejiang",
  861335579 => "Jinhua\,\ Zhejiang",
  861335580 => "Zhoushan\,\ Zhejiang",
  861335581 => "Hangzhou\,\ Zhejiang",
  861335582 => "Huzhou\,\ Zhejiang",
  861335583 => "Jiaxing\,\ Zhejiang",
  861335584 => "Ningbo\,\ Zhejiang",
  861335585 => "Shaoxing\,\ Zhejiang",
  861335586 => "Taizhou\,\ Zhejiang",
  861335587 => "Wenzhou\,\ Zhejiang",
  861335588 => "Wenzhou\,\ Zhejiang",
  861335589 => "Jinhua\,\ Zhejiang",
  86133559 => "Ningbo\,\ Zhejiang",
  86133560 => "Jiaxing\,\ Zhejiang",
  86133561 => "Wenzhou\,\ Zhejiang",
  861335620 => "Heze\,\ Shandong",
  861335621 => "Heze\,\ Shandong",
  861335622 => "Laiwu\,\ Shandong",
  861335623 => "Rizhao\,\ Shandong",
  861335624 => "Binzhou\,\ Shandong",
  861335625 => "Liaocheng\,\ Shandong",
  861335626 => "Dezhou\,\ Shandong",
  861335627 => "Dezhou\,\ Shandong",
  861335628 => "Binzhou\,\ Shandong",
  861335629 => "Binzhou\,\ Shandong",
  861335630 => "Weihai\,\ Shandong",
  861335631 => "Weihai\,\ Shandong",
  861335632 => "Zaozhuang\,\ Shandong",
  861335633 => "Rizhao\,\ Shandong",
  861335634 => "Laiwu\,\ Shandong",
  861335635 => "Liaocheng\,\ Shandong",
  861335636 => "Weifang\,\ Shandong",
  861335637 => "Zaozhuang\,\ Shandong",
  861335638 => "Yantai\,\ Shandong",
  861335639 => "Qingdao\,\ Shandong",
  861335640 => "Jiangmen\,\ Guangdong",
  861335641 => "Jiangmen\,\ Guangdong",
  861335642 => "Jiangmen\,\ Guangdong",
  861335643 => "Jiangmen\,\ Guangdong",
  861335644 => "Jiangmen\,\ Guangdong",
  861335645 => "Dongguan\,\ Guangdong",
  861335646 => "Dongguan\,\ Guangdong",
  861335647 => "Dongguan\,\ Guangdong",
  861335648 => "Dongguan\,\ Guangdong",
  861335649 => "Dongguan\,\ Guangdong",
  861335650 => "Zhanjiang\,\ Guangdong",
  861335651 => "Zhanjiang\,\ Guangdong",
  861335652 => "Zhanjiang\,\ Guangdong",
  861335653 => "Zhanjiang\,\ Guangdong",
  861335654 => "Zhanjiang\,\ Guangdong",
  861335655 => "Jiangmen\,\ Guangdong",
  861335656 => "Jiangmen\,\ Guangdong",
  861335657 => "Jiangmen\,\ Guangdong",
  861335658 => "Jiangmen\,\ Guangdong",
  861335659 => "Jiangmen\,\ Guangdong",
  861335660 => "Dongying\,\ Shandong",
  861335661 => "Dongying\,\ Shandong",
  861335662 => "Dongying\,\ Shandong",
  861335663 => "Dongying\,\ Shandong",
  861335664 => "Dongying\,\ Shandong",
  861335665 => "Jinan\,\ Shandong",
  861335666 => "Jinan\,\ Shandong",
  861335667 => "Jinan\,\ Shandong",
  861335668 => "Jinan\,\ Shandong",
  861335669 => "Jinan\,\ Shandong",
  86133567 => "Weifang\,\ Shandong",
  861335680 => "Weihai\,\ Shandong",
  861335681 => "Weihai\,\ Shandong",
  861335682 => "TaiAn\,\ Shandong",
  861335683 => "Dongying\,\ Shandong",
  861335684 => "Dezhou\,\ Shandong",
  861335685 => "Qingdao\,\ Shandong",
  861335686 => "Qingdao\,\ Shandong",
  861335687 => "Qingdao\,\ Shandong",
  861335688 => "Qingdao\,\ Shandong",
  861335689 => "Qingdao\,\ Shandong",
  86133569 => "Yantai\,\ Shandong",
  861335700 => "Quzhou\,\ Zhejiang",
  861335701 => "Quzhou\,\ Zhejiang",
  861335702 => "Quzhou\,\ Zhejiang",
  861335703 => "Jinhua\,\ Zhejiang",
  861335704 => "Jinhua\,\ Zhejiang",
  861335705 => "Jinhua\,\ Zhejiang",
  861335706 => "Jinhua\,\ Zhejiang",
  861335707 => "Lishui\,\ Zhejiang",
  861335708 => "Lishui\,\ Zhejiang",
  861335709 => "Lishui\,\ Zhejiang",
  86133571 => "Hangzhou\,\ Zhejiang",
  861335720 => "Zhuzhou\,\ Hunan",
  861335721 => "Changsha\,\ Hunan",
  861335722 => "Changsha\,\ Hunan",
  861335723 => "Xiangxi\,\ Hunan",
  861335724 => "Hengyang\,\ Hunan",
  861335725 => "Huaihua\,\ Hunan",
  861335726 => "Yongzhou\,\ Hunan",
  861335727 => "Chenzhou\,\ Hunan",
  861335728 => "Yongzhou\,\ Hunan",
  861335729 => "Shaoyang\,\ Hunan",
  861335730 => "Yueyang\,\ Hunan",
  861335731 => "Changsha\,\ Hunan",
  861335732 => "Xiangtan\,\ Hunan",
  861335733 => "Zhuzhou\,\ Hunan",
  861335734 => "Hengyang\,\ Hunan",
  861335735 => "Chenzhou\,\ Hunan",
  861335736 => "Changde\,\ Hunan",
  861335737 => "Yiyang\,\ Hunan",
  861335738 => "Loudi\,\ Hunan",
  861335739 => "Shaoyang\,\ Hunan",
  86133574 => "Beijing",
  86133575 => "Shaoxing\,\ Zhejiang",
  86133576 => "Taizhou\,\ Zhejiang",
  861335770 => "Nanjing\,\ Jiangsu",
  861335771 => "Nanjing\,\ Jiangsu",
  861335772 => "Nanjing\,\ Jiangsu",
  861335773 => "Nanjing\,\ Jiangsu",
  861335774 => "Zhenjiang\,\ Jiangsu",
  861335775 => "Zhenjiang\,\ Jiangsu",
  861335776 => "Zhenjiang\,\ Jiangsu",
  861335777 => "Zhenjiang\,\ Jiangsu",
  861335778 => "Taizhou\,\ Jiangsu",
  861335779 => "Taizhou\,\ Jiangsu",
  861335780 => "Nanjing\,\ Jiangsu",
  861335781 => "Nanjing\,\ Jiangsu",
  861335782 => "Nanjing\,\ Jiangsu",
  861335783 => "Nanjing\,\ Jiangsu",
  861335784 => "Suqian\,\ Jiangsu",
  861335785 => "Suqian\,\ Jiangsu",
  861335786 => "Lianyungang\,\ Jiangsu",
  861335787 => "Lianyungang\,\ Jiangsu",
  861335788 => "Changzhou\,\ Jiangsu",
  861335789 => "Changzhou\,\ Jiangsu",
  861335790 => "Wuxi\,\ Jiangsu",
  861335791 => "Wuxi\,\ Jiangsu",
  861335792 => "Wuxi\,\ Jiangsu",
  861335793 => "Xuzhou\,\ Jiangsu",
  861335794 => "Xuzhou\,\ Jiangsu",
  861335795 => "Xuzhou\,\ Jiangsu",
  861335796 => "HuaiAn\,\ Jiangsu",
  861335797 => "HuaiAn\,\ Jiangsu",
  861335798 => "Yancheng\,\ Jiangsu",
  861335799 => "Yancheng\,\ Jiangsu",
  861335800 => "Suzhou\,\ Jiangsu",
  861335801 => "Suzhou\,\ Jiangsu",
  861335802 => "Suzhou\,\ Jiangsu",
  861335803 => "Suzhou\,\ Jiangsu",
  861335804 => "Suzhou\,\ Jiangsu",
  861335805 => "Suzhou\,\ Jiangsu",
  861335806 => "Nantong\,\ Jiangsu",
  861335807 => "Nantong\,\ Jiangsu",
  861335808 => "Nantong\,\ Jiangsu",
  861335809 => "Nantong\,\ Jiangsu",
  861335810 => "Wuxi\,\ Jiangsu",
  861335811 => "Wuxi\,\ Jiangsu",
  861335812 => "Yangzhou\,\ Jiangsu",
  861335813 => "Yangzhou\,\ Jiangsu",
  861335814 => "Yangzhou\,\ Jiangsu",
  861335815 => "Wuxi\,\ Jiangsu",
  861335816 => "Changzhou\,\ Jiangsu",
  861335817 => "Changzhou\,\ Jiangsu",
  861335818 => "Changzhou\,\ Jiangsu",
  861335819 => "Changzhou\,\ Jiangsu",
  86133582 => "Fuzhou\,\ Fujian",
  861335830 => "Zhangzhou\,\ Fujian",
  861335831 => "Zhangzhou\,\ Fujian",
  861335832 => "Zhangzhou\,\ Fujian",
  861335833 => "Zhangzhou\,\ Fujian",
  861335834 => "Zhangzhou\,\ Fujian",
  861335835 => "Longyan\,\ Fujian",
  861335836 => "Longyan\,\ Fujian",
  861335837 => "Xiamen\,\ Fujian",
  861335838 => "Xiamen\,\ Fujian",
  861335839 => "Xiamen\,\ Fujian",
  861335840 => "Sanming\,\ Fujian",
  861335841 => "Sanming\,\ Fujian",
  861335842 => "Quanzhou\,\ Fujian",
  861335843 => "Quanzhou\,\ Fujian",
  861335844 => "Nanping\,\ Fujian",
  861335845 => "Nanping\,\ Fujian",
  861335846 => "Nanping\,\ Fujian",
  861335847 => "Ningde\,\ Fujian",
  861335848 => "Ningde\,\ Fujian",
  861335849 => "Ningde\,\ Fujian",
  861335850 => "Sanming\,\ Fujian",
  861335851 => "Putian\,\ Fujian",
  861335852 => "Putian\,\ Fujian",
  861335853 => "Putian\,\ Fujian",
  861335854 => "Quanzhou\,\ Fujian",
  861335855 => "Quanzhou\,\ Fujian",
  861335856 => "Quanzhou\,\ Fujian",
  861335857 => "Quanzhou\,\ Fujian",
  861335858 => "Quanzhou\,\ Fujian",
  861335859 => "Quanzhou\,\ Fujian",
  861335860 => "Anshan\,\ Liaoning",
  861335861 => "Anshan\,\ Liaoning",
  861335862 => "Anshan\,\ Liaoning",
  861335863 => "Anshan\,\ Liaoning",
  861335864 => "Anshan\,\ Liaoning",
  861335865 => "Anshan\,\ Liaoning",
  861335866 => "Anshan\,\ Liaoning",
  861335867 => "Anshan\,\ Liaoning",
  861335868 => "Anshan\,\ Liaoning",
  861335869 => "Fushun\,\ Liaoning",
  861335870 => "Liaoyang\,\ Liaoning",
  861335871 => "Fuxin\,\ Liaoning",
  861335872 => "Fuxin\,\ Liaoning",
  861335873 => "Yingkou\,\ Liaoning",
  861335874 => "Yingkou\,\ Liaoning",
  861335875 => "Jinzhou\,\ Liaoning",
  861335876 => "Jinzhou\,\ Liaoning",
  861335877 => "Dandong\,\ Liaoning",
  861335878 => "Dandong\,\ Liaoning",
  861335879 => "Fushun\,\ Liaoning",
  861335880 => "Huludao\,\ Liaoning",
  861335881 => "Huludao\,\ Liaoning",
  861335882 => "Huludao\,\ Liaoning",
  861335883 => "Huludao\,\ Liaoning",
  861335884 => "Huludao\,\ Liaoning",
  861335885 => "Shenyang\,\ Liaoning",
  861335886 => "Shenyang\,\ Liaoning",
  861335887 => "Shenyang\,\ Liaoning",
  861335888 => "Shenyang\,\ Liaoning",
  861335889 => "Benxi\,\ Liaoning",
  861335890 => "Panjin\,\ Liaoning",
  861335891 => "Panjin\,\ Liaoning",
  861335892 => "Chaoyang\,\ Liaoning",
  861335893 => "Chaoyang\,\ Liaoning",
  861335894 => "Tieling\,\ Liaoning",
  861335895 => "Tieling\,\ Liaoning",
  861335896 => "Tieling\,\ Liaoning",
  861335897 => "Tieling\,\ Liaoning",
  861335898 => "Tieling\,\ Liaoning",
  861335899 => "Tieling\,\ Liaoning",
  861335900 => "Chuzhou\,\ Anhui",
  861335901 => "Hefei\,\ Anhui",
  861335902 => "Bengbu\,\ Anhui",
  861335903 => "Huainan\,\ Anhui",
  861335904 => "Anqing\,\ Anhui",
  861335905 => "MaAnshan\,\ Anhui",
  861335906 => "Fuyang\,\ Anhui",
  861335907 => "Suzhou\,\ Anhui",
  861335908 => "Wuhu\,\ Anhui",
  861335909 => "Huangshan\,\ Anhui",
  861335910 => "Xianyang\,\ Shaanxi",
  861335911 => "YanAn\,\ Shaanxi",
  861335912 => "Yulin\,\ Shaanxi",
  861335913 => "Weinan\,\ Shaanxi",
  861335914 => "Shangluo\,\ Shaanxi",
  861335915 => "Ankang\,\ Shaanxi",
  861335916 => "Hanzhong\,\ Shaanxi",
  861335917 => "Baoji\,\ Shaanxi",
  861335918 => "XiAn\,\ Shaanxi",
  861335919 => "Tongchuan\,\ Shaanxi",
  86133592 => "XiAn\,\ Shaanxi",
  861335930 => "Jinchang\,\ Gansu",
  861335931 => "Lanzhou\,\ Gansu",
  861335932 => "Baiyin\,\ Gansu",
  861335933 => "Pingliang\,\ Gansu",
  861335934 => "Qingyang\,\ Gansu",
  861335935 => "Wuwei\,\ Gansu",
  861335936 => "Zhangye\,\ Gansu",
  861335937 => "Jiayuguan\,\ Gansu",
  861335938 => "Tianshui\,\ Gansu",
  861335939 => "Jiuquan\,\ Gansu",
  86133594 => "Lanzhou\,\ Gansu",
  861335950 => "Daqing\,\ Heilongjiang",
  861335951 => "Harbin\,\ Heilongjiang",
  861335952 => "Qiqihar\,\ Heilongjiang",
  861335953 => "Mudanjiang\,\ Heilongjiang",
  861335954 => "Jiamusi\,\ Heilongjiang",
  861335955 => "Jiamusi\,\ Heilongjiang",
  861335956 => "Mudanjiang\,\ Heilongjiang",
  861335957 => "Qiqihar\,\ Heilongjiang",
  861335958 => "Hegang\,\ Heilongjiang",
  861335959 => "Daqing\,\ Heilongjiang",
  861335960 => "Daqing\,\ Heilongjiang",
  861335961 => "Daqing\,\ Heilongjiang",
  861335962 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861335963 => "Jiamusi\,\ Heilongjiang",
  861335964 => "Jiamusi\,\ Heilongjiang",
  861335965 => "Shuangyashan\,\ Heilongjiang",
  861335966 => "Yichun\,\ Heilongjiang",
  861335967 => "Yichun\,\ Heilongjiang",
  861335968 => "Mudanjiang\,\ Heilongjiang",
  861335969 => "Mudanjiang\,\ Heilongjiang",
  861335970 => "Harbin\,\ Heilongjiang",
  861335971 => "Harbin\,\ Heilongjiang",
  861335972 => "Harbin\,\ Heilongjiang",
  861335973 => "Qiqihar\,\ Heilongjiang",
  861335974 => "Qiqihar\,\ Heilongjiang",
  861335975 => "Qiqihar\,\ Heilongjiang",
  861335976 => "Jiamusi\,\ Heilongjiang",
  861335977 => "Hegang\,\ Heilongjiang",
  861335978 => "Shuangyashan\,\ Heilongjiang",
  861335979 => "Qitaihe\,\ Heilongjiang",
  861335980 => "Daqing\,\ Heilongjiang",
  861335981 => "Daqing\,\ Heilongjiang",
  861335982 => "Daqing\,\ Heilongjiang",
  861335983 => "Daqing\,\ Heilongjiang",
  861335984 => "Harbin\,\ Heilongjiang",
  861335985 => "Harbin\,\ Heilongjiang",
  861335986 => "Harbin\,\ Heilongjiang",
  861335987 => "Harbin\,\ Heilongjiang",
  861335988 => "Mudanjiang\,\ Heilongjiang",
  861335989 => "Jixi\,\ Heilongjiang",
  861335990 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861335991 => "Suihua\,\ Heilongjiang",
  861335992 => "Suihua\,\ Heilongjiang",
  861335993 => "Heihe\,\ Heilongjiang",
  861335994 => "Heihe\,\ Heilongjiang",
  861335995 => "Jixi\,\ Heilongjiang",
  861335996 => "Jixi\,\ Heilongjiang",
  861335997 => "Hegang\,\ Heilongjiang",
  861335998 => "Harbin\,\ Heilongjiang",
  861335999 => "Harbin\,\ Heilongjiang",
  861336000 => "Guangzhou\,\ Guangdong",
  861336001 => "Guangzhou\,\ Guangdong",
  861336002 => "Guangzhou\,\ Guangdong",
  861336003 => "Guangzhou\,\ Guangdong",
  861336004 => "Guangzhou\,\ Guangdong",
  861336005 => "Shenzhen\,\ Guangdong",
  861336006 => "Shenzhen\,\ Guangdong",
  861336007 => "Shenzhen\,\ Guangdong",
  861336008 => "Shenzhen\,\ Guangdong",
  861336009 => "Shenzhen\,\ Guangdong",
  861336010 => "Zhanjiang\,\ Guangdong",
  861336011 => "Zhanjiang\,\ Guangdong",
  861336012 => "Zhanjiang\,\ Guangdong",
  861336013 => "Zhongshan\,\ Guangdong",
  861336014 => "Zhongshan\,\ Guangdong",
  861336015 => "Zhongshan\,\ Guangdong",
  861336016 => "Shantou\,\ Guangdong",
  861336017 => "Shantou\,\ Guangdong",
  861336018 => "Yangjiang\,\ Guangdong",
  861336019 => "Yunfu\,\ Guangdong",
  861336020 => "Jiangmen\,\ Guangdong",
  861336021 => "Jiangmen\,\ Guangdong",
  861336022 => "Jiangmen\,\ Guangdong",
  861336023 => "Zhaoqing\,\ Guangdong",
  861336024 => "Zhaoqing\,\ Guangdong",
  861336025 => "Zhaoqing\,\ Guangdong",
  861336026 => "Zhaoqing\,\ Guangdong",
  861336027 => "Zhaoqing\,\ Guangdong",
  861336028 => "Maoming\,\ Guangdong",
  861336029 => "Maoming\,\ Guangdong",
  861336030 => "Foshan\,\ Guangdong",
  861336031 => "Foshan\,\ Guangdong",
  861336032 => "Foshan\,\ Guangdong",
  861336033 => "Foshan\,\ Guangdong",
  861336034 => "Foshan\,\ Guangdong",
  861336035 => "Foshan\,\ Guangdong",
  861336036 => "Foshan\,\ Guangdong",
  861336037 => "Foshan\,\ Guangdong",
  861336038 => "Jieyang\,\ Guangdong",
  861336039 => "Jieyang\,\ Guangdong",
  861336040 => "Huizhou\,\ Guangdong",
  861336041 => "Huizhou\,\ Guangdong",
  861336042 => "Huizhou\,\ Guangdong",
  861336043 => "Jiangmen\,\ Guangdong",
  861336044 => "Jiangmen\,\ Guangdong",
  861336045 => "Dongguan\,\ Guangdong",
  861336046 => "Dongguan\,\ Guangdong",
  861336047 => "Dongguan\,\ Guangdong",
  861336048 => "Dongguan\,\ Guangdong",
  861336049 => "Heyuan\,\ Guangdong",
  861336050 => "Shenzhen\,\ Guangdong",
  861336051 => "Shenzhen\,\ Guangdong",
  861336052 => "Shenzhen\,\ Guangdong",
  861336053 => "Shenzhen\,\ Guangdong",
  861336054 => "Shenzhen\,\ Guangdong",
  861336055 => "Guangzhou\,\ Guangdong",
  861336056 => "Guangzhou\,\ Guangdong",
  861336057 => "Guangzhou\,\ Guangdong",
  861336058 => "Guangzhou\,\ Guangdong",
  861336059 => "Guangzhou\,\ Guangdong",
  861336060 => "Zhuhai\,\ Guangdong",
  861336061 => "Zhuhai\,\ Guangdong",
  861336062 => "Chaozhou\,\ Guangdong",
  861336063 => "Dongguan\,\ Guangdong",
  861336064 => "Dongguan\,\ Guangdong",
  861336065 => "Dongguan\,\ Guangdong",
  861336066 => "Dongguan\,\ Guangdong",
  861336067 => "Dongguan\,\ Guangdong",
  861336068 => "Dongguan\,\ Guangdong",
  861336069 => "Shaoguan\,\ Guangdong",
  861336070 => "Zhanjiang\,\ Guangdong",
  861336071 => "Zhanjiang\,\ Guangdong",
  861336072 => "Qingyuan\,\ Guangdong",
  861336073 => "Maoming\,\ Guangdong",
  861336074 => "Maoming\,\ Guangdong",
  861336075 => "Maoming\,\ Guangdong",
  861336076 => "Zhuhai\,\ Guangdong",
  861336077 => "Zhuhai\,\ Guangdong",
  861336078 => "Jieyang\,\ Guangdong",
  861336079 => "Jieyang\,\ Guangdong",
  861336080 => "Shantou\,\ Guangdong",
  861336081 => "Shantou\,\ Guangdong",
  861336082 => "Shantou\,\ Guangdong",
  861336083 => "Huizhou\,\ Guangdong",
  861336084 => "Huizhou\,\ Guangdong",
  861336085 => "Huizhou\,\ Guangdong",
  861336086 => "Huizhou\,\ Guangdong",
  861336087 => "Huizhou\,\ Guangdong",
  861336088 => "Huizhou\,\ Guangdong",
  861336089 => "Huizhou\,\ Guangdong",
  861336090 => "Shaoguan\,\ Guangdong",
  861336091 => "Shaoguan\,\ Guangdong",
  861336092 => "Qingyuan\,\ Guangdong",
  861336093 => "Qingyuan\,\ Guangdong",
  861336094 => "Shanwei\,\ Guangdong",
  861336095 => "Shanwei\,\ Guangdong",
  861336096 => "Meizhou\,\ Guangdong",
  861336097 => "Shenzhen\,\ Guangdong",
  861336098 => "Heyuan\,\ Guangdong",
  861336099 => "Heyuan\,\ Guangdong",
  86133610 => "Jinan\,\ Shandong",
  861336110 => "Zaozhuang\,\ Shandong",
  861336111 => "Zaozhuang\,\ Shandong",
  861336112 => "Zaozhuang\,\ Shandong",
  861336113 => "Zaozhuang\,\ Shandong",
  861336114 => "Weihai\,\ Shandong",
  861336115 => "Weihai\,\ Shandong",
  861336116 => "Weihai\,\ Shandong",
  861336117 => "Weihai\,\ Shandong",
  861336118 => "Weihai\,\ Shandong",
  861336119 => "Weihai\,\ Shandong",
  86133612 => "Qingdao\,\ Shandong",
  86133613 => "Yantai\,\ Shandong",
  861336140 => "Zibo\,\ Shandong",
  861336141 => "Dongying\,\ Shandong",
  861336142 => "Zaozhuang\,\ Shandong",
  861336143 => "Zaozhuang\,\ Shandong",
  861336144 => "Weifang\,\ Shandong",
  861336145 => "Weifang\,\ Shandong",
  861336146 => "Liaocheng\,\ Shandong",
  861336147 => "Liaocheng\,\ Shandong",
  861336148 => "Qingdao\,\ Shandong",
  861336149 => "Qingdao\,\ Shandong",
  861336150 => "Dongying\,\ Shandong",
  861336151 => "Dongying\,\ Shandong",
  861336152 => "Dongying\,\ Shandong",
  861336153 => "Weifang\,\ Shandong",
  861336154 => "Weifang\,\ Shandong",
  861336155 => "Weifang\,\ Shandong",
  861336156 => "Weifang\,\ Shandong",
  861336157 => "Weifang\,\ Shandong",
  861336158 => "Zibo\,\ Shandong",
  861336159 => "Zibo\,\ Shandong",
  861336160 => "Yingtan\,\ Jiangxi",
  861336161 => "Nanchang\,\ Jiangxi",
  861336162 => "Nanchang\,\ Jiangxi",
  861336163 => "Nanchang\,\ Jiangxi",
  861336164 => "Nanchang\,\ Jiangxi",
  861336165 => "Nanchang\,\ Jiangxi",
  861336166 => "Fuzhou\,\ Jiangxi",
  861336167 => "Fuzhou\,\ Jiangxi",
  861336168 => "Fuzhou\,\ Jiangxi",
  861336169 => "Shangrao\,\ Jiangxi",
  861336170 => "Xinyu\,\ Jiangxi",
  861336171 => "Nanchang\,\ Jiangxi",
  861336172 => "Jiujiang\,\ Jiangxi",
  861336173 => "Shangrao\,\ Jiangxi",
  861336174 => "Pingxiang\,\ Jiangxi",
  861336175 => "Yichun\,\ Jiangxi",
  861336176 => "JiAn\,\ Jiangxi",
  861336177 => "Ganzhou\,\ Jiangxi",
  861336178 => "Jingdezhen\,\ Jiangxi",
  861336179 => "Pingxiang\,\ Jiangxi",
  86133618 => "Shanghai",
  86133619 => "Shanghai",
  861336200 => "Quzhou\,\ Zhejiang",
  861336201 => "Quzhou\,\ Zhejiang",
  861336202 => "Quzhou\,\ Zhejiang",
  861336203 => "Quzhou\,\ Zhejiang",
  861336204 => "Quzhou\,\ Zhejiang",
  861336205 => "Lishui\,\ Zhejiang",
  861336206 => "Lishui\,\ Zhejiang",
  861336207 => "Lishui\,\ Zhejiang",
  861336208 => "Lishui\,\ Zhejiang",
  861336209 => "Lishui\,\ Zhejiang",
  86133621 => "Hangzhou\,\ Zhejiang",
  86133622 => "Huzhou\,\ Zhejiang",
  86133623 => "Jiaxing\,\ Zhejiang",
  861336240 => "Zhoushan\,\ Zhejiang",
  861336241 => "Zhoushan\,\ Zhejiang",
  861336242 => "Zhoushan\,\ Zhejiang",
  861336243 => "Ningbo\,\ Zhejiang",
  861336244 => "Ningbo\,\ Zhejiang",
  861336245 => "Ningbo\,\ Zhejiang",
  861336246 => "Ningbo\,\ Zhejiang",
  861336247 => "Ningbo\,\ Zhejiang",
  861336248 => "Ningbo\,\ Zhejiang",
  861336249 => "Lishui\,\ Zhejiang",
  86133625 => "Shaoxing\,\ Zhejiang",
  86133626 => "Taizhou\,\ Zhejiang",
  86133627 => "Wenzhou\,\ Zhejiang",
  861336280 => "Zhoushan\,\ Zhejiang",
  861336281 => "Zhoushan\,\ Zhejiang",
  861336282 => "Zhoushan\,\ Zhejiang",
  861336283 => "Ningbo\,\ Zhejiang",
  861336284 => "Ningbo\,\ Zhejiang",
  861336285 => "Ningbo\,\ Zhejiang",
  861336286 => "Ningbo\,\ Zhejiang",
  861336287 => "Ningbo\,\ Zhejiang",
  861336288 => "Ningbo\,\ Zhejiang",
  861336289 => "Hangzhou\,\ Zhejiang",
  86133629 => "Jinhua\,\ Zhejiang",
  86133630 => "Handan\,\ Hebei",
  861336310 => "Handan\,\ Hebei",
  861336311 => "Shijiazhuang\,\ Hebei",
  861336312 => "Baoding\,\ Hebei",
  861336313 => "Zhangjiakou\,\ Hebei",
  861336314 => "Chengde\,\ Hebei",
  861336315 => "Tangshan\,\ Hebei",
  861336316 => "Langfang\,\ Hebei",
  861336317 => "Cangzhou\,\ Hebei",
  861336318 => "Hengshui\,\ Hebei",
  861336319 => "Xingtai\,\ Hebei",
  86133632 => "Tangshan\,\ Hebei",
  861336330 => "Hengshui\,\ Hebei",
  861336331 => "Hengshui\,\ Hebei",
  861336332 => "Hengshui\,\ Hebei",
  861336333 => "Hengshui\,\ Hebei",
  861336334 => "Hengshui\,\ Hebei",
  861336335 => "Qinhuangdao\,\ Hebei",
  861336336 => "Tangshan\,\ Hebei",
  861336337 => "Tangshan\,\ Hebei",
  861336338 => "Tangshan\,\ Hebei",
  861336339 => "Tangshan\,\ Hebei",
  861336340 => "Datong\,\ Shanxi",
  861336341 => "Taiyuan\,\ Shanxi",
  861336342 => "Datong\,\ Shanxi",
  861336343 => "Taiyuan\,\ Shanxi",
  861336344 => "Taiyuan\,\ Shanxi",
  861336345 => "Changzhi\,\ Shanxi",
  861336346 => "Jincheng\,\ Shanxi",
  861336347 => "Linfen\,\ Shanxi",
  861336348 => "Yuncheng\,\ Shanxi",
  861336349 => "Shuozhou\,\ Shanxi",
  861336350 => "Xinzhou\,\ Shanxi",
  861336351 => "Taiyuan\,\ Shanxi",
  861336352 => "Datong\,\ Shanxi",
  861336353 => "Yangquan\,\ Shanxi",
  861336354 => "Jinzhong\,\ Shanxi",
  861336355 => "Changzhi\,\ Shanxi",
  861336356 => "Jincheng\,\ Shanxi",
  861336357 => "Linfen\,\ Shanxi",
  861336358 => "Lüliang\,\ Shanxi",
  861336359 => "Yuncheng\,\ Shanxi",
  861336360 => "Langfang\,\ Hebei",
  861336361 => "Langfang\,\ Hebei",
  861336362 => "Langfang\,\ Hebei",
  861336363 => "Langfang\,\ Hebei",
  861336364 => "Langfang\,\ Hebei",
  861336365 => "Langfang\,\ Hebei",
  861336366 => "Cangzhou\,\ Hebei",
  861336367 => "Cangzhou\,\ Hebei",
  861336368 => "Cangzhou\,\ Hebei",
  861336369 => "Cangzhou\,\ Hebei",
  86133637 => "Xingtai\,\ Hebei",
  86133638 => "Shijiazhuang\,\ Hebei",
  86133639 => "XiAn\,\ Shaanxi",
  86133640 => "Chongqing",
  861336410 => "Tieling\,\ Liaoning",
  861336411 => "Dalian\,\ Liaoning",
  861336412 => "Anshan\,\ Liaoning",
  861336413 => "Fushun\,\ Liaoning",
  861336414 => "Benxi\,\ Liaoning",
  861336415 => "Dandong\,\ Liaoning",
  861336416 => "Jinzhou\,\ Liaoning",
  861336417 => "Yingkou\,\ Liaoning",
  861336418 => "Fuxin\,\ Liaoning",
  861336419 => "Liaoyang\,\ Liaoning",
  861336420 => "Tieling\,\ Liaoning",
  861336421 => "Chaoyang\,\ Liaoning",
  861336422 => "Anshan\,\ Liaoning",
  861336423 => "Fushun\,\ Liaoning",
  861336424 => "Tieling\,\ Liaoning",
  861336425 => "Panjin\,\ Liaoning",
  861336426 => "Jinzhou\,\ Liaoning",
  861336427 => "Panjin\,\ Liaoning",
  861336428 => "Dandong\,\ Liaoning",
  861336429 => "Huludao\,\ Liaoning",
  861336430 => "Changchun\,\ Jilin",
  861336431 => "Changchun\,\ Jilin",
  861336432 => "Jilin\,\ Jilin",
  861336433 => "Yanbian\,\ Jilin",
  861336434 => "Siping\,\ Jilin",
  861336435 => "Tonghua\,\ Jilin",
  861336436 => "Baicheng\,\ Jilin",
  861336437 => "Liaoyuan\,\ Jilin",
  861336438 => "Songyuan\,\ Jilin",
  861336439 => "Baishan\,\ Jilin",
  861336440 => "Jilin\,\ Jilin",
  861336441 => "Jilin\,\ Jilin",
  861336442 => "Jilin\,\ Jilin",
  861336443 => "Yanbian\,\ Jilin",
  861336444 => "Jilin\,\ Jilin",
  861336445 => "Tonghua\,\ Jilin",
  861336446 => "Changchun\,\ Jilin",
  861336447 => "Changchun\,\ Jilin",
  861336448 => "Changchun\,\ Jilin",
  861336449 => "Baishan\,\ Jilin",
  861336450 => "Changchun\,\ Jilin",
  861336451 => "Changchun\,\ Jilin",
  861336452 => "Jilin\,\ Jilin",
  861336453 => "Songyuan\,\ Jilin",
  861336454 => "Changchun\,\ Jilin",
  861336455 => "Siping\,\ Jilin",
  861336456 => "Tonghua\,\ Jilin",
  861336457 => "Baicheng\,\ Jilin",
  861336458 => "Siping\,\ Jilin",
  861336459 => "Jilin\,\ Jilin",
  861336460 => "Changchun\,\ Jilin",
  861336461 => "Changchun\,\ Jilin",
  861336462 => "Jilin\,\ Jilin",
  861336463 => "Changchun\,\ Jilin",
  861336464 => "Changchun\,\ Jilin",
  861336465 => "Liaoyuan\,\ Jilin",
  861336466 => "Yanbian\,\ Jilin",
  861336467 => "Songyuan\,\ Jilin",
  861336468 => "Changchun\,\ Jilin",
  861336469 => "Changchun\,\ Jilin",
  861336470 => "Karamay\,\ Xinjiang",
  861336471 => "Ili\,\ Xinjiang",
  861336472 => "Aksu\,\ Xinjiang",
  861336473 => "Aksu\,\ Xinjiang",
  861336474 => "Kashi\,\ Xinjiang",
  861336475 => "Changji\,\ Xinjiang",
  861336476 => "Urumchi\,\ Xinjiang",
  861336477 => "Urumchi\,\ Xinjiang",
  861336478 => "Urumchi\,\ Xinjiang",
  861336479 => "Urumchi\,\ Xinjiang",
  861336480 => "Ili\,\ Xinjiang",
  861336481 => "Ili\,\ Xinjiang",
  861336482 => "Bortala\,\ Xinjiang",
  861336483 => "Tacheng\,\ Xinjiang",
  861336484 => "Bayingolin\,\ Xinjiang",
  861336485 => "Bayingolin\,\ Xinjiang",
  861336486 => "Altay\,\ Xinjiang",
  861336487 => "Aksu\,\ Xinjiang",
  861336488 => "Kashi\,\ Xinjiang",
  861336489 => "Hotan\,\ Xinjiang",
  861336490 => "Changji\,\ Xinjiang",
  861336491 => "Changji\,\ Xinjiang",
  861336492 => "Turpan\,\ Xinjiang",
  861336493 => "Hami\,\ Xinjiang",
  861336494 => "Hami\,\ Xinjiang",
  861336495 => "Ili\,\ Xinjiang",
  861336496 => "Ili\,\ Xinjiang",
  861336497 => "Shihezi\,\ Xinjiang",
  861336498 => "Shihezi\,\ Xinjiang",
  861336499 => "Karamay\,\ Xinjiang",
  861336500 => "Zhangzhou\,\ Fujian",
  861336501 => "Zhangzhou\,\ Fujian",
  861336502 => "Ningde\,\ Fujian",
  861336503 => "Ningde\,\ Fujian",
  861336504 => "Xiamen\,\ Fujian",
  861336505 => "Sanming\,\ Fujian",
  861336506 => "Sanming\,\ Fujian",
  861336507 => "Longyan\,\ Fujian",
  861336508 => "Longyan\,\ Fujian",
  861336509 => "Nanping\,\ Fujian",
  861336510 => "Yangzhou\,\ Jiangsu",
  861336511 => "Yangzhou\,\ Jiangsu",
  861336512 => "Yangzhou\,\ Jiangsu",
  861336513 => "Yangzhou\,\ Jiangsu",
  861336514 => "Yangzhou\,\ Jiangsu",
  861336515 => "Suqian\,\ Jiangsu",
  861336516 => "HuaiAn\,\ Jiangsu",
  861336517 => "HuaiAn\,\ Jiangsu",
  861336518 => "Yancheng\,\ Jiangsu",
  861336519 => "Yancheng\,\ Jiangsu",
  861336520 => "Taizhou\,\ Jiangsu",
  861336521 => "Taizhou\,\ Jiangsu",
  861336522 => "Taizhou\,\ Jiangsu",
  861336523 => "Taizhou\,\ Jiangsu",
  861336524 => "Taizhou\,\ Jiangsu",
  861336525 => "Suqian\,\ Jiangsu",
  861336526 => "Lianyungang\,\ Jiangsu",
  861336527 => "Lianyungang\,\ Jiangsu",
  861336528 => "Xuzhou\,\ Jiangsu",
  861336529 => "Xuzhou\,\ Jiangsu",
  861336530 => "Heze\,\ Shandong",
  861336531 => "Jinan\,\ Shandong",
  861336532 => "Qingdao\,\ Shandong",
  861336533 => "Zibo\,\ Shandong",
  861336534 => "Dezhou\,\ Shandong",
  861336535 => "Yantai\,\ Shandong",
  861336536 => "Weifang\,\ Shandong",
  861336537 => "Jining\,\ Shandong",
  861336538 => "TaiAn\,\ Shandong",
  861336539 => "Linyi\,\ Shandong",
  861336540 => "Heze\,\ Shandong",
  861336541 => "Jinan\,\ Shandong",
  861336542 => "Qingdao\,\ Shandong",
  861336543 => "Binzhou\,\ Shandong",
  861336544 => "Dezhou\,\ Shandong",
  861336545 => "Yantai\,\ Shandong",
  861336546 => "Dongying\,\ Shandong",
  861336547 => "Jining\,\ Shandong",
  861336548 => "TaiAn\,\ Shandong",
  861336549 => "Linyi\,\ Shandong",
  861336550 => "Chuzhou\,\ Anhui",
  861336551 => "Hefei\,\ Anhui",
  861336552 => "Bengbu\,\ Anhui",
  861336553 => "Wuhu\,\ Anhui",
  861336554 => "Huainan\,\ Anhui",
  861336555 => "MaAnshan\,\ Anhui",
  861336556 => "Anqing\,\ Anhui",
  861336557 => "Suzhou\,\ Anhui",
  861336558 => "Fuyang\,\ Anhui",
  861336559 => "Huangshan\,\ Anhui",
  861336560 => "Hefei\,\ Anhui",
  861336561 => "Huaibei\,\ Anhui",
  861336562 => "Tongling\,\ Anhui",
  861336563 => "Xuancheng\,\ Anhui",
  861336564 => "LuAn\,\ Anhui",
  861336565 => "Chaohu\,\ Anhui",
  861336566 => "Chizhou\,\ Anhui",
  861336567 => "Bozhou\,\ Anhui",
  861336568 => "LuAn\,\ Anhui",
  861336569 => "Hefei\,\ Anhui",
  861336570 => "Chuzhou\,\ Anhui",
  861336571 => "Wuhu\,\ Anhui",
  861336572 => "Bengbu\,\ Anhui",
  861336573 => "Wuhu\,\ Anhui",
  861336574 => "Hefei\,\ Anhui",
  861336575 => "Anqing\,\ Anhui",
  861336576 => "Anqing\,\ Anhui",
  861336577 => "Suzhou\,\ Anhui",
  861336578 => "Fuyang\,\ Anhui",
  861336579 => "Hefei\,\ Anhui",
  861336580 => "Yueyang\,\ Hunan",
  861336581 => "Zhuzhou\,\ Hunan",
  861336582 => "Xiangtan\,\ Hunan",
  861336583 => "Xiangxi\,\ Hunan",
  861336584 => "Zhangjiajie\,\ Hunan",
  861336585 => "Chenzhou\,\ Hunan",
  861336586 => "Yongzhou\,\ Hunan",
  861336587 => "Yiyang\,\ Hunan",
  861336588 => "Hengyang\,\ Hunan",
  861336589 => "Shaoyang\,\ Hunan",
  861336590 => "Xiamen\,\ Fujian",
  861336591 => "Fuzhou\,\ Fujian",
  861336592 => "Xiamen\,\ Fujian",
  861336593 => "Putian\,\ Fujian",
  861336594 => "Putian\,\ Fujian",
  861336595 => "Quanzhou\,\ Fujian",
  861336596 => "Quanzhou\,\ Fujian",
  861336597 => "Quanzhou\,\ Fujian",
  861336598 => "Quanzhou\,\ Fujian",
  861336599 => "Nanping\,\ Fujian",
  8613366 => "Beijing",
  861336700 => "Nanchang\,\ Jiangxi",
  861336701 => "Yingtan\,\ Jiangxi",
  861336702 => "Jiujiang\,\ Jiangxi",
  861336703 => "Shangrao\,\ Jiangxi",
  861336704 => "Fuzhou\,\ Jiangxi",
  861336705 => "Yichun\,\ Jiangxi",
  861336706 => "JiAn\,\ Jiangxi",
  861336707 => "Ganzhou\,\ Jiangxi",
  861336708 => "Nanchang\,\ Jiangxi",
  861336709 => "Nanchang\,\ Jiangxi",
  861336710 => "Xiangfan\,\ Hubei",
  861336711 => "Ezhou\,\ Hubei",
  861336712 => "Xiaogan\,\ Hubei",
  861336713 => "Huanggang\,\ Hubei",
  861336714 => "Huangshi\,\ Hubei",
  861336715 => "Xianning\,\ Hubei",
  861336716 => "Jingzhou\,\ Hubei",
  861336717 => "Yichang\,\ Hubei",
  861336718 => "Enshi\,\ Hubei",
  861336719 => "Shiyan\,\ Hubei",
  861336720 => "Xiantao\,\ Hubei",
  861336721 => "Wuhan\,\ Hubei",
  861336722 => "Wuhan\,\ Hubei",
  861336723 => "Jingmen\,\ Hubei",
  861336724 => "Wuhan\,\ Hubei",
  861336725 => "Wuhan\,\ Hubei",
  861336726 => "Wuhan\,\ Hubei",
  861336727 => "Wuhan\,\ Hubei",
  861336728 => "Wuhan\,\ Hubei",
  861336729 => "Suizhou\,\ Hubei",
  861336730 => "Yueyang\,\ Hunan",
  861336731 => "Changsha\,\ Hunan",
  861336732 => "Xiangtan\,\ Hunan",
  861336733 => "Zhuzhou\,\ Hunan",
  861336734 => "Hengyang\,\ Hunan",
  861336735 => "Chenzhou\,\ Hunan",
  861336736 => "Changde\,\ Hunan",
  861336737 => "Yiyang\,\ Hunan",
  861336738 => "Loudi\,\ Hunan",
  861336739 => "Shaoyang\,\ Hunan",
  861336740 => "Yueyang\,\ Hunan",
  861336741 => "Zhuzhou\,\ Hunan",
  861336742 => "Xiangtan\,\ Hunan",
  861336743 => "Xiangxi\,\ Hunan",
  861336744 => "Zhangjiajie\,\ Hunan",
  861336745 => "Huaihua\,\ Hunan",
  861336746 => "Yongzhou\,\ Hunan",
  861336747 => "Hengyang\,\ Hunan",
  861336748 => "Changsha\,\ Hunan",
  861336749 => "Changsha\,\ Hunan",
  861336750 => "Fangchenggang\,\ Guangxi",
  861336751 => "Nanning\,\ Guangxi",
  861336752 => "Liuzhou\,\ Guangxi",
  861336753 => "Guilin\,\ Guangxi",
  861336754 => "Hezhou\,\ Guangxi",
  861336755 => "Yulin\,\ Guangxi",
  861336756 => "Baise\,\ Guangxi",
  861336757 => "Guigang\,\ Guangxi",
  861336758 => "Hechi\,\ Guangxi",
  861336759 => "Beihai\,\ Guangxi",
  861336760 => "Wuzhou\,\ Guangxi",
  861336761 => "Nanning\,\ Guangxi",
  861336762 => "Liuzhou\,\ Guangxi",
  861336763 => "Guilin\,\ Guangxi",
  861336764 => "Wuzhou\,\ Guangxi",
  861336765 => "Guigang\,\ Guangxi",
  861336766 => "Baise\,\ Guangxi",
  861336767 => "Qinzhou\,\ Guangxi",
  861336768 => "Hechi\,\ Guangxi",
  861336769 => "Beihai\,\ Guangxi",
  861336770 => "Fangchenggang\,\ Guangxi",
  861336771 => "Nanning\,\ Guangxi",
  861336772 => "Liuzhou\,\ Guangxi",
  861336773 => "Guilin\,\ Guangxi",
  861336774 => "Hezhou\,\ Guangxi",
  861336775 => "Yulin\,\ Guangxi",
  861336776 => "Baise\,\ Guangxi",
  861336777 => "Qinzhou\,\ Guangxi",
  861336778 => "Hechi\,\ Guangxi",
  861336779 => "Beihai\,\ Guangxi",
  861336780 => "Nanning\,\ Guangxi",
  861336781 => "Nanning\,\ Guangxi",
  861336782 => "Liuzhou\,\ Guangxi",
  861336783 => "Guilin\,\ Guangxi",
  861336784 => "Hezhou\,\ Guangxi",
  861336785 => "Yulin\,\ Guangxi",
  861336786 => "Baise\,\ Guangxi",
  861336787 => "Wuzhou\,\ Guangxi",
  861336788 => "Hechi\,\ Guangxi",
  861336789 => "Beihai\,\ Guangxi",
  861336790 => "Xinyu\,\ Jiangxi",
  861336791 => "Nanchang\,\ Jiangxi",
  861336792 => "Jiujiang\,\ Jiangxi",
  861336793 => "Shangrao\,\ Jiangxi",
  861336794 => "Fuzhou\,\ Jiangxi",
  861336795 => "Yichun\,\ Jiangxi",
  861336796 => "JiAn\,\ Jiangxi",
  861336797 => "Ganzhou\,\ Jiangxi",
  861336798 => "Jingdezhen\,\ Jiangxi",
  861336799 => "Pingxiang\,\ Jiangxi",
  86133680 => "Chongqing",
  86133681 => "Chongqing",
  86133682 => "Chongqing",
  86133683 => "Chongqing",
  86133684 => "Chongqing",
  861336850 => "Guiyang\,\ Guizhou",
  861336851 => "Guiyang\,\ Guizhou",
  861336852 => "Zunyi\,\ Guizhou",
  861336853 => "Anshun\,\ Guizhou",
  861336854 => "Qiannan\,\ Guizhou",
  861336855 => "Qiandongnan\,\ Guizhou",
  861336856 => "Tongren\,\ Guizhou",
  861336857 => "Bijie\,\ Guizhou",
  861336858 => "Liupanshui\,\ Guizhou",
  861336859 => "Qianxinan\,\ Guizhou",
  861336860 => "Guiyang\,\ Guizhou",
  861336861 => "Guiyang\,\ Guizhou",
  861336862 => "Zunyi\,\ Guizhou",
  861336863 => "Anshun\,\ Guizhou",
  861336864 => "Qiannan\,\ Guizhou",
  861336865 => "Qiandongnan\,\ Guizhou",
  861336866 => "Zunyi\,\ Guizhou",
  861336867 => "Bijie\,\ Guizhou",
  861336868 => "Liupanshui\,\ Guizhou",
  861336869 => "Guiyang\,\ Guizhou",
  861336870 => "Zhaotong\,\ Yunnan",
  861336871 => "Kunming\,\ Yunnan",
  861336872 => "Dali\,\ Yunnan",
  861336873 => "Honghe\,\ Yunnan",
  861336874 => "Qujing\,\ Yunnan",
  861336875 => "Baoshan\,\ Yunnan",
  861336876 => "Wenshan\,\ Yunnan",
  861336877 => "Yuxi\,\ Yunnan",
  861336878 => "Chuxiong\,\ Yunnan",
  861336879 => "Puer\,\ Yunnan",
  861336880 => "Kunming\,\ Yunnan",
  861336881 => "Xishuangbanna\,\ Yunnan",
  861336882 => "Dehong\,\ Yunnan",
  861336883 => "Lincang\,\ Yunnan",
  861336884 => "Kunming\,\ Yunnan",
  861336885 => "Kunming\,\ Yunnan",
  861336886 => "Nujiang\,\ Yunnan",
  861336887 => "Deqen\,\ Yunnan",
  861336888 => "Lijiang\,\ Yunnan",
  861336889 => "Yuxi\,\ Yunnan",
  86133689 => "Haikou\,\ Hainan",
  861336900 => "Changji\,\ Xinjiang",
  861336901 => "Tacheng\,\ Xinjiang",
  861336902 => "Hami\,\ Xinjiang",
  861336903 => "Hotan\,\ Xinjiang",
  861336904 => "Ili\,\ Xinjiang",
  861336905 => "Karamay\,\ Xinjiang",
  861336906 => "Altay\,\ Xinjiang",
  861336907 => "Bayingolin\,\ Xinjiang",
  861336908 => "Kizilsu\,\ Xinjiang",
  861336909 => "Bortala\,\ Xinjiang",
  861336910 => "Xianyang\,\ Shaanxi",
  861336911 => "Xianyang\,\ Shaanxi",
  861336912 => "Xianyang\,\ Shaanxi",
  861336913 => "Weinan\,\ Shaanxi",
  861336914 => "Weinan\,\ Shaanxi",
  861336915 => "Weinan\,\ Shaanxi",
  861336916 => "Weinan\,\ Shaanxi",
  861336917 => "Weinan\,\ Shaanxi",
  861336918 => "Weinan\,\ Shaanxi",
  861336919 => "Baoji\,\ Shaanxi",
  861336920 => "Baoji\,\ Shaanxi",
  861336921 => "Baoji\,\ Shaanxi",
  861336922 => "Hanzhong\,\ Shaanxi",
  861336923 => "Hanzhong\,\ Shaanxi",
  861336924 => "Hanzhong\,\ Shaanxi",
  861336925 => "Hanzhong\,\ Shaanxi",
  861336926 => "YanAn\,\ Shaanxi",
  861336927 => "YanAn\,\ Shaanxi",
  861336928 => "YanAn\,\ Shaanxi",
  861336929 => "YanAn\,\ Shaanxi",
  861336930 => "Linxia\,\ Gansu",
  861336931 => "Lanzhou\,\ Gansu",
  861336932 => "Dingxi\,\ Gansu",
  861336933 => "Pingliang\,\ Gansu",
  861336934 => "Qingyang\,\ Gansu",
  861336935 => "Wuwei\,\ Gansu",
  861336936 => "Zhangye\,\ Gansu",
  861336937 => "Jiuquan\,\ Gansu",
  861336938 => "Tianshui\,\ Gansu",
  861336939 => "Longnan\,\ Gansu",
  861336940 => "Wuwei\,\ Gansu",
  861336941 => "Tianshui\,\ Gansu",
  861336942 => "Qingyang\,\ Gansu",
  861336943 => "Lanzhou\,\ Gansu",
  861336944 => "Lanzhou\,\ Gansu",
  861336945 => "Lanzhou\,\ Gansu",
  861336946 => "Lanzhou\,\ Gansu",
  861336947 => "Jiuquan\,\ Gansu",
  861336948 => "Lanzhou\,\ Gansu",
  861336949 => "Lanzhou\,\ Gansu",
  861336950 => "Yinchuan\,\ Ningxia",
  861336951 => "Yinchuan\,\ Ningxia",
  861336952 => "Shizuishan\,\ Ningxia",
  861336953 => "Wuzhong\,\ Ningxia",
  861336954 => "Guyuan\,\ Ningxia",
  861336955 => "Zhongwei\,\ Ningxia",
  861336956 => "Shizuishan\,\ Ningxia",
  861336957 => "Yinchuan\,\ Ningxia",
  861336958 => "Yinchuan\,\ Ningxia",
  861336959 => "Yinchuan\,\ Ningxia",
  86133696 => "Urumchi\,\ Xinjiang",
  861336970 => "Haibei\,\ Qinghai",
  861336971 => "Xining\,\ Qinghai",
  861336972 => "Haidong\,\ Qinghai",
  861336973 => "Huangnan\,\ Qinghai",
  861336974 => "Hainan\,\ Qinghai",
  861336975 => "Haidong\,\ Qinghai",
  861336976 => "Xining\,\ Qinghai",
  861336977 => "Haixi\,\ Qinghai",
  861336978 => "Xining\,\ Qinghai",
  861336979 => "Haixi\,\ Qinghai",
  861336980 => "Changji\,\ Xinjiang",
  861336981 => "Shihezi\,\ Xinjiang",
  861336982 => "Ili\,\ Xinjiang",
  861336983 => "Bortala\,\ Xinjiang",
  861336984 => "Kizilsu\,\ Xinjiang",
  861336985 => "Bayingolin\,\ Xinjiang",
  861336986 => "Bayingolin\,\ Xinjiang",
  861336987 => "Aksu\,\ Xinjiang",
  861336988 => "Aksu\,\ Xinjiang",
  861336989 => "Kashi\,\ Xinjiang",
  861336990 => "Karamay\,\ Xinjiang",
  861336991 => "Urumchi\,\ Xinjiang",
  861336992 => "Ili\,\ Xinjiang",
  861336993 => "Shihezi\,\ Xinjiang",
  861336994 => "Changji\,\ Xinjiang",
  861336995 => "Turpan\,\ Xinjiang",
  861336996 => "Bayingolin\,\ Xinjiang",
  861336997 => "Aksu\,\ Xinjiang",
  861336998 => "Kashi\,\ Xinjiang",
  861336999 => "Ili\,\ Xinjiang",
  86133700 => "Shanghai",
  86133701 => "Beijing",
  86133702 => "Shanghai",
  86133703 => "Tianjin",
  86133704 => "Tianjin",
  86133705 => "Jinan\,\ Shandong",
  861337060 => "TaiAn\,\ Shandong",
  861337061 => "TaiAn\,\ Shandong",
  861337062 => "TaiAn\,\ Shandong",
  861337063 => "Rizhao\,\ Shandong",
  861337064 => "Rizhao\,\ Shandong",
  861337065 => "Linyi\,\ Shandong",
  861337066 => "Linyi\,\ Shandong",
  861337067 => "Zibo\,\ Shandong",
  861337068 => "Zibo\,\ Shandong",
  861337069 => "Zibo\,\ Shandong",
  86133707 => "Chongqing",
  86133708 => "Qingdao\,\ Shandong",
  861337090 => "Weihai\,\ Shandong",
  861337091 => "Yantai\,\ Shandong",
  861337092 => "Yantai\,\ Shandong",
  861337093 => "Yantai\,\ Shandong",
  861337094 => "Yantai\,\ Shandong",
  861337095 => "Liaocheng\,\ Shandong",
  861337096 => "Liaocheng\,\ Shandong",
  861337097 => "Liaocheng\,\ Shandong",
  861337098 => "Zaozhuang\,\ Shandong",
  861337099 => "Zaozhuang\,\ Shandong",
  861337100 => "TaiAn\,\ Shandong",
  861337101 => "TaiAn\,\ Shandong",
  861337102 => "TaiAn\,\ Shandong",
  861337103 => "TaiAn\,\ Shandong",
  861337104 => "Weifang\,\ Shandong",
  861337105 => "Weifang\,\ Shandong",
  861337106 => "Weifang\,\ Shandong",
  861337107 => "Weifang\,\ Shandong",
  861337108 => "Weifang\,\ Shandong",
  861337109 => "Weifang\,\ Shandong",
  861337110 => "Zaozhuang\,\ Shandong",
  861337111 => "Zaozhuang\,\ Shandong",
  861337112 => "Zaozhuang\,\ Shandong",
  861337113 => "Zaozhuang\,\ Shandong",
  861337114 => "Weihai\,\ Shandong",
  861337115 => "Weihai\,\ Shandong",
  861337116 => "Weihai\,\ Shandong",
  861337117 => "Weihai\,\ Shandong",
  861337118 => "Weihai\,\ Shandong",
  861337119 => "Weihai\,\ Shandong",
  861337120 => "Jining\,\ Shandong",
  861337121 => "Jining\,\ Shandong",
  861337122 => "Jining\,\ Shandong",
  861337123 => "Jining\,\ Shandong",
  861337124 => "Jining\,\ Shandong",
  861337125 => "Jining\,\ Shandong",
  861337126 => "Linyi\,\ Shandong",
  861337127 => "Linyi\,\ Shandong",
  861337128 => "Linyi\,\ Shandong",
  861337129 => "Linyi\,\ Shandong",
  861337130 => "Binzhou\,\ Shandong",
  861337131 => "Binzhou\,\ Shandong",
  861337132 => "Binzhou\,\ Shandong",
  861337133 => "Binzhou\,\ Shandong",
  861337134 => "Binzhou\,\ Shandong",
  861337135 => "Yantai\,\ Shandong",
  861337136 => "Yantai\,\ Shandong",
  861337137 => "Yantai\,\ Shandong",
  861337138 => "Yantai\,\ Shandong",
  861337139 => "Yantai\,\ Shandong",
  861337140 => "Zibo\,\ Shandong",
  861337141 => "Dongying\,\ Shandong",
  861337142 => "Zaozhuang\,\ Shandong",
  861337143 => "Zaozhuang\,\ Shandong",
  861337144 => "Weifang\,\ Shandong",
  861337145 => "Weifang\,\ Shandong",
  861337146 => "Liaocheng\,\ Shandong",
  861337147 => "Liaocheng\,\ Shandong",
  861337148 => "Qingdao\,\ Shandong",
  861337149 => "Qingdao\,\ Shandong",
  861337150 => "Dongying\,\ Shandong",
  861337151 => "Dongying\,\ Shandong",
  861337152 => "Dongying\,\ Shandong",
  861337153 => "Dongying\,\ Shandong",
  861337154 => "Dongying\,\ Shandong",
  861337155 => "Dongying\,\ Shandong",
  861337156 => "Zibo\,\ Shandong",
  861337157 => "Zibo\,\ Shandong",
  861337158 => "Zibo\,\ Shandong",
  861337159 => "Zibo\,\ Shandong",
  86133716 => "Beijing",
  86133717 => "Beijing",
  86133718 => "Shanghai",
  86133719 => "Shanghai",
  861337200 => "Nanjing\,\ Jiangsu",
  861337201 => "Nanjing\,\ Jiangsu",
  861337202 => "Nanjing\,\ Jiangsu",
  861337203 => "Nanjing\,\ Jiangsu",
  861337204 => "Suqian\,\ Jiangsu",
  861337205 => "Suqian\,\ Jiangsu",
  861337206 => "Suqian\,\ Jiangsu",
  861337207 => "Nantong\,\ Jiangsu",
  861337208 => "Nantong\,\ Jiangsu",
  861337209 => "Nantong\,\ Jiangsu",
  861337210 => "Suzhou\,\ Jiangsu",
  861337211 => "Suzhou\,\ Jiangsu",
  861337212 => "Suzhou\,\ Jiangsu",
  861337213 => "Suzhou\,\ Jiangsu",
  861337214 => "Suzhou\,\ Jiangsu",
  861337215 => "Suzhou\,\ Jiangsu",
  861337216 => "Suzhou\,\ Jiangsu",
  861337217 => "Suzhou\,\ Jiangsu",
  861337218 => "Suzhou\,\ Jiangsu",
  861337219 => "Changzhou\,\ Jiangsu",
  861337220 => "Xuzhou\,\ Jiangsu",
  861337221 => "Xuzhou\,\ Jiangsu",
  861337222 => "Xuzhou\,\ Jiangsu",
  861337223 => "Xuzhou\,\ Jiangsu",
  861337224 => "Changzhou\,\ Jiangsu",
  861337225 => "Changzhou\,\ Jiangsu",
  861337226 => "Changzhou\,\ Jiangsu",
  861337227 => "Changzhou\,\ Jiangsu",
  861337228 => "Changzhou\,\ Jiangsu",
  861337229 => "Changzhou\,\ Jiangsu",
  861337230 => "Jiaxing\,\ Zhejiang",
  861337231 => "Jiaxing\,\ Zhejiang",
  861337232 => "Jiaxing\,\ Zhejiang",
  861337233 => "Jiaxing\,\ Zhejiang",
  861337234 => "Taizhou\,\ Zhejiang",
  861337235 => "Taizhou\,\ Zhejiang",
  861337236 => "Taizhou\,\ Zhejiang",
  861337237 => "Taizhou\,\ Zhejiang",
  861337238 => "Lishui\,\ Zhejiang",
  861337239 => "Lishui\,\ Zhejiang",
  861337240 => "Hangzhou\,\ Zhejiang",
  861337241 => "Hangzhou\,\ Zhejiang",
  861337242 => "Quzhou\,\ Zhejiang",
  861337243 => "Jiaxing\,\ Zhejiang",
  861337244 => "Ningbo\,\ Zhejiang",
  861337245 => "Ningbo\,\ Zhejiang",
  861337246 => "Wenzhou\,\ Zhejiang",
  861337247 => "Wenzhou\,\ Zhejiang",
  861337248 => "Lishui\,\ Zhejiang",
  861337249 => "Jinhua\,\ Zhejiang",
  861337250 => "Hangzhou\,\ Zhejiang",
  861337251 => "Hangzhou\,\ Zhejiang",
  861337252 => "Hangzhou\,\ Zhejiang",
  861337253 => "Hangzhou\,\ Zhejiang",
  861337254 => "Hangzhou\,\ Zhejiang",
  861337255 => "Hangzhou\,\ Zhejiang",
  861337256 => "Hangzhou\,\ Zhejiang",
  861337257 => "Hangzhou\,\ Zhejiang",
  861337258 => "Quzhou\,\ Zhejiang",
  861337259 => "Zhoushan\,\ Zhejiang",
  86133726 => "Chongqing",
  86133727 => "Chongqing",
  861337280 => "Tieling\,\ Liaoning",
  861337281 => "Panjin\,\ Liaoning",
  861337282 => "Shenyang\,\ Liaoning",
  861337283 => "Shenyang\,\ Liaoning",
  861337284 => "Fushun\,\ Liaoning",
  861337285 => "Anshan\,\ Liaoning",
  861337286 => "Dalian\,\ Liaoning",
  861337287 => "Dalian\,\ Liaoning",
  861337288 => "Benxi\,\ Liaoning",
  861337289 => "Benxi\,\ Liaoning",
  861337290 => "Huludao\,\ Liaoning",
  861337291 => "Panjin\,\ Liaoning",
  861337292 => "Chaoyang\,\ Liaoning",
  861337293 => "Tieling\,\ Liaoning",
  861337294 => "Liaoyang\,\ Liaoning",
  861337295 => "Fuxin\,\ Liaoning",
  861337296 => "Yingkou\,\ Liaoning",
  861337297 => "Jinzhou\,\ Liaoning",
  861337298 => "Dandong\,\ Liaoning",
  861337299 => "Dandong\,\ Liaoning",
  861337300 => "Handan\,\ Hebei",
  861337301 => "Shijiazhuang\,\ Hebei",
  861337302 => "Baoding\,\ Hebei",
  861337303 => "Zhangjiakou\,\ Hebei",
  861337304 => "Shijiazhuang\,\ Hebei",
  861337305 => "Tangshan\,\ Hebei",
  861337306 => "Langfang\,\ Hebei",
  861337307 => "Cangzhou\,\ Hebei",
  861337308 => "Hengshui\,\ Hebei",
  861337309 => "Xingtai\,\ Hebei",
  861337310 => "Handan\,\ Hebei",
  861337311 => "Shijiazhuang\,\ Hebei",
  861337312 => "Baoding\,\ Hebei",
  861337313 => "Zhangjiakou\,\ Hebei",
  861337314 => "Chengde\,\ Hebei",
  861337315 => "Tangshan\,\ Hebei",
  861337316 => "Langfang\,\ Hebei",
  861337317 => "Cangzhou\,\ Hebei",
  861337318 => "Hengshui\,\ Hebei",
  861337319 => "Xingtai\,\ Hebei",
  861337320 => "Handan\,\ Hebei",
  861337321 => "Shijiazhuang\,\ Hebei",
  861337322 => "Baoding\,\ Hebei",
  861337323 => "Cangzhou\,\ Hebei",
  861337324 => "Baoding\,\ Hebei",
  861337325 => "Tangshan\,\ Hebei",
  861337326 => "Langfang\,\ Hebei",
  861337327 => "Qinhuangdao\,\ Hebei",
  861337328 => "Qinhuangdao\,\ Hebei",
  861337329 => "Tangshan\,\ Hebei",
  861337330 => "Handan\,\ Hebei",
  861337331 => "Shijiazhuang\,\ Hebei",
  861337332 => "Baoding\,\ Hebei",
  861337333 => "Zhangjiakou\,\ Hebei",
  861337334 => "Shijiazhuang\,\ Hebei",
  861337335 => "Qinhuangdao\,\ Hebei",
  861337336 => "Langfang\,\ Hebei",
  861337337 => "Cangzhou\,\ Hebei",
  861337338 => "Hengshui\,\ Hebei",
  861337339 => "Xingtai\,\ Hebei",
  861337340 => "Handan\,\ Hebei",
  861337341 => "Shijiazhuang\,\ Hebei",
  861337342 => "Baoding\,\ Hebei",
  861337343 => "Zhangjiakou\,\ Hebei",
  861337344 => "Qinhuangdao\,\ Hebei",
  861337345 => "Tangshan\,\ Hebei",
  861337346 => "Langfang\,\ Hebei",
  861337347 => "Cangzhou\,\ Hebei",
  861337348 => "Hengshui\,\ Hebei",
  861337349 => "Xingtai\,\ Hebei",
  861337350 => "Handan\,\ Hebei",
  861337351 => "Shijiazhuang\,\ Hebei",
  861337352 => "Baoding\,\ Hebei",
  861337353 => "Cangzhou\,\ Hebei",
  861337354 => "Baoding\,\ Hebei",
  861337355 => "Tangshan\,\ Hebei",
  861337356 => "Langfang\,\ Hebei",
  861337357 => "Tangshan\,\ Hebei",
  861337358 => "Chengde\,\ Hebei",
  861337359 => "Tangshan\,\ Hebei",
  861337360 => "Wuxi\,\ Jiangsu",
  861337361 => "Wuxi\,\ Jiangsu",
  861337362 => "Wuxi\,\ Jiangsu",
  861337363 => "Wuxi\,\ Jiangsu",
  861337364 => "Wuxi\,\ Jiangsu",
  861337365 => "Wuxi\,\ Jiangsu",
  861337366 => "Wuxi\,\ Jiangsu",
  861337367 => "Yangzhou\,\ Jiangsu",
  861337368 => "Yangzhou\,\ Jiangsu",
  861337369 => "Yangzhou\,\ Jiangsu",
  861337370 => "Anyang\,\ Henan",
  861337371 => "Anyang\,\ Henan",
  861337372 => "Anyang\,\ Henan",
  861337373 => "Xinxiang\,\ Henan",
  861337374 => "Xinxiang\,\ Henan",
  861337375 => "Xinxiang\,\ Henan",
  861337376 => "Xinxiang\,\ Henan",
  861337377 => "Luoyang\,\ Henan",
  861337378 => "Luoyang\,\ Henan",
  861337379 => "Luoyang\,\ Henan",
  861337380 => "Jinhua\,\ Zhejiang",
  861337381 => "Jinhua\,\ Zhejiang",
  861337382 => "Jinhua\,\ Zhejiang",
  861337383 => "Jinhua\,\ Zhejiang",
  861337384 => "Jinhua\,\ Zhejiang",
  861337385 => "Wenzhou\,\ Zhejiang",
  861337386 => "Wenzhou\,\ Zhejiang",
  861337387 => "Ningbo\,\ Zhejiang",
  861337388 => "Ningbo\,\ Zhejiang",
  861337389 => "Ningbo\,\ Zhejiang",
  861337390 => "Zhengzhou\,\ Henan",
  861337391 => "Zhengzhou\,\ Henan",
  861337392 => "Zhengzhou\,\ Henan",
  861337393 => "Zhengzhou\,\ Henan",
  861337394 => "Zhengzhou\,\ Henan",
  861337395 => "Zhengzhou\,\ Henan",
  861337396 => "Sanmenxia\,\ Henan",
  861337397 => "Sanmenxia\,\ Henan",
  861337398 => "Sanmenxia\,\ Henan",
  861337399 => "Sanmenxia\,\ Henan",
  8613374 => "Taiyuan\,\ Shanxi",
  861337500 => "Fuzhou\,\ Fujian",
  861337501 => "Nanping\,\ Fujian",
  861337502 => "Nanping\,\ Fujian",
  861337503 => "Zhangzhou\,\ Fujian",
  861337504 => "Longyan\,\ Fujian",
  861337505 => "Putian\,\ Fujian",
  861337506 => "Putian\,\ Fujian",
  861337507 => "Sanming\,\ Fujian",
  861337508 => "Longyan\,\ Fujian",
  861337509 => "Longyan\,\ Fujian",
  861337510 => "Xuzhou\,\ Jiangsu",
  861337511 => "Xuzhou\,\ Jiangsu",
  861337512 => "Xuzhou\,\ Jiangsu",
  861337513 => "Xuzhou\,\ Jiangsu",
  861337514 => "Xuzhou\,\ Jiangsu",
  861337515 => "Suzhou\,\ Jiangsu",
  861337516 => "Suzhou\,\ Jiangsu",
  861337517 => "Suzhou\,\ Jiangsu",
  861337518 => "Suzhou\,\ Jiangsu",
  861337519 => "Suzhou\,\ Jiangsu",
  861337520 => "HuaiAn\,\ Jiangsu",
  861337521 => "HuaiAn\,\ Jiangsu",
  861337522 => "HuaiAn\,\ Jiangsu",
  861337523 => "Yancheng\,\ Jiangsu",
  861337524 => "Yancheng\,\ Jiangsu",
  861337525 => "Yancheng\,\ Jiangsu",
  861337526 => "Yancheng\,\ Jiangsu",
  861337527 => "Yangzhou\,\ Jiangsu",
  861337528 => "Yangzhou\,\ Jiangsu",
  861337529 => "Yangzhou\,\ Jiangsu",
  861337530 => "Heze\,\ Shandong",
  861337531 => "Jinan\,\ Shandong",
  861337532 => "Qingdao\,\ Shandong",
  861337533 => "Zibo\,\ Shandong",
  861337534 => "Dezhou\,\ Shandong",
  861337535 => "Yantai\,\ Shandong",
  861337536 => "Weifang\,\ Shandong",
  861337537 => "Jining\,\ Shandong",
  861337538 => "TaiAn\,\ Shandong",
  861337539 => "Linyi\,\ Shandong",
  861337540 => "Heze\,\ Shandong",
  861337541 => "Jinan\,\ Shandong",
  861337542 => "Qingdao\,\ Shandong",
  861337543 => "Binzhou\,\ Shandong",
  861337544 => "Dezhou\,\ Shandong",
  861337545 => "Yantai\,\ Shandong",
  861337546 => "Dongying\,\ Shandong",
  861337547 => "Jining\,\ Shandong",
  861337548 => "TaiAn\,\ Shandong",
  861337549 => "Linyi\,\ Shandong",
  861337550 => "Dezhou\,\ Shandong",
  861337551 => "Dezhou\,\ Shandong",
  861337552 => "Rizhao\,\ Shandong",
  861337553 => "Rizhao\,\ Shandong",
  861337554 => "Rizhao\,\ Shandong",
  861337555 => "Qingdao\,\ Shandong",
  861337556 => "Qingdao\,\ Shandong",
  861337557 => "Qingdao\,\ Shandong",
  861337558 => "Qingdao\,\ Shandong",
  861337559 => "Zibo\,\ Shandong",
  861337560 => "Liaocheng\,\ Shandong",
  861337561 => "Liaocheng\,\ Shandong",
  861337562 => "TaiAn\,\ Shandong",
  861337563 => "TaiAn\,\ Shandong",
  861337564 => "Zaozhuang\,\ Shandong",
  861337565 => "Zaozhuang\,\ Shandong",
  861337566 => "Zaozhuang\,\ Shandong",
  861337567 => "Zaozhuang\,\ Shandong",
  861337568 => "Linyi\,\ Shandong",
  861337569 => "Linyi\,\ Shandong",
  861337570 => "Quzhou\,\ Zhejiang",
  861337571 => "Hangzhou\,\ Zhejiang",
  861337572 => "Huzhou\,\ Zhejiang",
  861337573 => "Jiaxing\,\ Zhejiang",
  861337574 => "Ningbo\,\ Zhejiang",
  861337575 => "Shaoxing\,\ Zhejiang",
  861337576 => "Taizhou\,\ Zhejiang",
  861337577 => "Wenzhou\,\ Zhejiang",
  861337578 => "Lishui\,\ Zhejiang",
  861337579 => "Jinhua\,\ Zhejiang",
  861337580 => "Zhoushan\,\ Zhejiang",
  861337581 => "Hangzhou\,\ Zhejiang",
  861337582 => "Huzhou\,\ Zhejiang",
  861337583 => "Jiaxing\,\ Zhejiang",
  861337584 => "Ningbo\,\ Zhejiang",
  861337585 => "Shaoxing\,\ Zhejiang",
  861337586 => "Taizhou\,\ Zhejiang",
  861337587 => "Wenzhou\,\ Zhejiang",
  861337588 => "Lishui\,\ Zhejiang",
  861337589 => "Jinhua\,\ Zhejiang",
  861337590 => "Sanming\,\ Fujian",
  861337591 => "Fuzhou\,\ Fujian",
  861337592 => "Xiamen\,\ Fujian",
  861337593 => "Ningde\,\ Fujian",
  861337594 => "Putian\,\ Fujian",
  861337595 => "Quanzhou\,\ Fujian",
  861337596 => "Zhangzhou\,\ Fujian",
  861337597 => "Sanming\,\ Fujian",
  861337598 => "Fuzhou\,\ Fujian",
  861337599 => "Quanzhou\,\ Fujian",
  861337600 => "Taizhou\,\ Jiangsu",
  861337601 => "Taizhou\,\ Jiangsu",
  861337602 => "Taizhou\,\ Jiangsu",
  861337603 => "Taizhou\,\ Jiangsu",
  861337604 => "Zhenjiang\,\ Jiangsu",
  861337605 => "Nanjing\,\ Jiangsu",
  861337606 => "Nanjing\,\ Jiangsu",
  861337607 => "Nanjing\,\ Jiangsu",
  861337608 => "Nanjing\,\ Jiangsu",
  861337609 => "Nanjing\,\ Jiangsu",
  861337610 => "Nantong\,\ Jiangsu",
  861337611 => "Nantong\,\ Jiangsu",
  861337612 => "Nantong\,\ Jiangsu",
  861337613 => "Nantong\,\ Jiangsu",
  861337614 => "Zhenjiang\,\ Jiangsu",
  861337615 => "Zhenjiang\,\ Jiangsu",
  861337616 => "Zhenjiang\,\ Jiangsu",
  861337617 => "Zhenjiang\,\ Jiangsu",
  861337618 => "Zhenjiang\,\ Jiangsu",
  861337619 => "Zhenjiang\,\ Jiangsu",
  861337620 => "Wuxi\,\ Jiangsu",
  861337621 => "Wuxi\,\ Jiangsu",
  861337622 => "Wuxi\,\ Jiangsu",
  861337623 => "Wuxi\,\ Jiangsu",
  861337624 => "Wuxi\,\ Jiangsu",
  861337625 => "Changzhou\,\ Jiangsu",
  861337626 => "Changzhou\,\ Jiangsu",
  861337627 => "Changzhou\,\ Jiangsu",
  861337628 => "Changzhou\,\ Jiangsu",
  861337629 => "Changzhou\,\ Jiangsu",
  861337630 => "Weihai\,\ Shandong",
  861337631 => "Weihai\,\ Shandong",
  861337632 => "Zaozhuang\,\ Shandong",
  861337633 => "Rizhao\,\ Shandong",
  861337634 => "Laiwu\,\ Shandong",
  861337635 => "Liaocheng\,\ Shandong",
  861337636 => "Weifang\,\ Shandong",
  861337637 => "Zaozhuang\,\ Shandong",
  861337638 => "Yantai\,\ Shandong",
  861337639 => "Qingdao\,\ Shandong",
  861337640 => "Jinan\,\ Shandong",
  861337641 => "Jinan\,\ Shandong",
  861337642 => "Qingdao\,\ Shandong",
  861337643 => "Zibo\,\ Shandong",
  861337644 => "Jinan\,\ Shandong",
  861337645 => "Yantai\,\ Shandong",
  861337646 => "Weifang\,\ Shandong",
  861337647 => "Dongying\,\ Shandong",
  861337648 => "Qingdao\,\ Shandong",
  861337649 => "Binzhou\,\ Shandong",
  861337650 => "Meizhou\,\ Guangdong",
  861337651 => "Jieyang\,\ Guangdong",
  861337652 => "Jieyang\,\ Guangdong",
  861337653 => "Jieyang\,\ Guangdong",
  861337654 => "Jieyang\,\ Guangdong",
  861337655 => "Zhaoqing\,\ Guangdong",
  861337656 => "Zhaoqing\,\ Guangdong",
  861337657 => "Zhaoqing\,\ Guangdong",
  861337658 => "Shaoguan\,\ Guangdong",
  861337659 => "Shaoguan\,\ Guangdong",
  861337660 => "Shanwei\,\ Guangdong",
  861337661 => "Shantou\,\ Guangdong",
  861337662 => "Yangjiang\,\ Guangdong",
  861337663 => "Jieyang\,\ Guangdong",
  861337664 => "Shanwei\,\ Guangdong",
  861337665 => "Qingyuan\,\ Guangdong",
  861337666 => "Qingyuan\,\ Guangdong",
  861337667 => "Qingyuan\,\ Guangdong",
  861337668 => "Maoming\,\ Guangdong",
  861337669 => "Maoming\,\ Guangdong",
  861337670 => "Zhanjiang\,\ Guangdong",
  861337671 => "Zhanjiang\,\ Guangdong",
  861337672 => "Zhanjiang\,\ Guangdong",
  861337673 => "Chaozhou\,\ Guangdong",
  861337674 => "Chaozhou\,\ Guangdong",
  861337675 => "Chaozhou\,\ Guangdong",
  861337676 => "Chaozhou\,\ Guangdong",
  861337677 => "Heyuan\,\ Guangdong",
  861337678 => "Heyuan\,\ Guangdong",
  861337679 => "Shantou\,\ Guangdong",
  861337680 => "Zhoushan\,\ Zhejiang",
  861337681 => "Hangzhou\,\ Zhejiang",
  861337682 => "Hangzhou\,\ Zhejiang",
  861337683 => "Hangzhou\,\ Zhejiang",
  861337684 => "Lishui\,\ Zhejiang",
  861337685 => "Quzhou\,\ Zhejiang",
  861337686 => "Taizhou\,\ Zhejiang",
  861337687 => "Wenzhou\,\ Zhejiang",
  861337688 => "Ningbo\,\ Zhejiang",
  861337689 => "Jinhua\,\ Zhejiang",
  861337690 => "Zhangzhou\,\ Fujian",
  861337691 => "Zhangzhou\,\ Fujian",
  861337692 => "Xiamen\,\ Fujian",
  861337693 => "Ningde\,\ Fujian",
  861337694 => "Ningde\,\ Fujian",
  861337695 => "Putian\,\ Fujian",
  861337696 => "Quanzhou\,\ Fujian",
  861337697 => "Ningde\,\ Fujian",
  861337698 => "Xiamen\,\ Fujian",
  861337699 => "Fuzhou\,\ Fujian",
  861337700 => "Nanning\,\ Guangxi",
  861337701 => "Nanning\,\ Guangxi",
  861337702 => "Liuzhou\,\ Guangxi",
  861337703 => "Hezhou\,\ Guangxi",
  861337704 => "Nanning\,\ Guangxi",
  861337705 => "Nanning\,\ Guangxi",
  861337706 => "Guilin\,\ Guangxi",
  861337707 => "Liuzhou\,\ Guangxi",
  861337708 => "Nanning\,\ Guangxi",
  861337709 => "Nanning\,\ Guangxi",
  861337710 => "Fangchenggang\,\ Guangxi",
  861337711 => "Nanning\,\ Guangxi",
  861337712 => "Nanning\,\ Guangxi",
  861337713 => "Nanning\,\ Guangxi",
  861337714 => "Nanning\,\ Guangxi",
  861337715 => "Nanning\,\ Guangxi",
  861337716 => "Nanning\,\ Guangxi",
  861337717 => "Nanning\,\ Guangxi",
  861337718 => "Nanning\,\ Guangxi",
  861337719 => "Nanning\,\ Guangxi",
  861337720 => "Liuzhou\,\ Guangxi",
  861337721 => "Liuzhou\,\ Guangxi",
  861337722 => "Liuzhou\,\ Guangxi",
  861337723 => "Liuzhou\,\ Guangxi",
  861337724 => "Laibin\,\ Guangxi",
  861337725 => "Yulin\,\ Guangxi",
  861337726 => "Baise\,\ Guangxi",
  861337727 => "Qinzhou\,\ Guangxi",
  861337728 => "Laibin\,\ Guangxi",
  861337729 => "Beihai\,\ Guangxi",
  861337730 => "Guilin\,\ Guangxi",
  861337731 => "Guilin\,\ Guangxi",
  861337732 => "Guilin\,\ Guangxi",
  861337733 => "Guilin\,\ Guangxi",
  861337734 => "Guilin\,\ Guangxi",
  861337735 => "Yulin\,\ Guangxi",
  861337736 => "Guigang\,\ Guangxi",
  861337737 => "Qinzhou\,\ Guangxi",
  861337738 => "Hechi\,\ Guangxi",
  861337739 => "Beihai\,\ Guangxi",
  861337740 => "Laibin\,\ Guangxi",
  861337741 => "Wuzhou\,\ Guangxi",
  861337742 => "Laibin\,\ Guangxi",
  861337743 => "Yulin\,\ Guangxi",
  861337744 => "Wuzhou\,\ Guangxi",
  861337745 => "Yulin\,\ Guangxi",
  861337746 => "Baise\,\ Guangxi",
  861337747 => "Baise\,\ Guangxi",
  861337748 => "Hechi\,\ Guangxi",
  861337749 => "Hechi\,\ Guangxi",
  861337750 => "Jiangmen\,\ Guangdong",
  861337751 => "Shaoguan\,\ Guangdong",
  861337752 => "Huizhou\,\ Guangdong",
  861337753 => "Meizhou\,\ Guangdong",
  861337754 => "Shantou\,\ Guangdong",
  861337755 => "Shenzhen\,\ Guangdong",
  861337756 => "Zhuhai\,\ Guangdong",
  861337757 => "Foshan\,\ Guangdong",
  861337758 => "Zhaoqing\,\ Guangdong",
  861337759 => "Zhanjiang\,\ Guangdong",
  861337760 => "Zhongshan\,\ Guangdong",
  861337761 => "Heyuan\,\ Guangdong",
  861337762 => "Heyuan\,\ Guangdong",
  861337763 => "Qingyuan\,\ Guangdong",
  861337764 => "Shenzhen\,\ Guangdong",
  861337765 => "Foshan\,\ Guangdong",
  861337766 => "Yunfu\,\ Guangdong",
  861337767 => "Shenzhen\,\ Guangdong",
  861337768 => "Chaozhou\,\ Guangdong",
  861337769 => "Dongguan\,\ Guangdong",
  86133777 => "Dongguan\,\ Guangdong",
  861337780 => "Ezhou\,\ Hubei",
  861337781 => "Suizhou\,\ Hubei",
  861337782 => "Shiyan\,\ Hubei",
  861337783 => "Xiaogan\,\ Hubei",
  861337784 => "Xianning\,\ Hubei",
  861337785 => "Wuhan\,\ Hubei",
  861337786 => "Wuhan\,\ Hubei",
  861337787 => "Wuhan\,\ Hubei",
  861337788 => "Wuhan\,\ Hubei",
  861337789 => "Wuhan\,\ Hubei",
  861337790 => "Jingzhou\,\ Hubei",
  861337791 => "Huangshi\,\ Hubei",
  861337792 => "Huanggang\,\ Hubei",
  861337793 => "Xiantao\,\ Hubei",
  861337794 => "Wuhan\,\ Hubei",
  861337795 => "Wuhan\,\ Hubei",
  861337796 => "Enshi\,\ Hubei",
  861337797 => "Xiangfan\,\ Hubei",
  861337798 => "Yichang\,\ Hubei",
  861337799 => "Jingmen\,\ Hubei",
  861337800 => "Yueyang\,\ Hunan",
  861337801 => "Changsha\,\ Hunan",
  861337802 => "Xiangtan\,\ Hunan",
  861337803 => "Zhuzhou\,\ Hunan",
  861337804 => "Hengyang\,\ Hunan",
  861337805 => "Chenzhou\,\ Hunan",
  861337806 => "Changde\,\ Hunan",
  861337807 => "Yiyang\,\ Hunan",
  861337808 => "Zhuzhou\,\ Hunan",
  861337809 => "Shaoyang\,\ Hunan",
  861337810 => "Chengdu\,\ Sichuan",
  861337811 => "Chengdu\,\ Sichuan",
  861337812 => "Chengdu\,\ Sichuan",
  861337813 => "Deyang\,\ Sichuan",
  861337814 => "Deyang\,\ Sichuan",
  861337815 => "Mianyang\,\ Sichuan",
  861337816 => "Mianyang\,\ Sichuan",
  861337817 => "Guangyuan\,\ Sichuan",
  861337818 => "Nanchong\,\ Sichuan",
  861337819 => "Dazhou\,\ Sichuan",
  861337820 => "Dazhou\,\ Sichuan",
  861337821 => "Suining\,\ Sichuan",
  861337822 => "GuangAn\,\ Sichuan",
  861337823 => "Bazhong\,\ Sichuan",
  861337824 => "Nanchong\,\ Sichuan",
  861337825 => "Luzhou\,\ Sichuan",
  861337826 => "Luzhou\,\ Sichuan",
  861337827 => "Yibin\,\ Sichuan",
  861337828 => "Yibin\,\ Sichuan",
  861337829 => "Neijiang\,\ Sichuan",
  861337830 => "Neijiang\,\ Sichuan",
  861337831 => "Ziyang\,\ Sichuan",
  861337832 => "Zigong\,\ Sichuan",
  861337833 => "Leshan\,\ Sichuan",
  861337834 => "Leshan\,\ Sichuan",
  861337835 => "Meishan\,\ Sichuan",
  861337836 => "Meishan\,\ Sichuan",
  861337837 => "Liangshan\,\ Sichuan",
  861337838 => "YaAn\,\ Sichuan",
  861337839 => "Panzhihua\,\ Sichuan",
  861337840 => "Shenzhen\,\ Guangdong",
  861337841 => "Shenzhen\,\ Guangdong",
  861337842 => "Shenzhen\,\ Guangdong",
  861337843 => "Shenzhen\,\ Guangdong",
  861337844 => "Guangzhou\,\ Guangdong",
  861337845 => "Guangzhou\,\ Guangdong",
  861337846 => "Guangzhou\,\ Guangdong",
  861337847 => "Foshan\,\ Guangdong",
  861337848 => "Foshan\,\ Guangdong",
  861337849 => "Dongguan\,\ Guangdong",
  861337850 => "Guiyang\,\ Guizhou",
  861337851 => "Guiyang\,\ Guizhou",
  861337852 => "Zunyi\,\ Guizhou",
  861337853 => "Anshun\,\ Guizhou",
  861337854 => "Qiannan\,\ Guizhou",
  861337855 => "Qiandongnan\,\ Guizhou",
  861337856 => "Tongren\,\ Guizhou",
  861337857 => "Bijie\,\ Guizhou",
  861337858 => "Liupanshui\,\ Guizhou",
  861337859 => "Qianxinan\,\ Guizhou",
  861337860 => "Dongguan\,\ Guangdong",
  861337861 => "Dongguan\,\ Guangdong",
  861337862 => "Foshan\,\ Guangdong",
  861337863 => "Foshan\,\ Guangdong",
  861337864 => "Foshan\,\ Guangdong",
  861337865 => "Shenzhen\,\ Guangdong",
  861337866 => "Shenzhen\,\ Guangdong",
  861337867 => "Guangzhou\,\ Guangdong",
  861337868 => "Guangzhou\,\ Guangdong",
  861337869 => "Guangzhou\,\ Guangdong",
  861337870 => "Zhaotong\,\ Yunnan",
  861337871 => "Kunming\,\ Yunnan",
  861337872 => "Dali\,\ Yunnan",
  861337873 => "Honghe\,\ Yunnan",
  861337874 => "Qujing\,\ Yunnan",
  861337875 => "Baoshan\,\ Yunnan",
  861337876 => "Wenshan\,\ Yunnan",
  861337877 => "Yuxi\,\ Yunnan",
  861337878 => "Chuxiong\,\ Yunnan",
  861337879 => "Puer\,\ Yunnan",
  861337880 => "Kunming\,\ Yunnan",
  861337881 => "Xishuangbanna\,\ Yunnan",
  861337882 => "Dehong\,\ Yunnan",
  861337883 => "Lincang\,\ Yunnan",
  861337884 => "Kunming\,\ Yunnan",
  861337885 => "Kunming\,\ Yunnan",
  861337886 => "Nujiang\,\ Yunnan",
  861337887 => "Deqen\,\ Yunnan",
  861337888 => "Lijiang\,\ Yunnan",
  861337889 => "Yuxi\,\ Yunnan",
  861337890 => "Yueyang\,\ Hunan",
  861337891 => "Changsha\,\ Hunan",
  861337892 => "Huaihua\,\ Hunan",
  861337893 => "Xiangxi\,\ Hunan",
  861337894 => "Hengyang\,\ Hunan",
  861337895 => "Huaihua\,\ Hunan",
  861337896 => "Yongzhou\,\ Hunan",
  861337897 => "Zhangjiajie\,\ Hunan",
  861337898 => "Loudi\,\ Hunan",
  861337899 => "Shaoyang\,\ Hunan",
  86133790 => "XiAn\,\ Shaanxi",
  861337910 => "Xianyang\,\ Shaanxi",
  861337911 => "YanAn\,\ Shaanxi",
  861337912 => "Yulin\,\ Shaanxi",
  861337913 => "Weinan\,\ Shaanxi",
  861337914 => "Shangluo\,\ Shaanxi",
  861337915 => "Ankang\,\ Shaanxi",
  861337916 => "Hanzhong\,\ Shaanxi",
  861337917 => "Baoji\,\ Shaanxi",
  861337918 => "XiAn\,\ Shaanxi",
  861337919 => "Tongchuan\,\ Shaanxi",
  86133792 => "XiAn\,\ Shaanxi",
  861337930 => "Xianyang\,\ Shaanxi",
  861337931 => "YanAn\,\ Shaanxi",
  861337932 => "Yulin\,\ Shaanxi",
  861337933 => "Weinan\,\ Shaanxi",
  861337934 => "Weinan\,\ Shaanxi",
  861337935 => "Ankang\,\ Shaanxi",
  861337936 => "Hanzhong\,\ Shaanxi",
  861337937 => "Baoji\,\ Shaanxi",
  861337938 => "Baoji\,\ Shaanxi",
  861337939 => "Yulin\,\ Shaanxi",
  861337940 => "Xianyang\,\ Shaanxi",
  861337941 => "Ankang\,\ Shaanxi",
  861337942 => "Yulin\,\ Shaanxi",
  861337943 => "Weinan\,\ Shaanxi",
  861337944 => "Weinan\,\ Shaanxi",
  861337945 => "Ankang\,\ Shaanxi",
  861337946 => "Hanzhong\,\ Shaanxi",
  861337947 => "Baoji\,\ Shaanxi",
  861337948 => "Baoji\,\ Shaanxi",
  861337949 => "Yulin\,\ Shaanxi",
  861337950 => "XiAn\,\ Shaanxi",
  861337951 => "XiAn\,\ Shaanxi",
  861337952 => "Xianyang\,\ Shaanxi",
  861337953 => "YanAn\,\ Shaanxi",
  861337954 => "XiAn\,\ Shaanxi",
  861337955 => "YanAn\,\ Shaanxi",
  861337956 => "Yulin\,\ Shaanxi",
  861337957 => "Yulin\,\ Shaanxi",
  861337958 => "Yulin\,\ Shaanxi",
  861337959 => "Ankang\,\ Shaanxi",
  861337960 => "Zunyi\,\ Guizhou",
  861337961 => "Qiannan\,\ Guizhou",
  861337962 => "Qiannan\,\ Guizhou",
  861337963 => "Qiandongnan\,\ Guizhou",
  861337964 => "Tongren\,\ Guizhou",
  861337965 => "Bijie\,\ Guizhou",
  861337966 => "Qianxinan\,\ Guizhou",
  861337967 => "Qianxinan\,\ Guizhou",
  861337968 => "Qianxinan\,\ Guizhou",
  861337969 => "Qianxinan\,\ Guizhou",
  861337970 => "Kizilsu\,\ Xinjiang",
  861337971 => "Hami\,\ Xinjiang",
  861337972 => "Ili\,\ Xinjiang",
  861337973 => "Aksu\,\ Xinjiang",
  861337974 => "Kashi\,\ Xinjiang",
  861337975 => "Kashi\,\ Xinjiang",
  861337976 => "Bayingolin\,\ Xinjiang",
  861337977 => "Urumchi\,\ Xinjiang",
  861337978 => "Urumchi\,\ Xinjiang",
  861337979 => "Urumchi\,\ Xinjiang",
  86133798 => "Haikou\,\ Hainan",
  86133799 => "Haikou\,\ Hainan",
  86133800 => "Guangzhou\,\ Guangdong",
  86133801 => "Dongguan\,\ Guangdong",
  86133802 => "Foshan\,\ Guangdong",
  86133803 => "Shenzhen\,\ Guangdong",
  861338040 => "Shantou\,\ Guangdong",
  861338041 => "Shantou\,\ Guangdong",
  861338042 => "Yunfu\,\ Guangdong",
  861338043 => "Yunfu\,\ Guangdong",
  861338044 => "Zhongshan\,\ Guangdong",
  861338045 => "Zhongshan\,\ Guangdong",
  861338046 => "Chaozhou\,\ Guangdong",
  861338047 => "Chaozhou\,\ Guangdong",
  861338048 => "Shantou\,\ Guangdong",
  861338049 => "Shantou\,\ Guangdong",
  861338050 => "Foshan\,\ Guangdong",
  861338051 => "Foshan\,\ Guangdong",
  861338052 => "Foshan\,\ Guangdong",
  861338053 => "Foshan\,\ Guangdong",
  861338054 => "Foshan\,\ Guangdong",
  861338055 => "Jieyang\,\ Guangdong",
  861338056 => "Jieyang\,\ Guangdong",
  861338057 => "Jieyang\,\ Guangdong",
  861338058 => "Jieyang\,\ Guangdong",
  861338059 => "Jieyang\,\ Guangdong",
  861338060 => "Zhuhai\,\ Guangdong",
  861338061 => "Zhuhai\,\ Guangdong",
  861338062 => "Zhuhai\,\ Guangdong",
  861338063 => "Zhuhai\,\ Guangdong",
  861338064 => "Zhuhai\,\ Guangdong",
  861338065 => "Huizhou\,\ Guangdong",
  861338066 => "Huizhou\,\ Guangdong",
  861338067 => "Huizhou\,\ Guangdong",
  861338068 => "Huizhou\,\ Guangdong",
  861338069 => "Huizhou\,\ Guangdong",
  861338070 => "Qingyuan\,\ Guangdong",
  861338071 => "Qingyuan\,\ Guangdong",
  861338072 => "Shaoguan\,\ Guangdong",
  861338073 => "Shaoguan\,\ Guangdong",
  861338074 => "Yangjiang\,\ Guangdong",
  861338075 => "Zhaoqing\,\ Guangdong",
  861338076 => "Zhaoqing\,\ Guangdong",
  861338077 => "Meizhou\,\ Guangdong",
  861338078 => "Shenzhen\,\ Guangdong",
  861338079 => "Shenzhen\,\ Guangdong",
  861338080 => "Maoming\,\ Guangdong",
  861338081 => "Maoming\,\ Guangdong",
  861338082 => "Maoming\,\ Guangdong",
  861338083 => "Foshan\,\ Guangdong",
  861338084 => "Shanwei\,\ Guangdong",
  861338085 => "Shanwei\,\ Guangdong",
  861338086 => "Yangjiang\,\ Guangdong",
  861338087 => "Zhongshan\,\ Guangdong",
  861338088 => "Zhongshan\,\ Guangdong",
  861338089 => "Zhongshan\,\ Guangdong",
  861338090 => "Zhanjiang\,\ Guangdong",
  861338091 => "Zhanjiang\,\ Guangdong",
  861338092 => "Heyuan\,\ Guangdong",
  861338093 => "Heyuan\,\ Guangdong",
  861338094 => "Heyuan\,\ Guangdong",
  861338095 => "Jiangmen\,\ Guangdong",
  861338096 => "Jiangmen\,\ Guangdong",
  861338097 => "Jiangmen\,\ Guangdong",
  861338098 => "Jiangmen\,\ Guangdong",
  861338099 => "Jiangmen\,\ Guangdong",
  86133810 => "Beijing",
  86133811 => "Beijing",
  86133812 => "Beijing",
  86133813 => "Beijing",
  86133814 => "Beijing",
  86133815 => "Shanghai",
  86133816 => "Shanghai",
  86133817 => "Shanghai",
  86133818 => "Shanghai",
  86133819 => "Shanghai",
  86133820 => "Nanjing\,\ Jiangsu",
  86133821 => "Suzhou\,\ Jiangsu",
  86133822 => "Wuxi\,\ Jiangsu",
  861338230 => "HuaiAn\,\ Jiangsu",
  861338231 => "HuaiAn\,\ Jiangsu",
  861338232 => "HuaiAn\,\ Jiangsu",
  861338233 => "HuaiAn\,\ Jiangsu",
  861338234 => "Nantong\,\ Jiangsu",
  861338235 => "Nantong\,\ Jiangsu",
  861338236 => "Nantong\,\ Jiangsu",
  861338237 => "Nantong\,\ Jiangsu",
  861338238 => "Nantong\,\ Jiangsu",
  861338239 => "Nantong\,\ Jiangsu",
  861338240 => "Nanjing\,\ Jiangsu",
  861338241 => "Suzhou\,\ Jiangsu",
  861338242 => "Wuxi\,\ Jiangsu",
  861338243 => "Yangzhou\,\ Jiangsu",
  861338244 => "Changzhou\,\ Jiangsu",
  861338245 => "Xuzhou\,\ Jiangsu",
  861338246 => "Taizhou\,\ Jiangsu",
  861338247 => "Yancheng\,\ Jiangsu",
  861338248 => "Nantong\,\ Jiangsu",
  861338249 => "Zhenjiang\,\ Jiangsu",
  861338250 => "Suzhou\,\ Jiangsu",
  861338251 => "Suzhou\,\ Jiangsu",
  861338252 => "Suzhou\,\ Jiangsu",
  861338253 => "Suzhou\,\ Jiangsu",
  861338254 => "Suzhou\,\ Jiangsu",
  861338255 => "Taizhou\,\ Jiangsu",
  861338256 => "Taizhou\,\ Jiangsu",
  861338257 => "Taizhou\,\ Jiangsu",
  861338258 => "Taizhou\,\ Jiangsu",
  861338259 => "Taizhou\,\ Jiangsu",
  861338260 => "Yancheng\,\ Jiangsu",
  861338261 => "Yancheng\,\ Jiangsu",
  861338262 => "Yancheng\,\ Jiangsu",
  861338263 => "Yancheng\,\ Jiangsu",
  861338264 => "Yancheng\,\ Jiangsu",
  861338265 => "Xuzhou\,\ Jiangsu",
  861338266 => "Xuzhou\,\ Jiangsu",
  861338267 => "Xuzhou\,\ Jiangsu",
  861338268 => "Xuzhou\,\ Jiangsu",
  861338269 => "Xuzhou\,\ Jiangsu",
  861338270 => "Yangzhou\,\ Jiangsu",
  861338271 => "Yangzhou\,\ Jiangsu",
  861338272 => "Yangzhou\,\ Jiangsu",
  861338273 => "Yangzhou\,\ Jiangsu",
  861338274 => "Yangzhou\,\ Jiangsu",
  861338275 => "Yangzhou\,\ Jiangsu",
  861338276 => "Nanjing\,\ Jiangsu",
  861338277 => "Nanjing\,\ Jiangsu",
  861338278 => "Nanjing\,\ Jiangsu",
  861338279 => "Nanjing\,\ Jiangsu",
  861338280 => "Changzhou\,\ Jiangsu",
  861338281 => "Changzhou\,\ Jiangsu",
  861338282 => "Changzhou\,\ Jiangsu",
  861338283 => "Changzhou\,\ Jiangsu",
  861338284 => "Changzhou\,\ Jiangsu",
  861338285 => "Changzhou\,\ Jiangsu",
  861338286 => "Changzhou\,\ Jiangsu",
  861338287 => "Changzhou\,\ Jiangsu",
  861338288 => "Wuxi\,\ Jiangsu",
  861338289 => "Wuxi\,\ Jiangsu",
  861338290 => "Suqian\,\ Jiangsu",
  861338291 => "Suqian\,\ Jiangsu",
  861338292 => "Suqian\,\ Jiangsu",
  861338293 => "Lianyungang\,\ Jiangsu",
  861338294 => "Lianyungang\,\ Jiangsu",
  861338295 => "Lianyungang\,\ Jiangsu",
  861338296 => "Lianyungang\,\ Jiangsu",
  861338297 => "Zhenjiang\,\ Jiangsu",
  861338298 => "Zhenjiang\,\ Jiangsu",
  861338299 => "Zhenjiang\,\ Jiangsu",
  861338300 => "Handan\,\ Hebei",
  861338301 => "Shijiazhuang\,\ Hebei",
  861338302 => "Baoding\,\ Hebei",
  861338303 => "Shijiazhuang\,\ Hebei",
  861338304 => "Shijiazhuang\,\ Hebei",
  861338305 => "Tangshan\,\ Hebei",
  861338306 => "Cangzhou\,\ Hebei",
  861338307 => "Cangzhou\,\ Hebei",
  861338308 => "Handan\,\ Hebei",
  861338309 => "Xingtai\,\ Hebei",
  861338310 => "Handan\,\ Hebei",
  861338311 => "Shijiazhuang\,\ Hebei",
  861338312 => "Baoding\,\ Hebei",
  861338313 => "Zhangjiakou\,\ Hebei",
  861338314 => "Chengde\,\ Hebei",
  861338315 => "Tangshan\,\ Hebei",
  861338316 => "Langfang\,\ Hebei",
  861338317 => "Cangzhou\,\ Hebei",
  861338318 => "Hengshui\,\ Hebei",
  861338319 => "Xingtai\,\ Hebei",
  861338320 => "Handan\,\ Hebei",
  861338321 => "Shijiazhuang\,\ Hebei",
  861338322 => "Baoding\,\ Hebei",
  861338323 => "Shijiazhuang\,\ Hebei",
  861338324 => "Tangshan\,\ Hebei",
  861338325 => "Tangshan\,\ Hebei",
  861338326 => "Baoding\,\ Hebei",
  861338327 => "Qinhuangdao\,\ Hebei",
  861338328 => "Qinhuangdao\,\ Hebei",
  861338329 => "Shijiazhuang\,\ Hebei",
  861338330 => "Handan\,\ Hebei",
  861338331 => "Shijiazhuang\,\ Hebei",
  861338332 => "Baoding\,\ Hebei",
  861338333 => "Zhangjiakou\,\ Hebei",
  861338334 => "Tangshan\,\ Hebei",
  861338335 => "Qinhuangdao\,\ Hebei",
  861338336 => "Langfang\,\ Hebei",
  861338337 => "Cangzhou\,\ Hebei",
  861338338 => "Hengshui\,\ Hebei",
  861338339 => "Xingtai\,\ Hebei",
  861338340 => "Xinzhou\,\ Shanxi",
  861338341 => "Taiyuan\,\ Shanxi",
  861338342 => "Datong\,\ Shanxi",
  861338343 => "Taiyuan\,\ Shanxi",
  861338344 => "Jinzhong\,\ Shanxi",
  861338345 => "Changzhi\,\ Shanxi",
  861338346 => "Jincheng\,\ Shanxi",
  861338347 => "Linfen\,\ Shanxi",
  861338348 => "Yuncheng\,\ Shanxi",
  861338349 => "Shuozhou\,\ Shanxi",
  861338350 => "Xinzhou\,\ Shanxi",
  861338351 => "Taiyuan\,\ Shanxi",
  861338352 => "Datong\,\ Shanxi",
  861338353 => "Yangquan\,\ Shanxi",
  861338354 => "Jinzhong\,\ Shanxi",
  861338355 => "Changzhi\,\ Shanxi",
  861338356 => "Jincheng\,\ Shanxi",
  861338357 => "Linfen\,\ Shanxi",
  861338358 => "Lüliang\,\ Shanxi",
  861338359 => "Yuncheng\,\ Shanxi",
  861338360 => "Qinhuangdao\,\ Hebei",
  861338361 => "Shijiazhuang\,\ Hebei",
  861338362 => "Baoding\,\ Hebei",
  861338363 => "Zhangjiakou\,\ Hebei",
  861338364 => "Chengde\,\ Hebei",
  861338365 => "Qinhuangdao\,\ Hebei",
  861338366 => "Langfang\,\ Hebei",
  861338367 => "Langfang\,\ Hebei",
  861338368 => "Hengshui\,\ Hebei",
  861338369 => "Xingtai\,\ Hebei",
  861338370 => "Shangqiu\,\ Henan",
  861338371 => "Zhengzhou\,\ Henan",
  861338372 => "Anyang\,\ Henan",
  861338373 => "Xinxiang\,\ Henan",
  861338374 => "Xuchang\,\ Henan",
  861338375 => "Pingdingshan\,\ Henan",
  861338376 => "Xinyang\,\ Henan",
  861338377 => "Nanyang\,\ Henan",
  861338378 => "Kaifeng\,\ Henan",
  861338379 => "Luoyang\,\ Henan",
  861338380 => "Xinxiang\,\ Henan",
  861338381 => "Zhengzhou\,\ Henan",
  861338382 => "Zhengzhou\,\ Henan",
  861338383 => "Zhengzhou\,\ Henan",
  861338384 => "Zhengzhou\,\ Henan",
  861338385 => "Zhengzhou\,\ Henan",
  861338386 => "Zhengzhou\,\ Henan",
  861338387 => "Luoyang\,\ Henan",
  861338388 => "Luoyang\,\ Henan",
  861338389 => "Luoyang\,\ Henan",
  861338390 => "Pingdingshan\,\ Henan",
  861338391 => "Jiaozuo\,\ Henan",
  861338392 => "Hebi\,\ Henan",
  861338393 => "Puyang\,\ Henan",
  861338394 => "Zhoukou\,\ Henan",
  861338395 => "Luohe\,\ Henan",
  861338396 => "Zhumadian\,\ Henan",
  861338397 => "Xinyang\,\ Henan",
  861338398 => "Sanmenxia\,\ Henan",
  861338399 => "Pingdingshan\,\ Henan",
  861338400 => "Zhengzhou\,\ Henan",
  861338401 => "Zhengzhou\,\ Henan",
  861338402 => "Zhengzhou\,\ Henan",
  861338403 => "Zhengzhou\,\ Henan",
  861338404 => "Zhengzhou\,\ Henan",
  861338405 => "Pingdingshan\,\ Henan",
  861338406 => "Pingdingshan\,\ Henan",
  861338407 => "Nanyang\,\ Henan",
  861338408 => "Nanyang\,\ Henan",
  861338409 => "Jiaozuo\,\ Henan",
  861338410 => "Tieling\,\ Liaoning",
  861338411 => "Dalian\,\ Liaoning",
  861338412 => "Anshan\,\ Liaoning",
  861338413 => "Fushun\,\ Liaoning",
  861338414 => "Benxi\,\ Liaoning",
  861338415 => "Dandong\,\ Liaoning",
  861338416 => "Jinzhou\,\ Liaoning",
  861338417 => "Yingkou\,\ Liaoning",
  861338418 => "Fuxin\,\ Liaoning",
  861338419 => "Liaoyang\,\ Liaoning",
  861338420 => "Tieling\,\ Liaoning",
  861338421 => "Chaoyang\,\ Liaoning",
  861338422 => "Anshan\,\ Liaoning",
  861338423 => "Fushun\,\ Liaoning",
  861338424 => "Benxi\,\ Liaoning",
  861338425 => "Dandong\,\ Liaoning",
  861338426 => "Jinzhou\,\ Liaoning",
  861338427 => "Panjin\,\ Liaoning",
  861338428 => "Fuxin\,\ Liaoning",
  861338429 => "Huludao\,\ Liaoning",
  861338430 => "Changchun\,\ Jilin",
  861338431 => "Changchun\,\ Jilin",
  861338432 => "Jilin\,\ Jilin",
  861338433 => "Yanbian\,\ Jilin",
  861338434 => "Siping\,\ Jilin",
  861338435 => "Tonghua\,\ Jilin",
  861338436 => "Baicheng\,\ Jilin",
  861338437 => "Liaoyuan\,\ Jilin",
  861338438 => "Songyuan\,\ Jilin",
  861338439 => "Baishan\,\ Jilin",
  861338440 => "Jilin\,\ Jilin",
  861338441 => "Jilin\,\ Jilin",
  861338442 => "Jilin\,\ Jilin",
  861338443 => "Yanbian\,\ Jilin",
  861338444 => "Siping\,\ Jilin",
  861338445 => "Tonghua\,\ Jilin",
  861338446 => "Baicheng\,\ Jilin",
  861338447 => "Changchun\,\ Jilin",
  861338448 => "Changchun\,\ Jilin",
  861338449 => "Changchun\,\ Jilin",
  861338450 => "Harbin\,\ Heilongjiang",
  861338451 => "Harbin\,\ Heilongjiang",
  861338452 => "Qiqihar\,\ Heilongjiang",
  861338453 => "Mudanjiang\,\ Heilongjiang",
  861338454 => "Jiamusi\,\ Heilongjiang",
  861338455 => "Suihua\,\ Heilongjiang",
  861338456 => "Heihe\,\ Heilongjiang",
  861338457 => "Da\ Hinggan\ Ling\,\ Heilongjiang",
  861338458 => "Yichun\,\ Heilongjiang",
  861338459 => "Daqing\,\ Heilongjiang",
  861338460 => "Harbin\,\ Heilongjiang",
  861338461 => "Harbin\,\ Heilongjiang",
  861338462 => "Qiqihar\,\ Heilongjiang",
  861338463 => "Mudanjiang\,\ Heilongjiang",
  861338464 => "Qitaihe\,\ Heilongjiang",
  861338465 => "Harbin\,\ Heilongjiang",
  861338466 => "Harbin\,\ Heilongjiang",
  861338467 => "Jixi\,\ Heilongjiang",
  861338468 => "Hegang\,\ Heilongjiang",
  861338469 => "Shuangyashan\,\ Heilongjiang",
  861338470 => "Hulun\,\ Inner\ Mongolia",
  861338471 => "Hohhot\,\ Inner\ Mongolia",
  861338472 => "Baotou\,\ Inner\ Mongolia",
  861338473 => "Wuhai\,\ Inner\ Mongolia",
  861338474 => "Hinggan\,\ Inner\ Mongolia",
  861338475 => "Tongliao\,\ Inner\ Mongolia",
  861338476 => "Chifeng\,\ Inner\ Mongolia",
  861338477 => "Ordos\,\ Inner\ Mongolia",
  861338478 => "Bayannur\,\ Inner\ Mongolia",
  861338479 => "Xilin\,\ Inner\ Mongolia",
  861338480 => "Ordos\,\ Inner\ Mongolia",
  861338481 => "Chifeng\,\ Inner\ Mongolia",
  861338482 => "Hinggan\,\ Inner\ Mongolia",
  861338483 => "Alxa\,\ Inner\ Mongolia",
  861338484 => "Baotou\,\ Inner\ Mongolia",
  861338485 => "Baotou\,\ Inner\ Mongolia",
  861338486 => "Baotou\,\ Inner\ Mongolia",
  861338487 => "Hohhot\,\ Inner\ Mongolia",
  861338488 => "Hohhot\,\ Inner\ Mongolia",
  861338489 => "Hohhot\,\ Inner\ Mongolia",
  86133849 => "XiAn\,\ Shaanxi",
  861338500 => "Ningde\,\ Fujian",
  861338501 => "Ningde\,\ Fujian",
  861338502 => "Ningde\,\ Fujian",
  861338503 => "Ningde\,\ Fujian",
  861338504 => "Ningde\,\ Fujian",
  861338505 => "Ningde\,\ Fujian",
  861338506 => "Ningde\,\ Fujian",
  861338507 => "Sanming\,\ Fujian",
  861338508 => "Sanming\,\ Fujian",
  861338509 => "Sanming\,\ Fujian",
  861338510 => "Guiyang\,\ Guizhou",
  861338511 => "Guiyang\,\ Guizhou",
  861338512 => "Zunyi\,\ Guizhou",
  861338513 => "Anshun\,\ Guizhou",
  861338514 => "Guiyang\,\ Guizhou",
  861338515 => "Qiandongnan\,\ Guizhou",
  861338516 => "Liupanshui\,\ Guizhou",
  861338517 => "Bijie\,\ Guizhou",
  861338518 => "Qiannan\,\ Guizhou",
  861338519 => "Zunyi\,\ Guizhou",
  861338520 => "Wuhan\,\ Hubei",
  861338521 => "Wuhan\,\ Hubei",
  861338522 => "Xiantao\,\ Hubei",
  861338523 => "Enshi\,\ Hubei",
  861338524 => "Jingmen\,\ Hubei",
  861338525 => "Jingmen\,\ Hubei",
  861338526 => "Huangshi\,\ Hubei",
  861338527 => "Ezhou\,\ Hubei",
  861338528 => "Wuhan\,\ Hubei",
  861338529 => "Xiaogan\,\ Hubei",
  861338530 => "Heze\,\ Shandong",
  861338531 => "Jinan\,\ Shandong",
  861338532 => "Qingdao\,\ Shandong",
  861338533 => "Zibo\,\ Shandong",
  861338534 => "Dezhou\,\ Shandong",
  861338535 => "Yantai\,\ Shandong",
  861338536 => "Weifang\,\ Shandong",
  861338537 => "Jining\,\ Shandong",
  861338538 => "TaiAn\,\ Shandong",
  861338539 => "Linyi\,\ Shandong",
  861338540 => "Heze\,\ Shandong",
  861338541 => "Jinan\,\ Shandong",
  861338542 => "Qingdao\,\ Shandong",
  861338543 => "Binzhou\,\ Shandong",
  861338544 => "Dezhou\,\ Shandong",
  861338545 => "Yantai\,\ Shandong",
  861338546 => "Dongying\,\ Shandong",
  861338547 => "Jining\,\ Shandong",
  861338548 => "TaiAn\,\ Shandong",
  861338549 => "Linyi\,\ Shandong",
  861338550 => "Guiyang\,\ Guizhou",
  861338551 => "Guiyang\,\ Guizhou",
  861338552 => "Zunyi\,\ Guizhou",
  861338553 => "Anshun\,\ Guizhou",
  861338554 => "Qiannan\,\ Guizhou",
  861338555 => "Qiandongnan\,\ Guizhou",
  861338556 => "Tongren\,\ Guizhou",
  861338557 => "Bijie\,\ Guizhou",
  861338558 => "Liupanshui\,\ Guizhou",
  861338559 => "Qianxinan\,\ Guizhou",
  861338560 => "Hefei\,\ Anhui",
  861338561 => "Huaibei\,\ Anhui",
  861338562 => "Tongling\,\ Anhui",
  861338563 => "Xuancheng\,\ Anhui",
  861338564 => "LuAn\,\ Anhui",
  861338565 => "Chaohu\,\ Anhui",
  861338566 => "Chizhou\,\ Anhui",
  861338567 => "Bozhou\,\ Anhui",
  861338568 => "LuAn\,\ Anhui",
  861338569 => "Hefei\,\ Anhui",
  861338570 => "Quzhou\,\ Zhejiang",
  861338571 => "Hangzhou\,\ Zhejiang",
  861338572 => "Huzhou\,\ Zhejiang",
  861338573 => "Jiaxing\,\ Zhejiang",
  861338574 => "Ningbo\,\ Zhejiang",
  861338575 => "Shaoxing\,\ Zhejiang",
  861338576 => "Taizhou\,\ Zhejiang",
  861338577 => "Wenzhou\,\ Zhejiang",
  861338578 => "Lishui\,\ Zhejiang",
  861338579 => "Jinhua\,\ Zhejiang",
  861338580 => "Zhoushan\,\ Zhejiang",
  861338581 => "Hangzhou\,\ Zhejiang",
  861338582 => "Huzhou\,\ Zhejiang",
  861338583 => "Jiaxing\,\ Zhejiang",
  861338584 => "Ningbo\,\ Zhejiang",
  861338585 => "Shaoxing\,\ Zhejiang",
  861338586 => "Taizhou\,\ Zhejiang",
  861338587 => "Wenzhou\,\ Zhejiang",
  861338588 => "Lishui\,\ Zhejiang",
  861338589 => "Jinhua\,\ Zhejiang",
  861338590 => "Longyan\,\ Fujian",
  861338591 => "Fuzhou\,\ Fujian",
  861338592 => "Xiamen\,\ Fujian",
  861338593 => "Ningde\,\ Fujian",
  861338594 => "Putian\,\ Fujian",
  861338595 => "Quanzhou\,\ Fujian",
  861338596 => "Zhangzhou\,\ Fujian",
  861338597 => "Longyan\,\ Fujian",
  861338598 => "Sanming\,\ Fujian",
  861338599 => "Nanping\,\ Fujian",
  86133860 => "Shanghai",
  86133861 => "Shanghai",
  86133862 => "Shanghai",
  861338630 => "Weihai\,\ Shandong",
  861338631 => "Weihai\,\ Shandong",
  861338632 => "Zaozhuang\,\ Shandong",
  861338633 => "Rizhao\,\ Shandong",
  861338634 => "Laiwu\,\ Shandong",
  861338635 => "Liaocheng\,\ Shandong",
  861338636 => "Weifang\,\ Shandong",
  861338637 => "Zaozhuang\,\ Shandong",
  861338638 => "Yantai\,\ Shandong",
  861338639 => "Qingdao\,\ Shandong",
  861338640 => "Jinan\,\ Shandong",
  861338641 => "Jinan\,\ Shandong",
  861338642 => "Qingdao\,\ Shandong",
  861338643 => "Zibo\,\ Shandong",
  861338644 => "Jinan\,\ Shandong",
  861338645 => "Yantai\,\ Shandong",
  861338646 => "Weifang\,\ Shandong",
  861338647 => "Dongying\,\ Shandong",
  861338648 => "Qingdao\,\ Shandong",
  861338649 => "Binzhou\,\ Shandong",
  861338650 => "Hangzhou\,\ Zhejiang",
  861338651 => "Hangzhou\,\ Zhejiang",
  861338652 => "Hangzhou\,\ Zhejiang",
  861338653 => "Hangzhou\,\ Zhejiang",
  861338654 => "Taizhou\,\ Zhejiang",
  861338655 => "Taizhou\,\ Zhejiang",
  861338656 => "Taizhou\,\ Zhejiang",
  861338657 => "Taizhou\,\ Zhejiang",
  861338658 => "Taizhou\,\ Zhejiang",
  861338659 => "Taizhou\,\ Zhejiang",
  861338660 => "Ningbo\,\ Zhejiang",
  861338661 => "Ningbo\,\ Zhejiang",
  861338662 => "Ningbo\,\ Zhejiang",
  861338663 => "Ningbo\,\ Zhejiang",
  861338664 => "Ningbo\,\ Zhejiang",
  861338665 => "Ningbo\,\ Zhejiang",
  861338666 => "Ningbo\,\ Zhejiang",
  861338667 => "Ningbo\,\ Zhejiang",
  861338668 => "Zhoushan\,\ Zhejiang",
  861338669 => "Zhoushan\,\ Zhejiang",
  861338670 => "Benxi\,\ Liaoning",
  861338671 => "Yingkou\,\ Liaoning",
  861338672 => "Huludao\,\ Liaoning",
  861338673 => "Huludao\,\ Liaoning",
  861338674 => "Anshan\,\ Liaoning",
  861338675 => "Anshan\,\ Liaoning",
  861338676 => "Anshan\,\ Liaoning",
  861338677 => "Anshan\,\ Liaoning",
  861338678 => "Anshan\,\ Liaoning",
  861338679 => "Anshan\,\ Liaoning",
  861338680 => "Panjin\,\ Liaoning",
  861338681 => "Panjin\,\ Liaoning",
  861338682 => "Shenyang\,\ Liaoning",
  861338683 => "Shenyang\,\ Liaoning",
  861338684 => "Shenyang\,\ Liaoning",
  861338685 => "Shenyang\,\ Liaoning",
  861338686 => "Shenyang\,\ Liaoning",
  861338687 => "Shenyang\,\ Liaoning",
  861338688 => "Shenyang\,\ Liaoning",
  861338689 => "Shenyang\,\ Liaoning",
  861338690 => "Putian\,\ Fujian",
  861338691 => "Putian\,\ Fujian",
  861338692 => "Putian\,\ Fujian",
  861338693 => "Longyan\,\ Fujian",
  861338694 => "Zhangzhou\,\ Fujian",
  861338695 => "Zhangzhou\,\ Fujian",
  861338696 => "Zhangzhou\,\ Fujian",
  861338697 => "Zhangzhou\,\ Fujian",
  861338698 => "Nanping\,\ Fujian",
  861338699 => "Nanping\,\ Fujian",
  861338700 => "Nanchang\,\ Jiangxi",
  861338701 => "Yingtan\,\ Jiangxi",
  861338702 => "Jiujiang\,\ Jiangxi",
  861338703 => "Shangrao\,\ Jiangxi",
  861338704 => "JiAn\,\ Jiangxi",
  861338705 => "Yichun\,\ Jiangxi",
  861338706 => "Fuzhou\,\ Jiangxi",
  861338707 => "Ganzhou\,\ Jiangxi",
  861338708 => "Nanchang\,\ Jiangxi",
  861338709 => "Nanchang\,\ Jiangxi",
  861338710 => "Huangshi\,\ Hubei",
  861338711 => "Huanggang\,\ Hubei",
  861338712 => "Huanggang\,\ Hubei",
  861338713 => "Shiyan\,\ Hubei",
  861338714 => "Shiyan\,\ Hubei",
  861338715 => "Shiyan\,\ Hubei",
  861338716 => "Xianning\,\ Hubei",
  861338717 => "Xianning\,\ Hubei",
  861338718 => "Jingzhou\,\ Hubei",
  861338719 => "Jingzhou\,\ Hubei",
  861338720 => "Jingzhou\,\ Hubei",
  861338721 => "Xiangfan\,\ Hubei",
  861338722 => "Xiangfan\,\ Hubei",
  861338723 => "Xiangfan\,\ Hubei",
  861338724 => "Xiangfan\,\ Hubei",
  861338725 => "Yichang\,\ Hubei",
  861338726 => "Yichang\,\ Hubei",
  861338727 => "Yichang\,\ Hubei",
  861338728 => "Yichang\,\ Hubei",
  861338729 => "Suizhou\,\ Hubei",
  861338730 => "Yueyang\,\ Hunan",
  861338731 => "Changsha\,\ Hunan",
  861338732 => "Xiangtan\,\ Hunan",
  861338733 => "Zhuzhou\,\ Hunan",
  861338734 => "Hengyang\,\ Hunan",
  861338735 => "Chenzhou\,\ Hunan",
  861338736 => "Changde\,\ Hunan",
  861338737 => "Yiyang\,\ Hunan",
  861338738 => "Loudi\,\ Hunan",
  861338739 => "Shaoyang\,\ Hunan",
  861338740 => "Yueyang\,\ Hunan",
  861338741 => "Zhuzhou\,\ Hunan",
  861338742 => "Changde\,\ Hunan",
  861338743 => "Xiangxi\,\ Hunan",
  861338744 => "Zhangjiajie\,\ Hunan",
  861338745 => "Huaihua\,\ Hunan",
  861338746 => "Yongzhou\,\ Hunan",
  861338747 => "Hengyang\,\ Hunan",
  861338748 => "Changsha\,\ Hunan",
  861338749 => "Changsha\,\ Hunan",
  86133875 => "Wuhan\,\ Hubei",
  861338760 => "Wuhan\,\ Hubei",
  861338761 => "Wuhan\,\ Hubei",
  861338762 => "Wuhan\,\ Hubei",
  861338763 => "Wuhan\,\ Hubei",
  861338764 => "Wuhan\,\ Hubei",
  861338765 => "Wuhan\,\ Hubei",
  861338766 => "Wuhan\,\ Hubei",
  861338767 => "Xiaogan\,\ Hubei",
  861338768 => "Jingzhou\,\ Hubei",
  861338769 => "Enshi\,\ Hubei",
  861338770 => "Fangchenggang\,\ Guangxi",
  861338771 => "Nanning\,\ Guangxi",
  861338772 => "Liuzhou\,\ Guangxi",
  861338773 => "Guilin\,\ Guangxi",
  861338774 => "Hezhou\,\ Guangxi",
  861338775 => "Yulin\,\ Guangxi",
  861338776 => "Baise\,\ Guangxi",
  861338777 => "Qinzhou\,\ Guangxi",
  861338778 => "Hechi\,\ Guangxi",
  861338779 => "Beihai\,\ Guangxi",
  861338780 => "Liaoyang\,\ Liaoning",
  861338781 => "Liaoyang\,\ Liaoning",
  861338782 => "Chaoyang\,\ Liaoning",
  861338783 => "Dalian\,\ Liaoning",
  861338784 => "Dalian\,\ Liaoning",
  861338785 => "Dalian\,\ Liaoning",
  861338786 => "Dalian\,\ Liaoning",
  861338787 => "Dalian\,\ Liaoning",
  861338788 => "Dalian\,\ Liaoning",
  861338789 => "Dalian\,\ Liaoning",
  861338790 => "Xinyu\,\ Jiangxi",
  861338791 => "Nanchang\,\ Jiangxi",
  861338792 => "Jiujiang\,\ Jiangxi",
  861338793 => "Shangrao\,\ Jiangxi",
  861338794 => "Fuzhou\,\ Jiangxi",
  861338795 => "Yichun\,\ Jiangxi",
  861338796 => "JiAn\,\ Jiangxi",
  861338797 => "Ganzhou\,\ Jiangxi",
  861338798 => "Jingdezhen\,\ Jiangxi",
  861338799 => "Pingxiang\,\ Jiangxi",
  86133880 => "Tianjin",
  861338810 => "Mianyang\,\ Sichuan",
  861338811 => "Mianyang\,\ Sichuan",
  861338812 => "Deyang\,\ Sichuan",
  861338813 => "Deyang\,\ Sichuan",
  861338814 => "GuangAn\,\ Sichuan",
  861338815 => "GuangAn\,\ Sichuan",
  861338816 => "Chengdu\,\ Sichuan",
  861338817 => "Chengdu\,\ Sichuan",
  861338818 => "Chengdu\,\ Sichuan",
  861338819 => "Chengdu\,\ Sichuan",
  861338820 => "Dazhou\,\ Sichuan",
  861338821 => "Dazhou\,\ Sichuan",
  861338822 => "Nanchong\,\ Sichuan",
  861338823 => "Nanchong\,\ Sichuan",
  861338824 => "Meishan\,\ Sichuan",
  861338825 => "Meishan\,\ Sichuan",
  861338826 => "Leshan\,\ Sichuan",
  861338827 => "Leshan\,\ Sichuan",
  861338828 => "Luzhou\,\ Sichuan",
  861338829 => "Luzhou\,\ Sichuan",
  861338830 => "Ziyang\,\ Sichuan",
  861338831 => "Panzhihua\,\ Sichuan",
  861338832 => "Zigong\,\ Sichuan",
  861338833 => "Zigong\,\ Sichuan",
  861338834 => "YaAn\,\ Sichuan",
  861338835 => "Suining\,\ Sichuan",
  861338836 => "Neijiang\,\ Sichuan",
  861338837 => "Neijiang\,\ Sichuan",
  861338838 => "Yibin\,\ Sichuan",
  861338839 => "Yibin\,\ Sichuan",
  861338840 => "Quzhou\,\ Zhejiang",
  861338841 => "Huzhou\,\ Zhejiang",
  861338842 => "Hangzhou\,\ Zhejiang",
  861338843 => "Hangzhou\,\ Zhejiang",
  861338844 => "Zhoushan\,\ Zhejiang",
  861338845 => "Jinhua\,\ Zhejiang",
  861338846 => "Jinhua\,\ Zhejiang",
  861338847 => "Lishui\,\ Zhejiang",
  861338848 => "Lishui\,\ Zhejiang",
  861338849 => "Shaoxing\,\ Zhejiang",
  861338850 => "Quzhou\,\ Zhejiang",
  861338851 => "Wenzhou\,\ Zhejiang",
  861338852 => "Wenzhou\,\ Zhejiang",
  861338853 => "Wenzhou\,\ Zhejiang",
  861338854 => "Wenzhou\,\ Zhejiang",
  861338855 => "Wenzhou\,\ Zhejiang",
  861338856 => "Wenzhou\,\ Zhejiang",
  861338857 => "Wenzhou\,\ Zhejiang",
  861338858 => "Wenzhou\,\ Zhejiang",
  861338859 => "Wenzhou\,\ Zhejiang",
  861338860 => "Hangzhou\,\ Zhejiang",
  861338861 => "Hangzhou\,\ Zhejiang",
  861338862 => "Jiaxing\,\ Zhejiang",
  861338863 => "Jiaxing\,\ Zhejiang",
  861338864 => "Jiaxing\,\ Zhejiang",
  861338865 => "Jinhua\,\ Zhejiang",
  861338866 => "Jinhua\,\ Zhejiang",
  861338867 => "Shaoxing\,\ Zhejiang",
  861338868 => "Shaoxing\,\ Zhejiang",
  861338869 => "Huzhou\,\ Zhejiang",
  861338870 => "Zhaotong\,\ Yunnan",
  861338871 => "Kunming\,\ Yunnan",
  861338872 => "Dali\,\ Yunnan",
  861338873 => "Honghe\,\ Yunnan",
  861338874 => "Qujing\,\ Yunnan",
  861338875 => "Baoshan\,\ Yunnan",
  861338876 => "Wenshan\,\ Yunnan",
  861338877 => "Yuxi\,\ Yunnan",
  861338878 => "Chuxiong\,\ Yunnan",
  861338879 => "Puer\,\ Yunnan",
  861338880 => "Kunming\,\ Yunnan",
  861338881 => "Xishuangbanna\,\ Yunnan",
  861338882 => "Dehong\,\ Yunnan",
  861338883 => "Lincang\,\ Yunnan",
  861338884 => "Kunming\,\ Yunnan",
  861338885 => "Kunming\,\ Yunnan",
  861338886 => "Nujiang\,\ Yunnan",
  861338887 => "Deqen\,\ Yunnan",
  861338888 => "Lijiang\,\ Yunnan",
  861338889 => "Yuxi\,\ Yunnan",
  86133889 => "Chongqing",
  86133890 => "Tianjin",
  861338910 => "Xianyang\,\ Shaanxi",
  861338911 => "YanAn\,\ Shaanxi",
  861338912 => "Yulin\,\ Shaanxi",
  861338913 => "Weinan\,\ Shaanxi",
  861338914 => "Shangluo\,\ Shaanxi",
  861338915 => "Ankang\,\ Shaanxi",
  861338916 => "Hanzhong\,\ Shaanxi",
  861338917 => "Baoji\,\ Shaanxi",
  861338918 => "XiAn\,\ Shaanxi",
  861338919 => "Tongchuan\,\ Shaanxi",
  86133892 => "XiAn\,\ Shaanxi",
  861338930 => "Linxia\,\ Gansu",
  861338931 => "Lanzhou\,\ Gansu",
  861338932 => "Dingxi\,\ Gansu",
  861338933 => "Lanzhou\,\ Gansu",
  861338934 => "Qingyang\,\ Gansu",
  861338935 => "Wuwei\,\ Gansu",
  861338936 => "Lanzhou\,\ Gansu",
  861338937 => "Jiuquan\,\ Gansu",
  861338938 => "Tianshui\,\ Gansu",
  861338939 => "Longnan\,\ Gansu",
  861338940 => "Lanzhou\,\ Gansu",
  861338941 => "Gannan\,\ Gansu",
  861338942 => "Dingxi\,\ Gansu",
  861338943 => "Jiuquan\,\ Gansu",
  861338944 => "Lanzhou\,\ Gansu",
  861338945 => "Jinchang\,\ Gansu",
  861338946 => "Qingyang\,\ Gansu",
  861338947 => "Jiuquan\,\ Gansu",
  861338948 => "Tianshui\,\ Gansu",
  861338949 => "Longnan\,\ Gansu",
  861338950 => "Yinchuan\,\ Ningxia",
  861338951 => "Yinchuan\,\ Ningxia",
  861338952 => "Shizuishan\,\ Ningxia",
  861338953 => "Wuzhong\,\ Ningxia",
  861338954 => "Guyuan\,\ Ningxia",
  861338955 => "Zhongwei\,\ Ningxia",
  861338956 => "Zhongwei\,\ Ningxia",
  861338957 => "Wuzhong\,\ Ningxia",
  861338958 => "Yinchuan\,\ Ningxia",
  861338959 => "Guyuan\,\ Ningxia",
  86133896 => "Chongqing",
  861338970 => "Haibei\,\ Qinghai",
  861338971 => "Xining\,\ Qinghai",
  861338972 => "Haidong\,\ Qinghai",
  861338973 => "Huangnan\,\ Qinghai",
  861338974 => "Hainan\,\ Qinghai",
  861338975 => "Xining\,\ Qinghai",
  861338976 => "Yushu\,\ Qinghai",
  861338977 => "Haixi\,\ Qinghai",
  861338978 => "Xining\,\ Qinghai",
  861338979 => "Haixi\,\ Qinghai",
  86133898 => "Haikou\,\ Hainan",
  86133899 => "Tianjin",
  861339000 => "Dalian\,\ Liaoning",
  861339001 => "Dalian\,\ Liaoning",
  861339002 => "Dalian\,\ Liaoning",
  861339003 => "Dalian\,\ Liaoning",
  861339004 => "Dalian\,\ Liaoning",
  861339005 => "Dalian\,\ Liaoning",
  861339006 => "Dalian\,\ Liaoning",
  861339007 => "Anshan\,\ Liaoning",
  861339008 => "Anshan\,\ Liaoning",
  861339009 => "Anshan\,\ Liaoning",
  861339010 => "Shenyang\,\ Liaoning",
  861339011 => "Shenyang\,\ Liaoning",
  861339012 => "Shenyang\,\ Liaoning",
  861339013 => "Shenyang\,\ Liaoning",
  861339014 => "Shenyang\,\ Liaoning",
  861339015 => "Shenyang\,\ Liaoning",
  861339016 => "Shenyang\,\ Liaoning",
  861339017 => "Benxi\,\ Liaoning",
  861339018 => "Benxi\,\ Liaoning",
  861339019 => "Benxi\,\ Liaoning",
  861339020 => "Jinzhou\,\ Liaoning",
  861339021 => "Jinzhou\,\ Liaoning",
  861339022 => "Jinzhou\,\ Liaoning",
  861339023 => "Liaoyang\,\ Liaoning",
  861339024 => "Shenyang\,\ Liaoning",
  861339025 => "Yingkou\,\ Liaoning",
  861339026 => "Yingkou\,\ Liaoning",
  861339027 => "Panjin\,\ Liaoning",
  861339028 => "Tieling\,\ Liaoning",
  861339029 => "Huludao\,\ Liaoning",
  861339030 => "Anshan\,\ Liaoning",
  861339031 => "Anshan\,\ Liaoning",
  861339032 => "Anshan\,\ Liaoning",
  861339033 => "Anshan\,\ Liaoning",
  861339034 => "Anshan\,\ Liaoning",
  861339035 => "Benxi\,\ Liaoning",
  861339036 => "Dandong\,\ Liaoning",
  861339037 => "Jinzhou\,\ Liaoning",
  861339038 => "Panjin\,\ Liaoning",
  861339039 => "Chaoyang\,\ Liaoning",
  861339040 => "Tieling\,\ Liaoning",
  861339041 => "Panjin\,\ Liaoning",
  861339042 => "Huludao\,\ Liaoning",
  861339043 => "Fushun\,\ Liaoning",
  861339044 => "Benxi\,\ Liaoning",
  861339045 => "Dandong\,\ Liaoning",
  861339046 => "Jinzhou\,\ Liaoning",
  861339047 => "Yingkou\,\ Liaoning",
  861339048 => "Fuxin\,\ Liaoning",
  861339049 => "Liaoyang\,\ Liaoning",
  861339050 => "Dalian\,\ Liaoning",
  861339051 => "Dalian\,\ Liaoning",
  861339052 => "Dalian\,\ Liaoning",
  861339053 => "Dalian\,\ Liaoning",
  861339054 => "Dalian\,\ Liaoning",
  861339055 => "Shenyang\,\ Liaoning",
  861339056 => "Shenyang\,\ Liaoning",
  861339057 => "Shenyang\,\ Liaoning",
  861339058 => "Shenyang\,\ Liaoning",
  861339059 => "Shenyang\,\ Liaoning",
  861339060 => "Yangzhou\,\ Jiangsu",
  861339061 => "Yangzhou\,\ Jiangsu",
  861339062 => "Yangzhou\,\ Jiangsu",
  861339063 => "Yangzhou\,\ Jiangsu",
  861339064 => "Yangzhou\,\ Jiangsu",
  861339065 => "Yangzhou\,\ Jiangsu",
  861339066 => "Yangzhou\,\ Jiangsu",
  861339067 => "Yancheng\,\ Jiangsu",
  861339068 => "Yancheng\,\ Jiangsu",
  861339069 => "Yancheng\,\ Jiangsu",
  861339070 => "Yancheng\,\ Jiangsu",
  861339071 => "Yancheng\,\ Jiangsu",
  861339072 => "Yancheng\,\ Jiangsu",
  861339073 => "Yancheng\,\ Jiangsu",
  861339074 => "Yancheng\,\ Jiangsu",
  861339075 => "Nanjing\,\ Jiangsu",
  861339076 => "Nanjing\,\ Jiangsu",
  861339077 => "Nanjing\,\ Jiangsu",
  861339078 => "Nanjing\,\ Jiangsu",
  861339079 => "Nanjing\,\ Jiangsu",
  861339080 => "HuaiAn\,\ Jiangsu",
  861339081 => "HuaiAn\,\ Jiangsu",
  861339082 => "Suzhou\,\ Jiangsu",
  861339083 => "Suzhou\,\ Jiangsu",
  861339084 => "Suzhou\,\ Jiangsu",
  861339085 => "Suzhou\,\ Jiangsu",
  861339086 => "Suzhou\,\ Jiangsu",
  861339087 => "Suzhou\,\ Jiangsu",
  861339088 => "Suzhou\,\ Jiangsu",
  861339089 => "Suzhou\,\ Jiangsu",
  861339090 => "Nanjing\,\ Jiangsu",
  861339091 => "Nanjing\,\ Jiangsu",
  861339092 => "Nanjing\,\ Jiangsu",
  861339093 => "Nantong\,\ Jiangsu",
  861339094 => "Nantong\,\ Jiangsu",
  861339095 => "Nantong\,\ Jiangsu",
  861339096 => "Nantong\,\ Jiangsu",
  861339097 => "Nantong\,\ Jiangsu",
  861339098 => "Nantong\,\ Jiangsu",
  861339099 => "Nantong\,\ Jiangsu",
  86133910 => "Shanghai",
  86133911 => "Shanghai",
  86133912 => "Shanghai",
  86133913 => "Shanghai",
  86133914 => "Shanghai",
  86133915 => "Beijing",
  86133916 => "Beijing",
  86133917 => "Beijing",
  86133918 => "Beijing",
  86133919 => "Beijing",
  861339200 => "Huizhou\,\ Guangdong",
  861339201 => "Huizhou\,\ Guangdong",
  861339202 => "Huizhou\,\ Guangdong",
  861339203 => "Huizhou\,\ Guangdong",
  861339204 => "Huizhou\,\ Guangdong",
  861339205 => "Jiangmen\,\ Guangdong",
  861339206 => "Jiangmen\,\ Guangdong",
  861339207 => "Jiangmen\,\ Guangdong",
  861339208 => "Jiangmen\,\ Guangdong",
  861339209 => "Jiangmen\,\ Guangdong",
  861339210 => "Guangzhou\,\ Guangdong",
  861339211 => "Guangzhou\,\ Guangdong",
  861339212 => "Guangzhou\,\ Guangdong",
  861339213 => "Guangzhou\,\ Guangdong",
  861339214 => "Guangzhou\,\ Guangdong",
  861339215 => "Shenzhen\,\ Guangdong",
  861339216 => "Shenzhen\,\ Guangdong",
  861339217 => "Shenzhen\,\ Guangdong",
  861339218 => "Shenzhen\,\ Guangdong",
  861339219 => "Shenzhen\,\ Guangdong",
  86133922 => "Foshan\,\ Guangdong",
  86133923 => "Dongguan\,\ Guangdong",
  861339240 => "Shenzhen\,\ Guangdong",
  861339241 => "Shenzhen\,\ Guangdong",
  861339242 => "Shenzhen\,\ Guangdong",
  861339243 => "Shenzhen\,\ Guangdong",
  861339244 => "Shenzhen\,\ Guangdong",
  861339245 => "Guangzhou\,\ Guangdong",
  861339246 => "Guangzhou\,\ Guangdong",
  861339247 => "Guangzhou\,\ Guangdong",
  861339248 => "Guangzhou\,\ Guangdong",
  861339249 => "Guangzhou\,\ Guangdong",
  861339250 => "Jiangmen\,\ Guangdong",
  861339251 => "Jiangmen\,\ Guangdong",
  861339252 => "Zhuhai\,\ Guangdong",
  861339253 => "Zhuhai\,\ Guangdong",
  861339254 => "Zhuhai\,\ Guangdong",
  861339255 => "Huizhou\,\ Guangdong",
  861339256 => "Huizhou\,\ Guangdong",
  861339257 => "Zhongshan\,\ Guangdong",
  861339258 => "Zhongshan\,\ Guangdong",
  861339259 => "Zhongshan\,\ Guangdong",
  86133926 => "Guangzhou\,\ Guangdong",
  861339270 => "Dongguan\,\ Guangdong",
  861339271 => "Dongguan\,\ Guangdong",
  861339272 => "Dongguan\,\ Guangdong",
  861339273 => "Dongguan\,\ Guangdong",
  861339274 => "Dongguan\,\ Guangdong",
  861339275 => "Foshan\,\ Guangdong",
  861339276 => "Foshan\,\ Guangdong",
  861339277 => "Foshan\,\ Guangdong",
  861339278 => "Foshan\,\ Guangdong",
  861339279 => "Foshan\,\ Guangdong",
  86133928 => "Shenzhen\,\ Guangdong",
  861339290 => "Zhongshan\,\ Guangdong",
  861339291 => "Zhongshan\,\ Guangdong",
  861339292 => "Zhongshan\,\ Guangdong",
  861339293 => "Zhongshan\,\ Guangdong",
  861339294 => "Zhongshan\,\ Guangdong",
  861339295 => "Zhuhai\,\ Guangdong",
  861339296 => "Zhuhai\,\ Guangdong",
  861339297 => "Zhuhai\,\ Guangdong",
  861339298 => "Zhuhai\,\ Guangdong",
  861339299 => "Zhuhai\,\ Guangdong",
  861339300 => "Handan\,\ Hebei",
  861339301 => "Shijiazhuang\,\ Hebei",
  861339302 => "Baoding\,\ Hebei",
  861339303 => "Shijiazhuang\,\ Hebei",
  861339304 => "Shijiazhuang\,\ Hebei",
  861339305 => "Tangshan\,\ Hebei",
  861339306 => "Langfang\,\ Hebei",
  861339307 => "Cangzhou\,\ Hebei",
  861339308 => "Hengshui\,\ Hebei",
  861339309 => "Xingtai\,\ Hebei",
  861339310 => "Handan\,\ Hebei",
  861339311 => "Shijiazhuang\,\ Hebei",
  861339312 => "Baoding\,\ Hebei",
  861339313 => "Zhangjiakou\,\ Hebei",
  861339314 => "Chengde\,\ Hebei",
  861339315 => "Tangshan\,\ Hebei",
  861339316 => "Langfang\,\ Hebei",
  861339317 => "Cangzhou\,\ Hebei",
  861339318 => "Hengshui\,\ Hebei",
  861339319 => "Xingtai\,\ Hebei",
  861339320 => "Qinhuangdao\,\ Hebei",
  861339321 => "Shijiazhuang\,\ Hebei",
  861339322 => "Baoding\,\ Hebei",
  861339323 => "Shijiazhuang\,\ Hebei",
  861339324 => "Zhangjiakou\,\ Hebei",
  861339325 => "Tangshan\,\ Hebei",
  861339326 => "Langfang\,\ Hebei",
  861339327 => "Cangzhou\,\ Hebei",
  861339328 => "Hengshui\,\ Hebei",
  861339329 => "Xingtai\,\ Hebei",
  861339330 => "Qinhuangdao\,\ Hebei",
  861339331 => "Shijiazhuang\,\ Hebei",
  861339332 => "Baoding\,\ Hebei",
  861339333 => "Zhangjiakou\,\ Hebei",
  861339334 => "Qinhuangdao\,\ Hebei",
  861339335 => "Qinhuangdao\,\ Hebei",
  861339336 => "Langfang\,\ Hebei",
  861339337 => "Cangzhou\,\ Hebei",
  861339338 => "Cangzhou\,\ Hebei",
  861339339 => "Cangzhou\,\ Hebei",
  861339340 => "Taiyuan\,\ Shanxi",
  861339341 => "Taiyuan\,\ Shanxi",
  861339342 => "Datong\,\ Shanxi",
  861339343 => "Taiyuan\,\ Shanxi",
  861339344 => "Jinzhong\,\ Shanxi",
  861339345 => "Changzhi\,\ Shanxi",
  861339346 => "Jincheng\,\ Shanxi",
  861339347 => "Linfen\,\ Shanxi",
  861339348 => "Yuncheng\,\ Shanxi",
  861339349 => "Shuozhou\,\ Shanxi",
  861339350 => "Xinzhou\,\ Shanxi",
  861339351 => "Taiyuan\,\ Shanxi",
  861339352 => "Datong\,\ Shanxi",
  861339353 => "Yangquan\,\ Shanxi",
  861339354 => "Jinzhong\,\ Shanxi",
  861339355 => "Changzhi\,\ Shanxi",
  861339356 => "Jincheng\,\ Shanxi",
  861339357 => "Linfen\,\ Shanxi",
  861339358 => "Lüliang\,\ Shanxi",
  861339359 => "Yuncheng\,\ Shanxi",
  861339360 => "Laibin\,\ Guangxi",
  861339361 => "Nanning\,\ Guangxi",
  861339362 => "Laibin\,\ Guangxi",
  861339363 => "Guilin\,\ Guangxi",
  861339364 => "Nanning\,\ Guangxi",
  861339365 => "Yulin\,\ Guangxi",
  861339366 => "Nanning\,\ Guangxi",
  861339367 => "Nanning\,\ Guangxi",
  861339368 => "Nanning\,\ Guangxi",
  861339369 => "Nanning\,\ Guangxi",
  861339370 => "Zhengzhou\,\ Henan",
  861339371 => "Zhengzhou\,\ Henan",
  861339372 => "Zhengzhou\,\ Henan",
  861339373 => "Zhengzhou\,\ Henan",
  861339374 => "Zhengzhou\,\ Henan",
  861339375 => "Pingdingshan\,\ Henan",
  861339376 => "Pingdingshan\,\ Henan",
  861339377 => "Pingdingshan\,\ Henan",
  861339378 => "Pingdingshan\,\ Henan",
  861339379 => "Pingdingshan\,\ Henan",
  861339380 => "Kaifeng\,\ Henan",
  861339381 => "Kaifeng\,\ Henan",
  861339382 => "Kaifeng\,\ Henan",
  861339383 => "Kaifeng\,\ Henan",
  861339384 => "Kaifeng\,\ Henan",
  861339385 => "Jiaozuo\,\ Henan",
  861339386 => "Jiaozuo\,\ Henan",
  861339387 => "Jiaozuo\,\ Henan",
  861339388 => "Jiaozuo\,\ Henan",
  861339389 => "Jiaozuo\,\ Henan",
  861339390 => "Zhoukou\,\ Henan",
  861339391 => "Zhoukou\,\ Henan",
  861339392 => "Zhoukou\,\ Henan",
  861339393 => "Zhoukou\,\ Henan",
  861339394 => "Zhoukou\,\ Henan",
  861339395 => "Zhumadian\,\ Henan",
  861339396 => "Zhumadian\,\ Henan",
  861339397 => "Zhumadian\,\ Henan",
  861339398 => "Zhumadian\,\ Henan",
  861339399 => "Zhumadian\,\ Henan",
  861339400 => "Fuzhou\,\ Fujian",
  861339401 => "Sanming\,\ Fujian",
  861339402 => "Quanzhou\,\ Fujian",
  861339403 => "Zhangzhou\,\ Fujian",
  861339404 => "Xiamen\,\ Fujian",
  861339405 => "Xiamen\,\ Fujian",
  861339406 => "Xiamen\,\ Fujian",
  861339407 => "Quanzhou\,\ Fujian",
  861339408 => "Nanping\,\ Fujian",
  861339409 => "Longyan\,\ Fujian",
  861339410 => "Tieling\,\ Liaoning",
  861339411 => "Dalian\,\ Liaoning",
  861339412 => "Anshan\,\ Liaoning",
  861339413 => "Fushun\,\ Liaoning",
  861339414 => "Benxi\,\ Liaoning",
  861339415 => "Dandong\,\ Liaoning",
  861339416 => "Jinzhou\,\ Liaoning",
  861339417 => "Yingkou\,\ Liaoning",
  861339418 => "Fuxin\,\ Liaoning",
  861339419 => "Liaoyang\,\ Liaoning",
  861339420 => "Anshan\,\ Liaoning",
  861339421 => "Chaoyang\,\ Liaoning",
  861339422 => "Fushun\,\ Liaoning",
  861339423 => "Fushun\,\ Liaoning",
  861339424 => "Chaoyang\,\ Liaoning",
  861339425 => "Dandong\,\ Liaoning",
  861339426 => "Dandong\,\ Liaoning",
  861339427 => "Panjin\,\ Liaoning",
  861339428 => "Fuxin\,\ Liaoning",
  861339429 => "Huludao\,\ Liaoning",
  861339430 => "Changchun\,\ Jilin",
  861339431 => "Changchun\,\ Jilin",
  861339432 => "Jilin\,\ Jilin",
  861339433 => "Yanbian\,\ Jilin",
  861339434 => "Siping\,\ Jilin",
  861339435 => "Tonghua\,\ Jilin",
  861339436 => "Baicheng\,\ Jilin",
  861339437 => "Liaoyuan\,\ Jilin",
  861339438 => "Songyuan\,\ Jilin",
  861339439 => "Baishan\,\ Jilin",
  861339440 => "Jilin\,\ Jilin",
  861339441 => "Jilin\,\ Jilin",
  861339442 => "Jilin\,\ Jilin",
  861339443 => "Yanbian\,\ Jilin",
  861339444 => "Siping\,\ Jilin",
  861339445 => "Tonghua\,\ Jilin",
  861339446 => "Baicheng\,\ Jilin",
  861339447 => "Changchun\,\ Jilin",
  861339448 => "Changchun\,\ Jilin",
  861339449 => "Changchun\,\ Jilin",
  861339450 => "Harbin\,\ Heilongjiang",
  861339451 => "Harbin\,\ Heilongjiang",
  861339452 => "Qiqihar\,\ Heilongjiang",
  861339453 => "Mudanjiang\,\ Heilongjiang",
  861339454 => "Jiamusi\,\ Heilongjiang",
  861339455 => "Suihua\,\ Heilongjiang",
  861339456 => "Heihe\,\ Heilongjiang",
  861339457 => "Jiamusi\,\ Heilongjiang",
  861339458 => "Yichun\,\ Heilongjiang",
  861339459 => "Daqing\,\ Heilongjiang",
  861339460 => "Harbin\,\ Heilongjiang",
  861339461 => "Harbin\,\ Heilongjiang",
  861339462 => "Qiqihar\,\ Heilongjiang",
  861339463 => "Daqing\,\ Heilongjiang",
  861339464 => "Daqing\,\ Heilongjiang",
  861339465 => "Daqing\,\ Heilongjiang",
  861339466 => "Daqing\,\ Heilongjiang",
  861339467 => "Jixi\,\ Heilongjiang",
  861339468 => "Hegang\,\ Heilongjiang",
  861339469 => "Shuangyashan\,\ Heilongjiang",
  861339470 => "Hulun\,\ Inner\ Mongolia",
  861339471 => "Hohhot\,\ Inner\ Mongolia",
  861339472 => "Baotou\,\ Inner\ Mongolia",
  861339473 => "Wuhai\,\ Inner\ Mongolia",
  861339474 => "Hinggan\,\ Inner\ Mongolia",
  861339475 => "Tongliao\,\ Inner\ Mongolia",
  861339476 => "Chifeng\,\ Inner\ Mongolia",
  861339477 => "Ordos\,\ Inner\ Mongolia",
  861339478 => "Bayannur\,\ Inner\ Mongolia",
  861339479 => "Xilin\,\ Inner\ Mongolia",
  861339480 => "Hulun\,\ Inner\ Mongolia",
  861339481 => "Hulun\,\ Inner\ Mongolia",
  861339482 => "Hinggan\,\ Inner\ Mongolia",
  861339483 => "Bayannur\,\ Inner\ Mongolia",
  861339484 => "Chifeng\,\ Inner\ Mongolia",
  861339485 => "Bayannur\,\ Inner\ Mongolia",
  861339486 => "Bayannur\,\ Inner\ Mongolia",
  861339487 => "Bayannur\,\ Inner\ Mongolia",
  861339488 => "Hinggan\,\ Inner\ Mongolia",
  861339489 => "Hohhot\,\ Inner\ Mongolia",
  861339490 => "Kizilsu\,\ Xinjiang",
  861339491 => "Urumchi\,\ Xinjiang",
  861339492 => "Ili\,\ Xinjiang",
  861339493 => "Shihezi\,\ Xinjiang",
  861339494 => "Karamay\,\ Xinjiang",
  861339495 => "Turpan\,\ Xinjiang",
  861339496 => "Changji\,\ Xinjiang",
  861339497 => "Aksu\,\ Xinjiang",
  861339498 => "Aksu\,\ Xinjiang",
  861339499 => "Ili\,\ Xinjiang",
  861339500 => "Fuzhou\,\ Fujian",
  861339501 => "Xiamen\,\ Fujian",
  861339502 => "Xiamen\,\ Fujian",
  861339503 => "Xiamen\,\ Fujian",
  861339504 => "Fuzhou\,\ Fujian",
  861339505 => "Xiamen\,\ Fujian",
  861339506 => "Quanzhou\,\ Fujian",
  861339507 => "Xiamen\,\ Fujian",
  861339508 => "Fuzhou\,\ Fujian",
  861339509 => "Quanzhou\,\ Fujian",
  86133951 => "Wuxi\,\ Jiangsu",
  861339520 => "HuaiAn\,\ Jiangsu",
  861339521 => "HuaiAn\,\ Jiangsu",
  861339522 => "Xuzhou\,\ Jiangsu",
  861339523 => "Xuzhou\,\ Jiangsu",
  861339524 => "Xuzhou\,\ Jiangsu",
  861339525 => "Xuzhou\,\ Jiangsu",
  861339526 => "Xuzhou\,\ Jiangsu",
  861339527 => "Xuzhou\,\ Jiangsu",
  861339528 => "Xuzhou\,\ Jiangsu",
  861339529 => "Xuzhou\,\ Jiangsu",
  861339530 => "Heze\,\ Shandong",
  861339531 => "Jinan\,\ Shandong",
  861339532 => "Qingdao\,\ Shandong",
  861339533 => "Zibo\,\ Shandong",
  861339534 => "Dezhou\,\ Shandong",
  861339535 => "Yantai\,\ Shandong",
  861339536 => "Weifang\,\ Shandong",
  861339537 => "Jining\,\ Shandong",
  861339538 => "TaiAn\,\ Shandong",
  861339539 => "Linyi\,\ Shandong",
  861339540 => "Heze\,\ Shandong",
  861339541 => "Jinan\,\ Shandong",
  861339542 => "Qingdao\,\ Shandong",
  861339543 => "Binzhou\,\ Shandong",
  861339544 => "Dezhou\,\ Shandong",
  861339545 => "Yantai\,\ Shandong",
  861339546 => "Dongying\,\ Shandong",
  861339547 => "Jining\,\ Shandong",
  861339548 => "TaiAn\,\ Shandong",
  861339549 => "Linyi\,\ Shandong",
  861339550 => "Chuzhou\,\ Anhui",
  861339551 => "Hefei\,\ Anhui",
  861339552 => "Bengbu\,\ Anhui",
  861339553 => "Wuhu\,\ Anhui",
  861339554 => "Huainan\,\ Anhui",
  861339555 => "MaAnshan\,\ Anhui",
  861339556 => "Anqing\,\ Anhui",
  861339557 => "Suzhou\,\ Anhui",
  861339558 => "Fuyang\,\ Anhui",
  861339559 => "Huangshan\,\ Anhui",
  861339560 => "Hefei\,\ Anhui",
  861339561 => "Huaibei\,\ Anhui",
  861339562 => "Tongling\,\ Anhui",
  861339563 => "Xuancheng\,\ Anhui",
  861339564 => "LuAn\,\ Anhui",
  861339565 => "Chaohu\,\ Anhui",
  861339566 => "Chizhou\,\ Anhui",
  861339567 => "Bozhou\,\ Anhui",
  861339568 => "LuAn\,\ Anhui",
  861339569 => "Hefei\,\ Anhui",
  861339570 => "Quzhou\,\ Zhejiang",
  861339571 => "Hangzhou\,\ Zhejiang",
  861339572 => "Huzhou\,\ Zhejiang",
  861339573 => "Jiaxing\,\ Zhejiang",
  861339574 => "Ningbo\,\ Zhejiang",
  861339575 => "Shaoxing\,\ Zhejiang",
  861339576 => "Taizhou\,\ Zhejiang",
  861339577 => "Wenzhou\,\ Zhejiang",
  861339578 => "Lishui\,\ Zhejiang",
  861339579 => "Jinhua\,\ Zhejiang",
  861339580 => "Zhoushan\,\ Zhejiang",
  861339581 => "Hangzhou\,\ Zhejiang",
  861339582 => "Huzhou\,\ Zhejiang",
  861339583 => "Jiaxing\,\ Zhejiang",
  861339584 => "Ningbo\,\ Zhejiang",
  861339585 => "Shaoxing\,\ Zhejiang",
  861339586 => "Taizhou\,\ Zhejiang",
  861339587 => "Wenzhou\,\ Zhejiang",
  861339588 => "Lishui\,\ Zhejiang",
  861339589 => "Jinhua\,\ Zhejiang",
  861339590 => "Fuzhou\,\ Fujian",
  861339591 => "Fuzhou\,\ Fujian",
  861339592 => "Nanping\,\ Fujian",
  861339593 => "Ningde\,\ Fujian",
  861339594 => "Putian\,\ Fujian",
  861339595 => "Quanzhou\,\ Fujian",
  861339596 => "Zhangzhou\,\ Fujian",
  861339597 => "Longyan\,\ Fujian",
  861339598 => "Sanming\,\ Fujian",
  861339599 => "Xiamen\,\ Fujian",
  861339600 => "Jingzhou\,\ Hubei",
  861339601 => "Xiantao\,\ Hubei",
  861339602 => "Wuhan\,\ Hubei",
  861339603 => "Wuhan\,\ Hubei",
  861339604 => "Wuhan\,\ Hubei",
  861339605 => "Wuhan\,\ Hubei",
  861339606 => "Wuhan\,\ Hubei",
  861339607 => "Wuhan\,\ Hubei",
  861339608 => "Wuhan\,\ Hubei",
  861339609 => "Wuhan\,\ Hubei",
  861339610 => "Xiangfan\,\ Hubei",
  861339611 => "Xiangfan\,\ Hubei",
  861339612 => "Xiangfan\,\ Hubei",
  861339613 => "Xianning\,\ Hubei",
  861339614 => "Yichang\,\ Hubei",
  861339615 => "Yichang\,\ Hubei",
  861339616 => "Jingmen\,\ Hubei",
  861339617 => "Suizhou\,\ Hubei",
  861339618 => "Xiaogan\,\ Hubei",
  861339619 => "Enshi\,\ Hubei",
  861339620 => "Heze\,\ Shandong",
  861339621 => "Heze\,\ Shandong",
  861339622 => "Liaocheng\,\ Shandong",
  861339623 => "Rizhao\,\ Shandong",
  861339624 => "Weihai\,\ Shandong",
  861339625 => "Liaocheng\,\ Shandong",
  861339626 => "Dezhou\,\ Shandong",
  861339627 => "Dezhou\,\ Shandong",
  861339628 => "Binzhou\,\ Shandong",
  861339629 => "Binzhou\,\ Shandong",
  861339630 => "Weihai\,\ Shandong",
  861339631 => "Weihai\,\ Shandong",
  861339632 => "Zaozhuang\,\ Shandong",
  861339633 => "Rizhao\,\ Shandong",
  861339634 => "Laiwu\,\ Shandong",
  861339635 => "Liaocheng\,\ Shandong",
  861339636 => "Weifang\,\ Shandong",
  861339637 => "Zaozhuang\,\ Shandong",
  861339638 => "Yantai\,\ Shandong",
  861339639 => "Qingdao\,\ Shandong",
  861339640 => "Jinan\,\ Shandong",
  861339641 => "Jinan\,\ Shandong",
  861339642 => "Qingdao\,\ Shandong",
  861339643 => "Zibo\,\ Shandong",
  861339644 => "Jinan\,\ Shandong",
  861339645 => "Yantai\,\ Shandong",
  861339646 => "Weifang\,\ Shandong",
  861339647 => "Dongying\,\ Shandong",
  861339648 => "Qingdao\,\ Shandong",
  861339649 => "Binzhou\,\ Shandong",
  86133965 => "Hangzhou\,\ Zhejiang",
  86133966 => "Ningbo\,\ Zhejiang",
  861339670 => "Quzhou\,\ Zhejiang",
  861339671 => "Hangzhou\,\ Zhejiang",
  861339672 => "Huzhou\,\ Zhejiang",
  861339673 => "Jiaxing\,\ Zhejiang",
  861339674 => "Ningbo\,\ Zhejiang",
  861339675 => "Shaoxing\,\ Zhejiang",
  861339676 => "Taizhou\,\ Zhejiang",
  861339677 => "Wenzhou\,\ Zhejiang",
  861339678 => "Lishui\,\ Zhejiang",
  861339679 => "Jinhua\,\ Zhejiang",
  861339680 => "Zhoushan\,\ Zhejiang",
  861339681 => "Hangzhou\,\ Zhejiang",
  861339682 => "Huzhou\,\ Zhejiang",
  861339683 => "Jiaxing\,\ Zhejiang",
  861339684 => "Ningbo\,\ Zhejiang",
  861339685 => "Shaoxing\,\ Zhejiang",
  861339686 => "Taizhou\,\ Zhejiang",
  861339687 => "Wenzhou\,\ Zhejiang",
  861339688 => "Lishui\,\ Zhejiang",
  861339689 => "Jinhua\,\ Zhejiang",
  861339690 => "Taizhou\,\ Zhejiang",
  861339691 => "Taizhou\,\ Zhejiang",
  861339692 => "Taizhou\,\ Zhejiang",
  861339693 => "Taizhou\,\ Zhejiang",
  861339694 => "Taizhou\,\ Zhejiang",
  861339695 => "Wenzhou\,\ Zhejiang",
  861339696 => "Wenzhou\,\ Zhejiang",
  861339697 => "Wenzhou\,\ Zhejiang",
  861339698 => "Wenzhou\,\ Zhejiang",
  861339699 => "Wenzhou\,\ Zhejiang",
  861339700 => "Nanchang\,\ Jiangxi",
  861339701 => "Yingtan\,\ Jiangxi",
  861339702 => "Fuzhou\,\ Jiangxi",
  861339703 => "Shangrao\,\ Jiangxi",
  861339704 => "Jiujiang\,\ Jiangxi",
  861339705 => "Yichun\,\ Jiangxi",
  861339706 => "JiAn\,\ Jiangxi",
  861339707 => "Ganzhou\,\ Jiangxi",
  861339708 => "Nanchang\,\ Jiangxi",
  861339709 => "Nanchang\,\ Jiangxi",
  86133971 => "Wuhan\,\ Hubei",
  861339720 => "Yichang\,\ Hubei",
  861339721 => "Jingzhou\,\ Hubei",
  861339722 => "Jingzhou\,\ Hubei",
  861339723 => "Huangshi\,\ Hubei",
  861339724 => "Ezhou\,\ Hubei",
  861339725 => "Huanggang\,\ Hubei",
  861339726 => "Huanggang\,\ Hubei",
  861339727 => "Xiaogan\,\ Hubei",
  861339728 => "Shiyan\,\ Hubei",
  861339729 => "Shiyan\,\ Hubei",
  861339730 => "Yueyang\,\ Hunan",
  861339731 => "Changsha\,\ Hunan",
  861339732 => "Xiangtan\,\ Hunan",
  861339733 => "Zhuzhou\,\ Hunan",
  861339734 => "Hengyang\,\ Hunan",
  861339735 => "Chenzhou\,\ Hunan",
  861339736 => "Changde\,\ Hunan",
  861339737 => "Yiyang\,\ Hunan",
  861339738 => "Loudi\,\ Hunan",
  861339739 => "Shaoyang\,\ Hunan",
  861339740 => "Yueyang\,\ Hunan",
  861339741 => "Changsha\,\ Hunan",
  861339742 => "Xiangtan\,\ Hunan",
  861339743 => "Xiangxi\,\ Hunan",
  861339744 => "Zhangjiajie\,\ Hunan",
  861339745 => "Huaihua\,\ Hunan",
  861339746 => "Yongzhou\,\ Hunan",
  861339747 => "Hengyang\,\ Hunan",
  861339748 => "Changsha\,\ Hunan",
  861339749 => "Changsha\,\ Hunan",
  861339750 => "Yueyang\,\ Hunan",
  861339751 => "Changsha\,\ Hunan",
  861339752 => "Xiangtan\,\ Hunan",
  861339753 => "Zhuzhou\,\ Hunan",
  861339754 => "Chenzhou\,\ Hunan",
  861339755 => "Chenzhou\,\ Hunan",
  861339756 => "Changde\,\ Hunan",
  861339757 => "Yiyang\,\ Hunan",
  861339758 => "Loudi\,\ Hunan",
  861339759 => "Shaoyang\,\ Hunan",
  861339760 => "Changsha\,\ Hunan",
  861339761 => "Changsha\,\ Hunan",
  861339762 => "Yongzhou\,\ Hunan",
  861339763 => "Xiangxi\,\ Hunan",
  861339764 => "Changsha\,\ Hunan",
  861339765 => "Huaihua\,\ Hunan",
  861339766 => "Changde\,\ Hunan",
  861339767 => "Hengyang\,\ Hunan",
  861339768 => "Zhuzhou\,\ Hunan",
  861339769 => "Shaoyang\,\ Hunan",
  861339770 => "Nanning\,\ Guangxi",
  861339771 => "Nanning\,\ Guangxi",
  861339772 => "Liuzhou\,\ Guangxi",
  861339773 => "Guilin\,\ Guangxi",
  861339774 => "Hezhou\,\ Guangxi",
  861339775 => "Yulin\,\ Guangxi",
  861339776 => "Baise\,\ Guangxi",
  861339777 => "Nanning\,\ Guangxi",
  861339778 => "Hechi\,\ Guangxi",
  861339779 => "Beihai\,\ Guangxi",
  861339780 => "Nanning\,\ Guangxi",
  861339781 => "Nanning\,\ Guangxi",
  861339782 => "Liuzhou\,\ Guangxi",
  861339783 => "Guilin\,\ Guangxi",
  861339784 => "Wuzhou\,\ Guangxi",
  861339785 => "Guigang\,\ Guangxi",
  861339786 => "Baise\,\ Guangxi",
  861339787 => "Liuzhou\,\ Guangxi",
  861339788 => "Hechi\,\ Guangxi",
  861339789 => "Nanning\,\ Guangxi",
  861339790 => "Xinyu\,\ Jiangxi",
  861339791 => "Nanchang\,\ Jiangxi",
  861339792 => "Jiujiang\,\ Jiangxi",
  861339793 => "Shangrao\,\ Jiangxi",
  861339794 => "Fuzhou\,\ Jiangxi",
  861339795 => "Yichun\,\ Jiangxi",
  861339796 => "JiAn\,\ Jiangxi",
  861339797 => "Ganzhou\,\ Jiangxi",
  861339798 => "Jingdezhen\,\ Jiangxi",
  861339799 => "Pingxiang\,\ Jiangxi",
  861339800 => "Lhasa\,\ Tibet",
  861339801 => "Lhasa\,\ Tibet",
  861339802 => "Xigaze\,\ Tibet",
  861339803 => "Shannan\,\ Tibet",
  861339804 => "Nyingchi\,\ Tibet",
  861339805 => "Qamdo\,\ Tibet",
  861339806 => "Nagqu\,\ Tibet",
  861339807 => "Ngari\,\ Tibet",
  861339808 => "Lhasa\,\ Tibet",
  861339809 => "Lhasa\,\ Tibet",
  861339810 => "Neijiang\,\ Sichuan",
  861339811 => "Neijiang\,\ Sichuan",
  861339812 => "Zigong\,\ Sichuan",
  861339813 => "Zigong\,\ Sichuan",
  861339814 => "Meishan\,\ Sichuan",
  861339815 => "Chengdu\,\ Sichuan",
  861339816 => "Chengdu\,\ Sichuan",
  861339817 => "Chengdu\,\ Sichuan",
  861339818 => "Chengdu\,\ Sichuan",
  861339819 => "Chengdu\,\ Sichuan",
  861339820 => "Yibin\,\ Sichuan",
  861339821 => "Yibin\,\ Sichuan",
  861339822 => "Suining\,\ Sichuan",
  861339823 => "Leshan\,\ Sichuan",
  861339824 => "Leshan\,\ Sichuan",
  861339825 => "Leshan\,\ Sichuan",
  861339826 => "Luzhou\,\ Sichuan",
  861339827 => "Luzhou\,\ Sichuan",
  861339828 => "Luzhou\,\ Sichuan",
  861339829 => "Luzhou\,\ Sichuan",
  861339830 => "Ziyang\,\ Sichuan",
  861339831 => "Ziyang\,\ Sichuan",
  861339832 => "Dazhou\,\ Sichuan",
  861339833 => "Dazhou\,\ Sichuan",
  861339834 => "Dazhou\,\ Sichuan",
  861339835 => "Mianyang\,\ Sichuan",
  861339836 => "Mianyang\,\ Sichuan",
  861339837 => "Mianyang\,\ Sichuan",
  861339838 => "Mianyang\,\ Sichuan",
  861339839 => "Mianyang\,\ Sichuan",
  861339840 => "YaAn\,\ Sichuan",
  861339841 => "Nanchong\,\ Sichuan",
  861339842 => "Nanchong\,\ Sichuan",
  861339843 => "GuangAn\,\ Sichuan",
  861339844 => "Guangyuan\,\ Sichuan",
  861339845 => "Bazhong\,\ Sichuan",
  861339846 => "Panzhihua\,\ Sichuan",
  861339847 => "Liangshan\,\ Sichuan",
  861339848 => "Deyang\,\ Sichuan",
  861339849 => "Mianyang\,\ Sichuan",
  861339850 => "Guiyang\,\ Guizhou",
  861339851 => "Guiyang\,\ Guizhou",
  861339852 => "Zunyi\,\ Guizhou",
  861339853 => "Anshun\,\ Guizhou",
  861339854 => "Qiannan\,\ Guizhou",
  861339855 => "Qiandongnan\,\ Guizhou",
  861339856 => "Tongren\,\ Guizhou",
  861339857 => "Bijie\,\ Guizhou",
  861339858 => "Liupanshui\,\ Guizhou",
  861339859 => "Qianxinan\,\ Guizhou",
  861339860 => "Baoding\,\ Hebei",
  861339861 => "Shijiazhuang\,\ Hebei",
  861339862 => "Baoding\,\ Hebei",
  861339863 => "Baoding\,\ Hebei",
  861339864 => "Baoding\,\ Hebei",
  861339865 => "Qinhuangdao\,\ Hebei",
  861339866 => "Chengde\,\ Hebei",
  861339867 => "Chengde\,\ Hebei",
  861339868 => "Chengde\,\ Hebei",
  861339869 => "Chengde\,\ Hebei",
  861339870 => "Zhaotong\,\ Yunnan",
  861339871 => "Kunming\,\ Yunnan",
  861339872 => "Dali\,\ Yunnan",
  861339873 => "Honghe\,\ Yunnan",
  861339874 => "Qujing\,\ Yunnan",
  861339875 => "Baoshan\,\ Yunnan",
  861339876 => "Wenshan\,\ Yunnan",
  861339877 => "Yuxi\,\ Yunnan",
  861339878 => "Chuxiong\,\ Yunnan",
  861339879 => "Puer\,\ Yunnan",
  861339880 => "Kunming\,\ Yunnan",
  861339881 => "Xishuangbanna\,\ Yunnan",
  861339882 => "Dehong\,\ Yunnan",
  861339883 => "Lincang\,\ Yunnan",
  861339884 => "Kunming\,\ Yunnan",
  861339885 => "Kunming\,\ Yunnan",
  861339886 => "Nujiang\,\ Yunnan",
  861339887 => "Deqen\,\ Yunnan",
  861339888 => "Lijiang\,\ Yunnan",
  861339889 => "Yuxi\,\ Yunnan",
  86133989 => "Haikou\,\ Hainan",
  861339900 => "Karamay\,\ Xinjiang",
  861339901 => "Tacheng\,\ Xinjiang",
  861339902 => "Hami\,\ Xinjiang",
  861339903 => "Hotan\,\ Xinjiang",
  861339904 => "Bayingolin\,\ Xinjiang",
  861339905 => "Aksu\,\ Xinjiang",
  861339906 => "Altay\,\ Xinjiang",
  861339907 => "Bortala\,\ Xinjiang",
  861339908 => "Changji\,\ Xinjiang",
  861339909 => "Bortala\,\ Xinjiang",
  861339910 => "Xianyang\,\ Shaanxi",
  861339911 => "YanAn\,\ Shaanxi",
  861339912 => "Yulin\,\ Shaanxi",
  861339913 => "Weinan\,\ Shaanxi",
  861339914 => "Shangluo\,\ Shaanxi",
  861339915 => "Ankang\,\ Shaanxi",
  861339916 => "Hanzhong\,\ Shaanxi",
  861339917 => "Baoji\,\ Shaanxi",
  861339918 => "XiAn\,\ Shaanxi",
  861339919 => "Tongchuan\,\ Shaanxi",
  861339920 => "Xianyang\,\ Shaanxi",
  861339921 => "YanAn\,\ Shaanxi",
  861339922 => "Yulin\,\ Shaanxi",
  861339923 => "Weinan\,\ Shaanxi",
  861339924 => "Shangluo\,\ Shaanxi",
  861339925 => "Ankang\,\ Shaanxi",
  861339926 => "Hanzhong\,\ Shaanxi",
  861339927 => "Baoji\,\ Shaanxi",
  861339928 => "XiAn\,\ Shaanxi",
  861339929 => "Tongchuan\,\ Shaanxi",
  861339930 => "Linxia\,\ Gansu",
  861339931 => "Lanzhou\,\ Gansu",
  861339932 => "Dingxi\,\ Gansu",
  861339933 => "Pingliang\,\ Gansu",
  861339934 => "Qingyang\,\ Gansu",
  861339935 => "Wuwei\,\ Gansu",
  861339936 => "Zhangye\,\ Gansu",
  861339937 => "Jiuquan\,\ Gansu",
  861339938 => "Tianshui\,\ Gansu",
  861339939 => "Longnan\,\ Gansu",
  861339940 => "Jiuquan\,\ Gansu",
  861339941 => "Gannan\,\ Gansu",
  861339942 => "Jiayuguan\,\ Gansu",
  861339943 => "Baiyin\,\ Gansu",
  861339944 => "Zhangye\,\ Gansu",
  861339945 => "Jinchang\,\ Gansu",
  861339946 => "Lanzhou\,\ Gansu",
  861339947 => "Jiayuguan\,\ Gansu",
  861339948 => "Jinchang\,\ Gansu",
  861339949 => "Baiyin\,\ Gansu",
  861339950 => "Chuzhou\,\ Anhui",
  861339951 => "Hefei\,\ Anhui",
  861339952 => "Bengbu\,\ Anhui",
  861339953 => "Wuhu\,\ Anhui",
  861339954 => "Huainan\,\ Anhui",
  861339955 => "MaAnshan\,\ Anhui",
  861339956 => "Anqing\,\ Anhui",
  861339957 => "Suzhou\,\ Anhui",
  861339958 => "Fuyang\,\ Anhui",
  861339959 => "Huangshan\,\ Anhui",
  861339960 => "Chuzhou\,\ Anhui",
  861339961 => "Huaibei\,\ Anhui",
  861339962 => "Tongling\,\ Anhui",
  861339963 => "Xuancheng\,\ Anhui",
  861339964 => "LuAn\,\ Anhui",
  861339965 => "Chaohu\,\ Anhui",
  861339966 => "Chizhou\,\ Anhui",
  861339967 => "Bozhou\,\ Anhui",
  861339968 => "Fuyang\,\ Anhui",
  861339969 => "Hefei\,\ Anhui",
  861339970 => "Changji\,\ Xinjiang",
  861339971 => "Hami\,\ Xinjiang",
  861339972 => "Bortala\,\ Xinjiang",
  861339973 => "Tacheng\,\ Xinjiang",
  861339974 => "Altay\,\ Xinjiang",
  861339975 => "Bayingolin\,\ Xinjiang",
  861339976 => "Bayingolin\,\ Xinjiang",
  861339977 => "Kashi\,\ Xinjiang",
  861339978 => "Kashi\,\ Xinjiang",
  861339979 => "Hotan\,\ Xinjiang",
  86133998 => "Chongqing",
  861339990 => "Karamay\,\ Xinjiang",
  861339991 => "Urumchi\,\ Xinjiang",
  861339992 => "Ili\,\ Xinjiang",
  861339993 => "Shihezi\,\ Xinjiang",
  861339994 => "Changji\,\ Xinjiang",
  861339995 => "Turpan\,\ Xinjiang",
  861339996 => "Bayingolin\,\ Xinjiang",
  861339997 => "Aksu\,\ Xinjiang",
  861339998 => "Kashi\,\ Xinjiang",
  861339999 => "Ili\,\ Xinjiang",
  861340000 => "Wuxi\,\ Jiangsu",
  861340001 => "Wuxi\,\ Jiangsu",
  861340002 => "Wuxi\,\ Jiangsu",
  861340003 => "Wuxi\,\ Jiangsu",
  861340004 => "Wuxi\,\ Jiangsu",
  861340005 => "Nanjing\,\ Jiangsu",
  861340006 => "Nanjing\,\ Jiangsu",
  861340007 => "Nanjing\,\ Jiangsu",
  861340008 => "Zhenjiang\,\ Jiangsu",
  861340009 => "Zhenjiang\,\ Jiangsu",
  861340010 => "Handan\,\ Hebei",
  861340011 => "Shijiazhuang\,\ Hebei",
  861340012 => "Baoding\,\ Hebei",
  861340013 => "Zhangjiakou\,\ Hebei",
  861340014 => "Xingtai\,\ Hebei",
  861340015 => "Xingtai\,\ Hebei",
  861340016 => "Baoding\,\ Hebei",
  861340017 => "Cangzhou\,\ Hebei",
  861340018 => "Xingtai\,\ Hebei",
  861340019 => "Xingtai\,\ Hebei",
  861340020 => "Handan\,\ Hebei",
  861340021 => "Shijiazhuang\,\ Hebei",
  861340022 => "Baoding\,\ Hebei",
  861340023 => "Baoding\,\ Hebei",
  861340024 => "Baoding\,\ Hebei",
  861340025 => "Baoding\,\ Hebei",
  861340026 => "Baoding\,\ Hebei",
  861340027 => "Baoding\,\ Hebei",
  861340028 => "Baoding\,\ Hebei",
  861340029 => "Baoding\,\ Hebei",
  861340030 => "Handan\,\ Hebei",
  861340031 => "Shijiazhuang\,\ Hebei",
  861340032 => "Baoding\,\ Hebei",
  861340033 => "Baoding\,\ Hebei",
  861340034 => "Baoding\,\ Hebei",
  861340035 => "Baoding\,\ Hebei",
  861340036 => "Baoding\,\ Hebei",
  861340037 => "Baoding\,\ Hebei",
  861340038 => "Baoding\,\ Hebei",
  861340039 => "Baoding\,\ Hebei",
  861340040 => "Handan\,\ Hebei",
  861340041 => "Shijiazhuang\,\ Hebei",
  861340042 => "Baoding\,\ Hebei",
  861340043 => "Baoding\,\ Hebei",
  861340044 => "Baoding\,\ Hebei",
  861340045 => "Tangshan\,\ Hebei",
  861340046 => "Zhangjiakou\,\ Hebei",
  861340047 => "Cangzhou\,\ Hebei",
  861340048 => "Hengshui\,\ Hebei",
  861340049 => "Baoding\,\ Hebei",
  86134005 => "Fuzhou\,\ Fujian",
  86134006 => "Xiamen\,\ Fujian",
  86134007 => "Xiamen\,\ Fujian",
  86134008 => "Quanzhou\,\ Fujian",
  86134009 => "Zhangzhou\,\ Fujian",
  86134010 => "Beijing",
  86134011 => "Beijing",
  861340120 => "Taizhou\,\ Jiangsu",
  861340121 => "Taizhou\,\ Jiangsu",
  861340122 => "Taizhou\,\ Jiangsu",
  861340123 => "Taizhou\,\ Jiangsu",
  861340124 => "Taizhou\,\ Jiangsu",
  861340125 => "Yancheng\,\ Jiangsu",
  861340126 => "Lianyungang\,\ Jiangsu",
  861340127 => "Xuzhou\,\ Jiangsu",
  861340128 => "Nantong\,\ Jiangsu",
  861340129 => "Yangzhou\,\ Jiangsu",
  86134013 => "Changzhou\,\ Jiangsu",
  861340140 => "Suzhou\,\ Jiangsu",
  861340141 => "Suzhou\,\ Jiangsu",
  861340142 => "Suzhou\,\ Jiangsu",
  861340143 => "Suzhou\,\ Jiangsu",
  861340144 => "Suzhou\,\ Jiangsu",
  861340145 => "Suzhou\,\ Jiangsu",
  861340146 => "Suzhou\,\ Jiangsu",
  861340147 => "Suzhou\,\ Jiangsu",
  861340148 => "Changzhou\,\ Jiangsu",
  861340149 => "Changzhou\,\ Jiangsu",
  86134015 => "Changzhou\,\ Jiangsu",
  86134016 => "Changzhou\,\ Jiangsu",
  86134017 => "Yancheng\,\ Jiangsu",
  861340180 => "HuaiAn\,\ Jiangsu",
  861340181 => "HuaiAn\,\ Jiangsu",
  861340182 => "HuaiAn\,\ Jiangsu",
  861340183 => "HuaiAn\,\ Jiangsu",
  861340184 => "HuaiAn\,\ Jiangsu",
  861340185 => "HuaiAn\,\ Jiangsu",
  861340186 => "Suqian\,\ Jiangsu",
  861340187 => "Suqian\,\ Jiangsu",
  861340188 => "Suqian\,\ Jiangsu",
  861340189 => "Suqian\,\ Jiangsu",
  86134019 => "Nanjing\,\ Jiangsu",
  86134020 => "Shanghai",
  86134021 => "Shanghai",
  861340220 => "Jinan\,\ Shandong",
  861340221 => "Jinan\,\ Shandong",
  861340222 => "Jinan\,\ Shandong",
  861340223 => "Heze\,\ Shandong",
  861340224 => "Heze\,\ Shandong",
  861340225 => "Heze\,\ Shandong",
  861340226 => "Weifang\,\ Shandong",
  861340227 => "Jining\,\ Shandong",
  861340228 => "Jining\,\ Shandong",
  861340229 => "Dezhou\,\ Shandong",
  861340230 => "Zigong\,\ Sichuan",
  861340231 => "Zigong\,\ Sichuan",
  861340232 => "Zigong\,\ Sichuan",
  861340233 => "Mianyang\,\ Sichuan",
  861340234 => "Mianyang\,\ Sichuan",
  861340235 => "Mianyang\,\ Sichuan",
  861340236 => "Mianyang\,\ Sichuan",
  861340237 => "Mianyang\,\ Sichuan",
  861340238 => "Mianyang\,\ Sichuan",
  861340239 => "Mianyang\,\ Sichuan",
  861340240 => "Tangshan\,\ Hebei",
  861340241 => "Tangshan\,\ Hebei",
  861340242 => "Tangshan\,\ Hebei",
  861340243 => "Tangshan\,\ Hebei",
  861340244 => "Tangshan\,\ Hebei",
  861340245 => "Tangshan\,\ Hebei",
  861340246 => "Tangshan\,\ Hebei",
  861340247 => "Tangshan\,\ Hebei",
  861340248 => "Shijiazhuang\,\ Hebei",
  861340249 => "Shijiazhuang\,\ Hebei",
  86134025 => "Suzhou\,\ Jiangsu",
  86134026 => "Suzhou\,\ Jiangsu",
  86134027 => "Enshi\,\ Hubei",
  86134028 => "Chengdu\,\ Sichuan",
  861340290 => "YanAn\,\ Shaanxi",
  861340291 => "Weinan\,\ Shaanxi",
  861340292 => "Yulin\,\ Shaanxi",
  861340293 => "Xianyang\,\ Shaanxi",
  861340294 => "XiAn\,\ Shaanxi",
  861340295 => "XiAn\,\ Shaanxi",
  861340296 => "XiAn\,\ Shaanxi",
  861340297 => "XiAn\,\ Shaanxi",
  861340298 => "XiAn\,\ Shaanxi",
  861340299 => "Yulin\,\ Shaanxi",
  86134030 => "Enshi\,\ Hubei",
  861340310 => "Handan\,\ Hebei",
  861340311 => "