/*
 *  @(#)DefaultTestDataFactory.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.autodoc.v1;


import net.sourceforge.groboutils.autodoc.v1.testserver.TestInfo;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestData;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestDataFactory;


/**
 * A factory in charge of creating a specific <tt>TestData</tt> instance from
 * a <tt>TestInfo</tt> unique identifier.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 17, 2002
 * @version    $Date: 2003/02/10 22:51:56 $
 */
public class DefaultTestDataFactory implements TestDataFactory
{
    /**
     * Create the <tt>TestData</tt> for the specific <tt>info</tt> instance.
     * This should never return <tt>null</tt>.
     *
     * @param info the unique identifier for the test under inspection, which
     *      should never be <tt>null</tt>.
     * @return the new data for the given <tt>info</tt>.
     */
    public TestData createTestData( TestInfo info )
    {
        return new ITFTestData( info );
    }
}

