/*
 * @(#)HexUtilUTest.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.util;

import java.util.zip.CRC32;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;


/**
 * Tests the ChecksumUtil class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/07/07 09:39:14 $
 * @since     July 7, 2004
 */
public class HexUtilUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = HexUtilUTest.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public HexUtilUTest( String name )
    {
        super( name );
    }



    //-------------------------------------------------------------------------
    // Tests
    
    public void testGetInstance()
    {
        assertNotNull(
            "getInstance must never return null.",
            HexUtil.getInstance() );
    }
    
    
    public void testParseTwoHex1()
    {
        assertFalse(
            "Null TS",
            HexUtil.getInstance().parseTwoHex( "a a", null, ' ', 0 ) );
    }
    
    
    public void testParseTwoHex2()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertFalse(
            "Null string",
            HexUtil.getInstance().parseTwoHex( null, ts, ' ', 0 ));
    }
    
    
    public void testParseTwoHex3()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertFalse(
            "Negative start",
            HexUtil.getInstance().parseTwoHex( "a a", ts, ' ', -1 ) );
    }
    
    
    public void testParseTwoHex4()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertFalse(
            "No separator",
            HexUtil.getInstance().parseTwoHex( "a", ts, ' ', 0 ) );
    }
    
    
    public void testParseTwoHex5()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertFalse(
            "No separator after start",
            HexUtil.getInstance().parseTwoHex( "a a", ts, ' ', 2 ) );
    }
    
    
    public void testParseTwoHex6()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertFalse(
            "Start is after string length",
            HexUtil.getInstance().parseTwoHex( "x x", ts, ' ', 12 ) );
    }
    
    
    public void testParseTwoHex7()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertTrue(
            "Should have parsed correctly",
            HexUtil.getInstance().parseTwoHex( "0AAA F", ts, ' ', 0 ) );
        assertEquals(
            "Bad first string translate",
            0x0AAA,
            ts.a );
        assertEquals(
            "Bad second string translate",
            0xF,
            ts.b );
    }
    
    
    public void testParseTwoHex8()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertTrue(
            "Should have parsed correctly",
            HexUtil.getInstance().parseTwoHex( " 0BB 12", ts, ' ', 1 ) );
        assertEquals(
            "Bad first string translate",
            0x0BB,
            ts.a );
        assertEquals(
            "Bad second string translate",
            0x12,
            ts.b );
    }
    
    
    public void testParseTwoHex9()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        assertTrue(
            "Should have parsed correctly",
            HexUtil.getInstance().parseTwoHex( "1 2    ", ts, ' ', 0 ) );
        assertEquals(
            "Bad first string translate",
            0x1,
            ts.a );
        assertEquals(
            "Bad second string translate",
            0x2,
            ts.b );
    }
    
    
    public void testParseTwoHex10()
    {
        HexUtil.TwoShorts ts = new HexUtil.TwoShorts();
        ts.a = ts.b = -1;
        assertTrue(
            "Should have parsed correctly",
            HexUtil.getInstance().parseTwoHex( "0 0", ts, ' ', 0 ) );
        assertEquals(
            "Bad first string translate",
            0x0,
            ts.a );
        assertEquals(
            "Bad second string translate",
            0x0,
            ts.b );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

