/*
 * @(#)SingleSourceLogger.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.logger;

import net.sourceforge.groboutils.codecoverage.v2.IChannelLogger;


/**
 * Outputs the marks to the owning source.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/05/14 21:12:12 $
 * @since     April 16, 2004
 */
public class SingleSourceLogger implements IChannelLogger
{
    private short channel;
    private ISingleSource ss;
    
    
    public SingleSourceLogger( short channelIndex, ISingleSource ss )
    {
        this.channel = channelIndex;
        this.ss = ss;
    }
    
    
    /**
     * Records a coverage of a marked bytecode instruction.  This method should
     * never throw an exception.
     *
     * @param classSignature a signature of the class file being covered.
     *        this signature includes the fully-qualified name of the class,
     *        along with a checksum to uniquely identify it.
     * @param methodIndex index for a method within the class.  The meta-data
     *        store will know how to translate the index to a method signature.
     * @param markIndex the index of the bytecode instruction mark for this
     *        particular channel.
     */
    public void cover( String classSignature, short methodIndex,
            short markIndex )
    {
        if (this.ss != null)
        {
            this.ss.cover( this.channel, classSignature, methodIndex,
                markIndex );
        }
    }
}

