#if   !defined(__ENGINEBRIDGE_HPP)
#define __ENGINEBRIDGE_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#include <Common.hpp>

#if   !defined(__BRIDGE_HPP)
#include <Bridge.hpp>
#endif

//
// We are including this here because Cylinders is a defined type for
// engine. Otherwise we would have forward declared Engine class.
//

#if   !defined(__ENGINE_HPP)
#include <Engine.hpp>
#endif

/**
EngineBridge dynamically manages the underlying implementation of
an Engine.

EngineBridge can report the cylinder size and also will allow you
to upgrade to a bigger engine. Attempts to upgrade to a smaller
engine violate a EngineBridge semantic.
*/
      
DECLARE_CLASS(EngineBridge);

class EngineBridge : public CORELINUX(Bridge<EnginePtr>)
{

public:

                        /// Constructor with Engine Type

                        EngineBridge( EnginePtr ) 
                           throw(CORELINUX(Exception));

                        /// Destructor

   virtual              ~EngineBridge( void );

   //
   // Operator overloads
   //

            /// Assignment operator
         
            EngineBridgeRef   operator=( EngineBridgeCref ) 
                                 throw(CORELINUX(Exception));
         
            /// Equality operator
         
            bool     operator==( EngineBridgeCref ) const;

   //
   // Accessors
   //

            /// Return the Cylinders count

            CylindersCref  getCylinders( void ) const;

   //
   // Mutators
   //
            /// Upgrade the engine, throw exception if too small

            void        upgradeEngine( EnginePtr aPtr ) 
                           throw(CORELINUX(Exception));
   

protected:

                        /// Default constructor - Not Allowed as per Bridge
                  
                        EngineBridge( void ) 
                           throw(CORELINUX(Assertion));

                        /// Copy constructor - Not Allowed as per Bridge

                        EngineBridge( EngineBridgeCref ) 
                           throw(CORELINUX(Assertion));


            /**
            This is where the base Bridge calls down to in making a copy
            of the implementation for ownership by the bridge.
            @param  CoreLinuxObject pointer to original
            @return CoreLinuxObject pointer to clone
            */

   virtual  EnginePtr   cloneImplementation( EnginePtr aPtr ) 
                           throw(CORELINUX(Exception));
};

#endif // if !defined __ENGINEBRIDGE_HPP

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.5 $
   $Date: 2000/02/11 03:22:19 $
   $Locker:  $
*/


