/*=============================================================================
** Lynkeos
** $Id: corelation.h,v 1.7 2005/01/27 23:13:53 j-etienne Exp $
**-----------------------------------------------------------------------------
**
**  Created by Jean-Etienne LAMIAUD on Aug 5, 2003
**  Copyright (c) 2003-2005. Jean-Etienne LAMIAUD
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
**
**-----------------------------------------------------------------------------
*/
#ifndef __CORELATION_H
#define __CORELATION_H

#include "fourier.h"

typedef struct
{
   double x;
   double y;
   double val;
   double sigma_x;
   double sigma_y;
} CORRELATION_PEAK;

typedef struct
{
   CORRELATION_PEAK red, green, blue;
} CORRELATION_PEAK_RGB;

extern void correlate( FFT_DATA s1, FFT_DATA s2, FFT_DATA r );
extern void correlate_spectrums( FFT_DATA s1, FFT_DATA s2, FFT_DATA r );
extern void corelation_peak( FFT_DATA result, CORRELATION_PEAK *peak );

#endif
