package tests::ReportParserAsciiWriterTest;

use base qw/Lire::Test::TestCase tests::TestStoreFixture/;

use Lire::ReportParser::AsciiWriter;
use Lire::Utils qw/tempfile/;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->init();

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    unlink $self->{'unlink'}
      if $self->{'unlink'};

    return;
}

sub test_new {
    my $self = $_[0];

    my $parser = new Lire::ReportParser::AsciiWriter();
    $self->assert_isa( 'Lire::ReportParser::AsciiWriter', $parser );
    $self->assert_num_equals( 74, $parser->{'columns'} );
    $self->assert_num_equals( 180, $parser->{'max_name_len'} );
    $self->assert_str_equals( \*STDOUT, $parser->{'_fh'} );
    $self->assert_str_equals( '', $parser->{'_encoding'} );

    my $fh = tempfile();
    $parser = new Lire::ReportParser::AsciiWriter( 'output' => $fh,
                                                   'encoding' => 'UTF-8',
                                                   'columns' => 70,
                                                   'max_name_length' => 100,
                                                 );
    $self->assert_isa( 'Lire::ReportParser::AsciiWriter', $parser );
    $self->assert_num_equals( 70, $parser->{'columns'} );
    $self->assert_num_equals( 100, $parser->{'max_name_len'} );
    $self->assert_str_equals( $fh, $parser->{'_fh'} );
    $self->assert_str_equals( 'UTF-8', $parser->{'_encoding'} );
}

sub test_parsefile {
    my $self = $_[0];

    my ( $fh, $file ) = tempfile( 'report_XXXXXX', 'SUFFIX' => '.txt' );
    $self->{'unlink'} = $file;

    my $parser = new Lire::ReportParser::AsciiWriter( 'output' => $fh,
                                                      'encoding' => 'UTF-16LE'
                                                    );
    $parser->parsefile( "$self->{'testdir'}/data/test-utf8.xml" );
    close $fh;

    open my $exp_fh, "$self->{'testdir'}/data/test-utf-16le.txt"
      or die "open failed: $!";
    open my $gen_fh, $file
      or die "open failed: $!";

    local $/ = undef;
    my $expected = <$exp_fh>;
    my $generated = <$gen_fh>;
    $expected =~ s/\0/./g;
    $generated =~ s/\0/./g;
    $self->assert_str_equals( $expected, $generated );
}

1;
