/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcas_db_read.h
    \brief  Internal header file of LCAS database reader
    \author Martijn Steenbakkers for the EU DataGrid.

    This header contains the declarations of the LCAS database reader
    functions and typedefs.

    \internal
*/

#ifndef _LCAS_DB_READ_H
#define _LCAS_DB_READ_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include "_lcas_defines.h"

/******************************************************************************
                               Type definitions
******************************************************************************/
/*!
    \struct  lcas_db_entry_s
    \brief   LCAS data base element structure
    \internal
*/
/*!
    \typedef lcas_db_entry_t
    \brief   type of LCAS data base element
    \internal
*/
typedef struct lcas_db_entry_s
{
    char                      pluginname[LCAS_MAXPATHLEN+1]; /*!< Name of authorization plugin/module */
    char                      pluginargs[LCAS_MAXARGSTRING+1]; /*!< Argument list to be passed to authorization plugin/module */
    struct lcas_db_entry_s *  next;  /*!< handle to next db element */
}
lcas_db_entry_t;

/******************************************************************************
 *                             Module definition
 *****************************************************************************/
/*!
    \fn lcas_db_fill_entry(
        lcas_db_entry_t ** list,
        lcas_db_entry_t *  entry
        )
    \brief Add a database entry to a list.
    \param list database list (array of database entry pointers)
    \param entry the database entry to be added
    \return a pointer to the newly created database entry in the list or NULL (error)
    \internal
*/
extern lcas_db_entry_t * lcas_db_fill_entry(
        lcas_db_entry_t ** plcas_db,
        lcas_db_entry_t *  db_entry
);

/*!
    \fn lcas_db_read(
        char * lcas_db_fname
        )
    \brief Read database from file.
    \param lcas_db_fname database file.
    \return a pointer to the database list
    \internal
*/
extern lcas_db_entry_t ** lcas_db_read(
        char * lcas_db_fname
);

/*!
    \fn lcas_db_clean_list(
        lcas_db_entry_t ** list
        )
    \brief Clean/remove the database list
    \param list pointer to the database list
    \retval 0 succes.
    \retval 1 failure.
    \internal
*/
extern int lcas_db_clean_list(
        lcas_db_entry_t ** list
);

/*!
    \fn lcas_db_clean()
    \brief Clean/remove the database structure.
    \retval 0 succes
    \retval 1 failure
    \internal
*/
extern int lcas_db_clean(void);

#endif /* _LCAS_DB_READ_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcas/src/_lcas_db_read.h,v $
    $Date: 2010-05-03 10:42:49 $
    $Revision: 2.9 $
    $Author: okoeroo $
******************************************************************************/
