/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "profilecmdexecafterconnectoptions.h"

#include <QtGui/QCheckBox>
#include <QtGui/QLabel>

#include <knuminput.h>
#include <ktextedit.h>

#include "widgetnotifyhelper.h"

ProfileCmdExecAfterConnectOptions::ProfileCmdExecAfterConnectOptions(QWidget *parent) : QWidget(parent)
{
    main = new Ui_ProfileCmdExecAfterConnectOptionsBase();
    main->setupUi(this);
    connect(main->ExcuteCmdAfterConnectCheckBox, SIGNAL(stateChanged(int)), this, SLOT(execCmdAfterConnectToggled(int)));
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
}


ProfileCmdExecAfterConnectOptions::~ProfileCmdExecAfterConnectOptions()
{}

void ProfileCmdExecAfterConnectOptions::execCmdAfterConnectToggled(int)
{
    if (main->ExcuteCmdAfterConnectCheckBox->isChecked()) {
        main->CmdAfterConnectTextEdit->setEnabled(true);
        main->CommandAfterConnectDelayTimeNumInput->setEnabled(true);
        main->CommandAfterConnectDelayTimeNumInputLabel->setEnabled(true);
    } else {
        main->CmdAfterConnectTextEdit->setEnabled(false);
        main->CommandAfterConnectDelayTimeNumInput->setEnabled(false);
        main->CommandAfterConnectDelayTimeNumInputLabel->setEnabled(false);
    }
}

void ProfileCmdExecAfterConnectOptions::dialogChanged()
{
    dialogModified = true;
}


