/*
 * cast_sbox.h: CAST5 sbox arrays.
 *
 * from RFC 2144
 *
 * public domain.
 *
 * $eterna: cast_sbox.h,v 1.9 2003/12/08 01:59:48 mrg Exp $
 */

/* sigh */
#if __STDC__ /* || (__STDC__ == 0 && defined(__sun)) */
#define U(x) x##U
#define UL(x) x##UL
#else
#define U(x) x
#define UL(x) x/**/L
#endif

/*
 * the bulk of the text for these comes from appendix A. of
 # RFC 2144 "The CAST-128 Encryption Algorithm"
 */
static const u_32int cast_S1[] = {
	U(0x30fb40d4), U(0x9fa0ff0b), U(0x6beccd2f), U(0x3f258c7a),
	U(0x1e213f2f), U(0x9c004dd3), U(0x6003e540), U(0xcf9fc949),
	U(0xbfd4af27), U(0x88bbbdb5), U(0xe2034090), U(0x98d09675),
	U(0x6e63a0e0), U(0x15c361d2), U(0xc2e7661d), U(0x22d4ff8e),
	U(0x28683b6f), U(0xc07fd059), U(0xff2379c8), U(0x775f50e2),
	U(0x43c340d3), U(0xdf2f8656), U(0x887ca41a), U(0xa2d2bd2d),
	U(0xa1c9e0d6), U(0x346c4819), U(0x61b76d87), U(0x22540f2f),
	U(0x2abe32e1), U(0xaa54166b), U(0x22568e3a), U(0xa2d341d0),
	U(0x66db40c8), U(0xa784392f), U(0x004dff2f), U(0x2db9d2de),
	U(0x97943fac), U(0x4a97c1d8), U(0x527644b7), U(0xb5f437a7),
	U(0xb82cbaef), U(0xd751d159), U(0x6ff7f0ed), U(0x5a097a1f),
	U(0x827b68d0), U(0x90ecf52e), U(0x22b0c054), U(0xbc8e5935),
	U(0x4b6d2f7f), U(0x50bb64a2), U(0xd2664910), U(0xbee5812d),
	U(0xb7332290), U(0xe93b159f), U(0xb48ee411), U(0x4bff345d),
	U(0xfd45c240), U(0xad31973f), U(0xc4f6d02e), U(0x55fc8165),
	U(0xd5b1caad), U(0xa1ac2dae), U(0xa2d4b76d), U(0xc19b0c50),
	U(0x882240f2), U(0x0c6e4f38), U(0xa4e4bfd7), U(0x4f5ba272),
	U(0x564c1d2f), U(0xc59c5319), U(0xb949e354), U(0xb04669fe),
	U(0xb1b6ab8a), U(0xc71358dd), U(0x6385c545), U(0x110f935d),
	U(0x57538ad5), U(0x6a390493), U(0xe63d37e0), U(0x2a54f6b3),
	U(0x3a787d5f), U(0x6276a0b5), U(0x19a6fcdf), U(0x7a42206a),
	U(0x29f9d4d5), U(0xf61b1891), U(0xbb72275e), U(0xaa508167),
	U(0x38901091), U(0xc6b505eb), U(0x84c7cb8c), U(0x2ad75a0f),
	U(0x874a1427), U(0xa2d1936b), U(0x2ad286af), U(0xaa56d291),
	U(0xd7894360), U(0x425c750d), U(0x93b39e26), U(0x187184c9),
	U(0x6c00b32d), U(0x73e2bb14), U(0xa0bebc3c), U(0x54623779),
	U(0x64459eab), U(0x3f328b82), U(0x7718cf82), U(0x59a2cea6),
	U(0x04ee002e), U(0x89fe78e6), U(0x3fab0950), U(0x325ff6c2),
	U(0x81383f05), U(0x6963c5c8), U(0x76cb5ad6), U(0xd49974c9),
	U(0xca180dcf), U(0x380782d5), U(0xc7fa5cf6), U(0x8ac31511),
	U(0x35e79e13), U(0x47da91d0), U(0xf40f9086), U(0xa7e2419e),
	U(0x31366241), U(0x051ef495), U(0xaa573b04), U(0x4a805d8d),
	U(0x548300d0), U(0x00322a3c), U(0xbf64cddf), U(0xba57a68e),
	U(0x75c6372b), U(0x50afd341), U(0xa7c13275), U(0x915a0bf5),
	U(0x6b54bfab), U(0x2b0b1426), U(0xab4cc9d7), U(0x449ccd82),
	U(0xf7fbf265), U(0xab85c5f3), U(0x1b55db94), U(0xaad4e324),
	U(0xcfa4bd3f), U(0x2deaa3e2), U(0x9e204d02), U(0xc8bd25ac),
	U(0xeadf55b3), U(0xd5bd9e98), U(0xe31231b2), U(0x2ad5ad6c),
	U(0x954329de), U(0xadbe4528), U(0xd8710f69), U(0xaa51c90f),
	U(0xaa786bf6), U(0x22513f1e), U(0xaa51a79b), U(0x2ad344cc),
	U(0x7b5a41f0), U(0xd37cfbad), U(0x1b069505), U(0x41ece491),
	U(0xb4c332e6), U(0x032268d4), U(0xc9600acc), U(0xce387e6d),
	U(0xbf6bb16c), U(0x6a70fb78), U(0x0d03d9c9), U(0xd4df39de),
	U(0xe01063da), U(0x4736f464), U(0x5ad328d8), U(0xb347cc96),
	U(0x75bb0fc3), U(0x98511bfb), U(0x4ffbcc35), U(0xb58bcf6a),
	U(0xe11f0abc), U(0xbfc5fe4a), U(0xa70aec10), U(0xac39570a),
	U(0x3f04442f), U(0x6188b153), U(0xe0397a2e), U(0x5727cb79),
	U(0x9ceb418f), U(0x1cacd68d), U(0x2ad37c96), U(0x0175cb9d),
	U(0xc69dff09), U(0xc75b65f0), U(0xd9db40d8), U(0xec0e7779),
	U(0x4744ead4), U(0xb11c3274), U(0xdd24cb9e), U(0x7e1c54bd),
	U(0xf01144f9), U(0xd2240eb1), U(0x9675b3fd), U(0xa3ac3755),
	U(0xd47c27af), U(0x51c85f4d), U(0x56907596), U(0xa5bb15e6),
	U(0x580304f0), U(0xca042cf1), U(0x011a37ea), U(0x8dbfaadb),
	U(0x35ba3e4a), U(0x3526ffa0), U(0xc37b4d09), U(0xbc306ed9),
	U(0x98a52666), U(0x5648f725), U(0xff5e569d), U(0x0ced63d0),
	U(0x7c63b2cf), U(0x700b45e1), U(0xd5ea50f1), U(0x85a92872),
	U(0xaf1fbda7), U(0xd4234870), U(0xa7870bf3), U(0x2d3b4d79),
	U(0x42e04198), U(0x0cd0ede7), U(0x26470db8), U(0xf881814c),
	U(0x474d6ad7), U(0x7c0c5e5c), U(0xd1231959), U(0x381b7298),
	U(0xf5d2f4db), U(0xab838653), U(0x6e2f1e23), U(0x83719c9e),
	U(0xbd91e046), U(0x9a56456e), U(0xdc39200c), U(0x20c8c571),
	U(0x962bda1c), U(0xe1e696ff), U(0xb141ab08), U(0x7cca89b9),
	U(0x1a69e783), U(0x02cc4843), U(0xa2f7c579), U(0x429ef47d),
	U(0x427b169c), U(0x5ac9f049), U(0xdd8f0f00), U(0x5c8165bf)
};

static const u_32int cast_S2[] = {
	U(0x1f201094), U(0xef0ba75b), U(0x69e3cf7e), U(0x393f4380),
	U(0xfe61cf7a), U(0xeec5207a), U(0x55889c94), U(0x72fc0651),
	U(0xada7ef79), U(0x4e1d7235), U(0xd55a63ce), U(0xde0436ba),
	U(0x99c430ef), U(0x5f0c0794), U(0x18dcdb7d), U(0xa1d6eff3),
	U(0xa0b52f7b), U(0x59e83605), U(0xee15b094), U(0xe9ffd909),
	U(0xdc440086), U(0xef944459), U(0xba83ccb3), U(0xe0c3cdfb),
	U(0xd1da4181), U(0x3b092ab1), U(0xf997f1c1), U(0xa5e6cf7b),
	U(0x01420ddb), U(0xe4e7ef5b), U(0x25a1ff41), U(0xe180f806),
	U(0x1fc41080), U(0x179bee7a), U(0xd37ac6a9), U(0xfe5830a4),
	U(0x98de8b7f), U(0x77e83f4e), U(0x79929269), U(0x24fa9f7b),
	U(0xe113c85b), U(0xacc40083), U(0xd7503525), U(0xf7ea615f),
	U(0x62143154), U(0x0d554b63), U(0x5d681121), U(0xc866c359),
	U(0x3d63cf73), U(0xcee234c0), U(0xd4d87e87), U(0x5c672b21),
	U(0x071f6181), U(0x39f7627f), U(0x361e3084), U(0xe4eb573b),
	U(0x602f64a4), U(0xd63acd9c), U(0x1bbc4635), U(0x9e81032d),
	U(0x2701f50c), U(0x99847ab4), U(0xa0e3df79), U(0xba6cf38c),
	U(0x10843094), U(0x2537a95e), U(0xf46f6ffe), U(0xa1ff3b1f),
	U(0x208cfb6a), U(0x8f458c74), U(0xd9e0a227), U(0x4ec73a34),
	U(0xfc884f69), U(0x3e4de8df), U(0xef0e0088), U(0x3559648d),
	U(0x8a45388c), U(0x1d804366), U(0x721d9bfd), U(0xa58684bb),
	U(0xe8256333), U(0x844e8212), U(0x128d8098), U(0xfed33fb4),
	U(0xce280ae1), U(0x27e19ba5), U(0xd5a6c252), U(0xe49754bd),
	U(0xc5d655dd), U(0xeb667064), U(0x77840b4d), U(0xa1b6a801),
	U(0x84db26a9), U(0xe0b56714), U(0x21f043b7), U(0xe5d05860),
	U(0x54f03084), U(0x066ff472), U(0xa31aa153), U(0xdadc4755),
	U(0xb5625dbf), U(0x68561be6), U(0x83ca6b94), U(0x2d6ed23b),
	U(0xeccf01db), U(0xa6d3d0ba), U(0xb6803d5c), U(0xaf77a709),
	U(0x33b4a34c), U(0x397bc8d6), U(0x5ee22b95), U(0x5f0e5304),
	U(0x81ed6f61), U(0x20e74364), U(0xb45e1378), U(0xde18639b),
	U(0x881ca122), U(0xb96726d1), U(0x8049a7e8), U(0x22b7da7b),
	U(0x5e552d25), U(0x5272d237), U(0x79d2951c), U(0xc60d894c),
	U(0x488cb402), U(0x1ba4fe5b), U(0xa4b09f6b), U(0x1ca815cf),
	U(0xa20c3005), U(0x8871df63), U(0xb9de2fcb), U(0x0cc6c9e9),
	U(0x0beeff53), U(0xe3214517), U(0xb4542835), U(0x9f63293c),
	U(0xee41e729), U(0x6e1d2d7c), U(0x50045286), U(0x1e6685f3),
	U(0xf33401c6), U(0x30a22c95), U(0x31a70850), U(0x60930f13),
	U(0x73f98417), U(0xa1269859), U(0xec645c44), U(0x52c877a9),
	U(0xcdff33a6), U(0xa02b1741), U(0x7cbad9a2), U(0x2180036f),
	U(0x50d99c08), U(0xcb3f4861), U(0xc26bd765), U(0x64a3f6ab),
	U(0x80342676), U(0x25a75e7b), U(0xe4e6d1fc), U(0x20c710e6),
	U(0xcdf0b680), U(0x17844d3b), U(0x31eef84d), U(0x7e0824e4),
	U(0x2ccb49eb), U(0x846a3bae), U(0x8ff77888), U(0xee5d60f6),
	U(0x7af75673), U(0x2fdd5cdb), U(0xa11631c1), U(0x30f66f43),
	U(0xb3faec54), U(0x157fd7fa), U(0xef8579cc), U(0xd152de58),
	U(0xdb2ffd5e), U(0x8f32ce19), U(0x306af97a), U(0x02f03ef8),
	U(0x99319ad5), U(0xc242fa0f), U(0xa7e3ebb0), U(0xc68e4906),
	U(0xb8da230c), U(0x80823028), U(0xdcdef3c8), U(0xd35fb171),
	U(0x088a1bc8), U(0xbec0c560), U(0x61a3c9e8), U(0xbca8f54d),
	U(0xc72feffa), U(0x22822e99), U(0x82c570b4), U(0xd8d94e89),
	U(0x8b1c34bc), U(0x301e16e6), U(0x273be979), U(0xb0ffeaa6),
	U(0x61d9b8c6), U(0x00b24869), U(0xb7ffce3f), U(0x08dc283b),
	U(0x43daf65a), U(0xf7e19798), U(0x7619b72f), U(0x8f1c9ba4),
	U(0xdc8637a0), U(0x16a7d3b1), U(0x9fc393b7), U(0xa7136eeb),
	U(0xc6bcc63e), U(0x1a513742), U(0xef6828bc), U(0x520365d6),
	U(0x2d6a77ab), U(0x3527ed4b), U(0x821fd216), U(0x095c6e2e),
	U(0xdb92f2fb), U(0x5eea29cb), U(0x145892f5), U(0x91584f7f),
	U(0x5483697b), U(0x2667a8cc), U(0x85196048), U(0x8c4bacea),
	U(0x833860d4), U(0x0d23e0f9), U(0x6c387e8a), U(0x0ae6d249),
	U(0xb284600c), U(0xd835731d), U(0xdcb1c647), U(0xac4c56ea),
	U(0x3ebd81b3), U(0x230eabb0), U(0x6438bc87), U(0xf0b5b1fa),
	U(0x8f5ea2b3), U(0xfc184642), U(0x0a036b7a), U(0x4fb089bd),
	U(0x649da589), U(0xa345415e), U(0x5c038323), U(0x3e5d3bb9),
	U(0x43d79572), U(0x7e6dd07c), U(0x06dfdf1e), U(0x6c6cc4ef),
	U(0x7160a539), U(0x73bfbe70), U(0x83877605), U(0x4523ecf1)
};

static const u_32int cast_S3[] = {
	U(0x8defc240), U(0x25fa5d9f), U(0xeb903dbf), U(0xe810c907),
	U(0x47607fff), U(0x369fe44b), U(0x8c1fc644), U(0xaececa90),
	U(0xbeb1f9bf), U(0xeefbcaea), U(0xe8cf1950), U(0x51df07ae),
	U(0x920e8806), U(0xf0ad0548), U(0xe13c8d83), U(0x927010d5),
	U(0x11107d9f), U(0x07647db9), U(0xb2e3e4d4), U(0x3d4f285e),
	U(0xb9afa820), U(0xfade82e0), U(0xa067268b), U(0x8272792e),
	U(0x553fb2c0), U(0x489ae22b), U(0xd4ef9794), U(0x125e3fbc),
	U(0x21fffcee), U(0x825b1bfd), U(0x9255c5ed), U(0x1257a240),
	U(0x4e1a8302), U(0xbae07fff), U(0x528246e7), U(0x8e57140e),
	U(0x3373f7bf), U(0x8c9f8188), U(0xa6fc4ee8), U(0xc982b5a5),
	U(0xa8c01db7), U(0x579fc264), U(0x67094f31), U(0xf2bd3f5f),
	U(0x40fff7c1), U(0x1fb78dfc), U(0x8e6bd2c1), U(0x437be59b),
	U(0x99b03dbf), U(0xb5dbc64b), U(0x638dc0e6), U(0x55819d99),
	U(0xa197c81c), U(0x4a012d6e), U(0xc5884a28), U(0xccc36f71),
	U(0xb843c213), U(0x6c0743f1), U(0x8309893c), U(0x0feddd5f),
	U(0x2f7fe850), U(0xd7c07f7e), U(0x02507fbf), U(0x5afb9a04),
	U(0xa747d2d0), U(0x1651192e), U(0xaf70bf3e), U(0x58c31380),
	U(0x5f98302e), U(0x727cc3c4), U(0x0a0fb402), U(0x0f7fef82),
	U(0x8c96fdad), U(0x5d2c2aae), U(0x8ee99a49), U(0x50da88b8),
	U(0x8427f4a0), U(0x1eac5790), U(0x796fb449), U(0x8252dc15),
	U(0xefbd7d9b), U(0xa672597d), U(0xada840d8), U(0x45f54504),
	U(0xfa5d7403), U(0xe83ec305), U(0x4f91751a), U(0x925669c2),
	U(0x23efe941), U(0xa903f12e), U(0x60270df2), U(0x0276e4b6),
	U(0x94fd6574), U(0x927985b2), U(0x8276dbcb), U(0x02778176),
	U(0xf8af918d), U(0x4e48f79e), U(0x8f616ddf), U(0xe29d840e),
	U(0x842f7d83), U(0x340ce5c8), U(0x96bbb682), U(0x93b4b148),
	U(0xef303cab), U(0x984faf28), U(0x779faf9b), U(0x92dc560d),
	U(0x224d1e20), U(0x8437aa88), U(0x7d29dc96), U(0x2756d3dc),
	U(0x8b907cee), U(0xb51fd240), U(0xe7c07ce3), U(0xe566b4a1),
	U(0xc3e9615e), U(0x3cf8209d), U(0x6094d1e3), U(0xcd9ca341),
	U(0x5c76460e), U(0x00ea983b), U(0xd4d67881), U(0xfd47572c),
	U(0xf76cedd9), U(0xbda8229c), U(0x127dadaa), U(0x438a074e),
	U(0x1f97c090), U(0x081bdb8a), U(0x93a07ebe), U(0xb938ca15),
	U(0x97b03cff), U(0x3dc2c0f8), U(0x8d1ab2ec), U(0x64380e51),
	U(0x68cc7bfb), U(0xd90f2788), U(0x12490181), U(0x5de5ffd4),
	U(0xdd7ef86a), U(0x76a2e214), U(0xb9a40368), U(0x925d958f),
	U(0x4b39fffa), U(0xba39aee9), U(0xa4ffd30b), U(0xfaf7933b),
	U(0x6d498623), U(0x193cbcfa), U(0x27627545), U(0x825cf47a),
	U(0x61bd8ba0), U(0xd11e42d1), U(0xcead04f4), U(0x127ea392),
	U(0x10428db7), U(0x8272a972), U(0x9270c4a8), U(0x127de50b),
	U(0x285ba1c8), U(0x3c62f44f), U(0x35c0eaa5), U(0xe805d231),
	U(0x428929fb), U(0xb4fcdf82), U(0x4fb66a53), U(0x0e7dc15b),
	U(0x1f081fab), U(0x108618ae), U(0xfcfd086d), U(0xf9ff2889),
	U(0x694bcc11), U(0x236a5cae), U(0x12deca4d), U(0x2c3f8cc5),
	U(0xd2d02dfe), U(0xf8ef5896), U(0xe4cf52da), U(0x95155b67),
	U(0x494a488c), U(0xb9b6a80c), U(0x5c8f82bc), U(0x89d36b45),
	U(0x3a609437), U(0xec00c9a9), U(0x44715253), U(0x0a874b49),
	U(0xd773bc40), U(0x7c34671c), U(0x02717ef6), U(0x4feb5536),
	U(0xa2d02fff), U(0xd2bf60c4), U(0xd43f03c0), U(0x50b4ef6d),
	U(0x07478cd1), U(0x006e1888), U(0xa2e53f55), U(0xb9e6d4bc),
	U(0xa2048016), U(0x97573833), U(0xd7207d67), U(0xde0f8f3d),
	U(0x72f87b33), U(0xabcc4f33), U(0x7688c55d), U(0x7b00a6b0),
	U(0x947b0001), U(0x570075d2), U(0xf9bb88f8), U(0x8942019e),
	U(0x4264a5ff), U(0x856302e0), U(0x72dbd92b), U(0xee971b69),
	U(0x6ea22fde), U(0x5f08ae2b), U(0xaf7a616d), U(0xe5c98767),
	U(0xcf1febd2), U(0x61efc8c2), U(0xf1ac2571), U(0xcc8239c2),
	U(0x67214cb8), U(0xb1e583d1), U(0xb7dc3e62), U(0x7f10bdce),
	U(0xf90a5c38), U(0x0ff0443d), U(0x606e6dc6), U(0x60543a49),
	U(0x5727c148), U(0x2be98a1d), U(0x8ab41738), U(0x20e1be24),
	U(0xaf96da0f), U(0x68458425), U(0x99833be5), U(0x600d457d),
	U(0x282f9350), U(0x8334b362), U(0xd91d1120), U(0x2b6d8da0),
	U(0x642b1e31), U(0x9c305a00), U(0x52bce688), U(0x1b03588a),
	U(0xf7baefd5), U(0x4142ed9c), U(0xa4315c11), U(0x83323ec5),
	U(0xdfef4636), U(0xa133c501), U(0xe9d3531c), U(0xee353783)
};

static const u_32int cast_S4[] = {
	U(0x9db30420), U(0x1fb6e9de), U(0xa7be7bef), U(0xd273a298),
	U(0x4a4f7bdb), U(0x64ad8c57), U(0x85510443), U(0xfa020ed1),
	U(0x7e287aff), U(0xe60fb663), U(0x095f35a1), U(0x79ebf120),
	U(0xfd059d43), U(0x6497b7b1), U(0xf3641f63), U(0x241e4adf),
	U(0x28147f5f), U(0x4fa2b8cd), U(0xc9430040), U(0x0cc32220),
	U(0xfdd30b30), U(0xc0a5374f), U(0x1d2d00d9), U(0x24147b15),
	U(0xee4d111a), U(0x0fca5167), U(0x71ff904c), U(0x2d195ffe),
	U(0x1a05645f), U(0x0c13fefe), U(0x081b08ca), U(0x05170121),
	U(0x80530100), U(0xe83e5efe), U(0xac9af4f8), U(0x7fe72701),
	U(0xd2b8ee5f), U(0x06df4261), U(0xbb9e9b8a), U(0x7293ea25),
	U(0xce84ffdf), U(0xf5718801), U(0x3dd64b04), U(0xa26f263b),
	U(0x7ed48400), U(0x547eebe6), U(0x446d4ca0), U(0x6cf3d6f5),
	U(0x2649abdf), U(0xaea0c7f5), U(0x36338cc1), U(0x503f7e93),
	U(0xd3772061), U(0x11b638e1), U(0x72500e03), U(0xf80eb2bb),
	U(0xabe0502e), U(0xec8d77de), U(0x57971e81), U(0xe14f6746),
	U(0xc9335400), U(0x6920318f), U(0x081dbb99), U(0xffc304a5),
	U(0x4d351805), U(0x7f3d5ce3), U(0xa6c866c6), U(0x5d5bcca9),
	U(0xdaec6fea), U(0x9f926f91), U(0x9f46222f), U(0x3991467d),
	U(0xa5bf6d8e), U(0x1143c44f), U(0x43958302), U(0xd0214eeb),
	U(0x022083b8), U(0x3fb6180c), U(0x18f8931e), U(0x281658e6),
	U(0x26486e3e), U(0x8bd78a70), U(0x7477e4c1), U(0xb506e07c),
	U(0xf32d0a25), U(0x79098b02), U(0xe4eabb81), U(0x28123b23),
	U(0x69dead38), U(0x1574ca16), U(0xdf871b62), U(0x211c40b7),
	U(0xa51a9ef9), U(0x0014377b), U(0x041e8ac8), U(0x09114003),
	U(0xbd59e4d2), U(0xe3d156d5), U(0x4fe876d5), U(0x2f91a340),
	U(0x557be8de), U(0x00eae4a7), U(0x0ce5c2ec), U(0x4db4bba6),
	U(0xe756bdff), U(0xdd3369ac), U(0xec17b035), U(0x06572327),
	U(0x99afc8b0), U(0x56c8c391), U(0x6b65811c), U(0x5e146119),
	U(0x6e85cb75), U(0xbe07c002), U(0xc2325577), U(0x893ff4ec),
	U(0x5bbfc92d), U(0xd0ec3b25), U(0xb7801ab7), U(0x8d6d3b24),
	U(0x20c763ef), U(0xc366a5fc), U(0x9c382880), U(0x0ace3205),
	U(0xaac9548a), U(0xeca1d7c7), U(0x041afa32), U(0x1d16625a),
	U(0x6701902c), U(0x9b757a54), U(0x31d477f7), U(0x9126b031),
	U(0x36cc6fdb), U(0xc70b8b46), U(0xd9e66a48), U(0x56e55a79),
	U(0x026a4ceb), U(0x52437eff), U(0x2f8f76b4), U(0x0df980a5),
	U(0x8674cde3), U(0xedda04eb), U(0x17a9be04), U(0x2c18f4df),
	U(0xb7747f9d), U(0xab2af7b4), U(0xefc34d20), U(0x2e096b7c),
	U(0x1741a254), U(0xe5b6a035), U(0x213d42f6), U(0x2c1c7c26),
	U(0x61c2f50f), U(0x6552daf9), U(0xd2c231f8), U(0x25130f69),
	U(0xd8167fa2), U(0x0418f2c8), U(0x001a96a6), U(0x0d1526ab),
	U(0x63315c21), U(0x5e0a72ec), U(0x49bafefd), U(0x187908d9),
	U(0x8d0dbd86), U(0x311170a7), U(0x3e9b640c), U(0xcc3e10d7),
	U(0xd5cad3b6), U(0x0caec388), U(0xf73001e1), U(0x6c728aff),
	U(0x71eae2a1), U(0x1f9af36e), U(0xcfcbd12f), U(0xc1de8417),
	U(0xac07be6b), U(0xcb44a1d8), U(0x8b9b0f56), U(0x013988c3),
	U(0xb1c52fca), U(0xb4be31cd), U(0xd8782806), U(0x12a3a4e2),
	U(0x6f7de532), U(0x58fd7eb6), U(0xd01ee900), U(0x24adffc2),
	U(0xf4990fc5), U(0x9711aac5), U(0x001d7b95), U(0x82e5e7d2),
	U(0x109873f6), U(0x00613096), U(0xc32d9521), U(0xada121ff),
	U(0x29908415), U(0x7fbb977f), U(0xaf9eb3db), U(0x29c9ed2a),
	U(0x5ce2a465), U(0xa730f32c), U(0xd0aa3fe8), U(0x8a5cc091),
	U(0xd49e2ce7), U(0x0ce454a9), U(0xd60acd86), U(0x015f1919),
	U(0x77079103), U(0xdea03af6), U(0x78a8565e), U(0xdee356df),
	U(0x21f05cbe), U(0x8b75e387), U(0xb3c50651), U(0xb8a5c3ef),
	U(0xd8eeb6d2), U(0xe523be77), U(0xc2154529), U(0x2f69efdf),
	U(0xafe67afb), U(0xf470c4b2), U(0xf3e0eb5b), U(0xd6cc9876),
	U(0x39e4460c), U(0x1fda8538), U(0x1987832f), U(0xca007367),
	U(0xa99144f8), U(0x296b299e), U(0x492fc295), U(0x9266beab),
	U(0xb5676e69), U(0x9bd3ddda), U(0xdf7e052f), U(0xdb25701c),
	U(0x1b5e51ee), U(0xf65324e6), U(0x6afce36c), U(0x0316cc04),
	U(0x8644213e), U(0xb7dc59d0), U(0x7965291f), U(0xccd6fd43),
	U(0x41823979), U(0x932bcdf6), U(0xb657c34d), U(0x4edfd282),
	U(0x7ae5290c), U(0x3cb9536b), U(0x851e20fe), U(0x9833557e),
	U(0x13ecf0b0), U(0xd3ffb372), U(0x3f85c5c1), U(0x0aef7ed2)
};

static const u_32int cast_S5[] = {
	U(0x7ec90c04), U(0x2c6e74b9), U(0x9b0e66df), U(0xa6337911),
	U(0xb86a7fff), U(0x1dd358f5), U(0x44dd9d44), U(0x1731167f),
	U(0x08fbf1fa), U(0xe7f511cc), U(0xd2051b00), U(0x735aba00),
	U(0x2ab722d8), U(0x386381cb), U(0xacf6243a), U(0x69befd7a),
	U(0xe6a2e77f), U(0xf0c720cd), U(0xc4494816), U(0xccf5c180),
	U(0x38851640), U(0x15b0a848), U(0xe68b18cb), U(0x4caadeff),
	U(0x5f480a01), U(0x0412b2aa), U(0x259814fc), U(0x41d0efe2),
	U(0x4e40b48d), U(0x248eb6fb), U(0x8dba1cfe), U(0x41a99b02),
	U(0x1a550a04), U(0xba8f65cb), U(0x7251f4e7), U(0x95a51725),
	U(0xc106ecd7), U(0x97a5980a), U(0xc539b9aa), U(0x4d79fe6a),
	U(0xf2f3f763), U(0x68af8040), U(0xed0c9e56), U(0x11b4958b),
	U(0xe1eb5a88), U(0x8709e6b0), U(0xd7e07156), U(0x4e29fea7),
	U(0x6366e52d), U(0x02d1c000), U(0xc4ac8e05), U(0x9377f571),
	U(0x0c05372a), U(0x578535f2), U(0x2261be02), U(0xd642a0c9),
	U(0xdf13a280), U(0x74b55bd2), U(0x682199c0), U(0xd421e5ec),
	U(0x53fb3ce8), U(0xc8adedb3), U(0x28a87fc9), U(0x3d959981),
	U(0x5c1ff900), U(0xfe38d399), U(0x0c4eff0b), U(0x062407ea),
	U(0xaa2f4fb1), U(0x4fb96976), U(0x90c79505), U(0xb0a8a774),
	U(0xef55a1ff), U(0xe59ca2c2), U(0xa6b62d27), U(0xe66a4263),
	U(0xdf65001f), U(0x0ec50966), U(0xdfdd55bc), U(0x29de0655),
	U(0x911e739a), U(0x17af8975), U(0x32c7911c), U(0x89f89468),
	U(0x0d01e980), U(0x524755f4), U(0x03b63cc9), U(0x0cc844b2),
	U(0xbcf3f0aa), U(0x87ac36e9), U(0xe53a7426), U(0x01b3d82b),
	U(0x1a9e7449), U(0x64ee2d7e), U(0xcddbb1da), U(0x01c94910),
	U(0xb868bf80), U(0x0d26f3fd), U(0x9342ede7), U(0x04a5c284),
	U(0x636737b6), U(0x50f5b616), U(0xf24766e3), U(0x8eca36c1),
	U(0x136e05db), U(0xfef18391), U(0xfb887a37), U(0xd6e7f7d4),
	U(0xc7fb7dc9), U(0x3063fcdf), U(0xb6f589de), U(0xec2941da),
	U(0x26e46695), U(0xb7566419), U(0xf654efc5), U(0xd08d58b7),
	U(0x48925401), U(0xc1bacb7f), U(0xe5ff550f), U(0xb6083049),
	U(0x5bb5d0e8), U(0x87d72e5a), U(0xab6a6ee1), U(0x223a66ce),
	U(0xc62bf3cd), U(0x9e0885f9), U(0x68cb3e47), U(0x086c010f),
	U(0xa21de820), U(0xd18b69de), U(0xf3f65777), U(0xfa02c3f6),
	U(0x407edac3), U(0xcbb3d550), U(0x1793084d), U(0xb0d70eba),
	U(0x0ab378d5), U(0xd951fb0c), U(0xded7da56), U(0x4124bbe4),
	U(0x94ca0b56), U(0x0f5755d1), U(0xe0e1e56e), U(0x6184b5be),
	U(0x580a249f), U(0x94f74bc0), U(0xe327888e), U(0x9f7b5561),
	U(0xc3dc0280), U(0x05687715), U(0x646c6bd7), U(0x44904db3),
	U(0x66b4f0a3), U(0xc0f1648a), U(0x697ed5af), U(0x49e92ff6),
	U(0x309e374f), U(0x2cb6356a), U(0x85808573), U(0x4991f840),
	U(0x76f0ae02), U(0x083be84d), U(0x28421c9a), U(0x44489406),
	U(0x736e4cb8), U(0xc1092910), U(0x8bc95fc6), U(0x7d869cf4),
	U(0x134f616f), U(0x2e77118d), U(0xb31b2be1), U(0xaa90b472),
	U(0x3ca5d717), U(0x7d161bba), U(0x9cad9010), U(0xaf462ba2),
	U(0x9fe459d2), U(0x45d34559), U(0xd9f2da13), U(0xdbc65487),
	U(0xf3e4f94e), U(0x176d486f), U(0x097c13ea), U(0x631da5c7),
	U(0x445f7382), U(0x175683f4), U(0xcdc66a97), U(0x70be0288),
	U(0xb3cdcf72), U(0x6e5dd2f3), U(0x20936079), U(0x459b80a5),
	U(0xbe60e2db), U(0xa9c23101), U(0xeba5315c), U(0x224e42f2),
	U(0x1c5c1572), U(0xf6721b2c), U(0x1ad2fff3), U(0x8c25404e),
	U(0x324ed72f), U(0x4067b7fd), U(0x0523138e), U(0x5ca3bc78),
	U(0xdc0fd66e), U(0x75922283), U(0x784d6b17), U(0x58ebb16e),
	U(0x44094f85), U(0x3f481d87), U(0xfcfeae7b), U(0x77b5ff76),
	U(0x8c2302bf), U(0xaaf47556), U(0x5f46b02a), U(0x2b092801),
	U(0x3d38f5f7), U(0x0ca81f36), U(0x52af4a8a), U(0x66d5e7c0),
	U(0xdf3b0874), U(0x95055110), U(0x1b5ad7a8), U(0xf61ed5ad),
	U(0x6cf6e479), U(0x20758184), U(0xd0cefa65), U(0x88f7be58),
	U(0x4a046826), U(0x0ff6f8f3), U(0xa09c7f70), U(0x5346aba0),
	U(0x5ce96c28), U(0xe176eda3), U(0x6bac307f), U(0x376829d2),
	U(0x85360fa9), U(0x17e3fe2a), U(0x24b79767), U(0xf5a96b20),
	U(0xd6cd2595), U(0x68ff1ebf), U(0x7555442c), U(0xf19f06be),
	U(0xf9e0659a), U(0xeeb9491d), U(0x34010718), U(0xbb30cab8),
	U(0xe822fe15), U(0x88570983), U(0x750e6249), U(0xda627e55),
	U(0x5e76ffa8), U(0xb1534546), U(0x6d47de08), U(0xefe9e7d4)
};

static const u_32int cast_S6[] = {
	U(0xf6fa8f9d), U(0x2cac6ce1), U(0x4ca34867), U(0xe2337f7c),
	U(0x95db08e7), U(0x016843b4), U(0xeced5cbc), U(0x325553ac),
	U(0xbf9f0960), U(0xdfa1e2ed), U(0x83f0579d), U(0x63ed86b9),
	U(0x1ab6a6b8), U(0xde5ebe39), U(0xf38ff732), U(0x8989b138),
	U(0x33f14961), U(0xc01937bd), U(0xf506c6da), U(0xe4625e7e),
	U(0xa308ea99), U(0x4e23e33c), U(0x79cbd7cc), U(0x48a14367),
	U(0xa3149619), U(0xfec94bd5), U(0xa114174a), U(0xeaa01866),
	U(0xa084db2d), U(0x09a8486f), U(0xa888614a), U(0x2900af98),
	U(0x01665991), U(0xe1992863), U(0xc8f30c60), U(0x2e78ef3c),
	U(0xd0d51932), U(0xcf0fec14), U(0xf7ca07d2), U(0xd0a82072),
	U(0xfd41197e), U(0x9305a6b0), U(0xe86be3da), U(0x74bed3cd),
	U(0x372da53c), U(0x4c7f4448), U(0xdab5d440), U(0x6dba0ec3),
	U(0x083919a7), U(0x9fbaeed9), U(0x49dbcfb0), U(0x4e670c53),
	U(0x5c3d9c01), U(0x64bdb941), U(0x2c0e636a), U(0xba7dd9cd),
	U(0xea6f7388), U(0xe70bc762), U(0x35f29adb), U(0x5c4cdd8d),
	U(0xf0d48d8c), U(0xb88153e2), U(0x08a19866), U(0x1ae2eac8),
	U(0x284caf89), U(0xaa928223), U(0x9334be53), U(0x3b3a21bf),
	U(0x16434be3), U(0x9aea3906), U(0xefe8c36e), U(0xf890cdd9),
	U(0x80226dae), U(0xc340a4a3), U(0xdf7e9c09), U(0xa694a807),
	U(0x5b7c5ecc), U(0x221db3a6), U(0x9a69a02f), U(0x68818a54),
	U(0xceb2296f), U(0x53c0843a), U(0xfe893655), U(0x25bfe68a),
	U(0xb4628abc), U(0xcf222ebf), U(0x25ac6f48), U(0xa9a99387),
	U(0x53bddb65), U(0xe76ffbe7), U(0xe967fd78), U(0x0ba93563),
	U(0x8e342bc1), U(0xe8a11be9), U(0x4980740d), U(0xc8087dfc),
	U(0x8de4bf99), U(0xa11101a0), U(0x7fd37975), U(0xda5a26c0),
	U(0xe81f994f), U(0x9528cd89), U(0xfd339fed), U(0xb87834bf),
	U(0x5f04456d), U(0x22258698), U(0xc9c4c83b), U(0x2dc156be),
	U(0x4f628daa), U(0x57f55ec5), U(0xe2220abe), U(0xd2916ebf),
	U(0x4ec75b95), U(0x24f2c3c0), U(0x42d15d99), U(0xcd0d7fa0),
	U(0x7b6e27ff), U(0xa8dc8af0), U(0x7345c106), U(0xf41e232f),
	U(0x35162386), U(0xe6ea8926), U(0x3333b094), U(0x157ec6f2),
	U(0x372b74af), U(0x692573e4), U(0xe9a9d848), U(0xf3160289),
	U(0x3a62ef1d), U(0xa787e238), U(0xf3a5f676), U(0x74364853),
	U(0x20951063), U(0x4576698d), U(0xb6fad407), U(0x592af950),
	U(0x36f73523), U(0x4cfb6e87), U(0x7da4cec0), U(0x6c152daa),
	U(0xcb0396a8), U(0xc50dfe5d), U(0xfcd707ab), U(0x0921c42f),
	U(0x89dff0bb), U(0x5fe2be78), U(0x448f4f33), U(0x754613c9),
	U(0x2b05d08d), U(0x48b9d585), U(0xdc049441), U(0xc8098f9b),
	U(0x7dede786), U(0xc39a3373), U(0x42410005), U(0x6a091751),
	U(0x0ef3c8a6), U(0x890072d6), U(0x28207682), U(0xa9a9f7be),
	U(0xbf32679d), U(0xd45b5b75), U(0xb353fd00), U(0xcbb0e358),
	U(0x830f220a), U(0x1f8fb214), U(0xd372cf08), U(0xcc3c4a13),
	U(0x8cf63166), U(0x061c87be), U(0x88c98f88), U(0x6062e397),
	U(0x47cf8e7a), U(0xb6c85283), U(0x3cc2acfb), U(0x3fc06976),
	U(0x4e8f0252), U(0x64d8314d), U(0xda3870e3), U(0x1e665459),
	U(0xc10908f0), U(0x513021a5), U(0x6c5b68b7), U(0x822f8aa0),
	U(0x3007cd3e), U(0x74719eef), U(0xdc872681), U(0x073340d4),
	U(0x7e432fd9), U(0x0c5ec241), U(0x8809286c), U(0xf592d891),
	U(0x08a930f6), U(0x957ef305), U(0xb7fbffbd), U(0xc266e96f),
	U(0x6fe4ac98), U(0xb173ecc0), U(0xbc60b42a), U(0x953498da),
	U(0xfba1ae12), U(0x2d4bd736), U(0x0f25faab), U(0xa4f3fceb),
	U(0xe2969123), U(0x257f0c3d), U(0x9348af49), U(0x361400bc),
	U(0xe8816f4a), U(0x3814f200), U(0xa3f94043), U(0x9c7a54c2),
	U(0xbc704f57), U(0xda41e7f9), U(0xc25ad33a), U(0x54f4a084),
	U(0xb17f5505), U(0x59357cbe), U(0xedbd15c8), U(0x7f97c5ab),
	U(0xba5ac7b5), U(0xb6f6deaf), U(0x3a479c3a), U(0x5302da25),
	U(0x653d7e6a), U(0x54268d49), U(0x51a477ea), U(0x5017d55b),
	U(0xd7d25d88), U(0x44136c76), U(0x0404a8c8), U(0xb8e5a121),
	U(0xb81a928a), U(0x60ed5869), U(0x97c55b96), U(0xeaec991b),
	U(0x29935913), U(0x01fdb7f1), U(0x088e8dfa), U(0x9ab6f6f5),
	U(0x3b4cbf9f), U(0x4a5de3ab), U(0xe6051d35), U(0xa0e1d855),
	U(0xd36b4cf1), U(0xf544edeb), U(0xb0e93524), U(0xbebb8fbd),
	U(0xa2d762cf), U(0x49c92f54), U(0x38b5f331), U(0x7128a454),
	U(0x48392905), U(0xa65b1db8), U(0x851c97bd), U(0xd675cf2f)
};

static const u_32int cast_S7[] = {
	U(0x85e04019), U(0x332bf567), U(0x662dbfff), U(0xcfc65693),
	U(0x2a8d7f6f), U(0xab9bc912), U(0xde6008a1), U(0x2028da1f),
	U(0x0227bce7), U(0x4d642916), U(0x18fac300), U(0x50f18b82),
	U(0x2cb2cb11), U(0xb232e75c), U(0x4b3695f2), U(0xb28707de),
	U(0xa05fbcf6), U(0xcd4181e9), U(0xe150210c), U(0xe24ef1bd),
	U(0xb168c381), U(0xfde4e789), U(0x5c79b0d8), U(0x1e8bfd43),
	U(0x4d495001), U(0x38be4341), U(0x913cee1d), U(0x92a79c3f),
	U(0x089766be), U(0xbaeeadf4), U(0x1286becf), U(0xb6eacb19),
	U(0x2660c200), U(0x7565bde4), U(0x64241f7a), U(0x8248dca9),
	U(0xc3b3ad66), U(0x28136086), U(0x0bd8dfa8), U(0x356d1cf2),
	U(0x107789be), U(0xb3b2e9ce), U(0x0502aa8f), U(0x0bc0351e),
	U(0x166bf52a), U(0xeb12ff82), U(0xe3486911), U(0xd34d7516),
	U(0x4e7b3aff), U(0x5f43671b), U(0x9cf6e037), U(0x4981ac83),
	U(0x334266ce), U(0x8c9341b7), U(0xd0d854c0), U(0xcb3a6c88),
	U(0x47bc2829), U(0x4725ba37), U(0xa66ad22b), U(0x7ad61f1e),
	U(0x0c5cbafa), U(0x4437f107), U(0xb6e79962), U(0x42d2d816),
	U(0x0a961288), U(0xe1a5c06e), U(0x13749e67), U(0x72fc081a),
	U(0xb1d139f7), U(0xf9583745), U(0xcf19df58), U(0xbec3f756),
	U(0xc06eba30), U(0x07211b24), U(0x45c28829), U(0xc95e317f),
	U(0xbc8ec511), U(0x38bc46e9), U(0xc6e6fa14), U(0xbae8584a),
	U(0xad4ebc46), U(0x468f508b), U(0x7829435f), U(0xf124183b),
	U(0x821dba9f), U(0xaff60ff4), U(0xea2c4e6d), U(0x16e39264),
	U(0x92544a8b), U(0x009b4fc3), U(0xaba68ced), U(0x9ac96f78),
	U(0x06a5b79a), U(0xb2856e6e), U(0x1aec3ca9), U(0xbe838688),
	U(0x0e0804e9), U(0x55f1be56), U(0xe7e5363b), U(0xb3a1f25d),
	U(0xf7debb85), U(0x61fe033c), U(0x16746233), U(0x3c034c28),
	U(0xda6d0c74), U(0x79aac56c), U(0x3ce4e1ad), U(0x51f0c802),
	U(0x98f8f35a), U(0x1626a49f), U(0xeed82b29), U(0x1d382fe3),
	U(0x0c4fb99a), U(0xbb325778), U(0x3ec6d97b), U(0x6e77a6a9),
	U(0xcb658b5c), U(0xd45230c7), U(0x2bd1408b), U(0x60c03eb7),
	U(0xb9068d78), U(0xa33754f4), U(0xf430c87d), U(0xc8a71302),
	U(0xb96d8c32), U(0xebd4e7be), U(0xbe8b9d2d), U(0x7979fb06),
	U(0xe7225308), U(0x8b75cf77), U(0x11ef8da4), U(0xe083c858),
	U(0x8d6b786f), U(0x5a6317a6), U(0xfa5cf7a0), U(0x5dda0033),
	U(0xf28ebfb0), U(0xf5b9c310), U(0xa0eac280), U(0x08b9767a),
	U(0xa3d9d2b0), U(0x79d34217), U(0x021a718d), U(0x9ac6336a),
	U(0x2711fd60), U(0x438050e3), U(0x069908a8), U(0x3d7fedc4),
	U(0x826d2bef), U(0x4eeb8476), U(0x488dcf25), U(0x36c9d566),
	U(0x28e74e41), U(0xc2610aca), U(0x3d49a9cf), U(0xbae3b9df),
	U(0xb65f8de6), U(0x92aeaf64), U(0x3ac7d5e6), U(0x9ea80509),
	U(0xf22b017d), U(0xa4173f70), U(0xdd1e16c3), U(0x15e0d7f9),
	U(0x50b1b887), U(0x2b9f4fd5), U(0x625aba82), U(0x6a017962),
	U(0x2ec01b9c), U(0x15488aa9), U(0xd716e740), U(0x40055a2c),
	U(0x93d29a22), U(0xe32dbf9a), U(0x058745b9), U(0x3453dc1e),
	U(0xd699296e), U(0x496cff6f), U(0x1c9f4986), U(0xdfe2ed07),
	U(0xb87242d1), U(0x19de7eae), U(0x053e561a), U(0x15ad6f8c),
	U(0x66626c1c), U(0x7154c24c), U(0xea082b2a), U(0x93eb2939),
	U(0x17dcb0f0), U(0x58d4f2ae), U(0x9ea294fb), U(0x52cf564c),
	U(0x9883fe66), U(0x2ec40581), U(0x763953c3), U(0x01d6692e),
	U(0xd3a0c108), U(0xa1e7160e), U(0xe4f2dfa6), U(0x693ed285),
	U(0x74904698), U(0x4c2b0edd), U(0x4f757656), U(0x5d393378),
	U(0xa132234f), U(0x3d321c5d), U(0xc3f5e194), U(0x4b269301),
	U(0xc79f022f), U(0x3c997e7e), U(0x5e4f9504), U(0x3ffafbbd),
	U(0x76f7ad0e), U(0x296693f4), U(0x3d1fce6f), U(0xc61e45be),
	U(0xd3b5ab34), U(0xf72bf9b7), U(0x1b0434c0), U(0x4e72b567),
	U(0x5592a33d), U(0xb5229301), U(0xcfd2a87f), U(0x60aeb767),
	U(0x1814386b), U(0x30bcc33d), U(0x38a0c07d), U(0xfd1606f2),
	U(0xc363519b), U(0x589dd390), U(0x5479f8e6), U(0x1cb8d647),
	U(0x97fd61a9), U(0xea7759f4), U(0x2d57539d), U(0x569a58cf),
	U(0xe84e63ad), U(0x462e1b78), U(0x6580f87e), U(0xf3817914),
	U(0x91da55f4), U(0x40a230f3), U(0xd1988f35), U(0xb6e318d2),
	U(0x3ffa50bc), U(0x3d40f021), U(0xc3c0bdae), U(0x4958c24c),
	U(0x518f36b2), U(0x84b1d370), U(0x0fedce83), U(0x878ddada),
	U(0xf2a279c7), U(0x94e01be8), U(0x90716f4b), U(0x954b8aa3)
};

static const u_32int cast_S8[] = {
	U(0xe216300d), U(0xbbddfffc), U(0xa7ebdabd), U(0x35648095),
	U(0x7789f8b7), U(0xe6c1121b), U(0x0e241600), U(0x052ce8b5),
	U(0x11a9cfb0), U(0xe5952f11), U(0xece7990a), U(0x9386d174),
	U(0x2a42931c), U(0x76e38111), U(0xb12def3a), U(0x37ddddfc),
	U(0xde9adeb1), U(0x0a0cc32c), U(0xbe197029), U(0x84a00940),
	U(0xbb243a0f), U(0xb4d137cf), U(0xb44e79f0), U(0x049eedfd),
	U(0x0b15a15d), U(0x480d3168), U(0x8bbbde5a), U(0x669ded42),
	U(0xc7ece831), U(0x3f8f95e7), U(0x72df191b), U(0x7580330d),
	U(0x94074251), U(0x5c7dcdfa), U(0xabbe6d63), U(0xaa402164),
	U(0xb301d40a), U(0x02e7d1ca), U(0x53571dae), U(0x7a3182a2),
	U(0x12a8ddec), U(0xfdaa335d), U(0x176f43e8), U(0x71fb46d4),
	U(0x38129022), U(0xce949ad4), U(0xb84769ad), U(0x965bd862),
	U(0x82f3d055), U(0x66fb9767), U(0x15b80b4e), U(0x1d5b47a0),
	U(0x4cfde06f), U(0xc28ec4b8), U(0x57e8726e), U(0x647a78fc),
	U(0x99865d44), U(0x608bd593), U(0x6c200e03), U(0x39dc5ff6),
	U(0x5d0b00a3), U(0xae63aff2), U(0x7e8bd632), U(0x70108c0c),
	U(0xbbd35049), U(0x2998df04), U(0x980cf42a), U(0x9b6df491),
	U(0x9e7edd53), U(0x06918548), U(0x58cb7e07), U(0x3b74ef2e),
	U(0x522fffb1), U(0xd24708cc), U(0x1c7e27cd), U(0xa4eb215b),
	U(0x3cf1d2e2), U(0x19b47a38), U(0x424f7618), U(0x35856039),
	U(0x9d17dee7), U(0x27eb35e6), U(0xc9aff67b), U(0x36baf5b8),
	U(0x09c467cd), U(0xc18910b1), U(0xe11dbf7b), U(0x06cd1af8),
	U(0x7170c608), U(0x2d5e3354), U(0xd4de495a), U(0x64c6d006),
	U(0xbcc0c62c), U(0x3dd00db3), U(0x708f8f34), U(0x77d51b42),
	U(0x264f620f), U(0x24b8d2bf), U(0x15c1b79e), U(0x46a52564),
	U(0xf8d7e54e), U(0x3e378160), U(0x7895cda5), U(0x859c15a5),
	U(0xe6459788), U(0xc37bc75f), U(0xdb07ba0c), U(0x0676a3ab),
	U(0x7f229b1e), U(0x31842e7b), U(0x24259fd7), U(0xf8bef472),
	U(0x835ffcb8), U(0x6df4c1f2), U(0x96f5b195), U(0xfd0af0fc),
	U(0xb0fe134c), U(0xe2506d3d), U(0x4f9b12ea), U(0xf215f225),
	U(0xa223736f), U(0x9fb4c428), U(0x25d04979), U(0x34c713f8),
	U(0xc4618187), U(0xea7a6e98), U(0x7cd16efc), U(0x1436876c),
	U(0xf1544107), U(0xbedeee14), U(0x56e9af27), U(0xa04aa441),
	U(0x3cf7c899), U(0x92ecbae6), U(0xdd67016d), U(0x151682eb),
	U(0xa842eedf), U(0xfdba60b4), U(0xf1907b75), U(0x20e3030f),
	U(0x24d8c29e), U(0xe139673b), U(0xefa63fb8), U(0x71873054),
	U(0xb6f2cf3b), U(0x9f326442), U(0xcb15a4cc), U(0xb01a4504),
	U(0xf1e47d8d), U(0x844a1be5), U(0xbae7dfdc), U(0x42cbda70),
	U(0xcd7dae0a), U(0x57e85b7a), U(0xd53f5af6), U(0x20cf4d8c),
	U(0xcea4d428), U(0x79d130a4), U(0x3486ebfb), U(0x33d3cddc),
	U(0x77853b53), U(0x37effcb5), U(0xc5068778), U(0xe580b3e6),
	U(0x4e68b8f4), U(0xc5c8b37e), U(0x0d809ea2), U(0x398feb7c),
	U(0x132a4f94), U(0x43b7950e), U(0x2fee7d1c), U(0x223613bd),
	U(0xdd06caa2), U(0x37df932b), U(0xc4248289), U(0xacf3ebc3),
	U(0x5715f6b7), U(0xef3478dd), U(0xf267616f), U(0xc148cbe4),
	U(0x9052815e), U(0x5e410fab), U(0xb48a2465), U(0x2eda7fa4),
	U(0xe87b40e4), U(0xe98ea084), U(0x5889e9e1), U(0xefd390fc),
	U(0xdd07d35b), U(0xdb485694), U(0x38d7e5b2), U(0x57720101),
	U(0x730edebc), U(0x5b643113), U(0x94917e4f), U(0x503c2fba),
	U(0x646f1282), U(0x7523d24a), U(0xe0779695), U(0xf9c17a8f),
	U(0x7a5b2121), U(0xd187b896), U(0x29263a4d), U(0xba510cdf),
	U(0x81f47c9f), U(0xad1163ed), U(0xea7b5965), U(0x1a00726e),
	U(0x11403092), U(0x00da6d77), U(0x4a0cdd61), U(0xad1f4603),
	U(0x605bdfb0), U(0x9eedc364), U(0x22ebe6a8), U(0xcee7d28a),
	U(0xa0e736a0), U(0x5564a6b9), U(0x10853209), U(0xc7eb8f37),
	U(0x2de705ca), U(0x8951570f), U(0xdf09822b), U(0xbd691a6c),
	U(0xaa12e4f2), U(0x87451c0f), U(0xe0f6a27a), U(0x3ada4819),
	U(0x4cf1764f), U(0x0d771c2b), U(0x67cdb156), U(0x350d8384),
	U(0x5938fa0f), U(0x42399ef3), U(0x36997b07), U(0x0e84093d),
	U(0x4aa93e61), U(0x8360d87b), U(0x1fa98b0c), U(0x1149382c),
	U(0xe97625a5), U(0x0614d1b7), U(0x0e25244b), U(0x0c768347),
	U(0x589e8d82), U(0x0d2059d1), U(0xa466bb1e), U(0xf8da0a82),
	U(0x04f19130), U(0xba6e4ec0), U(0x99265164), U(0x1ee7230d),
	U(0x50b2ad80), U(0xeaee6801), U(0x8db2a283), U(0xea8bf59e)
};
