<* $Id: macros.hsc,v 1.68 2004/02/05 09:43:23 mb Exp mb $ *>

<* This is a collection of HSC macros that evolved during my development
 * of a (gasp!) homepage and some other webpages. Most macros need
 * one of the newer versions of HSC to work correctly!
 *>
 
<*-----------------------------------------------------------------------*>
<* BASIC                                                                 *>
<*-----------------------------------------------------------------------*>
<* some abbreviations for HSC stuff *>
<$macro _NOTE T:string/R><$message CLASS=note TEXT=(T)></$macro>
<$macro _WARNING T:string/R><$message CLASS=warning TEXT=(T)></$macro>
<$macro _ERROR T:string/R><$message CLASS=error TEXT=(T)></$macro>
<$macro _FATALERROR T:string/R><$message CLASS=fatal TEXT=(T)></$macro>
<$macro _DEBUG T:string/R>
	<$if COND=(defined DEBUG)><$message CLASS=warning TEXT=(T)></$if>
</$macro>

<*-------------------------------------*>
<* show warning if compiled with too old an HSC version *>
<$if COND=((not defined hsc.version) or 
           ((hsc.version = "0") and (hsc.revision < "931")))>
  <$message class=warning text=(HSC.LF + "You are using HSC V" + hsc.version + "." +
            hsc.revision +
            ", but this macro file requires HSC V0.931 or greater." +
				    HSC.LF + "Get it from " +
				    "http://www.linguistik.uni-erlangen.de/msbethke/software.html")> 
</$if>

<*-------------------------------------*>
<* how to delete temporary files *>
<$if COND=(defined HSC_SYSCMD_RM)>
	<$macro HSC_SYSCMD_RMFILE FILE:string/R>
		<$exec COMMAND=(HSC_SYSCMD_RM + ' ' + FILE)>
	</$macro>
<$else>
	<$if COND=(HSC.System = "amiga")>
		<$macro HSC_SYSCMD_RMFILE FILE:string/R>
			<$exec COMMAND=("delete " + FILE)>
		</$macro>
	<$elseif COND=((HSC.System = "unix") or (HSC.System = "nextstep") or (HSC.System = "beos"))>
		<$macro HSC_SYSCMD_RMFILE FILE:string/R>
			<$exec COMMAND=("rm -f " + FILE)>
		</$macro>
	<$else>
		<$macro HSC_SYSCMD_RMFILE FILE:string/R>
			<$message class=warning text=("Cannot remove file(s) - please define HSC_SYSCMD_RM: "
								  + FILE)>
		</$macro>
	</$if>
</$if>

<*-----------------------------------------------------------------------*>
<* LOOPS                                                                 *>
<*-----------------------------------------------------------------------*>

<* Did you know HSC can do loops? It can!
 * _ITERATE is the "raw" and somewhat awkward version that works like those
 * LISP iterators you have to write in 1st year CS =^>
 * FOR adds ease of use as a container macro with error handling and 
 * optional parameters. FOR's content is expanded in the context of its
 * respective surrounding _ITERATE macro.
 * Example:
 * <FOR VAR=i START=2 TO=10>
 *   <P>Counting: <(i)></P>
 * </FOR>
 * Think of calculated tag attributes...
 * If you want to qualify for the "Obfuscated HSC Contest", you can even
 * modify <VAR> in your loop's body: <$let x=(x - "1")>
 * Nested loops are possible, too:
 * <FOR START=0 TO=3 VAR=y>
 *   <FOR START=0 TO=3 VAR=x>
 *     <('Column ' + x + ', Line ' + y)>
 *   </FOR>
 * </FOR>
 *>
<$macro _ITERATE COND:string/R CONTENT:string/R>
  <(
    "<$if COND=(" + COND + ")>" +
      "<(CONTENT)>" +
      "<_ITERATE COND=(COND) CONTENT=(CONTENT)>" +
    "</$if>"
   )>
</$macro>

<$macro FOR /CLOSE VAR:string/R START:num=1 TO:num/R STEP:num=1>
  <$if COND=(STEP = "0")>
    <$message class=fatal text="STEP must not be zero!">
  </$if>

  <* define _loop_nestlevel if required, otherwise increment it *>
  <$if COND=(defined _loop_nestlevel)>
    <$let _loop_nestlevel = (_loop_nestlevel & "1")>
  <$else>
    <$define _loop_nestlevel:num="1">
  </$if>  
  
  <* define loop-local variable VAR and set it to START *>
  <("<$define " + VAR + ":num=" + START + ">")>
  
  <* define "_loop_running_<level>" required for the BREAK macro *>
  <( "<$define _loop_running_" + _loop_nestlevel + ":bool='1'>" )>
  
  <* Determine the loop condition and do the iterations *>
  <$if COND=(STEP < "0")>
    <_ITERATE COND=("_loop_running_" + _loop_nestlevel + " AND (" + VAR + ">='" +
        TO +"')")
      CONTENT=(HSC.Content + "<$let " + VAR + "=(" + VAR + "&'" + STEP + "')>")>
  <$else>
    <_ITERATE COND=("_loop_running_" + _loop_nestlevel + " AND (" + VAR + "<='" +
        TO +"')")
      CONTENT=(HSC.Content + "<$let " + VAR + "=(" + VAR + "&'" + STEP + "')>")>
  </$if>
</$macro>

<* This macro breaks a FOR-loop on the next iteration. I.e. it's not quite the
 * same as the C keyword that leaves immediately! Setting "N" breaks that
 * many levels of nested loops at once.
 *>
<$macro BREAK /MBI="for|while" N:num>
  <$if COND=(set N)>
    <FOR VAR=_the_break_loop_counter START="1" TO=(N)>
      <(
        "<$if COND=(defined _loop_running_" +
          (_loop_nestlevel - "1" & _the_break_loop_counter) +
        ")>" +
          "<$let _loop_running_" +
            (_loop_nestlevel - "1" & _the_break_loop_counter) +
            "=''>" +
        "</$if>"
      )>
    </FOR>
  <$else>
    <$let {_loop_running_ + _loop_nestlevel} = ''>
  </$if>  
</$macro>

<*-------------------------------------*>
<* The other kind of loop: while()
 * Dead simple to use:
 * <WHILE COND="a < 10">
 *   <$let a=(a & "1")>
 *   A is <(a)>.<br>
 * </WHILE>
 * (You have to $define "a" before, of course!)
 *> 
<$macro WHILE /CLOSE COND:string/R>
  <_ITERATE COND?=COND CONTENT=(HSC.Content)>
</$macro>

<*-----------------------------------------------------------------------*>
<* ARRAYS                                                                *>
<*-----------------------------------------------------------------------*>

<* this macro creates code to define an "array" of variables of type TYPE. The
 * code is written to the variable whose name is passed as VAR (and must exist
 * already) and when expanded will create N variables with prefix P
 * So to create an "array" called "foo" with 10 strings, use
 *
 * <$define code:string>
 * <_MAKE_ARRAYCODE N=10 P=foo TYPE=string VAR=code>
 * <(code)>
 * optional: for big arrays, <$let code=''> to free some KBytes
 * These steps are necessary to allow for macro-local arrays.
 * 
 * See below for some syntactic epsom salts (I wouldn't dare call
 * this "sugar" :)) for this sequence.
 * 
 * You can then access the variables as foo0,foo1 .. foo9.
 * To access varying indices, use dynamic source attributes with
 * symbolic references as described in the "Attribute Assignment"
 * section of the docs.
 * For reading: <$let var = {'foo' + fooindex}>
 * For writing: <$let {'foo' + fooindex} = 'new contents'>
 * If you need the variables initialized to a default value (so they don't
 * throw any errors when read) set the DEFAULT attribute.
 *>
<$macro _MAKE_ARRAYCODE N:num/R P:string/R VAR:string/R TYPE:string='string'
                        DEFAULT:string GLOBAL:bool>
	<$define _mkac-tmpcode:string>	     <* first level generated code *>
	<$define _mkac-varname:string>	     <* dynamic variable name *>
  <$define _mkac-tcode-1:string/C=('<$let ' + VAR + '=(' + VAR + '+"' +
                                   '<' + '$if COND=(not defined ')>
  <$define _mkac-tcode-2:string/C=("'><" + '/$if>")>')>
  <$define _mkac-tcode-3:string/C=("='" + DEFAULT + "'><" + "$else><" +
                                   "$let ")>
  <$define _mkac-init:bool/C=(set DEFAULT)>
  <$define _mkac-langb:string/C='<'>

	<$if COND=(N = '0')>
    <$message class=warning text=("Array size for '" + P + "' is zero!")>
  </$if>
	<$let {VAR}=""> <* clear the variable *>
	<FOR VAR=i START='0' TO=(N)>	    <* define N variables *>
		<$let _mkac-varname = (P + i)>
		<$let _mkac-tmpcode = (_mkac-tcode-1 + _mkac-varname + ')>' +
		      '<$define ' + _mkac-varname + ':' + TYPE)>
		<$if COND=(_mkac-init)>
      <$let _mkac-tmpcode = (_mkac-tmpcode + _mkac-tcode-3)>
      <$let _mkac-tmpcode = (_mkac-tmpcode + _mkac-varname + "='" + DEFAULT)>
      <$let _mkac-tmpcode = (_mkac-tmpcode + _mkac-tcode-2)>
    <$else>
      <$let _mkac-tmpcode = (_mkac-tmpcode + _mkac-tcode-2)>
    </$if>
		<* execute code to add to variable in VAR *>
		<(_mkac-tmpcode)>
	</FOR>
</$macro>

<* The following is a somewhat more consistent (if you want to call it that)
 * syntax for defining an array; it handles the temp variable on its own:
 *
 * <(DEFARRAY_PRE)>
 * <DEFARRAY_MAIN N=10 P=foo TYPE=string DEFAULT="foo-default">
 * <(DEFARRAY_POST)>
 *
 * (note the different notations as two variable expansions and one macro!)
 *>
<$define DEFARRAY_PRE:string/C=
  "<$if COND=(not (defined __code))><$define __code:string></$if>">
<$macro DEFARRAY_MAIN N:num/R P:string/R TYPE:string='string' DEFAULT:string
        GLOBAL:bool>
  <_MAKE_ARRAYCODE N=(N) P=(P) TYPE=(TYPE) DEFAULT?=DEFAULT VAR="__code"
                   GLOBAL?=GLOBAL>
</$macro>
<$define DEFARRAY_POST:string/C="<(__code)><$let __code=''>">

<*-----------------------------------------------------------------------*>
<* SCRIPTING                                                             *>
<*-----------------------------------------------------------------------*>

<* Scripting macros: call virtually any script from HSC and insert its
 * output or read it into a variable. See PERL/PYTHON and their DYN-
 * flavors!
 *>
<$macro INTERPRET-SCRIPT INTERPRETER:string/R PARAMS:string SCRIPT:string/R
        ARGS:string TOVAR:string>
  <$define cmd:string=(INTERPRETER + ' ')>
  <$define tempfile:string/CONST=(HSC.Source.Name + "_sctmp")>
  <$if COND=(set PARAMS)><$let cmd=(cmd + PARAMS + ' ')></$if>
  <$let cmd=(cmd + tempfile + ' ')>
  <$if COND=(set ARGS)><$let cmd=(cmd + ' ' + ARGS)></$if>
  <$export FILE=(tempfile) DATA=(SCRIPT)>
  <$if COND=(set TOVAR)>
    <$exec COMMAND=(cmd) ATTRIBUTE=(TOVAR) TEMPORARY>
  <$else>
    <$exec COMMAND=(cmd) INCLUDE TEMPORARY>
  </$if>
	<HSC_SYSCMD_RMFILE FILE=(tempfile)>
</$macro>

<*-------------------------------------*>
<$macro PERL /CLOSE ARGS:string TOVAR:string>
  <INTERPRET-SCRIPT INTERPRETER="perl" SCRIPT=(HSC.Content) ARGS?=ARGS
                    TOVAR?=TOVAR>
</$macro>

<*-------------------------------------*>
<$macro PYTHON /CLOSE ARGS:string TOVAR:string>
  <INTERPRET-SCRIPT INTERPRETER="python" SCRIPT=(HSC.Content) ARGS?=ARGS
                    TOVAR?=TOVAR>
</$macro>

<*-------------------------------------*>
<* here's for dynamically generated scripts *>

<$macro DYN-PERL SCRIPT:string/R ARGS:string TOVAR:string>
  <INTERPRET-SCRIPT INTERPRETER="perl" SCRIPT=(SCRIPT) ARGS?=ARGS
                    TOVAR?=TOVAR>
</$macro>

<*-------------------------------------*>
<$macro DYN-PYTHON SCRIPT:string/R ARGS:string TOVAR:string>
  <INTERPRET-SCRIPT INTERPRETER="python" SCRIPT=(SCRIPT) ARGS?=ARGS
                    TOVAR?=TOVAR>
</$macro>

<*-----------------------------------------------------------------------*>
<* Assign the entire contents of this container to VAR *>
<$macro TEXT_TO_STRING /CLOSE VAR:string/R>
  <$let {VAR}=(HSC.Content)>
</$macro>

<*-----------------------------------------------------------------------*>
<* Make an ordinal number: 1st, 2nd, etc.                                *>
<$macro ORDINAL N:num/R>
  <$define _ordinalmod:num/C=(N MOD '10')>
  <$define _ordinalsup:string="th">
  <$if COND=((N < '4') or (N > '20'))>
    <$if     COND=(_ordinalmod = '1')>
      <$let _ordinalsup="st">
    <$elseif COND=(_ordinalmod = '2')>
      <$let _ordinalsup="nd">
    <$elseif COND=(_ordinalmod = '3')>
      <$let _ordinalsup="rd">
    </$if>
  </$if>
  <(N)><sup><(_ordinalsup)></sup>
</$macro>

<*-----------------------------------------------------------------------*>
<* PAGES                                                                 *>
<*-----------------------------------------------------------------------*>

<* You may have to adapt this to the doctypes you actually use... *>
<$macro THISDOCTYPE>
<$if COND=(defined HSC.OPTS.XHTML)>
    <$if COND=(defined PROJECT_CHARSET)>
      <$define _tdtcharset:string=(PROJECT_CHARSET)>
    <$else>
      <$if COND=(HSC.OPTS.ENTITYMODE = "utf-8")>
        <$define _tdtcharset:string="utf-8">
      <$else>
        <$define _tdtcharset:string="iso-8859-1">
      </$if>
    </$if>
    <('<|<?xml version="1.0" encoding="' + _tdtcharset + '"?>|>')>
  <$if COND=(defined TRANSITIONAL_DTD)>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
     "DTD/xhtml1-transitional.dtd">
  <$else>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
    "DTD/xhtml1-strict.dtd">
  </$if>
<$else>
  <$if COND=(defined TRANSITIONAL_DTD)>
    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
    "http://www.w3.org/TR/1999/REC-html401-19991224/loose.dtd">
  <$else>
    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"
    "http://www.w3.org/TR/html4/strict.dtd">
  </$if>
</$if>
</$macro>

<*-------------------------------------*>
<* Generate a whole header with title and all the META crap in one go.
 * Global variables used (usually correspond to an attribute which takes
 * precedence if present):
 * PROJECT_AUTHOR: e.g. "Matthias Bethke"
 * PROJECT_COPYRIGHT: same as above
 * PROJECT_STYLEFILE: e.g  "main.css"
 * PROJECT_LANGUAGE: e.g. "en_US"
 * PROJECT_HEADERDATE: creates a META DATE tag with the date/time of processing
 * PROJECT_HEADERPROFILE: set PROFILE attribute in HEAD
 * PROJECT_CHARSET: create a content-type tag
 * PROJECT_TOCLINKS: insert LINK tags from a table-of-contents file in
 *                   PROJECT_TOC_FILE
 * Set them in your Makefile to generate the corresponding header fields
 * automatically.
 *>
<$macro HEADER /CLOSE
        TITLE:string/R KEYWORDS:string DESCRIPTION:string AUTHOR:string
        LANGUAGE:string STYLEFILE:uri JAVASCRIPT:string JAVASCRIPT-EXT:uri
        SHORTCUTICON:uri DEFAULTFRAME:string BASE:uri
        ROBOTS:string PROFILE:uri REVISIT-AFTER:string CHARSET:string
        ALLOW-SMARTTAGS:bool NOPROXYCACHE:bool NOBROWSERCACHE:bool
        CLASSIFICATION:string DISTRIBUTION:enum("global|local")
        COPYRIGHT:string REPLY-TO:string TOCLINKS:bool>
<$define _hdr_author:string>
<$define _hdr_cr:string>
<$define _hdr_lang:string>
<$define _hdr_profile:uri>

<* process options that may have project-global defaults *>
<$if COND=(defined PROJECT_AUTHOR)><$let _hdr_author=(PROJECT_AUTHOR)></$if>
<$if COND=(set AUTHOR)><$let _hdr_author=(AUTHOR)></$if>
<$if COND=(defined PROJECT_COPYRIGHT)><$let _hdr_cr=(PROJECT_COPYRIGHT)></$if>
<$if COND=(set COPYRIGHT)><$let _hdr_cr=(COPYRIGHT)></$if>
<$if COND=(defined PROJECT_LANGUAGE)><$let _hdr_lang=(PROJECT_LANGUAGE)></$if>
<$if COND=(set LANGUAGE)><$let _hdr_lang=(LANGUAGE)></$if>
<$if COND=(defined PROJECT_HEADERPROFILE)><$let _hdr_profile=(PROJECT_HEADERPROFILE)></$if>
<$if COND=(set PROFILE)><$let _hdr_profile=(PROFILE)></$if>

<HEAD PROFILE?=_hdr_profile>
<$if COND=(set CHARSET)>
  <META HTTP-EQUIV="content-type" CONTENT=("text/html;" + "charset=" + CHARSET)>
<$elseif COND=(defined PROJECT_CHARSET)>
  <META HTTP-EQUIV="content-type" CONTENT=("text/html;" + "charset=" + PROJECT_CHARSET)>
</$if>
<$if COND=(set NOPROXYCACHE)>
  <META HTTP-EQUIV="pragma" CONTENT="no-cache">
</$if>
<$if COND=(set NOBROWSERCACHE)>
  <META HTTP-EQUIV="cache-control" CONTENT="no-cache">
</$if>
<$if COND=(set _hdr_lang)>
  <META HTTP-EQUIV="content-language" CONTENT=(_hdr_lang)>
</$if>

<_SET_HEADER_META PARAM?=KEYWORDS NAME="keywords">
<_SET_HEADER_META PARAM?=DESCRIPTION NAME="description">
<_SET_HEADER_META PARAM?=_hdr_author NAME="author">
<_SET_HEADER_META PARAM?=_hdr_cr NAME="copyright">
<_SET_HEADER_META PARAM?=ROBOTS NAME="robots">
<_SET_HEADER_META PARAM?=REVISIT-AFTER NAME="revisit-after">
<_SET_HEADER_META PARAM?=CLASSIFICATION NAME="classification">
<_SET_HEADER_META PARAM?=DISTRIBUTION NAME="distribution">
<_SET_HEADER_META PARAM?=REPLY-TO NAME="reply-to">
<META NAME="generator" CONTENT=("HSC/" + Hsc.System)>
<$if COND=(not set ALLOW-SMARTTAGS)>
  <META NAME="MSSmartTagsPreventParsing" CONTENT="TRUE">
</$if>

<$if COND=(defined PROJECT_HEADERDATE)>
  <$define _ttf:string=(HSC.Format.Time)>
  <$let HSC.Format.Time="%Y-%m-%dT%T">
  <META NAME="date" CONTENT=(GetTime())>
  <* GMT offsets are still unsupported *>
  <$let HSC.Format.Time=(_ttf)>
</$if>

<$if COND=(set SHORTCUTICON)>
  <LINK REL="shortcut icon" HREF=(SHORTCUTICON)>
</$if>
<$if COND=(set STYLEFILE)>
  <LINK REL="stylesheet" TYPE="text/css" HREF=(STYLEFILE)>
<$elseif COND=(defined PROJECT_STYLEFILE)>
  <LINK REL="stylesheet" TYPE="text/css" HREF=(PROJECT_STYLEFILE)>
</$if>

<$if COND=((set TOCLINKS) or (defined PROJECT_TOCLINKS))>
  <_TABLE-OF-CONTENTS-LINKS>
</$if>

<$if COND=((set BASE) or (set DEFAULTFRAME))>
  <BASE HREF?=BASE TARGET?=DEFAULTFRAME>
</$if>

<$content>

<_INSERT_JAVASCRIPT JS?=JAVASCRIPT JSX?=JAVASCRIPT-EXT>
<TITLE><(TITLE)></TITLE>
</HEAD>
</$macro>

<* a little helper macro to avoid if-orgies in <HEADER> *>
<$macro _SET_HEADER_META PARAM:string NAME:string/R>
<$if COND=(set PARAM)><META NAME=(NAME) CONTENT=(PARAM)></$if>
</$macro>

<* This helper macro creates a bunch of <LINK> tags for sections if requested in
   HEADER (FILE unused as of yet) *>
<$macro _TABLE-OF-CONTENTS-LINKS FILE:string>
	<$define the_toclinks:string=''>
	<$define tocfile:string>

	<$if COND=(defined PROJECT_GENERATE_TOC)>
		<$if COND=(set FILE)>
			<$let tocfile=(FILE)>
		<$elseif COND=(defined PROJECT_TOC_FILE)>
			<$let tocfile=(PROJECT_TOC_FILE)>
		<$else>
			<$let tocfile=((basename (HSC.Source.File)) + '.toc')>
		</$if>

		<$if COND=(fExists(tocfile))>
		<* include file with some TABLE-OF-CONTENTS-ENTRY macros and expand them *>
			<$include FILE=(tocfile) TEMPORARY>
		<$else>
			<$message class=warning text=("Missing TOC file " + tocfile +
                   " in header - rerun HSC to get it right!")>
		</$if>
		<(the_toclinks)>
	</$if>
</$macro>

<*-------------------------------------*>

<$macro WEBPAGE /CLOSE><THISDOCTYPE>
<$if COND=(defined HSC.OPTS.XHTML)>
  <html xmlns="http://www.w3.org/1999/xhtml">
<$else>
  <HTML>
</$if>
<$content></HTML></$macro>

<$macro LAST_CHANGE><SMALL>Last change: <(GetFileDate(hsc.source.file))></SMALL></$macro>

<*-----------------------------------------------------------------------*>
<* FRAMES                                                                *>
<*-----------------------------------------------------------------------*>

<$macro FRAMESETPAGE /CLOSE>
<$if COND=(defined HSC.OPTS.XHTML)>
  <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN"
  "DTD/xhtml1-frameset.dtd">
<$else>
  <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN"
  "http://www.w3.org/TR/html4/frameset.dtd">
</$if>
<HTML><$content></HTML>
</$macro>

<* This is used in other places as well, so it gets its own macro *>
<$macro _INSERT_JAVASCRIPT JS:string JSX:uri>
  <$if COND=(set JS)>
    <script TYPE="text/javascript">
      <("<!-- " + HSC.LF + JS + HSC.LF + "//-->")>
    </script>
  </$if>
  <$if COND=(set JSX)>
    <script TYPE="text/javascript" SRC=(JSX)></script>
  </$if>
</$macro>

<*---------------------------------------------------------------------------*>
<* The frames/noframes switching magic :)
 * To generate the frames version, the symbol USE_FRAMES must be defined.
 * For the noframes version, the symbol FRAMES_NAVBAR must be set to the
 * filename of the HTML file that contains the navigation bar (it doesn't
 * hurt to set it for the frames version, too). The FRAME_MAGIC macro
 * generates the supposed source name by substituting "hsc" for the suffix
 * of this file.
 * The file-global variable FRAMES_NAVSIZE will be set if it isn't defined
 * already. It contains the percentage of the browser window's width to devote
 * to the navigation frame.
 *>

<* This macro doesn't generate any text, only warnings *>
<$macro _FRAMES_CHECK_NAVSIZE_DEF>
	<$define _default_navsize:string="15">
	<$if COND=(not defined FRAMES_NAVSIZE)>
		<$message class=warning text=("Warning: FRAMES_NAVSIZE is not defined, using " +
							_default_navsize)>
		<$define FRAMES_NAVSIZE:num/GLOBAL/CONST=(_default_navsize)>
	</$if>
</$macro>

<* inserts globally defined navigation bar file or an appropriate warning *>
<$macro _FRAMES_INSERT_NAVIGATION_BAR>
  <$if COND=(DEFINED FRAMES_NAVBAR)>
		<$include FILE=((basename (FRAMES_NAVBAR))+".hsc")>
  <$else>
    <TD><SPAN STYLE="font-size:x-large">Warning!</SPAN>FRAMES_NAVBAR was
        undefined when HSC processed this page. To generate proper
        noframes-pages, call HSC with
        <CODE>DEF "FRAMES_NAVBAR:uri=my_navbar.html"</CODE>!</TD>
    <$message class=warning text="FRAMES_NAVBAR is undefined - check output!">
  </$if>
</$macro>

<$macro _FRAMES_CHECK_NAVBARPOS_ENUM>
  <$define _navbarposlist:enum("left|right|top|bottom|l|r|t|b")>
<* if you get an error here, your navbar position is not from the above list *>
  <$if COND=(defined PROJECT_FRAMES_NAVBAR_POS)>
    <$let _navbarposlist=(PROJECT_FRAMES_NAVBAR_POS)>
  <$else>
    <$message class=warning text="PROJECT_FRAMES_NAVBAR_POS is undefined - assuming 'left'!">
    <$define PROJECT_FRAMES_NAVBAR_POS:string/GLOBAL/CONST='left'>
  </$if>
</$macro>

<* An "intelligent" hyperlink.
 * This macro emits links to different files depending on whether frames
 * are in use or not. It tries to figure out what files to treat specially
 * from their suffix (for now and probably ever: everything that ends in 
 * "html" or "htm" (yuck!))
 * HTML files get special treatment in that site-internal links to them
 * that appear on a frameless page and without a special TARGET get the
 * "noframes" infix b/w their name and extension.
 * If you set the global variable DEFAULT_TARGETFRAME to a string, it will be used
 * as the default frame to open links in.
 *>
<$macro HYPERLINK /CLOSE HREF:uri/R LEAVE:bool NEWWIN:bool TARGET:string
REL:enum("contents|chapter|section|subsection|index|glossary|appendix|copyright|next|prev|start|help|bookmark|alternate")
REV:enum("contents|chapter|section|subsection|index|glossary|appendix|copyright|next|prev|start|help|bookmark|alternate")> 
  <$define TGT:string>
  <$define LNK:uri>
  <$if COND=(set Target)>
  	<$if COND=(set Newwin)>
  		<$message class=warning text="TARGET and NEWWIN are mutually exclusive - ignoring NEWWIN">
  	</$if>
  	<$let TGT=(Target)>
  <$elseif COND=(set Newwin)>
  	<$let TGT="_blank"> <* independent of frame use *>
  <$elseif COND=(set Leave)>
  	<$let TGT="_top">
  <$elseif COND=(defined DEFAULT_TARGETFRAME)>
  	<$let TGT=(DEFAULT_TARGETFRAME)>
  </$if>
  <* determine file to link to *>
  <$if COND=((set TGT) or (defined USE_FRAMES) or ((urikind (HREF)) = "ext") or
  	(not (((extension (HREF)) = "html") or ((extension (HREF)) = "htm" ))))>
  <* either using frames, or a custom target, or not referencing a local HTML
     file, so emit the link verbatim *>
  	<$let LNK=(HREF)>
  <$else>
  	<* not using frames nor a custom target, and referencing a local HTML file,
       so insert the "noframes" infix. *>
  	<$let LNK=((basename (HREF))+"_nf."+(extension (HREF)))>
  </$if>
  <A HREF=(LNK) TARGET?=TGT REL?=REL REV?=REV><$content></A>
</$macro>

<* The following will create a table with the navigation bar from the file
 * stored in FRAMES_NAVBAR
 *>
<$macro FRAME_MAGIC /CLOSE /ONLYONCE /MBI="html" CLASS:string PAD:num='8'>
  <$if COND=(defined USE_FRAMES)>
  	<* This page is part of a frameset *>
  	<* Just insert the macro's content into a BODY and be done with it *>
  	<BODY CLASS?=CLASS><$content></BODY>
  <$else>
  	<* Creating a frameless page *>
    <_FRAMES_CHECK_NAVBARPOS_ENUM>
		<_FRAMES_CHECK_NAVSIZE_DEF>
    <$define _framespacing:num>
    <$if COND=(defined FRAMES_FRAMESPACING)>
      <$let _framespacing=(FRAMES_FRAMESPACING)>
    </$if>
		<BODY><TABLE CELLSPACING?=_framespacing CELLPADDING?=PAD WIDTH="100%"
    SUMMARY="Layout">
    <* The following depends on the navigation bar's position *>
    <$if COND=((PROJECT_FRAMES_NAVBAR_POS = "left") or
               (PROJECT_FRAMES_NAVBAR_POS = "l"))>
      <COLGROUP><COL WIDTH=(FRAMES_NAVSIZE)><COL WIDTH="*"></COLGROUP>
      <TR VALIGN="top"><_FRAMES_INSERT_NAVIGATION_BAR>
	  	<TD CLASS?=CLASS><$content></TD>
    <$elseif COND=((PROJECT_FRAMES_NAVBAR_POS = "right") or
                   (PROJECT_FRAMES_NAVBAR_POS = "r"))>
      <COLGROUP><COL WIDTH="*"><COL WIDTH=(FRAMES_NAVSIZE)></COLGROUP>
	  	<TR VALIGN="top"><TD CLASS?=CLASS><$content></TD>
      <_FRAMES_INSERT_NAVIGATION_BAR>
    <$elseif COND=((PROJECT_FRAMES_NAVBAR_POS = "top") or
                   (PROJECT_FRAMES_NAVBAR_POS = "t"))>
      <TR VALIGN="top"><_FRAMES_INSERT_NAVIGATION_BAR></TR>
	  	<TR VALIGN="top"><TD CLASS?=CLASS><$content></TD>
    <$else> <* bottom *>
	  	<TR VALIGN="top"><TD CLASS?=CLASS><$content></TD></TR>
  		<TR VALIGN="top"><_FRAMES_INSERT_NAVIGATION_BAR>
    </$if>
    </TR></TABLE></BODY>
  </$if>
</$macro>

<* Make a navigation frame either into an HTML page or part of a table.
 * TODO: - allow names other than "main" for the main frame
 *>
<$macro NAVIGATION_FRAME /CLOSE CLASS:string STYLEFILE:uri
        DEFAULTFRAME:string="main" LANGUAGE:string JAVASCRIPT:string
        JAVASCRIPT-EXT:uri>
  <$define _navframecontents:string/CONST=(HSC.Content)>
  <$if COND=(defined USE_FRAMES)>
  	<* Expand into a full-blown HTML file *>
    <$define DEFAULT_TARGETFRAME:string=(DEFAULTFRAME)>
  	<WEBPAGE>
      <HEADER TITLE="Navigation" STYLEFILE?=STYLEFILE LANGUAGE?=LANGUAGE
              JAVASCRIPT?=JAVASCRIPT JAVASCRIPT-EXT?=JAVASCRIPT-EXT>
  	  <BODY CLASS?=CLASS>
        <(_navframecontents)>
      </BODY>
    </WEBPAGE>
  <$else>
    <* expand into a mere cell of a table, with much the same properties *>
  	<TD WIDTH?=FRAMES_NAVSIZE CLASS?=CLASS>
      <* first insert javascript stuff that would otherwise be lost *>
      <_INSERT_JAVASCRIPT JS?=JAVASCRIPT JSX?=JAVASCRIPT-EXT>
  	  <(_navframecontents)>
    </TD>
  </$if>
</$macro>

<* A little help for creating the frameset page using already defined stuff *>
<$macro AUTO_FRAMESET /CLOSE /ONLYONCE /MBI="html" /NAW="body"
	NAVNAME:string/R MAINNAME:string/R MAINFILE:uri/R NORESIZE:bool>
  <$define frameborder:num>
  <$if COND=(defined FRAMES_FRAMEBORDER)>
    <$let frameborder=(FRAMES_FRAMEBORDER)>
  </$if>
  <_FRAMES_CHECK_NAVSIZE_DEF>
  <_FRAMES_CHECK_NAVBARPOS_ENUM>
    <* The following depends on the navigation bar's position *>
    <$if COND=((PROJECT_FRAMES_NAVBAR_POS = "left") or
               (PROJECT_FRAMES_NAVBAR_POS = "l"))>
      <FRAMESET COLS=(FRAMES_NAVSIZE + ",*")>
        <FRAME SRC=(FRAMES_NAVBAR) NAME=(NavName) FRAMEBORDER?=frameborder
               NORESIZE?=NORESIZE>
        <FRAME SRC=(MainFile) NAME=(MainName) FRAMEBORDER?=frameborder>
    <$elseif COND=((PROJECT_FRAMES_NAVBAR_POS = "right") or
                   (PROJECT_FRAMES_NAVBAR_POS = "r"))>
       <FRAMESET COLS=("*," + FRAMES_NAVSIZE)>
        <FRAME SRC=(MainFile) NAME=(MainName) FRAMEBORDER?=frameborder>
        <FRAME SRC=(FRAMES_NAVBAR) NAME=(NavName) FRAMEBORDER?=frameborder
               NORESIZE?=NORESIZE>
   <$elseif COND=((PROJECT_FRAMES_NAVBAR_POS = "top") or
                  (PROJECT_FRAMES_NAVBAR_POS = "t"))>
       <FRAMESET ROWS=(FRAMES_NAVSIZE + ",*")>
        <FRAME SRC=(FRAMES_NAVBAR) NAME=(NavName) FRAMEBORDER?=frameborder
               NORESIZE?=NORESIZE>
        <FRAME SRC=(MainFile) NAME=(MainName) FRAMEBORDER?=frameborder>
    <$else> <* bottom *>
       <FRAMESET ROWS=("*," + FRAMES_NAVSIZE)>
        <FRAME SRC=(MainFile) NAME=(MainName) FRAMEBORDER?=frameborder>
        <FRAME SRC=(FRAMES_NAVBAR) NAME=(NavName) FRAMEBORDER?=frameborder
               NORESIZE?=NORESIZE>
    </$if>
    <NOFRAMES><$content></NOFRAMES>
  </FRAMESET>
</$macro>

<* The following two macros can help you build a navigation frame, like this:
 * <NAVTABLE JSCLICKS>
 * <NAVCELL>Page 1</NAVCELL>
 * <NAVCELL>Page 2</NAVECELL>
 * <NAVCELL><IMG SRC="foo.jpg" ALT="Page 3"></NAVCELL>
 * </NAVTABLE>
 *
 * If you use only text in cells, this will also adapt decently to horizontal
 * and vertical layouts.
 * If you set the table's JSCLICKS attribute, the NAVCELLs will try to call
 * some javascript functions to highlight themselves and respond to clicks
 * even if you don't hit the link inside. Like these:
 * function over(cell){cell.style.background='#2AC410';cell.style.cursor='hand';}
 * function out(cell){cell.style.background='#156208';}
 * function click(cell){ var t,i,o=cell.childNodes;
 *   for(i=0;o[i].nodeName!="A"&&i<o.length;i++);
 *   if((t=o[i].getAttribute("target")))
 *     eval("parent."+t+".location.href=o[i].getAttribute(\"href\");");
 *   else
 *     window.location.href=o[i].getAttribute("href");
 * }
 *>
<$macro NAVCELL /CLOSE /MBI="navtable" U:uri/R>
  <$if COND=(defined NAVTABLE_USE_JAVASCRIPT)>
    <$define _navclickcell:string/C='<TD onClick="click(this);" onMouseOver="over(this);" onMouseOut="out(this);">'>
  <$else>
    <$define _navclickcell:string/C='<TD>'>  
  </$if>  
  <$if COND=((PROJECT_FRAMES_NAVBAR_POS = "top") or
              (PROJECT_FRAMES_NAVBAR_POS = "t") or
              (PROJECT_FRAMES_NAVBAR_POS = "bottom") or
              (PROJECT_FRAMES_NAVBAR_POS = "b"))>
    <(_navclickcell)><HYPERLINK HREF=(U)><$content></HYPERLINK></TD>
  <$else>
    <TR><(_navclickcell)><HYPERLINK HREF=(U)><$content></HYPERLINK></TD></TR>
  </$if>
</$macro>

<$macro NAVTABLE /MBI="navigation_frame" /CLOSE JSCLICKS:bool>
  <$if COND=(set JSCLICKS)>
    <$define NAVTABLE_USE_JAVASCRIPT:bool>
  </$if>
  <TABLE CLASS="navframe" SUMMARY="navigation">
    <$if COND=((PROJECT_FRAMES_NAVBAR_POS = "top") or
                (PROJECT_FRAMES_NAVBAR_POS = "t") or
                (PROJECT_FRAMES_NAVBAR_POS = "bottom") or
                (PROJECT_FRAMES_NAVBAR_POS = "b"))>
      <TR><(Hsc.Content)></TR>
    <$else>  
      <(HSC.Content)>
    </$if>
  </TABLE>
</$macro>


<*-----------------------------------------------------------------------*>
<* GRAPHICS                                                              *>
<*-----------------------------------------------------------------------*>
<* This lets you insert a thumbnail picture in the current document,
 * automagically linked to the full-size picture. Specify the big image's name
 * as IMG, and the macro will assume the thumbnail has the same name with
 * "_tnail" added before the extension. NEWWIN opens the picture in a new
 * window, SIZE lets you add the full picture's size in kilobytes to either the
 * ALT text or the title.
 *
 * TODO: fix problem with absolute URIs
 *>
<$macro THUMBNAIL PIC:uri/R ALT:string/R TITLE:string NEWWIN:bool
        SIZE:enum("alt|title") [__IAlign]>
  <$define _tnailname:string/C=((basename (PIC))+"_tnail."+(extension (PIC)))>
  <$define _tnailpath:string/C=(HSC.DestPath + HSC.Document.Path + _tnailname)>
  <$define _imgpath:string/C=(HSC.DestPath + HSC.Document.Path + PIC)>
  <$define _tgt:string>
  <$define _alttxt:string=(ALT)>
  <$define _titletxt:string>
  <$if COND=(set NEWWIN)>
  	<$let _tgt="_blank">
  </$if>
  <$if COND=(set SIZE)>
    <$if COND=(SIZE = "alt")>
      <$let _alttxt=(_alttxt + " [" + GetFileSize(PIC)+"]")>
    <$else>
      <$if COND=(set TITLE)>
        <$let _titletxt=(TITLE + " [" + GetFileSize(PIC)+"]")>
      <$else>
        <$let _titletxt=(GetFileSize(PIC))>
      </$if>
    </$if>
  <$else>
  </$if>
  <$if COND=(not (fexists(_tnailpath)))>
    <$if COND=(not ((defined _AUTOTHUMB-SCALE) and (defined _AUTOTHUMB-MINDIM)))>
      <$message class=error text="Auto-generated thumbnails need _AUTOTHUMB-SCALE and _AUTOTHUMB-MINDIM set!">
    </$if>
    <$message class=note text=("No thumbnail for image " + PIC + ", generating...")>
    <PERL ARGS=(_imgpath + " " + _tnailpath + " " + _AUTOTHUMB-SCALE + " " +
                _AUTOTHUMB-MINDIM)>
    my $pix="";
    my ($img,$tnail,$scale,$mindim) = @ARGV;
    $scale /= 100;
    my ($picw,$pich) = (`anytopnm $img 2>/dev/null | pnmfile` =~ /(\d+) by (\d+)/);
    $pix = "-xsize=$mindim",$scale=$mindim/$picw if($mindim > $picw*$scale);
    $pix = "-ysize=$mindim" if($mindim > $pich*$scale);
    $scale="" if(length $pix);
    # TODO: allow for output formats other than JPEG
    system("anytopnm $img 2>/dev/null | pnmscale 2>/dev/null $scale $pix | ppmtojpeg 2>/dev/null -optimize -quality=60 -dct=float >$tnail");
    </PERL>
  </$if>
  <$if COND=(defined HSC.Opts.XHTML)>
    <$if COND=(set NEWWIN)>
      <$message class=warning text="Sorry, NEWWIN doesn't work in XHTML mode!">
    </$if>
    <A HREF=(PIC)>
  <$else>
    <A HREF=(PIC) TARGET?=_tgt>
  </$if>
  <IMG SRC=(_tnailname) ALT=(_alttxt) TITLE?=_titletxt ALIGN?=ALIGN></A>
</$macro>

<*-----------------------------------------------------------------------*>
<* LAYOUT / TeX-ALIKE                                                    *>
<*-----------------------------------------------------------------------*>
<* the following is needed by both the footnote and bibliography macros
   below. It wraps TEXT in TAG like this:
   TEXT="foo" TAG="H1"  ->  <H1>foo</H1> *>
<$macro _WRAP_STRING_IN_TAGS TEXT:string TAG:string>
  <$if COND=(set TEXT)>
    <$if COND=(set TAG)>
      <('<' + TAG + '>' + TEXT + '<' + '/' + TAG + '>' + HSC.LF)>
    <$else>
      <(TEXT + HSC.LF)>
    </$if>
  <$elseif COND=(set TAG)>
    <$message class=warning text="TAG is set, but no TEXT - ignored"> 
  </$if>
</$macro>

<*-------------------------------------*>

<* Footnotes LaTeX style! *>

<* FOOTNOTE is a container that inserts a superscripted number in place of its
 * contents, and appends the contents to a global variable (which is
 * created if nonexistant) instead, marked with a NAMEd anchor.
 * FOOTNOTES, inserted below in the document, will then interpolate this
 * variable as a numbered list.
*>
<$macro FOOTNOTE /CLOSE>
<$if COND=(defined the_footnote_counter)><$stripws>
  <$let the_footnote_counter=(the_footnote_counter & "1")><$stripws>
<$else><$stripws>
  <$define the_footnote_counter:num/GLOBAL=1><$stripws>
  <$define the_footnote_bucket:string/GLOBAL=''><$stripws>
</$if><$stripws>
<$define ftnname:string/CONST=('footnote' + the_footnote_counter)><$stripws>
<$let the_footnote_bucket = (the_footnote_bucket + '<LI><A NAME="' + ftnname +
  '"></A>' + Hsc.Content + '<_FOOTNOTE_BACKLINK NUM=' + the_footnote_counter +
  '></LI>' + HSC.LF)><$stripws>
<SMALL><SUP><A NAME=(ftnname + 'r')></A><A HREF=('#' + ftnname)><(the_footnote_counter)></A></SUP></SMALL><$stripws>
</$macro> 

<*-------------------------------------*>
<* this macro inserts all footnotes accumulated during the processing of the
   current document as an <OL>. The footnote bucket is emptied, just in
   case you should want several "foot"note sections in one HTML file
   See bibliography macro below for TITLE and TC!
*>
<$macro FOOTNOTES TITLE:string="Footnotes" TC:string="H1" RULERS:bool
        BACKLINK:bool>
  <* don't expand to anything if footnotes are not in use *>
  <$if COND=(defined the_footnote_bucket)>
    <$if COND=(set BACKLINK)>
      <$macro _FOOTNOTE_BACKLINK NUM:num/R>&nbsp;[<A HREF=('#footnote' + num + 'r')>back</A>]</$macro>
    <$else>
      <$macro _FOOTNOTE_BACKLINK NUM:num/R></$macro>
    </$if>
		<* allow special attributes to be set via CSS *>
    <DIV class="footnotes">
    <$if COND=(set RULERS)><HR></$if>
		<* either use project-global heading or convert arguments *>
		<$if COND=(defined PROJECT_FOOTNOTES_CAPTION)>
			<(PROJECT_FOOTNOTES_CAPTION)>
		<$else>
    	<_WRAP_STRING_IN_TAGS TEXT?=TITLE TAG?=TC>
		</$if>
    <* interpolate footnote bucket as entries in a numbered list *>
    <OL><(the_footnote_bucket)></OL></DIV>
    <$if COND=(set RULERS)><HR></$if>
    <$let the_footnote_bucket=''>
  </$if>
</$macro>

<*-------------------------------------*>
<* Some LaTeXish bibliography macros *>

<* Mainly a shortcut for some CSS stuff...
   TITLE is something like "Bibliography". For no title instead of the default
   (which can be set globally as PROJECT_BIBLIOGRAPHY_CAPTION), use "TITLE=''"
   TC is the optional "Title Container", i.e. usually some formatting
   stuff. Use TITLE="foo" TC="H3" for a result of <H3>foo</H3>
   TITLE may contain further tags or macros!
 *>
<$macro THEBIBLIOGRAPHY /CLOSE TITLE:string="Bibliography" TC:string="H1">
  <DIV class="bibliography">
  <$if COND=(defined PROJECT_BIBLIOGRAPHY_CAPTION)>
		<(PROJECT_BIBLIOGRAPHY_CAPTION)>
	<$else>
		<_WRAP_STRING_IN_TAGS TEXT?=TITLE TAG?=TC>
	</$if>
	<TABLE BORDER="0" SUMMARY?=TITLE>
	<$content>
	</TABLE></DIV>
</$macro>

<*-------------------------------------*>
<* This should be fairly self-explanatory. More typing of attribute names than
   the typical LaTeX bibitem, but with an automagically consistent look! *>
<$macro BIBITEM KEY:string/R AUTHOR:string/R DATE:string/R TITLE:string/R
        PLACE:string PUBLISHER:string TYPE:string EDITION:string>
<$define entry:string=(AUTHOR + ': <CITE>' + TITLE + '</CITE>')>
<$if COND=(set TYPE)><$let entry=(entry + '. ' + TYPE)></$if>
<$if COND=(set EDITION)><$let entry=(entry + ', ' + EDITION)></$if>
<$if COND=(set PLACE)><$let entry=(entry + '. ' + PLACE)></$if>
<$if COND=(set PUBLISHER)><$let entry=(entry + ', ' + PUBLISHER)></$if>
<$let entry=(entry + ': ' + DATE)>
<TR><TD CLASS="key"><A NAME=("bib_"+KEY)></A>[<(KEY)>]</TD>
<TD><(entry)></TD></TR> 
</$macro>

<*-------------------------------------*>
<* Use this to refer to a citation in the text. SRC must be set to the
   BIBITEM's KEY value; TEXT is what is to appear as a "link". Leave it unset
   to get a clickable citation key.
   If you have a separate bibliography page, put its URI in BIBFILE or the
   global variable PROJECT_BIBLIOGRAPHY_URI (if both are set, BIBFILE takes
   precedence!) *>
<$macro CITATION SRC:string/R TEXT:string BIBFILE:uri>
<$define _linkto:string=''>
<$define _linktext:string=''>
<$let _linktext?=TEXT>
<$if COND=(_linktext = '')><$let _linktext=(SRC)></$if>
<$if COND=(defined PROJECT_BIBLIOGRAPHY_URI)>
  <$let _linkto=(PROJECT_BIBLIOGRAPHY_URI)>
</$if>
<$let _linkto?=BIBFILE>
<A HREF=(_linkto + '#bib_' + SRC)>[<(_linktext)>]</A>
</$macro>

<*-------------------------------------*>
<* Table of contents *>
<* The following macros implement LaTeX-like sections. To activate them, call
 * <GIMME-LATEX-SECTIONS DOC=...>
 * somewhere at the start of your document. Depending on <doc>, the top-level
 * element will be either "section" or "chapter". To use special features of the
 * _TEX-SECTION macro like EXTRA (passes extra attributes to the opening tag of
 * the container around the section title, like <h2 class="red">) or HDRLEVEL
 * (allows you to change the container tag around the title, although this is
 * not recommended), write your own wrappers like below.
 * SEPCHAR sets the character to separate section numbers with; NUMSTYLE can be
 * any one documented below for _CONVERT-NUMBER-SYSTEM's SYS attribute, so you
 * can number alphabetically, roman, or even hexadecimal :)
 *>

<$macro GIMME-LATEX-SECTIONS /ONLYONCE DOC:enum("book|report|article")/R
        SEPCHAR:string NUMSTYLE:string BIAS:string>
  <$if COND=(DOC = "article")>
    <$macro SECTION       TITLE:string/R><_TEX-SECTION LEVEL=1 TITLE=(TITLE)></$macro>
    <$macro SUBSECTION    TITLE:string/R><_TEX-SECTION LEVEL=2 TITLE=(TITLE)></$macro>
    <$macro SUBSUBSECTION TITLE:string/R><_TEX-SECTION LEVEL=3 TITLE=(TITLE)></$macro>
    <$macro PARAGRAPH     TITLE:string/R><_TEX-SECTION LEVEL=4 TITLE=(TITLE)></$macro>
    <$macro SUBPARAGRAPH  TITLE:string/R><_TEX-SECTION LEVEL=5 TITLE=(TITLE)></$macro>
  <$else>
    <* same for book and report (PART is not supported) *>
    <$macro CHAPTER       TITLE:string/R><_TEX-SECTION LEVEL=1 TITLE=(TITLE)></$macro>
    <$macro SECTION       TITLE:string/R><_TEX-SECTION LEVEL=2 TITLE=(TITLE)></$macro>
    <$macro SUBSECTION    TITLE:string/R><_TEX-SECTION LEVEL=3 TITLE=(TITLE)></$macro>
    <$macro SUBSUBSECTION TITLE:string/R><_TEX-SECTION LEVEL=4 TITLE=(TITLE)></$macro>
    <$macro PARAGRAPH     TITLE:string/R><_TEX-SECTION LEVEL=5 TITLE=(TITLE)></$macro>
    <$macro SUBPARAGRAPH  TITLE:string/R><_TEX-SECTION LEVEL=6 TITLE=(TITLE)></$macro>
  </$if>
  <$if COND=(set SEPCHAR)>
    <$define PROJECT_SECTIONS_SEPCHAR:string/C/G=(SEPCHAR)>
  </$if>
  <$if COND=(set NUMSTYLE)>
    <$define PROJECT_SECTIONS_NUMSTYLE:string/C/G=(NUMSTYLE)>
  </$if>
  <$if COND=(set BIAS)>
    <$define _bias1:string><$define _bias2:string><$define _bias3:string>
    <$define _bias4:string><$define _bias5:string><$define _bias6:string>
    <$define _l:num='0'><$define _m:num='1'>
    <WHILE COND="not (BIAS == '')">
      <$let _l = (_l & '1')>
      <$let {_bias + _l} = (extension BIAS)>
      <$let BIAS = (basename BIAS)>
      <$message class=warning text=('XBIAS: _bias' + _l + '=' + {_bias + _l} + ', BIAS=' + BIAS)>
    </WHILE>
    <WHILE COND="not (_l == '0')">
      <$let {'the_section' + _m + '_counter'} = {_bias + _l}>
      <$message class=warning text=('BIAS: ' + 'the_section' + _m + '_counter=' + {'the_section' + _m + '_counter'})>
      <$let _l = (_l - '1')>
      <$let _m = (_m & '1')>
    </WHILE>
  </$if>
</$macro>

<* This is what the actual section macros are based on. It's a general
 * sectioning macro with unlimited stacking depth.
 *>
<$macro _TEX-SECTION LEVEL:num TITLE:string EXTRA:string HDRLEVEL:string>
	<$define sectnum:string=''>
	<$define ctrname:string=('the_section' + LEVEL + '_counter')>
  <$define styledctr:string=''>

	<* this section's number *>
	<$define hlvl:string>
	<* headerlevel is either defined explicitely or "Hx" where 1<=x<=6 *>
	<$if COND=(set HDRLEVEL)>
		<$let hlvl=(HDRLEVEL)>
	<$else>
		<$if COND=((LEVEL < '1') or (LEVEL > "6"))>
			<$message class=error text="LEVEL must be between 1 and 6 for current HTML versions!">
		</$if>
		<$let hlvl=('H' + LEVEL)>
	</$if>

  <* add extra attributes if there are any defined *>
	<$if COND=(set EXTRA)>
		<$define open_hdr:string=("<" + hlvl + ' ' + EXTRA + ">")>
	<$else>
		<$define open_hdr:string=("<" + hlvl + ">")>
	</$if>
	<* simpler: the closing tag *>
	<$define close_hdr:string=("<" + "/" + hlvl + ">")>

	<* add to the current counter *>
	<(
    "<$if COND=(defined " + ctrname + ")>" +
      "<$let " + ctrname + "=(" + ctrname + " & '1')>" +
    "<$else>" +
      "<$define " + ctrname + ":num/GLOBAL='1'>" +
    "</$if>"
   )>

	<* make sure all higher-level counters exist *>
	<FOR VAR=i START=1 TO=(LEVEL - "1")>
    <(
      "<$if COND=(not defined the_section" + i + "_counter)>" +
        "<$define the_section" + i + "_counter:num/GLOBAL='1'>" +
      "</$if>"
    )>
  </FOR>

	<* zero all lower-level counters if there are any defined *>
	<FOR VAR=i START=(LEVEL & "1") TO="6">
    <$if COND=(defined {"the_section" + i + "_counter"})>
      <$let {"the_section" + i + "_counter"}='0'>
    </$if>
	</FOR>

	<* concatenate the actual counters, potentially converted according to the
   * current NUMSTYLE and separated by periods or SEPCHARs *>
	<FOR VAR=i START=1 TO=(LEVEL)>
		<$if COND=(i > "1")>
      <$if COND=(defined PROJECT_SECTIONS_SEPCHAR)>
			  <$let sectnum = (sectnum + PROJECT_SECTIONS_SEPCHAR)>
      <$else>
			  <$let sectnum = (sectnum + '.')>
      </$if>
		</$if>
    <$if COND=(defined PROJECT_SECTIONS_NUMSTYLE)>
      <_CONVERT-NUMBER-SYSTEM N={"the_section" + i + "_counter"} DEST="styledctr"
                             SYS=(PROJECT_SECTIONS_NUMSTYLE)>
    <$else>
      <$let styledctr={"the_section" + i + "_counter"}>
    </$if>
    <$let sectnum=(sectnum + styledctr)>
	</FOR>

	<* insert the counter string and title at current location *>
 	<( open_hdr + '<A NAME="hscsectname' + sectnum + '">' +
     sectnum + "</A>&nbsp;" +  TITLE + close_hdr )>

	<* if we want a table of contents, do this *>
	<$if COND=(defined PROJECT_GENERATE_TOC)>
		<* just write a single macro call to the TOC file. this gets expanded
       when TABLE-OF-CONTENTS reads in the file! *>
		<$export FILE=(HSC.Source.Path + (basename (HSC.Source.Name)) + ".toc")
             APPEND DATA=("<TABLE-OF-CONTENTS-ENTRY LEVEL=" + LEVEL +
             " NUMBER='" + sectnum + "' TITLE='" + TITLE + "'>" + HSC.LF)>
	</$if>
</$macro>

<*-------------------------------------*>
<* This macro converts a positive numeric value N to one of several numbering
 * systems SYS and stores the result in DEST:
 * numeric   : no conversion
 * decimal   : same as numeric
 * loweralpha: lowercase letters; a, b, c, ..., z, aa, ab,...
 * upperalpha: uppercase letters; A, B, C, ..., Z, AA, AB,...
 * alpha     : same as loweralpha
 * lowerroman: lowercase roman numerals: i, ii, iii, iv, v, vi, ...
 * upperroman: uppercase roman numerals: I, II, III, IV, V, VI, ...
 * roman     : same as upperroman
 * lowerhex  : lowercase hexadecimal: 1, 2, 3, ..., a, b, ..., f, 10, 11, ...
 * upperhex  : uppercase hexadecimal: 1, 2, 3, ..., A, B, ..., F, 10, 11, ...
 * hex       : same as lowerhex
 *>
<$macro _CONVERT-NUMBER-SYSTEM SYS:string/R DEST:string/R N:num/R>
  <$let {DEST} = ''>

  <$if COND=((SYS = 'numeric') or (SYS = 'decimal'))>
    <$let {DEST}=(N)>

  <$elseif COND=((SYS = 'roman') or (SYS = 'lowerroman') or (SYS = 'upperroman'))>
    <$if COND=(SYS = 'upperroman')>
      <$define _m:string/C='M'><$define _d:string/C='D'><$define _c:string/C='C'>
      <$define _l:string/C='L'><$define _x:string/C='X'><$define _v:string/C='V'>
      <$define _i:string/C='I'>
    <$else>
      <$define _m:string/C='m'><$define _d:string/C='d'><$define _c:string/C='c'>
      <$define _l:string/C='l'><$define _x:string/C='x'><$define _v:string/C='v'>
      <$define _i:string/C='i'>
    </$if>
    <$if COND=(N > '0')>
      <WHILE COND="N > '0'">
        <$if     COND=(N >= '1000')>
          <$let {DEST} = ({DEST} + _m)>     <$let N = (N - '1000')>
        <$elseif COND=(N >=  '900')>
          <$let {DEST} = ({DEST} + _c + _m)><$let N = (N -  '900')>
        <$elseif COND=(N >=  '500')>
          <$let {DEST} = ({DEST} + _d)>     <$let N = (N -  '500')>
        <$elseif COND=(N >=  '400')>
          <$let {DEST} = ({DEST} + _c + _d)><$let N = (N -  '400')>
        <$elseif COND=(N >=  '100')>
          <$let {DEST} = ({DEST} + _c)>     <$let N = (N -  '100')>
        <$elseif COND=(N >=   '90')>
          <$let {DEST} = ({DEST} + _x + _c)><$let N = (N -   '90')>
        <$elseif COND=(N >=   '50')>
          <$let {DEST} = ({DEST} + _l)>     <$let N = (N -   '50')>
        <$elseif COND=(N >=   '40')>
          <$let {DEST} = ({DEST} + _x + _l)><$let N = (N -   '40')>
        <$elseif COND=(N >=   '10')>
          <$let {DEST} = ({DEST} + _x)>     <$let N = (N -   '10')>
        <$elseif COND=(N >=    '9')>
          <$let {DEST} = ({DEST} + _i + _x)><$let N = (N -    '9')>
        <$elseif COND=(N >=    '5')>
          <$let {DEST} = ({DEST} + _v)>     <$let N = (N -    '5')>
        <$elseif COND=(N >=    '4')>
          <$let {DEST} = ({DEST} + _i + _v)><$let N = (N -    '4')>
        <$else>
          <$let {DEST} = ({DEST} + _i)>     <$let N = (N -    '1')>
        </$if>
      </WHILE>
    </$if>

  <$elseif COND=((SYS = 'hex') or (SYS = 'lowerhex') or (SYS = 'upperhex'))>
    <$define _q:num>
    <$define _r:num>
    <WHILE COND="N > '0'">
      <$let _q = (N / '16')>
      <$let _r = (N - (_q * '16'))>
      <$if COND=(_r >= '10')>
        <$if COND=(SYS = 'upperhex')>
          <$let {DEST}=(chr(ord('A') & _r - '10') + {DEST})>
        <$else> <* lowerhex or hex *>
          <$let {DEST}=(chr(ord('a') & _r - '10') + {DEST})>
        </$if>
      <$else>
        <$let {DEST}=(_r + {DEST})>
      </$if>
      <$let N=(_q)>
    </WHILE>

  <$elseif COND=((SYS = 'alpha') or (SYS = 'loweralpha') or (SYS = 'upperalpha'))>
     <WHILE COND="N > '0'">
      <$let N=(N - '1')>
      <$if COND=(SYS = "upperalpha")>
        <$let {DEST}=((CHR((N MOD '26') & ORD("A"))) + {DEST})>
      <$else> <* loweralpha or alpha *>
        <$let {DEST}=((CHR((N MOD '26') & ORD("a"))) + {DEST})>
      </$if>
      <$let N = (N / '26')>
    </WHILE>

  <$else>
    <$message class=warning text=("Unknown numbering system '" + SYS + "', using 'numeric'!")>
    <$let {DEST}=(N)>
  </$if>
</$macro>

<*-------------------------------------*>
<* this macro will only be used in TOC-files written by the above macros
 * LEVEL:  this entry's logical heading level
 * NUMBER: section number
 * TITLE:  section title
 *
 * TODO: extend the whole system to allow for global TOC pages... (numbering?)
 * TODO: output TOCs for inclusion as navigation menus
 *>
<$macro TABLE-OF-CONTENTS-ENTRY
				LEVEL:num/R NUMBER:string/R TITLE:string/R>
<* Distinguish between the TABLE-OF-CONTENTS environment and
   TABLE-OF-CONTENTS-LINKS in HEADER *>
<$if COND=(defined the_toc)>
  <* assign a style to the current row if text sizes should be adapted *>        
  <$if COND=(defined _TOC_USE_TEXT_SIZES)>
    <$if COND=(LEVEL = "1")>
      <$define _tocentry:string='<TR STYLE="font-size:x-large">'>
    <$elseif COND=(LEVEL = "2")>
      <$define _tocentry:string='<TR STYLE="font-size:large">'>
    <$elseif COND=(LEVEL = "3")>
      <$define _tocentry:string='<TR STYLE="font-size:medium">'>
    <$else>
      <$define _tocentry:string='<TR STYLE="font-size:small">'>
    </$if>  
  <$else>
    <$define _tocentry:string='<TR>'>
  </$if>
  
  <* update max_toc_level (must be defined in TABLE-OF-CONTENTS!) *>
  	<$if COND=(max_toc_level < LEVEL)><$let max_toc_level=(LEVEL)></$if>
  <* emit an empty cell for indentation according to level *>
    <$if COND=(LEVEL > "1")>
      <$let _tocentry = (_tocentry +
       '<TD ALIGN="left" COLSPAN="' + (LEVEL - "1") + '"></TD>')>
    </$if>
  <* add section number *>
  	<$let _tocentry = (_tocentry + '<TD>' + NUMBER + '</TD>')>
  <* make a cell that stretches to the right of the table *>
  	<$let _tocentry = (_tocentry +
     '<TD COLSPAN=(max_toc_level - "'+(LEVEL - "1")+'")>')>
  <* emit a link, add title, close anchor, cell and row *>
  	<$let _tocentry = (_tocentry + '<A HREF="#hscsectname' + NUMBER + '">' + TITLE)>
  	<$let _tocentry = (_tocentry + '</A></TD></TR>' + HSC.LF)>
  	<* add _tocentry to the actual TOC string *>
    <* we have to delay the actual TOC creation until after all
     * TABLE-OF-CONTENTS-ENTRY macros have been processed, so max_toc_level has
     * its final value, therefore everything has to go into the_toc first!  *>
  	<$let the_toc = (the_toc + _tocentry)>
<$else>
  <$let the_toclinks = (the_toclinks + '<LINK REL="section" HREF="#hscsectname' +
    NUMBER + '" TITLE="' + TITLE + '">' + HSC.LF)>
</$if>
</$macro>

<*-------------------------------------*>
<* This emits the actual table of contents in a nice TeXy format :-)
 * If your TOC-file is neither called <srcname>.toc nor defined in
 * PROJECT_TOC_FILE, you may specify it as FILE. "TITLE" should be
 * self-explanatory.
 * TEXTSIZE make the TOC use bigger fonts for levels 1 and 2, which is
 * non-standard but may look nice in places anyway.
 * If your TOC is above the actual text, you will have to rerun HSC
 * if you change anything about the sections to see the changes in the TOC. If
 * the TOC file is missing on the first run, you will get a warning.
 *>
<$macro TABLE-OF-CONTENTS TITLE:string FILE:string TEXTSIZE:bool>
	<$define max_toc_level:num=1>
	<$define the_toc:string=''>
	<$define tocfile:string>

	<$if COND=(defined PROJECT_GENERATE_TOC)>
    <$if COND=(set TEXTSIZE)>
     <$define _TOC_USE_TEXT_SIZES:bool>
    </$if>

		<$if COND=(set FILE)>
			<$let tocfile=(FILE)>
		<$elseif COND=(defined PROJECT_TOC_FILE)>
			<$let tocfile=(PROJECT_TOC_FILE)>
		<$else>
			<$let tocfile=(HSC.Source.Path + (basename (HSC.Source.Name)) + '.toc')>
		</$if>

		<$if COND=(Exists(tocfile))>
		<* include file with some TABLE-OF-CONTENTS-ENTRY macros and expand them *>
			<$include FILE=(tocfile)>
		<$else>
			<$define errormsg:string="Missing TOC file - rerun HSC to get it right!">
			<$let the_toc=("<TR><TD>" + errormsg + "</TD></TR>")>
			<$message class=warning text=(errormsg)>
		</$if>
		<* now expand the actual TOC in a context where max_toc_level has its
			 final value already *>
		<TABLE CLASS="table_of_contents" BORDER="0" SUMMARY="Table of Contents">
		<$if COND=(set TITLE)>
			<TR><TH COLSPAN=(max_toc_level & "1") ALIGN="left"><(TITLE)></TH></TR>
		</$if>
		<(the_toc)>
		</TABLE>
		<* get rid of the TOC file *>
		<HSC_SYSCMD_RMFILE FILE=(tocfile)>
	</$if>
</$macro>

<*-----------------------------------------------------------------------*>
<* HIERARCHICAL NAVIGATION MENUS                                         *>
<*-----------------------------------------------------------------------*>

<* MENUITEMs link to a certain page from a hierarchical menu. The URI to link to
 * must be given by HREF; TEXT is the text to appear as a link. HREF must
 * currently be a project-relative URI, i.e. start in ':'.
 * NOTE: Due to the way TOPMENU works, MENUITEMS must not contain anything but
 * SUBMENUs!
 *>
<$macro MENUITEM /CLOSE /MBI="topmenu|submenu" HREF:uri/R TEXT:string/R
        TITLE:string='__HSC_NO_TITLE__'>
  <$let _menu-rel-uri=(":" + HSC.Document.URI)>
  <* increment the item counter for the current menu level *>
  <$let {"_menu-itemctr"+_menu-level} = ({"_menu-itemctr"+_menu-level} & '1')>
  <$if cond=(_menu-try)>
    <* just do the checks, don't output any text *>
    <$if cond=({'_menu-expand' + _menu-level} = '0')>
      <* if no expansion has been found yet for the current level *>
      <$if cond=(_menu-rel-uri = HREF)>
        <* if HREF matches the current document's URI *>
        <* remember to expand the current level submenu and highlight the
           current item *>
        <$let {'_menu-expand' + _menu-level} = {'_menu-itemctr' + _menu-level}>
        <$let {'_menu-hilite' + _menu-level} = {'_menu-itemctr' + _menu-level}>
      </$if>
      <(hsc.content)>
      <* propagate the expansion request upwards *>
      <$if cond=({'_menu-expand' + _menu-level} =
                 {'_menu-itemctr'+_menu-level})>
        <$let {'_menu-expand'+(_menu-level - '1')} =
              {'_menu-itemctr'+(_menu-level - '1')}>
      </$if>
    </$if>
  <$else>
    <* this generates the real menu in the second expansion *>
    <$if cond=({'_menu-hilite'+_menu-level}={"_menu-itemctr"+_menu-level})>
      <* the current item wants to be highlighted *>
      <(_activelinktagopen)><$stripws><(TEXT)><$stripws><(_activelinktagclose)>
    <$else>
      <* a regular item, visible but not active *>
      <_MENUITEM-TAG TITLE=(TITLE)><a href=(HREF)><(TEXT)></a>
    </$if>
    <$stripws>
    <$if COND=(MENUKIND = "div")>
      <* <p><div>...</div></p> is illegal, so the <p> has 2b closed b4 *>
      <_MENUITEM-TAG CLOSE>
      <(hsc.content)>
    <$elseif COND=(MENUKIND = "list")>
      <* UL may only contain LI, not UL outside of an LI *>
      <(hsc.content)>
      <_MENUITEM-TAG CLOSE>
    <$else>
      <* must be TABLE menukind *>
      <(hsc.content)>
      <_MENUITEM-TAG CLOSE>
    </$if>
  </$if>
</$macro>

<* This opens a new menu. The maximum submenu level is given by
 * MAXNESTDEPTH with a default of 4, which should be plenty for normal
 * applications.
 * The attributes:
 * MENUKIND defines the kind of menu to build. Currently, nested lists and
 *          DIVs are supported. Lists handle the indentation of lower menu
 *          levels automagically, but the style applied to remove annoying
 *          bullet points may give strange results on older browsers such as
 *          Netscape 4.x. Nested DIVs should be combined with AUTOCLASS to
 *          get the appropriate indentation style. You may also want to
 *          reduce the margins for paragraphs in this context.
 *          Note: HTML's MENU tag is deprecated and thus not supported.
 *          Note: TABLE-based menus are possible now, but don't work as they
 *          should yet!
 * MENUSTYLE gives an extra STYLE attribute to apply to the whole
 *           (top-level, inherited downwards) menu, e.g. to set the font size.
 * AUTOCLASS gives every menu level its own class, using the prefix specified
 *           here, with a numeric suffix of 1..MAXNESTDEPTH.
 * MENUCLASS gives a certain CLASS attribute to this menu only
 * ITEMHLSTYLE specifies a style to apply to menuitems that get highlighted to
 *             show the user the position in the menu hierarchy corresponding
 *             to the current page. "background-color:#fff" or something...
 * ITEMHLEXTRA holds extra attributes to be added to items that should be
 *             highlighted.
 * HILITELINK gives the ITEMHLSTYLE only to the link tag, not to the entire
 *            menuitem
 * NOLINKCURRENT (set by default!) makes the entry for the current page a simple
 *               text instead of an anchor.
 * JSCLICKS makes enclosed MENUITEMs add an 'onClick="menuclick(this)"'
 *          attribute
 * 
 * TOPMENUs may only contain MENUITEMs, which in turn may contain further
 * SUBMENUs. 
 *>
<$macro TOPMENU /CLOSE /MBI="body" /NAW="topmenu"
        MAXNESTDEPTH:num='4' MENUKIND:enum("list|div|table")="div"
        MENUSTYLE:string='' ITEMHLSTYLE:string ITEMHLEXTRA:string=""
        HILITELINK:bool AUTOCLASS:string MENUCLASS:string=''
        NOLINKCURRENT:bool='1' JSCLICKS:bool>
  <$define _menu-try:bool='1'>
  <$define _menu-level:num='1'>
  <$define _menu-rel-uri:uri>
  <$define _activelinktagopen:string>
  <$define _activelinktagclose:string>

  <$let MAXNESTDEPTH=(MAXNESTDEPTH & '1')>
  <* define arrays for item counters, menu expansion and highlighting *>
  <$define _arraycode:string>
  <_MAKE_ARRAYCODE N=(MAXNESTDEPTH) P=_menu-itemctr TYPE=num
                   VAR=_arraycode DEFAULT='0'> 
  <(_arraycode)>
  <_MAKE_ARRAYCODE N=(MAXNESTDEPTH) P=_menu-expand TYPE=num
                   VAR=_arraycode DEFAULT='0'> 
  <(_arraycode)>
  <_MAKE_ARRAYCODE N=(MAXNESTDEPTH) P=_menu-hilite TYPE=num
                   VAR=_arraycode DEFAULT='0'> 
  <(_arraycode)>

  <$if COND=(NOLINKCURRENT)>
    <$if COND=(set HILITELINK)>
      <$let _activelinktagopen='<("<_MENUITEM-TAG TITLE=(TITLE)><span style?=ITEMHLSTYLE " + ITEMHLEXTRA + ">")>'>
      <$let _activelinktagclose = '</span>'>
    <$else>
      <$let _activelinktagopen=('<("<_MENUITEM-TAG TITLE=(TITLE) STYLE?=ITEMHLSTYLE EXTRA=' + "'" + '" + ITEMHLEXTRA + "' + "'" + '>")>')>
      <$let _activelinktagclose = ''>
    </$if>
  <$else>
    <$if COND=(set HILITELINK)>
      <$let _activelinktagopen='<("<_MENUITEM-TAG TITLE=(TITLE)><a href=(HREF) style?=ITEMHLSTYLE " + ITEMHLEXTRA + ">")>'>
    <$else>
      <$let _activelinktagopen=('<("<_MENUITEM-TAG TITLE=(TITLE) STYLE?=ITEMHLSTYLE EXTRA=' + "'" + '" + ITEMHLEXTRA + "' + "'" + '><a href=(HREF)>")>')>
    </$if>
    <$let _activelinktagclose = '</a>'
  </$if>

  <* expand content once with _menu-try set *>
  <(hsc.content)>
  <* reset some variables *>
  <$let _menu-try=''>
  <$let _menu-level='1'>
  <FOR VAR=i START=0 TO=(MAXNESTDEPTH - '1')>
    <$let {"_menu-itemctr" + i}='0'>
  </FOR>
  <* open a new menu and expand everything anew, with _menu-try reset *>
  <_SUBMENU-TAG>
  <(hsc.content)>
  <_SUBMENU-TAG CLOSE>
</$macro>

<* A SUBMENU may occur inside a MENUITEM and contain more MENUITEMs. See
 * TOPMENU for a description of MENUSTYLE/MENUCLASS
 *>
<$macro SUBMENU /CLOSE /MBI="menuitem" MENUSTYLE:string='' MENUCLASS:string=''>
  <* increase the current menu level for per-level counter etc. *>
  <$let _menu-level=(_menu-level & '1')>
  <* if we're just trying, simply expand all contents *>
  <$if cond=(_menu-try)>
    <(hsc.content)>
  <$else>
    <* only expand contents if _menu-expand<n-1> is our parent item's number *>
    <$if cond=({"_menu-expand" + (_menu-level - '1') } =
               {"_menu-itemctr" + (_menu-level - '1')})>
      <* put everything into an unsorted list *>
      <_SUBMENU-TAG>
      <(hsc.content)>
      <_SUBMENU-TAG CLOSE>
    </$if>
  </$if>
  <* zero the item counter for further submenus on the same level *>
  <$let {"_menu-itemctr" + _menu-level}='0'>
  <$let _menu-level=(_menu-level - '1')>
</$macro>

<* Helper macros: generate submenu/item tags. They could be containers but
 * rather provide CLOSE attributes to avoid excessively deep container macro
 * nesting and consequent debugging problems.
 *>
<$macro _SUBMENU-TAG CLOSE:bool>
  <* set the tag according to the desired MENUKIND *>
  <$if COND=(MENUKIND = "list")>
    <$define _tag:string="ul">
  <$elseif COND=(MENUKIND = "div")>
    <$define _tag:string="div">
  <$else>
    <$define _tag:string="table">
  </$if>

  <* add appropriate closing slash or STYLE/CLASS attributes *>
  <$if COND=(set CLOSE)>
    <$let _tag = ("<" + "/" + _tag)>
  <$else>
    <$let _tag = ("<" + _tag)>
    <* MENUSTYLE has an empty default to allow for nesting SUBMENU macros *>
    <$if COND=(not (MENUSTYLE = ''))>
      <$let _tag=(_tag + ' STYLE="' + MENUSTYLE + '"')>
    </$if>
    <$if COND=((not (MENUCLASS = '')) or (set AUTOCLASS))>
      <$if COND=(not (MENUCLASS = ''))>
        <$let _tag=(_tag + ' CLASS="' + MENUCLASS + '"')>
      <$else>
        <$let _tag=(_tag + ' CLASS="' + AUTOCLASS + _menu-level + '"')>
      </$if>
    </$if>
  </$if>

  <* this actually yields the tag :) *>
  <(_tag + ">")>
</$macro>

<$macro _MENUITEM-TAG CLOSE:bool STYLE:string TITLE:string='__HSC_NO_TITLE__' EXTRA:string=''>
  <$define _menuitem_tag:string>
  <$define _menuitem_tagopen:string>
  <$define _menuitem_attrs:string="">
  <$if COND=(set CLOSE)>
    <$let _menuitem_tagopen="</">
    <$if COND=(MENUKIND = "table")>
      <* table cells need special treatment as they need more than one tag *>
      <$let _menuitem_tag=("<" + "/td><" + "/tr")>
    </$if> 
  <$else>
    <$let _menuitem_tagopen="<">
    <$if COND=(set STYLE)>
      <$let _menuitem_attrs=(' STYLE="' + STYLE + '"' + EXTRA)>
    </$if>
    <$if COND=(not (TITLE = '__HSC_NO_TITLE__'))>
      <$let _menuitem_attrs=(_menuitem_attrs + ' TITLE="' + TITLE + '"')>
    </$if>
    <$if COND=(set JSCLICKS)>
      <$let _menuitem_attrs=(_menuitem_attrs + ' onClick="menuclick(this)"')>
    </$if>
    <$if COND=(MENUKIND = "table")>
      <$let _menuitem_tag="<tr><td">
    </$if> 
  </$if>
  <* list-kind menus get LI items, DIVs get Ps, TABLEs are treated above *>
  <$if COND=(MENUKIND = "list")>
    <$let _menuitem_tag=(_menuitem_tagopen + "li")>
  <$elseif COND=(MENUKIND = "div")>
    <$let _menuitem_tag=(_menuitem_tagopen + "p")>
  </$if>

  <* expand to tag *>
  <(_menuitem_tag + _menuitem_attrs + ">")>
</$macro>

<*-----------------------------------------------------------------------*>
<* DYNAMIC LAYOUT: COLUMNS AND GROUPS                                    *>
<*-----------------------------------------------------------------------*>

<*-------------------------------------*>
<* Dynamic layout with tables: use ROWGROUP or COLUMNGROUP to layout
 * arbitrarily many HTML objects of any kind in a regular grid:
 * <ROWGROUP NELEMS=3>
 *   <GROUPENTRY><IMG SRC="i1"></GROUPENTRY>
 *   <GROUPENTRY><IMG SRC="i2"></GROUPENTRY>
 *   <GROUPENTRY><IMG SRC="i3"></GROUPENTRY>
 *   <GROUPENTRY><IMG SRC="i4"></GROUPENTRY>
 *   <GROUPENTRY><IMG SRC="i5"></GROUPENTRY>
 * </ROWGROUP>
 * yields this layout:
 *   i1 i4
 *   i2 i5
 *   i3
 * while COLUMNGROUP would put them like this:
 *   i1 i2 i3
 *   i4 i5
 *
 * To start a new row/column respectively, use the COLUMNGROUP-NEWROW
 * and ROWGROUP-NEWCOLUMN macros.
 *>
<$macro ROWGROUP /CLOSE NELEMS:num/R PAD:num BORDER:num STYLE:string
                        CLASS:string>
	<$if COND=(NELEMS = '0')><$message class=fatal text="NELEMS must not be zero!"></$if>

  <* the group level will be used in GROUPENTRY to deal with nested groups *>
	<$if COND=(not (defined _the_group_level))>
		<$define _the_group_level:string='1'>
    <$define _the_group_nelems:num=(NELEMS)>
    <$define _the_group_counter:num=(NELEMS)>
	  <$define _the_group_columnwise:bool=''>
	  <$define _the_group_arrayprefix:string=''>
	  <$define _the_group_newrow:bool=''> <* only for nested COLUMNGROUPs *>
	  <$define _groupentry_celltype:string=''> <* used in GROUPENTRYs *>
	<$else>
		<$let _the_group_level=(_the_group_level & '1')>
    <("<$define _the_group_nelems" + _the_group_level + ":num=(_the_group_nelems)>")>
    <("<$define _the_group_counter" + _the_group_level + ":num=(_the_group_counter)>")>
	  <("<$define _the_group_columnwise" + _the_group_level + ":bool=(_the_group_columnwise)>")>
	  <("<$define _the_group_arrayprefix" + _the_group_level + ":string=(_the_group_arrayprefix)>")>
	  <("<$define _groupentry_celltype" + _the_group_level + ":string=(_groupentry_celltype)>")>
    <$let _the_group_nelems=(NELEMS)>
    <$let _the_group_counter=(NELEMS)>
	  <$let _the_group_columnwise=''>
	</$if>

  <* construct prefix for the row array according to level *>
	<$let _the_group_arrayprefix=("_rowgroup_l" + _the_group_level + "r")>

  <* create variables <prefix>0 .. <prefix><NELEMS> *>
  <(DEFARRAY_PRE)>
  <DEFARRAY_MAIN N=(NELEMS) P=(_the_group_arrayprefix) DEFAULT=''>
  <(DEFARRAY_POST)>

  <* insert all GROUPENTRYs, which will only add text to array vars! *>
  <(HSC.Content)>

  <* start the layout table *>
  <TABLE CELLPADDING?=PAD BORDER?=BORDER SUMMARY="rowgroup-layout" CLASS?=CLASS>

  <* now emit all rows previously accumulated in the array *>
	<FOR VAR=("_rowgrp_emitctr" + _the_group_level)
       START=0 TO=(_the_group_nelems - '1')>
    <TR>
      <({_the_group_arrayprefix + {"_rowgrp_emitctr" + _the_group_level}})>
    </TR>
	</FOR>
  </TABLE>

  <$if COND=(_the_group_level > '1')>
    <$let _the_group_nelems={"_the_group_nelems" + _the_group_level}>
    <$let _the_group_counter={"_the_group_counter" + _the_group_level}>
	  <$let _the_group_columnwise={"_the_group_columnwise" + _the_group_level}>
	  <$let _the_group_arrayprefix={"_the_group_arrayprefix" + _the_group_level}>
	  <$let _groupentry_celltype={"_groupentry_celltype" + _the_group_level}>
  </$if>
  <$let _the_group_level=(_the_group_level - '1')>
</$macro>

<*-------------------------------------*>
<$macro COLUMNGROUP /CLOSE NELEMS:num/R PAD:num BORDER:num CLASS:string>
	<$if COND=(NELEMS = '0')>
    <$message class=fatal text="NELEMS must not be zero!">
  </$if>

	<$if COND=(not (defined _the_group_level))>
		<$define _the_group_level:string='1'>
    <$define _the_group_nelems:num=(NELEMS)>
    <$define _the_group_counter:num=(NELEMS)>
	  <$define _the_group_columnwise:bool='1'>
	  <$define _the_group_newrow:bool='1'> <* force new row on 1st element *>
	  <$define _the_group_arrayprefix:string=''> <* only for nested ROWGROUPs *>
	  <$define _groupentry_celltype:string=''> <* used in GROUPENTRYs *>
	<$else>
		<$let _the_group_level=(_the_group_level & '1')>
    <("<$define _the_group_nelems" + _the_group_level + ":num=(_the_group_nelems)>")>
    <("<$define _the_group_counter" + _the_group_level + ":num=(_the_group_counter)>")>
	  <("<$define _the_group_columnwise" + _the_group_level + ":bool=(_the_group_columnwise)>")>
	  <("<$define _the_group_newrow" + _the_group_level + ":bool=(_the_group_newrow)>")>
	  <("<$define _groupentry_celltype" + _the_group_level + ":string=(_groupentry_celltype)>")>
    <$let _the_group_nelems=(NELEMS)>
    <$let _the_group_counter=(NELEMS)>
	  <$let _the_group_columnwise='1'>
	  <$let _the_group_newrow='1'>
	</$if>

  <TABLE CELLPADDING?=PAD BORDER?=BORDER SUMMARY="columngroup-layout"
         CLASS?=CLASS>
    <(HSC.Content +
      "<$if COND=(_the_group_counter <> _the_group_nelems)></TR></$if>")>
  </TABLE>

  <$if COND=(_the_group_level > '1')>
    <$let _the_group_nelems={"_the_group_nelems" + _the_group_level}>
    <$let _the_group_counter={"_the_group_counter" + _the_group_level}>
	  <$let _the_group_columnwise={"_the_group_columnwise" + _the_group_level}>
	  <$let _the_group_newrow={"_the_group_newrow" + _the_group_level}>
	  <$let _groupentry_celltype={"_groupentry_celltype" + _the_group_level}>
  </$if>
  <$let _the_group_level=(_the_group_level - '1')>
</$macro>

<*-------------------------------------*>
<$macro GROUPENTRY /CLOSE /MBI="rowgroup|columngroup" HEAD:bool>

  <* decide whether we want data cells or table headers *>
  <$if COND=(HEAD)>
    <$let _groupentry_celltype="TH">
  <$else>
    <$let _groupentry_celltype="TD">
  </$if>

  <* distinguish between row and column layouts *>
	<$if COND=(_the_group_columnwise)>

    <* if a new row has to be started, emit <TR> and reset flag *>
	  <$if COND=(_the_group_newrow)>
		  <TR><$let _the_group_newrow=''>
  	</$if>

    <* simply put the contents into a table cell or header *>
	  <_WRAP_STRING_IN_TAGS TAG=(_groupentry_celltype) TEXT=(Hsc.Content)>

    <* decrement element counter *>
		<$let _the_group_counter=(_the_group_counter - '1')>

    <* check for end of row *>
		<_COLUMNGROUP_CHECKENDROW>

	<$else>

    <* if the element counter has expired, just reset it *>
	  <$if COND=(_the_group_counter = '0')>
		  <$let _the_group_counter=(_the_group_nelems)>
  	</$if>

    <* decrement element counter *>
		<$let _the_group_counter=(_the_group_counter - '1')>

    <* add macro contents to current row's array variable *>
    <$let {_the_group_arrayprefix +
           ((_the_group_nelems - _the_group_counter) - '1')} =
          ({_the_group_arrayprefix +
           ((_the_group_nelems - _the_group_counter) - '1')} +
          "<" + _groupentry_celltype + ">" + HSC.Content +
          "<" + "/" + _groupentry_celltype + ">")>
	</$if>
</$macro>




<* This is highly experimental... *>
<$macro COLUMNGROUP-NG /CLOSE NELEMS:num/R CLASS:string>
	<$if COND=(NELEMS = '0')>
    <$message class=fatal text="NELEMS must not be zero!">
  </$if>

	<$if COND=(not (defined _the_group_level))>
		<$define _the_group_level:string='1'>
    <$define _the_group_nelems:num=(NELEMS)>
    <$define _the_group_counter:num=(NELEMS)>
	  <$define _the_group_columnwise:bool='1'>
	  <$define _the_group_newrow:bool='1'> <* force new row on 1st element *>
	  <$define _the_group_arrayprefix:string=''> <* only for nested ROWGROUPs *>
	<$else>
		<$let _the_group_level=(_the_group_level & '1')>
    <("<$define _the_group_nelems" + _the_group_level + ":num=(_the_group_nelems)>")>
    <("<$define _the_group_counter" + _the_group_level + ":num=(_the_group_counter)>")>
	  <("<$define _the_group_columnwise" + _the_group_level + ":bool=(_the_group_columnwise)>")>
	  <("<$define _the_group_newrow" + _the_group_level + ":bool=(_the_group_newrow)>")>
    <$let _the_group_nelems=(NELEMS)>
    <$let _the_group_counter='0'>
	  <$let _the_group_columnwise='1'>
	  <$let _the_group_newrow='1'>
	</$if>

  <_GROUPING-TABLE CLASS?=CLASS>
    <(HSC.Content + "<$if COND=(_the_group_counter <> _the_group_nelems)><_GROUPING-TABLE-ROW CLOSE></$if>")>
  <_GROUPING-TABLE CLOSE>

  <$if COND=(_the_group_level > '1')>
    <$let _the_group_nelems={"_the_group_nelems" + _the_group_level}>
    <$let _the_group_counter={"_the_group_counter" + _the_group_level}>
	  <$let _the_group_columnwise={"_the_group_columnwise" + _the_group_level}>
	  <$let _the_group_newrow={"_the_group_newrow" + _the_group_level}>
  </$if>
  <$let _the_group_level=(_the_group_level - '1')>
</$macro>

<$macro GROUPENTRY-NG /CLOSE /MBI="rowgroup-ng|columngroup-ng">
  <* distinguish between row and column layouts *>
	<$if COND=(_the_group_columnwise)>

    <* if a new row has to be started, emit <TR> and reset flag *>
	  <$if COND=(_the_group_newrow)>
		  <_GROUPING-TABLE-ROW><$let _the_group_newrow=''>
  	</$if>

    <* simply put the contents into a table cell or header *>
    <_GROUPING-TABLE-CELL>
	    <(Hsc.Content + "<$if COND=(_the_group_counter <> _the_group_nelems)><_GROUPING-TABLE-ROW CLOSE></$if>")>
    <_GROUPING-TABLE-CELL CLOSE>

    <* decrement element counter *>
		<$let _the_group_counter=(_the_group_counter - '1')>

    <* check for end of row *>
		<_COLUMNGROUP-NG_CHECKENDROW>

	<$else>

    <* if the element counter has expired, just reset it *>
	  <$if COND=(_the_group_counter = '0')>
		  <$let _the_group_counter=(_the_group_nelems)>
  	</$if>

    <* decrement element counter *>
		<$let _the_group_counter=(_the_group_counter - '1')>

    <* add macro contents to current row's array variable *>
    <$let {_the_group_arrayprefix +
           ((_the_group_nelems - _the_group_counter) - '1')} =
          ({_the_group_arrayprefix +
           ((_the_group_nelems - _the_group_counter) - '1')} +
          "<_GROUPING-TABLE-ROW>" + HSC.Content + "<_GROUPING-TABLE-ROW CLOSE>")>
	</$if>
</$macro>

<$macro _COLUMNGROUP-NG_CHECKENDROW>
  <* close row if element counter has reached zero *>
	<$if COND=(_the_group_counter = '0')>
		<_GROUPING-TABLE-ROW CLOSE>
    <* reset counter and set flag for new row on next groupentry *>
		<$let _the_group_counter=(_the_group_nelems)>
		<$let _the_group_newrow='1'>
	</$if>
</$macro>


<$macro _GROUPING-TABLE CLOSE:bool CLASS:string PAD:string BORDER:num>
  <$if COND=(set CLOSE)>
    <$if COND=(defined HSC.Opts.XHTML)>
      </DIV>
    <$else>
      </TABLE>
    </$if>
  <$else>
    <$if COND=(defined HSC.Opts.XHTML)>
      <$if COND=(set CLASS)><DIV CLASS=(CLASS)><$else><DIV STYLE="display:table"></$if>
    <$else>
      <TABLE CELLPADDING?=PAD BORDER?=BORDER SUMMARY="columngroup-layout" CLASS?=CLASS>
    </$if>
  </$if>
</$macro>

<$macro _GROUPING-TABLE-ROW CLOSE:bool CLASS:string>
  <$message class=warning text="New row">
  <$if COND=(set CLOSE)>
    <$if COND=(defined HSC.Opts.XHTML)></DIV><$else></TR></$if>
  <$else>
    <$if COND=(defined HSC.Opts.XHTML)>
      <$if COND=(set CLASS)><DIV CLASS=(CLASS)><$else><DIV STYLE="display:table-row"></$if>
    <$else>
      <TR CLASS?=CLASS>
    </$if>
  </$if>
</$macro>

<$macro _GROUPING-TABLE-CELL CLOSE:bool CLASS:string>
  <$if COND=(set CLOSE)>
    <$if COND=(defined HSC.Opts.XHTML)></DIV><$else></TD></$if>
  <$else>
    <$if COND=(defined HSC.Opts.XHTML)>
      <$if COND=(set CLASS)><DIV CLASS=(CLASS)><$else><DIV STYLE="display:table-cell"></$if>
    <$else>
      <TD>
    </$if>
  </$if>
</$macro>

<*-------------------------------------*>

<$macro ROWGROUP-NEWCOLUMN /MBI="rowgroup" HEAD:bool>
  <$if COND=(_the_group_counter)>
    <$if COND=(HEAD)>
      <$define _newcolumn_fillcell:string/C="<TH></TH>">
    <$else>
      <$define _newcolumn_fillcell:string/C="<TD></TD>">
    </$if>
    <FOR VAR=i START=0 TO=(_the_group_counter) STEP=1>
      <$let {_the_group_arrayprefix + ((_the_group_nelems - i) - '1')} =
            ({_the_group_arrayprefix + ((_the_group_nelems - i) - '1')} +
             _newcolumn_fillcell)>
    </FOR>
    <$let _the_group_counter=0>
  </$if>
</$macro>

<*-------------------------------------*>

<$macro COLUMNGROUP-NEWROW /MBI="columngroup" CELLS:bool>
  <$if COND=(HEAD)>
    <$define _newrow_fillcell:string/C="<TH>&nbsp;</TH>">
  <$else>
    <$define _newrow_fillcell:string/C="<TD>&nbsp;</TD>">
  </$if>
  <$if COND=(set CELLS)>
    <WHILE COND='_the_group_counter > "0"'>
      <$let _the_group_counter=(_the_group_counter - '1')>
      <(_newrow_fillcell)>
    </WHILE>
  <$else>
    <$let _the_group_counter='0'>
  </$if>
  <_COLUMNGROUP_CHECKENDROW>
</$macro>

<*-------------------------------------*>
<$macro _COLUMNGROUP_CHECKENDROW>
  <* close row if element counter has reached zero *>
	<$if COND=(_the_group_counter = '0')>
		</TR>
    <* reset counter and set flag for new row on next groupentry *>
		<$let _the_group_counter=(_the_group_nelems)>
		<$let _the_group_newrow='1'>
	</$if>
</$macro>

<*-------------------------------------*>
<* This adds the string "<NAME>:<ATTR>" to DEST, possibly separated with a
 * semicolon if DEST was defined before. If ATTR is undefined, does nothing,
 * so it is safe to use it like this:
 * <$macro FOO SOME:string PARAMETER:num>
 *   <$define styleattr:string>
 *   <_MAKE-CSS-STYLE ATTR?=SOME NAME=some DEST=styleattr>
 *   <_MAKE-CSS-STYLE ATTR?=PARAMETER NAME=other DEST=styleattr>
 * </$macro>
 *>
<$macro _MAKE-CSS-STYLE ATTR:string NAME:string/R DEST:string/R>
  <$if COND=(set ATTR)>
    <$if COND=(set {DEST})>
      <$let {DEST}=({DEST} + ';' + NAME + ':' + ATTR)>
    <$else>
      <$let {DEST}=(NAME + ':' + ATTR)>
    </$if>
  </$if>
</$macro>

<*-----------------------------------------------------------------------*>
<*
 * $Log: macros.hsc,v $
 * Revision 1.68  2004/02/05 09:43:23  mb
 * Added TITLE attribute to MENUITEM
 * Added (experimental) BIAS to GIMME-LATEX-SECTIONS
 *
 * Revision 1.67  2004/01/21 07:49:02  mb
 * Added NOLINKCURRENT attribute to TOPMENU, hopefully aiding usability
 *
 * Revision 1.66  2004/01/19 12:06:23  mb
 * Simplified BREAK a little, added ORDINAL, improved BIBITEM
 *
 * Revision 1.65  2003/12/23 16:59:06  mb
 * Rewrote experimental (and still broken) grouping macros
 *
 * Revision 1.64  2003/12/20 11:36:46  mb
 * Bugfix: added EXTRA attribute to _MENUITEM-TAG helper macro
 * Reduced default menu's MAXNESTDEPTH to 4
 *
 * Revision 1.63  2003/11/06 11:17:32  mb
 * Added BACKLINK attribute to FOOTNOTES
 *
 * Revision 1.62  2003/11/06 10:49:28  mb
 * Added MENUCLASS to TOPMENU and SUBMENU macros
 * Removed automatic "list-style-type: none" from list-style menus. If you want
 * this look, enable it yourself in a class definition; I use:
 *  .menu a[href] { display: block; }
 *  .menu ul { padding-left: 0em; font-size: 120%; list-style-type: none; line-height: 140%; }
 *  .menu ul ul { padding-left: 1em; font-size: 68%; }
 *  .menu ul ul ul { font-size: 75%; }
 *>

<* vi: set tabstop=2 expandtab nowrap: *>
