// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: svc/auth/v1/service.proto

package authv1connect

import (
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	v1 "github.com/humanlogio/api/go/svc/auth/v1"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// AuthServiceName is the fully-qualified name of the AuthService service.
	AuthServiceName = "svc.auth.v1.AuthService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// AuthServiceGetAuthURLProcedure is the fully-qualified name of the AuthService's GetAuthURL RPC.
	AuthServiceGetAuthURLProcedure = "/svc.auth.v1.AuthService/GetAuthURL"
	// AuthServiceBeginDeviceAuthProcedure is the fully-qualified name of the AuthService's
	// BeginDeviceAuth RPC.
	AuthServiceBeginDeviceAuthProcedure = "/svc.auth.v1.AuthService/BeginDeviceAuth"
	// AuthServiceCompleteDeviceAuthProcedure is the fully-qualified name of the AuthService's
	// CompleteDeviceAuth RPC.
	AuthServiceCompleteDeviceAuthProcedure = "/svc.auth.v1.AuthService/CompleteDeviceAuth"
)

// AuthServiceClient is a client for the svc.auth.v1.AuthService service.
type AuthServiceClient interface {
	GetAuthURL(context.Context, *connect.Request[v1.GetAuthURLRequest]) (*connect.Response[v1.GetAuthURLResponse], error)
	BeginDeviceAuth(context.Context, *connect.Request[v1.BeginDeviceAuthRequest]) (*connect.Response[v1.BeginDeviceAuthResponse], error)
	CompleteDeviceAuth(context.Context, *connect.Request[v1.CompleteDeviceAuthRequest]) (*connect.Response[v1.CompleteDeviceAuthResponse], error)
}

// NewAuthServiceClient constructs a client for the svc.auth.v1.AuthService service. By default, it
// uses the Connect protocol with the binary Protobuf Codec, asks for gzipped responses, and sends
// uncompressed requests. To use the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or
// connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewAuthServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) AuthServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	authServiceMethods := v1.File_svc_auth_v1_service_proto.Services().ByName("AuthService").Methods()
	return &authServiceClient{
		getAuthURL: connect.NewClient[v1.GetAuthURLRequest, v1.GetAuthURLResponse](
			httpClient,
			baseURL+AuthServiceGetAuthURLProcedure,
			connect.WithSchema(authServiceMethods.ByName("GetAuthURL")),
			connect.WithClientOptions(opts...),
		),
		beginDeviceAuth: connect.NewClient[v1.BeginDeviceAuthRequest, v1.BeginDeviceAuthResponse](
			httpClient,
			baseURL+AuthServiceBeginDeviceAuthProcedure,
			connect.WithSchema(authServiceMethods.ByName("BeginDeviceAuth")),
			connect.WithClientOptions(opts...),
		),
		completeDeviceAuth: connect.NewClient[v1.CompleteDeviceAuthRequest, v1.CompleteDeviceAuthResponse](
			httpClient,
			baseURL+AuthServiceCompleteDeviceAuthProcedure,
			connect.WithSchema(authServiceMethods.ByName("CompleteDeviceAuth")),
			connect.WithClientOptions(opts...),
		),
	}
}

// authServiceClient implements AuthServiceClient.
type authServiceClient struct {
	getAuthURL         *connect.Client[v1.GetAuthURLRequest, v1.GetAuthURLResponse]
	beginDeviceAuth    *connect.Client[v1.BeginDeviceAuthRequest, v1.BeginDeviceAuthResponse]
	completeDeviceAuth *connect.Client[v1.CompleteDeviceAuthRequest, v1.CompleteDeviceAuthResponse]
}

// GetAuthURL calls svc.auth.v1.AuthService.GetAuthURL.
func (c *authServiceClient) GetAuthURL(ctx context.Context, req *connect.Request[v1.GetAuthURLRequest]) (*connect.Response[v1.GetAuthURLResponse], error) {
	return c.getAuthURL.CallUnary(ctx, req)
}

// BeginDeviceAuth calls svc.auth.v1.AuthService.BeginDeviceAuth.
func (c *authServiceClient) BeginDeviceAuth(ctx context.Context, req *connect.Request[v1.BeginDeviceAuthRequest]) (*connect.Response[v1.BeginDeviceAuthResponse], error) {
	return c.beginDeviceAuth.CallUnary(ctx, req)
}

// CompleteDeviceAuth calls svc.auth.v1.AuthService.CompleteDeviceAuth.
func (c *authServiceClient) CompleteDeviceAuth(ctx context.Context, req *connect.Request[v1.CompleteDeviceAuthRequest]) (*connect.Response[v1.CompleteDeviceAuthResponse], error) {
	return c.completeDeviceAuth.CallUnary(ctx, req)
}

// AuthServiceHandler is an implementation of the svc.auth.v1.AuthService service.
type AuthServiceHandler interface {
	GetAuthURL(context.Context, *connect.Request[v1.GetAuthURLRequest]) (*connect.Response[v1.GetAuthURLResponse], error)
	BeginDeviceAuth(context.Context, *connect.Request[v1.BeginDeviceAuthRequest]) (*connect.Response[v1.BeginDeviceAuthResponse], error)
	CompleteDeviceAuth(context.Context, *connect.Request[v1.CompleteDeviceAuthRequest]) (*connect.Response[v1.CompleteDeviceAuthResponse], error)
}

// NewAuthServiceHandler builds an HTTP handler from the service implementation. It returns the path
// on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewAuthServiceHandler(svc AuthServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	authServiceMethods := v1.File_svc_auth_v1_service_proto.Services().ByName("AuthService").Methods()
	authServiceGetAuthURLHandler := connect.NewUnaryHandler(
		AuthServiceGetAuthURLProcedure,
		svc.GetAuthURL,
		connect.WithSchema(authServiceMethods.ByName("GetAuthURL")),
		connect.WithHandlerOptions(opts...),
	)
	authServiceBeginDeviceAuthHandler := connect.NewUnaryHandler(
		AuthServiceBeginDeviceAuthProcedure,
		svc.BeginDeviceAuth,
		connect.WithSchema(authServiceMethods.ByName("BeginDeviceAuth")),
		connect.WithHandlerOptions(opts...),
	)
	authServiceCompleteDeviceAuthHandler := connect.NewUnaryHandler(
		AuthServiceCompleteDeviceAuthProcedure,
		svc.CompleteDeviceAuth,
		connect.WithSchema(authServiceMethods.ByName("CompleteDeviceAuth")),
		connect.WithHandlerOptions(opts...),
	)
	return "/svc.auth.v1.AuthService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case AuthServiceGetAuthURLProcedure:
			authServiceGetAuthURLHandler.ServeHTTP(w, r)
		case AuthServiceBeginDeviceAuthProcedure:
			authServiceBeginDeviceAuthHandler.ServeHTTP(w, r)
		case AuthServiceCompleteDeviceAuthProcedure:
			authServiceCompleteDeviceAuthHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedAuthServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedAuthServiceHandler struct{}

func (UnimplementedAuthServiceHandler) GetAuthURL(context.Context, *connect.Request[v1.GetAuthURLRequest]) (*connect.Response[v1.GetAuthURLResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("svc.auth.v1.AuthService.GetAuthURL is not implemented"))
}

func (UnimplementedAuthServiceHandler) BeginDeviceAuth(context.Context, *connect.Request[v1.BeginDeviceAuthRequest]) (*connect.Response[v1.BeginDeviceAuthResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("svc.auth.v1.AuthService.BeginDeviceAuth is not implemented"))
}

func (UnimplementedAuthServiceHandler) CompleteDeviceAuth(context.Context, *connect.Request[v1.CompleteDeviceAuthRequest]) (*connect.Response[v1.CompleteDeviceAuthResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("svc.auth.v1.AuthService.CompleteDeviceAuth is not implemented"))
}
