// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Request a cost allocation tag backfill. This will backfill the activation
//
// status (either active or inactive ) for all tag keys from para:BackfillFrom up
// to the when this request is made.
//
// You can request a backfill once every 24 hours.
func (c *Client) StartCostAllocationTagBackfill(ctx context.Context, params *StartCostAllocationTagBackfillInput, optFns ...func(*Options)) (*StartCostAllocationTagBackfillOutput, error) {
	if params == nil {
		params = &StartCostAllocationTagBackfillInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartCostAllocationTagBackfill", params, optFns, c.addOperationStartCostAllocationTagBackfillMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartCostAllocationTagBackfillOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartCostAllocationTagBackfillInput struct {

	//  The date you want the backfill to start from. The date can only be a first day
	// of the month (a billing start date). Dates can't precede the previous twelve
	// months, or in the future.
	//
	// This member is required.
	BackfillFrom *string

	noSmithyDocumentSerde
}

type StartCostAllocationTagBackfillOutput struct {

	//  An object containing detailed metadata of your new backfill request.
	BackfillRequest *types.CostAllocationTagBackfillRequest

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartCostAllocationTagBackfillMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartCostAllocationTagBackfill{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartCostAllocationTagBackfill{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartCostAllocationTagBackfill"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpStartCostAllocationTagBackfillValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartCostAllocationTagBackfill(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartCostAllocationTagBackfill(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartCostAllocationTagBackfill",
	}
}
