/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gf-shell-gen.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.gnome.Shell
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GfShellGen
 * @title: GfShellGen
 * @short_description: Generated C code for the org.gnome.Shell D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-gnome-Shell.top_of_page">org.gnome.Shell</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.gnome.Shell ---- */

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_eval_IN_ARG_script =
{
  {
    -1,
    (gchar *) "script",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_eval_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_eval_IN_ARG_script.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_eval_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_eval_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_eval_OUT_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_eval_OUT_ARG_success.parent_struct,
  &_gf_shell_gen_method_info_eval_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_eval =
{
  {
    -1,
    (gchar *) "Eval",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_eval_IN_ARG_pointers,
    (GDBusArgInfo **) &_gf_shell_gen_method_info_eval_OUT_ARG_pointers,
    NULL
  },
  "handle-eval",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_focus_search =
{
  {
    -1,
    (gchar *) "FocusSearch",
    NULL,
    NULL,
    NULL
  },
  "handle-focus-search",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_show_osd_IN_ARG_params =
{
  {
    -1,
    (gchar *) "params",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_show_osd_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_show_osd_IN_ARG_params.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_show_osd =
{
  {
    -1,
    (gchar *) "ShowOSD",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_show_osd_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-osd",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_show_monitor_labels_IN_ARG_params =
{
  {
    -1,
    (gchar *) "params",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_show_monitor_labels_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_show_monitor_labels_IN_ARG_params.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_show_monitor_labels =
{
  {
    -1,
    (gchar *) "ShowMonitorLabels",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_show_monitor_labels_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-show-monitor-labels",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_hide_monitor_labels =
{
  {
    -1,
    (gchar *) "HideMonitorLabels",
    NULL,
    NULL,
    NULL
  },
  "handle-hide-monitor-labels",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_focus_app_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_focus_app_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_focus_app_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_focus_app =
{
  {
    -1,
    (gchar *) "FocusApp",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_focus_app_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-focus-app",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_show_applications =
{
  {
    -1,
    (gchar *) "ShowApplications",
    NULL,
    NULL,
    NULL
  },
  "handle-show-applications",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_grab_accelerator_IN_ARG_accelerator =
{
  {
    -1,
    (gchar *) "accelerator",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_grab_accelerator_IN_ARG_modeFlags =
{
  {
    -1,
    (gchar *) "modeFlags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_grab_accelerator_IN_ARG_grabFlags =
{
  {
    -1,
    (gchar *) "grabFlags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_grab_accelerator_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_grab_accelerator_IN_ARG_accelerator.parent_struct,
  &_gf_shell_gen_method_info_grab_accelerator_IN_ARG_modeFlags.parent_struct,
  &_gf_shell_gen_method_info_grab_accelerator_IN_ARG_grabFlags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_grab_accelerator_OUT_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_grab_accelerator_OUT_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_grab_accelerator_OUT_ARG_action.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_grab_accelerator =
{
  {
    -1,
    (gchar *) "GrabAccelerator",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_grab_accelerator_IN_ARG_pointers,
    (GDBusArgInfo **) &_gf_shell_gen_method_info_grab_accelerator_OUT_ARG_pointers,
    NULL
  },
  "handle-grab-accelerator",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_grab_accelerators_IN_ARG_accelerators =
{
  {
    -1,
    (gchar *) "accelerators",
    (gchar *) "a(suu)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_grab_accelerators_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_grab_accelerators_IN_ARG_accelerators.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_grab_accelerators_OUT_ARG_actions =
{
  {
    -1,
    (gchar *) "actions",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_grab_accelerators_OUT_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_grab_accelerators_OUT_ARG_actions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_grab_accelerators =
{
  {
    -1,
    (gchar *) "GrabAccelerators",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_grab_accelerators_IN_ARG_pointers,
    (GDBusArgInfo **) &_gf_shell_gen_method_info_grab_accelerators_OUT_ARG_pointers,
    NULL
  },
  "handle-grab-accelerators",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_ungrab_accelerator_IN_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_ungrab_accelerator_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_ungrab_accelerator_IN_ARG_action.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_ungrab_accelerator_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_ungrab_accelerator_OUT_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_ungrab_accelerator_OUT_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_ungrab_accelerator =
{
  {
    -1,
    (gchar *) "UngrabAccelerator",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_ungrab_accelerator_IN_ARG_pointers,
    (GDBusArgInfo **) &_gf_shell_gen_method_info_ungrab_accelerator_OUT_ARG_pointers,
    NULL
  },
  "handle-ungrab-accelerator",
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_ungrab_accelerators_IN_ARG_actions =
{
  {
    -1,
    (gchar *) "actions",
    (gchar *) "au",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_ungrab_accelerators_IN_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_ungrab_accelerators_IN_ARG_actions.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_method_info_ungrab_accelerators_OUT_ARG_success =
{
  {
    -1,
    (gchar *) "success",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_method_info_ungrab_accelerators_OUT_ARG_pointers[] =
{
  &_gf_shell_gen_method_info_ungrab_accelerators_OUT_ARG_success.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gf_shell_gen_method_info_ungrab_accelerators =
{
  {
    -1,
    (gchar *) "UngrabAccelerators",
    (GDBusArgInfo **) &_gf_shell_gen_method_info_ungrab_accelerators_IN_ARG_pointers,
    (GDBusArgInfo **) &_gf_shell_gen_method_info_ungrab_accelerators_OUT_ARG_pointers,
    NULL
  },
  "handle-ungrab-accelerators",
  FALSE
};

static const GDBusMethodInfo * const _gf_shell_gen_method_info_pointers[] =
{
  &_gf_shell_gen_method_info_eval.parent_struct,
  &_gf_shell_gen_method_info_focus_search.parent_struct,
  &_gf_shell_gen_method_info_show_osd.parent_struct,
  &_gf_shell_gen_method_info_show_monitor_labels.parent_struct,
  &_gf_shell_gen_method_info_hide_monitor_labels.parent_struct,
  &_gf_shell_gen_method_info_focus_app.parent_struct,
  &_gf_shell_gen_method_info_show_applications.parent_struct,
  &_gf_shell_gen_method_info_grab_accelerator.parent_struct,
  &_gf_shell_gen_method_info_grab_accelerators.parent_struct,
  &_gf_shell_gen_method_info_ungrab_accelerator.parent_struct,
  &_gf_shell_gen_method_info_ungrab_accelerators.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_signal_info_accelerator_activated_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gf_shell_gen_signal_info_accelerator_activated_ARG_parameters =
{
  {
    -1,
    (gchar *) "parameters",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gf_shell_gen_signal_info_accelerator_activated_ARG_pointers[] =
{
  &_gf_shell_gen_signal_info_accelerator_activated_ARG_action.parent_struct,
  &_gf_shell_gen_signal_info_accelerator_activated_ARG_parameters.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gf_shell_gen_signal_info_accelerator_activated =
{
  {
    -1,
    (gchar *) "AcceleratorActivated",
    (GDBusArgInfo **) &_gf_shell_gen_signal_info_accelerator_activated_ARG_pointers,
    NULL
  },
  "accelerator-activated"
};

static const GDBusSignalInfo * const _gf_shell_gen_signal_info_pointers[] =
{
  &_gf_shell_gen_signal_info_accelerator_activated.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _gf_shell_gen_property_info_mode =
{
  {
    -1,
    (gchar *) "Mode",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "mode",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gf_shell_gen_property_info_overview_active =
{
  {
    -1,
    (gchar *) "OverviewActive",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "overview-active",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _gf_shell_gen_property_info_shell_version =
{
  {
    -1,
    (gchar *) "ShellVersion",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "shell-version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _gf_shell_gen_property_info_pointers[] =
{
  &_gf_shell_gen_property_info_mode.parent_struct,
  &_gf_shell_gen_property_info_overview_active.parent_struct,
  &_gf_shell_gen_property_info_shell_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gf_shell_gen_interface_info =
{
  {
    -1,
    (gchar *) "org.gnome.Shell",
    (GDBusMethodInfo **) &_gf_shell_gen_method_info_pointers,
    (GDBusSignalInfo **) &_gf_shell_gen_signal_info_pointers,
    (GDBusPropertyInfo **) &_gf_shell_gen_property_info_pointers,
    NULL
  },
  "shell-gen",
};


/**
 * gf_shell_gen_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-gnome-Shell.top_of_page">org.gnome.Shell</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gf_shell_gen_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gf_shell_gen_interface_info.parent_struct;
}

/**
 * gf_shell_gen_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GfShellGen interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gf_shell_gen_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "mode");
  g_object_class_override_property (klass, property_id_begin++, "overview-active");
  g_object_class_override_property (klass, property_id_begin++, "shell-version");
  return property_id_begin - 1;
}



/**
 * GfShellGen:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell.top_of_page">org.gnome.Shell</link>.
 */

/**
 * GfShellGenIface:
 * @parent_iface: The parent interface.
 * @handle_eval: Handler for the #GfShellGen::handle-eval signal.
 * @handle_focus_app: Handler for the #GfShellGen::handle-focus-app signal.
 * @handle_focus_search: Handler for the #GfShellGen::handle-focus-search signal.
 * @handle_grab_accelerator: Handler for the #GfShellGen::handle-grab-accelerator signal.
 * @handle_grab_accelerators: Handler for the #GfShellGen::handle-grab-accelerators signal.
 * @handle_hide_monitor_labels: Handler for the #GfShellGen::handle-hide-monitor-labels signal.
 * @handle_show_applications: Handler for the #GfShellGen::handle-show-applications signal.
 * @handle_show_monitor_labels: Handler for the #GfShellGen::handle-show-monitor-labels signal.
 * @handle_show_osd: Handler for the #GfShellGen::handle-show-osd signal.
 * @handle_ungrab_accelerator: Handler for the #GfShellGen::handle-ungrab-accelerator signal.
 * @handle_ungrab_accelerators: Handler for the #GfShellGen::handle-ungrab-accelerators signal.
 * @get_mode: Getter for the #GfShellGen:mode property.
 * @get_overview_active: Getter for the #GfShellGen:overview-active property.
 * @get_shell_version: Getter for the #GfShellGen:shell-version property.
 * @accelerator_activated: Handler for the #GfShellGen::accelerator-activated signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell.top_of_page">org.gnome.Shell</link>.
 */

typedef GfShellGenIface GfShellGenInterface;
G_DEFINE_INTERFACE (GfShellGen, gf_shell_gen, G_TYPE_OBJECT)

static void
gf_shell_gen_default_init (GfShellGenIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GfShellGen::handle-eval:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_script: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.Eval">Eval()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_eval() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-eval",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_eval),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GfShellGen::handle-focus-search:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.FocusSearch">FocusSearch()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_focus_search() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-focus-search",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_focus_search),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GfShellGen::handle-show-osd:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_params: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.ShowOSD">ShowOSD()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_show_osd() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-osd",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_show_osd),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GfShellGen::handle-show-monitor-labels:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_params: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.ShowMonitorLabels">ShowMonitorLabels()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_show_monitor_labels() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-monitor-labels",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_show_monitor_labels),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GfShellGen::handle-hide-monitor-labels:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.HideMonitorLabels">HideMonitorLabels()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_hide_monitor_labels() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hide-monitor-labels",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_hide_monitor_labels),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GfShellGen::handle-focus-app:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.FocusApp">FocusApp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_focus_app() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-focus-app",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_focus_app),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GfShellGen::handle-show-applications:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.ShowApplications">ShowApplications()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_show_applications() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-show-applications",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_show_applications),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GfShellGen::handle-grab-accelerator:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_accelerator: Argument passed by remote caller.
   * @arg_modeFlags: Argument passed by remote caller.
   * @arg_grabFlags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerator">GrabAccelerator()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_grab_accelerator() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-grab-accelerator",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_grab_accelerator),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * GfShellGen::handle-grab-accelerators:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_accelerators: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerators">GrabAccelerators()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_grab_accelerators() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-grab-accelerators",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_grab_accelerators),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * GfShellGen::handle-ungrab-accelerator:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_action: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerator">UngrabAccelerator()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_ungrab_accelerator() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-ungrab-accelerator",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_ungrab_accelerator),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * GfShellGen::handle-ungrab-accelerators:
   * @object: A #GfShellGen.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_actions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerators">UngrabAccelerators()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gf_shell_gen_complete_ungrab_accelerators() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-ungrab-accelerators",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, handle_ungrab_accelerators),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * GfShellGen::accelerator-activated:
   * @object: A #GfShellGen.
   * @arg_action: Argument.
   * @arg_parameters: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-gnome-Shell.AcceleratorActivated">"AcceleratorActivated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("accelerator-activated",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GfShellGenIface, accelerator_activated),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * GfShellGen:mode:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Shell.Mode">"Mode"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("mode", "Mode", "Mode", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GfShellGen:overview-active:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Shell.OverviewActive">"OverviewActive"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("overview-active", "OverviewActive", "OverviewActive", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * GfShellGen:shell-version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-gnome-Shell.ShellVersion">"ShellVersion"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("shell-version", "ShellVersion", "ShellVersion", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * gf_shell_gen_get_mode: (skip)
 * @object: A #GfShellGen.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Shell.Mode">"Mode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gf_shell_gen_dup_mode() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gf_shell_gen_get_mode (GfShellGen *object)
{
  return GF_SHELL_GEN_GET_IFACE (object)->get_mode (object);
}

/**
 * gf_shell_gen_dup_mode: (skip)
 * @object: A #GfShellGen.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Shell.Mode">"Mode"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gf_shell_gen_dup_mode (GfShellGen *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "mode", &value, NULL);
  return value;
}

/**
 * gf_shell_gen_set_mode: (skip)
 * @object: A #GfShellGen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Shell.Mode">"Mode"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gf_shell_gen_set_mode (GfShellGen *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "mode", value, NULL);
}

/**
 * gf_shell_gen_get_overview_active: (skip)
 * @object: A #GfShellGen.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Shell.OverviewActive">"OverviewActive"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
gf_shell_gen_get_overview_active (GfShellGen *object)
{
  return GF_SHELL_GEN_GET_IFACE (object)->get_overview_active (object);
}

/**
 * gf_shell_gen_set_overview_active: (skip)
 * @object: A #GfShellGen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Shell.OverviewActive">"OverviewActive"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
gf_shell_gen_set_overview_active (GfShellGen *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "overview-active", value, NULL);
}

/**
 * gf_shell_gen_get_shell_version: (skip)
 * @object: A #GfShellGen.
 *
 * Gets the value of the <link linkend="gdbus-property-org-gnome-Shell.ShellVersion">"ShellVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use gf_shell_gen_dup_shell_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
gf_shell_gen_get_shell_version (GfShellGen *object)
{
  return GF_SHELL_GEN_GET_IFACE (object)->get_shell_version (object);
}

/**
 * gf_shell_gen_dup_shell_version: (skip)
 * @object: A #GfShellGen.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-gnome-Shell.ShellVersion">"ShellVersion"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
gf_shell_gen_dup_shell_version (GfShellGen *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "shell-version", &value, NULL);
  return value;
}

/**
 * gf_shell_gen_set_shell_version: (skip)
 * @object: A #GfShellGen.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-gnome-Shell.ShellVersion">"ShellVersion"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
gf_shell_gen_set_shell_version (GfShellGen *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "shell-version", value, NULL);
}

/**
 * gf_shell_gen_emit_accelerator_activated:
 * @object: A #GfShellGen.
 * @arg_action: Argument to pass with the signal.
 * @arg_parameters: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-gnome-Shell.AcceleratorActivated">"AcceleratorActivated"</link> D-Bus signal.
 */
void
gf_shell_gen_emit_accelerator_activated (
    GfShellGen *object,
    guint arg_action,
    GVariant *arg_parameters)
{
  g_signal_emit_by_name (object, "accelerator-activated", arg_action, arg_parameters);
}

/**
 * gf_shell_gen_call_eval:
 * @proxy: A #GfShellGenProxy.
 * @arg_script: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.Eval">Eval()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_eval_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_eval_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_eval (
    GfShellGen *proxy,
    const gchar *arg_script,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Eval",
    g_variant_new ("(s)",
                   arg_script),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_eval_finish:
 * @proxy: A #GfShellGenProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_eval().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_eval().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_eval_finish (
    GfShellGen *proxy,
    gboolean *out_success,
    gchar **out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_eval_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_script: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.Eval">Eval()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_eval() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_eval_sync (
    GfShellGen *proxy,
    const gchar *arg_script,
    gboolean *out_success,
    gchar **out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Eval",
    g_variant_new ("(s)",
                   arg_script),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(bs)",
                 out_success,
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_focus_search:
 * @proxy: A #GfShellGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.FocusSearch">FocusSearch()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_focus_search_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_focus_search_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_focus_search (
    GfShellGen *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FocusSearch",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_focus_search_finish:
 * @proxy: A #GfShellGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_focus_search().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_focus_search().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_focus_search_finish (
    GfShellGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_focus_search_sync:
 * @proxy: A #GfShellGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.FocusSearch">FocusSearch()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_focus_search() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_focus_search_sync (
    GfShellGen *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FocusSearch",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_show_osd:
 * @proxy: A #GfShellGenProxy.
 * @arg_params: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.ShowOSD">ShowOSD()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_show_osd_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_show_osd_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_show_osd (
    GfShellGen *proxy,
    GVariant *arg_params,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowOSD",
    g_variant_new ("(@a{sv})",
                   arg_params),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_show_osd_finish:
 * @proxy: A #GfShellGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_show_osd().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_show_osd().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_show_osd_finish (
    GfShellGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_show_osd_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_params: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.ShowOSD">ShowOSD()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_show_osd() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_show_osd_sync (
    GfShellGen *proxy,
    GVariant *arg_params,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowOSD",
    g_variant_new ("(@a{sv})",
                   arg_params),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_show_monitor_labels:
 * @proxy: A #GfShellGenProxy.
 * @arg_params: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.ShowMonitorLabels">ShowMonitorLabels()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_show_monitor_labels_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_show_monitor_labels_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_show_monitor_labels (
    GfShellGen *proxy,
    GVariant *arg_params,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowMonitorLabels",
    g_variant_new ("(@a{sv})",
                   arg_params),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_show_monitor_labels_finish:
 * @proxy: A #GfShellGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_show_monitor_labels().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_show_monitor_labels().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_show_monitor_labels_finish (
    GfShellGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_show_monitor_labels_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_params: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.ShowMonitorLabels">ShowMonitorLabels()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_show_monitor_labels() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_show_monitor_labels_sync (
    GfShellGen *proxy,
    GVariant *arg_params,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowMonitorLabels",
    g_variant_new ("(@a{sv})",
                   arg_params),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_hide_monitor_labels:
 * @proxy: A #GfShellGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.HideMonitorLabels">HideMonitorLabels()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_hide_monitor_labels_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_hide_monitor_labels_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_hide_monitor_labels (
    GfShellGen *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HideMonitorLabels",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_hide_monitor_labels_finish:
 * @proxy: A #GfShellGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_hide_monitor_labels().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_hide_monitor_labels().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_hide_monitor_labels_finish (
    GfShellGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_hide_monitor_labels_sync:
 * @proxy: A #GfShellGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.HideMonitorLabels">HideMonitorLabels()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_hide_monitor_labels() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_hide_monitor_labels_sync (
    GfShellGen *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HideMonitorLabels",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_focus_app:
 * @proxy: A #GfShellGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.FocusApp">FocusApp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_focus_app_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_focus_app_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_focus_app (
    GfShellGen *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "FocusApp",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_focus_app_finish:
 * @proxy: A #GfShellGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_focus_app().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_focus_app().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_focus_app_finish (
    GfShellGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_focus_app_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.FocusApp">FocusApp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_focus_app() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_focus_app_sync (
    GfShellGen *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "FocusApp",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_show_applications:
 * @proxy: A #GfShellGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.ShowApplications">ShowApplications()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_show_applications_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_show_applications_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_show_applications (
    GfShellGen *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ShowApplications",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_show_applications_finish:
 * @proxy: A #GfShellGenProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_show_applications().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_show_applications().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_show_applications_finish (
    GfShellGen *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_show_applications_sync:
 * @proxy: A #GfShellGenProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.ShowApplications">ShowApplications()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_show_applications() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_show_applications_sync (
    GfShellGen *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ShowApplications",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_grab_accelerator:
 * @proxy: A #GfShellGenProxy.
 * @arg_accelerator: Argument to pass with the method invocation.
 * @arg_modeFlags: Argument to pass with the method invocation.
 * @arg_grabFlags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerator">GrabAccelerator()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_grab_accelerator_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_grab_accelerator_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_grab_accelerator (
    GfShellGen *proxy,
    const gchar *arg_accelerator,
    guint arg_modeFlags,
    guint arg_grabFlags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GrabAccelerator",
    g_variant_new ("(suu)",
                   arg_accelerator,
                   arg_modeFlags,
                   arg_grabFlags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_grab_accelerator_finish:
 * @proxy: A #GfShellGenProxy.
 * @out_action: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_grab_accelerator().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_grab_accelerator().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_grab_accelerator_finish (
    GfShellGen *proxy,
    guint *out_action,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_action);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_grab_accelerator_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_accelerator: Argument to pass with the method invocation.
 * @arg_modeFlags: Argument to pass with the method invocation.
 * @arg_grabFlags: Argument to pass with the method invocation.
 * @out_action: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerator">GrabAccelerator()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_grab_accelerator() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_grab_accelerator_sync (
    GfShellGen *proxy,
    const gchar *arg_accelerator,
    guint arg_modeFlags,
    guint arg_grabFlags,
    guint *out_action,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GrabAccelerator",
    g_variant_new ("(suu)",
                   arg_accelerator,
                   arg_modeFlags,
                   arg_grabFlags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_action);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_grab_accelerators:
 * @proxy: A #GfShellGenProxy.
 * @arg_accelerators: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerators">GrabAccelerators()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_grab_accelerators_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_grab_accelerators_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_grab_accelerators (
    GfShellGen *proxy,
    GVariant *arg_accelerators,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GrabAccelerators",
    g_variant_new ("(@a(suu))",
                   arg_accelerators),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_grab_accelerators_finish:
 * @proxy: A #GfShellGenProxy.
 * @out_actions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_grab_accelerators().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_grab_accelerators().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_grab_accelerators_finish (
    GfShellGen *proxy,
    GVariant **out_actions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@au)",
                 out_actions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_grab_accelerators_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_accelerators: Argument to pass with the method invocation.
 * @out_actions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerators">GrabAccelerators()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_grab_accelerators() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_grab_accelerators_sync (
    GfShellGen *proxy,
    GVariant *arg_accelerators,
    GVariant **out_actions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GrabAccelerators",
    g_variant_new ("(@a(suu))",
                   arg_accelerators),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@au)",
                 out_actions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_ungrab_accelerator:
 * @proxy: A #GfShellGenProxy.
 * @arg_action: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerator">UngrabAccelerator()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_ungrab_accelerator_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_ungrab_accelerator_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_ungrab_accelerator (
    GfShellGen *proxy,
    guint arg_action,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UngrabAccelerator",
    g_variant_new ("(u)",
                   arg_action),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_ungrab_accelerator_finish:
 * @proxy: A #GfShellGenProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_ungrab_accelerator().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_ungrab_accelerator().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_ungrab_accelerator_finish (
    GfShellGen *proxy,
    gboolean *out_success,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_ungrab_accelerator_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_action: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerator">UngrabAccelerator()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_ungrab_accelerator() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_ungrab_accelerator_sync (
    GfShellGen *proxy,
    guint arg_action,
    gboolean *out_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UngrabAccelerator",
    g_variant_new ("(u)",
                   arg_action),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_ungrab_accelerators:
 * @proxy: A #GfShellGenProxy.
 * @arg_actions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerators">UngrabAccelerators()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_call_ungrab_accelerators_finish() to get the result of the operation.
 *
 * See gf_shell_gen_call_ungrab_accelerators_sync() for the synchronous, blocking version of this method.
 */
void
gf_shell_gen_call_ungrab_accelerators (
    GfShellGen *proxy,
    GVariant *arg_actions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UngrabAccelerators",
    g_variant_new ("(@au)",
                   arg_actions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gf_shell_gen_call_ungrab_accelerators_finish:
 * @proxy: A #GfShellGenProxy.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_call_ungrab_accelerators().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gf_shell_gen_call_ungrab_accelerators().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_ungrab_accelerators_finish (
    GfShellGen *proxy,
    gboolean *out_success,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_call_ungrab_accelerators_sync:
 * @proxy: A #GfShellGenProxy.
 * @arg_actions: Argument to pass with the method invocation.
 * @out_success: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerators">UngrabAccelerators()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_call_ungrab_accelerators() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gf_shell_gen_call_ungrab_accelerators_sync (
    GfShellGen *proxy,
    GVariant *arg_actions,
    gboolean *out_success,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UngrabAccelerators",
    g_variant_new ("(@au)",
                   arg_actions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_success);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gf_shell_gen_complete_eval:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.Eval">Eval()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_eval (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success,
    const gchar *result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(bs)",
                   success,
                   result));
}

/**
 * gf_shell_gen_complete_focus_search:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.FocusSearch">FocusSearch()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_focus_search (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_shell_gen_complete_show_osd:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.ShowOSD">ShowOSD()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_show_osd (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_shell_gen_complete_show_monitor_labels:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.ShowMonitorLabels">ShowMonitorLabels()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_show_monitor_labels (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_shell_gen_complete_hide_monitor_labels:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.HideMonitorLabels">HideMonitorLabels()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_hide_monitor_labels (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_shell_gen_complete_focus_app:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.FocusApp">FocusApp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_focus_app (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_shell_gen_complete_show_applications:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.ShowApplications">ShowApplications()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_show_applications (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gf_shell_gen_complete_grab_accelerator:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @action: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerator">GrabAccelerator()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_grab_accelerator (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint action)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   action));
}

/**
 * gf_shell_gen_complete_grab_accelerators:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @actions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.GrabAccelerators">GrabAccelerators()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_grab_accelerators (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *actions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@au)",
                   actions));
}

/**
 * gf_shell_gen_complete_ungrab_accelerator:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerator">UngrabAccelerator()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_ungrab_accelerator (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   success));
}

/**
 * gf_shell_gen_complete_ungrab_accelerators:
 * @object: A #GfShellGen.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @success: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-gnome-Shell.UngrabAccelerators">UngrabAccelerators()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gf_shell_gen_complete_ungrab_accelerators (
    GfShellGen *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean success)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   success));
}

/* ------------------------------------------------------------------------ */

/**
 * GfShellGenProxy:
 *
 * The #GfShellGenProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfShellGenProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfShellGenProxy.
 */

struct _GfShellGenProxyPrivate
{
  GData *qdata;
};

static void gf_shell_gen_proxy_iface_init (GfShellGenIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfShellGenProxy, gf_shell_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GfShellGenProxy)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SHELL_GEN, gf_shell_gen_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfShellGenProxy, gf_shell_gen_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SHELL_GEN, gf_shell_gen_proxy_iface_init))

#endif
static void
gf_shell_gen_proxy_finalize (GObject *object)
{
  GfShellGenProxy *proxy = GF_SHELL_GEN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gf_shell_gen_proxy_parent_class)->finalize (object);
}

static void
gf_shell_gen_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_shell_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
gf_shell_gen_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.gnome.Shell: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
gf_shell_gen_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_shell_gen_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.gnome.Shell", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) gf_shell_gen_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
gf_shell_gen_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gf_shell_gen_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GF_TYPE_SHELL_GEN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_SHELL_GEN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gf_shell_gen_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GfShellGenProxy *proxy = GF_SHELL_GEN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_shell_gen_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_shell_gen_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
gf_shell_gen_proxy_get_mode (GfShellGen *object)
{
  GfShellGenProxy *proxy = GF_SHELL_GEN_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Mode");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
gf_shell_gen_proxy_get_overview_active (GfShellGen *object)
{
  GfShellGenProxy *proxy = GF_SHELL_GEN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "OverviewActive");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
gf_shell_gen_proxy_get_shell_version (GfShellGen *object)
{
  GfShellGenProxy *proxy = GF_SHELL_GEN_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "ShellVersion");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
gf_shell_gen_proxy_init (GfShellGenProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gf_shell_gen_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GF_TYPE_SHELL_GEN_PROXY, GfShellGenProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gf_shell_gen_interface_info ());
}

static void
gf_shell_gen_proxy_class_init (GfShellGenProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gf_shell_gen_proxy_finalize;
  gobject_class->get_property = gf_shell_gen_proxy_get_property;
  gobject_class->set_property = gf_shell_gen_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gf_shell_gen_proxy_g_signal;
  proxy_class->g_properties_changed = gf_shell_gen_proxy_g_properties_changed;

  gf_shell_gen_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfShellGenProxyPrivate));
#endif
}

static void
gf_shell_gen_proxy_iface_init (GfShellGenIface *iface)
{
  iface->get_mode = gf_shell_gen_proxy_get_mode;
  iface->get_overview_active = gf_shell_gen_proxy_get_overview_active;
  iface->get_shell_version = gf_shell_gen_proxy_get_shell_version;
}

/**
 * gf_shell_gen_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell.top_of_page">org.gnome.Shell</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_proxy_new_finish() to get the result of the operation.
 *
 * See gf_shell_gen_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_shell_gen_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_SHELL_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell", NULL);
}

/**
 * gf_shell_gen_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_shell_gen_proxy_new().
 *
 * Returns: (transfer full) (type GfShellGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfShellGen *
gf_shell_gen_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_SHELL_GEN (ret);
  else
    return NULL;
}

/**
 * gf_shell_gen_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell.top_of_page">org.gnome.Shell</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfShellGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfShellGen *
gf_shell_gen_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_SHELL_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell", NULL);
  if (ret != NULL)
    return GF_SHELL_GEN (ret);
  else
    return NULL;
}


/**
 * gf_shell_gen_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gf_shell_gen_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gf_shell_gen_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gf_shell_gen_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gf_shell_gen_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GF_TYPE_SHELL_GEN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell", NULL);
}

/**
 * gf_shell_gen_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gf_shell_gen_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gf_shell_gen_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GfShellGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfShellGen *
gf_shell_gen_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GF_SHELL_GEN (ret);
  else
    return NULL;
}

/**
 * gf_shell_gen_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gf_shell_gen_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gf_shell_gen_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GfShellGenProxy): The constructed proxy object or %NULL if @error is set.
 */
GfShellGen *
gf_shell_gen_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GF_TYPE_SHELL_GEN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.gnome.Shell", NULL);
  if (ret != NULL)
    return GF_SHELL_GEN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GfShellGenSkeleton:
 *
 * The #GfShellGenSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GfShellGenSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GfShellGenSkeleton.
 */

struct _GfShellGenSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gf_shell_gen_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GF_TYPE_SHELL_GEN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GF_TYPE_SHELL_GEN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gf_shell_gen_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_shell_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gf_shell_gen_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gf_shell_gen_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gf_shell_gen_skeleton_vtable =
{
  _gf_shell_gen_skeleton_handle_method_call,
  _gf_shell_gen_skeleton_handle_get_property,
  _gf_shell_gen_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gf_shell_gen_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gf_shell_gen_interface_info ();
}

static GDBusInterfaceVTable *
gf_shell_gen_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gf_shell_gen_skeleton_vtable;
}

static GVariant *
gf_shell_gen_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_gf_shell_gen_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gf_shell_gen_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gf_shell_gen_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gf_shell_gen_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _gf_shell_gen_emit_changed (gpointer user_data);

static void
gf_shell_gen_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _gf_shell_gen_emit_changed (skeleton);
}

static void
_gf_shell_gen_on_signal_accelerator_activated (
    GfShellGen *object,
    guint arg_action,
    GVariant *arg_parameters)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(u@a{sv})",
                   arg_action,
                   arg_parameters));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.gnome.Shell", "AcceleratorActivated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gf_shell_gen_skeleton_iface_init (GfShellGenIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GfShellGenSkeleton, gf_shell_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GfShellGenSkeleton)
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SHELL_GEN, gf_shell_gen_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GfShellGenSkeleton, gf_shell_gen_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GF_TYPE_SHELL_GEN, gf_shell_gen_skeleton_iface_init))

#endif
static void
gf_shell_gen_skeleton_finalize (GObject *object)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gf_shell_gen_skeleton_parent_class)->finalize (object);
}

static void
gf_shell_gen_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_gf_shell_gen_emit_changed (gpointer user_data)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.gnome.Shell",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_gf_shell_gen_schedule_emit_changed (GfShellGenSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
gf_shell_gen_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _gf_shell_gen_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _gf_shell_gen_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
gf_shell_gen_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _gf_shell_gen_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _gf_shell_gen_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
gf_shell_gen_skeleton_init (GfShellGenSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gf_shell_gen_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GF_TYPE_SHELL_GEN_SKELETON, GfShellGenSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
}

static const gchar *
gf_shell_gen_skeleton_get_mode (GfShellGen *object)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
gf_shell_gen_skeleton_get_overview_active (GfShellGen *object)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
gf_shell_gen_skeleton_get_shell_version (GfShellGen *object)
{
  GfShellGenSkeleton *skeleton = GF_SHELL_GEN_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
gf_shell_gen_skeleton_class_init (GfShellGenSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gf_shell_gen_skeleton_finalize;
  gobject_class->get_property = gf_shell_gen_skeleton_get_property;
  gobject_class->set_property = gf_shell_gen_skeleton_set_property;
  gobject_class->notify       = gf_shell_gen_skeleton_notify;


  gf_shell_gen_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gf_shell_gen_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gf_shell_gen_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gf_shell_gen_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gf_shell_gen_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GfShellGenSkeletonPrivate));
#endif
}

static void
gf_shell_gen_skeleton_iface_init (GfShellGenIface *iface)
{
  iface->accelerator_activated = _gf_shell_gen_on_signal_accelerator_activated;
  iface->get_mode = gf_shell_gen_skeleton_get_mode;
  iface->get_overview_active = gf_shell_gen_skeleton_get_overview_active;
  iface->get_shell_version = gf_shell_gen_skeleton_get_shell_version;
}

/**
 * gf_shell_gen_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-gnome-Shell.top_of_page">org.gnome.Shell</link>.
 *
 * Returns: (transfer full) (type GfShellGenSkeleton): The skeleton object.
 */
GfShellGen *
gf_shell_gen_skeleton_new (void)
{
  return GF_SHELL_GEN (g_object_new (GF_TYPE_SHELL_GEN_SKELETON, NULL));
}

