// FontFamily.cs - customizations to Gnome.FontFamily
//
// Authors: Mike Kestner  <mkestner@ximian.com>
//
// Copyright (c) 2004 Novell, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of version 2 of the Lesser GNU General 
// Public License as published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this program; if not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

namespace Gnome {

	using System;
	using System.Runtime.InteropServices;

	public class FontFamily {

		private FontFamily () {}

		[DllImport("gnomeprint-2-2")]
		static extern IntPtr gnome_font_family_list ();

		public static string[] List ()
		{
			IntPtr list_ptr = gnome_font_family_list ();
			if (list_ptr == IntPtr.Zero)
				return new string [0];

			GLib.List list = new GLib.List (list_ptr, typeof (string));
			string[] result = new string [list.Count];
			int i = 0;
			foreach (string val in list)
				result [i++] = val;
			return result;
		}
	}
}
