#ifndef __GM_TRIGGERS_H__
#define __GM_TRIGGERS_H__

#include <glib.h>
#include <glib-object.h>
#include <regex.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_TRIGGERS				(gm_triggers_get_type())
#define GM_TRIGGERS(obj)				(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_TRIGGERS, GmTriggers))
#define GM_TRIGGERS_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_TRIGGERS, GmTriggers const))
#define GM_TRIGGERS_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_TRIGGERS, GmTriggersClass))
#define GM_IS_TRIGGERS(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_TRIGGERS))
#define GM_IS_TRIGGERS_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_TRIGGERS))
#define GM_TRIGGERS_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_TRIGGERS, GmTriggersClass))

/* Private structure type */
typedef struct _GmTriggersPrivate GmTriggersPrivate;

/*
 * Main object structure
 */
typedef struct _GmTriggers GmTriggers;
 
struct _GmTriggers {
	GObject object;
	
	/*< private > */
	GmTriggersPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmTriggersClass 	GmTriggersClass;

struct _GmTriggersClass {
	GObjectClass parent_class;

	/* Signals */
};

typedef enum _GmTriggerType {
	TT_OUTPUT = 0,
	TT_USERS
} GmTriggerType;

typedef enum _GmTriggerConditionType {
	TCT_CONTAINS = 0,
	TCT_NOT_CONTAINS,
	TCT_BEGINS,
	TCT_NOT_BEGINS,
	TCT_ENDS,
	TCT_NOT_ENDS,
	TCT_MATCHES,
	TCT_NOT_MATCHES,
	TCT_USER_ONLINE,
	TCT_USER_OFFLINE,
	TCT_USER_IDLE,
	TCT_USER_IDLE_OFF,
	TCT_USER_AWAY,
	TCT_USER_AWAY_OFF
} GmTriggerConditionType;

typedef enum _GmTriggerActionType {
	TAT_HIGHLIGHT_LINE = 0,
	TAT_HIGHLIGHT_MATCH,
	TAT_BEEP,
	TAT_PLAY_SOUND,
	TAT_NOTIFY,
	TAT_RUN_SCRIPT,
	TAT_RUN
} GmTriggerActionType;

typedef struct _GmTriggerData {
	guint type;
	gchar *data;
	regex_t expr;
} GmTriggerData;

typedef struct _GmTrigger {
	gchar *name;
	GmTriggerType event;

	GList *conditions;
	GList *actions;
} GmTrigger;

GType gm_triggers_get_type(void) G_GNUC_CONST;
GmTriggers *gm_triggers_new(void);
GmTriggers *gm_triggers_new_from_file(gchar *filename);
void gm_triggers_save(GmTriggers *triggers);
void gm_triggers_save_as(GmTriggers *trg, const gchar *path);
void gm_triggers_set_path(GmTriggers *trg, gchar *path);
GmTriggers *gm_triggers_dup(GmTriggers *source);
const GList *gm_triggers_list(GmTriggers *trg);
void gm_triggers_add(GmTriggers *trg, GmTrigger *t);
void gm_triggers_clear(GmTriggers *trg);

GmTrigger *gm_trigger_new();
void gm_trigger_free(GmTrigger *trigger);
GmTrigger *gm_trigger_dup(GmTrigger *source);
void gm_trigger_set_name(GmTrigger *trigger, const gchar *name);
void gm_trigger_free_list(GList *list);
void gm_trigger_add_condition(GmTrigger *trigger, GmTriggerData *condition);
void gm_trigger_add_action(GmTrigger *trigger, GmTriggerData *action);
void gm_trigger_set_conditions(GmTrigger *trigger, GList *conditions);
void gm_trigger_set_actions(GmTrigger *trigger, GList *actions);

gint gm_trigger_match_user(GmTrigger *trigger, gchar const *username, 
		GmTriggerConditionType condition, regmatch_t *matches, gint nmatch);
gint gm_trigger_match(GmTrigger *trigger, gchar *text, regmatch_t *matches,
		gint nmatch);

GmTriggerData *gm_trigger_data_new(gint type, gchar *data);
void gm_trigger_data_free(GmTriggerData *tdata);

G_END_DECLS
#endif /* __GM_TRIGGERS_H__ */
