-------------------------------------------------------------------------------
--									     --
--  Filename        : $Source: /cvsroot/gnade/gnade/tools/util.adb,v $
--  Description     : Export the contents of a data base                     --
--  Author          : Michael Erdmann                                        --
--  Created         : 5.4.2003                                               --
--  Last Modified By: $Author: persan $				     --
--  Last Modified On: $Date: 2007/08/25 12:43:35 $			     --
--  Status          : $State: Exp $					     --
--									     --
--  Copyright (C) 2000 - 2003 Michael Erdmann                                --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  Export the contents of a table into a simple file format. This file      --
--  format i intended for importing or processing by other gnade tools       --
--                                                                           --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Text_IO;           use Ada.Text_IO;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;

package body Util is
   Version        : constant String := "$Id: util.adb,v 1.2 2007/08/25 12:43:35 persan Exp $";
   pragma Unreferenced (Version);
   ------------
   -- Report --
   ------------
   procedure Report (
      T : in String) is
   begin
      if not Quiet then
         Put_Line (T);
      end if;
   end Report;

   -----------
   -- Error --
   -----------
   procedure Error (
      T : in String) is
   begin
      Put_Line (T);
   end Error;

   ---------------------
   -- Report_DB_Error --
   ---------------------
   procedure Report_DB_Error (
      DB      : in out ODBC.Object) is
      -- report the odbc error information
      Err     : Unbounded_String;
      Message : Unbounded_String;
   begin
      Get_Error (DB, Err, Message);
      Error (To_String (Err) & ":" & To_String (Message));
   end Report_DB_Error;

   ------------
   -- Bucket --
   ------------
   package body Bucket is
      type Element_Type;
      type Element_Type_Access is access Element_Type;

      type Element_Type is record
         Next : Element_Type_Access := null;
         Item : Bucket_Type;
      end record;

      Head : Element_Type_Access := null;
      Tail : Element_Type_Access := null;
      Next : Element_Type_Access := null;

      ---------
      -- Add --
      ---------
      procedure Add (
         Item : in Bucket_Type) is
      -- Add an element to the bucket.
         E    : constant Element_Type_Access := new Element_Type;
      begin
         E.Item := Item;

         if Head /= null then
            Tail.Next := E;
         else
            Head := E;
         end if;

         Tail := E;
      end Add;

      ---------
      -- Get --
      ---------
      function Get (
         First : in Boolean := False) return Bucket_Type is
      -- Retrive an element from the bucket
         R     : Bucket_Type;
      begin
         if First then
            Next := Head;
         end if;

         R := Next.Item;
         Next := Next.Next;
         return R;
      end Get;

      -------------------
      -- End_Of_Bucket --
      -------------------
      function End_Of_Bucket return Boolean is
      begin
         return Next = null;
      end End_Of_Bucket;

      -------------
      -- Destroy --
      -------------
      procedure Destroy is
         E : Element_Type_Access := Head;
      begin
         while E /= null loop
            E := E.Next;
         end loop;
      end Destroy;

   end Bucket;


end Util;

