------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-string_bounded.adb,v 1.16 2008/07/03 06:22:48 vagul Exp $

with OCI.Thread;

package body OCI.Thick.String_Bounded is

   procedure Bind
     (Stmt  : in     Statement;
      Value : in out Variable;
      Name  : in     String) is
   begin
      Check_Error (OCIBindByName
        (Stmtp       => OCIStmt (Handle (Stmt)),
         Bindpp      => Value.Bind'Access,
         Errhp       => Thread.Error,
         Placeholder => C.To_C (Name),
         Placeh_Len  => Name'Length,
         Valuep      => Value.Value'Address,
         Value_Sz    => Value.Value'Length,
         Dty         => SQLT_STR,
         Indp        => Value.Indicator'Unchecked_Access));
   end Bind;

   procedure Bind
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive) is
   begin
      Check_Error (OCIBindByPos
        (Stmtp    => OCIStmt (Handle (Stmt)),
         Bindpp   => Value.Bind'Access,
         Errhp    => Thread.Error,
         Position => Ub4 (Position),
         Valuep   => Value.Value'Address,
         Value_Sz => Value.Value'Length,
         Dty      => SQLT_STR,
         Indp     => Value.Indicator'Unchecked_Access));
   end Bind;

   procedure Define
     (Stmt     : in     Statement;
      Value    : in out Variable;
      Position : in     Positive) is
   begin
      Check_Error (OCIDefineByPos
        (Stmtp    => OCIStmt (Handle (Stmt)),
         Defnpp   => Value.Define'Access,
         Errhp    => Thread.Error,
         Position => Ub4 (Position),
         Value    => Value.Value'Address,
         Value_Sz => Value.Value'Length,
         Dty      => SQLT_STR,
         Indp     => Value.Indicator'Unchecked_Access));
   end Define;

   ---------------
   -- Get_Value --
   ---------------

   function Get_Value (Var : Variable) return String is
   begin
      if Is_Null (Var) then
         raise Null_Value;
      else
         return C.To_Ada (Var.Value);
      end if;
   end Get_Value;

   function Get_Value
     (Var     : in Variable;
      Default : in String;
      Mode    : in Default_Mode := Instead_Any)
      return  String is
   begin
      if not Is_Attached (Var) then
         if Mode = Instead_Not_Attached or Mode = Instead_Any then
            return Default;
         else
            raise Not_Attached;
         end if;

      elsif Is_Null (Var) then
         if Mode = Instead_Null or Mode = Instead_Any then
            return Default;
         else
            raise Null_Value;
         end if;

      else
         return C.To_Ada (Var.Value);
      end if;
   end Get_Value;

   ---------------
   -- Set_Value --
   ---------------

   procedure Set_Value (Var : in out Variable; Value : String) is
      Len : String_Size;
      use type String_Size;
   begin
      if Value'Length > Var.Length then
         raise Constraint_Error;
      end if;

      Var.Indicator := 0;

      C.To_C
        (Item       => Value,
         Target     => Var.Value,
         Count      => Len,
         Append_Nul => True);
   end Set_Value;

end OCI.Thick.String_Bounded;
