-------------------------------------------------------------------------------
--                            2                                               --
--  Filename        : $Source: /cvsroot/gnade/gnade/contrib/gsql/gui_addrow.ads,v $
--  Description     : Dialog to define a row in a relation
--  Author          : Michael Erdmann                                        --
--  Created         : 7.10.2001                                              --
--  Last Modified By: $Author: me $
--  Last Modified On: $Date: 2001/11/27 20:39:29 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  Author: Michael Erdmann <michael.erdmann@snafu.de>                       --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
-------------------------------------------------------------------------------
with Ada.Strings.Unbounded;               use Ada.Strings.Unbounded;

with Gtk.Box;                             use Gtk.Box;
with Gtk.Gentry;                          use Gtk.Gentry;
with Gtk.Combo;                           use Gtk.Combo;

with GUI_Rowdefinition;                   use GUI_Rowdefinition;
with GUI_Dialog;                          use GUI_Dialog;
with GUI_Worksheet;                       use GUI_Worksheet;
with GUI_Checkbutton;                     use GUI_Checkbutton;

package GUI_AddRow is

   type Object is new GUI_Dialog.Object with private;

   procedure Initialize(
      This  : in out Object;
      Row   : in Row_Information_Record;
      Sheet : in GUI_Worksheet.Object'Class ) ;

   procedure Finalize(
      This  : in out Object );

private
   type Choice_Result_Type ;
   type Choice_Result is access Choice_Result_Type;

   type Object is new GUI_Dialog.Object with record
         Name           : Gtk_Entry;
         Sql_Type       : Gtk_Combo;
         Sql_Default    : Gtk_Entry;
         Sql_Constraint : Gtk_Entry;
         Sql_Check      : Gtk_Entry;
         Sql_Primary    : GUI_Checkbutton.Handle;
         Sql_Unique     : GUI_Checkbutton.Handle;
         Row            : Row_Information_Record;
         Comment        : Gtk_Entry;
         Sheet          : GUI_Worksheet.Handle := null;
         SQL_Null       : Choice_Result := null;
      end record;

   procedure Dialog_Contents(
      This : in out Object;
      Vbox : in Gtk_Box );

   procedure Command(
      This : in out Object;
      Cmd  : in Natural);

end GUI_AddRow;
